/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Tool;
import com.sun.electric.util.math.Orientation;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class IdReader {
    public final IdManager idManager;
    private final DataInputStream in;
    private final ArrayList<Variable.Key> varKeys = new ArrayList();
    private final ArrayList<TextDescriptor> textDescriptors = new ArrayList();
    private final ArrayList<Tool> tools = new ArrayList();
    private final ArrayList<Orientation> orients = new ArrayList();

    public IdReader(DataInputStream in, IdManager idManager) {
        if (in == null || idManager == null) {
            throw new NullPointerException();
        }
        this.in = in;
        this.idManager = idManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDiffs() throws IOException {
        int i;
        int techIndex;
        IdManager idManager = this.idManager;
        synchronized (idManager) {
            int oldTechIdsCount = this.idManager.techIds.size();
            int oldLibIdsCount = this.idManager.libIds.size();
            int oldCellIdsCount = this.idManager.cellIds.size();
        }
        int techIdsCount = this.readInt();
        for (int techIndex2 = oldTechIdsCount; techIndex2 < techIdsCount; ++techIndex2) {
            this.idManager.newTechIdInternal(this.readString());
        }
        int libIdsCount = this.readInt();
        for (int libIndex = oldLibIdsCount; libIndex < libIdsCount; ++libIndex) {
            this.idManager.newLibIdInternal(this.readString());
        }
        int cellIdsCount = this.readInt();
        for (int cellIndex = oldCellIdsCount; cellIndex < cellIdsCount; ++cellIndex) {
            LibId libId = this.readLibId();
            this.idManager.newCellIdInternal(libId, CellName.parseName(this.readString()));
        }
        IdManager cellIndex = this.idManager;
        synchronized (cellIndex) {
            assert (techIdsCount == this.idManager.techIds.size());
            assert (libIdsCount == this.idManager.libIds.size());
            assert (cellIdsCount == this.idManager.cellIds.size());
        }
        while ((techIndex = this.readInt()) != -1) {
            int primIndex;
            TechId techId = this.idManager.getTechId(techIndex);
            int numNewLayerIds = this.readInt();
            for (i = 0; i < numNewLayerIds; ++i) {
                String layerName = this.readString();
                techId.newLayerIdInternal(layerName);
            }
            int numNewArcProtoIds = this.readInt();
            for (int i2 = 0; i2 < numNewArcProtoIds; ++i2) {
                String arcProtoName = this.readString();
                techId.newArcProtoIdInternal(arcProtoName);
            }
            int numNewPrimitiveNodeIds = this.readInt();
            for (int i3 = 0; i3 < numNewPrimitiveNodeIds; ++i3) {
                String primitiveNodeName = this.readString();
                techId.newPrimitiveNodeIdInternal(primitiveNodeName);
            }
            while ((primIndex = this.readInt()) != -1) {
                PrimitiveNodeId primitiveNodeId = techId.getPrimitiveNodeId(primIndex);
                int numNewPrimitivePortIds = this.readInt();
                for (int i4 = 0; i4 < numNewPrimitivePortIds; ++i4) {
                    String primitivePortName = this.readString();
                    primitiveNodeId.newPrimitivePortIdInternal(primitivePortName);
                }
            }
        }
        while ((cellIndex = this.readInt()) != -1) {
            CellId cellId = this.idManager.getCellId(cellIndex);
            int numNewExportIds = this.readInt();
            for (i = 0; i < numNewExportIds; ++i) {
                String exportIdString = this.readString();
                cellId.newPortId(exportIdString);
            }
        }
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public byte[] readBytes() throws IOException {
        int length = this.in.readInt();
        byte[] bytes = new byte[length];
        this.in.readFully(bytes);
        return bytes;
    }

    public String readString() throws IOException {
        return this.in.readUTF();
    }

    public Variable.Key readVariableKey() throws IOException {
        int i = this.in.readInt();
        if (i == this.varKeys.size()) {
            String s = this.in.readUTF();
            Variable.Key varKey = Variable.newKey(s);
            this.varKeys.add(varKey);
        }
        return this.varKeys.get(i);
    }

    public TextDescriptor readTextDescriptor() throws IOException {
        int i = this.in.readInt();
        if (i == -1) {
            return null;
        }
        if (i == this.textDescriptors.size()) {
            long bits = this.in.readLong();
            int colorIndex = this.in.readInt();
            boolean isDisplay = this.in.readBoolean();
            String fontName = this.in.readUTF();
            MutableTextDescriptor mtd = new MutableTextDescriptor(bits, colorIndex, isDisplay);
            int face = 0;
            if (fontName.length() != 0) {
                AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontName);
                face = af.getIndex();
            }
            mtd.setFace(face);
            TextDescriptor td = TextDescriptor.newTextDescriptor(mtd);
            this.textDescriptors.add(td);
        }
        return this.textDescriptors.get(i);
    }

    public Tool readTool() throws IOException {
        int i = this.in.readInt();
        if (i == this.tools.size()) {
            String toolName = this.in.readUTF();
            Tool tool = Tool.findTool(toolName);
            this.tools.add(tool);
        }
        return this.tools.get(i);
    }

    public TechId readTechId() throws IOException {
        int techIndex = this.in.readInt();
        return this.idManager.getTechId(techIndex);
    }

    public ArcProtoId readArcProtoId() throws IOException {
        TechId techId = this.readTechId();
        int chronIndex = this.readInt();
        return techId.getArcProtoId(chronIndex);
    }

    public LibId readLibId() throws IOException {
        int libIndex = this.in.readInt();
        return this.idManager.getLibId(libIndex);
    }

    public NodeProtoId readNodeProtoId() throws IOException {
        int i = this.in.readInt();
        if (i >= 0) {
            return this.idManager.getCellId(i);
        }
        int chronIndex = ~i;
        TechId techId = this.readTechId();
        return techId.getPrimitiveNodeId(chronIndex);
    }

    public PortProtoId readPortProtoId() throws IOException {
        NodeProtoId nodeProtoId = this.readNodeProtoId();
        int chronIndex = this.in.readInt();
        return nodeProtoId.getPortId(chronIndex);
    }

    public int readNodeId() throws IOException {
        return this.in.readInt();
    }

    public int readArcId() throws IOException {
        return this.in.readInt();
    }

    public Name readNameKey() throws IOException {
        String name = this.in.readUTF();
        return Name.findName(name);
    }

    public Orientation readOrientation() throws IOException {
        int i = this.in.readInt();
        if (i == this.orients.size()) {
            short angle = this.in.readShort();
            boolean isXMirrored = this.in.readBoolean();
            boolean isYMirrored = this.in.readBoolean();
            Orientation orient = Orientation.fromJava(angle, isXMirrored, isYMirrored);
            this.orients.add(orient);
        }
        return this.orients.get(i);
    }

    public long readCoord() throws IOException {
        return this.in.readLong();
    }

    public EPoint readPoint() throws IOException {
        long x = this.readCoord();
        long y = this.readCoord();
        return EPoint.fromGrid(x, y);
    }

    public ERectangle readRectangle() throws IOException {
        long x = this.readCoord();
        long y = this.readCoord();
        long w = this.readCoord();
        long h = this.readCoord();
        return ERectangle.fromGrid(x, y, w, h);
    }
}

