/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.bookshelf;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.BookshelfInputParser;
import com.sun.electric.tool.io.input.bookshelf.BookshelfNets;
import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class BookshelfNodes
implements BookshelfInputParser<Void> {
    private String nodesFile;

    public BookshelfNodes(String nodesFile) {
        this.nodesFile = nodesFile;
    }

    @Override
    public Void parse() throws IOException {
        String line;
        BufferedReader rin;
        Job.getUserInterface().setProgressNote("Parse Nodes File");
        try {
            File file = new File(this.nodesFile);
            FileReader freader = new FileReader(file);
            rin = new BufferedReader(freader);
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: Cannot find Bookshelf Nodes file: " + this.nodesFile);
            return null;
        }
        while ((line = rin.readLine()) != null) {
            if (!line.startsWith("   ")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int i = 0;
            String name = "";
            double height = 0.0;
            double width = 0.0;
            boolean isTerminal = false;
            while (tokenizer.hasMoreTokens()) {
                if (i == 0) {
                    name = tokenizer.nextToken();
                } else if (i == 1) {
                    width = TextUtils.atof(tokenizer.nextToken());
                } else if (i == 2) {
                    height = TextUtils.atof(tokenizer.nextToken());
                } else if (i == 3) {
                    if (tokenizer.nextToken().toLowerCase().equals("terminal")) {
                        isTerminal = true;
                    }
                } else {
                    tokenizer.nextToken();
                }
                ++i;
            }
            new BookshelfNode(name, width, height, isTerminal);
        }
        rin.close();
        return null;
    }

    public static class BookshelfNode {
        private String name;
        private double width;
        private double height;
        private double x;
        private double y;
        private boolean terminal;
        private List<BookshelfPin> pins;
        private Cell prototype;
        private NodeInst instance;
        private static Map<String, BookshelfNode> nodeMap = new LinkedHashMap<String, BookshelfNode>();
        private int weight;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getWidth() {
            return this.width;
        }

        public void setWidth(double width) {
            this.width = width;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Cell getPrototype() {
            return this.prototype;
        }

        public void setInstance(NodeInst instance) {
            this.instance = instance;
        }

        public NodeInst getInstance() {
            return this.instance;
        }

        public void setPrototype(Cell prototype) {
            this.prototype = prototype;
        }

        public BookshelfNode(String name, double width, double height, boolean terminal) {
            this.name = name;
            this.width = width;
            this.height = height;
            this.y = 0.0;
            this.x = 0.0;
            this.setTerminal(terminal);
            this.pins = CollectionFactory.createArrayList();
            nodeMap.put(name, this);
        }

        public static BookshelfNode findNode(String name) {
            return nodeMap.get(name);
        }

        public static Collection<BookshelfNode> getAllNodes() {
            return nodeMap.values();
        }

        public void setPins(List<BookshelfPin> pins) {
            this.pins = pins;
        }

        public List<BookshelfPin> getPins() {
            return this.pins;
        }

        public void setTerminal(boolean terminal) {
            this.terminal = terminal;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name + " ");
            builder.append(String.valueOf(this.width) + " ");
            builder.append(String.valueOf(this.height));
            if (this.terminal) {
                builder.append(" terminal");
            }
            return builder.toString();
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public static class BookshelfPin {
        private Point2D location;
        private BookshelfNets.BookshelfNet net;
        private String nodeName;

        public BookshelfPin(Point2D location, BookshelfNets.BookshelfNet net, String nodeName) {
            this.location = location;
            this.setNet(net);
            this.nodeName = nodeName;
        }

        public void setLocation(Point2D location) {
            this.location = location;
        }

        public Point2D getLocation() {
            return this.location;
        }

        public void setNet(BookshelfNets.BookshelfNet net) {
            this.net = net;
        }

        public BookshelfNets.BookshelfNet getNet() {
            return this.net;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

