/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Design;
import com.sun.electric.tool.simulation.acl2.mods.ElabMod;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.ModDb;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.modsext.Compile;
import com.sun.electric.tool.simulation.acl2.modsext.DesignExt;
import com.sun.electric.tool.simulation.acl2.modsext.DesignHints;
import com.sun.electric.tool.simulation.acl2.modsext.DriverExt;
import com.sun.electric.tool.simulation.acl2.modsext.GenFsm;
import com.sun.electric.tool.simulation.acl2.modsext.GenFsmNew;
import com.sun.electric.tool.simulation.acl2.modsext.ModExport;
import com.sun.electric.tool.simulation.acl2.modsext.ModInstExt;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.ParameterizedModule;
import com.sun.electric.tool.simulation.acl2.modsext.PathExt;
import com.sun.electric.tool.simulation.acl2.modsext.TutorialHints;
import com.sun.electric.tool.simulation.acl2.modsext.WireExt;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Reader;
import com.sun.electric.util.acl2.ACL2Writer;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ACL2DesignJobs {
    private static final int VERBOSE_DUMP = 1;

    public static <H extends DesignHints> void dump(Class<H> cls, File saoFile, String outFileName) {
        new DumpDesignJob<H>(cls, saoFile, outFileName).startJob();
    }

    public static void genAlu(File saoFile, String outFileName) {
        new GenFsmJob<Alu>(Alu.class, saoFile, outFileName).startJob();
    }

    public static void showTutorialSvexLibs(File saoFile) {
        new ShowSvexLibsJob<TutorialHints>(TutorialHints.class, saoFile).startJob();
    }

    public static <H extends DesignHints> void compareSvexLibs(Class<H> cls, File[] saoFiles) {
        new CompareSvexLibsJob<H>(cls, saoFiles).startJob();
    }

    public static void dedup(File saoFile, String designName, String outFileName) {
        new DedupSvexJob(saoFile, designName, outFileName).startJob();
    }

    public static void showAssigns(File saoFile, String designName, String outFileName) {
        new ShowAssignsJob(saoFile, designName, outFileName).startJob();
    }

    public static void namedToIndexed(File saoFile, String designName) {
        new NamedToIndexedJob(saoFile, designName).startJob();
    }

    public static void normalizeAssigns(File saoFile, String designName, boolean isIndexed) {
        new NormalizeAssignsJob(saoFile, designName, isIndexed).startJob();
    }

    private static class DumpDesignJob<H extends DesignHints>
    extends Job {
        private final Class<H> cls;
        private final File saoFile;
        private final String outFileName;

        private DumpDesignJob(Class<H> cls, File saoFile, String outFileName) {
            super("Dump SV Design", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFile = saoFile;
            this.outFileName = outFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger(this.saoFile.getName());
                DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                DesignExt design = new DesignExt(sr.root, designHints);
                GenFsmNew gen = new GenFsmNew(designHints);
                gen.scanDesign(design.b);
                String clockName = designHints.getGlobalClock();
                design.computeCombinationalInputs(clockName);
                try (PrintStream out = new PrintStream(this.outFileName);){
                    for (Map.Entry<ParameterizedModule, Map<String, ModName>> e : gen.parModuleInstances.entrySet()) {
                        ParameterizedModule parMod = e.getKey();
                        Map<String, ModName> specializations = e.getValue();
                        this.dumpModules(out, design, parMod, specializations.values());
                    }
                    for (ModName modName : design.downTop.keySet()) {
                        if (gen.modToParMod.containsKey(modName)) continue;
                        this.dumpModules(out, design, null, Collections.singleton(modName));
                    }
                    ElabMod topMod = design.moddb.topMod();
                    out.println("// design.top=" + design.getTop());
                    out.println(topMod.modTotalWires() + " wires " + topMod.modTotalBits() + " bits");
                    if (clockName != null) {
                        out.println("// clock=" + clockName);
                    }
                }
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }

        private void dumpModules(PrintStream out, DesignExt design, ParameterizedModule parMod, Collection<ModName> modNames) {
            for (ModName modName : modNames) {
                PathExt.Bit pb;
                int bit;
                List<Map<Svar<PathExt>, BigInteger>> closureDeps1;
                List<Map<Svar<PathExt>, BigInteger>> closureDeps0;
                List<Map<Svar<PathExt>, BigInteger>> fineDeps1;
                List<Map<Svar<PathExt>, BigInteger>> fineDeps0;
                BitSet fineStateTransDeps1;
                BitSet fineStateTransDeps0;
                BitSet fineStateLocDeps1;
                BitSet fineStateLocDeps0;
                ModuleExt m = design.downTop.get(modName);
                Map<Object, Set<Object>> crudeGraph0 = m.computeDepsGraph(false);
                Map<Object, Set<Object>> crudeGraph1 = m.computeDepsGraph(true);
                Map<Object, Set<Object>> crudeClosure0 = m.closure(crudeGraph0);
                Map<Object, Set<Object>> crudeClosure1 = m.closure(crudeGraph1);
                Map<Object, Set<Object>> fineGraph0 = m.computeFineDepsGraph(false);
                Map<Object, Set<Object>> fineGraph1 = m.computeFineDepsGraph(true);
                Map<Object, Set<Object>> fineClosure0 = m.closure(fineGraph0);
                Map<Object, Set<Object>> fineClosure1 = m.closure(fineGraph1);
                out.println("module " + modName + " // has " + m.wires.size() + " wires " + m.insts.size() + " insts " + m.assigns.size() + " assigns " + m.aliaspairs.size() + " aliaspairs " + m.useCount + " useCount");
                out.println(" wires");
                if (m.stateWires.isEmpty()) {
                    assert (m.stateVars0.isEmpty());
                    assert (m.stateVars1.isEmpty());
                } else {
                    out.println("  // state wires: " + m.stateWires);
                    out.println("  // state " + ModuleExt.showFineDeps(false, m.stateVars0, false, m.stateVars1));
                }
                for (WireExt wireExt : m.wires) {
                    ModExport export;
                    if (wireExt.isAssigned()) {
                        out.print(wireExt.used ? "  out    " : "  output ");
                        if (wireExt.isAssigned() && !BigIntegerUtil.logheadMask(wireExt.getWidth()).equals(wireExt.getAssignedBits())) {
                            out.print("#x" + wireExt.getAssignedBits().toString(16));
                        }
                    } else {
                        Util.check(wireExt.getAssignedBits().signum() == 0);
                        out.print(wireExt.used ? "  input  " : "  unused ");
                    }
                    out.print((export = wireExt.getExport()) == null ? "  " : (export.isGlobal() ? "! " : "* "));
                    out.print(wireExt + " //");
                    for (Map.Entry<Lhrange<PathExt>, WireExt.WireDriver> e1 : wireExt.drivers.entrySet()) {
                        Lhrange<PathExt> lhr = e1.getKey();
                        WireExt.WireDriver wd = e1.getValue();
                        out.print(" " + lhr + "<=");
                        if (wd.driver != null) {
                            out.print(wd.driver.name);
                            if (lhr.getWidth() != wd.driver.getWidth() || wd.lsh != 0) {
                                out.print("[" + (wd.lsh + lhr.getWidth() - 1) + ":" + wd.lsh + "]");
                            }
                        }
                        if (wd.pi != null) {
                            out.print(wd.pi.toString(BigIntegerUtil.logheadMask(lhr.getWidth()).shiftLeft(wd.lsh)));
                        }
                        if (wd.inp == null) continue;
                        out.print(wd.inp.toString(BigIntegerUtil.logheadMask(lhr.getWidth()).shiftLeft(wd.lsh)));
                    }
                    out.println();
                    if (wireExt.isInput()) continue;
                    if (wireExt.isOutput()) {
                        String fineStr = wireExt.showFinePortDeps(fineClosure0, fineClosure1);
                        String crudeStr = m.showCrudePortDeps(wireExt, crudeClosure0, crudeClosure1);
                        out.println("   // fine  export depends* " + (String)fineStr);
                        if (!fineStr.equals(crudeStr)) {
                            out.println("   // crude export depends* " + crudeStr);
                        }
                    }
                    out.println("    // fine  depends  on " + wireExt.showFinePortDeps(fineGraph0, fineGraph1));
                    out.println("    // fine  depends* on " + wireExt.showFinePortDeps(fineClosure0, fineClosure1));
                    out.println("    // crude depends  on " + m.showCrudePortDeps(wireExt, crudeGraph0, crudeGraph1));
                    out.println("    // crude depends* on " + m.showCrudePortDeps(wireExt, crudeClosure0, crudeClosure1));
                }
                out.println("// insts");
                for (ModInstExt modInstExt : m.insts) {
                    out.println("  " + modInstExt.getModname() + " " + modInstExt.getInstname() + " (");
                    boolean hasExports = false;
                    for (PathExt.PortInst piIn : modInstExt.portInsts) {
                        if (!piIn.isInput()) continue;
                        if (hasExports) {
                            out.print("   ,");
                        } else {
                            out.print("    ");
                            hasExports = true;
                        }
                        out.println("." + piIn.getProtoName() + "(" + piIn.driver + ")");
                        out.println("    // fine  depends  on " + piIn.showFinePortDeps(fineGraph0, fineGraph1));
                        out.println("    // fine  depends* on " + piIn.showFinePortDeps(fineClosure0, fineClosure1));
                    }
                    out.println("   //");
                    for (PathExt.PortInst piOut : modInstExt.portInsts) {
                        if (!piOut.isOutput()) continue;
                        if (hasExports) {
                            out.print("   ,");
                        } else {
                            out.print("    ");
                            hasExports = true;
                        }
                        out.println("." + piOut.getProtoName() + "(" + piOut.source + ")");
                        if (piOut.splitIt) {
                            out.println("    // SPLIT");
                        }
                        out.println("    // fine  depends  on " + piOut.showFinePortDeps(fineGraph0, fineGraph1));
                        out.println("    // fine  depends* on " + piOut.showFinePortDeps(fineClosure0, fineClosure1));
                        if (!piOut.splitIt) {
                            out.println("    // crude depends  on " + m.showCrudePortDeps(piOut, crudeGraph0, crudeGraph1));
                            out.println("    // crude depends* on " + m.showCrudePortDeps(piOut, crudeClosure0, crudeClosure1));
                        }
                        if (!piOut.splitIt) continue;
                        fineStateLocDeps0 = new BitSet();
                        fineStateLocDeps1 = new BitSet();
                        fineStateTransDeps0 = new BitSet();
                        fineStateTransDeps1 = new BitSet();
                        fineDeps0 = piOut.gatherFineBitDeps(fineStateLocDeps0, fineGraph0);
                        fineDeps1 = piOut.gatherFineBitDeps(fineStateLocDeps1, fineGraph1);
                        closureDeps0 = piOut.gatherFineBitDeps(fineStateTransDeps0, fineClosure0);
                        closureDeps1 = piOut.gatherFineBitDeps(fineStateTransDeps1, fineClosure1);
                        for (bit = 0; bit < piOut.getWidth(); ++bit) {
                            pb = piOut.getBit(bit);
                            out.println("    // fine  " + pb + " depends  on " + ModuleExt.showFineDeps(fineStateLocDeps0, fineDeps0, fineStateLocDeps1, fineDeps1, bit));
                            if (!piOut.splitIt) continue;
                            out.println("    // crude " + pb + " depends  on " + m.showCrudePortDeps(pb, crudeGraph0, crudeGraph1));
                        }
                        for (bit = 0; bit < piOut.getWidth(); ++bit) {
                            pb = piOut.getBit(bit);
                            out.println("    // fine  " + pb + " depends* on " + ModuleExt.showFineDeps(fineStateLocDeps0, closureDeps0, fineStateLocDeps1, closureDeps1, bit));
                            if (!piOut.splitIt) continue;
                            out.println("    // crude " + pb + " depends* on " + m.showCrudePortDeps(pb, crudeClosure0, crudeClosure1));
                        }
                    }
                    out.println("  );");
                }
                out.println(" assigns");
                for (Map.Entry entry : m.assigns.entrySet()) {
                    Lhs l = (Lhs)entry.getKey();
                    DriverExt d = (DriverExt)entry.getValue();
                    assert (!l.ranges.isEmpty());
                    for (int i = 0; i < l.ranges.size(); ++i) {
                        Lhrange lr = l.ranges.get(i);
                        Svar svar = lr.getVar();
                        assert (svar.getDelay() == 0);
                        assert (!svar.isNonblocking());
                        out.print((i == 0 ? "  " : ",") + lr);
                    }
                    out.print(" = " + d.getOrigSvex());
                    BigInteger complexity = d.getOrigSvex().traverse(new Svex.TraverseVisitor<PathExt, BigInteger>(){

                        @Override
                        public BigInteger visitQuote(Vec4 val) {
                            return BigInteger.ZERO;
                        }

                        @Override
                        public BigInteger visitVar(Svar<PathExt> svar) {
                            return BigInteger.ZERO;
                        }

                        public BigInteger visitCall(SvexFunction fun, Svex<PathExt>[] args, BigInteger[] argVals) {
                            BigInteger result = BigInteger.ONE;
                            for (BigInteger argVal : argVals) {
                                result = result.add(argVal);
                            }
                            return result;
                        }

                        public BigInteger[] newVals(int arity) {
                            return new BigInteger[arity];
                        }
                    });
                    out.println(" // " + (complexity.bitLength() > 11 ? "COMPLEX " : "") + complexity + " " + d.toString());
                    if (d.splitIt) {
                        out.println(" // SPLIT");
                    }
                    out.println("    // fine  depends  on " + d.showFinePortDeps(fineGraph0, fineGraph1));
                    out.println("    // fine  depends* on " + d.showFinePortDeps(fineClosure0, fineClosure1));
                    if (!d.splitIt) {
                        out.println("    // crude depends  on " + m.showCrudePortDeps(d, crudeGraph0, crudeGraph1));
                        out.println("    // crude depends* on " + m.showCrudePortDeps(d, crudeClosure0, crudeClosure1));
                    }
                    if (d.splitIt) {
                        fineStateLocDeps0 = new BitSet();
                        fineStateLocDeps1 = new BitSet();
                        fineStateTransDeps0 = new BitSet();
                        fineStateTransDeps1 = new BitSet();
                        fineDeps0 = d.gatherFineBitDeps(fineStateLocDeps0, fineGraph0);
                        fineDeps1 = d.gatherFineBitDeps(fineStateLocDeps1, fineGraph1);
                        closureDeps0 = d.gatherFineBitDeps(fineStateTransDeps0, fineClosure0);
                        closureDeps1 = d.gatherFineBitDeps(fineStateTransDeps1, fineClosure1);
                        for (bit = 0; bit < l.width(); ++bit) {
                            pb = d.getBit(bit);
                            out.println("    // fine  " + pb + " depends on " + ModuleExt.showFineDeps(fineStateLocDeps0, fineDeps0, fineStateLocDeps1, fineDeps1, bit));
                            if (!d.splitIt) continue;
                            out.println("    // crude " + pb + " depends  on " + m.showCrudePortDeps(pb, crudeGraph0, crudeGraph1));
                        }
                        for (bit = 0; bit < l.width(); ++bit) {
                            pb = d.getBit(bit);
                            out.println("    // fine  " + pb + " depends* on " + ModuleExt.showFineDeps(fineStateTransDeps0, closureDeps0, fineStateTransDeps1, closureDeps1, bit));
                            if (!d.splitIt) continue;
                            out.println("    // crude " + pb + " depends* on " + m.showCrudePortDeps(pb, crudeClosure0, crudeClosure1));
                        }
                    }
                    GenFsmNew.printSvex(out, 2, d.getNormSvex());
                    if (d.getNormVars().equals(d.getOrigVars())) continue;
                    out.println("**** DIFFERENT NORM VARS ****");
                    out.println("orig: " + d.getOrigVars());
                    out.println("norm: " + d.getNormVars());
                }
                for (Map.Entry entry : m.aliaspairs.entrySet()) {
                    Lhs l = (Lhs)entry.getKey();
                    Lhs r = (Lhs)entry.getValue();
                    assert (l.ranges.size() == 1);
                    Lhrange lr = l.ranges.get(0);
                    assert (lr.getRsh() == 0);
                    Svar svar = lr.getVar();
                    assert (svar.getDelay() == 0);
                    assert (!svar.isNonblocking());
                    if (svar.getName() instanceof PathExt.PortInst) continue;
                    out.print("  // alias " + lr + " <->");
                    for (Lhrange lr1 : r.ranges) {
                        svar = lr1.getVar();
                        assert (svar.getDelay() == 0);
                        assert (!svar.isNonblocking());
                        out.print(" " + lr1);
                    }
                    out.println();
                }
                out.println("endmodule // " + modName);
                out.println();
            }
        }
    }

    public static class GenFsmJob<T extends GenFsm>
    extends Job {
        private final Class<T> cls;
        private final File saoFile;
        private final String outFileName;

        public GenFsmJob(Class<T> cls, File saoFile, String outFileName) {
            super("Gen Fsm in ACL2", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFile = saoFile;
            this.outFileName = outFileName;
        }

        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger(this.outFileName);
                GenFsm gen = (GenFsm)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                gen.gen(this.saoFile, this.outFileName);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                System.out.println(e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }
    }

    private static class Alu
    extends GenFsm {
        private static String[] inputs = new String[]{"opcode", "abus", "bbus"};

        private Alu() {
        }

        @Override
        protected boolean ignore_wire(WireExt w) {
            String s = w.getName().toString();
            for (String is : inputs) {
                if (!is.equals(s)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean isFlipFlopIn(String modname, String wireName) {
            return modname.startsWith("flop$width=") && wireName.equals("d");
        }

        @Override
        protected boolean isFlipFlopOut(String modname, String wireName) {
            return modname.startsWith("flop$width=") && wireName.equals("q");
        }
    }

    public static class ShowSvexLibsJob<H extends DesignHints>
    extends Job {
        private final Class<H> cls;
        private final File saoFile;

        public ShowSvexLibsJob(Class<H> cls, File saoFile) {
            super("Show used Svex Libs", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFile = saoFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <H extends DesignHints> boolean doItNoJob(Class<H> cls, File saoFile) {
            try {
                ACL2Object.initHonsMananger(saoFile.getName());
                DesignHints designHints = (DesignHints)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                GenFsmNew gen = new GenFsmNew(designHints);
                gen.scanLib(saoFile);
                gen.showLibs();
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                System.out.println(e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }

        @Override
        public boolean doIt() throws JobException {
            return ShowSvexLibsJob.doItNoJob(this.cls, this.saoFile);
        }
    }

    private static class CompareSvexLibsJob<H extends DesignHints>
    extends Job {
        private final Class<H> cls;
        private final File[] saoFiles;

        public CompareSvexLibsJob(Class<H> cls, File[] saoFiles) {
            super("Compare Svex Libs", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFiles = saoFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger("Compare Svex Libs");
                DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                GenFsmNew gen = new GenFsmNew(designHints);
                HashMap modMap = new HashMap();
                for (File saoFile : this.saoFiles) {
                    System.out.println(saoFile);
                    gen.scanLib(saoFile);
                    ACL2Reader sr = new ACL2Reader(saoFile);
                    Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
                    Design<Address> design = new Design<Address>(snb, sr.root);
                    for (Map.Entry e : design.modalist.entrySet()) {
                        ModName modName = e.getKey();
                        Module newM = e.getValue();
                        Module oldM = (Module)modMap.get(modName);
                        if (oldM != null) {
                            if (newM.equals(oldM)) {
                                assert (newM.getACL2Object().equals(oldM.getACL2Object()));
                                continue;
                            }
                            System.out.println("Defferent module " + modName + " in " + saoFile);
                            continue;
                        }
                        modMap.put(modName, newM);
                    }
                }
                gen.showLibs();
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                System.out.println(e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }
    }

    private static class DedupSvexJob
    extends Job {
        private final File saoFile;
        private final String designName;
        private final String outFileName;

        private DedupSvexJob(File saoFile, String designName, String outFileName) {
            super("Dedup SVEX in Design", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.saoFile = saoFile;
            this.designName = designName;
            this.outFileName = outFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger(this.designName);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                DesignExt design = new DesignExt(sr.root);
                HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
                LinkedHashMap<Svex<PathExt>, String> svexLabels = new LinkedHashMap<Svex<PathExt>, String>();
                HashMap<Svex<PathExt>, BigInteger> svexSizes = new HashMap<Svex<PathExt>, BigInteger>();
                try (PrintStream out = new PrintStream(this.outFileName);){
                    Svex<N>[] toposort;
                    String label;
                    Svex svex;
                    out.println("(in-package \"SV\")");
                    out.println("(include-book \"std/util/defrule\" :dir :system)");
                    out.println("(include-book \"std/util/defconsts\" :dir :system)");
                    out.println("(include-book \"centaur/sv/mods/svmods\" :dir :system)");
                    out.println("(include-book \"centaur/sv/svex/svex\" :dir :system)");
                    out.println("(include-book \"centaur/sv/svex/rewrite\" :dir :system)");
                    out.println("(include-book \"centaur/sv/svex/xeval\" :dir :system)");
                    out.println();
                    out.println("(defconsts (*" + this.designName + "* state)");
                    out.println("  (serialize-read \"" + this.designName + ".sao\"))");
                    out.println();
                    out.println("(local (defn extract-labels (labels acc)");
                    out.println("  (if (atom labels)");
                    out.println("     ()");
                    out.println("    (cons (cdr (hons-get (car labels) acc))");
                    out.println("          (extract-labels (cdr labels) acc)))))");
                    out.println();
                    out.println("(local (defun from-dedup (x acc)");
                    out.println("  (if (atom x)");
                    out.println("       acc");
                    out.println("    (let* ((line (car x))");
                    out.println("           (label (car line))");
                    out.println("           (kind (cadr line))");
                    out.println("           (args (cddr line)))");
                    out.println("      (from-dedup");
                    out.println("        (cdr x)");
                    out.println("        (hons-acons");
                    out.println("          label");
                    out.println("          (case kind");
                    out.println("            (:quote (make-svex-quote :val (car args)))");
                    out.println("            (:var (make-svex-var :name (car args)))");
                    out.println("            (:call (make-svex-call :fn (car args)");
                    out.println("                                   :args (extract-labels (cdr args) acc))))");
                    out.println("          acc))))))");
                    out.println();
                    out.println("(defconsts (*" + this.designName + "-dedup*)");
                    out.println(" (from-dedup `(");
                    for (ModuleExt moduleExt : design.downTop.values()) {
                        for (DriverExt dr : moduleExt.assigns.values()) {
                            this.genDedup(out, dr.getOrigSvex(), svexLabels, svexSizes);
                        }
                    }
                    out.println(" ) ()))");
                    out.println();
                    for (Map.Entry entry : design.downTop.entrySet()) {
                        ModName mn = (ModName)entry.getKey();
                        ModuleExt m = (ModuleExt)entry.getValue();
                        out.println();
                        out.println("(local (defun |check-" + mn + "| ()");
                        out.println("  (let ((m (cdr (assoc-equal '" + mn + " (design->modalist *" + this.designName + "*)))))");
                        out.println("    (equal (hons-copy (strip-cars (strip-cdrs (module->assigns m))))");
                        out.print("           (extract-labels '(");
                        for (DriverExt dr : m.assigns.values()) {
                            out.print(" " + (String)svexLabels.get(dr.getOrigSvex()));
                        }
                        out.println(")");
                        out.println("                           *" + this.designName + "-dedup*)))))");
                    }
                    out.println();
                    out.println("(rule");
                    out.println("  (and");
                    for (ModName modName : design.downTop.keySet()) {
                        out.println("    (|check-" + modName + "|)");
                    }
                    out.println("))");
                    out.println();
                    out.println("(defconsts (*" + this.designName + "-xeval*) '(");
                    HashMap xevalMemoize = new HashMap();
                    for (Map.Entry e : svexLabels.entrySet()) {
                        svex = (Svex)e.getKey();
                        label = (String)e.getValue();
                        Vec4 xeval = svex.xeval(xevalMemoize);
                        out.println("  (" + label + " . " + xeval.getACL2Object(backedCache).rep() + ")");
                    }
                    out.println(" ))");
                    out.println();
                    out.println("(local (defun check-xeval (alist dedup)");
                    out.println("  (or (atom alist)");
                    out.println("      (and (equal (svex-xeval (cdr (hons-get (caar alist) dedup)))");
                    out.println("                  (cdar alist))");
                    out.println("           (check-xeval (cdr alist) dedup)))))");
                    out.println();
                    out.println("(rule");
                    out.println("  (check-xeval *" + this.designName + "-xeval* *" + this.designName + "-dedup*))");
                    out.println();
                    out.println("(defconsts (*" + this.designName + "-toposort*) '(");
                    for (Map.Entry e : svexLabels.entrySet()) {
                        svex = (Svex)e.getKey();
                        label = (String)e.getValue();
                        toposort = svex.toposort();
                        Util.check(toposort[0].equals(svex));
                        out.print("  (" + label);
                        for (int i = 1; i < toposort.length; ++i) {
                            out.print(" " + (String)svexLabels.get(toposort[i]));
                        }
                        out.println(")");
                    }
                    out.println(" ))");
                    out.println();
                    out.println("(local (defun check-toposort (list dedup)");
                    out.println("  (or (atom list)");
                    out.println("      (b* ((toposort (extract-labels (car list) dedup))");
                    out.println("           ((mv sort ?contents) (svex-toposort (car toposort) () ()))");
                    out.println("           (sort (hons-copy sort)))");
                    out.println("        (and (equal sort toposort)");
                    out.println("             (check-toposort (cdr list) dedup))))))");
                    out.println();
                    out.println("(rule");
                    out.println("  (check-toposort *" + this.designName + "-toposort* *" + this.designName + "-dedup*))");
                    out.println();
                    out.println("(defconsts (*" + this.designName + "-masks*) '(");
                    for (Map.Entry e : svexLabels.entrySet()) {
                        svex = (Svex)e.getKey();
                        label = (String)e.getValue();
                        toposort = svex.toposort();
                        Util.check(toposort[0].equals(svex));
                        Map masks = svex.maskAlist(BigIntegerUtil.MINUS_ONE);
                        out.print("  (" + label);
                        for (int i = 0; i < toposort.length; ++i) {
                            BigInteger mask = masks.get(toposort[i]);
                            if (mask == null) {
                                mask = BigInteger.ZERO;
                            }
                            out.print(" #x" + mask.toString(16));
                        }
                        out.println(")");
                    }
                    out.println(" ))");
                    out.println();
                    out.println("(local (defun toposort-label (label dedup)");
                    out.println("  (b* ((svex (cdr (hons-get label dedup)))");
                    out.println("       ((mv toposort ?contents) (svex-toposort svex () ())))");
                    out.println("    toposort)))");
                    out.println();
                    out.println("(local (defun comp-masks (toposort mask-al)");
                    out.println("  (if (atom toposort)");
                    out.println("      ()");
                    out.println("    (cons (svex-mask-lookup (car toposort) mask-al)");
                    out.println("          (comp-masks (cdr toposort) mask-al)))))");
                    out.println();
                    out.println("(local (defun masks-label (label dedup)");
                    out.println("  (b* ((svex (cdr (hons-get label dedup)))");
                    out.println("       (toposort (toposort-label label dedup))");
                    out.println("       (mask-al (svexlist-mask-alist (list svex))))");
                    out.println("    (comp-masks toposort mask-al))))");
                    out.println();
                    out.println("(local (defun show-line (line dedup)");
                    out.println("  (list");
                    out.println("   :line line");
                    out.println("   :toposort (toposort-label (car line) dedup)");
                    out.println("   :masks (masks-label (car line) dedup)");
                    out.println("   :ok (equal (masks-label (car line) dedup) (cdr line)))))");
                    out.println();
                    out.println("(local (defun check-masks (masks-lines dedup)");
                    out.println("  (or (atom masks-lines)");
                    out.println("      (and (let ((line (car masks-lines)))");
                    out.println("             (equal (masks-label (car line) dedup) (cdr line)))");
                    out.println("           (check-masks (cdr masks-lines) dedup)))))");
                    out.println();
                    out.println("(rule");
                    out.println("  (check-masks *" + this.designName + "-masks* *" + this.designName + "-dedup*))");
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }

        private <N extends SvarName> BigInteger computeSize(Svex<N> svex, Map<Svex<N>, BigInteger> sizes) {
            BigInteger size = sizes.get(svex);
            if (size == null) {
                if (svex instanceof SvexCall) {
                    size = BigInteger.ONE;
                    for (Svex arg : ((SvexCall)svex).getArgs()) {
                        size = size.add(this.computeSize(arg, sizes));
                    }
                } else {
                    size = BigInteger.ONE;
                }
                sizes.put(svex, size);
            }
            return size;
        }

        private String genDedup(PrintStream out, Svex<PathExt> svex, Map<Svex<PathExt>, String> svexLabels, Map<Svex<PathExt>, BigInteger> svexSizes) {
            Object label = svexLabels.get(svex);
            if (label == null) {
                if (svex instanceof SvexQuote) {
                    SvexQuote sq = (SvexQuote)svex;
                    label = "l" + svexLabels.size();
                    svexLabels.put(svex, (String)label);
                    out.print(" (" + (String)label + " :quote ");
                    Vec4 val = sq.val;
                    if (val instanceof Vec2) {
                        out.print("#x" + ((Vec2)val).getVal().toString(16));
                    } else {
                        out.print("(#x" + val.getUpper().toString(16) + " . #x" + val.getLower().toString(16) + ")");
                    }
                    out.println(")");
                } else if (svex instanceof SvexVar) {
                    SvexVar sv = (SvexVar)svex;
                    label = "l" + svexLabels.size();
                    svexLabels.put(svex, (String)label);
                    out.print(" (" + (String)label + " :var ,(make-svar :name ");
                    if (sv.svar.getName() instanceof PathExt.PortInst) {
                        PathExt.PortInst pi = (PathExt.PortInst)sv.svar.getName();
                        out.print("'(" + pi.inst.getInstname().toLispString() + " . " + pi.getProtoName().toLispString() + ")");
                    } else {
                        WireExt lw = (WireExt)sv.svar.getName();
                        out.print(lw.getName().toLispString());
                        if (sv.svar.getDelay() != 0) {
                            out.print(" :delay " + sv.svar.getDelay());
                        }
                    }
                    out.println("))");
                } else {
                    SvexCall sc = (SvexCall)svex;
                    Svex<N>[] args = sc.getArgs();
                    String[] labels = new String[args.length];
                    for (int i = 0; i < labels.length; ++i) {
                        labels[i] = this.genDedup(out, args[i], svexLabels, svexSizes);
                    }
                    label = "l" + svexLabels.size();
                    svexLabels.put(svex, (String)label);
                    out.print(" (" + (String)label + " :call " + ACL2.symbol_name(sc.fun.fn).stringValueExact());
                    for (String l : labels) {
                        out.print(" " + l);
                    }
                    out.println(") ; " + this.computeSize(svex, svexSizes));
                }
            }
            return label;
        }
    }

    private static class ShowAssignsJob
    extends Job {
        private final File saoFile;
        private final String designName;
        private final String outFileName;

        private ShowAssignsJob(File saoFile, String designName, String outFileName) {
            super("Show SVEX assigns", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.saoFile = saoFile;
            this.designName = designName;
            this.outFileName = outFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger(this.designName);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                DesignExt design = new DesignExt(sr.root);
                try (PrintStream out = new PrintStream(this.outFileName);){
                    out.println("(in-package \"SV\")");
                    out.println("(include-book \"std/util/defconsts\" :dir :system)");
                    out.println("(include-book \"std/util/define\" :dir :system)");
                    out.println("(include-book \"std/util/defrule\" :dir :system)");
                    out.println("(include-book \"centaur/sv/mods/svmods\" :dir :system)");
                    out.println("(include-book \"centaur/sv/svex/svex\" :dir :system)");
                    out.println("(include-book \"centaur/sv/svex/rewrite\" :dir :system)");
                    out.println();
                    out.println("(defconsts (*" + this.designName + "* state)");
                    out.println("  (serialize-read \"" + this.designName + ".sao\"))");
                    out.println();
                    out.println("(local (define filter-vars");
                    out.println("  ((toposort svexlist-p)");
                    out.println("   (mask-al svex-mask-alist-p))");
                    out.println("  :returns (filtered svex-mask-alist-p)");
                    out.println("  (and (consp toposort)");
                    out.println("       (let ((svex (svex-fix (car toposort)))");
                    out.println("             (rest (cdr toposort)))");
                    out.println("         (svex-case svex");
                    out.println("           :quote (filter-vars rest mask-al)");
                    out.println("           :call (filter-vars rest mask-al)");
                    out.println("           :var (cons (cons svex (svex-mask-lookup svex mask-al))");
                    out.println("                      (filter-vars rest mask-al)))))))");
                    out.println();
                    out.println("(local (define compute-driver-masks");
                    out.println("  ((x svexlist-p))");
                    out.println("  (and (consp x)");
                    out.println("       (b* ((svex (car x))");
                    out.println("            ((mv toposort ?contents) (svex-toposort svex () ()))");
                    out.println("            (mask-al (svexlist-mask-alist (list svex))))");
                    out.println("         (cons (rev (filter-vars toposort mask-al))");
                    out.println("               (compute-driver-masks (cdr x)))))))");
                    for (Map.Entry<ModName, ModuleExt> e : design.downTop.entrySet()) {
                        ModName mn = e.getKey();
                        ModuleExt m = e.getValue();
                        out.println();
                        out.println("(local (define |check-" + mn + "| ()");
                        out.println("  (let ((m (cdr (assoc-equal \"" + mn + "\" (design->modalist *" + this.designName + "*)))))");
                        out.println("    (equal (compute-driver-masks (hons-copy (strip-cars (strip-cdrs (module->assigns m))))) `(");
                        for (Map.Entry<Lhs<PathExt>, DriverExt> e1 : m.assigns.entrySet()) {
                            Lhs<PathExt> l = e1.getKey();
                            DriverExt d = e1.getValue();
                            List<Svar<PathExt>> vars = d.getOrigVars();
                            Map<Svex<PathExt>, BigInteger> masks = d.getOrigSvex().maskAlist(BigIntegerUtil.MINUS_ONE);
                            out.print("      (;");
                            assert (!l.ranges.isEmpty());
                            for (int i = 0; i < l.ranges.size(); ++i) {
                                Lhrange lr = l.ranges.get(i);
                                Svar svar = lr.getVar();
                                assert (svar.getDelay() == 0);
                                assert (!svar.isNonblocking());
                                out.print((i == 0 ? "  " : ",") + lr);
                            }
                            out.println();
                            for (Svar<PathExt> var : vars) {
                                WireExt lw = (WireExt)var.getName();
                                SvexVar<PathExt> svex = new SvexVar<PathExt>(var);
                                BigInteger mask = masks.get(svex);
                                if (mask == null) {
                                    mask = BigInteger.ZERO;
                                }
                                out.print("        (");
                                String rep = lw.getName().toLispString();
                                if (var.getDelay() == 0) {
                                    out.print(rep);
                                } else {
                                    out.print(",(make-svar :name " + rep + " :delay " + var.getDelay() + ")");
                                }
                                out.println(" . #x" + mask.toString(16) + ")");
                            }
                            out.print("      )");
                        }
                        out.println(" )))))");
                    }
                    out.println();
                    out.println("(rule");
                    out.println("  (and");
                    for (ModName mn : design.downTop.keySet()) {
                        out.println("    (|check-" + mn + "|)");
                    }
                    out.println("))");
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }
    }

    private static class NamedToIndexedJob
    extends Job {
        private final File saoFile;
        private final String designName;

        private NamedToIndexedJob(File saoFile, String designName) {
            super("Named->Indexed", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.saoFile = saoFile;
            this.designName = designName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger(this.designName);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
                Design<Address> design = new Design<Address>(snb, sr.root);
                ModDb db = new ModDb(design.top, design.modalist);
                IndexName.curElabMod = db.topMod();
                Map<ModName, Module<Address>> indexedMods = db.modalistNamedToIndex(design.modalist);
                ElabMod topIdx = db.modnameGetIndex(design.top);
                ModDb.FlattenResult flattenResult = topIdx.svexmodFlatten(indexedMods);
                ACL2Object indexedAlist = ACL2.NIL;
                for (Map.Entry<ModName, Module<Address>> e : indexedMods.entrySet()) {
                    indexedAlist = ACL2.cons(ACL2.cons(e.getKey().getACL2Object(), e.getValue().getACL2Object()), indexedAlist);
                }
                indexedAlist = Util.revList(indexedAlist);
                ACL2Object aliaspairsAlist = flattenResult.aliaspairsToACL2Object();
                ACL2Object assignsAlist = flattenResult.assignsToACL2Object();
                ACL2Object aliasesList = flattenResult.aliasesToACL2Object();
                ACL2Object results = ACL2.cons(indexedAlist, ACL2.cons(aliaspairsAlist, ACL2.cons(assignsAlist, ACL2.cons(aliasesList, ACL2.NIL))));
                File outDir = this.saoFile.getParentFile();
                File saoIndexedFile = new File(outDir, this.designName + "-indexed.sao");
                ACL2Writer.write(results, saoIndexedFile);
                ArrayList<String> lines = new ArrayList<String>();
                try (LineNumberReader in = new LineNumberReader(new InputStreamReader(ACL2DesignJobs.class.getResourceAsStream("design-indexed.dat")));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        lines.add(line);
                    }
                }
                File outFile = new File(outDir, this.designName + "-indexed.lisp");
                try (PrintStream out = new PrintStream(outFile);){
                    for (String line : lines) {
                        out.println(line.replace("$DESIGN$", this.designName));
                    }
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                IndexName.curElabMod = null;
                ACL2Object.closeHonsManager();
            }
            return true;
        }
    }

    private static class NormalizeAssignsJob
    extends Job {
        private final File saoFile;
        private final String designName;
        private final boolean isIndexed;

        private NormalizeAssignsJob(File saoFile, String designName, boolean isIndexed) {
            super("Named->Indexed", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.saoFile = saoFile;
            this.designName = designName;
            this.isIndexed = isIndexed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object resDelays;
                ACL2Object resAssigns;
                ACL2Object netAssigns;
                ACL2Object normAssigns;
                ACL2Object svexarrList;
                ACL2Object indexedAliasesList;
                ACL2Object.initHonsMananger(this.designName);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
                Design<Address> design = new Design<Address>(snb, sr.root);
                ModDb db = new ModDb(design.top, design.modalist);
                IndexName.curElabMod = db.topMod();
                Map<ModName, Module<Address>> indexedMods = db.modalistNamedToIndex(design.modalist);
                ElabMod topElabMod = db.modnameGetIndex(design.top);
                ElabMod.ModScope topScope = new ElabMod.ModScope(topElabMod);
                ModDb.FlattenResult flattenResult = topElabMod.svexmodFlatten(indexedMods);
                ACL2Object indexedAssignsAlist = flattenResult.assignsToACL2Object();
                ACL2Object namedAliasesList = indexedAliasesList = flattenResult.aliasesToACL2Object();
                if (this.isIndexed) {
                    Compile<IndexName> compile = new Compile<IndexName>(flattenResult.aliases.getArr(), flattenResult.assigns, flattenResult.sm);
                    svexarrList = compile.svexarrAsACL2Object();
                    normAssigns = compile.normAssignsAsACL2Object();
                    netAssigns = compile.netAssignsAsACL2Object();
                    resAssigns = compile.resAssignsAsACL2Object();
                    resDelays = compile.resDelaysAsACL2Object();
                } else {
                    SvexManager<Path> sm = new SvexManager<Path>();
                    List namedAliases = topScope.aliasesToPath(flattenResult.aliases, sm);
                    Compile<Path> compile = new Compile<Path>(namedAliases, flattenResult.assigns, sm);
                    namedAliasesList = topScope.aliasesToNamedACL2Object(flattenResult.aliases, sm);
                    svexarrList = compile.svexarrAsACL2Object();
                    normAssigns = compile.normAssignsAsACL2Object();
                    netAssigns = compile.netAssignsAsACL2Object();
                    resAssigns = compile.resAssignsAsACL2Object();
                    resDelays = compile.resDelaysAsACL2Object();
                }
                ACL2Object results = ACL2.cons(indexedAssignsAlist, ACL2.cons(indexedAliasesList, ACL2.cons(namedAliasesList, ACL2.cons(svexarrList, ACL2.cons(normAssigns, ACL2.cons(netAssigns, ACL2.cons(resAssigns, ACL2.cons(resDelays, ACL2.NIL))))))));
                File outDir = this.saoFile.getParentFile();
                File saoIndexedFile = new File(outDir, this.designName + "-svex-normalize-assigns.sao");
                ACL2Writer.write(results, saoIndexedFile);
                ArrayList<String> lines = new ArrayList<String>();
                try (LineNumberReader in = new LineNumberReader(new InputStreamReader(ACL2DesignJobs.class.getResourceAsStream("svex-normalize-assigns.dat")));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        lines.add(line);
                    }
                }
                File outFile = new File(outDir, this.designName + "-svex-normalized-assigns.lisp");
                try (PrintStream out = new PrintStream(outFile);){
                    String indexedStr = this.isIndexed ? "t" : "nil";
                    for (String line : lines) {
                        out.println(line.replace("$DESIGN$", this.designName).replace("$INDEXED$", indexedStr));
                    }
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                IndexName.curElabMod = null;
                ACL2Object.closeHonsManager();
            }
            return true;
        }
    }
}

