/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.FCQueue;
import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.datastructures.IWorkStealing;
import com.sun.electric.tool.util.concurrent.datastructures.LockFreeQueue;
import com.sun.electric.tool.util.concurrent.runtime.MultiThreadedRandomizer;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import com.sun.electric.util.TextUtils;
import java.util.List;
import java.util.Map;

public class MultipleQueuesStructure<T>
extends IStructure<T>
implements IWorkStealing {
    protected Map<Long, IStructure<T>> dataQueues = ConcurrentCollectionFactory.createConcurrentHashMap();
    protected Map<Long, Long> dataQueuesMapping = ConcurrentCollectionFactory.createConcurrentHashMap();
    protected MultiThreadedRandomizer randomizer;
    private List<Long> freeInternalIds;

    public MultipleQueuesStructure(int numOfThreads) {
        this.randomizer = new MultiThreadedRandomizer(numOfThreads);
        this.freeInternalIds = ConcurrentCollectionFactory.createConcurrentList();
        for (long i = 0L; i < (long)numOfThreads; ++i) {
            this.freeInternalIds.add(i);
            this.dataQueues.put(i, new LockFreeQueue());
            this.dataQueues.put(i, new FCQueue());
        }
    }

    @Override
    public void add(T item) {
        this.add(item, -1);
    }

    @Override
    public void add(T item, int i) {
        Long osThreadId = this.getThreadId();
        Long localQueueId = this.dataQueuesMapping.get(osThreadId);
        if (i == -1) {
            IStructure<T> ownQueue;
            if (localQueueId != null && (ownQueue = this.dataQueues.get(localQueueId)) != null) {
                ownQueue.add(item);
                return;
            }
            int foreignQueue = this.randomizer.getRandomizer().nextInt(this.dataQueues.size());
            this.dataQueues.get(foreignQueue).add(item);
        } else {
            this.dataQueues.get(i).add(item);
        }
    }

    @Override
    public boolean isEmpty() {
        IStructure<T> ownQueue = this.dataQueues.get(this.getThreadId());
        if (ownQueue != null) {
            return ownQueue.isEmpty();
        }
        return false;
    }

    @Override
    public T remove() {
        Long osThreadId = this.getThreadId();
        Long localQueueId = this.dataQueuesMapping.get(osThreadId);
        if (localQueueId == null) {
            throw new Error("Thread not registered");
        }
        T result = null;
        IStructure<T> ownQueue = this.dataQueues.get(localQueueId);
        if (ownQueue != null) {
            result = ownQueue.remove();
        }
        return result;
    }

    protected Long getThreadId() {
        return TextUtils.getThreadID(Thread.currentThread());
    }

    @Override
    public void registerThread() {
        if (this.freeInternalIds.size() > 0) {
            Long myId = this.freeInternalIds.remove(0);
            this.dataQueuesMapping.put(this.getThreadId(), myId);
        }
    }
}

