/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         cf_parse
#define yylex           cf_lex
#define yyerror         cf_error
#define yydebug         cf_debug
#define yynerrs         cf_nerrs
#define yylval          cf_lval
#define yychar          cf_char

/* First part of user prologue.  */
#line 57 "conf/gen_parser.m4"

#line 9 "conf/confbase.Y"
/* Headers from conf/confbase.Y */

#define PARSER 1

#include "nest/bird.h"
#include "conf/conf.h"
#include "lib/resource.h"
#include "lib/socket.h"
#include "lib/settle.h"
#include "lib/timer.h"
#include "lib/string.h"
#include "nest/protocol.h"
#include "nest/iface.h"
#include "nest/route.h"
#include "nest/bfd.h"
#include "nest/cli.h"
#include "filter/filter.h"

/* FIXME: Turn on YYERROR_VERBOSE and work around lots of bison bugs? */

/* Defines from conf/confbase.Y */

static bool this_sadr_from_hack_active;

static void
check_u16(uint val)
{
  if (val > 0xFFFF)
    cf_error("Value %u out of range (0-65535)", val);
}

#define cf_assert(cond, ...) do { if (!(cond)) cf_error(__VA_ARGS__); } while (0)
static inline void cf_assert_symbol(const struct symbol *sym, uint class) {
  switch (class) {
    case SYM_PROTO: cf_assert(sym->class == SYM_PROTO, "Protocol name required"); break;
    case SYM_TEMPLATE: cf_assert(sym->class == SYM_TEMPLATE, "Protocol template name required"); break;
    case SYM_FUNCTION: cf_assert(sym->class == SYM_FUNCTION, "Function name required"); break;
    case SYM_FILTER: cf_assert(sym->class == SYM_FILTER, "Filter name required"); break;
    case SYM_TABLE: cf_assert(sym->class == SYM_TABLE, "Table name required"); break;
    case SYM_ATTRIBUTE: cf_assert(sym->class == SYM_ATTRIBUTE, "Custom attribute name required"); break;
    case SYM_MPLS_DOMAIN: cf_assert(sym->class == SYM_MPLS_DOMAIN, "MPLS domain name required"); break;
    case SYM_MPLS_RANGE: cf_assert(sym->class == SYM_MPLS_RANGE, "MPLS range name required"); break;
    case SYM_VARIABLE: cf_assert((sym->class & ~0xff) == SYM_VARIABLE, "Variable name required"); break;
    case SYM_CONSTANT: cf_assert((sym->class & ~0xff) == SYM_CONSTANT, "Constant name required"); break;
    default: bug("This shall not happen");
  }
}

static inline const char *
cf_type_name(btype type)
{
  /* There is already f_type_name(), but this uses names more suited
     to configuration error messages */
  switch (type)
  {
  case T_INT:		return "Number";
  case T_BOOL:		return "Boolean";
  case T_IP:		return "IP address";
  case T_NET:		return "Network";
  case T_STRING:	return "String";
  case T_BYTESTRING:	return "Bytestring";
  default:		return "???";
  }
}

static inline void
cf_assert_type(const struct f_val val, btype type)
{
  if (val.type != type)
    cf_error("%s expected", cf_type_name(type));
}


#line 9 "conf/flowspec.Y"
/* Headers from conf/flowspec.Y */

#define PARSER 1

#include "nest/bird.h"
#include "lib/flowspec.h"


/* Defines from conf/flowspec.Y */

struct flow_builder *this_flow;


#line 11 "filter/config.Y"
/* Headers from filter/config.Y */

#include "filter/f-inst.h"
#include "filter/data.h"

/* Defines from filter/config.Y */

static inline u32 pair(u32 a, u32 b) { return (a << 16) | b; }
static inline u32 pair_a(u32 p) { return p >> 16; }
static inline u32 pair_b(u32 p) { return p & 0xFFFF; }

static struct symbol *this_function;
static struct sym_scope *this_for_scope;

static struct f_method_scope {
  struct f_inst *object;
  struct sym_scope *main;
  struct sym_scope scope;
} f_method_scope_stack[32];
static int f_method_scope_pos = -1;

#define FM  (f_method_scope_stack[f_method_scope_pos])

static inline void f_method_call_start(struct f_inst *object)
{
  if (object->type == T_VOID)
    cf_error("Can't infer type to properly call a method, please assign the value to a variable");
  if (++f_method_scope_pos >= (int) ARRAY_SIZE(f_method_scope_stack))
    cf_error("Too many nested method calls");

  struct sym_scope *scope = f_type_method_scope(object->type);
  if (!scope->hash.count && !scope->next)
    cf_error("No methods defined for type %s", f_type_name(object->type));

  /* Replacing the current symbol scope with the appropriate method scope
     for the given type. */
  FM = (struct f_method_scope) {
    .object = object,
    .main = new_config->current_scope,
    .scope = {
      .next = scope->next,
      .hash = scope->hash,
      .block = 1,
      .readonly = 1,
    },
  };
  new_config->current_scope = &FM.scope;
}

static inline void f_method_call_args(void)
{
  /* For argument parsing, we need to revert back to the standard symbol scope. */
  new_config->current_scope = FM.main;
}

static inline void f_method_call_end(void)
{
  ASSERT_DIE(f_method_scope_pos >= 0);
  if (&FM.scope == new_config->current_scope)
    new_config->current_scope = FM.main;

  f_method_scope_pos--;
}

static int
f_new_var(struct sym_scope *s)
{
  /*
   * - A variable is an offset on vstack from vbase.
   * - Vbase is set on filter start / function call.
   * - Scopes contain (non-frame) block scopes inside filter/function scope
   * - Each scope knows number of vars in that scope
   * - Offset is therefore a sum of 'slots' up to filter/function scope
   * - New variables are added on top of vstk, so intermediate values cannot
   *   be there during FI_VAR_INIT. I.e. no 'var' inside 'term'.
   * - Also, each f_line must always have its scope, otherwise a variable may
   *   be defined but not initialized if relevant f_line is not executed.
   */

  int offset = s->slots++;

  while (s->block)
  {
    s = s->next;
    ASSERT(s);
    offset += s->slots;
  }

  if (offset >= 0xff)
    cf_error("Too many variables, at most 255 allowed");

  return offset;
}

/* Macro for top-level pre-defined variables. */
#define f_predefined_variable(conf_, name_, type_) \
    cf_define_symbol(conf_, cf_get_symbol(conf_, name_), SYM_VARIABLE | type_, offset, f_new_var(conf_->current_scope))

/*
 * Sets and their items are during parsing handled as lists, linked
 * through left ptr. The first item in a list also contains a pointer
 * to the last item in a list (right ptr). For convenience, even items
 * are handled as one-item lists. Lists are merged by f_merge_items().
 */
static int
f_valid_set_type(int type)
{
  switch (type)
  {
  case T_INT:
  case T_PAIR:
  case T_QUAD:
  case T_ENUM:
  case T_IP:
  case T_EC:
  case T_LC:
  case T_RD:
    return 1;

  default:
    return 0;
  }
}

static inline struct f_tree *
f_new_item(struct f_val from, struct f_val to)
{
  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from = from;
  t->to = to;
  return t;
}

static inline struct f_tree *
f_merge_items(struct f_tree *a, struct f_tree *b)
{
  if (!a) return b;
  a->right->left = b;
  a->right = b->right;
  b->right = NULL;
  return a;
}

static inline struct f_tree *
f_new_pair_item(int fa, int ta, int fb, int tb)
{
  check_u16(fa);
  check_u16(ta);
  check_u16(fb);
  check_u16(tb);

  if ((ta < fa) || (tb < fb))
    cf_error( "From value cannot be higher that To value in pair sets");

  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from.type = t->to.type = T_PAIR;
  t->from.val.i = pair(fa, fb);
  t->to.val.i = pair(ta, tb);
  return t;
}

static inline struct f_tree *
f_new_pair_set(int fa, int ta, int fb, int tb)
{
  check_u16(fa);
  check_u16(ta);
  check_u16(fb);
  check_u16(tb);

  if ((ta < fa) || (tb < fb))
    cf_error( "From value cannot be higher that To value in pair sets");

  struct f_tree *lst = NULL;
  int i;

  for (i = fa; i <= ta; i++)
    lst = f_merge_items(lst, f_new_pair_item(i, i, fb, tb));

  return lst;
}

#define CC_ALL 0xFFFF
#define EC_ALL 0xFFFFFFFF
#define LC_ALL 0xFFFFFFFF

static struct f_tree *
f_new_ec_item(u32 kind, u32 ipv4_used, u32 key, u32 vf, u32 vt)
{
  u64 fm, to;

  if ((kind != EC_GENERIC) && (ipv4_used || (key >= 0x10000))) {
    check_u16(vf);
    if (vt == EC_ALL)
      vt = 0xFFFF;
    else
      check_u16(vt);
  }

  if (kind == EC_GENERIC) {
    fm = ec_generic(key, vf);
    to = ec_generic(key, vt);
  }
  else if (ipv4_used) {
    fm = ec_ip4(kind, key, vf);
    to = ec_ip4(kind, key, vt);
  }
  else if (key < 0x10000) {
    fm = ec_as2(kind, key, vf);
    to = ec_as2(kind, key, vt);
  }
  else {
    fm = ec_as4(kind, key, vf);
    to = ec_as4(kind, key, vt);
  }

  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from.type = t->to.type = T_EC;
  t->from.val.ec = fm;
  t->to.val.ec = to;
  return t;
}

static struct f_tree *
f_new_lc_item(u32 f1, u32 t1, u32 f2, u32 t2, u32 f3, u32 t3)
{
  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from.type = t->to.type = T_LC;
  t->from.val.lc = (lcomm) {f1, f2, f3};
  t->to.val.lc = (lcomm) {t1, t2, t3};
  return t;
}


/*
 * Remove all new lines and doubled whitespaces
 * and convert all tabulators to spaces
 * and return a copy of string
 */
char *
assert_copy_expr(const char *start, size_t len)
{
  /* XXX: Allocates maybe a little more memory than we really finally need */
  char *str = cfg_alloc(len + 1);

  char *dst = str;
  const char *src = start - 1;
  const char *end = start + len;
  while (++src < end)
  {
    if (*src == '\n')
      continue;

    /* Skip doubled whitespaces */
    if (src != start)
    {
      const char *prev = src - 1;
      if ((*src == ' ' || *src == '\t') && (*prev == ' ' || *prev == '\t'))
	continue;
    }

    if (*src == '\t')
      *dst = ' ';
    else
      *dst = *src;

    dst++;
  }
  *dst = '\0';

  return str;
}

/*
 * assert_done - create f_instruction of bt_assert
 * @expr: expression in bt_assert()
 * @start: pointer to first char of test expression
 * @end: pointer to the last char of test expression
 */
static struct f_inst *
assert_done(struct f_inst *expr, const char *start, const char *end)
{
  return f_new_inst(FI_ASSERT, expr,
    (end >= start) ?
      assert_copy_expr(start, end - start + 1)
    : "???");
}

static struct f_inst *
f_lval_getter(struct f_lval *lval)
{
  switch (lval->type) {
    case F_LVAL_CONSTANT:	return f_new_inst(FI_CONSTANT, *(lval->sym->val));
    case F_LVAL_VARIABLE:	return f_new_inst(FI_VAR_GET, lval->sym);
    case F_LVAL_SA:		return f_new_inst(FI_RTA_GET, lval->rte, lval->sa);
    case F_LVAL_EA:		return f_new_inst(FI_EA_GET, lval->rte, lval->da);
    case F_LVAL_ATTR_BIT:
      {
	struct f_inst *c = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = (1U << lval->fab.bit)});
	return f_new_inst(FI_EQ, c, f_new_inst(FI_BITAND, f_new_inst(FI_EA_GET, lval->rte, lval->fab.class), c));
      }
    default:			bug("Unknown lval type");
  }
}

static struct f_inst *
f_lval_setter(struct f_lval *lval, struct f_inst *expr)
{
  switch (lval->type) {
    case F_LVAL_CONSTANT:	cf_error("Constant %s is read-only", lval->sym->name);
    case F_LVAL_VARIABLE:	return f_new_inst(FI_VAR_SET, expr, lval->sym);
    case F_LVAL_SA:
      if (lval->sa.readonly)
	cf_error( "This static attribute is read-only.");
      return f_new_inst(FI_RTA_SET, expr, lval->sa);

    case F_LVAL_EA:		return f_new_inst(FI_EA_SET, expr, lval->da);
    case F_LVAL_ATTR_BIT:	return f_new_inst(FI_CONDITION, expr,
	f_new_inst(FI_EA_SET,
	  f_new_inst(FI_BITOR,
	    f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = (1U << lval->fab.bit)}),
	    f_new_inst(FI_EA_GET, lval->rte, lval->fab.class)
	  ),
	  lval->fab.class),
	f_new_inst(FI_EA_SET,
	  f_new_inst(FI_BITAND,
	    f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = ~(1U << lval->fab.bit)}),
	    f_new_inst(FI_EA_GET, lval->rte, lval->fab.class)
	  ),
	  lval->fab.class)
	);
    default:			bug("Unknown lval type");
  }
}

static struct f_inst *
assert_assign(struct f_lval *lval, struct f_inst *expr, const char *start, const char *end)
{
  struct f_inst *setter = f_lval_setter(lval, expr),
		*getter = f_lval_getter(lval);

  struct f_inst *checker = f_new_inst(FI_EQ, expr, getter);
  setter->next = checker;

  return assert_done(setter, start, end);
}

#line 10 "nest/config.Y"
/* Headers from nest/config.Y */

#include "nest/rt-dev.h"
#include "nest/password.h"
#include "nest/cmds.h"
#include "nest/mpls.h"
#include "lib/lists.h"
#include "lib/mac.h"

/* Defines from nest/config.Y */

static struct rtable_config *this_table;
static struct proto_config *this_proto;
static struct channel_config *this_channel;
static struct iface_patt *this_ipatt;
static struct iface_patt_node *this_ipn;
/* static struct roa_table_config *this_roa_table; */
static list *this_p_list;
static struct password_item *this_p_item;
static int password_id;
static struct bfd_options *this_bfd_opts;

static void
iface_patt_check(void)
{
  struct iface_patt_node *pn;

  WALK_LIST(pn, this_ipatt->ipn_list)
    if (!pn->pattern || pn->prefix.type)
      cf_error("Interface name/mask expected, not IP prefix");
}

static inline void
init_password_list(void)
{
   if (!this_p_list) {
      this_p_list = cfg_allocz(sizeof(list));
      init_list(this_p_list);
      password_id = 1;
   }
}

static inline void
init_password(const void *key, uint length, uint id)
{
   this_p_item = cfg_allocz(sizeof (struct password_item));
   this_p_item->password = key;
   this_p_item->length = length;
   this_p_item->genfrom = 0;
   this_p_item->gento = TIME_INFINITY;
   this_p_item->accfrom = 0;
   this_p_item->accto = TIME_INFINITY;
   this_p_item->id = id;
   this_p_item->alg = ALG_UNDEFINED;
   add_tail(this_p_list, &this_p_item->n);
}

static inline void
reset_passwords(void)
{
  this_p_list = NULL;
}

static inline list *
get_passwords(void)
{
  list *rv = this_p_list;
  this_p_list = NULL;
  return rv;
}

static inline void
init_bfd_opts(struct bfd_options **opts)
{
  cf_check_bfd(1);

  if (! *opts)
    *opts = bfd_new_options();
}

static inline void
open_bfd_opts(struct bfd_options **opts)
{
  init_bfd_opts(opts);
  this_bfd_opts = *opts;
}

static inline void
close_bfd_opts(void)
{
  this_bfd_opts = NULL;
}

static void
proto_postconfig(void)
{
  CALL(this_proto->protocol->postconfig, this_proto);
  this_channel = NULL;
  this_proto = NULL;
}

static void
channel_reload_out_done_main(void *_prr)
{
  struct proto_reload_request *prr = _prr;
  ASSERT_THE_BIRD_LOCKED;

  rfree(prr->trie->lp);
}

static inline void
proto_call_cmd_reload(struct proto_spec ps, int dir, const struct f_trie *trie)
{
  struct proto_reload_request *prr = cfg_alloc(sizeof *prr);
  *prr = (struct proto_reload_request) {
    .trie = trie,
    .dir = dir,
    .counter = 1,
  };
  if (trie)
  {
    /* CLI linpool is moved to trie, because trie is need for longer time
     * than the linpool would exist in CLI. The linpool is freed in channel_reload_out_done_main.
     */
    ASSERT_DIE(this_cli->parser_pool == prr->trie->lp);
    rmove(this_cli->parser_pool, &root_pool);
    this_cli->parser_pool = lp_new(this_cli->pool);
    prr->ev = (event) {
      .data = prr,
      .hook = channel_reload_out_done_main,
    };
  }

  proto_apply_cmd(ps, proto_cmd_reload, 1, (uintptr_t) prr);
  /* This function used reference to this trie, so it is freed here as well as in protocols*/
  if (trie)
    if (atomic_fetch_sub_explicit(&prr->counter, 1, memory_order_acq_rel) == 1)
      ev_send_loop(&main_birdloop, &prr->ev);
}

#define DIRECT_CFG ((struct rt_dev_config *) this_proto)

#line 10 "nest/mpls.Y"
/* Headers from nest/mpls.Y */

#include "nest/mpls.h"

/* Defines from nest/mpls.Y */

static struct mpls_domain_config *this_mpls_domain;
static struct mpls_range_config *this_mpls_range;

#define MPLS_CC ((struct mpls_channel_config *) this_channel)

#line 11 "proto/aggregator/config.Y"
/* Headers from proto/aggregator/config.Y */

#include "proto/aggregator/aggregator.h"

/* Defines from proto/aggregator/config.Y */

#define AGGREGATOR_CFG ((struct aggregator_config *) this_proto)
#define AGGR_ITEM_ALLOC ((struct aggr_item_node *) cfg_allocz(sizeof(struct aggr_item_node)))

#line 8 "proto/bfd/config.Y"
/* Headers from proto/bfd/config.Y */

#include "proto/bfd/bfd.h"

/* Defines from proto/bfd/config.Y */

#define BFD_CFG ((struct bfd_config *) this_proto)
#define BFD_IFACE ((struct bfd_iface_config *) this_ipatt)
#define BFD_NEIGHBOR this_bfd_neighbor

static struct bfd_neighbor *this_bfd_neighbor;

extern struct bfd_config *bfd_cf;

#line 13 "proto/babel/config.Y"
/* Headers from proto/babel/config.Y */

#include "proto/babel/babel.h"
#include "nest/iface.h"

/* Defines from proto/babel/config.Y */

#define BABEL_CFG ((struct babel_config *) this_proto)
#define BABEL_IFACE ((struct babel_iface_config *) this_ipatt)

#line 9 "proto/bgp/config.Y"
/* Headers from proto/bgp/config.Y */

#include "proto/bgp/bgp.h"

/* Defines from proto/bgp/config.Y */

#define BGP_CFG ((struct bgp_config *) this_proto)
#define BGP_CC ((struct bgp_channel_config *) this_channel)

static struct ao_config *this_ao_key;
static struct ao_config **next_ao_key;

#line 10 "proto/l3vpn/config.Y"
/* Headers from proto/l3vpn/config.Y */

#include "proto/l3vpn/l3vpn.h"


/* Defines from proto/l3vpn/config.Y */

#define L3VPN_CFG ((struct l3vpn_config *) this_proto)

static void
f_tree_only_rt(struct f_tree *t)
{
  /* Parsed degenerate trees have link to the last node in t->right */
  t->right = NULL;

  while (t)
  {
    uint type1 = t->from.val.ec >> 48;
    uint type2 = t->to.val.ec >> 48;
    ASSERT(type1 == type2);

    if (!ec_type_is_rt(type1))
      cf_error("Extended community is not route target");

    ASSERT(!t->right);
    t = t->left;
  }
}


#line 9 "proto/ospf/config.Y"
/* Headers from proto/ospf/config.Y */

#include "proto/ospf/ospf.h"

/* Defines from proto/ospf/config.Y */

#define OSPF_CFG ((struct ospf_config *) this_proto)
#define OSPF_PATT ((struct ospf_iface_patt *) this_ipatt)

static struct ospf_area_config *this_area;
static struct nbma_node *this_nbma;
static list *this_nets;
static struct area_net_config *this_pref;
static struct ospf_stubnet_config *this_stubnet;

static inline int ospf_cfg_is_v2(void) { return OSPF_CFG->ospf2; }
static inline int ospf_cfg_is_v3(void) { return ! OSPF_CFG->ospf2; }

static void
ospf_iface_finish(void)
{
  struct ospf_iface_patt *ip = OSPF_PATT;

  if (ip->deadint == 0)
    ip->deadint = ip->deadc * ip->helloint;

  if (ip->waitint == 0)
    ip->waitint = ip->deadc * ip->helloint;

  ip->passwords = get_passwords();

  if (ospf_cfg_is_v2() && (ip->autype == OSPF_AUTH_CRYPT) && (ip->helloint < 5))
    cf_warn("Hello or poll interval less that 5 makes cryptographic authentication prone to replay attacks");

  if ((ip->autype == OSPF_AUTH_NONE) && (ip->passwords != NULL))
    cf_warn("Password option without authentication option does not make sense");

  if (ip->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *ip->passwords)
    {
      if (pass->alg && (ip->autype != OSPF_AUTH_CRYPT))
	cf_error("Password algorithm option requires cryptographic authentication");

      /* Set default OSPF crypto algorithms */
      if (!pass->alg && (ip->autype == OSPF_AUTH_CRYPT))
	pass->alg = ospf_cfg_is_v2() ? ALG_MD5 : ALG_HMAC_SHA256;

      if (ospf_cfg_is_v3() && ip->autype && (pass->alg < ALG_HMAC))
	cf_error("Keyed hash algorithms are not allowed, use HMAC algorithms");
    }
  }
}

static void
ospf_area_finish(void)
{
  if ((this_area->areaid == 0) && (this_area->type != OPT_E))
    cf_error("Backbone area cannot be stub/NSSA");

  if (this_area->summary && (this_area->type == OPT_E))
    cf_error("Only stub/NSSA areas can use summary propagation");

  if (this_area->default_nssa && ((this_area->type != OPT_N) || ! this_area->summary))
    cf_error("Only NSSA areas with summary propagation can use NSSA default route");

  if ((this_area->default_cost & LSA_EXT3_EBIT) && ! this_area->default_nssa)
    cf_error("Only NSSA default route can use type 2 metric");
}

static void
ospf_proto_finish(void)
{
  struct ospf_config *cf = OSPF_CFG;
  struct ospf_area_config *ac;
  struct ospf_iface_patt *ic;

  /* Define default channel */
  if (! proto_cf_main_channel(this_proto))
  {
    uint net_type = this_proto->net_type = ospf_cfg_is_v2() ? NET_IP4 : NET_IP6;
    channel_config_new(NULL, net_label[net_type], net_type, this_proto);
  }

  /* Propagate global instance ID to interfaces */
  if (cf->instance_id_set)
  {
    WALK_LIST(ac, cf->area_list)
      WALK_LIST(ic, ac->patt_list)
	if (!ic->instance_id_set)
	{ ic->instance_id = cf->instance_id; ic->instance_id_set = 1; }

    WALK_LIST(ic, cf->vlink_list)
      if (!ic->instance_id_set)
      { ic->instance_id = cf->instance_id; ic->instance_id_set = 1; }
  }

  if (ospf_cfg_is_v3())
  {
    uint ipv4 = (this_proto->net_type == NET_IP4);
    uint base = (ipv4 ? 64 : 0) + (cf->af_mc ? 32 : 0);

    /* RFC 5838 - OSPFv3-AF */
    if (cf->af_ext)
    {
      /* RFC 5838 2.1 - instance IDs based on AFs */
      WALK_LIST(ac, cf->area_list)
	WALK_LIST(ic, ac->patt_list)
	{
	  if (!ic->instance_id_set)
	    ic->instance_id = base;
	  else if (ic->instance_id >= 128)
	    cf_warn("Instance ID %d from unassigned/private range", ic->instance_id);
	  else if ((ic->instance_id < base) || (ic->instance_id >= (base + 32)))
	    cf_error("Instance ID %d invalid for given channel type", ic->instance_id);
	}

      /* RFC 5838 2.8 - vlinks limited to IPv6 unicast */
      if ((ipv4 || cf->af_mc) && !EMPTY_LIST(cf->vlink_list))
	cf_error("Vlinks not supported in AFs other than IPv6 unicast");
    }
    else
    {
      if (ipv4 || cf->af_mc)
	cf_error("Different channel type");
    }
  }

  if (EMPTY_LIST(cf->area_list))
    cf_error("No configured areas in OSPF");

  int areano = 0;
  int backbone = 0;
  int nssa = 0;
  WALK_LIST(ac, cf->area_list)
  {
    areano++;
    if (ac->areaid == 0)
      backbone = 1;
    if (ac->type == OPT_N)
      nssa = 1;
  }

  cf->abr = areano > 1;

  /* Route export or NSSA translation (RFC 3101 3.1) */
  cf->asbr = (proto_cf_main_channel(this_proto)->out_filter != FILTER_REJECT) || (nssa && cf->abr);

  if (cf->abr && !backbone)
  {
    struct ospf_area_config *ac = cfg_allocz(sizeof(struct ospf_area_config));
    ac->type = OPT_E; /* Backbone is non-stub */
    add_head(&cf->area_list, NODE ac);
    init_list(&ac->patt_list);
    init_list(&ac->net_list);
    init_list(&ac->enet_list);
    init_list(&ac->stubnet_list);
  }

  if (!cf->abr && !EMPTY_LIST(cf->vlink_list))
    cf_error("Vlinks cannot be used on single area router");

  if (cf->asbr && (areano == 1) && (this_area->type == 0))
    cf_error("ASBR must be in non-stub area");
}

static inline void
ospf_check_defcost(int cost)
{
  if ((cost <= 0) || (cost >= LSINFINITY))
   cf_error("Default cost must be in range 1-%u", LSINFINITY-1);
}

static inline void
ospf_check_auth(void)
{
  if (ospf_cfg_is_v3())
    cf_error("Plaintext authentication not supported in OSPFv3");
}


#line 9 "proto/pipe/config.Y"
/* Headers from proto/pipe/config.Y */

#include "proto/pipe/pipe.h"

/* Defines from proto/pipe/config.Y */

#define PIPE_CFG ((struct pipe_config *) this_proto)

#line 10 "proto/radv/config.Y"
/* Headers from proto/radv/config.Y */

#include "proto/radv/radv.h"

/* Defines from proto/radv/config.Y */

#define RADV_CFG ((struct radv_config *) this_proto)
#define RADV_IFACE ((struct radv_iface_config *) this_ipatt)
#define RADV_PREFIX this_radv_prefix
#define RADV_RDNSS (&this_radv_rdnss)
#define RADV_DNSSL (&this_radv_dnssl)

static struct radv_prefix_config *this_radv_prefix;
static struct radv_rdnss_config this_radv_rdnss;
static struct radv_dnssl_config this_radv_dnssl;
static list radv_dns_list;	/* Used by radv_rdnss and radv_dnssl */
static u8 radv_mult_val;	/* Used by radv_mult for second return value */

static inline void
radv_add_to_custom_list(list *l, int type, const struct adata *payload)
{
  if (type < 0 || type > 255) cf_error("RA cusom type must be in range 0-255");
  struct radv_custom_config *cf = cfg_allocz(sizeof(struct radv_custom_config));
  add_tail(l, NODE cf);
  cf->type = type;
  cf->payload = payload;
}

#line 12 "proto/rip/config.Y"
/* Headers from proto/rip/config.Y */

#include "proto/rip/rip.h"
#include "nest/iface.h"

/* Defines from proto/rip/config.Y */

#define RIP_CFG ((struct rip_config *) this_proto)
#define RIP_IFACE ((struct rip_iface_config *) this_ipatt)

static inline int rip_cfg_is_v2(void) { return RIP_CFG->rip2; }
static inline int rip_cfg_is_ng(void) { return ! RIP_CFG->rip2; }

static inline void
rip_check_auth(void)
{
  if (rip_cfg_is_ng())
    cf_error("Authentication not supported in RIPng");
}


#line 9 "proto/rpki/config.Y"
/* Headers from proto/rpki/config.Y */

#include "proto/rpki/rpki.h"

/* Defines from proto/rpki/config.Y */

#define RPKI_CFG ((struct rpki_config *) this_proto)
#define RPKI_TR_TCP_CFG ((struct rpki_tr_tcp_config *) RPKI_CFG->tr_config.spec)
#define RPKI_TR_SSH_CFG ((struct rpki_tr_ssh_config *) RPKI_CFG->tr_config.spec)

static void
rpki_check_unused_hostname(void)
{
  if (RPKI_CFG->hostname != NULL)
    cf_error("Only one cache server per protocol allowed");
}

static void
rpki_check_unused_transport(void)
{
  if (RPKI_CFG->tr_config.spec != NULL)
    cf_error("At the most one transport per protocol allowed");
}

#line 9 "proto/static/config.Y"
/* Headers from proto/static/config.Y */

#include "proto/static/static.h"

/* Defines from proto/static/config.Y */

#define STATIC_CFG ((struct static_config *) this_proto)
static struct static_route *this_srt, *this_snh;
static struct f_inst *this_srt_cmds, *this_srt_last_cmd;
static uint this_srt_aspa_max;

static struct static_route *
static_nexthop_new(void)
{
  struct static_route *nh = this_srt;

  if (this_snh)
  {
    /* Additional next hop */
    nh = cfg_allocz(sizeof(struct static_route));
    nh->net = this_srt->net;
    this_snh->mp_next = nh;
  }

  nh->dest = RTD_UNICAST;
  nh->mp_head = this_srt;
  return nh;
};

static void
static_route_finish(void)
{
  if (net_type_match(this_srt->net, NB_DEST) == !this_srt->dest)
    cf_error("Unexpected or missing nexthop/type");

  this_srt->cmds = f_linearize(this_srt_cmds, 0);
}

#line 10 "proto/mrt/config.Y"
/* Headers from proto/mrt/config.Y */

#include "proto/mrt/mrt.h"

/* Defines from proto/mrt/config.Y */

#define MRT_CFG ((struct mrt_config *) this_proto)

#line 9 "proto/bmp/config.Y"
/* Headers from proto/bmp/config.Y */

#include "proto/bmp/bmp.h"

/* Defines from proto/bmp/config.Y */

#define BMP_CFG ((struct bmp_config *) this_proto)

#line 9 "sysdep/linux/netlink.Y"
/* Headers from sysdep/linux/netlink.Y */

#line 9 "sysdep/unix/config.Y"
/* Headers from sysdep/unix/config.Y */

#include "sysdep/unix/unix.h"
#include <stdio.h>

/* Defines from sysdep/unix/config.Y */

static struct log_config *this_log;
static struct cli_config *this_cli_config;
static struct thread_group_config *this_thread_group;

#line 9 "sysdep/unix/krt.Y"
/* Headers from sysdep/unix/krt.Y */

#include "sysdep/unix/krt.h"

/* Defines from sysdep/unix/krt.Y */

#define THIS_KRT ((struct krt_config *) this_proto)
#define THIS_KIF ((struct kif_config *) this_proto)
#define KIF_IFACE ((struct kif_iface_config *) this_ipatt)

static void
kif_set_preferred(ip_addr ip)
{
  if (ipa_is_ip4(ip))
    KIF_IFACE->pref_v4 = ip;
  else if (!ipa_is_link_local(ip))
    KIF_IFACE->pref_v6 = ip;
  else
    KIF_IFACE->pref_ll = ip;
}

#line 57 "conf/gen_parser.m4"

#line 1118 "obj/conf/cf-parse.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "cf-parse.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_QUIT = 3,                       /* QUIT  */
  YYSYMBOL_EXIT = 4,                       /* EXIT  */
  YYSYMBOL_HELP = 5,                       /* HELP  */
  YYSYMBOL_END = 6,                        /* END  */
  YYSYMBOL_CLI_MARKER = 7,                 /* CLI_MARKER  */
  YYSYMBOL_INVALID_TOKEN = 8,              /* INVALID_TOKEN  */
  YYSYMBOL_ELSECOL = 9,                    /* ELSECOL  */
  YYSYMBOL_DDOT = 10,                      /* DDOT  */
  YYSYMBOL_GEQ = 11,                       /* GEQ  */
  YYSYMBOL_LEQ = 12,                       /* LEQ  */
  YYSYMBOL_NEQ = 13,                       /* NEQ  */
  YYSYMBOL_AND = 14,                       /* AND  */
  YYSYMBOL_OR = 15,                        /* OR  */
  YYSYMBOL_IMP = 16,                       /* IMP  */
  YYSYMBOL_PP = 17,                        /* PP  */
  YYSYMBOL_PO = 18,                        /* PO  */
  YYSYMBOL_PC = 19,                        /* PC  */
  YYSYMBOL_NUM = 20,                       /* NUM  */
  YYSYMBOL_ENUM_TOKEN = 21,                /* ENUM_TOKEN  */
  YYSYMBOL_IP4 = 22,                       /* IP4  */
  YYSYMBOL_IP6 = 23,                       /* IP6  */
  YYSYMBOL_VPN_RD = 24,                    /* VPN_RD  */
  YYSYMBOL_CF_SYM_KNOWN = 25,              /* CF_SYM_KNOWN  */
  YYSYMBOL_CF_SYM_UNDEFINED = 26,          /* CF_SYM_UNDEFINED  */
  YYSYMBOL_CF_SYM_METHOD_BARE = 27,        /* CF_SYM_METHOD_BARE  */
  YYSYMBOL_CF_SYM_METHOD_ARGS = 28,        /* CF_SYM_METHOD_ARGS  */
  YYSYMBOL_TEXT = 29,                      /* TEXT  */
  YYSYMBOL_BYTETEXT = 30,                  /* BYTETEXT  */
  YYSYMBOL_PREFIX_DUMMY = 31,              /* PREFIX_DUMMY  */
  YYSYMBOL_32_ = 32,                       /* '='  */
  YYSYMBOL_33_ = 33,                       /* '<'  */
  YYSYMBOL_34_ = 34,                       /* '>'  */
  YYSYMBOL_35_ = 35,                       /* '~'  */
  YYSYMBOL_NMA = 36,                       /* NMA  */
  YYSYMBOL_37_ = 37,                       /* '|'  */
  YYSYMBOL_38_ = 38,                       /* '&'  */
  YYSYMBOL_39_ = 39,                       /* '+'  */
  YYSYMBOL_40_ = 40,                       /* '-'  */
  YYSYMBOL_41_ = 41,                       /* '*'  */
  YYSYMBOL_42_ = 42,                       /* '/'  */
  YYSYMBOL_43_ = 43,                       /* '%'  */
  YYSYMBOL_44_ = 44,                       /* '!'  */
  YYSYMBOL_45_ = 45,                       /* '.'  */
  YYSYMBOL_DEFINE = 46,                    /* DEFINE  */
  YYSYMBOL_ON = 47,                        /* ON  */
  YYSYMBOL_OFF = 48,                       /* OFF  */
  YYSYMBOL_YES = 49,                       /* YES  */
  YYSYMBOL_NO = 50,                        /* NO  */
  YYSYMBOL_S = 51,                         /* S  */
  YYSYMBOL_MS = 52,                        /* MS  */
  YYSYMBOL_US = 53,                        /* US  */
  YYSYMBOL_PORT = 54,                      /* PORT  */
  YYSYMBOL_VPN = 55,                       /* VPN  */
  YYSYMBOL_MPLS = 56,                      /* MPLS  */
  YYSYMBOL_FROM = 57,                      /* FROM  */
  YYSYMBOL_MAX = 58,                       /* MAX  */
  YYSYMBOL_AS = 59,                        /* AS  */
  YYSYMBOL_60_ = 60,                       /* ';'  */
  YYSYMBOL_61_ = 61,                       /* '('  */
  YYSYMBOL_62_ = 62,                       /* ')'  */
  YYSYMBOL_FLOW4 = 63,                     /* FLOW4  */
  YYSYMBOL_FLOW6 = 64,                     /* FLOW6  */
  YYSYMBOL_DST = 65,                       /* DST  */
  YYSYMBOL_SRC = 66,                       /* SRC  */
  YYSYMBOL_PROTO = 67,                     /* PROTO  */
  YYSYMBOL_NEXT = 68,                      /* NEXT  */
  YYSYMBOL_HEADER = 69,                    /* HEADER  */
  YYSYMBOL_DPORT = 70,                     /* DPORT  */
  YYSYMBOL_SPORT = 71,                     /* SPORT  */
  YYSYMBOL_ICMP = 72,                      /* ICMP  */
  YYSYMBOL_TYPE = 73,                      /* TYPE  */
  YYSYMBOL_CODE = 74,                      /* CODE  */
  YYSYMBOL_TCP = 75,                       /* TCP  */
  YYSYMBOL_FLAGS = 76,                     /* FLAGS  */
  YYSYMBOL_LENGTH = 77,                    /* LENGTH  */
  YYSYMBOL_DSCP = 78,                      /* DSCP  */
  YYSYMBOL_DONT_FRAGMENT = 79,             /* DONT_FRAGMENT  */
  YYSYMBOL_IS_FRAGMENT = 80,               /* IS_FRAGMENT  */
  YYSYMBOL_FIRST_FRAGMENT = 81,            /* FIRST_FRAGMENT  */
  YYSYMBOL_LAST_FRAGMENT = 82,             /* LAST_FRAGMENT  */
  YYSYMBOL_FRAGMENT = 83,                  /* FRAGMENT  */
  YYSYMBOL_LABEL = 84,                     /* LABEL  */
  YYSYMBOL_OFFSET = 85,                    /* OFFSET  */
  YYSYMBOL_86_ = 86,                       /* ','  */
  YYSYMBOL_87_ = 87,                       /* '{'  */
  YYSYMBOL_88_ = 88,                       /* '}'  */
  YYSYMBOL_FUNCTION = 89,                  /* FUNCTION  */
  YYSYMBOL_PRINT = 90,                     /* PRINT  */
  YYSYMBOL_PRINTN = 91,                    /* PRINTN  */
  YYSYMBOL_UNSET = 92,                     /* UNSET  */
  YYSYMBOL_RETURN = 93,                    /* RETURN  */
  YYSYMBOL_ACCEPT = 94,                    /* ACCEPT  */
  YYSYMBOL_REJECT = 95,                    /* REJECT  */
  YYSYMBOL_ERROR = 96,                     /* ERROR  */
  YYSYMBOL_INT = 97,                       /* INT  */
  YYSYMBOL_BOOL = 98,                      /* BOOL  */
  YYSYMBOL_IP = 99,                        /* IP  */
  YYSYMBOL_PREFIX = 100,                   /* PREFIX  */
  YYSYMBOL_RD = 101,                       /* RD  */
  YYSYMBOL_PAIR = 102,                     /* PAIR  */
  YYSYMBOL_QUAD = 103,                     /* QUAD  */
  YYSYMBOL_EC = 104,                       /* EC  */
  YYSYMBOL_LC = 105,                       /* LC  */
  YYSYMBOL_ENUM = 106,                     /* ENUM  */
  YYSYMBOL_SET = 107,                      /* SET  */
  YYSYMBOL_STRING = 108,                   /* STRING  */
  YYSYMBOL_BYTESTRING = 109,               /* BYTESTRING  */
  YYSYMBOL_BGPMASK = 110,                  /* BGPMASK  */
  YYSYMBOL_BGPPATH = 111,                  /* BGPPATH  */
  YYSYMBOL_CLIST = 112,                    /* CLIST  */
  YYSYMBOL_ECLIST = 113,                   /* ECLIST  */
  YYSYMBOL_LCLIST = 114,                   /* LCLIST  */
  YYSYMBOL_IF = 115,                       /* IF  */
  YYSYMBOL_THEN = 116,                     /* THEN  */
  YYSYMBOL_ELSE = 117,                     /* ELSE  */
  YYSYMBOL_CASE = 118,                     /* CASE  */
  YYSYMBOL_FOR = 119,                      /* FOR  */
  YYSYMBOL_IN = 120,                       /* IN  */
  YYSYMBOL_DO = 121,                       /* DO  */
  YYSYMBOL_TRUE = 122,                     /* TRUE  */
  YYSYMBOL_FALSE = 123,                    /* FALSE  */
  YYSYMBOL_RT = 124,                       /* RT  */
  YYSYMBOL_RO = 125,                       /* RO  */
  YYSYMBOL_UNKNOWN = 126,                  /* UNKNOWN  */
  YYSYMBOL_GENERIC = 127,                  /* GENERIC  */
  YYSYMBOL_GW = 128,                       /* GW  */
  YYSYMBOL_NET = 129,                      /* NET  */
  YYSYMBOL_SCOPE = 130,                    /* SCOPE  */
  YYSYMBOL_DEST = 131,                     /* DEST  */
  YYSYMBOL_IFNAME = 132,                   /* IFNAME  */
  YYSYMBOL_IFINDEX = 133,                  /* IFINDEX  */
  YYSYMBOL_WEIGHT = 134,                   /* WEIGHT  */
  YYSYMBOL_GW_MPLS = 135,                  /* GW_MPLS  */
  YYSYMBOL_ONLINK = 136,                   /* ONLINK  */
  YYSYMBOL_ROA_CHECK = 137,                /* ROA_CHECK  */
  YYSYMBOL_ASPA_CHECK = 138,               /* ASPA_CHECK  */
  YYSYMBOL_DEFINED = 139,                  /* DEFINED  */
  YYSYMBOL_ADD = 140,                      /* ADD  */
  YYSYMBOL_DELETE = 141,                   /* DELETE  */
  YYSYMBOL_RESET = 142,                    /* RESET  */
  YYSYMBOL_PREPEND = 143,                  /* PREPEND  */
  YYSYMBOL_APPEND = 144,                   /* APPEND  */
  YYSYMBOL_EMPTY = 145,                    /* EMPTY  */
  YYSYMBOL_FILTER = 146,                   /* FILTER  */
  YYSYMBOL_WHERE = 147,                    /* WHERE  */
  YYSYMBOL_EVAL = 148,                     /* EVAL  */
  YYSYMBOL_ATTRIBUTE = 149,                /* ATTRIBUTE  */
  YYSYMBOL_FROM_HEX = 150,                 /* FROM_HEX  */
  YYSYMBOL_BT_ASSERT = 151,                /* BT_ASSERT  */
  YYSYMBOL_BT_TEST_SUITE = 152,            /* BT_TEST_SUITE  */
  YYSYMBOL_BT_CHECK_ASSIGN = 153,          /* BT_CHECK_ASSIGN  */
  YYSYMBOL_BT_TEST_SAME = 154,             /* BT_TEST_SAME  */
  YYSYMBOL_FORMAT = 155,                   /* FORMAT  */
  YYSYMBOL_STACKS = 156,                   /* STACKS  */
  YYSYMBOL_157_ = 157,                     /* ':'  */
  YYSYMBOL_158_ = 158,                     /* '['  */
  YYSYMBOL_159_ = 159,                     /* ']'  */
  YYSYMBOL_160_ = 160,                     /* '?'  */
  YYSYMBOL_ROUTER = 161,                   /* ROUTER  */
  YYSYMBOL_ID = 162,                       /* ID  */
  YYSYMBOL_HOSTNAME = 163,                 /* HOSTNAME  */
  YYSYMBOL_PROTOCOL = 164,                 /* PROTOCOL  */
  YYSYMBOL_TEMPLATE = 165,                 /* TEMPLATE  */
  YYSYMBOL_PREFERENCE = 166,               /* PREFERENCE  */
  YYSYMBOL_DISABLED = 167,                 /* DISABLED  */
  YYSYMBOL_DEBUG = 168,                    /* DEBUG  */
  YYSYMBOL_ALL = 169,                      /* ALL  */
  YYSYMBOL_DIRECT = 170,                   /* DIRECT  */
  YYSYMBOL_PIPE = 171,                     /* PIPE  */
  YYSYMBOL_INTERFACE = 172,                /* INTERFACE  */
  YYSYMBOL_IMPORT = 173,                   /* IMPORT  */
  YYSYMBOL_EXPORT = 174,                   /* EXPORT  */
  YYSYMBOL_NONE = 175,                     /* NONE  */
  YYSYMBOL_VRF = 176,                      /* VRF  */
  YYSYMBOL_DEFAULT = 177,                  /* DEFAULT  */
  YYSYMBOL_TABLE = 178,                    /* TABLE  */
  YYSYMBOL_TABLES = 179,                   /* TABLES  */
  YYSYMBOL_STATES = 180,                   /* STATES  */
  YYSYMBOL_ROUTES = 181,                   /* ROUTES  */
  YYSYMBOL_FILTERS = 182,                  /* FILTERS  */
  YYSYMBOL_IPV4 = 183,                     /* IPV4  */
  YYSYMBOL_IPV6 = 184,                     /* IPV6  */
  YYSYMBOL_VPN4 = 185,                     /* VPN4  */
  YYSYMBOL_VPN6 = 186,                     /* VPN6  */
  YYSYMBOL_ROA4 = 187,                     /* ROA4  */
  YYSYMBOL_ROA6 = 188,                     /* ROA6  */
  YYSYMBOL_SADR = 189,                     /* SADR  */
  YYSYMBOL_ASPA = 190,                     /* ASPA  */
  YYSYMBOL_RECEIVE = 191,                  /* RECEIVE  */
  YYSYMBOL_LIMIT = 192,                    /* LIMIT  */
  YYSYMBOL_ACTION = 193,                   /* ACTION  */
  YYSYMBOL_WARN = 194,                     /* WARN  */
  YYSYMBOL_BLOCK = 195,                    /* BLOCK  */
  YYSYMBOL_RESTART = 196,                  /* RESTART  */
  YYSYMBOL_DISABLE = 197,                  /* DISABLE  */
  YYSYMBOL_KEEP = 198,                     /* KEEP  */
  YYSYMBOL_FILTERED = 199,                 /* FILTERED  */
  YYSYMBOL_RPKI = 200,                     /* RPKI  */
  YYSYMBOL_PASSWORD = 201,                 /* PASSWORD  */
  YYSYMBOL_KEY = 202,                      /* KEY  */
  YYSYMBOL_PASSIVE = 203,                  /* PASSIVE  */
  YYSYMBOL_TO = 204,                       /* TO  */
  YYSYMBOL_EVENTS = 205,                   /* EVENTS  */
  YYSYMBOL_PACKETS = 206,                  /* PACKETS  */
  YYSYMBOL_PROTOCOLS = 207,                /* PROTOCOLS  */
  YYSYMBOL_CHANNELS = 208,                 /* CHANNELS  */
  YYSYMBOL_INTERFACES = 209,               /* INTERFACES  */
  YYSYMBOL_ALGORITHM = 210,                /* ALGORITHM  */
  YYSYMBOL_KEYED = 211,                    /* KEYED  */
  YYSYMBOL_HMAC = 212,                     /* HMAC  */
  YYSYMBOL_MD5 = 213,                      /* MD5  */
  YYSYMBOL_SHA1 = 214,                     /* SHA1  */
  YYSYMBOL_SHA256 = 215,                   /* SHA256  */
  YYSYMBOL_SHA384 = 216,                   /* SHA384  */
  YYSYMBOL_SHA512 = 217,                   /* SHA512  */
  YYSYMBOL_BLAKE2S128 = 218,               /* BLAKE2S128  */
  YYSYMBOL_BLAKE2S256 = 219,               /* BLAKE2S256  */
  YYSYMBOL_BLAKE2B256 = 220,               /* BLAKE2B256  */
  YYSYMBOL_BLAKE2B512 = 221,               /* BLAKE2B512  */
  YYSYMBOL_PRIMARY = 222,                  /* PRIMARY  */
  YYSYMBOL_STATS = 223,                    /* STATS  */
  YYSYMBOL_COUNT = 224,                    /* COUNT  */
  YYSYMBOL_COMMANDS = 225,                 /* COMMANDS  */
  YYSYMBOL_PREEXPORT = 226,                /* PREEXPORT  */
  YYSYMBOL_NOEXPORT = 227,                 /* NOEXPORT  */
  YYSYMBOL_EXPORTED = 228,                 /* EXPORTED  */
  YYSYMBOL_GENERATE = 229,                 /* GENERATE  */
  YYSYMBOL_BGP = 230,                      /* BGP  */
  YYSYMBOL_PASSWORDS = 231,                /* PASSWORDS  */
  YYSYMBOL_DESCRIPTION = 232,              /* DESCRIPTION  */
  YYSYMBOL_RELOAD = 233,                   /* RELOAD  */
  YYSYMBOL_OUT = 234,                      /* OUT  */
  YYSYMBOL_MRTDUMP = 235,                  /* MRTDUMP  */
  YYSYMBOL_MESSAGES = 236,                 /* MESSAGES  */
  YYSYMBOL_RESTRICT = 237,                 /* RESTRICT  */
  YYSYMBOL_MEMORY = 238,                   /* MEMORY  */
  YYSYMBOL_CLASS = 239,                    /* CLASS  */
  YYSYMBOL_PARTIAL = 240,                  /* PARTIAL  */
  YYSYMBOL_TIMEFORMAT = 241,               /* TIMEFORMAT  */
  YYSYMBOL_ISO = 242,                      /* ISO  */
  YYSYMBOL_SHORT = 243,                    /* SHORT  */
  YYSYMBOL_LONG = 244,                     /* LONG  */
  YYSYMBOL_ROUTE = 245,                    /* ROUTE  */
  YYSYMBOL_BASE = 246,                     /* BASE  */
  YYSYMBOL_LOG = 247,                      /* LOG  */
  YYSYMBOL_GRACEFUL = 248,                 /* GRACEFUL  */
  YYSYMBOL_WAIT = 249,                     /* WAIT  */
  YYSYMBOL_CHECK = 250,                    /* CHECK  */
  YYSYMBOL_LINK = 251,                     /* LINK  */
  YYSYMBOL_CORK = 252,                     /* CORK  */
  YYSYMBOL_SORTED = 253,                   /* SORTED  */
  YYSYMBOL_TRIE = 254,                     /* TRIE  */
  YYSYMBOL_MIN = 255,                      /* MIN  */
  YYSYMBOL_ROA = 256,                      /* ROA  */
  YYSYMBOL_DIGEST = 257,                   /* DIGEST  */
  YYSYMBOL_REFRESH = 258,                  /* REFRESH  */
  YYSYMBOL_SETTLE = 259,                   /* SETTLE  */
  YYSYMBOL_TIME = 260,                     /* TIME  */
  YYSYMBOL_GC = 261,                       /* GC  */
  YYSYMBOL_THRESHOLD = 262,                /* THRESHOLD  */
  YYSYMBOL_PERIOD = 263,                   /* PERIOD  */
  YYSYMBOL_MPLS_LABEL = 264,               /* MPLS_LABEL  */
  YYSYMBOL_MPLS_POLICY = 265,              /* MPLS_POLICY  */
  YYSYMBOL_MPLS_CLASS = 266,               /* MPLS_CLASS  */
  YYSYMBOL_ASPA_PROVIDERS = 267,           /* ASPA_PROVIDERS  */
  YYSYMBOL_IPV4_MC = 268,                  /* IPV4_MC  */
  YYSYMBOL_IPV4_MPLS = 269,                /* IPV4_MPLS  */
  YYSYMBOL_IPV6_MC = 270,                  /* IPV6_MC  */
  YYSYMBOL_IPV6_MPLS = 271,                /* IPV6_MPLS  */
  YYSYMBOL_IPV6_SADR = 272,                /* IPV6_SADR  */
  YYSYMBOL_VPN4_MC = 273,                  /* VPN4_MC  */
  YYSYMBOL_VPN4_MPLS = 274,                /* VPN4_MPLS  */
  YYSYMBOL_VPN6_MC = 275,                  /* VPN6_MC  */
  YYSYMBOL_VPN6_MPLS = 276,                /* VPN6_MPLS  */
  YYSYMBOL_PRI = 277,                      /* PRI  */
  YYSYMBOL_SEC = 278,                      /* SEC  */
  YYSYMBOL_NET_TYPE = 279,                 /* NET_TYPE  */
  YYSYMBOL_RTS = 280,                      /* RTS  */
  YYSYMBOL_RTD = 281,                      /* RTD  */
  YYSYMBOL_AF = 282,                       /* AF  */
  YYSYMBOL_SHOW = 283,                     /* SHOW  */
  YYSYMBOL_STATUS = 284,                   /* STATUS  */
  YYSYMBOL_SUMMARY = 285,                  /* SUMMARY  */
  YYSYMBOL_SYMBOLS = 286,                  /* SYMBOLS  */
  YYSYMBOL_DUMP = 287,                     /* DUMP  */
  YYSYMBOL_RESOURCES = 288,                /* RESOURCES  */
  YYSYMBOL_SOCKETS = 289,                  /* SOCKETS  */
  YYSYMBOL_AO = 290,                       /* AO  */
  YYSYMBOL_KEYS = 291,                     /* KEYS  */
  YYSYMBOL_NEIGHBORS = 292,                /* NEIGHBORS  */
  YYSYMBOL_ATTRIBUTES = 293,               /* ATTRIBUTES  */
  YYSYMBOL_ENABLE = 294,                   /* ENABLE  */
  YYSYMBOL_DOMAIN = 295,                   /* DOMAIN  */
  YYSYMBOL_RANGE = 296,                    /* RANGE  */
  YYSYMBOL_STATIC = 297,                   /* STATIC  */
  YYSYMBOL_DYNAMIC = 298,                  /* DYNAMIC  */
  YYSYMBOL_START = 299,                    /* START  */
  YYSYMBOL_POLICY = 300,                   /* POLICY  */
  YYSYMBOL_AGGREGATE = 301,                /* AGGREGATE  */
  YYSYMBOL_RANGES = 302,                   /* RANGES  */
  YYSYMBOL_AGGREGATOR = 303,               /* AGGREGATOR  */
  YYSYMBOL_PEER = 304,                     /* PEER  */
  YYSYMBOL_MERGE = 305,                    /* MERGE  */
  YYSYMBOL_BY = 306,                       /* BY  */
  YYSYMBOL_BABEL = 307,                    /* BABEL  */
  YYSYMBOL_METRIC = 308,                   /* METRIC  */
  YYSYMBOL_RXCOST = 309,                   /* RXCOST  */
  YYSYMBOL_HELLO = 310,                    /* HELLO  */
  YYSYMBOL_UPDATE = 311,                   /* UPDATE  */
  YYSYMBOL_WIRED = 312,                    /* WIRED  */
  YYSYMBOL_WIRELESS = 313,                 /* WIRELESS  */
  YYSYMBOL_BUFFER = 314,                   /* BUFFER  */
  YYSYMBOL_PRIORITY = 315,                 /* PRIORITY  */
  YYSYMBOL_HOP = 316,                      /* HOP  */
  YYSYMBOL_ENTRIES = 317,                  /* ENTRIES  */
  YYSYMBOL_RANDOMIZE = 318,                /* RANDOMIZE  */
  YYSYMBOL_MAC = 319,                      /* MAC  */
  YYSYMBOL_PERMISSIVE = 320,               /* PERMISSIVE  */
  YYSYMBOL_EXTENDED = 321,                 /* EXTENDED  */
  YYSYMBOL_TUNNEL = 322,                   /* TUNNEL  */
  YYSYMBOL_RTT = 323,                      /* RTT  */
  YYSYMBOL_DECAY = 324,                    /* DECAY  */
  YYSYMBOL_SEND = 325,                     /* SEND  */
  YYSYMBOL_TIMESTAMPS = 326,               /* TIMESTAMPS  */
  YYSYMBOL_COST = 327,                     /* COST  */
  YYSYMBOL_DELAY = 328,                    /* DELAY  */
  YYSYMBOL_PREFER = 329,                   /* PREFER  */
  YYSYMBOL_NATIVE = 330,                   /* NATIVE  */
  YYSYMBOL_BFD = 331,                      /* BFD  */
  YYSYMBOL_IDLE = 332,                     /* IDLE  */
  YYSYMBOL_RX = 333,                       /* RX  */
  YYSYMBOL_TX = 334,                       /* TX  */
  YYSYMBOL_INTERVAL = 335,                 /* INTERVAL  */
  YYSYMBOL_MULTIPLIER = 336,               /* MULTIPLIER  */
  YYSYMBOL_ADDRESS = 337,                  /* ADDRESS  */
  YYSYMBOL_EXPRESS = 338,                  /* EXPRESS  */
  YYSYMBOL_MULTIHOP = 339,                 /* MULTIHOP  */
  YYSYMBOL_NEIGHBOR = 340,                 /* NEIGHBOR  */
  YYSYMBOL_DEV = 341,                      /* DEV  */
  YYSYMBOL_LOCAL = 342,                    /* LOCAL  */
  YYSYMBOL_AUTHENTICATION = 343,           /* AUTHENTICATION  */
  YYSYMBOL_SIMPLE = 344,                   /* SIMPLE  */
  YYSYMBOL_METICULOUS = 345,               /* METICULOUS  */
  YYSYMBOL_STRICT = 346,                   /* STRICT  */
  YYSYMBOL_BIND = 347,                     /* BIND  */
  YYSYMBOL_ZERO = 348,                     /* ZERO  */
  YYSYMBOL_UDP6 = 349,                     /* UDP6  */
  YYSYMBOL_CHECKSUM = 350,                 /* CHECKSUM  */
  YYSYMBOL_SESSIONS = 351,                 /* SESSIONS  */
  YYSYMBOL_HOLD = 352,                     /* HOLD  */
  YYSYMBOL_CONNECT = 353,                  /* CONNECT  */
  YYSYMBOL_RETRY = 354,                    /* RETRY  */
  YYSYMBOL_KEEPALIVE = 355,                /* KEEPALIVE  */
  YYSYMBOL_STARTUP = 356,                  /* STARTUP  */
  YYSYMBOL_VIA = 357,                      /* VIA  */
  YYSYMBOL_SELF = 358,                     /* SELF  */
  YYSYMBOL_PATH = 359,                     /* PATH  */
  YYSYMBOL_FORGET = 360,                   /* FORGET  */
  YYSYMBOL_AFTER = 361,                    /* AFTER  */
  YYSYMBOL_BGP_LOCAL_PREF = 362,           /* BGP_LOCAL_PREF  */
  YYSYMBOL_BGP_MED = 363,                  /* BGP_MED  */
  YYSYMBOL_SOURCE = 364,                   /* SOURCE  */
  YYSYMBOL_RR = 365,                       /* RR  */
  YYSYMBOL_RS = 366,                       /* RS  */
  YYSYMBOL_CLIENT = 367,                   /* CLIENT  */
  YYSYMBOL_CLUSTER = 368,                  /* CLUSTER  */
  YYSYMBOL_AS4 = 369,                      /* AS4  */
  YYSYMBOL_ADVERTISE = 370,                /* ADVERTISE  */
  YYSYMBOL_CAPABILITIES = 371,             /* CAPABILITIES  */
  YYSYMBOL_OLDER = 372,                    /* OLDER  */
  YYSYMBOL_MISSING = 373,                  /* MISSING  */
  YYSYMBOL_LLADDR = 374,                   /* LLADDR  */
  YYSYMBOL_DROP = 375,                     /* DROP  */
  YYSYMBOL_IGNORE = 376,                   /* IGNORE  */
  YYSYMBOL_ENHANCED = 377,                 /* ENHANCED  */
  YYSYMBOL_INTERPRET = 378,                /* INTERPRET  */
  YYSYMBOL_COMMUNITIES = 379,              /* COMMUNITIES  */
  YYSYMBOL_IGP = 380,                      /* IGP  */
  YYSYMBOL_GATEWAY = 381,                  /* GATEWAY  */
  YYSYMBOL_RECURSIVE = 382,                /* RECURSIVE  */
  YYSYMBOL_MED = 383,                      /* MED  */
  YYSYMBOL_TTL = 384,                      /* TTL  */
  YYSYMBOL_SECURITY = 385,                 /* SECURITY  */
  YYSYMBOL_DETERMINISTIC = 386,            /* DETERMINISTIC  */
  YYSYMBOL_SECONDARY = 387,                /* SECONDARY  */
  YYSYMBOL_ALLOW = 388,                    /* ALLOW  */
  YYSYMBOL_PATHS = 389,                    /* PATHS  */
  YYSYMBOL_AWARE = 390,                    /* AWARE  */
  YYSYMBOL_SETKEY = 391,                   /* SETKEY  */
  YYSYMBOL_CONFEDERATION = 392,            /* CONFEDERATION  */
  YYSYMBOL_MEMBER = 393,                   /* MEMBER  */
  YYSYMBOL_MULTICAST = 394,                /* MULTICAST  */
  YYSYMBOL_LIVED = 395,                    /* LIVED  */
  YYSYMBOL_STALE = 396,                    /* STALE  */
  YYSYMBOL_IBGP = 397,                     /* IBGP  */
  YYSYMBOL_EBGP = 398,                     /* EBGP  */
  YYSYMBOL_MANDATORY = 399,                /* MANDATORY  */
  YYSYMBOL_INTERNAL = 400,                 /* INTERNAL  */
  YYSYMBOL_EXTERNAL = 401,                 /* EXTERNAL  */
  YYSYMBOL_SETS = 402,                     /* SETS  */
  YYSYMBOL_NAME = 403,                     /* NAME  */
  YYSYMBOL_DIGITS = 404,                   /* DIGITS  */
  YYSYMBOL_AIGP = 405,                     /* AIGP  */
  YYSYMBOL_ORIGINATE = 406,                /* ORIGINATE  */
  YYSYMBOL_ENFORCE = 407,                  /* ENFORCE  */
  YYSYMBOL_FIRST = 408,                    /* FIRST  */
  YYSYMBOL_FREE = 409,                     /* FREE  */
  YYSYMBOL_VALIDATE = 410,                 /* VALIDATE  */
  YYSYMBOL_ROLE = 411,                     /* ROLE  */
  YYSYMBOL_ROLES = 412,                    /* ROLES  */
  YYSYMBOL_PROVIDER = 413,                 /* PROVIDER  */
  YYSYMBOL_CUSTOMER = 414,                 /* CUSTOMER  */
  YYSYMBOL_RS_SERVER = 415,                /* RS_SERVER  */
  YYSYMBOL_RS_CLIENT = 416,                /* RS_CLIENT  */
  YYSYMBOL_REQUIRE = 417,                  /* REQUIRE  */
  YYSYMBOL_BGP_OTC = 418,                  /* BGP_OTC  */
  YYSYMBOL_GLOBAL = 419,                   /* GLOBAL  */
  YYSYMBOL_RECV = 420,                     /* RECV  */
  YYSYMBOL_SIZE = 421,                     /* SIZE  */
  YYSYMBOL_WARNING = 422,                  /* WARNING  */
  YYSYMBOL_SINGLE = 423,                   /* SINGLE  */
  YYSYMBOL_DOUBLE = 424,                   /* DOUBLE  */
  YYSYMBOL_SECRET = 425,                   /* SECRET  */
  YYSYMBOL_DEPRECATED = 426,               /* DEPRECATED  */
  YYSYMBOL_PREFERRED = 427,                /* PREFERRED  */
  YYSYMBOL_CMAC = 428,                     /* CMAC  */
  YYSYMBOL_AES128 = 429,                   /* AES128  */
  YYSYMBOL_BGP_ORIGIN = 430,               /* BGP_ORIGIN  */
  YYSYMBOL_CEASE = 431,                    /* CEASE  */
  YYSYMBOL_HIT = 432,                      /* HIT  */
  YYSYMBOL_ADMINISTRATIVE = 433,           /* ADMINISTRATIVE  */
  YYSYMBOL_SHUTDOWN = 434,                 /* SHUTDOWN  */
  YYSYMBOL_CONFIGURATION = 435,            /* CONFIGURATION  */
  YYSYMBOL_CHANGE = 436,                   /* CHANGE  */
  YYSYMBOL_DECONFIGURED = 437,             /* DECONFIGURED  */
  YYSYMBOL_CONNECTION = 438,               /* CONNECTION  */
  YYSYMBOL_REJECTED = 439,                 /* REJECTED  */
  YYSYMBOL_COLLISION = 440,                /* COLLISION  */
  YYSYMBOL_OF = 441,                       /* OF  */
  YYSYMBOL_ASPA_CHECK_UPSTREAM = 442,      /* ASPA_CHECK_UPSTREAM  */
  YYSYMBOL_ASPA_CHECK_DOWNSTREAM = 443,    /* ASPA_CHECK_DOWNSTREAM  */
  YYSYMBOL_BMP = 444,                      /* BMP  */
  YYSYMBOL_STATION = 445,                  /* STATION  */
  YYSYMBOL_SYSTEM = 446,                   /* SYSTEM  */
  YYSYMBOL_MONITORING = 447,               /* MONITORING  */
  YYSYMBOL_RIB = 448,                      /* RIB  */
  YYSYMBOL_PRE_POLICY = 449,               /* PRE_POLICY  */
  YYSYMBOL_POST_POLICY = 450,              /* POST_POLICY  */
  YYSYMBOL_L3VPN = 451,                    /* L3VPN  */
  YYSYMBOL_TARGET = 452,                   /* TARGET  */
  YYSYMBOL_DISTINGUISHER = 453,            /* DISTINGUISHER  */
  YYSYMBOL_MRT = 454,                      /* MRT  */
  YYSYMBOL_FILENAME = 455,                 /* FILENAME  */
  YYSYMBOL_ALWAYS = 456,                   /* ALWAYS  */
  YYSYMBOL_OSPF = 457,                     /* OSPF  */
  YYSYMBOL_V2 = 458,                       /* V2  */
  YYSYMBOL_V3 = 459,                       /* V3  */
  YYSYMBOL_AREA = 460,                     /* AREA  */
  YYSYMBOL_RFC1583COMPAT = 461,            /* RFC1583COMPAT  */
  YYSYMBOL_STUB = 462,                     /* STUB  */
  YYSYMBOL_TICK = 463,                     /* TICK  */
  YYSYMBOL_COST2 = 464,                    /* COST2  */
  YYSYMBOL_RETRANSMIT = 465,               /* RETRANSMIT  */
  YYSYMBOL_TRANSMIT = 466,                 /* TRANSMIT  */
  YYSYMBOL_DEAD = 467,                     /* DEAD  */
  YYSYMBOL_BROADCAST = 468,                /* BROADCAST  */
  YYSYMBOL_BCAST = 469,                    /* BCAST  */
  YYSYMBOL_NONBROADCAST = 470,             /* NONBROADCAST  */
  YYSYMBOL_NBMA = 471,                     /* NBMA  */
  YYSYMBOL_POINTOPOINT = 472,              /* POINTOPOINT  */
  YYSYMBOL_PTP = 473,                      /* PTP  */
  YYSYMBOL_POINTOMULTIPOINT = 474,         /* POINTOMULTIPOINT  */
  YYSYMBOL_PTMP = 475,                     /* PTMP  */
  YYSYMBOL_CRYPTOGRAPHIC = 476,            /* CRYPTOGRAPHIC  */
  YYSYMBOL_ELIGIBLE = 477,                 /* ELIGIBLE  */
  YYSYMBOL_POLL = 478,                     /* POLL  */
  YYSYMBOL_NETWORKS = 479,                 /* NETWORKS  */
  YYSYMBOL_HIDDEN = 480,                   /* HIDDEN  */
  YYSYMBOL_VIRTUAL = 481,                  /* VIRTUAL  */
  YYSYMBOL_ONLY = 482,                     /* ONLY  */
  YYSYMBOL_LARGE = 483,                    /* LARGE  */
  YYSYMBOL_NORMAL = 484,                   /* NORMAL  */
  YYSYMBOL_STUBNET = 485,                  /* STUBNET  */
  YYSYMBOL_TAG = 486,                      /* TAG  */
  YYSYMBOL_LSADB = 487,                    /* LSADB  */
  YYSYMBOL_ECMP = 488,                     /* ECMP  */
  YYSYMBOL_NSSA = 489,                     /* NSSA  */
  YYSYMBOL_TRANSLATOR = 490,               /* TRANSLATOR  */
  YYSYMBOL_STABILITY = 491,                /* STABILITY  */
  YYSYMBOL_LSID = 492,                     /* LSID  */
  YYSYMBOL_INSTANCE = 493,                 /* INSTANCE  */
  YYSYMBOL_REAL = 494,                     /* REAL  */
  YYSYMBOL_NETMASK = 495,                  /* NETMASK  */
  YYSYMBOL_LSA = 496,                      /* LSA  */
  YYSYMBOL_SUPPRESSION = 497,              /* SUPPRESSION  */
  YYSYMBOL_RFC5838 = 498,                  /* RFC5838  */
  YYSYMBOL_PE = 499,                       /* PE  */
  YYSYMBOL_TOPOLOGY = 500,                 /* TOPOLOGY  */
  YYSYMBOL_STATE = 501,                    /* STATE  */
  YYSYMBOL_GENERATION = 502,               /* GENERATION  */
  YYSYMBOL_RADV = 503,                     /* RADV  */
  YYSYMBOL_RA = 504,                       /* RA  */
  YYSYMBOL_SOLICITED = 505,                /* SOLICITED  */
  YYSYMBOL_UNICAST = 506,                  /* UNICAST  */
  YYSYMBOL_MANAGED = 507,                  /* MANAGED  */
  YYSYMBOL_OTHER = 508,                    /* OTHER  */
  YYSYMBOL_CONFIG = 509,                   /* CONFIG  */
  YYSYMBOL_LINGER = 510,                   /* LINGER  */
  YYSYMBOL_MTU = 511,                      /* MTU  */
  YYSYMBOL_REACHABLE = 512,                /* REACHABLE  */
  YYSYMBOL_RETRANS = 513,                  /* RETRANS  */
  YYSYMBOL_TIMER = 514,                    /* TIMER  */
  YYSYMBOL_CURRENT = 515,                  /* CURRENT  */
  YYSYMBOL_VALID = 516,                    /* VALID  */
  YYSYMBOL_MULT = 517,                     /* MULT  */
  YYSYMBOL_LIFETIME = 518,                 /* LIFETIME  */
  YYSYMBOL_SKIP = 519,                     /* SKIP  */
  YYSYMBOL_AUTONOMOUS = 520,               /* AUTONOMOUS  */
  YYSYMBOL_RDNSS = 521,                    /* RDNSS  */
  YYSYMBOL_DNSSL = 522,                    /* DNSSL  */
  YYSYMBOL_NS = 523,                       /* NS  */
  YYSYMBOL_TRIGGER = 524,                  /* TRIGGER  */
  YYSYMBOL_SENSITIVE = 525,                /* SENSITIVE  */
  YYSYMBOL_LOW = 526,                      /* LOW  */
  YYSYMBOL_MEDIUM = 527,                   /* MEDIUM  */
  YYSYMBOL_HIGH = 528,                     /* HIGH  */
  YYSYMBOL_PROPAGATE = 529,                /* PROPAGATE  */
  YYSYMBOL_CUSTOM = 530,                   /* CUSTOM  */
  YYSYMBOL_OPTION = 531,                   /* OPTION  */
  YYSYMBOL_VALUE = 532,                    /* VALUE  */
  YYSYMBOL_PD = 533,                       /* PD  */
  YYSYMBOL_RA_PREFERENCE = 534,            /* RA_PREFERENCE  */
  YYSYMBOL_RIP = 535,                      /* RIP  */
  YYSYMBOL_NG = 536,                       /* NG  */
  YYSYMBOL_INFINITY = 537,                 /* INFINITY  */
  YYSYMBOL_TIMEOUT = 538,                  /* TIMEOUT  */
  YYSYMBOL_GARBAGE = 539,                  /* GARBAGE  */
  YYSYMBOL_MODE = 540,                     /* MODE  */
  YYSYMBOL_VERSION = 541,                  /* VERSION  */
  YYSYMBOL_SPLIT = 542,                    /* SPLIT  */
  YYSYMBOL_HORIZON = 543,                  /* HORIZON  */
  YYSYMBOL_POISON = 544,                   /* POISON  */
  YYSYMBOL_REVERSE = 545,                  /* REVERSE  */
  YYSYMBOL_PLAINTEXT = 546,                /* PLAINTEXT  */
  YYSYMBOL_DEMAND = 547,                   /* DEMAND  */
  YYSYMBOL_CIRCUIT = 548,                  /* CIRCUIT  */
  YYSYMBOL_REMOTE = 549,                   /* REMOTE  */
  YYSYMBOL_BIRD = 550,                     /* BIRD  */
  YYSYMBOL_PRIVATE = 551,                  /* PRIVATE  */
  YYSYMBOL_PUBLIC = 552,                   /* PUBLIC  */
  YYSYMBOL_SSH = 553,                      /* SSH  */
  YYSYMBOL_TRANSPORT = 554,                /* TRANSPORT  */
  YYSYMBOL_USER = 555,                     /* USER  */
  YYSYMBOL_EXPIRE = 556,                   /* EXPIRE  */
  YYSYMBOL_PROHIBIT = 557,                 /* PROHIBIT  */
  YYSYMBOL_BLACKHOLE = 558,                /* BLACKHOLE  */
  YYSYMBOL_UNREACHABLE = 559,              /* UNREACHABLE  */
  YYSYMBOL_TRANSIT = 560,                  /* TRANSIT  */
  YYSYMBOL_PROVIDERS = 561,                /* PROVIDERS  */
  YYSYMBOL_KERNEL = 562,                   /* KERNEL  */
  YYSYMBOL_NETLINK = 563,                  /* NETLINK  */
  YYSYMBOL_KRT_LOCK_MTU = 564,             /* KRT_LOCK_MTU  */
  YYSYMBOL_KRT_LOCK_WINDOW = 565,          /* KRT_LOCK_WINDOW  */
  YYSYMBOL_KRT_LOCK_RTT = 566,             /* KRT_LOCK_RTT  */
  YYSYMBOL_KRT_LOCK_RTTVAR = 567,          /* KRT_LOCK_RTTVAR  */
  YYSYMBOL_KRT_LOCK_SSTHRESH = 568,        /* KRT_LOCK_SSTHRESH  */
  YYSYMBOL_KRT_LOCK_CWND = 569,            /* KRT_LOCK_CWND  */
  YYSYMBOL_KRT_LOCK_ADVMSS = 570,          /* KRT_LOCK_ADVMSS  */
  YYSYMBOL_KRT_LOCK_REORDERING = 571,      /* KRT_LOCK_REORDERING  */
  YYSYMBOL_KRT_LOCK_HOPLIMIT = 572,        /* KRT_LOCK_HOPLIMIT  */
  YYSYMBOL_KRT_LOCK_INITCWND = 573,        /* KRT_LOCK_INITCWND  */
  YYSYMBOL_KRT_LOCK_RTO_MIN = 574,         /* KRT_LOCK_RTO_MIN  */
  YYSYMBOL_KRT_LOCK_INITRWND = 575,        /* KRT_LOCK_INITRWND  */
  YYSYMBOL_KRT_LOCK_QUICKACK = 576,        /* KRT_LOCK_QUICKACK  */
  YYSYMBOL_KRT_LOCK_CONGCTL = 577,         /* KRT_LOCK_CONGCTL  */
  YYSYMBOL_KRT_LOCK_FASTOPEN_NO_COOKIE = 578, /* KRT_LOCK_FASTOPEN_NO_COOKIE  */
  YYSYMBOL_KRT_FEATURE_ECN = 579,          /* KRT_FEATURE_ECN  */
  YYSYMBOL_KRT_FEATURE_ALLFRAG = 580,      /* KRT_FEATURE_ALLFRAG  */
  YYSYMBOL_SYSLOG = 581,                   /* SYSLOG  */
  YYSYMBOL_TRACE = 582,                    /* TRACE  */
  YYSYMBOL_INFO = 583,                     /* INFO  */
  YYSYMBOL_AUTH = 584,                     /* AUTH  */
  YYSYMBOL_FATAL = 585,                    /* FATAL  */
  YYSYMBOL_BUG = 586,                      /* BUG  */
  YYSYMBOL_STDERR = 587,                   /* STDERR  */
  YYSYMBOL_SOFT = 588,                     /* SOFT  */
  YYSYMBOL_UDP = 589,                      /* UDP  */
  YYSYMBOL_CLI = 590,                      /* CLI  */
  YYSYMBOL_CONFIRM = 591,                  /* CONFIRM  */
  YYSYMBOL_UNDO = 592,                     /* UNDO  */
  YYSYMBOL_LATENCY = 593,                  /* LATENCY  */
  YYSYMBOL_WATCHDOG = 594,                 /* WATCHDOG  */
  YYSYMBOL_PING = 595,                     /* PING  */
  YYSYMBOL_WAKEUP = 596,                   /* WAKEUP  */
  YYSYMBOL_SCHEDULING = 597,               /* SCHEDULING  */
  YYSYMBOL_TIMERS = 598,                   /* TIMERS  */
  YYSYMBOL_ALLOCATOR = 599,                /* ALLOCATOR  */
  YYSYMBOL_FIXED = 600,                    /* FIXED  */
  YYSYMBOL_THREAD = 601,                   /* THREAD  */
  YYSYMBOL_THREADS = 602,                  /* THREADS  */
  YYSYMBOL_GROUP = 603,                    /* GROUP  */
  YYSYMBOL_CONFIGURE = 604,                /* CONFIGURE  */
  YYSYMBOL_DOWN = 605,                     /* DOWN  */
  YYSYMBOL_PERSIST = 606,                  /* PERSIST  */
  YYSYMBOL_SCAN = 607,                     /* SCAN  */
  YYSYMBOL_LEARN = 608,                    /* LEARN  */
  YYSYMBOL_DEVICE = 609,                   /* DEVICE  */
  YYSYMBOL_YYACCEPT = 610,                 /* $accept  */
  YYSYMBOL_cli_cmd = 611,                  /* cli_cmd  */
  YYSYMBOL_cmd_QUIT = 612,                 /* cmd_QUIT  */
  YYSYMBOL_cmd_EXIT = 613,                 /* cmd_EXIT  */
  YYSYMBOL_cmd_HELP = 614,                 /* cmd_HELP  */
  YYSYMBOL_config = 615,                   /* config  */
  YYSYMBOL_conf_entries = 616,             /* conf_entries  */
  YYSYMBOL_conf = 617,                     /* conf  */
  YYSYMBOL_definition = 618,               /* definition  */
  YYSYMBOL_conf_expr = 619,                /* conf_expr  */
  YYSYMBOL_symbol = 620,                   /* symbol  */
  YYSYMBOL_symbol_known = 621,             /* symbol_known  */
  YYSYMBOL_expr = 622,                     /* expr  */
  YYSYMBOL_expr_us = 623,                  /* expr_us  */
  YYSYMBOL_bool = 624,                     /* bool  */
  YYSYMBOL_ipa = 625,                      /* ipa  */
  YYSYMBOL_ipa_scope = 626,                /* ipa_scope  */
  YYSYMBOL_pxlen4 = 627,                   /* pxlen4  */
  YYSYMBOL_net_ip4_ = 628,                 /* net_ip4_  */
  YYSYMBOL_net_ip6_slash = 629,            /* net_ip6_slash  */
  YYSYMBOL_net_ip6_ = 630,                 /* net_ip6_  */
  YYSYMBOL_net_ip6_sadr_ = 631,            /* net_ip6_sadr_  */
  YYSYMBOL_net_vpn4_ = 632,                /* net_vpn4_  */
  YYSYMBOL_net_vpn6_ = 633,                /* net_vpn6_  */
  YYSYMBOL_net_roa4_ = 634,                /* net_roa4_  */
  YYSYMBOL_net_roa6_ = 635,                /* net_roa6_  */
  YYSYMBOL_net_mpls_ = 636,                /* net_mpls_  */
  YYSYMBOL_net_aspa_ = 637,                /* net_aspa_  */
  YYSYMBOL_net_ip_ = 638,                  /* net_ip_  */
  YYSYMBOL_net_vpn_ = 639,                 /* net_vpn_  */
  YYSYMBOL_net_roa_ = 640,                 /* net_roa_  */
  YYSYMBOL_net_ = 641,                     /* net_  */
  YYSYMBOL_net_ip4 = 642,                  /* net_ip4  */
  YYSYMBOL_net_ip6 = 643,                  /* net_ip6  */
  YYSYMBOL_net_ip = 644,                   /* net_ip  */
  YYSYMBOL_net_any = 645,                  /* net_any  */
  YYSYMBOL_label_stack_start = 646,        /* label_stack_start  */
  YYSYMBOL_label_stack = 647,              /* label_stack  */
  YYSYMBOL_settle = 648,                   /* settle  */
  YYSYMBOL_text = 649,                     /* text  */
  YYSYMBOL_opttext = 650,                  /* opttext  */
  YYSYMBOL_time = 651,                     /* time  */
  YYSYMBOL_bytestring = 652,               /* bytestring  */
  YYSYMBOL_bytestring_expr = 653,          /* bytestring_expr  */
  YYSYMBOL_idval = 654,                    /* idval  */
  YYSYMBOL_net_or_ipa = 655,               /* net_or_ipa  */
  YYSYMBOL_text_or_ipa = 656,              /* text_or_ipa  */
  YYSYMBOL_bytestring_or_text = 657,       /* bytestring_or_text  */
  YYSYMBOL_flow_num_op = 658,              /* flow_num_op  */
  YYSYMBOL_flow_logic_op = 659,            /* flow_logic_op  */
  YYSYMBOL_flow_num_type_ = 660,           /* flow_num_type_  */
  YYSYMBOL_flow_num_type = 661,            /* flow_num_type  */
  YYSYMBOL_flow_flag_type = 662,           /* flow_flag_type  */
  YYSYMBOL_flow_frag_type = 663,           /* flow_frag_type  */
  YYSYMBOL_flow_srcdst = 664,              /* flow_srcdst  */
  YYSYMBOL_flow_num_opts = 665,            /* flow_num_opts  */
  YYSYMBOL_flow_num_opt_ext_expr = 666,    /* flow_num_opt_ext_expr  */
  YYSYMBOL_flow_num_opt_ext = 667,         /* flow_num_opt_ext  */
  YYSYMBOL_flow_bmk_opts = 668,            /* flow_bmk_opts  */
  YYSYMBOL_flow_neg = 669,                 /* flow_neg  */
  YYSYMBOL_flow_frag_val = 670,            /* flow_frag_val  */
  YYSYMBOL_flow_frag_opts = 671,           /* flow_frag_opts  */
  YYSYMBOL_flow4_item = 672,               /* flow4_item  */
  YYSYMBOL_flow6_item = 673,               /* flow6_item  */
  YYSYMBOL_flow4_opts = 674,               /* flow4_opts  */
  YYSYMBOL_flow6_opts = 675,               /* flow6_opts  */
  YYSYMBOL_flow_builder_init = 676,        /* flow_builder_init  */
  YYSYMBOL_flow_builder_set_ipv4 = 677,    /* flow_builder_set_ipv4  */
  YYSYMBOL_flow_builder_set_ipv6 = 678,    /* flow_builder_set_ipv6  */
  YYSYMBOL_net_flow4_ = 679,               /* net_flow4_  */
  YYSYMBOL_net_flow6_ = 680,               /* net_flow6_  */
  YYSYMBOL_net_flow_ = 681,                /* net_flow_  */
  YYSYMBOL_enum_type = 682,                /* enum_type  */
  YYSYMBOL_filter_def = 683,               /* filter_def  */
  YYSYMBOL_684_1 = 684,                    /* $@1  */
  YYSYMBOL_filter_eval = 685,              /* filter_eval  */
  YYSYMBOL_custom_attr = 686,              /* custom_attr  */
  YYSYMBOL_bt_test_suite = 687,            /* bt_test_suite  */
  YYSYMBOL_bt_test_same = 688,             /* bt_test_same  */
  YYSYMBOL_type = 689,                     /* type  */
  YYSYMBOL_690_2 = 690,                    /* @2  */
  YYSYMBOL_function_argsn = 691,           /* function_argsn  */
  YYSYMBOL_function_args = 692,            /* function_args  */
  YYSYMBOL_function_vars = 693,            /* function_vars  */
  YYSYMBOL_function_type = 694,            /* function_type  */
  YYSYMBOL_filter_body = 695,              /* filter_body  */
  YYSYMBOL_filter = 696,                   /* filter  */
  YYSYMBOL_697_3 = 697,                    /* $@3  */
  YYSYMBOL_where_filter = 698,             /* where_filter  */
  YYSYMBOL_699_4 = 699,                    /* $@4  */
  YYSYMBOL_function_body = 700,            /* function_body  */
  YYSYMBOL_function_def = 701,             /* function_def  */
  YYSYMBOL_702_5 = 702,                    /* $@5  */
  YYSYMBOL_703_6 = 703,                    /* $@6  */
  YYSYMBOL_cmds = 704,                     /* cmds  */
  YYSYMBOL_cmd_var = 705,                  /* cmd_var  */
  YYSYMBOL_cmd_prep = 706,                 /* cmd_prep  */
  YYSYMBOL_cmds_int = 707,                 /* cmds_int  */
  YYSYMBOL_fipa = 708,                     /* fipa  */
  YYSYMBOL_set_atom0 = 709,                /* set_atom0  */
  YYSYMBOL_set_atom = 710,                 /* set_atom  */
  YYSYMBOL_switch_atom = 711,              /* switch_atom  */
  YYSYMBOL_cnum = 712,                     /* cnum  */
  YYSYMBOL_pair_item = 713,                /* pair_item  */
  YYSYMBOL_ec_kind = 714,                  /* ec_kind  */
  YYSYMBOL_ec_item = 715,                  /* ec_item  */
  YYSYMBOL_lc_item = 716,                  /* lc_item  */
  YYSYMBOL_set_item = 717,                 /* set_item  */
  YYSYMBOL_switch_item = 718,              /* switch_item  */
  YYSYMBOL_ec_items = 719,                 /* ec_items  */
  YYSYMBOL_set_items = 720,                /* set_items  */
  YYSYMBOL_switch_items = 721,             /* switch_items  */
  YYSYMBOL_fprefix = 722,                  /* fprefix  */
  YYSYMBOL_fprefix_set = 723,              /* fprefix_set  */
  YYSYMBOL_switch_body = 724,              /* switch_body  */
  YYSYMBOL_bgp_path_expr = 725,            /* bgp_path_expr  */
  YYSYMBOL_bgp_path = 726,                 /* bgp_path  */
  YYSYMBOL_bgp_path_tail = 727,            /* bgp_path_tail  */
  YYSYMBOL_constant = 728,                 /* constant  */
  YYSYMBOL_constructor = 729,              /* constructor  */
  YYSYMBOL_var_list_r = 730,               /* var_list_r  */
  YYSYMBOL_var_list = 731,                 /* var_list  */
  YYSYMBOL_function_call = 732,            /* function_call  */
  YYSYMBOL_static_attr = 733,              /* static_attr  */
  YYSYMBOL_term_dot_method = 734,          /* term_dot_method  */
  YYSYMBOL_735_7 = 735,                    /* $@7  */
  YYSYMBOL_method_name_cont = 736,         /* method_name_cont  */
  YYSYMBOL_737_8 = 737,                    /* $@8  */
  YYSYMBOL_term = 738,                     /* term  */
  YYSYMBOL_term_bs = 739,                  /* term_bs  */
  YYSYMBOL_break_command = 740,            /* break_command  */
  YYSYMBOL_var = 741,                      /* var  */
  YYSYMBOL_for_var = 742,                  /* for_var  */
  YYSYMBOL_cmd = 743,                      /* cmd  */
  YYSYMBOL_744_9 = 744,                    /* $@9  */
  YYSYMBOL_745_10 = 745,                   /* $@10  */
  YYSYMBOL_746_11 = 746,                   /* $@11  */
  YYSYMBOL_747_12 = 747,                   /* $@12  */
  YYSYMBOL_748_13 = 748,                   /* $@13  */
  YYSYMBOL_749_14 = 749,                   /* $@14  */
  YYSYMBOL_get_cf_position = 750,          /* get_cf_position  */
  YYSYMBOL_lvalue = 751,                   /* lvalue  */
  YYSYMBOL_rtrid = 752,                    /* rtrid  */
  YYSYMBOL_hostname_override = 753,        /* hostname_override  */
  YYSYMBOL_gr_opts = 754,                  /* gr_opts  */
  YYSYMBOL_net_type_base = 755,            /* net_type_base  */
  YYSYMBOL_net_type = 756,                 /* net_type  */
  YYSYMBOL_table = 757,                    /* table  */
  YYSYMBOL_table_start = 758,              /* table_start  */
  YYSYMBOL_table_sorted = 759,             /* table_sorted  */
  YYSYMBOL_table_opt = 760,                /* table_opt  */
  YYSYMBOL_table_opts = 761,               /* table_opts  */
  YYSYMBOL_table_opt_list = 762,           /* table_opt_list  */
  YYSYMBOL_proto_start = 763,              /* proto_start  */
  YYSYMBOL_proto_name = 764,               /* proto_name  */
  YYSYMBOL_proto_item = 765,               /* proto_item  */
  YYSYMBOL_channel_start = 766,            /* channel_start  */
  YYSYMBOL_channel_item_ = 767,            /* channel_item_  */
  YYSYMBOL_channel_item = 768,             /* channel_item  */
  YYSYMBOL_channel_opts = 769,             /* channel_opts  */
  YYSYMBOL_channel_opt_list = 770,         /* channel_opt_list  */
  YYSYMBOL_channel_end = 771,              /* channel_end  */
  YYSYMBOL_proto_channel = 772,            /* proto_channel  */
  YYSYMBOL_rtable = 773,                   /* rtable  */
  YYSYMBOL_imexport = 774,                 /* imexport  */
  YYSYMBOL_limit_action = 775,             /* limit_action  */
  YYSYMBOL_limit_spec = 776,               /* limit_spec  */
  YYSYMBOL_debug_default = 777,            /* debug_default  */
  YYSYMBOL_timeformat_base = 778,          /* timeformat_base  */
  YYSYMBOL_timeformat_which = 779,         /* timeformat_which  */
  YYSYMBOL_timeformat_spec = 780,          /* timeformat_spec  */
  YYSYMBOL_iface_patt_node_init = 781,     /* iface_patt_node_init  */
  YYSYMBOL_iface_patt_node_body = 782,     /* iface_patt_node_body  */
  YYSYMBOL_iface_negate = 783,             /* iface_negate  */
  YYSYMBOL_iface_patt_node = 784,          /* iface_patt_node  */
  YYSYMBOL_iface_patt_list = 785,          /* iface_patt_list  */
  YYSYMBOL_iface_patt_list_nopx = 786,     /* iface_patt_list_nopx  */
  YYSYMBOL_iface_patt_init = 787,          /* iface_patt_init  */
  YYSYMBOL_iface_patt = 788,               /* iface_patt  */
  YYSYMBOL_tos = 789,                      /* tos  */
  YYSYMBOL_proto = 790,                    /* proto  */
  YYSYMBOL_dev_proto_start = 791,          /* dev_proto_start  */
  YYSYMBOL_dev_proto = 792,                /* dev_proto  */
  YYSYMBOL_dev_iface_init = 793,           /* dev_iface_init  */
  YYSYMBOL_dev_iface_patt = 794,           /* dev_iface_patt  */
  YYSYMBOL_debug_mask = 795,               /* debug_mask  */
  YYSYMBOL_debug_list = 796,               /* debug_list  */
  YYSYMBOL_debug_flag = 797,               /* debug_flag  */
  YYSYMBOL_mrtdump_mask = 798,             /* mrtdump_mask  */
  YYSYMBOL_mrtdump_list = 799,             /* mrtdump_list  */
  YYSYMBOL_mrtdump_flag = 800,             /* mrtdump_flag  */
  YYSYMBOL_password_list = 801,            /* password_list  */
  YYSYMBOL_password_list_body = 802,       /* password_list_body  */
  YYSYMBOL_password_items = 803,           /* password_items  */
  YYSYMBOL_password_item = 804,            /* password_item  */
  YYSYMBOL_pass_key = 805,                 /* pass_key  */
  YYSYMBOL_password_item_begin = 806,      /* password_item_begin  */
  YYSYMBOL_password_item_params = 807,     /* password_item_params  */
  YYSYMBOL_password_algorithm = 808,       /* password_algorithm  */
  YYSYMBOL_password_item_end = 809,        /* password_item_end  */
  YYSYMBOL_bfd_opts = 810,                 /* bfd_opts  */
  YYSYMBOL_cmd_SHOW_STATUS = 811,          /* cmd_SHOW_STATUS  */
  YYSYMBOL_cmd_SHOW_MEMORY = 812,          /* cmd_SHOW_MEMORY  */
  YYSYMBOL_cmd_SHOW_PROTOCOLS = 813,       /* cmd_SHOW_PROTOCOLS  */
  YYSYMBOL_cmd_SHOW_PROTOCOLS_ALL = 814,   /* cmd_SHOW_PROTOCOLS_ALL  */
  YYSYMBOL_optproto = 815,                 /* optproto  */
  YYSYMBOL_cmd_SHOW_INTERFACES = 816,      /* cmd_SHOW_INTERFACES  */
  YYSYMBOL_cmd_SHOW_INTERFACES_SUMMARY = 817, /* cmd_SHOW_INTERFACES_SUMMARY  */
  YYSYMBOL_cmd_SHOW_ROUTE = 818,           /* cmd_SHOW_ROUTE  */
  YYSYMBOL_r_args = 819,                   /* r_args  */
  YYSYMBOL_r_args_for = 820,               /* r_args_for  */
  YYSYMBOL_r_args_for_val = 821,           /* r_args_for_val  */
  YYSYMBOL_export_mode = 822,              /* export_mode  */
  YYSYMBOL_channel_sym = 823,              /* channel_sym  */
  YYSYMBOL_channel_arg = 824,              /* channel_arg  */
  YYSYMBOL_cmd_SHOW_SYMBOLS = 825,         /* cmd_SHOW_SYMBOLS  */
  YYSYMBOL_sym_args = 826,                 /* sym_args  */
  YYSYMBOL_cmd_DUMP_RESOURCES = 827,       /* cmd_DUMP_RESOURCES  */
  YYSYMBOL_cmd_DUMP_SOCKETS = 828,         /* cmd_DUMP_SOCKETS  */
  YYSYMBOL_cmd_DUMP_AO_KEYS = 829,         /* cmd_DUMP_AO_KEYS  */
  YYSYMBOL_cmd_DUMP_EVENTS = 830,          /* cmd_DUMP_EVENTS  */
  YYSYMBOL_cmd_DUMP_INTERFACES = 831,      /* cmd_DUMP_INTERFACES  */
  YYSYMBOL_cmd_DUMP_NEIGHBORS = 832,       /* cmd_DUMP_NEIGHBORS  */
  YYSYMBOL_cmd_DUMP_ATTRIBUTES = 833,      /* cmd_DUMP_ATTRIBUTES  */
  YYSYMBOL_cmd_DUMP_ROUTES = 834,          /* cmd_DUMP_ROUTES  */
  YYSYMBOL_cmd_DUMP_TABLES = 835,          /* cmd_DUMP_TABLES  */
  YYSYMBOL_cmd_DUMP_PROTOCOLS = 836,       /* cmd_DUMP_PROTOCOLS  */
  YYSYMBOL_cmd_DUMP_FILTER_ALL = 837,      /* cmd_DUMP_FILTER_ALL  */
  YYSYMBOL_cmd_EVAL = 838,                 /* cmd_EVAL  */
  YYSYMBOL_partial_opt = 839,              /* partial_opt  */
  YYSYMBOL_cmd_DISABLE = 840,              /* cmd_DISABLE  */
  YYSYMBOL_cmd_ENABLE = 841,               /* cmd_ENABLE  */
  YYSYMBOL_cmd_RESTART = 842,              /* cmd_RESTART  */
  YYSYMBOL_cmd_RELOAD_FILTERS = 843,       /* cmd_RELOAD_FILTERS  */
  YYSYMBOL_cmd_RELOAD_FILTERS_IN = 844,    /* cmd_RELOAD_FILTERS_IN  */
  YYSYMBOL_cmd_RELOAD_FILTERS_OUT = 845,   /* cmd_RELOAD_FILTERS_OUT  */
  YYSYMBOL_cmd_DEBUG = 846,                /* cmd_DEBUG  */
  YYSYMBOL_debug_args = 847,               /* debug_args  */
  YYSYMBOL_cmd_MRTDUMP = 848,              /* cmd_MRTDUMP  */
  YYSYMBOL_cmd_RESTRICT = 849,             /* cmd_RESTRICT  */
  YYSYMBOL_cmd_TIMEFORMAT = 850,           /* cmd_TIMEFORMAT  */
  YYSYMBOL_proto_patt = 851,               /* proto_patt  */
  YYSYMBOL_proto_patt2 = 852,              /* proto_patt2  */
  YYSYMBOL_mpls_domain = 853,              /* mpls_domain  */
  YYSYMBOL_mpls_domain_start = 854,        /* mpls_domain_start  */
  YYSYMBOL_mpls_domain_opt = 855,          /* mpls_domain_opt  */
  YYSYMBOL_mpls_domain_opts = 856,         /* mpls_domain_opts  */
  YYSYMBOL_mpls_domain_opt_list = 857,     /* mpls_domain_opt_list  */
  YYSYMBOL_mpls_domain_end = 858,          /* mpls_domain_end  */
  YYSYMBOL_mpls_range = 859,               /* mpls_range  */
  YYSYMBOL_mpls_range_start = 860,         /* mpls_range_start  */
  YYSYMBOL_mpls_range_opt = 861,           /* mpls_range_opt  */
  YYSYMBOL_mpls_range_opts = 862,          /* mpls_range_opts  */
  YYSYMBOL_mpls_range_opt_list = 863,      /* mpls_range_opt_list  */
  YYSYMBOL_mpls_range_end = 864,           /* mpls_range_end  */
  YYSYMBOL_mpls_channel = 865,             /* mpls_channel  */
  YYSYMBOL_mpls_channel_start = 866,       /* mpls_channel_start  */
  YYSYMBOL_mpls_label_policy = 867,        /* mpls_label_policy  */
  YYSYMBOL_mpls_channel_opt = 868,         /* mpls_channel_opt  */
  YYSYMBOL_mpls_channel_opts = 869,        /* mpls_channel_opts  */
  YYSYMBOL_mpls_channel_opt_list = 870,    /* mpls_channel_opt_list  */
  YYSYMBOL_mpls_channel_end = 871,         /* mpls_channel_end  */
  YYSYMBOL_872_15 = 872,                   /* $@15  */
  YYSYMBOL_show_mpls_ranges_args = 873,    /* show_mpls_ranges_args  */
  YYSYMBOL_cmd_SHOW_MPLS_RANGES = 874,     /* cmd_SHOW_MPLS_RANGES  */
  YYSYMBOL_aggregator_proto_start = 875,   /* aggregator_proto_start  */
  YYSYMBOL_aggregator_proto_item = 876,    /* aggregator_proto_item  */
  YYSYMBOL_877_16 = 877,                   /* $@16  */
  YYSYMBOL_878_17 = 878,                   /* $@17  */
  YYSYMBOL_aggregator_proto_opts = 879,    /* aggregator_proto_opts  */
  YYSYMBOL_aggregator_proto = 880,         /* aggregator_proto  */
  YYSYMBOL_aggr_list = 881,                /* aggr_list  */
  YYSYMBOL_aggr_item = 882,                /* aggr_item  */
  YYSYMBOL_babel_proto_start = 883,        /* babel_proto_start  */
  YYSYMBOL_babel_proto_item = 884,         /* babel_proto_item  */
  YYSYMBOL_babel_proto_opts = 885,         /* babel_proto_opts  */
  YYSYMBOL_babel_proto = 886,              /* babel_proto  */
  YYSYMBOL_babel_iface_start = 887,        /* babel_iface_start  */
  YYSYMBOL_babel_iface_finish = 888,       /* babel_iface_finish  */
  YYSYMBOL_babel_iface_item = 889,         /* babel_iface_item  */
  YYSYMBOL_babel_iface_opts = 890,         /* babel_iface_opts  */
  YYSYMBOL_babel_iface_opt_list = 891,     /* babel_iface_opt_list  */
  YYSYMBOL_babel_iface = 892,              /* babel_iface  */
  YYSYMBOL_cmd_SHOW_BABEL_INTERFACES = 893, /* cmd_SHOW_BABEL_INTERFACES  */
  YYSYMBOL_cmd_SHOW_BABEL_NEIGHBORS = 894, /* cmd_SHOW_BABEL_NEIGHBORS  */
  YYSYMBOL_cmd_SHOW_BABEL_ENTRIES = 895,   /* cmd_SHOW_BABEL_ENTRIES  */
  YYSYMBOL_cmd_SHOW_BABEL_ROUTES = 896,    /* cmd_SHOW_BABEL_ROUTES  */
  YYSYMBOL_bfd_proto_start = 897,          /* bfd_proto_start  */
  YYSYMBOL_bfd_proto_item = 898,           /* bfd_proto_item  */
  YYSYMBOL_bfd_proto_opts = 899,           /* bfd_proto_opts  */
  YYSYMBOL_bfd_proto = 900,                /* bfd_proto  */
  YYSYMBOL_bfd_accept_item = 901,          /* bfd_accept_item  */
  YYSYMBOL_bfd_accept = 902,               /* bfd_accept  */
  YYSYMBOL_bfd_iface_start = 903,          /* bfd_iface_start  */
  YYSYMBOL_bfd_iface_finish = 904,         /* bfd_iface_finish  */
  YYSYMBOL_bfd_auth_type = 905,            /* bfd_auth_type  */
  YYSYMBOL_bfd_iface_opt_list = 906,       /* bfd_iface_opt_list  */
  YYSYMBOL_bfd_iface = 907,                /* bfd_iface  */
  YYSYMBOL_bfd_multihop = 908,             /* bfd_multihop  */
  YYSYMBOL_bfd_neigh_iface = 909,          /* bfd_neigh_iface  */
  YYSYMBOL_bfd_neigh_local = 910,          /* bfd_neigh_local  */
  YYSYMBOL_bfd_neigh_multihop = 911,       /* bfd_neigh_multihop  */
  YYSYMBOL_bfd_neighbor = 912,             /* bfd_neighbor  */
  YYSYMBOL_bfd_item = 913,                 /* bfd_item  */
  YYSYMBOL_bfd_items = 914,                /* bfd_items  */
  YYSYMBOL_bfd_opts_start = 915,           /* bfd_opts_start  */
  YYSYMBOL_bfd_opts_end = 916,             /* bfd_opts_end  */
  YYSYMBOL_cmd_SHOW_BFD_SESSIONS = 917,    /* cmd_SHOW_BFD_SESSIONS  */
  YYSYMBOL_bfd_show_sessions_args = 918,   /* bfd_show_sessions_args  */
  YYSYMBOL_bgp_proto_start = 919,          /* bgp_proto_start  */
  YYSYMBOL_bgp_loc_opts = 920,             /* bgp_loc_opts  */
  YYSYMBOL_bgp_nbr_opts = 921,             /* bgp_nbr_opts  */
  YYSYMBOL_bgp_cease_mask = 922,           /* bgp_cease_mask  */
  YYSYMBOL_bgp_cease_list = 923,           /* bgp_cease_list  */
  YYSYMBOL_bgp_cease_flag = 924,           /* bgp_cease_flag  */
  YYSYMBOL_bgp_auth_type = 925,            /* bgp_auth_type  */
  YYSYMBOL_bgp_role_name = 926,            /* bgp_role_name  */
  YYSYMBOL_bgp_proto = 927,                /* bgp_proto  */
  YYSYMBOL_928_18 = 928,                   /* $@18  */
  YYSYMBOL_929_19 = 929,                   /* $@19  */
  YYSYMBOL_bgp_afi = 930,                  /* bgp_afi  */
  YYSYMBOL_tcp_ao_key_start = 931,         /* tcp_ao_key_start  */
  YYSYMBOL_tcp_ao_key_opt = 932,           /* tcp_ao_key_opt  */
  YYSYMBOL_tcp_ao_algorithm = 933,         /* tcp_ao_algorithm  */
  YYSYMBOL_tcp_ao_key_opts = 934,          /* tcp_ao_key_opts  */
  YYSYMBOL_tcp_ao_key_end = 935,           /* tcp_ao_key_end  */
  YYSYMBOL_tcp_ao_key = 936,               /* tcp_ao_key  */
  YYSYMBOL_tcp_ao_keys = 937,              /* tcp_ao_keys  */
  YYSYMBOL_tcp_ao_key_list = 938,          /* tcp_ao_key_list  */
  YYSYMBOL_939_20 = 939,                   /* $@20  */
  YYSYMBOL_tcp_ao_end = 940,               /* tcp_ao_end  */
  YYSYMBOL_bgp_channel_start = 941,        /* bgp_channel_start  */
  YYSYMBOL_bgp_nh = 942,                   /* bgp_nh  */
  YYSYMBOL_bgp_llnh = 943,                 /* bgp_llnh  */
  YYSYMBOL_bgp_lladdr = 944,               /* bgp_lladdr  */
  YYSYMBOL_bgp_channel_item = 945,         /* bgp_channel_item  */
  YYSYMBOL_bgp_channel_opts = 946,         /* bgp_channel_opts  */
  YYSYMBOL_bgp_channel_opt_list = 947,     /* bgp_channel_opt_list  */
  YYSYMBOL_bgp_channel_end = 948,          /* bgp_channel_end  */
  YYSYMBOL_bgp_proto_channel = 949,        /* bgp_proto_channel  */
  YYSYMBOL_cmd_RELOAD_BGP = 950,           /* cmd_RELOAD_BGP  */
  YYSYMBOL_cmd_RELOAD_BGP_IN = 951,        /* cmd_RELOAD_BGP_IN  */
  YYSYMBOL_cmd_RELOAD_BGP_OUT = 952,       /* cmd_RELOAD_BGP_OUT  */
  YYSYMBOL_bmp_proto_start = 953,          /* bmp_proto_start  */
  YYSYMBOL_bmp_station_address = 954,      /* bmp_station_address  */
  YYSYMBOL_bmp_proto = 955,                /* bmp_proto  */
  YYSYMBOL_l3vpn_channel_start = 956,      /* l3vpn_channel_start  */
  YYSYMBOL_l3vpn_channel = 957,            /* l3vpn_channel  */
  YYSYMBOL_l3vpn_proto_start = 958,        /* l3vpn_proto_start  */
  YYSYMBOL_l3vpn_proto_item = 959,         /* l3vpn_proto_item  */
  YYSYMBOL_l3vpn_proto_opts = 960,         /* l3vpn_proto_opts  */
  YYSYMBOL_l3vpn_proto = 961,              /* l3vpn_proto  */
  YYSYMBOL_l3vpn_targets = 962,            /* l3vpn_targets  */
  YYSYMBOL_mrt_proto_start = 963,          /* mrt_proto_start  */
  YYSYMBOL_mrt_proto_item = 964,           /* mrt_proto_item  */
  YYSYMBOL_mrt_proto_opts = 965,           /* mrt_proto_opts  */
  YYSYMBOL_mrt_proto = 966,                /* mrt_proto  */
  YYSYMBOL_cmd_MRT_DUMP = 967,             /* cmd_MRT_DUMP  */
  YYSYMBOL_mrt_dump_args = 968,            /* mrt_dump_args  */
  YYSYMBOL_ospf_variant = 969,             /* ospf_variant  */
  YYSYMBOL_ospf_proto_start = 970,         /* ospf_proto_start  */
  YYSYMBOL_ospf_proto = 971,               /* ospf_proto  */
  YYSYMBOL_ospf_af_mc = 972,               /* ospf_af_mc  */
  YYSYMBOL_ospf_channel_start = 973,       /* ospf_channel_start  */
  YYSYMBOL_ospf_channel = 974,             /* ospf_channel  */
  YYSYMBOL_ospf_proto_item = 975,          /* ospf_proto_item  */
  YYSYMBOL_ospf_area_start = 976,          /* ospf_area_start  */
  YYSYMBOL_ospf_area = 977,                /* ospf_area  */
  YYSYMBOL_ospf_area_opts = 978,           /* ospf_area_opts  */
  YYSYMBOL_ospf_area_item = 979,           /* ospf_area_item  */
  YYSYMBOL_980_21 = 980,                   /* $@21  */
  YYSYMBOL_981_22 = 981,                   /* $@22  */
  YYSYMBOL_ospf_stubnet = 982,             /* ospf_stubnet  */
  YYSYMBOL_ospf_stubnet_start = 983,       /* ospf_stubnet_start  */
  YYSYMBOL_ospf_stubnet_opts = 984,        /* ospf_stubnet_opts  */
  YYSYMBOL_ospf_stubnet_item = 985,        /* ospf_stubnet_item  */
  YYSYMBOL_ospf_vlink = 986,               /* ospf_vlink  */
  YYSYMBOL_ospf_vlink_opts = 987,          /* ospf_vlink_opts  */
  YYSYMBOL_ospf_vlink_item = 988,          /* ospf_vlink_item  */
  YYSYMBOL_ospf_vlink_start = 989,         /* ospf_vlink_start  */
  YYSYMBOL_ospf_iface_item = 990,          /* ospf_iface_item  */
  YYSYMBOL_pref_list = 991,                /* pref_list  */
  YYSYMBOL_pref_item = 992,                /* pref_item  */
  YYSYMBOL_pref_base = 993,                /* pref_base  */
  YYSYMBOL_pref_opt = 994,                 /* pref_opt  */
  YYSYMBOL_nbma_list = 995,                /* nbma_list  */
  YYSYMBOL_nbma_eligible = 996,            /* nbma_eligible  */
  YYSYMBOL_nbma_item = 997,                /* nbma_item  */
  YYSYMBOL_ospf_iface_start = 998,         /* ospf_iface_start  */
  YYSYMBOL_ospf_instance_id = 999,         /* ospf_instance_id  */
  YYSYMBOL_ospf_iface_patt_list = 1000,    /* ospf_iface_patt_list  */
  YYSYMBOL_1001_23 = 1001,                 /* $@23  */
  YYSYMBOL_ospf_iface_opts = 1002,         /* ospf_iface_opts  */
  YYSYMBOL_ospf_iface_opt_list = 1003,     /* ospf_iface_opt_list  */
  YYSYMBOL_ospf_iface = 1004,              /* ospf_iface  */
  YYSYMBOL_cmd_SHOW_OSPF = 1005,           /* cmd_SHOW_OSPF  */
  YYSYMBOL_cmd_SHOW_OSPF_NEIGHBORS = 1006, /* cmd_SHOW_OSPF_NEIGHBORS  */
  YYSYMBOL_cmd_SHOW_OSPF_INTERFACE = 1007, /* cmd_SHOW_OSPF_INTERFACE  */
  YYSYMBOL_cmd_SHOW_OSPF_TOPOLOGY = 1008,  /* cmd_SHOW_OSPF_TOPOLOGY  */
  YYSYMBOL_cmd_SHOW_OSPF_TOPOLOGY_ALL = 1009, /* cmd_SHOW_OSPF_TOPOLOGY_ALL  */
  YYSYMBOL_cmd_SHOW_OSPF_STATE = 1010,     /* cmd_SHOW_OSPF_STATE  */
  YYSYMBOL_cmd_SHOW_OSPF_STATE_ALL = 1011, /* cmd_SHOW_OSPF_STATE_ALL  */
  YYSYMBOL_cmd_SHOW_OSPF_LSADB = 1012,     /* cmd_SHOW_OSPF_LSADB  */
  YYSYMBOL_lsadb_args = 1013,              /* lsadb_args  */
  YYSYMBOL_pipe_proto_start = 1014,        /* pipe_proto_start  */
  YYSYMBOL_1015_24 = 1015,                 /* $@24  */
  YYSYMBOL_pipe_proto = 1016,              /* pipe_proto  */
  YYSYMBOL_radv_proto_start = 1017,        /* radv_proto_start  */
  YYSYMBOL_radv_proto_item = 1018,         /* radv_proto_item  */
  YYSYMBOL_1019_25 = 1019,                 /* $@25  */
  YYSYMBOL_1020_26 = 1020,                 /* $@26  */
  YYSYMBOL_radv_proto_opts = 1021,         /* radv_proto_opts  */
  YYSYMBOL_radv_proto = 1022,              /* radv_proto  */
  YYSYMBOL_radv_iface_start = 1023,        /* radv_iface_start  */
  YYSYMBOL_radv_iface_item = 1024,         /* radv_iface_item  */
  YYSYMBOL_1025_27 = 1025,                 /* $@27  */
  YYSYMBOL_1026_28 = 1026,                 /* $@28  */
  YYSYMBOL_radv_preference = 1027,         /* radv_preference  */
  YYSYMBOL_radv_iface_finish = 1028,       /* radv_iface_finish  */
  YYSYMBOL_radv_iface_opts = 1029,         /* radv_iface_opts  */
  YYSYMBOL_radv_iface_opt_list = 1030,     /* radv_iface_opt_list  */
  YYSYMBOL_radv_iface = 1031,              /* radv_iface  */
  YYSYMBOL_radv_prefix_start = 1032,       /* radv_prefix_start  */
  YYSYMBOL_radv_prefix_item = 1033,        /* radv_prefix_item  */
  YYSYMBOL_radv_prefix_finish = 1034,      /* radv_prefix_finish  */
  YYSYMBOL_radv_prefix_opts = 1035,        /* radv_prefix_opts  */
  YYSYMBOL_radv_prefix_opt_list = 1036,    /* radv_prefix_opt_list  */
  YYSYMBOL_radv_prefix = 1037,             /* radv_prefix  */
  YYSYMBOL_radv_rdnss_node = 1038,         /* radv_rdnss_node  */
  YYSYMBOL_radv_rdnss_start = 1039,        /* radv_rdnss_start  */
  YYSYMBOL_radv_rdnss_item = 1040,         /* radv_rdnss_item  */
  YYSYMBOL_radv_rdnss_finish = 1041,       /* radv_rdnss_finish  */
  YYSYMBOL_radv_rdnss_opts = 1042,         /* radv_rdnss_opts  */
  YYSYMBOL_radv_rdnss = 1043,              /* radv_rdnss  */
  YYSYMBOL_radv_dnssl_node = 1044,         /* radv_dnssl_node  */
  YYSYMBOL_radv_dnssl_start = 1045,        /* radv_dnssl_start  */
  YYSYMBOL_radv_dnssl_item = 1046,         /* radv_dnssl_item  */
  YYSYMBOL_radv_dnssl_finish = 1047,       /* radv_dnssl_finish  */
  YYSYMBOL_radv_dnssl_opts = 1048,         /* radv_dnssl_opts  */
  YYSYMBOL_radv_dnssl = 1049,              /* radv_dnssl  */
  YYSYMBOL_radv_mult = 1050,               /* radv_mult  */
  YYSYMBOL_radv_sensitive = 1051,          /* radv_sensitive  */
  YYSYMBOL_rip_variant = 1052,             /* rip_variant  */
  YYSYMBOL_rip_proto_start = 1053,         /* rip_proto_start  */
  YYSYMBOL_rip_proto_item = 1054,          /* rip_proto_item  */
  YYSYMBOL_rip_proto_opts = 1055,          /* rip_proto_opts  */
  YYSYMBOL_rip_proto = 1056,               /* rip_proto  */
  YYSYMBOL_rip_iface_start = 1057,         /* rip_iface_start  */
  YYSYMBOL_rip_iface_finish = 1058,        /* rip_iface_finish  */
  YYSYMBOL_rip_iface_item = 1059,          /* rip_iface_item  */
  YYSYMBOL_rip_auth = 1060,                /* rip_auth  */
  YYSYMBOL_rip_iface_opts = 1061,          /* rip_iface_opts  */
  YYSYMBOL_rip_iface_opt_list = 1062,      /* rip_iface_opt_list  */
  YYSYMBOL_rip_iface = 1063,               /* rip_iface  */
  YYSYMBOL_cmd_SHOW_RIP_INTERFACES = 1064, /* cmd_SHOW_RIP_INTERFACES  */
  YYSYMBOL_cmd_SHOW_RIP_NEIGHBORS = 1065,  /* cmd_SHOW_RIP_NEIGHBORS  */
  YYSYMBOL_rpki_proto_start = 1066,        /* rpki_proto_start  */
  YYSYMBOL_rpki_proto = 1067,              /* rpki_proto  */
  YYSYMBOL_rpki_proto_opts = 1068,         /* rpki_proto_opts  */
  YYSYMBOL_rpki_proto_item = 1069,         /* rpki_proto_item  */
  YYSYMBOL_rpki_keep_interval = 1070,      /* rpki_keep_interval  */
  YYSYMBOL_rpki_proto_item_port = 1071,    /* rpki_proto_item_port  */
  YYSYMBOL_rpki_cache_addr = 1072,         /* rpki_cache_addr  */
  YYSYMBOL_rpki_transport = 1073,          /* rpki_transport  */
  YYSYMBOL_rpki_transport_tcp_init = 1074, /* rpki_transport_tcp_init  */
  YYSYMBOL_rpki_transport_tcp_opts_list = 1075, /* rpki_transport_tcp_opts_list  */
  YYSYMBOL_rpki_transport_tcp_opts = 1076, /* rpki_transport_tcp_opts  */
  YYSYMBOL_rpki_transport_tcp_item = 1077, /* rpki_transport_tcp_item  */
  YYSYMBOL_rpki_transport_tcp_check = 1078, /* rpki_transport_tcp_check  */
  YYSYMBOL_rpki_transport_ssh_init = 1079, /* rpki_transport_ssh_init  */
  YYSYMBOL_rpki_transport_ssh_opts = 1080, /* rpki_transport_ssh_opts  */
  YYSYMBOL_rpki_transport_ssh_item = 1081, /* rpki_transport_ssh_item  */
  YYSYMBOL_rpki_transport_ssh_check = 1082, /* rpki_transport_ssh_check  */
  YYSYMBOL_static_proto_start = 1083,      /* static_proto_start  */
  YYSYMBOL_static_proto = 1084,            /* static_proto  */
  YYSYMBOL_stat_nexthop = 1085,            /* stat_nexthop  */
  YYSYMBOL_1086_29 = 1086,                 /* $@29  */
  YYSYMBOL_stat_nexthops = 1087,           /* stat_nexthops  */
  YYSYMBOL_stat_mpls = 1088,               /* stat_mpls  */
  YYSYMBOL_stat_route0 = 1089,             /* stat_route0  */
  YYSYMBOL_1090_30 = 1090,                 /* $@30  */
  YYSYMBOL_stat_route = 1091,              /* stat_route  */
  YYSYMBOL_1092_31 = 1092,                 /* $@31  */
  YYSYMBOL_stat_aspa_provider = 1093,      /* stat_aspa_provider  */
  YYSYMBOL_stat_aspa_providers = 1094,     /* stat_aspa_providers  */
  YYSYMBOL_stat_route_item = 1095,         /* stat_route_item  */
  YYSYMBOL_stat_route_opts = 1096,         /* stat_route_opts  */
  YYSYMBOL_stat_route_opt_list = 1097,     /* stat_route_opt_list  */
  YYSYMBOL_1098_32 = 1098,                 /* $@32  */
  YYSYMBOL_cmd_SHOW_STATIC = 1099,         /* cmd_SHOW_STATIC  */
  YYSYMBOL_kern_proto = 1100,              /* kern_proto  */
  YYSYMBOL_kern_sys_item = 1101,           /* kern_sys_item  */
  YYSYMBOL_attr_bit = 1102,                /* attr_bit  */
  YYSYMBOL_log_begin = 1103,               /* log_begin  */
  YYSYMBOL_log_config = 1104,              /* log_config  */
  YYSYMBOL_syslog_name = 1105,             /* syslog_name  */
  YYSYMBOL_log_limit = 1106,               /* log_limit  */
  YYSYMBOL_log_file = 1107,                /* log_file  */
  YYSYMBOL_log_udp_host = 1108,            /* log_udp_host  */
  YYSYMBOL_log_udp_port = 1109,            /* log_udp_port  */
  YYSYMBOL_log_mask = 1110,                /* log_mask  */
  YYSYMBOL_log_mask_list = 1111,           /* log_mask_list  */
  YYSYMBOL_log_cat = 1112,                 /* log_cat  */
  YYSYMBOL_mrtdump_base = 1113,            /* mrtdump_base  */
  YYSYMBOL_cli = 1114,                     /* cli  */
  YYSYMBOL_cli_opts = 1115,                /* cli_opts  */
  YYSYMBOL_cli_opts_begin = 1116,          /* cli_opts_begin  */
  YYSYMBOL_cli_opts_block = 1117,          /* cli_opts_block  */
  YYSYMBOL_thread_group = 1118,            /* thread_group  */
  YYSYMBOL_thread_group_start = 1119,      /* thread_group_start  */
  YYSYMBOL_thread_group_opt = 1120,        /* thread_group_opt  */
  YYSYMBOL_thread_group_opts = 1121,       /* thread_group_opts  */
  YYSYMBOL_thread_group_opt_list = 1122,   /* thread_group_opt_list  */
  YYSYMBOL_thread_group_end = 1123,        /* thread_group_end  */
  YYSYMBOL_debug_unix = 1124,              /* debug_unix  */
  YYSYMBOL_latency_debug_mask = 1125,      /* latency_debug_mask  */
  YYSYMBOL_latency_debug_list = 1126,      /* latency_debug_list  */
  YYSYMBOL_latency_debug_flag = 1127,      /* latency_debug_flag  */
  YYSYMBOL_cmd_CONFIGURE = 1128,           /* cmd_CONFIGURE  */
  YYSYMBOL_cmd_CONFIGURE_SOFT = 1129,      /* cmd_CONFIGURE_SOFT  */
  YYSYMBOL_cmd_CONFIGURE_CONFIRM = 1130,   /* cmd_CONFIGURE_CONFIRM  */
  YYSYMBOL_cmd_CONFIGURE_UNDO = 1131,      /* cmd_CONFIGURE_UNDO  */
  YYSYMBOL_cmd_CONFIGURE_STATUS = 1132,    /* cmd_CONFIGURE_STATUS  */
  YYSYMBOL_cmd_CONFIGURE_CHECK = 1133,     /* cmd_CONFIGURE_CHECK  */
  YYSYMBOL_cmd_DOWN = 1134,                /* cmd_DOWN  */
  YYSYMBOL_cmd_GRACEFUL_RESTART = 1135,    /* cmd_GRACEFUL_RESTART  */
  YYSYMBOL_cmd_SHOW_THREADS = 1136,        /* cmd_SHOW_THREADS  */
  YYSYMBOL_cmd_SHOW_THREADS_ALL = 1137,    /* cmd_SHOW_THREADS_ALL  */
  YYSYMBOL_cfg_name = 1138,                /* cfg_name  */
  YYSYMBOL_cfg_timeout = 1139,             /* cfg_timeout  */
  YYSYMBOL_kern_proto_start = 1140,        /* kern_proto_start  */
  YYSYMBOL_kern_learn = 1141,              /* kern_learn  */
  YYSYMBOL_kern_mp_limit = 1142,           /* kern_mp_limit  */
  YYSYMBOL_kern_channel = 1143,            /* kern_channel  */
  YYSYMBOL_kern_item = 1144,               /* kern_item  */
  YYSYMBOL_kif_proto_start = 1145,         /* kif_proto_start  */
  YYSYMBOL_kif_proto = 1146,               /* kif_proto  */
  YYSYMBOL_kif_item = 1147,                /* kif_item  */
  YYSYMBOL_kif_iface_start = 1148,         /* kif_iface_start  */
  YYSYMBOL_kif_iface_item = 1149,          /* kif_iface_item  */
  YYSYMBOL_kif_iface_opts = 1150,          /* kif_iface_opts  */
  YYSYMBOL_kif_iface_opt_list = 1151,      /* kif_iface_opt_list  */
  YYSYMBOL_kif_iface = 1152                /* kif_iface  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
# define YYCOPY_NEEDED 1
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  87
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   6889

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  610
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  543
/* YYNRULES -- Number of rules.  */
#define YYNRULES  1718
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  3253

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   841


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    44,     2,     2,     2,    43,    38,     2,
      61,    62,    41,    39,    86,    40,    45,    42,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   157,    60,
      33,    32,    34,   160,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   158,     2,   159,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    87,    37,    88,    35,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    36,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
     428,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,   446,   447,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,   602,   603,   604,   605,   606,   607,
     608,   609
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,    57,    57,    57,    57,    57,    57,    57,    57,    57,
      57,    57,   204,   205,   208,   210,   213,   218,   221,   228,
     232,   235,   235,   236,   242,   243,   247,   248,   249,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   279,   280,
     281,   285,   286,   293,   299,   309,   315,   334,   362,   368,
     374,   382,   390,   396,   402,   402,   403,   403,   404,   404,
     407,   408,   409,   410,   411,   412,   413,   420,   421,   429,
     430,   438,   439,   447,   448,   455,   463,   464,   478,   485,
     486,   490,   491,   495,   506,   507,   511,   512,   520,   521,
     522,   534,   535,   536,   537,   538,   550,   551,   552,   553,
     562,   563,   564,    37,    38,    39,    40,    41,    42,    43,
      44,    48,    49,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    65,    66,    67,    70,    71,    75,    79,
      83,    84,    88,    92,   101,   102,   106,   110,   114,   121,
     122,   126,   127,   128,   129,   133,   136,   139,   145,   149,
     150,   151,   155,   159,   165,   166,   167,   170,   172,   175,
     177,   181,   188,   189,   191,   197,   203,   203,     9,     9,
      10,    10,    11,    11,   404,   413,   415,   415,   430,   432,
     435,   436,   451,   453,   464,   466,   480,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,   519,   518,   528,   529,   538,   539,
     547,   548,   555,   556,   559,   562,   566,   566,   581,   581,
     591,   597,   600,   605,   600,   633,   634,   637,   637,   639,
     647,   648,   670,   671,   684,   685,   686,   687,   688,   696,
     697,   706,   710,   713,   714,   715,   716,   717,   718,   719,
     720,   721,   722,   727,   728,   729,   730,   734,   735,   736,
     740,   741,   742,   743,   744,   745,   746,   747,   752,   753,
     754,   755,   756,   760,   761,   762,   763,   764,   768,   769,
     773,   774,   778,   779,   783,   784,   785,   786,   794,   795,
     798,   799,   806,   816,   817,   821,   825,   826,   827,   828,
     832,   833,   834,   835,   836,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   854,   855,   859,   860,   861,
     862,   868,   869,   870,   873,   889,   900,   901,   902,   903,
     904,   905,   906,   907,   908,   911,   911,   913,   916,   916,
     921,   926,   936,   937,   938,   939,   940,   941,   942,   943,
     944,   945,   946,   947,   948,   949,   950,   951,   952,   953,
     954,   956,   957,   959,   961,   963,   964,   965,   966,   968,
     969,   970,   971,   972,   974,   976,   977,   978,   980,   982,
     983,   987,   991,   992,   993,   997,  1001,  1008,  1009,  1013,
    1013,  1013,  1014,  1017,  1020,  1026,  1028,  1020,  1033,  1036,
    1052,  1059,  1062,  1065,  1068,  1069,  1072,  1072,  1078,  1079,
    1083,  1088,  1104,   205,   208,   209,   212,   214,   216,   218,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     237,   238,   244,   246,   248,   253,   255,   259,   260,   261,
     266,   267,   268,   272,   273,   274,   275,   282,   284,   287,
     289,   295,   298,   299,   303,   309,   313,   323,   333,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   352,
     358,   363,   364,   370,   371,   372,   373,   374,   375,   383,
     388,   389,   392,   394,   397,   399,   403,   410,   413,   420,
     421,   422,   423,   427,   428,   429,   430,   431,   435,   436,
     440,   443,   444,   445,   446,   447,   452,   455,   459,   460,
     461,   462,   466,   467,   468,   469,   470,   471,   472,   473,
     479,   487,   488,   489,   490,   491,   501,   505,   506,   510,
     515,   516,   520,   522,   530,   534,   535,   540,   542,   550,
     551,   552,   553,   554,   558,   566,   572,   573,   574,   578,
     579,   583,   584,   585,   586,   587,   588,   594,   595,   596,
     600,   601,   605,   606,   612,   616,   617,   620,   622,   626,
     627,   630,   630,   632,   643,   644,   645,   646,   647,   648,
     649,   650,   651,   655,   656,   657,   658,   659,   660,   661,
     662,   663,   664,   665,   666,   667,   668,   672,   678,   684,
     684,   687,   687,   690,   690,   693,   693,   697,   698,   701,
     701,   704,   704,   708,   708,   743,   750,   756,   762,   769,
     776,   783,   790,   796,   801,   806,   810,   814,   818,   828,
     835,   844,   848,   855,   859,   860,   861,   862,   866,   870,
     874,   888,   889,   890,   891,   894,   895,   896,   897,   902,
     903,   904,   905,   906,   907,   908,   909,   910,   911,   912,
     913,   914,   915,   916,   917,   918,   919,   920,   921,   922,
     926,   936,   936,   946,   950,   951,   952,   953,   954,   955,
     959,   959,   961,   961,   963,   963,   965,   965,   967,   967,
     969,   969,   971,   971,   973,   973,   975,   975,   977,   977,
     979,   979,   982,   982,   986,   992,   995,   995,   997,   997,
     999,   999,  1001,  1001,  1003,  1003,  1005,  1005,  1009,  1009,
    1022,  1023,  1027,  1027,  1030,  1030,  1034,  1034,  1044,  1045,
    1046,  1050,  1051,  1052,    31,    33,    35,    38,    41,    43,
      46,    48,    51,    54,    56,    60,    64,    69,    70,    73,
      75,    78,    80,    84,    97,    99,   119,   120,   121,   122,
     126,   127,   128,   129,   130,   131,   134,   136,   139,   141,
     144,   144,   149,   155,   178,   186,   196,   196,    28,    30,
      40,    41,    42,    43,    43,    73,    73,    85,    85,    86,
      90,    91,   105,   127,    36,    38,    59,    60,    65,    66,
      67,    68,    69,    70,    73,    75,    79,    86,    87,    88,
      89,    93,    97,   101,   117,   139,   140,   141,   142,   143,
     144,   147,   149,   153,   156,   161,   162,   163,   167,   168,
     172,   173,   176,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   210,   212,   216,   219,   239,   245,   245,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,    34,
      36,    44,    45,    46,    47,    50,    52,    56,    60,    82,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   177,   179,
     182,   184,   189,   193,   193,   196,   196,   199,   199,   202,
     202,    56,    58,    98,   100,   101,   104,   106,   107,   108,
     109,   110,   115,   116,   120,   121,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   137,   138,   139,   143,   144,
     145,   146,   147,   151,   152,   153,   154,   155,   156,   160,
     161,   167,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   252,   252,   253,
     254,   255,   256,   257,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   275,   286,   292,   297,
     302,   307,   323,   328,   336,   337,   340,   342,   345,   357,
     359,   361,   365,   365,   369,   387,   416,   417,   418,   422,
     423,   424,   427,   427,   427,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   447,   448,
     449,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,   475,   487,   489,   492,
     494,   498,   508,   510,   523,   523,   529,   529,   534,   534,
     540,   551,    49,    52,    65,    67,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    88,    90,    94,    98,    99,
     100,   101,   211,   214,   215,   216,   219,   235,   236,   240,
     241,   245,   254,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   274,   289,
     292,   294,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   307,   308,   308,   309,   310,   311,   315,   316,
     320,   328,   330,   334,   335,   336,   340,   341,   344,   346,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   362,   381,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   422,   424,   427,   429,   437,   439,   440,   443,   445,
     449,   450,   453,   463,   486,   488,   492,   492,   495,   497,
     500,   502,   506,   510,   510,   513,   513,   516,   516,   521,
     521,   524,   524,   529,   529,   532,   532,   536,   536,   553,
     556,   557,   558,   559,   560,   561,   562,   563,    23,    26,
      25,    42,    43,    44,    45,    51,    52,    53,    55,    68,
      69,    70,    71,    72,    72,    73,    73,    74,    75,    76,
      79,    81,    85,    89,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   128,   132,   133,   134,   135,
     136,   137,   137,   138,   138,   139,   140,   141,   142,   146,
     147,   148,   151,   189,   191,   194,   196,   200,   203,   215,
     216,   217,   218,   219,   223,   230,   238,   240,   243,   245,
     249,   253,   263,   268,   269,   270,   274,   286,   288,   292,
     293,   297,   310,   315,   316,   317,   321,   333,   335,   339,
     340,   345,   346,   350,   351,    46,    49,    50,    53,    67,
      68,    69,    70,    71,    72,    75,    77,    81,    85,   111,
     141,   142,   143,   144,   145,   146,   147,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   174,   175,   176,
     177,   180,   182,   185,   187,   191,   196,   196,   199,   199,
      43,    45,    55,    57,    59,    63,    64,    65,    66,    67,
      68,    69,    70,    76,    82,    88,    89,    93,   100,   101,
     104,   106,   124,   125,   129,   135,   137,   140,   142,   146,
     147,   148,   152,   158,   168,   170,   174,   175,   176,   180,
      56,    58,    65,    66,    67,    68,    69,    70,    78,    82,
      82,    94,    97,   100,   105,   109,   117,   118,   121,   123,
     126,   126,   139,   140,   144,   149,   150,   151,   152,   153,
     154,   155,   155,   160,   169,   182,   182,   185,   194,   196,
     199,   201,   201,   205,   205,    26,    28,    35,    36,    37,
      38,    39,    40,    41,    42,    45,    47,    51,    54,    54,
      63,    64,    65,    66,    67,    68,    24,    26,    35,    37,
      42,    50,    51,    52,    55,    56,    63,    70,    73,    76,
      26,    29,    30,    31,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    46,    47,    48,    49,    50,    53,
      54,    57,    34,    36,    38,    45,    46,    49,    51,    55,
      63,    71,    72,    73,    76,    86,    87,    91,    92,    96,
      97,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     113,   116,   117,   127,   129,   135,   135,   137,   145,   147,
     148,   151,   163,   165,   167,   182,   183,   184,   185,   186,
     187,   198,   200,   203,   205,   208,   223,   226,   227,   228,
     229,   233,   234,   235,   238,   238,   241,   242,   243,   244,
     245,   246,   247,   255,   255,   258,   258,   265,   265,   268,
     268,   271,   271,   274,   274,   277,   277,   282,   282,   285,
     285,   288,   288,   292,   293,   297,   298,   299,    43,    45,
      50,    51,    54,    55,    59,    60,    65,    66,    70,    71,
      72,    73,    77,    84,    85,    96,    98,   101,   102,   105,
     106,   107,   114,   121,   124,   126,   129,   131,   135
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "QUIT", "EXIT", "HELP",
  "END", "CLI_MARKER", "INVALID_TOKEN", "ELSECOL", "DDOT", "GEQ", "LEQ",
  "NEQ", "AND", "OR", "IMP", "PP", "PO", "PC", "NUM", "ENUM_TOKEN", "IP4",
  "IP6", "VPN_RD", "CF_SYM_KNOWN", "CF_SYM_UNDEFINED",
  "CF_SYM_METHOD_BARE", "CF_SYM_METHOD_ARGS", "TEXT", "BYTETEXT",
  "PREFIX_DUMMY", "'='", "'<'", "'>'", "'~'", "NMA", "'|'", "'&'", "'+'",
  "'-'", "'*'", "'/'", "'%'", "'!'", "'.'", "DEFINE", "ON", "OFF", "YES",
  "NO", "S", "MS", "US", "PORT", "VPN", "MPLS", "FROM", "MAX", "AS", "';'",
  "'('", "')'", "FLOW4", "FLOW6", "DST", "SRC", "PROTO", "NEXT", "HEADER",
  "DPORT", "SPORT", "ICMP", "TYPE", "CODE", "TCP", "FLAGS", "LENGTH",
  "DSCP", "DONT_FRAGMENT", "IS_FRAGMENT", "FIRST_FRAGMENT",
  "LAST_FRAGMENT", "FRAGMENT", "LABEL", "OFFSET", "','", "'{'", "'}'",
  "FUNCTION", "PRINT", "PRINTN", "UNSET", "RETURN", "ACCEPT", "REJECT",
  "ERROR", "INT", "BOOL", "IP", "PREFIX", "RD", "PAIR", "QUAD", "EC", "LC",
  "ENUM", "SET", "STRING", "BYTESTRING", "BGPMASK", "BGPPATH", "CLIST",
  "ECLIST", "LCLIST", "IF", "THEN", "ELSE", "CASE", "FOR", "IN", "DO",
  "TRUE", "FALSE", "RT", "RO", "UNKNOWN", "GENERIC", "GW", "NET", "SCOPE",
  "DEST", "IFNAME", "IFINDEX", "WEIGHT", "GW_MPLS", "ONLINK", "ROA_CHECK",
  "ASPA_CHECK", "DEFINED", "ADD", "DELETE", "RESET", "PREPEND", "APPEND",
  "EMPTY", "FILTER", "WHERE", "EVAL", "ATTRIBUTE", "FROM_HEX", "BT_ASSERT",
  "BT_TEST_SUITE", "BT_CHECK_ASSIGN", "BT_TEST_SAME", "FORMAT", "STACKS",
  "':'", "'['", "']'", "'?'", "ROUTER", "ID", "HOSTNAME", "PROTOCOL",
  "TEMPLATE", "PREFERENCE", "DISABLED", "DEBUG", "ALL", "DIRECT", "PIPE",
  "INTERFACE", "IMPORT", "EXPORT", "NONE", "VRF", "DEFAULT", "TABLE",
  "TABLES", "STATES", "ROUTES", "FILTERS", "IPV4", "IPV6", "VPN4", "VPN6",
  "ROA4", "ROA6", "SADR", "ASPA", "RECEIVE", "LIMIT", "ACTION", "WARN",
  "BLOCK", "RESTART", "DISABLE", "KEEP", "FILTERED", "RPKI", "PASSWORD",
  "KEY", "PASSIVE", "TO", "EVENTS", "PACKETS", "PROTOCOLS", "CHANNELS",
  "INTERFACES", "ALGORITHM", "KEYED", "HMAC", "MD5", "SHA1", "SHA256",
  "SHA384", "SHA512", "BLAKE2S128", "BLAKE2S256", "BLAKE2B256",
  "BLAKE2B512", "PRIMARY", "STATS", "COUNT", "COMMANDS", "PREEXPORT",
  "NOEXPORT", "EXPORTED", "GENERATE", "BGP", "PASSWORDS", "DESCRIPTION",
  "RELOAD", "OUT", "MRTDUMP", "MESSAGES", "RESTRICT", "MEMORY", "CLASS",
  "PARTIAL", "TIMEFORMAT", "ISO", "SHORT", "LONG", "ROUTE", "BASE", "LOG",
  "GRACEFUL", "WAIT", "CHECK", "LINK", "CORK", "SORTED", "TRIE", "MIN",
  "ROA", "DIGEST", "REFRESH", "SETTLE", "TIME", "GC", "THRESHOLD",
  "PERIOD", "MPLS_LABEL", "MPLS_POLICY", "MPLS_CLASS", "ASPA_PROVIDERS",
  "IPV4_MC", "IPV4_MPLS", "IPV6_MC", "IPV6_MPLS", "IPV6_SADR", "VPN4_MC",
  "VPN4_MPLS", "VPN6_MC", "VPN6_MPLS", "PRI", "SEC", "NET_TYPE", "RTS",
  "RTD", "AF", "SHOW", "STATUS", "SUMMARY", "SYMBOLS", "DUMP", "RESOURCES",
  "SOCKETS", "AO", "KEYS", "NEIGHBORS", "ATTRIBUTES", "ENABLE", "DOMAIN",
  "RANGE", "STATIC", "DYNAMIC", "START", "POLICY", "AGGREGATE", "RANGES",
  "AGGREGATOR", "PEER", "MERGE", "BY", "BABEL", "METRIC", "RXCOST",
  "HELLO", "UPDATE", "WIRED", "WIRELESS", "BUFFER", "PRIORITY", "HOP",
  "ENTRIES", "RANDOMIZE", "MAC", "PERMISSIVE", "EXTENDED", "TUNNEL", "RTT",
  "DECAY", "SEND", "TIMESTAMPS", "COST", "DELAY", "PREFER", "NATIVE",
  "BFD", "IDLE", "RX", "TX", "INTERVAL", "MULTIPLIER", "ADDRESS",
  "EXPRESS", "MULTIHOP", "NEIGHBOR", "DEV", "LOCAL", "AUTHENTICATION",
  "SIMPLE", "METICULOUS", "STRICT", "BIND", "ZERO", "UDP6", "CHECKSUM",
  "SESSIONS", "HOLD", "CONNECT", "RETRY", "KEEPALIVE", "STARTUP", "VIA",
  "SELF", "PATH", "FORGET", "AFTER", "BGP_LOCAL_PREF", "BGP_MED", "SOURCE",
  "RR", "RS", "CLIENT", "CLUSTER", "AS4", "ADVERTISE", "CAPABILITIES",
  "OLDER", "MISSING", "LLADDR", "DROP", "IGNORE", "ENHANCED", "INTERPRET",
  "COMMUNITIES", "IGP", "GATEWAY", "RECURSIVE", "MED", "TTL", "SECURITY",
  "DETERMINISTIC", "SECONDARY", "ALLOW", "PATHS", "AWARE", "SETKEY",
  "CONFEDERATION", "MEMBER", "MULTICAST", "LIVED", "STALE", "IBGP", "EBGP",
  "MANDATORY", "INTERNAL", "EXTERNAL", "SETS", "NAME", "DIGITS", "AIGP",
  "ORIGINATE", "ENFORCE", "FIRST", "FREE", "VALIDATE", "ROLE", "ROLES",
  "PROVIDER", "CUSTOMER", "RS_SERVER", "RS_CLIENT", "REQUIRE", "BGP_OTC",
  "GLOBAL", "RECV", "SIZE", "WARNING", "SINGLE", "DOUBLE", "SECRET",
  "DEPRECATED", "PREFERRED", "CMAC", "AES128", "BGP_ORIGIN", "CEASE",
  "HIT", "ADMINISTRATIVE", "SHUTDOWN", "CONFIGURATION", "CHANGE",
  "DECONFIGURED", "CONNECTION", "REJECTED", "COLLISION", "OF",
  "ASPA_CHECK_UPSTREAM", "ASPA_CHECK_DOWNSTREAM", "BMP", "STATION",
  "SYSTEM", "MONITORING", "RIB", "PRE_POLICY", "POST_POLICY", "L3VPN",
  "TARGET", "DISTINGUISHER", "MRT", "FILENAME", "ALWAYS", "OSPF", "V2",
  "V3", "AREA", "RFC1583COMPAT", "STUB", "TICK", "COST2", "RETRANSMIT",
  "TRANSMIT", "DEAD", "BROADCAST", "BCAST", "NONBROADCAST", "NBMA",
  "POINTOPOINT", "PTP", "POINTOMULTIPOINT", "PTMP", "CRYPTOGRAPHIC",
  "ELIGIBLE", "POLL", "NETWORKS", "HIDDEN", "VIRTUAL", "ONLY", "LARGE",
  "NORMAL", "STUBNET", "TAG", "LSADB", "ECMP", "NSSA", "TRANSLATOR",
  "STABILITY", "LSID", "INSTANCE", "REAL", "NETMASK", "LSA", "SUPPRESSION",
  "RFC5838", "PE", "TOPOLOGY", "STATE", "GENERATION", "RADV", "RA",
  "SOLICITED", "UNICAST", "MANAGED", "OTHER", "CONFIG", "LINGER", "MTU",
  "REACHABLE", "RETRANS", "TIMER", "CURRENT", "VALID", "MULT", "LIFETIME",
  "SKIP", "AUTONOMOUS", "RDNSS", "DNSSL", "NS", "TRIGGER", "SENSITIVE",
  "LOW", "MEDIUM", "HIGH", "PROPAGATE", "CUSTOM", "OPTION", "VALUE", "PD",
  "RA_PREFERENCE", "RIP", "NG", "INFINITY", "TIMEOUT", "GARBAGE", "MODE",
  "VERSION", "SPLIT", "HORIZON", "POISON", "REVERSE", "PLAINTEXT",
  "DEMAND", "CIRCUIT", "REMOTE", "BIRD", "PRIVATE", "PUBLIC", "SSH",
  "TRANSPORT", "USER", "EXPIRE", "PROHIBIT", "BLACKHOLE", "UNREACHABLE",
  "TRANSIT", "PROVIDERS", "KERNEL", "NETLINK", "KRT_LOCK_MTU",
  "KRT_LOCK_WINDOW", "KRT_LOCK_RTT", "KRT_LOCK_RTTVAR",
  "KRT_LOCK_SSTHRESH", "KRT_LOCK_CWND", "KRT_LOCK_ADVMSS",
  "KRT_LOCK_REORDERING", "KRT_LOCK_HOPLIMIT", "KRT_LOCK_INITCWND",
  "KRT_LOCK_RTO_MIN", "KRT_LOCK_INITRWND", "KRT_LOCK_QUICKACK",
  "KRT_LOCK_CONGCTL", "KRT_LOCK_FASTOPEN_NO_COOKIE", "KRT_FEATURE_ECN",
  "KRT_FEATURE_ALLFRAG", "SYSLOG", "TRACE", "INFO", "AUTH", "FATAL", "BUG",
  "STDERR", "SOFT", "UDP", "CLI", "CONFIRM", "UNDO", "LATENCY", "WATCHDOG",
  "PING", "WAKEUP", "SCHEDULING", "TIMERS", "ALLOCATOR", "FIXED", "THREAD",
  "THREADS", "GROUP", "CONFIGURE", "DOWN", "PERSIST", "SCAN", "LEARN",
  "DEVICE", "$accept", "cli_cmd", "cmd_QUIT", "cmd_EXIT", "cmd_HELP",
  "config", "conf_entries", "conf", "definition", "conf_expr", "symbol",
  "symbol_known", "expr", "expr_us", "bool", "ipa", "ipa_scope", "pxlen4",
  "net_ip4_", "net_ip6_slash", "net_ip6_", "net_ip6_sadr_", "net_vpn4_",
  "net_vpn6_", "net_roa4_", "net_roa6_", "net_mpls_", "net_aspa_",
  "net_ip_", "net_vpn_", "net_roa_", "net_", "net_ip4", "net_ip6",
  "net_ip", "net_any", "label_stack_start", "label_stack", "settle",
  "text", "opttext", "time", "bytestring", "bytestring_expr", "idval",
  "net_or_ipa", "text_or_ipa", "bytestring_or_text", "flow_num_op",
  "flow_logic_op", "flow_num_type_", "flow_num_type", "flow_flag_type",
  "flow_frag_type", "flow_srcdst", "flow_num_opts",
  "flow_num_opt_ext_expr", "flow_num_opt_ext", "flow_bmk_opts", "flow_neg",
  "flow_frag_val", "flow_frag_opts", "flow4_item", "flow6_item",
  "flow4_opts", "flow6_opts", "flow_builder_init", "flow_builder_set_ipv4",
  "flow_builder_set_ipv6", "net_flow4_", "net_flow6_", "net_flow_",
  "enum_type", "filter_def", "$@1", "filter_eval", "custom_attr",
  "bt_test_suite", "bt_test_same", "type", "@2", "function_argsn",
  "function_args", "function_vars", "function_type", "filter_body",
  "filter", "$@3", "where_filter", "$@4", "function_body", "function_def",
  "$@5", "$@6", "cmds", "cmd_var", "cmd_prep", "cmds_int", "fipa",
  "set_atom0", "set_atom", "switch_atom", "cnum", "pair_item", "ec_kind",
  "ec_item", "lc_item", "set_item", "switch_item", "ec_items", "set_items",
  "switch_items", "fprefix", "fprefix_set", "switch_body", "bgp_path_expr",
  "bgp_path", "bgp_path_tail", "constant", "constructor", "var_list_r",
  "var_list", "function_call", "static_attr", "term_dot_method", "$@7",
  "method_name_cont", "$@8", "term", "term_bs", "break_command", "var",
  "for_var", "cmd", "$@9", "$@10", "$@11", "$@12", "$@13", "$@14",
  "get_cf_position", "lvalue", "rtrid", "hostname_override", "gr_opts",
  "net_type_base", "net_type", "table", "table_start", "table_sorted",
  "table_opt", "table_opts", "table_opt_list", "proto_start", "proto_name",
  "proto_item", "channel_start", "channel_item_", "channel_item",
  "channel_opts", "channel_opt_list", "channel_end", "proto_channel",
  "rtable", "imexport", "limit_action", "limit_spec", "debug_default",
  "timeformat_base", "timeformat_which", "timeformat_spec",
  "iface_patt_node_init", "iface_patt_node_body", "iface_negate",
  "iface_patt_node", "iface_patt_list", "iface_patt_list_nopx",
  "iface_patt_init", "iface_patt", "tos", "proto", "dev_proto_start",
  "dev_proto", "dev_iface_init", "dev_iface_patt", "debug_mask",
  "debug_list", "debug_flag", "mrtdump_mask", "mrtdump_list",
  "mrtdump_flag", "password_list", "password_list_body", "password_items",
  "password_item", "pass_key", "password_item_begin",
  "password_item_params", "password_algorithm", "password_item_end",
  "bfd_opts", "cmd_SHOW_STATUS", "cmd_SHOW_MEMORY", "cmd_SHOW_PROTOCOLS",
  "cmd_SHOW_PROTOCOLS_ALL", "optproto", "cmd_SHOW_INTERFACES",
  "cmd_SHOW_INTERFACES_SUMMARY", "cmd_SHOW_ROUTE", "r_args", "r_args_for",
  "r_args_for_val", "export_mode", "channel_sym", "channel_arg",
  "cmd_SHOW_SYMBOLS", "sym_args", "cmd_DUMP_RESOURCES", "cmd_DUMP_SOCKETS",
  "cmd_DUMP_AO_KEYS", "cmd_DUMP_EVENTS", "cmd_DUMP_INTERFACES",
  "cmd_DUMP_NEIGHBORS", "cmd_DUMP_ATTRIBUTES", "cmd_DUMP_ROUTES",
  "cmd_DUMP_TABLES", "cmd_DUMP_PROTOCOLS", "cmd_DUMP_FILTER_ALL",
  "cmd_EVAL", "partial_opt", "cmd_DISABLE", "cmd_ENABLE", "cmd_RESTART",
  "cmd_RELOAD_FILTERS", "cmd_RELOAD_FILTERS_IN", "cmd_RELOAD_FILTERS_OUT",
  "cmd_DEBUG", "debug_args", "cmd_MRTDUMP", "cmd_RESTRICT",
  "cmd_TIMEFORMAT", "proto_patt", "proto_patt2", "mpls_domain",
  "mpls_domain_start", "mpls_domain_opt", "mpls_domain_opts",
  "mpls_domain_opt_list", "mpls_domain_end", "mpls_range",
  "mpls_range_start", "mpls_range_opt", "mpls_range_opts",
  "mpls_range_opt_list", "mpls_range_end", "mpls_channel",
  "mpls_channel_start", "mpls_label_policy", "mpls_channel_opt",
  "mpls_channel_opts", "mpls_channel_opt_list", "mpls_channel_end", "$@15",
  "show_mpls_ranges_args", "cmd_SHOW_MPLS_RANGES",
  "aggregator_proto_start", "aggregator_proto_item", "$@16", "$@17",
  "aggregator_proto_opts", "aggregator_proto", "aggr_list", "aggr_item",
  "babel_proto_start", "babel_proto_item", "babel_proto_opts",
  "babel_proto", "babel_iface_start", "babel_iface_finish",
  "babel_iface_item", "babel_iface_opts", "babel_iface_opt_list",
  "babel_iface", "cmd_SHOW_BABEL_INTERFACES", "cmd_SHOW_BABEL_NEIGHBORS",
  "cmd_SHOW_BABEL_ENTRIES", "cmd_SHOW_BABEL_ROUTES", "bfd_proto_start",
  "bfd_proto_item", "bfd_proto_opts", "bfd_proto", "bfd_accept_item",
  "bfd_accept", "bfd_iface_start", "bfd_iface_finish", "bfd_auth_type",
  "bfd_iface_opt_list", "bfd_iface", "bfd_multihop", "bfd_neigh_iface",
  "bfd_neigh_local", "bfd_neigh_multihop", "bfd_neighbor", "bfd_item",
  "bfd_items", "bfd_opts_start", "bfd_opts_end", "cmd_SHOW_BFD_SESSIONS",
  "bfd_show_sessions_args", "bgp_proto_start", "bgp_loc_opts",
  "bgp_nbr_opts", "bgp_cease_mask", "bgp_cease_list", "bgp_cease_flag",
  "bgp_auth_type", "bgp_role_name", "bgp_proto", "$@18", "$@19", "bgp_afi",
  "tcp_ao_key_start", "tcp_ao_key_opt", "tcp_ao_algorithm",
  "tcp_ao_key_opts", "tcp_ao_key_end", "tcp_ao_key", "tcp_ao_keys",
  "tcp_ao_key_list", "$@20", "tcp_ao_end", "bgp_channel_start", "bgp_nh",
  "bgp_llnh", "bgp_lladdr", "bgp_channel_item", "bgp_channel_opts",
  "bgp_channel_opt_list", "bgp_channel_end", "bgp_proto_channel",
  "cmd_RELOAD_BGP", "cmd_RELOAD_BGP_IN", "cmd_RELOAD_BGP_OUT",
  "bmp_proto_start", "bmp_station_address", "bmp_proto",
  "l3vpn_channel_start", "l3vpn_channel", "l3vpn_proto_start",
  "l3vpn_proto_item", "l3vpn_proto_opts", "l3vpn_proto", "l3vpn_targets",
  "mrt_proto_start", "mrt_proto_item", "mrt_proto_opts", "mrt_proto",
  "cmd_MRT_DUMP", "mrt_dump_args", "ospf_variant", "ospf_proto_start",
  "ospf_proto", "ospf_af_mc", "ospf_channel_start", "ospf_channel",
  "ospf_proto_item", "ospf_area_start", "ospf_area", "ospf_area_opts",
  "ospf_area_item", "$@21", "$@22", "ospf_stubnet", "ospf_stubnet_start",
  "ospf_stubnet_opts", "ospf_stubnet_item", "ospf_vlink",
  "ospf_vlink_opts", "ospf_vlink_item", "ospf_vlink_start",
  "ospf_iface_item", "pref_list", "pref_item", "pref_base", "pref_opt",
  "nbma_list", "nbma_eligible", "nbma_item", "ospf_iface_start",
  "ospf_instance_id", "ospf_iface_patt_list", "$@23", "ospf_iface_opts",
  "ospf_iface_opt_list", "ospf_iface", "cmd_SHOW_OSPF",
  "cmd_SHOW_OSPF_NEIGHBORS", "cmd_SHOW_OSPF_INTERFACE",
  "cmd_SHOW_OSPF_TOPOLOGY", "cmd_SHOW_OSPF_TOPOLOGY_ALL",
  "cmd_SHOW_OSPF_STATE", "cmd_SHOW_OSPF_STATE_ALL", "cmd_SHOW_OSPF_LSADB",
  "lsadb_args", "pipe_proto_start", "$@24", "pipe_proto",
  "radv_proto_start", "radv_proto_item", "$@25", "$@26", "radv_proto_opts",
  "radv_proto", "radv_iface_start", "radv_iface_item", "$@27", "$@28",
  "radv_preference", "radv_iface_finish", "radv_iface_opts",
  "radv_iface_opt_list", "radv_iface", "radv_prefix_start",
  "radv_prefix_item", "radv_prefix_finish", "radv_prefix_opts",
  "radv_prefix_opt_list", "radv_prefix", "radv_rdnss_node",
  "radv_rdnss_start", "radv_rdnss_item", "radv_rdnss_finish",
  "radv_rdnss_opts", "radv_rdnss", "radv_dnssl_node", "radv_dnssl_start",
  "radv_dnssl_item", "radv_dnssl_finish", "radv_dnssl_opts", "radv_dnssl",
  "radv_mult", "radv_sensitive", "rip_variant", "rip_proto_start",
  "rip_proto_item", "rip_proto_opts", "rip_proto", "rip_iface_start",
  "rip_iface_finish", "rip_iface_item", "rip_auth", "rip_iface_opts",
  "rip_iface_opt_list", "rip_iface", "cmd_SHOW_RIP_INTERFACES",
  "cmd_SHOW_RIP_NEIGHBORS", "rpki_proto_start", "rpki_proto",
  "rpki_proto_opts", "rpki_proto_item", "rpki_keep_interval",
  "rpki_proto_item_port", "rpki_cache_addr", "rpki_transport",
  "rpki_transport_tcp_init", "rpki_transport_tcp_opts_list",
  "rpki_transport_tcp_opts", "rpki_transport_tcp_item",
  "rpki_transport_tcp_check", "rpki_transport_ssh_init",
  "rpki_transport_ssh_opts", "rpki_transport_ssh_item",
  "rpki_transport_ssh_check", "static_proto_start", "static_proto",
  "stat_nexthop", "$@29", "stat_nexthops", "stat_mpls", "stat_route0",
  "$@30", "stat_route", "$@31", "stat_aspa_provider",
  "stat_aspa_providers", "stat_route_item", "stat_route_opts",
  "stat_route_opt_list", "$@32", "cmd_SHOW_STATIC", "kern_proto",
  "kern_sys_item", "attr_bit", "log_begin", "log_config", "syslog_name",
  "log_limit", "log_file", "log_udp_host", "log_udp_port", "log_mask",
  "log_mask_list", "log_cat", "mrtdump_base", "cli", "cli_opts",
  "cli_opts_begin", "cli_opts_block", "thread_group", "thread_group_start",
  "thread_group_opt", "thread_group_opts", "thread_group_opt_list",
  "thread_group_end", "debug_unix", "latency_debug_mask",
  "latency_debug_list", "latency_debug_flag", "cmd_CONFIGURE",
  "cmd_CONFIGURE_SOFT", "cmd_CONFIGURE_CONFIRM", "cmd_CONFIGURE_UNDO",
  "cmd_CONFIGURE_STATUS", "cmd_CONFIGURE_CHECK", "cmd_DOWN",
  "cmd_GRACEFUL_RESTART", "cmd_SHOW_THREADS", "cmd_SHOW_THREADS_ALL",
  "cfg_name", "cfg_timeout", "kern_proto_start", "kern_learn",
  "kern_mp_limit", "kern_channel", "kern_item", "kif_proto_start",
  "kif_proto", "kif_item", "kif_iface_start", "kif_iface_item",
  "kif_iface_opts", "kif_iface_opt_list", "kif_iface", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-2666)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1027)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     220,   217,   236,  1248,   355,   467,   497,  5323,   496,   703,
     703,    37,   703,   504,   170,   369,   510,  1615,   703,   264,
      85,   570, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  1253,
     317, -2666, -2666, -2666,  1253,   383,  5323,  4141,   611,   645,
     628,  1349, -2666, -2666,   -49, -2666,   610, -2666, -2666, -2666,
   -2666, -2666,   866,  1068, -2666,   619,  1349,   260,   242,  1135,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666,   712, -2666,   649,  3897, -2666, -2666, -2666,  1314,
     840, -2666,   869,  1314, -2666,  1314, -2666,  1314, -2666,  1314,
    5680,  1314,   930,  1314, -2666,  1314, -2666,  1314,  1974,   886,
      74,  1314, -2666,  1314, -2666,  1314, -2666,  1314,  2314,  1699,
   -2666, -2666, -2666, -2666,   907, -2666,  1314,  1314,   166, -2666,
   -2666, -2666,  2864, -2666, -2666,   908,   987,  1308,  1022, -2666,
   -2666,   949,   168,  5323,  1135,  3707,  1058,  1069, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  1038,
    1041,  1107,  1114,  1120,  1123,  1152,  1157,  1195,  1241,  1443,
    1135,  1255,  1275, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
    1251,  1327,  1286, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,  6808, -2666, -2666, -2666,  1321, -2666,
   -2666,   182,  1386,   182, -2666,  1372,  1372,   682,   684,   520,
   -2666, -2666, -2666,  5323,  1243, -2666, -2666,  1135,  1409,  1417,
    1127,   704,   223,  1433, -2666,  1454, -2666,  1445,   923,  1164,
     221,   501,   197,  1334,  1349,  1349,  1349,  1349,  1349,  1349,
    1349,  1252,  1349,  1349,  1372, -2666,  1349,  1564,  1349,  1590,
    1595, -2666,  1065, -2666, -2666, -2666,  1576,  1253, -2666,  1135,
   -2666,  6844, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  1599,
   -2666,   935,  1585,  1604,  1780,  1555,   182,   182,   182,  1135,
    1390,   961, -2666,   520,  1582, -2666, -2666, -2666, -2666,   170,
      67,  1395, -2666,  1135,  1135,  1253, -2666, -2666, -2666,  1253,
   -2666,  1565, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666,  1088, -2666,  1136, -2666, -2666, -2666, -2666,
    1623,  1593,  1574, -2666,  1512,  1349,  2011,   182, -2666,   641,
    1416,  1349,   520,  1439,  1089, -2666,  1641,  1656,  1661,  1705,
   -2666, -2666,  1660,  1673,  1683,  1694, -2666,   493, -2666, -2666,
   -2666,    22,  2011,  1707,   224,  1216,    35,   113,   121,   122,
     478,  1349,  2011,  1315,  1583,  1535,   524,  1703,   -45,  1405,
    1465,  1446,  1441,  2538,  1382,  1184,   239,   111,   653,  1470,
    1567,   426,  1605,  1501,  1547,  1532,  1301,  1507,  1725,  2011,
    1518,  1594,  1598,  1534,  1538,   429,  2011,   136,  1516,  1579,
     880,  1868,  1872,  1852, -2666,  1861,  1914,  1896, -2666,  1672,
    1651,  1653,   -46,  1539,  1931,  1905,  1911,  1919,  1509, -2666,
   -2666,  1813,  1609,  1342,  2011,  1851,  1135,  2011,  1855,  2011,
    1619, -2666,  1656, -2666,  1954,  1934, -2666, -2666,  1523, -2666,
    1135,  1637,  1626,  2001,  1836,  1800,  1856,  1979,  1981,  1959,
    1961,  1963,  1968, -2666,  1183,  1816,  1886,  2008,  2009,  2013,
     137,  1983, -2666,  1878,  1686,  1135,  1898,  1752,  2011,  1840,
    1606, -2666, -2666, -2666,  2042, -2666,  2044, -2666, -2666,  2020,
    2021, -2666, -2666,  1849, -2666,  2054,   489, -2666,  2864,  2864,
    5323,  1695,  2864,  2864,  2096, -2666,  2099, -2666, -2666,   908,
     987, -2666,  2100, -2666,  5323,  2084,   186,  2086,  2091, -2666,
   -2666, -2666,  2118, -2666,  2053,  5006, -2666, -2666,  2001,  2001,
    5323,  5323,  5323,  5323,  5323,  5323,  5323,  5323, -2666, -2666,
   -2666, -2666,  1955, -2666, -2666, -2666,  1261, -2666, -2666,  2136,
   -2666, -2666, -2666, -2666,   130, -2666,   142, -2666,  2001,  2001,
    1135,  2090,  1135, -2666,  5323,  5323,  5323,  5323,  5323,  5323,
    5323,  5323,  5323,  5323,  5323,  5323,  5323,  5323,  5323,  5323,
    5323, -2666,  3686, -2666,  1634, -2666, -2666, -2666, -2666, -2666,
    2142,  2146,   703,   703,  1913,   703,   703,  2149, -2666,   338,
   -2666,  2150,  6276,  1531,  1631,  1349, -2666, -2666, -2666, -2666,
   -2666,   890,  2157, -2666,  2160, -2666,  5370, -2666,  1125, -2666,
    2161,  1445,  1445,  1445,  1445, -2666,  1445,  1445, -2666,   231,
     358,  2165,  1445,  1445, -2666,  2170,  1349,  2171,  2172,  2173,
    2175,  2178,  2181,  2183,  1349,  2186,  2194,  2197,   680,  2198,
   -2666,  1065, -2666, -2666,  1135,  2202,  5323, -2666,  2113,  1135,
   -2666,   954,  3814, -2666,  2152,  2065,  2127, -2666, -2666, -2666,
   -2666,  2159, -2666, -2666, -2666, -2666, -2666,   182, -2666,    -7,
   -2666,  1135, -2666,  2176, -2666,  2177,  1827, -2666,  1477,  1349,
    1135,   199,  1135, -2666,   823,  1570, -2666, -2666, -2666, -2666,
   -2666, -2666,  1314, -2666, -2666, -2666, -2666,  2195, -2666,  1342,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,  1135, -2666, -2666,  2011,  1253, -2666,
   -2666, -2666, -2666, -2666,  1079, -2666, -2666, -2666, -2666, -2666,
    1838,  2035,  1978,  1980,  2184, -2666, -2666,  2185,  1135,  1135,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  2011,     7,
    2189,  2190,   -10,  1238,  2011,  1858,  2058,  1997,  1999, -2666,
    2200,  2014,  2041,  2011,  2026,   163,  2018,  2022,  2011,  2220,
    2221,  2196,  1863, -2666,  2224, -2666, -2666,  1396, -2666,  2255,
     185,   733,  2255,  1222, -2666, -2666, -2666,  2239,  2011,  1135,
    2049,  2051,  1135,  2057,  2011,  1511,  2011,  2139,  2011,  2011,
    2242,  2011,  2011,  2011,  2011,  2011,  1901,  2254,  2011,  2011,
    2263,  2011,  2268,  2271,  2011,  2011,  1947,  2056,  2135,  2109,
    2011,  2101,  2011, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,  2155,  1511, -2666,  1349,  1349,  2232, -2666, -2666, -2666,
   -2666,  2011,  1285,  2011, -2666, -2666,  2011, -2666,  2163,  1135,
   -2666, -2666, -2666, -2666, -2666, -2666,  1135, -2666,  1183,  2334,
   -2666, -2666, -2666,  1400,  2162, -2666, -2666,  1183,  1400, -2666,
   -2666, -2666,  1400,  2011,  2001, -2666, -2666, -2666, -2666, -2666,
   -2666,  1308, -2666, -2666, -2666,  2011,  2001, -2666, -2666, -2666,
   -2666,  1477, -2666,  1511, -2666, -2666, -2666, -2666, -2666,   207,
    2003, -2666,  2311,  2011,  2011, -2666,  1135,  2059, -2666,  1135,
   -2666, -2666, -2666, -2666, -2666,    17, -2666, -2666, -2666, -2666,
   -2666,  1135, -2666,  2347, -2666, -2666, -2666,  6290, -2666, -2666,
    2864,   395, -2666, -2666, -2666, -2666, -2666,  2286,  2318,  6844,
   -2666,  2230,  2336, -2666, -2666,  5323, -2666,  5323, -2666, -2666,
     925,  2295,  6328,  4630,  5617,  5685,  6066,  6129,  6342,  6380,
    2296,   451,  2297,  6394, -2666, -2666,  2366,  1944,  2174, -2666,
    1308, -2666,  2325,  2327,  2332,  2370,  2335,  3456,  3456,  3456,
    3748,  3748,  1210,  3456,  3456,  3456,  3456,  3456,  1910,  1910,
    1210,  1210,  2091,  2091,  2665, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666,   895, -2666, -2666, -2666,  1913,  1913,  5323,
    2389,  2390,  2393, -2666, -2666, -2666,  1048, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,   208,  2395, -2666, -2666, -2666,
    1727,  1183,  2334,  2379, -2666,  2227,  2233,   556, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,  2387, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666,  1372,  1372,  1372,  1372,
     663,  1372,  1372,   662,  1445,  1372,  1445,  1372, -2666,  1372,
    1372, -2666,  2409, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
    2410, -2666, -2666, -2666, -2666,  2334,  1199,  1349, -2666, -2666,
    2411, -2666, -2666,  6706,  2356,  2403,  2362,  3101, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,   935, -2666,  1349,  1604, -2666,  2365, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666,  1267, -2666, -2666, -2666,
   -2666,  1349, -2666, -2666, -2666, -2666, -2666, -2666,  2372,  1135,
    1349, -2666,   -23, -2666,  2367,  2368, -2666, -2666, -2666, -2666,
   -2666,    92, -2666, -2666, -2666,  2391, -2666,  2346, -2666,  2373,
   -2666,  1339, -2666,  2143, -2666,  2378, -2666,  2358,   379,  1510,
    1572,  2055,  2192,  1135,  1135, -2666, -2666, -2666,  2394,  2398,
    2399,  2011,  2301, -2666, -2666,  2253,  2193,  1135,  2400,  2401,
    2404,  2067,  2206,  1135,  1135, -2666, -2666,  2011,  2011,  2408,
    2211,  1135,  2416,  1135,  1135,  2418, -2666, -2666,  2462, -2666,
    1135, -2666, -2666, -2666, -2666,  1253, -2666,  1135,  1135, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  2419, -2666,
    1135,  1135, -2666, -2666,  2420,  2423,  1135,  1135,  2424,  1135,
    2426,  2429,  2431,  1342,  2432,  2433, -2666,  2443,  2445,  2446,
    2447,  2448,  2011,  1449,  2449,  2476, -2666,  2478, -2666,  2011,
    2479,  2480,  2293,  2011,  2011,  2011,  2484,  2287,  2487,  1012,
   -2666, -2666,  5740, -2666,  1135,  2488,  1016,  2490,  2493,  1264,
    3096,  2922, -2666,  1135, -2666, -2666, -2666, -2666,  1135, -2666,
   -2666,  1039,  2494,  1420, -2666, -2666, -2666,  5323, -2666,  2363,
   -2666,  2011,  1420, -2666, -2666, -2666,  2495,  3523,  2080,  5319,
    2501,  2500,  2502, -2666,  2505,  1135,  1135,  1135,  2011,  2011,
    1349,   207, -2666, -2666, -2666,  2374, -2666,  1135, -2666,  -140,
   -2666,  2011,  2305,  2309,  1135,  2507,  2346,  2483, -2666,  2864,
   -2666, -2666,  2864,  5323, -2666,  2531,  2532,  6164,  5222, -2666,
   -2666, -2666,  5323,  5323, -2666,  5323,  5323,  5323,  5323,  5323,
   -2666, -2666,  4400,  5323,  4562,  5323, -2666,  2492,  5323, -2666,
   -2666, -2666, -2666, -2666,  1135,  2539,  1135, -2666, -2666, -2666,
   -2666, -2666,  1634, -2666,  2578,  2583,  6844, -2666, -2666, -2666,
     338, -2666, -2666, -2666, -2666, -2666, -2666,   908,   753,  1709,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,  2566,  2566, -2666, -2666,  1321, -2666,  2586,  2587,  2588,
    2589, -2666, -2666, -2666, -2666,  1349, -2666, -2666,  1666, -2666,
    1349,  2592,  2594, -2666, -2666,  1135,  1342, -2666, -2666, -2666,
    1342,  1342,  1372,  2595,  1372,  2596,  2597,  2599, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,  3814,  3814, -2666,
   -2666,  3534,   935,  2548,  2547,  2524,  2346, -2666,    -7, -2666,
   -2666,  1135, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,  1270, -2666, -2666, -2666,   -24, -2666,
     182,  2352,  2354,  2353,  2011,  2011,  2355,  1514,  2015,  2556,
   -2666,  1680, -2666, -2666, -2666,   182,  1561, -2666,  2559,   286,
   -2666, -2666, -2666, -2666,  2575,  2451,  2317, -2666, -2666,  2564,
   -2666, -2666,  2465, -2666, -2666,  2567, -2666, -2666, -2666,  2029,
   -2666,  1511,  2284,  2283, -2666,  2577,  2375,  1135,  2552,  2581,
    2584, -2666, -2666, -2666,  2585,   555, -2666,  2590,  1332,  1135,
    2593, -2666, -2666, -2666,  2383,  1135,  2598,  2602,   461, -2666,
    2603,  2604, -2666,  2011,  2605, -2666,  2606,  2607, -2666,  2558,
   -2666,  2609,  2610,   304, -2666,   330, -2666, -2666, -2666,  1309,
   -2666, -2666, -2666, -2666,  2612,  2614, -2666,  2618, -2666, -2666,
   -2666,  2619, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  2620,
   -2666,  2622, -2666, -2666, -2666,  2623, -2666, -2666,  2453,  2624,
    2627,  2635, -2666,  2011, -2666,   942, -2666,  2629, -2666,  2637,
   -2666,  2413,  2331, -2666,  2266,  2036,  1422,  2257,  2481,  2503,
    2359,  2454,  2632,  1135,  2328,  2525,   -32,  2011,  2011,   727,
    2011,     9, -2666,  2647,  2648, -2666,  1135, -2666,  1511, -2666,
   -2666,  2011,  2011, -2666,  2685,  2258,  2259,  1373, -2666, -2666,
   -2666,  1656, -2666,  2652, -2666,  2334,  1293,  1135,  1349,  2573,
   -2666, -2666,  2654, -2666, -2666, -2666, -2666,   214,  2011, -2666,
    2168, -2666,  2464,  1396, -2666,   135,  2657, -2666,  2228, -2666,
    2662, -2666,  6844,  1650, -2666, -2666, -2666, -2666, -2666,  1365,
   -2666, -2666, -2666,  1365,  2542,  2204, -2666, -2666,  2666, -2666,
   -2666,  2011,  1135, -2666, -2666,  2667,  1135,  2187, -2666,  2188,
    2533,  2396,  2533,  2678,  1477,   -21,  2533, -2666, -2666,  2690,
   -2666,  1135, -2666, -2666, -2666,  2255,  1135, -2666, -2666,  2672,
   -2666, -2666,  2696, -2666, -2666, -2666, -2666,  3230,  1135, -2666,
   -2666,  1135,  1135, -2666,  1135,  1135, -2666, -2666, -2666, -2666,
   -2666, -2666,  6844,  2719, -2666,  5323, -2666,  5323,  4004,  4094,
    6199,  6234,  6432,  6446,  6484,  6498,  6536,  1009,   739,  6844,
    2674,  1015,   952,  2675,  2742,  6394, -2666,  2743, -2666,  2703,
   -2666, -2666, -2666, -2666,  2744,   908,   987,  1321, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,   908,   987, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  2760, -2666,
    2762, -2666, -2666, -2666,   935,  2669, -2666, -2666,  5323,  5323,
    2708,  5323, -2666, -2666, -2666,  5323,  5323, -2666,  2711,  2712,
     935,  2686, -2666, -2666,  3534,  2718,  5323, -2666, -2666,   691,
    2721, -2666, -2666,  1135, -2666, -2666,   -23, -2666,  2724,  2729,
    2497, -2666,  2535,  2617,  1135, -2666, -2666,  2543,  1135,  1135,
    1253, -2666,   908,   987,    87,   115, -2666,  1666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,   127, -2666, -2666,  2001, -2666,
   -2666, -2666, -2666,  2630, -2666,   388, -2666, -2666,  2199,  2717,
   -2666,    75, -2666,  2011,  2457, -2666,  1135,  2748,  1135, -2666,
   -2666, -2666,  2625,  2369,  2377, -2666,    -2,  2388,  1391,  1356,
   -2666, -2666,  2749,  2763,  2767, -2666,  1135,  2769, -2666, -2666,
   -2666, -2666,  2746,  2770, -2666, -2666,  2774, -2666, -2666, -2666,
   -2666,  1277, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,  2011, -2666, -2666, -2666,  2775,   226,
     417, -2666, -2666,  2441,   626,  1557,  2011,  2011,  2580,    39,
    2001,  2011,  2773,  2450,  2526, -2666,  1100,  2001, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  2458,  2778, -2666, -2666, -2666,
   -2666,  2783,  2789, -2666,   783,   796,   796,  2826, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  2496, -2666, -2666, -2666,  1135,
    1135,  2011, -2666,  2764,  1135, -2666,  2765,  1342, -2666, -2666,
    2777,  1135, -2666, -2666,  1135,  2779, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,  2780, -2666, -2666, -2666,  1298,  1166,
   -2666,  2011,  2784, -2666, -2666, -2666,  2664, -2666, -2666, -2666,
    1135,  1135, -2666,  1135,  1511,  1135,  2785, -2666,  2807, -2666,
   -2666, -2666,  1135, -2666, -2666, -2666,  2696,  1135,  1135, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,    -4,  2829,  6550,
    6588, -2666, -2666, -2666, -2666,  2801, -2666, -2666,  1784,  2795,
   -2666, -2666, -2666, -2666, -2666, -2666,  2307,  2831,  2831,  1139,
    2812, -2666,  2307,  2831,  2831,  1365,  2813,  5323,  5323, -2666,
   -2666, -2666, -2666, -2666, -2666,  2836,  5323, -2666,  4725, -2666,
    2837,  5323,  2869,  5041,  5184,  2793, -2666,  5323, -2666, -2666,
   -2666,  1431, -2666,  3534,   931,   936,  2857,  6744,  3501,  4894,
    2643, -2666, -2666,   914, -2666, -2666, -2666,   955,  5323, -2666,
   -2666,  2823, -2666, -2666, -2666,  2827,  1135,  2634,  1135,  1135,
   -2666, -2666, -2666, -2666,  1135, -2666,  1135,  2834,   985, -2666,
   -2666,  2799,  2011, -2666, -2666, -2666, -2666, -2666,  2717,  1253,
   -2666, -2666,  1253,  1349,  2549, -2666,  2563,  2839, -2666,  2840,
    2469,  2621, -2666, -2666, -2666, -2666, -2666, -2666,   555, -2666,
   -2666, -2666, -2666,  2846, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,  2011,  2810, -2666,  1530,  2574,  1135,  1135,   688, -2666,
   -2666, -2666,  1141,  2820,  2850,  2851, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  2516,   928,   466,  1511,   928,
   -2666, -2666, -2666, -2666, -2666,  1135,  2720,  2653, -2666, -2666,
    2601,  2518,  2011, -2666, -2666, -2666, -2666, -2666,  2011,  2608,
   -2666, -2666,  1817,   129, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666,  2011,  2346,  2832, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  2842, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  1135,  2843,
    1135, -2666, -2666, -2666, -2666, -2666,  2011, -2666,  2845,  2848,
   -2666, -2666, -2666, -2666,  1511,  2858, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,  2913,  1135,  1862, -2666,  2841, -2666,  1173,  1135,  1921,
    1207, -2666, -2666, -2666, -2666,  1862,  1173,  1207,  2852, -2666,
    6602,  6640,  2874,  2876,  1090,   768,  2877,  1112,  2865,  2879,
     969,  2881,   972, -2666,  2882, -2666, -2666, -2666, -2666, -2666,
    2883, -2666,  3462, -2666, -2666,   935,  2830,  5323,  2828,  5323,
   -2666, -2666,  6758,  2665, -2666, -2666,  1135, -2666,  2687, -2666,
   -2666, -2666, -2666, -2666,  5323, -2666,  2860, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,  1456, -2666, -2666, -2666,  1511,  2615,
    2011, -2666, -2666, -2666, -2666, -2666, -2666,   572, -2666, -2666,
    1692,  2613,  2616,  2631, -2666, -2666, -2666,  1687, -2666,  2738,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,   596, -2666, -2666,
   -2666,  2693, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,  2011,  1135,  2800,  2705, -2666, -2666,  2011, -2666, -2666,
     491, -2666,  2228, -2666, -2666,  1563,  1811,   -17,   764,   237,
   -2666, -2666, -2666, -2666, -2666,  2435, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  1135, -2666, -2666,  1135,  2262,
    1135, -2666,  2831,  2831,  2926, -2666, -2666, -2666, -2666, -2666,
    2831,  2831,  1135, -2666, -2666, -2666, -2666, -2666,  2929,  5323,
   -2666, -2666, -2666,  2930,  5323, -2666,  5323,  2962, -2666,  5323,
   -2666, -2666,  2885,  2914,  2859,  1936, -2666, -2666,  6844, -2666,
    6794, -2666,  2917, -2666,  1135,  6654,   985,  2915, -2666, -2666,
   -2666, -2666,  2011, -2666, -2666, -2666,  1135,   867,  2816,  2817,
    1141,  2920,  2921, -2666,  2887,  2924,  1135,  1135,  1135, -2666,
   -2666,  1724,  1349,   148,  1135,  1349,  2145,   155,  2894,  1135,
   -2666, -2666,   717,  1135, -2666,  2925, -2666, -2666,  4346, -2666,
   -2666, -2666,   437, -2666, -2666,  2011,  1135,  2011,  2931, -2666,
    1135,  1135,   -71,  1135,  2661,   146, -2666,  2934, -2666,  2011,
    2467,  2472,  2011,  2011,  2579,  2944,  1935, -2666,   -22,   -20,
    1019,  3679, -2666,    24, -2666,    55, -2666,  2841,  1135, -2666,
    1135,  1135,  1135,  1921,  1921, -2666,  2943,  2945,  2949,  2927,
    2952,  2954,  2955, -2666, -2666,  3462,  3462, -2666, -2666,  3006,
   -2666, -2666, -2666, -2666,   699,  5323,  2956,  2933, -2666, -2666,
   -2666, -2666, -2666,  1135,  2704,  1324, -2666,  1135,  2772,  1135,
    2691,  2692,  2953,   485,  2699,  2714,   133,   563, -2666,  2969,
   -2666, -2666,  2970,  1700,  2010, -2666, -2666, -2666, -2666,  2626,
   -2666,  2971,  1135,  1135,  2972, -2666, -2666, -2666,  1692, -2666,
   -2666, -2666, -2666, -2666, -2666,  2973,  1349,  1349,  2975,  2977,
    2982,  1349,  1349, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,  2043, -2666,  1135,  2792,  2550,  2957,  1135,  1135,  1135,
    2011,  2731,   525,    -8,  2582,  2663,  2011,  1135,  2723,   654,
    -119,  1135,  2919,  2591, -2666,  2987, -2666,  1135,  2994, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  1135,
    1135, -2666, -2666, -2666,  1135,  1135, -2666, -2666,  2011, -2666,
    2554, -2666,    63,   -58,   -69,  2551,  -165,  2557,  2011,  2555,
    2803,  2546,  2750,  2725,  2730,  2544,  3013, -2666,    52,  1511,
    3014, -2666,  1349,    52,  3016, -2666, -2666, -2666,  1135, -2666,
    2011,    29,  1135,  2819,  2011,  2781,   574,  1511,   -59,  2701,
    2824,  2958,  2833,  2853,  -185,   145,  2534,  2560,  2540, -2666,
    3027, -2666,  1349,    68,  3031, -2666,  2545,  2561,  1349,  3034,
   -2666,  3054,  3057, -2666, -2666, -2666, -2666, -2666, -2666,  5323,
   -2666,  5323, -2666, -2666, -2666,  2108,  2313,  3462,  6844,  3041,
    5323, -2666,   204, -2666, -2666, -2666, -2666,  2011, -2666,  1135,
    1135,  2786,  1135,  1135,  1135,  1135,  2011,  1135,  1135,  1135,
    1135,  1135, -2666, -2666,  2788, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  3046,
    3050, -2666, -2666,   596,  3051,  3060,   596,   596,   596,  3061,
    3062, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,  2011,  2628, -2666, -2666, -2666, -2666, -2666,   132,  1135,
    1135, -2666, -2666, -2666, -2666,  2011,  1831, -2666, -2666,  1135,
    1135, -2666,  2011,  2011, -2666,  1135,  2011, -2666, -2666, -2666,
   -2666, -2666,  2611,  2611, -2666,  2791,  2854, -2666,  1137,  1135,
    1137,  2863,  1135,  1135,  1135,  2794,  2636, -2666,  2011,  1135,
    1135,  2932,  2011,  1298,  2011,  1166,    80, -2666, -2666,  1135,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
    2011,  2011, -2666,  1135, -2666,  1135,  1135,  1135, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  1995,  1135,  1135,  1135,  1135,
   -2666, -2666,  2011, -2666,  2011,  2011,  2011, -2666, -2666, -2666,
   -2666, -2666, -2666,  2928,  2935, -2666, -2666,  1135,  1135,  3065,
    3042, -2666, -2666, -2666,  3010, -2666,  6692,  1511,  1511,   100,
   -2666, -2666, -2666,  2011, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,   596,   596,
   -2666, -2666, -2666,   596,   596, -2666,  2011,  1848, -2666, -2666,
   -2666, -2666, -2666, -2666,  2656, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666,  2011, -2666, -2666,  1135,  1135, -2666, -2666, -2666,
   -2666,  2611, -2666,  1135,  2611, -2666, -2666,  1135,  2011, -2666,
   -2666, -2666,  1135, -2666, -2666, -2666, -2666,  1135,  2011, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666,  2658, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666,  1349,  1349, -2666, -2666,
   -2666,  5323,  3462,  3075, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  2668, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,  2638, -2666, -2666,
   -2666, -2666,  3055, -2666, -2666, -2666,  3083,  1019,  5323, -2666,
   -2666,  3082, -2666
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
      14,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1683,     0,    13,   168,   170,   172,   599,   601,   603,   605,
     609,   611,   613,   671,   680,   682,   684,   686,   688,   690,
     692,   694,   696,   698,   700,   702,   706,   708,   710,   712,
     714,   716,   718,   722,   724,   726,   776,   903,   905,   907,
     909,   847,  1114,  1116,  1118,  1548,  1273,  1275,  1277,  1279,
    1281,  1283,  1285,  1287,  1446,  1448,  1533,  1663,  1665,  1667,
    1669,  1671,  1673,  1675,  1677,  1679,  1681,     1,    12,     0,
     431,    16,   427,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   452,   453,     0,   420,   421,   423,   424,   425,
     426,   429,     0,     0,  1593,     0,     0,     0,     0,     0,
      15,    17,   175,   178,   180,   182,   184,   221,   413,   416,
     418,   430,     0,   432,   435,     0,   500,   506,   451,   454,
     458,   734,   740,   454,   778,   454,   859,   454,   794,   454,
     458,   454,   458,   454,  1122,   454,  1535,   454,   458,     0,
     458,   454,  1307,   454,  1395,   454,  1450,   454,   458,   458,
    1592,  1620,  1623,  1632,  1643,  1646,   454,   454,   458,   169,
     171,   173,   304,   305,   316,   232,   233,   311,   411,   308,
     309,     0,     0,     0,     0,     0,     0,     0,   328,   306,
     307,   326,   327,   329,   330,   331,   332,   333,   334,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1574,  1575,  1576,  1577,  1578,  1579,  1580,
    1581,  1582,  1583,  1584,  1585,  1586,  1587,  1588,  1589,  1590,
      54,     0,    55,    64,    56,    57,    58,    59,    65,    66,
      60,    61,    62,   312,   166,   167,    63,   310,   320,   361,
     362,   380,   412,   364,     0,   379,   363,  1591,   728,   730,
     729,     0,     0,     0,   728,    82,    82,     0,     0,     0,
     725,    23,    79,     0,     0,    80,    19,   512,     0,     0,
       0,   732,     0,     0,   615,     0,   673,   608,     0,     0,
     608,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,  1550,  1683,     0,  1683,     0,
       0,  1684,  1685,  1676,    22,    21,     0,     0,   222,     0,
     176,   179,   186,   187,   188,   190,   189,   191,   192,   193,
     194,   204,   195,   196,   197,   198,   199,   200,   201,     0,
     202,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   509,   508,   510,   511,     0,
       0,     0,  1627,     0,     0,     0,    24,    25,  1631,     0,
     436,   449,   538,  1299,  1451,   912,  1491,   779,   860,   795,
    1557,  1125,  1536,  1143,  1308,  1396,  1689,  1706,  1146,  1398,
       0,   455,     0,   537,     0,     0,    35,     0,   544,     0,
       0,     0,     0,     0,     0,   469,     0,   484,     0,     0,
     738,   742,     0,     0,     0,     0,   755,     0,  1044,  1045,
     911,     0,    35,     0,     0,     0,  1034,  1035,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,     0,     0,   916,   913,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,   768,  1065,  1109,     0,     0,  1556,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   431,
    1142,     0,     0,     0,    35,     0,     0,    35,     0,    35,
    1149,  1153,   484,  1154,     0,     0,  1167,  1301,     0,  1298,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1490,     0,     0,     0,     0,     0,     0,
    1515,  1530,  1688,     0,     0,     0,     0,     0,    35,     0,
      35,  1698,  1696,  1697,     0,  1699,     0,  1641,  1645,     0,
       0,  1705,  1712,     0,  1709,     0,   304,   411,   304,   304,
       0,     0,   304,   304,     0,   293,     0,    44,    45,     0,
       0,    48,     0,    49,   321,     0,     0,     0,   359,    52,
     253,   254,     0,   256,     0,     0,   161,   161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   234,   237,
     236,   240,     0,   313,    54,    55,   284,   235,   239,   271,
     268,   269,   270,   280,     0,   288,     0,    53,     0,     0,
       0,    46,     0,   703,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   335,     0,   547,     0,   546,   721,   719,   720,    81,
       0,     0,     0,     0,   705,     0,     0,     0,   558,     0,
     557,     0,     0,   514,   517,     0,   727,  1678,   772,   731,
     733,   732,     0,   610,     0,   602,     0,   600,     0,   607,
       0,   608,   608,   608,   608,   849,   608,   608,  1289,   608,
     608,     0,   608,   608,  1680,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1672,  1685,  1668,  1670,  1686,     0,     0,   736,     0,     0,
     210,     0,     0,   203,     0,     0,     0,    88,    89,   533,
      90,     0,   417,   503,   501,   502,   504,     0,  1652,     0,
    1651,     0,  1647,     0,  1622,     0,  1596,  1602,     0,     0,
    1597,     0,     0,  1624,     0,     0,  1649,  1650,  1634,   434,
     447,   433,   454,  1144,  1145,  1397,   456,     0,   539,     0,
     464,    36,    29,    32,    30,    33,    31,    34,    37,   459,
     461,   520,   467,   466,     0,   465,   462,    35,     0,   540,
     482,   486,   541,   542,     0,   735,   787,   865,   804,   943,
       0,     0,     0,     0,     0,   963,   533,     0,     0,     0,
    1038,  1036,  1039,  1037,  1040,  1042,  1041,  1043,    35,     0,
       0,     0,     0,    35,    35,     0,     0,     0,     0,  1062,
       0,     0,     0,    35,     0,     0,     0,     0,    35,     0,
       0,     0,     0,   964,     0,    38,    39,     0,    40,    41,
       0,     0,    41,     0,   935,   936,   937,     0,    35,     0,
       0,     0,     0,     0,    35,     0,    35,     0,    35,    35,
       0,    35,    35,    35,    35,    35,     0,     0,    35,    35,
       0,    35,     0,     0,    35,    35,     0,     0,     0,     0,
      35,     0,    35,   944,   946,   766,   770,  1107,  1111,   945,
    1561,     0,     0,  1558,     0,     0,     0,  1562,  1135,  1545,
    1147,    35,    35,    35,  1168,  1155,    35,  1165,  1162,     0,
    1156,  1150,  1151,   486,  1148,  1170,     0,   477,     0,   216,
     218,   491,   492,     0,     0,   490,   471,     0,     0,   473,
     488,   470,     0,    35,     0,  1302,  1303,  1320,  1405,  1453,
    1492,     0,    74,    73,  1510,    35,     0,  1493,  1494,  1495,
    1517,     0,  1516,     0,  1520,  1518,  1519,  1523,  1521,  1506,
    1512,  1531,     0,    35,    35,  1572,     0,     0,  1700,     0,
    1693,  1692,  1702,  1570,  1691,     0,  1633,  1690,  1707,   520,
    1710,     0,  1708,     0,   296,   302,   300,     0,   232,   233,
     304,     0,   301,   303,   295,    43,    46,   324,     0,   322,
     365,     0,     0,   366,   255,     0,   342,     0,   162,   163,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   242,   285,   286,     0,     0,     0,   314,
       0,   315,     0,     0,     0,     0,     0,   356,   354,   352,
     349,   350,   374,   351,   353,   355,   357,   358,   348,   347,
     343,   344,   345,   346,     0,   666,   664,   665,   649,   652,
     656,   659,   662,   663,   667,   650,   651,   653,   654,   655,
     657,   658,   660,   661,   668,   669,   670,   551,   552,   553,
     555,   556,   554,     0,   549,   711,   707,   705,   705,     0,
       0,     0,     0,  1115,   562,   563,     0,   560,   723,    20,
     515,   516,   518,   519,   513,     0,     0,   604,   612,   614,
       0,     0,   216,     0,   625,     0,   646,     0,   627,   626,
     631,   632,   645,   647,   648,   616,   624,     0,   672,   679,
     676,   675,   677,   678,   674,  1534,    82,    82,    82,    82,
       0,    82,    82,     0,   608,    82,   608,    82,  1274,    82,
      82,  1682,     0,   697,   695,   687,   699,   689,   681,   683,
       0,   691,   693,   709,  1549,   216,     0,     0,  1554,  1674,
       0,  1687,  1664,     0,   206,   212,     0,     0,   177,   214,
       4,     7,     6,     9,     2,     3,     5,     8,    10,    11,
     205,     0,   181,     0,     0,   520,     0,   414,   505,  1661,
    1658,  1656,  1657,  1659,  1662,  1660,     0,  1654,  1648,  1621,
     507,     0,  1601,    97,    98,    96,    99,  1604,  1605,     0,
       0,  1599,     0,  1607,     0,     0,  1626,  1628,    26,    27,
      28,     0,  1300,   457,   463,   527,   530,   545,   460,     0,
     468,     0,   487,     0,   741,     0,   737,   751,   458,   458,
     458,     0,     0,     0,     0,   954,   520,   952,     0,     0,
       0,    35,    35,  1003,  1005,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1060,  1064,    35,    35,     0,
       0,     0,     0,     0,     0,     0,  1025,  1024,   844,  1027,
       0,   965,    72,    71,   916,     0,   916,     0,     0,   949,
     921,   919,   920,   938,   939,   940,   941,   942,     0,   913,
       0,     0,   947,  1001,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1000,     0,     0,     0,
       0,     0,    35,     0,     0,     0,  1004,     0,   958,    35,
       0,     0,     0,    35,    35,    35,     0,     0,     0,     0,
     754,   486,     0,  1112,     0,     0,     0,     0,     0,     0,
     458,   458,  1157,     0,  1160,  1159,  1164,  1158,     0,  1166,
    1152,     0,     0,     0,   215,   489,   210,     0,   499,   493,
     475,    35,     0,   476,   474,   479,     0,   458,   458,   458,
    1508,     0,     0,  1499,  1513,     0,     0,     0,    35,    35,
       0,  1507,  1528,  1498,  1703,  1694,  1571,     0,  1701,     0,
    1644,    35,     0,     0,     0,     0,   532,  1716,  1711,   304,
     294,   298,   304,     0,   325,     0,     0,     0,     0,   157,
     159,   375,     0,     0,   360,     0,     0,     0,     0,     0,
     381,   378,     0,     0,     0,     0,   238,     0,     0,   272,
     281,   289,  1121,  1120,     0,     0,     0,   341,   337,   338,
     340,   336,     0,   548,     0,     0,   704,   713,  1117,  1119,
       0,   559,   777,   773,   774,   775,   606,   643,   644,     0,
     640,   641,   642,   636,   634,   635,   617,   633,   618,   623,
     630,     0,     0,   619,   620,   628,   629,     0,     0,     0,
       0,   848,   850,   854,   857,     0,   855,   856,     0,   858,
       0,     0,     0,  1288,  1297,     0,     0,  1292,  1295,  1290,
       0,     0,    82,     0,    82,     0,     0,     0,   701,   685,
    1553,  1552,  1551,  1555,  1666,    18,   208,     0,     0,   223,
     174,   225,     0,     0,     0,     0,   534,   415,     0,  1653,
    1595,     0,  1603,  1600,  1598,  1616,  1611,  1615,  1614,  1612,
    1613,  1617,  1618,  1619,     0,  1609,  1594,   419,     0,   450,
       0,     0,     0,     0,    35,    35,     0,     0,     0,     0,
     528,     0,   520,   543,   485,     0,     0,   480,     0,     0,
     739,   749,   753,   789,     0,     0,     0,   780,   781,     0,
     867,   868,     0,   861,   862,     0,   806,   811,   813,     0,
     813,     0,     0,     0,   796,     0,     0,     0,     0,     0,
       0,   976,   975,  1032,     0,     0,   922,     0,    35,     0,
       0,  1013,  1012,  1023,     0,     0,     0,     0,     0,  1002,
       0,     0,   990,    35,     0,   966,     0,     0,   973,     0,
     842,     0,     0,     0,    42,     0,   917,   918,  1030,     0,
     914,   915,   968,   960,     0,     0,   981,     0,   970,   977,
     956,     0,   957,   992,  1006,   972,   971,  1022,   974,     0,
    1007,     0,  1009,  1010,   959,     0,   969,   997,     0,     0,
       0,     0,   995,    35,  1031,     0,   769,     0,   760,     0,
     771,     0,     0,  1110,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,    35,    35,
      35,     0,  1075,     0,     0,  1563,     0,  1564,     0,  1565,
    1566,    35,    35,  1137,     0,     0,     0,     0,  1123,  1126,
    1128,   484,  1127,     0,  1547,   216,     0,     0,     0,     0,
    1541,  1537,     0,  1161,  1163,  1169,  1263,     0,    35,  1183,
      35,  1181,     0,     0,  1173,    35,     0,  1187,  1264,  1306,
       0,   217,   219,     0,   498,   478,   472,  1305,  1322,     0,
    1323,  1313,  1315,     0,     0,     0,  1309,  1310,     0,  1407,
    1408,    35,     0,  1399,  1400,     0,     0,     0,  1452,     0,
    1468,     0,  1468,     0,     0,     0,  1468,  1455,  1456,     0,
    1459,     0,  1511,  1496,  1497,    41,     0,  1524,  1525,  1522,
      75,    76,  1502,  1504,  1503,  1505,  1501,     0,     0,  1704,
    1573,     0,     0,  1640,     0,     0,  1638,  1642,  1714,  1718,
     297,   299,   323,     0,   367,     0,   317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   242,
       0,     0,     0,     0,     0,     0,    50,     0,    51,     0,
     550,   715,   717,   561,     0,   637,   638,     0,   621,   622,
     910,   904,   906,   908,   852,    93,    94,    95,    91,    92,
     851,   853,  1278,  1276,  1293,  1296,  1291,  1294,     0,  1280,
       0,  1284,  1447,  1449,     0,   213,   210,   389,   321,   321,
       0,     0,   382,   383,   384,     0,     0,   394,     0,     0,
       0,     0,   229,   230,   226,     0,   321,   227,   228,     0,
       0,  1113,   183,     0,  1655,  1606,     0,  1608,     0,     0,
       0,   438,     0,     0,     0,   437,   439,     0,     0,     0,
       0,   448,   523,   524,    79,    80,   522,     0,   529,   531,
     481,   483,   744,   745,   746,     0,   743,   783,     0,   785,
     788,   520,   863,     0,   866,   798,   520,   799,     0,   821,
     800,   825,   801,    35,     0,   805,     0,     0,     0,   984,
     953,   986,     0,     0,     0,   926,     0,     0,     0,     0,
     924,   987,     0,     0,     0,  1014,     0,     0,   961,   982,
    1063,  1046,     0,     0,   988,   991,     0,   967,   978,   983,
     598,     0,  1028,  1033,   951,   950,   948,   979,   980,   962,
     955,  1011,  1008,  1029,    35,   993,   998,   996,     0,     0,
       0,   761,   767,     0,     0,    35,    35,    35,     0,     0,
       0,    35,     0,     0,     0,  1104,     0,     0,  1084,  1085,
    1086,  1082,  1103,  1102,  1087,     0,     0,  1108,  1569,  1560,
    1559,     0,     0,  1129,     0,     0,     0,     0,   486,  1136,
    1540,  1539,  1538,  1543,  1542,     0,  1546,   520,  1186,     0,
       0,    35,  1174,     0,     0,  1172,     0,     0,  1190,  1185,
    1189,     0,  1179,  1171,     0,  1197,  1304,   494,   495,   496,
     497,    70,    69,  1358,  1368,  1312,   520,  1311,     0,     0,
    1318,    35,     0,  1321,   520,  1404,  1401,  1403,  1406,  1470,
       0,     0,  1469,     0,     0,     0,     0,  1471,  1457,  1474,
    1483,  1461,     0,  1454,  1509,  1500,  1514,     0,     0,  1532,
    1527,  1529,  1695,  1635,  1637,  1636,  1639,     0,     0,     0,
       0,   115,   126,   127,   113,     0,   116,   117,     0,     0,
     120,   121,   125,   122,   164,   123,     0,   139,   139,     0,
       0,   165,     0,   139,   139,     0,     0,     0,     0,   371,
     372,   369,   370,   373,   251,     0,     0,   249,     0,   245,
       0,     0,   243,     0,     0,     0,    47,   321,   639,  1282,
    1286,     0,   224,   225,     0,     0,     0,     0,     0,     0,
       0,   410,   410,     0,   220,   231,   404,     0,     0,   406,
     211,     0,  1610,  1625,  1629,     0,     0,     0,     0,     0,
     440,   441,   446,   526,     0,   752,     0,     0,     0,   782,
     210,   900,    35,   809,   807,   808,   810,   812,   821,     0,
     842,   814,     0,     0,   828,   802,     0,     0,  1016,     0,
       0,     0,   929,   930,   928,   932,   931,   933,     0,   923,
    1018,  1017,  1019,     0,  1015,  1056,  1061,   989,   845,   571,
     572,    35,     0,   839,     0,     0,     0,     0,     0,   841,
     564,   566,     0,   597,     0,     0,   994,   762,   763,   764,
     757,   759,   756,   758,   765,     0,    35,     0,     0,    35,
    1095,  1096,  1097,  1099,  1100,     0,     0,     0,  1106,  1088,
       0,     0,    35,  1072,  1073,  1074,  1083,  1105,    35,     0,
    1567,  1568,     0,     0,  1131,  1141,  1138,  1132,  1133,  1134,
    1130,  1124,    35,  1266,  1270,  1176,  1177,  1175,  1251,  1178,
    1251,  1211,  1191,  1180,  1265,  1198,  1366,  1365,  1355,  1372,
    1371,  1379,  1314,  1382,  1381,  1389,  1316,  1319,     0,  1443,
       0,  1467,  1466,  1462,  1460,  1463,    35,  1458,  1475,     0,
    1464,  1526,    77,  1717,     0,     0,   368,   318,   319,   114,
     118,   119,   124,   109,   107,   105,   104,   106,   108,   103,
     110,   132,     0,   149,   134,   130,   140,   150,     0,     0,
     151,    68,    67,   148,   158,   154,   155,   156,   152,   160,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   287,     0,   207,   209,   390,   402,   403,
       0,   399,     0,   290,   388,     0,     0,     0,     0,     0,
     386,   401,     0,     0,   185,  1630,     0,   443,     0,   442,
     445,   748,   747,   750,     0,   793,   784,   790,   786,   898,
     869,   864,   814,   797,     0,   824,   826,   827,     0,   830,
      35,  1021,   985,   927,   934,   925,  1020,     0,   846,   838,
     567,     0,     0,     0,   833,   837,   815,     0,   816,     0,
     840,   101,   100,    86,   102,   573,    87,   574,   570,   843,
     999,     0,  1067,  1068,  1066,  1078,  1080,  1079,  1076,  1077,
    1101,    35,     0,     0,     0,  1093,  1098,    35,  1140,   278,
       0,  1544,  1264,  1268,  1272,     0,     0,     0,  1200,     0,
    1370,  1353,  1352,  1377,  1387,     0,  1441,  1409,  1402,  1465,
    1477,  1482,  1484,  1713,  1715,     0,   128,   112,   111,     0,
       0,   111,   139,   139,     0,   141,   142,   143,   144,   145,
     139,   139,     0,   376,   377,   266,   250,   248,     0,     0,
     246,   264,   244,     0,     0,   262,     0,   260,   259,     0,
     257,   339,     0,     0,   392,     0,   387,   395,   410,   410,
       0,   398,     0,    78,     0,     0,     0,   870,   902,   823,
     822,   829,    35,   832,   803,  1058,     0,     0,     0,     0,
       0,     0,     0,  1057,     0,     0,     0,     0,     0,   817,
     818,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1089,  1090,     0,     0,  1094,     0,  1139,  1267,     0,  1184,
    1254,  1252,  1255,  1182,  1188,    35,     0,    35,     0,  1196,
       0,     0,     0,     0,     0,     0,  1210,     0,  1369,    35,
       0,     0,    35,    35,     0,     0,     0,  1357,  1373,  1383,
       0,     0,  1445,     0,  1472,     0,   133,   131,     0,   135,
       0,     0,     0,     0,     0,   153,     0,     0,     0,     0,
       0,     0,     0,   391,   400,     0,     0,   405,   241,   276,
     273,   274,   275,   282,     0,     0,     0,     0,   385,   407,
     444,   792,   791,     0,     0,     0,   901,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   897,     0,
     831,  1059,     0,     0,     0,   593,   594,   595,   596,     0,
    1054,     0,     0,     0,     0,  1052,  1053,   565,   567,   834,
     835,   836,   819,   820,    83,     0,     0,     0,     0,     0,
       0,     0,     0,   597,  1092,  1069,  1070,  1071,  1081,  1091,
     279,     0,  1271,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,  1250,     0,  1256,     0,     0,  1194,
    1195,  1193,  1192,  1204,  1201,  1207,  1208,  1209,  1202,     0,
       0,  1205,  1199,  1360,     0,     0,  1359,  1361,    35,  1367,
       0,  1356,     0,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,  1341,  1343,     0,     0,  1376,     0,     0,
       0,  1386,     0,     0,     0,    84,  1317,    85,     0,  1444,
      35,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1436,
       0,  1476,     0,     0,     0,  1489,     0,     0,     0,     0,
     129,     0,     0,   136,   147,   146,   265,   247,   263,     0,
     261,     0,   258,   393,   292,     0,     0,     0,   396,     0,
       0,   871,     0,   874,   875,   876,   873,    35,   872,     0,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,   881,   889,   890,   899,  1047,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,  1055,  1050,     0,
       0,  1051,   568,   574,     0,     0,   574,   574,   574,     0,
       0,   569,  1219,  1220,  1221,  1222,  1223,  1224,  1225,  1226,
    1216,    35,     0,  1258,  1213,  1231,  1212,  1249,     0,     0,
       0,  1244,  1238,  1239,  1240,    35,    35,  1233,  1215,     0,
       0,  1217,    35,    35,  1214,     0,    35,  1269,  1257,  1253,
    1203,  1206,  1393,  1393,  1362,     0,     0,  1340,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1328,    35,     0,
       0,     0,    35,     0,    35,     0,     0,  1354,  1380,     0,
    1391,  1375,  1374,  1378,  1390,  1384,  1385,  1388,  1415,  1413,
      35,    35,  1410,     0,  1434,     0,     0,     0,  1429,  1414,
    1437,  1440,  1439,  1438,  1435,    35,     0,     0,     0,     0,
    1411,  1412,    35,  1416,    35,    35,    35,  1442,  1481,  1479,
    1480,  1478,  1473,     0,     0,  1488,  1485,     0,     0,     0,
       0,   277,   283,   291,     0,   408,     0,     0,     0,     0,
     883,   877,   878,    35,   893,   892,   895,   894,   896,   879,
     880,   536,   535,   882,   891,  1048,  1049,   579,   574,   574,
     581,   580,   582,   574,   574,  1234,    35,     0,  1242,  1241,
    1243,  1246,  1245,  1232,     0,  1247,  1230,  1218,  1229,  1228,
    1235,  1227,    35,  1364,  1363,     0,     0,  1349,  1350,  1351,
    1336,  1393,  1337,     0,  1393,  1330,  1326,     0,    35,  1329,
    1331,  1332,     0,  1346,  1342,  1347,  1344,     0,    35,  1392,
    1433,  1420,  1422,  1427,  1428,  1430,     0,  1431,  1425,  1426,
    1423,  1424,  1417,  1418,  1419,  1421,     0,     0,   138,   137,
     252,     0,     0,     0,   884,   885,   887,   886,   888,   577,
     578,   575,   576,  1236,  1237,  1260,  1259,  1248,  1394,  1325,
    1338,  1334,  1339,  1335,  1324,  1327,  1333,     0,  1348,  1432,
    1487,  1486,     0,   397,   409,  1261,     0,     0,     0,  1262,
    1345,     0,   267
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,   -14,
     -72,  -303,  1303,  -370,  1937,  -442,  -830, -2666,  -145,  -156,
    -158,  2017,  2019,  2023, -2666, -2666, -2666, -2666,  -212, -2666,
   -2666,  -469, -2666, -1741,  -819,  -544, -2666,  1319, -2177,    10,
    -225, -1659,   -97, -2665,  -501,  1179,  -931,   508,   573,  -807,
   -2666,  1292,  1294,  1297,  1299,   965,   579,   583,   970, -1850,
    -762,   968, -2666, -2666, -2666, -2666,  2633, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,   -86,
   -2666, -2666, -2666, -2666, -2666,  1779, -1084, -2666,  -642, -2666,
   -1874, -2666, -2666, -2666,   943, -2666,  1233, -2666,  -211, -2444,
    2131,   244, -1437, -2477,  2985, -2016, -2434,  2133,   246, -2666,
    2649, -2666,  2137, -2666, -2666, -2666, -2666,  -513, -2666, -2666,
    -353,   956, -1542, -1069, -2666, -2666,   706, -2666,    -6, -2279,
   -2666, -2666, -2666, -1814, -2666, -2666, -2666, -2666, -2666, -2666,
   -2157,  -162, -2666, -2666, -2666,     6,  3028, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,   -26,  -111, -2666,  -139,  -280, -2666,
    -499,  -915,  -134,  -529,  -506, -2666,   476, -2666, -2666, -2666,
    2821, -2666, -2666, -2666,  1589,  -779, -1230,  2380, -2666, -2599,
   -2666, -2666, -2666, -2666, -2666,  -263, -2666,  1712,  -104, -2666,
    1718, -1486, -2666,   407, -2341, -2666, -2666, -1878,   557,   418,
   -2666, -2666, -2666, -2666, -2666,  -217, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -1066, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,   863,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,    97,  2541, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  -132, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666,   591, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666,  1601,   726, -2666,   951, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666,   957, -2666, -2666, -2666, -2666, -2666,
    1903,   205, -2666, -2666,   941, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666,   902, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666,  -114, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666,   862, -2666, -2666, -2666, -2666, -2666, -2666, -2666,   681,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,   206, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,   382,   366, -2666,
   -2666, -2666, -2666,   194,   368, -2666, -2666, -2666, -2666,   196,
     370, -2236, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
    -349,  1094, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666,  2274, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666,  1093, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666,  1305, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666,  1697, -2666, -2666,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,  1276,  2553,
   -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666, -2666,
   -2666, -2666, -2666
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    22,    23,    24,    25,     2,     3,   120,   121,   377,
     401,   286,   765,  2486,  2544,  2390,  1316,   577,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,  2443,  2133,  2680,   964,  1841,  1842,  2487,  2794,
     660,  2795,  2886,  2534,   741,  1910,  1237,  2535,  2432,  2589,
    2195,  2196,  2197,  2198,  2199,  2433,  2434,  2435,  2437,  2438,
    2599,  2440,  2200,  2206,  1868,  1869,  1028,  1449,  1450,   254,
     255,   256,  1210,   122,   730,   123,   124,   125,   126,  1940,
     731,  1557,  1195,  1197,  1559,  1198,  1395,  1396,   945,  1397,
    1199,   127,   728,  1926,  1941,  1942,  1943,  1944,   257,   618,
     619,  2739,  1041,   620,  1042,   621,   622,   623,  2743,  2560,
     624,  2744,   625,   626,  2625,   573,   258,   574,   259,   260,
    1017,  1018,   261,   262,   263,  1074,  1481,  1889,  1879,   265,
    1946,  1947,  2476,  1948,  2233,  2622,  2240,  2745,  3114,  2483,
    2477,   266,   128,   129,   130,   415,   132,   133,   134,   381,
    1599,  1251,   771,   135,   402,   416,   417,  1607,  1608,  1261,
     801,  1262,   418,   951,   946,  1794,  1400,   136,   137,   369,
     288,  1255,  1978,  1601,  1256,  1436,  1437,  1215,  1216,  2962,
     138,   139,   140,   791,   419,   656,  1103,  1104,   671,  1116,
    1117,  2319,  2320,  2654,  2321,  2322,  2323,  2668,  2780,  2538,
    1309,    26,    27,    28,    29,   690,    30,    31,    32,   686,
    1506,  1507,  1147,  1096,   271,    33,   688,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,  1110,
      46,    47,    48,    49,    50,    51,    52,   272,    53,    54,
      55,   273,   682,   141,   142,  1265,   804,   421,   805,  1266,
    1267,  2267,  1985,  1612,  1986,   482,   483,  2334,  1719,  1369,
     906,  1370,  1371,  1125,    56,   143,  1619,  2268,  2270,  1268,
     144,  2496,  2497,   145,  1625,  1269,   146,  1991,  2638,  2769,
    2637,  2500,  1992,    57,    58,    59,    60,   147,  1635,  1270,
     148,  2277,  1995,  1996,  2505,  2530,  2281,  1997,  2000,  2284,
    2509,  2643,  2002,  2324,  2041,  1670,  2518,    61,  1160,   149,
     863,   860,  1647,  2019,  2020,   867,  1328,   150,   851,  1671,
     484,  2032,  2653,  2781,  2517,  2771,  2033,  1658,   840,  1295,
    1659,   485,  2545,  2808,  2356,  1743,  1372,   908,  1373,   486,
      62,    63,    64,   151,  1376,   152,  1761,  1762,   153,  1763,
    1380,   154,  2367,   155,  1772,  1381,   156,    65,   718,   398,
     157,   158,   932,   512,   513,   514,   515,   516,  1391,  1786,
    2116,  2113,  2119,  2120,  2567,  2688,  1787,  2568,  2697,  1788,
    2835,  2565,  2681,  2682,  2838,  3147,  3246,  3226,  2107,  2125,
    2374,  2562,  2678,  2564,  2108,    66,    67,    68,    69,    70,
      71,    72,    73,  1163,   159,   772,   160,   161,  1808,  2138,
    2139,  1407,   162,  2136,  2876,  3053,  3055,  3170,  2707,  2706,
    2572,  2137,  2134,  2705,  2570,  2569,  2387,  2135,  2391,  2573,
    2880,  3058,  2708,  2392,  2395,  2574,  2884,  3064,  2709,  2396,
    3061,  3163,   399,   163,  1815,  1408,   164,  2144,  2712,  2910,
    3084,  2711,  2577,  2145,    74,    75,   165,   166,  1409,  1829,
    2153,  1830,  2158,  2161,  2408,  2581,  2713,  2914,  2714,  2409,
    2715,  2919,  3102,   167,   168,   979,  1835,   980,  1832,   540,
    1410,   541,  1415,  1838,  1839,  2171,  1847,   982,  1422,    76,
     169,   554,   267,   370,   170,  1232,  1241,   761,  1238,  1572,
    1244,  1584,  1585,   171,   172,   763,   764,  1588,   173,   174,
    1435,   995,   558,   996,   175,   752,  1226,  1227,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,   322,   725,
     176,   992,  1849,   555,   556,   177,   178,   565,   999,  2415,
    2177,  1859,  1000
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     285,   264,   924,   766,   767,  1480,   285,   616,   617,   131,
     658,   351,  1257,   933,   859,   862,   949,   326,  1390,  1945,
     575,   528,   328,   330,   287,  1878,  1880,  1882,  1883,   583,
     321,   582,  1329,  2170,   538,   552,   539,   553,  1314,   481,
    1413,   494,   581,  2536,  1146,  2887,  1640,   511,  1509,   527,
     736,   661,  2232,  1004,  2159,  1005,  1006,   537,   551,  1012,
    1013,   615,  2140,   582,  1958,   963,  2877,   564,  2881,  1030,
    1031,  2684,   376,  1575,   614,  1429,  1188,   281,  2366,  2366,
    2366,  1516,  2490,   701,  2413,  2478,   580,   285,   281,   717,
     331,   820,   281,   743,   744,   745,   282,  3040,   285,  1052,
    1053,  1550,   285,  1281,  2845,  1430,   275,   276,  3038,   279,
     281,   355,  2911,   283,   282,   314,  3080,   422,  2282,   423,
    1851,   424,   364,   425,   283,   487,   372,   495,   283,   496,
     356,   497,   518,   855,   856,   529,   281,   530,  2078,   531,
    2293,   532,  1145,  2915,   790,  1576,   283,  -521,  2740,  2085,
     559,   560,   376,  3187,  3081,   781,   376,   281,   357,   358,
     281,   281,   519,  3044,   131,   376,   376,  3012,  2550,   822,
     281,   281,   283,  -521,  -521,  -525,   359,   824,   826,  2655,
    1589,  2738,   782,   783,   784,   785,   914,   588,   281,   595,
    2362,  2742,   282,   283,  1431,   281,   283,   283,  1219,   282,
     841,  -525,  -525,   704,  2264,  2796,   283,   283,   586,  3090,
    2958,  2959,  2801,  1959,  1492,  2265,  1048,   963,  3022,   277,
       4,     5,     6,  3011,   283,  2912,  1021,     1,  1050,   683,
     653,   283,   970,  1493,   360,   404,    87,   405,  1285,  1317,
     520,   406,   407,  3099,  1318,  1319,   689,   521,   522,   281,
     409,  2327,   523,   282,   561,   727,   689,   786,   787,   753,
    1590,   855,   856,  1416,   281,   524,  1591,   278,  2685,   654,
     410,   812,  1432,  2846,   525,  2882,   842,   672,  1254,   734,
    3070,  3100,  1220,  3091,  3216,   283,  1242,  2346,  2558,  1049,
     285,   285,   285,   285,   285,   285,   285,  3078,   285,   285,
     283,  1051,   285,   768,   285,  1945,   411,   769,   796,   412,
    2686,   324,   325,   587,   707,   708,   709,   710,   711,   712,
     713,  1320,   715,   716,   843,  2698,   321,   404,   321,   405,
    2086,  1022,   844,   406,   407,   316,  3013,  1592,   562,  3045,
     740,  1417,   409,  1418,  1593,  1594,  1595,  2559,  2439,  1596,
    2079,   655,  2797,  1597,  2439,   285,   285,   915,  1317,  2802,
     617,   179,   410,  1318,  2044,     7,   705,  2913,  1243,   317,
    2850,  2536,  2960,  2699,   664,   667,  3023,  3071,   526,   287,
     760,  1228,   813,   689,  1317,     8,  1286,  3117,  3118,  1318,
    2045,   285,   788,   696,  1393,   285,  2498,   285,   411,  1577,
    1164,   412,  1945,  1402,   575,  2847,   575,   575,   324,   325,
     575,   575,   284,     9,    10,   780,  2283,  3082,   788,   793,
     285,   795,  3188,  2414,  1258,  1406,  2266,   285,   788,   821,
    3217,  2536,  2294,  1341,  1960,  2347,  1566,  1412,  1282,   788,
    1320,  3041,   858,   858,   817,  1898,  1899,  2655,  2961,  3042,
      11,   830,    12,  1852,    13,   788,  1720,  2750,    14,  2740,
    3039,  1463,   788,  2687,  2448,    15,  1320,  1613,  3014,   963,
    1375,  2746,  2747,   180,  1156,  1157,  1158,  1159,   963,  1161,
    1162,  1048,  1165,  1167,  1218,  1169,  1170,  3083,   886,   740,
     788,  2738,  2738,   788,   971,   788,  2878,  1441,  2883,  1003,
      16,  2879,  2742,   181,    17,  1494,  1495,   823,   684,   566,
     280,    18,   972,   697,   567,   825,   827,  2330,  1114,   973,
     816,   268,   861,  2328,  2329,   269,  1578,  1166,   568,   891,
     569,  1414,  2160,  3119,   788,   857,   788,  1464,  1419,   329,
     404,  2109,   405,  2952,   361,   520,   406,   407,  1420,  2030,
     570,   315,  1606,   522,  1442,   409,   198,   523,  2273,  1579,
    1580,  1581,  1582,  1583,  1007,   289,   290,  1301,   668,  3059,
     524,  2274,  2275,  3036,  1115,   410,   323,  2675,  1019,   525,
    -521,  1513,  2887,  1982,  1983,  1321,  1322,  1508,  1221,  1222,
    1223,  1224,  1225,  2331,  1032,  1033,  1034,  1035,  1036,  1037,
    1038,  1039,  3009,  2959,  2916,  2917,  1043,   669,  -525,  2741,
    2918,   411,   327,  1433,   412,  3148,  3149,   201,   202,  1434,
     203,   204,   205,   206,   207,   208,  2121,  3092,  1057,  1058,
    1059,  1060,  1061,  1062,  1063,  1064,  1065,  1066,  1067,  1068,
    1069,  1070,  1071,  1072,  1073,  1313,  1211,   571,   756,   572,
    2676,  3076,  2959,  2662,   757,  2012,   758,  1552,  2624,  2810,
    2645,   285,   963,  2031,  2700,   270,   281,   759,  1533,  1521,
     282,    19,   352,   318,   376,   414,   319,   320,  2110,   281,
    1614,  2100,   373,  1615,  1616,  1124,  1184,  1534,  1522,   670,
    2663,  1945,   285,  1598,   974,   975,   976,   977,   978,   615,
     285,   582,   283,  2111,  1321,  1322,   353,   274,   698,   274,
     702,   269,   614,   269,  2332,   283,  1172,   291,  2333,   292,
    1193,   699,   700,  2248,  1180,  1514,  1260,  2276,   274,   679,
    1321,  1322,   269,   680,  2646,  1535,  2249,   810,  2963,  1770,
    2953,   811,  2720,  2721,  1236,   285,  1252,   781,   293,  2216,
    2723,  2724,   281,  2701,   870,   294,  2702,  2703,  2664,  1107,
    1108,  2271,  1111,  1112,  2960,   740,  2278,   414,   835,  1239,
    2704,   887,   836,   563,   782,   783,   784,   785,  2609,  2453,
     871,  2455,  2647,   788,  2457,  2936,  2460,  2462,   283,  2013,
     354,   888,   889,   703,   295,   578,   296,  3164,   374,   362,
    2665,  2217,   662,   583,   665,   582,  2666,   297,  2546,  2954,
    1894,   828,  2955,  2960,   788,   371,   581,   298,   792,   788,
     788,    20,    21,  1536,  2336,  2667,  1185,   940,   864,   788,
    2610,   285,  1523,  1524,   788,  1525,   617,   617,   616,   829,
    3010,   299,  1691,  1312,  2362,   375,  1526,  1527,   575,   786,
     787,   270,  2689,   270,   788,  1302,  2937,  2362,  1186,  2014,
     788,   858,   788,  2526,   788,   788,   865,   788,   788,   788,
     788,   788,   270,   681,   788,   788,   837,   788,  3020,   838,
     788,   788,  2964,  1246,  1187,  2547,   788,  1790,   788,  3077,
     379,   281,   615,  2157,   582,   282,  1796,  2648,   858,  2527,
     285,   285,   380,    92,    93,   614,  2388,   788,   788,   788,
    1247,  1565,   788,  1537,  2399,   679,   663,  2836,   666,   680,
    2741,  2933,  2934,  2837,  1377,  1378,  1860,   283,   403,  1861,
    1945,  1517,  1518,  1519,  1520,  3231,  1531,  1532,  3233,   788,
    1543,  2363,  1545,   866,  1546,  1547,  2479,  1542,   781,  1544,
     576,   788,  2364,   281,  2363,  2337,   420,  1236,  2365,   858,
     324,   325,  2221,  2338,  2118,  2309,  2310,   300,  2536,   788,
     788,  2365,  1502,   517,  2480,   782,   783,   784,   785,  2616,
     414,  1482,  2619,  1483,  2339,  1501,  2015,  1451,  2016,   283,
    2017,  2468,  2649,  2018,   557,  2312,  2469,  2650,  2651,  2652,
    1528,   404,  1529,   405,  1530,  2165,  2799,   406,   407,   748,
     567,  1452,   408,  2690,  2222,  2481,   409,  1443,   488,  1447,
    1538,  1448,  1443,   105,   106,   107,   108,   109,   110,   578,
     111,  2617,  2528,  2529,  2620,  1915,   410,  1323,  2223,  1916,
    1917,  1443,   733,   895,   281,   301,  2494,  2805,   749,  2885,
     786,   787,   198,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
    1746,  2214,   411,   363,  2691,   412,  1747,  2219,  2773,  2774,
     283,  1539,  2696,   584,  1200,  2775,  2776,  2777,  2778,  1718,
     413,   404,  1742,   405,   585,  2215,  1715,   406,   407,   598,
    1716,  2220,   599,  1486,   691,  3137,   409,  2692,  3140,  3141,
    3142,  1562,   302,   201,   202,  1748,   203,   204,   205,   206,
     207,   208,  1540,  3113,   896,   897,   410,  1775,   898,  1618,
     750,  1148,   692,  2082,  1490,  1624,  1491,  2984,  2985,  1563,
    2806,  2807,  2989,  2990,  1201,   596,  1324,  1325,  1326,  1327,
    1149,  2768,  2607,   751,  1541,   376,   597,  1617,  1623,  1634,
     281,   579,   411,  1263,   281,   412,   281,  1264,   600,   217,
    2531,  2532,  2727,   285,  2612,   601,  2608,  2729,   520,  2730,
    1605,   602,  2732,  2371,   603,  1606,   522,  2587,  2591,  2001,
     523,   281,  2834,  1945,  1945,   282,   283,  1553,  2613,   285,
     283,   899,   283,   524,   376,   579,   580,   961,   962,   281,
    1202,  1776,   525,   604,  1150,   693,  1777,   285,   605,  1203,
     949,  2587,  2591,  1564,   950,  2909,   285,   283,  1551,  2693,
    2694,  2695,   365,  1204,  1205,  1206,  1207,  2102,  2059,   194,
     694,  1570,  2060,  1674,   853,   283,   196,   197,  1760,   900,
    1574,   649,   650,  2393,    88,   651,   606,   901,   781,  2592,
    3219,  3220,  2098,   281,   489,  3221,  3222,   788,   788,  1759,
    1771,  1151,   490,  1807,  1814,  1828,  1330,   575,   324,   325,
     575,  1331,  1332,   788,   788,   782,   783,   784,   785,  1152,
    1153,   217,   902,  2600,    89,  2779,  1806,  1813,  1827,   283,
    1044,  1045,   607,  1154,    90,   781,  2090,  1717,    91,   630,
     281,    92,    93,   366,   367,   368,   628,  1918,   950,  1920,
     855,   856,  2101,   281,  1778,  2542,  2543,  1961,  2373,   740,
     579,   580,   782,   783,   784,   785,   629,    94,   788,   324,
     325,   583,  1980,   582,   632,   788,   283,   631,  1046,   788,
     788,   788,   781,  1568,   581,  1569,  1956,   281,  1957,   283,
     786,   787,   737,  1330,   738,  2308,   652,   281,  1331,  2046,
    1909,   400,   582,   220,   281,   491,   492,   493,   282,   782,
     783,   784,   785,  1908,  1208,  2389,  1758,   788,   580,  1976,
     281,  1792,   657,   283,    95,  1945,    96,    97,  3243,  1949,
      98,   659,    99,   283,   788,   788,   285,   786,   787,   100,
     283,   101,   102,   103,  1480,   676,   104,   788,   579,   580,
     376,   281,   378,   677,  1403,   281,   283,  1604,  1404,   678,
    1846,   105,   106,   107,   108,   109,   110,  1862,   111,   685,
    1779,   414,  2298,   615,  2299,   582,  1870,  1871,  1398,  1872,
    1873,  1874,  1875,  1876,   786,   787,   614,   283,  2353,  2269,
     687,   283,  1885,   608,   609,   185,   186,   610,   611,   376,
     689,  1924,  1925,  2155,   281,  2354,  2355,  2162,  2309,  2310,
    2311,  2173,  2174,   112,  2175,  2176,   673,   674,  1209,   113,
    1950,  2465,  3109,  2466,  3110,   114,   115,   589,  1287,  1233,
    1234,  1780,   281,   706,   612,   520,  1235,  1605,  2312,  1700,
     283,   285,  1606,   522,  1907,   695,   285,   523,  1781,  1673,
    1782,  1675,   740,   627,  1783,  2313,   740,   740,  1784,  1785,
     524,   414,  2314,   855,   856,  1904,   281,  1984,   283,   525,
    1911,  2348,   947,   714,  2640,  1383,   773,   774,  2357,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   939,   940,   939,   940,
     720,  1313,   283,    92,    93,  2234,  2235,   781,   818,   819,
     788,   788,   281,  1120,  1121,   579,   580,  1975,   281,   941,
     675,   941,   719,  2247,   721,   942,   722,   942,  1620,  2261,
    2067,   723,   613,   724,   782,   783,   784,   785,   726,  2315,
     735,  1977,  2316,  2317,   948,   742,  2381,   858,   283,   732,
    2318,  1248,  1249,  1250,   283,   615,   781,   582,  1288,   281,
    2593,   281,   729,  2601,   788,   747,  2943,  2944,   614,  2593,
    2601,  2132,   754,   582,   762,  2132,  2945,   582,   776,   788,
     777,  2679,   770,   782,   783,   784,   785,  2309,  2310,  2311,
    1626,   778,   746,  3167,  3168,  3169,  1627,   283,   876,   877,
    1945,   404,   775,   405,   779,  1384,   794,   406,   407,   786,
     787,  2068,  1621,  1122,  1123,  1949,   409,  2312,  1905,  1906,
     797,   281,   798,   105,   106,   107,   108,   109,   110,   788,
     111,   799,  1972,  1973,  2313,   281,   410,   939,   940,  1974,
     832,  2314,  2404,  1751,  1752,   608,   609,  1008,  1009,   610,
     611,   802,  2022,   788,   788,   788,   788,   283,   786,   787,
     941,  1895,  1896,   404,   858,   405,   942,   788,   788,   406,
     407,   283,   411,   800,  1628,   412,   947,   806,   409,  1497,
    1498,  1499,  1500,   943,   285,   426,   612,   938,   854,   944,
     807,   303,    92,    93,   788,   803,   788,   815,   410,  1312,
     808,   788,   939,   940,  3242,   990,  1968,  1969,  2104,   833,
     892,   809,  1949,   939,   940,  2131,   834,   542,  2315,  2131,
     839,  2316,  2317,   846,   304,   941,   305,   788,   847,  2318,
     737,   942,   738,   852,   411,   281,   941,   412,   845,   927,
    1236,  3251,   942,   848,  1097,  1098,  1099,   868,   948,  1909,
     306,   582,   307,   937,   308,  2096,  2097,   869,  1622,   943,
    2296,  2297,  1908,   579,   580,   944,   281,   739,   116,  1100,
    1101,   283,   117,  1102,  2127,  2128,  2129,  2130,   985,   118,
     119,   781,  2231,   873,  1010,   874,   281,  2420,  2421,  2179,
     404,  2180,   405,  2521,  2522,   872,   406,   407,  2243,   875,
     855,   856,   283,   281,   878,   409,  2587,  2588,   782,   783,
     784,   785,   105,   106,   107,   108,   109,   110,   879,   111,
    2340,  2341,   283,  2309,  2310,   410,  2548,   881,  2262,  2683,
    2659,  2660,   882,   309,   310,   311,   883,   312,   313,   283,
    1629,  1630,  1631,  2967,  2968,  2969,  2970,  2971,  1632,   884,
    1633,   885,  1019,  1019,   893,  2237,   894,   639,   903,  2238,
    2239,   411,   904,  1054,   412,  1056,  3224,  2792,  2793,   905,
    1019,   590,   591,   592,   593,  2736,  2524,   543,   907,   647,
     648,   649,   650,   786,   787,   651,   608,   609,  1008,  1009,
     610,  2924,  2925,  1907,   608,   609,  1008,  1009,   610,   611,
    1484,  1485,  2583,   182,   909,   183,   184,   185,   186,   187,
     188,  2368,  2369,   910,   189,   190,   911,   916,   912,   788,
     913,   917,   918,  2860,   191,   192,  1040,   612,   919,   193,
    2595,  2596,  2597,  2598,   544,  1468,   920,   545,   921,   922,
     923,   194,   926,   931,   934,   781,   195,   929,   196,   197,
     281,   935,   198,  2861,  2737,   936,   950,  1191,   952,   498,
     499,   781,  1196,   953,   954,  2862,   281,    92,    93,   955,
     788,   956,   782,   783,   784,   785,   957,  2132,   958,   582,
     959,   788,   788,   788,  2442,   960,   283,   788,   782,   783,
     784,   785,   500,  1240,   966,  1245,  2641,   965,   967,   968,
     981,  1949,   283,   969,   983,   984,   986,   199,   200,   590,
     591,   592,   593,   201,   202,   987,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   788,   214,   215,
     989,   216,   993,   740,   994,   217,  2495,   997,   998,  1001,
     218,   414,  2863,   219,  1002,  1014,  2633,   786,   787,  1015,
    1016,  1278,  1279,  1020,   858,   285,  1023,   788,   608,   609,
    1008,  1009,   610,   786,   787,   404,   651,   405,  1024,  1025,
     858,   406,   407,    92,    93,   220,  1047,  1055,  1105,  2394,
     409,  1213,  1106,  1109,  2475,  1113,  1118,   105,   106,   107,
     108,   109,   110,  1127,   111,  3154,  1128,  1155,  1809,  1468,
     410,  1168,  1335,   414,  1194,  1338,  1171,  1173,  1174,  1175,
    2864,  1176,   939,   940,  1177,  2441,  2865,  1178,   781,  1179,
    2866,  2131,  1181,   281,   608,   609,  1008,  1009,   610,   611,
    1182,  2450,  2451,  1183,  1189,   941,   411,  2503,  1192,   412,
    2506,   942,  1212,  1214,  2066,   782,   783,   784,   785,  1217,
    1253,  1019,   501,  2972,  2973,  2974,  2975,  2976,   943,   283,
    1231,  1272,  1389,  1271,   944,   612,  1229,  1230,  1273,  1392,
    1274,   404,  2482,   405,  1275,  1277,  1399,   406,   407,  1283,
    1284,  1399,  1810,  1291,  1292,  1399,   409,  1293,   788,  1294,
    1296,   546,   547,   105,   106,   107,   108,   109,   110,   285,
     111,  1300,  1297,  2423,  2424,  2425,   410,  1298,  1303,   502,
    1306,  1307,  1304,  1308,  1311,  1310,  2789,  2790,  2791,  1426,
     786,   787,  1428,  2507,  2426,  2427,  2428,   788,  1315,  1333,
     414,  1343,  1346,  1352,  1438,   548,   549,   550,  2533,  1336,
    1949,  1337,   411,  1353,  1363,   412,  2629,  1339,  2423,  2424,
    2425,   781,   788,  1356,   858,   788,   281,   376,  1358,  3196,
    1359,  1364,   281,   608,   609,  1008,  1009,   610,   788,  2426,
    2427,  2428,  1362,   789,   788,  1365,  1367,  1374,   782,   783,
     784,   785,  1379,  1313,  1313,  1388,  2773,  2774,   788,  1394,
     971,  1401,   283,  2775,  2776,  2777,  2778,  1439,   283,   814,
     426,  1423,  1443,  1427,   612,  1445,  1446,    92,    93,   831,
    1444,  1453,  1462,  1465,  2429,  2430,  1467,  1472,  1645,  1473,
     850,  1474,   788,  1475,  1476,  1487,  1488,   221,   222,  1489,
     858,  1496,   533,  2626,  1510,  1511,   880,   615,   615,   582,
     582,  1512,  1515,   890,   617,  1548,  1549,  1554,  1556,  1558,
     614,   614,  1560,   786,   787,  1567,  1571,  1586,  1587,  2429,
    2430,  1600,  1602,  1603,   503,   504,   505,   506,  1610,  1609,
    2867,   925,  2868,  2869,   928,  1611,   930,  2870,  2871,  1648,
    2872,  1636,  1637,  1649,  1641,  3079,  2873,  2874,  1642,  1643,
    1651,  1652,   507,  1654,  1653,  2875,  1655,   508,  1662,  1663,
    1669,  2628,   509,  2630,  2495,   404,  1665,   405,  1668,  1678,
    1682,   406,   407,  1683,  1686,   988,  1688,   991,  2635,  1689,
     409,  1690,  1692,  1693,   858,  2114,   788,   105,   106,   107,
     108,   109,   110,  1694,   111,  1695,  1696,  1697,  1698,  1702,
     410,  2992,  2993,  2994,  2995,  2996,  2997,  2998,  2999,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,  1703,   788,  1704,  1706,
    1707,  1708,  1573,   788,  1712,  1713,   411,  1714,  1745,   412,
    1749,  1312,  1312,  1750,  1789,  1797,  1793,  1831,   781,   534,
    1833,  1836,  1834,   281,   535,  1854,  1848,  1857,  1811,  1855,
    1858,  1863,  1864,  1949,  1949,   414,  1638,  1639,  1884,  3121,
    3122,  1887,  3124,  3125,  1891,   782,   783,   784,   785,  1892,
    1650,  1897,  1900,  1901,  1902,  1903,  1656,  1657,  1912,   283,
    1913,  1919,  1921,  1922,  1664,  1923,  1666,  1667,  1951,  1952,
    1953,  1962,  1963,  1672,  1967,  1964,  1971,  1812,  1970,  1981,
    1676,  1677,  1987,  1989,  1990, -1026,  1993,  1994,   788,  1988,
    1998,  2003,  2004,  1680,  1681,  2006,  2533,  2005,  2008,  1684,
    1685,  2009,  1687,  2026,  2010,  2011,  2040,  2064,   285,  2054,
    2021,   285,  2069,  2025,  2061,  2065,  1701,  2063,  2028,  2070,
     786,   787,  2029,  2034,  2035,  2037,  2038,  2039,  2474,  2042,
    2043,   788,  2047,   788,  2048,  3214,  3215,  1744,  2049,  2050,
    2051,   414,  2052,  2053,  2055,   788,  1773,  2056,   788,   788,
    1477,  1774,  1478,  1479,   536,  2057,  2533,  2062,  2073,  2071,
    2074,  2072,  2076,  2077,  2132,  3225,   582,  2087,  2088,  2093,
    2094,  2095,  2099,  2105,  2106,  2117,  3198,  2123,  1837,  1840,
    1843,  2124,  2126,  2141,   617,   617,  2143,  2148,  2150,  2151,
    1850,  2152,   198,  2154,  1259,  2142,  2156,  1856,  2168,  2938,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
    2163,   342,   343,   344,   345,   346,   347,   348,  2167,  2178,
    2218,  2224,  2225,  2226,  2227,  1280,  2229,  2228,  2230,  2236,
    1289,  1290,  2241,  2242,  2244,  1949,   733,  1886,  2246,  1888,
    1299,  2250,   285,   285,  2253,  1305,   849,   285,   285,  2254,
    2255,  2257,  2272,   201,   202,  2256,   203,   204,   205,   206,
     207,   208,  2279,  2259,  2280,  1334,   788,  2286,  2288,  2300,
    2291,  1340,   788,  1342,  2292,  1344,  1345,  2290,  1347,  1348,
    1349,  1350,  1351,  2301,  2295,  1354,  1355,  2302,  1357,  2304,
    2306,  1360,  1361,  2305,  2307,  2326,  2335,  1366,  1914,  1368,
    2345,  2350,  2352,  2360,   788,  2351,  2359,  2358,  2131,  2361,
    2370,  2378,  2380,   567,   788,  2372,  2400,  2398,  1382,  1385,
    1386,  1816,  2406,  1387,  2382,   858,  2385,  2386,   285,  2416,
    2419,  2422,  2444,  2449,  1955,  2436,   788,  2452,  2456,  2458,
     788,  2463,  2470,   858,   566,  2484,  2499,  2485,   350,   567,
    1405,  2508,  2394,  2488,  2493,   198,  2510,  2520,   285,  2511,
    2512,  2513,  1411,   568,   285,   569,  2516,  2537,  2523,  2514,
    2539,  2540,  2541,  2552,  2554,   414,  2551,  2553,  2584,  2563,
    1424,  1425,  3098,  2585,  2557,   570,  2614,  2590,  3105,  2571,
    2576,   198,  2580,   788,  3116,  2582,  2605,  2602,  2606,  2611,
    2007,  2615,   788,  2618,  2621,  2623,  2636,  2634,  2656,  2661,
    2627,  2657,  2024,  2669,  2642,  2672,   201,   202,  2027,   203,
     204,   205,   206,   207,   208,  2673,  2658,  2710,  2722,  2753,
    2726,  2728,  2731,  2733,  2734,  2787,  2735,  2749,  2782,  2783,
    2785,  2786,  2803,  2754,  2788,  2854,  2362,   788,  2755,  2849,
    2855,  2842,   201,   202,  2852,   203,   204,   205,   206,   207,
     208,   788,   788,  2756,  2859,  2926,  2858,  2927,   788,   788,
    1764,  2928,   788,  2929,  2930,  2931,  2935,  2932,  2939,  2940,
    2942,  2951,   571,  2947,   572,  2956,  2949,  2950,  2957,  2965,
    2966,  2978,  2981,  2983,   788,  2986,  2075,  2987,   788,   858,
     788,   285,  2988,  3001,  3003,  3008,  3002,  3027,  3016,  2089,
    1949,  3019,  3015,  3025,  3029,  2977,   788,   788,  3035,  3026,
    3050,  3046,  3043,  3049,  3048,  2394,  3051,  3052,  1765,   940,
    2103,   788,  3054,  3057,  3063,  3056,  3067,  3094,   788,  3073,
     788,   788,   788,   404,  3086,   405,  3085,  3097,  3096,   406,
     407,  3101,  3087,  3088,  3106,  3075,  3107,  3103,   409,  3108,
    1766,  3115,  3123,   858,   858,  3095,  3135,  2757,  3134,   788,
    3136,  3138,  3104,  3089,  3166,  2147,  2309,  2310,   410,  2149,
    3139,  3143,  3144,  3173,  3182,  3146,  3165,  3210,  3211,  3177,
    3206,  3212,   788,   858,  2164,  3244,  3162,  3207,  3227,  1840,
    3239,  3248,  3178,  3249,  3252,  3245,  2312,  1503,   788,  1504,
    3250,  2172,   426,  1505,   411,  2166,  2263,   412,  2784,    92,
      93,  2202,  2718,  2203,   788,  2758,  2204,  2445,  2205,  2719,
    3247,  2717,  2447,  2446,   788,  1791,  2467,  2245,  1469,  3111,
     594,  1470,  3112,  2464,  1753,  1767,   510,  1471,  1561,  2632,
     755,  1979,   285,   285,  1890,  2982,  1276,  1754,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,  1893,   342,
     343,   344,   345,   346,   347,   348,  3240,  3241,  1644,  1646,
    1011,  2991,  1126,  2800,  2759,  2760,  2761,  2752,  2639,  2502,
    1029,  1999,  1679,  2533,  1660,  1661,  2762,  2504,  2763,  2515,
    2764,  2549,  2566,  2677,  3037,  3062,  3172,  3184,  2765,  2766,
    3065,  3186,  2407,  3066,  1421,   188,  2251,   404,  2767,   405,
    2411,  2252,     0,   406,   407,  1954,     0,  2258,     0,  1755,
    1756,  2260,   409,     0,  1190,     0,     0,     0,     0,   105,
     106,   107,   108,   109,   110,     0,   111,     0,     0,  1699,
       0,     0,   410,     0,     0,     0,  1705,   198,     0,     0,
    1709,  1710,  1711,     0,     0,     0,     0,     0,     0,  2287,
       0,  2289,     0,     0,     0,     0,     0,  1927,  2169,     0,
    1928,  1929,  1930,  1931,  1932,  1933,  1934,     0,   411,  2303,
       0,   412,     0,     0,     0,     0,     0,     0,  1795,     0,
       0,  1757,     0,     0,     0,  1935,   350,     0,  1936,  1937,
       0,     0,     0,     0,     0,  1844,  1845,     0,   201,   202,
       0,   203,   204,   205,   206,   207,   208,     0,  1853,     0,
       0,     0,     0,     0,     0,     0,     0,  1768,  1769,     0,
       0,  1938,     0,  1939,     0,     0,     0,     0,     0,     0,
       0,     0,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,     0,
       0,     0,  2375,  2376,     0,     0,     0,  2379,     0,     0,
       0,     0,     0,     0,  2383,     0,     0,  2384,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,     0,     0,     0,     0,     0,
       0,     0,     0,  2401,  2402,     0,  2403,     0,  2405,     0,
       0,     0,     0,     0,     0,  2410,     0, -1027, -1027, -1027,
    1837,  2412,     0,   639,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188, -1027, -1027,
   -1027, -1027, -1027,   645,   646,   647,   648,   649,   650,  2431,
       0,   651,     0,     0,     0,  2431,     0,     0,     0,     0,
       0,     0,   634,   635,   636,   637,   638,     0,   639,     0,
       0,     0,     0,   414,     0,     0,     0,     0,     0,   198,
       0,  1965,  1966,   640,   641,   642,   643,   644,   645,   646,
     647,   648,   649,   650,     0,     0,   651,     0,     0,  1927,
       0,     0,  1928,  1929,  1930,  1931,  1932,  1933,  1934,   188,
       0,  2489,     0,     0,     0,     0,     0,  2491,     0,  2492,
       0,     0,     0,     0,     0,     0,     0,  1935,     0,     0,
    1936,  1937,     0,     0,     0,  2023,    92,    93,     0,     0,
     201,   202,     0,   203,   204,   205,   206,   207,   208,     0,
    2036,   198,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1798,     0,  1938,     0,  1939,     0,  2472,     0,     0,
    2525,  1927,     0,  1799,  1928,  1929,  1930,  1931,  1932,  1933,
    1934,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,     0,   342,   343,   344,   345,   346,   347,   348,  1935,
    2058,     0,  1936,  1937,     0,     0,     0,     0,     0,     0,
       0,     0,   201,   202,     0,   203,   204,   205,   206,   207,
     208,     0,     0,     0,  2080,  2081,  2083,  2084,     0,     0,
       0,     0,     0,     0,   404,  1938,   405,  1939,  2091,  2092,
     406,   407,     0,     0,     0,  1800,     0,   414,     0,   409,
       0,  2575,     0,  2578,     0,     0,   105,   106,   107,   108,
     109,   110,     0,   111,     0,  2112,     0,  2115,     0,   410,
       0,     0,  2122,     0,     0,   182,     0,   183,   184,   185,
     186,   187,   188,  2888,     0,  2586,   189,   190,     0,     0,
       0,  2594,  1075,     0,     0,     0,   191,   192,  2146,  1076,
    1077,   193,     0,     0,     0,   411,     0,     0,   412,   634,
     635,   636,     0,   194,     0,   639,     0,  2889,   195,     0,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   350,
     640,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,     0,     0,   651,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   199,
     200,   590,   591,   592,   593,   201,   202,     0,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,     0,
     214,   215,     0,   216,     0,  2671,     0,   217,     0,     0,
       0,     0,   218,     0,     0,   219,     0,     0,     0,  1078,
    1079,  1080,  1081,  1082,  1083,     0,  1084,     0,     0,     0,
    2309,  2310,  2890,     0,     0,     0,     0,     0,  2716,     0,
       0,  2431,     0,  2431,     0,     0,     0,   220,     0,     0,
       0,     0,     0,     0,     0,  2725,     0,     0,     0,     0,
    2312,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,     0,   342,   343,   344,   345,   346,   347,   348,  2891,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2285,     0,     0,     0,     0,     0,     0,     0,     0,  2772,
       0,     0,     0,     0,  1085,  1086,  1087,  1088,  1089,  1090,
    1091,  1092,  1093,  1094,  1095,     0,     0,  2798,     0,     0,
       0,     0,  2804,     0,     0,     0,  2809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2892,     0,  2840,
    2893,  2325,     0,  2843,  2844,     0,  2848,     0,  2851,     0,
       0,     0,  2342,  2343,  2344,     0,     0,     0,  2349,     0,
    2894,     0,  2895,  2896,     0,     0,  2897,     0,     0,     0,
       0,  2920,  2898,  2921,  2922,  2923,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,     0,  1801,  1802,     0,  1803,  2377,     0,
       0,     0,  1804,  1805,     0,     0,  2941,     0,  2181,   350,
    2946,     0,  2948,  2899,     0,     0,     0,   382,   383,  2182,
    2183,  2184,  2185,     0,  2186,  2187,  2188,     0,  2397,  2189,
       0,  2190,  2191,     0,     0,  2979,  2980,  2192,  2193,     0,
       0,     0,  2194,     0,     0,     0,     0,   384,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,     0,  3000,     0,     0,     0,
    3004,  3005,  3006,     0,   414,     0,     0,   385,     0,     0,
    3018,     0,  3021,     0,  3024,     0,     0,     0,     0,     0,
    3028,     0,     0,     0,  2900,     0,     0,     0,  2181,   221,
     222,     0,  3030,  3031,     0,     0,     0,  3032,  3033,  2182,
    2183,  2184,  2185,     0,  2186,  2187,  2188,  2901,     0,  2189,
       0,  2190,  2191,     0,     0,     0,     0,  2192,  2193,     0,
       0,  3060,  2201,     0,     0,     0,  3060,     0,     0,     0,
       0,  3068,     0,     0,   386,  3072,     0,     0,     0,     0,
     387,     0,     0,     0,   388,     0,     0,     0,  3093,  2501,
       0,     0,     0,     0,     0,     0,     0,  2902,  2903,  2904,
    2905,  2906,     0,  2907,     0,     0,  2908,     0,   389,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,  2519,   342,
     343,   344,   345,   346,   347,   348,     0,  3126,  3127,     0,
    3129,  3130,  3131,  3132,  3133,     0,     0,     0,     0,     0,
       0,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,     0,  2555,
       0,     0,     0,     0,     0,  2556,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2561,
       0,  3150,  3151,  3152,     0,     0,     0,     0,     0,     0,
       0,     0,  3156,  3157,     0,     0,     0,     0,  3160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   390,  3171,  2579,     0,  3174,  3175,  3176,   391,     0,
       0,   392,  3180,  3181,   393,     0,     0,     0,     0,     0,
       0,     0,  3189,     0,     0,     0,     0,     0,     0,     0,
       0,   349,     0,     0,     0,     0,  3192,     0,  3193,  3194,
    3195,     0,     0,     0,     0,     0,   350,     0,     0,     0,
    3199,  3200,  3201,     0,     0,     0,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3208,  3209,     0,     0,     0,     0,     0,     0,   182,  2811,
     183,   184,   185,   186,   187,   188,     0,     0,     0,   189,
     190,     0,   395,     0,  2812,     0,     0,     0,     0,   191,
     192,  1877,     0,     0,   193,     0,     0,  2644,     0,     0,
       0,     0,     0,     0,     0,     0,   194,     0,     0,   396,
       0,   195,     0,   196,   197,     0,     0,   198,  3229,  3230,
       0,     0,     0,     0,     0,     0,  3232,     0,     0,     0,
    3234,     0,     0,     0,     0,  3236,     0,     0,  2670,     0,
    3237,     0,     0,     0,  2674,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   397,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,     0,   214,   215,     0,   216,  2309,  2310,     0,
     217,     0,     0,     0,     0,   218,     0,     0,   219,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2312,     0,  2770,
     182,     0,   183,   184,   185,   186,   187,   188,     0,     0,
     220,   189,   190,     0,     0,  2813,  2814,  2815,     0,     0,
       0,   191,   192,  1881,     0,     0,   193,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   194,     0,
       0,     0,  2839,   195,  2841,   196,   197,     0,     0,   198,
       0,     0,     0,     0,     0,     0,  2853,     0,  2816,  2856,
    2857,   634,   635,   636,   637,   638,     0,   639,     0,     0,
       0,     0,     0,     0,     0,     0,  2817,     0,     0,     0,
       0,  2818,   640,   641,   642,   643,   644,   645,   646,   647,
     648,   649,   650,  2819,     0,   651,     0,  2820,     0,  2821,
    2822,     0,     0,     0,   199,   200,     0,     0,     0,  2823,
     201,   202,  2824,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,     0,   214,   215,     0,   216,     0,
       0,     0,   217,     0,     0,     0,  1455,   218,     0,     0,
     219,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2825,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   182,     0,   183,   184,   185,   186,   187,
     188,     0,   220,     0,   189,   190,     0,  3007,     0,     0,
       0,     0,     0,  3017,   191,   192,  2454,     0,     0,   193,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,     0,     0,     0,     0,   195,     0,   196,   197,
       0,     0,   198,     0,     0,  3034,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3047,     0,     0,  2826,     0,
       0,  2827,  2828,  2829,     0,     0,     0,     0,     0,  2830,
       0,     0,     0,     0,  2831,     0,     0,  3069,     0,     0,
       0,  3074,     0,     0,  2832,     0,     0,     0,     0,     0,
    2833,     0,   221,   222,     0,     0,     0,   199,   200,     0,
       0,     0,     0,   201,   202,     0,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,     0,   214,   215,
       0,   216,     0,     0,     0,   217,     0,     0,     0,     0,
     218,     0,     0,   219,  3120,     0,     0,     0,     0,     0,
       0,     0,     0,  3128,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   634,   635,   636,   637,   638,
       0,   639,     0,     0,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,  3145,   651,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3153,  3155,     0,     0,     0,     0,     0,  3158,
    3159,     0,     0,  3161,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,  2473,     0,     0,     0,  3179,     0,     0,     0,  3183,
       0,  3185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   221,   222,     0,  3190,  3191,     0,
       0,     0,     0,     0,     0,     0,     0,   634,   635,   636,
     637,   638,  3197,   639,     0,     0,     0,     0,     0,  3202,
       0,  3203,  3204,  3205,     0,     0,     0,     0,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,     0,
       0,   651,     0,     0,     0,     0,     0,     0,     0,   182,
    3218,   183,   184,   185,   186,   187,   188,     0,  1026,     0,
     189,   190,     0,     0,     0,     0,     0,     0,     0,     0,
     191,   192,  2459,  3223,     0,   193,     0,     0,     0,     0,
       0,     0,  1027,     0,     0,     0,     0,   194,     0,  3228,
       0,     0,   195,     0,   196,   197,     0,     0,   198,     0,
       0,     0,     0,     0,     0,  3235,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3238,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   221,   222,   201,
     202,     0,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,     0,   214,   215,     0,   216,     0,     0,
       0,   217,     0,     0,     0,     0,   218,     0,     0,   219,
       0,     0,   182,     0,   183,   184,   185,   186,   187,   188,
       0,     0,     0,   189,   190,     0,     0,     0,     0,     0,
       0,     0,     0,   191,   192,  2461,     0,     0,   193,     0,
       0,   220,     0,   634,   635,   636,   637,   638,     0,   639,
     194,     0,     0,     0,     0,   195,     0,   196,   197,     0,
       0,   198,     0,     0,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,     0,     0,   651,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1866,     0,     0,     0,     0,   223,
     224,   225,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   199,   200,  1867,     0,
       0,     0,   201,   202,     0,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,     0,   214,   215,     0,
     216,     0,     0,     0,   217,     0,     0,     0,     0,   218,
       0,   182,   219,   183,   184,   185,   186,   187,   188,     0,
       0,     0,   189,   190,     0,     0,     0,     0,     0,     0,
       0,     0,   191,   192,     0,     0,     0,   193,     0,     0,
       0,     0,     0,  1816,   220,     0,  1129,  1817,     0,   194,
       0,     0,    92,    93,   195,     0,   196,   197,     0,     0,
     198,     0,   579,   580,   961,   962,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,     0,     0,     0,
       0,     0,     0,   196,   197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,     0,   214,   215,     0,   216,
       0,     0,     0,   217,     0,     0,     0,     0,   218,     0,
     404,   219,   405,   221,   222,     0,   406,   407,     0,  1130,
    1131,     0,     0,     0,     0,   409,     0,     0,     0,     0,
       0,     0,   105,   106,   107,   108,   109,   110,     0,   111,
       0,     0,     0,   220,     0,   410,  1132,   940,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1133,     0,     0,     0,     0,  1134,
       0,     0,     0,  1135,  1136,     0,     0,     0,  1137,     0,
       0,   411,     0,     0,   412,     0,     0,     0,     0,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,  1138,
       0,     0,     0,     0,  1819,     0,     0,  1820,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1139,  1140,  1141,     0,  1142,  1143,  1144,     0,
       0,     0,     0,     0,     0,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,     0,     0,     0,     0,   221,   222,   634,   635,
     636,   637,   638,     0,   639,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   640,
     641,   642,   643,   644,   645,   646,   647,   648,   649,   650,
       0,  1821,   651,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1822,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1823,   634,   635,   636,   637,
     638,     0,   639,  1456,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   640,   641,   642,
     643,   644,   645,   646,   647,   648,   649,   650,     0,     0,
     651,     0,     0,     0,     0,     0,   426,     0,   427,     0,
       0,     0,     0,   428,   429,     0,     0,     0,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   221,   222,     0,   430,     0,
       0,  1457,     0,     0,     0,     0,   431,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1721,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1722,     0,
       0,     0,     0,     0,     0,     0,   432,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1723,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   404,     0,   405,     0,     0,     0,   406,   407,     0,
     433,     0,   434,     0,     0,     0,   409,   435,     0,     0,
       0,     0,     0,   436,   437,   438,   439,     0,  1824,     0,
       0,     0,     0,  1825,     0,  1826,   410,   440,     0,     0,
    1724,   441,     0,   442,     0,     0,     0,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,     0,     0,   520,     0,  1605,     0,
       0,     0,   411,  1725,  1726,   412,     0,     0,   523,     0,
     414,     0,     0,     0,   443,     0,     0,     0,   444,     0,
     445,   524,     0,     0,     0,   446,     0,     0,     0,     0,
     525,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   447,     0,     0,   448,     0,     0,     0,   449,   450,
       0,     0,     0,     0,  1727,     0,  1728,     0,  1729,     0,
       0,  1730,     0,     0,     0,  1731,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   451,     0,     0,     0,   452,
       0,   453,     0,     0,   454,     0,     0,     0,     0,   455,
     456,     0,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,   460,   461,     0,   462,   463,     0,     0,   464,
       0,     0,     0,     0,   465,   466,   467,     0,     0,     0,
     468,   469,     0,     0,     0,     0,     0,     0,   470,     0,
     471,  1732,     0,   472,   473,     0,   474,  1733,   475,     0,
       0,   476,   477,     0,     0,     0,     0,   634,   635,   636,
     637,   638,     0,   639,     0,     0,     0,   478,     0,   479,
       0,     0,     0,     0,     0,     0,     0,   480,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,     0,
       0,   651,     0,  1734,     0,     0,     0,     0,     0,     0,
    1735,  1736,     0,     0,     0,     0,     0,  1737,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1738,
     634,   635,   636,   637,   638,  1739,   639,     0,     0,     0,
    1740,     0,  1458,     0,     0,     0,     0,  1741,     0,     0,
       0,   640,   641,   642,   643,   644,   645,   646,   647,   648,
     649,   650,     0,     0,   651,   634,   635,   636,   637,   638,
       0,   639,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651,
     634,   635,   636,   637,   638,  1459,   639,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   640,   641,   642,   643,   644,   645,   646,   647,   648,
     649,   650,     0,     0,   651,   634,   635,   636,   637,   638,
    1865,   639,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651,
       0,   414,     0,     0,     0,  2207,     0,   634,   635,   636,
     637,   638,     0,   639,     0,     0,     0,     0,     0,     0,
       0,   634,   635,   636,   637,   638,     0,   639,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,     0,
    2208,   651,   640,   641,   642,   643,   644,   645,   646,   647,
     648,   649,   650,     0,     0,   651,     0,     0,  1119,   634,
     635,   636,   637,   638,     0,   639,     0,     0,     0,     0,
       0,     0,  1440,   634,   635,   636,   637,   638,     0,   639,
     640,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,     0,     0,   651,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,     0,     0,   651,     0,     0,
    1454,   634,   635,   636,   637,   638,     0,   639,     0,     0,
       0,     0,     0,     0,  1460,   634,   635,   636,   637,   638,
       0,   639,   640,   641,   642,   643,   644,   645,   646,   647,
     648,   649,   650,     0,     0,   651,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651,
       0,     0,  1461,   634,   635,   636,   637,   638,     0,   639,
       0,     0,     0,     0,     0,     0,  1466,   634,   635,   636,
     637,   638,     0,   639,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,     0,     0,   651,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,     0,
       0,   651,     0,     0,  2209,   634,   635,   636,   637,   638,
       0,   639,     0,     0,     0,     0,     0,     0,  2210,   634,
     635,   636,   637,   638,     0,   639,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651,
     640,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,     0,     0,   651,     0,     0,  2211,   634,   635,   636,
     637,   638,     0,   639,     0,     0,     0,     0,     0,     0,
    2212,   634,   635,   636,   637,   638,     0,   639,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,     0,
       0,   651,   640,   641,   642,   643,   644,   645,   646,   647,
     648,   649,   650,     0,     0,   651,     0,     0,  2213,   634,
     635,   636,   637,   638,     0,   639,     0,     0,     0,     0,
       0,     0,  2417,   634,   635,   636,   637,   638,     0,   639,
     640,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,     0,     0,   651,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,     0,     0,   651,     0,     0,
    2418,   634,   635,   636,   637,   638,     0,   639,     0,     0,
       0,     0,     0,     0,  2603,   634,   635,   636,   637,   638,
       0,   639,   640,   641,   642,   643,   644,   645,   646,   647,
     648,   649,   650,     0,     0,   651,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651,
       0,     0,  2604,   634,   635,   636,   637,   638,     0,   639,
       0,     0,     0,     0,     0,     0,  2751,   634,   635,   636,
     637,   638,     0,   639,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,     0,     0,   651,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,     0,
       0,   651,     0,     0,  3213,   634,   635,   636,   637,   638,
       0,   639,     0,     0,     0,     0,  1555,     0,     0,   634,
     635,   636,   637,   638,     0,   639,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651,
     640,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,     0,     0,   651,  2471,   634,   635,   636,   637,   638,
       0,   639,     0,     0,   633,     0,     0,     0,  2631,   634,
     635,   636,   637,   638,     0,   639,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651,
     640,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,     0,     0,   651,  2748,   634,   635,   636,   637,   638,
       0,   639,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   640,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,     0,     0,   651
};

static const yytype_int16 yycheck[] =
{
      14,     7,   503,   373,   374,  1074,    20,   219,   219,     3,
     273,    97,   791,   512,   456,   457,   522,    89,   933,  1561,
     182,   160,    94,    95,    14,  1462,  1463,  1464,  1465,   187,
      20,   187,   862,  1847,   168,   169,   168,   169,   857,   150,
     971,   152,   187,  2322,   686,  2710,  1276,   158,  1132,   160,
     353,   276,  1926,   566,    75,   568,   569,   168,   169,   572,
     573,   219,  1803,   219,    88,   534,    88,   178,    88,   598,
     599,    88,    20,    96,   219,    58,   718,    25,  2094,  2095,
    2096,  1147,  2259,   300,    88,  2242,    23,   101,    25,   314,
      96,    56,    25,   356,   357,   358,    29,   166,   112,   628,
     629,  1185,   116,    96,   175,    88,     9,    10,   166,    12,
      25,   101,    88,    61,    29,    18,   175,   143,    43,   145,
     260,   147,   112,   149,    61,   151,   116,   153,    61,   155,
     179,   157,    58,    22,    23,   161,    25,   163,   170,   165,
     142,   167,   686,    88,   407,   168,    61,    60,  2625,   140,
     176,   177,    20,    73,   213,    20,    20,    25,   207,   208,
      25,    25,    88,   328,   158,    20,    20,   175,  2345,    56,
      25,    25,    61,    86,    87,    60,   225,    56,    56,  2520,
      88,  2625,    47,    48,    49,    50,   232,   193,    25,   195,
      61,  2625,    29,    61,   177,    25,    61,    61,   205,    29,
     245,    86,    87,     6,    77,    57,    61,    61,    40,   394,
      77,    78,    57,   237,     6,    88,    86,   686,   337,   182,
       3,     4,     5,  2822,    61,   201,    40,     7,    86,     6,
      48,    61,    95,    25,   283,   161,     0,   163,   248,    54,
     166,   167,   168,   175,    59,    60,    25,   173,   174,    25,
     176,    25,   178,    29,    88,   327,    25,   122,   123,   363,
     168,    22,    23,    56,    25,   191,   174,   230,   285,    87,
     196,   249,   255,   344,   200,   295,   321,   283,   779,   351,
     251,   213,   289,   468,   184,    61,    87,   248,   159,   159,
     304,   305,   306,   307,   308,   309,   310,  2896,   312,   313,
      61,   159,   316,   375,   318,  1847,   232,   379,   412,   235,
     327,    25,    26,   145,   304,   305,   306,   307,   308,   309,
     310,   136,   312,   313,   369,    88,   316,   161,   318,   163,
     321,   145,   377,   167,   168,   250,   344,   245,   172,   504,
     354,   134,   176,   136,   252,   253,   254,  2363,  2198,   257,
     382,   169,   204,   261,  2204,   369,   370,   403,    54,   204,
     571,     6,   196,    59,    60,   148,   169,   343,   169,   284,
     224,  2650,   239,   136,   277,   278,   495,   348,   304,   369,
     370,   751,   360,    25,    54,   168,   396,   183,   184,    59,
      60,   405,   406,   172,   938,   409,  2270,   411,   232,   422,
     169,   235,  1944,   947,   566,   476,   568,   569,    25,    26,
     572,   573,   242,   196,   197,   405,   341,   476,   432,   409,
     434,   411,   342,   427,   794,   954,   299,   441,   442,   394,
     330,  2710,   434,   875,   458,   396,  1215,   966,   431,   453,
     136,   510,   456,   457,   434,  1511,  1512,  2788,   315,   518,
     233,   441,   235,   593,   237,   469,  1371,  2634,   241,  2936,
     518,    10,   476,   480,  2205,   248,   136,    88,   476,   938,
     912,  2628,  2629,     6,   691,   692,   693,   694,   947,   696,
     697,    86,   699,   700,   747,   702,   703,   546,    59,   503,
     504,  2935,  2936,   507,   357,   509,   518,  1010,   518,    10,
     283,   523,  2936,     6,   287,   297,   298,   394,   285,    20,
       6,   294,   375,   292,    25,   394,   394,   100,   180,   382,
     296,    25,   411,   297,   298,    29,   549,   169,    39,   393,
      41,   973,   553,   329,   548,   296,   550,    86,   331,   156,
     161,   327,   163,    58,   593,   166,   167,   168,   341,    88,
      61,   287,   173,   174,   159,   176,    67,   178,   170,   582,
     583,   584,   585,   586,   570,   196,    56,   404,    48,   517,
     191,   183,   184,   510,   236,   196,     6,    86,   584,   200,
     493,    25,  3247,   297,   298,   400,   401,  1131,   595,   596,
     597,   598,   599,   176,   600,   601,   602,   603,   604,   605,
     606,   607,    77,    78,   549,   550,   612,    87,   493,  2625,
     555,   232,   295,   596,   235,   483,   484,   128,   129,   602,
     131,   132,   133,   134,   135,   136,   491,   482,   634,   635,
     636,   637,   638,   639,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,   857,   732,   158,   581,   160,
     159,    77,    78,    57,   587,   100,   589,  1186,  2472,  2675,
      88,   675,  1131,   202,   427,   169,    25,   600,     6,     6,
      29,   454,    61,   588,    20,   601,   591,   592,   464,    25,
     301,  1765,   422,   304,   305,   675,     6,    25,    25,   169,
      94,  2233,   706,   601,   557,   558,   559,   560,   561,   857,
     714,   857,    61,   489,   400,   401,    61,    25,   487,    25,
     209,    29,   857,    29,   297,    61,   706,   207,   301,   209,
     726,   500,   501,    32,   714,   169,   798,   339,    25,    25,
     400,   401,    29,    29,   162,    73,    45,   244,   175,  1381,
     255,   248,  2592,  2593,   758,   759,   772,    20,   238,    10,
    2600,  2601,    25,   516,   328,   245,   519,   520,   162,   662,
     663,  1991,   665,   666,   239,   779,  1996,   601,   244,   759,
     533,   342,   248,   607,    47,    48,    49,    50,    10,  2216,
     354,  2218,   210,   797,  2221,    86,  2223,  2224,    61,   234,
     162,   362,   363,   292,   284,    42,   286,  3033,   538,   189,
     204,    62,   120,   961,   120,   961,   210,   297,   342,   324,
      57,   333,   327,   239,   828,   196,   961,   307,   177,   833,
     834,   604,   605,   161,   198,   229,   146,   147,   175,   843,
      62,   845,   169,   170,   848,   172,  1047,  1048,  1050,   361,
     315,   331,  1343,   857,    61,   603,   183,   184,  1010,   122,
     123,   169,    88,   169,   868,   845,   157,    61,   178,   304,
     874,   875,   876,   175,   878,   879,   213,   881,   882,   883,
     884,   885,   169,   169,   888,   889,   352,   891,   224,   355,
     894,   895,   319,    60,   204,   419,   900,  1393,   902,   315,
     178,    25,  1050,  1824,  1050,    29,  1402,   325,   912,   211,
     914,   915,   253,    63,    64,  1050,  2136,   921,   922,   923,
      87,  1214,   926,   251,  2144,    25,   234,   480,   234,    29,
    2936,  2735,  2736,   486,   914,   915,  1439,    61,    88,  1442,
    2472,  1156,  1157,  1158,  1159,  3171,  1161,  1162,  3174,   953,
    1165,   158,  1167,   290,  1169,  1170,    32,  1164,    20,  1166,
      42,   965,   169,    25,   158,   329,    87,   971,   175,   973,
      25,    26,    10,   337,  1783,   201,   202,   457,  3247,   983,
     984,   175,  1130,    87,    60,    47,    48,    49,    50,    10,
     601,    86,    10,    88,   358,  1130,   431,    62,   433,    61,
     435,    60,   420,   438,    87,   231,    60,   425,   426,   427,
     337,   161,   339,   163,   341,  1835,  2665,   167,   168,    48,
      25,    86,   172,   249,    62,    60,   176,    86,    88,  1025,
     358,  1027,    86,   183,   184,   185,   186,   187,   188,    42,
     190,    62,   344,   345,    62,  1536,   196,   304,    86,  1540,
    1541,    86,   107,   163,    25,   535,    61,   330,    87,    30,
     122,   123,    67,   564,   565,   566,   567,   568,   569,   570,
     571,   572,   573,   574,   575,   576,   577,   578,   579,   580,
      54,    62,   232,   207,   310,   235,    60,    62,   211,   212,
      61,   419,  2568,    61,   130,   218,   219,   220,   221,  1369,
     250,   161,  1372,   163,   145,    86,    84,   167,   168,    61,
      88,    86,    61,  1109,   181,  2983,   176,   343,  2986,  2987,
    2988,  1197,   602,   128,   129,    99,   131,   132,   133,   134,
     135,   136,   460,  2937,   244,   245,   196,    88,   248,  1268,
     169,     6,   209,   406,    86,  1269,    88,  2796,  2797,  1211,
     423,   424,  2801,  2802,   190,    87,   413,   414,   415,   416,
      25,  2637,    62,   192,   492,    20,    87,  1268,  1269,  1270,
      25,    22,   232,    84,    25,   235,    25,    88,    61,   150,
      29,    30,  2609,  1187,    62,    61,    86,  2614,   166,  2616,
     168,    61,  2619,  2098,    61,   173,   174,    14,    15,  1631,
     178,    25,  2678,  2735,  2736,    29,    61,  1187,    86,  1213,
      61,   321,    61,   191,    20,    22,    23,    24,    25,    25,
     256,   172,   200,    61,    89,   292,   177,  1231,    61,   265,
    1726,    14,    15,  1213,    25,  2711,  1240,    61,    29,   465,
     466,   467,   164,   279,   280,   281,   282,  1766,   296,    56,
     317,  1231,   300,  1315,    60,    61,    63,    64,  1380,   369,
    1240,    41,    42,    87,     6,    45,    61,   377,    20,    86,
    3138,  3139,  1761,    25,   334,  3143,  3144,  1281,  1282,  1380,
    1381,   146,   342,  1407,  1408,  1409,    54,  1439,    25,    26,
    1442,    59,    60,  1297,  1298,    47,    48,    49,    50,   164,
     165,   150,   412,    86,    46,   428,  1407,  1408,  1409,    61,
      39,    40,    61,   178,    56,    20,  1748,   295,    60,    58,
      25,    63,    64,   245,   246,   247,    61,  1542,    25,  1544,
      22,    23,    29,    25,   285,   397,   398,  1590,  2107,  1343,
      22,    23,    47,    48,    49,    50,    61,    89,  1352,    25,
      26,  1499,  1605,  1499,    58,  1359,    61,    20,    87,  1363,
    1364,  1365,    20,    86,  1499,    88,    86,    25,    88,    61,
     122,   123,    20,    54,    22,    88,    45,    25,    59,    60,
    1528,    57,  1528,   190,    25,   445,   446,   447,    29,    47,
      48,    49,    50,  1528,   430,    87,  1380,  1401,    23,  1601,
      25,  1397,     6,    61,   146,  2937,   148,   149,  3212,  1561,
     152,    29,   154,    61,  1418,  1419,  1420,   122,   123,   161,
      61,   163,   164,   165,  2483,     6,   168,  1431,    22,    23,
      20,    25,   119,     6,   948,    25,    61,    88,   952,   302,
    1420,   183,   184,   185,   186,   187,   188,  1443,   190,     6,
     401,   601,    86,  1601,    88,  1601,  1452,  1453,    48,  1455,
    1456,  1457,  1458,  1459,   122,   123,  1601,    61,   358,  1988,
       6,    61,  1468,    20,    21,    22,    23,    24,    25,    20,
      25,  1557,  1558,  1822,    25,   375,   376,  1826,   201,   202,
     203,  1851,  1852,   235,  1854,  1855,   243,   244,   534,   241,
    1562,    60,  2929,    62,  2931,   247,   248,   194,   260,    22,
      23,   462,    25,   169,    61,   166,    29,   168,   231,    60,
      61,  1525,   173,   174,  1528,   351,  1530,   178,   479,  1314,
     481,  1316,  1536,   220,   485,   248,  1540,  1541,   489,   490,
     191,   601,   255,    22,    23,  1525,    25,  1609,    61,   200,
    1530,  2070,   120,   291,    88,   260,   458,   459,  2077,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   146,   147,   146,   147,
       6,  1783,    61,    63,    64,  1928,  1929,    20,   362,   363,
    1594,  1595,    25,    52,    53,    22,    23,  1601,    25,   169,
     287,   169,   316,  1946,   318,   175,     6,   175,    88,  1969,
     178,     6,   159,   538,    47,    48,    49,    50,    32,   332,
      25,  1601,   335,   336,   192,    60,  2117,  1631,    61,    20,
     343,    51,    52,    53,    61,  1783,    20,  1783,   390,    25,
    2437,    25,   329,  2440,  1648,   245,   312,   313,  1783,  2446,
    2447,  1799,    60,  1799,   249,  1803,   322,  1803,    25,  1663,
      57,    88,    87,    47,    48,    49,    50,   201,   202,   203,
      88,    87,   359,   526,   527,   528,    94,    61,   367,   368,
    3212,   161,   536,   163,   162,   390,   260,   167,   168,   122,
     123,   259,   172,    52,    53,  1847,   176,   231,    22,    23,
     251,    25,   603,   183,   184,   185,   186,   187,   188,  1713,
     190,    60,    22,    23,   248,    25,   196,   146,   147,    29,
     395,   255,  2154,   449,   450,    20,    21,    22,    23,    24,
      25,    60,   390,  1737,  1738,  1739,  1740,    61,   122,   123,
     169,    22,    23,   161,  1748,   163,   175,  1751,  1752,   167,
     168,    61,   232,    87,   172,   235,   120,    87,   176,    22,
      23,    24,    25,   192,  1768,    56,    61,   120,   455,   198,
      87,   146,    63,    64,  1778,    60,  1780,    60,   196,  1783,
      87,  1785,   146,   147,  3211,   169,   262,   263,  1768,   196,
     477,    87,  1944,   146,   147,  1799,   251,    88,   332,  1803,
      87,   335,   336,   328,   179,   169,   181,  1811,   352,   343,
      20,   175,    22,   421,   232,    25,   169,   235,   403,   506,
    1824,  3248,   175,   372,   180,   181,   182,   347,   192,  1977,
     205,  1977,   207,   520,   209,   452,   453,   260,   318,   192,
     439,   440,  1977,    22,    23,   198,    25,    57,   590,   205,
     206,    61,   594,   209,   194,   195,   196,   197,   545,   601,
     602,    20,  1924,   352,   159,   308,    25,    73,    74,  1865,
     161,  1867,   163,   333,   334,   260,   167,   168,  1940,   337,
      22,    23,    61,    25,   367,   176,    14,    15,    47,    48,
      49,    50,   183,   184,   185,   186,   187,   188,   163,   190,
     333,   334,    61,   201,   202,   196,  2338,   379,  1970,    88,
     213,   214,   308,   288,   289,   290,   308,   292,   293,    61,
     338,   339,   340,   213,   214,   215,   216,   217,   346,   385,
     348,   383,  1928,  1929,   408,  1931,   347,    17,    60,  1935,
    1936,   232,    60,   630,   235,   632,    88,   213,   214,    87,
    1946,   124,   125,   126,   127,     9,  2316,   248,    87,    39,
      40,    41,    42,   122,   123,    45,    20,    21,    22,    23,
      24,  2723,  2724,  1977,    20,    21,    22,    23,    24,    25,
    1107,  1108,  2414,    18,    60,    20,    21,    22,    23,    24,
      25,  2095,  2096,    87,    29,    30,   314,   448,   337,  2003,
     337,    60,    87,    58,    39,    40,    41,    61,    87,    44,
      79,    80,    81,    82,   305,    61,    87,   308,   499,   196,
     401,    56,   161,   394,    60,    20,    61,   162,    63,    64,
      25,    87,    67,    88,    88,   502,    25,   724,   192,    55,
      56,    20,   729,   233,   178,   100,    25,    63,    64,    60,
    2054,    60,    47,    48,    49,    50,    87,  2205,    87,  2205,
      87,  2065,  2066,  2067,  2199,    87,    61,  2071,    47,    48,
      49,    50,    88,   760,   178,   762,  2508,   251,    60,    60,
      87,  2233,    61,    60,   196,   389,   178,   122,   123,   124,
     125,   126,   127,   128,   129,   333,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,  2111,   143,   144,
     260,   146,    60,  2117,    60,   150,  2268,    87,    87,   260,
     155,   601,   177,   158,    60,    19,  2486,   122,   123,    20,
      20,   818,   819,    39,  2138,  2139,    40,  2141,    20,    21,
      22,    23,    24,   122,   123,   161,    45,   163,    20,    86,
    2154,   167,   168,    63,    64,   190,    10,    57,     6,  2139,
     176,    86,     6,   240,  2240,     6,     6,   183,   184,   185,
     186,   187,   188,     6,   190,   334,     6,     6,    88,    61,
     196,     6,   869,   601,    61,   872,     6,     6,     6,     6,
     245,     6,   146,   147,     6,  2199,   251,     6,    20,     6,
     255,  2205,     6,    25,    20,    21,    22,    23,    24,    25,
       6,  2207,  2208,     6,     6,   169,   232,  2279,     6,   235,
    2282,   175,    60,    86,   178,    47,    48,    49,    50,    60,
      25,  2227,   248,   213,   214,   215,   216,   217,   192,    61,
     403,   196,   929,   395,   198,    61,    60,    60,   260,   936,
     260,   161,  2248,   163,    60,    60,   943,   167,   168,    60,
      60,   948,   172,   395,   196,   952,   176,   260,  2272,   260,
      60,   562,   563,   183,   184,   185,   186,   187,   188,  2283,
     190,   245,   258,    11,    12,    13,   196,   236,   260,   305,
      60,    60,   260,    87,    60,   422,  2656,  2657,  2658,   986,
     122,   123,   989,  2283,    32,    33,    34,  2311,    43,    60,
     601,   162,    60,   402,  1001,   606,   607,   608,  2322,   260,
    2472,   260,   232,    59,   258,   235,  2478,   260,    11,    12,
      13,    20,  2336,    60,  2338,  2339,    25,    20,    60,   334,
      59,   196,    25,    20,    21,    22,    23,    24,  2352,    32,
      33,    34,   395,   406,  2358,   236,   245,   192,    47,    48,
      49,    50,   120,  2565,  2566,   192,   211,   212,  2372,    25,
     357,   199,    61,   218,   219,   220,   221,    20,    61,   432,
      56,    60,    86,   314,    61,   145,    40,    63,    64,   442,
      62,    86,    86,    86,   122,   123,    20,    62,    87,    62,
     453,    59,  2406,    23,    59,     6,     6,   442,   443,     6,
    2414,     6,    88,  2475,    25,   178,   469,  2565,  2566,  2565,
    2566,   178,    25,   476,  2625,     6,     6,     6,    62,    16,
    2565,  2566,    60,   122,   123,    60,    54,    60,    60,   122,
     123,    40,    86,    60,   460,   461,   462,   463,    60,   296,
     505,   504,   507,   508,   507,    87,   509,   512,   513,   196,
     515,   396,   260,   260,    60,  2897,   521,   522,    60,    60,
      60,    60,   488,   396,    60,   530,   260,   493,    60,   258,
       8,  2477,   498,  2479,  2636,   161,    60,   163,    60,    60,
      60,   167,   168,    60,    60,   548,    60,   550,  2494,    60,
     176,    60,    60,    60,  2508,   327,  2510,   183,   184,   185,
     186,   187,   188,    60,   190,    60,    60,    60,    60,    60,
     196,   468,   469,   470,   471,   472,   473,   474,   475,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,    60,  2551,    60,    60,
      60,   248,  1239,  2557,    60,   258,   232,    60,    60,   235,
      60,  2565,  2566,    60,    60,    60,   193,    56,    20,   245,
      60,    56,    60,    25,   250,   260,   192,    60,   488,   260,
      87,    40,    40,  2735,  2736,   601,  1273,  1274,    86,  2949,
    2950,    42,  2952,  2953,     6,    47,    48,    49,    50,     6,
    1287,    25,     6,     6,     6,     6,  1293,  1294,     6,    61,
       6,     6,     6,     6,  1301,     6,  1303,  1304,    60,    62,
      86,   259,   258,  1310,   259,   262,    60,   537,   603,    60,
    1317,  1318,    47,   306,    60,    87,   161,    60,  2642,   178,
     601,   347,   349,  1330,  1331,   260,  2650,    60,    86,  1336,
    1337,    60,  1339,   260,    60,    60,    88,   316,  2662,   196,
      60,  2665,   395,    60,    25,   389,  1353,   244,    60,   178,
     122,   123,    60,    60,    60,    60,    60,    60,    25,    60,
      60,  2685,    60,  2687,    60,  3117,  3118,  1374,    60,    60,
      60,   601,    60,    60,    60,  2699,  1383,    60,  2702,  2703,
      25,  1388,    27,    28,   380,    60,  2710,    60,   244,   196,
      68,   342,   374,   178,  2862,  3147,  2862,    60,    60,    24,
     452,   452,    60,   140,    60,   251,  3086,    60,  1415,  1416,
    1417,   493,    60,   181,  2935,  2936,    60,    60,   541,   541,
    1427,   198,    67,   337,   797,   531,    58,  1434,    42,  2745,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      60,   108,   109,   110,   111,   112,   113,   114,    86,    40,
      86,    86,    20,    20,    61,   828,     6,    23,     6,    61,
     833,   834,    61,    61,    88,  2937,   107,  1474,    60,  1476,
     843,    60,  2796,  2797,    60,   848,   248,  2801,  2802,    60,
     293,   174,   162,   128,   129,   260,   131,   132,   133,   134,
     135,   136,   603,   260,    87,   868,  2820,   350,    60,    60,
     441,   874,  2826,   876,   437,   878,   879,   192,   881,   882,
     883,   884,   885,    60,   436,   888,   889,    60,   891,    60,
      60,   894,   895,    87,    60,    60,   395,   900,  1535,   902,
     260,    68,   316,    60,  2858,   395,    68,   389,  2862,    60,
      24,    87,    87,    25,  2868,   359,   192,    73,   921,   922,
     923,    54,    77,   926,    87,  2879,    87,    87,  2882,    40,
      69,    76,    60,    60,  1571,    44,  2890,    41,    41,    10,
    2894,    88,    25,  2897,    20,    62,    87,    60,   245,    25,
     953,   342,  2882,   259,    60,    67,   333,    87,  2912,    60,
      60,   432,   965,    39,  2918,    41,    60,    87,   334,   288,
      60,    60,   396,   260,   396,   601,   196,   316,    60,    87,
     983,   984,  2912,    10,   316,    61,    61,    86,  2918,    87,
      87,    67,    87,  2947,  2940,    87,    62,    85,    62,    62,
    1637,    62,  2956,    62,    62,    62,    86,   260,   335,   211,
     120,   335,  1649,   260,   339,   155,   128,   129,  1655,   131,
     132,   133,   134,   135,   136,   260,   335,   532,    42,    54,
      41,    41,    10,    88,    60,    88,   117,    60,   162,   162,
      60,    60,    88,    68,    60,   518,    61,  3001,    73,   328,
     518,    60,   128,   129,    60,   131,   132,   133,   134,   135,
     136,  3015,  3016,    88,    60,    62,   427,    62,  3022,  3023,
      88,    62,  3026,    86,    62,    61,    10,    62,    62,    86,
     316,    68,   158,   251,   160,   326,   335,   335,   314,    60,
      60,    60,    60,    60,  3048,    60,  1733,    60,  3052,  3053,
    3054,  3055,    60,   251,    87,   314,   496,    60,   385,  1746,
    3212,   328,   470,   134,    60,   429,  3070,  3071,   504,   468,
     514,   504,   511,   260,   509,  3055,   316,   342,   146,   147,
    1767,  3085,   342,    60,    60,   531,    60,   543,  3092,   260,
    3094,  3095,  3096,   161,   260,   163,   385,    60,   548,   167,
     168,    60,   134,   260,    60,   314,    42,   552,   176,    42,
     178,    60,   316,  3117,  3118,   545,    60,   192,   320,  3123,
      60,    60,   551,   260,   260,  1812,   201,   202,   196,  1816,
      60,    60,    60,   260,   192,   497,   335,    62,    86,   335,
     202,   121,  3146,  3147,  1831,    60,   525,   202,   482,  1836,
     482,    86,   506,    60,    62,   477,   231,  1130,  3162,  1130,
    3247,  1848,    56,  1130,   232,  1836,  1977,   235,  2650,    63,
      64,  1869,  2589,  1869,  3178,   250,  1869,  2202,  1869,  2590,
     532,  2588,  2204,  2203,  3188,  1396,  2233,  1944,  1047,  2935,
     195,  1048,  2936,  2227,    88,   263,   158,  1050,    87,  2483,
     369,  1602,  3206,  3207,  1482,  2788,   816,   101,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,  1490,   108,
     109,   110,   111,   112,   113,   114,  3206,  3207,  1281,  1282,
     571,  2803,   681,  2666,   309,   310,   311,  2636,  2502,  2278,
     597,  1630,  1329,  3247,  1297,  1298,   321,  2280,   323,  2298,
     325,  2339,  2380,  2562,  2862,  2879,  3040,  3053,   333,   334,
    2882,  3055,  2158,  2883,   980,    25,  1953,   161,   343,   163,
    2167,  1956,    -1,   167,   168,  1568,    -1,  1964,    -1,   173,
     174,  1968,   176,    -1,   721,    -1,    -1,    -1,    -1,   183,
     184,   185,   186,   187,   188,    -1,   190,    -1,    -1,  1352,
      -1,    -1,   196,    -1,    -1,    -1,  1359,    67,    -1,    -1,
    1363,  1364,  1365,    -1,    -1,    -1,    -1,    -1,    -1,  2006,
      -1,  2008,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,
      90,    91,    92,    93,    94,    95,    96,    -1,   232,  2026,
      -1,   235,    -1,    -1,    -1,    -1,    -1,    -1,  1401,    -1,
      -1,   245,    -1,    -1,    -1,   115,   245,    -1,   118,   119,
      -1,    -1,    -1,    -1,    -1,  1418,  1419,    -1,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,    -1,  1431,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   455,   456,    -1,
      -1,   151,    -1,   153,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,   575,   576,   577,   578,   579,   580,    -1,
      -1,    -1,  2109,  2110,    -1,    -1,    -1,  2114,    -1,    -1,
      -1,    -1,    -1,    -1,  2121,    -1,    -1,  2124,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   574,   575,
     576,   577,   578,   579,   580,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2150,  2151,    -1,  2153,    -1,  2155,    -1,
      -1,    -1,    -1,    -1,    -1,  2162,    -1,    11,    12,    13,
    2167,  2168,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,  2196,
      -1,    45,    -1,    -1,    -1,  2202,    -1,    -1,    -1,    -1,
      -1,    -1,    11,    12,    13,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,   601,    -1,    -1,    -1,    -1,    -1,    67,
      -1,  1594,  1595,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,    87,
      -1,    -1,    90,    91,    92,    93,    94,    95,    96,    25,
      -1,  2258,    -1,    -1,    -1,    -1,    -1,  2264,    -1,  2266,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,
     118,   119,    -1,    -1,    -1,  1648,    63,    64,    -1,    -1,
     128,   129,    -1,   131,   132,   133,   134,   135,   136,    -1,
    1663,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    88,    -1,   151,    -1,   153,    -1,   116,    -1,    -1,
    2317,    87,    -1,   100,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,   110,   111,   112,   113,   114,   115,
    1713,    -1,   118,   119,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,    -1,    -1,    -1,  1737,  1738,  1739,  1740,    -1,    -1,
      -1,    -1,    -1,    -1,   161,   151,   163,   153,  1751,  1752,
     167,   168,    -1,    -1,    -1,   172,    -1,   601,    -1,   176,
      -1,  2398,    -1,  2400,    -1,    -1,   183,   184,   185,   186,
     187,   188,    -1,   190,    -1,  1778,    -1,  1780,    -1,   196,
      -1,    -1,  1785,    -1,    -1,    18,    -1,    20,    21,    22,
      23,    24,    25,    54,    -1,  2432,    29,    30,    -1,    -1,
      -1,  2438,    56,    -1,    -1,    -1,    39,    40,  1811,    63,
      64,    44,    -1,    -1,    -1,   232,    -1,    -1,   235,    11,
      12,    13,    -1,    56,    -1,    17,    -1,    88,    61,    -1,
      63,    64,    -1,    -1,    67,    -1,    -1,    -1,    -1,   245,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    -1,    45,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,   575,   576,   577,   578,   579,
     580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,
     123,   124,   125,   126,   127,   128,   129,    -1,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,    -1,
     143,   144,    -1,   146,    -1,  2552,    -1,   150,    -1,    -1,
      -1,    -1,   155,    -1,    -1,   158,    -1,    -1,    -1,   183,
     184,   185,   186,   187,   188,    -1,   190,    -1,    -1,    -1,
     201,   202,   203,    -1,    -1,    -1,    -1,    -1,  2585,    -1,
      -1,  2588,    -1,  2590,    -1,    -1,    -1,   190,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2602,    -1,    -1,    -1,    -1,
     231,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,   110,   111,   112,   113,   114,   250,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2003,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2646,
      -1,    -1,    -1,    -1,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,    -1,    -1,  2664,    -1,    -1,
      -1,    -1,  2669,    -1,    -1,    -1,  2673,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   308,    -1,  2686,
     311,  2054,    -1,  2690,  2691,    -1,  2693,    -1,  2695,    -1,
      -1,    -1,  2065,  2066,  2067,    -1,    -1,    -1,  2071,    -1,
     331,    -1,   333,   334,    -1,    -1,   337,    -1,    -1,    -1,
      -1,  2718,   343,  2720,  2721,  2722,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
     578,   579,   580,    -1,   521,   522,    -1,   524,  2111,    -1,
      -1,    -1,   529,   530,    -1,    -1,  2753,    -1,    54,   245,
    2757,    -1,  2759,   384,    -1,    -1,    -1,   170,   171,    65,
      66,    67,    68,    -1,    70,    71,    72,    -1,  2141,    75,
      -1,    77,    78,    -1,    -1,  2782,  2783,    83,    84,    -1,
      -1,    -1,    88,    -1,    -1,    -1,    -1,   200,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   574,   575,
     576,   577,   578,   579,   580,    -1,  2813,    -1,    -1,    -1,
    2817,  2818,  2819,    -1,   601,    -1,    -1,   230,    -1,    -1,
    2827,    -1,  2829,    -1,  2831,    -1,    -1,    -1,    -1,    -1,
    2837,    -1,    -1,    -1,   465,    -1,    -1,    -1,    54,   442,
     443,    -1,  2849,  2850,    -1,    -1,    -1,  2854,  2855,    65,
      66,    67,    68,    -1,    70,    71,    72,   488,    -1,    75,
      -1,    77,    78,    -1,    -1,    -1,    -1,    83,    84,    -1,
      -1,  2878,    88,    -1,    -1,    -1,  2883,    -1,    -1,    -1,
      -1,  2888,    -1,    -1,   297,  2892,    -1,    -1,    -1,    -1,
     303,    -1,    -1,    -1,   307,    -1,    -1,    -1,  2905,  2272,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   538,   539,   540,
     541,   542,    -1,   544,    -1,    -1,   547,    -1,   331,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,  2311,   108,
     109,   110,   111,   112,   113,   114,    -1,  2954,  2955,    -1,
    2957,  2958,  2959,  2960,  2961,    -1,    -1,    -1,    -1,    -1,
      -1,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   575,   576,   577,   578,   579,   580,    -1,  2352,
      -1,    -1,    -1,    -1,    -1,  2358,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2372,
      -1,  3008,  3009,  3010,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3019,  3020,    -1,    -1,    -1,    -1,  3025,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   444,  3039,  2406,    -1,  3042,  3043,  3044,   451,    -1,
      -1,   454,  3049,  3050,   457,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3059,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,    -1,  3073,    -1,  3075,  3076,
    3077,    -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,
    3087,  3088,  3089,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     503,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3107,  3108,    -1,    -1,    -1,    -1,    -1,    -1,    18,    73,
      20,    21,    22,    23,    24,    25,    -1,    -1,    -1,    29,
      30,    -1,   535,    -1,    88,    -1,    -1,    -1,    -1,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,  2510,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    56,    -1,    -1,   562,
      -1,    61,    -1,    63,    64,    -1,    -1,    67,  3165,  3166,
      -1,    -1,    -1,    -1,    -1,    -1,  3173,    -1,    -1,    -1,
    3177,    -1,    -1,    -1,    -1,  3182,    -1,    -1,  2551,    -1,
    3187,    -1,    -1,    -1,  2557,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   609,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   122,   123,    -1,    -1,    -1,    -1,   128,   129,
      -1,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,    -1,   143,   144,    -1,   146,   201,   202,    -1,
     150,    -1,    -1,    -1,    -1,   155,    -1,    -1,   158,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,  2642,
      18,    -1,    20,    21,    22,    23,    24,    25,    -1,    -1,
     190,    29,    30,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    56,    -1,
      -1,    -1,  2685,    61,  2687,    63,    64,    -1,    -1,    67,
      -1,    -1,    -1,    -1,    -1,    -1,  2699,    -1,   292,  2702,
    2703,    11,    12,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   310,    -1,    -1,    -1,
      -1,   315,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,   327,    -1,    45,    -1,   331,    -1,   333,
     334,    -1,    -1,    -1,   122,   123,    -1,    -1,    -1,   343,
     128,   129,   346,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,    -1,   143,   144,    -1,   146,    -1,
      -1,    -1,   150,    -1,    -1,    -1,    86,   155,    -1,    -1,
     158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    18,    -1,    20,    21,    22,    23,    24,
      25,    -1,   190,    -1,    29,    30,    -1,  2820,    -1,    -1,
      -1,    -1,    -1,  2826,    39,    40,    41,    -1,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    56,    -1,    -1,    -1,    -1,    61,    -1,    63,    64,
      -1,    -1,    67,    -1,    -1,  2858,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2868,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,    -1,    -1,    -1,    -1,    -1,   473,
      -1,    -1,    -1,    -1,   478,    -1,    -1,  2890,    -1,    -1,
      -1,  2894,    -1,    -1,   488,    -1,    -1,    -1,    -1,    -1,
     494,    -1,   442,   443,    -1,    -1,    -1,   122,   123,    -1,
      -1,    -1,    -1,   128,   129,    -1,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,    -1,   143,   144,
      -1,   146,    -1,    -1,    -1,   150,    -1,    -1,    -1,    -1,
     155,    -1,    -1,   158,  2947,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2956,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    11,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,  3001,    45,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3015,  3016,    -1,    -1,    -1,    -1,    -1,  3022,
    3023,    -1,    -1,  3026,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,   575,   576,   577,   578,   579,
     580,    87,    -1,    -1,    -1,  3048,    -1,    -1,    -1,  3052,
      -1,  3054,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   442,   443,    -1,  3070,  3071,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    11,    12,    13,
      14,    15,  3085,    17,    -1,    -1,    -1,    -1,    -1,  3092,
      -1,  3094,  3095,  3096,    -1,    -1,    -1,    -1,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    -1,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,
    3123,    20,    21,    22,    23,    24,    25,    -1,    62,    -1,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      39,    40,    41,  3146,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    56,    -1,  3162,
      -1,    -1,    61,    -1,    63,    64,    -1,    -1,    67,    -1,
      -1,    -1,    -1,    -1,    -1,  3178,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3188,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
     578,   579,   580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   122,   123,    -1,    -1,   442,   443,   128,
     129,    -1,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,    -1,   143,   144,    -1,   146,    -1,    -1,
      -1,   150,    -1,    -1,    -1,    -1,   155,    -1,    -1,   158,
      -1,    -1,    18,    -1,    20,    21,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,   190,    -1,    11,    12,    13,    14,    15,    -1,    17,
      56,    -1,    -1,    -1,    -1,    61,    -1,    63,    64,    -1,
      -1,    67,    -1,    -1,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   122,   123,    86,    -1,
      -1,    -1,   128,   129,    -1,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,    -1,   143,   144,    -1,
     146,    -1,    -1,    -1,   150,    -1,    -1,    -1,    -1,   155,
      -1,    18,   158,    20,    21,    22,    23,    24,    25,    -1,
      -1,    -1,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    40,    -1,    -1,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    54,   190,    -1,     6,    58,    -1,    56,
      -1,    -1,    63,    64,    61,    -1,    63,    64,    -1,    -1,
      67,    -1,    22,    23,    24,    25,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    56,    -1,    -1,    -1,
      -1,    -1,    -1,    63,    64,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   122,   123,    -1,    -1,    -1,
      -1,   128,   129,    -1,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,    -1,   143,   144,    -1,   146,
      -1,    -1,    -1,   150,    -1,    -1,    -1,    -1,   155,    -1,
     161,   158,   163,   442,   443,    -1,   167,   168,    -1,   119,
     120,    -1,    -1,    -1,    -1,   176,    -1,    -1,    -1,    -1,
      -1,    -1,   183,   184,   185,   186,   187,   188,    -1,   190,
      -1,    -1,    -1,   190,    -1,   196,   146,   147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
      -1,    -1,    -1,   173,   174,    -1,    -1,    -1,   178,    -1,
      -1,   232,    -1,    -1,   235,    -1,    -1,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,    -1,    -1,   255,    -1,    -1,   258,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   222,   223,   224,    -1,   226,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   564,   565,   566,   567,   568,
     569,   570,   571,   572,   573,   574,   575,   576,   577,   578,
     579,   580,    -1,    -1,    -1,    -1,   442,   443,    11,    12,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      -1,   342,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   354,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   376,    11,    12,    13,    14,
      15,    -1,    17,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    -1,    -1,    -1,    56,    -1,    58,    -1,
      -1,    -1,    -1,    63,    64,    -1,    -1,    -1,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   574,   575,
     576,   577,   578,   579,   580,   442,   443,    -1,    88,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   161,    -1,   163,    -1,    -1,    -1,   167,   168,    -1,
     170,    -1,   172,    -1,    -1,    -1,   176,   177,    -1,    -1,
      -1,    -1,    -1,   183,   184,   185,   186,    -1,   549,    -1,
      -1,    -1,    -1,   554,    -1,   556,   196,   197,    -1,    -1,
     140,   201,    -1,   203,    -1,    -1,    -1,   564,   565,   566,
     567,   568,   569,   570,   571,   572,   573,   574,   575,   576,
     577,   578,   579,   580,    -1,    -1,   166,    -1,   168,    -1,
      -1,    -1,   232,   173,   174,   235,    -1,    -1,   178,    -1,
     601,    -1,    -1,    -1,   244,    -1,    -1,    -1,   248,    -1,
     250,   191,    -1,    -1,    -1,   255,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   291,    -1,    -1,   294,    -1,    -1,    -1,   298,   299,
      -1,    -1,    -1,    -1,   244,    -1,   246,    -1,   248,    -1,
      -1,   251,    -1,    -1,    -1,   255,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   325,    -1,    -1,    -1,   329,
      -1,   331,    -1,    -1,   334,    -1,    -1,    -1,    -1,   339,
     340,    -1,   342,   343,    -1,    -1,   346,    -1,    -1,    -1,
      -1,    -1,   352,   353,    -1,   355,   356,    -1,    -1,   359,
      -1,    -1,    -1,    -1,   364,   365,   366,    -1,    -1,    -1,
     370,   371,    -1,    -1,    -1,    -1,    -1,    -1,   378,    -1,
     380,   321,    -1,   383,   384,    -1,   386,   327,   388,    -1,
      -1,   391,   392,    -1,    -1,    -1,    -1,    11,    12,    13,
      14,    15,    -1,    17,    -1,    -1,    -1,   407,    -1,   409,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   417,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    -1,
      -1,    45,    -1,   373,    -1,    -1,    -1,    -1,    -1,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,
      11,    12,    13,    14,    15,   405,    17,    -1,    -1,    -1,
     410,    -1,    86,    -1,    -1,    -1,    -1,   417,    -1,    -1,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    -1,    -1,    45,    11,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45,
      11,    12,    13,    14,    15,    86,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    -1,    -1,    45,    11,    12,    13,    14,    15,
      86,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45,
      -1,   601,    -1,    -1,    -1,    86,    -1,    11,    12,    13,
      14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    11,    12,    13,    14,    15,    -1,    17,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    -1,
      86,    45,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    62,    11,
      12,    13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    62,    11,    12,    13,    14,    15,    -1,    17,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    -1,    45,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      62,    11,    12,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    62,    11,    12,    13,    14,    15,
      -1,    17,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    -1,    -1,    45,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45,
      -1,    -1,    62,    11,    12,    13,    14,    15,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    -1,    62,    11,    12,    13,
      14,    15,    -1,    17,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    -1,    -1,    45,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    -1,
      -1,    45,    -1,    -1,    62,    11,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    62,    11,
      12,    13,    14,    15,    -1,    17,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    -1,    45,    -1,    -1,    62,    11,    12,    13,
      14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,
      62,    11,    12,    13,    14,    15,    -1,    17,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    -1,
      -1,    45,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    -1,    -1,    45,    -1,    -1,    62,    11,
      12,    13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    62,    11,    12,    13,    14,    15,    -1,    17,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    -1,    45,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,
      62,    11,    12,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    62,    11,    12,    13,    14,    15,
      -1,    17,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    -1,    -1,    45,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45,
      -1,    -1,    62,    11,    12,    13,    14,    15,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    -1,    62,    11,    12,    13,
      14,    15,    -1,    17,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    -1,    -1,    45,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    -1,
      -1,    45,    -1,    -1,    62,    11,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    60,    -1,    -1,    11,
      12,    13,    14,    15,    -1,    17,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    -1,    45,    60,    11,    12,    13,    14,    15,
      -1,    17,    -1,    -1,     6,    -1,    -1,    -1,    60,    11,
      12,    13,    14,    15,    -1,    17,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    -1,    45,    60,    11,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    -1,    45
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     7,   615,   616,     3,     4,     5,   148,   168,   196,
     197,   233,   235,   237,   241,   248,   283,   287,   294,   454,
     604,   605,   611,   612,   613,   614,   811,   812,   813,   814,
     816,   817,   818,   825,   827,   828,   829,   830,   831,   832,
     833,   834,   835,   836,   837,   838,   840,   841,   842,   843,
     844,   845,   846,   848,   849,   850,   874,   893,   894,   895,
     896,   917,   950,   951,   952,   967,  1005,  1006,  1007,  1008,
    1009,  1010,  1011,  1012,  1064,  1065,  1099,  1128,  1129,  1130,
    1131,  1132,  1133,  1134,  1135,  1136,  1137,     0,     6,    46,
      56,    60,    63,    64,    89,   146,   148,   149,   152,   154,
     161,   163,   164,   165,   168,   183,   184,   185,   186,   187,
     188,   190,   235,   241,   247,   248,   590,   594,   601,   602,
     617,   618,   683,   685,   686,   687,   688,   701,   752,   753,
     754,   755,   756,   757,   758,   763,   777,   778,   790,   791,
     792,   853,   854,   875,   880,   883,   886,   897,   900,   919,
     927,   953,   955,   958,   961,   963,   966,   970,   971,  1014,
    1016,  1017,  1022,  1053,  1056,  1066,  1067,  1083,  1084,  1100,
    1104,  1113,  1114,  1118,  1119,  1124,  1140,  1145,  1146,     6,
       6,     6,    18,    20,    21,    22,    23,    24,    25,    29,
      30,    39,    40,    44,    56,    61,    63,    64,    67,   122,
     123,   128,   129,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   143,   144,   146,   150,   155,   158,
     190,   442,   443,   564,   565,   566,   567,   568,   569,   570,
     571,   572,   573,   574,   575,   576,   577,   578,   579,   580,
     628,   629,   630,   631,   632,   633,   634,   635,   636,   637,
     638,   639,   640,   641,   679,   680,   681,   708,   726,   728,
     729,   732,   733,   734,   738,   739,   751,  1102,    25,    29,
     169,   824,   847,   851,    25,   851,   851,   182,   230,   851,
       6,    25,    29,    61,   242,   619,   621,   649,   780,   196,
      56,   207,   209,   238,   245,   284,   286,   297,   307,   331,
     457,   535,   602,   146,   179,   181,   205,   207,   209,   288,
     289,   290,   292,   293,   851,   287,   250,   284,   588,   591,
     592,   649,  1138,     6,    25,    26,   620,   295,   620,   156,
     620,   738,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   108,   109,   110,   111,   112,   113,   114,   230,
     245,   689,    61,    61,   162,   649,   179,   207,   208,   225,
     283,   593,   189,   207,   649,   164,   245,   246,   247,   779,
    1103,   196,   649,   422,   538,   603,    20,   619,   622,   178,
     253,   759,   170,   171,   200,   230,   297,   303,   307,   331,
     444,   451,   454,   457,   503,   535,   562,   609,   969,  1052,
      57,   620,   764,    88,   161,   163,   167,   168,   172,   176,
     196,   232,   235,   250,   601,   755,   765,   766,   772,   794,
      87,   857,   764,   764,   764,   764,    56,    58,    63,    64,
      88,    96,   136,   170,   172,   177,   183,   184,   185,   186,
     197,   201,   203,   244,   248,   250,   255,   291,   294,   298,
     299,   325,   329,   331,   334,   339,   340,   342,   343,   346,
     352,   353,   355,   356,   359,   364,   365,   366,   370,   371,
     378,   380,   383,   384,   386,   388,   391,   392,   407,   409,
     417,   765,   865,   866,   930,   941,   949,   764,    88,   334,
     342,   445,   446,   447,   765,   764,   764,   764,    55,    56,
      88,   248,   305,   460,   461,   462,   463,   488,   493,   498,
     756,   765,   973,   974,   975,   976,   977,    87,    58,    88,
     166,   173,   174,   178,   191,   200,   304,   765,   767,   764,
     764,   764,   764,    88,   245,   250,   380,   765,   772,   865,
    1089,  1091,    88,   248,   305,   308,   562,   563,   606,   607,
     608,   765,   772,   865,  1101,  1143,  1144,    87,  1122,   764,
     764,    88,   172,   607,   765,  1147,    20,    25,    39,    41,
      61,   158,   160,   725,   727,   751,    42,   627,    42,    22,
      23,   628,   629,   630,    61,   145,    40,   145,   738,   622,
     124,   125,   126,   127,   714,   738,    87,    87,    61,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    20,    21,
      24,    25,    61,   159,   628,   630,   638,   708,   709,   710,
     713,   715,   716,   717,   720,   722,   723,   622,    61,    61,
      58,    20,    58,     6,    11,    12,    13,    14,    15,    17,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    45,    45,    48,    87,   169,   795,     6,   795,    29,
     650,   650,   120,   234,   851,   120,   234,   851,    48,    87,
     169,   798,   738,   243,   244,   622,     6,     6,   302,    25,
      29,   169,   852,     6,   285,     6,   819,     6,   826,    25,
     815,   181,   209,   292,   317,   351,   172,   292,   487,   500,
     501,   815,   209,   292,     6,   169,   169,   649,   649,   649,
     649,   649,   649,   649,   291,   649,   649,   650,   968,  1138,
       6,  1138,     6,     6,   538,  1139,    32,   620,   702,   622,
     684,   690,    20,   107,   620,    25,   621,    20,    22,    57,
     619,   654,    60,   795,   795,   795,   622,   245,    48,    87,
     169,   192,  1125,   798,    60,   780,   581,   587,   589,   600,
     649,  1107,   249,  1115,  1116,   622,   623,   623,   620,   620,
      87,   762,  1015,   458,   459,   536,    25,    57,    87,   162,
     649,    20,    47,    48,    49,    50,   122,   123,   619,   624,
     795,   793,   177,   649,   260,   649,   798,   251,   603,    60,
      87,   770,    60,    60,   856,   858,    87,    87,    87,    87,
     244,   248,   249,   360,   624,    60,   296,   649,   362,   363,
      56,   394,    56,   394,    56,   394,    56,   394,   333,   361,
     649,   624,   395,   196,   251,   244,   248,   352,   355,    87,
     938,   245,   321,   369,   377,   403,   328,   352,   372,   248,
     624,   928,   421,    60,   622,    22,    23,   296,   619,   625,
     921,   411,   625,   920,   175,   213,   290,   925,   347,   260,
     328,   354,   260,   352,   308,   337,   367,   368,   367,   163,
     624,   379,   308,   308,   385,   383,    59,   342,   362,   363,
     624,   393,   622,   408,   347,   163,   244,   245,   248,   321,
     369,   377,   412,    60,    60,    87,   870,    87,   947,    60,
      87,   314,   337,   337,   232,   403,   448,    60,    87,    87,
      87,   499,   196,   401,   654,   624,   161,   622,   624,   162,
     624,   394,   972,   770,    60,    87,   502,   622,   120,   146,
     147,   169,   175,   192,   198,   698,   774,   120,   192,   774,
      25,   773,   192,   233,   178,    60,    60,    87,    87,    87,
      87,    24,    25,   641,   645,   251,   178,    60,    60,    60,
      95,   357,   375,   382,   557,   558,   559,   560,   561,  1085,
    1087,    87,  1097,   196,   389,   622,   178,   333,   624,   260,
     169,   624,  1141,    60,    60,  1121,  1123,    87,    87,  1148,
    1152,   260,    60,    10,   727,   727,   727,   738,    22,    23,
     159,   720,   727,   727,    19,    20,    20,   730,   731,   738,
      39,    40,   145,    40,    20,    86,    62,    86,   676,   676,
     773,   773,   738,   738,   738,   738,   738,   738,   738,   738,
      41,   712,   714,   738,    39,    40,    87,    10,    86,   159,
      86,   159,   773,   773,   622,    57,   622,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   735,    56,    63,    64,   183,   184,
     185,   186,   187,   188,   190,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   823,   180,   181,   182,
     205,   206,   209,   796,   797,     6,     6,   851,   851,   240,
     839,   851,   851,     6,   180,   236,   799,   800,     6,    62,
      52,    53,    52,    53,   649,   873,   852,     6,     6,     6,
     119,   120,   146,   164,   169,   173,   174,   178,   199,   222,
     223,   224,   226,   227,   228,   645,   698,   822,     6,    25,
      89,   146,   164,   165,   178,     6,   815,   815,   815,   815,
     918,   815,   815,  1013,   169,   815,   169,   815,     6,   815,
     815,     6,   649,     6,     6,     6,     6,     6,     6,     6,
     649,     6,     6,     6,     6,   146,   178,   204,   698,     6,
    1139,   622,     6,   738,    61,   692,   622,   693,   695,   700,
     130,   190,   256,   265,   279,   280,   281,   282,   430,   534,
     682,   689,    60,    86,    86,   787,   788,    60,   795,   205,
     289,   595,   596,   597,   598,   599,  1126,  1127,   623,    60,
      60,   403,  1105,    22,    23,    29,   619,   656,  1108,   649,
     622,  1106,    87,   169,  1110,   622,    60,    87,    51,    52,
      53,   761,   764,    25,   654,   781,   784,   785,   623,   624,
     620,   769,   771,    84,    88,   855,   859,   860,   879,   885,
     899,   395,   196,   260,   260,    60,   787,    60,   622,   622,
     624,    96,   431,    60,    60,   248,   396,   260,   390,   624,
     624,   395,   196,   260,   260,   939,    60,   258,   236,   624,
     245,   404,   649,   260,   260,   624,    60,    60,    87,   810,
     422,    60,   619,   638,   644,    43,   626,    54,    59,    60,
     136,   400,   401,   304,   413,   414,   415,   416,   926,   626,
      54,    59,    60,    60,   624,   622,   260,   260,   622,   260,
     624,   625,   624,   162,   624,   624,    60,   624,   624,   624,
     624,   624,   402,    59,   624,   624,    60,   624,    60,    59,
     624,   624,   395,   258,   196,   236,   624,   245,   624,   869,
     871,   872,   946,   948,   192,   625,   954,   649,   649,   120,
     960,   965,   624,   260,   390,   624,   624,   624,   192,   622,
     771,   978,   622,   645,    25,   696,   697,   699,    48,   622,
     776,   199,   645,   776,   776,   624,   773,  1021,  1055,  1068,
    1090,   624,   773,   656,   625,  1092,    56,   134,   136,   331,
     341,  1085,  1098,    60,   624,   624,   622,   314,   622,    58,
      88,   177,   255,   596,   602,  1120,   785,   786,   622,    20,
      62,   727,   159,    86,    62,   145,    40,   738,   738,   677,
     678,    62,    86,    86,    62,    86,    86,    86,    86,    86,
      62,    62,    86,    10,    86,    86,    62,    20,    61,   710,
     717,   722,    62,    62,    59,    23,    59,    25,    27,    28,
     733,   736,    86,    88,   839,   839,   738,     6,     6,     6,
      86,    88,     6,    25,   297,   298,     6,    22,    23,    24,
      25,   628,   630,   631,   632,   633,   820,   821,   645,   696,
      25,   178,   178,    25,   169,    25,   824,   650,   650,   650,
     650,     6,    25,   169,   170,   172,   183,   184,   337,   339,
     341,   650,   650,     6,    25,    73,   161,   251,   358,   419,
     460,   492,   815,   650,   815,   650,   650,   650,     6,     6,
     696,    29,   773,   649,     6,    60,    62,   691,    16,   694,
      60,    87,   689,   620,   649,   621,   785,    60,    86,    88,
     649,    54,  1109,   622,   649,    96,   168,   422,   549,   582,
     583,   584,   585,   586,  1111,  1112,    60,    60,  1117,    88,
     168,   174,   245,   252,   253,   254,   257,   261,   601,   760,
      40,   783,    86,    60,    88,   168,   173,   767,   768,   296,
      60,    87,   863,    88,   301,   304,   305,   765,   767,   876,
      88,   172,   318,   765,   772,   884,    88,    94,   172,   338,
     339,   340,   346,   348,   765,   898,   396,   260,   622,   622,
     786,    60,    60,    60,   624,    87,   624,   922,   196,   260,
     622,    60,    60,    60,   396,   260,   622,   622,   937,   940,
     624,   624,    60,   258,   622,    60,   622,   622,    60,     8,
     915,   929,   622,   921,   620,   921,   622,   622,    60,   920,
     622,   622,    60,    60,   622,   622,    60,   622,    60,    60,
      60,   654,    60,    60,    60,    60,    60,    60,    60,   624,
      60,   622,    60,    60,    60,   624,    60,    60,   248,   624,
     624,   624,    60,   258,    60,    84,    88,   295,   768,   868,
     771,    58,    68,    88,   140,   173,   174,   244,   246,   248,
     251,   255,   321,   327,   373,   380,   381,   387,   399,   405,
     410,   417,   768,   945,   622,    60,    54,    60,    99,    60,
      60,   449,   450,    88,   101,   173,   174,   245,   755,   765,
     865,   956,   957,   959,    88,   146,   178,   263,   455,   456,
     698,   765,   964,   622,   622,    88,   172,   177,   285,   401,
     462,   479,   481,   485,   489,   490,   979,   986,   989,    60,
     774,   695,   738,   193,   775,   624,   774,    60,    88,   100,
     172,   521,   522,   524,   529,   530,   765,   772,  1018,    88,
     172,   488,   537,   765,   772,  1054,    54,    58,    88,   255,
     258,   342,   354,   376,   549,   554,   556,   765,   772,  1069,
    1071,    56,  1088,    60,    60,  1086,    56,   622,  1093,  1094,
     622,   646,   647,   622,   624,   624,   649,  1096,   192,  1142,
     622,   260,   593,   624,   260,   260,   622,    60,    87,  1151,
     727,   727,   738,    40,    40,    86,    62,    86,   674,   675,
     738,   738,   738,   738,   738,   738,   738,    41,   712,   738,
     712,    41,   712,   712,    86,   738,   622,    42,   622,   737,
     797,     6,     6,   800,    57,    22,    23,    25,   824,   824,
       6,     6,     6,     6,   649,    22,    23,   619,   628,   630,
     655,   649,     6,     6,   622,   654,   654,   654,   650,     6,
     650,     6,     6,     6,   689,   689,   703,    87,    90,    91,
      92,    93,    94,    95,    96,   115,   118,   119,   151,   153,
     689,   704,   705,   706,   707,   732,   740,   741,   743,   751,
     620,    60,    62,    86,  1127,   622,    86,    88,    88,   237,
     458,   795,   259,   258,   262,   624,   624,   259,   262,   263,
     603,    60,    22,    23,    29,   619,   638,   649,   782,   784,
     795,    60,   297,   298,   620,   862,   864,    47,   178,   306,
      60,   887,   892,   161,    60,   902,   903,   907,   601,   903,
     908,   625,   912,   347,   349,    60,   260,   622,    86,    60,
      60,    60,   100,   234,   304,   431,   433,   435,   438,   923,
     924,    60,   390,   624,   622,    60,   260,   622,    60,    60,
      88,   202,   931,   936,    60,    60,   624,    60,    60,    60,
      88,   914,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,   196,    60,    60,    60,   624,   296,
     300,    25,    60,   244,   316,   389,   178,   178,   259,   395,
     178,   196,   342,   244,    68,   622,   374,   178,   170,   382,
     624,   624,   406,   624,   624,   140,   321,    60,    60,   622,
     625,   624,   624,    24,   452,   452,   452,   453,   770,    60,
     696,    29,   773,   622,   649,   140,    60,   998,  1004,   327,
     464,   489,   624,   981,   327,   624,   980,   251,   644,   982,
     983,   491,   624,    60,   493,   999,    60,   194,   195,   196,
     197,   619,   630,   643,  1032,  1037,  1023,  1031,  1019,  1020,
     643,   181,   531,    60,  1057,  1063,   624,   622,    60,   622,
     541,   541,   198,  1070,   337,  1070,    58,   656,  1072,    75,
     553,  1073,  1070,    60,   622,   626,   647,    86,    42,    88,
     743,  1095,   622,   623,   623,   623,   623,  1150,    40,   738,
     738,    54,    65,    66,    67,    68,    70,    71,    72,    75,
      77,    78,    83,    84,    88,   660,   661,   662,   663,   664,
     672,    88,   661,   662,   663,   664,   673,    86,    86,    62,
      62,    62,    62,    62,    62,    86,    10,    62,    86,    62,
      86,    10,    62,    86,    86,    20,    20,    61,    23,     6,
       6,   620,   700,   744,   730,   730,    61,   738,   738,   738,
     746,    61,    61,   620,    88,   706,    60,   730,    32,    45,
      60,   622,  1112,    60,    60,   293,   260,   174,   622,   260,
     622,   623,   620,   655,    77,    88,   299,   861,   877,   773,
     878,   786,   162,   170,   183,   184,   339,   901,   786,   603,
      87,   906,    43,   341,   909,   624,   350,   622,    60,   622,
     192,   441,   437,   142,   434,   436,   439,   440,    86,    88,
      60,    60,    60,   622,    60,    87,    60,    60,    88,   201,
     202,   203,   231,   248,   255,   332,   335,   336,   343,   801,
     802,   804,   805,   806,   913,   624,    60,    25,   297,   298,
     100,   176,   297,   301,   867,   395,   198,   329,   337,   358,
     333,   334,   624,   624,   624,   260,   248,   396,   773,   624,
      68,   395,   316,   358,   375,   376,   944,   773,   389,    68,
      60,    60,    61,   158,   169,   175,   715,   962,   962,   962,
      24,   771,   359,   785,  1000,   622,   622,   624,    87,   622,
      87,   654,    87,   622,   622,    87,    87,  1036,   786,    87,
     625,  1038,  1043,    87,   649,  1044,  1049,   624,    73,   786,
     192,   622,   622,   622,   625,   622,    77,  1071,  1074,  1079,
     622,  1093,   622,    88,   427,  1149,    40,    62,    62,    69,
      73,    74,    76,    11,    12,    13,    32,    33,    34,   122,
     123,   622,   658,   665,   666,   667,    44,   668,   669,   669,
     671,   619,   628,   642,    60,   665,   668,   671,   643,    60,
     738,   738,    41,   712,    41,   712,    41,   712,    10,    41,
     712,    41,   712,    88,   731,    60,    62,   704,    60,    60,
      25,    60,   116,    87,    25,   689,   742,   750,   750,    32,
      60,    60,   738,   749,    62,    60,   623,   648,   259,   622,
     648,   622,   622,    60,    61,   751,   881,   882,   700,    87,
     891,   624,   906,   620,   914,   904,   620,   649,   342,   910,
     333,    60,    60,   432,   288,   924,    60,   934,   916,   624,
      87,   333,   334,   334,   623,   622,   175,   211,   344,   345,
     905,    29,    30,   619,   653,   657,   739,    87,   809,    60,
      60,   396,   397,   398,   624,   942,   342,   419,   625,   942,
     648,   196,   260,   316,   396,   624,   624,   316,   159,   715,
     719,   624,  1001,    87,  1003,   991,   991,   984,   987,  1035,
    1034,    87,  1030,  1039,  1045,   622,    87,  1062,   622,   624,
      87,  1075,    87,   625,    60,    10,   622,    14,    15,   659,
      86,    15,    86,   659,   622,    79,    80,    81,    82,   670,
      86,   659,    85,    62,    62,    62,    62,    62,    86,    10,
      62,    62,    62,    86,    61,    62,    10,    62,    62,    10,
      62,    62,   745,    62,   743,   724,   620,   120,   738,   751,
     738,    60,   736,   623,   260,   738,    86,   890,   888,   904,
      88,   625,   339,   911,   624,    88,   162,   210,   325,   420,
     425,   426,   427,   932,   803,   804,   335,   335,   335,   213,
     214,   211,    57,    94,   162,   204,   210,   229,   807,   260,
     624,   622,   155,   260,   624,    86,   159,   999,  1002,    88,
     644,   992,   993,    88,    88,   285,   327,   480,   985,    88,
     249,   310,   343,   465,   466,   467,   801,   988,    88,   136,
     427,   516,   519,   520,   533,  1033,  1029,  1028,  1042,  1048,
     532,  1061,  1058,  1076,  1078,  1080,   622,   667,   658,   666,
     669,   669,    42,   669,   669,   622,    41,   712,    41,   712,
     712,    10,   712,    88,    60,   117,     9,    88,   709,   711,
     713,   715,   716,   718,   721,   747,   750,   750,    60,    60,
     648,    62,   882,    54,    68,    73,    88,   192,   250,   309,
     310,   311,   321,   323,   325,   333,   334,   343,   801,   889,
     624,   935,   622,   211,   212,   218,   219,   220,   221,   428,
     808,   933,   162,   162,   657,    60,    60,    88,    60,   623,
     623,   623,   213,   214,   649,   651,    57,   204,   622,   651,
     808,    57,   204,    88,   622,   330,   423,   424,   943,   622,
     715,    73,    88,   249,   250,   251,   292,   310,   315,   327,
     331,   333,   334,   343,   346,   384,   462,   465,   466,   467,
     473,   478,   488,   494,   801,   990,   480,   486,   994,   624,
     622,   624,    60,   622,   622,   175,   344,   476,   622,   328,
     224,   622,    60,   624,   518,   518,   624,   624,   427,    60,
      58,    88,   100,   177,   245,   251,   255,   505,   507,   508,
     512,   513,   515,   521,   522,   530,  1024,    88,   518,   523,
    1040,    88,   295,   518,  1046,    30,   652,   653,    54,    88,
     203,   250,   308,   311,   331,   333,   334,   337,   343,   384,
     465,   488,   538,   539,   540,   541,   542,   544,   547,   801,
    1059,    88,   201,   343,  1077,    88,   549,   550,   555,  1081,
     622,   622,   622,   622,   670,   670,    62,    62,    62,    86,
      62,    61,    62,   743,   743,    10,    86,   157,   738,    62,
      86,   622,   316,   312,   313,   322,   622,   251,   622,   335,
     335,    68,    58,   255,   324,   327,   326,   314,    77,    78,
     239,   315,   789,   175,   319,    60,    60,   213,   214,   215,
     216,   217,   213,   214,   215,   216,   217,   429,    60,   622,
     622,    60,   803,    60,   651,   651,    60,    60,    60,   651,
     651,   809,   468,   469,   470,   471,   472,   473,   474,   475,
     622,   251,   496,    87,   622,   622,   622,   624,   314,    77,
     315,   789,   175,   344,   476,   470,   385,   624,   622,   328,
     224,   622,   337,   495,   622,   134,   468,    60,   622,    60,
     622,   622,   622,   622,   624,   504,   510,  1037,   166,   518,
     166,   510,   518,   511,   328,   504,   504,   624,   509,   260,
     514,   316,   342,  1025,   342,  1026,   531,    60,  1041,   517,
     622,  1050,  1038,    60,  1047,  1044,  1050,    60,   622,   624,
     251,   348,   622,   260,   624,   314,    77,   315,   789,   625,
     175,   213,   476,   546,  1060,   385,   260,   134,   260,   260,
     394,   468,   482,   622,   543,   545,   548,    60,   649,   175,
     213,    60,  1082,   552,   551,   649,    60,    42,    42,   712,
     712,   711,   718,   743,   748,    60,   738,   183,   184,   329,
     624,   623,   623,   316,   623,   623,   622,   622,   624,   622,
     622,   622,   622,   622,   320,    60,    60,   807,    60,    60,
     807,   807,   807,    60,    60,   624,   497,   995,   483,   484,
     622,   622,   622,   624,   334,   624,   622,   622,   624,   624,
     622,   624,   525,  1051,  1051,   335,   260,   526,   527,   528,
    1027,   622,  1027,   260,   622,   622,   622,   335,   506,   624,
     622,   622,   192,   624,  1043,   624,  1049,    73,   342,   622,
     624,   624,   622,   622,   622,   622,   334,   624,   623,   622,
     622,   622,   624,   624,   624,   624,   202,   202,   622,   622,
      62,    86,   121,    62,   625,   625,   184,   330,   624,   807,
     807,   807,   807,   624,    88,   625,   997,   482,   624,   622,
     622,  1051,   622,  1051,   622,   624,   622,   622,   624,   482,
     649,   649,   712,   743,    60,   477,   996,   532,    86,    60,
     652,   712,    62
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   610,   682,   682,   682,   682,   682,   682,   682,   682,
     682,   682,   615,   615,   616,   616,   617,   617,   618,   619,
     619,   620,   620,   621,   622,   622,   623,   623,   623,   624,
     624,   624,   624,   624,   624,   624,   624,   624,   625,   625,
     625,   626,   626,   627,   628,   629,   630,   631,   632,   633,
     634,   635,   636,   637,   638,   638,   639,   639,   640,   640,
     641,   641,   641,   641,   641,   641,   641,   642,   642,   643,
     643,   644,   644,   645,   645,   646,   647,   647,   648,   649,
     649,   650,   650,   651,   652,   652,   653,   653,   654,   654,
     654,   655,   655,   655,   655,   655,   656,   656,   656,   656,
     657,   657,   657,   658,   658,   658,   658,   658,   658,   658,
     658,   659,   659,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   660,   661,   662,   663,   664,   664,   665,   665,
     665,   665,   666,   666,   667,   667,   668,   668,   668,   669,
     669,   670,   670,   670,   670,   671,   671,   671,   672,   672,
     672,   672,   673,   673,   673,   673,   673,   674,   674,   675,
     675,   676,   677,   678,   679,   680,   681,   681,   611,   612,
     611,   613,   611,   614,   617,   617,   684,   683,   617,   685,
     617,   686,   617,   687,   617,   688,   689,   689,   689,   689,
     689,   689,   689,   689,   689,   689,   689,   689,   689,   689,
     689,   689,   689,   689,   690,   689,   691,   691,   692,   692,
     693,   693,   694,   694,   695,   696,   697,   696,   699,   698,
     700,   617,   702,   703,   701,   704,   704,   705,   705,   706,
     707,   707,   708,   708,   709,   709,   709,   709,   709,   710,
     710,   711,   712,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   714,   714,   714,   714,   715,   715,   715,
     716,   716,   716,   716,   716,   716,   716,   716,   717,   717,
     717,   717,   717,   718,   718,   718,   718,   718,   719,   719,
     720,   720,   721,   721,   722,   722,   722,   722,   723,   723,
     724,   724,   724,   725,   725,   726,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   729,   729,   729,
     729,   730,   730,   730,   731,   732,   733,   733,   733,   733,
     733,   733,   733,   733,   733,   735,   734,   736,   737,   736,
     736,   736,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   739,   740,   740,   740,   741,   741,   742,   742,   744,
     745,   743,   743,   743,   746,   747,   748,   743,   743,   743,
     743,   743,   743,   743,   743,   743,   749,   743,   743,   743,
     750,   751,   751,   617,   752,   752,   617,   753,   617,   754,
     755,   755,   755,   755,   755,   755,   755,   755,   755,   755,
     756,   756,   617,   757,   758,   759,   759,   760,   760,   760,
     760,   760,   760,   760,   760,   760,   760,   761,   761,   762,
     762,   617,   763,   763,   764,   764,   764,   764,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   766,
     767,   767,   767,   767,   767,   767,   767,   767,   767,   767,
     768,   768,   769,   769,   770,   770,   771,   772,   773,   774,
     774,   774,   774,   775,   775,   775,   775,   775,   776,   776,
     617,   777,   777,   777,   777,   777,   617,   778,   779,   779,
     779,   779,   780,   780,   780,   780,   780,   780,   780,   780,
     781,   782,   782,   782,   782,   782,   782,   783,   783,   784,
     785,   785,   786,   787,   788,   789,   789,   790,   791,   792,
     792,   792,   792,   792,   793,   794,   795,   795,   795,   796,
     796,   797,   797,   797,   797,   797,   797,   798,   798,   798,
     799,   799,   800,   800,   801,   802,   802,   803,   803,   804,
     804,   805,   805,   806,   807,   807,   807,   807,   807,   807,
     807,   807,   807,   808,   808,   808,   808,   808,   808,   808,
     808,   808,   808,   808,   808,   808,   808,   809,   810,   611,
     811,   611,   812,   611,   813,   611,   814,   815,   815,   611,
     816,   611,   817,   611,   818,   819,   819,   819,   819,   819,
     819,   819,   819,   819,   819,   819,   819,   819,   819,   819,
     819,   819,   819,   820,   820,   820,   820,   820,   820,   820,
     820,   821,   821,   821,   821,   822,   822,   822,   822,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     824,   611,   825,   826,   826,   826,   826,   826,   826,   826,
     611,   827,   611,   828,   611,   829,   611,   830,   611,   831,
     611,   832,   611,   833,   611,   834,   611,   835,   611,   836,
     611,   837,   611,   838,   839,   839,   611,   840,   611,   841,
     611,   842,   611,   843,   611,   844,   611,   845,   611,   846,
     847,   847,   611,   848,   611,   849,   611,   850,   851,   851,
     851,   852,   852,   852,   617,   853,   854,   855,   856,   856,
     857,   857,   858,   859,   860,   860,   860,   861,   861,   862,
     862,   863,   863,   864,   865,   866,   867,   867,   867,   867,
     868,   868,   868,   868,   868,   868,   869,   869,   870,   870,
     872,   871,   873,   873,   873,   873,   611,   874,   790,   875,
     876,   876,   876,   877,   876,   878,   876,   879,   879,   880,
     881,   881,   882,   882,   790,   897,   898,   898,   898,   898,
     898,   898,   898,   898,   899,   899,   900,   901,   901,   901,
     901,   902,   902,   903,   904,   905,   905,   905,   905,   905,
     905,   906,   906,   907,   908,   909,   909,   909,   910,   910,
     911,   911,   912,   913,   913,   913,   913,   913,   913,   913,
     913,   913,   914,   914,   915,   916,   810,   611,   917,   918,
     918,   918,   918,   918,   918,   918,   918,   918,   918,   790,
     883,   884,   884,   884,   884,   885,   885,   886,   887,   888,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   890,   890,
     891,   891,   892,   611,   893,   611,   894,   611,   895,   611,
     896,   790,   919,   920,   920,   920,   921,   921,   921,   921,
     921,   921,   922,   922,   923,   923,   924,   924,   924,   924,
     924,   924,   924,   924,   924,   925,   925,   925,   926,   926,
     926,   926,   926,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   927,   927,   927,   927,   928,   929,   927,   927,
     927,   927,   927,   927,   930,   930,   930,   930,   930,   930,
     930,   930,   930,   930,   930,   930,   931,   932,   932,   932,
     932,   932,   932,   932,   933,   933,   934,   934,   935,   936,
     937,   937,   939,   938,   940,   941,   942,   942,   942,   943,
     943,   943,   944,   944,   944,   945,   945,   945,   945,   945,
     945,   945,   945,   945,   945,   945,   945,   945,   945,   945,
     945,   945,   945,   945,   945,   945,   945,   945,   945,   945,
     945,   945,   945,   945,   945,   945,   945,   946,   946,   947,
     947,   948,   949,   686,   611,   950,   611,   951,   611,   952,
     738,   738,   790,   956,   957,   958,   959,   959,   959,   959,
     959,   959,   959,   959,   959,   960,   960,   961,   962,   962,
     962,   962,   790,   969,   969,   969,   970,   971,   971,   972,
     972,   973,   974,   975,   975,   975,   975,   975,   975,   975,
     975,   975,   975,   975,   975,   975,   975,   975,   976,   977,
     978,   978,   979,   979,   979,   979,   979,   979,   979,   979,
     979,   980,   979,   981,   979,   979,   979,   979,   982,   982,
     983,   984,   984,   985,   985,   985,   986,   986,   987,   987,
     988,   988,   988,   988,   988,   988,   988,   988,   988,   988,
     988,   989,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   991,   991,   992,   993,   994,   994,   994,   995,   995,
     996,   996,   997,   998,   999,   999,  1001,  1000,  1002,  1002,
    1003,  1003,  1004,   611,  1005,   611,  1006,   611,  1007,   611,
    1008,   611,  1009,   611,  1010,   611,  1011,   611,  1012,  1013,
    1013,  1013,  1013,  1013,  1013,  1013,  1013,  1013,   790,  1015,
    1014,  1016,  1016,  1016,  1016,  1016,  1016,   790,  1017,  1018,
    1018,  1018,  1018,  1019,  1018,  1020,  1018,  1018,  1018,  1018,
    1021,  1021,  1022,  1023,  1024,  1024,  1024,  1024,  1024,  1024,
    1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    1024,  1025,  1024,  1026,  1024,  1024,  1024,  1024,  1024,  1027,
    1027,  1027,  1028,  1029,  1029,  1030,  1030,  1031,  1032,  1033,
    1033,  1033,  1033,  1033,  1033,  1034,  1035,  1035,  1036,  1036,
    1037,  1038,  1039,  1040,  1040,  1040,  1041,  1042,  1042,  1043,
    1043,  1044,  1045,  1046,  1046,  1046,  1047,  1048,  1048,  1049,
    1049,  1050,  1050,  1051,  1051,   790,  1052,  1052,  1053,  1054,
    1054,  1054,  1054,  1054,  1054,  1055,  1055,  1056,  1057,  1058,
    1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,
    1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,
    1059,  1059,  1059,  1059,  1059,  1059,  1059,  1060,  1060,  1060,
    1060,  1061,  1061,  1062,  1062,  1063,   611,  1064,   611,  1065,
     790,  1066,  1067,  1068,  1068,  1069,  1069,  1069,  1069,  1069,
    1069,  1069,  1069,  1069,  1069,  1069,  1069,  1069,  1070,  1070,
    1071,  1072,  1073,  1073,  1074,  1075,  1075,  1076,  1076,  1077,
    1077,  1077,  1078,  1079,  1080,  1080,  1081,  1081,  1081,  1082,
     790,  1083,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1086,
    1085,  1085,  1085,  1085,  1085,  1085,  1087,  1087,  1088,  1088,
    1090,  1089,  1091,  1091,  1091,  1091,  1091,  1091,  1091,  1091,
    1091,  1092,  1091,  1091,  1093,  1094,  1094,  1095,  1096,  1096,
    1097,  1098,  1097,   611,  1099,   790,   963,   964,   964,   964,
     964,   964,   964,   964,   964,   965,   965,   966,   611,   967,
     968,   968,   968,   968,   968,   968,   790,   953,   954,   954,
     954,   955,   955,   955,   955,   955,   955,   955,   955,   955,
    1100,  1101,  1101,  1101,  1102,  1102,  1102,  1102,  1102,  1102,
    1102,  1102,  1102,  1102,  1102,  1102,  1102,  1102,  1102,  1102,
    1102,   751,   617,  1103,  1104,  1105,  1105,  1106,  1106,  1107,
    1107,  1107,  1107,  1107,  1108,  1109,  1109,  1110,  1110,  1111,
    1111,  1112,  1112,  1112,  1112,  1112,  1112,  1112,  1112,  1112,
     617,  1113,  1113,   617,  1114,  1115,  1115,  1116,  1117,  1117,
    1117,   617,   617,  1118,  1119,  1120,  1120,  1120,  1120,  1120,
    1120,  1121,  1121,  1122,  1122,  1123,   617,  1124,  1124,  1124,
    1124,  1125,  1125,  1125,  1126,  1126,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,   611,  1128,   611,  1129,   611,  1130,   611,
    1131,   611,  1132,   611,  1133,   611,  1134,   611,  1135,   611,
    1136,   611,  1137,  1138,  1138,  1139,  1139,  1139,   790,  1140,
    1100,  1100,  1141,  1141,  1142,  1142,  1143,  1143,  1144,  1144,
    1144,  1144,  1144,  1144,  1144,   790,  1145,  1146,  1146,  1147,
    1147,  1147,  1148,  1149,  1150,  1150,  1151,  1151,  1152
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     0,     2,     1,     1,     5,     1,
       3,     1,     1,     1,     1,     1,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     0,     2,     2,     2,     2,     2,     6,     2,     2,
       5,     5,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     2,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     2,     1,     1,     1,     2,     4,
       1,     3,     1,     3,     1,     3,     4,     6,     6,     0,
       1,     1,     1,     1,     1,     2,     4,     4,     2,     2,
       2,     2,     2,     4,     2,     2,     2,     0,     3,     0,
       3,     0,     0,     0,     6,     6,     1,     1,     1,     2,
       1,     2,     1,     2,     5,     1,     0,     4,     1,     2,
       1,     4,     1,     6,     1,     8,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     0,     3,     0,     4,     2,     5,
       0,     4,     0,     2,     1,     1,     0,     2,     0,     3,
       4,     1,     0,     0,     7,     0,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     3,     1,
       1,     1,     1,     5,     7,     5,     7,     9,     7,     5,
       7,     5,    11,     1,     1,     2,     1,     7,     9,     7,
       7,     9,     7,     9,     7,     9,     7,    15,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     1,     3,
       1,     3,     1,     3,     1,     2,     2,     6,     1,     3,
       0,     4,     3,     1,     3,     3,     2,     4,     3,     4,
       2,     2,     2,     2,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     3,     1,     5,     7,     7,
       1,     0,     1,     3,     1,     4,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     4,     1,     0,     5,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       4,     1,     1,     1,     1,     3,     3,     5,     7,     6,
       6,     6,     6,     6,     3,     4,     8,     8,     4,     1,
       1,     4,     1,     1,     1,     5,     3,     2,     1,     0,
       0,     5,     4,     6,     0,     0,     0,     9,     4,     3,
       5,     3,     3,     3,     2,     5,     0,     5,     7,     9,
       0,     1,     1,     1,     4,     5,     1,     3,     1,     5,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     0,     1,     2,     2,     2,
       3,     3,     4,     4,     6,     4,     3,     0,     3,     0,
       3,     1,     1,     1,     0,     1,     2,     3,     0,     2,
       3,     2,     2,     3,     2,     2,     2,     2,     3,     1,
       2,     2,     4,     2,     3,     3,     3,     2,     4,     3,
       1,     2,     0,     3,     0,     3,     0,     3,     1,     2,
       1,     1,     1,     0,     2,     2,     2,     2,     2,     1,
       1,     3,     3,     3,     3,     4,     1,     4,     1,     1,
       1,     1,     1,     3,     2,     3,     3,     2,     3,     3,
       0,     1,     1,     1,     1,     1,     2,     0,     1,     3,
       1,     3,     1,     0,     2,     2,     2,     2,     2,     3,
       3,     3,     3,     5,     0,     3,     1,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     3,     1,     1,     1,     4,     1,     0,     3,     5,
       2,     1,     1,     2,     0,     5,     5,     5,     5,     4,
       4,     4,     4,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     1,     1,     1,     1,     0,     3,     1,
       3,     1,     3,     1,     4,     1,     5,     1,     0,     1,
       3,     1,     4,     1,     4,     0,     2,     3,     3,     3,
       3,     4,     4,     3,     2,     2,     2,     2,     3,     3,
       3,     2,     2,     1,     1,     1,     1,     2,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     4,     0,     2,     2,     2,     2,     2,     2,
       1,     4,     1,     4,     1,     5,     1,     4,     1,     4,
       1,     4,     1,     4,     1,     4,     1,     4,     1,     4,
       1,     5,     1,     3,     2,     0,     1,     4,     1,     4,
       1,     4,     1,     5,     1,     6,     1,     6,     1,     3,
       2,     2,     1,     4,     1,     2,     1,     3,     1,     1,
       1,     1,     0,     1,     1,     3,     3,     1,     0,     3,
       0,     3,     0,     3,     3,     3,     3,     2,     2,     0,
       3,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       1,     2,     3,     3,     3,     3,     0,     3,     0,     3,
       0,     2,     0,     2,     2,     2,     1,     5,     1,     2,
       1,     1,     3,     0,     4,     0,     4,     0,     3,     5,
       1,     3,     3,     1,     1,     2,     1,     4,     2,     2,
       2,     2,     3,     5,     0,     3,     5,     1,     1,     1,
       1,     0,     2,     0,     0,     1,     1,     2,     2,     3,
       3,     0,     3,     4,     3,     0,     2,     2,     0,     2,
       0,     2,     4,     2,     4,     4,     4,     2,     2,     1,
       2,     1,     0,     3,     0,     0,     5,     1,     5,     0,
       2,     3,     3,     3,     2,     2,     2,     2,     2,     1,
       2,     1,     1,     2,     4,     0,     3,     5,     0,     0,
       0,     2,     2,     2,     2,     2,     2,     3,     3,     3,
       3,     2,     3,     3,     4,     4,     4,     4,     4,     2,
       2,     3,     3,     3,     3,     3,     3,     1,     0,     3,
       0,     3,     4,     1,     6,     1,     6,     1,     6,     1,
       6,     2,     2,     0,     3,     3,     0,     3,     3,     2,
       2,     2,     1,     3,     1,     3,     1,     3,     2,     2,
       2,     2,     2,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     4,     6,     4,
       6,     6,     4,     6,     4,     6,     5,     5,     4,     5,
       5,     6,     6,     3,     3,     4,     5,     6,     5,     5,
       5,     5,     5,     5,     5,     5,     5,     5,     6,     6,
       6,     5,     6,     6,     6,     8,     6,     6,     6,     7,
       5,     6,     5,     6,     7,     5,     6,     5,     6,     8,
       4,     4,     5,     4,     4,     4,     5,     5,     6,     5,
       5,     6,     5,     5,     6,     7,     7,     7,     7,     7,
       8,     8,     5,     5,     4,     4,     0,     0,     6,     6,
       5,     5,     5,     6,     1,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     1,     1,     1,     3,     4,     4,
       3,     3,     2,     2,     1,     2,     0,     2,     0,     5,
       0,     3,     0,     4,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     4,     4,     4,
       4,     6,     2,     3,     2,     2,     2,     2,     3,     5,
       5,     6,     6,     4,     5,     3,     3,     3,     4,     3,
       3,     4,     2,     2,     2,     3,     3,     0,     3,     0,
       3,     0,     3,     6,     1,     4,     1,     5,     1,     5,
       4,     4,     1,     1,     3,     2,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     0,     3,     5,     1,     3,
       2,     1,     2,     1,     2,     2,     2,     3,     3,     0,
       1,     2,     3,     1,     1,     2,     2,     3,     3,     3,
       3,     4,     2,     4,     3,     2,     3,     1,     2,     4,
       0,     3,     2,     1,     2,     3,     3,     3,     3,     2,
       3,     0,     5,     0,     5,     2,     2,     1,     4,     1,
       1,     0,     3,     2,     2,     2,     5,     2,     0,     3,
       0,     2,     2,     3,     2,     2,     3,     2,     2,     2,
       1,     3,     2,     2,     2,     2,     2,     2,     3,     2,
       2,     2,     2,     2,     2,     2,     2,     3,     3,     3,
       3,     2,     3,     2,     3,     3,     4,     4,     2,     2,
       2,     3,     3,     3,     2,     3,     3,     3,     4,     2,
       1,     0,     2,     3,     1,     0,     1,     2,     0,     2,
       0,     1,     3,     0,     0,     2,     0,     3,     0,     3,
       0,     3,     3,     1,     4,     1,     6,     1,     6,     1,
       6,     1,     7,     1,     6,     1,     7,     1,     5,     0,
       2,     3,     2,     3,     3,     2,     3,     2,     2,     0,
       4,     2,     3,     3,     6,     5,     5,     1,     2,     1,
       1,     2,     2,     0,     3,     0,     3,     6,     2,     3,
       0,     3,     5,     0,     4,     4,     3,     4,     2,     3,
       3,     3,     3,     4,     4,     4,     3,     3,     4,     4,
       2,     0,     3,     0,     3,     6,     3,     3,     4,     1,
       1,     1,     0,     0,     3,     0,     3,     4,     1,     2,
       2,     2,     3,     4,     4,     0,     0,     3,     0,     3,
       3,     1,     0,     0,     2,     2,     0,     0,     3,     1,
       5,     1,     0,     0,     2,     2,     0,     0,     3,     1,
       5,     1,     2,     0,     2,     1,     1,     2,     2,     1,
       1,     2,     4,     2,     2,     0,     3,     5,     0,     0,
       2,     2,     2,     2,     2,     2,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       3,     3,     4,     3,     2,     2,     1,     1,     1,     1,
       1,     0,     3,     0,     3,     4,     1,     6,     1,     6,
       1,     2,     5,     0,     3,     1,     1,     2,     3,     1,
       3,     2,     3,     3,     3,     4,     3,     3,     0,     1,
       2,     1,     4,     6,     0,     0,     3,     0,     3,     2,
       2,     2,     0,     0,     0,     3,     4,     4,     2,     0,
       2,     2,     3,     3,     3,     3,     5,     5,     4,     0,
       4,     3,     3,     3,     3,     3,     1,     2,     0,     2,
       0,     4,     2,     3,     5,     1,     2,     2,     2,     2,
       2,     0,     4,     2,     1,     1,     3,     1,     0,     2,
       0,     0,     4,     1,     4,     1,     2,     1,     2,     2,
       2,     1,     2,     2,     4,     0,     3,     5,     1,     4,
       0,     3,     3,     3,     2,     3,     2,     2,     0,     3,
       3,     3,     3,     5,     5,     5,     5,     7,     7,     6,
       3,     3,     2,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     5,     2,     0,     0,     2,     2,
       3,     2,     1,     3,     1,     0,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     3,     1,     3,     5,     2,     0,     0,     3,
       4,     2,     1,     3,     3,     3,     3,     3,     2,     3,
       2,     0,     3,     0,     3,     0,     1,     3,     4,     3,
       3,     1,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     1,     5,     1,     3,     1,
       3,     1,     3,     1,     4,     1,     2,     1,     3,     1,
       3,     1,     4,     0,     1,     0,     1,     2,     2,     2,
       3,     3,     1,     1,     0,     2,     1,     1,     1,     1,
       2,     3,     2,     3,     4,     2,     2,     3,     3,     1,
       2,     3,     0,     2,     0,     3,     0,     3,     3
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        YY_LAC_DISCARD ("YYBACKUP");                              \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Given a state stack such that *YYBOTTOM is its bottom, such that
   *YYTOP is either its top or is YYTOP_EMPTY to indicate an empty
   stack, and such that *YYCAPACITY is the maximum number of elements it
   can hold without a reallocation, make sure there is enough room to
   store YYADD more elements.  If not, allocate a new stack using
   YYSTACK_ALLOC, copy the existing elements, and adjust *YYBOTTOM,
   *YYTOP, and *YYCAPACITY to reflect the new capacity and memory
   location.  If *YYBOTTOM != YYBOTTOM_NO_FREE, then free the old stack
   using YYSTACK_FREE.  Return 0 if successful or if no reallocation is
   required.  Return YYENOMEM if memory is exhausted.  */
static int
yy_lac_stack_realloc (YYPTRDIFF_T *yycapacity, YYPTRDIFF_T yyadd,
#if YYDEBUG
                      char const *yydebug_prefix,
                      char const *yydebug_suffix,
#endif
                      yy_state_t **yybottom,
                      yy_state_t *yybottom_no_free,
                      yy_state_t **yytop, yy_state_t *yytop_empty)
{
  YYPTRDIFF_T yysize_old =
    *yytop == yytop_empty ? 0 : *yytop - *yybottom + 1;
  YYPTRDIFF_T yysize_new = yysize_old + yyadd;
  if (*yycapacity < yysize_new)
    {
      YYPTRDIFF_T yyalloc = 2 * yysize_new;
      yy_state_t *yybottom_new;
      /* Use YYMAXDEPTH for maximum stack size given that the stack
         should never need to grow larger than the main state stack
         needs to grow without LAC.  */
      if (YYMAXDEPTH < yysize_new)
        {
          YYDPRINTF ((stderr, "%smax size exceeded%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (YYMAXDEPTH < yyalloc)
        yyalloc = YYMAXDEPTH;
      yybottom_new =
        YY_CAST (yy_state_t *,
                 YYSTACK_ALLOC (YY_CAST (YYSIZE_T,
                                         yyalloc * YYSIZEOF (*yybottom_new))));
      if (!yybottom_new)
        {
          YYDPRINTF ((stderr, "%srealloc failed%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (*yytop != yytop_empty)
        {
          YYCOPY (yybottom_new, *yybottom, yysize_old);
          *yytop = yybottom_new + (yysize_old - 1);
        }
      if (*yybottom != yybottom_no_free)
        YYSTACK_FREE (*yybottom);
      *yybottom = yybottom_new;
      *yycapacity = yyalloc;
    }
  return 0;
}

/* Establish the initial context for the current lookahead if no initial
   context is currently established.

   We define a context as a snapshot of the parser stacks.  We define
   the initial context for a lookahead as the context in which the
   parser initially examines that lookahead in order to select a
   syntactic action.  Thus, if the lookahead eventually proves
   syntactically unacceptable (possibly in a later context reached via a
   series of reductions), the initial context can be used to determine
   the exact set of tokens that would be syntactically acceptable in the
   lookahead's place.  Moreover, it is the context after which any
   further semantic actions would be erroneous because they would be
   determined by a syntactically unacceptable token.

   YY_LAC_ESTABLISH should be invoked when a reduction is about to be
   performed in an inconsistent state (which, for the purposes of LAC,
   includes consistent states that don't know they're consistent because
   their default reductions have been disabled).  Iff there is a
   lookahead token, it should also be invoked before reporting a syntax
   error.  This latter case is for the sake of the debugging output.

   For parse.lac=full, the implementation of YY_LAC_ESTABLISH is as
   follows.  If no initial context is currently established for the
   current lookahead, then check if that lookahead can eventually be
   shifted if syntactic actions continue from the current context.
   Report a syntax error if it cannot.  */
#define YY_LAC_ESTABLISH                                                \
do {                                                                    \
  if (!yy_lac_established)                                              \
    {                                                                   \
      YYDPRINTF ((stderr,                                               \
                  "LAC: initial context established for %s\n",          \
                  yysymbol_name (yytoken)));                            \
      yy_lac_established = 1;                                           \
      switch (yy_lac (yyesa, &yyes, &yyes_capacity, yyssp, yytoken))    \
        {                                                               \
        case YYENOMEM:                                                  \
          YYNOMEM;                                                      \
        case 1:                                                         \
          goto yyerrlab;                                                \
        }                                                               \
    }                                                                   \
} while (0)

/* Discard any previous initial lookahead context because of Event,
   which may be a lookahead change or an invalidation of the currently
   established initial context for the current lookahead.

   The most common example of a lookahead change is a shift.  An example
   of both cases is syntax error recovery.  That is, a syntax error
   occurs when the lookahead is syntactically erroneous for the
   currently established initial context, so error recovery manipulates
   the parser stacks to try to find a new initial context in which the
   current lookahead is syntactically acceptable.  If it fails to find
   such a context, it discards the lookahead.  */
#if YYDEBUG
# define YY_LAC_DISCARD(Event)                                           \
do {                                                                     \
  if (yy_lac_established)                                                \
    {                                                                    \
      YYDPRINTF ((stderr, "LAC: initial context discarded due to "       \
                  Event "\n"));                                          \
      yy_lac_established = 0;                                            \
    }                                                                    \
} while (0)
#else
# define YY_LAC_DISCARD(Event) yy_lac_established = 0
#endif

/* Given the stack whose top is *YYSSP, return 0 iff YYTOKEN can
   eventually (after perhaps some reductions) be shifted, return 1 if
   not, or return YYENOMEM if memory is exhausted.  As preconditions and
   postconditions: *YYES_CAPACITY is the allocated size of the array to
   which *YYES points, and either *YYES = YYESA or *YYES points to an
   array allocated with YYSTACK_ALLOC.  yy_lac may overwrite the
   contents of either array, alter *YYES and *YYES_CAPACITY, and free
   any old *YYES other than YYESA.  */
static int
yy_lac (yy_state_t *yyesa, yy_state_t **yyes,
        YYPTRDIFF_T *yyes_capacity, yy_state_t *yyssp, yysymbol_kind_t yytoken)
{
  yy_state_t *yyes_prev = yyssp;
  yy_state_t *yyesp = yyes_prev;
  /* Reduce until we encounter a shift and thereby accept the token.  */
  YYDPRINTF ((stderr, "LAC: checking lookahead %s:", yysymbol_name (yytoken)));
  if (yytoken == YYSYMBOL_YYUNDEF)
    {
      YYDPRINTF ((stderr, " Always Err\n"));
      return 1;
    }
  while (1)
    {
      int yyrule = yypact[+*yyesp];
      if (yypact_value_is_default (yyrule)
          || (yyrule += yytoken) < 0 || YYLAST < yyrule
          || yycheck[yyrule] != yytoken)
        {
          /* Use the default action.  */
          yyrule = yydefact[+*yyesp];
          if (yyrule == 0)
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
        }
      else
        {
          /* Use the action from yytable.  */
          yyrule = yytable[yyrule];
          if (yytable_value_is_error (yyrule))
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
          if (0 < yyrule)
            {
              YYDPRINTF ((stderr, " S%d\n", yyrule));
              return 0;
            }
          yyrule = -yyrule;
        }
      /* By now we know we have to simulate a reduce.  */
      YYDPRINTF ((stderr, " R%d", yyrule - 1));
      {
        /* Pop the corresponding number of values from the stack.  */
        YYPTRDIFF_T yylen = yyr2[yyrule];
        /* First pop from the LAC stack as many tokens as possible.  */
        if (yyesp != yyes_prev)
          {
            YYPTRDIFF_T yysize = yyesp - *yyes + 1;
            if (yylen < yysize)
              {
                yyesp -= yylen;
                yylen = 0;
              }
            else
              {
                yyesp = yyes_prev;
                yylen -= yysize;
              }
          }
        /* Only afterwards look at the main stack.  */
        if (yylen)
          yyesp = yyes_prev -= yylen;
      }
      /* Push the resulting state of the reduction.  */
      {
        yy_state_fast_t yystate;
        {
          const int yylhs = yyr1[yyrule] - YYNTOKENS;
          const int yyi = yypgoto[yylhs] + *yyesp;
          yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyesp
                     ? yytable[yyi]
                     : yydefgoto[yylhs]);
        }
        if (yyesp == yyes_prev)
          {
            yyesp = *yyes;
            YY_IGNORE_USELESS_CAST_BEGIN
            *yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        else
          {
            if (yy_lac_stack_realloc (yyes_capacity, 1,
#if YYDEBUG
                                      " (", ")",
#endif
                                      yyes, yyesa, &yyesp, yyes_prev))
              {
                YYDPRINTF ((stderr, "\n"));
                return YYENOMEM;
              }
            YY_IGNORE_USELESS_CAST_BEGIN
            *++yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        YYDPRINTF ((stderr, " G%d", yystate));
      }
    }
}

/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yy_state_t *yyesa;
  yy_state_t **yyes;
  YYPTRDIFF_T *yyes_capacity;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;

  int yyx;
  for (yyx = 0; yyx < YYNTOKENS; ++yyx)
    {
      yysymbol_kind_t yysym = YY_CAST (yysymbol_kind_t, yyx);
      if (yysym != YYSYMBOL_YYerror && yysym != YYSYMBOL_YYUNDEF)
        switch (yy_lac (yyctx->yyesa, yyctx->yyes, yyctx->yyes_capacity, yyctx->yyssp, yysym))
          {
          case YYENOMEM:
            return YYENOMEM;
          case 1:
            continue;
          default:
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
       In the first two cases, it might appear that the current syntax
       error should have been detected in the previous state when yy_lac
       was invoked.  However, at that time, there might have been a
       different syntax error that discarded a different initial context
       during error recovery, leaving behind the current lookahead.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      YYDPRINTF ((stderr, "Constructing syntax error message\n"));
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else if (yyn == 0)
        YYDPRINTF ((stderr, "No expected tokens.\n"));
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.  In order to see if a particular token T is a
   valid looakhead, invoke yy_lac (YYESA, YYES, YYES_CAPACITY, YYSSP, T).

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store or if
   yy_lac returned YYENOMEM.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    yy_state_t yyesa[20];
    yy_state_t *yyes = yyesa;
    YYPTRDIFF_T yyes_capacity = 20 < YYMAXDEPTH ? 20 : YYMAXDEPTH;

  /* Whether LAC context is established.  A Boolean.  */
  int yy_lac_established = 0;
  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    {
      YY_LAC_ESTABLISH;
      goto yydefault;
    }
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      YY_LAC_ESTABLISH;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  YY_LAC_DISCARD ("shift");
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  {
    int yychar_backup = yychar;
    switch (yyn)
      {
  case 2: /* enum_type: NET_TYPE  */
#line 57 "conf/gen_parser.m4"
                    { (yyval.i) = T_ENUM_NET_TYPE; }
#line 7009 "obj/conf/cf-parse.tab.c"
    break;

  case 3: /* enum_type: RTS  */
#line 57 "conf/gen_parser.m4"
                                                    { (yyval.i) = T_ENUM_RTS; }
#line 7015 "obj/conf/cf-parse.tab.c"
    break;

  case 4: /* enum_type: SCOPE  */
#line 57 "conf/gen_parser.m4"
                                                                                 { (yyval.i) = T_ENUM_SCOPE; }
#line 7021 "obj/conf/cf-parse.tab.c"
    break;

  case 5: /* enum_type: RTD  */
#line 57 "conf/gen_parser.m4"
                                                                                                              { (yyval.i) = T_ENUM_RTD; }
#line 7027 "obj/conf/cf-parse.tab.c"
    break;

  case 6: /* enum_type: ROA  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                         { (yyval.i) = T_ENUM_ROA; }
#line 7033 "obj/conf/cf-parse.tab.c"
    break;

  case 7: /* enum_type: ASPA  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                     { (yyval.i) = T_ENUM_ASPA; }
#line 7039 "obj/conf/cf-parse.tab.c"
    break;

  case 8: /* enum_type: AF  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                { (yyval.i) = T_ENUM_AF; }
#line 7045 "obj/conf/cf-parse.tab.c"
    break;

  case 9: /* enum_type: MPLS_POLICY  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                                                  { (yyval.i) = T_ENUM_MPLS_POLICY; }
#line 7051 "obj/conf/cf-parse.tab.c"
    break;

  case 10: /* enum_type: BGP_ORIGIN  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                                                                                            { (yyval.i) = T_ENUM_BGP_ORIGIN; }
#line 7057 "obj/conf/cf-parse.tab.c"
    break;

  case 11: /* enum_type: RA_PREFERENCE  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                                                                                                                                        { (yyval.i) = T_ENUM_RA_PREFERENCE; }
#line 7063 "obj/conf/cf-parse.tab.c"
    break;

  case 12: /* config: conf_entries END  */
#line 204 "conf/confbase.Y"
                         { return 0; }
#line 7069 "obj/conf/cf-parse.tab.c"
    break;

  case 13: /* config: CLI_MARKER cli_cmd  */
#line 205 "conf/confbase.Y"
                      { return 0; }
#line 7075 "obj/conf/cf-parse.tab.c"
    break;

  case 18: /* definition: DEFINE symbol '=' term ';'  */
#line 221 "conf/confbase.Y"
                              {
     struct f_val *val = cf_eval((yyvsp[-1].x), T_VOID);
     cf_define_symbol(new_config, (yyvsp[-3].s), SYM_CONSTANT | val->type, val, val);
   }
#line 7084 "obj/conf/cf-parse.tab.c"
    break;

  case 19: /* conf_expr: symbol_known  */
#line 228 "conf/confbase.Y"
                {
     /* If the symbol is not a constant, we pass empty f_val and fail later on type check */
     (yyval.v) = (((yyvsp[0].s)->class & ~0xff) == SYM_CONSTANT) ? *(yyvsp[0].s)->val : (struct f_val) {};
   }
#line 7093 "obj/conf/cf-parse.tab.c"
    break;

  case 20: /* conf_expr: '(' term ')'  */
#line 232 "conf/confbase.Y"
                { (yyval.v) = *cf_eval((yyvsp[-1].x), T_VOID); }
#line 7099 "obj/conf/cf-parse.tab.c"
    break;

  case 25: /* expr: conf_expr  */
#line 243 "conf/confbase.Y"
             { cf_assert_type((yyvsp[0].v), T_INT); (yyval.i) = (yyvsp[0].v).val.i; }
#line 7105 "obj/conf/cf-parse.tab.c"
    break;

  case 26: /* expr_us: expr S  */
#line 247 "conf/confbase.Y"
           { (yyval.time) = (yyvsp[-1].i) S_; }
#line 7111 "obj/conf/cf-parse.tab.c"
    break;

  case 27: /* expr_us: expr MS  */
#line 248 "conf/confbase.Y"
           { (yyval.time) = (yyvsp[-1].i) MS_; }
#line 7117 "obj/conf/cf-parse.tab.c"
    break;

  case 28: /* expr_us: expr US  */
#line 249 "conf/confbase.Y"
           { (yyval.time) = (yyvsp[-1].i) US_; }
#line 7123 "obj/conf/cf-parse.tab.c"
    break;

  case 29: /* bool: ON  */
#line 256 "conf/confbase.Y"
      { (yyval.i) = 1; }
#line 7129 "obj/conf/cf-parse.tab.c"
    break;

  case 30: /* bool: YES  */
#line 257 "conf/confbase.Y"
       { (yyval.i) = 1; }
#line 7135 "obj/conf/cf-parse.tab.c"
    break;

  case 31: /* bool: TRUE  */
#line 258 "conf/confbase.Y"
        { (yyval.i) = 1; }
#line 7141 "obj/conf/cf-parse.tab.c"
    break;

  case 32: /* bool: OFF  */
#line 259 "conf/confbase.Y"
       { (yyval.i) = 0; }
#line 7147 "obj/conf/cf-parse.tab.c"
    break;

  case 33: /* bool: NO  */
#line 260 "conf/confbase.Y"
      { (yyval.i) = 0; }
#line 7153 "obj/conf/cf-parse.tab.c"
    break;

  case 34: /* bool: FALSE  */
#line 261 "conf/confbase.Y"
         { (yyval.i) = 0; }
#line 7159 "obj/conf/cf-parse.tab.c"
    break;

  case 35: /* bool: %empty  */
#line 262 "conf/confbase.Y"
                                 { (yyval.i) = 1; }
#line 7165 "obj/conf/cf-parse.tab.c"
    break;

  case 36: /* bool: NUM  */
#line 263 "conf/confbase.Y"
       { (yyval.i) = !!(yyvsp[0].i); cf_warn("Number argument for switch option deprecated"); }
#line 7171 "obj/conf/cf-parse.tab.c"
    break;

  case 37: /* bool: conf_expr  */
#line 264 "conf/confbase.Y"
             {
     if (((yyvsp[0].v).type != T_BOOL) && ((yyvsp[0].v).type != T_INT))
       cf_error("Switch value expected");

     if ((yyvsp[0].v).type == T_INT)
       cf_warn("Number argument for switch option deprecated");

     (yyval.i) = !!(yyvsp[0].v).val.i;
   }
#line 7185 "obj/conf/cf-parse.tab.c"
    break;

  case 38: /* ipa: IP4  */
#line 279 "conf/confbase.Y"
       { (yyval.a) = ipa_from_ip4((yyvsp[0].ip4)); }
#line 7191 "obj/conf/cf-parse.tab.c"
    break;

  case 39: /* ipa: IP6  */
#line 280 "conf/confbase.Y"
       { (yyval.a) = ipa_from_ip6((yyvsp[0].ip6)); }
#line 7197 "obj/conf/cf-parse.tab.c"
    break;

  case 40: /* ipa: conf_expr  */
#line 281 "conf/confbase.Y"
             { cf_assert_type((yyvsp[0].v), T_IP); (yyval.a) = (yyvsp[0].v).val.ip; }
#line 7203 "obj/conf/cf-parse.tab.c"
    break;

  case 41: /* ipa_scope: %empty  */
#line 285 "conf/confbase.Y"
               { (yyval.iface) = NULL; }
#line 7209 "obj/conf/cf-parse.tab.c"
    break;

  case 42: /* ipa_scope: '%' symbol  */
#line 286 "conf/confbase.Y"
              { (yyval.iface) = if_get_by_name((yyvsp[0].s)->name); }
#line 7215 "obj/conf/cf-parse.tab.c"
    break;

  case 43: /* pxlen4: '/' NUM  */
#line 293 "conf/confbase.Y"
           {
     if ((yyvsp[0].i) > IP4_MAX_PREFIX_LENGTH) cf_error("Invalid prefix length %u", (yyvsp[0].i));
     (yyval.i) = (yyvsp[0].i);
   }
#line 7224 "obj/conf/cf-parse.tab.c"
    break;

  case 44: /* net_ip4_: IP4 pxlen4  */
#line 300 "conf/confbase.Y"
{
  net_fill_ip4(&((yyval.net)), (yyvsp[-1].ip4), (yyvsp[0].i));

  net_addr_ip4 *n = (void *) &((yyval.net));
  if (!net_validate_ip4(n))
    cf_error("Invalid IPv4 prefix %I4/%d, maybe you wanted %I4/%d",
	     n->prefix, n->pxlen, ip4_and(n->prefix, ip4_mkmask(n->pxlen)), n->pxlen);
}
#line 7237 "obj/conf/cf-parse.tab.c"
    break;

  case 45: /* net_ip6_slash: IP6 '/'  */
#line 310 "conf/confbase.Y"
{
  this_sadr_from_hack_active = cf_maybe_exit_filters();
  (yyval.a) = (yyvsp[-1].ip6);
}
#line 7246 "obj/conf/cf-parse.tab.c"
    break;

  case 46: /* net_ip6_: net_ip6_slash NUM  */
#line 316 "conf/confbase.Y"
{
  if (this_sadr_from_hack_active)
  {
    cf_enter_filters();
    this_sadr_from_hack_active = 0;
  }

  if ((yyvsp[0].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid prefix length %u", (yyvsp[0].i));

  net_fill_ip6(&((yyval.net)), (yyvsp[-1].a), (yyvsp[0].i));

  net_addr_ip6 *n = (void *) &((yyval.net));
  if (!net_validate_ip6(n))
    cf_error("Invalid IPv6 prefix %I6/%d, maybe you wanted %I6/%d",
	     n->prefix, n->pxlen, ip6_and(n->prefix, ip6_mkmask(n->pxlen)), n->pxlen);
}
#line 7268 "obj/conf/cf-parse.tab.c"
    break;

  case 47: /* net_ip6_sadr_: net_ip6_slash NUM FROM IP6 '/' NUM  */
#line 335 "conf/confbase.Y"
{
  if (this_sadr_from_hack_active)
  {
    cf_enter_filters();
    this_sadr_from_hack_active = 0;
  }

  if (((yyvsp[-3].s)->class != SYM_KEYWORD) || ((yyvsp[-3].s)->keyword->value != FROM))
    cf_error("Expected FROM after %I6/%d", (yyvsp[-5].a), (yyvsp[-4].i));

  if ((yyvsp[-4].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid prefix length %u", (yyvsp[-4].i));

  if ((yyvsp[0].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid prefix length %u", (yyvsp[0].i));

  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_ip6_sadr));
  net_fill_ip6_sadr((yyval.net_ptr), (yyvsp[-5].a), (yyvsp[-4].i), (yyvsp[-2].ip6), (yyvsp[0].i));

  net_addr_ip6_sadr *n = (void *) (yyval.net_ptr);
  if (!net_validate_ip6_sadr(n))
    cf_error("Invalid SADR IPv6 prefix %I6/%d from %I6/%d, maybe you wanted %I6/%d from %I6/%d",
	     n->dst_prefix, n->dst_pxlen, n->src_prefix, n->src_pxlen,
	     ip6_and(n->dst_prefix, ip6_mkmask(n->dst_pxlen)), n->dst_pxlen,
	     ip6_and(n->src_prefix, ip6_mkmask(n->src_pxlen)), n->src_pxlen);
}
#line 7299 "obj/conf/cf-parse.tab.c"
    break;

  case 48: /* net_vpn4_: VPN_RD net_ip4_  */
#line 363 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn4));
  net_fill_vpn4((yyval.net_ptr), net4_prefix(&(yyvsp[0].net)), net4_pxlen(&(yyvsp[0].net)), (yyvsp[-1].rd));
}
#line 7308 "obj/conf/cf-parse.tab.c"
    break;

  case 49: /* net_vpn6_: VPN_RD net_ip6_  */
#line 369 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn6));
  net_fill_vpn6((yyval.net_ptr), net6_prefix(&(yyvsp[0].net)), net6_pxlen(&(yyvsp[0].net)), (yyvsp[-1].rd));
}
#line 7317 "obj/conf/cf-parse.tab.c"
    break;

  case 50: /* net_roa4_: net_ip4_ MAX expr AS expr  */
#line 375 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_roa4));
  net_fill_roa4((yyval.net_ptr), net4_prefix(&(yyvsp[-4].net)), net4_pxlen(&(yyvsp[-4].net)), (yyvsp[-2].i), (yyvsp[0].i));
  if ((yyvsp[-2].i) < net4_pxlen(&(yyvsp[-4].net)) || (yyvsp[-2].i) > IP4_MAX_PREFIX_LENGTH)
    cf_error("Invalid max prefix length %u", (yyvsp[-2].i));
}
#line 7328 "obj/conf/cf-parse.tab.c"
    break;

  case 51: /* net_roa6_: net_ip6_ MAX expr AS expr  */
#line 383 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_roa6));
  net_fill_roa6((yyval.net_ptr), net6_prefix(&(yyvsp[-4].net)), net6_pxlen(&(yyvsp[-4].net)), (yyvsp[-2].i), (yyvsp[0].i));
  if ((yyvsp[-2].i) < net6_pxlen(&(yyvsp[-4].net)) || (yyvsp[-2].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid max prefix length %u", (yyvsp[-2].i));
}
#line 7339 "obj/conf/cf-parse.tab.c"
    break;

  case 52: /* net_mpls_: MPLS expr  */
#line 391 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_mpls));
  net_fill_mpls((yyval.net_ptr), (yyvsp[0].i));
}
#line 7348 "obj/conf/cf-parse.tab.c"
    break;

  case 53: /* net_aspa_: ASPA expr  */
#line 397 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_aspa));
  net_fill_aspa((yyval.net_ptr), (yyvsp[0].i));
}
#line 7357 "obj/conf/cf-parse.tab.c"
    break;

  case 60: /* net_: net_ip_  */
#line 407 "conf/confbase.Y"
           { (yyval.net_ptr) = cfg_alloc((yyvsp[0].net).length); net_copy((yyval.net_ptr), &((yyvsp[0].net))); }
#line 7363 "obj/conf/cf-parse.tab.c"
    break;

  case 68: /* net_ip4: conf_expr  */
#line 421 "conf/confbase.Y"
             {
     if (((yyvsp[0].v).type != T_NET) || ((yyvsp[0].v).val.net->type != NET_IP4))
       cf_error("IPv4 network expected");
     (yyval.net) = * (yyvsp[0].v).val.net;
   }
#line 7373 "obj/conf/cf-parse.tab.c"
    break;

  case 70: /* net_ip6: conf_expr  */
#line 430 "conf/confbase.Y"
             {
     if (((yyvsp[0].v).type != T_NET) || ((yyvsp[0].v).val.net->type != NET_IP6))
       cf_error("IPv6 network expected");
     (yyval.net) = * (yyvsp[0].v).val.net;
   }
#line 7383 "obj/conf/cf-parse.tab.c"
    break;

  case 72: /* net_ip: conf_expr  */
#line 439 "conf/confbase.Y"
             {
     if (((yyvsp[0].v).type != T_NET) || !net_is_ip((yyvsp[0].v).val.net))
       cf_error("IP network expected");
     (yyval.net) = * (yyvsp[0].v).val.net;
   }
#line 7393 "obj/conf/cf-parse.tab.c"
    break;

  case 74: /* net_any: CF_SYM_KNOWN  */
#line 448 "conf/confbase.Y"
                {
     if ((yyvsp[0].s)->class != (SYM_CONSTANT | T_NET))
       cf_error("Network expected");
     (yyval.net_ptr) = (net_addr *) SYM_VAL((yyvsp[0].s)).net; /* Avoid const warning */
   }
#line 7403 "obj/conf/cf-parse.tab.c"
    break;

  case 75: /* label_stack_start: expr  */
#line 456 "conf/confbase.Y"
{
  (yyval.ad) = cfg_allocz(ADATA_SIZE(MPLS_MAX_LABEL_STACK * sizeof(u32)));
  (yyval.ad)->length = sizeof(u32);
  *((u32 *)(yyval.ad)->data) = (yyvsp[0].i);
}
#line 7413 "obj/conf/cf-parse.tab.c"
    break;

  case 77: /* label_stack: label_stack '/' expr  */
#line 464 "conf/confbase.Y"
                         {
    if ((yyvsp[-2].ad)->length >= MPLS_MAX_LABEL_STACK * sizeof(u32))
      cf_error("Too many labels in stack");

    *((u32 *)((yyval.ad)->data + (yyvsp[-2].ad)->length)) = (yyvsp[0].i);
    (yyvsp[-2].ad)->length += sizeof(u32);
    (yyval.ad) = (yyvsp[-2].ad);
  }
#line 7426 "obj/conf/cf-parse.tab.c"
    break;

  case 78: /* settle: expr_us expr_us  */
#line 478 "conf/confbase.Y"
                        {
  if ((yyvsp[-1].time) > (yyvsp[0].time)) cf_error("Minimum settle time %t is bigger than maximum settle time %t", (yyvsp[-1].time), (yyvsp[0].time));
  (yyval.settle).min = (yyvsp[-1].time);
  (yyval.settle).max = (yyvsp[0].time);
}
#line 7436 "obj/conf/cf-parse.tab.c"
    break;

  case 80: /* text: conf_expr  */
#line 486 "conf/confbase.Y"
             { cf_assert_type((yyvsp[0].v), T_STRING); (yyval.t) = (yyvsp[0].v).val.s; }
#line 7442 "obj/conf/cf-parse.tab.c"
    break;

  case 82: /* opttext: %empty  */
#line 491 "conf/confbase.Y"
               { (yyval.t) = NULL; }
#line 7448 "obj/conf/cf-parse.tab.c"
    break;

  case 83: /* time: text  */
#line 495 "conf/confbase.Y"
        {
     (yyval.time) = tm_parse_time((yyvsp[0].t));
     if (!(yyval.time))
       cf_error("Invalid date/time");
   }
#line 7458 "obj/conf/cf-parse.tab.c"
    break;

  case 85: /* bytestring: bytestring_expr  */
#line 507 "conf/confbase.Y"
                   { cf_assert_type((yyvsp[0].v), T_BYTESTRING); (yyval.bs) = (yyvsp[0].v).val.bs; }
#line 7464 "obj/conf/cf-parse.tab.c"
    break;

  case 87: /* bytestring_expr: term_bs  */
#line 512 "conf/confbase.Y"
           { (yyval.v) = *cf_eval((yyvsp[0].x), T_VOID); }
#line 7470 "obj/conf/cf-parse.tab.c"
    break;

  case 88: /* idval: NUM  */
#line 520 "conf/confbase.Y"
       { (yyval.i32) = (yyvsp[0].i); }
#line 7476 "obj/conf/cf-parse.tab.c"
    break;

  case 89: /* idval: IP4  */
#line 521 "conf/confbase.Y"
       { (yyval.i32) = ip4_to_u32((yyvsp[0].ip4)); }
#line 7482 "obj/conf/cf-parse.tab.c"
    break;

  case 90: /* idval: conf_expr  */
#line 522 "conf/confbase.Y"
             {
     if (((yyvsp[0].v).type == T_INT) || ((yyvsp[0].v).type == T_QUAD))
       (yyval.i32) = (yyvsp[0].v).val.i;
     else if (((yyvsp[0].v).type == T_IP) && ipa_is_ip4((yyvsp[0].v).val.ip))
       (yyval.i32) = ipa_to_u32((yyvsp[0].v).val.ip);
     else
       cf_error("Number or IPv4 address expected");
   }
#line 7495 "obj/conf/cf-parse.tab.c"
    break;

  case 93: /* net_or_ipa: IP4  */
#line 536 "conf/confbase.Y"
       { net_fill_ip4(&((yyval.net)), (yyvsp[0].ip4), IP4_MAX_PREFIX_LENGTH); }
#line 7501 "obj/conf/cf-parse.tab.c"
    break;

  case 94: /* net_or_ipa: IP6  */
#line 537 "conf/confbase.Y"
       { net_fill_ip6(&((yyval.net)), (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH); }
#line 7507 "obj/conf/cf-parse.tab.c"
    break;

  case 95: /* net_or_ipa: conf_expr  */
#line 538 "conf/confbase.Y"
             {
     if ((yyvsp[0].v).type == T_IP)
       net_fill_ip_host(&((yyval.net)), (yyvsp[0].v).val.ip);
     else if (((yyvsp[0].v).type == T_NET) && net_is_ip((yyvsp[0].v).val.net))
       (yyval.net) = * (yyvsp[0].v).val.net;
     else
       cf_error("IP address/prefix expected");
   }
#line 7520 "obj/conf/cf-parse.tab.c"
    break;

  case 96: /* text_or_ipa: TEXT  */
#line 550 "conf/confbase.Y"
        { (yyval.v).type = T_STRING; (yyval.v).val.s = (yyvsp[0].t); }
#line 7526 "obj/conf/cf-parse.tab.c"
    break;

  case 97: /* text_or_ipa: IP4  */
#line 551 "conf/confbase.Y"
       { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip4((yyvsp[0].ip4)); }
#line 7532 "obj/conf/cf-parse.tab.c"
    break;

  case 98: /* text_or_ipa: IP6  */
#line 552 "conf/confbase.Y"
       { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip6((yyvsp[0].ip6)); }
#line 7538 "obj/conf/cf-parse.tab.c"
    break;

  case 99: /* text_or_ipa: conf_expr  */
#line 553 "conf/confbase.Y"
             {
     if (((yyvsp[0].v).type != T_STRING) && ((yyvsp[0].v).type != T_IP))
       cf_error("String or IP address expected");
     (yyval.v) = (yyvsp[0].v);
   }
#line 7548 "obj/conf/cf-parse.tab.c"
    break;

  case 100: /* bytestring_or_text: BYTETEXT  */
#line 562 "conf/confbase.Y"
            { (yyval.v).type = T_BYTESTRING; (yyval.v).val.bs = (yyvsp[0].bs); }
#line 7554 "obj/conf/cf-parse.tab.c"
    break;

  case 101: /* bytestring_or_text: TEXT  */
#line 563 "conf/confbase.Y"
        { (yyval.v).type = T_STRING; (yyval.v).val.s = (yyvsp[0].t); }
#line 7560 "obj/conf/cf-parse.tab.c"
    break;

  case 102: /* bytestring_or_text: bytestring_expr  */
#line 564 "conf/confbase.Y"
                   {
     if (((yyvsp[0].v).type != T_BYTESTRING) && ((yyvsp[0].v).type != T_STRING))
       cf_error("Bytestring or string expected");
     (yyval.v) = (yyvsp[0].v);
   }
#line 7570 "obj/conf/cf-parse.tab.c"
    break;

  case 103: /* flow_num_op: TRUE  */
#line 37 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_TRUE; }
#line 7576 "obj/conf/cf-parse.tab.c"
    break;

  case 104: /* flow_num_op: '='  */
#line 38 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_EQ;  }
#line 7582 "obj/conf/cf-parse.tab.c"
    break;

  case 105: /* flow_num_op: NEQ  */
#line 39 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_NEQ; }
#line 7588 "obj/conf/cf-parse.tab.c"
    break;

  case 106: /* flow_num_op: '<'  */
#line 40 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_LT;  }
#line 7594 "obj/conf/cf-parse.tab.c"
    break;

  case 107: /* flow_num_op: LEQ  */
#line 41 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_LEQ; }
#line 7600 "obj/conf/cf-parse.tab.c"
    break;

  case 108: /* flow_num_op: '>'  */
#line 42 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_GT;  }
#line 7606 "obj/conf/cf-parse.tab.c"
    break;

  case 109: /* flow_num_op: GEQ  */
#line 43 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_GEQ; }
#line 7612 "obj/conf/cf-parse.tab.c"
    break;

  case 110: /* flow_num_op: FALSE  */
#line 44 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_FALSE; }
#line 7618 "obj/conf/cf-parse.tab.c"
    break;

  case 111: /* flow_logic_op: OR  */
#line 48 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_OR; }
#line 7624 "obj/conf/cf-parse.tab.c"
    break;

  case 112: /* flow_logic_op: AND  */
#line 49 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_AND; }
#line 7630 "obj/conf/cf-parse.tab.c"
    break;

  case 113: /* flow_num_type_: PROTO  */
#line 53 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_IP_PROTOCOL; }
#line 7636 "obj/conf/cf-parse.tab.c"
    break;

  case 114: /* flow_num_type_: NEXT HEADER  */
#line 54 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_NEXT_HEADER; }
#line 7642 "obj/conf/cf-parse.tab.c"
    break;

  case 115: /* flow_num_type_: PORT  */
#line 55 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_PORT; }
#line 7648 "obj/conf/cf-parse.tab.c"
    break;

  case 116: /* flow_num_type_: DPORT  */
#line 56 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_DST_PORT; }
#line 7654 "obj/conf/cf-parse.tab.c"
    break;

  case 117: /* flow_num_type_: SPORT  */
#line 57 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_SRC_PORT; }
#line 7660 "obj/conf/cf-parse.tab.c"
    break;

  case 118: /* flow_num_type_: ICMP TYPE  */
#line 58 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_ICMP_TYPE; }
#line 7666 "obj/conf/cf-parse.tab.c"
    break;

  case 119: /* flow_num_type_: ICMP CODE  */
#line 59 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_ICMP_CODE; }
#line 7672 "obj/conf/cf-parse.tab.c"
    break;

  case 120: /* flow_num_type_: LENGTH  */
#line 60 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_PACKET_LENGTH; }
#line 7678 "obj/conf/cf-parse.tab.c"
    break;

  case 121: /* flow_num_type_: DSCP  */
#line 61 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_DSCP; }
#line 7684 "obj/conf/cf-parse.tab.c"
    break;

  case 122: /* flow_num_type_: LABEL  */
#line 62 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_LABEL; }
#line 7690 "obj/conf/cf-parse.tab.c"
    break;

  case 123: /* flow_num_type: flow_num_type_  */
#line 65 "conf/flowspec.Y"
                             { flow_builder_set_type(this_flow, (yyvsp[0].i32)); }
#line 7696 "obj/conf/cf-parse.tab.c"
    break;

  case 124: /* flow_flag_type: TCP FLAGS  */
#line 66 "conf/flowspec.Y"
                             { flow_builder_set_type(this_flow, FLOW_TYPE_TCP_FLAGS); }
#line 7702 "obj/conf/cf-parse.tab.c"
    break;

  case 125: /* flow_frag_type: FRAGMENT  */
#line 67 "conf/flowspec.Y"
                             { flow_builder_set_type(this_flow, FLOW_TYPE_FRAGMENT); }
#line 7708 "obj/conf/cf-parse.tab.c"
    break;

  case 126: /* flow_srcdst: DST  */
#line 70 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_DST_PREFIX; }
#line 7714 "obj/conf/cf-parse.tab.c"
    break;

  case 127: /* flow_srcdst: SRC  */
#line 71 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_SRC_PREFIX; }
#line 7720 "obj/conf/cf-parse.tab.c"
    break;

  case 128: /* flow_num_opts: flow_num_op expr  */
#line 75 "conf/flowspec.Y"
                    {
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, (yyvsp[-1].i32), (yyvsp[0].i));
   }
#line 7729 "obj/conf/cf-parse.tab.c"
    break;

  case 129: /* flow_num_opts: flow_num_opts flow_logic_op flow_num_op expr  */
#line 79 "conf/flowspec.Y"
                                                {
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, (yyvsp[-2].i32) | (yyvsp[-1].i32), (yyvsp[0].i));
   }
#line 7738 "obj/conf/cf-parse.tab.c"
    break;

  case 132: /* flow_num_opt_ext_expr: expr  */
#line 88 "conf/flowspec.Y"
        {
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, FLOW_OP_EQ, (yyvsp[0].i));
   }
#line 7747 "obj/conf/cf-parse.tab.c"
    break;

  case 133: /* flow_num_opt_ext_expr: expr DDOT expr  */
#line 92 "conf/flowspec.Y"
                  {
     flow_check_cf_value_length(this_flow, (yyvsp[-2].i));
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, FLOW_OP_GEQ, (yyvsp[-2].i));
     flow_builder_add_op_val(this_flow, FLOW_OP_AND | FLOW_OP_LEQ, (yyvsp[0].i));
   }
#line 7758 "obj/conf/cf-parse.tab.c"
    break;

  case 136: /* flow_bmk_opts: flow_neg expr '/' expr  */
#line 106 "conf/flowspec.Y"
                          {
     flow_check_cf_bmk_values(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
     flow_builder_add_val_mask(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
   }
#line 7767 "obj/conf/cf-parse.tab.c"
    break;

  case 137: /* flow_bmk_opts: flow_bmk_opts flow_logic_op flow_neg expr '/' expr  */
#line 110 "conf/flowspec.Y"
                                                      {
     flow_check_cf_bmk_values(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
     flow_builder_add_val_mask(this_flow, (yyvsp[-4].i32) | (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
   }
#line 7776 "obj/conf/cf-parse.tab.c"
    break;

  case 138: /* flow_bmk_opts: flow_bmk_opts ',' flow_neg expr '/' expr  */
#line 114 "conf/flowspec.Y"
                                            {
     flow_check_cf_bmk_values(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
     flow_builder_add_val_mask(this_flow, 0x40 | (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i)); /* AND */
   }
#line 7785 "obj/conf/cf-parse.tab.c"
    break;

  case 139: /* flow_neg: %empty  */
#line 121 "conf/flowspec.Y"
                { (yyval.i32) = 0x00; }
#line 7791 "obj/conf/cf-parse.tab.c"
    break;

  case 140: /* flow_neg: '!'  */
#line 122 "conf/flowspec.Y"
                { (yyval.i32) = 0x02; }
#line 7797 "obj/conf/cf-parse.tab.c"
    break;

  case 141: /* flow_frag_val: DONT_FRAGMENT  */
#line 126 "conf/flowspec.Y"
                  { (yyval.i32) = 1; }
#line 7803 "obj/conf/cf-parse.tab.c"
    break;

  case 142: /* flow_frag_val: IS_FRAGMENT  */
#line 127 "conf/flowspec.Y"
                  { (yyval.i32) = 2; }
#line 7809 "obj/conf/cf-parse.tab.c"
    break;

  case 143: /* flow_frag_val: FIRST_FRAGMENT  */
#line 128 "conf/flowspec.Y"
                  { (yyval.i32) = 4; }
#line 7815 "obj/conf/cf-parse.tab.c"
    break;

  case 144: /* flow_frag_val: LAST_FRAGMENT  */
#line 129 "conf/flowspec.Y"
                  { (yyval.i32) = 8; }
#line 7821 "obj/conf/cf-parse.tab.c"
    break;

  case 145: /* flow_frag_opts: flow_neg flow_frag_val  */
#line 133 "conf/flowspec.Y"
                          {
     flow_builder_add_val_mask(this_flow, 0, ((yyvsp[-1].i32) ? 0 : (yyvsp[0].i32)), (yyvsp[0].i32));
   }
#line 7829 "obj/conf/cf-parse.tab.c"
    break;

  case 146: /* flow_frag_opts: flow_frag_opts flow_logic_op flow_neg flow_frag_val  */
#line 136 "conf/flowspec.Y"
                                                       {
     flow_builder_add_val_mask(this_flow, (yyvsp[-2].i32), ((yyvsp[-1].i32) ? 0 : (yyvsp[0].i32)), (yyvsp[0].i32));
   }
#line 7837 "obj/conf/cf-parse.tab.c"
    break;

  case 147: /* flow_frag_opts: flow_frag_opts ',' flow_neg flow_frag_val  */
#line 139 "conf/flowspec.Y"
                                             {
     flow_builder_add_val_mask(this_flow, 0x40, ((yyvsp[-1].i32) ? 0 : (yyvsp[0].i32)), (yyvsp[0].i32)); /* AND */
   }
#line 7845 "obj/conf/cf-parse.tab.c"
    break;

  case 148: /* flow4_item: flow_srcdst net_ip4  */
#line 145 "conf/flowspec.Y"
                       {
     flow_builder_set_type(this_flow, (yyvsp[-1].i32));
     flow_builder4_add_pfx(this_flow, (net_addr_ip4 *) &((yyvsp[0].net)));
   }
#line 7854 "obj/conf/cf-parse.tab.c"
    break;

  case 152: /* flow6_item: flow_srcdst net_ip6  */
#line 155 "conf/flowspec.Y"
                       {
     flow_builder_set_type(this_flow, (yyvsp[-1].i32));
     flow_builder6_add_pfx(this_flow, (net_addr_ip6 *) &((yyvsp[0].net)), 0);
   }
#line 7863 "obj/conf/cf-parse.tab.c"
    break;

  case 153: /* flow6_item: flow_srcdst net_ip6 OFFSET expr  */
#line 159 "conf/flowspec.Y"
                                   {
     if ((yyvsp[0].i) > (yyvsp[-2].net).pxlen)
       cf_error("Prefix offset is higher than prefix length");
     flow_builder_set_type(this_flow, (yyvsp[-3].i32));
     flow_builder6_add_pfx(this_flow, (net_addr_ip6 *) &((yyvsp[-2].net)), (yyvsp[0].i));
   }
#line 7874 "obj/conf/cf-parse.tab.c"
    break;

  case 161: /* flow_builder_init: %empty  */
#line 181 "conf/flowspec.Y"
{
  if (this_flow == NULL)
    this_flow = flow_builder_init(config_pool);	  /* FIXME: This should be allocated from tmp in future */
  else
    flow_builder_clear(this_flow);
}
#line 7885 "obj/conf/cf-parse.tab.c"
    break;

  case 162: /* flow_builder_set_ipv4: %empty  */
#line 188 "conf/flowspec.Y"
                       { this_flow->ipv6 = 0; }
#line 7891 "obj/conf/cf-parse.tab.c"
    break;

  case 163: /* flow_builder_set_ipv6: %empty  */
#line 189 "conf/flowspec.Y"
                       { this_flow->ipv6 = 1; }
#line 7897 "obj/conf/cf-parse.tab.c"
    break;

  case 164: /* net_flow4_: FLOW4 '{' flow_builder_init flow_builder_set_ipv4 flow4_opts '}'  */
#line 192 "conf/flowspec.Y"
{
  (yyval.net_ptr) = (net_addr *) flow_builder4_finalize(this_flow, cfg_mem);
  flow4_validate_cf((net_addr_flow4 *) (yyval.net_ptr));
}
#line 7906 "obj/conf/cf-parse.tab.c"
    break;

  case 165: /* net_flow6_: FLOW6 '{' flow_builder_init flow_builder_set_ipv6 flow6_opts '}'  */
#line 198 "conf/flowspec.Y"
{
  (yyval.net_ptr) = (net_addr *) flow_builder6_finalize(this_flow, cfg_mem);
  flow6_validate_cf((net_addr_flow6 *) (yyval.net_ptr));
}
#line 7915 "obj/conf/cf-parse.tab.c"
    break;

  case 174: /* conf: FILTER STACKS expr expr ';'  */
#line 404 "filter/config.Y"
                                  {
  if (((yyvsp[-2].i) < 16) || ((yyvsp[-1].i) < 16))
    /* Check for self-crippling values */
    cf_error("Filter stack values lesser than 16 not supported");
  new_config->filter_vstk = (yyvsp[-2].i);
  new_config->filter_estk = (yyvsp[-1].i);
 }
#line 7927 "obj/conf/cf-parse.tab.c"
    break;

  case 176: /* $@1: %empty  */
#line 415 "filter/config.Y"
                 {
     (yyvsp[0].s) = cf_define_symbol(new_config, (yyvsp[0].s), SYM_FILTER, filter, NULL);
     cf_enter_filters();
     cf_push_scope( new_config, (yyvsp[0].s) );
     this_function = NULL;
   }
#line 7938 "obj/conf/cf-parse.tab.c"
    break;

  case 177: /* filter_def: FILTER symbol $@1 filter_body  */
#line 420 "filter/config.Y"
                 {
     struct filter *f = cfg_alloc(sizeof(struct filter));
     *f = (struct filter) { .sym = (yyvsp[-2].s), .root = (yyvsp[0].fl) };
     (yyvsp[-2].s)->filter = f;

     cf_pop_scope(new_config);
     cf_exit_filters();
   }
#line 7951 "obj/conf/cf-parse.tab.c"
    break;

  case 179: /* filter_eval: EVAL term  */
#line 432 "filter/config.Y"
             { cf_eval_int((yyvsp[0].x)); }
#line 7957 "obj/conf/cf-parse.tab.c"
    break;

  case 181: /* custom_attr: ATTRIBUTE type symbol ';'  */
#line 436 "filter/config.Y"
                                       {
  cf_enter_filters();
  struct ea_class *ac = ea_class_find_by_name((yyvsp[-1].s)->name);
  cf_exit_filters();
  if (ac && (ac->type == (yyvsp[-2].i)))
    ea_ref_class(new_config->pool, ac);
  else
    ac = ea_register_alloc(new_config->pool, (struct ea_class) {
	.name = (yyvsp[-1].s)->name,
	.type = (yyvsp[-2].i),
    })->class;

  cf_define_symbol(new_config, (yyvsp[-1].s), SYM_ATTRIBUTE, attribute, ac);
}
#line 7976 "obj/conf/cf-parse.tab.c"
    break;

  case 183: /* bt_test_suite: BT_TEST_SUITE '(' CF_SYM_KNOWN ',' text ')'  */
#line 453 "filter/config.Y"
                                             {
  cf_assert_symbol((yyvsp[-3].s), SYM_FUNCTION);
  struct f_bt_test_suite *t = cfg_allocz(sizeof(struct f_bt_test_suite));
  t->fn = (yyvsp[-3].s)->function;
  t->fn_name = (yyvsp[-3].s)->name;
  t->dsc = (yyvsp[-1].t);

  add_tail(&new_config->tests, &t->n);
 }
#line 7990 "obj/conf/cf-parse.tab.c"
    break;

  case 185: /* bt_test_same: BT_TEST_SAME '(' symbol_known ',' symbol_known ',' expr ')'  */
#line 466 "filter/config.Y"
                                                             {
  cf_assert_symbol((yyvsp[-5].s), SYM_FUNCTION);
  cf_assert_symbol((yyvsp[-3].s), SYM_FUNCTION);
  struct f_bt_test_suite *t = cfg_allocz(sizeof(struct f_bt_test_suite));
  t->fn = (yyvsp[-5].s)->function;
  t->cmp = (yyvsp[-3].s)->function;
  t->result = (yyvsp[-1].i);
  t->fn_name = (yyvsp[-5].s)->name;
  t->dsc = (yyvsp[-3].s)->name;
  add_tail(&new_config->tests, &t->n);
 }
#line 8006 "obj/conf/cf-parse.tab.c"
    break;

  case 186: /* type: INT  */
#line 480 "filter/config.Y"
       { (yyval.i) = T_INT; }
#line 8012 "obj/conf/cf-parse.tab.c"
    break;

  case 187: /* type: BOOL  */
#line 481 "filter/config.Y"
        { (yyval.i) = T_BOOL; }
#line 8018 "obj/conf/cf-parse.tab.c"
    break;

  case 188: /* type: IP  */
#line 482 "filter/config.Y"
      { (yyval.i) = T_IP; }
#line 8024 "obj/conf/cf-parse.tab.c"
    break;

  case 189: /* type: RD  */
#line 483 "filter/config.Y"
      { (yyval.i) = T_RD; }
#line 8030 "obj/conf/cf-parse.tab.c"
    break;

  case 190: /* type: PREFIX  */
#line 484 "filter/config.Y"
          { (yyval.i) = T_NET; }
#line 8036 "obj/conf/cf-parse.tab.c"
    break;

  case 191: /* type: PAIR  */
#line 485 "filter/config.Y"
        { (yyval.i) = T_PAIR; }
#line 8042 "obj/conf/cf-parse.tab.c"
    break;

  case 192: /* type: QUAD  */
#line 486 "filter/config.Y"
        { (yyval.i) = T_QUAD; }
#line 8048 "obj/conf/cf-parse.tab.c"
    break;

  case 193: /* type: EC  */
#line 487 "filter/config.Y"
      { (yyval.i) = T_EC; }
#line 8054 "obj/conf/cf-parse.tab.c"
    break;

  case 194: /* type: LC  */
#line 488 "filter/config.Y"
      { (yyval.i) = T_LC; }
#line 8060 "obj/conf/cf-parse.tab.c"
    break;

  case 195: /* type: STRING  */
#line 489 "filter/config.Y"
          { (yyval.i) = T_STRING; }
#line 8066 "obj/conf/cf-parse.tab.c"
    break;

  case 196: /* type: BYTESTRING  */
#line 490 "filter/config.Y"
              { (yyval.i) = T_BYTESTRING; }
#line 8072 "obj/conf/cf-parse.tab.c"
    break;

  case 197: /* type: BGPMASK  */
#line 491 "filter/config.Y"
           { (yyval.i) = T_PATH_MASK; }
#line 8078 "obj/conf/cf-parse.tab.c"
    break;

  case 198: /* type: BGPPATH  */
#line 492 "filter/config.Y"
           { (yyval.i) = T_PATH; }
#line 8084 "obj/conf/cf-parse.tab.c"
    break;

  case 199: /* type: CLIST  */
#line 493 "filter/config.Y"
         { (yyval.i) = T_CLIST; }
#line 8090 "obj/conf/cf-parse.tab.c"
    break;

  case 200: /* type: ECLIST  */
#line 494 "filter/config.Y"
          { (yyval.i) = T_ECLIST; }
#line 8096 "obj/conf/cf-parse.tab.c"
    break;

  case 201: /* type: LCLIST  */
#line 495 "filter/config.Y"
          { (yyval.i) = T_LCLIST; }
#line 8102 "obj/conf/cf-parse.tab.c"
    break;

  case 202: /* type: ROUTE  */
#line 496 "filter/config.Y"
         { (yyval.i) = T_ROUTE; }
#line 8108 "obj/conf/cf-parse.tab.c"
    break;

  case 203: /* type: type SET  */
#line 497 "filter/config.Y"
            {
	switch ((yyvsp[-1].i)) {
	  case T_INT:
	  case T_PAIR:
	  case T_QUAD:
	  case T_ENUM:
	  case T_EC:
	  case T_LC:
	  case T_RD:
	  case T_IP:
	       (yyval.i) = T_SET;
	       break;

	  case T_NET:
	       (yyval.i) = T_PREFIX_SET;
	    break;

	  default:
		cf_error( "You can't create sets of this type." );
	}
   }
#line 8134 "obj/conf/cf-parse.tab.c"
    break;

  case 204: /* @2: %empty  */
#line 519 "filter/config.Y"
   { (yyval.i) = cf_maybe_exit_filters(); }
#line 8140 "obj/conf/cf-parse.tab.c"
    break;

  case 205: /* type: ENUM @2 enum_type  */
#line 521 "filter/config.Y"
   {
     if ((yyvsp[-1].i)) cf_enter_filters();
     (yyval.i) = (yyvsp[0].i);
   }
#line 8149 "obj/conf/cf-parse.tab.c"
    break;

  case 206: /* function_argsn: %empty  */
#line 528 "filter/config.Y"
               { (yyval.fa) = NULL; }
#line 8155 "obj/conf/cf-parse.tab.c"
    break;

  case 207: /* function_argsn: function_argsn type symbol ';'  */
#line 529 "filter/config.Y"
                                  {
     if ((yyvsp[-1].s)->scope->slots >= 0xfe) cf_error("Too many declarations, at most 255 allowed");
     (yyval.fa) = cfg_alloc(sizeof(struct f_arg));
     (yyval.fa)->arg = cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, sym_->scope->slots++);
     (yyval.fa)->next = (yyvsp[-3].fa);
   }
#line 8166 "obj/conf/cf-parse.tab.c"
    break;

  case 208: /* function_args: '(' ')'  */
#line 538 "filter/config.Y"
           { (yyval.fa) = NULL; }
#line 8172 "obj/conf/cf-parse.tab.c"
    break;

  case 209: /* function_args: '(' function_argsn type symbol ')'  */
#line 539 "filter/config.Y"
                                      {
     (yyval.fa) = cfg_alloc(sizeof(struct f_arg));
     (yyval.fa)->arg = cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, sym_->scope->slots++);
     (yyval.fa)->next = (yyvsp[-3].fa);
   }
#line 8182 "obj/conf/cf-parse.tab.c"
    break;

  case 210: /* function_vars: %empty  */
#line 547 "filter/config.Y"
               { (yyval.i) = 0; }
#line 8188 "obj/conf/cf-parse.tab.c"
    break;

  case 211: /* function_vars: function_vars type symbol ';'  */
#line 548 "filter/config.Y"
                                 {
     cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, f_new_var(sym_->scope));
     (yyval.i) = (yyvsp[-3].i) + 1;
   }
#line 8197 "obj/conf/cf-parse.tab.c"
    break;

  case 212: /* function_type: %empty  */
#line 555 "filter/config.Y"
               { (yyval.i) = T_VOID; }
#line 8203 "obj/conf/cf-parse.tab.c"
    break;

  case 213: /* function_type: IMP type  */
#line 556 "filter/config.Y"
            { (yyval.i) = (yyvsp[0].i); }
#line 8209 "obj/conf/cf-parse.tab.c"
    break;

  case 215: /* filter: CF_SYM_KNOWN  */
#line 562 "filter/config.Y"
                {
     cf_assert_symbol((yyvsp[0].s), SYM_FILTER);
     (yyval.f) = (yyvsp[0].s)->filter;
   }
#line 8218 "obj/conf/cf-parse.tab.c"
    break;

  case 216: /* $@3: %empty  */
#line 566 "filter/config.Y"
   {
     cf_enter_filters();
     cf_push_scope(new_config, NULL);
     this_function = NULL;
   }
#line 8228 "obj/conf/cf-parse.tab.c"
    break;

  case 217: /* filter: $@3 filter_body  */
#line 570 "filter/config.Y"
                 {
     struct filter *f = cfg_alloc(sizeof(struct filter));
     *f = (struct filter) { .root = (yyvsp[0].fl) };
     (yyval.f) = f;

     cf_pop_scope(new_config);
     cf_exit_filters();
   }
#line 8241 "obj/conf/cf-parse.tab.c"
    break;

  case 218: /* $@4: %empty  */
#line 581 "filter/config.Y"
         {
     cf_enter_filters();
   }
#line 8249 "obj/conf/cf-parse.tab.c"
    break;

  case 219: /* where_filter: WHERE $@4 term  */
#line 583 "filter/config.Y"
          {
     /* Construct 'IF term THEN { ACCEPT; } ELSE { REJECT; }' */
     (yyval.f) = f_new_where((yyvsp[0].x));
     cf_exit_filters();
   }
#line 8259 "obj/conf/cf-parse.tab.c"
    break;

  case 220: /* function_body: function_vars '{' cmds '}'  */
#line 591 "filter/config.Y"
                              {
     (yyval.fl) = f_linearize((yyvsp[-1].x), 0);
     (yyval.fl)->vars = (yyvsp[-3].i);
   }
#line 8268 "obj/conf/cf-parse.tab.c"
    break;

  case 222: /* $@5: %empty  */
#line 600 "filter/config.Y"
                   {
     DBG( "Beginning of function %s\n", (yyvsp[0].s)->name );
     this_function = cf_define_symbol(new_config, (yyvsp[0].s), SYM_FUNCTION, function, NULL);
     cf_enter_filters();
     cf_push_scope(new_config, this_function);
   }
#line 8279 "obj/conf/cf-parse.tab.c"
    break;

  case 223: /* $@6: %empty  */
#line 605 "filter/config.Y"
                                 {
     /* Make dummy f_line for storing function prototype */
     struct f_line *dummy = cfg_allocz(sizeof(struct f_line));
     this_function->function = dummy;

     dummy->return_type = (yyvsp[0].i);

     /* Revert the args */
     while ((yyvsp[-1].fa)) {
       struct f_arg *tmp = (yyvsp[-1].fa);
       (yyvsp[-1].fa) = (yyvsp[-1].fa)->next;

       tmp->next = dummy->arg_list;
       dummy->arg_list = tmp;
       dummy->args++;
     }
   }
#line 8301 "obj/conf/cf-parse.tab.c"
    break;

  case 224: /* function_def: FUNCTION symbol $@5 function_args function_type $@6 function_body  */
#line 621 "filter/config.Y"
                   {
     (yyvsp[0].fl)->args = this_function->function->args;
     (yyvsp[0].fl)->arg_list = this_function->function->arg_list;
     (yyvsp[0].fl)->return_type = this_function->function->return_type;
     (yyvsp[-5].s)->function = (yyvsp[0].fl);
     cf_pop_scope(new_config);
     cf_exit_filters();
   }
#line 8314 "obj/conf/cf-parse.tab.c"
    break;

  case 225: /* cmds: %empty  */
#line 633 "filter/config.Y"
                  { (yyval.x) = NULL; }
#line 8320 "obj/conf/cf-parse.tab.c"
    break;

  case 226: /* cmds: cmds_int  */
#line 634 "filter/config.Y"
            { (yyval.x) = (yyvsp[0].xp).begin; }
#line 8326 "obj/conf/cf-parse.tab.c"
    break;

  case 229: /* cmd_prep: cmd_var  */
#line 639 "filter/config.Y"
                  {
  (yyval.xp).begin = (yyval.xp).end = (yyvsp[0].x);
  if ((yyvsp[0].x))
    while ((yyval.xp).end->next)
      (yyval.xp).end = (yyval.xp).end->next;
}
#line 8337 "obj/conf/cf-parse.tab.c"
    break;

  case 231: /* cmds_int: cmds_int cmd_prep  */
#line 648 "filter/config.Y"
                     {
  if (!(yyvsp[-1].xp).begin)
    (yyval.xp) = (yyvsp[0].xp);
  else if (!(yyvsp[0].xp).begin)
    (yyval.xp) = (yyvsp[-1].xp);
  else {
    (yyval.xp).begin = (yyvsp[-1].xp).begin;
    (yyval.xp).end = (yyvsp[0].xp).end;
    (yyvsp[-1].xp).end->next = (yyvsp[0].xp).begin;
  }
 }
#line 8353 "obj/conf/cf-parse.tab.c"
    break;

  case 232: /* fipa: IP4  */
#line 670 "filter/config.Y"
                          { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip4((yyvsp[0].ip4)); }
#line 8359 "obj/conf/cf-parse.tab.c"
    break;

  case 233: /* fipa: IP6  */
#line 671 "filter/config.Y"
                          { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip6((yyvsp[0].ip6)); }
#line 8365 "obj/conf/cf-parse.tab.c"
    break;

  case 234: /* set_atom0: NUM  */
#line 684 "filter/config.Y"
          { (yyval.v).type = T_INT; (yyval.v).val.i = (yyvsp[0].i); }
#line 8371 "obj/conf/cf-parse.tab.c"
    break;

  case 235: /* set_atom0: fipa  */
#line 685 "filter/config.Y"
          { (yyval.v) = (yyvsp[0].v); }
#line 8377 "obj/conf/cf-parse.tab.c"
    break;

  case 236: /* set_atom0: VPN_RD  */
#line 686 "filter/config.Y"
          { (yyval.v).type = T_RD; (yyval.v).val.rd = (yyvsp[0].rd); }
#line 8383 "obj/conf/cf-parse.tab.c"
    break;

  case 237: /* set_atom0: ENUM_TOKEN  */
#line 687 "filter/config.Y"
              { (yyval.v).type = pair_a((yyvsp[0].i)); (yyval.v).val.i = pair_b((yyvsp[0].i)); }
#line 8389 "obj/conf/cf-parse.tab.c"
    break;

  case 238: /* set_atom0: '(' term ')'  */
#line 688 "filter/config.Y"
                {
     (yyval.v) = cf_eval_tmp((yyvsp[-1].x), T_VOID);
     if (!f_valid_set_type((yyval.v).type))
       cf_error("Set-incompatible type (%s)", f_type_name((yyval.v).type));
   }
#line 8399 "obj/conf/cf-parse.tab.c"
    break;

  case 240: /* set_atom: CF_SYM_KNOWN  */
#line 697 "filter/config.Y"
                {
     cf_assert_symbol((yyvsp[0].s), SYM_CONSTANT);
     if (!f_valid_set_type(SYM_TYPE((yyvsp[0].s))))
       cf_error("%s: Set-incompatible type (%s)", (yyvsp[0].s)->name, f_type_name(SYM_TYPE((yyvsp[0].s))));
     (yyval.v) = *(yyvsp[0].s)->val;
   }
#line 8410 "obj/conf/cf-parse.tab.c"
    break;

  case 242: /* cnum: term  */
#line 710 "filter/config.Y"
        { (yyval.i32) = cf_eval_int((yyvsp[0].x)); }
#line 8416 "obj/conf/cf-parse.tab.c"
    break;

  case 243: /* pair_item: '(' cnum ',' cnum ')'  */
#line 713 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-3].i32), (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8422 "obj/conf/cf-parse.tab.c"
    break;

  case 244: /* pair_item: '(' cnum ',' cnum DDOT cnum ')'  */
#line 714 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8428 "obj/conf/cf-parse.tab.c"
    break;

  case 245: /* pair_item: '(' cnum ',' '*' ')'  */
#line 715 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-3].i32), (yyvsp[-3].i32), 0, CC_ALL); }
#line 8434 "obj/conf/cf-parse.tab.c"
    break;

  case 246: /* pair_item: '(' cnum DDOT cnum ',' cnum ')'  */
#line 716 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_set((yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8440 "obj/conf/cf-parse.tab.c"
    break;

  case 247: /* pair_item: '(' cnum DDOT cnum ',' cnum DDOT cnum ')'  */
#line 717 "filter/config.Y"
                                             { (yyval.e) = f_new_pair_set((yyvsp[-7].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8446 "obj/conf/cf-parse.tab.c"
    break;

  case 248: /* pair_item: '(' cnum DDOT cnum ',' '*' ')'  */
#line 718 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-5].i32), (yyvsp[-3].i32), 0, CC_ALL); }
#line 8452 "obj/conf/cf-parse.tab.c"
    break;

  case 249: /* pair_item: '(' '*' ',' cnum ')'  */
#line 719 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_set(0, CC_ALL, (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8458 "obj/conf/cf-parse.tab.c"
    break;

  case 250: /* pair_item: '(' '*' ',' cnum DDOT cnum ')'  */
#line 720 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_set(0, CC_ALL, (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8464 "obj/conf/cf-parse.tab.c"
    break;

  case 251: /* pair_item: '(' '*' ',' '*' ')'  */
#line 721 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item(0, CC_ALL, 0, CC_ALL); }
#line 8470 "obj/conf/cf-parse.tab.c"
    break;

  case 252: /* pair_item: '(' cnum ',' cnum ')' DDOT '(' cnum ',' cnum ')'  */
#line 723 "filter/config.Y"
   { (yyval.e) = f_new_pair_item((yyvsp[-9].i32), (yyvsp[-3].i32), (yyvsp[-7].i32), (yyvsp[-1].i32)); }
#line 8476 "obj/conf/cf-parse.tab.c"
    break;

  case 253: /* ec_kind: RT  */
#line 727 "filter/config.Y"
      { (yyval.ecs) = EC_RT; }
#line 8482 "obj/conf/cf-parse.tab.c"
    break;

  case 254: /* ec_kind: RO  */
#line 728 "filter/config.Y"
      { (yyval.ecs) = EC_RO; }
#line 8488 "obj/conf/cf-parse.tab.c"
    break;

  case 255: /* ec_kind: UNKNOWN NUM  */
#line 729 "filter/config.Y"
               { (yyval.ecs) = (yyvsp[0].i); }
#line 8494 "obj/conf/cf-parse.tab.c"
    break;

  case 256: /* ec_kind: GENERIC  */
#line 730 "filter/config.Y"
           { (yyval.ecs) = EC_GENERIC; }
#line 8500 "obj/conf/cf-parse.tab.c"
    break;

  case 257: /* ec_item: '(' ec_kind ',' cnum ',' cnum ')'  */
#line 734 "filter/config.Y"
                                                { (yyval.e) = f_new_ec_item((yyvsp[-5].ecs), 0, (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8506 "obj/conf/cf-parse.tab.c"
    break;

  case 258: /* ec_item: '(' ec_kind ',' cnum ',' cnum DDOT cnum ')'  */
#line 735 "filter/config.Y"
                                                { (yyval.e) = f_new_ec_item((yyvsp[-7].ecs), 0, (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8512 "obj/conf/cf-parse.tab.c"
    break;

  case 259: /* ec_item: '(' ec_kind ',' cnum ',' '*' ')'  */
#line 736 "filter/config.Y"
                                                { (yyval.e) = f_new_ec_item((yyvsp[-5].ecs), 0, (yyvsp[-3].i32), 0, EC_ALL); }
#line 8518 "obj/conf/cf-parse.tab.c"
    break;

  case 260: /* lc_item: '(' cnum ',' cnum ',' cnum ')'  */
#line 740 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8524 "obj/conf/cf-parse.tab.c"
    break;

  case 261: /* lc_item: '(' cnum ',' cnum ',' cnum DDOT cnum ')'  */
#line 741 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-7].i32), (yyvsp[-7].i32), (yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8530 "obj/conf/cf-parse.tab.c"
    break;

  case 262: /* lc_item: '(' cnum ',' cnum ',' '*' ')'  */
#line 742 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-3].i32), 0, LC_ALL); }
#line 8536 "obj/conf/cf-parse.tab.c"
    break;

  case 263: /* lc_item: '(' cnum ',' cnum DDOT cnum ',' '*' ')'  */
#line 743 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-7].i32), (yyvsp[-7].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), 0, LC_ALL); }
#line 8542 "obj/conf/cf-parse.tab.c"
    break;

  case 264: /* lc_item: '(' cnum ',' '*' ',' '*' ')'  */
#line 744 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-5].i32), (yyvsp[-5].i32), 0, LC_ALL, 0, LC_ALL); }
#line 8548 "obj/conf/cf-parse.tab.c"
    break;

  case 265: /* lc_item: '(' cnum DDOT cnum ',' '*' ',' '*' ')'  */
#line 745 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-7].i32), (yyvsp[-5].i32), 0, LC_ALL, 0, LC_ALL); }
#line 8554 "obj/conf/cf-parse.tab.c"
    break;

  case 266: /* lc_item: '(' '*' ',' '*' ',' '*' ')'  */
#line 746 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item(0, LC_ALL, 0, LC_ALL, 0, LC_ALL); }
#line 8560 "obj/conf/cf-parse.tab.c"
    break;

  case 267: /* lc_item: '(' cnum ',' cnum ',' cnum ')' DDOT '(' cnum ',' cnum ',' cnum ')'  */
#line 748 "filter/config.Y"
   { (yyval.e) = f_new_lc_item((yyvsp[-13].i32), (yyvsp[-5].i32), (yyvsp[-11].i32), (yyvsp[-3].i32), (yyvsp[-9].i32), (yyvsp[-1].i32)); }
#line 8566 "obj/conf/cf-parse.tab.c"
    break;

  case 271: /* set_item: set_atom  */
#line 755 "filter/config.Y"
            { (yyval.e) = f_new_item((yyvsp[0].v), (yyvsp[0].v)); }
#line 8572 "obj/conf/cf-parse.tab.c"
    break;

  case 272: /* set_item: set_atom DDOT set_atom  */
#line 756 "filter/config.Y"
                          { (yyval.e) = f_new_item((yyvsp[-2].v), (yyvsp[0].v)); }
#line 8578 "obj/conf/cf-parse.tab.c"
    break;

  case 276: /* switch_item: switch_atom  */
#line 763 "filter/config.Y"
               { (yyval.e) = f_new_item((yyvsp[0].v), (yyvsp[0].v)); }
#line 8584 "obj/conf/cf-parse.tab.c"
    break;

  case 277: /* switch_item: switch_atom DDOT switch_atom  */
#line 764 "filter/config.Y"
                                { (yyval.e) = f_new_item((yyvsp[-2].v), (yyvsp[0].v)); }
#line 8590 "obj/conf/cf-parse.tab.c"
    break;

  case 279: /* ec_items: ec_items ',' ec_item  */
#line 769 "filter/config.Y"
                        { (yyval.e) = f_merge_items((yyvsp[-2].e), (yyvsp[0].e)); }
#line 8596 "obj/conf/cf-parse.tab.c"
    break;

  case 281: /* set_items: set_items ',' set_item  */
#line 774 "filter/config.Y"
                          { (yyval.e) = f_merge_items((yyvsp[-2].e), (yyvsp[0].e)); }
#line 8602 "obj/conf/cf-parse.tab.c"
    break;

  case 283: /* switch_items: switch_items ',' switch_item  */
#line 779 "filter/config.Y"
                                { (yyval.e) = f_merge_items((yyvsp[-2].e), (yyvsp[0].e)); }
#line 8608 "obj/conf/cf-parse.tab.c"
    break;

  case 284: /* fprefix: net_ip_  */
#line 783 "filter/config.Y"
                { (yyval.px).net = (yyvsp[0].net); (yyval.px).lo = (yyvsp[0].net).pxlen; (yyval.px).hi = (yyvsp[0].net).pxlen; }
#line 8614 "obj/conf/cf-parse.tab.c"
    break;

  case 285: /* fprefix: net_ip_ '+'  */
#line 784 "filter/config.Y"
                { (yyval.px).net = (yyvsp[-1].net); (yyval.px).lo = (yyvsp[-1].net).pxlen; (yyval.px).hi = net_max_prefix_length[(yyvsp[-1].net).type]; }
#line 8620 "obj/conf/cf-parse.tab.c"
    break;

  case 286: /* fprefix: net_ip_ '-'  */
#line 785 "filter/config.Y"
                { (yyval.px).net = (yyvsp[-1].net); (yyval.px).lo = 0; (yyval.px).hi = (yyvsp[-1].net).pxlen; }
#line 8626 "obj/conf/cf-parse.tab.c"
    break;

  case 287: /* fprefix: net_ip_ '{' NUM ',' NUM '}'  */
#line 786 "filter/config.Y"
                               {
     (yyval.px).net = (yyvsp[-5].net); (yyval.px).lo = (yyvsp[-3].i); (yyval.px).hi = (yyvsp[-1].i);
     if (((yyvsp[-3].i) > (yyvsp[-1].i)) || ((yyvsp[-1].i) > net_max_prefix_length[(yyvsp[-5].net).type]))
       cf_error("Invalid prefix pattern range: {%u, %u}", (yyvsp[-3].i), (yyvsp[-1].i));
   }
#line 8636 "obj/conf/cf-parse.tab.c"
    break;

  case 288: /* fprefix_set: fprefix  */
#line 794 "filter/config.Y"
           { (yyval.trie) = f_new_trie(cfg_mem, 0); trie_add_prefix((yyval.trie), &((yyvsp[0].px).net), (yyvsp[0].px).lo, (yyvsp[0].px).hi); }
#line 8642 "obj/conf/cf-parse.tab.c"
    break;

  case 289: /* fprefix_set: fprefix_set ',' fprefix  */
#line 795 "filter/config.Y"
                           { (yyval.trie) = (yyvsp[-2].trie); if (!trie_add_prefix((yyval.trie), &((yyvsp[0].px).net), (yyvsp[0].px).lo, (yyvsp[0].px).hi)) cf_error("Mixed IPv4/IPv6 prefixes in prefix set"); }
#line 8648 "obj/conf/cf-parse.tab.c"
    break;

  case 290: /* switch_body: %empty  */
#line 798 "filter/config.Y"
                         { (yyval.e) = NULL; }
#line 8654 "obj/conf/cf-parse.tab.c"
    break;

  case 291: /* switch_body: switch_body switch_items ':' cmd  */
#line 799 "filter/config.Y"
                                    {
     /* Fill data fields */
     struct f_tree *t;
     for (t = (yyvsp[-2].e); t; t = t->left)
       t->data = (yyvsp[0].x);
     (yyval.e) = f_merge_items((yyvsp[-3].e), (yyvsp[-2].e));
   }
#line 8666 "obj/conf/cf-parse.tab.c"
    break;

  case 292: /* switch_body: switch_body ELSECOL cmd  */
#line 806 "filter/config.Y"
                           {
     struct f_tree *t = f_new_tree();
     t->from.type = t->to.type = T_VOID;
     t->right = t;
     t->data = (yyvsp[0].x);
     (yyval.e) = f_merge_items((yyvsp[-2].e), t);
 }
#line 8678 "obj/conf/cf-parse.tab.c"
    break;

  case 293: /* bgp_path_expr: lvalue  */
#line 816 "filter/config.Y"
          { (yyval.x) = f_lval_getter(&(yyvsp[0].flv)); }
#line 8684 "obj/conf/cf-parse.tab.c"
    break;

  case 294: /* bgp_path_expr: '(' term ')'  */
#line 817 "filter/config.Y"
                { (yyval.x) = (yyvsp[-1].x); }
#line 8690 "obj/conf/cf-parse.tab.c"
    break;

  case 295: /* bgp_path: PO bgp_path_tail PC  */
#line 821 "filter/config.Y"
                         { (yyval.x) = (yyvsp[-1].x); }
#line 8696 "obj/conf/cf-parse.tab.c"
    break;

  case 296: /* bgp_path_tail: NUM bgp_path_tail  */
#line 825 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .asn = (yyvsp[-1].i), .kind = PM_ASN, }, }); (yyval.x)->next = (yyvsp[0].x);  }
#line 8702 "obj/conf/cf-parse.tab.c"
    break;

  case 297: /* bgp_path_tail: NUM DDOT NUM bgp_path_tail  */
#line 826 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .from = (yyvsp[-3].i), .to = (yyvsp[-1].i), .kind = PM_ASN_RANGE }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8708 "obj/conf/cf-parse.tab.c"
    break;

  case 298: /* bgp_path_tail: '[' ']' bgp_path_tail  */
#line 827 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .set = NULL, .kind = PM_ASN_SET }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8714 "obj/conf/cf-parse.tab.c"
    break;

  case 299: /* bgp_path_tail: '[' set_items ']' bgp_path_tail  */
#line 828 "filter/config.Y"
                                   {
   if ((yyvsp[-2].e)->from.type != T_INT) cf_error("Only integer sets allowed in path mask");
   (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .set = build_tree((yyvsp[-2].e), true), .kind = PM_ASN_SET }, }); (yyval.x)->next = (yyvsp[0].x);
 }
#line 8723 "obj/conf/cf-parse.tab.c"
    break;

  case 300: /* bgp_path_tail: '*' bgp_path_tail  */
#line 832 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .kind = PM_ASTERISK }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8729 "obj/conf/cf-parse.tab.c"
    break;

  case 301: /* bgp_path_tail: '?' bgp_path_tail  */
#line 833 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .kind = PM_QUESTION }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8735 "obj/conf/cf-parse.tab.c"
    break;

  case 302: /* bgp_path_tail: '+' bgp_path_tail  */
#line 834 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .kind = PM_LOOP }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8741 "obj/conf/cf-parse.tab.c"
    break;

  case 303: /* bgp_path_tail: bgp_path_expr bgp_path_tail  */
#line 835 "filter/config.Y"
                                { (yyval.x) = (yyvsp[-1].x); (yyval.x)->next = (yyvsp[0].x); }
#line 8747 "obj/conf/cf-parse.tab.c"
    break;

  case 304: /* bgp_path_tail: %empty  */
#line 836 "filter/config.Y"
                                { (yyval.x) = NULL; }
#line 8753 "obj/conf/cf-parse.tab.c"
    break;

  case 305: /* constant: NUM  */
#line 840 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = (yyvsp[0].i), }); }
#line 8759 "obj/conf/cf-parse.tab.c"
    break;

  case 306: /* constant: TRUE  */
#line 841 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 1, }); }
#line 8765 "obj/conf/cf-parse.tab.c"
    break;

  case 307: /* constant: FALSE  */
#line 842 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 0, }); }
#line 8771 "obj/conf/cf-parse.tab.c"
    break;

  case 308: /* constant: TEXT  */
#line 843 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_STRING, .val.s = (yyvsp[0].t), }); }
#line 8777 "obj/conf/cf-parse.tab.c"
    break;

  case 309: /* constant: BYTETEXT  */
#line 844 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BYTESTRING, .val.bs = (yyvsp[0].bs), }); }
#line 8783 "obj/conf/cf-parse.tab.c"
    break;

  case 310: /* constant: fipa  */
#line 845 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (yyvsp[0].v)); }
#line 8789 "obj/conf/cf-parse.tab.c"
    break;

  case 311: /* constant: VPN_RD  */
#line 846 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_RD, .val.rd = (yyvsp[0].rd), }); }
#line 8795 "obj/conf/cf-parse.tab.c"
    break;

  case 312: /* constant: net_  */
#line 847 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_NET, .val.net = (yyvsp[0].net_ptr), }); }
#line 8801 "obj/conf/cf-parse.tab.c"
    break;

  case 313: /* constant: '[' ']'  */
#line 848 "filter/config.Y"
           { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_SET, .val.t = NULL, }); }
#line 8807 "obj/conf/cf-parse.tab.c"
    break;

  case 314: /* constant: '[' set_items ']'  */
#line 849 "filter/config.Y"
                     {
     DBG( "We've got a set here..." );
     (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_SET, .val.t = build_tree((yyvsp[-1].e), true), });
     DBG( "ook\n" );
 }
#line 8817 "obj/conf/cf-parse.tab.c"
    break;

  case 315: /* constant: '[' fprefix_set ']'  */
#line 854 "filter/config.Y"
                       { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PREFIX_SET, .val.ti = (yyvsp[-1].trie), }); }
#line 8823 "obj/conf/cf-parse.tab.c"
    break;

  case 316: /* constant: ENUM_TOKEN  */
#line 855 "filter/config.Y"
              { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = (yyvsp[0].i) >> 16, .val.i = (yyvsp[0].i) & 0xffff, }); }
#line 8829 "obj/conf/cf-parse.tab.c"
    break;

  case 317: /* constructor: '(' term ',' term ')'  */
#line 859 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_PAIR_CONSTRUCT, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8835 "obj/conf/cf-parse.tab.c"
    break;

  case 318: /* constructor: '(' ec_kind ',' term ',' term ')'  */
#line 860 "filter/config.Y"
                                     { (yyval.x) = f_new_inst(FI_EC_CONSTRUCT, (yyvsp[-3].x), (yyvsp[-1].x), (yyvsp[-5].ecs)); }
#line 8841 "obj/conf/cf-parse.tab.c"
    break;

  case 319: /* constructor: '(' term ',' term ',' term ')'  */
#line 861 "filter/config.Y"
                                  { (yyval.x) = f_new_inst(FI_LC_CONSTRUCT, (yyvsp[-5].x), (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8847 "obj/conf/cf-parse.tab.c"
    break;

  case 320: /* constructor: bgp_path  */
#line 862 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_PATHMASK_CONSTRUCT, (yyvsp[0].x)); }
#line 8853 "obj/conf/cf-parse.tab.c"
    break;

  case 321: /* var_list_r: %empty  */
#line 868 "filter/config.Y"
               { (yyval.x) = NULL; }
#line 8859 "obj/conf/cf-parse.tab.c"
    break;

  case 322: /* var_list_r: term  */
#line 869 "filter/config.Y"
        { (yyval.x) = (yyvsp[0].x); }
#line 8865 "obj/conf/cf-parse.tab.c"
    break;

  case 323: /* var_list_r: var_list_r ',' term  */
#line 870 "filter/config.Y"
                       { (yyval.x) = (yyvsp[0].x); (yyval.x)->next = (yyvsp[-2].x); }
#line 8871 "obj/conf/cf-parse.tab.c"
    break;

  case 324: /* var_list: var_list_r  */
#line 874 "filter/config.Y"
   {
     (yyval.x) = NULL;

     /* Revert the var_list_r */
     while ((yyvsp[0].x)) {
       struct f_inst *tmp = (yyvsp[0].x);
       (yyvsp[0].x) = (yyvsp[0].x)->next;

       tmp->next = (yyval.x);
       (yyval.x) = tmp;
     }
   }
#line 8888 "obj/conf/cf-parse.tab.c"
    break;

  case 325: /* function_call: CF_SYM_KNOWN '(' var_list ')'  */
#line 890 "filter/config.Y"
   {
     if ((yyvsp[-3].s)->class != SYM_FUNCTION)
       cf_error("You can't call something which is not a function. Really.");

     (yyval.x) = f_new_inst(FI_CALL, (yyvsp[-1].x), (yyvsp[-3].s));
   }
#line 8899 "obj/conf/cf-parse.tab.c"
    break;

  case 326: /* static_attr: GW  */
#line 900 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_IP,         SA_GW,	0); }
#line 8905 "obj/conf/cf-parse.tab.c"
    break;

  case 327: /* static_attr: NET  */
#line 901 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_NET,	  SA_NET,	1); }
#line 8911 "obj/conf/cf-parse.tab.c"
    break;

  case 328: /* static_attr: PROTO  */
#line 902 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_STRING,     SA_PROTO,	1); }
#line 8917 "obj/conf/cf-parse.tab.c"
    break;

  case 329: /* static_attr: DEST  */
#line 903 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_ENUM_RTD,   SA_DEST,	0); }
#line 8923 "obj/conf/cf-parse.tab.c"
    break;

  case 330: /* static_attr: IFNAME  */
#line 904 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_STRING,     SA_IFNAME,	0); }
#line 8929 "obj/conf/cf-parse.tab.c"
    break;

  case 331: /* static_attr: IFINDEX  */
#line 905 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_INT,        SA_IFINDEX,	1); }
#line 8935 "obj/conf/cf-parse.tab.c"
    break;

  case 332: /* static_attr: WEIGHT  */
#line 906 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_INT,        SA_WEIGHT,	0); }
#line 8941 "obj/conf/cf-parse.tab.c"
    break;

  case 333: /* static_attr: GW_MPLS  */
#line 907 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_INT,        SA_GW_MPLS,	0); }
#line 8947 "obj/conf/cf-parse.tab.c"
    break;

  case 334: /* static_attr: ONLINK  */
#line 908 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_BOOL,       SA_ONLINK,    0); }
#line 8953 "obj/conf/cf-parse.tab.c"
    break;

  case 335: /* $@7: %empty  */
#line 911 "filter/config.Y"
                          { f_method_call_start((yyvsp[-1].x)); }
#line 8959 "obj/conf/cf-parse.tab.c"
    break;

  case 336: /* term_dot_method: term '.' $@7 method_name_cont  */
#line 911 "filter/config.Y"
                                                                        { f_method_call_end(); (yyval.x) = (yyvsp[0].x); }
#line 8965 "obj/conf/cf-parse.tab.c"
    break;

  case 337: /* method_name_cont: CF_SYM_METHOD_BARE  */
#line 913 "filter/config.Y"
                      {
     (yyval.x) = f_dispatch_method((yyvsp[0].s), FM.object, NULL, 1);
   }
#line 8973 "obj/conf/cf-parse.tab.c"
    break;

  case 338: /* $@8: %empty  */
#line 916 "filter/config.Y"
                      {
     f_method_call_args();
   }
#line 8981 "obj/conf/cf-parse.tab.c"
    break;

  case 339: /* method_name_cont: CF_SYM_METHOD_ARGS $@8 '(' var_list ')'  */
#line 918 "filter/config.Y"
                      {
     (yyval.x) = f_dispatch_method((yyvsp[-4].s), FM.object, (yyvsp[-1].x), 1);
   }
#line 8989 "obj/conf/cf-parse.tab.c"
    break;

  case 340: /* method_name_cont: static_attr  */
#line 921 "filter/config.Y"
               {
     if (FM.object->type != T_ROUTE)
       cf_error("Getting a route attribute from %s, need a route", f_type_name(FM.object->type));
     (yyval.x) = f_new_inst(FI_RTA_GET, FM.object, (yyvsp[0].fsa));
   }
#line 8999 "obj/conf/cf-parse.tab.c"
    break;

  case 341: /* method_name_cont: CF_SYM_KNOWN  */
#line 926 "filter/config.Y"
                {
     if ((yyvsp[0].s)->class != SYM_ATTRIBUTE)
       cf_error("Not a method of %s: %s", f_type_name(FM.object->type), (yyvsp[0].s)->name);
     if (FM.object->type != T_ROUTE)
       cf_error("Getting a route attribute from %s, need a route", f_type_name(FM.object->type));
     (yyval.x) = f_new_inst(FI_EA_GET, FM.object, (yyvsp[0].s)->attribute);
   }
#line 9011 "obj/conf/cf-parse.tab.c"
    break;

  case 342: /* term: '(' term ')'  */
#line 936 "filter/config.Y"
                        { (yyval.x) = (yyvsp[-1].x); }
#line 9017 "obj/conf/cf-parse.tab.c"
    break;

  case 343: /* term: term '+' term  */
#line 937 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_ADD, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9023 "obj/conf/cf-parse.tab.c"
    break;

  case 344: /* term: term '-' term  */
#line 938 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_SUBTRACT, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9029 "obj/conf/cf-parse.tab.c"
    break;

  case 345: /* term: term '*' term  */
#line 939 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_MULTIPLY, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9035 "obj/conf/cf-parse.tab.c"
    break;

  case 346: /* term: term '/' term  */
#line 940 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_DIVIDE, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9041 "obj/conf/cf-parse.tab.c"
    break;

  case 347: /* term: term '&' term  */
#line 941 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_BITAND, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9047 "obj/conf/cf-parse.tab.c"
    break;

  case 348: /* term: term '|' term  */
#line 942 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_BITOR, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9053 "obj/conf/cf-parse.tab.c"
    break;

  case 349: /* term: term AND term  */
#line 943 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_AND, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9059 "obj/conf/cf-parse.tab.c"
    break;

  case 350: /* term: term OR term  */
#line 944 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_OR, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9065 "obj/conf/cf-parse.tab.c"
    break;

  case 351: /* term: term '=' term  */
#line 945 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_EQ, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9071 "obj/conf/cf-parse.tab.c"
    break;

  case 352: /* term: term NEQ term  */
#line 946 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_NEQ, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9077 "obj/conf/cf-parse.tab.c"
    break;

  case 353: /* term: term '<' term  */
#line 947 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LT, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9083 "obj/conf/cf-parse.tab.c"
    break;

  case 354: /* term: term LEQ term  */
#line 948 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LTE, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9089 "obj/conf/cf-parse.tab.c"
    break;

  case 355: /* term: term '>' term  */
#line 949 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LT, (yyvsp[0].x), (yyvsp[-2].x)); }
#line 9095 "obj/conf/cf-parse.tab.c"
    break;

  case 356: /* term: term GEQ term  */
#line 950 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LTE, (yyvsp[0].x), (yyvsp[-2].x)); }
#line 9101 "obj/conf/cf-parse.tab.c"
    break;

  case 357: /* term: term '~' term  */
#line 951 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_MATCH, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9107 "obj/conf/cf-parse.tab.c"
    break;

  case 358: /* term: term NMA term  */
#line 952 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_NOT_MATCH, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9113 "obj/conf/cf-parse.tab.c"
    break;

  case 359: /* term: '!' term  */
#line 953 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_NOT, (yyvsp[0].x)); }
#line 9119 "obj/conf/cf-parse.tab.c"
    break;

  case 360: /* term: DEFINED '(' term ')'  */
#line 954 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_DEFINED, (yyvsp[-1].x)); }
#line 9125 "obj/conf/cf-parse.tab.c"
    break;

  case 361: /* term: constant  */
#line 956 "filter/config.Y"
            { (yyval.x) = (yyvsp[0].x); }
#line 9131 "obj/conf/cf-parse.tab.c"
    break;

  case 362: /* term: constructor  */
#line 957 "filter/config.Y"
               { (yyval.x) = (yyvsp[0].x); }
#line 9137 "obj/conf/cf-parse.tab.c"
    break;

  case 363: /* term: lvalue  */
#line 959 "filter/config.Y"
          { (yyval.x) = f_lval_getter(&(yyvsp[0].flv)); }
#line 9143 "obj/conf/cf-parse.tab.c"
    break;

  case 365: /* term: '+' EMPTY '+'  */
#line 963 "filter/config.Y"
                 { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_PATH)); }
#line 9149 "obj/conf/cf-parse.tab.c"
    break;

  case 366: /* term: '-' EMPTY '-'  */
#line 964 "filter/config.Y"
                 { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_CLIST)); }
#line 9155 "obj/conf/cf-parse.tab.c"
    break;

  case 367: /* term: '-' '-' EMPTY '-' '-'  */
#line 965 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_ECLIST)); }
#line 9161 "obj/conf/cf-parse.tab.c"
    break;

  case 368: /* term: '-' '-' '-' EMPTY '-' '-' '-'  */
#line 966 "filter/config.Y"
                                 { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_LCLIST)); }
#line 9167 "obj/conf/cf-parse.tab.c"
    break;

  case 369: /* term: PREPEND '(' term ',' term ')'  */
#line 968 "filter/config.Y"
                                 { (yyval.x) = f_dispatch_method_x("prepend", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 9173 "obj/conf/cf-parse.tab.c"
    break;

  case 370: /* term: APPEND '(' term ',' term ')'  */
#line 969 "filter/config.Y"
                                { (yyval.x) = f_dispatch_method_x("append", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 9179 "obj/conf/cf-parse.tab.c"
    break;

  case 371: /* term: ADD '(' term ',' term ')'  */
#line 970 "filter/config.Y"
                             { (yyval.x) = f_dispatch_method_x("add", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 9185 "obj/conf/cf-parse.tab.c"
    break;

  case 372: /* term: DELETE '(' term ',' term ')'  */
#line 971 "filter/config.Y"
                                { (yyval.x) = f_dispatch_method_x("delete", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 9191 "obj/conf/cf-parse.tab.c"
    break;

  case 373: /* term: FILTER '(' term ',' term ')'  */
#line 972 "filter/config.Y"
                                { (yyval.x) = f_dispatch_method_x("filter", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 9197 "obj/conf/cf-parse.tab.c"
    break;

  case 374: /* term: term PP term  */
#line 974 "filter/config.Y"
                { (yyval.x) = f_dispatch_method_x("append", (yyvsp[-2].x)->type, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 9203 "obj/conf/cf-parse.tab.c"
    break;

  case 375: /* term: ROA_CHECK '(' rtable ')'  */
#line 976 "filter/config.Y"
                            { (yyval.x) = f_implicit_roa_check((yyvsp[-1].r)); }
#line 9209 "obj/conf/cf-parse.tab.c"
    break;

  case 376: /* term: ROA_CHECK '(' rtable ',' term ',' term ')'  */
#line 977 "filter/config.Y"
                                              { (yyval.x) = f_new_inst(FI_ROA_CHECK, (yyvsp[-3].x), (yyvsp[-1].x), (yyvsp[-5].r)); }
#line 9215 "obj/conf/cf-parse.tab.c"
    break;

  case 377: /* term: ASPA_CHECK '(' rtable ',' term ',' term ')'  */
#line 978 "filter/config.Y"
                                               { (yyval.x) = f_new_inst(FI_ASPA_CHECK_EXPLICIT, (yyvsp[-3].x), (yyvsp[-1].x), (yyvsp[-5].r)); }
#line 9221 "obj/conf/cf-parse.tab.c"
    break;

  case 378: /* term: FORMAT '(' term ')'  */
#line 980 "filter/config.Y"
                       {  (yyval.x) = f_new_inst(FI_FORMAT, (yyvsp[-1].x)); }
#line 9227 "obj/conf/cf-parse.tab.c"
    break;

  case 381: /* term_bs: FROM_HEX '(' term ')'  */
#line 987 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_FROM_HEX, (yyvsp[-1].x)); }
#line 9233 "obj/conf/cf-parse.tab.c"
    break;

  case 382: /* break_command: ACCEPT  */
#line 991 "filter/config.Y"
          { (yyval.fret) = F_ACCEPT; }
#line 9239 "obj/conf/cf-parse.tab.c"
    break;

  case 383: /* break_command: REJECT  */
#line 992 "filter/config.Y"
          { (yyval.fret) = F_REJECT; }
#line 9245 "obj/conf/cf-parse.tab.c"
    break;

  case 384: /* break_command: ERROR  */
#line 993 "filter/config.Y"
         { (yyval.fret) = F_ERROR; }
#line 9251 "obj/conf/cf-parse.tab.c"
    break;

  case 385: /* var: type symbol '=' term ';'  */
#line 997 "filter/config.Y"
                            {
     struct symbol *sym = cf_define_symbol(new_config, (yyvsp[-3].s), SYM_VARIABLE | (yyvsp[-4].i), offset, f_new_var(sym_->scope));
     (yyval.x) = f_new_inst(FI_VAR_INIT, (yyvsp[-1].x), sym);
   }
#line 9260 "obj/conf/cf-parse.tab.c"
    break;

  case 386: /* var: type symbol ';'  */
#line 1001 "filter/config.Y"
                   {
     struct symbol *sym = cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, f_new_var(sym_->scope));
     (yyval.x) = f_new_inst(FI_VAR_INIT0, sym);
   }
#line 9269 "obj/conf/cf-parse.tab.c"
    break;

  case 387: /* for_var: type symbol  */
#line 1008 "filter/config.Y"
               { (yyval.s) = cf_define_symbol(new_config, (yyvsp[0].s), SYM_VARIABLE | (yyvsp[-1].i), offset, f_new_var(sym_->scope)); }
#line 9275 "obj/conf/cf-parse.tab.c"
    break;

  case 388: /* for_var: CF_SYM_KNOWN  */
#line 1009 "filter/config.Y"
                { cf_error("Use of a pre-defined variable in for loop is not allowed"); }
#line 9281 "obj/conf/cf-parse.tab.c"
    break;

  case 389: /* $@9: %empty  */
#line 1013 "filter/config.Y"
       { cf_push_soft_scope(new_config); }
#line 9287 "obj/conf/cf-parse.tab.c"
    break;

  case 390: /* $@10: %empty  */
#line 1013 "filter/config.Y"
                                                { cf_pop_soft_scope(new_config); }
#line 9293 "obj/conf/cf-parse.tab.c"
    break;

  case 391: /* cmd: '{' $@9 cmds $@10 '}'  */
#line 1013 "filter/config.Y"
                                                                                       { (yyval.x) = (yyvsp[-2].x); }
#line 9299 "obj/conf/cf-parse.tab.c"
    break;

  case 392: /* cmd: IF term THEN cmd  */
#line 1014 "filter/config.Y"
                    {
     (yyval.x) = f_new_inst(FI_CONDITION, (yyvsp[-2].x), (yyvsp[0].x), NULL);
   }
#line 9307 "obj/conf/cf-parse.tab.c"
    break;

  case 393: /* cmd: IF term THEN cmd ELSE cmd  */
#line 1017 "filter/config.Y"
                             {
     (yyval.x) = f_new_inst(FI_CONDITION, (yyvsp[-4].x), (yyvsp[-2].x), (yyvsp[0].x));
   }
#line 9315 "obj/conf/cf-parse.tab.c"
    break;

  case 394: /* $@11: %empty  */
#line 1020 "filter/config.Y"
       {
     /* Reserve space for walk data on stack */
     cf_push_block_scope(new_config);
     new_config->current_scope->slots += 2;
   }
#line 9325 "obj/conf/cf-parse.tab.c"
    break;

  case 395: /* $@12: %empty  */
#line 1026 "filter/config.Y"
   { this_for_scope = new_config->current_scope; new_config->current_scope = this_for_scope->next; }
#line 9331 "obj/conf/cf-parse.tab.c"
    break;

  case 396: /* $@13: %empty  */
#line 1028 "filter/config.Y"
   { new_config->current_scope = this_for_scope; this_for_scope = NULL; }
#line 9337 "obj/conf/cf-parse.tab.c"
    break;

  case 397: /* cmd: FOR $@11 for_var IN $@12 term $@13 DO cmd  */
#line 1029 "filter/config.Y"
          {
     cf_pop_block_scope(new_config);
     (yyval.x) = f_for_cycle((yyvsp[-6].s), (yyvsp[-3].x), (yyvsp[0].x));
   }
#line 9346 "obj/conf/cf-parse.tab.c"
    break;

  case 398: /* cmd: lvalue '=' term ';'  */
#line 1033 "filter/config.Y"
                       {
     (yyval.x) = f_lval_setter(&(yyvsp[-3].flv), (yyvsp[-1].x));
   }
#line 9354 "obj/conf/cf-parse.tab.c"
    break;

  case 399: /* cmd: RETURN term ';'  */
#line 1036 "filter/config.Y"
                   {
     DBG( "Ook, we'll return the value\n" );
     if (!this_function)
       cf_error("Can't return from a non-function, use accept or reject instead.");
     if (this_function->function->return_type == T_VOID)
     {
       if ((yyvsp[-1].x)->type != T_VOID)
	 cf_warn("Inferring function %s return type from its return value: %s", this_function->name, f_type_name((yyvsp[-1].x)->type));
       ((struct f_line *) this_function->function)->return_type = (yyvsp[-1].x)->type;
     }
     else if (this_function->function->return_type != (yyvsp[-1].x)->type)
       cf_error("Can't return type %s from function %s, expected %s",
		f_type_name((yyvsp[-1].x)->type), this_function->name, f_type_name(this_function->function->return_type));

     (yyval.x) = f_new_inst(FI_RETURN, (yyvsp[-1].x));
   }
#line 9375 "obj/conf/cf-parse.tab.c"
    break;

  case 400: /* cmd: UNSET '(' CF_SYM_KNOWN ')' ';'  */
#line 1052 "filter/config.Y"
                                  {
     if ((yyvsp[-2].s)->class != SYM_ATTRIBUTE)
       cf_error("Can't unset %s", (yyvsp[-2].s)->name);
     if ((yyvsp[-2].s)->attribute->readonly)
       cf_error("Attribute %s is read-only", (yyvsp[-2].s)->attribute->name);
     (yyval.x) = f_new_inst(FI_EA_UNSET, (yyvsp[-2].s)->attribute);
   }
#line 9387 "obj/conf/cf-parse.tab.c"
    break;

  case 401: /* cmd: break_command var_list_r ';'  */
#line 1059 "filter/config.Y"
                                {
    (yyval.x) = f_print((yyvsp[-1].x), !!(yyvsp[-1].x), (yyvsp[-2].fret));
   }
#line 9395 "obj/conf/cf-parse.tab.c"
    break;

  case 402: /* cmd: PRINT var_list_r ';'  */
#line 1062 "filter/config.Y"
                        {
    (yyval.x) = f_print((yyvsp[-1].x), 1, F_NOP);
   }
#line 9403 "obj/conf/cf-parse.tab.c"
    break;

  case 403: /* cmd: PRINTN var_list_r ';'  */
#line 1065 "filter/config.Y"
                         {
    (yyval.x) = f_print((yyvsp[-1].x), 0, F_NOP);
   }
#line 9411 "obj/conf/cf-parse.tab.c"
    break;

  case 404: /* cmd: function_call ';'  */
#line 1068 "filter/config.Y"
                     { (yyval.x) = f_new_inst(FI_DROP_RESULT, (yyvsp[-1].x)); }
#line 9417 "obj/conf/cf-parse.tab.c"
    break;

  case 405: /* cmd: CASE term '{' switch_body '}'  */
#line 1069 "filter/config.Y"
                                 {
      (yyval.x) = f_new_inst(FI_SWITCH, (yyvsp[-3].x), (yyvsp[-1].e));
   }
#line 9425 "obj/conf/cf-parse.tab.c"
    break;

  case 406: /* $@14: %empty  */
#line 1072 "filter/config.Y"
              {
     f_method_call_start(f_lval_getter(&(yyvsp[-1].flv)));
   }
#line 9433 "obj/conf/cf-parse.tab.c"
    break;

  case 407: /* cmd: lvalue '.' $@14 method_name_cont ';'  */
#line 1074 "filter/config.Y"
                          {
     f_method_call_end();
     (yyval.x) = f_lval_setter(&(yyvsp[-4].flv), (yyvsp[-1].x));
   }
#line 9442 "obj/conf/cf-parse.tab.c"
    break;

  case 408: /* cmd: BT_ASSERT '(' get_cf_position term get_cf_position ')' ';'  */
#line 1078 "filter/config.Y"
                                                              { (yyval.x) = assert_done((yyvsp[-3].x), (yyvsp[-4].t) + 1, (yyvsp[-2].t) - 1); }
#line 9448 "obj/conf/cf-parse.tab.c"
    break;

  case 409: /* cmd: BT_CHECK_ASSIGN '(' get_cf_position lvalue get_cf_position ',' term ')' ';'  */
#line 1079 "filter/config.Y"
                                                                               { (yyval.x) = assert_assign(&(yyvsp[-5].flv), (yyvsp[-2].x), (yyvsp[-6].t) + 1, (yyvsp[-4].t) - 1); }
#line 9454 "obj/conf/cf-parse.tab.c"
    break;

  case 410: /* get_cf_position: %empty  */
#line 1083 "filter/config.Y"
{
  (yyval.t) = cf_text;
}
#line 9462 "obj/conf/cf-parse.tab.c"
    break;

  case 411: /* lvalue: CF_SYM_KNOWN  */
#line 1088 "filter/config.Y"
                {
     switch ((yyvsp[0].s)->class)
     {
       case SYM_CONSTANT_RANGE:
	 (yyval.flv) = (struct f_lval) { .type = F_LVAL_CONSTANT, .sym = (yyvsp[0].s), };
	 break;
       case SYM_VARIABLE_RANGE:
	 (yyval.flv) = (struct f_lval) { .type = F_LVAL_VARIABLE, .sym = (yyvsp[0].s), };
         break;
       case SYM_ATTRIBUTE:
         (yyval.flv) = (struct f_lval) { .type = F_LVAL_EA, .da = (yyvsp[0].s)->attribute, .rte = f_new_inst(FI_CURRENT_ROUTE), };
	 break;
       default:
	 cf_error("Variable name or attribute name required");
     }
   }
#line 9483 "obj/conf/cf-parse.tab.c"
    break;

  case 412: /* lvalue: static_attr  */
#line 1104 "filter/config.Y"
               { (yyval.flv) = (struct f_lval) { .type = F_LVAL_SA, .sa = (yyvsp[0].fsa), .rte = f_new_inst(FI_CURRENT_ROUTE), }; }
#line 9489 "obj/conf/cf-parse.tab.c"
    break;

  case 414: /* rtrid: ROUTER ID idval ';'  */
#line 208 "nest/config.Y"
                       { new_config->router_id = (yyvsp[-1].i32); }
#line 9495 "obj/conf/cf-parse.tab.c"
    break;

  case 415: /* rtrid: ROUTER ID FROM iface_patt ';'  */
#line 209 "nest/config.Y"
                                 { new_config->router_id_from = this_ipatt; }
#line 9501 "obj/conf/cf-parse.tab.c"
    break;

  case 417: /* hostname_override: HOSTNAME text ';'  */
#line 214 "nest/config.Y"
                                     { new_config->hostname = (yyvsp[-1].t); }
#line 9507 "obj/conf/cf-parse.tab.c"
    break;

  case 419: /* gr_opts: GRACEFUL RESTART WAIT expr ';'  */
#line 218 "nest/config.Y"
                                        { new_config->gr_wait = (yyvsp[-1].i); }
#line 9513 "obj/conf/cf-parse.tab.c"
    break;

  case 420: /* net_type_base: IPV4  */
#line 224 "nest/config.Y"
        { (yyval.i) = NET_IP4; }
#line 9519 "obj/conf/cf-parse.tab.c"
    break;

  case 421: /* net_type_base: IPV6  */
#line 225 "nest/config.Y"
        { (yyval.i) = NET_IP6; }
#line 9525 "obj/conf/cf-parse.tab.c"
    break;

  case 422: /* net_type_base: IPV6 SADR  */
#line 226 "nest/config.Y"
             { (yyval.i) = NET_IP6_SADR; }
#line 9531 "obj/conf/cf-parse.tab.c"
    break;

  case 423: /* net_type_base: VPN4  */
#line 227 "nest/config.Y"
        { (yyval.i) = NET_VPN4; }
#line 9537 "obj/conf/cf-parse.tab.c"
    break;

  case 424: /* net_type_base: VPN6  */
#line 228 "nest/config.Y"
        { (yyval.i) = NET_VPN6; }
#line 9543 "obj/conf/cf-parse.tab.c"
    break;

  case 425: /* net_type_base: ROA4  */
#line 229 "nest/config.Y"
        { (yyval.i) = NET_ROA4; }
#line 9549 "obj/conf/cf-parse.tab.c"
    break;

  case 426: /* net_type_base: ROA6  */
#line 230 "nest/config.Y"
        { (yyval.i) = NET_ROA6; }
#line 9555 "obj/conf/cf-parse.tab.c"
    break;

  case 427: /* net_type_base: FLOW4  */
#line 231 "nest/config.Y"
        { (yyval.i) = NET_FLOW4; }
#line 9561 "obj/conf/cf-parse.tab.c"
    break;

  case 428: /* net_type_base: FLOW6  */
#line 232 "nest/config.Y"
        { (yyval.i) = NET_FLOW6; }
#line 9567 "obj/conf/cf-parse.tab.c"
    break;

  case 429: /* net_type_base: ASPA  */
#line 233 "nest/config.Y"
        { (yyval.i) = NET_ASPA; }
#line 9573 "obj/conf/cf-parse.tab.c"
    break;

  case 431: /* net_type: MPLS  */
#line 238 "nest/config.Y"
        { (yyval.i) = NET_MPLS; }
#line 9579 "obj/conf/cf-parse.tab.c"
    break;

  case 434: /* table_start: net_type TABLE symbol  */
#line 248 "nest/config.Y"
                                   {
   this_table = rt_new_table((yyvsp[0].s), (yyvsp[-2].i));
   }
#line 9587 "obj/conf/cf-parse.tab.c"
    break;

  case 436: /* table_sorted: SORTED  */
#line 255 "nest/config.Y"
          { this_table->sorted = 1; }
#line 9593 "obj/conf/cf-parse.tab.c"
    break;

  case 437: /* table_opt: SORTED bool  */
#line 259 "nest/config.Y"
               { this_table->sorted = (yyvsp[0].i); }
#line 9599 "obj/conf/cf-parse.tab.c"
    break;

  case 438: /* table_opt: DEBUG debug_mask  */
#line 260 "nest/config.Y"
                    { this_table->debug = (yyvsp[0].i); }
#line 9605 "obj/conf/cf-parse.tab.c"
    break;

  case 439: /* table_opt: TRIE bool  */
#line 261 "nest/config.Y"
             {
     if (!net_val_match(this_table->addr_type, NB_IP | NB_VPN | NB_ROA | NB_IP6_SADR))
       cf_error("Trie option not supported for %s table", net_label[this_table->addr_type]);
     this_table->trie_used = (yyvsp[0].i);
   }
#line 9615 "obj/conf/cf-parse.tab.c"
    break;

  case 440: /* table_opt: GC THRESHOLD expr  */
#line 266 "nest/config.Y"
                     { this_table->gc_threshold = (yyvsp[0].i); }
#line 9621 "obj/conf/cf-parse.tab.c"
    break;

  case 441: /* table_opt: GC PERIOD expr_us  */
#line 267 "nest/config.Y"
                     { this_table->gc_period = (uint) (yyvsp[0].time); if ((yyvsp[0].time) > 3600 S_) cf_error("GC period must be at most 3600 s"); }
#line 9627 "obj/conf/cf-parse.tab.c"
    break;

  case 442: /* table_opt: CORK THRESHOLD expr expr  */
#line 268 "nest/config.Y"
                            {
     if ((yyvsp[-1].i) > (yyvsp[0].i)) cf_error("Cork low threshold must be lower than the high threshold.");
     this_table->cork_threshold.low = (yyvsp[-1].i);
     this_table->cork_threshold.high = (yyvsp[0].i); }
#line 9636 "obj/conf/cf-parse.tab.c"
    break;

  case 443: /* table_opt: EXPORT SETTLE TIME settle  */
#line 272 "nest/config.Y"
                             { this_table->export_settle = (yyvsp[0].settle); }
#line 9642 "obj/conf/cf-parse.tab.c"
    break;

  case 444: /* table_opt: ROUTE REFRESH EXPORT SETTLE TIME settle  */
#line 273 "nest/config.Y"
                                           { this_table->export_rr_settle = (yyvsp[0].settle); }
#line 9648 "obj/conf/cf-parse.tab.c"
    break;

  case 445: /* table_opt: DIGEST SETTLE TIME settle  */
#line 274 "nest/config.Y"
                             { this_table->digest_settle = (yyvsp[0].settle); }
#line 9654 "obj/conf/cf-parse.tab.c"
    break;

  case 446: /* table_opt: THREAD GROUP symbol  */
#line 275 "nest/config.Y"
                       {
    if ((yyvsp[0].s)->class != SYM_THREAD_GROUP)
      cf_error("Unexpected symbol %s as a thread group name", (yyvsp[0].s)->name);
    this_table->thread_group = (yyvsp[0].s)->thread_group;
 }
#line 9664 "obj/conf/cf-parse.tab.c"
    break;

  case 451: /* conf: proto  */
#line 295 "nest/config.Y"
            { proto_postconfig(); }
#line 9670 "obj/conf/cf-parse.tab.c"
    break;

  case 452: /* proto_start: PROTOCOL  */
#line 298 "nest/config.Y"
            { (yyval.i) = SYM_PROTO; }
#line 9676 "obj/conf/cf-parse.tab.c"
    break;

  case 453: /* proto_start: TEMPLATE  */
#line 299 "nest/config.Y"
            { (yyval.i) = SYM_TEMPLATE; }
#line 9682 "obj/conf/cf-parse.tab.c"
    break;

  case 454: /* proto_name: %empty  */
#line 303 "nest/config.Y"
               {
     struct symbol *s = cf_default_name(new_config, this_proto->protocol->template, &this_proto->protocol->name_counter);
     s->class = this_proto->class;
     s->proto = this_proto;
     this_proto->name = s->name;
     }
#line 9693 "obj/conf/cf-parse.tab.c"
    break;

  case 455: /* proto_name: symbol  */
#line 309 "nest/config.Y"
          {
     cf_define_symbol(new_config, (yyvsp[0].s), this_proto->class, proto, this_proto);
     this_proto->name = (yyvsp[0].s)->name;
   }
#line 9702 "obj/conf/cf-parse.tab.c"
    break;

  case 456: /* proto_name: FROM CF_SYM_KNOWN  */
#line 313 "nest/config.Y"
                     {
     if (((yyvsp[0].s)->class != SYM_TEMPLATE) && ((yyvsp[0].s)->class != SYM_PROTO)) cf_error("Template or protocol name expected");

     struct symbol *s = cf_default_name(new_config, this_proto->protocol->template, &this_proto->protocol->name_counter);
     s->class = this_proto->class;
     s->proto = this_proto;
     this_proto->name = s->name;

     proto_copy_config(this_proto, (yyvsp[0].s)->proto);
   }
#line 9717 "obj/conf/cf-parse.tab.c"
    break;

  case 457: /* proto_name: symbol FROM CF_SYM_KNOWN  */
#line 323 "nest/config.Y"
                            {
     if (((yyvsp[0].s)->class != SYM_TEMPLATE) && ((yyvsp[0].s)->class != SYM_PROTO)) cf_error("Template or protocol name expected");

     cf_define_symbol(new_config, (yyvsp[-2].s), this_proto->class, proto, this_proto);
     this_proto->name = (yyvsp[-2].s)->name;

     proto_copy_config(this_proto, (yyvsp[0].s)->proto);
   }
#line 9730 "obj/conf/cf-parse.tab.c"
    break;

  case 459: /* proto_item: DISABLED bool  */
#line 335 "nest/config.Y"
                 { this_proto->disabled = (yyvsp[0].i); }
#line 9736 "obj/conf/cf-parse.tab.c"
    break;

  case 460: /* proto_item: RESTART TIME expr_us  */
#line 336 "nest/config.Y"
                        { this_proto->restart_limit = (yyvsp[0].time); }
#line 9742 "obj/conf/cf-parse.tab.c"
    break;

  case 461: /* proto_item: DEBUG debug_mask  */
#line 337 "nest/config.Y"
                    { this_proto->debug = (yyvsp[0].i); }
#line 9748 "obj/conf/cf-parse.tab.c"
    break;

  case 462: /* proto_item: MRTDUMP mrtdump_mask  */
#line 338 "nest/config.Y"
                        { this_proto->mrtdump = (yyvsp[0].i); }
#line 9754 "obj/conf/cf-parse.tab.c"
    break;

  case 463: /* proto_item: ROUTER ID idval  */
#line 339 "nest/config.Y"
                   { this_proto->router_id = (yyvsp[0].i32); }
#line 9760 "obj/conf/cf-parse.tab.c"
    break;

  case 464: /* proto_item: HOSTNAME text  */
#line 340 "nest/config.Y"
                 { this_proto->hostname = (yyvsp[0].t); }
#line 9766 "obj/conf/cf-parse.tab.c"
    break;

  case 465: /* proto_item: DESCRIPTION text  */
#line 341 "nest/config.Y"
                    { this_proto->dsc = (yyvsp[0].t); }
#line 9772 "obj/conf/cf-parse.tab.c"
    break;

  case 466: /* proto_item: VRF text  */
#line 342 "nest/config.Y"
            { this_proto->vrf = if_get_by_name((yyvsp[0].t)); }
#line 9778 "obj/conf/cf-parse.tab.c"
    break;

  case 467: /* proto_item: VRF DEFAULT  */
#line 343 "nest/config.Y"
               { this_proto->vrf = &default_vrf; }
#line 9784 "obj/conf/cf-parse.tab.c"
    break;

  case 468: /* proto_item: THREAD GROUP symbol  */
#line 344 "nest/config.Y"
                       {
    if ((yyvsp[0].s)->class != SYM_THREAD_GROUP)
      cf_error("Unexpected symbol %s as a thread group name", (yyvsp[0].s)->name);
    this_proto->thread_group = (yyvsp[0].s)->thread_group;
 }
#line 9794 "obj/conf/cf-parse.tab.c"
    break;

  case 469: /* channel_start: net_type_base  */
#line 353 "nest/config.Y"
{
  (yyval.cc) = this_channel = channel_config_get(NULL, net_label[(yyvsp[0].i)], (yyvsp[0].i), this_proto);
}
#line 9802 "obj/conf/cf-parse.tab.c"
    break;

  case 470: /* channel_item_: TABLE rtable  */
#line 358 "nest/config.Y"
                {
     if (this_channel->net_type && ((yyvsp[0].r)->addr_type != this_channel->net_type))
       cf_error("Incompatible table type");
     this_channel->table = (yyvsp[0].r);
   }
#line 9812 "obj/conf/cf-parse.tab.c"
    break;

  case 471: /* channel_item_: IMPORT imexport  */
#line 363 "nest/config.Y"
                   { this_channel->in_filter = (yyvsp[0].f); }
#line 9818 "obj/conf/cf-parse.tab.c"
    break;

  case 472: /* channel_item_: EXPORT IN net_any imexport  */
#line 364 "nest/config.Y"
                              {
     if (this_channel->net_type && ((yyvsp[-1].net_ptr)->type != this_channel->net_type))
       cf_error("Incompatible export prefilter type");
     this_channel->out_subprefix = (yyvsp[-1].net_ptr);
     this_channel->out_filter = (yyvsp[0].f);
   }
#line 9829 "obj/conf/cf-parse.tab.c"
    break;

  case 473: /* channel_item_: EXPORT imexport  */
#line 370 "nest/config.Y"
                   { this_channel->out_filter = (yyvsp[0].f); }
#line 9835 "obj/conf/cf-parse.tab.c"
    break;

  case 474: /* channel_item_: RECEIVE LIMIT limit_spec  */
#line 371 "nest/config.Y"
                            { this_channel->rx_limit = (yyvsp[0].cl); }
#line 9841 "obj/conf/cf-parse.tab.c"
    break;

  case 475: /* channel_item_: IMPORT LIMIT limit_spec  */
#line 372 "nest/config.Y"
                           { this_channel->in_limit = (yyvsp[0].cl); }
#line 9847 "obj/conf/cf-parse.tab.c"
    break;

  case 476: /* channel_item_: EXPORT LIMIT limit_spec  */
#line 373 "nest/config.Y"
                           { this_channel->out_limit = (yyvsp[0].cl); }
#line 9853 "obj/conf/cf-parse.tab.c"
    break;

  case 477: /* channel_item_: PREFERENCE expr  */
#line 374 "nest/config.Y"
                   { this_channel->preference = (yyvsp[0].i); check_u16((yyvsp[0].i)); }
#line 9859 "obj/conf/cf-parse.tab.c"
    break;

  case 478: /* channel_item_: IMPORT KEEP FILTERED bool  */
#line 375 "nest/config.Y"
                             {
     if ((yyvsp[0].i))
       this_channel->in_keep |= RIK_REJECTED;
     else if ((this_channel->in_keep & RIK_PREFILTER) == RIK_PREFILTER)
       cf_error("Import keep filtered is implied by the import table.");
     else
       this_channel->in_keep &= ~RIK_REJECTED;
   }
#line 9872 "obj/conf/cf-parse.tab.c"
    break;

  case 479: /* channel_item_: RPKI RELOAD bool  */
#line 383 "nest/config.Y"
                    { this_channel->rpki_reload = (yyvsp[0].i); }
#line 9878 "obj/conf/cf-parse.tab.c"
    break;

  case 481: /* channel_item: DEBUG debug_mask  */
#line 389 "nest/config.Y"
                    { this_channel->debug = (yyvsp[0].i); }
#line 9884 "obj/conf/cf-parse.tab.c"
    break;

  case 486: /* channel_end: %empty  */
#line 403 "nest/config.Y"
{
  if (!this_channel->table)
    cf_error("Routing table not specified");

  this_channel = NULL;
}
#line 9895 "obj/conf/cf-parse.tab.c"
    break;

  case 488: /* rtable: CF_SYM_KNOWN  */
#line 413 "nest/config.Y"
                     {
  cf_assert_symbol((yyvsp[0].s), SYM_TABLE);
  if (!(yyvsp[0].s)->table) rt_new_default_table((yyvsp[0].s));
  (yyval.r) = (yyvsp[0].s)->table;
}
#line 9905 "obj/conf/cf-parse.tab.c"
    break;

  case 489: /* imexport: FILTER filter  */
#line 420 "nest/config.Y"
                 { (yyval.f) = (yyvsp[0].f); }
#line 9911 "obj/conf/cf-parse.tab.c"
    break;

  case 491: /* imexport: ALL  */
#line 422 "nest/config.Y"
       { (yyval.f) = FILTER_ACCEPT; }
#line 9917 "obj/conf/cf-parse.tab.c"
    break;

  case 492: /* imexport: NONE  */
#line 423 "nest/config.Y"
        { (yyval.f) = FILTER_REJECT; }
#line 9923 "obj/conf/cf-parse.tab.c"
    break;

  case 493: /* limit_action: %empty  */
#line 427 "nest/config.Y"
                 { (yyval.i) = PLA_DISABLE; }
#line 9929 "obj/conf/cf-parse.tab.c"
    break;

  case 494: /* limit_action: ACTION WARN  */
#line 428 "nest/config.Y"
               { (yyval.i) = PLA_WARN; }
#line 9935 "obj/conf/cf-parse.tab.c"
    break;

  case 495: /* limit_action: ACTION BLOCK  */
#line 429 "nest/config.Y"
                { (yyval.i) = PLA_BLOCK; }
#line 9941 "obj/conf/cf-parse.tab.c"
    break;

  case 496: /* limit_action: ACTION RESTART  */
#line 430 "nest/config.Y"
                  { (yyval.i) = PLA_RESTART; }
#line 9947 "obj/conf/cf-parse.tab.c"
    break;

  case 497: /* limit_action: ACTION DISABLE  */
#line 431 "nest/config.Y"
                  { (yyval.i) = PLA_DISABLE; }
#line 9953 "obj/conf/cf-parse.tab.c"
    break;

  case 498: /* limit_spec: expr limit_action  */
#line 435 "nest/config.Y"
                     { (yyval.cl) = (struct channel_limit){ .limit = (yyvsp[-1].i), (yyval.cl).action = (yyvsp[0].i) }; }
#line 9959 "obj/conf/cf-parse.tab.c"
    break;

  case 499: /* limit_spec: OFF  */
#line 436 "nest/config.Y"
       { (yyval.cl) = (struct channel_limit){}; }
#line 9965 "obj/conf/cf-parse.tab.c"
    break;

  case 501: /* debug_default: DEBUG PROTOCOLS debug_mask  */
#line 443 "nest/config.Y"
                              { new_config->proto_default_debug = (yyvsp[0].i); }
#line 9971 "obj/conf/cf-parse.tab.c"
    break;

  case 502: /* debug_default: DEBUG CHANNELS debug_mask  */
#line 444 "nest/config.Y"
                             { new_config->channel_default_debug = (yyvsp[0].i); }
#line 9977 "obj/conf/cf-parse.tab.c"
    break;

  case 503: /* debug_default: DEBUG TABLES debug_mask  */
#line 445 "nest/config.Y"
                           { new_config->table_default_debug = (yyvsp[0].i); }
#line 9983 "obj/conf/cf-parse.tab.c"
    break;

  case 504: /* debug_default: DEBUG COMMANDS expr  */
#line 446 "nest/config.Y"
                       { new_config->cli_debug = (yyvsp[0].i); }
#line 9989 "obj/conf/cf-parse.tab.c"
    break;

  case 505: /* debug_default: DEBUG SHOW ROUTE debug_mask  */
#line 447 "nest/config.Y"
                               { new_config->show_route_debug = (yyvsp[0].i); }
#line 9995 "obj/conf/cf-parse.tab.c"
    break;

  case 507: /* timeformat_base: TIMEFORMAT timeformat_which timeformat_spec ';'  */
#line 455 "nest/config.Y"
                                                   { *(yyvsp[-2].tfp) = (yyvsp[-1].tf); }
#line 10001 "obj/conf/cf-parse.tab.c"
    break;

  case 508: /* timeformat_which: ROUTE  */
#line 459 "nest/config.Y"
         { (yyval.tfp) = &new_config->tf_route; }
#line 10007 "obj/conf/cf-parse.tab.c"
    break;

  case 509: /* timeformat_which: PROTOCOL  */
#line 460 "nest/config.Y"
            { (yyval.tfp) = &new_config->tf_proto; }
#line 10013 "obj/conf/cf-parse.tab.c"
    break;

  case 510: /* timeformat_which: BASE  */
#line 461 "nest/config.Y"
        { (yyval.tfp) = &new_config->tf_base; }
#line 10019 "obj/conf/cf-parse.tab.c"
    break;

  case 511: /* timeformat_which: LOG  */
#line 462 "nest/config.Y"
       { (yyval.tfp) = &new_config->tf_log; }
#line 10025 "obj/conf/cf-parse.tab.c"
    break;

  case 512: /* timeformat_spec: text  */
#line 466 "nest/config.Y"
        { (yyval.tf) = (struct timeformat){(yyvsp[0].t), NULL, 0}; }
#line 10031 "obj/conf/cf-parse.tab.c"
    break;

  case 513: /* timeformat_spec: text expr text  */
#line 467 "nest/config.Y"
                  { (yyval.tf) = (struct timeformat){(yyvsp[-2].t), (yyvsp[0].t), (s64) (yyvsp[-1].i) S_}; }
#line 10037 "obj/conf/cf-parse.tab.c"
    break;

  case 514: /* timeformat_spec: ISO SHORT  */
#line 468 "nest/config.Y"
                { (yyval.tf) = TM_ISO_SHORT_S; }
#line 10043 "obj/conf/cf-parse.tab.c"
    break;

  case 515: /* timeformat_spec: ISO SHORT MS  */
#line 469 "nest/config.Y"
                { (yyval.tf) = TM_ISO_SHORT_MS; }
#line 10049 "obj/conf/cf-parse.tab.c"
    break;

  case 516: /* timeformat_spec: ISO SHORT US  */
#line 470 "nest/config.Y"
                { (yyval.tf) = TM_ISO_SHORT_US; }
#line 10055 "obj/conf/cf-parse.tab.c"
    break;

  case 517: /* timeformat_spec: ISO LONG  */
#line 471 "nest/config.Y"
                { (yyval.tf) = TM_ISO_LONG_S; }
#line 10061 "obj/conf/cf-parse.tab.c"
    break;

  case 518: /* timeformat_spec: ISO LONG MS  */
#line 472 "nest/config.Y"
                { (yyval.tf) = TM_ISO_LONG_MS; }
#line 10067 "obj/conf/cf-parse.tab.c"
    break;

  case 519: /* timeformat_spec: ISO LONG US  */
#line 473 "nest/config.Y"
                { (yyval.tf) = TM_ISO_LONG_US; }
#line 10073 "obj/conf/cf-parse.tab.c"
    break;

  case 520: /* iface_patt_node_init: %empty  */
#line 479 "nest/config.Y"
               {
     struct iface_patt_node *ipn = cfg_allocz(sizeof(struct iface_patt_node));
     add_tail(&this_ipatt->ipn_list, NODE ipn);
     this_ipn = ipn;
   }
#line 10083 "obj/conf/cf-parse.tab.c"
    break;

  case 521: /* iface_patt_node_body: TEXT  */
#line 487 "nest/config.Y"
        { this_ipn->pattern = (yyvsp[0].t); }
#line 10089 "obj/conf/cf-parse.tab.c"
    break;

  case 522: /* iface_patt_node_body: net_ip_  */
#line 488 "nest/config.Y"
           { this_ipn->prefix = (yyvsp[0].net); }
#line 10095 "obj/conf/cf-parse.tab.c"
    break;

  case 523: /* iface_patt_node_body: IP4  */
#line 489 "nest/config.Y"
       { net_fill_ip4(&(this_ipn->prefix), (yyvsp[0].ip4), IP4_MAX_PREFIX_LENGTH); }
#line 10101 "obj/conf/cf-parse.tab.c"
    break;

  case 524: /* iface_patt_node_body: IP6  */
#line 490 "nest/config.Y"
       { net_fill_ip6(&(this_ipn->prefix), (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH); }
#line 10107 "obj/conf/cf-parse.tab.c"
    break;

  case 525: /* iface_patt_node_body: conf_expr  */
#line 491 "nest/config.Y"
             {
     if ((yyvsp[0].v).type == T_STRING)
       this_ipn->pattern = (yyvsp[0].v).val.s;
     else if ((yyvsp[0].v).type == T_IP)
       net_fill_ip_host(&(this_ipn->prefix), (yyvsp[0].v).val.ip);
     else if (((yyvsp[0].v).type == T_NET) && net_is_ip((yyvsp[0].v).val.net))
       this_ipn->prefix = * (yyvsp[0].v).val.net;
     else
       cf_error("String or IP address/prefix expected");
 }
#line 10122 "obj/conf/cf-parse.tab.c"
    break;

  case 526: /* iface_patt_node_body: text net_or_ipa  */
#line 501 "nest/config.Y"
                   { this_ipn->pattern = (yyvsp[-1].t); this_ipn->prefix = (yyvsp[0].net); }
#line 10128 "obj/conf/cf-parse.tab.c"
    break;

  case 527: /* iface_negate: %empty  */
#line 505 "nest/config.Y"
       { this_ipn->positive = 1; }
#line 10134 "obj/conf/cf-parse.tab.c"
    break;

  case 528: /* iface_negate: '-'  */
#line 506 "nest/config.Y"
       { this_ipn->positive = 0; }
#line 10140 "obj/conf/cf-parse.tab.c"
    break;

  case 532: /* iface_patt_list_nopx: iface_patt_list  */
#line 520 "nest/config.Y"
                                      { iface_patt_check(); }
#line 10146 "obj/conf/cf-parse.tab.c"
    break;

  case 533: /* iface_patt_init: %empty  */
#line 522 "nest/config.Y"
                 {
   /* Generic this_ipatt init */
   this_ipatt = cfg_allocz(sizeof(struct iface_patt));
   init_list(&this_ipatt->ipn_list);
 }
#line 10156 "obj/conf/cf-parse.tab.c"
    break;

  case 535: /* tos: CLASS expr  */
#line 534 "nest/config.Y"
              { (yyval.i) = (yyvsp[0].i) & 0xfc;        if ((yyvsp[0].i) > 255) cf_error("TX class must be in range 0-255"); }
#line 10162 "obj/conf/cf-parse.tab.c"
    break;

  case 536: /* tos: DSCP expr  */
#line 535 "nest/config.Y"
              { (yyval.i) = ((yyvsp[0].i) & 0x3f) << 2; if ((yyvsp[0].i) > 63)  cf_error("TX DSCP must be in range 0-63"); }
#line 10168 "obj/conf/cf-parse.tab.c"
    break;

  case 538: /* dev_proto_start: proto_start DIRECT  */
#line 542 "nest/config.Y"
                                    {
     this_proto = proto_config_new(&proto_device, (yyvsp[-1].i));
     init_list(&DIRECT_CFG->iface_list);
     this_proto->late_if_feed = 1;
   }
#line 10178 "obj/conf/cf-parse.tab.c"
    break;

  case 543: /* dev_proto: dev_proto CHECK LINK bool ';'  */
#line 554 "nest/config.Y"
                                 { DIRECT_CFG->check_link = (yyvsp[-1].i); }
#line 10184 "obj/conf/cf-parse.tab.c"
    break;

  case 544: /* dev_iface_init: %empty  */
#line 558 "nest/config.Y"
               {
     this_ipatt = cfg_allocz(sizeof(struct iface_patt));
     add_tail(&DIRECT_CFG->iface_list, NODE this_ipatt);
     init_list(&this_ipatt->ipn_list);
   }
#line 10194 "obj/conf/cf-parse.tab.c"
    break;

  case 546: /* debug_mask: ALL  */
#line 572 "nest/config.Y"
       { (yyval.i) = ~0; }
#line 10200 "obj/conf/cf-parse.tab.c"
    break;

  case 547: /* debug_mask: OFF  */
#line 573 "nest/config.Y"
       { (yyval.i) = 0; }
#line 10206 "obj/conf/cf-parse.tab.c"
    break;

  case 548: /* debug_mask: '{' debug_list '}'  */
#line 574 "nest/config.Y"
                      { (yyval.i) = (yyvsp[-1].i); }
#line 10212 "obj/conf/cf-parse.tab.c"
    break;

  case 550: /* debug_list: debug_list ',' debug_flag  */
#line 579 "nest/config.Y"
                             { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 10218 "obj/conf/cf-parse.tab.c"
    break;

  case 551: /* debug_flag: STATES  */
#line 583 "nest/config.Y"
                { (yyval.i) = D_STATES; }
#line 10224 "obj/conf/cf-parse.tab.c"
    break;

  case 552: /* debug_flag: ROUTES  */
#line 584 "nest/config.Y"
                { (yyval.i) = D_ROUTES; }
#line 10230 "obj/conf/cf-parse.tab.c"
    break;

  case 553: /* debug_flag: FILTERS  */
#line 585 "nest/config.Y"
                { (yyval.i) = D_FILTERS; }
#line 10236 "obj/conf/cf-parse.tab.c"
    break;

  case 554: /* debug_flag: INTERFACES  */
#line 586 "nest/config.Y"
                { (yyval.i) = D_IFACES; }
#line 10242 "obj/conf/cf-parse.tab.c"
    break;

  case 555: /* debug_flag: EVENTS  */
#line 587 "nest/config.Y"
                { (yyval.i) = D_EVENTS; }
#line 10248 "obj/conf/cf-parse.tab.c"
    break;

  case 556: /* debug_flag: PACKETS  */
#line 588 "nest/config.Y"
                { (yyval.i) = D_PACKETS; }
#line 10254 "obj/conf/cf-parse.tab.c"
    break;

  case 557: /* mrtdump_mask: ALL  */
#line 594 "nest/config.Y"
       { (yyval.i) = ~0; }
#line 10260 "obj/conf/cf-parse.tab.c"
    break;

  case 558: /* mrtdump_mask: OFF  */
#line 595 "nest/config.Y"
       { (yyval.i) = 0; }
#line 10266 "obj/conf/cf-parse.tab.c"
    break;

  case 559: /* mrtdump_mask: '{' mrtdump_list '}'  */
#line 596 "nest/config.Y"
                        { (yyval.i) = (yyvsp[-1].i); }
#line 10272 "obj/conf/cf-parse.tab.c"
    break;

  case 561: /* mrtdump_list: mrtdump_list ',' mrtdump_flag  */
#line 601 "nest/config.Y"
                                 { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 10278 "obj/conf/cf-parse.tab.c"
    break;

  case 562: /* mrtdump_flag: STATES  */
#line 605 "nest/config.Y"
                { (yyval.i) = MD_STATES; }
#line 10284 "obj/conf/cf-parse.tab.c"
    break;

  case 563: /* mrtdump_flag: MESSAGES  */
#line 606 "nest/config.Y"
                { (yyval.i) = MD_MESSAGES; }
#line 10290 "obj/conf/cf-parse.tab.c"
    break;

  case 573: /* password_item_begin: pass_key bytestring_or_text  */
#line 633 "nest/config.Y"
{
  init_password_list();
  if ((yyvsp[0].v).type == T_BYTESTRING)
    init_password((yyvsp[0].v).val.bs->data, (yyvsp[0].v).val.bs->length, password_id++);
  else if ((yyvsp[0].v).type == T_STRING)
    init_password((yyvsp[0].v).val.s, strlen((yyvsp[0].v).val.s), password_id++);
  else bug("Bad bytestring_or_text");
}
#line 10303 "obj/conf/cf-parse.tab.c"
    break;

  case 574: /* password_item_params: %empty  */
#line 643 "nest/config.Y"
               { }
#line 10309 "obj/conf/cf-parse.tab.c"
    break;

  case 575: /* password_item_params: GENERATE FROM time ';' password_item_params  */
#line 644 "nest/config.Y"
                                               { this_p_item->genfrom = (yyvsp[-2].time); }
#line 10315 "obj/conf/cf-parse.tab.c"
    break;

  case 576: /* password_item_params: GENERATE TO time ';' password_item_params  */
#line 645 "nest/config.Y"
                                             { this_p_item->gento = (yyvsp[-2].time); }
#line 10321 "obj/conf/cf-parse.tab.c"
    break;

  case 577: /* password_item_params: ACCEPT FROM time ';' password_item_params  */
#line 646 "nest/config.Y"
                                             { this_p_item->accfrom = (yyvsp[-2].time); }
#line 10327 "obj/conf/cf-parse.tab.c"
    break;

  case 578: /* password_item_params: ACCEPT TO time ';' password_item_params  */
#line 647 "nest/config.Y"
                                           { this_p_item->accto = (yyvsp[-2].time); }
#line 10333 "obj/conf/cf-parse.tab.c"
    break;

  case 579: /* password_item_params: FROM time ';' password_item_params  */
#line 648 "nest/config.Y"
                                      { this_p_item->genfrom = this_p_item->accfrom = (yyvsp[-2].time); }
#line 10339 "obj/conf/cf-parse.tab.c"
    break;

  case 580: /* password_item_params: TO time ';' password_item_params  */
#line 649 "nest/config.Y"
                                    { this_p_item->gento = this_p_item->accto = (yyvsp[-2].time); }
#line 10345 "obj/conf/cf-parse.tab.c"
    break;

  case 581: /* password_item_params: ID expr ';' password_item_params  */
#line 650 "nest/config.Y"
                                    { this_p_item->id = (yyvsp[-2].i); if ((yyvsp[-2].i) > 255) cf_error("Password ID must be in range 0-255"); }
#line 10351 "obj/conf/cf-parse.tab.c"
    break;

  case 582: /* password_item_params: ALGORITHM password_algorithm ';' password_item_params  */
#line 651 "nest/config.Y"
                                                         { this_p_item->alg = (yyvsp[-2].i); }
#line 10357 "obj/conf/cf-parse.tab.c"
    break;

  case 583: /* password_algorithm: KEYED MD5  */
#line 655 "nest/config.Y"
                { (yyval.i) = ALG_MD5; }
#line 10363 "obj/conf/cf-parse.tab.c"
    break;

  case 584: /* password_algorithm: KEYED SHA1  */
#line 656 "nest/config.Y"
                { (yyval.i) = ALG_SHA1; }
#line 10369 "obj/conf/cf-parse.tab.c"
    break;

  case 585: /* password_algorithm: KEYED SHA256  */
#line 657 "nest/config.Y"
                { (yyval.i) = ALG_SHA256; }
#line 10375 "obj/conf/cf-parse.tab.c"
    break;

  case 586: /* password_algorithm: KEYED SHA384  */
#line 658 "nest/config.Y"
                { (yyval.i) = ALG_SHA384; }
#line 10381 "obj/conf/cf-parse.tab.c"
    break;

  case 587: /* password_algorithm: KEYED SHA512  */
#line 659 "nest/config.Y"
                { (yyval.i) = ALG_SHA512; }
#line 10387 "obj/conf/cf-parse.tab.c"
    break;

  case 588: /* password_algorithm: HMAC MD5  */
#line 660 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_MD5; }
#line 10393 "obj/conf/cf-parse.tab.c"
    break;

  case 589: /* password_algorithm: HMAC SHA1  */
#line 661 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA1; }
#line 10399 "obj/conf/cf-parse.tab.c"
    break;

  case 590: /* password_algorithm: HMAC SHA256  */
#line 662 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA256; }
#line 10405 "obj/conf/cf-parse.tab.c"
    break;

  case 591: /* password_algorithm: HMAC SHA384  */
#line 663 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA384; }
#line 10411 "obj/conf/cf-parse.tab.c"
    break;

  case 592: /* password_algorithm: HMAC SHA512  */
#line 664 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA512; }
#line 10417 "obj/conf/cf-parse.tab.c"
    break;

  case 593: /* password_algorithm: BLAKE2S128  */
#line 665 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2S_128; }
#line 10423 "obj/conf/cf-parse.tab.c"
    break;

  case 594: /* password_algorithm: BLAKE2S256  */
#line 666 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2S_256; }
#line 10429 "obj/conf/cf-parse.tab.c"
    break;

  case 595: /* password_algorithm: BLAKE2B256  */
#line 667 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2B_256; }
#line 10435 "obj/conf/cf-parse.tab.c"
    break;

  case 596: /* password_algorithm: BLAKE2B512  */
#line 668 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2B_512; }
#line 10441 "obj/conf/cf-parse.tab.c"
    break;

  case 597: /* password_item_end: %empty  */
#line 672 "nest/config.Y"
{
  password_validate_length(this_p_item);
}
#line 10449 "obj/conf/cf-parse.tab.c"
    break;

  case 600: /* cmd_SHOW_STATUS: SHOW STATUS END  */
#line 685 "nest/config.Y"
{ cmd_show_status(); }
#line 10455 "obj/conf/cf-parse.tab.c"
    break;

  case 602: /* cmd_SHOW_MEMORY: SHOW MEMORY END  */
#line 688 "nest/config.Y"
{ cmd_show_memory(); }
#line 10461 "obj/conf/cf-parse.tab.c"
    break;

  case 604: /* cmd_SHOW_PROTOCOLS: SHOW PROTOCOLS proto_patt2 END  */
#line 691 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-1].ps), proto_cmd_show, 0, 0); }
#line 10467 "obj/conf/cf-parse.tab.c"
    break;

  case 606: /* cmd_SHOW_PROTOCOLS_ALL: SHOW PROTOCOLS ALL proto_patt2 END  */
#line 694 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-1].ps), proto_cmd_show, 0, 1); }
#line 10473 "obj/conf/cf-parse.tab.c"
    break;

  case 607: /* optproto: CF_SYM_KNOWN  */
#line 697 "nest/config.Y"
                { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.s) = (yyvsp[0].s); }
#line 10479 "obj/conf/cf-parse.tab.c"
    break;

  case 608: /* optproto: %empty  */
#line 698 "nest/config.Y"
               { (yyval.s) = NULL; }
#line 10485 "obj/conf/cf-parse.tab.c"
    break;

  case 610: /* cmd_SHOW_INTERFACES: SHOW INTERFACES END  */
#line 702 "nest/config.Y"
{ if_show(); }
#line 10491 "obj/conf/cf-parse.tab.c"
    break;

  case 612: /* cmd_SHOW_INTERFACES_SUMMARY: SHOW INTERFACES SUMMARY END  */
#line 705 "nest/config.Y"
{ if_show_summary(); }
#line 10497 "obj/conf/cf-parse.tab.c"
    break;

  case 614: /* cmd_SHOW_ROUTE: SHOW ROUTE r_args END  */
#line 709 "nest/config.Y"
{ rt_show((yyvsp[-1].ra)); }
#line 10503 "obj/conf/cf-parse.tab.c"
    break;

  case 615: /* r_args: %empty  */
#line 743 "nest/config.Y"
               {
     (yyval.ra) = cfg_allocz(sizeof(struct rt_show_data));
     init_list(&((yyval.ra)->tables));
     (yyval.ra)->filter = FILTER_ACCEPT;
     (yyval.ra)->cli = this_cli;
     (yyval.ra)->tf_route = this_cli->main_config->tf_route;
   }
#line 10515 "obj/conf/cf-parse.tab.c"
    break;

  case 616: /* r_args: r_args net_any  */
#line 750 "nest/config.Y"
                  {
     (yyval.ra) = (yyvsp[-1].ra);
     if ((yyval.ra)->addr) cf_error("Only one prefix expected");
     (yyval.ra)->addr = (yyvsp[0].net_ptr);
     (yyval.ra)->addr_mode = TE_ADDR_EQUAL;
   }
#line 10526 "obj/conf/cf-parse.tab.c"
    break;

  case 617: /* r_args: r_args FOR r_args_for  */
#line 756 "nest/config.Y"
                         {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->addr) cf_error("Only one prefix expected");
     (yyval.ra)->addr = (yyvsp[0].net_ptr);
     (yyval.ra)->addr_mode = TE_ADDR_FOR;
   }
#line 10537 "obj/conf/cf-parse.tab.c"
    break;

  case 618: /* r_args: r_args IN net_any  */
#line 762 "nest/config.Y"
                     {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->addr) cf_error("Only one prefix expected");
     if (!net_type_match((yyvsp[0].net_ptr), NB_IP)) cf_error("Only IP networks accepted for 'in' argument");
     (yyval.ra)->addr = (yyvsp[0].net_ptr);
     (yyval.ra)->addr_mode = TE_ADDR_IN;
   }
#line 10549 "obj/conf/cf-parse.tab.c"
    break;

  case 619: /* r_args: r_args TABLE CF_SYM_KNOWN  */
#line 769 "nest/config.Y"
                            {
     cf_assert_symbol((yyvsp[0].s), SYM_TABLE);
     if (!(yyvsp[0].s)->table) cf_error("Table %s not configured", (yyvsp[0].s)->name);
     (yyval.ra) = (yyvsp[-2].ra);
     rt_show_add_table((yyval.ra), (yyvsp[0].s)->table->table);
     (yyval.ra)->tables_defined_by = RSD_TDB_DIRECT;
   }
#line 10561 "obj/conf/cf-parse.tab.c"
    break;

  case 620: /* r_args: r_args TABLE ALL  */
#line 776 "nest/config.Y"
                    {
     struct rtable_config *t;
     (yyval.ra) = (yyvsp[-2].ra);
     WALK_LIST(t, this_cli->main_config->tables)
       rt_show_add_table((yyval.ra), t->table);
     (yyval.ra)->tables_defined_by = RSD_TDB_ALL;
   }
#line 10573 "obj/conf/cf-parse.tab.c"
    break;

  case 621: /* r_args: r_args IMPORT TABLE channel_arg  */
#line 783 "nest/config.Y"
                                   {
     if (!((yyvsp[0].c)->in_keep & RIK_PREFILTER)) cf_error("No import table in channel %s.%s", (yyvsp[0].c)->proto->name, (yyvsp[0].c)->name);
     struct rt_show_data_rtable *rsdr = rt_show_add_table((yyval.ra), (yyvsp[0].c)->table);
     rsdr->name = "import";
     rsdr->prefilter = (yyvsp[0].c);
     (yyval.ra)->tables_defined_by = RSD_TDB_DIRECT;
   }
#line 10585 "obj/conf/cf-parse.tab.c"
    break;

  case 622: /* r_args: r_args EXPORT TABLE channel_arg  */
#line 790 "nest/config.Y"
                                   {
     if (!((yyvsp[0].c)->out_table)) cf_error("No export table in channel %s.%s", (yyvsp[0].c)->proto->name, (yyvsp[0].c)->name);
     struct rt_show_data_rtable *rsdr = rt_show_add_exporter((yyval.ra), (yyvsp[0].c)->out_table);
     rsdr->name = "export";
     (yyval.ra)->tables_defined_by = RSD_TDB_DIRECT;
   }
#line 10596 "obj/conf/cf-parse.tab.c"
    break;

  case 623: /* r_args: r_args FILTER filter  */
#line 796 "nest/config.Y"
                        {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->filter != FILTER_ACCEPT) cf_error("Filter specified twice");
     (yyval.ra)->filter = (yyvsp[0].f);
   }
#line 10606 "obj/conf/cf-parse.tab.c"
    break;

  case 624: /* r_args: r_args where_filter  */
#line 801 "nest/config.Y"
                       {
     (yyval.ra) = (yyvsp[-1].ra);
     if ((yyval.ra)->filter != FILTER_ACCEPT) cf_error("Filter specified twice");
     (yyval.ra)->filter = (yyvsp[0].f);
   }
#line 10616 "obj/conf/cf-parse.tab.c"
    break;

  case 625: /* r_args: r_args ALL  */
#line 806 "nest/config.Y"
              {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->verbose = 1;
   }
#line 10625 "obj/conf/cf-parse.tab.c"
    break;

  case 626: /* r_args: r_args PRIMARY  */
#line 810 "nest/config.Y"
                  {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->primary_only = 1;
   }
#line 10634 "obj/conf/cf-parse.tab.c"
    break;

  case 627: /* r_args: r_args FILTERED  */
#line 814 "nest/config.Y"
                   {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->filtered = 1;
   }
#line 10643 "obj/conf/cf-parse.tab.c"
    break;

  case 628: /* r_args: r_args export_mode CF_SYM_KNOWN  */
#line 818 "nest/config.Y"
                                   {
     cf_assert_symbol((yyvsp[0].s), SYM_PROTO);
     struct proto_config *c = (struct proto_config *) (yyvsp[0].s)->proto;
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->export_mode) cf_error("Export specified twice");
     if (!c->proto) cf_error("%s is not a protocol", (yyvsp[0].s)->name);
     (yyval.ra)->export_mode = (yyvsp[-1].i);
     (yyval.ra)->export_protocol = c->proto;
     (yyval.ra)->tables_defined_by = RSD_TDB_INDIRECT;
   }
#line 10658 "obj/conf/cf-parse.tab.c"
    break;

  case 629: /* r_args: r_args export_mode channel_arg  */
#line 828 "nest/config.Y"
                                  {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->export_mode) cf_error("Export specified twice");
     (yyval.ra)->export_mode = (yyvsp[-1].i);
     (yyval.ra)->export_channel = (yyvsp[0].c);
     (yyval.ra)->tables_defined_by = RSD_TDB_INDIRECT;
   }
#line 10670 "obj/conf/cf-parse.tab.c"
    break;

  case 630: /* r_args: r_args PROTOCOL CF_SYM_KNOWN  */
#line 835 "nest/config.Y"
                                {
     cf_assert_symbol((yyvsp[0].s), SYM_PROTO);
     struct proto_config *c = (struct proto_config *) (yyvsp[0].s)->proto;
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->show_protocol) cf_error("Protocol specified twice");
     if (!c->proto) cf_error("%s is not a protocol", (yyvsp[0].s)->name);
     (yyval.ra)->show_protocol = c->proto;
     (yyval.ra)->tables_defined_by = RSD_TDB_INDIRECT;
   }
#line 10684 "obj/conf/cf-parse.tab.c"
    break;

  case 631: /* r_args: r_args STATS  */
#line 844 "nest/config.Y"
                {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->stats = 1;
   }
#line 10693 "obj/conf/cf-parse.tab.c"
    break;

  case 632: /* r_args: r_args COUNT  */
#line 848 "nest/config.Y"
                {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->stats = 2;
   }
#line 10702 "obj/conf/cf-parse.tab.c"
    break;

  case 633: /* r_args_for: r_args_for_val  */
#line 855 "nest/config.Y"
                 {
    (yyval.net_ptr) = cfg_alloc((yyvsp[0].net).length);
    net_copy((yyval.net_ptr), &(yyvsp[0].net));
  }
#line 10711 "obj/conf/cf-parse.tab.c"
    break;

  case 637: /* r_args_for: VPN_RD IP4  */
#line 862 "nest/config.Y"
              {
    (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn4));
    net_fill_vpn4((yyval.net_ptr), (yyvsp[0].ip4), IP4_MAX_PREFIX_LENGTH, (yyvsp[-1].rd));
  }
#line 10720 "obj/conf/cf-parse.tab.c"
    break;

  case 638: /* r_args_for: VPN_RD IP6  */
#line 866 "nest/config.Y"
              {
    (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn6));
    net_fill_vpn6((yyval.net_ptr), (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH, (yyvsp[-1].rd));
  }
#line 10729 "obj/conf/cf-parse.tab.c"
    break;

  case 639: /* r_args_for: IP6 FROM IP6  */
#line 870 "nest/config.Y"
                {
    (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_ip6_sadr));
    net_fill_ip6_sadr((yyval.net_ptr), (yyvsp[-2].ip6), IP6_MAX_PREFIX_LENGTH, (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH);
  }
#line 10738 "obj/conf/cf-parse.tab.c"
    break;

  case 640: /* r_args_for: CF_SYM_KNOWN  */
#line 874 "nest/config.Y"
                {
     if ((yyvsp[0].s)->class == (SYM_CONSTANT | T_IP))
     {
       (yyval.net_ptr) = cfg_alloc(ipa_is_ip4(SYM_VAL((yyvsp[0].s)).ip) ? sizeof(net_addr_ip4) : sizeof(net_addr_ip6));
       net_fill_ip_host((yyval.net_ptr), SYM_VAL((yyvsp[0].s)).ip);
     }
     else if (((yyvsp[0].s)->class == (SYM_CONSTANT | T_NET)) && net_type_match(SYM_VAL((yyvsp[0].s)).net, NB_IP | NB_VPN))
       (yyval.net_ptr) = (net_addr *) SYM_VAL((yyvsp[0].s)).net; /* Avoid const warning */
     else
       cf_error("IP address or network constant expected");
   }
#line 10754 "obj/conf/cf-parse.tab.c"
    break;

  case 643: /* r_args_for_val: IP4  */
#line 890 "nest/config.Y"
       { net_fill_ip4(&((yyval.net)), (yyvsp[0].ip4), IP4_MAX_PREFIX_LENGTH); }
#line 10760 "obj/conf/cf-parse.tab.c"
    break;

  case 644: /* r_args_for_val: IP6  */
#line 891 "nest/config.Y"
       { net_fill_ip6(&((yyval.net)), (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH); }
#line 10766 "obj/conf/cf-parse.tab.c"
    break;

  case 645: /* export_mode: PREEXPORT  */
#line 894 "nest/config.Y"
                { (yyval.i) = RSEM_PREEXPORT; }
#line 10772 "obj/conf/cf-parse.tab.c"
    break;

  case 646: /* export_mode: EXPORT  */
#line 895 "nest/config.Y"
                { (yyval.i) = RSEM_EXPORT; }
#line 10778 "obj/conf/cf-parse.tab.c"
    break;

  case 647: /* export_mode: NOEXPORT  */
#line 896 "nest/config.Y"
                { (yyval.i) = RSEM_NOEXPORT; }
#line 10784 "obj/conf/cf-parse.tab.c"
    break;

  case 648: /* export_mode: EXPORTED  */
#line 897 "nest/config.Y"
                { (yyval.i) = RSEM_EXPORTED; }
#line 10790 "obj/conf/cf-parse.tab.c"
    break;

  case 649: /* channel_sym: IPV4  */
#line 902 "nest/config.Y"
                { (yyval.t) = "ipv4"; }
#line 10796 "obj/conf/cf-parse.tab.c"
    break;

  case 650: /* channel_sym: IPV4_MC  */
#line 903 "nest/config.Y"
                { (yyval.t) = "ipv4-mc"; }
#line 10802 "obj/conf/cf-parse.tab.c"
    break;

  case 651: /* channel_sym: IPV4_MPLS  */
#line 904 "nest/config.Y"
                { (yyval.t) = "ipv4-mpls"; }
#line 10808 "obj/conf/cf-parse.tab.c"
    break;

  case 652: /* channel_sym: IPV6  */
#line 905 "nest/config.Y"
                { (yyval.t) = "ipv6"; }
#line 10814 "obj/conf/cf-parse.tab.c"
    break;

  case 653: /* channel_sym: IPV6_MC  */
#line 906 "nest/config.Y"
                { (yyval.t) = "ipv6-mc"; }
#line 10820 "obj/conf/cf-parse.tab.c"
    break;

  case 654: /* channel_sym: IPV6_MPLS  */
#line 907 "nest/config.Y"
                { (yyval.t) = "ipv6-mpls"; }
#line 10826 "obj/conf/cf-parse.tab.c"
    break;

  case 655: /* channel_sym: IPV6_SADR  */
#line 908 "nest/config.Y"
                { (yyval.t) = "ipv6-sadr"; }
#line 10832 "obj/conf/cf-parse.tab.c"
    break;

  case 656: /* channel_sym: VPN4  */
#line 909 "nest/config.Y"
                { (yyval.t) = "vpn4"; }
#line 10838 "obj/conf/cf-parse.tab.c"
    break;

  case 657: /* channel_sym: VPN4_MC  */
#line 910 "nest/config.Y"
                { (yyval.t) = "vpn4-mc"; }
#line 10844 "obj/conf/cf-parse.tab.c"
    break;

  case 658: /* channel_sym: VPN4_MPLS  */
#line 911 "nest/config.Y"
                { (yyval.t) = "vpn4-mpls"; }
#line 10850 "obj/conf/cf-parse.tab.c"
    break;

  case 659: /* channel_sym: VPN6  */
#line 912 "nest/config.Y"
                { (yyval.t) = "vpn6"; }
#line 10856 "obj/conf/cf-parse.tab.c"
    break;

  case 660: /* channel_sym: VPN6_MC  */
#line 913 "nest/config.Y"
                { (yyval.t) = "vpn6-mc"; }
#line 10862 "obj/conf/cf-parse.tab.c"
    break;

  case 661: /* channel_sym: VPN6_MPLS  */
#line 914 "nest/config.Y"
                { (yyval.t) = "vpn6-mpls"; }
#line 10868 "obj/conf/cf-parse.tab.c"
    break;

  case 662: /* channel_sym: ROA4  */
#line 915 "nest/config.Y"
                { (yyval.t) = "roa4"; }
#line 10874 "obj/conf/cf-parse.tab.c"
    break;

  case 663: /* channel_sym: ROA6  */
#line 916 "nest/config.Y"
                { (yyval.t) = "roa6"; }
#line 10880 "obj/conf/cf-parse.tab.c"
    break;

  case 664: /* channel_sym: FLOW4  */
#line 917 "nest/config.Y"
                { (yyval.t) = "flow4"; }
#line 10886 "obj/conf/cf-parse.tab.c"
    break;

  case 665: /* channel_sym: FLOW6  */
#line 918 "nest/config.Y"
                { (yyval.t) = "flow6"; }
#line 10892 "obj/conf/cf-parse.tab.c"
    break;

  case 666: /* channel_sym: MPLS  */
#line 919 "nest/config.Y"
                { (yyval.t) = "mpls"; }
#line 10898 "obj/conf/cf-parse.tab.c"
    break;

  case 667: /* channel_sym: ASPA  */
#line 920 "nest/config.Y"
                { (yyval.t) = "aspa"; }
#line 10904 "obj/conf/cf-parse.tab.c"
    break;

  case 668: /* channel_sym: PRI  */
#line 921 "nest/config.Y"
                { (yyval.t) = "pri"; }
#line 10910 "obj/conf/cf-parse.tab.c"
    break;

  case 669: /* channel_sym: SEC  */
#line 922 "nest/config.Y"
                { (yyval.t) = "sec"; }
#line 10916 "obj/conf/cf-parse.tab.c"
    break;

  case 670: /* channel_arg: CF_SYM_KNOWN '.' channel_sym  */
#line 926 "nest/config.Y"
                                {
     cf_assert_symbol((yyvsp[-2].s), SYM_PROTO);
     struct proto *p =  (yyvsp[-2].s)->proto->proto;
     if (!p) cf_error("%s is not a protocol", (yyvsp[-2].s)->name);
     (yyval.c) = proto_find_channel_by_name(p, (yyvsp[0].t));
     if (!(yyval.c)) cf_error("Channel %s.%s not found", (yyvsp[-2].s)->name, (yyvsp[0].t));
   }
#line 10928 "obj/conf/cf-parse.tab.c"
    break;

  case 672: /* cmd_SHOW_SYMBOLS: SHOW SYMBOLS sym_args END  */
#line 937 "nest/config.Y"
{ cmd_show_symbols((yyvsp[-1].sd)); }
#line 10934 "obj/conf/cf-parse.tab.c"
    break;

  case 673: /* sym_args: %empty  */
#line 946 "nest/config.Y"
               {
     (yyval.sd) = cfg_allocz(sizeof(struct sym_show_data));
     (yyval.sd)->config = this_cli->main_config;
   }
#line 10943 "obj/conf/cf-parse.tab.c"
    break;

  case 674: /* sym_args: sym_args TABLE  */
#line 950 "nest/config.Y"
                  { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_TABLE; }
#line 10949 "obj/conf/cf-parse.tab.c"
    break;

  case 675: /* sym_args: sym_args FILTER  */
#line 951 "nest/config.Y"
                   { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_FILTER; }
#line 10955 "obj/conf/cf-parse.tab.c"
    break;

  case 676: /* sym_args: sym_args FUNCTION  */
#line 952 "nest/config.Y"
                     { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_FUNCTION; }
#line 10961 "obj/conf/cf-parse.tab.c"
    break;

  case 677: /* sym_args: sym_args PROTOCOL  */
#line 953 "nest/config.Y"
                     { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_PROTO; }
#line 10967 "obj/conf/cf-parse.tab.c"
    break;

  case 678: /* sym_args: sym_args TEMPLATE  */
#line 954 "nest/config.Y"
                     { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_TEMPLATE; }
#line 10973 "obj/conf/cf-parse.tab.c"
    break;

  case 679: /* sym_args: sym_args CF_SYM_KNOWN  */
#line 955 "nest/config.Y"
                         { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->sym = (yyvsp[0].s); }
#line 10979 "obj/conf/cf-parse.tab.c"
    break;

  case 681: /* cmd_DUMP_RESOURCES: DUMP RESOURCES text END  */
#line 960 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "resources", resource_dump); }
#line 10985 "obj/conf/cf-parse.tab.c"
    break;

  case 683: /* cmd_DUMP_SOCKETS: DUMP SOCKETS text END  */
#line 962 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "sockets", sk_dump_all); }
#line 10991 "obj/conf/cf-parse.tab.c"
    break;

  case 685: /* cmd_DUMP_AO_KEYS: DUMP AO KEYS text END  */
#line 964 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "AO keys", sk_dump_ao_all); }
#line 10997 "obj/conf/cf-parse.tab.c"
    break;

  case 687: /* cmd_DUMP_EVENTS: DUMP EVENTS text END  */
#line 966 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "event log", io_log_dump); }
#line 11003 "obj/conf/cf-parse.tab.c"
    break;

  case 689: /* cmd_DUMP_INTERFACES: DUMP INTERFACES text END  */
#line 968 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "interfaces", if_dump_all); }
#line 11009 "obj/conf/cf-parse.tab.c"
    break;

  case 691: /* cmd_DUMP_NEIGHBORS: DUMP NEIGHBORS text END  */
#line 970 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "neighbor cache", neigh_dump_all); }
#line 11015 "obj/conf/cf-parse.tab.c"
    break;

  case 693: /* cmd_DUMP_ATTRIBUTES: DUMP ATTRIBUTES text END  */
#line 972 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "attribute cache", ea_dump_all); }
#line 11021 "obj/conf/cf-parse.tab.c"
    break;

  case 695: /* cmd_DUMP_ROUTES: DUMP ROUTES text END  */
#line 974 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "routing tables", rt_dump_all); }
#line 11027 "obj/conf/cf-parse.tab.c"
    break;

  case 697: /* cmd_DUMP_TABLES: DUMP TABLES text END  */
#line 976 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "table connections", rt_dump_hooks_all); }
#line 11033 "obj/conf/cf-parse.tab.c"
    break;

  case 699: /* cmd_DUMP_PROTOCOLS: DUMP PROTOCOLS text END  */
#line 978 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "protocols", protos_dump_all); }
#line 11039 "obj/conf/cf-parse.tab.c"
    break;

  case 701: /* cmd_DUMP_FILTER_ALL: DUMP FILTER ALL text END  */
#line 980 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "filter bytecode", filters_dump_all); }
#line 11045 "obj/conf/cf-parse.tab.c"
    break;

  case 703: /* cmd_EVAL: EVAL term END  */
#line 983 "nest/config.Y"
{ cmd_eval(f_linearize((yyvsp[-1].x), 1)); }
#line 11051 "obj/conf/cf-parse.tab.c"
    break;

  case 704: /* partial_opt: PARTIAL term  */
#line 986 "nest/config.Y"
               {
    struct f_val val;
    if (f_eval(f_linearize((yyvsp[0].x), 1), &val) > F_RETURN) cf_error("Runtime error");
    if (val.type != T_PREFIX_SET) cf_error("Partial spec must be prefix set");
    (yyval.const_trie) = val.val.ti;
  }
#line 11062 "obj/conf/cf-parse.tab.c"
    break;

  case 705: /* partial_opt: %empty  */
#line 992 "nest/config.Y"
                { (yyval.const_trie) = NULL; }
#line 11068 "obj/conf/cf-parse.tab.c"
    break;

  case 707: /* cmd_DISABLE: DISABLE proto_patt opttext END  */
#line 996 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_disable, 1, (uintptr_t) (yyvsp[-1].t)); }
#line 11074 "obj/conf/cf-parse.tab.c"
    break;

  case 709: /* cmd_ENABLE: ENABLE proto_patt opttext END  */
#line 998 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_enable, 1, (uintptr_t) (yyvsp[-1].t)); }
#line 11080 "obj/conf/cf-parse.tab.c"
    break;

  case 711: /* cmd_RESTART: RESTART proto_patt opttext END  */
#line 1000 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_restart, 1, (uintptr_t) (yyvsp[-1].t)); }
#line 11086 "obj/conf/cf-parse.tab.c"
    break;

  case 713: /* cmd_RELOAD_FILTERS: RELOAD FILTERS proto_patt partial_opt END  */
#line 1002 "nest/config.Y"
{ proto_call_cmd_reload((yyvsp[-2].ps), CMD_RELOAD, (yyvsp[-1].const_trie)); }
#line 11092 "obj/conf/cf-parse.tab.c"
    break;

  case 715: /* cmd_RELOAD_FILTERS_IN: RELOAD FILTERS IN proto_patt partial_opt END  */
#line 1004 "nest/config.Y"
{ proto_call_cmd_reload((yyvsp[-2].ps), CMD_RELOAD_IN, (yyvsp[-1].const_trie)); }
#line 11098 "obj/conf/cf-parse.tab.c"
    break;

  case 717: /* cmd_RELOAD_FILTERS_OUT: RELOAD FILTERS OUT proto_patt partial_opt END  */
#line 1006 "nest/config.Y"
{ proto_call_cmd_reload((yyvsp[-2].ps), CMD_RELOAD_OUT, (yyvsp[-1].const_trie)); }
#line 11104 "obj/conf/cf-parse.tab.c"
    break;

  case 719: /* cmd_DEBUG: DEBUG debug_args END  */
#line 1010 "nest/config.Y"
{ /* Done in debug_args */  }
#line 11110 "obj/conf/cf-parse.tab.c"
    break;

  case 720: /* debug_args: proto_patt debug_mask  */
#line 1022 "nest/config.Y"
                         { proto_apply_cmd((yyvsp[-1].ps), proto_cmd_debug, 1, (yyvsp[0].i));  }
#line 11116 "obj/conf/cf-parse.tab.c"
    break;

  case 721: /* debug_args: channel_arg debug_mask  */
#line 1023 "nest/config.Y"
                          { channel_cmd_debug((yyvsp[-1].c), (yyvsp[0].i)); }
#line 11122 "obj/conf/cf-parse.tab.c"
    break;

  case 723: /* cmd_MRTDUMP: MRTDUMP proto_patt mrtdump_mask END  */
#line 1028 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_mrtdump, 1, (yyvsp[-1].i)); }
#line 11128 "obj/conf/cf-parse.tab.c"
    break;

  case 725: /* cmd_RESTRICT: RESTRICT END  */
#line 1031 "nest/config.Y"
{ this_cli->restricted = 1; cli_msg(16, "Access restricted"); }
#line 11134 "obj/conf/cf-parse.tab.c"
    break;

  case 727: /* cmd_TIMEFORMAT: TIMEFORMAT timeformat_spec END  */
#line 1035 "nest/config.Y"
{ cli_set_timeformat(this_cli, (yyvsp[-1].tf)); }
#line 11140 "obj/conf/cf-parse.tab.c"
    break;

  case 728: /* proto_patt: CF_SYM_KNOWN  */
#line 1044 "nest/config.Y"
                { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.ps).ptr = (yyvsp[0].s); (yyval.ps).patt = 0; }
#line 11146 "obj/conf/cf-parse.tab.c"
    break;

  case 729: /* proto_patt: ALL  */
#line 1045 "nest/config.Y"
        { (yyval.ps).ptr = NULL; (yyval.ps).patt = 1; }
#line 11152 "obj/conf/cf-parse.tab.c"
    break;

  case 730: /* proto_patt: TEXT  */
#line 1046 "nest/config.Y"
        { (yyval.ps).ptr = (yyvsp[0].t); (yyval.ps).patt = 1; }
#line 11158 "obj/conf/cf-parse.tab.c"
    break;

  case 731: /* proto_patt2: CF_SYM_KNOWN  */
#line 1050 "nest/config.Y"
                { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.ps).ptr = (yyvsp[0].s); (yyval.ps).patt = 0; }
#line 11164 "obj/conf/cf-parse.tab.c"
    break;

  case 732: /* proto_patt2: %empty  */
#line 1051 "nest/config.Y"
        { (yyval.ps).ptr = NULL; (yyval.ps).patt = 1; }
#line 11170 "obj/conf/cf-parse.tab.c"
    break;

  case 733: /* proto_patt2: TEXT  */
#line 1052 "nest/config.Y"
        { (yyval.ps).ptr = (yyvsp[0].t); (yyval.ps).patt = 1; }
#line 11176 "obj/conf/cf-parse.tab.c"
    break;

  case 736: /* mpls_domain_start: MPLS DOMAIN symbol  */
#line 35 "nest/mpls.Y"
                                      { this_mpls_domain = mpls_domain_config_new((yyvsp[0].s)); }
#line 11182 "obj/conf/cf-parse.tab.c"
    break;

  case 742: /* mpls_domain_end: %empty  */
#line 51 "nest/mpls.Y"
                 { mpls_domain_postconfig(this_mpls_domain); this_mpls_domain = NULL; }
#line 11188 "obj/conf/cf-parse.tab.c"
    break;

  case 744: /* mpls_range_start: LABEL RANGE STATIC  */
#line 56 "nest/mpls.Y"
                                     {
    this_mpls_range = this_mpls_domain->static_range;
}
#line 11196 "obj/conf/cf-parse.tab.c"
    break;

  case 745: /* mpls_range_start: LABEL RANGE DYNAMIC  */
#line 60 "nest/mpls.Y"
                                      {
    this_mpls_range = this_mpls_domain->dynamic_range;
}
#line 11204 "obj/conf/cf-parse.tab.c"
    break;

  case 746: /* mpls_range_start: LABEL RANGE symbol  */
#line 64 "nest/mpls.Y"
                                     {
    this_mpls_range = mpls_range_config_new(this_mpls_domain, (yyvsp[0].s));
}
#line 11212 "obj/conf/cf-parse.tab.c"
    break;

  case 747: /* mpls_range_opt: START expr  */
#line 69 "nest/mpls.Y"
              { this_mpls_range->start = (yyvsp[0].i); if ((yyvsp[0].i) >= MPLS_MAX_LABEL) cf_error("MPLS label range start must be less than 2^20"); }
#line 11218 "obj/conf/cf-parse.tab.c"
    break;

  case 748: /* mpls_range_opt: LENGTH expr  */
#line 70 "nest/mpls.Y"
               { this_mpls_range->length = (yyvsp[0].i); if ((yyvsp[0].i) >= MPLS_MAX_LABEL) cf_error("MPLS label range length must be less than 2^20"); if (!(yyvsp[0].i)) cf_error("MPLS label range length must be nonzero"); }
#line 11224 "obj/conf/cf-parse.tab.c"
    break;

  case 753: /* mpls_range_end: %empty  */
#line 84 "nest/mpls.Y"
{
  struct mpls_range_config *r = this_mpls_range;

  if ((r->start == (uint) -1) || (r->length == (uint) -1))
    cf_error("MPLS label range start and length must be specified");

  if (r->start + r->length > MPLS_MAX_LABEL)
    cf_error("MPLS label range end must be less than 2^20");

  this_mpls_range = NULL;
}
#line 11240 "obj/conf/cf-parse.tab.c"
    break;

  case 755: /* mpls_channel_start: MPLS  */
#line 100 "nest/mpls.Y"
{
  (yyval.cc) = this_channel = channel_config_get(&channel_mpls, net_label[NET_MPLS], NET_MPLS, this_proto);

  if (EMPTY_LIST(new_config->mpls_domains))
  {
    int counter = 0;
    mpls_domain_config_new(cf_default_name(new_config, "mpls%d", &counter));
    cf_warn("No MPLS domain defined");
  }

  /* Default values for new channel */
  if (!MPLS_CC->domain)
  {
    MPLS_CC->domain = cf_default_mpls_domain(new_config);
    MPLS_CC->label_policy = MPLS_POLICY_PREFIX;
  }
}
#line 11262 "obj/conf/cf-parse.tab.c"
    break;

  case 756: /* mpls_label_policy: STATIC  */
#line 119 "nest/mpls.Y"
          { (yyval.i) = MPLS_POLICY_STATIC; }
#line 11268 "obj/conf/cf-parse.tab.c"
    break;

  case 757: /* mpls_label_policy: PREFIX  */
#line 120 "nest/mpls.Y"
          { (yyval.i) = MPLS_POLICY_PREFIX; }
#line 11274 "obj/conf/cf-parse.tab.c"
    break;

  case 758: /* mpls_label_policy: AGGREGATE  */
#line 121 "nest/mpls.Y"
             { (yyval.i) = MPLS_POLICY_AGGREGATE; }
#line 11280 "obj/conf/cf-parse.tab.c"
    break;

  case 759: /* mpls_label_policy: VRF  */
#line 122 "nest/mpls.Y"
       { (yyval.i) = MPLS_POLICY_VRF; }
#line 11286 "obj/conf/cf-parse.tab.c"
    break;

  case 761: /* mpls_channel_opt: DOMAIN CF_SYM_KNOWN  */
#line 127 "nest/mpls.Y"
                       { cf_assert_symbol((yyvsp[0].s), SYM_MPLS_DOMAIN); MPLS_CC->domain = (yyvsp[0].s)->mpls_domain; }
#line 11292 "obj/conf/cf-parse.tab.c"
    break;

  case 762: /* mpls_channel_opt: LABEL RANGE CF_SYM_KNOWN  */
#line 128 "nest/mpls.Y"
                            { cf_assert_symbol((yyvsp[0].s), SYM_MPLS_RANGE); MPLS_CC->range = (yyvsp[0].s)->mpls_range; }
#line 11298 "obj/conf/cf-parse.tab.c"
    break;

  case 763: /* mpls_channel_opt: LABEL RANGE STATIC  */
#line 129 "nest/mpls.Y"
                       { MPLS_CC->range = MPLS_CC->domain->static_range; }
#line 11304 "obj/conf/cf-parse.tab.c"
    break;

  case 764: /* mpls_channel_opt: LABEL RANGE DYNAMIC  */
#line 130 "nest/mpls.Y"
                       { MPLS_CC->range = MPLS_CC->domain->dynamic_range; }
#line 11310 "obj/conf/cf-parse.tab.c"
    break;

  case 765: /* mpls_channel_opt: LABEL POLICY mpls_label_policy  */
#line 131 "nest/mpls.Y"
                                  { MPLS_CC->label_policy = (yyvsp[0].i); }
#line 11316 "obj/conf/cf-parse.tab.c"
    break;

  case 770: /* $@15: %empty  */
#line 144 "nest/mpls.Y"
                  { mpls_channel_postconfig(this_channel); }
#line 11322 "obj/conf/cf-parse.tab.c"
    break;

  case 772: /* show_mpls_ranges_args: %empty  */
#line 149 "nest/mpls.Y"
   {
     if (EMPTY_LIST(this_cli->main_config->mpls_domains))
       cf_error("No MPLS domain defined");

     (yyval.msrc) = cfg_allocz(sizeof(struct mpls_show_ranges_cmd));
   }
#line 11333 "obj/conf/cf-parse.tab.c"
    break;

  case 773: /* show_mpls_ranges_args: show_mpls_ranges_args CF_SYM_KNOWN  */
#line 156 "nest/mpls.Y"
   {
     if ((yyvsp[0].s)->class == SYM_MPLS_DOMAIN)
     {
       if ((yyval.msrc)->domain)
	cf_error("Only one MPLS domain expected");

       (yyval.msrc)->domain = (yyvsp[0].s)->mpls_domain;
     }
     else if ((yyvsp[0].s)->class == SYM_MPLS_RANGE)
     {
       if ((yyval.msrc)->range)
	cf_error("Only one MPLS label range expected");

       if ((yyval.msrc)->domain != (yyvsp[0].s)->mpls_range->domain)
	cf_error("MPLS label range from different MPLS domain");

       (yyval.msrc)->domain = (yyvsp[0].s)->mpls_range->domain;
       (yyval.msrc)->range = (yyvsp[0].s)->mpls_range;
     }
     else
       cf_error("MPLS domain or label range expected");
   }
#line 11360 "obj/conf/cf-parse.tab.c"
    break;

  case 774: /* show_mpls_ranges_args: show_mpls_ranges_args STATIC  */
#line 179 "nest/mpls.Y"
   {
     if ((yyval.msrc)->range)
       cf_error("Only one MPLS label range expected");

     (yyval.msrc)->domain = (yyval.msrc)->domain ?: cf_default_mpls_domain(this_cli->main_config);
     (yyval.msrc)->range = (yyval.msrc)->domain->static_range;
   }
#line 11372 "obj/conf/cf-parse.tab.c"
    break;

  case 775: /* show_mpls_ranges_args: show_mpls_ranges_args DYNAMIC  */
#line 187 "nest/mpls.Y"
   {
     if ((yyval.msrc)->range)
       cf_error("Only one MPLS label range expected");

     (yyval.msrc)->domain = (yyval.msrc)->domain ?: cf_default_mpls_domain(this_cli->main_config);
     (yyval.msrc)->range = (yyval.msrc)->domain->dynamic_range;
   }
#line 11384 "obj/conf/cf-parse.tab.c"
    break;

  case 777: /* cmd_SHOW_MPLS_RANGES: SHOW MPLS RANGES show_mpls_ranges_args END  */
#line 197 "nest/mpls.Y"
{ mpls_show_ranges((yyvsp[-1].msrc)); }
#line 11390 "obj/conf/cf-parse.tab.c"
    break;

  case 779: /* aggregator_proto_start: proto_start AGGREGATOR  */
#line 31 "proto/aggregator/config.Y"
{
  this_proto = proto_config_new(&proto_aggregator, (yyvsp[-1].i));
  this_channel = AGGREGATOR_CFG->src = channel_config_new(NULL, "source", 0, this_proto);
  AGGREGATOR_CFG->dst = channel_config_new(NULL, "destination", 0, this_proto);

  AGGREGATOR_CFG->src->ra_mode = AGGREGATOR_CFG->dst->ra_mode = RA_ANY;
}
#line 11402 "obj/conf/cf-parse.tab.c"
    break;

  case 782: /* aggregator_proto_item: PEER TABLE rtable  */
#line 42 "proto/aggregator/config.Y"
                     { AGGREGATOR_CFG->dst->table = (yyvsp[0].r); }
#line 11408 "obj/conf/cf-parse.tab.c"
    break;

  case 783: /* $@16: %empty  */
#line 43 "proto/aggregator/config.Y"
                {
    if (AGGREGATOR_CFG->aggr_on)
      cf_error("Only one aggregate on clause allowed");

    cf_enter_filters();
    cf_push_block_scope(new_config);
 }
#line 11420 "obj/conf/cf-parse.tab.c"
    break;

  case 784: /* aggregator_proto_item: AGGREGATE ON $@16 aggr_list  */
#line 49 "proto/aggregator/config.Y"
             {
    int count = new_config->current_scope->slots;
    cf_pop_block_scope(new_config);
    cf_exit_filters();

    if (!AGGREGATOR_CFG->aggr_on_net)
      cf_error("aggregate on must be always include 'net'.");

   struct f_inst *rot = NULL;
   while ((yyvsp[0].xp).begin)
   {
     struct f_inst *tmp = (yyvsp[0].xp).begin->next;
     (yyvsp[0].xp).begin->next = rot;
     rot = (yyvsp[0].xp).begin;
     (yyvsp[0].xp).begin = tmp;
   }

   AGGREGATOR_CFG->aggr_on_count = count;
   AGGREGATOR_CFG->aggr_on = f_linearize(rot, count);

   struct f_line *premerge = f_linearize((yyvsp[0].xp).end, 0);
   premerge->args = count;
   AGGREGATOR_CFG->premerge = premerge;
 }
#line 11449 "obj/conf/cf-parse.tab.c"
    break;

  case 785: /* $@17: %empty  */
#line 73 "proto/aggregator/config.Y"
            {
   cf_enter_filters();
   cf_push_block_scope(new_config);
   f_predefined_variable(new_config, "routes", T_ROUTES_BLOCK);
 }
#line 11459 "obj/conf/cf-parse.tab.c"
    break;

  case 786: /* aggregator_proto_item: MERGE BY $@17 function_body  */
#line 77 "proto/aggregator/config.Y"
                 {
   cf_pop_block_scope(new_config);
   cf_exit_filters();
   (yyvsp[0].fl)->args++;
   AGGREGATOR_CFG->merge_by = (yyvsp[0].fl);
 }
#line 11470 "obj/conf/cf-parse.tab.c"
    break;

  case 791: /* aggr_list: aggr_list ',' aggr_item  */
#line 91 "proto/aggregator/config.Y"
                           {
    if ((yyval.xp).begin = (yyvsp[0].xp).begin)
      (yyval.xp).begin->next = (yyvsp[-2].xp).begin;
    else
      (yyval.xp).begin = (yyvsp[-2].xp).begin;

    if ((yyval.xp).end = (yyvsp[0].xp).end)
      (yyval.xp).end->next = (yyvsp[-2].xp).end;
    else
      (yyval.xp).end = (yyvsp[-2].xp).end;
 }
#line 11486 "obj/conf/cf-parse.tab.c"
    break;

  case 792: /* aggr_item: '(' term ')'  */
#line 105 "proto/aggregator/config.Y"
                {
     switch ((yyvsp[-1].x)->type) {
       case T_INT:
       case T_BOOL:
       case T_PAIR:
       case T_QUAD:
       case T_ENUM:
       case T_IP:
       case T_EC:
       case T_LC:
       case T_RD:
	 /* Fits, OK */
	 break;

       default:
	 cf_error("Expression evaluated to type %s unsupported by aggregator. Store this value as a custom attribute instead", f_type_name((yyvsp[-1].x)->type));
     }

     (yyval.xp).begin = (yyvsp[-1].x);
     (yyval.xp).end = NULL;
     f_new_var(new_config->current_scope);
   }
#line 11513 "obj/conf/cf-parse.tab.c"
    break;

  case 793: /* aggr_item: lvalue  */
#line 127 "proto/aggregator/config.Y"
           {
    (yyval.xp).begin = f_lval_getter(&(yyvsp[0].flv));
    int vari = f_new_var(new_config->current_scope);

    if ((yyvsp[0].flv).type == F_LVAL_SA && (yyvsp[0].flv).sa.sa_code == SA_NET)
      AGGREGATOR_CFG->aggr_on_net = 1;
    if (((yyvsp[0].flv).type == F_LVAL_CONSTANT) || 
	((yyvsp[0].flv).type == F_LVAL_SA && (yyvsp[0].flv).sa.readonly))
      (yyval.xp).end = NULL;
    else
    {
      char varname[12];
      bsnprintf(varname, 12, "!aggr%d", vari);
      (yyval.xp).end = f_lval_setter(&(yyvsp[0].flv),
	  f_new_inst(FI_VAR_GET, cf_define_symbol(
	      new_config, cf_get_symbol(new_config, varname),
	      SYM_VARIABLE | (yyval.xp).begin->type, offset, vari
	      )));
    }
  }
#line 11538 "obj/conf/cf-parse.tab.c"
    break;

  case 795: /* bfd_proto_start: proto_start BFD  */
#line 39 "proto/bfd/config.Y"
{
  this_proto = proto_config_new(&proto_bfd, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
  if (new_config->thread_group_simple)
    BFD_CFG->express_thread_group = TTAIL(thread_group, &new_config->thread_group);
  else
  {
    struct symbol *sym = cf_find_symbol(new_config, "express");
    if (sym && sym->class == SYM_THREAD_GROUP)
      BFD_CFG->express_thread_group = sym->thread_group;
    else
      BFD_CFG->express_thread_group = NULL;
  }

  init_list(&BFD_CFG->patt_list);
  BFD_CFG->accept_ipv4 = BFD_CFG->accept_ipv6 = 1;
  BFD_CFG->accept_direct = BFD_CFG->accept_multihop = 1;
}
#line 11561 "obj/conf/cf-parse.tab.c"
    break;

  case 797: /* bfd_proto_item: EXPRESS THREAD GROUP symbol  */
#line 60 "proto/bfd/config.Y"
                               {
    if ((yyvsp[0].s)->class != SYM_THREAD_GROUP)
      cf_error("Unexpected symbol %s as a thread group name", (yyvsp[0].s)->name);
    BFD_CFG->express_thread_group = (yyvsp[0].s)->thread_group;
 }
#line 11571 "obj/conf/cf-parse.tab.c"
    break;

  case 802: /* bfd_proto_item: STRICT BIND bool  */
#line 69 "proto/bfd/config.Y"
                    { BFD_CFG->strict_bind = (yyvsp[0].i); }
#line 11577 "obj/conf/cf-parse.tab.c"
    break;

  case 803: /* bfd_proto_item: ZERO UDP6 CHECKSUM RX bool  */
#line 70 "proto/bfd/config.Y"
                              { BFD_CFG->zero_udp6_checksum_rx = (yyvsp[0].i); }
#line 11583 "obj/conf/cf-parse.tab.c"
    break;

  case 806: /* bfd_proto: bfd_proto_start proto_name '{' bfd_proto_opts '}'  */
#line 79 "proto/bfd/config.Y"
                                                     {
  if (!BFD_CFG->express_thread_group)
    cf_error("Express thread group not configured and \"express\" not found.");
}
#line 11592 "obj/conf/cf-parse.tab.c"
    break;

  case 807: /* bfd_accept_item: IPV4  */
#line 86 "proto/bfd/config.Y"
                        { BFD_CFG->accept_ipv4 = 1;  BFD_CFG->accept_ipv6 = 0; }
#line 11598 "obj/conf/cf-parse.tab.c"
    break;

  case 808: /* bfd_accept_item: IPV6  */
#line 87 "proto/bfd/config.Y"
                        { BFD_CFG->accept_ipv4 = 0;  BFD_CFG->accept_ipv6 = 1; }
#line 11604 "obj/conf/cf-parse.tab.c"
    break;

  case 809: /* bfd_accept_item: DIRECT  */
#line 88 "proto/bfd/config.Y"
                        { BFD_CFG->accept_direct = 1;  BFD_CFG->accept_multihop = 0; }
#line 11610 "obj/conf/cf-parse.tab.c"
    break;

  case 810: /* bfd_accept_item: MULTIHOP  */
#line 89 "proto/bfd/config.Y"
                        { BFD_CFG->accept_direct = 0;  BFD_CFG->accept_multihop = 1; }
#line 11616 "obj/conf/cf-parse.tab.c"
    break;

  case 811: /* bfd_accept: %empty  */
#line 93 "proto/bfd/config.Y"
   {
     BFD_CFG->accept_ipv4 = BFD_CFG->accept_ipv6 = 1;
     BFD_CFG->accept_direct = BFD_CFG->accept_multihop = 1;
   }
#line 11625 "obj/conf/cf-parse.tab.c"
    break;

  case 813: /* bfd_iface_start: %empty  */
#line 101 "proto/bfd/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct bfd_iface_config));
  add_tail(&BFD_CFG->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);

  this_bfd_opts = &BFD_IFACE->opts;

  this_bfd_opts->min_rx_int = BFD_DEFAULT_MIN_RX_INT;
  this_bfd_opts->min_tx_int = BFD_DEFAULT_MIN_TX_INT;
  this_bfd_opts->idle_tx_int = BFD_DEFAULT_IDLE_TX_INT;
  this_bfd_opts->multiplier = BFD_DEFAULT_MULTIPLIER;

  reset_passwords();
}
#line 11644 "obj/conf/cf-parse.tab.c"
    break;

  case 814: /* bfd_iface_finish: %empty  */
#line 117 "proto/bfd/config.Y"
{
  this_bfd_opts->passwords = get_passwords();

  if (!this_bfd_opts->auth_type != !this_bfd_opts->passwords)
    cf_warn("Authentication and password options should be used together");

  if (this_bfd_opts->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *this_bfd_opts->passwords)
    {
      if (pass->alg)
        cf_error("Password algorithm option not available in BFD protocol");

      pass->alg = bfd_auth_type_to_hash_alg[this_bfd_opts->auth_type];
    }
  }

  this_bfd_opts = NULL;
}
#line 11669 "obj/conf/cf-parse.tab.c"
    break;

  case 815: /* bfd_auth_type: NONE  */
#line 139 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_NONE; }
#line 11675 "obj/conf/cf-parse.tab.c"
    break;

  case 816: /* bfd_auth_type: SIMPLE  */
#line 140 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_SIMPLE; }
#line 11681 "obj/conf/cf-parse.tab.c"
    break;

  case 817: /* bfd_auth_type: KEYED MD5  */
#line 141 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_KEYED_MD5; }
#line 11687 "obj/conf/cf-parse.tab.c"
    break;

  case 818: /* bfd_auth_type: KEYED SHA1  */
#line 142 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_KEYED_SHA1; }
#line 11693 "obj/conf/cf-parse.tab.c"
    break;

  case 819: /* bfd_auth_type: METICULOUS KEYED MD5  */
#line 143 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_METICULOUS_KEYED_MD5; }
#line 11699 "obj/conf/cf-parse.tab.c"
    break;

  case 820: /* bfd_auth_type: METICULOUS KEYED SHA1  */
#line 144 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_METICULOUS_KEYED_SHA1; }
#line 11705 "obj/conf/cf-parse.tab.c"
    break;

  case 824: /* bfd_multihop: bfd_iface_start bfd_iface_opt_list bfd_iface_finish  */
#line 157 "proto/bfd/config.Y"
{ BFD_CFG->multihop = BFD_IFACE; }
#line 11711 "obj/conf/cf-parse.tab.c"
    break;

  case 825: /* bfd_neigh_iface: %empty  */
#line 161 "proto/bfd/config.Y"
               { (yyval.iface) = NULL; }
#line 11717 "obj/conf/cf-parse.tab.c"
    break;

  case 826: /* bfd_neigh_iface: '%' symbol  */
#line 162 "proto/bfd/config.Y"
              { (yyval.iface) = if_get_by_name((yyvsp[0].s)->name); }
#line 11723 "obj/conf/cf-parse.tab.c"
    break;

  case 827: /* bfd_neigh_iface: DEV text  */
#line 163 "proto/bfd/config.Y"
            { (yyval.iface) = if_get_by_name((yyvsp[0].t)); }
#line 11729 "obj/conf/cf-parse.tab.c"
    break;

  case 828: /* bfd_neigh_local: %empty  */
#line 167 "proto/bfd/config.Y"
               { (yyval.a) = IPA_NONE; }
#line 11735 "obj/conf/cf-parse.tab.c"
    break;

  case 829: /* bfd_neigh_local: LOCAL ipa  */
#line 168 "proto/bfd/config.Y"
             { (yyval.a) = (yyvsp[0].a); }
#line 11741 "obj/conf/cf-parse.tab.c"
    break;

  case 830: /* bfd_neigh_multihop: %empty  */
#line 172 "proto/bfd/config.Y"
               { (yyval.i) = 0; }
#line 11747 "obj/conf/cf-parse.tab.c"
    break;

  case 831: /* bfd_neigh_multihop: MULTIHOP bool  */
#line 173 "proto/bfd/config.Y"
                 { (yyval.i) = (yyvsp[0].i); }
#line 11753 "obj/conf/cf-parse.tab.c"
    break;

  case 832: /* bfd_neighbor: ipa bfd_neigh_iface bfd_neigh_local bfd_neigh_multihop  */
#line 177 "proto/bfd/config.Y"
{
  this_bfd_neighbor = cfg_allocz(sizeof(struct bfd_neighbor));
  bfd_neighbor_add_tail(&BFD_CFG->neigh_list, this_bfd_neighbor);

  callback_init(&BFD_NEIGHBOR->notify, bfd_neighbor_notify, &main_birdloop);

  BFD_NEIGHBOR->addr = (yyvsp[-3].a);
  BFD_NEIGHBOR->local = (yyvsp[-1].a);
  BFD_NEIGHBOR->iface = (yyvsp[-2].iface);
  BFD_NEIGHBOR->multihop = (yyvsp[0].i);

  if ((yyvsp[0].i) && (yyvsp[-2].iface))
    cf_error("Neighbor cannot set both interface and multihop");

  if ((yyvsp[0].i) && ipa_zero((yyvsp[-1].a)))
    cf_error("Multihop neighbor requires specified local address");
}
#line 11775 "obj/conf/cf-parse.tab.c"
    break;

  case 833: /* bfd_item: INTERVAL expr_us  */
#line 199 "proto/bfd/config.Y"
                    { this_bfd_opts->min_rx_int = this_bfd_opts->min_tx_int = (yyvsp[0].time); }
#line 11781 "obj/conf/cf-parse.tab.c"
    break;

  case 834: /* bfd_item: MIN RX INTERVAL expr_us  */
#line 200 "proto/bfd/config.Y"
                           { this_bfd_opts->min_rx_int = (yyvsp[0].time); }
#line 11787 "obj/conf/cf-parse.tab.c"
    break;

  case 835: /* bfd_item: MIN TX INTERVAL expr_us  */
#line 201 "proto/bfd/config.Y"
                           { this_bfd_opts->min_tx_int = (yyvsp[0].time); }
#line 11793 "obj/conf/cf-parse.tab.c"
    break;

  case 836: /* bfd_item: IDLE TX INTERVAL expr_us  */
#line 202 "proto/bfd/config.Y"
                            { this_bfd_opts->idle_tx_int = (yyvsp[0].time); }
#line 11799 "obj/conf/cf-parse.tab.c"
    break;

  case 837: /* bfd_item: MULTIPLIER expr  */
#line 203 "proto/bfd/config.Y"
                   { this_bfd_opts->multiplier = (yyvsp[0].i); }
#line 11805 "obj/conf/cf-parse.tab.c"
    break;

  case 838: /* bfd_item: PASSIVE bool  */
#line 204 "proto/bfd/config.Y"
                { this_bfd_opts->passive = (yyvsp[0].i) ? BFD_OPT_PASSIVE : BFD_OPT_NOT_PASSIVE; }
#line 11811 "obj/conf/cf-parse.tab.c"
    break;

  case 839: /* bfd_item: GRACEFUL  */
#line 205 "proto/bfd/config.Y"
            { this_bfd_opts->mode = BGP_BFD_GRACEFUL; }
#line 11817 "obj/conf/cf-parse.tab.c"
    break;

  case 840: /* bfd_item: AUTHENTICATION bfd_auth_type  */
#line 206 "proto/bfd/config.Y"
                                { this_bfd_opts->auth_type = (yyvsp[0].i); }
#line 11823 "obj/conf/cf-parse.tab.c"
    break;

  case 841: /* bfd_item: password_list  */
#line 207 "proto/bfd/config.Y"
                 {}
#line 11829 "obj/conf/cf-parse.tab.c"
    break;

  case 844: /* bfd_opts_start: %empty  */
#line 216 "proto/bfd/config.Y"
{ reset_passwords(); }
#line 11835 "obj/conf/cf-parse.tab.c"
    break;

  case 845: /* bfd_opts_end: %empty  */
#line 219 "proto/bfd/config.Y"
{
  this_bfd_opts->passwords = get_passwords();

  if (!this_bfd_opts->auth_type != !this_bfd_opts->passwords)
    cf_warn("Authentication and password options should be used together");

  if (this_bfd_opts->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *this_bfd_opts->passwords)
    {
      if (pass->alg)
        cf_error("Password algorithm option not available in BFD protocol");

      pass->alg = bfd_auth_type_to_hash_alg[this_bfd_opts->auth_type];
    }
  }
}
#line 11858 "obj/conf/cf-parse.tab.c"
    break;

  case 848: /* cmd_SHOW_BFD_SESSIONS: SHOW BFD SESSIONS bfd_show_sessions_args END  */
#line 246 "proto/bfd/config.Y"
{ PROTO_WALK_CMD((yyvsp[-1].bssc)->name, &proto_bfd, p) bfd_show_sessions(p, (yyvsp[-1].bssc)); }
#line 11864 "obj/conf/cf-parse.tab.c"
    break;

  case 849: /* bfd_show_sessions_args: %empty  */
#line 258 "proto/bfd/config.Y"
               { (yyval.bssc) = cfg_allocz(sizeof(struct bfd_show_sessions_cmd)); }
#line 11870 "obj/conf/cf-parse.tab.c"
    break;

  case 850: /* bfd_show_sessions_args: bfd_show_sessions_args CF_SYM_KNOWN  */
#line 259 "proto/bfd/config.Y"
                                       { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.bssc)->name = (yyvsp[0].s); }
#line 11876 "obj/conf/cf-parse.tab.c"
    break;

  case 851: /* bfd_show_sessions_args: bfd_show_sessions_args ADDRESS net_or_ipa  */
#line 260 "proto/bfd/config.Y"
                                             { net_copy(&((yyval.bssc)->address), &((yyvsp[0].net))); }
#line 11882 "obj/conf/cf-parse.tab.c"
    break;

  case 852: /* bfd_show_sessions_args: bfd_show_sessions_args INTERFACE text  */
#line 261 "proto/bfd/config.Y"
                                         { (yyval.bssc)->iface = if_get_by_name((yyvsp[0].t)); }
#line 11888 "obj/conf/cf-parse.tab.c"
    break;

  case 853: /* bfd_show_sessions_args: bfd_show_sessions_args DEV text  */
#line 262 "proto/bfd/config.Y"
                                   { (yyval.bssc)->iface = if_get_by_name((yyvsp[0].t)); }
#line 11894 "obj/conf/cf-parse.tab.c"
    break;

  case 854: /* bfd_show_sessions_args: bfd_show_sessions_args ALL  */
#line 263 "proto/bfd/config.Y"
                              { (yyval.bssc)->verbose = 1; }
#line 11900 "obj/conf/cf-parse.tab.c"
    break;

  case 855: /* bfd_show_sessions_args: bfd_show_sessions_args IPV4  */
#line 264 "proto/bfd/config.Y"
                               { (yyval.bssc)->ipv4 = 1; if ((yyval.bssc)->ipv6) cf_error("Options 'ipv4' and 'ipv6' are mutually exclusive"); }
#line 11906 "obj/conf/cf-parse.tab.c"
    break;

  case 856: /* bfd_show_sessions_args: bfd_show_sessions_args IPV6  */
#line 265 "proto/bfd/config.Y"
                               { (yyval.bssc)->ipv6 = 1; if ((yyval.bssc)->ipv4) cf_error("Options 'ipv4' and 'ipv6' are mutually exclusive"); }
#line 11912 "obj/conf/cf-parse.tab.c"
    break;

  case 857: /* bfd_show_sessions_args: bfd_show_sessions_args DIRECT  */
#line 266 "proto/bfd/config.Y"
                                 { (yyval.bssc)->direct = 1; if ((yyval.bssc)->multihop) cf_error("Options 'direct' and 'multihop' are mutually exclusive"); }
#line 11918 "obj/conf/cf-parse.tab.c"
    break;

  case 858: /* bfd_show_sessions_args: bfd_show_sessions_args MULTIHOP  */
#line 267 "proto/bfd/config.Y"
                                   { (yyval.bssc)->multihop = 1; if ((yyval.bssc)->direct) cf_error("Options 'direct' and 'multihop' are mutually exclusive"); }
#line 11924 "obj/conf/cf-parse.tab.c"
    break;

  case 860: /* babel_proto_start: proto_start BABEL  */
#line 37 "proto/babel/config.Y"
{
  this_proto = proto_config_new(&proto_babel, (yyvsp[-1].i));
  init_list(&BABEL_CFG->iface_list);
  BABEL_CFG->hold_time = 1 S_;
}
#line 11934 "obj/conf/cf-parse.tab.c"
    break;

  case 864: /* babel_proto_item: RANDOMIZE ROUTER ID bool  */
#line 47 "proto/babel/config.Y"
                            { BABEL_CFG->randomize_router_id = (yyvsp[0].i); }
#line 11940 "obj/conf/cf-parse.tab.c"
    break;

  case 868: /* babel_iface_start: %empty  */
#line 60 "proto/babel/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct babel_iface_config));
  add_tail(&BABEL_CFG->iface_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  reset_passwords();

  this_proto->loop_order = DOMAIN_ORDER(proto);
  BABEL_IFACE->port = BABEL_PORT;
  BABEL_IFACE->type = BABEL_IFACE_TYPE_WIRED;
  BABEL_IFACE->limit = BABEL_HELLO_LIMIT;
  BABEL_IFACE->tx_tos = IP_PREC_INTERNET_CONTROL;
  BABEL_IFACE->tx_priority = sk_priority_control;
  BABEL_IFACE->rtt_min = BABEL_RTT_MIN;
  BABEL_IFACE->rtt_max = BABEL_RTT_MAX;
  BABEL_IFACE->rtt_decay = BABEL_RTT_DECAY;
  BABEL_IFACE->rtt_send = 1;
  BABEL_IFACE->check_link = 1;
  BABEL_IFACE->ext_next_hop = 1;
}
#line 11964 "obj/conf/cf-parse.tab.c"
    break;

  case 869: /* babel_iface_finish: %empty  */
#line 82 "proto/babel/config.Y"
{
  if (BABEL_IFACE->type == BABEL_IFACE_TYPE_WIRELESS)
  {
    if (!BABEL_IFACE->hello_interval)
      BABEL_IFACE->hello_interval = BABEL_HELLO_INTERVAL_WIRELESS;
    if (!BABEL_IFACE->rxcost)
      BABEL_IFACE->rxcost = BABEL_RXCOST_WIRELESS;
  }
  else
  {
    if (!BABEL_IFACE->hello_interval)
      BABEL_IFACE->hello_interval = BABEL_HELLO_INTERVAL_WIRED;
    if (!BABEL_IFACE->rxcost)
      BABEL_IFACE->rxcost = BABEL_RXCOST_WIRED;
    if (BABEL_IFACE->type == BABEL_IFACE_TYPE_TUNNEL && !BABEL_IFACE->rtt_cost)
      BABEL_IFACE->rtt_cost = BABEL_RXCOST_RTT;
  }

  if (BABEL_IFACE->rtt_cost && !BABEL_IFACE->rtt_send)
    cf_error("Can't set RTT cost when sending timestamps is disabled");

  if (BABEL_IFACE->rtt_min >= BABEL_IFACE->rtt_max)
    cf_error("Min RTT must be smaller than max RTT");

  /* Make sure we do not overflow the 16-bit centisec fields */
  if (!BABEL_IFACE->update_interval)
    BABEL_IFACE->update_interval = MIN_(BABEL_IFACE->hello_interval*BABEL_UPDATE_INTERVAL_FACTOR, BABEL_MAX_INTERVAL);
  BABEL_IFACE->ihu_interval = MIN_(BABEL_IFACE->hello_interval*BABEL_IHU_INTERVAL_FACTOR, BABEL_MAX_INTERVAL);

  BABEL_CFG->hold_time = MAX_(BABEL_CFG->hold_time, BABEL_IFACE->update_interval*BABEL_HOLD_TIME_FACTOR);

  BABEL_IFACE->passwords = get_passwords();

  if (!BABEL_IFACE->auth_type != !BABEL_IFACE->passwords)
    cf_error("Authentication and password options should be used together");

  if (BABEL_IFACE->passwords)
  {
    struct password_item *pass;
    uint len = 0, i = 0;

    WALK_LIST(pass, *BABEL_IFACE->passwords)
    {
      /* Set default crypto algorithm (HMAC-SHA256) */
      if (!pass->alg)
	pass->alg = ALG_HMAC_SHA256;

      if (!((pass->alg & ALG_HMAC) ||
	    (pass->alg == ALG_BLAKE2S_128) ||
	    (pass->alg == ALG_BLAKE2S_256) ||
	    (pass->alg == ALG_BLAKE2B_256) ||
	    (pass->alg == ALG_BLAKE2B_512)))
	cf_error("Only HMAC and Blake2 algorithms are supported");

      len += mac_type_length(pass->alg);
      i++;
    }

    BABEL_IFACE->mac_num_keys = i;
    BABEL_IFACE->mac_total_len = len;
  }

}
#line 12032 "obj/conf/cf-parse.tab.c"
    break;

  case 871: /* babel_iface_item: PORT expr  */
#line 148 "proto/babel/config.Y"
             { BABEL_IFACE->port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 12038 "obj/conf/cf-parse.tab.c"
    break;

  case 872: /* babel_iface_item: RXCOST expr  */
#line 149 "proto/babel/config.Y"
               { BABEL_IFACE->rxcost = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid rxcost"); }
#line 12044 "obj/conf/cf-parse.tab.c"
    break;

  case 873: /* babel_iface_item: LIMIT expr  */
#line 150 "proto/babel/config.Y"
              { BABEL_IFACE->limit = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>16)) cf_error("Limit must be in range 1-16"); }
#line 12050 "obj/conf/cf-parse.tab.c"
    break;

  case 874: /* babel_iface_item: TYPE WIRED  */
#line 151 "proto/babel/config.Y"
              { BABEL_IFACE->type = BABEL_IFACE_TYPE_WIRED; }
#line 12056 "obj/conf/cf-parse.tab.c"
    break;

  case 875: /* babel_iface_item: TYPE WIRELESS  */
#line 152 "proto/babel/config.Y"
                 { BABEL_IFACE->type = BABEL_IFACE_TYPE_WIRELESS; }
#line 12062 "obj/conf/cf-parse.tab.c"
    break;

  case 876: /* babel_iface_item: TYPE TUNNEL  */
#line 153 "proto/babel/config.Y"
               { BABEL_IFACE->type = BABEL_IFACE_TYPE_TUNNEL; }
#line 12068 "obj/conf/cf-parse.tab.c"
    break;

  case 877: /* babel_iface_item: HELLO INTERVAL expr_us  */
#line 154 "proto/babel/config.Y"
                          { BABEL_IFACE->hello_interval = (yyvsp[0].time); if (((yyvsp[0].time)<BABEL_MIN_INTERVAL) || ((yyvsp[0].time)>BABEL_MAX_INTERVAL)) cf_error("Hello interval must be in range 10 ms - 655 s"); }
#line 12074 "obj/conf/cf-parse.tab.c"
    break;

  case 878: /* babel_iface_item: UPDATE INTERVAL expr_us  */
#line 155 "proto/babel/config.Y"
                           { BABEL_IFACE->update_interval = (yyvsp[0].time); if (((yyvsp[0].time)<BABEL_MIN_INTERVAL) || ((yyvsp[0].time)>BABEL_MAX_INTERVAL)) cf_error("Update interval must be in range 10 ms - 655 s"); }
#line 12080 "obj/conf/cf-parse.tab.c"
    break;

  case 879: /* babel_iface_item: RX BUFFER expr  */
#line 156 "proto/babel/config.Y"
                  { BABEL_IFACE->rx_buffer = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("RX buffer must be in range 256-65535"); }
#line 12086 "obj/conf/cf-parse.tab.c"
    break;

  case 880: /* babel_iface_item: TX LENGTH expr  */
#line 157 "proto/babel/config.Y"
                  { BABEL_IFACE->tx_length = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("TX length must be in range 256-65535"); }
#line 12092 "obj/conf/cf-parse.tab.c"
    break;

  case 881: /* babel_iface_item: TX tos  */
#line 158 "proto/babel/config.Y"
          { BABEL_IFACE->tx_tos = (yyvsp[0].i); }
#line 12098 "obj/conf/cf-parse.tab.c"
    break;

  case 882: /* babel_iface_item: TX PRIORITY expr  */
#line 159 "proto/babel/config.Y"
                    { BABEL_IFACE->tx_priority = (yyvsp[0].i); }
#line 12104 "obj/conf/cf-parse.tab.c"
    break;

  case 883: /* babel_iface_item: CHECK LINK bool  */
#line 160 "proto/babel/config.Y"
                   { BABEL_IFACE->check_link = (yyvsp[0].i); }
#line 12110 "obj/conf/cf-parse.tab.c"
    break;

  case 884: /* babel_iface_item: NEXT HOP IPV4 ipa  */
#line 161 "proto/babel/config.Y"
                     { BABEL_IFACE->next_hop_ip4 = (yyvsp[0].a); if (!ipa_is_ip4((yyvsp[0].a))) cf_error("Must be an IPv4 address"); }
#line 12116 "obj/conf/cf-parse.tab.c"
    break;

  case 885: /* babel_iface_item: NEXT HOP IPV6 ipa  */
#line 162 "proto/babel/config.Y"
                     { BABEL_IFACE->next_hop_ip6 = (yyvsp[0].a); if (!ipa_is_ip6((yyvsp[0].a))) cf_error("Must be an IPv6 address"); }
#line 12122 "obj/conf/cf-parse.tab.c"
    break;

  case 886: /* babel_iface_item: NEXT HOP PREFER NATIVE  */
#line 163 "proto/babel/config.Y"
                          { BABEL_IFACE->next_hop_prefer = BABEL_NHP_NATIVE; }
#line 12128 "obj/conf/cf-parse.tab.c"
    break;

  case 887: /* babel_iface_item: NEXT HOP PREFER IPV6  */
#line 164 "proto/babel/config.Y"
                        { BABEL_IFACE->next_hop_prefer = BABEL_NHP_IP6; }
#line 12134 "obj/conf/cf-parse.tab.c"
    break;

  case 888: /* babel_iface_item: EXTENDED NEXT HOP bool  */
#line 165 "proto/babel/config.Y"
                          { BABEL_IFACE->ext_next_hop = (yyvsp[0].i); }
#line 12140 "obj/conf/cf-parse.tab.c"
    break;

  case 889: /* babel_iface_item: AUTHENTICATION NONE  */
#line 166 "proto/babel/config.Y"
                       { BABEL_IFACE->auth_type = BABEL_AUTH_NONE; }
#line 12146 "obj/conf/cf-parse.tab.c"
    break;

  case 890: /* babel_iface_item: AUTHENTICATION MAC  */
#line 167 "proto/babel/config.Y"
                      { BABEL_IFACE->auth_type = BABEL_AUTH_MAC; BABEL_IFACE->auth_permissive = 0; }
#line 12152 "obj/conf/cf-parse.tab.c"
    break;

  case 891: /* babel_iface_item: AUTHENTICATION MAC PERMISSIVE  */
#line 168 "proto/babel/config.Y"
                                 { BABEL_IFACE->auth_type = BABEL_AUTH_MAC; BABEL_IFACE->auth_permissive = 1; }
#line 12158 "obj/conf/cf-parse.tab.c"
    break;

  case 892: /* babel_iface_item: RTT MIN expr_us  */
#line 169 "proto/babel/config.Y"
                   { BABEL_IFACE->rtt_min = (yyvsp[0].time); }
#line 12164 "obj/conf/cf-parse.tab.c"
    break;

  case 893: /* babel_iface_item: RTT MAX expr_us  */
#line 170 "proto/babel/config.Y"
                   { BABEL_IFACE->rtt_max = (yyvsp[0].time); }
#line 12170 "obj/conf/cf-parse.tab.c"
    break;

  case 894: /* babel_iface_item: RTT COST expr  */
#line 171 "proto/babel/config.Y"
                 { BABEL_IFACE->rtt_cost = (yyvsp[0].i); if ((yyvsp[0].i) >= BABEL_INFINITY) cf_error("RTT cost must be < 65535"); }
#line 12176 "obj/conf/cf-parse.tab.c"
    break;

  case 895: /* babel_iface_item: RTT DECAY expr  */
#line 172 "proto/babel/config.Y"
                  { BABEL_IFACE->rtt_decay = (yyvsp[0].i); if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 256)) cf_error("RTT decay must be between 1-256"); }
#line 12182 "obj/conf/cf-parse.tab.c"
    break;

  case 896: /* babel_iface_item: SEND TIMESTAMPS bool  */
#line 173 "proto/babel/config.Y"
                        { BABEL_IFACE->rtt_send = (yyvsp[0].i); }
#line 12188 "obj/conf/cf-parse.tab.c"
    break;

  case 904: /* cmd_SHOW_BABEL_INTERFACES: SHOW BABEL INTERFACES optproto opttext END  */
#line 194 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p) babel_show_interfaces(p, (yyvsp[-1].t)); }
#line 12194 "obj/conf/cf-parse.tab.c"
    break;

  case 906: /* cmd_SHOW_BABEL_NEIGHBORS: SHOW BABEL NEIGHBORS optproto opttext END  */
#line 197 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p) babel_show_neighbors(p, (yyvsp[-1].t)); }
#line 12200 "obj/conf/cf-parse.tab.c"
    break;

  case 908: /* cmd_SHOW_BABEL_ENTRIES: SHOW BABEL ENTRIES optproto opttext END  */
#line 200 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p) babel_show_entries(p); }
#line 12206 "obj/conf/cf-parse.tab.c"
    break;

  case 910: /* cmd_SHOW_BABEL_ROUTES: SHOW BABEL ROUTES optproto opttext END  */
#line 203 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p)  babel_show_routes(p); }
#line 12212 "obj/conf/cf-parse.tab.c"
    break;

  case 912: /* bgp_proto_start: proto_start BGP  */
#line 58 "proto/bgp/config.Y"
                                 {
     this_proto = proto_config_new(&proto_bgp, (yyvsp[-1].i));
     this_proto->loop_order = DOMAIN_ORDER(proto);
     BGP_CFG->local_port = BGP_PORT;
     BGP_CFG->remote_port = BGP_PORT;
     BGP_CFG->multihop = -1;	/* undefined */
     BGP_CFG->hold_time = 240;
     BGP_CFG->initial_hold_time = 240;
     BGP_CFG->compare_path_lengths = 1;
     BGP_CFG->igp_metric = 1;
     BGP_CFG->connect_delay_time = 5;
     BGP_CFG->connect_retry_time = 120;
     BGP_CFG->error_amnesia_time = 300;
     BGP_CFG->error_delay_time_min = 60;
     BGP_CFG->error_delay_time_max = 300;
     BGP_CFG->enable_refresh = 1;
     BGP_CFG->enable_enhanced_refresh = 1;
     BGP_CFG->enable_as4 = 1;
     BGP_CFG->enable_hostname = 0;
     BGP_CFG->capabilities = 2;
     BGP_CFG->interpret_communities = 1;
     BGP_CFG->allow_as_sets = 0;
     BGP_CFG->default_local_pref = 100;
     BGP_CFG->gr_mode = BGP_GR_AWARE;
     BGP_CFG->gr_time = 120;
     BGP_CFG->min_gr_time = 0;
     BGP_CFG->max_gr_time = ~0U;
     BGP_CFG->llgr_mode = -1;
     BGP_CFG->llgr_time = 3600;
     BGP_CFG->min_llgr_time = 0;
     BGP_CFG->max_llgr_time = ~0U;
     BGP_CFG->setkey = 1;
     BGP_CFG->local_role = BGP_ROLE_UNDEFINED;
     BGP_CFG->dynamic_name = "dynbgp";
     BGP_CFG->check_link = -1;
     BGP_CFG->send_hold_time = -1;
     BGP_CFG->tx_size_warning = 0;
   }
#line 12255 "obj/conf/cf-parse.tab.c"
    break;

  case 914: /* bgp_loc_opts: bgp_loc_opts PORT expr  */
#line 100 "proto/bgp/config.Y"
                          { BGP_CFG->local_port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 12261 "obj/conf/cf-parse.tab.c"
    break;

  case 915: /* bgp_loc_opts: bgp_loc_opts AS expr  */
#line 101 "proto/bgp/config.Y"
                        { BGP_CFG->local_as = (yyvsp[0].i); }
#line 12267 "obj/conf/cf-parse.tab.c"
    break;

  case 917: /* bgp_nbr_opts: bgp_nbr_opts PORT expr  */
#line 106 "proto/bgp/config.Y"
                          { BGP_CFG->remote_port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 12273 "obj/conf/cf-parse.tab.c"
    break;

  case 918: /* bgp_nbr_opts: bgp_nbr_opts AS expr  */
#line 107 "proto/bgp/config.Y"
                        { BGP_CFG->remote_as = (yyvsp[0].i); }
#line 12279 "obj/conf/cf-parse.tab.c"
    break;

  case 919: /* bgp_nbr_opts: bgp_nbr_opts INTERNAL  */
#line 108 "proto/bgp/config.Y"
                         { BGP_CFG->peer_type = BGP_PT_INTERNAL; }
#line 12285 "obj/conf/cf-parse.tab.c"
    break;

  case 920: /* bgp_nbr_opts: bgp_nbr_opts EXTERNAL  */
#line 109 "proto/bgp/config.Y"
                         { BGP_CFG->peer_type = BGP_PT_EXTERNAL; }
#line 12291 "obj/conf/cf-parse.tab.c"
    break;

  case 921: /* bgp_nbr_opts: bgp_nbr_opts ONLINK  */
#line 110 "proto/bgp/config.Y"
                       { BGP_CFG->onlink = 1; }
#line 12297 "obj/conf/cf-parse.tab.c"
    break;

  case 922: /* bgp_cease_mask: bool  */
#line 115 "proto/bgp/config.Y"
        { (yyval.i) = (yyvsp[0].i) ? ~(1 << 7) : 0; }
#line 12303 "obj/conf/cf-parse.tab.c"
    break;

  case 923: /* bgp_cease_mask: '{' bgp_cease_list '}'  */
#line 116 "proto/bgp/config.Y"
                          { (yyval.i) = (yyvsp[-1].i); }
#line 12309 "obj/conf/cf-parse.tab.c"
    break;

  case 925: /* bgp_cease_list: bgp_cease_list ',' bgp_cease_flag  */
#line 121 "proto/bgp/config.Y"
                                     { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 12315 "obj/conf/cf-parse.tab.c"
    break;

  case 926: /* bgp_cease_flag: CEASE  */
#line 125 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 0; }
#line 12321 "obj/conf/cf-parse.tab.c"
    break;

  case 927: /* bgp_cease_flag: PREFIX LIMIT HIT  */
#line 126 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 1; }
#line 12327 "obj/conf/cf-parse.tab.c"
    break;

  case 928: /* bgp_cease_flag: ADMINISTRATIVE SHUTDOWN  */
#line 127 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 2; }
#line 12333 "obj/conf/cf-parse.tab.c"
    break;

  case 929: /* bgp_cease_flag: PEER DECONFIGURED  */
#line 128 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 3; }
#line 12339 "obj/conf/cf-parse.tab.c"
    break;

  case 930: /* bgp_cease_flag: ADMINISTRATIVE RESET  */
#line 129 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 4; }
#line 12345 "obj/conf/cf-parse.tab.c"
    break;

  case 931: /* bgp_cease_flag: CONNECTION REJECTED  */
#line 130 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 5; }
#line 12351 "obj/conf/cf-parse.tab.c"
    break;

  case 932: /* bgp_cease_flag: CONFIGURATION CHANGE  */
#line 131 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 6; }
#line 12357 "obj/conf/cf-parse.tab.c"
    break;

  case 933: /* bgp_cease_flag: CONNECTION COLLISION  */
#line 132 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 7; }
#line 12363 "obj/conf/cf-parse.tab.c"
    break;

  case 934: /* bgp_cease_flag: OUT OF RESOURCES  */
#line 133 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 8; }
#line 12369 "obj/conf/cf-parse.tab.c"
    break;

  case 935: /* bgp_auth_type: NONE  */
#line 137 "proto/bgp/config.Y"
                { (yyval.i) = BGP_AUTH_NONE; }
#line 12375 "obj/conf/cf-parse.tab.c"
    break;

  case 936: /* bgp_auth_type: MD5  */
#line 138 "proto/bgp/config.Y"
                { (yyval.i) = BGP_AUTH_MD5; }
#line 12381 "obj/conf/cf-parse.tab.c"
    break;

  case 937: /* bgp_auth_type: AO  */
#line 139 "proto/bgp/config.Y"
                { (yyval.i) = BGP_AUTH_AO; }
#line 12387 "obj/conf/cf-parse.tab.c"
    break;

  case 938: /* bgp_role_name: PEER  */
#line 143 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_PEER; }
#line 12393 "obj/conf/cf-parse.tab.c"
    break;

  case 939: /* bgp_role_name: PROVIDER  */
#line 144 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_PROVIDER; }
#line 12399 "obj/conf/cf-parse.tab.c"
    break;

  case 940: /* bgp_role_name: CUSTOMER  */
#line 145 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_CUSTOMER; }
#line 12405 "obj/conf/cf-parse.tab.c"
    break;

  case 941: /* bgp_role_name: RS_SERVER  */
#line 146 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_RS_SERVER; }
#line 12411 "obj/conf/cf-parse.tab.c"
    break;

  case 942: /* bgp_role_name: RS_CLIENT  */
#line 147 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_RS_CLIENT; }
#line 12417 "obj/conf/cf-parse.tab.c"
    break;

  case 948: /* bgp_proto: bgp_proto LOCAL ipa ipa_scope bgp_loc_opts ';'  */
#line 156 "proto/bgp/config.Y"
                                                  {
     BGP_CFG->local_ip = (yyvsp[-3].a);
     if ((yyvsp[-2].iface)) BGP_CFG->iface = (yyvsp[-2].iface);
   }
#line 12426 "obj/conf/cf-parse.tab.c"
    break;

  case 950: /* bgp_proto: bgp_proto NEIGHBOR ipa ipa_scope bgp_nbr_opts ';'  */
#line 161 "proto/bgp/config.Y"
                                                     {
     if (ipa_nonzero(BGP_CFG->remote_ip) || BGP_CFG->remote_range)
       cf_error("Only one neighbor per BGP instance is allowed");
     BGP_CFG->remote_ip = (yyvsp[-3].a);
     if ((yyvsp[-2].iface)) BGP_CFG->iface = (yyvsp[-2].iface);
   }
#line 12437 "obj/conf/cf-parse.tab.c"
    break;

  case 951: /* bgp_proto: bgp_proto NEIGHBOR RANGE net_ip bgp_nbr_opts ';'  */
#line 167 "proto/bgp/config.Y"
                                                    {
     if (ipa_nonzero(BGP_CFG->remote_ip) || BGP_CFG->remote_range)
       cf_error("Only one neighbor per BGP instance is allowed");
     net_addr *n = cfg_alloc((yyvsp[-2].net).length);
     net_copy(n, &((yyvsp[-2].net)));
     BGP_CFG->remote_range = n;
   }
#line 12449 "obj/conf/cf-parse.tab.c"
    break;

  case 952: /* bgp_proto: bgp_proto INTERFACE text ';'  */
#line 174 "proto/bgp/config.Y"
                                { BGP_CFG->iface = if_get_by_name((yyvsp[-1].t)); }
#line 12455 "obj/conf/cf-parse.tab.c"
    break;

  case 953: /* bgp_proto: bgp_proto INTERFACE RANGE iface_patt_init iface_patt_list_nopx ';'  */
#line 175 "proto/bgp/config.Y"
                                                                      { BGP_CFG->ipatt = this_ipatt; }
#line 12461 "obj/conf/cf-parse.tab.c"
    break;

  case 954: /* bgp_proto: bgp_proto ONLINK bool ';'  */
#line 176 "proto/bgp/config.Y"
                             { BGP_CFG->onlink = (yyvsp[-1].i); }
#line 12467 "obj/conf/cf-parse.tab.c"
    break;

  case 955: /* bgp_proto: bgp_proto RR CLUSTER ID idval ';'  */
#line 177 "proto/bgp/config.Y"
                                     { BGP_CFG->rr_cluster_id = (yyvsp[-1].i32); }
#line 12473 "obj/conf/cf-parse.tab.c"
    break;

  case 956: /* bgp_proto: bgp_proto RR CLIENT bool ';'  */
#line 178 "proto/bgp/config.Y"
                                { BGP_CFG->rr_client = (yyvsp[-1].i); }
#line 12479 "obj/conf/cf-parse.tab.c"
    break;

  case 957: /* bgp_proto: bgp_proto RS CLIENT bool ';'  */
#line 179 "proto/bgp/config.Y"
                                { BGP_CFG->rs_client = (yyvsp[-1].i); }
#line 12485 "obj/conf/cf-parse.tab.c"
    break;

  case 958: /* bgp_proto: bgp_proto CONFEDERATION expr ';'  */
#line 180 "proto/bgp/config.Y"
                                    { BGP_CFG->confederation = (yyvsp[-1].i); }
#line 12491 "obj/conf/cf-parse.tab.c"
    break;

  case 959: /* bgp_proto: bgp_proto CONFEDERATION MEMBER bool ';'  */
#line 181 "proto/bgp/config.Y"
                                           { BGP_CFG->confederation_member = (yyvsp[-1].i); }
#line 12497 "obj/conf/cf-parse.tab.c"
    break;

  case 960: /* bgp_proto: bgp_proto HOLD TIME expr ';'  */
#line 182 "proto/bgp/config.Y"
                                { BGP_CFG->hold_time = (yyvsp[-1].i); if (((yyvsp[-1].i) && (yyvsp[-1].i)<3) || ((yyvsp[-1].i)>65535)) cf_error("Hold time must be in range 3-65535 or zero"); }
#line 12503 "obj/conf/cf-parse.tab.c"
    break;

  case 961: /* bgp_proto: bgp_proto MIN HOLD TIME expr ';'  */
#line 183 "proto/bgp/config.Y"
                                    { BGP_CFG->min_hold_time = (yyvsp[-1].i); }
#line 12509 "obj/conf/cf-parse.tab.c"
    break;

  case 962: /* bgp_proto: bgp_proto STARTUP HOLD TIME expr ';'  */
#line 184 "proto/bgp/config.Y"
                                        { BGP_CFG->initial_hold_time = (yyvsp[-1].i); }
#line 12515 "obj/conf/cf-parse.tab.c"
    break;

  case 963: /* bgp_proto: bgp_proto DIRECT ';'  */
#line 185 "proto/bgp/config.Y"
                        { BGP_CFG->multihop = 0; }
#line 12521 "obj/conf/cf-parse.tab.c"
    break;

  case 964: /* bgp_proto: bgp_proto MULTIHOP ';'  */
#line 186 "proto/bgp/config.Y"
                          { BGP_CFG->multihop = 64; }
#line 12527 "obj/conf/cf-parse.tab.c"
    break;

  case 965: /* bgp_proto: bgp_proto MULTIHOP expr ';'  */
#line 187 "proto/bgp/config.Y"
                               { BGP_CFG->multihop = (yyvsp[-1].i); if (((yyvsp[-1].i)<1) || ((yyvsp[-1].i)>255)) cf_error("Multihop must be in range 1-255"); }
#line 12533 "obj/conf/cf-parse.tab.c"
    break;

  case 966: /* bgp_proto: bgp_proto DYNAMIC NAME text ';'  */
#line 188 "proto/bgp/config.Y"
                                   {
     if (strchr((yyvsp[-1].t), '%')) cf_error("Forbidden character '%%' in dynamic name");
     if (strlen((yyvsp[-1].t)) > (SYM_MAX_LEN - 16)) cf_error("Dynamic name too long");
     BGP_CFG->dynamic_name = (yyvsp[-1].t);
   }
#line 12543 "obj/conf/cf-parse.tab.c"
    break;

  case 967: /* bgp_proto: bgp_proto DYNAMIC NAME DIGITS expr ';'  */
#line 193 "proto/bgp/config.Y"
                                          { BGP_CFG->dynamic_name_digits = (yyvsp[-1].i); if ((yyvsp[-1].i)>10) cf_error("Dynamic name digits must be at most 10"); }
#line 12549 "obj/conf/cf-parse.tab.c"
    break;

  case 968: /* bgp_proto: bgp_proto STRICT BIND bool ';'  */
#line 194 "proto/bgp/config.Y"
                                  { BGP_CFG->strict_bind = (yyvsp[-1].i); }
#line 12555 "obj/conf/cf-parse.tab.c"
    break;

  case 969: /* bgp_proto: bgp_proto FREE BIND bool ';'  */
#line 195 "proto/bgp/config.Y"
                                { BGP_CFG->free_bind = (yyvsp[-1].i); }
#line 12561 "obj/conf/cf-parse.tab.c"
    break;

  case 970: /* bgp_proto: bgp_proto PATH METRIC bool ';'  */
#line 196 "proto/bgp/config.Y"
                                  { BGP_CFG->compare_path_lengths = (yyvsp[-1].i); }
#line 12567 "obj/conf/cf-parse.tab.c"
    break;

  case 971: /* bgp_proto: bgp_proto MED METRIC bool ';'  */
#line 197 "proto/bgp/config.Y"
                                 { BGP_CFG->med_metric = (yyvsp[-1].i); }
#line 12573 "obj/conf/cf-parse.tab.c"
    break;

  case 972: /* bgp_proto: bgp_proto IGP METRIC bool ';'  */
#line 198 "proto/bgp/config.Y"
                                 { BGP_CFG->igp_metric = (yyvsp[-1].i); }
#line 12579 "obj/conf/cf-parse.tab.c"
    break;

  case 973: /* bgp_proto: bgp_proto PREFER OLDER bool ';'  */
#line 199 "proto/bgp/config.Y"
                                   { BGP_CFG->prefer_older = (yyvsp[-1].i); }
#line 12585 "obj/conf/cf-parse.tab.c"
    break;

  case 974: /* bgp_proto: bgp_proto DETERMINISTIC MED bool ';'  */
#line 200 "proto/bgp/config.Y"
                                        { BGP_CFG->deterministic_med = (yyvsp[-1].i); }
#line 12591 "obj/conf/cf-parse.tab.c"
    break;

  case 975: /* bgp_proto: bgp_proto DEFAULT BGP_MED expr ';'  */
#line 201 "proto/bgp/config.Y"
                                      { BGP_CFG->default_med = (yyvsp[-1].i); }
#line 12597 "obj/conf/cf-parse.tab.c"
    break;

  case 976: /* bgp_proto: bgp_proto DEFAULT BGP_LOCAL_PREF expr ';'  */
#line 202 "proto/bgp/config.Y"
                                             { BGP_CFG->default_local_pref = (yyvsp[-1].i); }
#line 12603 "obj/conf/cf-parse.tab.c"
    break;

  case 977: /* bgp_proto: bgp_proto SOURCE ADDRESS ipa ';'  */
#line 203 "proto/bgp/config.Y"
                                    { BGP_CFG->local_ip = (yyvsp[-1].a); }
#line 12609 "obj/conf/cf-parse.tab.c"
    break;

  case 978: /* bgp_proto: bgp_proto START DELAY TIME expr ';'  */
#line 204 "proto/bgp/config.Y"
                                       { BGP_CFG->connect_delay_time = (yyvsp[-1].i); cf_warn("%s: Start delay time option is deprecated, use connect delay time", this_proto->name); }
#line 12615 "obj/conf/cf-parse.tab.c"
    break;

  case 979: /* bgp_proto: bgp_proto CONNECT DELAY TIME expr ';'  */
#line 205 "proto/bgp/config.Y"
                                         { BGP_CFG->connect_delay_time = (yyvsp[-1].i); }
#line 12621 "obj/conf/cf-parse.tab.c"
    break;

  case 980: /* bgp_proto: bgp_proto CONNECT RETRY TIME expr ';'  */
#line 206 "proto/bgp/config.Y"
                                         { BGP_CFG->connect_retry_time = (yyvsp[-1].i); }
#line 12627 "obj/conf/cf-parse.tab.c"
    break;

  case 981: /* bgp_proto: bgp_proto KEEPALIVE TIME expr ';'  */
#line 207 "proto/bgp/config.Y"
                                     { BGP_CFG->keepalive_time = (yyvsp[-1].i); if (((yyvsp[-1].i)<1) || ((yyvsp[-1].i)>65535)) cf_error("Keepalive time must be in range 1-65535"); }
#line 12633 "obj/conf/cf-parse.tab.c"
    break;

  case 982: /* bgp_proto: bgp_proto MIN KEEPALIVE TIME expr ';'  */
#line 208 "proto/bgp/config.Y"
                                         { BGP_CFG->min_keepalive_time = (yyvsp[-1].i); }
#line 12639 "obj/conf/cf-parse.tab.c"
    break;

  case 983: /* bgp_proto: bgp_proto SEND HOLD TIME expr ';'  */
#line 209 "proto/bgp/config.Y"
                                    { BGP_CFG->send_hold_time = (yyvsp[-1].i); }
#line 12645 "obj/conf/cf-parse.tab.c"
    break;

  case 984: /* bgp_proto: bgp_proto ERROR FORGET TIME expr ';'  */
#line 210 "proto/bgp/config.Y"
                                        { BGP_CFG->error_amnesia_time = (yyvsp[-1].i); }
#line 12651 "obj/conf/cf-parse.tab.c"
    break;

  case 985: /* bgp_proto: bgp_proto ERROR WAIT TIME expr ',' expr ';'  */
#line 211 "proto/bgp/config.Y"
                                               { BGP_CFG->error_delay_time_min = (yyvsp[-3].i); BGP_CFG->error_delay_time_max = (yyvsp[-1].i); }
#line 12657 "obj/conf/cf-parse.tab.c"
    break;

  case 986: /* bgp_proto: bgp_proto DISABLE AFTER ERROR bool ';'  */
#line 212 "proto/bgp/config.Y"
                                          { BGP_CFG->disable_after_error = (yyvsp[-1].i); }
#line 12663 "obj/conf/cf-parse.tab.c"
    break;

  case 987: /* bgp_proto: bgp_proto DISABLE AFTER CEASE bgp_cease_mask ';'  */
#line 213 "proto/bgp/config.Y"
                                                    { BGP_CFG->disable_after_cease = (yyvsp[-1].i); }
#line 12669 "obj/conf/cf-parse.tab.c"
    break;

  case 988: /* bgp_proto: bgp_proto ENABLE ROUTE REFRESH bool ';'  */
#line 214 "proto/bgp/config.Y"
                                           { BGP_CFG->enable_refresh = (yyvsp[-1].i); }
#line 12675 "obj/conf/cf-parse.tab.c"
    break;

  case 989: /* bgp_proto: bgp_proto ENABLE ENHANCED ROUTE REFRESH bool ';'  */
#line 215 "proto/bgp/config.Y"
                                                    { BGP_CFG->enable_enhanced_refresh = (yyvsp[-1].i); }
#line 12681 "obj/conf/cf-parse.tab.c"
    break;

  case 990: /* bgp_proto: bgp_proto ENABLE AS4 bool ';'  */
#line 216 "proto/bgp/config.Y"
                                 { BGP_CFG->enable_as4 = (yyvsp[-1].i); }
#line 12687 "obj/conf/cf-parse.tab.c"
    break;

  case 991: /* bgp_proto: bgp_proto ENABLE EXTENDED MESSAGES bool ';'  */
#line 217 "proto/bgp/config.Y"
                                               { BGP_CFG->enable_extended_messages = (yyvsp[-1].i); }
#line 12693 "obj/conf/cf-parse.tab.c"
    break;

  case 992: /* bgp_proto: bgp_proto ADVERTISE HOSTNAME bool ';'  */
#line 218 "proto/bgp/config.Y"
                                         { BGP_CFG->enable_hostname = (yyvsp[-1].i); }
#line 12699 "obj/conf/cf-parse.tab.c"
    break;

  case 993: /* bgp_proto: bgp_proto REQUIRE ROUTE REFRESH bool ';'  */
#line 219 "proto/bgp/config.Y"
                                            { BGP_CFG->require_refresh = (yyvsp[-1].i); }
#line 12705 "obj/conf/cf-parse.tab.c"
    break;

  case 994: /* bgp_proto: bgp_proto REQUIRE ENHANCED ROUTE REFRESH bool ';'  */
#line 220 "proto/bgp/config.Y"
                                                     { BGP_CFG->require_enhanced_refresh = (yyvsp[-1].i); }
#line 12711 "obj/conf/cf-parse.tab.c"
    break;

  case 995: /* bgp_proto: bgp_proto REQUIRE AS4 bool ';'  */
#line 221 "proto/bgp/config.Y"
                                  { BGP_CFG->require_as4 = (yyvsp[-1].i); }
#line 12717 "obj/conf/cf-parse.tab.c"
    break;

  case 996: /* bgp_proto: bgp_proto REQUIRE EXTENDED MESSAGES bool ';'  */
#line 222 "proto/bgp/config.Y"
                                                { BGP_CFG->require_extended_messages = (yyvsp[-1].i); }
#line 12723 "obj/conf/cf-parse.tab.c"
    break;

  case 997: /* bgp_proto: bgp_proto REQUIRE HOSTNAME bool ';'  */
#line 223 "proto/bgp/config.Y"
                                       { BGP_CFG->require_hostname = (yyvsp[-1].i); }
#line 12729 "obj/conf/cf-parse.tab.c"
    break;

  case 998: /* bgp_proto: bgp_proto REQUIRE GRACEFUL RESTART bool ';'  */
#line 224 "proto/bgp/config.Y"
                                               { BGP_CFG->require_gr = (yyvsp[-1].i); }
#line 12735 "obj/conf/cf-parse.tab.c"
    break;

  case 999: /* bgp_proto: bgp_proto REQUIRE LONG LIVED GRACEFUL RESTART bool ';'  */
#line 225 "proto/bgp/config.Y"
                                                          { BGP_CFG->require_llgr = (yyvsp[-1].i); }
#line 12741 "obj/conf/cf-parse.tab.c"
    break;

  case 1000: /* bgp_proto: bgp_proto CAPABILITIES bool ';'  */
#line 226 "proto/bgp/config.Y"
                                   { BGP_CFG->capabilities = (yyvsp[-1].i); }
#line 12747 "obj/conf/cf-parse.tab.c"
    break;

  case 1001: /* bgp_proto: bgp_proto AUTHENTICATION bgp_auth_type ';'  */
#line 227 "proto/bgp/config.Y"
                                              { BGP_CFG->auth_type = (yyvsp[-1].i); }
#line 12753 "obj/conf/cf-parse.tab.c"
    break;

  case 1003: /* bgp_proto: bgp_proto PASSWORD text ';'  */
#line 229 "proto/bgp/config.Y"
                               { BGP_CFG->password = (yyvsp[-1].t); }
#line 12759 "obj/conf/cf-parse.tab.c"
    break;

  case 1004: /* bgp_proto: bgp_proto SETKEY bool ';'  */
#line 230 "proto/bgp/config.Y"
                             { BGP_CFG->setkey = (yyvsp[-1].i); }
#line 12765 "obj/conf/cf-parse.tab.c"
    break;

  case 1005: /* bgp_proto: bgp_proto PASSIVE bool ';'  */
#line 231 "proto/bgp/config.Y"
                              { BGP_CFG->passive = (yyvsp[-1].i); }
#line 12771 "obj/conf/cf-parse.tab.c"
    break;

  case 1006: /* bgp_proto: bgp_proto INTERPRET COMMUNITIES bool ';'  */
#line 232 "proto/bgp/config.Y"
                                            { BGP_CFG->interpret_communities = (yyvsp[-1].i); }
#line 12777 "obj/conf/cf-parse.tab.c"
    break;

  case 1007: /* bgp_proto: bgp_proto ALLOW LOCAL AS ';'  */
#line 233 "proto/bgp/config.Y"
                                { BGP_CFG->allow_local_as = -1; }
#line 12783 "obj/conf/cf-parse.tab.c"
    break;

  case 1008: /* bgp_proto: bgp_proto ALLOW LOCAL AS expr ';'  */
#line 234 "proto/bgp/config.Y"
                                     { BGP_CFG->allow_local_as = (yyvsp[-1].i); }
#line 12789 "obj/conf/cf-parse.tab.c"
    break;

  case 1009: /* bgp_proto: bgp_proto ALLOW BGP_LOCAL_PREF bool ';'  */
#line 235 "proto/bgp/config.Y"
                                           { BGP_CFG->allow_local_pref = (yyvsp[-1].i); }
#line 12795 "obj/conf/cf-parse.tab.c"
    break;

  case 1010: /* bgp_proto: bgp_proto ALLOW BGP_MED bool ';'  */
#line 236 "proto/bgp/config.Y"
                                    { BGP_CFG->allow_med = (yyvsp[-1].i); }
#line 12801 "obj/conf/cf-parse.tab.c"
    break;

  case 1011: /* bgp_proto: bgp_proto ALLOW AS SETS bool ';'  */
#line 237 "proto/bgp/config.Y"
                                    { BGP_CFG->allow_as_sets = (yyvsp[-1].i); }
#line 12807 "obj/conf/cf-parse.tab.c"
    break;

  case 1012: /* bgp_proto: bgp_proto GRACEFUL RESTART bool ';'  */
#line 238 "proto/bgp/config.Y"
                                       { BGP_CFG->gr_mode = (yyvsp[-1].i); }
#line 12813 "obj/conf/cf-parse.tab.c"
    break;

  case 1013: /* bgp_proto: bgp_proto GRACEFUL RESTART AWARE ';'  */
#line 239 "proto/bgp/config.Y"
                                        { BGP_CFG->gr_mode = BGP_GR_AWARE; }
#line 12819 "obj/conf/cf-parse.tab.c"
    break;

  case 1014: /* bgp_proto: bgp_proto GRACEFUL RESTART TIME expr ';'  */
#line 240 "proto/bgp/config.Y"
                                            { BGP_CFG->gr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 12)) cf_error("Graceful restart time must be less than 4096"); }
#line 12825 "obj/conf/cf-parse.tab.c"
    break;

  case 1015: /* bgp_proto: bgp_proto MIN GRACEFUL RESTART TIME expr ';'  */
#line 241 "proto/bgp/config.Y"
                                                { BGP_CFG->min_gr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 12)) cf_error("Min graceful restart time must be less than 4096"); }
#line 12831 "obj/conf/cf-parse.tab.c"
    break;

  case 1016: /* bgp_proto: bgp_proto MAX GRACEFUL RESTART TIME expr ';'  */
#line 242 "proto/bgp/config.Y"
                                                { BGP_CFG->max_gr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 12)) cf_error("Max graceful restart time must be less than 4096"); }
#line 12837 "obj/conf/cf-parse.tab.c"
    break;

  case 1017: /* bgp_proto: bgp_proto LONG LIVED GRACEFUL RESTART bool ';'  */
#line 243 "proto/bgp/config.Y"
                                                  { BGP_CFG->llgr_mode = (yyvsp[-1].i); }
#line 12843 "obj/conf/cf-parse.tab.c"
    break;

  case 1018: /* bgp_proto: bgp_proto LONG LIVED GRACEFUL RESTART AWARE ';'  */
#line 244 "proto/bgp/config.Y"
                                                   { BGP_CFG->llgr_mode = BGP_LLGR_AWARE; }
#line 12849 "obj/conf/cf-parse.tab.c"
    break;

  case 1019: /* bgp_proto: bgp_proto LONG LIVED STALE TIME expr ';'  */
#line 245 "proto/bgp/config.Y"
                                            { BGP_CFG->llgr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 24)) cf_error("Long-lived stale time must be less than 2^24"); }
#line 12855 "obj/conf/cf-parse.tab.c"
    break;

  case 1020: /* bgp_proto: bgp_proto MIN LONG LIVED STALE TIME expr ';'  */
#line 246 "proto/bgp/config.Y"
                                                { BGP_CFG->min_llgr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 24)) cf_error("Min long-lived stale time must be less than 2^24"); }
#line 12861 "obj/conf/cf-parse.tab.c"
    break;

  case 1021: /* bgp_proto: bgp_proto MAX LONG LIVED STALE TIME expr ';'  */
#line 247 "proto/bgp/config.Y"
                                                { BGP_CFG->max_llgr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 24)) cf_error("Max long-lived stale time must be less than 2^24"); }
#line 12867 "obj/conf/cf-parse.tab.c"
    break;

  case 1022: /* bgp_proto: bgp_proto TTL SECURITY bool ';'  */
#line 248 "proto/bgp/config.Y"
                                   { BGP_CFG->ttl_security = (yyvsp[-1].i); }
#line 12873 "obj/conf/cf-parse.tab.c"
    break;

  case 1023: /* bgp_proto: bgp_proto CHECK LINK bool ';'  */
#line 249 "proto/bgp/config.Y"
                                 { BGP_CFG->check_link = (yyvsp[-1].i); }
#line 12879 "obj/conf/cf-parse.tab.c"
    break;

  case 1024: /* bgp_proto: bgp_proto BFD bool ';'  */
#line 250 "proto/bgp/config.Y"
                          { if ((yyvsp[-1].i)) init_bfd_opts(&BGP_CFG->bfd); else BGP_CFG->bfd = NULL; }
#line 12885 "obj/conf/cf-parse.tab.c"
    break;

  case 1025: /* bgp_proto: bgp_proto BFD GRACEFUL ';'  */
#line 251 "proto/bgp/config.Y"
                              { init_bfd_opts(&BGP_CFG->bfd); BGP_CFG->bfd->mode = BGP_BFD_GRACEFUL; }
#line 12891 "obj/conf/cf-parse.tab.c"
    break;

  case 1026: /* $@18: %empty  */
#line 252 "proto/bgp/config.Y"
                 { open_bfd_opts(&BGP_CFG->bfd); }
#line 12897 "obj/conf/cf-parse.tab.c"
    break;

  case 1027: /* $@19: %empty  */
#line 252 "proto/bgp/config.Y"
                                                            { close_bfd_opts(); }
#line 12903 "obj/conf/cf-parse.tab.c"
    break;

  case 1029: /* bgp_proto: bgp_proto ENFORCE FIRST AS bool ';'  */
#line 253 "proto/bgp/config.Y"
                                       { BGP_CFG->enforce_first_as = (yyvsp[-1].i); }
#line 12909 "obj/conf/cf-parse.tab.c"
    break;

  case 1030: /* bgp_proto: bgp_proto LOCAL ROLE bgp_role_name ';'  */
#line 254 "proto/bgp/config.Y"
                                          { BGP_CFG->local_role = (yyvsp[-1].i); }
#line 12915 "obj/conf/cf-parse.tab.c"
    break;

  case 1031: /* bgp_proto: bgp_proto REQUIRE ROLES bool ';'  */
#line 255 "proto/bgp/config.Y"
                                    { BGP_CFG->require_roles = (yyvsp[-1].i); }
#line 12921 "obj/conf/cf-parse.tab.c"
    break;

  case 1032: /* bgp_proto: bgp_proto DISABLE RX bool ';'  */
#line 256 "proto/bgp/config.Y"
                                 { BGP_CFG->disable_rx = (yyvsp[-1].i); }
#line 12927 "obj/conf/cf-parse.tab.c"
    break;

  case 1033: /* bgp_proto: bgp_proto TX SIZE WARNING expr ';'  */
#line 257 "proto/bgp/config.Y"
                                      { BGP_CFG->tx_size_warning = (yyvsp[-1].i); }
#line 12933 "obj/conf/cf-parse.tab.c"
    break;

  case 1034: /* bgp_afi: IPV4  */
#line 261 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV4; }
#line 12939 "obj/conf/cf-parse.tab.c"
    break;

  case 1035: /* bgp_afi: IPV6  */
#line 262 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV6; }
#line 12945 "obj/conf/cf-parse.tab.c"
    break;

  case 1036: /* bgp_afi: IPV4 MULTICAST  */
#line 263 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV4_MC; }
#line 12951 "obj/conf/cf-parse.tab.c"
    break;

  case 1037: /* bgp_afi: IPV6 MULTICAST  */
#line 264 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV6_MC; }
#line 12957 "obj/conf/cf-parse.tab.c"
    break;

  case 1038: /* bgp_afi: IPV4 MPLS  */
#line 265 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV4_MPLS; }
#line 12963 "obj/conf/cf-parse.tab.c"
    break;

  case 1039: /* bgp_afi: IPV6 MPLS  */
#line 266 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV6_MPLS; }
#line 12969 "obj/conf/cf-parse.tab.c"
    break;

  case 1040: /* bgp_afi: VPN4 MPLS  */
#line 267 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN4_MPLS; }
#line 12975 "obj/conf/cf-parse.tab.c"
    break;

  case 1041: /* bgp_afi: VPN6 MPLS  */
#line 268 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN6_MPLS; }
#line 12981 "obj/conf/cf-parse.tab.c"
    break;

  case 1042: /* bgp_afi: VPN4 MULTICAST  */
#line 269 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN4_MC; }
#line 12987 "obj/conf/cf-parse.tab.c"
    break;

  case 1043: /* bgp_afi: VPN6 MULTICAST  */
#line 270 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN6_MC; }
#line 12993 "obj/conf/cf-parse.tab.c"
    break;

  case 1044: /* bgp_afi: FLOW4  */
#line 271 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_FLOW4; }
#line 12999 "obj/conf/cf-parse.tab.c"
    break;

  case 1045: /* bgp_afi: FLOW6  */
#line 272 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_FLOW6; }
#line 13005 "obj/conf/cf-parse.tab.c"
    break;

  case 1046: /* tcp_ao_key_start: KEY  */
#line 275 "proto/bgp/config.Y"
                      {
  this_ao_key = cfg_allocz(sizeof(struct ao_config));
  *next_ao_key = this_ao_key;
  next_ao_key = &(this_ao_key->next);

  this_ao_key->key.send_id = -1;
  this_ao_key->key.recv_id = -1;
  this_ao_key->key.algorithm = ALG_HMAC_SHA1;
}
#line 13019 "obj/conf/cf-parse.tab.c"
    break;

  case 1047: /* tcp_ao_key_opt: ID expr ';'  */
#line 286 "proto/bgp/config.Y"
               {
     if ((yyvsp[-1].i) > 255)
       cf_error("Key ID must be in range 0-255");
     this_ao_key->key.send_id = (yyvsp[-1].i);
     this_ao_key->key.recv_id = (yyvsp[-1].i);
   }
#line 13030 "obj/conf/cf-parse.tab.c"
    break;

  case 1048: /* tcp_ao_key_opt: SEND ID expr ';'  */
#line 292 "proto/bgp/config.Y"
                    {
     if ((yyvsp[-1].i) > 255)
       cf_error("Send ID must be in range 0-255");
     this_ao_key->key.send_id = (yyvsp[-1].i);
   }
#line 13040 "obj/conf/cf-parse.tab.c"
    break;

  case 1049: /* tcp_ao_key_opt: RECV ID expr ';'  */
#line 297 "proto/bgp/config.Y"
                    {
     if ((yyvsp[-1].i) > 255)
       cf_error("Recv ID must be in range 0-255");
     this_ao_key->key.recv_id = (yyvsp[-1].i);
   }
#line 13050 "obj/conf/cf-parse.tab.c"
    break;

  case 1050: /* tcp_ao_key_opt: ALGORITHM tcp_ao_algorithm ';'  */
#line 302 "proto/bgp/config.Y"
                                  {
     if (!tcp_ao_alg_known((yyvsp[-1].i)))
       cf_error("Unknown algorithm for TCP-AO");
     this_ao_key->key.algorithm = (yyvsp[-1].i);
   }
#line 13060 "obj/conf/cf-parse.tab.c"
    break;

  case 1051: /* tcp_ao_key_opt: SECRET bytestring_or_text ';'  */
#line 307 "proto/bgp/config.Y"
                                 {
     if ((yyvsp[-1].v).type == T_BYTESTRING)
     {
       this_ao_key->key.key = (yyvsp[-1].v).val.bs->data;
       this_ao_key->key.keylen = (yyvsp[-1].v).val.bs->length;
     }
     else if ((yyvsp[-1].v).type == T_STRING)
     {
       this_ao_key->key.key = (yyvsp[-1].v).val.s;
       this_ao_key->key.keylen = strlen((yyvsp[-1].v).val.s);
     }
     else bug("Bad bytestring_or_text");

     if (this_ao_key->key.keylen > AO_MAX_KEY_LENGTH)
       cf_error("TCP-AO secret too long");
   }
#line 13081 "obj/conf/cf-parse.tab.c"
    break;

  case 1052: /* tcp_ao_key_opt: DEPRECATED ';'  */
#line 323 "proto/bgp/config.Y"
                  {
     if (this_ao_key->key.preference > 0)
       cf_error("Key cannot be both preferred and deprecated");
     this_ao_key->key.preference = -1;
   }
#line 13091 "obj/conf/cf-parse.tab.c"
    break;

  case 1053: /* tcp_ao_key_opt: PREFERRED ';'  */
#line 328 "proto/bgp/config.Y"
                 {
     if (this_ao_key->key.preference < 0)
       cf_error("Key cannot be both preferred and deprecated");
     this_ao_key->key.preference = 1;
   }
#line 13101 "obj/conf/cf-parse.tab.c"
    break;

  case 1054: /* tcp_ao_algorithm: password_algorithm  */
#line 336 "proto/bgp/config.Y"
                      { (yyval.i) = (yyvsp[0].i); }
#line 13107 "obj/conf/cf-parse.tab.c"
    break;

  case 1055: /* tcp_ao_algorithm: CMAC AES128  */
#line 337 "proto/bgp/config.Y"
               { (yyval.i) = ALG_CMAC_AES128_AO; }
#line 13113 "obj/conf/cf-parse.tab.c"
    break;

  case 1058: /* tcp_ao_key_end: %empty  */
#line 345 "proto/bgp/config.Y"
                {
  struct ao_config *key = this_ao_key;
  this_ao_key = NULL;

  if (key->key.send_id == -1)
    cf_error("No key Send ID");
  if (key->key.recv_id == -1)
    cf_error("No key Recv ID");
  if (!key->key.key || !key->key.keylen)
    cf_error("No secret defined for key %i/%i", key->key.send_id, key->key.recv_id);
}
#line 13129 "obj/conf/cf-parse.tab.c"
    break;

  case 1061: /* tcp_ao_keys: tcp_ao_keys tcp_ao_key ';'  */
#line 361 "proto/bgp/config.Y"
                              { }
#line 13135 "obj/conf/cf-parse.tab.c"
    break;

  case 1062: /* $@20: %empty  */
#line 365 "proto/bgp/config.Y"
       { next_ao_key = &(BGP_CFG->ao_keys); }
#line 13141 "obj/conf/cf-parse.tab.c"
    break;

  case 1063: /* tcp_ao_key_list: '{' $@20 tcp_ao_keys '}'  */
#line 365 "proto/bgp/config.Y"
                                                              { next_ao_key = NULL; }
#line 13147 "obj/conf/cf-parse.tab.c"
    break;

  case 1064: /* tcp_ao_end: %empty  */
#line 369 "proto/bgp/config.Y"
{
  char used_aos_id_send[256];
  char used_aos_id_recv[256];
  memset(used_aos_id_send, 0, sizeof(char)*256);
  memset(used_aos_id_recv, 0, sizeof(char)*256);

  for (struct ao_config *key = BGP_CFG->ao_keys; key; key = key->next)
  {
    if (used_aos_id_send[key->key.send_id])
      cf_error("Multiple keys with Send ID %i", key->key.send_id);
    used_aos_id_send[key->key.send_id] = 1;

    if (used_aos_id_recv[key->key.recv_id])
      cf_error("Multiple keys with Recv ID %i", key->key.recv_id);
    used_aos_id_recv[key->key.recv_id] = 1;
  }
}
#line 13169 "obj/conf/cf-parse.tab.c"
    break;

  case 1065: /* bgp_channel_start: bgp_afi  */
#line 388 "proto/bgp/config.Y"
{
  const struct bgp_af_desc *desc = bgp_get_af_desc((yyvsp[0].i32));

  if (!desc)
    cf_error("Unknown AFI/SAFI");

  this_channel = channel_config_get(&channel_bgp, desc->name, desc->net, this_proto);

  /* New channel */
  if (!BGP_CC->desc)
  {
    BGP_CC->c.in_filter = FILTER_UNDEF;
    BGP_CC->c.out_filter = FILTER_UNDEF;
    BGP_CC->c.ra_mode = RA_UNDEF;
    BGP_CC->afi = (yyvsp[0].i32);
    BGP_CC->desc = desc;
    BGP_CC->next_hop_keep = 0xff; /* undefined */
    BGP_CC->gr_able = 0xff;	/* undefined */
    BGP_CC->llgr_able = 0xff;	/* undefined */
    BGP_CC->llgr_time = ~0U;	/* undefined */
    BGP_CC->min_llgr_time = ~0U; /* undefined */
    BGP_CC->max_llgr_time = ~0U; /* undefined */
    BGP_CC->aigp = 0xff;	/* undefined */
    BGP_CC->ptx_exporter_settle = (struct settle_config) { 10 MS_, 100 MS_ };
  }
}
#line 13200 "obj/conf/cf-parse.tab.c"
    break;

  case 1066: /* bgp_nh: bool  */
#line 416 "proto/bgp/config.Y"
        { (yyval.i) = (yyvsp[0].i); }
#line 13206 "obj/conf/cf-parse.tab.c"
    break;

  case 1067: /* bgp_nh: IBGP  */
#line 417 "proto/bgp/config.Y"
        { (yyval.i) = NH_IBGP; }
#line 13212 "obj/conf/cf-parse.tab.c"
    break;

  case 1068: /* bgp_nh: EBGP  */
#line 418 "proto/bgp/config.Y"
        { (yyval.i) = NH_EBGP; }
#line 13218 "obj/conf/cf-parse.tab.c"
    break;

  case 1069: /* bgp_llnh: NATIVE  */
#line 422 "proto/bgp/config.Y"
          { (yyval.i) = LLNH_NATIVE; }
#line 13224 "obj/conf/cf-parse.tab.c"
    break;

  case 1070: /* bgp_llnh: SINGLE  */
#line 423 "proto/bgp/config.Y"
          { (yyval.i) = LLNH_SINGLE; }
#line 13230 "obj/conf/cf-parse.tab.c"
    break;

  case 1071: /* bgp_llnh: DOUBLE  */
#line 424 "proto/bgp/config.Y"
          { (yyval.i) = LLNH_DOUBLE; }
#line 13236 "obj/conf/cf-parse.tab.c"
    break;

  case 1076: /* bgp_channel_item: NEXT HOP ADDRESS ipa  */
#line 431 "proto/bgp/config.Y"
                        { BGP_CC->next_hop_addr = (yyvsp[0].a); }
#line 13242 "obj/conf/cf-parse.tab.c"
    break;

  case 1077: /* bgp_channel_item: NEXT HOP SELF bgp_nh  */
#line 432 "proto/bgp/config.Y"
                        { BGP_CC->next_hop_self = (yyvsp[0].i); }
#line 13248 "obj/conf/cf-parse.tab.c"
    break;

  case 1078: /* bgp_channel_item: NEXT HOP KEEP bgp_nh  */
#line 433 "proto/bgp/config.Y"
                        { BGP_CC->next_hop_keep = (yyvsp[0].i); }
#line 13254 "obj/conf/cf-parse.tab.c"
    break;

  case 1079: /* bgp_channel_item: NEXT HOP PREFER GLOBAL  */
#line 434 "proto/bgp/config.Y"
                          { BGP_CC->next_hop_prefer = NHP_GLOBAL; }
#line 13260 "obj/conf/cf-parse.tab.c"
    break;

  case 1080: /* bgp_channel_item: NEXT HOP PREFER LOCAL  */
#line 435 "proto/bgp/config.Y"
                          { BGP_CC->next_hop_prefer = NHP_LOCAL;  }
#line 13266 "obj/conf/cf-parse.tab.c"
    break;

  case 1081: /* bgp_channel_item: LINK LOCAL NEXT HOP FORMAT bgp_llnh  */
#line 436 "proto/bgp/config.Y"
                                       { BGP_CC->llnh_format = (yyvsp[0].i); }
#line 13272 "obj/conf/cf-parse.tab.c"
    break;

  case 1082: /* bgp_channel_item: MANDATORY bool  */
#line 437 "proto/bgp/config.Y"
                  { BGP_CC->mandatory = (yyvsp[0].i); }
#line 13278 "obj/conf/cf-parse.tab.c"
    break;

  case 1083: /* bgp_channel_item: MISSING LLADDR bgp_lladdr  */
#line 438 "proto/bgp/config.Y"
                             { cf_warn("%s.%s: Missing lladdr option is deprecated and ignored, remove it", this_proto->name, this_channel->name); }
#line 13284 "obj/conf/cf-parse.tab.c"
    break;

  case 1084: /* bgp_channel_item: GATEWAY DIRECT  */
#line 439 "proto/bgp/config.Y"
                  { BGP_CC->gw_mode = GW_DIRECT; }
#line 13290 "obj/conf/cf-parse.tab.c"
    break;

  case 1085: /* bgp_channel_item: GATEWAY RECURSIVE  */
#line 440 "proto/bgp/config.Y"
                     { BGP_CC->gw_mode = GW_RECURSIVE; }
#line 13296 "obj/conf/cf-parse.tab.c"
    break;

  case 1086: /* bgp_channel_item: SECONDARY bool  */
#line 441 "proto/bgp/config.Y"
                  { BGP_CC->secondary = (yyvsp[0].i); }
#line 13302 "obj/conf/cf-parse.tab.c"
    break;

  case 1087: /* bgp_channel_item: VALIDATE bool  */
#line 442 "proto/bgp/config.Y"
                 {
    BGP_CC->validate = (yyvsp[0].i);
    if (BGP_SAFI(BGP_CC->afi) != BGP_SAFI_FLOW)
      cf_error("Validate option limited to flowspec channels");
   }
#line 13312 "obj/conf/cf-parse.tab.c"
    break;

  case 1088: /* bgp_channel_item: GRACEFUL RESTART bool  */
#line 447 "proto/bgp/config.Y"
                         { BGP_CC->gr_able = (yyvsp[0].i); }
#line 13318 "obj/conf/cf-parse.tab.c"
    break;

  case 1089: /* bgp_channel_item: LONG LIVED GRACEFUL RESTART bool  */
#line 448 "proto/bgp/config.Y"
                                    { BGP_CC->llgr_able = (yyvsp[0].i); }
#line 13324 "obj/conf/cf-parse.tab.c"
    break;

  case 1090: /* bgp_channel_item: LONG LIVED STALE TIME expr  */
#line 449 "proto/bgp/config.Y"
                              { BGP_CC->llgr_time = (yyvsp[0].i); if ((yyvsp[0].i) >= (1 << 24)) cf_error("Long-lived stale time must be less than 2^24"); }
#line 13330 "obj/conf/cf-parse.tab.c"
    break;

  case 1091: /* bgp_channel_item: MIN LONG LIVED STALE TIME expr  */
#line 450 "proto/bgp/config.Y"
                                  { BGP_CC->min_llgr_time = (yyvsp[0].i); if ((yyvsp[0].i) >= (1 << 24)) cf_error("Min long-lived stale time must be less than 2^24"); }
#line 13336 "obj/conf/cf-parse.tab.c"
    break;

  case 1092: /* bgp_channel_item: MAX LONG LIVED STALE TIME expr  */
#line 451 "proto/bgp/config.Y"
                                  { BGP_CC->max_llgr_time = (yyvsp[0].i); if ((yyvsp[0].i) >= (1 << 24)) cf_error("Max long-lived stale time must be less than 2^24"); }
#line 13342 "obj/conf/cf-parse.tab.c"
    break;

  case 1093: /* bgp_channel_item: EXTENDED NEXT HOP bool  */
#line 452 "proto/bgp/config.Y"
                          { BGP_CC->ext_next_hop = (yyvsp[0].i); }
#line 13348 "obj/conf/cf-parse.tab.c"
    break;

  case 1094: /* bgp_channel_item: REQUIRE EXTENDED NEXT HOP bool  */
#line 453 "proto/bgp/config.Y"
                                  { BGP_CC->require_ext_next_hop = (yyvsp[0].i);  if (BGP_AFI(BGP_CC->afi) != BGP_AFI_IPV4) cf_warn("Require extended next hop option ignored for non-IPv4 channels"); }
#line 13354 "obj/conf/cf-parse.tab.c"
    break;

  case 1095: /* bgp_channel_item: ADD PATHS RX  */
#line 454 "proto/bgp/config.Y"
                { BGP_CC->add_path = BGP_ADD_PATH_RX; }
#line 13360 "obj/conf/cf-parse.tab.c"
    break;

  case 1096: /* bgp_channel_item: ADD PATHS TX  */
#line 455 "proto/bgp/config.Y"
                { BGP_CC->add_path = BGP_ADD_PATH_TX; }
#line 13366 "obj/conf/cf-parse.tab.c"
    break;

  case 1097: /* bgp_channel_item: ADD PATHS bool  */
#line 456 "proto/bgp/config.Y"
                  { BGP_CC->add_path = (yyvsp[0].i) ? BGP_ADD_PATH_FULL : 0; }
#line 13372 "obj/conf/cf-parse.tab.c"
    break;

  case 1098: /* bgp_channel_item: REQUIRE ADD PATHS bool  */
#line 457 "proto/bgp/config.Y"
                          { BGP_CC->require_add_path = (yyvsp[0].i); }
#line 13378 "obj/conf/cf-parse.tab.c"
    break;

  case 1099: /* bgp_channel_item: IMPORT TABLE bool  */
#line 458 "proto/bgp/config.Y"
                     { BGP_CC->import_table = (yyvsp[0].i); }
#line 13384 "obj/conf/cf-parse.tab.c"
    break;

  case 1100: /* bgp_channel_item: EXPORT TABLE bool  */
#line 459 "proto/bgp/config.Y"
                     { BGP_CC->export_table = (yyvsp[0].i); }
#line 13390 "obj/conf/cf-parse.tab.c"
    break;

  case 1101: /* bgp_channel_item: EXPORT SETTLE TIME settle  */
#line 460 "proto/bgp/config.Y"
                             { BGP_CC->ptx_exporter_settle = (yyvsp[0].settle); }
#line 13396 "obj/conf/cf-parse.tab.c"
    break;

  case 1102: /* bgp_channel_item: AIGP bool  */
#line 461 "proto/bgp/config.Y"
             { BGP_CC->aigp = (yyvsp[0].i); BGP_CC->aigp_originate = 0; }
#line 13402 "obj/conf/cf-parse.tab.c"
    break;

  case 1103: /* bgp_channel_item: AIGP ORIGINATE  */
#line 462 "proto/bgp/config.Y"
                  { BGP_CC->aigp = 1; BGP_CC->aigp_originate = 1; }
#line 13408 "obj/conf/cf-parse.tab.c"
    break;

  case 1104: /* bgp_channel_item: COST expr  */
#line 463 "proto/bgp/config.Y"
             { BGP_CC->cost = (yyvsp[0].i); if ((yyvsp[0].i) < 1) cf_error("Cost must be positive"); }
#line 13414 "obj/conf/cf-parse.tab.c"
    break;

  case 1105: /* bgp_channel_item: IGP TABLE rtable  */
#line 464 "proto/bgp/config.Y"
                    {
    if (BGP_CC->desc->no_igp)
      cf_error("IGP table not allowed here");

    if ((yyvsp[0].r)->addr_type == NET_IP4)
      BGP_CC->igp_table_ip4 = (yyvsp[0].r);
    else if ((yyvsp[0].r)->addr_type == NET_IP6)
      BGP_CC->igp_table_ip6 = (yyvsp[0].r);
    else
      cf_error("Mismatched IGP table type");
   }
#line 13430 "obj/conf/cf-parse.tab.c"
    break;

  case 1106: /* bgp_channel_item: BASE TABLE rtable  */
#line 475 "proto/bgp/config.Y"
                     {
    if (BGP_SAFI(BGP_CC->afi) != BGP_SAFI_FLOW)
      cf_error("Base table option limited to flowspec channels");

    if (((BGP_CC->afi == BGP_AF_FLOW4) && ((yyvsp[0].r)->addr_type == NET_IP4)) ||
        ((BGP_CC->afi == BGP_AF_FLOW6) && ((yyvsp[0].r)->addr_type == NET_IP6)))
      BGP_CC->base_table = (yyvsp[0].r);
    else
      cf_error("Mismatched base table type");
   }
#line 13445 "obj/conf/cf-parse.tab.c"
    break;

  case 1111: /* bgp_channel_end: %empty  */
#line 498 "proto/bgp/config.Y"
{
  if (!this_channel->table)
    cf_error("Routing table not specified");

  if (BGP_CC->import_table)
    this_channel->in_keep |= RIK_PREFILTER;

  this_channel = NULL;
}
#line 13459 "obj/conf/cf-parse.tab.c"
    break;

  case 1113: /* custom_attr: ATTRIBUTE BGP NUM type symbol ';'  */
#line 510 "proto/bgp/config.Y"
                                               {
  if ((yyvsp[-3].i) > 255 || (yyvsp[-3].i) < 1)
    cf_error("Invalid attribute number. (Given %i, must be 1-255.)", (yyvsp[-3].i));

  struct ea_class *ac = bgp_find_ea_class_by_id((yyvsp[-3].i));
  ASSERT_DIE(ac);
  if ((yyvsp[-2].i) != ac->type)
    cf_error("Attribute %d type must be %s, not %s.", (yyvsp[-3].i), f_type_name(ac->type), f_type_name((yyvsp[-2].i)));

  ea_ref_class(new_config->pool, ac);
  cf_define_symbol(new_config, (yyvsp[-1].s), SYM_ATTRIBUTE, attribute, ac);
}
#line 13476 "obj/conf/cf-parse.tab.c"
    break;

  case 1115: /* cmd_RELOAD_BGP: RELOAD BGP proto_patt END  */
#line 524 "proto/bgp/config.Y"
{
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_in, 1, 0);
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_out, 1, 0);
}
#line 13485 "obj/conf/cf-parse.tab.c"
    break;

  case 1117: /* cmd_RELOAD_BGP_IN: RELOAD BGP IN proto_patt END  */
#line 530 "proto/bgp/config.Y"
{
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_in, 1, 0);
}
#line 13493 "obj/conf/cf-parse.tab.c"
    break;

  case 1119: /* cmd_RELOAD_BGP_OUT: RELOAD BGP OUT proto_patt END  */
#line 535 "proto/bgp/config.Y"
{
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_out, 1, 0);
}
#line 13501 "obj/conf/cf-parse.tab.c"
    break;

  case 1120: /* term: ASPA_CHECK_DOWNSTREAM '(' rtable ')'  */
#line 540 "proto/bgp/config.Y"
                                           { (yyval.x) =
  f_new_inst(FI_ASPA_CHECK_EXPLICIT,
      f_new_inst(FI_EA_GET,
	f_new_inst(FI_CURRENT_ROUTE),
	ea_class_find_by_name("bgp_path")
      ),
      f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 0, }),
      (yyvsp[-1].r)
  );
}
#line 13516 "obj/conf/cf-parse.tab.c"
    break;

  case 1121: /* term: ASPA_CHECK_UPSTREAM '(' rtable ')'  */
#line 551 "proto/bgp/config.Y"
                                         { (yyval.x) =
  f_new_inst(FI_ASPA_CHECK_EXPLICIT,
      f_new_inst(FI_EA_GET,
	f_new_inst(FI_CURRENT_ROUTE),
	ea_class_find_by_name("bgp_path")
      ),
      f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 1, }),
      (yyvsp[-1].r)
  );
}
#line 13531 "obj/conf/cf-parse.tab.c"
    break;

  case 1123: /* l3vpn_channel_start: net_type_base  */
#line 53 "proto/l3vpn/config.Y"
{
  /* Redefining proto_channel to change default values */
  (yyval.cc) = this_channel = channel_config_get(NULL, net_label[(yyvsp[0].i)], (yyvsp[0].i), this_proto);
  if (!this_channel->copy)
  {
    this_channel->out_filter = FILTER_ACCEPT;
    this_channel->preference = net_val_match((yyvsp[0].i), NB_IP) ?
      DEF_PREF_L3VPN_IMPORT :
      DEF_PREF_L3VPN_EXPORT;
  }
}
#line 13547 "obj/conf/cf-parse.tab.c"
    break;

  case 1125: /* l3vpn_proto_start: proto_start L3VPN  */
#line 68 "proto/l3vpn/config.Y"
{
  this_proto = proto_config_new(&proto_l3vpn, (yyvsp[-1].i));

  L3VPN_CFG->import_target = RT_UNDEF;
  L3VPN_CFG->export_target = RT_UNDEF;
}
#line 13558 "obj/conf/cf-parse.tab.c"
    break;

  case 1129: /* l3vpn_proto_item: RD VPN_RD  */
#line 80 "proto/l3vpn/config.Y"
             { L3VPN_CFG->rd = (yyvsp[0].rd); }
#line 13564 "obj/conf/cf-parse.tab.c"
    break;

  case 1130: /* l3vpn_proto_item: ROUTE DISTINGUISHER VPN_RD  */
#line 81 "proto/l3vpn/config.Y"
                              { L3VPN_CFG->rd = (yyvsp[0].rd); }
#line 13570 "obj/conf/cf-parse.tab.c"
    break;

  case 1131: /* l3vpn_proto_item: IMPORT TARGET ALL  */
#line 82 "proto/l3vpn/config.Y"
                     { L3VPN_CFG->import_target = RT_ALL; }
#line 13576 "obj/conf/cf-parse.tab.c"
    break;

  case 1132: /* l3vpn_proto_item: IMPORT TARGET l3vpn_targets  */
#line 83 "proto/l3vpn/config.Y"
                               { L3VPN_CFG->import_target = (yyvsp[0].e); }
#line 13582 "obj/conf/cf-parse.tab.c"
    break;

  case 1133: /* l3vpn_proto_item: EXPORT TARGET l3vpn_targets  */
#line 84 "proto/l3vpn/config.Y"
                               { L3VPN_CFG->export_target = (yyvsp[0].e); }
#line 13588 "obj/conf/cf-parse.tab.c"
    break;

  case 1134: /* l3vpn_proto_item: ROUTE TARGET l3vpn_targets  */
#line 85 "proto/l3vpn/config.Y"
                              { L3VPN_CFG->import_target = L3VPN_CFG->export_target = (yyvsp[0].e); }
#line 13594 "obj/conf/cf-parse.tab.c"
    break;

  case 1138: /* l3vpn_targets: ec_item  */
#line 98 "proto/l3vpn/config.Y"
           { f_tree_only_rt((yyvsp[0].e)); (yyval.e) = (yyvsp[0].e); }
#line 13600 "obj/conf/cf-parse.tab.c"
    break;

  case 1139: /* l3vpn_targets: '[' ec_items ']'  */
#line 99 "proto/l3vpn/config.Y"
                    { f_tree_only_rt((yyvsp[-1].e)); (yyval.e) = build_tree((yyvsp[-1].e), true); }
#line 13606 "obj/conf/cf-parse.tab.c"
    break;

  case 1140: /* l3vpn_targets: '[' ']'  */
#line 100 "proto/l3vpn/config.Y"
           { (yyval.e) = RT_NONE; }
#line 13612 "obj/conf/cf-parse.tab.c"
    break;

  case 1141: /* l3vpn_targets: NONE  */
#line 101 "proto/l3vpn/config.Y"
        { (yyval.e) = RT_NONE; }
#line 13618 "obj/conf/cf-parse.tab.c"
    break;

  case 1142: /* proto: ospf_proto '}'  */
#line 211 "proto/ospf/config.Y"
                      { ospf_proto_finish(); }
#line 13624 "obj/conf/cf-parse.tab.c"
    break;

  case 1143: /* ospf_variant: OSPF  */
#line 214 "proto/ospf/config.Y"
           { (yyval.i) = 1; }
#line 13630 "obj/conf/cf-parse.tab.c"
    break;

  case 1144: /* ospf_variant: OSPF V2  */
#line 215 "proto/ospf/config.Y"
           { (yyval.i) = 1; }
#line 13636 "obj/conf/cf-parse.tab.c"
    break;

  case 1145: /* ospf_variant: OSPF V3  */
#line 216 "proto/ospf/config.Y"
           { (yyval.i) = 0; }
#line 13642 "obj/conf/cf-parse.tab.c"
    break;

  case 1146: /* ospf_proto_start: proto_start ospf_variant  */
#line 220 "proto/ospf/config.Y"
{
  this_proto = proto_config_new(&proto_ospf, (yyvsp[-1].i));
  this_proto->net_type = (yyvsp[0].i) ? NET_IP4 : 0;

  init_list(&OSPF_CFG->area_list);
  init_list(&OSPF_CFG->vlink_list);
  OSPF_CFG->ecmp = rt_default_ecmp;
  OSPF_CFG->tick = OSPF_DEFAULT_TICK;
  OSPF_CFG->ospf2 = (yyvsp[0].i);
  OSPF_CFG->af_ext = !(yyvsp[0].i);
  OSPF_CFG->gr_mode = OSPF_GR_AWARE;
  OSPF_CFG->gr_time = OSPF_DEFAULT_GR_TIME;
}
#line 13660 "obj/conf/cf-parse.tab.c"
    break;

  case 1149: /* ospf_af_mc: %empty  */
#line 240 "proto/ospf/config.Y"
             { (yyval.i) = 0; }
#line 13666 "obj/conf/cf-parse.tab.c"
    break;

  case 1150: /* ospf_af_mc: MULTICAST  */
#line 241 "proto/ospf/config.Y"
             { (yyval.i) = 1; }
#line 13672 "obj/conf/cf-parse.tab.c"
    break;

  case 1151: /* ospf_channel_start: net_type ospf_af_mc  */
#line 246 "proto/ospf/config.Y"
{
  /* TODO: change name for multicast channels */
  (yyval.cc) = this_channel = channel_config_get(NULL, net_label[(yyvsp[-1].i)], (yyvsp[-1].i), this_proto);

  /* Save the multicast flag */
  OSPF_CFG->af_mc = (yyvsp[0].i);
}
#line 13684 "obj/conf/cf-parse.tab.c"
    break;

  case 1154: /* ospf_proto_item: ospf_channel  */
#line 258 "proto/ospf/config.Y"
                { this_proto->net_type = (yyvsp[0].cc)->net_type; }
#line 13690 "obj/conf/cf-parse.tab.c"
    break;

  case 1155: /* ospf_proto_item: RFC1583COMPAT bool  */
#line 259 "proto/ospf/config.Y"
                      { OSPF_CFG->rfc1583 = (yyvsp[0].i); }
#line 13696 "obj/conf/cf-parse.tab.c"
    break;

  case 1156: /* ospf_proto_item: RFC5838 bool  */
#line 260 "proto/ospf/config.Y"
                { OSPF_CFG->af_ext = (yyvsp[0].i); if (!ospf_cfg_is_v3()) cf_error("RFC5838 option requires OSPFv3"); }
#line 13702 "obj/conf/cf-parse.tab.c"
    break;

  case 1157: /* ospf_proto_item: VPN PE bool  */
#line 261 "proto/ospf/config.Y"
               { OSPF_CFG->vpn_pe = (yyvsp[0].i); }
#line 13708 "obj/conf/cf-parse.tab.c"
    break;

  case 1158: /* ospf_proto_item: STUB ROUTER bool  */
#line 262 "proto/ospf/config.Y"
                    { OSPF_CFG->stub_router = (yyvsp[0].i); }
#line 13714 "obj/conf/cf-parse.tab.c"
    break;

  case 1159: /* ospf_proto_item: GRACEFUL RESTART bool  */
#line 263 "proto/ospf/config.Y"
                         { OSPF_CFG->gr_mode = (yyvsp[0].i); }
#line 13720 "obj/conf/cf-parse.tab.c"
    break;

  case 1160: /* ospf_proto_item: GRACEFUL RESTART AWARE  */
#line 264 "proto/ospf/config.Y"
                          { OSPF_CFG->gr_mode = OSPF_GR_AWARE; }
#line 13726 "obj/conf/cf-parse.tab.c"
    break;

  case 1161: /* ospf_proto_item: GRACEFUL RESTART TIME expr  */
#line 265 "proto/ospf/config.Y"
                              { OSPF_CFG->gr_time = (yyvsp[0].i); if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 1800)) cf_error("Graceful restart time must be in range 1-1800"); }
#line 13732 "obj/conf/cf-parse.tab.c"
    break;

  case 1162: /* ospf_proto_item: ECMP bool  */
#line 266 "proto/ospf/config.Y"
             { OSPF_CFG->ecmp = (yyvsp[0].i) ? OSPF_DEFAULT_ECMP_LIMIT : 0; }
#line 13738 "obj/conf/cf-parse.tab.c"
    break;

  case 1163: /* ospf_proto_item: ECMP bool LIMIT expr  */
#line 267 "proto/ospf/config.Y"
                        { OSPF_CFG->ecmp = (yyvsp[-2].i) ? (yyvsp[0].i) : 0; }
#line 13744 "obj/conf/cf-parse.tab.c"
    break;

  case 1164: /* ospf_proto_item: MERGE EXTERNAL bool  */
#line 268 "proto/ospf/config.Y"
                       { OSPF_CFG->merge_external = (yyvsp[0].i); }
#line 13750 "obj/conf/cf-parse.tab.c"
    break;

  case 1165: /* ospf_proto_item: TICK expr  */
#line 269 "proto/ospf/config.Y"
             { OSPF_CFG->tick = (yyvsp[0].i); if((yyvsp[0].i) <= 0) cf_error("Tick must be greater than zero"); }
#line 13756 "obj/conf/cf-parse.tab.c"
    break;

  case 1166: /* ospf_proto_item: INSTANCE ID expr  */
#line 270 "proto/ospf/config.Y"
                    { OSPF_CFG->instance_id = (yyvsp[0].i); OSPF_CFG->instance_id_set = 1; if ((yyvsp[0].i) > 255) cf_error("Instance ID must be in range 0-255"); }
#line 13762 "obj/conf/cf-parse.tab.c"
    break;

  case 1168: /* ospf_area_start: AREA idval  */
#line 274 "proto/ospf/config.Y"
                            {
  this_area = cfg_allocz(sizeof(struct ospf_area_config));
  add_tail(&OSPF_CFG->area_list, NODE this_area);
  this_area->areaid = (yyvsp[0].i32);
  this_area->default_cost = OSPF_DEFAULT_STUB_COST;
  this_area->type = OPT_E;
  this_area->transint = OSPF_DEFAULT_TRANSINT;

  init_list(&this_area->patt_list);
  init_list(&this_area->net_list);
  init_list(&this_area->enet_list);
  init_list(&this_area->stubnet_list);
 }
#line 13780 "obj/conf/cf-parse.tab.c"
    break;

  case 1169: /* ospf_area: ospf_area_start '{' ospf_area_opts '}'  */
#line 289 "proto/ospf/config.Y"
                                                  { ospf_area_finish(); }
#line 13786 "obj/conf/cf-parse.tab.c"
    break;

  case 1172: /* ospf_area_item: STUB bool  */
#line 298 "proto/ospf/config.Y"
             { this_area->type = (yyvsp[0].i) ? 0 : OPT_E; /* We should remove the option */ }
#line 13792 "obj/conf/cf-parse.tab.c"
    break;

  case 1173: /* ospf_area_item: NSSA  */
#line 299 "proto/ospf/config.Y"
        { this_area->type = OPT_N; }
#line 13798 "obj/conf/cf-parse.tab.c"
    break;

  case 1174: /* ospf_area_item: SUMMARY bool  */
#line 300 "proto/ospf/config.Y"
                { this_area->summary = (yyvsp[0].i); }
#line 13804 "obj/conf/cf-parse.tab.c"
    break;

  case 1175: /* ospf_area_item: DEFAULT NSSA bool  */
#line 301 "proto/ospf/config.Y"
                     { this_area->default_nssa = (yyvsp[0].i); }
#line 13810 "obj/conf/cf-parse.tab.c"
    break;

  case 1176: /* ospf_area_item: DEFAULT COST expr  */
#line 302 "proto/ospf/config.Y"
                     { this_area->default_cost = (yyvsp[0].i); ospf_check_defcost((yyvsp[0].i)); }
#line 13816 "obj/conf/cf-parse.tab.c"
    break;

  case 1177: /* ospf_area_item: DEFAULT COST2 expr  */
#line 303 "proto/ospf/config.Y"
                      { this_area->default_cost = (yyvsp[0].i) | LSA_EXT3_EBIT; ospf_check_defcost((yyvsp[0].i)); }
#line 13822 "obj/conf/cf-parse.tab.c"
    break;

  case 1178: /* ospf_area_item: STUB COST expr  */
#line 304 "proto/ospf/config.Y"
                  { this_area->default_cost = (yyvsp[0].i); ospf_check_defcost((yyvsp[0].i)); }
#line 13828 "obj/conf/cf-parse.tab.c"
    break;

  case 1179: /* ospf_area_item: TRANSLATOR bool  */
#line 305 "proto/ospf/config.Y"
                   { this_area->translator = (yyvsp[0].i); }
#line 13834 "obj/conf/cf-parse.tab.c"
    break;

  case 1180: /* ospf_area_item: TRANSLATOR STABILITY expr  */
#line 306 "proto/ospf/config.Y"
                             { this_area->transint = (yyvsp[0].i); }
#line 13840 "obj/conf/cf-parse.tab.c"
    break;

  case 1181: /* $@21: %empty  */
#line 307 "proto/ospf/config.Y"
            { this_nets = &this_area->net_list; }
#line 13846 "obj/conf/cf-parse.tab.c"
    break;

  case 1183: /* $@22: %empty  */
#line 308 "proto/ospf/config.Y"
            { this_nets = &this_area->enet_list; }
#line 13852 "obj/conf/cf-parse.tab.c"
    break;

  case 1190: /* ospf_stubnet_start: net_ip  */
#line 320 "proto/ospf/config.Y"
          {
     this_stubnet = cfg_allocz(sizeof(struct ospf_stubnet_config));
     add_tail(&this_area->stubnet_list, NODE this_stubnet);
     this_stubnet->prefix = (yyvsp[0].net);
     this_stubnet->cost = COST_D;
   }
#line 13863 "obj/conf/cf-parse.tab.c"
    break;

  case 1193: /* ospf_stubnet_item: HIDDEN bool  */
#line 334 "proto/ospf/config.Y"
               { this_stubnet->hidden = (yyvsp[0].i); }
#line 13869 "obj/conf/cf-parse.tab.c"
    break;

  case 1194: /* ospf_stubnet_item: SUMMARY bool  */
#line 335 "proto/ospf/config.Y"
                { this_stubnet->summary = (yyvsp[0].i); }
#line 13875 "obj/conf/cf-parse.tab.c"
    break;

  case 1195: /* ospf_stubnet_item: COST expr  */
#line 336 "proto/ospf/config.Y"
             { this_stubnet->cost = (yyvsp[0].i); }
#line 13881 "obj/conf/cf-parse.tab.c"
    break;

  case 1196: /* ospf_vlink: ospf_vlink_start ospf_instance_id '{' ospf_vlink_opts '}'  */
#line 340 "proto/ospf/config.Y"
                                                             { ospf_iface_finish(); }
#line 13887 "obj/conf/cf-parse.tab.c"
    break;

  case 1197: /* ospf_vlink: ospf_vlink_start ospf_instance_id  */
#line 341 "proto/ospf/config.Y"
                                     { ospf_iface_finish(); }
#line 13893 "obj/conf/cf-parse.tab.c"
    break;

  case 1201: /* ospf_vlink_item: HELLO expr  */
#line 350 "proto/ospf/config.Y"
              { OSPF_PATT->helloint = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Hello interval must be in range 1-65535"); }
#line 13899 "obj/conf/cf-parse.tab.c"
    break;

  case 1202: /* ospf_vlink_item: RETRANSMIT expr  */
#line 351 "proto/ospf/config.Y"
                   { OSPF_PATT->rxmtint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Retransmit int must be greater than one"); }
#line 13905 "obj/conf/cf-parse.tab.c"
    break;

  case 1203: /* ospf_vlink_item: TRANSMIT DELAY expr  */
#line 352 "proto/ospf/config.Y"
                       { OSPF_PATT->inftransdelay = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Transmit delay must be in range 1-65535"); }
#line 13911 "obj/conf/cf-parse.tab.c"
    break;

  case 1204: /* ospf_vlink_item: WAIT expr  */
#line 353 "proto/ospf/config.Y"
             { OSPF_PATT->waitint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Wait interval must be greater than one"); }
#line 13917 "obj/conf/cf-parse.tab.c"
    break;

  case 1205: /* ospf_vlink_item: DEAD expr  */
#line 354 "proto/ospf/config.Y"
             { OSPF_PATT->deadint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead interval must be greater than one"); }
#line 13923 "obj/conf/cf-parse.tab.c"
    break;

  case 1206: /* ospf_vlink_item: DEAD COUNT expr  */
#line 355 "proto/ospf/config.Y"
                   { OSPF_PATT->deadc = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead count must be greater than one"); }
#line 13929 "obj/conf/cf-parse.tab.c"
    break;

  case 1207: /* ospf_vlink_item: AUTHENTICATION NONE  */
#line 356 "proto/ospf/config.Y"
                       { OSPF_PATT->autype = OSPF_AUTH_NONE;  }
#line 13935 "obj/conf/cf-parse.tab.c"
    break;

  case 1208: /* ospf_vlink_item: AUTHENTICATION SIMPLE  */
#line 357 "proto/ospf/config.Y"
                         { OSPF_PATT->autype = OSPF_AUTH_SIMPLE; ospf_check_auth(); }
#line 13941 "obj/conf/cf-parse.tab.c"
    break;

  case 1209: /* ospf_vlink_item: AUTHENTICATION CRYPTOGRAPHIC  */
#line 358 "proto/ospf/config.Y"
                                { OSPF_PATT->autype = OSPF_AUTH_CRYPT; }
#line 13947 "obj/conf/cf-parse.tab.c"
    break;

  case 1211: /* ospf_vlink_start: VIRTUAL LINK idval  */
#line 363 "proto/ospf/config.Y"
 {
  if (this_area->areaid == 0) cf_error("Virtual link cannot be in backbone");
  this_ipatt = cfg_allocz(sizeof(struct ospf_iface_patt));
  add_tail(&OSPF_CFG->vlink_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  OSPF_PATT->voa = this_area->areaid;
  OSPF_PATT->vid = (yyvsp[0].i32);
  OSPF_PATT->helloint = HELLOINT_D;
  OSPF_PATT->rxmtint = RXMTINT_D;
  OSPF_PATT->inftransdelay = INFTRANSDELAY_D;
  OSPF_PATT->deadc = DEADC_D;
  OSPF_PATT->type = OSPF_IT_VLINK;
  init_list(&OSPF_PATT->nbma_list);
  reset_passwords();
 }
#line 13967 "obj/conf/cf-parse.tab.c"
    break;

  case 1212: /* ospf_iface_item: COST expr  */
#line 381 "proto/ospf/config.Y"
             { OSPF_PATT->cost = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Cost must be in range 1-65535"); }
#line 13973 "obj/conf/cf-parse.tab.c"
    break;

  case 1213: /* ospf_iface_item: HELLO expr  */
#line 382 "proto/ospf/config.Y"
              { OSPF_PATT->helloint = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Hello interval must be in range 1-65535"); }
#line 13979 "obj/conf/cf-parse.tab.c"
    break;

  case 1214: /* ospf_iface_item: POLL expr  */
#line 383 "proto/ospf/config.Y"
             { OSPF_PATT->pollint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=0) cf_error("Poll int must be greater than zero"); }
#line 13985 "obj/conf/cf-parse.tab.c"
    break;

  case 1215: /* ospf_iface_item: RETRANSMIT expr  */
#line 384 "proto/ospf/config.Y"
                   { OSPF_PATT->rxmtint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Retransmit int must be greater than one"); }
#line 13991 "obj/conf/cf-parse.tab.c"
    break;

  case 1216: /* ospf_iface_item: WAIT expr  */
#line 385 "proto/ospf/config.Y"
             { OSPF_PATT->waitint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Wait interval must be greater than one"); }
#line 13997 "obj/conf/cf-parse.tab.c"
    break;

  case 1217: /* ospf_iface_item: DEAD expr  */
#line 386 "proto/ospf/config.Y"
             { OSPF_PATT->deadint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead interval must be greater than one"); }
#line 14003 "obj/conf/cf-parse.tab.c"
    break;

  case 1218: /* ospf_iface_item: DEAD COUNT expr  */
#line 387 "proto/ospf/config.Y"
                   { OSPF_PATT->deadc = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead count must be greater than one"); }
#line 14009 "obj/conf/cf-parse.tab.c"
    break;

  case 1219: /* ospf_iface_item: TYPE BROADCAST  */
#line 388 "proto/ospf/config.Y"
                  { OSPF_PATT->type = OSPF_IT_BCAST ; }
#line 14015 "obj/conf/cf-parse.tab.c"
    break;

  case 1220: /* ospf_iface_item: TYPE BCAST  */
#line 389 "proto/ospf/config.Y"
              { OSPF_PATT->type = OSPF_IT_BCAST ; }
#line 14021 "obj/conf/cf-parse.tab.c"
    break;

  case 1221: /* ospf_iface_item: TYPE NONBROADCAST  */
#line 390 "proto/ospf/config.Y"
                     { OSPF_PATT->type = OSPF_IT_NBMA ; }
#line 14027 "obj/conf/cf-parse.tab.c"
    break;

  case 1222: /* ospf_iface_item: TYPE NBMA  */
#line 391 "proto/ospf/config.Y"
             { OSPF_PATT->type = OSPF_IT_NBMA ; }
#line 14033 "obj/conf/cf-parse.tab.c"
    break;

  case 1223: /* ospf_iface_item: TYPE POINTOPOINT  */
#line 392 "proto/ospf/config.Y"
                    { OSPF_PATT->type = OSPF_IT_PTP ; }
#line 14039 "obj/conf/cf-parse.tab.c"
    break;

  case 1224: /* ospf_iface_item: TYPE PTP  */
#line 393 "proto/ospf/config.Y"
            { OSPF_PATT->type = OSPF_IT_PTP ; }
#line 14045 "obj/conf/cf-parse.tab.c"
    break;

  case 1225: /* ospf_iface_item: TYPE POINTOMULTIPOINT  */
#line 394 "proto/ospf/config.Y"
                         { OSPF_PATT->type = OSPF_IT_PTMP ; }
#line 14051 "obj/conf/cf-parse.tab.c"
    break;

  case 1226: /* ospf_iface_item: TYPE PTMP  */
#line 395 "proto/ospf/config.Y"
             { OSPF_PATT->type = OSPF_IT_PTMP ; }
#line 14057 "obj/conf/cf-parse.tab.c"
    break;

  case 1227: /* ospf_iface_item: REAL BROADCAST bool  */
#line 396 "proto/ospf/config.Y"
                       { OSPF_PATT->real_bcast = (yyvsp[0].i); if (!ospf_cfg_is_v2()) cf_error("Real broadcast option requires OSPFv2"); }
#line 14063 "obj/conf/cf-parse.tab.c"
    break;

  case 1228: /* ospf_iface_item: PTP NETMASK bool  */
#line 397 "proto/ospf/config.Y"
                    { OSPF_PATT->ptp_netmask = (yyvsp[0].i); if (!ospf_cfg_is_v2()) cf_error("PtP netmask option requires OSPFv2"); }
#line 14069 "obj/conf/cf-parse.tab.c"
    break;

  case 1229: /* ospf_iface_item: PTP ADDRESS bool  */
#line 398 "proto/ospf/config.Y"
                    { OSPF_PATT->ptp_address = (yyvsp[0].i); if (!ospf_cfg_is_v2()) cf_error("PtP address option requires OSPFv2"); }
#line 14075 "obj/conf/cf-parse.tab.c"
    break;

  case 1230: /* ospf_iface_item: TRANSMIT DELAY expr  */
#line 399 "proto/ospf/config.Y"
                       { OSPF_PATT->inftransdelay = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Transmit delay must be in range 1-65535"); }
#line 14081 "obj/conf/cf-parse.tab.c"
    break;

  case 1231: /* ospf_iface_item: PRIORITY expr  */
#line 400 "proto/ospf/config.Y"
                 { OSPF_PATT->priority = (yyvsp[0].i) ; if ((yyvsp[0].i)>255) cf_error("Priority must be in range 0-255"); }
#line 14087 "obj/conf/cf-parse.tab.c"
    break;

  case 1232: /* ospf_iface_item: STRICT NONBROADCAST bool  */
#line 401 "proto/ospf/config.Y"
                            { OSPF_PATT->strictnbma = (yyvsp[0].i) ; }
#line 14093 "obj/conf/cf-parse.tab.c"
    break;

  case 1233: /* ospf_iface_item: STUB bool  */
#line 402 "proto/ospf/config.Y"
             { OSPF_PATT->stub = (yyvsp[0].i) ; }
#line 14099 "obj/conf/cf-parse.tab.c"
    break;

  case 1234: /* ospf_iface_item: CHECK LINK bool  */
#line 403 "proto/ospf/config.Y"
                   { OSPF_PATT->check_link = (yyvsp[0].i); }
#line 14105 "obj/conf/cf-parse.tab.c"
    break;

  case 1235: /* ospf_iface_item: ECMP WEIGHT expr  */
#line 404 "proto/ospf/config.Y"
                    { OSPF_PATT->ecmp_weight = (yyvsp[0].i) - 1; if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>256)) cf_error("ECMP weight must be in range 1-256"); }
#line 14111 "obj/conf/cf-parse.tab.c"
    break;

  case 1236: /* ospf_iface_item: LINK LSA SUPPRESSION bool  */
#line 405 "proto/ospf/config.Y"
                             { OSPF_PATT->link_lsa_suppression = (yyvsp[0].i); if (!ospf_cfg_is_v3()) cf_error("Link LSA suppression option requires OSPFv3"); }
#line 14117 "obj/conf/cf-parse.tab.c"
    break;

  case 1238: /* ospf_iface_item: AUTHENTICATION NONE  */
#line 407 "proto/ospf/config.Y"
                       { OSPF_PATT->autype = OSPF_AUTH_NONE; }
#line 14123 "obj/conf/cf-parse.tab.c"
    break;

  case 1239: /* ospf_iface_item: AUTHENTICATION SIMPLE  */
#line 408 "proto/ospf/config.Y"
                         { OSPF_PATT->autype = OSPF_AUTH_SIMPLE; ospf_check_auth(); }
#line 14129 "obj/conf/cf-parse.tab.c"
    break;

  case 1240: /* ospf_iface_item: AUTHENTICATION CRYPTOGRAPHIC  */
#line 409 "proto/ospf/config.Y"
                                { OSPF_PATT->autype = OSPF_AUTH_CRYPT; }
#line 14135 "obj/conf/cf-parse.tab.c"
    break;

  case 1241: /* ospf_iface_item: RX BUFFER NORMAL  */
#line 410 "proto/ospf/config.Y"
                    { OSPF_PATT->rx_buffer = 0; }
#line 14141 "obj/conf/cf-parse.tab.c"
    break;

  case 1242: /* ospf_iface_item: RX BUFFER LARGE  */
#line 411 "proto/ospf/config.Y"
                   { OSPF_PATT->rx_buffer = OSPF_MAX_PKT_SIZE; }
#line 14147 "obj/conf/cf-parse.tab.c"
    break;

  case 1243: /* ospf_iface_item: RX BUFFER expr  */
#line 412 "proto/ospf/config.Y"
                  { OSPF_PATT->rx_buffer = (yyvsp[0].i); if (((yyvsp[0].i) < OSPF_MIN_PKT_SIZE) || ((yyvsp[0].i) > OSPF_MAX_PKT_SIZE)) cf_error("Buffer size must be in range 256-65535"); }
#line 14153 "obj/conf/cf-parse.tab.c"
    break;

  case 1244: /* ospf_iface_item: TX tos  */
#line 413 "proto/ospf/config.Y"
          { OSPF_PATT->tx_tos = (yyvsp[0].i); }
#line 14159 "obj/conf/cf-parse.tab.c"
    break;

  case 1245: /* ospf_iface_item: TX PRIORITY expr  */
#line 414 "proto/ospf/config.Y"
                    { OSPF_PATT->tx_priority = (yyvsp[0].i); }
#line 14165 "obj/conf/cf-parse.tab.c"
    break;

  case 1246: /* ospf_iface_item: TX LENGTH expr  */
#line 415 "proto/ospf/config.Y"
                  { OSPF_PATT->tx_length = (yyvsp[0].i); if (((yyvsp[0].i) < OSPF_MIN_PKT_SIZE) || ((yyvsp[0].i) > OSPF_MAX_PKT_SIZE)) cf_error("TX length must be in range 256-65535"); }
#line 14171 "obj/conf/cf-parse.tab.c"
    break;

  case 1247: /* ospf_iface_item: TTL SECURITY bool  */
#line 416 "proto/ospf/config.Y"
                     { OSPF_PATT->ttl_security = (yyvsp[0].i); }
#line 14177 "obj/conf/cf-parse.tab.c"
    break;

  case 1248: /* ospf_iface_item: TTL SECURITY TX ONLY  */
#line 417 "proto/ospf/config.Y"
                        { OSPF_PATT->ttl_security = 2; }
#line 14183 "obj/conf/cf-parse.tab.c"
    break;

  case 1249: /* ospf_iface_item: BFD bool  */
#line 418 "proto/ospf/config.Y"
            { OSPF_PATT->bfd = (yyvsp[0].i); cf_check_bfd((yyvsp[0].i)); }
#line 14189 "obj/conf/cf-parse.tab.c"
    break;

  case 1254: /* pref_base: net_ip  */
#line 430 "proto/ospf/config.Y"
 {
   this_pref = cfg_allocz(sizeof(struct area_net_config));
   add_tail(this_nets, NODE this_pref);
   this_pref->prefix = (yyvsp[0].net);
 }
#line 14199 "obj/conf/cf-parse.tab.c"
    break;

  case 1256: /* pref_opt: HIDDEN  */
#line 439 "proto/ospf/config.Y"
          { this_pref->hidden = 1; }
#line 14205 "obj/conf/cf-parse.tab.c"
    break;

  case 1257: /* pref_opt: TAG expr  */
#line 440 "proto/ospf/config.Y"
            { this_pref->tag = (yyvsp[0].i); }
#line 14211 "obj/conf/cf-parse.tab.c"
    break;

  case 1260: /* nbma_eligible: %empty  */
#line 449 "proto/ospf/config.Y"
             { (yyval.i) = 0; }
#line 14217 "obj/conf/cf-parse.tab.c"
    break;

  case 1261: /* nbma_eligible: ELIGIBLE  */
#line 450 "proto/ospf/config.Y"
            { (yyval.i) = 1; }
#line 14223 "obj/conf/cf-parse.tab.c"
    break;

  case 1262: /* nbma_item: ipa nbma_eligible ';'  */
#line 454 "proto/ospf/config.Y"
 {
   this_nbma = cfg_allocz(sizeof(struct nbma_node));
   add_tail(&OSPF_PATT->nbma_list, NODE this_nbma);
   this_nbma->ip=(yyvsp[-2].a);
   this_nbma->eligible=(yyvsp[-1].i);
 }
#line 14234 "obj/conf/cf-parse.tab.c"
    break;

  case 1263: /* ospf_iface_start: %empty  */
#line 463 "proto/ospf/config.Y"
 {
  this_proto->loop_order = DOMAIN_ORDER(proto);
  this_ipatt = cfg_allocz(sizeof(struct ospf_iface_patt));
  add_tail(&this_area->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  OSPF_PATT->cost = COST_D;
  OSPF_PATT->helloint = HELLOINT_D;
  OSPF_PATT->pollint = POLLINT_D;
  OSPF_PATT->rxmtint = RXMTINT_D;
  OSPF_PATT->inftransdelay = INFTRANSDELAY_D;
  OSPF_PATT->priority = PRIORITY_D;
  OSPF_PATT->deadc = DEADC_D;
  OSPF_PATT->type = OSPF_IT_UNDEF;
  init_list(&OSPF_PATT->nbma_list);
  OSPF_PATT->check_link = 1;
  OSPF_PATT->ptp_netmask = 2; /* not specified */
  OSPF_PATT->ptp_address = 2; /* not specified */
  OSPF_PATT->tx_tos = IP_PREC_INTERNET_CONTROL;
  OSPF_PATT->tx_priority = sk_priority_control;
  reset_passwords();
 }
#line 14260 "obj/conf/cf-parse.tab.c"
    break;

  case 1265: /* ospf_instance_id: INSTANCE expr  */
#line 488 "proto/ospf/config.Y"
                 { OSPF_PATT->instance_id = (yyvsp[0].i); OSPF_PATT->instance_id_set = 1; if ((yyvsp[0].i) > 255) cf_error("Instance ID must be in range 0-255"); }
#line 14266 "obj/conf/cf-parse.tab.c"
    break;

  case 1266: /* $@23: %empty  */
#line 492 "proto/ospf/config.Y"
                   { if (ospf_cfg_is_v3()) iface_patt_check(); }
#line 14272 "obj/conf/cf-parse.tab.c"
    break;

  case 1272: /* ospf_iface: ospf_iface_start ospf_iface_patt_list ospf_iface_opt_list  */
#line 506 "proto/ospf/config.Y"
                                                            { ospf_iface_finish(); }
#line 14278 "obj/conf/cf-parse.tab.c"
    break;

  case 1274: /* cmd_SHOW_OSPF: SHOW OSPF optproto END  */
#line 511 "proto/ospf/config.Y"
{ PROTO_WALK_CMD((yyvsp[-1].s), &proto_ospf, p) ospf_sh(p); }
#line 14284 "obj/conf/cf-parse.tab.c"
    break;

  case 1276: /* cmd_SHOW_OSPF_NEIGHBORS: SHOW OSPF NEIGHBORS optproto opttext END  */
#line 514 "proto/ospf/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_ospf, p) ospf_sh_neigh(p, (yyvsp[-1].t)); }
#line 14290 "obj/conf/cf-parse.tab.c"
    break;

  case 1278: /* cmd_SHOW_OSPF_INTERFACE: SHOW OSPF INTERFACE optproto opttext END  */
#line 517 "proto/ospf/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_ospf, p) ospf_sh_iface(p, (yyvsp[-1].t)); }
#line 14296 "obj/conf/cf-parse.tab.c"
    break;

  case 1280: /* cmd_SHOW_OSPF_TOPOLOGY: SHOW OSPF TOPOLOGY optproto opttext END  */
#line 522 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 0, 1); }
#line 14302 "obj/conf/cf-parse.tab.c"
    break;

  case 1282: /* cmd_SHOW_OSPF_TOPOLOGY_ALL: SHOW OSPF TOPOLOGY ALL optproto opttext END  */
#line 525 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 0, 0); }
#line 14308 "obj/conf/cf-parse.tab.c"
    break;

  case 1284: /* cmd_SHOW_OSPF_STATE: SHOW OSPF STATE optproto opttext END  */
#line 530 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 1, 1); }
#line 14314 "obj/conf/cf-parse.tab.c"
    break;

  case 1286: /* cmd_SHOW_OSPF_STATE_ALL: SHOW OSPF STATE ALL optproto opttext END  */
#line 533 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 1, 0); }
#line 14320 "obj/conf/cf-parse.tab.c"
    break;

  case 1288: /* cmd_SHOW_OSPF_LSADB: SHOW OSPF LSADB lsadb_args END  */
#line 537 "proto/ospf/config.Y"
{
  if (!(yyvsp[-1].ld)->proto)
    (yyvsp[-1].ld)->proto = (struct ospf_proto *) proto_get_named(NULL, &proto_ospf);

  ospf_sh_lsadb((yyvsp[-1].ld));
}
#line 14331 "obj/conf/cf-parse.tab.c"
    break;

  case 1289: /* lsadb_args: %empty  */
#line 553 "proto/ospf/config.Y"
               {
     (yyval.ld) = cfg_allocz(sizeof(struct lsadb_show_data));
   }
#line 14339 "obj/conf/cf-parse.tab.c"
    break;

  case 1290: /* lsadb_args: lsadb_args GLOBAL  */
#line 556 "proto/ospf/config.Y"
                     { (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->scope = LSA_SCOPE_AS; }
#line 14345 "obj/conf/cf-parse.tab.c"
    break;

  case 1291: /* lsadb_args: lsadb_args AREA idval  */
#line 557 "proto/ospf/config.Y"
                         { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->scope = LSA_SCOPE_AREA; (yyval.ld)->area = (yyvsp[0].i32); }
#line 14351 "obj/conf/cf-parse.tab.c"
    break;

  case 1292: /* lsadb_args: lsadb_args LINK  */
#line 558 "proto/ospf/config.Y"
                   { (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->scope = 1; /* hack, 0 is no filter */ }
#line 14357 "obj/conf/cf-parse.tab.c"
    break;

  case 1293: /* lsadb_args: lsadb_args TYPE expr  */
#line 559 "proto/ospf/config.Y"
                        { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->type = (yyvsp[0].i); }
#line 14363 "obj/conf/cf-parse.tab.c"
    break;

  case 1294: /* lsadb_args: lsadb_args LSID idval  */
#line 560 "proto/ospf/config.Y"
                         { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->lsid = (yyvsp[0].i32); }
#line 14369 "obj/conf/cf-parse.tab.c"
    break;

  case 1295: /* lsadb_args: lsadb_args SELF  */
#line 561 "proto/ospf/config.Y"
                   { (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->router = SH_ROUTER_SELF; }
#line 14375 "obj/conf/cf-parse.tab.c"
    break;

  case 1296: /* lsadb_args: lsadb_args ROUTER idval  */
#line 562 "proto/ospf/config.Y"
                           { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->router = (yyvsp[0].i32); }
#line 14381 "obj/conf/cf-parse.tab.c"
    break;

  case 1297: /* lsadb_args: lsadb_args CF_SYM_KNOWN  */
#line 563 "proto/ospf/config.Y"
                           { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->proto = (struct ospf_proto *) proto_get_named((yyvsp[0].s), &proto_ospf); }
#line 14387 "obj/conf/cf-parse.tab.c"
    break;

  case 1298: /* proto: pipe_proto '}'  */
#line 23 "proto/pipe/config.Y"
                      { this_channel = NULL; }
#line 14393 "obj/conf/cf-parse.tab.c"
    break;

  case 1299: /* $@24: %empty  */
#line 26 "proto/pipe/config.Y"
{
  this_proto = proto_config_new(&proto_pipe, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
  PIPE_CFG->max_generation = 16;
}
#line 14403 "obj/conf/cf-parse.tab.c"
    break;

  case 1300: /* pipe_proto_start: proto_start PIPE $@24 proto_name  */
#line 32 "proto/pipe/config.Y"
{
  this_channel = proto_cf_main_channel(this_proto);
  if (!this_channel) {
    this_channel = channel_config_new(NULL, NULL, 0, this_proto);
    this_channel->in_filter = FILTER_ACCEPT;
    this_channel->out_filter = FILTER_ACCEPT;
  }
}
#line 14416 "obj/conf/cf-parse.tab.c"
    break;

  case 1304: /* pipe_proto: pipe_proto IMPORT IN net_any imexport ';'  */
#line 45 "proto/pipe/config.Y"
                                             {
    if (this_channel->net_type && ((yyvsp[-2].net_ptr)->type != this_channel->net_type))
      cf_error("Incompatible export prefilter type");
    PIPE_CFG->in_subprefix = (yyvsp[-2].net_ptr);
    this_channel->in_filter = (yyvsp[-1].f);
  }
#line 14427 "obj/conf/cf-parse.tab.c"
    break;

  case 1305: /* pipe_proto: pipe_proto PEER TABLE rtable ';'  */
#line 51 "proto/pipe/config.Y"
                                    { PIPE_CFG->peer = (yyvsp[-1].r); }
#line 14433 "obj/conf/cf-parse.tab.c"
    break;

  case 1306: /* pipe_proto: pipe_proto MAX GENERATION expr ';'  */
#line 52 "proto/pipe/config.Y"
                                      {
    if (((yyvsp[-1].i) < 1) || ((yyvsp[-1].i) > 254)) cf_error("Max generation must be in range 1..254, got %u", (yyvsp[-1].i));
    PIPE_CFG->max_generation = (yyvsp[-1].i);
  }
#line 14442 "obj/conf/cf-parse.tab.c"
    break;

  case 1308: /* radv_proto_start: proto_start RADV  */
#line 56 "proto/radv/config.Y"
{
  this_proto = proto_config_new(&proto_radv, (yyvsp[-1].i));
  this_proto->net_type = NET_IP6;

  init_list(&RADV_CFG->patt_list);
  init_list(&RADV_CFG->pref_list);
  init_list(&RADV_CFG->rdnss_list);
  init_list(&RADV_CFG->dnssl_list);
  init_list(&RADV_CFG->custom_list);
}
#line 14457 "obj/conf/cf-parse.tab.c"
    break;

  case 1312: /* radv_proto_item: PREFIX radv_prefix  */
#line 71 "proto/radv/config.Y"
                      { add_tail(&RADV_CFG->pref_list, NODE this_radv_prefix); }
#line 14463 "obj/conf/cf-parse.tab.c"
    break;

  case 1313: /* $@25: %empty  */
#line 72 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14469 "obj/conf/cf-parse.tab.c"
    break;

  case 1314: /* radv_proto_item: RDNSS $@25 radv_rdnss  */
#line 72 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_CFG->rdnss_list, &radv_dns_list); }
#line 14475 "obj/conf/cf-parse.tab.c"
    break;

  case 1315: /* $@26: %empty  */
#line 73 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14481 "obj/conf/cf-parse.tab.c"
    break;

  case 1316: /* radv_proto_item: DNSSL $@26 radv_dnssl  */
#line 73 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_CFG->dnssl_list, &radv_dns_list); }
#line 14487 "obj/conf/cf-parse.tab.c"
    break;

  case 1317: /* radv_proto_item: CUSTOM OPTION TYPE expr VALUE bytestring  */
#line 74 "proto/radv/config.Y"
                                            { radv_add_to_custom_list(&RADV_CFG->custom_list, (yyvsp[-2].i), (yyvsp[0].bs)); }
#line 14493 "obj/conf/cf-parse.tab.c"
    break;

  case 1318: /* radv_proto_item: TRIGGER net_ip6  */
#line 75 "proto/radv/config.Y"
                   { RADV_CFG->trigger = (yyvsp[0].net); }
#line 14499 "obj/conf/cf-parse.tab.c"
    break;

  case 1319: /* radv_proto_item: PROPAGATE ROUTES bool  */
#line 76 "proto/radv/config.Y"
                         { RADV_CFG->propagate_routes = (yyvsp[0].i); }
#line 14505 "obj/conf/cf-parse.tab.c"
    break;

  case 1323: /* radv_iface_start: %empty  */
#line 89 "proto/radv/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct radv_iface_config));
  add_tail(&RADV_CFG->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  init_list(&RADV_IFACE->pref_list);
  init_list(&RADV_IFACE->rdnss_list);
  init_list(&RADV_IFACE->dnssl_list);
  init_list(&RADV_IFACE->custom_list);

  RADV_IFACE->min_ra_int = (u32) -1; /* undefined */
  RADV_IFACE->max_ra_int = DEFAULT_MAX_RA_INT;
  RADV_IFACE->min_delay = DEFAULT_MIN_DELAY;
  RADV_IFACE->prefix_linger_time = (u32) -1;
  RADV_IFACE->route_linger_time = (u32) -1;
  RADV_IFACE->current_hop_limit = DEFAULT_CURRENT_HOP_LIMIT;
  RADV_IFACE->default_lifetime = (u32) -1;
  RADV_IFACE->default_lifetime_sensitive = 1;
  RADV_IFACE->default_preference = RA_PREF_MEDIUM;
  RADV_IFACE->route_lifetime = (u32) -1;
  RADV_IFACE->route_lifetime_sensitive = 0;
  RADV_IFACE->route_preference = RA_PREF_MEDIUM;
}
#line 14532 "obj/conf/cf-parse.tab.c"
    break;

  case 1324: /* radv_iface_item: MIN RA INTERVAL expr  */
#line 113 "proto/radv/config.Y"
                        { RADV_IFACE->min_ra_int = (yyvsp[0].i); if ((yyvsp[0].i) < 3) cf_error("Min RA interval must be at least 3"); }
#line 14538 "obj/conf/cf-parse.tab.c"
    break;

  case 1325: /* radv_iface_item: MAX RA INTERVAL expr  */
#line 114 "proto/radv/config.Y"
                        { RADV_IFACE->max_ra_int = (yyvsp[0].i); if (((yyvsp[0].i) < 4) || ((yyvsp[0].i) > 1800)) cf_error("Max RA interval must be in range 4-1800"); }
#line 14544 "obj/conf/cf-parse.tab.c"
    break;

  case 1326: /* radv_iface_item: MIN DELAY expr  */
#line 115 "proto/radv/config.Y"
                  { RADV_IFACE->min_delay = (yyvsp[0].i); if ((yyvsp[0].i) <= 0) cf_error("Min delay must be positive"); }
#line 14550 "obj/conf/cf-parse.tab.c"
    break;

  case 1327: /* radv_iface_item: SOLICITED RA UNICAST bool  */
#line 116 "proto/radv/config.Y"
                             { RADV_IFACE->solicited_ra_unicast = (yyvsp[0].i); }
#line 14556 "obj/conf/cf-parse.tab.c"
    break;

  case 1328: /* radv_iface_item: MANAGED bool  */
#line 117 "proto/radv/config.Y"
                { RADV_IFACE->managed = (yyvsp[0].i); }
#line 14562 "obj/conf/cf-parse.tab.c"
    break;

  case 1329: /* radv_iface_item: OTHER CONFIG bool  */
#line 118 "proto/radv/config.Y"
                     { RADV_IFACE->other_config = (yyvsp[0].i); }
#line 14568 "obj/conf/cf-parse.tab.c"
    break;

  case 1330: /* radv_iface_item: LINK MTU expr  */
#line 119 "proto/radv/config.Y"
                 { RADV_IFACE->link_mtu = (yyvsp[0].i); }
#line 14574 "obj/conf/cf-parse.tab.c"
    break;

  case 1331: /* radv_iface_item: REACHABLE TIME expr  */
#line 120 "proto/radv/config.Y"
                       { RADV_IFACE->reachable_time = (yyvsp[0].i); if ((yyvsp[0].i) > 3600000) cf_error("Reachable time must be in range 0-3600000"); }
#line 14580 "obj/conf/cf-parse.tab.c"
    break;

  case 1332: /* radv_iface_item: RETRANS TIMER expr  */
#line 121 "proto/radv/config.Y"
                      { RADV_IFACE->retrans_timer = (yyvsp[0].i); }
#line 14586 "obj/conf/cf-parse.tab.c"
    break;

  case 1333: /* radv_iface_item: CURRENT HOP LIMIT expr  */
#line 122 "proto/radv/config.Y"
                          { RADV_IFACE->current_hop_limit = (yyvsp[0].i); if ((yyvsp[0].i) > 255) cf_error("Current hop limit must be in range 0-255"); }
#line 14592 "obj/conf/cf-parse.tab.c"
    break;

  case 1334: /* radv_iface_item: DEFAULT LIFETIME expr radv_sensitive  */
#line 123 "proto/radv/config.Y"
                                        {
     RADV_IFACE->default_lifetime = (yyvsp[-1].i);
     if ((yyvsp[-1].i) > 9000)  cf_error("Default lifetime must be in range 0-9000");
     if ((yyvsp[0].i) != (uint) -1) RADV_IFACE->default_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14602 "obj/conf/cf-parse.tab.c"
    break;

  case 1335: /* radv_iface_item: ROUTE LIFETIME expr radv_sensitive  */
#line 128 "proto/radv/config.Y"
                                      {
     RADV_IFACE->route_lifetime = (yyvsp[-1].i);
     if ((yyvsp[0].i) != (uint) -1) RADV_IFACE->route_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14611 "obj/conf/cf-parse.tab.c"
    break;

  case 1336: /* radv_iface_item: DEFAULT PREFERENCE radv_preference  */
#line 132 "proto/radv/config.Y"
                                      { RADV_IFACE->default_preference = (yyvsp[0].i); }
#line 14617 "obj/conf/cf-parse.tab.c"
    break;

  case 1337: /* radv_iface_item: ROUTE PREFERENCE radv_preference  */
#line 133 "proto/radv/config.Y"
                                    { RADV_IFACE->route_preference = (yyvsp[0].i); }
#line 14623 "obj/conf/cf-parse.tab.c"
    break;

  case 1338: /* radv_iface_item: PREFIX LINGER TIME expr  */
#line 134 "proto/radv/config.Y"
                           { RADV_IFACE->prefix_linger_time = (yyvsp[0].i); }
#line 14629 "obj/conf/cf-parse.tab.c"
    break;

  case 1339: /* radv_iface_item: ROUTE LINGER TIME expr  */
#line 135 "proto/radv/config.Y"
                          { RADV_IFACE->route_linger_time = (yyvsp[0].i); }
#line 14635 "obj/conf/cf-parse.tab.c"
    break;

  case 1340: /* radv_iface_item: PREFIX radv_prefix  */
#line 136 "proto/radv/config.Y"
                      { add_tail(&RADV_IFACE->pref_list, NODE this_radv_prefix); }
#line 14641 "obj/conf/cf-parse.tab.c"
    break;

  case 1341: /* $@27: %empty  */
#line 137 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14647 "obj/conf/cf-parse.tab.c"
    break;

  case 1342: /* radv_iface_item: RDNSS $@27 radv_rdnss  */
#line 137 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_IFACE->rdnss_list, &radv_dns_list); }
#line 14653 "obj/conf/cf-parse.tab.c"
    break;

  case 1343: /* $@28: %empty  */
#line 138 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14659 "obj/conf/cf-parse.tab.c"
    break;

  case 1344: /* radv_iface_item: DNSSL $@28 radv_dnssl  */
#line 138 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_IFACE->dnssl_list, &radv_dns_list); }
#line 14665 "obj/conf/cf-parse.tab.c"
    break;

  case 1345: /* radv_iface_item: CUSTOM OPTION TYPE expr VALUE bytestring  */
#line 139 "proto/radv/config.Y"
                                            { radv_add_to_custom_list(&RADV_IFACE->custom_list, (yyvsp[-2].i), (yyvsp[0].bs)); }
#line 14671 "obj/conf/cf-parse.tab.c"
    break;

  case 1346: /* radv_iface_item: RDNSS LOCAL bool  */
#line 140 "proto/radv/config.Y"
                    { RADV_IFACE->rdnss_local = (yyvsp[0].i); }
#line 14677 "obj/conf/cf-parse.tab.c"
    break;

  case 1347: /* radv_iface_item: DNSSL LOCAL bool  */
#line 141 "proto/radv/config.Y"
                    { RADV_IFACE->dnssl_local = (yyvsp[0].i); }
#line 14683 "obj/conf/cf-parse.tab.c"
    break;

  case 1348: /* radv_iface_item: CUSTOM OPTION LOCAL bool  */
#line 142 "proto/radv/config.Y"
                            { RADV_IFACE->custom_local = (yyvsp[0].i); }
#line 14689 "obj/conf/cf-parse.tab.c"
    break;

  case 1349: /* radv_preference: LOW  */
#line 146 "proto/radv/config.Y"
       { (yyval.i) = RA_PREF_LOW; }
#line 14695 "obj/conf/cf-parse.tab.c"
    break;

  case 1350: /* radv_preference: MEDIUM  */
#line 147 "proto/radv/config.Y"
          { (yyval.i) = RA_PREF_MEDIUM; }
#line 14701 "obj/conf/cf-parse.tab.c"
    break;

  case 1351: /* radv_preference: HIGH  */
#line 148 "proto/radv/config.Y"
        { (yyval.i) = RA_PREF_HIGH; }
#line 14707 "obj/conf/cf-parse.tab.c"
    break;

  case 1352: /* radv_iface_finish: %empty  */
#line 151 "proto/radv/config.Y"
{
  struct radv_iface_config *ic = RADV_IFACE;

  if (ic->min_ra_int == (u32) -1)
    ic->min_ra_int = MAX_(ic->max_ra_int / 3, 3);

  if (ic->default_lifetime == (u32) -1)
    ic->default_lifetime = 3 * ic->max_ra_int;

  if (ic->route_lifetime == (u32) -1)
    ic->route_lifetime = 3 * ic->max_ra_int;

  if (ic->prefix_linger_time == (u32) -1)
    ic->prefix_linger_time = 3 * ic->max_ra_int;

  if (ic->route_linger_time == (u32) -1)
    ic->route_linger_time = 3 * ic->max_ra_int;

  if ((ic->min_ra_int > 3) &&
      (ic->min_ra_int > (ic->max_ra_int * 3 / 4)))
    cf_error("Min RA interval must be at most 3/4 * Max RA interval");

  if ((ic->default_lifetime > 0) && (ic->default_lifetime < ic->max_ra_int))
    cf_error("Default lifetime must be either 0 or at least Max RA interval");

  if ((ic->route_lifetime > 0) && (ic->route_lifetime < ic->max_ra_int))
    cf_error("Route lifetime must be either 0 or at least Max RA interval");

  if ((ic->prefix_linger_time > 0) && (ic->prefix_linger_time < ic->max_ra_int))
    cf_error("Prefix linger time must be either 0 or at least Max RA interval");

  if ((ic->route_linger_time > 0) && (ic->route_linger_time < ic->max_ra_int))
    cf_error("Route linger time must be either 0 or at least Max RA interval");

  RADV_CFG->max_linger_time = MAX_(RADV_CFG->max_linger_time, ic->route_linger_time);
}
#line 14748 "obj/conf/cf-parse.tab.c"
    break;

  case 1358: /* radv_prefix_start: net_ip6  */
#line 204 "proto/radv/config.Y"
{
  this_radv_prefix = cfg_allocz(sizeof(struct radv_prefix_config));
  RADV_PREFIX->prefix = *(net_addr_ip6 *) &((yyvsp[0].net));

  RADV_PREFIX->onlink = 1;
  RADV_PREFIX->autonomous = 1;
  RADV_PREFIX->valid_lifetime = DEFAULT_VALID_LIFETIME;
  RADV_PREFIX->preferred_lifetime = DEFAULT_PREFERRED_LIFETIME;
}
#line 14762 "obj/conf/cf-parse.tab.c"
    break;

  case 1359: /* radv_prefix_item: SKIP bool  */
#line 215 "proto/radv/config.Y"
             { RADV_PREFIX->skip = (yyvsp[0].i); }
#line 14768 "obj/conf/cf-parse.tab.c"
    break;

  case 1360: /* radv_prefix_item: ONLINK bool  */
#line 216 "proto/radv/config.Y"
               { RADV_PREFIX->onlink = (yyvsp[0].i); }
#line 14774 "obj/conf/cf-parse.tab.c"
    break;

  case 1361: /* radv_prefix_item: AUTONOMOUS bool  */
#line 217 "proto/radv/config.Y"
                   { RADV_PREFIX->autonomous = (yyvsp[0].i); }
#line 14780 "obj/conf/cf-parse.tab.c"
    break;

  case 1362: /* radv_prefix_item: PD PREFERRED bool  */
#line 218 "proto/radv/config.Y"
                     { RADV_PREFIX->pd_preferred = (yyvsp[0].i); }
#line 14786 "obj/conf/cf-parse.tab.c"
    break;

  case 1363: /* radv_prefix_item: VALID LIFETIME expr radv_sensitive  */
#line 219 "proto/radv/config.Y"
                                      {
     RADV_PREFIX->valid_lifetime = (yyvsp[-1].i);
     if ((yyvsp[0].i) != (uint) -1) RADV_PREFIX->valid_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14795 "obj/conf/cf-parse.tab.c"
    break;

  case 1364: /* radv_prefix_item: PREFERRED LIFETIME expr radv_sensitive  */
#line 223 "proto/radv/config.Y"
                                          {
     RADV_PREFIX->preferred_lifetime = (yyvsp[-1].i);
     if ((yyvsp[0].i) != (uint) -1) RADV_PREFIX->preferred_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14804 "obj/conf/cf-parse.tab.c"
    break;

  case 1365: /* radv_prefix_finish: %empty  */
#line 230 "proto/radv/config.Y"
{
  if (RADV_PREFIX->preferred_lifetime > RADV_PREFIX->valid_lifetime)
    cf_error("Preferred lifetime must be at most Valid lifetime");

  if (RADV_PREFIX->valid_lifetime_sensitive > RADV_PREFIX->preferred_lifetime_sensitive)
    cf_error("Valid lifetime sensitive requires that Preferred lifetime is sensitive too");
}
#line 14816 "obj/conf/cf-parse.tab.c"
    break;

  case 1371: /* radv_rdnss_node: ipa  */
#line 254 "proto/radv/config.Y"
{
  struct radv_rdnss_config *cf = cfg_allocz(sizeof(struct radv_rdnss_config));
  add_tail(&radv_dns_list, NODE cf);

  cf->server = (yyvsp[0].a);
  cf->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;
}
#line 14828 "obj/conf/cf-parse.tab.c"
    break;

  case 1372: /* radv_rdnss_start: %empty  */
#line 263 "proto/radv/config.Y"
{
  RADV_RDNSS->lifetime = 0;
  RADV_RDNSS->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;
}
#line 14837 "obj/conf/cf-parse.tab.c"
    break;

  case 1375: /* radv_rdnss_item: LIFETIME radv_mult  */
#line 270 "proto/radv/config.Y"
                      { RADV_RDNSS->lifetime = (yyvsp[0].i); RADV_RDNSS->lifetime_mult = radv_mult_val; }
#line 14843 "obj/conf/cf-parse.tab.c"
    break;

  case 1376: /* radv_rdnss_finish: %empty  */
#line 274 "proto/radv/config.Y"
{
  if (EMPTY_LIST(radv_dns_list))
    cf_error("No nameserver in RDNSS section");

  struct radv_rdnss_config *cf;
  WALK_LIST(cf, radv_dns_list)
  {
    cf->lifetime = RADV_RDNSS->lifetime;
    cf->lifetime_mult = RADV_RDNSS->lifetime_mult;
  }
}
#line 14859 "obj/conf/cf-parse.tab.c"
    break;

  case 1381: /* radv_dnssl_node: text  */
#line 298 "proto/radv/config.Y"
{
  struct radv_dnssl_config *cf = cfg_allocz(sizeof(struct radv_dnssl_config));
  add_tail(&radv_dns_list, NODE cf);

  cf->domain = (yyvsp[0].t);
  cf->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;

  if (radv_process_domain(cf) < 0)
    cf_error("Invalid domain dame");
}
#line 14874 "obj/conf/cf-parse.tab.c"
    break;

  case 1382: /* radv_dnssl_start: %empty  */
#line 310 "proto/radv/config.Y"
{
  RADV_DNSSL->lifetime = 0;
  RADV_DNSSL->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;
}
#line 14883 "obj/conf/cf-parse.tab.c"
    break;

  case 1385: /* radv_dnssl_item: LIFETIME radv_mult  */
#line 317 "proto/radv/config.Y"
                      { RADV_DNSSL->lifetime = (yyvsp[0].i); RADV_DNSSL->lifetime_mult = radv_mult_val; }
#line 14889 "obj/conf/cf-parse.tab.c"
    break;

  case 1386: /* radv_dnssl_finish: %empty  */
#line 321 "proto/radv/config.Y"
{
  if (EMPTY_LIST(radv_dns_list))
    cf_error("No domain in DNSSL section");

  struct radv_dnssl_config *cf;
  WALK_LIST(cf, radv_dns_list)
  {
    cf->lifetime = RADV_DNSSL->lifetime;
    cf->lifetime_mult = RADV_DNSSL->lifetime_mult;
  }
}
#line 14905 "obj/conf/cf-parse.tab.c"
    break;

  case 1391: /* radv_mult: expr  */
#line 345 "proto/radv/config.Y"
        { (yyval.i) = (yyvsp[0].i); radv_mult_val = 0; }
#line 14911 "obj/conf/cf-parse.tab.c"
    break;

  case 1392: /* radv_mult: MULT expr  */
#line 346 "proto/radv/config.Y"
             { (yyval.i) = 0; radv_mult_val = (yyvsp[0].i); if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 254)) cf_error("Multiplier must be in range 1-254"); }
#line 14917 "obj/conf/cf-parse.tab.c"
    break;

  case 1393: /* radv_sensitive: %empty  */
#line 350 "proto/radv/config.Y"
               { (yyval.i) = (uint) -1; }
#line 14923 "obj/conf/cf-parse.tab.c"
    break;

  case 1394: /* radv_sensitive: SENSITIVE bool  */
#line 351 "proto/radv/config.Y"
                  { (yyval.i) = (yyvsp[0].i); }
#line 14929 "obj/conf/cf-parse.tab.c"
    break;

  case 1396: /* rip_variant: RIP  */
#line 49 "proto/rip/config.Y"
          { (yyval.i) = 1; }
#line 14935 "obj/conf/cf-parse.tab.c"
    break;

  case 1397: /* rip_variant: RIP NG  */
#line 50 "proto/rip/config.Y"
          { (yyval.i) = 0; }
#line 14941 "obj/conf/cf-parse.tab.c"
    break;

  case 1398: /* rip_proto_start: proto_start rip_variant  */
#line 54 "proto/rip/config.Y"
{
  this_proto = proto_config_new(&proto_rip, (yyvsp[-1].i));
  this_proto->net_type = (yyvsp[0].i) ? NET_IP4 : NET_IP6;

  init_list(&RIP_CFG->patt_list);
  RIP_CFG->rip2 = (yyvsp[0].i);
  RIP_CFG->ecmp = rt_default_ecmp;
  RIP_CFG->infinity = RIP_DEFAULT_INFINITY;
  RIP_CFG->min_timeout_time = 60 S_;
  RIP_CFG->max_garbage_time = 60 S_;
}
#line 14957 "obj/conf/cf-parse.tab.c"
    break;

  case 1401: /* rip_proto_item: ECMP bool  */
#line 69 "proto/rip/config.Y"
                        { RIP_CFG->ecmp = (yyvsp[0].i) ? RIP_DEFAULT_ECMP_LIMIT : 0; }
#line 14963 "obj/conf/cf-parse.tab.c"
    break;

  case 1402: /* rip_proto_item: ECMP bool LIMIT expr  */
#line 70 "proto/rip/config.Y"
                        { RIP_CFG->ecmp = (yyvsp[-2].i) ? (yyvsp[0].i) : 0; }
#line 14969 "obj/conf/cf-parse.tab.c"
    break;

  case 1403: /* rip_proto_item: INFINITY expr  */
#line 71 "proto/rip/config.Y"
                        { RIP_CFG->infinity = (yyvsp[0].i); }
#line 14975 "obj/conf/cf-parse.tab.c"
    break;

  case 1408: /* rip_iface_start: %empty  */
#line 85 "proto/rip/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct rip_iface_config));
  add_tail(&RIP_CFG->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  reset_passwords();

  this_proto->loop_order = DOMAIN_ORDER(proto);
  RIP_IFACE->metric = 1;
  RIP_IFACE->port = rip_cfg_is_v2() ? RIP_PORT : RIP_NG_PORT;
  RIP_IFACE->version = rip_cfg_is_v2() ? RIP_V2 : RIP_V1;
  RIP_IFACE->split_horizon = 1;
  RIP_IFACE->poison_reverse = 1;
  RIP_IFACE->check_zero = 1;
  RIP_IFACE->check_link = 1;
  RIP_IFACE->ttl_security = rip_cfg_is_v2() ? 0 : 1;
  RIP_IFACE->rx_buffer = rip_cfg_is_v2() ? RIP_MAX_PKT_LENGTH : 0;
  RIP_IFACE->tx_length = rip_cfg_is_v2() ? RIP_MAX_PKT_LENGTH : 0;
  RIP_IFACE->tx_tos = IP_PREC_INTERNET_CONTROL;
  RIP_IFACE->tx_priority = sk_priority_control;
  RIP_IFACE->update_time = RIP_DEFAULT_UPDATE_TIME;
  RIP_IFACE->timeout_time = RIP_DEFAULT_TIMEOUT_TIME;
  RIP_IFACE->garbage_time = RIP_DEFAULT_GARBAGE_TIME;
  RIP_IFACE->rxmt_time = RIP_DEFAULT_RXMT_TIME;
}
#line 15004 "obj/conf/cf-parse.tab.c"
    break;

  case 1409: /* rip_iface_finish: %empty  */
#line 111 "proto/rip/config.Y"
{
  /* Default mode is broadcast for RIPv1, multicast for RIPv2 and RIPng */
  if (!RIP_IFACE->mode)
    RIP_IFACE->mode = (rip_cfg_is_v2() && (RIP_IFACE->version == RIP_V1)) ?
      RIP_IM_BROADCAST : RIP_IM_MULTICAST;

  RIP_IFACE->passwords = get_passwords();

  if (!RIP_IFACE->auth_type != !RIP_IFACE->passwords)
    cf_warn("Authentication and password options should be used together");

  if (RIP_IFACE->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *RIP_IFACE->passwords)
    {
      if (pass->alg && (RIP_IFACE->auth_type != RIP_AUTH_CRYPTO))
	cf_error("Password algorithm option requires cryptographic authentication");

      /* Set default crypto algorithm (MD5) */
      if (!pass->alg && (RIP_IFACE->auth_type == RIP_AUTH_CRYPTO))
	pass->alg = ALG_MD5;
    }
  }

  RIP_CFG->min_timeout_time = MIN_(RIP_CFG->min_timeout_time, RIP_IFACE->timeout_time);
  RIP_CFG->max_garbage_time = MAX_(RIP_CFG->max_garbage_time, RIP_IFACE->garbage_time);
}
#line 15037 "obj/conf/cf-parse.tab.c"
    break;

  case 1410: /* rip_iface_item: METRIC expr  */
#line 141 "proto/rip/config.Y"
                        { RIP_IFACE->metric = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>255)) cf_error("Metric must be in range 1-255"); }
#line 15043 "obj/conf/cf-parse.tab.c"
    break;

  case 1411: /* rip_iface_item: MODE MULTICAST  */
#line 142 "proto/rip/config.Y"
                        { RIP_IFACE->mode = RIP_IM_MULTICAST; }
#line 15049 "obj/conf/cf-parse.tab.c"
    break;

  case 1412: /* rip_iface_item: MODE BROADCAST  */
#line 143 "proto/rip/config.Y"
                        { RIP_IFACE->mode = RIP_IM_BROADCAST; if (rip_cfg_is_ng()) cf_error("Broadcast not supported in RIPng"); }
#line 15055 "obj/conf/cf-parse.tab.c"
    break;

  case 1413: /* rip_iface_item: PASSIVE bool  */
#line 144 "proto/rip/config.Y"
                        { RIP_IFACE->passive = (yyvsp[0].i); }
#line 15061 "obj/conf/cf-parse.tab.c"
    break;

  case 1414: /* rip_iface_item: ADDRESS ipa  */
#line 145 "proto/rip/config.Y"
                        { RIP_IFACE->address = (yyvsp[0].a); if (ipa_is_ip4((yyvsp[0].a)) != rip_cfg_is_v2()) cf_error("IP address version mismatch"); }
#line 15067 "obj/conf/cf-parse.tab.c"
    break;

  case 1415: /* rip_iface_item: PORT expr  */
#line 146 "proto/rip/config.Y"
                        { RIP_IFACE->port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 15073 "obj/conf/cf-parse.tab.c"
    break;

  case 1416: /* rip_iface_item: VERSION expr  */
#line 147 "proto/rip/config.Y"
                        { RIP_IFACE->version = (yyvsp[0].i);
			  if (rip_cfg_is_ng()) cf_error("Version not supported in RIPng");
			  if (((yyvsp[0].i) != RIP_V1) && ((yyvsp[0].i) != RIP_V2)) cf_error("Unsupported version");
			}
#line 15082 "obj/conf/cf-parse.tab.c"
    break;

  case 1417: /* rip_iface_item: VERSION ONLY bool  */
#line 151 "proto/rip/config.Y"
                        { RIP_IFACE->version_only = (yyvsp[0].i); }
#line 15088 "obj/conf/cf-parse.tab.c"
    break;

  case 1418: /* rip_iface_item: SPLIT HORIZON bool  */
#line 152 "proto/rip/config.Y"
                        { RIP_IFACE->split_horizon = (yyvsp[0].i); }
#line 15094 "obj/conf/cf-parse.tab.c"
    break;

  case 1419: /* rip_iface_item: POISON REVERSE bool  */
#line 153 "proto/rip/config.Y"
                        { RIP_IFACE->poison_reverse = (yyvsp[0].i); }
#line 15100 "obj/conf/cf-parse.tab.c"
    break;

  case 1420: /* rip_iface_item: CHECK ZERO bool  */
#line 154 "proto/rip/config.Y"
                        { RIP_IFACE->check_zero = (yyvsp[0].i); }
#line 15106 "obj/conf/cf-parse.tab.c"
    break;

  case 1421: /* rip_iface_item: DEMAND CIRCUIT bool  */
#line 155 "proto/rip/config.Y"
                        { RIP_IFACE->demand_circuit = (yyvsp[0].i); }
#line 15112 "obj/conf/cf-parse.tab.c"
    break;

  case 1422: /* rip_iface_item: UPDATE TIME expr  */
#line 156 "proto/rip/config.Y"
                        { RIP_IFACE->update_time = (yyvsp[0].i) S_; if ((yyvsp[0].i)<=0) cf_error("Update time must be positive"); }
#line 15118 "obj/conf/cf-parse.tab.c"
    break;

  case 1423: /* rip_iface_item: TIMEOUT TIME expr  */
#line 157 "proto/rip/config.Y"
                        { RIP_IFACE->timeout_time = (yyvsp[0].i) S_; if ((yyvsp[0].i)<=0) cf_error("Timeout time must be positive"); }
#line 15124 "obj/conf/cf-parse.tab.c"
    break;

  case 1424: /* rip_iface_item: GARBAGE TIME expr  */
#line 158 "proto/rip/config.Y"
                        { RIP_IFACE->garbage_time = (yyvsp[0].i) S_; if ((yyvsp[0].i)<=0) cf_error("Garbage time must be positive"); }
#line 15130 "obj/conf/cf-parse.tab.c"
    break;

  case 1425: /* rip_iface_item: RETRANSMIT TIME expr_us  */
#line 159 "proto/rip/config.Y"
                           { RIP_IFACE->rxmt_time = (yyvsp[0].time); if ((yyvsp[0].time)<=0) cf_error("Retransmit time must be positive"); }
#line 15136 "obj/conf/cf-parse.tab.c"
    break;

  case 1426: /* rip_iface_item: ECMP WEIGHT expr  */
#line 160 "proto/rip/config.Y"
                        { RIP_IFACE->ecmp_weight = (yyvsp[0].i) - 1; if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>256)) cf_error("ECMP weight must be in range 1-256"); }
#line 15142 "obj/conf/cf-parse.tab.c"
    break;

  case 1427: /* rip_iface_item: RX BUFFER expr  */
#line 161 "proto/rip/config.Y"
                        { RIP_IFACE->rx_buffer = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("RX length must be in range 256-65535"); }
#line 15148 "obj/conf/cf-parse.tab.c"
    break;

  case 1428: /* rip_iface_item: TX LENGTH expr  */
#line 162 "proto/rip/config.Y"
                        { RIP_IFACE->tx_length = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("TX length must be in range 256-65535"); }
#line 15154 "obj/conf/cf-parse.tab.c"
    break;

  case 1429: /* rip_iface_item: TX tos  */
#line 163 "proto/rip/config.Y"
                        { RIP_IFACE->tx_tos = (yyvsp[0].i); }
#line 15160 "obj/conf/cf-parse.tab.c"
    break;

  case 1430: /* rip_iface_item: TX PRIORITY expr  */
#line 164 "proto/rip/config.Y"
                        { RIP_IFACE->tx_priority = (yyvsp[0].i); }
#line 15166 "obj/conf/cf-parse.tab.c"
    break;

  case 1431: /* rip_iface_item: TTL SECURITY bool  */
#line 165 "proto/rip/config.Y"
                        { RIP_IFACE->ttl_security = (yyvsp[0].i); }
#line 15172 "obj/conf/cf-parse.tab.c"
    break;

  case 1432: /* rip_iface_item: TTL SECURITY TX ONLY  */
#line 166 "proto/rip/config.Y"
                        { RIP_IFACE->ttl_security = 2; }
#line 15178 "obj/conf/cf-parse.tab.c"
    break;

  case 1433: /* rip_iface_item: CHECK LINK bool  */
#line 167 "proto/rip/config.Y"
                        { RIP_IFACE->check_link = (yyvsp[0].i); }
#line 15184 "obj/conf/cf-parse.tab.c"
    break;

  case 1434: /* rip_iface_item: BFD bool  */
#line 168 "proto/rip/config.Y"
                        { RIP_IFACE->bfd = (yyvsp[0].i); cf_check_bfd((yyvsp[0].i)); }
#line 15190 "obj/conf/cf-parse.tab.c"
    break;

  case 1435: /* rip_iface_item: AUTHENTICATION rip_auth  */
#line 169 "proto/rip/config.Y"
                           { RIP_IFACE->auth_type = (yyvsp[0].i); if ((yyvsp[0].i)) rip_check_auth(); }
#line 15196 "obj/conf/cf-parse.tab.c"
    break;

  case 1436: /* rip_iface_item: password_list  */
#line 170 "proto/rip/config.Y"
                        { rip_check_auth(); }
#line 15202 "obj/conf/cf-parse.tab.c"
    break;

  case 1437: /* rip_auth: NONE  */
#line 174 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_NONE; }
#line 15208 "obj/conf/cf-parse.tab.c"
    break;

  case 1438: /* rip_auth: PLAINTEXT  */
#line 175 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_PLAIN; }
#line 15214 "obj/conf/cf-parse.tab.c"
    break;

  case 1439: /* rip_auth: CRYPTOGRAPHIC  */
#line 176 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_CRYPTO; }
#line 15220 "obj/conf/cf-parse.tab.c"
    break;

  case 1440: /* rip_auth: MD5  */
#line 177 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_CRYPTO; }
#line 15226 "obj/conf/cf-parse.tab.c"
    break;

  case 1447: /* cmd_SHOW_RIP_INTERFACES: SHOW RIP INTERFACES optproto opttext END  */
#line 197 "proto/rip/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_rip, p) rip_show_interfaces(p, (yyvsp[-1].t)); }
#line 15232 "obj/conf/cf-parse.tab.c"
    break;

  case 1449: /* cmd_SHOW_RIP_NEIGHBORS: SHOW RIP NEIGHBORS optproto opttext END  */
#line 200 "proto/rip/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_rip, p) rip_show_neighbors(p, (yyvsp[-1].t)); }
#line 15238 "obj/conf/cf-parse.tab.c"
    break;

  case 1451: /* rpki_proto_start: proto_start RPKI  */
#line 45 "proto/rpki/config.Y"
                                   {
  this_proto = proto_config_new(&proto_rpki, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
  RPKI_CFG->retry_interval = RPKI_RETRY_INTERVAL;
  RPKI_CFG->refresh_interval = RPKI_REFRESH_INTERVAL;
  RPKI_CFG->expire_interval = RPKI_EXPIRE_INTERVAL;
  RPKI_CFG->min_version = 0;
  RPKI_CFG->max_version = RPKI_MAX_VERSION;
}
#line 15252 "obj/conf/cf-parse.tab.c"
    break;

  case 1452: /* rpki_proto: rpki_proto_start proto_name '{' rpki_proto_opts '}'  */
#line 55 "proto/rpki/config.Y"
                                                                { rpki_check_config(RPKI_CFG); }
#line 15258 "obj/conf/cf-parse.tab.c"
    break;

  case 1460: /* rpki_proto_item: LOCAL ADDRESS ipa  */
#line 68 "proto/rpki/config.Y"
                     { RPKI_CFG->local_ip = (yyvsp[0].a); }
#line 15264 "obj/conf/cf-parse.tab.c"
    break;

  case 1462: /* rpki_proto_item: REFRESH rpki_keep_interval expr  */
#line 70 "proto/rpki/config.Y"
                                   {
     if (rpki_check_refresh_interval((yyvsp[0].i)))
       cf_error(rpki_check_refresh_interval((yyvsp[0].i)));
     RPKI_CFG->refresh_interval = (yyvsp[0].i);
     RPKI_CFG->keep_refresh_interval = (yyvsp[-1].i);
   }
#line 15275 "obj/conf/cf-parse.tab.c"
    break;

  case 1463: /* rpki_proto_item: RETRY rpki_keep_interval expr  */
#line 76 "proto/rpki/config.Y"
                                 {
     if (rpki_check_retry_interval((yyvsp[0].i)))
       cf_error(rpki_check_retry_interval((yyvsp[0].i)));
     RPKI_CFG->retry_interval = (yyvsp[0].i);
     RPKI_CFG->keep_retry_interval = (yyvsp[-1].i);
   }
#line 15286 "obj/conf/cf-parse.tab.c"
    break;

  case 1464: /* rpki_proto_item: EXPIRE rpki_keep_interval expr  */
#line 82 "proto/rpki/config.Y"
                                  {
     if (rpki_check_expire_interval((yyvsp[0].i)))
       cf_error(rpki_check_expire_interval((yyvsp[0].i)));
     RPKI_CFG->expire_interval = (yyvsp[0].i);
     RPKI_CFG->keep_expire_interval = (yyvsp[-1].i);
   }
#line 15297 "obj/conf/cf-parse.tab.c"
    break;

  case 1465: /* rpki_proto_item: IGNORE MAX LENGTH bool  */
#line 88 "proto/rpki/config.Y"
                          { RPKI_CFG->ignore_max_length = (yyvsp[0].i); }
#line 15303 "obj/conf/cf-parse.tab.c"
    break;

  case 1466: /* rpki_proto_item: MIN VERSION expr  */
#line 89 "proto/rpki/config.Y"
                    {
     if ((yyvsp[0].i) > RPKI_MAX_VERSION) cf_error("RPKI version %u unsupported, min version must be in range 0-%u", (yyvsp[0].i), RPKI_MAX_VERSION);
     RPKI_CFG->min_version = (yyvsp[0].i);
   }
#line 15312 "obj/conf/cf-parse.tab.c"
    break;

  case 1467: /* rpki_proto_item: MAX VERSION expr  */
#line 93 "proto/rpki/config.Y"
                    {
     if ((yyvsp[0].i) > RPKI_MAX_VERSION) cf_error("RPKI version %u unsupported, max version must be in range 0-%u", (yyvsp[0].i), RPKI_MAX_VERSION);
     RPKI_CFG->max_version = (yyvsp[0].i);
   }
#line 15321 "obj/conf/cf-parse.tab.c"
    break;

  case 1468: /* rpki_keep_interval: %empty  */
#line 100 "proto/rpki/config.Y"
             { (yyval.i) = 0; }
#line 15327 "obj/conf/cf-parse.tab.c"
    break;

  case 1469: /* rpki_keep_interval: KEEP  */
#line 101 "proto/rpki/config.Y"
        { (yyval.i) = 1; }
#line 15333 "obj/conf/cf-parse.tab.c"
    break;

  case 1470: /* rpki_proto_item_port: PORT expr  */
#line 104 "proto/rpki/config.Y"
                                { check_u16((yyvsp[0].i)); RPKI_CFG->port = (yyvsp[0].i); }
#line 15339 "obj/conf/cf-parse.tab.c"
    break;

  case 1471: /* rpki_cache_addr: text_or_ipa  */
#line 107 "proto/rpki/config.Y"
{
  rpki_check_unused_hostname();
  if ((yyvsp[0].v).type == T_STRING)
    RPKI_CFG->hostname = (yyvsp[0].v).val.s;
  else if ((yyvsp[0].v).type == T_IP)
  {
    RPKI_CFG->ip = (yyvsp[0].v).val.ip;

    /* Ensure hostname is filled */
    char *hostname = cfg_allocz(INET6_ADDRSTRLEN + 1);
    bsnprintf(hostname, INET6_ADDRSTRLEN+1, "%I", RPKI_CFG->ip);
    RPKI_CFG->hostname = hostname;
  }
  else bug("Bad text_or_ipa");
}
#line 15359 "obj/conf/cf-parse.tab.c"
    break;

  case 1474: /* rpki_transport_tcp_init: %empty  */
#line 129 "proto/rpki/config.Y"
{
  rpki_check_unused_transport();
  RPKI_CFG->tr_config.spec = cfg_allocz(sizeof(struct rpki_tr_tcp_config));
  RPKI_CFG->tr_config.type = RPKI_TR_TCP;
}
#line 15369 "obj/conf/cf-parse.tab.c"
    break;

  case 1479: /* rpki_transport_tcp_item: AUTHENTICATION NONE  */
#line 146 "proto/rpki/config.Y"
                        { RPKI_TR_TCP_CFG->auth_type = RPKI_TCP_AUTH_NONE; }
#line 15375 "obj/conf/cf-parse.tab.c"
    break;

  case 1480: /* rpki_transport_tcp_item: AUTHENTICATION MD5  */
#line 147 "proto/rpki/config.Y"
                        { RPKI_TR_TCP_CFG->auth_type = RPKI_TCP_AUTH_MD5; }
#line 15381 "obj/conf/cf-parse.tab.c"
    break;

  case 1481: /* rpki_transport_tcp_item: PASSWORD text  */
#line 148 "proto/rpki/config.Y"
                        { RPKI_TR_TCP_CFG->password = (yyvsp[0].t); }
#line 15387 "obj/conf/cf-parse.tab.c"
    break;

  case 1482: /* rpki_transport_tcp_check: %empty  */
#line 152 "proto/rpki/config.Y"
{
  if (!RPKI_TR_TCP_CFG->auth_type != !RPKI_TR_TCP_CFG->password)
    cf_error("Authentication and password options should be used together");
}
#line 15396 "obj/conf/cf-parse.tab.c"
    break;

  case 1483: /* rpki_transport_ssh_init: %empty  */
#line 158 "proto/rpki/config.Y"
{
#if HAVE_LIBSSH
  rpki_check_unused_transport();
  RPKI_CFG->tr_config.spec = cfg_allocz(sizeof(struct rpki_tr_ssh_config));
  RPKI_CFG->tr_config.type = RPKI_TR_SSH;
#else
  cf_error("This build doesn't support SSH");
#endif
}
#line 15410 "obj/conf/cf-parse.tab.c"
    break;

  case 1486: /* rpki_transport_ssh_item: BIRD PRIVATE KEY text  */
#line 174 "proto/rpki/config.Y"
                          { RPKI_TR_SSH_CFG->bird_private_key = (yyvsp[0].t); }
#line 15416 "obj/conf/cf-parse.tab.c"
    break;

  case 1487: /* rpki_transport_ssh_item: REMOTE PUBLIC KEY text  */
#line 175 "proto/rpki/config.Y"
                          { RPKI_TR_SSH_CFG->cache_public_key = (yyvsp[0].t); }
#line 15422 "obj/conf/cf-parse.tab.c"
    break;

  case 1488: /* rpki_transport_ssh_item: USER text  */
#line 176 "proto/rpki/config.Y"
                          { RPKI_TR_SSH_CFG->user = (yyvsp[0].t); }
#line 15428 "obj/conf/cf-parse.tab.c"
    break;

  case 1489: /* rpki_transport_ssh_check: %empty  */
#line 180 "proto/rpki/config.Y"
{
  if (RPKI_TR_SSH_CFG->user == NULL)
    cf_error("User must be set");
}
#line 15437 "obj/conf/cf-parse.tab.c"
    break;

  case 1491: /* static_proto_start: proto_start STATIC  */
#line 59 "proto/static/config.Y"
{
  this_proto = proto_config_new(&proto_static, (yyvsp[-1].i));
  init_list(&STATIC_CFG->routes);
}
#line 15446 "obj/conf/cf-parse.tab.c"
    break;

  case 1494: /* static_proto: static_proto proto_channel ';'  */
#line 67 "proto/static/config.Y"
                                  { this_proto->net_type = (yyvsp[-1].cc)->net_type; }
#line 15452 "obj/conf/cf-parse.tab.c"
    break;

  case 1496: /* static_proto: static_proto CHECK LINK bool ';'  */
#line 69 "proto/static/config.Y"
                                    { STATIC_CFG->check_link = (yyvsp[-1].i); }
#line 15458 "obj/conf/cf-parse.tab.c"
    break;

  case 1497: /* static_proto: static_proto IGP TABLE rtable ';'  */
#line 70 "proto/static/config.Y"
                                     {
    if ((yyvsp[-1].r)->addr_type == NET_IP4)
      STATIC_CFG->igp_table_ip4 = (yyvsp[-1].r);
    else if ((yyvsp[-1].r)->addr_type == NET_IP6)
      STATIC_CFG->igp_table_ip6 = (yyvsp[-1].r);
    else
      cf_error("Incompatible IGP table type");
   }
#line 15471 "obj/conf/cf-parse.tab.c"
    break;

  case 1498: /* static_proto: static_proto stat_route stat_route_opt_list ';'  */
#line 78 "proto/static/config.Y"
                                                   { static_route_finish(); }
#line 15477 "obj/conf/cf-parse.tab.c"
    break;

  case 1499: /* $@29: %empty  */
#line 82 "proto/static/config.Y"
                    {
      this_snh = static_nexthop_new();
      if ((yyvsp[0].v).type == T_IP)
        this_snh->via = (yyvsp[0].v).val.ip;
      else if ((yyvsp[0].v).type == T_STRING)
        this_snh->iface = if_get_by_name((yyvsp[0].v).val.s);
    }
#line 15489 "obj/conf/cf-parse.tab.c"
    break;

  case 1500: /* stat_nexthop: VIA text_or_ipa $@29 ipa_scope  */
#line 88 "proto/static/config.Y"
                {
      if ((yyvsp[-2].v).type == T_IP)
        this_snh->iface = (yyvsp[0].iface);
      else if ((yyvsp[0].iface))
        cf_error("syntax error, unexpected '%'");
    }
#line 15500 "obj/conf/cf-parse.tab.c"
    break;

  case 1501: /* stat_nexthop: stat_nexthop DEV text  */
#line 94 "proto/static/config.Y"
                          {
      this_snh->iface = if_get_by_name((yyvsp[0].t));
    }
#line 15508 "obj/conf/cf-parse.tab.c"
    break;

  case 1502: /* stat_nexthop: stat_nexthop MPLS label_stack  */
#line 97 "proto/static/config.Y"
                                  {
    this_snh->mls = (yyvsp[0].ad);
  }
#line 15516 "obj/conf/cf-parse.tab.c"
    break;

  case 1503: /* stat_nexthop: stat_nexthop ONLINK bool  */
#line 100 "proto/static/config.Y"
                             {
    this_snh->onlink = (yyvsp[0].i);
    if (this_snh->use_bfd && this_snh->onlink)
      cf_error("Options 'bfd' and 'onlink' cannot be combined");
  }
#line 15526 "obj/conf/cf-parse.tab.c"
    break;

  case 1504: /* stat_nexthop: stat_nexthop WEIGHT expr  */
#line 105 "proto/static/config.Y"
                             {
    this_snh->weight = (yyvsp[0].i) - 1;
    if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>256)) cf_error("Weight must be in range 1-256");
  }
#line 15535 "obj/conf/cf-parse.tab.c"
    break;

  case 1505: /* stat_nexthop: stat_nexthop BFD bool  */
#line 109 "proto/static/config.Y"
                          {
    this_snh->use_bfd = (yyvsp[0].i); cf_check_bfd((yyvsp[0].i));
    if (this_snh->use_bfd && this_snh->onlink)
      cf_error("Options 'bfd' and 'onlink' cannot be combined");
  }
#line 15545 "obj/conf/cf-parse.tab.c"
    break;

  case 1509: /* stat_mpls: MPLS expr  */
#line 123 "proto/static/config.Y"
             { this_srt->mpls_label = (yyvsp[0].i); if ((yyvsp[0].i) >= MPLS_MAX_LABEL) cf_error("MPLS label must be less than 2^20"); }
#line 15551 "obj/conf/cf-parse.tab.c"
    break;

  case 1510: /* $@30: %empty  */
#line 126 "proto/static/config.Y"
                           {
     this_srt = cfg_allocz(sizeof(struct static_route));
     add_tail(&STATIC_CFG->routes, &this_srt->n);
     this_srt->net = (yyvsp[0].net_ptr);
     this_srt->mpls_label = (uint) -1;
     this_srt_cmds = NULL;
     this_srt_last_cmd = NULL;
     this_srt->mp_next = NULL;
     this_snh = NULL;
  }
#line 15566 "obj/conf/cf-parse.tab.c"
    break;

  case 1513: /* stat_route: stat_route0 RECURSIVE ipa  */
#line 140 "proto/static/config.Y"
                             {
      this_srt->dest = RTDX_RECURSIVE;
      this_srt->via = (yyvsp[0].a);
   }
#line 15575 "obj/conf/cf-parse.tab.c"
    break;

  case 1514: /* stat_route: stat_route0 RECURSIVE ipa MPLS label_stack  */
#line 144 "proto/static/config.Y"
                                              {
      this_srt->dest = RTDX_RECURSIVE;
      this_srt->via = (yyvsp[-2].a);
      this_srt->mls = (yyvsp[0].ad);
   }
#line 15585 "obj/conf/cf-parse.tab.c"
    break;

  case 1515: /* stat_route: stat_route0  */
#line 149 "proto/static/config.Y"
                                { this_srt->dest = RTD_NONE; }
#line 15591 "obj/conf/cf-parse.tab.c"
    break;

  case 1516: /* stat_route: stat_route0 DROP  */
#line 150 "proto/static/config.Y"
                                { this_srt->dest = RTD_BLACKHOLE; }
#line 15597 "obj/conf/cf-parse.tab.c"
    break;

  case 1517: /* stat_route: stat_route0 REJECT  */
#line 151 "proto/static/config.Y"
                                { this_srt->dest = RTD_UNREACHABLE; }
#line 15603 "obj/conf/cf-parse.tab.c"
    break;

  case 1518: /* stat_route: stat_route0 BLACKHOLE  */
#line 152 "proto/static/config.Y"
                                { this_srt->dest = RTD_BLACKHOLE; }
#line 15609 "obj/conf/cf-parse.tab.c"
    break;

  case 1519: /* stat_route: stat_route0 UNREACHABLE  */
#line 153 "proto/static/config.Y"
                                { this_srt->dest = RTD_UNREACHABLE; }
#line 15615 "obj/conf/cf-parse.tab.c"
    break;

  case 1520: /* stat_route: stat_route0 PROHIBIT  */
#line 154 "proto/static/config.Y"
                                { this_srt->dest = RTD_PROHIBIT; }
#line 15621 "obj/conf/cf-parse.tab.c"
    break;

  case 1521: /* $@31: %empty  */
#line 155 "proto/static/config.Y"
                         {
    if (this_srt->net->type != NET_ASPA) cf_error("Provider settings available only for ASPA");
    this_srt->aspa = cfg_alloc(sizeof (adata) + (this_srt_aspa_max = 8) * sizeof (u32));
    this_srt->aspa->length = 0;
   }
#line 15631 "obj/conf/cf-parse.tab.c"
    break;

  case 1523: /* stat_route: stat_route0 TRANSIT  */
#line 160 "proto/static/config.Y"
                       {
    if (this_srt->net->type != NET_ASPA) cf_error("Transit settings available only for ASPA");
    /* Allocate an explicit zero */
    this_srt->aspa = cfg_alloc(sizeof (adata) + sizeof (u32));
    this_srt->aspa->length = sizeof(u32);
    ((u32 *) this_srt->aspa->data)[0] = 0;
   }
#line 15643 "obj/conf/cf-parse.tab.c"
    break;

  case 1524: /* stat_aspa_provider: expr  */
#line 169 "proto/static/config.Y"
                         {
  if (this_srt->aspa->length == this_srt_aspa_max * sizeof(u32))
  {
    adata *new = cfg_alloc(sizeof (adata) + (this_srt_aspa_max * 2) * sizeof (u32));
    memcpy(new, this_srt->aspa, this_srt->aspa->length + sizeof(adata));
    this_srt->aspa = new;
    this_srt_aspa_max *= 2;
  }

  ((u32 *) this_srt->aspa->data)[this_srt->aspa->length / sizeof(u32)] = (yyvsp[0].i);
  this_srt->aspa->length += sizeof(u32);
}
#line 15660 "obj/conf/cf-parse.tab.c"
    break;

  case 1527: /* stat_route_item: cmd  */
#line 185 "proto/static/config.Y"
       {
     if (this_srt_last_cmd)
       this_srt_last_cmd->next = (yyvsp[0].x);
     else
       this_srt_cmds = (yyvsp[0].x);
     this_srt_last_cmd = (yyvsp[0].x);
   }
#line 15672 "obj/conf/cf-parse.tab.c"
    break;

  case 1531: /* $@32: %empty  */
#line 201 "proto/static/config.Y"
       { cf_enter_filters(); }
#line 15678 "obj/conf/cf-parse.tab.c"
    break;

  case 1532: /* stat_route_opt_list: '{' $@32 stat_route_opts '}'  */
#line 201 "proto/static/config.Y"
                                                   { cf_exit_filters(); }
#line 15684 "obj/conf/cf-parse.tab.c"
    break;

  case 1534: /* cmd_SHOW_STATIC: SHOW STATIC optproto END  */
#line 206 "proto/static/config.Y"
{ PROTO_WALK_CMD((yyvsp[-1].s), &proto_static, p) static_show(p); }
#line 15690 "obj/conf/cf-parse.tab.c"
    break;

  case 1536: /* mrt_proto_start: proto_start MRT  */
#line 29 "proto/mrt/config.Y"
{
  this_proto = proto_config_new(&proto_mrt, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
}
#line 15699 "obj/conf/cf-parse.tab.c"
    break;

  case 1538: /* mrt_proto_item: TABLE rtable  */
#line 36 "proto/mrt/config.Y"
                        { MRT_CFG->table_cf = (yyvsp[0].r); }
#line 15705 "obj/conf/cf-parse.tab.c"
    break;

  case 1539: /* mrt_proto_item: TABLE TEXT  */
#line 37 "proto/mrt/config.Y"
                        { MRT_CFG->table_expr = (yyvsp[0].t); }
#line 15711 "obj/conf/cf-parse.tab.c"
    break;

  case 1540: /* mrt_proto_item: FILTER filter  */
#line 38 "proto/mrt/config.Y"
                        { MRT_CFG->filter = (yyvsp[0].f); }
#line 15717 "obj/conf/cf-parse.tab.c"
    break;

  case 1541: /* mrt_proto_item: where_filter  */
#line 39 "proto/mrt/config.Y"
                        { MRT_CFG->filter = (yyvsp[0].f); }
#line 15723 "obj/conf/cf-parse.tab.c"
    break;

  case 1542: /* mrt_proto_item: FILENAME text  */
#line 40 "proto/mrt/config.Y"
                        { MRT_CFG->filename = (yyvsp[0].t); }
#line 15729 "obj/conf/cf-parse.tab.c"
    break;

  case 1543: /* mrt_proto_item: PERIOD expr  */
#line 41 "proto/mrt/config.Y"
                        { MRT_CFG->period = (yyvsp[0].i); }
#line 15735 "obj/conf/cf-parse.tab.c"
    break;

  case 1544: /* mrt_proto_item: ALWAYS ADD PATH bool  */
#line 42 "proto/mrt/config.Y"
                        { MRT_CFG->always_add_path = (yyvsp[0].i); }
#line 15741 "obj/conf/cf-parse.tab.c"
    break;

  case 1547: /* mrt_proto: mrt_proto_start proto_name '{' mrt_proto_opts '}'  */
#line 51 "proto/mrt/config.Y"
                                                     { mrt_check_config(this_proto); }
#line 15747 "obj/conf/cf-parse.tab.c"
    break;

  case 1549: /* cmd_MRT_DUMP: MRT DUMP mrt_dump_args END  */
#line 55 "proto/mrt/config.Y"
{ mrt_dump_cmd((yyvsp[-1].md)); }
#line 15753 "obj/conf/cf-parse.tab.c"
    break;

  case 1550: /* mrt_dump_args: %empty  */
#line 63 "proto/mrt/config.Y"
               { (yyval.md) = cfg_allocz(sizeof(struct mrt_dump_data)); }
#line 15759 "obj/conf/cf-parse.tab.c"
    break;

  case 1551: /* mrt_dump_args: mrt_dump_args TABLE rtable  */
#line 64 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->table_ptr = (yyvsp[0].r)->table; }
#line 15765 "obj/conf/cf-parse.tab.c"
    break;

  case 1552: /* mrt_dump_args: mrt_dump_args TABLE TEXT  */
#line 65 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->table_expr = (yyvsp[0].t); }
#line 15771 "obj/conf/cf-parse.tab.c"
    break;

  case 1553: /* mrt_dump_args: mrt_dump_args FILTER filter  */
#line 66 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->filter = (yyvsp[0].f); }
#line 15777 "obj/conf/cf-parse.tab.c"
    break;

  case 1554: /* mrt_dump_args: mrt_dump_args where_filter  */
#line 67 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-1].md); (yyval.md)->filter = (yyvsp[0].f); }
#line 15783 "obj/conf/cf-parse.tab.c"
    break;

  case 1555: /* mrt_dump_args: mrt_dump_args TO text  */
#line 68 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->filename = (yyvsp[0].t); }
#line 15789 "obj/conf/cf-parse.tab.c"
    break;

  case 1557: /* bmp_proto_start: proto_start BMP  */
#line 26 "proto/bmp/config.Y"
                                 {
     this_proto = proto_config_new(&proto_bmp, (yyvsp[-1].i));
     this_proto->loop_order = DOMAIN_ORDER(proto);
     BMP_CFG->sys_descr = "Not defined";
     BMP_CFG->sys_name = "Not defined";
     BMP_CFG->tx_pending_limit = (1 << 30) / page_size;
   }
#line 15801 "obj/conf/cf-parse.tab.c"
    break;

  case 1559: /* bmp_station_address: bmp_station_address IP ipa  */
#line 37 "proto/bmp/config.Y"
                              {
     if (ipa_zero((yyvsp[0].a)))
       cf_error("Invalid BMP monitoring station IP address");
     BMP_CFG->station_ip = (yyvsp[0].a);
   }
#line 15811 "obj/conf/cf-parse.tab.c"
    break;

  case 1560: /* bmp_station_address: bmp_station_address PORT expr  */
#line 42 "proto/bmp/config.Y"
                                 {
     if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 65535))
       cf_error("Invalid BMP monitoring station port number");
     BMP_CFG->station_port = (yyvsp[0].i);
   }
#line 15821 "obj/conf/cf-parse.tab.c"
    break;

  case 1563: /* bmp_proto: bmp_proto LOCAL ADDRESS ipa ';'  */
#line 52 "proto/bmp/config.Y"
                                   {
     BMP_CFG->local_addr = (yyvsp[-1].a);
   }
#line 15829 "obj/conf/cf-parse.tab.c"
    break;

  case 1565: /* bmp_proto: bmp_proto SYSTEM DESCRIPTION text ';'  */
#line 56 "proto/bmp/config.Y"
                                         {
     if (!(yyvsp[-1].t) || (strlen((yyvsp[-1].t)) == 0))
       cf_error("String is empty");
     else if (strlen((yyvsp[-1].t)) > 255)
       cf_error("Invalid string length");
     BMP_CFG->sys_descr = (yyvsp[-1].t);
   }
#line 15841 "obj/conf/cf-parse.tab.c"
    break;

  case 1566: /* bmp_proto: bmp_proto SYSTEM NAME text ';'  */
#line 63 "proto/bmp/config.Y"
                                  {
     if (!(yyvsp[-1].t) || (strlen((yyvsp[-1].t)) == 0))
       cf_error("String is empty");
     else if (strlen((yyvsp[-1].t)) > 255)
       cf_error("Invalid string length");
     BMP_CFG->sys_name = (yyvsp[-1].t);
   }
#line 15853 "obj/conf/cf-parse.tab.c"
    break;

  case 1567: /* bmp_proto: bmp_proto MONITORING RIB IN PRE_POLICY bool ';'  */
#line 70 "proto/bmp/config.Y"
                                                   {
     BMP_CFG->monitoring_rib_in_pre_policy = (yyvsp[-1].i);
   }
#line 15861 "obj/conf/cf-parse.tab.c"
    break;

  case 1568: /* bmp_proto: bmp_proto MONITORING RIB IN POST_POLICY bool ';'  */
#line 73 "proto/bmp/config.Y"
                                                    {
     BMP_CFG->monitoring_rib_in_post_policy = (yyvsp[-1].i);
   }
#line 15869 "obj/conf/cf-parse.tab.c"
    break;

  case 1569: /* bmp_proto: bmp_proto TX BUFFER LIMIT expr ';'  */
#line 76 "proto/bmp/config.Y"
                                      {
     BMP_CFG->tx_pending_limit = (yyvsp[-1].i) * (u64) (1 << 20) / page_size;
     if ((yyvsp[-1].i) < 1) cf_error("BMP TX buffer limit must be at least 1 megabyte");
   }
#line 15878 "obj/conf/cf-parse.tab.c"
    break;

  case 1571: /* kern_sys_item: KERNEL TABLE expr  */
#line 29 "sysdep/linux/netlink.Y"
                     { THIS_KRT->sys.table_id = (yyvsp[0].i); }
#line 15884 "obj/conf/cf-parse.tab.c"
    break;

  case 1572: /* kern_sys_item: METRIC expr  */
#line 30 "sysdep/linux/netlink.Y"
               { THIS_KRT->sys.metric = (yyvsp[0].i); }
#line 15890 "obj/conf/cf-parse.tab.c"
    break;

  case 1573: /* kern_sys_item: NETLINK RX BUFFER expr  */
#line 31 "sysdep/linux/netlink.Y"
                          { THIS_KRT->sys.netlink_rx_buffer = (yyvsp[0].i); }
#line 15896 "obj/conf/cf-parse.tab.c"
    break;

  case 1574: /* attr_bit: KRT_LOCK_MTU  */
#line 35 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(2, "krt_lock"); }
#line 15902 "obj/conf/cf-parse.tab.c"
    break;

  case 1575: /* attr_bit: KRT_LOCK_WINDOW  */
#line 36 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(3, "krt_lock"); }
#line 15908 "obj/conf/cf-parse.tab.c"
    break;

  case 1576: /* attr_bit: KRT_LOCK_RTT  */
#line 37 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(4, "krt_lock"); }
#line 15914 "obj/conf/cf-parse.tab.c"
    break;

  case 1577: /* attr_bit: KRT_LOCK_RTTVAR  */
#line 38 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(5, "krt_lock"); }
#line 15920 "obj/conf/cf-parse.tab.c"
    break;

  case 1578: /* attr_bit: KRT_LOCK_SSTHRESH  */
#line 39 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(6, "krt_lock"); }
#line 15926 "obj/conf/cf-parse.tab.c"
    break;

  case 1579: /* attr_bit: KRT_LOCK_CWND  */
#line 40 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(7, "krt_lock"); }
#line 15932 "obj/conf/cf-parse.tab.c"
    break;

  case 1580: /* attr_bit: KRT_LOCK_ADVMSS  */
#line 41 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(8, "krt_lock"); }
#line 15938 "obj/conf/cf-parse.tab.c"
    break;

  case 1581: /* attr_bit: KRT_LOCK_REORDERING  */
#line 42 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(9, "krt_lock"); }
#line 15944 "obj/conf/cf-parse.tab.c"
    break;

  case 1582: /* attr_bit: KRT_LOCK_HOPLIMIT  */
#line 43 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(10, "krt_lock"); }
#line 15950 "obj/conf/cf-parse.tab.c"
    break;

  case 1583: /* attr_bit: KRT_LOCK_INITCWND  */
#line 44 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(11, "krt_lock"); }
#line 15956 "obj/conf/cf-parse.tab.c"
    break;

  case 1584: /* attr_bit: KRT_LOCK_RTO_MIN  */
#line 46 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(13, "krt_lock"); }
#line 15962 "obj/conf/cf-parse.tab.c"
    break;

  case 1585: /* attr_bit: KRT_LOCK_INITRWND  */
#line 47 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(14, "krt_lock"); }
#line 15968 "obj/conf/cf-parse.tab.c"
    break;

  case 1586: /* attr_bit: KRT_LOCK_QUICKACK  */
#line 48 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(15, "krt_lock"); }
#line 15974 "obj/conf/cf-parse.tab.c"
    break;

  case 1587: /* attr_bit: KRT_LOCK_CONGCTL  */
#line 49 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(16, "krt_lock"); }
#line 15980 "obj/conf/cf-parse.tab.c"
    break;

  case 1588: /* attr_bit: KRT_LOCK_FASTOPEN_NO_COOKIE  */
#line 50 "sysdep/linux/netlink.Y"
                                        { (yyval.fab) = f_new_dynamic_attr_bit(17, "krt_lock"); }
#line 15986 "obj/conf/cf-parse.tab.c"
    break;

  case 1589: /* attr_bit: KRT_FEATURE_ECN  */
#line 53 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(0, "krt_features"); }
#line 15992 "obj/conf/cf-parse.tab.c"
    break;

  case 1590: /* attr_bit: KRT_FEATURE_ALLFRAG  */
#line 54 "sysdep/linux/netlink.Y"
                              { (yyval.fab) = f_new_dynamic_attr_bit(3, "krt_features"); }
#line 15998 "obj/conf/cf-parse.tab.c"
    break;

  case 1591: /* lvalue: attr_bit  */
#line 57 "sysdep/linux/netlink.Y"
                 { (yyval.flv) = (struct f_lval) { .type = F_LVAL_ATTR_BIT, .fab = (yyvsp[0].fab), .rte = f_new_inst(FI_CURRENT_ROUTE), }; }
#line 16004 "obj/conf/cf-parse.tab.c"
    break;

  case 1593: /* log_begin: %empty  */
#line 36 "sysdep/unix/config.Y"
           { this_log = cfg_allocz(sizeof(struct log_config)); }
#line 16010 "obj/conf/cf-parse.tab.c"
    break;

  case 1594: /* log_config: LOG log_begin log_file log_mask ';'  */
#line 38 "sysdep/unix/config.Y"
                                                {
    this_log->mask = (yyvsp[-1].i);
    add_tail(&new_config->logfiles, &this_log->n);
  }
#line 16019 "obj/conf/cf-parse.tab.c"
    break;

  case 1595: /* syslog_name: NAME text  */
#line 45 "sysdep/unix/config.Y"
             { (yyval.t) = (yyvsp[0].t); }
#line 16025 "obj/conf/cf-parse.tab.c"
    break;

  case 1596: /* syslog_name: %empty  */
#line 46 "sysdep/unix/config.Y"
   { (yyval.t) = bird_name; }
#line 16031 "obj/conf/cf-parse.tab.c"
    break;

  case 1598: /* log_limit: expr text  */
#line 51 "sysdep/unix/config.Y"
             { this_log->limit = (yyvsp[-1].i); this_log->backup = (yyvsp[0].t); }
#line 16037 "obj/conf/cf-parse.tab.c"
    break;

  case 1599: /* log_file: text log_limit  */
#line 55 "sysdep/unix/config.Y"
                  {
     if (!parse_and_exit)
     {
       this_log->rf = rf_open(new_config->pool, (yyvsp[-1].t), RF_APPEND, this_log->limit);
       if (!this_log->rf) cf_error("Unable to open log file '%s': %m", (yyvsp[-1].t));
     }
     this_log->filename = (yyvsp[-1].t);
   }
#line 16050 "obj/conf/cf-parse.tab.c"
    break;

  case 1600: /* log_file: FIXED text expr  */
#line 63 "sysdep/unix/config.Y"
                   {
     if (!parse_and_exit)
     {
       this_log->rf = rf_open(new_config->pool, (yyvsp[-1].t), RF_FIXED, this_log->limit = (yyvsp[0].i));
       if (!this_log->rf) cf_error("Unable to open log file '%s': %m", (yyvsp[-1].t));
     }
     this_log->filename = (yyvsp[-1].t);
   }
#line 16063 "obj/conf/cf-parse.tab.c"
    break;

  case 1601: /* log_file: SYSLOG syslog_name  */
#line 71 "sysdep/unix/config.Y"
                      { this_log->rf = NULL; new_config->syslog_name = (yyvsp[0].t); }
#line 16069 "obj/conf/cf-parse.tab.c"
    break;

  case 1602: /* log_file: STDERR  */
#line 72 "sysdep/unix/config.Y"
          { this_log->rf = &rf_stderr; this_log->terminal_flag = 1; }
#line 16075 "obj/conf/cf-parse.tab.c"
    break;

  case 1603: /* log_file: UDP log_udp_host log_udp_port  */
#line 73 "sysdep/unix/config.Y"
                                 { this_log->rf = NULL; }
#line 16081 "obj/conf/cf-parse.tab.c"
    break;

  case 1604: /* log_udp_host: text_or_ipa  */
#line 77 "sysdep/unix/config.Y"
{
  if ((yyvsp[0].v).type == T_STRING)
    this_log->udp_host = (yyvsp[0].v).val.s;
  else if ((yyvsp[0].v).type == T_IP)
    this_log->udp_ip = (yyvsp[0].v).val.ip;
  else bug("Bad text_or_ipa");
}
#line 16093 "obj/conf/cf-parse.tab.c"
    break;

  case 1605: /* log_udp_port: %empty  */
#line 86 "sysdep/unix/config.Y"
                { this_log->udp_port = 514; }
#line 16099 "obj/conf/cf-parse.tab.c"
    break;

  case 1606: /* log_udp_port: PORT expr  */
#line 87 "sysdep/unix/config.Y"
              { check_u16((yyvsp[0].i)); this_log->udp_port = (yyvsp[0].i); }
#line 16105 "obj/conf/cf-parse.tab.c"
    break;

  case 1607: /* log_mask: ALL  */
#line 91 "sysdep/unix/config.Y"
       { (yyval.i) = ~0; }
#line 16111 "obj/conf/cf-parse.tab.c"
    break;

  case 1608: /* log_mask: '{' log_mask_list '}'  */
#line 92 "sysdep/unix/config.Y"
                         { (yyval.i) = (yyvsp[-1].i); }
#line 16117 "obj/conf/cf-parse.tab.c"
    break;

  case 1609: /* log_mask_list: log_cat  */
#line 96 "sysdep/unix/config.Y"
           { (yyval.i) = 1 << (yyvsp[0].i); }
#line 16123 "obj/conf/cf-parse.tab.c"
    break;

  case 1610: /* log_mask_list: log_mask_list ',' log_cat  */
#line 97 "sysdep/unix/config.Y"
                             { (yyval.i) = (yyvsp[-2].i) | (1 << (yyvsp[0].i)); }
#line 16129 "obj/conf/cf-parse.tab.c"
    break;

  case 1611: /* log_cat: DEBUG  */
#line 101 "sysdep/unix/config.Y"
         { (yyval.i) = L_DEBUG[0]; }
#line 16135 "obj/conf/cf-parse.tab.c"
    break;

  case 1612: /* log_cat: TRACE  */
#line 102 "sysdep/unix/config.Y"
         { (yyval.i) = L_TRACE[0]; }
#line 16141 "obj/conf/cf-parse.tab.c"
    break;

  case 1613: /* log_cat: INFO  */
#line 103 "sysdep/unix/config.Y"
        { (yyval.i) = L_INFO[0]; }
#line 16147 "obj/conf/cf-parse.tab.c"
    break;

  case 1614: /* log_cat: REMOTE  */
#line 104 "sysdep/unix/config.Y"
          { (yyval.i) = L_REMOTE[0]; }
#line 16153 "obj/conf/cf-parse.tab.c"
    break;

  case 1615: /* log_cat: WARNING  */
#line 105 "sysdep/unix/config.Y"
           { (yyval.i) = L_WARN[0]; }
#line 16159 "obj/conf/cf-parse.tab.c"
    break;

  case 1616: /* log_cat: ERROR  */
#line 106 "sysdep/unix/config.Y"
         { (yyval.i) = L_ERR[0]; }
#line 16165 "obj/conf/cf-parse.tab.c"
    break;

  case 1617: /* log_cat: AUTH  */
#line 107 "sysdep/unix/config.Y"
        { (yyval.i) = L_AUTH[0]; }
#line 16171 "obj/conf/cf-parse.tab.c"
    break;

  case 1618: /* log_cat: FATAL  */
#line 108 "sysdep/unix/config.Y"
         { (yyval.i) = L_FATAL[0]; }
#line 16177 "obj/conf/cf-parse.tab.c"
    break;

  case 1619: /* log_cat: BUG  */
#line 109 "sysdep/unix/config.Y"
       { (yyval.i) = L_BUG[0]; }
#line 16183 "obj/conf/cf-parse.tab.c"
    break;

  case 1621: /* mrtdump_base: MRTDUMP PROTOCOLS mrtdump_mask ';'  */
#line 116 "sysdep/unix/config.Y"
                                      { new_config->proto_default_mrtdump = (yyvsp[-1].i); }
#line 16189 "obj/conf/cf-parse.tab.c"
    break;

  case 1622: /* mrtdump_base: MRTDUMP text ';'  */
#line 117 "sysdep/unix/config.Y"
                    {
     if (!parse_and_exit)
     {
       struct rfile *f = rf_open(new_config->pool, (yyvsp[-1].t), RF_APPEND, 0);
       if (!f) cf_error("Unable to open MRTDump file '%s': %m", (yyvsp[-1].t));
       new_config->mrtdump_file = f;
     }
   }
#line 16202 "obj/conf/cf-parse.tab.c"
    break;

  case 1624: /* cli: CLI text cli_opts  */
#line 129 "sysdep/unix/config.Y"
                       {
  this_cli_config->name = (yyvsp[-1].t);
  cli_config_add_tail(&new_config->cli, this_cli_config);
  this_cli_config = NULL;
}
#line 16212 "obj/conf/cf-parse.tab.c"
    break;

  case 1627: /* cli_opts_begin: %empty  */
#line 137 "sysdep/unix/config.Y"
                {
  this_cli_config = cfg_alloc(sizeof *this_cli_config);
  *this_cli_config = (typeof (*this_cli_config)) {
    .config = new_config,
    .mode = 0660,
  };
}
#line 16224 "obj/conf/cf-parse.tab.c"
    break;

  case 1629: /* cli_opts_block: cli_opts_block RESTRICT ';'  */
#line 147 "sysdep/unix/config.Y"
                                { this_cli_config->restricted = 1; }
#line 16230 "obj/conf/cf-parse.tab.c"
    break;

  case 1630: /* cli_opts_block: cli_opts_block V2 ATTRIBUTES ';'  */
#line 148 "sysdep/unix/config.Y"
                                     { this_cli_config->v2attributes = 1; }
#line 16236 "obj/conf/cf-parse.tab.c"
    break;

  case 1631: /* conf: THREADS expr  */
#line 151 "sysdep/unix/config.Y"
                   {
  if ((yyvsp[0].i) < 1) cf_error("Number of threads must be at least one.");
  if (!new_config->thread_group_simple &&
      !EMPTY_TLIST(thread_group_config, &new_config->thread_group))
    cf_error("Mixing of `threads NUM` and `threads worker {}` is not allowed.");

  if (new_config->thread_group_simple == -1)
    THEAD(thread_group_config, &new_config->thread_group)->thread_count = (yyvsp[0].i);

  new_config->thread_group_simple = (yyvsp[0].i);
}
#line 16252 "obj/conf/cf-parse.tab.c"
    break;

  case 1634: /* thread_group_start: THREAD GROUP symbol  */
#line 167 "sysdep/unix/config.Y"
                                        {
  switch (new_config->thread_group_simple) {
    case -1: cf_error("Put `threads` block before any protocol or table definition.");
    case 0: break;
    default: cf_error("Mixing of `threads NUM` and `threads worker {}` is not allowed.");
  }

  this_thread_group = cfg_alloc(sizeof *this_thread_group);
  *this_thread_group = strcmp((yyvsp[0].s)->name, "express") ?
    thread_group_config_default_worker :
    thread_group_config_default_express;
  this_thread_group->symbol = cf_define_symbol(new_config, (yyvsp[0].s), SYM_THREAD_GROUP, thread_group, this_thread_group);
}
#line 16270 "obj/conf/cf-parse.tab.c"
    break;

  case 1635: /* thread_group_opt: MAX TIME expr_us  */
#line 182 "sysdep/unix/config.Y"
                    { this_thread_group->params.max_time = (yyvsp[0].time); }
#line 16276 "obj/conf/cf-parse.tab.c"
    break;

  case 1636: /* thread_group_opt: MIN TIME expr_us  */
#line 183 "sysdep/unix/config.Y"
                    { this_thread_group->params.min_time = (yyvsp[0].time); }
#line 16282 "obj/conf/cf-parse.tab.c"
    break;

  case 1637: /* thread_group_opt: MAX LATENCY expr_us  */
#line 184 "sysdep/unix/config.Y"
                       { this_thread_group->params.max_latency = (yyvsp[0].time); }
#line 16288 "obj/conf/cf-parse.tab.c"
    break;

  case 1638: /* thread_group_opt: THREADS expr  */
#line 185 "sysdep/unix/config.Y"
                { this_thread_group->thread_count = (yyvsp[0].i); }
#line 16294 "obj/conf/cf-parse.tab.c"
    break;

  case 1639: /* thread_group_opt: WAKEUP TIME expr_us  */
#line 186 "sysdep/unix/config.Y"
                       { this_thread_group->params.wakeup_time = (yyvsp[0].time); }
#line 16300 "obj/conf/cf-parse.tab.c"
    break;

  case 1640: /* thread_group_opt: DEFAULT bool  */
#line 187 "sysdep/unix/config.Y"
                {
    if ((yyvsp[0].i)) {
      if (new_config->default_thread_group && new_config->default_thread_group != this_thread_group) {
        cf_error("Too many default thread groups, already have %s",
          new_config->default_thread_group->symbol->name);
      }
      new_config->default_thread_group = this_thread_group;
    }
  }
#line 16314 "obj/conf/cf-parse.tab.c"
    break;

  case 1645: /* thread_group_end: %empty  */
#line 208 "sysdep/unix/config.Y"
                  {
  if (this_thread_group->params.max_time > 60 S_)
    cf_error("Loop time maximum is 60 seconds, got %t", this_thread_group->params.max_time);
  if (this_thread_group->params.max_latency < this_thread_group->params.max_time)
    cf_error("Loop time maximum can't be higher than its latency limit");
  if (this_thread_group->params.min_time > this_thread_group->params.max_time)
    cf_error("Loop time minimm can't be higher than maximum");
  if (this_thread_group->params.wakeup_time < 1 S_)
    cf_error("Too low idle wakeup time, expected at least 1 second");

  thread_group_config_add_tail(&new_config->thread_group, this_thread_group);
  this_thread_group = NULL;
}
#line 16332 "obj/conf/cf-parse.tab.c"
    break;

  case 1647: /* debug_unix: DEBUG LATENCY latency_debug_mask  */
#line 226 "sysdep/unix/config.Y"
                                    { new_config->latency_debug = (yyvsp[0].i); }
#line 16338 "obj/conf/cf-parse.tab.c"
    break;

  case 1648: /* debug_unix: DEBUG LATENCY LIMIT expr_us  */
#line 227 "sysdep/unix/config.Y"
                               { new_config->latency_limit = (yyvsp[0].time); }
#line 16344 "obj/conf/cf-parse.tab.c"
    break;

  case 1649: /* debug_unix: WATCHDOG WARNING expr_us  */
#line 228 "sysdep/unix/config.Y"
                            { new_config->watchdog_warning = (yyvsp[0].time); }
#line 16350 "obj/conf/cf-parse.tab.c"
    break;

  case 1650: /* debug_unix: WATCHDOG TIMEOUT expr_us  */
#line 229 "sysdep/unix/config.Y"
                            { new_config->watchdog_timeout = ((yyvsp[0].time) + 999999) TO_S; }
#line 16356 "obj/conf/cf-parse.tab.c"
    break;

  case 1651: /* latency_debug_mask: ALL  */
#line 233 "sysdep/unix/config.Y"
       { (yyval.i) = ~0; }
#line 16362 "obj/conf/cf-parse.tab.c"
    break;

  case 1652: /* latency_debug_mask: OFF  */
#line 234 "sysdep/unix/config.Y"
       { (yyval.i) = 0; }
#line 16368 "obj/conf/cf-parse.tab.c"
    break;

  case 1653: /* latency_debug_mask: '{' latency_debug_list '}'  */
#line 235 "sysdep/unix/config.Y"
                              { (yyval.i) = (yyvsp[-1].i); }
#line 16374 "obj/conf/cf-parse.tab.c"
    break;

  case 1655: /* latency_debug_list: latency_debug_list ',' latency_debug_flag  */
#line 238 "sysdep/unix/config.Y"
                                                                                   { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 16380 "obj/conf/cf-parse.tab.c"
    break;

  case 1656: /* latency_debug_flag: PING  */
#line 241 "sysdep/unix/config.Y"
                { (yyval.i) = DL_PING; }
#line 16386 "obj/conf/cf-parse.tab.c"
    break;

  case 1657: /* latency_debug_flag: WAKEUP  */
#line 242 "sysdep/unix/config.Y"
                { (yyval.i) = DL_WAKEUP; }
#line 16392 "obj/conf/cf-parse.tab.c"
    break;

  case 1658: /* latency_debug_flag: SOCKETS  */
#line 243 "sysdep/unix/config.Y"
                { (yyval.i) = DL_SOCKETS; }
#line 16398 "obj/conf/cf-parse.tab.c"
    break;

  case 1659: /* latency_debug_flag: SCHEDULING  */
#line 244 "sysdep/unix/config.Y"
                { (yyval.i) = DL_SCHEDULING; }
#line 16404 "obj/conf/cf-parse.tab.c"
    break;

  case 1660: /* latency_debug_flag: ALLOCATOR  */
#line 245 "sysdep/unix/config.Y"
                { (yyval.i) = DL_ALLOCATOR; }
#line 16410 "obj/conf/cf-parse.tab.c"
    break;

  case 1661: /* latency_debug_flag: EVENTS  */
#line 246 "sysdep/unix/config.Y"
                { (yyval.i) = DL_EVENTS; }
#line 16416 "obj/conf/cf-parse.tab.c"
    break;

  case 1662: /* latency_debug_flag: TIMERS  */
#line 247 "sysdep/unix/config.Y"
                { (yyval.i) = DL_TIMERS; }
#line 16422 "obj/conf/cf-parse.tab.c"
    break;

  case 1664: /* cmd_CONFIGURE: CONFIGURE cfg_name cfg_timeout END  */
#line 256 "sysdep/unix/config.Y"
{ cmd_reconfig((yyvsp[-2].t), RECONFIG_HARD, (yyvsp[-1].i)); }
#line 16428 "obj/conf/cf-parse.tab.c"
    break;

  case 1666: /* cmd_CONFIGURE_SOFT: CONFIGURE SOFT cfg_name cfg_timeout END  */
#line 259 "sysdep/unix/config.Y"
{ cmd_reconfig((yyvsp[-2].t), RECONFIG_SOFT, (yyvsp[-1].i)); }
#line 16434 "obj/conf/cf-parse.tab.c"
    break;

  case 1668: /* cmd_CONFIGURE_CONFIRM: CONFIGURE CONFIRM END  */
#line 266 "sysdep/unix/config.Y"
{ cmd_reconfig_confirm(); }
#line 16440 "obj/conf/cf-parse.tab.c"
    break;

  case 1670: /* cmd_CONFIGURE_UNDO: CONFIGURE UNDO END  */
#line 269 "sysdep/unix/config.Y"
{ cmd_reconfig_undo(); }
#line 16446 "obj/conf/cf-parse.tab.c"
    break;

  case 1672: /* cmd_CONFIGURE_STATUS: CONFIGURE STATUS END  */
#line 272 "sysdep/unix/config.Y"
{ cmd_reconfig_status(); }
#line 16452 "obj/conf/cf-parse.tab.c"
    break;

  case 1674: /* cmd_CONFIGURE_CHECK: CONFIGURE CHECK cfg_name END  */
#line 275 "sysdep/unix/config.Y"
{ cmd_check_config((yyvsp[-1].t)); }
#line 16458 "obj/conf/cf-parse.tab.c"
    break;

  case 1676: /* cmd_DOWN: DOWN END  */
#line 278 "sysdep/unix/config.Y"
{ cmd_shutdown(); }
#line 16464 "obj/conf/cf-parse.tab.c"
    break;

  case 1678: /* cmd_GRACEFUL_RESTART: GRACEFUL RESTART END  */
#line 283 "sysdep/unix/config.Y"
{ cmd_graceful_restart(); }
#line 16470 "obj/conf/cf-parse.tab.c"
    break;

  case 1680: /* cmd_SHOW_THREADS: SHOW THREADS END  */
#line 286 "sysdep/unix/config.Y"
{ cmd_show_threads(0); }
#line 16476 "obj/conf/cf-parse.tab.c"
    break;

  case 1682: /* cmd_SHOW_THREADS_ALL: SHOW THREADS ALL END  */
#line 289 "sysdep/unix/config.Y"
{ cmd_show_threads(1); }
#line 16482 "obj/conf/cf-parse.tab.c"
    break;

  case 1683: /* cfg_name: %empty  */
#line 292 "sysdep/unix/config.Y"
               { (yyval.t) = NULL; }
#line 16488 "obj/conf/cf-parse.tab.c"
    break;

  case 1685: /* cfg_timeout: %empty  */
#line 297 "sysdep/unix/config.Y"
               { (yyval.i) = 0; }
#line 16494 "obj/conf/cf-parse.tab.c"
    break;

  case 1686: /* cfg_timeout: TIMEOUT  */
#line 298 "sysdep/unix/config.Y"
           { (yyval.i) = UNIX_DEFAULT_CONFIGURE_TIMEOUT; }
#line 16500 "obj/conf/cf-parse.tab.c"
    break;

  case 1687: /* cfg_timeout: TIMEOUT expr  */
#line 299 "sysdep/unix/config.Y"
                { (yyval.i) = (yyvsp[0].i); }
#line 16506 "obj/conf/cf-parse.tab.c"
    break;

  case 1689: /* kern_proto_start: proto_start KERNEL  */
#line 45 "sysdep/unix/krt.Y"
                                     {
     this_proto = krt_init_config((yyvsp[-1].i));
}
#line 16514 "obj/conf/cf-parse.tab.c"
    break;

  case 1692: /* kern_learn: bool  */
#line 54 "sysdep/unix/krt.Y"
        { (yyval.i) = (yyvsp[0].i) ? KRT_LEARN_ALIEN : KRT_LEARN_NONE; }
#line 16520 "obj/conf/cf-parse.tab.c"
    break;

  case 1693: /* kern_learn: ALL  */
#line 55 "sysdep/unix/krt.Y"
        { (yyval.i) = KRT_LEARN_ALL; }
#line 16526 "obj/conf/cf-parse.tab.c"
    break;

  case 1694: /* kern_mp_limit: %empty  */
#line 59 "sysdep/unix/krt.Y"
               { (yyval.i) = KRT_DEFAULT_ECMP_LIMIT; }
#line 16532 "obj/conf/cf-parse.tab.c"
    break;

  case 1695: /* kern_mp_limit: LIMIT expr  */
#line 60 "sysdep/unix/krt.Y"
               { (yyval.i) = (yyvsp[0].i); if (((yyvsp[0].i) <= 0) || ((yyvsp[0].i) > 255)) cf_error("Merge paths limit must be in range 1-255"); }
#line 16538 "obj/conf/cf-parse.tab.c"
    break;

  case 1699: /* kern_item: kern_channel  */
#line 71 "sysdep/unix/krt.Y"
                { this_proto->net_type = (yyvsp[0].cc)->net_type; }
#line 16544 "obj/conf/cf-parse.tab.c"
    break;

  case 1700: /* kern_item: PERSIST bool  */
#line 72 "sysdep/unix/krt.Y"
                { THIS_KRT->persist = (yyvsp[0].i); }
#line 16550 "obj/conf/cf-parse.tab.c"
    break;

  case 1701: /* kern_item: SCAN TIME expr  */
#line 73 "sysdep/unix/krt.Y"
                  {
      /* Scan time of 0 means scan on startup only */
      THIS_KRT->scan_time = (yyvsp[0].i) S_;
   }
#line 16559 "obj/conf/cf-parse.tab.c"
    break;

  case 1702: /* kern_item: LEARN kern_learn  */
#line 77 "sysdep/unix/krt.Y"
                    {
      THIS_KRT->learn = (yyvsp[0].i);
#ifndef KRT_ALLOW_LEARN
      if ((yyvsp[0].i))
	cf_error("Learning of kernel routes not supported on this platform");
#endif
   }
#line 16571 "obj/conf/cf-parse.tab.c"
    break;

  case 1703: /* kern_item: GRACEFUL RESTART bool  */
#line 84 "sysdep/unix/krt.Y"
                         { THIS_KRT->graceful_restart = (yyvsp[0].i); }
#line 16577 "obj/conf/cf-parse.tab.c"
    break;

  case 1704: /* kern_item: MERGE PATHS bool kern_mp_limit  */
#line 85 "sysdep/unix/krt.Y"
                                  {
      THIS_KRT->merge_paths = (yyvsp[-1].i) ? (yyvsp[0].i) : 0;
#ifndef KRT_ALLOW_MERGE_PATHS
      if ((yyvsp[-1].i))
	cf_error("Path merging not supported on this platform");
#endif
   }
#line 16589 "obj/conf/cf-parse.tab.c"
    break;

  case 1706: /* kif_proto_start: proto_start DEVICE  */
#line 98 "sysdep/unix/krt.Y"
                                    { this_proto = kif_init_config((yyvsp[-1].i)); }
#line 16595 "obj/conf/cf-parse.tab.c"
    break;

  case 1711: /* kif_item: SCAN TIME expr  */
#line 107 "sysdep/unix/krt.Y"
                  {
      /* Scan time of 0 means scan on startup only */
      THIS_KIF->scan_time = (yyvsp[0].i) S_;
   }
#line 16604 "obj/conf/cf-parse.tab.c"
    break;

  case 1712: /* kif_iface_start: %empty  */
#line 114 "sysdep/unix/krt.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct kif_iface_config));
  add_tail(&THIS_KIF->iface_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
}
#line 16614 "obj/conf/cf-parse.tab.c"
    break;

  case 1713: /* kif_iface_item: PREFERRED ipa  */
#line 121 "sysdep/unix/krt.Y"
                 { kif_set_preferred((yyvsp[0].a)); }
#line 16620 "obj/conf/cf-parse.tab.c"
    break;


#line 16624 "obj/conf/cf-parse.tab.c"

        default: break;
      }
    if (yychar_backup != yychar)
      YY_LAC_DISCARD ("yychar change");
  }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yyesa, &yyes, &yyes_capacity, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        if (yychar != YYEMPTY)
          YY_LAC_ESTABLISH;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  /* If the stack popping above didn't lose the initial context for the
     current lookahead token, the shift below will for sure.  */
  YY_LAC_DISCARD ("error recovery");

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yyes != yyesa)
    YYSTACK_FREE (yyes);
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 57 "conf/gen_parser.m4"

#line 572 "conf/confbase.Y"
/* C Code from conf/confbase.Y */

#line 206 "conf/flowspec.Y"
/* C Code from conf/flowspec.Y */

#line 1055 "nest/config.Y"
/* C Code from nest/config.Y */

#line 200 "nest/mpls.Y"
/* C Code from nest/mpls.Y */

#line 149 "proto/aggregator/config.Y"
/* C Code from proto/aggregator/config.Y */

#line 271 "proto/bfd/config.Y"
/* C Code from proto/bfd/config.Y */

#line 205 "proto/babel/config.Y"
/* C Code from proto/babel/config.Y */

#line 562 "proto/bgp/config.Y"
/* C Code from proto/bgp/config.Y */

#line 105 "proto/l3vpn/config.Y"
/* C Code from proto/l3vpn/config.Y */

#line 566 "proto/ospf/config.Y"
/* C Code from proto/ospf/config.Y */

#line 58 "proto/pipe/config.Y"
/* C Code from proto/pipe/config.Y */

#line 354 "proto/radv/config.Y"
/* C Code from proto/radv/config.Y */

#line 203 "proto/rip/config.Y"
/* C Code from proto/rip/config.Y */

#line 185 "proto/rpki/config.Y"
/* C Code from proto/rpki/config.Y */

#line 208 "proto/static/config.Y"
/* C Code from proto/static/config.Y */

#line 72 "proto/mrt/config.Y"
/* C Code from proto/mrt/config.Y */

#line 82 "proto/bmp/config.Y"
/* C Code from proto/bmp/config.Y */

#line 59 "sysdep/linux/netlink.Y"
/* C Code from sysdep/linux/netlink.Y */

#line 302 "sysdep/unix/config.Y"
/* C Code from sysdep/unix/config.Y */

#line 138 "sysdep/unix/krt.Y"
/* C Code from sysdep/unix/krt.Y */

