// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	context "context"

	ciliumiov2 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CiliumEndpointsGetter has a method to return a CiliumEndpointInterface.
// A group's client should implement this interface.
type CiliumEndpointsGetter interface {
	CiliumEndpoints(namespace string) CiliumEndpointInterface
}

// CiliumEndpointInterface has methods to work with CiliumEndpoint resources.
type CiliumEndpointInterface interface {
	Create(ctx context.Context, ciliumEndpoint *ciliumiov2.CiliumEndpoint, opts v1.CreateOptions) (*ciliumiov2.CiliumEndpoint, error)
	Update(ctx context.Context, ciliumEndpoint *ciliumiov2.CiliumEndpoint, opts v1.UpdateOptions) (*ciliumiov2.CiliumEndpoint, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, ciliumEndpoint *ciliumiov2.CiliumEndpoint, opts v1.UpdateOptions) (*ciliumiov2.CiliumEndpoint, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*ciliumiov2.CiliumEndpoint, error)
	List(ctx context.Context, opts v1.ListOptions) (*ciliumiov2.CiliumEndpointList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *ciliumiov2.CiliumEndpoint, err error)
	CiliumEndpointExpansion
}

// ciliumEndpoints implements CiliumEndpointInterface
type ciliumEndpoints struct {
	*gentype.ClientWithList[*ciliumiov2.CiliumEndpoint, *ciliumiov2.CiliumEndpointList]
}

// newCiliumEndpoints returns a CiliumEndpoints
func newCiliumEndpoints(c *CiliumV2Client, namespace string) *ciliumEndpoints {
	return &ciliumEndpoints{
		gentype.NewClientWithList[*ciliumiov2.CiliumEndpoint, *ciliumiov2.CiliumEndpointList](
			"ciliumendpoints",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *ciliumiov2.CiliumEndpoint { return &ciliumiov2.CiliumEndpoint{} },
			func() *ciliumiov2.CiliumEndpointList { return &ciliumiov2.CiliumEndpointList{} },
		),
	}
}
