static const char *embedded_config = ""
"group \"Elm_Config\" struct {"
"  value \"config_version\" int: 131096;"
"  value \"entry_select_allow\" uchar: 1;"
"  value \"engine\" string: \"\";"
"  value \"vsync\" uchar: 1;"
"  value \"thumbscroll_enable\" uchar: 0;"
"  value \"thumbscroll_threshold\" int: 4;"
"  value \"thumbscroll_hold_threshold\" int: 4;"
"  value \"thumbscroll_momentum_threshold\" double: 100.0;"
"  value \"thumbscroll_flick_distance_tolerance\" int: 1000;"
"  value \"thumbscroll_friction\" double: 1.0;"
"  value \"thumbscroll_momentum_distance_max\" int: 3000;"
"  value \"thumbscroll_momentum_friction\" double: 0.95;"
""
"  value \"thumbscroll_momentum_animation_duration_min_limit\" double: 0.3;"
"  value \"thumbscroll_momentum_animation_duration_max_limit\" double: 1.3;"
"  // will not be used"
"  value \"thumbscroll_min_friction\" double: 1.0;"
"  value \"thumbscroll_friction_standard\" double: 2000.0;"
"  //"
"  value \"thumbscroll_bounce_friction\" double: 0.5;"
"  value \"thumbscroll_bounce_enable\" uchar: 0;"
"  value \"thumbscroll_acceleration_threshold\" double: 500.0;"
"  value \"thumbscroll_acceleration_time_limit\" double: 0.7;"
"  value \"thumbscroll_acceleration_weight\" double: 1.5;"
"  value \"page_scroll_friction\" double: 0.5;"
"  value \"bring_in_scroll_friction\" double: 0.5;"
"  value \"zoom_friction\" double: 0.5;"
"  value \"thumbscroll_border_friction\" double: 0.5;"
"  value \"thumbscroll_sensitivity_friction\" double: 0.25;"
"  value \"scroll_smooth_start_enable\" uchar: 1;"
"  value \"scroll_smooth_amount\" double: 1.0;"
"  value \"scroll_smooth_time_window\" double: 0.15;"
"  value \"scroll_accel_factor\" double: 7.0;"
"  value \"focus_autoscroll_mode\" uchar: 0;"
"  value \"slider_indicator_visible_mode\" int: 0;"
"  value \"scale\" double: 1.0;"
"  value \"bgpixmap\" int: 0;"
"  value \"compositing\" int: 1;"
"  value \"font_hinting\" int: 2;"
"  value \"cache_flush_poll_interval\" int: 512;"
"  value \"cache_flush_enable\" uchar: 1;"
"  value \"image_cache\" int: 65536;"
"  value \"font_cache\" int: 512;"
"  value \"edje_cache\" int: 32;"
"  value \"edje_collection_cache\" int: 64;"
"  value \"finger_size\" int: 10;"
"  value \"fps\" double: 60.0;"
"  value \"theme\" string: \"default\";"
"  value \"modules\" string: \"prefs>prefs_iface:access_output>access/api:clock_input_ctxpopup>clock/api\";"
"  value \"tooltip_delay\" double: 1.0;"
"  value \"cursor_engine_only\" uchar: 0;"
"  value \"focus_highlight_enable\" uchar: 0;"
"  value \"focus_highlight_animate\" uchar: 0;"
"  value \"focus_highlight_clip_disable\" uchar: 1;"
"  value \"item_select_on_focus_disable\" uchar: 1;"
"  value \"first_item_focus_on_first_focus_in\" uchar: 0;"
"  value \"focus_move_policy\" uchar: 0;"
"  value \"toolbar_shrink_mode\" int: 3;"
"  value \"fileselector_expand_enable\" uchar: 1;"
"  value \"fileselector_double_tap_navigation_enable\" uchar: 1;"
"  value \"inwin_dialogs_enable\" uchar: 0;"
"  value \"icon_size\" int: 32;"
"  value \"longpress_timeout\" double: 1.0;"
"  value \"effect_enable\" uchar: 1;"
"  value \"desktop_entry\" uchar: 1;"
"  value \"context_menu_disabled\" uchar: 0;"
"  value \"password_show_last\" uchar: 0;"
"  value \"password_show_last_timeout\" double: 2.0;"
"  value \"glayer_zoom_finger_enable\" uchar: 1;"
"  value \"glayer_zoom_finger_factor\" double: 1.0;"
"  value \"glayer_zoom_wheel_factor\" double: 0.05;"
"  value \"glayer_zoom_distance_tolerance\" double: 1.0;"
"  value \"glayer_rotate_finger_enable\" uchar: 1;"
"  value \"glayer_rotate_angular_tolerance\" double: 2.0;"
"  value \"glayer_line_min_length\" double: 1.0;"
"  value \"glayer_line_distance_tolerance\" double: 3.0;"
"  value \"glayer_line_angular_tolerance\" double: 20.0;"
"  value \"glayer_flick_time_limit_ms\" uint: 120; /* ms to finish flick */"
"  value \"glayer_long_tap_start_timeout\" double: 1.2; /* sec to start long-tap */"
"  value \"glayer_double_tap_timeout\" double: 0.25; /* Timeout between two mouse dows when doing double click (and more). */"
"  value \"glayer_continues_enable\" uchar: 1;          /* Continues gesture enabled */"
"  value \"glayer_tap_finger_size\" int: 10;"
"  value \"week_start\" int: 1;"
"  value \"weekend_start\" int: 6;"
"  value \"weekend_len\" int: 2;"
"  value \"year_min\" int: 2;"
"  value \"year_max\" int: 137;"
"  value \"softcursor_mode\" uchar: 0;"
"  value \"auto_norender_withdrawn\" uchar: 1;"
"  value \"auto_norender_iconified_same_as_withdrawn\" uchar: 1;"
"  value \"auto_flush_withdrawn\" uchar: 1;"
"  value \"auto_dump_withdrawn\" uchar: 0;"
"  value \"auto_throttle\" uchar: 0;"
"  value \"auto_throttle_amount\" double: 0.0333333333;"
"  value \"magnifier_enable\" uchar: 0;"
"  value \"magnifier_scale\" double: 1.5;"
"  value \"audio_mute_effect\" uchar: 0;"
"  value \"audio_mute_background\" uchar: 0;"
"  value \"audio_mute_music\" uchar: 0;"
"  value \"audio_mute_foreground\" uchar: 0;"
"  value \"audio_mute_interface\" uchar: 0;"
"  value \"audio_mute_input\" uchar: 0;"
"  value \"audio_mute_alert\" uchar: 0;"
"  value \"audio_mute_all\" uchar: 0;"
"  value \"win_auto_focus_enable\" uchar: 1;"
"  value \"win_auto_focus_animate\" uchar: 1;"
"  value \"transition_duration_factor\" double: 1.0;"
"  value \"naviframe_prev_btn_auto_pushed\" uchar: 1;"
"  value \"popup_horizontal_align\" double: 0.5;"
"  value \"popup_vertical_align\" double: 0.5;"
"  value \"popup_scrollable\" uchar: 0;"
"  value \"spinner_min_max_filter_enable\" uchar: 0;"
"  group \"color_palette\" list {"
"     group \"Elm_Custom_Palette\" struct {"
"        value \"palette_name\" string: \"default\";"
"        group \"color_list\" list {"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 0;"
"              value \"b\" uint: 0;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 0;"
"              value \"g\" uint: 255;"
"              value \"b\" uint: 0;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 0;"
"              value \"g\" uint: 0;"
"              value \"b\" uint: 255;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 255;"
"              value \"b\" uint: 0;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 0;"
"              value \"g\" uint: 255;"
"              value \"b\" uint: 255;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 0;"
"              value \"b\" uint: 255;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 90;"
"              value \"b\" uint: 0;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 180;"
"              value \"b\" uint: 0;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 92;"
"              value \"g\" uint: 142;"
"              value \"b\" uint: 151;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 41;"
"              value \"g\" uint: 68;"
"              value \"b\" uint: 59;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 41;"
"              value \"g\" uint: 46;"
"              value \"b\" uint: 68;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 68;"
"              value \"g\" uint: 40;"
"              value \"b\" uint: 55;"
"              value \"a\" uint: 255;"
"           }"
"        }"
"     }"
"     group \"Elm_Custom_Palette\" struct {"
"        value \"palette_name\" string: \"painting\";"
"        group \"color_list\" list {"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 90;"
"              value \"b\" uint: 18;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 213;"
"              value \"b\" uint: 0;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 146;"
"              value \"g\" uint: 255;"
"              value \"b\" uint: 11;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 9;"
"              value \"g\" uint: 186;"
"              value \"b\" uint: 10;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 86;"
"              value \"g\" uint: 201;"
"              value \"b\" uint: 242;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 18;"
"              value \"g\" uint: 83;"
"              value \"b\" uint: 128;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 140;"
"              value \"g\" uint: 53;"
"              value \"b\" uint: 238;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 145;"
"              value \"b\" uint: 145;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 59;"
"              value \"b\" uint: 119;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 133;"
"              value \"g\" uint: 100;"
"              value \"b\" uint: 69;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 255;"
"              value \"g\" uint: 255;"
"              value \"b\" uint: 119;"
"              value \"a\" uint: 255;"
"           }"
"           group \"Elm_Color_RGBA\" struct {"
"              value \"r\" uint: 133;"
"              value \"g\" uint: 100;"
"              value \"b\" uint: 255;"
"              value \"a\" uint: 255;"
"           }"
"        }"
"     }"
"  }"
"  group \"bindings\" list {"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Ctxpopup\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"previous\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Fileselector\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"BackSpace\";"
"              value \"action\" string: \"backspace\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Hoversel\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Combobox\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"return\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"return\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"return\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Multibuttonentry\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"BackSpace\";"
"              value \"action\" string: \"delete\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Delete\";"
"              value \"action\" string: \"delete\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"enter\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"enter\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Popup\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"previous\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"esc\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Button\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Nstate\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Calendar\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Calendar\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Check\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Colorselector\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Diskselector\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prev\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prev\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prev\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prev\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Flipselector\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"flip\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"flip\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"flip\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"flip\";"
"              value \"params\" string: \"down\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Gengrid\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Genlist\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Image\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_List\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Map\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Add\";"
"              value \"action\" string: \"zoom\";"
"              value \"params\" string: \"in\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Subtract\";"
"              value \"action\" string: \"zoom\";"
"              value \"params\" string: \"out\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Panel\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"toggle\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"toggle\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"toggle\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Image_Zoomable\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Add\";"
"              value \"action\" string: \"zoom\";"
"              value \"params\" string: \"in\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Subtract\";"
"              value \"action\" string: \"zoom\";"
"              value \"params\" string: \"out\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Naviframe\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"BackSpace\";"
"              value \"action\" string: \"top_item_get\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"item_pop\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Player\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"play\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Radio\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"activate\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Scroller\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Slider\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"down\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Slider\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"down\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Slider_Interval\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"drag\";"
"              value \"params\" string: \"down\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Slideshow\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"pause\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"pause\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"pause\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Spinner\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"spin\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"toggle\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"toggle\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"toggle\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Elm_Toolbar\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Item\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Tab_Bar\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Video\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"play\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Win\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"return\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"return\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Alt\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"ISO_Left_Tab\";"
"              value \"action\" string: \"return\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"ISO_Left_Tab\";"
"              value \"action\" string: \"return\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Alt\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"previous\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Alt\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"ISO_Left_Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"previous\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Alt\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Alt\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"ISO_Left_Tab\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Alt\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.List\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 0;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down_multi\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Shift\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Return\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Enter\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"space\";"
"              value \"action\" string: \"select\";"
"              value \"params\" string: \"\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Escape\";"
"              value \"action\" string: \"escape\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Scroller\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Left\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"left\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Right\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"right\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Up\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"up\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Down\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"down\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Home\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"first\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_End\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"last\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Prior\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"prior\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"KP_Next\";"
"              value \"action\" string: \"move\";"
"              value \"params\" string: \"next\";"
"           }"
"       }"
"     }"
"     group \"Elm_Config_Bindings_Widget\" struct {"
"        value \"name\" string: \"Efl.Ui.Textbox\";"
"        group \"key_bindings\" list {"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"c\";"
"              value \"action\" string: \"copy\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"x\";"
"              value \"action\" string: \"cut\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"v\";"
"              value \"action\" string: \"paste\";"
"              value \"params\" string: \"\";"
"              group \"modifiers\" list {"
"                 group \"Elm_Config_Binding_Modifier\" struct {"
"                    value \"mod\" string: \"Control\";"
"                    value \"flag\" uchar: 1;"
"                 }"
"              }"
"           }"
"           group \"Elm_Config_Binding_Key\" struct {"
"              value \"context\" int: 0;"
"              value \"key\" string: \"menu\";"
"              value \"action\" string: \"menu\";"
"              value \"params\" string: \"\";"
"           }"
"        }"
"     }"
"  }"
"}"
"";
