/* components-web-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from components-web-view.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2016-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <webkit2/webkit2.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#define COMPONENTS_WEB_VIEW_MESSAGE_ENABLE_REMOTE_LOAD "__enable_remote_load__"
#define COMPONENTS_WEB_VIEW_MESSAGE_EXCEPTION "__exception__"
#define COMPONENTS_WEB_VIEW_MESSAGE_RETURN_VALUE "__return__"
#define COMPONENTS_WEB_VIEW_COMMAND_STACK_CHANGED "command_stack_changed"
#define COMPONENTS_WEB_VIEW_CONTENT_LOADED "content_loaded"
#define COMPONENTS_WEB_VIEW_DOCUMENT_MODIFIED "document_modified"
#define COMPONENTS_WEB_VIEW_PREFERRED_HEIGHT_CHANGED "preferred_height_changed"
#define COMPONENTS_WEB_VIEW_REMOTE_RESOURCE_LOAD_BLOCKED "remote_resource_load_blocked"
#define COMPONENTS_WEB_VIEW_SELECTION_CHANGED "selection_changed"
#define COMPONENTS_WEB_VIEW_ZOOM_DEFAULT 1.0
#define COMPONENTS_WEB_VIEW_ZOOM_FACTOR 0.1
#define COMPONENTS_WEB_VIEW_ZOOM_MAX 2.0
#define COMPONENTS_WEB_VIEW_ZOOM_MIN 0.5
#define COMPONENTS_WEB_VIEW_USER_CSS "user-style.css"
#define COMPONENTS_WEB_VIEW_USER_CSS_LEGACY "user-message.css"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE (components_web_view_message_callable_get_type ())
#define COMPONENTS_WEB_VIEW_MESSAGE_CALLABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE, ComponentsWebViewMessageCallable))
#define COMPONENTS_WEB_VIEW_MESSAGE_CALLABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE, ComponentsWebViewMessageCallableClass))
#define COMPONENTS_WEB_VIEW_IS_MESSAGE_CALLABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE))
#define COMPONENTS_WEB_VIEW_IS_MESSAGE_CALLABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE))
#define COMPONENTS_WEB_VIEW_MESSAGE_CALLABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE, ComponentsWebViewMessageCallableClass))

typedef struct _ComponentsWebViewMessageCallable ComponentsWebViewMessageCallable;
typedef struct _ComponentsWebViewMessageCallableClass ComponentsWebViewMessageCallableClass;
enum  {
	COMPONENTS_WEB_VIEW_0_PROPERTY,
	COMPONENTS_WEB_VIEW_IS_CONTENT_LOADED_PROPERTY,
	COMPONENTS_WEB_VIEW_HAS_SELECTION_PROPERTY,
	COMPONENTS_WEB_VIEW_PREFERRED_HEIGHT_PROPERTY,
	COMPONENTS_WEB_VIEW_IS_LOAD_REMOTE_RESOURCES_ENABLED_PROPERTY,
	COMPONENTS_WEB_VIEW_DOCUMENT_FONT_PROPERTY,
	COMPONENTS_WEB_VIEW_MONOSPACE_FONT_PROPERTY,
	COMPONENTS_WEB_VIEW_NUM_PROPERTIES
};
static GParamSpec* components_web_view_properties[COMPONENTS_WEB_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block62Data Block62Data;

#define COMPONENTS_WEB_VIEW_TYPE_WEBSITE_DATA_MANAGER (components_web_view_website_data_manager_get_type ())
#define COMPONENTS_WEB_VIEW_WEBSITE_DATA_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPONENTS_WEB_VIEW_TYPE_WEBSITE_DATA_MANAGER, ComponentsWebViewWebsiteDataManager))
#define COMPONENTS_WEB_VIEW_WEBSITE_DATA_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), COMPONENTS_WEB_VIEW_TYPE_WEBSITE_DATA_MANAGER, ComponentsWebViewWebsiteDataManagerClass))
#define COMPONENTS_WEB_VIEW_IS_WEBSITE_DATA_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPONENTS_WEB_VIEW_TYPE_WEBSITE_DATA_MANAGER))
#define COMPONENTS_WEB_VIEW_IS_WEBSITE_DATA_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COMPONENTS_WEB_VIEW_TYPE_WEBSITE_DATA_MANAGER))
#define COMPONENTS_WEB_VIEW_WEBSITE_DATA_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), COMPONENTS_WEB_VIEW_TYPE_WEBSITE_DATA_MANAGER, ComponentsWebViewWebsiteDataManagerClass))

typedef struct _ComponentsWebViewWebsiteDataManager ComponentsWebViewWebsiteDataManager;
typedef struct _ComponentsWebViewWebsiteDataManagerClass ComponentsWebViewWebsiteDataManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _webkit_user_script_unref0(var) ((var == NULL) ? NULL : (var = (webkit_user_script_unref (var), NULL)))
#define _webkit_user_style_sheet_unref0(var) ((var == NULL) ? NULL : (var = (webkit_user_style_sheet_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _Block63Data Block63Data;
typedef struct _Block64Data Block64Data;
#define _util_js_callable_unref0(var) ((var == NULL) ? NULL : (var = (util_js_callable_unref (var), NULL)))
typedef struct _ComponentsWebViewGetHtmlData ComponentsWebViewGetHtmlData;
typedef struct _ComponentsWebViewLoadRemoteResourcesData ComponentsWebViewLoadRemoteResourcesData;
typedef struct _ComponentsWebViewSetEditableData ComponentsWebViewSetEditableData;
typedef struct _ComponentsWebViewCallVoidData ComponentsWebViewCallVoidData;
typedef struct _ComponentsWebViewCallReturningData ComponentsWebViewCallReturningData;
#define _components_web_view_message_callable_unref0(var) ((var == NULL) ? NULL : (var = (components_web_view_message_callable_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
typedef struct _ComponentsWebViewCallImplData ComponentsWebViewCallImplData;
#define __vala_WebKitNavigationAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_WebKitNavigationAction_free (var), NULL)))
typedef struct _ComponentsWebViewMessageCallablePrivate ComponentsWebViewMessageCallablePrivate;
typedef struct _ComponentsWebViewWebsiteDataManagerPrivate ComponentsWebViewWebsiteDataManagerPrivate;
enum  {
	COMPONENTS_WEB_VIEW_WEBSITE_DATA_MANAGER_0_PROPERTY,
	COMPONENTS_WEB_VIEW_WEBSITE_DATA_MANAGER_NUM_PROPERTIES
};
static GParamSpec* components_web_view_website_data_manager_properties[COMPONENTS_WEB_VIEW_WEBSITE_DATA_MANAGER_NUM_PROPERTIES];
typedef struct _ComponentsWebViewParamSpecMessageCallable ComponentsWebViewParamSpecMessageCallable;
enum  {
	COMPONENTS_WEB_VIEW_CONTENT_LOADED_SIGNAL,
	COMPONENTS_WEB_VIEW_COMMAND_STACK_CHANGED_SIGNAL,
	COMPONENTS_WEB_VIEW_DOCUMENT_MODIFIED_SIGNAL,
	COMPONENTS_WEB_VIEW_LINK_ACTIVATED_SIGNAL,
	COMPONENTS_WEB_VIEW_INTERNAL_RESOURCE_LOADED_SIGNAL,
	COMPONENTS_WEB_VIEW_REMOTE_RESOURCE_LOAD_BLOCKED_SIGNAL,
	COMPONENTS_WEB_VIEW_NUM_SIGNALS
};
static guint components_web_view_signals[COMPONENTS_WEB_VIEW_NUM_SIGNALS] = {0};

struct _ComponentsWebViewPrivate {
	gboolean _is_content_loaded;
	gboolean _has_selection;
	gboolean _is_load_remote_resources_enabled;
	gchar* _document_font;
	gchar* _monospace_font;
	const gchar* body;
	GeeMap* internal_resources;
	GeeMap* message_handlers;
	gdouble webkit_reported_height;
};

struct _Block62Data {
	int _ref_count_;
	WebKitWebContext* context;
	ApplicationConfiguration* config;
	GFile* web_extension_dir;
};

struct _Block63Data {
	int _ref_count_;
	ComponentsWebView* self;
	gchar* body;
	gchar* base_uri;
};

struct _Block64Data {
	int _ref_count_;
	Block63Data * _data63_;
	gulong handler_id;
};

struct _ComponentsWebViewGetHtmlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsWebView* self;
	gchar* result;
	gchar* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _ComponentsWebViewLoadRemoteResourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsWebView* self;
	GCancellable* cancellable;
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	GError* _inner_error0_;
};

struct _ComponentsWebViewSetEditableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsWebView* self;
	gboolean enabled;
	GCancellable* cancellable;
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	GError* _inner_error0_;
};

struct _ComponentsWebViewCallVoidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsWebView* self;
	UtilJSCallable* target;
	GCancellable* cancellable;
	WebKitUserMessage* _tmp0_;
	WebKitUserMessage* _tmp1_;
	GError* _inner_error0_;
};

struct _ComponentsWebViewCallReturningData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsWebView* self;
	UtilJSCallable* target;
	GCancellable* cancellable;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gpointer result;
	WebKitUserMessage* response;
	WebKitUserMessage* _tmp0_;
	WebKitUserMessage* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	GVariant* param;
	WebKitUserMessage* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gpointer ret_value;
	GType ret_type;
	GVariant* _tmp10_;
	gpointer _tmp11_;
	gboolean _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	const GVariantType* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	GVariantClass param_type;
	GVariant* _tmp19_;
	gboolean _tmp20_;
	GVariant* _tmp21_;
	const gchar* _tmp22_;
	gpointer _tmp23_;
	gboolean _tmp24_;
	gboolean* _tmp25_;
	GVariant* _tmp26_;
	gboolean _tmp27_;
	gboolean* _tmp28_;
	gboolean* _tmp29_;
	gboolean _tmp30_;
	gint* _tmp31_;
	GVariant* _tmp32_;
	gint _tmp33_;
	gint* _tmp34_;
	gint* _tmp35_;
	gboolean _tmp36_;
	gshort* _tmp37_;
	GVariant* _tmp38_;
	gshort _tmp39_;
	gshort* _tmp40_;
	gshort* _tmp41_;
	gboolean _tmp42_;
	gchar* _tmp43_;
	GVariant* _tmp44_;
	gchar _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gboolean _tmp48_;
	glong* _tmp49_;
	GVariant* _tmp50_;
	glong _tmp51_;
	glong* _tmp52_;
	glong* _tmp53_;
	gboolean _tmp54_;
	gint64* _tmp55_;
	GVariant* _tmp56_;
	gint64 _tmp57_;
	gint64* _tmp58_;
	gint64* _tmp59_;
	gboolean _tmp60_;
	guint* _tmp61_;
	GVariant* _tmp62_;
	guint _tmp63_;
	guint* _tmp64_;
	guint* _tmp65_;
	gboolean _tmp66_;
	guchar* _tmp67_;
	GVariant* _tmp68_;
	guchar _tmp69_;
	guchar* _tmp70_;
	guchar* _tmp71_;
	gboolean _tmp72_;
	gushort* _tmp73_;
	GVariant* _tmp74_;
	gushort _tmp75_;
	gushort* _tmp76_;
	gushort* _tmp77_;
	gboolean _tmp78_;
	gulong* _tmp79_;
	GVariant* _tmp80_;
	gulong _tmp81_;
	gulong* _tmp82_;
	gulong* _tmp83_;
	gboolean _tmp84_;
	guint64* _tmp85_;
	GVariant* _tmp86_;
	guint64 _tmp87_;
	guint64* _tmp88_;
	guint64* _tmp89_;
	gboolean _tmp90_;
	gdouble* _tmp91_;
	GVariant* _tmp92_;
	gdouble _tmp93_;
	gdouble* _tmp94_;
	gdouble* _tmp95_;
	gboolean _tmp96_;
	gfloat* _tmp97_;
	GVariant* _tmp98_;
	gfloat _tmp99_;
	gfloat* _tmp100_;
	gfloat* _tmp101_;
	const gchar* _tmp102_;
	const gchar* _tmp103_;
	GError* _tmp104_;
	GError* _inner_error0_;
};

struct _ComponentsWebViewCallImplData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsWebView* self;
	UtilJSCallable* target;
	GCancellable* cancellable;
	WebKitUserMessage* result;
	WebKitUserMessage* response;
	WebKitUserMessage* _tmp0_;
	WebKitUserMessage* _tmp1_;
	WebKitUserMessage* _tmp2_;
	WebKitUserMessage* _tmp3_;
	WebKitUserMessage* _tmp4_;
	gchar* response_name;
	WebKitUserMessage* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GVariantDict* exception;
	WebKitUserMessage* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariantDict* _tmp13_;
	gchar* name;
	GVariantDict* _tmp14_;
	const GVariantType* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* message;
	GVariantDict* _tmp20_;
	const GVariantType* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* backtrace;
	GVariantDict* _tmp26_;
	const GVariantType* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* source;
	GVariantDict* _tmp32_;
	const GVariantType* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GVariant* line;
	GVariantDict* _tmp38_;
	const GVariantType* _tmp39_;
	GVariant* _tmp40_;
	GVariant* column;
	GVariantDict* _tmp41_;
	const GVariantType* _tmp42_;
	GVariant* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gint _tmp48_;
	GVariant* _tmp49_;
	GVariant* _tmp50_;
	gint _tmp51_;
	GVariant* _tmp52_;
	GVariant* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* log_message;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	GError* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	const gchar* _tmp68_;
	GError* _tmp69_;
	GError* _tmp70_;
	GError* _inner_error0_;
};

struct _ComponentsWebViewMessageCallable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentsWebViewMessageCallback handler;
	gpointer handler_target;
	ComponentsWebViewMessageCallablePrivate * priv;
};

struct _ComponentsWebViewMessageCallableClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentsWebViewMessageCallable *self);
};

struct _ComponentsWebViewWebsiteDataManager {
	WebKitWebsiteDataManager parent_instance;
	ComponentsWebViewWebsiteDataManagerPrivate * priv;
};

struct _ComponentsWebViewWebsiteDataManagerClass {
	WebKitWebsiteDataManagerClass parent_class;
};

struct _ComponentsWebViewParamSpecMessageCallable {
	GParamSpec parent_instance;
};

static gint ComponentsWebView_private_offset;
static gpointer components_web_view_parent_class = NULL;
static WebKitWebContext* components_web_view_default_context;
static WebKitWebContext* components_web_view_default_context = NULL;
static WebKitUserStyleSheet* components_web_view_user_stylesheet;
static WebKitUserStyleSheet* components_web_view_user_stylesheet = NULL;
static WebKitUserScript* components_web_view_script;
static WebKitUserScript* components_web_view_script = NULL;
static gpointer components_web_view_website_data_manager_parent_class = NULL;
static gpointer components_web_view_message_callable_parent_class = NULL;
static GearyBaseInterfaceIface * components_web_view_geary_base_interface_parent_iface = NULL;

static gpointer components_web_view_message_callable_ref (gpointer instance);
static void components_web_view_message_callable_unref (gpointer instance);
static GParamSpec* components_web_view_param_spec_message_callable (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags) G_GNUC_UNUSED ;
static void components_web_view_value_set_message_callable (GValue* value,
                                                     gpointer v_object) G_GNUC_UNUSED ;
static void components_web_view_value_take_message_callable (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer components_web_view_value_get_message_callable (const GValue* value) G_GNUC_UNUSED ;
static GType components_web_view_message_callable_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static GType components_web_view_website_data_manager_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ComponentsWebViewWebsiteDataManager* components_web_view_website_data_manager_new (const gchar* base_cache_directory);
static ComponentsWebViewWebsiteDataManager* components_web_view_website_data_manager_construct (GType object_type,
                                                                                         const gchar* base_cache_directory);
static void __lambda168_ (WebKitURISchemeRequest* req);
static void components_web_view_handle_cid_request (ComponentsWebView* self,
                                             WebKitURISchemeRequest* request);
static void ___lambda168__web_kit_uri_scheme_request_callback (WebKitURISchemeRequest* request,
                                                        gpointer self);
static void __lambda169_ (WebKitURISchemeRequest* req);
static void components_web_view_handle_internal_request (ComponentsWebView* self,
                                                  WebKitURISchemeRequest* request);
static void ___lambda169__web_kit_uri_scheme_request_callback (WebKitURISchemeRequest* request,
                                                        gpointer self);
static void __lambda170_ (Block62Data* _data62_,
                   WebKitWebContext* context);
static void ___lambda170__webkit_web_context_initialize_web_extensions (WebKitWebContext* _sender,
                                                                 gpointer self);
static inline void components_web_view_update_spellcheck (WebKitWebContext* context,
                                            ApplicationConfiguration* config);
static void __lambda171_ (Block62Data* _data62_);
static void ___lambda171__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static inline guint components_web_view_to_wk2_font_size (PangoFontDescription* font);
static void components_web_view_set_is_content_loaded (ComponentsWebView* self,
                                                gboolean value);
static void components_web_view_set_has_selection (ComponentsWebView* self,
                                            gboolean value);
static void components_web_view_set_is_load_remote_resources_enabled (ComponentsWebView* self,
                                                               gboolean value);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void components_web_view_init (ComponentsWebView* self,
                               ApplicationConfiguration* config);
static void components_web_view_real_destroy (GtkWidget* base);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
static void ___lambda63_ (Block64Data* _data64_);
static void ____lambda63__gtk_widget_map (GtkWidget* _sender,
                                   gpointer self);
static void components_web_view_get_html_data_free (gpointer _data);
static gboolean components_web_view_get_html_co (ComponentsWebViewGetHtmlData* _data_);
static void components_web_view_get_html_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void components_web_view_load_remote_resources_data_free (gpointer _data);
static gboolean components_web_view_load_remote_resources_co (ComponentsWebViewLoadRemoteResourcesData* _data_);
static void components_web_view_load_remote_resources_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void components_web_view_set_editable_data_free (gpointer _data);
static gboolean components_web_view_set_editable_co (ComponentsWebViewSetEditableData* _data_);
static void components_web_view_set_editable_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void components_web_view_call_void_data_free (gpointer _data);
static gboolean components_web_view_call_void_co (ComponentsWebViewCallVoidData* _data_);
static void components_web_view_call_impl (ComponentsWebView* self,
                                    UtilJSCallable* target,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static WebKitUserMessage* components_web_view_call_impl_finish (ComponentsWebView* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void components_web_view_call_void_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void components_web_view_call_returning_data_free (gpointer _data);
static gboolean components_web_view_call_returning_co (ComponentsWebViewCallReturningData* _data_);
static void components_web_view_call_returning_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static gboolean* _bool_dup (gboolean* self);
static gint* _int_dup (gint* self);
static gshort* _short_dup (gshort* self);
static gchar* _g_ascii_dup (gchar* self);
static glong* _long_dup (glong* self);
static gint64* _int64_dup (gint64* self);
static guint* _uint_dup (guint* self);
static guchar* _uchar_dup (guchar* self);
static gushort* _ushort_dup (gushort* self);
static gulong* _ulong_dup (gulong* self);
static guint64* _uint64_dup (guint64* self);
static gdouble* _double_dup (gdouble* self);
static gfloat* _float_dup (gfloat* self);
static const char* _g_variant_class_to_string (GVariantClass value);
static ComponentsWebViewMessageCallable* components_web_view_message_callable_new (ComponentsWebViewMessageCallback handler,
                                                                            gpointer handler_target);
static ComponentsWebViewMessageCallable* components_web_view_message_callable_construct (GType object_type,
                                                                                  ComponentsWebViewMessageCallback handler,
                                                                                  gpointer handler_target);
static gboolean components_web_view_on_decide_policy (ComponentsWebView* self,
                                               WebKitWebView* view,
                                               WebKitPolicyDecision* policy,
                                               WebKitPolicyDecisionType type);
static gboolean _components_web_view_on_decide_policy_webkit_web_view_decide_policy (WebKitWebView* _sender,
                                                                              WebKitPolicyDecision* decision,
                                                                              WebKitPolicyDecisionType type,
                                                                              gpointer self);
static void __lambda42_ (ComponentsWebView* self,
                  WebKitWebProcessTerminationReason reason);
static void ___lambda42__webkit_web_view_web_process_terminated (WebKitWebView* _sender,
                                                          WebKitWebProcessTerminationReason reason,
                                                          gpointer self);
static void components_web_view_on_command_stack_changed (ComponentsWebView* self,
                                                   GVariant* parameters);
static void _components_web_view_on_command_stack_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                         gpointer self);
static void components_web_view_on_content_loaded (ComponentsWebView* self,
                                            GVariant* parameters);
static void _components_web_view_on_content_loaded_components_web_view_message_callback (GVariant* parameters,
                                                                                  gpointer self);
static void components_web_view_on_document_modified (ComponentsWebView* self,
                                               GVariant* parameters);
static void _components_web_view_on_document_modified_components_web_view_message_callback (GVariant* parameters,
                                                                                     gpointer self);
static void components_web_view_on_preferred_height_changed (ComponentsWebView* self,
                                                      GVariant* parameters);
static void _components_web_view_on_preferred_height_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                            gpointer self);
static void components_web_view_on_remote_resource_load_blocked (ComponentsWebView* self,
                                                          GVariant* parameters);
static void _components_web_view_on_remote_resource_load_blocked_components_web_view_message_callback (GVariant* parameters,
                                                                                                gpointer self);
static void components_web_view_on_selection_changed (ComponentsWebView* self,
                                               GVariant* parameters);
static void _components_web_view_on_selection_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                     gpointer self);
static gboolean components_web_view_on_message_received (ComponentsWebView* self,
                                                  WebKitUserMessage* message);
static gboolean _components_web_view_on_message_received_webkit_web_view_user_message_received (WebKitWebView* _sender,
                                                                                         WebKitUserMessage* message,
                                                                                         gpointer self);
static gboolean components_web_view_on_scroll_event (ComponentsWebView* self,
                                              GdkEventScroll* event);
static gboolean _components_web_view_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                       GdkEventScroll* event,
                                                                       gpointer self);
static void components_web_view_call_impl_data_free (gpointer _data);
static gboolean components_web_view_call_impl_co (ComponentsWebViewCallImplData* _data_);
static void components_web_view_call_impl_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static gchar* _variant_get8 (GVariant* value);
static gchar* _variant_get9 (GVariant* value);
static gchar* _variant_get10 (GVariant* value);
static gchar* _variant_get11 (GVariant* value);
static gboolean components_web_view_handle_internal_response (ComponentsWebView* self,
                                                       WebKitURISchemeRequest* request);
static WebKitNavigationAction* _vala_WebKitNavigationAction_copy (WebKitNavigationAction* self);
static void _vala_WebKitNavigationAction_free (WebKitNavigationAction* self);
static gchar* _variant_get12 (GVariant* value);
static gchar* _variant_get13 (GVariant* value);
static GType components_web_view_website_data_manager_get_type_once (void);
static void components_web_view_message_callable_finalize (ComponentsWebViewMessageCallable * obj);
static GType components_web_view_message_callable_get_type_once (void);
static void components_web_view_finalize (GObject * obj);
static GType components_web_view_get_type_once (void);
static void _vala_components_web_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_components_web_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
components_web_view_get_instance_private (ComponentsWebView* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsWebView_private_offset);
}

/**
     * Initialises WebKit.WebContext for use by the client.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block62Data*
block62_data_ref (Block62Data* _data62_)
{
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}

static void
block62_data_unref (void * _userdata_)
{
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		_g_object_unref0 (_data62_->context);
		_g_object_unref0 (_data62_->config);
		_g_object_unref0 (_data62_->web_extension_dir);
		g_slice_free (Block62Data, _data62_);
	}
}

static void
__lambda168_ (WebKitURISchemeRequest* req)
{
	ComponentsWebView* view = NULL;
	WebKitWebView* _tmp0_;
	ComponentsWebView* _tmp1_;
	ComponentsWebView* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (req, webkit_uri_scheme_request_get_type ()));
	_tmp0_ = webkit_uri_scheme_request_get_web_view (req);
	_tmp1_ = _g_object_ref0 (COMPONENTS_IS_WEB_VIEW (_tmp0_) ? ((ComponentsWebView*) _tmp0_) : NULL);
	view = _tmp1_;
	_tmp2_ = view;
	if (_tmp2_ != NULL) {
		ComponentsWebView* _tmp3_;
		_tmp3_ = view;
		components_web_view_handle_cid_request (_tmp3_, req);
	}
	_g_object_unref0 (view);
}

static void
___lambda168__web_kit_uri_scheme_request_callback (WebKitURISchemeRequest* request,
                                                   gpointer self)
{
	__lambda168_ (request);
}

static void
__lambda169_ (WebKitURISchemeRequest* req)
{
	ComponentsWebView* view = NULL;
	WebKitWebView* _tmp0_;
	ComponentsWebView* _tmp1_;
	ComponentsWebView* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (req, webkit_uri_scheme_request_get_type ()));
	_tmp0_ = webkit_uri_scheme_request_get_web_view (req);
	_tmp1_ = _g_object_ref0 (COMPONENTS_IS_WEB_VIEW (_tmp0_) ? ((ComponentsWebView*) _tmp0_) : NULL);
	view = _tmp1_;
	_tmp2_ = view;
	if (_tmp2_ != NULL) {
		ComponentsWebView* _tmp3_;
		_tmp3_ = view;
		components_web_view_handle_internal_request (_tmp3_, req);
	}
	_g_object_unref0 (view);
}

static void
___lambda169__web_kit_uri_scheme_request_callback (WebKitURISchemeRequest* request,
                                                   gpointer self)
{
	__lambda169_ (request);
}

static void
__lambda170_ (Block62Data* _data62_,
              WebKitWebContext* context)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, webkit_web_context_get_type ()));
	_tmp0_ = g_file_get_path (_data62_->web_extension_dir);
	_tmp1_ = _tmp0_;
	webkit_web_context_set_web_extensions_directory (context, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = application_configuration_get_enable_debug (_data62_->config);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_boolean (_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	webkit_web_context_set_web_extensions_initialization_user_data (context, _tmp5_);
	_g_variant_unref0 (_tmp5_);
}

static void
___lambda170__webkit_web_context_initialize_web_extensions (WebKitWebContext* _sender,
                                                            gpointer self)
{
	__lambda170_ (self, _sender);
}

static void
__lambda171_ (Block62Data* _data62_)
{
	WebKitWebContext* _tmp0_;
	_tmp0_ = _data62_->context;
	components_web_view_update_spellcheck (_tmp0_, _data62_->config);
}

static void
___lambda171__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	__lambda171_ (self);
}

void
components_web_view_init_web_context (ApplicationConfiguration* config,
                                      GFile* web_extension_dir,
                                      GFile* cache_dir,
                                      gboolean sandboxed)
{
	Block62Data* _data62_;
	ApplicationConfiguration* _tmp0_;
	GFile* _tmp1_;
	ComponentsWebViewWebsiteDataManager* data_manager = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ComponentsWebViewWebsiteDataManager* _tmp4_;
	ComponentsWebViewWebsiteDataManager* _tmp5_;
	ComponentsWebViewWebsiteDataManager* _tmp6_;
	WebKitWebContext* _tmp7_;
	WebKitWebContext* _tmp12_;
	WebKitWebContext* _tmp13_;
	WebKitWebContext* _tmp14_;
	WebKitWebContext* _tmp15_;
	WebKitWebContext* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	gchar* _tmp19_;
	WebKitWebContext* _tmp20_;
	WebKitWebContext* _tmp21_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (config));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (web_extension_dir, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cache_dir, g_file_get_type ()));
	_data62_ = g_slice_new0 (Block62Data);
	_data62_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (_data62_->config);
	_data62_->config = _tmp0_;
	_tmp1_ = _g_object_ref0 (web_extension_dir);
	_g_object_unref0 (_data62_->web_extension_dir);
	_data62_->web_extension_dir = _tmp1_;
	_tmp2_ = g_file_get_path (cache_dir);
	_tmp3_ = _tmp2_;
	_tmp4_ = components_web_view_website_data_manager_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	data_manager = _tmp5_;
	_tmp6_ = data_manager;
	_tmp7_ = webkit_web_context_new_with_website_data_manager (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, webkit_website_data_manager_get_type (), WebKitWebsiteDataManager));
	_data62_->context = _tmp7_;
	if (sandboxed) {
		WebKitWebContext* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		WebKitWebContext* _tmp11_;
		_tmp8_ = _data62_->context;
		_tmp9_ = g_file_get_path (_data62_->web_extension_dir);
		_tmp10_ = _tmp9_;
		webkit_web_context_add_path_to_sandbox (_tmp8_, _tmp10_, TRUE);
		_g_free0 (_tmp10_);
		_tmp11_ = _data62_->context;
		webkit_web_context_set_sandbox_enabled (_tmp11_, TRUE);
	}
	_tmp12_ = _data62_->context;
	webkit_web_context_set_cache_model (_tmp12_, WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER);
	_tmp13_ = _data62_->context;
	webkit_web_context_register_uri_scheme (_tmp13_, "cid", ___lambda168__web_kit_uri_scheme_request_callback, NULL, NULL);
	_tmp14_ = _data62_->context;
	webkit_web_context_register_uri_scheme (_tmp14_, "geary", ___lambda169__web_kit_uri_scheme_request_callback, NULL, NULL);
	_tmp15_ = _data62_->context;
	g_signal_connect_data (_tmp15_, "initialize-web-extensions", (GCallback) ___lambda170__webkit_web_context_initialize_web_extensions, block62_data_ref (_data62_), (GClosureNotify) block62_data_unref, 0);
	_tmp16_ = _data62_->context;
	components_web_view_update_spellcheck (_tmp16_, _data62_->config);
	_tmp17_ = application_configuration_get_settings (_data62_->config);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("changed::", APPLICATION_CONFIGURATION_SPELL_CHECK_LANGUAGES, NULL);
	g_signal_connect_data (_tmp18_, _tmp19_, (GCallback) ___lambda171__g_settings_changed, block62_data_ref (_data62_), (GClosureNotify) block62_data_unref, 0);
	_g_free0 (_tmp19_);
	_tmp20_ = _data62_->context;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (components_web_view_default_context);
	components_web_view_default_context = _tmp21_;
	_g_object_unref0 (data_manager);
	block62_data_unref (_data62_);
	_data62_ = NULL;
}

/**
     * Loads static resources used by WebView.
     */
void
components_web_view_load_resources (GFile* user_dir,
                                    GError** error)
{
	WebKitUserScript* _tmp0_ = NULL;
	WebKitUserScript* _tmp1_;
	WebKitUserScript* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (user_dir, g_file_get_type ()));
	_tmp1_ = components_web_view_load_app_script ("components-web-view.js", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_webkit_user_script_unref0 (components_web_view_script);
	components_web_view_script = _tmp2_;
	_tmp3_ = g_strdup (COMPONENTS_WEB_VIEW_USER_CSS);
	_tmp4_ = g_strdup (COMPONENTS_WEB_VIEW_USER_CSS_LEGACY);
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp5_;
		name_collection_length1 = 2;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp6_;
			gchar* name = NULL;
			_tmp6_ = g_strdup (name_collection[name_it]);
			name = _tmp6_;
			{
				GFile* stylesheet = NULL;
				const gchar* _tmp7_;
				GFile* _tmp8_;
				_tmp7_ = name;
				_tmp8_ = g_file_get_child (user_dir, _tmp7_);
				stylesheet = _tmp8_;
				{
					WebKitUserStyleSheet* _tmp9_ = NULL;
					GFile* _tmp10_;
					WebKitUserStyleSheet* _tmp11_;
					WebKitUserStyleSheet* _tmp12_;
					_tmp10_ = stylesheet;
					_tmp11_ = components_web_view_load_user_stylesheet (_tmp10_, &_inner_error0_);
					_tmp9_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
							goto __catch0_g_io_error_not_found;
						}
						if (g_error_matches (_inner_error0_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
							goto __catch0_g_file_error_noent;
						}
						goto __catch0_g_error;
					}
					_tmp12_ = _tmp9_;
					_tmp9_ = NULL;
					_webkit_user_style_sheet_unref0 (components_web_view_user_stylesheet);
					components_web_view_user_stylesheet = _tmp12_;
					_webkit_user_style_sheet_unref0 (_tmp9_);
					_g_object_unref0 (stylesheet);
					_g_free0 (name);
					break;
				}
				goto __finally0;
				__catch0_g_io_error_not_found:
				{
					g_clear_error (&_inner_error0_);
				}
				goto __finally0;
				__catch0_g_file_error_noent:
				{
					g_clear_error (&_inner_error0_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					GFile* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					GError* _tmp16_;
					const gchar* _tmp17_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp13_ = stylesheet;
					_tmp14_ = g_file_get_path (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = err;
					_tmp17_ = _tmp16_->message;
					g_warning ("components-web-view.vala:143: Could not load %s: %s", _tmp15_, _tmp17_);
					_g_free0 (_tmp15_);
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (stylesheet);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_webkit_user_script_unref0 (_tmp0_);
					return;
				}
				_g_object_unref0 (stylesheet);
				_g_free0 (name);
			}
		}
		name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_webkit_user_script_unref0 (_tmp0_);
}

/** Loads an application-specific WebKit stylesheet. */
WebKitUserStyleSheet*
components_web_view_load_app_stylesheet (const gchar* name,
                                         GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	WebKitUserStyleSheet* _tmp2_;
	GError* _inner_error0_ = NULL;
	WebKitUserStyleSheet* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = gio_util_read_resource (name, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = webkit_user_style_sheet_new (_tmp0_, WEBKIT_USER_CONTENT_INJECT_TOP_FRAME, WEBKIT_USER_STYLE_LEVEL_USER, NULL, NULL);
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

/** Loads a user stylesheet from disk. */
WebKitUserStyleSheet*
components_web_view_load_user_stylesheet (GFile* name,
                                          GError** error)
{
	GearyMemoryFileBuffer* buf = NULL;
	GearyMemoryFileBuffer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	WebKitUserStyleSheet* _tmp3_;
	WebKitUserStyleSheet* _tmp4_;
	GError* _inner_error0_ = NULL;
	WebKitUserStyleSheet* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (name, g_file_get_type ()), NULL);
	_tmp0_ = geary_memory_file_buffer_new (name, TRUE, &_inner_error0_);
	buf = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = geary_memory_buffer_get_valid_utf8 (G_TYPE_CHECK_INSTANCE_CAST (buf, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_tmp2_ = _tmp1_;
	_tmp3_ = webkit_user_style_sheet_new (_tmp2_, WEBKIT_USER_CONTENT_INJECT_ALL_FRAMES, WEBKIT_USER_STYLE_LEVEL_USER, NULL, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	_g_object_unref0 (buf);
	return result;
}

/** Loads an application-specific WebKit JavaScript script. */
WebKitUserScript*
components_web_view_load_app_script (const gchar* name,
                                     GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	WebKitUserScript* _tmp2_;
	GError* _inner_error0_ = NULL;
	WebKitUserScript* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = gio_util_read_resource (name, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = webkit_user_script_new (_tmp0_, WEBKIT_USER_CONTENT_INJECT_TOP_FRAME, WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_START, NULL, NULL);
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static inline void
components_web_view_update_spellcheck (WebKitWebContext* context,
                                       ApplicationConfiguration* config)
{
	gchar** langs = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint langs_length1;
	gint _langs_size_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, webkit_web_context_get_type ()));
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (config));
	_tmp1_ = application_configuration_get_spell_check_languages (config, &_tmp0_);
	langs = _tmp1_;
	langs_length1 = _tmp0_;
	_langs_size_ = langs_length1;
	webkit_web_context_set_spell_checking_enabled (context, langs_length1 > 0);
	webkit_web_context_set_spell_checking_languages (context, langs);
	langs = (_vala_array_free (langs, langs_length1, (GDestroyNotify) g_free), NULL);
}

static inline guint
components_web_view_to_wk2_font_size (PangoFontDescription* font)
{
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	gdouble _tmp2_ = 0.0;
	GdkScreen* _tmp3_;
	gdouble dpi = 0.0;
	gdouble size = 0.0;
	guint result;
	g_return_val_if_fail (font != NULL, 0U);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp3_ = screen;
	if (_tmp3_ != NULL) {
		GdkScreen* _tmp4_;
		_tmp4_ = screen;
		_tmp2_ = gdk_screen_get_resolution (_tmp4_);
	} else {
		_tmp2_ = 96.0;
	}
	dpi = _tmp2_;
	size = (gdouble) pango_font_description_get_size (font);
	if (!pango_font_description_get_size_is_absolute (font)) {
		size = size / PANGO_SCALE;
	}
	result = (guint) ((size * dpi) / 72.0);
	_g_object_unref0 (screen);
	return result;
}

gboolean
components_web_view_get_is_content_loaded (ComponentsWebView* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), FALSE);
	result = self->priv->_is_content_loaded;
	return result;
}

static void
components_web_view_set_is_content_loaded (ComponentsWebView* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	old_value = components_web_view_get_is_content_loaded (self);
	if (old_value != value) {
		self->priv->_is_content_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, components_web_view_properties[COMPONENTS_WEB_VIEW_IS_CONTENT_LOADED_PROPERTY]);
	}
}

gboolean
components_web_view_get_has_selection (ComponentsWebView* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), FALSE);
	result = self->priv->_has_selection;
	return result;
}

static void
components_web_view_set_has_selection (ComponentsWebView* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	old_value = components_web_view_get_has_selection (self);
	if (old_value != value) {
		self->priv->_has_selection = value;
		g_object_notify_by_pspec ((GObject *) self, components_web_view_properties[COMPONENTS_WEB_VIEW_HAS_SELECTION_PROPERTY]);
	}
}

gint
components_web_view_get_preferred_height (ComponentsWebView* self)
{
	gint result;
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), 0);
	_tmp0_ = webkit_web_view_get_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp1_ = _tmp0_;
	result = (gint) round (self->priv->webkit_reported_height * _tmp1_);
	return result;
}

gboolean
components_web_view_get_is_load_remote_resources_enabled (ComponentsWebView* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), FALSE);
	result = self->priv->_is_load_remote_resources_enabled;
	return result;
}

static void
components_web_view_set_is_load_remote_resources_enabled (ComponentsWebView* self,
                                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	old_value = components_web_view_get_is_load_remote_resources_enabled (self);
	if (old_value != value) {
		self->priv->_is_load_remote_resources_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, components_web_view_properties[COMPONENTS_WEB_VIEW_IS_LOAD_REMOTE_RESOURCES_ENABLED_PROPERTY]);
	}
}

const gchar*
components_web_view_get_document_font (ComponentsWebView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), NULL);
	_tmp0_ = self->priv->_document_font;
	result = _tmp0_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

void
components_web_view_set_document_font (ComponentsWebView* self,
                                       const gchar* value)
{
	gchar* _tmp0_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp1_;
	WebKitSettings* settings = NULL;
	WebKitSettings* _tmp2_;
	WebKitSettings* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_document_font);
	self->priv->_document_font = _tmp0_;
	_tmp1_ = pango_font_description_from_string (value);
	font = _tmp1_;
	_tmp2_ = webkit_web_view_get_settings (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	settings = _tmp3_;
	_tmp4_ = pango_font_description_get_family (font);
	webkit_settings_set_default_font_family (settings, _tmp4_);
	webkit_settings_set_default_font_size (settings, components_web_view_to_wk2_font_size (font));
	webkit_web_view_set_settings (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), settings);
	_g_object_unref0 (settings);
	__vala_PangoFontDescription_free0 (font);
	g_object_notify_by_pspec ((GObject *) self, components_web_view_properties[COMPONENTS_WEB_VIEW_DOCUMENT_FONT_PROPERTY]);
}

const gchar*
components_web_view_get_monospace_font (ComponentsWebView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), NULL);
	_tmp0_ = self->priv->_monospace_font;
	result = _tmp0_;
	return result;
}

void
components_web_view_set_monospace_font (ComponentsWebView* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp1_;
	WebKitSettings* settings = NULL;
	WebKitSettings* _tmp2_;
	WebKitSettings* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_monospace_font);
	self->priv->_monospace_font = _tmp0_;
	_tmp1_ = pango_font_description_from_string (value);
	font = _tmp1_;
	_tmp2_ = webkit_web_view_get_settings (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	settings = _tmp3_;
	_tmp4_ = pango_font_description_get_family (font);
	webkit_settings_set_monospace_font_family (settings, _tmp4_);
	webkit_settings_set_default_monospace_font_size (settings, components_web_view_to_wk2_font_size (font));
	webkit_web_view_set_settings (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), settings);
	_g_object_unref0 (settings);
	__vala_PangoFontDescription_free0 (font);
	g_object_notify_by_pspec ((GObject *) self, components_web_view_properties[COMPONENTS_WEB_VIEW_MONOSPACE_FONT_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

ComponentsWebView*
components_web_view_construct (GType object_type,
                               ApplicationConfiguration* config,
                               WebKitUserContentManager* custom_manager,
                               ComponentsWebView* related)
{
	ComponentsWebView * self = NULL;
	WebKitSettings* setts = NULL;
	WebKitSettings* _tmp0_;
	WebKitSettings* _tmp1_;
	WebKitSettings* _tmp2_;
	WebKitSettings* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	WebKitSettings* _tmp6_;
	WebKitSettings* _tmp7_;
	WebKitSettings* _tmp8_;
	WebKitSettings* _tmp9_;
	WebKitSettings* _tmp10_;
	WebKitSettings* _tmp11_;
	WebKitSettings* _tmp12_;
	WebKitSettings* _tmp13_;
	WebKitSettings* _tmp14_;
	WebKitSettings* _tmp15_;
	WebKitUserContentManager* _tmp16_ = NULL;
	WebKitUserContentManager* _tmp17_;
	WebKitUserContentManager* content_manager = NULL;
	WebKitUserContentManager* _tmp19_;
	WebKitUserContentManager* _tmp20_;
	WebKitUserScript* _tmp21_;
	WebKitUserStyleSheet* _tmp22_;
	WebKitSettings* _tmp25_;
	WebKitUserContentManager* _tmp26_;
	WebKitWebContext* _tmp27_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	g_return_val_if_fail ((custom_manager == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (custom_manager, webkit_user_content_manager_get_type ()), NULL);
	g_return_val_if_fail ((related == NULL) || COMPONENTS_IS_WEB_VIEW (related), NULL);
	_tmp0_ = webkit_settings_new ();
	setts = _tmp0_;
	_tmp1_ = setts;
	webkit_settings_set_allow_modal_dialogs (_tmp1_, FALSE);
	_tmp2_ = setts;
	webkit_settings_set_default_charset (_tmp2_, "UTF-8");
	_tmp3_ = setts;
	_tmp4_ = application_configuration_get_enable_inspector (config);
	_tmp5_ = _tmp4_;
	webkit_settings_set_enable_developer_extras (_tmp3_, _tmp5_);
	_tmp6_ = setts;
	webkit_settings_set_enable_fullscreen (_tmp6_, FALSE);
	_tmp7_ = setts;
	webkit_settings_set_enable_html5_database (_tmp7_, FALSE);
	_tmp8_ = setts;
	webkit_settings_set_enable_html5_local_storage (_tmp8_, FALSE);
	_tmp9_ = setts;
	webkit_settings_set_enable_javascript (_tmp9_, TRUE);
	_tmp10_ = setts;
	webkit_settings_set_enable_javascript_markup (_tmp10_, FALSE);
	_tmp11_ = setts;
	webkit_settings_set_enable_media_stream (_tmp11_, FALSE);
	_tmp12_ = setts;
	webkit_settings_set_enable_offline_web_application_cache (_tmp12_, FALSE);
	_tmp13_ = setts;
	webkit_settings_set_enable_page_cache (_tmp13_, FALSE);
	_tmp14_ = setts;
	webkit_settings_set_hardware_acceleration_policy (_tmp14_, WEBKIT_HARDWARE_ACCELERATION_POLICY_NEVER);
	_tmp15_ = setts;
	webkit_settings_set_javascript_can_access_clipboard (_tmp15_, TRUE);
	_tmp17_ = _g_object_ref0 (custom_manager);
	_tmp16_ = _tmp17_;
	if (_tmp16_ == NULL) {
		WebKitUserContentManager* _tmp18_;
		_tmp18_ = webkit_user_content_manager_new ();
		_g_object_unref0 (_tmp16_);
		_tmp16_ = _tmp18_;
	}
	_tmp19_ = _tmp16_;
	_tmp16_ = NULL;
	content_manager = _tmp19_;
	_tmp20_ = content_manager;
	_tmp21_ = components_web_view_script;
	webkit_user_content_manager_add_script (_tmp20_, _tmp21_);
	_tmp22_ = components_web_view_user_stylesheet;
	if (_tmp22_ != NULL) {
		WebKitUserContentManager* _tmp23_;
		WebKitUserStyleSheet* _tmp24_;
		_tmp23_ = content_manager;
		_tmp24_ = components_web_view_user_stylesheet;
		webkit_user_content_manager_add_style_sheet (_tmp23_, _tmp24_);
	}
	_tmp25_ = setts;
	_tmp26_ = content_manager;
	_tmp27_ = components_web_view_default_context;
	self = (ComponentsWebView*) g_object_new (object_type, "settings", _tmp25_, "user-content-manager", _tmp26_, "web-context", _tmp27_, NULL);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	components_web_view_init (self, config);
	_g_object_unref0 (content_manager);
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (setts);
	return self;
}

/**
     * Constructs a new web view with a new shared WebProcess.
     *
     * The new view will use the same WebProcess, settings and content
     * manager as the given related view's.
     *
     * @see WebKit.WebView.WebView.with_related_view
     */
ComponentsWebView*
components_web_view_construct_with_related_view (GType object_type,
                                                 ApplicationConfiguration* config,
                                                 ComponentsWebView* related)
{
	ComponentsWebView * self = NULL;
	WebKitSettings* _tmp0_;
	WebKitUserContentManager* _tmp1_;
	WebKitUserContentManager* _tmp2_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (related), NULL);
	_tmp0_ = webkit_web_view_get_settings (G_TYPE_CHECK_INSTANCE_CAST (related, webkit_web_view_get_type (), WebKitWebView));
	_tmp1_ = webkit_web_view_get_user_content_manager (G_TYPE_CHECK_INSTANCE_CAST (related, webkit_web_view_get_type (), WebKitWebView));
	_tmp2_ = _tmp1_;
	self = (ComponentsWebView*) g_object_new (object_type, "related-view", related, "settings", _tmp0_, "user-content-manager", _tmp2_, NULL);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	components_web_view_init (self, config);
	return self;
}

static void
components_web_view_real_destroy (GtkWidget* base)
{
	ComponentsWebView * self;
	GeeMap* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView);
	_tmp0_ = self->priv->message_handlers;
	gee_map_clear (_tmp0_);
	GTK_WIDGET_CLASS (components_web_view_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), gtk_widget_get_type (), GtkWidget));
}

/**
     * Loads a message HTML body into the view.
     */
static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		ComponentsWebView* self;
		self = _data63_->self;
		_g_free0 (_data63_->body);
		_g_free0 (_data63_->base_uri);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		ComponentsWebView* self;
		self = _data64_->_data63_->self;
		block63_data_unref (_data64_->_data63_);
		_data64_->_data63_ = NULL;
		g_slice_free (Block64Data, _data64_);
	}
}

static void
___lambda63_ (Block64Data* _data64_)
{
	Block63Data* _data63_;
	ComponentsWebView* self;
	const gchar* _tmp0_ = NULL;
	_data63_ = _data64_->_data63_;
	self = _data63_->self;
	_tmp0_ = _data63_->base_uri;
	if (_tmp0_ == NULL) {
		_tmp0_ = COMPONENTS_WEB_VIEW_INTERNAL_URL_BODY;
	}
	webkit_web_view_load_html (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), _data63_->body, _tmp0_);
	if (_data64_->handler_id > ((gulong) 0)) {
		g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _data64_->handler_id);
	}
}

static void
____lambda63__gtk_widget_map (GtkWidget* _sender,
                              gpointer self)
{
	___lambda63_ (self);
}

void
components_web_view_load_html (ComponentsWebView* self,
                               const gchar* body,
                               const gchar* base_uri)
{
	Block63Data* _data63_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_tmp0_ = g_strdup (body);
	_g_free0 (_data63_->body);
	_data63_->body = _tmp0_;
	_tmp1_ = g_strdup (base_uri);
	_g_free0 (_data63_->base_uri);
	_data63_->base_uri = _tmp1_;
	self->priv->body = _data63_->body;
	if (gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget))) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _data63_->base_uri;
		if (_tmp2_ == NULL) {
			_tmp2_ = COMPONENTS_WEB_VIEW_INTERNAL_URL_BODY;
		}
		webkit_web_view_load_html (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), _data63_->body, _tmp2_);
	} else {
		Block64Data* _data64_;
		gulong _tmp3_;
		_data64_ = g_slice_new0 (Block64Data);
		_data64_->_ref_count_ = 1;
		_data64_->_data63_ = block63_data_ref (_data63_);
		_data64_->handler_id = (gulong) 0;
		_tmp3_ = g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "map", (GCallback) ____lambda63__gtk_widget_map, block64_data_ref (_data64_), (GClosureNotify) block64_data_unref, 0);
		_data64_->handler_id = _tmp3_;
		block64_data_unref (_data64_);
		_data64_ = NULL;
	}
	block63_data_unref (_data63_);
	_data63_ = NULL;
}

/**
     * Loads a message HTML body into the view.
     */
void
components_web_view_load_html_headless (ComponentsWebView* self,
                                        const gchar* body,
                                        const gchar* base_uri)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	self->priv->body = body;
	_tmp0_ = base_uri;
	if (_tmp0_ == NULL) {
		_tmp0_ = COMPONENTS_WEB_VIEW_INTERNAL_URL_BODY;
	}
	webkit_web_view_load_html (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), body, _tmp0_);
}

static void
components_web_view_get_html_data_free (gpointer _data)
{
	ComponentsWebViewGetHtmlData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsWebViewGetHtmlData, _data_);
}

void
components_web_view_get_html (ComponentsWebView* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ComponentsWebViewGetHtmlData* _data_;
	ComponentsWebView* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	_data_ = g_slice_new0 (ComponentsWebViewGetHtmlData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_web_view_get_html_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	components_web_view_get_html_co (_data_);
}

gchar*
components_web_view_get_html_finish (ComponentsWebView* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gchar* result;
	ComponentsWebViewGetHtmlData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the view's content as an HTML string.
     */
static void
components_web_view_get_html_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	ComponentsWebViewGetHtmlData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_web_view_get_html_co (_data_);
}

static gboolean
components_web_view_get_html_co (ComponentsWebViewGetHtmlData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = util_js_callable ("getHtml");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	components_web_view_call_returning (_data_->self, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _data_->_tmp2_, NULL, components_web_view_get_html_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = components_web_view_call_returning_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp4_ = (gchar*) _data_->_tmp3_;
	_util_js_callable_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_free0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Adds an resource that may be accessed from the view via a URL.
     *
     * Internal resources may be access via both the internal `geary`
     * scheme (for resources such as an image inserted via the
     * composer) or via the `cid` scheme (for standard HTML email IMG
     * elements).
     */
void
components_web_view_add_internal_resource (ComponentsWebView* self,
                                           const gchar* id,
                                           GearyMemoryBuffer* buf)
{
	GeeMap* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (buf, GEARY_MEMORY_TYPE_BUFFER));
	_tmp0_ = self->priv->internal_resources;
	gee_map_set (_tmp0_, id, buf);
}

/**
     * Adds a set of internal resources to the view.
     *
     * @see add_internal_resource
     */
void
components_web_view_add_internal_resources (ComponentsWebView* self,
                                            GeeMap* res)
{
	GeeMap* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, GEE_TYPE_MAP));
	_tmp0_ = self->priv->internal_resources;
	gee_map_set_all (_tmp0_, res);
}

static void
components_web_view_load_remote_resources_data_free (gpointer _data)
{
	ComponentsWebViewLoadRemoteResourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsWebViewLoadRemoteResourcesData, _data_);
}

void
components_web_view_load_remote_resources (ComponentsWebView* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	ComponentsWebViewLoadRemoteResourcesData* _data_;
	ComponentsWebView* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ComponentsWebViewLoadRemoteResourcesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_web_view_load_remote_resources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	components_web_view_load_remote_resources_co (_data_);
}

void
components_web_view_load_remote_resources_finish (ComponentsWebView* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	ComponentsWebViewLoadRemoteResourcesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Load any remote resources that were previously blocked.
     *
     * Calling this before calling {@link load_html} will enable any
     * remote resources to be loaded as the HTML is loaded. Calling it
     * afterwards wil ensure any remote resources that were blocked
     * during initial HTML page load are now loaded.
     *
     * @see is_load_remote_resources_enabled
     */
static void
components_web_view_load_remote_resources_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	ComponentsWebViewLoadRemoteResourcesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_web_view_load_remote_resources_co (_data_);
}

static gboolean
components_web_view_load_remote_resources_co (ComponentsWebViewLoadRemoteResourcesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	components_web_view_set_is_load_remote_resources_enabled (_data_->self, TRUE);
	_data_->_tmp0_ = util_js_callable (COMPONENTS_WEB_VIEW_MESSAGE_ENABLE_REMOTE_LOAD);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	components_web_view_call_void (_data_->self, _data_->_tmp1_, NULL, components_web_view_load_remote_resources_ready, _data_);
	return FALSE;
	_state_1:
	components_web_view_call_void_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_util_js_callable_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Selects all content in the web view.
     */
void
components_web_view_select_all (ComponentsWebView* self)
{
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), WEBKIT_EDITING_COMMAND_SELECT_ALL);
}

/**
     * Copies selected content and sends it to the clipboard.
     */
void
components_web_view_copy_clipboard (ComponentsWebView* self)
{
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), WEBKIT_EDITING_COMMAND_COPY);
}

void
components_web_view_zoom_reset (ComponentsWebView* self)
{
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	webkit_web_view_set_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), COMPONENTS_WEB_VIEW_ZOOM_DEFAULT);
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "preferred-height");
}

void
components_web_view_zoom_in (ComponentsWebView* self)
{
	gdouble new_zoom = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	_tmp0_ = webkit_web_view_get_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp1_ = _tmp0_;
	_tmp2_ = webkit_web_view_get_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp3_ = _tmp2_;
	webkit_web_view_set_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), _tmp1_ + (_tmp3_ * COMPONENTS_WEB_VIEW_ZOOM_FACTOR));
	new_zoom = _tmp1_ + (_tmp3_ * COMPONENTS_WEB_VIEW_ZOOM_FACTOR);
	if (new_zoom > COMPONENTS_WEB_VIEW_ZOOM_MAX) {
		new_zoom = COMPONENTS_WEB_VIEW_ZOOM_MAX;
	}
	webkit_web_view_set_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), new_zoom);
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "preferred-height");
}

void
components_web_view_zoom_out (ComponentsWebView* self)
{
	gdouble new_zoom = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	_tmp0_ = webkit_web_view_get_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp1_ = _tmp0_;
	_tmp2_ = webkit_web_view_get_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp3_ = _tmp2_;
	webkit_web_view_set_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), _tmp1_ - (_tmp3_ * COMPONENTS_WEB_VIEW_ZOOM_FACTOR));
	new_zoom = _tmp1_ - (_tmp3_ * COMPONENTS_WEB_VIEW_ZOOM_FACTOR);
	if (new_zoom < COMPONENTS_WEB_VIEW_ZOOM_MIN) {
		new_zoom = COMPONENTS_WEB_VIEW_ZOOM_MIN;
	}
	webkit_web_view_set_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), new_zoom);
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "preferred-height");
}

static void
components_web_view_set_editable_data_free (gpointer _data)
{
	ComponentsWebViewSetEditableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsWebViewSetEditableData, _data_);
}

void
components_web_view_set_editable (ComponentsWebView* self,
                                  gboolean enabled,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ComponentsWebViewSetEditableData* _data_;
	ComponentsWebView* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ComponentsWebViewSetEditableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_web_view_set_editable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->enabled = enabled;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	components_web_view_set_editable_co (_data_);
}

void
components_web_view_set_editable_finish (ComponentsWebView* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	ComponentsWebViewSetEditableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
components_web_view_set_editable_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	ComponentsWebViewSetEditableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_web_view_set_editable_co (_data_);
}

static gboolean
components_web_view_set_editable_co (ComponentsWebViewSetEditableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = util_js_callable ("setEditable");
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = util_js_callable_bool (_data_->_tmp1_, _data_->enabled);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	components_web_view_call_void (_data_->self, _data_->_tmp3_, _data_->cancellable, components_web_view_set_editable_ready, _data_);
	return FALSE;
	_state_1:
	components_web_view_call_void_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_util_js_callable_unref0 (_data_->_tmp3_);
	_util_js_callable_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
components_web_view_call_void_data_free (gpointer _data)
{
	ComponentsWebViewCallVoidData* _data_;
	_data_ = _data;
	_util_js_callable_unref0 (_data_->target);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsWebViewCallVoidData, _data_);
}

static gpointer
_util_js_callable_ref0 (gpointer self)
{
	return self ? util_js_callable_ref (self) : NULL;
}

void
components_web_view_call_void (ComponentsWebView* self,
                               UtilJSCallable* target,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ComponentsWebViewCallVoidData* _data_;
	ComponentsWebView* _tmp0_;
	UtilJSCallable* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (UTIL_JS_IS_CALLABLE (target));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ComponentsWebViewCallVoidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_web_view_call_void_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _util_js_callable_ref0 (target);
	_util_js_callable_unref0 (_data_->target);
	_data_->target = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	components_web_view_call_void_co (_data_);
}

void
components_web_view_call_void_finish (ComponentsWebView* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	ComponentsWebViewCallVoidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Invokes a {@link Util.JS.Callable} on this web view.
     *
     * This calls the given callable on the `geary` object for the
     * current view, any returned value are ignored.
     */
static void
components_web_view_call_void_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	ComponentsWebViewCallVoidData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_web_view_call_void_co (_data_);
}

static gboolean
components_web_view_call_void_co (ComponentsWebViewCallVoidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	components_web_view_call_impl (_data_->self, _data_->target, _data_->cancellable, components_web_view_call_void_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = components_web_view_call_impl_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
components_web_view_call_returning_data_free (gpointer _data)
{
	ComponentsWebViewCallReturningData* _data_;
	_data_ = _data;
	_util_js_callable_unref0 (_data_->target);
	_g_object_unref0 (_data_->cancellable);
	((_data_->result == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->result = (_data_->t_destroy_func (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsWebViewCallReturningData, _data_);
}

void
components_web_view_call_returning (ComponentsWebView* self,
                                    GType t_type,
                                    GBoxedCopyFunc t_dup_func,
                                    GDestroyNotify t_destroy_func,
                                    UtilJSCallable* target,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	ComponentsWebViewCallReturningData* _data_;
	ComponentsWebView* _tmp0_;
	UtilJSCallable* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (UTIL_JS_IS_CALLABLE (target));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ComponentsWebViewCallReturningData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_web_view_call_returning_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _util_js_callable_ref0 (target);
	_util_js_callable_unref0 (_data_->target);
	_data_->target = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	_data_->t_type = t_type;
	_data_->t_dup_func = t_dup_func;
	_data_->t_destroy_func = t_destroy_func;
	components_web_view_call_returning_co (_data_);
}

gpointer
components_web_view_call_returning_finish (ComponentsWebView* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	gpointer result;
	ComponentsWebViewCallReturningData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Invokes a {@link Util.JS.Callable} on this web view.
     *
     * This calls the given callable on the `geary` object for the
     * current view. The value returned by the call is returned by
     * this method.
     *
     * The type parameter `T` must match the type returned by the
     * call, else an error is thrown. Only simple nullable value types
     * are supported for T, for more complex return types (arrays,
     * dictionaries, etc) specify {@link GLib.Variant} for `T` and
     * manually parse that.
     */
static void
components_web_view_call_returning_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	ComponentsWebViewCallReturningData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_web_view_call_returning_co (_data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gshort*
_short_dup (gshort* self)
{
	gshort* dup;
	dup = g_new0 (gshort, 1);
	memcpy (dup, self, sizeof (gshort));
	return dup;
}

static gpointer
__short_dup0 (gpointer self)
{
	return self ? _short_dup (self) : NULL;
}

static gchar*
_g_ascii_dup (gchar* self)
{
	gchar* dup;
	dup = g_new0 (gchar, 1);
	memcpy (dup, self, sizeof (gchar));
	return dup;
}

static gpointer
__g_ascii_dup0 (gpointer self)
{
	return self ? _g_ascii_dup (self) : NULL;
}

static glong*
_long_dup (glong* self)
{
	glong* dup;
	dup = g_new0 (glong, 1);
	memcpy (dup, self, sizeof (glong));
	return dup;
}

static gpointer
__long_dup0 (gpointer self)
{
	return self ? _long_dup (self) : NULL;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static guchar*
_uchar_dup (guchar* self)
{
	guchar* dup;
	dup = g_new0 (guchar, 1);
	memcpy (dup, self, sizeof (guchar));
	return dup;
}

static gpointer
__uchar_dup0 (gpointer self)
{
	return self ? _uchar_dup (self) : NULL;
}

static gushort*
_ushort_dup (gushort* self)
{
	gushort* dup;
	dup = g_new0 (gushort, 1);
	memcpy (dup, self, sizeof (gushort));
	return dup;
}

static gpointer
__ushort_dup0 (gpointer self)
{
	return self ? _ushort_dup (self) : NULL;
}

static gulong*
_ulong_dup (gulong* self)
{
	gulong* dup;
	dup = g_new0 (gulong, 1);
	memcpy (dup, self, sizeof (gulong));
	return dup;
}

static gpointer
__ulong_dup0 (gpointer self)
{
	return self ? _ulong_dup (self) : NULL;
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

static gfloat*
_float_dup (gfloat* self)
{
	gfloat* dup;
	dup = g_new0 (gfloat, 1);
	memcpy (dup, self, sizeof (gfloat));
	return dup;
}

static gpointer
__float_dup0 (gpointer self)
{
	return self ? _float_dup (self) : NULL;
}

static const char*
_g_variant_class_to_string (GVariantClass value)
{
	switch (value) {
		case G_VARIANT_CLASS_BOOLEAN:
		return "G_VARIANT_CLASS_BOOLEAN";
		case G_VARIANT_CLASS_BYTE:
		return "G_VARIANT_CLASS_BYTE";
		case G_VARIANT_CLASS_INT16:
		return "G_VARIANT_CLASS_INT16";
		case G_VARIANT_CLASS_UINT16:
		return "G_VARIANT_CLASS_UINT16";
		case G_VARIANT_CLASS_INT32:
		return "G_VARIANT_CLASS_INT32";
		case G_VARIANT_CLASS_UINT32:
		return "G_VARIANT_CLASS_UINT32";
		case G_VARIANT_CLASS_INT64:
		return "G_VARIANT_CLASS_INT64";
		case G_VARIANT_CLASS_UINT64:
		return "G_VARIANT_CLASS_UINT64";
		case G_VARIANT_CLASS_HANDLE:
		return "G_VARIANT_CLASS_HANDLE";
		case G_VARIANT_CLASS_DOUBLE:
		return "G_VARIANT_CLASS_DOUBLE";
		case G_VARIANT_CLASS_STRING:
		return "G_VARIANT_CLASS_STRING";
		case G_VARIANT_CLASS_OBJECT_PATH:
		return "G_VARIANT_CLASS_OBJECT_PATH";
		case G_VARIANT_CLASS_SIGNATURE:
		return "G_VARIANT_CLASS_SIGNATURE";
		case G_VARIANT_CLASS_VARIANT:
		return "G_VARIANT_CLASS_VARIANT";
		case G_VARIANT_CLASS_MAYBE:
		return "G_VARIANT_CLASS_MAYBE";
		case G_VARIANT_CLASS_ARRAY:
		return "G_VARIANT_CLASS_ARRAY";
		case G_VARIANT_CLASS_TUPLE:
		return "G_VARIANT_CLASS_TUPLE";
		case G_VARIANT_CLASS_DICT_ENTRY:
		return "G_VARIANT_CLASS_DICT_ENTRY";
	}
	return NULL;
}

static gboolean
components_web_view_call_returning_co (ComponentsWebViewCallReturningData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	components_web_view_call_impl (_data_->self, _data_->target, _data_->cancellable, components_web_view_call_returning_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = components_web_view_call_impl_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->response = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->response;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = util_js_callable_to_string (_data_->target);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Method call %s did not return a value", _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_free0 (_data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp5_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->response);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->response;
	_data_->_tmp7_ = webkit_user_message_get_parameters (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _g_variant_ref0 (_data_->_tmp8_);
	_data_->param = _data_->_tmp9_;
	_data_->ret_value = NULL;
	_data_->ret_type = _data_->t_type;
	if (_data_->ret_type == G_TYPE_VARIANT) {
		_data_->_tmp10_ = _data_->param;
		_data_->_tmp11_ = ((_data_->_tmp10_ != NULL) && (_data_->t_dup_func != NULL)) ? _data_->t_dup_func ((gpointer) _data_->_tmp10_) : ((gpointer) _data_->_tmp10_);
		((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
		_data_->ret_value = _data_->_tmp11_;
	} else {
		_data_->_tmp13_ = _data_->param;
		if (_data_->_tmp13_ != NULL) {
			_data_->_tmp14_ = _data_->param;
			_data_->_tmp15_ = g_variant_get_type (_data_->_tmp14_);
			_data_->_tmp12_ = g_variant_type_is_maybe (_data_->_tmp15_);
		} else {
			_data_->_tmp12_ = FALSE;
		}
		if (_data_->_tmp12_) {
			_data_->_tmp16_ = _data_->param;
			_data_->_tmp17_ = g_variant_get_maybe (_data_->_tmp16_);
			_g_variant_unref0 (_data_->param);
			_data_->param = _data_->_tmp17_;
		}
		_data_->_tmp18_ = _data_->param;
		if (_data_->_tmp18_ != NULL) {
			_data_->_tmp19_ = _data_->param;
			_data_->param_type = g_variant_classify (_data_->_tmp19_);
			if (_data_->ret_type == G_TYPE_STRING) {
				_data_->_tmp20_ = _data_->param_type == G_VARIANT_CLASS_STRING;
			} else {
				_data_->_tmp20_ = FALSE;
			}
			if (_data_->_tmp20_) {
				_data_->_tmp21_ = _data_->param;
				_data_->_tmp22_ = g_variant_get_string (_data_->_tmp21_, NULL);
				_data_->_tmp23_ = ((_data_->_tmp22_ != NULL) && (_data_->t_dup_func != NULL)) ? _data_->t_dup_func ((gpointer) _data_->_tmp22_) : ((gpointer) _data_->_tmp22_);
				((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
				_data_->ret_value = _data_->_tmp23_;
			} else {
				if (_data_->ret_type == G_TYPE_BOOLEAN) {
					_data_->_tmp24_ = _data_->param_type == G_VARIANT_CLASS_BOOLEAN;
				} else {
					_data_->_tmp24_ = FALSE;
				}
				if (_data_->_tmp24_) {
					_data_->_tmp26_ = _data_->param;
					_data_->_tmp27_ = g_variant_get_boolean (_data_->_tmp26_);
					_data_->_tmp28_ = __bool_dup0 (&_data_->_tmp27_);
					_data_->_tmp25_ = _data_->_tmp28_;
					_data_->_tmp29_ = _data_->_tmp25_;
					_data_->_tmp25_ = NULL;
					((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
					_data_->ret_value = _data_->_tmp29_;
					_g_free0 (_data_->_tmp25_);
				} else {
					if (_data_->ret_type == G_TYPE_INT) {
						_data_->_tmp30_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
					} else {
						_data_->_tmp30_ = FALSE;
					}
					if (_data_->_tmp30_) {
						_data_->_tmp32_ = _data_->param;
						_data_->_tmp33_ = (gint) g_variant_get_double (_data_->_tmp32_);
						_data_->_tmp34_ = __int_dup0 (&_data_->_tmp33_);
						_data_->_tmp31_ = _data_->_tmp34_;
						_data_->_tmp35_ = _data_->_tmp31_;
						_data_->_tmp31_ = NULL;
						((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
						_data_->ret_value = _data_->_tmp35_;
						_g_free0 (_data_->_tmp31_);
					} else {
						if (_data_->ret_type == G_TYPE_INT) {
							_data_->_tmp36_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
						} else {
							_data_->_tmp36_ = FALSE;
						}
						if (_data_->_tmp36_) {
							_data_->_tmp38_ = _data_->param;
							_data_->_tmp39_ = (gshort) g_variant_get_double (_data_->_tmp38_);
							_data_->_tmp40_ = __short_dup0 (&_data_->_tmp39_);
							_data_->_tmp37_ = _data_->_tmp40_;
							_data_->_tmp41_ = _data_->_tmp37_;
							_data_->_tmp37_ = NULL;
							((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
							_data_->ret_value = _data_->_tmp41_;
							_g_free0 (_data_->_tmp37_);
						} else {
							if (_data_->ret_type == G_TYPE_CHAR) {
								_data_->_tmp42_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
							} else {
								_data_->_tmp42_ = FALSE;
							}
							if (_data_->_tmp42_) {
								_data_->_tmp44_ = _data_->param;
								_data_->_tmp45_ = (gchar) g_variant_get_double (_data_->_tmp44_);
								_data_->_tmp46_ = __g_ascii_dup0 (&_data_->_tmp45_);
								_data_->_tmp43_ = _data_->_tmp46_;
								_data_->_tmp47_ = _data_->_tmp43_;
								_data_->_tmp43_ = NULL;
								((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
								_data_->ret_value = _data_->_tmp47_;
								_g_free0 (_data_->_tmp43_);
							} else {
								if (_data_->ret_type == G_TYPE_LONG) {
									_data_->_tmp48_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
								} else {
									_data_->_tmp48_ = FALSE;
								}
								if (_data_->_tmp48_) {
									_data_->_tmp50_ = _data_->param;
									_data_->_tmp51_ = (glong) g_variant_get_double (_data_->_tmp50_);
									_data_->_tmp52_ = __long_dup0 (&_data_->_tmp51_);
									_data_->_tmp49_ = _data_->_tmp52_;
									_data_->_tmp53_ = _data_->_tmp49_;
									_data_->_tmp49_ = NULL;
									((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
									_data_->ret_value = _data_->_tmp53_;
									_g_free0 (_data_->_tmp49_);
								} else {
									if (_data_->ret_type == G_TYPE_INT64) {
										_data_->_tmp54_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
									} else {
										_data_->_tmp54_ = FALSE;
									}
									if (_data_->_tmp54_) {
										_data_->_tmp56_ = _data_->param;
										_data_->_tmp57_ = (gint64) g_variant_get_double (_data_->_tmp56_);
										_data_->_tmp58_ = __int64_dup0 (&_data_->_tmp57_);
										_data_->_tmp55_ = _data_->_tmp58_;
										_data_->_tmp59_ = _data_->_tmp55_;
										_data_->_tmp55_ = NULL;
										((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
										_data_->ret_value = _data_->_tmp59_;
										_g_free0 (_data_->_tmp55_);
									} else {
										if (_data_->ret_type == G_TYPE_UINT) {
											_data_->_tmp60_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
										} else {
											_data_->_tmp60_ = FALSE;
										}
										if (_data_->_tmp60_) {
											_data_->_tmp62_ = _data_->param;
											_data_->_tmp63_ = (guint) g_variant_get_double (_data_->_tmp62_);
											_data_->_tmp64_ = __uint_dup0 (&_data_->_tmp63_);
											_data_->_tmp61_ = _data_->_tmp64_;
											_data_->_tmp65_ = _data_->_tmp61_;
											_data_->_tmp61_ = NULL;
											((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
											_data_->ret_value = _data_->_tmp65_;
											_g_free0 (_data_->_tmp61_);
										} else {
											if (_data_->ret_type == G_TYPE_UCHAR) {
												_data_->_tmp66_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
											} else {
												_data_->_tmp66_ = FALSE;
											}
											if (_data_->_tmp66_) {
												_data_->_tmp68_ = _data_->param;
												_data_->_tmp69_ = (guchar) g_variant_get_double (_data_->_tmp68_);
												_data_->_tmp70_ = __uchar_dup0 (&_data_->_tmp69_);
												_data_->_tmp67_ = _data_->_tmp70_;
												_data_->_tmp71_ = _data_->_tmp67_;
												_data_->_tmp67_ = NULL;
												((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
												_data_->ret_value = _data_->_tmp71_;
												_g_free0 (_data_->_tmp67_);
											} else {
												if (_data_->ret_type == G_TYPE_UINT) {
													_data_->_tmp72_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
												} else {
													_data_->_tmp72_ = FALSE;
												}
												if (_data_->_tmp72_) {
													_data_->_tmp74_ = _data_->param;
													_data_->_tmp75_ = (gushort) g_variant_get_double (_data_->_tmp74_);
													_data_->_tmp76_ = __ushort_dup0 (&_data_->_tmp75_);
													_data_->_tmp73_ = _data_->_tmp76_;
													_data_->_tmp77_ = _data_->_tmp73_;
													_data_->_tmp73_ = NULL;
													((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
													_data_->ret_value = _data_->_tmp77_;
													_g_free0 (_data_->_tmp73_);
												} else {
													if (_data_->ret_type == G_TYPE_ULONG) {
														_data_->_tmp78_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
													} else {
														_data_->_tmp78_ = FALSE;
													}
													if (_data_->_tmp78_) {
														_data_->_tmp80_ = _data_->param;
														_data_->_tmp81_ = (gulong) g_variant_get_double (_data_->_tmp80_);
														_data_->_tmp82_ = __ulong_dup0 (&_data_->_tmp81_);
														_data_->_tmp79_ = _data_->_tmp82_;
														_data_->_tmp83_ = _data_->_tmp79_;
														_data_->_tmp79_ = NULL;
														((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
														_data_->ret_value = _data_->_tmp83_;
														_g_free0 (_data_->_tmp79_);
													} else {
														if (_data_->ret_type == G_TYPE_UINT64) {
															_data_->_tmp84_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
														} else {
															_data_->_tmp84_ = FALSE;
														}
														if (_data_->_tmp84_) {
															_data_->_tmp86_ = _data_->param;
															_data_->_tmp87_ = (guint64) g_variant_get_double (_data_->_tmp86_);
															_data_->_tmp88_ = __uint64_dup0 (&_data_->_tmp87_);
															_data_->_tmp85_ = _data_->_tmp88_;
															_data_->_tmp89_ = _data_->_tmp85_;
															_data_->_tmp85_ = NULL;
															((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
															_data_->ret_value = _data_->_tmp89_;
															_g_free0 (_data_->_tmp85_);
														} else {
															if (_data_->ret_type == G_TYPE_DOUBLE) {
																_data_->_tmp90_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
															} else {
																_data_->_tmp90_ = FALSE;
															}
															if (_data_->_tmp90_) {
																_data_->_tmp92_ = _data_->param;
																_data_->_tmp93_ = g_variant_get_double (_data_->_tmp92_);
																_data_->_tmp94_ = __double_dup0 (&_data_->_tmp93_);
																_data_->_tmp91_ = _data_->_tmp94_;
																_data_->_tmp95_ = _data_->_tmp91_;
																_data_->_tmp91_ = NULL;
																((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
																_data_->ret_value = _data_->_tmp95_;
																_g_free0 (_data_->_tmp91_);
															} else {
																if (_data_->ret_type == G_TYPE_FLOAT) {
																	_data_->_tmp96_ = _data_->param_type == G_VARIANT_CLASS_DOUBLE;
																} else {
																	_data_->_tmp96_ = FALSE;
																}
																if (_data_->_tmp96_) {
																	_data_->_tmp98_ = _data_->param;
																	_data_->_tmp99_ = (gfloat) g_variant_get_double (_data_->_tmp98_);
																	_data_->_tmp100_ = __float_dup0 (&_data_->_tmp99_);
																	_data_->_tmp97_ = _data_->_tmp100_;
																	_data_->_tmp101_ = _data_->_tmp97_;
																	_data_->_tmp97_ = NULL;
																	((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
																	_data_->ret_value = _data_->_tmp101_;
																	_g_free0 (_data_->_tmp97_);
																} else {
																	_data_->_tmp102_ = g_type_name (_data_->ret_type);
																	_data_->_tmp103_ = _g_variant_class_to_string (_data_->param_type);
																	_data_->_tmp104_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "%s is not a supported type for %s", _data_->_tmp102_, _data_->_tmp103_);
																	_data_->_inner_error0_ = _data_->_tmp104_;
																	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
																	((_data_->ret_value == NULL) || (_data_->t_destroy_func == NULL)) ? NULL : (_data_->ret_value = (_data_->t_destroy_func (_data_->ret_value), NULL));
																	_g_variant_unref0 (_data_->param);
																	_g_object_unref0 (_data_->response);
																	g_object_unref (_data_->_async_result);
																	return FALSE;
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_data_->result = _data_->ret_value;
	_g_variant_unref0 (_data_->param);
	_g_object_unref0 (_data_->response);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Registers a callback for a specific WebKit user message.
     */
void
components_web_view_register_message_callback (ComponentsWebView* self,
                                               const gchar* name,
                                               ComponentsWebViewMessageCallback handler,
                                               gpointer handler_target)
{
	GeeMap* _tmp0_;
	ComponentsWebViewMessageCallable* _tmp1_;
	ComponentsWebViewMessageCallable* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->message_handlers;
	_tmp1_ = components_web_view_message_callable_new (handler, handler_target);
	_tmp2_ = _tmp1_;
	gee_map_set (_tmp0_, name, _tmp2_);
	_components_web_view_message_callable_unref0 (_tmp2_);
}

static gboolean
_components_web_view_on_decide_policy_webkit_web_view_decide_policy (WebKitWebView* _sender,
                                                                     WebKitPolicyDecision* decision,
                                                                     WebKitPolicyDecisionType type,
                                                                     gpointer self)
{
	gboolean result;
	result = components_web_view_on_decide_policy ((ComponentsWebView*) self, _sender, decision, type);
	return result;
}

static void
__lambda42_ (ComponentsWebView* self,
             WebKitWebProcessTerminationReason reason)
{
	GEnumValue* _tmp0_;
	_tmp0_ = g_enum_get_value (g_type_class_ref (webkit_web_process_termination_reason_get_type ()), reason);
	g_warning ("components-web-view.vala:618: Web process crashed: %s", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
}

static void
___lambda42__webkit_web_view_web_process_terminated (WebKitWebView* _sender,
                                                     WebKitWebProcessTerminationReason reason,
                                                     gpointer self)
{
	__lambda42_ ((ComponentsWebView*) self, reason);
}

static void
_components_web_view_on_command_stack_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                    gpointer self)
{
	components_web_view_on_command_stack_changed ((ComponentsWebView*) self, parameters);
}

static void
_components_web_view_on_content_loaded_components_web_view_message_callback (GVariant* parameters,
                                                                             gpointer self)
{
	components_web_view_on_content_loaded ((ComponentsWebView*) self, parameters);
}

static void
_components_web_view_on_document_modified_components_web_view_message_callback (GVariant* parameters,
                                                                                gpointer self)
{
	components_web_view_on_document_modified ((ComponentsWebView*) self, parameters);
}

static void
_components_web_view_on_preferred_height_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                       gpointer self)
{
	components_web_view_on_preferred_height_changed ((ComponentsWebView*) self, parameters);
}

static void
_components_web_view_on_remote_resource_load_blocked_components_web_view_message_callback (GVariant* parameters,
                                                                                           gpointer self)
{
	components_web_view_on_remote_resource_load_blocked ((ComponentsWebView*) self, parameters);
}

static void
_components_web_view_on_selection_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                gpointer self)
{
	components_web_view_on_selection_changed ((ComponentsWebView*) self, parameters);
}

static gboolean
_components_web_view_on_message_received_webkit_web_view_user_message_received (WebKitWebView* _sender,
                                                                                WebKitUserMessage* message,
                                                                                gpointer self)
{
	gboolean result;
	result = components_web_view_on_message_received ((ComponentsWebView*) self, message);
	return result;
}

static gboolean
_components_web_view_on_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                              GdkEventScroll* event,
                                                              gpointer self)
{
	gboolean result;
	result = components_web_view_on_scroll_event ((ComponentsWebView*) self, event);
	return result;
}

static void
components_web_view_init (ComponentsWebView* self,
                          ApplicationConfiguration* config)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	GSettings* system_settings = NULL;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (config));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), "decide-policy", (GCallback) _components_web_view_on_decide_policy_webkit_web_view_decide_policy, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), "web-process-terminated", (GCallback) ___lambda42__webkit_web_view_web_process_terminated, self, 0);
	components_web_view_register_message_callback (self, COMPONENTS_WEB_VIEW_COMMAND_STACK_CHANGED, _components_web_view_on_command_stack_changed_components_web_view_message_callback, self);
	components_web_view_register_message_callback (self, COMPONENTS_WEB_VIEW_CONTENT_LOADED, _components_web_view_on_content_loaded_components_web_view_message_callback, self);
	components_web_view_register_message_callback (self, COMPONENTS_WEB_VIEW_DOCUMENT_MODIFIED, _components_web_view_on_document_modified_components_web_view_message_callback, self);
	components_web_view_register_message_callback (self, COMPONENTS_WEB_VIEW_PREFERRED_HEIGHT_CHANGED, _components_web_view_on_preferred_height_changed_components_web_view_message_callback, self);
	components_web_view_register_message_callback (self, COMPONENTS_WEB_VIEW_REMOTE_RESOURCE_LOAD_BLOCKED, _components_web_view_on_remote_resource_load_blocked_components_web_view_message_callback, self);
	components_web_view_register_message_callback (self, COMPONENTS_WEB_VIEW_SELECTION_CHANGED, _components_web_view_on_selection_changed_components_web_view_message_callback, self);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), "user-message-received", (GCallback) _components_web_view_on_message_received_webkit_web_view_user_message_received, self, 0);
	application_configuration_bind (config, APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_KEY, G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "zoom_level", G_SETTINGS_BIND_DEFAULT);
	_tmp0_ = webkit_web_view_get_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp1_ = _tmp0_;
	if (_tmp1_ < COMPONENTS_WEB_VIEW_ZOOM_MIN) {
		webkit_web_view_set_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), COMPONENTS_WEB_VIEW_ZOOM_MIN);
	} else {
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp2_ = webkit_web_view_get_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
		_tmp3_ = _tmp2_;
		if (_tmp3_ > COMPONENTS_WEB_VIEW_ZOOM_MAX) {
			webkit_web_view_set_zoom_level (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), COMPONENTS_WEB_VIEW_ZOOM_MAX);
		}
	}
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) _components_web_view_on_scroll_event_gtk_widget_scroll_event, self, 0);
	_tmp4_ = application_configuration_get_gnome_interface (config);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	system_settings = _tmp6_;
	g_settings_bind (system_settings, "document-font-name", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "document-font", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (system_settings, "monospace-font-name", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "monospace-font", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (system_settings);
}

static void
components_web_view_call_impl_data_free (gpointer _data)
{
	ComponentsWebViewCallImplData* _data_;
	_data_ = _data;
	_util_js_callable_unref0 (_data_->target);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsWebViewCallImplData, _data_);
}

static void
components_web_view_call_impl (ComponentsWebView* self,
                               UtilJSCallable* target,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ComponentsWebViewCallImplData* _data_;
	ComponentsWebView* _tmp0_;
	UtilJSCallable* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (UTIL_JS_IS_CALLABLE (target));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ComponentsWebViewCallImplData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_web_view_call_impl_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _util_js_callable_ref0 (target);
	_util_js_callable_unref0 (_data_->target);
	_data_->target = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	components_web_view_call_impl_co (_data_);
}

static WebKitUserMessage*
components_web_view_call_impl_finish (ComponentsWebView* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	WebKitUserMessage* result;
	ComponentsWebViewCallImplData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
components_web_view_call_impl_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	ComponentsWebViewCallImplData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_web_view_call_impl_co (_data_);
}

static gchar*
_variant_get8 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static gchar*
_variant_get9 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static gchar*
_variant_get10 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static gchar*
_variant_get11 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static gboolean
components_web_view_call_impl_co (ComponentsWebViewCallImplData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = util_js_callable_to_message (_data_->target);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	webkit_web_view_send_message_to_page (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, webkit_web_view_get_type (), WebKitWebView), _data_->_tmp1_, _data_->cancellable, components_web_view_call_impl_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = webkit_web_view_send_message_to_page_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, webkit_web_view_get_type (), WebKitWebView), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->response = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->response;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->response;
		_data_->_tmp6_ = webkit_user_message_get_name (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
		_data_->response_name = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->response_name;
		if (g_strcmp0 (_data_->_tmp9_, COMPONENTS_WEB_VIEW_MESSAGE_EXCEPTION) == 0) {
			_data_->_tmp10_ = _data_->response;
			_data_->_tmp11_ = webkit_user_message_get_parameters (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = g_variant_dict_new (_data_->_tmp12_);
			_data_->exception = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->exception;
			_data_->_tmp15_ = G_VARIANT_TYPE_STRING;
			_data_->_tmp16_ = g_variant_dict_lookup_value (_data_->_tmp14_, "name", _data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_tmp18_ = _variant_get8 (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_g_variant_unref0 (_data_->_tmp17_);
			_data_->name = _data_->_tmp19_;
			_data_->_tmp20_ = _data_->exception;
			_data_->_tmp21_ = G_VARIANT_TYPE_STRING;
			_data_->_tmp22_ = g_variant_dict_lookup_value (_data_->_tmp20_, "message", _data_->_tmp21_);
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp24_ = _variant_get9 (_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_g_variant_unref0 (_data_->_tmp23_);
			_data_->message = _data_->_tmp25_;
			_data_->_tmp26_ = _data_->exception;
			_data_->_tmp27_ = G_VARIANT_TYPE_STRING;
			_data_->_tmp28_ = g_variant_dict_lookup_value (_data_->_tmp26_, "backtrace_string", _data_->_tmp27_);
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = _variant_get10 (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_g_variant_unref0 (_data_->_tmp29_);
			_data_->backtrace = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->exception;
			_data_->_tmp33_ = G_VARIANT_TYPE_STRING;
			_data_->_tmp34_ = g_variant_dict_lookup_value (_data_->_tmp32_, "source_uri", _data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = _variant_get11 (_data_->_tmp35_);
			_data_->_tmp37_ = _data_->_tmp36_;
			_g_variant_unref0 (_data_->_tmp35_);
			_data_->source = _data_->_tmp37_;
			_data_->_tmp38_ = _data_->exception;
			_data_->_tmp39_ = G_VARIANT_TYPE_UINT32;
			_data_->_tmp40_ = g_variant_dict_lookup_value (_data_->_tmp38_, "line_number", _data_->_tmp39_);
			_data_->line = _data_->_tmp40_;
			_data_->_tmp41_ = _data_->exception;
			_data_->_tmp42_ = G_VARIANT_TYPE_UINT32;
			_data_->_tmp43_ = g_variant_dict_lookup_value (_data_->_tmp41_, "column_number", _data_->_tmp42_);
			_data_->column = _data_->_tmp43_;
			_data_->_tmp45_ = _data_->name;
			_data_->_tmp44_ = _data_->_tmp45_;
			if (_data_->_tmp44_ == NULL) {
				_data_->_tmp44_ = "unknown";
			}
			_data_->_tmp47_ = _data_->source;
			_data_->_tmp46_ = _data_->_tmp47_;
			if (_data_->_tmp46_ == NULL) {
				_data_->_tmp46_ = "unknown";
			}
			_data_->_tmp49_ = _data_->line;
			if (_data_->_tmp49_ != NULL) {
				_data_->_tmp50_ = _data_->line;
				_data_->_tmp48_ = (gint) g_variant_get_uint32 (_data_->_tmp50_);
			} else {
				_data_->_tmp48_ = -1;
			}
			_data_->_tmp52_ = _data_->column;
			if (_data_->_tmp52_ != NULL) {
				_data_->_tmp53_ = _data_->column;
				_data_->_tmp51_ = (gint) g_variant_get_uint32 (_data_->_tmp53_);
			} else {
				_data_->_tmp51_ = -1;
			}
			_data_->_tmp55_ = _data_->message;
			_data_->_tmp54_ = _data_->_tmp55_;
			if (_data_->_tmp54_ == NULL) {
				_data_->_tmp54_ = "unknown";
			}
			_data_->_tmp56_ = util_js_callable_to_string (_data_->target);
			_data_->_tmp57_ = _data_->_tmp56_;
			_data_->_tmp58_ = g_strdup_printf ("Method call %s raised %s exception at %s:%d:%d: %s", _data_->_tmp57_, _data_->_tmp44_, _data_->_tmp46_, _data_->_tmp48_, _data_->_tmp51_, _data_->_tmp54_);
			_data_->_tmp59_ = _data_->_tmp58_;
			_g_free0 (_data_->_tmp57_);
			_data_->log_message = _data_->_tmp59_;
			_data_->_tmp60_ = _data_->log_message;
			g_debug ("components-web-view.vala:684: %s", _data_->_tmp60_);
			_data_->_tmp61_ = _data_->backtrace;
			if (_data_->_tmp61_ != NULL) {
				_data_->_tmp62_ = _data_->backtrace;
				g_debug ("components-web-view.vala:686: %s", _data_->_tmp62_);
			}
			_data_->_tmp63_ = _data_->log_message;
			_data_->_tmp64_ = g_error_new_literal (UTIL_JS_ERROR, UTIL_JS_ERROR_EXCEPTION, _data_->_tmp63_);
			_data_->_inner_error0_ = _data_->_tmp64_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->log_message);
			_g_variant_unref0 (_data_->column);
			_g_variant_unref0 (_data_->line);
			_g_free0 (_data_->source);
			_g_free0 (_data_->backtrace);
			_g_free0 (_data_->message);
			_g_free0 (_data_->name);
			_g_variant_dict_unref0 (_data_->exception);
			_g_free0 (_data_->response_name);
			_g_object_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp65_ = _data_->response_name;
			if (g_strcmp0 (_data_->_tmp65_, COMPONENTS_WEB_VIEW_MESSAGE_RETURN_VALUE) != 0) {
				_data_->_tmp66_ = util_js_callable_to_string (_data_->target);
				_data_->_tmp67_ = _data_->_tmp66_;
				_data_->_tmp68_ = _data_->response_name;
				_data_->_tmp69_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Method call %s returned unknown name: %s", _data_->_tmp67_, _data_->_tmp68_);
				_data_->_tmp70_ = _data_->_tmp69_;
				_g_free0 (_data_->_tmp67_);
				_data_->_inner_error0_ = _data_->_tmp70_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->response_name);
				_g_object_unref0 (_data_->response);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_free0 (_data_->response_name);
	}
	_data_->result = _data_->response;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
components_web_view_handle_cid_request (ComponentsWebView* self,
                                        WebKitURISchemeRequest* request)
{
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (request, webkit_uri_scheme_request_get_type ()));
	if (!components_web_view_handle_internal_response (self, request)) {
		GError* _tmp0_;
		GError* _tmp1_;
		_tmp0_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_NOENT, "Unknown CID");
		_tmp1_ = _tmp0_;
		webkit_uri_scheme_request_finish_error (request, _tmp1_);
		_g_error_free0 (_tmp1_);
	}
}

static void
components_web_view_handle_internal_request (ComponentsWebView* self,
                                             WebKitURISchemeRequest* request)
{
	const gchar* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (request, webkit_uri_scheme_request_get_type ()));
	_tmp0_ = webkit_uri_scheme_request_get_uri (request);
	if (g_strcmp0 (_tmp0_, COMPONENTS_WEB_VIEW_INTERNAL_URL_BODY) == 0) {
		GearyMemoryBuffer* buf = NULL;
		const gchar* _tmp1_;
		GearyMemoryStringBuffer* _tmp2_;
		GearyMemoryBuffer* _tmp3_;
		GInputStream* _tmp4_;
		GInputStream* _tmp5_;
		GearyMemoryBuffer* _tmp6_;
		gsize _tmp7_;
		gsize _tmp8_;
		_tmp1_ = self->priv->body;
		_tmp2_ = geary_memory_string_buffer_new (_tmp1_);
		buf = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
		_tmp3_ = buf;
		_tmp4_ = geary_memory_buffer_get_input_stream (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = buf;
		_tmp7_ = geary_memory_buffer_get_size (_tmp6_);
		_tmp8_ = _tmp7_;
		webkit_uri_scheme_request_finish (request, _tmp5_, (gint64) _tmp8_, NULL);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (buf);
	} else {
		if (!components_web_view_handle_internal_response (self, request)) {
			GError* _tmp9_;
			GError* _tmp10_;
			_tmp9_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_NOENT, "Unknown internal URL");
			_tmp10_ = _tmp9_;
			webkit_uri_scheme_request_finish_error (request, _tmp10_);
			_g_error_free0 (_tmp10_);
		}
	}
}

static gboolean
components_web_view_handle_internal_response (ComponentsWebView* self,
                                              WebKitURISchemeRequest* request)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GearyMemoryBuffer* buf = NULL;
	GeeMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	gboolean handled = FALSE;
	GearyMemoryBuffer* _tmp5_;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (request, webkit_uri_scheme_request_get_type ()), FALSE);
	_tmp0_ = webkit_uri_scheme_request_get_path (request);
	_tmp1_ = g_uri_unescape_string (_tmp0_, NULL);
	name = _tmp1_;
	_tmp2_ = self->priv->internal_resources;
	_tmp3_ = name;
	_tmp4_ = gee_map_get (_tmp2_, _tmp3_);
	buf = (GearyMemoryBuffer*) _tmp4_;
	handled = FALSE;
	_tmp5_ = buf;
	if (_tmp5_ != NULL) {
		GearyMemoryBuffer* _tmp6_;
		GInputStream* _tmp7_;
		GInputStream* _tmp8_;
		GearyMemoryBuffer* _tmp9_;
		gsize _tmp10_;
		gsize _tmp11_;
		const gchar* _tmp12_;
		_tmp6_ = buf;
		_tmp7_ = geary_memory_buffer_get_input_stream (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = buf;
		_tmp10_ = geary_memory_buffer_get_size (_tmp9_);
		_tmp11_ = _tmp10_;
		webkit_uri_scheme_request_finish (request, _tmp8_, (gint64) _tmp11_, NULL);
		_g_object_unref0 (_tmp8_);
		_tmp12_ = name;
		g_signal_emit (self, components_web_view_signals[COMPONENTS_WEB_VIEW_INTERNAL_RESOURCE_LOADED_SIGNAL], 0, _tmp12_);
		handled = TRUE;
	}
	result = handled;
	_g_object_unref0 (buf);
	_g_free0 (name);
	return result;
}

static WebKitNavigationAction*
_vala_WebKitNavigationAction_copy (WebKitNavigationAction* self)
{
	return g_boxed_copy (webkit_navigation_action_get_type (), self);
}

static gpointer
__vala_WebKitNavigationAction_copy0 (gpointer self)
{
	return self ? _vala_WebKitNavigationAction_copy (self) : NULL;
}

static void
_vala_WebKitNavigationAction_free (WebKitNavigationAction* self)
{
	g_boxed_free (webkit_navigation_action_get_type (), self);
}

static gboolean
components_web_view_on_decide_policy (ComponentsWebView* self,
                                      WebKitWebView* view,
                                      WebKitPolicyDecision* policy,
                                      WebKitPolicyDecisionType type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (view, webkit_web_view_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (policy, webkit_policy_decision_get_type ()), FALSE);
	if (type == WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION;
	}
	if (_tmp0_) {
		WebKitNavigationPolicyDecision* nav_policy = NULL;
		WebKitNavigationPolicyDecision* _tmp1_;
		WebKitNavigationAction* nav_action = NULL;
		WebKitNavigationPolicyDecision* _tmp2_;
		WebKitNavigationAction* _tmp3_;
		WebKitNavigationAction* _tmp4_;
		WebKitNavigationAction* _tmp5_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (policy, webkit_navigation_policy_decision_get_type (), WebKitNavigationPolicyDecision));
		nav_policy = _tmp1_;
		_tmp2_ = nav_policy;
		_tmp3_ = webkit_navigation_policy_decision_get_navigation_action (_tmp2_);
		_tmp4_ = __vala_WebKitNavigationAction_copy0 (_tmp3_);
		nav_action = _tmp4_;
		_tmp5_ = nav_action;
		switch (webkit_navigation_action_get_navigation_type (_tmp5_)) {
			case WEBKIT_NAVIGATION_TYPE_OTHER:
			{
				WebKitNavigationAction* _tmp6_;
				WebKitURIRequest* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp6_ = nav_action;
				_tmp7_ = webkit_navigation_action_get_request (_tmp6_);
				_tmp8_ = webkit_uri_request_get_uri (_tmp7_);
				_tmp9_ = _tmp8_;
				if (g_strcmp0 (_tmp9_, COMPONENTS_WEB_VIEW_INTERNAL_URL_BODY) == 0) {
					webkit_policy_decision_use (policy);
				} else {
					webkit_policy_decision_ignore (policy);
				}
				break;
			}
			case WEBKIT_NAVIGATION_TYPE_LINK_CLICKED:
			{
				WebKitNavigationAction* _tmp10_;
				WebKitURIRequest* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				webkit_policy_decision_ignore (policy);
				_tmp10_ = nav_action;
				_tmp11_ = webkit_navigation_action_get_request (_tmp10_);
				_tmp12_ = webkit_uri_request_get_uri (_tmp11_);
				_tmp13_ = _tmp12_;
				g_signal_emit (self, components_web_view_signals[COMPONENTS_WEB_VIEW_LINK_ACTIVATED_SIGNAL], 0, _tmp13_);
				break;
			}
			default:
			{
				webkit_policy_decision_ignore (policy);
				break;
			}
		}
		__vala_WebKitNavigationAction_free0 (nav_action);
		_g_object_unref0 (nav_policy);
	} else {
		webkit_policy_decision_ignore (policy);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
components_web_view_on_scroll_event (ComponentsWebView* self,
                                     GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->state & GDK_CONTROL_MASK) != 0) {
		gdouble dir = 0.0;
		dir = (gdouble) 0;
		if (event->direction == GDK_SCROLL_UP) {
			dir = (gdouble) -1;
		} else {
			if (event->direction == GDK_SCROLL_DOWN) {
				dir = (gdouble) 1;
			} else {
				if (event->direction == GDK_SCROLL_SMOOTH) {
					dir = event->delta_y;
				}
			}
		}
		if (dir < ((gdouble) 0)) {
			components_web_view_zoom_in (self);
			result = TRUE;
			return result;
		} else {
			if (dir > ((gdouble) 0)) {
				components_web_view_zoom_out (self);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
components_web_view_on_preferred_height_changed (ComponentsWebView* self,
                                                 GVariant* parameters)
{
	gdouble height = 0.0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	height = self->priv->webkit_reported_height;
	if (parameters != NULL) {
		_tmp0_ = g_variant_classify (parameters) == G_VARIANT_CLASS_DOUBLE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		height = g_variant_get_double (parameters);
	} else {
		g_warning ("components-web-view.vala:804: Could not get JS preferred height");
	}
	if (self->priv->webkit_reported_height != height) {
		self->priv->webkit_reported_height = height;
		g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "preferred-height");
	}
}

static void
components_web_view_on_command_stack_changed (ComponentsWebView* self,
                                              GVariant* parameters)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	if (parameters != NULL) {
		_tmp1_ = g_variant_is_container (parameters);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = g_variant_n_children (parameters) == ((gsize) 2);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GVariant* can_undo = NULL;
		GVariant* _tmp2_;
		GVariant* can_redo = NULL;
		GVariant* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GVariant* _tmp5_;
		gboolean _tmp7_ = FALSE;
		GVariant* _tmp8_;
		_tmp2_ = g_variant_get_child_value (parameters, (gsize) 0);
		can_undo = _tmp2_;
		_tmp3_ = g_variant_get_child_value (parameters, (gsize) 1);
		can_redo = _tmp3_;
		_tmp5_ = can_undo;
		if (g_variant_classify (_tmp5_) == G_VARIANT_CLASS_BOOLEAN) {
			GVariant* _tmp6_;
			_tmp6_ = can_undo;
			_tmp4_ = g_variant_get_boolean (_tmp6_);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp8_ = can_redo;
		if (g_variant_classify (_tmp8_) == G_VARIANT_CLASS_BOOLEAN) {
			GVariant* _tmp9_;
			_tmp9_ = can_redo;
			_tmp7_ = g_variant_get_boolean (_tmp9_);
		} else {
			_tmp7_ = FALSE;
		}
		g_signal_emit (self, components_web_view_signals[COMPONENTS_WEB_VIEW_COMMAND_STACK_CHANGED_SIGNAL], 0, _tmp4_, _tmp7_);
		_g_variant_unref0 (can_redo);
		_g_variant_unref0 (can_undo);
	} else {
		g_warning ("components-web-view.vala:824: Could not get JS command stack state");
	}
}

static void
components_web_view_on_document_modified (ComponentsWebView* self,
                                          GVariant* parameters)
{
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_signal_emit (self, components_web_view_signals[COMPONENTS_WEB_VIEW_DOCUMENT_MODIFIED_SIGNAL], 0);
}

static void
components_web_view_on_remote_resource_load_blocked (ComponentsWebView* self,
                                                     GVariant* parameters)
{
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	g_signal_emit (self, components_web_view_signals[COMPONENTS_WEB_VIEW_REMOTE_RESOURCE_LOAD_BLOCKED_SIGNAL], 0);
}

static void
components_web_view_on_content_loaded (ComponentsWebView* self,
                                       GVariant* parameters)
{
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	components_web_view_set_is_content_loaded (self, TRUE);
	g_signal_emit (self, components_web_view_signals[COMPONENTS_WEB_VIEW_CONTENT_LOADED_SIGNAL], 0);
}

static void
components_web_view_on_selection_changed (ComponentsWebView* self,
                                          GVariant* parameters)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (COMPONENTS_IS_WEB_VIEW (self));
	if (parameters != NULL) {
		_tmp0_ = g_variant_classify (parameters) == G_VARIANT_CLASS_BOOLEAN;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		components_web_view_set_has_selection (self, g_variant_get_boolean (parameters));
	} else {
		g_warning ("components-web-view.vala:845: Could not get JS selection value");
	}
}

static gchar*
_variant_get12 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static gchar*
_variant_get13 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static gboolean
components_web_view_on_message_received (ComponentsWebView* self,
                                         WebKitUserMessage* message)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_WEB_VIEW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, webkit_user_message_get_type ()), FALSE);
	_tmp0_ = webkit_user_message_get_name (message);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, COMPONENTS_WEB_VIEW_MESSAGE_EXCEPTION) == 0) {
		GVariantDict* detail = NULL;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		GVariantDict* _tmp4_;
		gchar* name = NULL;
		GVariantDict* _tmp5_;
		const GVariantType* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* log_message = NULL;
		GVariantDict* _tmp11_;
		const GVariantType* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		_tmp2_ = webkit_user_message_get_parameters (message);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_variant_dict_new (_tmp3_);
		detail = _tmp4_;
		_tmp5_ = detail;
		_tmp6_ = G_VARIANT_TYPE_STRING;
		_tmp7_ = g_variant_dict_lookup_value (_tmp5_, "name", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _variant_get12 (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_variant_unref0 (_tmp8_);
		name = _tmp10_;
		_tmp11_ = detail;
		_tmp12_ = G_VARIANT_TYPE_STRING;
		_tmp13_ = g_variant_dict_lookup_value (_tmp11_, "message", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _variant_get13 (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_variant_unref0 (_tmp14_);
		log_message = _tmp16_;
		_tmp18_ = name;
		_tmp17_ = _tmp18_;
		if (_tmp17_ == NULL) {
			_tmp17_ = "unknown";
		}
		_tmp20_ = log_message;
		_tmp19_ = _tmp20_;
		if (_tmp19_ == NULL) {
			_tmp19_ = "unknown";
		}
		g_warning ("components-web-view.vala:854: Error sending message from JS: %s: %s", _tmp17_, _tmp19_);
		_g_free0 (log_message);
		_g_free0 (name);
		_g_variant_dict_unref0 (detail);
	} else {
		GeeMap* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = self->priv->message_handlers;
		_tmp22_ = webkit_user_message_get_name (message);
		_tmp23_ = _tmp22_;
		if (gee_map_has_key (_tmp21_, _tmp23_)) {
			gchar* _tmp24_ = NULL;
			GVariant* _tmp25_;
			GVariant* _tmp26_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			ComponentsWebViewMessageCallable* callback = NULL;
			GeeMap* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gpointer _tmp36_;
			ComponentsWebViewMessageCallable* _tmp37_;
			ComponentsWebViewMessageCallback _tmp38_;
			gpointer _tmp38__target;
			GVariant* _tmp39_;
			GVariant* _tmp40_;
			_tmp25_ = webkit_user_message_get_parameters (message);
			_tmp26_ = _tmp25_;
			if (_tmp26_ != NULL) {
				GVariant* _tmp27_;
				GVariant* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = webkit_user_message_get_parameters (message);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_variant_print (_tmp28_, TRUE);
				_g_free0 (_tmp24_);
				_tmp24_ = _tmp29_;
			} else {
				gchar* _tmp30_;
				_tmp30_ = g_strdup ("");
				_g_free0 (_tmp24_);
				_tmp24_ = _tmp30_;
			}
			_tmp31_ = webkit_user_message_get_name (message);
			_tmp32_ = _tmp31_;
			g_debug ("components-web-view.vala:860: Message received: %s(%s)", _tmp32_, _tmp24_);
			_tmp33_ = self->priv->message_handlers;
			_tmp34_ = webkit_user_message_get_name (message);
			_tmp35_ = _tmp34_;
			_tmp36_ = gee_map_get (_tmp33_, _tmp35_);
			callback = (ComponentsWebViewMessageCallable*) _tmp36_;
			_tmp37_ = callback;
			_tmp38_ = _tmp37_->handler;
			_tmp38__target = _tmp37_->handler_target;
			_tmp39_ = webkit_user_message_get_parameters (message);
			_tmp40_ = _tmp39_;
			_tmp38_ (_tmp40_, _tmp38__target);
			_components_web_view_message_callable_unref0 (callback);
			_g_free0 (_tmp24_);
		} else {
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp41_ = webkit_user_message_get_name (message);
			_tmp42_ = _tmp41_;
			g_warning ("components-web-view.vala:868: Message with unknown handler received: %" \
"s", _tmp42_);
		}
	}
	result = TRUE;
	return result;
}

static ComponentsWebViewWebsiteDataManager*
components_web_view_website_data_manager_construct (GType object_type,
                                                    const gchar* base_cache_directory)
{
	ComponentsWebViewWebsiteDataManager * self = NULL;
	g_return_val_if_fail (base_cache_directory != NULL, NULL);
	self = (ComponentsWebViewWebsiteDataManager*) g_object_new (object_type, "base-cache-directory", base_cache_directory, "base-data-directory", base_cache_directory, NULL);
	return self;
}

static ComponentsWebViewWebsiteDataManager*
components_web_view_website_data_manager_new (const gchar* base_cache_directory)
{
	return components_web_view_website_data_manager_construct (COMPONENTS_WEB_VIEW_TYPE_WEBSITE_DATA_MANAGER, base_cache_directory);
}

static void
components_web_view_website_data_manager_class_init (ComponentsWebViewWebsiteDataManagerClass * klass,
                                                     gpointer klass_data)
{
	components_web_view_website_data_manager_parent_class = g_type_class_peek_parent (klass);
}

static void
components_web_view_website_data_manager_instance_init (ComponentsWebViewWebsiteDataManager * self,
                                                        gpointer klass)
{
}

static GType
components_web_view_website_data_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsWebViewWebsiteDataManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_web_view_website_data_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsWebViewWebsiteDataManager), 0, (GInstanceInitFunc) components_web_view_website_data_manager_instance_init, NULL };
	GType components_web_view_website_data_manager_type_id;
	components_web_view_website_data_manager_type_id = g_type_register_static (webkit_website_data_manager_get_type (), "ComponentsWebViewWebsiteDataManager", &g_define_type_info, 0);
	return components_web_view_website_data_manager_type_id;
}

static GType
components_web_view_website_data_manager_get_type (void)
{
	static volatile gsize components_web_view_website_data_manager_type_id__once = 0;
	if (g_once_init_enter (&components_web_view_website_data_manager_type_id__once)) {
		GType components_web_view_website_data_manager_type_id;
		components_web_view_website_data_manager_type_id = components_web_view_website_data_manager_get_type_once ();
		g_once_init_leave (&components_web_view_website_data_manager_type_id__once, components_web_view_website_data_manager_type_id);
	}
	return components_web_view_website_data_manager_type_id__once;
}

static ComponentsWebViewMessageCallable*
components_web_view_message_callable_construct (GType object_type,
                                                ComponentsWebViewMessageCallback handler,
                                                gpointer handler_target)
{
	ComponentsWebViewMessageCallable* self = NULL;
	self = (ComponentsWebViewMessageCallable*) g_type_create_instance (object_type);
	self->handler = handler;
	self->handler_target = handler_target;
	return self;
}

static ComponentsWebViewMessageCallable*
components_web_view_message_callable_new (ComponentsWebViewMessageCallback handler,
                                          gpointer handler_target)
{
	return components_web_view_message_callable_construct (COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE, handler, handler_target);
}

static void
components_web_view_value_message_callable_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
components_web_view_value_message_callable_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		components_web_view_message_callable_unref (value->data[0].v_pointer);
	}
}

static void
components_web_view_value_message_callable_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = components_web_view_message_callable_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
components_web_view_value_message_callable_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
components_web_view_value_message_callable_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ComponentsWebViewMessageCallable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = components_web_view_message_callable_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
components_web_view_value_message_callable_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	ComponentsWebViewMessageCallable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = components_web_view_message_callable_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
components_web_view_param_spec_message_callable (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	ComponentsWebViewParamSpecMessageCallable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
components_web_view_value_get_message_callable (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE), NULL);
	return value->data[0].v_pointer;
}

static void
components_web_view_value_set_message_callable (GValue* value,
                                                gpointer v_object)
{
	ComponentsWebViewMessageCallable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		components_web_view_message_callable_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		components_web_view_message_callable_unref (old);
	}
}

static void
components_web_view_value_take_message_callable (GValue* value,
                                                 gpointer v_object)
{
	ComponentsWebViewMessageCallable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		components_web_view_message_callable_unref (old);
	}
}

static void
components_web_view_message_callable_class_init (ComponentsWebViewMessageCallableClass * klass,
                                                 gpointer klass_data)
{
	components_web_view_message_callable_parent_class = g_type_class_peek_parent (klass);
	((ComponentsWebViewMessageCallableClass *) klass)->finalize = components_web_view_message_callable_finalize;
}

static void
components_web_view_message_callable_instance_init (ComponentsWebViewMessageCallable * self,
                                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
components_web_view_message_callable_finalize (ComponentsWebViewMessageCallable * obj)
{
	ComponentsWebViewMessageCallable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE, ComponentsWebViewMessageCallable);
	g_signal_handlers_destroy (self);
}

static GType
components_web_view_message_callable_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { components_web_view_value_message_callable_init, components_web_view_value_message_callable_free_value, components_web_view_value_message_callable_copy_value, components_web_view_value_message_callable_peek_pointer, "p", components_web_view_value_message_callable_collect_value, "p", components_web_view_value_message_callable_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsWebViewMessageCallableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_web_view_message_callable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsWebViewMessageCallable), 0, (GInstanceInitFunc) components_web_view_message_callable_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType components_web_view_message_callable_type_id;
	components_web_view_message_callable_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ComponentsWebViewMessageCallable", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return components_web_view_message_callable_type_id;
}

static GType
components_web_view_message_callable_get_type (void)
{
	static volatile gsize components_web_view_message_callable_type_id__once = 0;
	if (g_once_init_enter (&components_web_view_message_callable_type_id__once)) {
		GType components_web_view_message_callable_type_id;
		components_web_view_message_callable_type_id = components_web_view_message_callable_get_type_once ();
		g_once_init_leave (&components_web_view_message_callable_type_id__once, components_web_view_message_callable_type_id);
	}
	return components_web_view_message_callable_type_id__once;
}

static gpointer
components_web_view_message_callable_ref (gpointer instance)
{
	ComponentsWebViewMessageCallable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
components_web_view_message_callable_unref (gpointer instance)
{
	ComponentsWebViewMessageCallable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		COMPONENTS_WEB_VIEW_MESSAGE_CALLABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
components_web_view_class_init (ComponentsWebViewClass * klass,
                                gpointer klass_data)
{
	components_web_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsWebView_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) components_web_view_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_components_web_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_web_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_web_view_finalize;
	/**
	     * Determines if the view's content has been fully loaded.
	     *
	     * This property is updated immediately before the {@link
	     * content_loaded} signal is fired, and is triggered by the
	     * PageState JavaScript object completing its load
	     * handler. I.e. This will be true after the in-page JavaScript has
	     * finished making any modifications to the page content.
	     *
	     * This will likely be fired after WebKitGTK sets the `is-loading`
	     * property to `FALSE` and emits `load-changed` with
	     * `WebKitLoadEvent.LOAD_FINISHED`, since they are related to
	     * network resource loading, not page content.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_WEB_VIEW_IS_CONTENT_LOADED_PROPERTY, components_web_view_properties[COMPONENTS_WEB_VIEW_IS_CONTENT_LOADED_PROPERTY] = g_param_spec_boolean ("is-content-loaded", "is-content-loaded", "is-content-loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if the view has any selected text */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_WEB_VIEW_HAS_SELECTION_PROPERTY, components_web_view_properties[COMPONENTS_WEB_VIEW_HAS_SELECTION_PROPERTY] = g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The HTML content's current preferred height in window pixels. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_WEB_VIEW_PREFERRED_HEIGHT_PROPERTY, components_web_view_properties[COMPONENTS_WEB_VIEW_PREFERRED_HEIGHT_PROPERTY] = g_param_spec_int ("preferred-height", "preferred-height", "preferred-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Specifies whether loading remote resources is currently permitted.
	     *
	     * If false, any remote resources contained in HTML loaded into
	     * the view will be blocked.
	     *
	     * @see load_remote_resources
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_WEB_VIEW_IS_LOAD_REMOTE_RESOURCES_ENABLED_PROPERTY, components_web_view_properties[COMPONENTS_WEB_VIEW_IS_LOAD_REMOTE_RESOURCES_ENABLED_PROPERTY] = g_param_spec_boolean ("is-load-remote-resources-enabled", "is-load-remote-resources-enabled", "is-load-remote-resources-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_WEB_VIEW_DOCUMENT_FONT_PROPERTY, components_web_view_properties[COMPONENTS_WEB_VIEW_DOCUMENT_FONT_PROPERTY] = g_param_spec_string ("document-font", "document-font", "document-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_WEB_VIEW_MONOSPACE_FONT_PROPERTY, components_web_view_properties[COMPONENTS_WEB_VIEW_MONOSPACE_FONT_PROPERTY] = g_param_spec_string ("monospace-font", "monospace-font", "monospace-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Emitted when the view's content has finished loaded.
	     *
	     * See {@link is_content_loaded} for detail about when this is
	     * emitted.
	     */
	components_web_view_signals[COMPONENTS_WEB_VIEW_CONTENT_LOADED_SIGNAL] = g_signal_new ("content-loaded", COMPONENTS_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Emitted when the web view's undo/redo stack state changes. */
	components_web_view_signals[COMPONENTS_WEB_VIEW_COMMAND_STACK_CHANGED_SIGNAL] = g_signal_new ("command-stack-changed", COMPONENTS_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	/** Emitted when the web view's content has changed. */
	components_web_view_signals[COMPONENTS_WEB_VIEW_DOCUMENT_MODIFIED_SIGNAL] = g_signal_new ("document-modified", COMPONENTS_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Emitted when a user clicks a link in the view. */
	components_web_view_signals[COMPONENTS_WEB_VIEW_LINK_ACTIVATED_SIGNAL] = g_signal_new ("link-activated", COMPONENTS_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/** Emitted when the view has loaded a resource added to it. */
	components_web_view_signals[COMPONENTS_WEB_VIEW_INTERNAL_RESOURCE_LOADED_SIGNAL] = g_signal_new ("internal-resource-loaded", COMPONENTS_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/** Emitted when a remote resource load was disallowed. */
	components_web_view_signals[COMPONENTS_WEB_VIEW_REMOTE_RESOURCE_LOAD_BLOCKED_SIGNAL] = g_signal_new ("remote-resource-load-blocked", COMPONENTS_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
components_web_view_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                         gpointer iface_data)
{
	components_web_view_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
components_web_view_instance_init (ComponentsWebView * self,
                                   gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = components_web_view_get_instance_private (self);
	self->priv->_is_content_loaded = FALSE;
	self->priv->_has_selection = FALSE;
	self->priv->_is_load_remote_resources_enabled = FALSE;
	self->priv->body = NULL;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->internal_resources = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, COMPONENTS_WEB_VIEW_TYPE_MESSAGE_CALLABLE, (GBoxedCopyFunc) components_web_view_message_callable_ref, (GDestroyNotify) components_web_view_message_callable_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->message_handlers = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap);
	self->priv->webkit_reported_height = (gdouble) 0;
}

static void
components_web_view_finalize (GObject * obj)
{
	ComponentsWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView);
	geary_base_interface_base_unref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_g_free0 (self->priv->_document_font);
	_g_free0 (self->priv->_monospace_font);
	_g_object_unref0 (self->priv->internal_resources);
	_g_object_unref0 (self->priv->message_handlers);
	G_OBJECT_CLASS (components_web_view_parent_class)->finalize (obj);
}

/**
 * Base class for all WebKit2 WebView instances used by the Geary client.
 *
 * This provides common functionality expected by the client for
 * displaying HTML, such as common WebKit settings, desktop font
 * integration, Inspector support, and remote and inline resource
 * handling for content such as images and videos.
 */
static GType
components_web_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsWebViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_web_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsWebView), 0, (GInstanceInitFunc) components_web_view_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) components_web_view_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType components_web_view_type_id;
	components_web_view_type_id = g_type_register_static (webkit_web_view_get_type (), "ComponentsWebView", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (components_web_view_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ComponentsWebView_private_offset = g_type_add_instance_private (components_web_view_type_id, sizeof (ComponentsWebViewPrivate));
	return components_web_view_type_id;
}

GType
components_web_view_get_type (void)
{
	static volatile gsize components_web_view_type_id__once = 0;
	if (g_once_init_enter (&components_web_view_type_id__once)) {
		GType components_web_view_type_id;
		components_web_view_type_id = components_web_view_get_type_once ();
		g_once_init_leave (&components_web_view_type_id__once, components_web_view_type_id);
	}
	return components_web_view_type_id__once;
}

static void
_vala_components_web_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ComponentsWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView);
	switch (property_id) {
		case COMPONENTS_WEB_VIEW_IS_CONTENT_LOADED_PROPERTY:
		g_value_set_boolean (value, components_web_view_get_is_content_loaded (self));
		break;
		case COMPONENTS_WEB_VIEW_HAS_SELECTION_PROPERTY:
		g_value_set_boolean (value, components_web_view_get_has_selection (self));
		break;
		case COMPONENTS_WEB_VIEW_PREFERRED_HEIGHT_PROPERTY:
		g_value_set_int (value, components_web_view_get_preferred_height (self));
		break;
		case COMPONENTS_WEB_VIEW_IS_LOAD_REMOTE_RESOURCES_ENABLED_PROPERTY:
		g_value_set_boolean (value, components_web_view_get_is_load_remote_resources_enabled (self));
		break;
		case COMPONENTS_WEB_VIEW_DOCUMENT_FONT_PROPERTY:
		g_value_set_string (value, components_web_view_get_document_font (self));
		break;
		case COMPONENTS_WEB_VIEW_MONOSPACE_FONT_PROPERTY:
		g_value_set_string (value, components_web_view_get_monospace_font (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_web_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ComponentsWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView);
	switch (property_id) {
		case COMPONENTS_WEB_VIEW_IS_CONTENT_LOADED_PROPERTY:
		components_web_view_set_is_content_loaded (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_WEB_VIEW_HAS_SELECTION_PROPERTY:
		components_web_view_set_has_selection (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_WEB_VIEW_IS_LOAD_REMOTE_RESOURCES_ENABLED_PROPERTY:
		components_web_view_set_is_load_remote_resources_enabled (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_WEB_VIEW_DOCUMENT_FONT_PROPERTY:
		components_web_view_set_document_font (self, g_value_get_string (value));
		break;
		case COMPONENTS_WEB_VIEW_MONOSPACE_FONT_PROPERTY:
		components_web_view_set_monospace_font (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

