/* imap-command.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-command.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_COMMAND_0_PROPERTY,
	GEARY_IMAP_COMMAND_TAG_PROPERTY,
	GEARY_IMAP_COMMAND_NAME_PROPERTY,
	GEARY_IMAP_COMMAND_RESPONSE_TIMEOUT_PROPERTY,
	GEARY_IMAP_COMMAND_STATUS_PROPERTY,
	GEARY_IMAP_COMMAND_SHOULD_SEND_PROPERTY,
	GEARY_IMAP_COMMAND_ARGS_PROPERTY,
	GEARY_IMAP_COMMAND_RESPONSE_TIMER_PROPERTY,
	GEARY_IMAP_COMMAND_NUM_PROPERTIES
};
static GParamSpec* geary_imap_command_properties[GEARY_IMAP_COMMAND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapCommandSendData GearyImapCommandSendData;
typedef struct _GearyImapCommandSendWaitData GearyImapCommandSendWaitData;
typedef struct _GearyImapCommandWaitUntilCompleteData GearyImapCommandWaitUntilCompleteData;
enum  {
	GEARY_IMAP_COMMAND_RESPONSE_TIMED_OUT_SIGNAL,
	GEARY_IMAP_COMMAND_NUM_SIGNALS
};
static guint geary_imap_command_signals[GEARY_IMAP_COMMAND_NUM_SIGNALS] = {0};

struct _GearyImapCommandPrivate {
	GearyImapTag* _tag;
	gchar* _name;
	guint _response_timeout;
	GearyImapStatusResponse* _status;
	GCancellable* _should_send;
	GearyImapListParameter* _args;
	GearyTimeoutManager* _response_timer;
	GearyNonblockingSemaphore* complete_lock;
	GError* cancelled_cause;
	GearyNonblockingSpinlock* literal_spinlock;
	GCancellable* literal_cancellable;
};

struct _GearyImapCommandSendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapCommand* self;
	GearyImapSerializer* ser;
	GCancellable* cancellable;
	GearyTimeoutManager* _tmp0_;
	GearyImapTag* _tmp1_;
	const gchar* _tmp2_;
	GearyImapListParameter* _tmp3_;
	GeeList* _arg_list;
	GearyImapListParameter* _tmp4_;
	GeeList* _tmp5_;
	gint _arg_size;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _arg_index;
	gint _tmp9_;
	gint _tmp10_;
	GearyImapParameter* arg;
	GeeList* _tmp11_;
	gpointer _tmp12_;
	GearyImapParameter* _tmp13_;
	GearyImapLiteralParameter* literal;
	GearyImapParameter* _tmp14_;
	GearyImapLiteralParameter* _tmp15_;
	GearyImapLiteralParameter* _tmp16_;
	GearyNonblockingSpinlock* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	GearyNonblockingSpinlock* _tmp20_;
	GearyNonblockingSpinlock* _tmp21_;
	guint buf_size;
	guint _tmp22_;
	guint _tmp23_;
	guint8* buf;
	guint8* _tmp24_;
	gint buf_length1;
	gint _buf_size_;
	GInputStream* data;
	GearyImapLiteralParameter* _tmp25_;
	GearyMemoryBuffer* _tmp26_;
	GearyMemoryBuffer* _tmp27_;
	GInputStream* _tmp28_;
	gsize read;
	GInputStream* _tmp29_;
	guint8* _tmp30_;
	gint _tmp30__length1;
	gsize _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	GearyTimeoutManager* _tmp33_;
	GError* _inner_error1_;
	GInputStream* _tmp34_;
	GError* _inner_error0_;
};

struct _GearyImapCommandSendWaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapCommand* self;
	GearyImapSerializer* ser;
	GCancellable* cancellable;
};

struct _GearyImapCommandWaitUntilCompleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapCommand* self;
	GCancellable* cancellable;
	GearyNonblockingSemaphore* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	gboolean _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GearyImapStatusResponse* _tmp11_;
	GearyImapStatus _tmp12_;
	GearyImapStatus _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GearyImapStatusResponse* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	GError* _inner_error0_;
};

static gint GearyImapCommand_private_offset;
static gpointer geary_imap_command_parent_class = NULL;

VALA_EXTERN void geary_imap_command_send (GearyImapCommand* self,
                              GearyImapSerializer* ser,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_finish (GearyImapCommand* self,
                                     GAsyncResult* _res_,
                                     GError** error);
VALA_EXTERN void geary_imap_command_send_wait (GearyImapCommand* self,
                                   GearyImapSerializer* ser,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_wait_finish (GearyImapCommand* self,
                                          GAsyncResult* _res_,
                                          GError** error);
VALA_EXTERN void geary_imap_command_update_response_timer (GearyImapCommand* self);
VALA_EXTERN void geary_imap_command_completed (GearyImapCommand* self,
                                   GearyImapStatusResponse* new_status,
                                   GError** error);
VALA_EXTERN void geary_imap_command_cancelled_before_send (GearyImapCommand* self);
VALA_EXTERN void geary_imap_command_disconnected (GearyImapCommand* self,
                                      const gchar* reason);
VALA_EXTERN void geary_imap_command_data_received (GearyImapCommand* self,
                                       GearyImapServerData* data,
                                       GError** error);
VALA_EXTERN void geary_imap_command_continuation_requested (GearyImapCommand* self,
                                                GearyImapContinuationResponse* continuation,
                                                GError** error);
static void geary_imap_command_set_tag (GearyImapCommand* self,
                                 GearyImapTag* value);
static void geary_imap_command_set_name (GearyImapCommand* self,
                                  const gchar* value);
static void geary_imap_command_set_status (GearyImapCommand* self,
                                    GearyImapStatusResponse* value);
static void geary_imap_command_set_should_send (GearyImapCommand* self,
                                         GCancellable* value);
static void geary_imap_command_set_args (GearyImapCommand* self,
                                  GearyImapListParameter* value);
static void geary_imap_command_set_response_timer (GearyImapCommand* self,
                                            GearyTimeoutManager* value);
static void geary_imap_command_on_response_timeout (GearyImapCommand* self);
static void _geary_imap_command_on_response_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                 gpointer self);
VALA_EXTERN void geary_imap_command_assign_tag (GearyImapCommand* self,
                                    GearyImapTag* new_tag,
                                    GError** error);
VALA_EXTERN gchar* geary_imap_command_to_brief_string (GearyImapCommand* self);
static void geary_imap_command_real_send_data_free (gpointer _data);
static void geary_imap_command_real_send (GearyImapCommand* self,
                                   GearyImapSerializer* ser,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static gboolean geary_imap_command_real_send_co (GearyImapCommandSendData* _data_);
static void geary_imap_command_send_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void geary_imap_command_real_send_wait_data_free (gpointer _data);
static void geary_imap_command_real_send_wait (GearyImapCommand* self,
                                        GearyImapSerializer* ser,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean geary_imap_command_real_send_wait_co (GearyImapCommandSendWaitData* _data_);
static void geary_imap_command_wait_until_complete_data_free (gpointer _data);
static gboolean geary_imap_command_wait_until_complete_co (GearyImapCommandWaitUntilCompleteData* _data_);
static void geary_imap_command_wait_until_complete_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void geary_imap_command_check_has_status (GearyImapCommand* self,
                                          GError** error);
static gchar* geary_imap_command_real_to_string (GearyImapCommand* self);
static void geary_imap_command_real_update_response_timer (GearyImapCommand* self);
static void geary_imap_command_real_completed (GearyImapCommand* self,
                                        GearyImapStatusResponse* new_status,
                                        GError** error);
static void geary_imap_command_real_cancelled_before_send (GearyImapCommand* self);
static void geary_imap_command_cancel (GearyImapCommand* self,
                                GError* cause);
static void geary_imap_command_real_disconnected (GearyImapCommand* self,
                                           const gchar* reason);
static void geary_imap_command_real_data_received (GearyImapCommand* self,
                                            GearyImapServerData* data,
                                            GError** error);
static void geary_imap_command_real_continuation_requested (GearyImapCommand* self,
                                                     GearyImapContinuationResponse* continuation,
                                                     GError** error);
static void geary_imap_command_real_stop_serialisation (GearyImapCommand* self);
static void geary_imap_command_finalize (GObject * obj);
static GType geary_imap_command_get_type_once (void);
static void _vala_geary_imap_command_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_geary_imap_command_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
geary_imap_command_get_instance_private (GearyImapCommand* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapCommand_private_offset);
}

GearyImapTag*
geary_imap_command_get_tag (GearyImapCommand* self)
{
	GearyImapTag* result;
	GearyImapTag* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_tag;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_command_set_tag (GearyImapCommand* self,
                            GearyImapTag* value)
{
	GearyImapTag* old_value;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	old_value = geary_imap_command_get_tag (self);
	if (old_value != value) {
		GearyImapTag* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_tag);
		self->priv->_tag = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_command_properties[GEARY_IMAP_COMMAND_TAG_PROPERTY]);
	}
}

const gchar*
geary_imap_command_get_name (GearyImapCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
geary_imap_command_set_name (GearyImapCommand* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	old_value = geary_imap_command_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_command_properties[GEARY_IMAP_COMMAND_NAME_PROPERTY]);
	}
}

guint
geary_imap_command_get_response_timeout (GearyImapCommand* self)
{
	guint result;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), 0U);
	result = self->priv->_response_timeout;
	return result;
}

void
geary_imap_command_set_response_timeout (GearyImapCommand* self,
                                         guint value)
{
	GearyTimeoutManager* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	self->priv->_response_timeout = value;
	_tmp0_ = self->priv->_response_timer;
	_tmp0_->interval = value;
	g_object_notify_by_pspec ((GObject *) self, geary_imap_command_properties[GEARY_IMAP_COMMAND_RESPONSE_TIMEOUT_PROPERTY]);
}

GearyImapStatusResponse*
geary_imap_command_get_status (GearyImapCommand* self)
{
	GearyImapStatusResponse* result;
	GearyImapStatusResponse* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}

static void
geary_imap_command_set_status (GearyImapCommand* self,
                               GearyImapStatusResponse* value)
{
	GearyImapStatusResponse* old_value;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	old_value = geary_imap_command_get_status (self);
	if (old_value != value) {
		GearyImapStatusResponse* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_status);
		self->priv->_status = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_command_properties[GEARY_IMAP_COMMAND_STATUS_PROPERTY]);
	}
}

GCancellable*
geary_imap_command_get_should_send (GearyImapCommand* self)
{
	GCancellable* result;
	GCancellable* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_should_send;
	result = _tmp0_;
	return result;
}

static void
geary_imap_command_set_should_send (GearyImapCommand* self,
                                    GCancellable* value)
{
	GCancellable* old_value;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	old_value = geary_imap_command_get_should_send (self);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_should_send);
		self->priv->_should_send = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_command_properties[GEARY_IMAP_COMMAND_SHOULD_SEND_PROPERTY]);
	}
}

GearyImapListParameter*
geary_imap_command_get_args (GearyImapCommand* self)
{
	GearyImapListParameter* result;
	GearyImapListParameter* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_args;
	result = _tmp0_;
	return result;
}

static void
geary_imap_command_set_args (GearyImapCommand* self,
                             GearyImapListParameter* value)
{
	GearyImapListParameter* old_value;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	old_value = geary_imap_command_get_args (self);
	if (old_value != value) {
		GearyImapListParameter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_args);
		self->priv->_args = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_command_properties[GEARY_IMAP_COMMAND_ARGS_PROPERTY]);
	}
}

GearyTimeoutManager*
geary_imap_command_get_response_timer (GearyImapCommand* self)
{
	GearyTimeoutManager* result;
	GearyTimeoutManager* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_response_timer;
	result = _tmp0_;
	return result;
}

static void
geary_imap_command_set_response_timer (GearyImapCommand* self,
                                       GearyTimeoutManager* value)
{
	GearyTimeoutManager* old_value;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	old_value = geary_imap_command_get_response_timer (self);
	if (old_value != value) {
		GearyTimeoutManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_response_timer);
		self->priv->_response_timer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_command_properties[GEARY_IMAP_COMMAND_RESPONSE_TIMER_PROPERTY]);
	}
}

/**
     * Constructs a new command with an unassigned tag.
     *
     * Any arguments provided here will be converted to appropriate
     * string arguments. The given cancellable will be set as {@link
     * should_send}.
     *
     * @see Tag
     * @see should_send
     */
static void
_geary_imap_command_on_response_timeout_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                            gpointer self)
{
	geary_imap_command_on_response_timeout ((GearyImapCommand*) self);
}

GearyImapCommand*
geary_imap_command_construct (GType object_type,
                              const gchar* name,
                              gchar** args,
                              gint args_length1,
                              GCancellable* should_send)
{
	GearyImapCommand * self = NULL;
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp1_;
	GearyTimeoutManager* _tmp7_;
	GearyTimeoutManager* _tmp8_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	self = (GearyImapCommand*) geary_base_object_construct (object_type);
	_tmp0_ = geary_imap_tag_get_unassigned ();
	_tmp1_ = _tmp0_;
	geary_imap_command_set_tag (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	geary_imap_command_set_name (self, name);
	if (args != NULL) {
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = args;
			arg_collection_length1 = args_length1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp2_;
				gchar* arg = NULL;
				_tmp2_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp2_;
				{
					GearyImapListParameter* _tmp3_;
					const gchar* _tmp4_;
					GearyImapParameter* _tmp5_;
					GearyImapParameter* _tmp6_;
					_tmp3_ = self->priv->_args;
					_tmp4_ = arg;
					_tmp5_ = geary_imap_parameter_get_for_string (_tmp4_);
					_tmp6_ = _tmp5_;
					geary_imap_list_parameter_add (_tmp3_, _tmp6_);
					_g_object_unref0 (_tmp6_);
					_g_free0 (arg);
				}
			}
		}
	}
	geary_imap_command_set_should_send (self, should_send);
	_tmp7_ = geary_timeout_manager_new_seconds (self->priv->_response_timeout, _geary_imap_command_on_response_timeout_geary_timeout_manager_timeout_func, self);
	_tmp8_ = _tmp7_;
	geary_imap_command_set_response_timer (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	return self;
}

gboolean
geary_imap_command_has_name (GearyImapCommand* self,
                             const gchar* name)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_name;
	result = geary_ascii_stri_equal (_tmp0_, name);
	return result;
}

/**
     * Assign a Tag to this command, if currently unassigned.
     *
     * Can only be called on a Command that holds an unassigned tag,
     * and hence this can only be called once at most. Throws an error
     * if already assigned or if the supplied tag is unassigned.
     */
void
geary_imap_command_assign_tag (GearyImapCommand* self,
                               GearyImapTag* new_tag,
                               GError** error)
{
	GearyImapTag* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	g_return_if_fail (GEARY_IMAP_IS_TAG (new_tag));
	_tmp0_ = self->priv->_tag;
	if (geary_imap_tag_is_assigned (_tmp0_)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_command_to_brief_string (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_SUPPORTED, "%s: Command tag is already assigned", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (!geary_imap_tag_is_assigned (new_tag)) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp5_ = geary_imap_command_to_brief_string (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_SUPPORTED, "%s: New tag is not assigned", _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	geary_imap_command_set_tag (self, new_tag);
}

static void
geary_imap_command_real_send_data_free (gpointer _data)
{
	GearyImapCommandSendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ser);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapCommandSendData, _data_);
}

static void
geary_imap_command_real_send (GearyImapCommand* self,
                              GearyImapSerializer* ser,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GearyImapCommandSendData* _data_;
	GearyImapCommand* _tmp0_;
	GearyImapSerializer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapCommandSendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_command_real_send_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ser);
	_g_object_unref0 (_data_->ser);
	_data_->ser = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_command_real_send_co (_data_);
}

static void
geary_imap_command_real_send_finish (GearyImapCommand* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GearyImapCommandSendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Serialises this command for transmission to the server.
     *
     * This will serialise its tag, name and arguments (if
     * any). Arguments are treated as strings and escaped as needed,
     * including being encoded as a literal. If any literals are
     * required, this method will yield until a command continuation
     * has been received, when it will resume the same process.
     */
static void
geary_imap_command_send_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GearyImapCommandSendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_command_real_send_co (_data_);
}

static gboolean
geary_imap_command_real_send_co (GearyImapCommandSendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_response_timer;
	geary_timeout_manager_start (_data_->_tmp0_);
	_data_->_tmp1_ = _data_->self->priv->_tag;
	geary_imap_parameter_serialize (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter), _data_->ser, _data_->cancellable, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_imap_serializer_push_space (_data_->ser, _data_->cancellable, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_name;
	geary_imap_serializer_push_unquoted_string (_data_->ser, _data_->_tmp2_, _data_->cancellable, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->_args;
	if (_data_->_tmp3_ != NULL) {
		{
			_data_->_tmp4_ = _data_->self->priv->_args;
			_data_->_tmp5_ = geary_imap_list_parameter_get_all (_data_->_tmp4_);
			_data_->_arg_list = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->_arg_list;
			_data_->_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_arg_size = _data_->_tmp8_;
			_data_->_arg_index = -1;
			while (TRUE) {
				_data_->_arg_index = _data_->_arg_index + 1;
				_data_->_tmp9_ = _data_->_arg_index;
				_data_->_tmp10_ = _data_->_arg_size;
				if (!(_data_->_tmp9_ < _data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = _data_->_arg_list;
				_data_->_tmp12_ = gee_list_get (_data_->_tmp11_, _data_->_arg_index);
				_data_->arg = (GearyImapParameter*) _data_->_tmp12_;
				geary_imap_serializer_push_space (_data_->ser, _data_->cancellable, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->arg);
					_g_object_unref0 (_data_->_arg_list);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp13_ = _data_->arg;
				geary_imap_parameter_serialize (_data_->_tmp13_, _data_->ser, _data_->cancellable, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->arg);
					_g_object_unref0 (_data_->_arg_list);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp14_ = _data_->arg;
				_data_->_tmp15_ = _g_object_ref0 (GEARY_IMAP_IS_LITERAL_PARAMETER (_data_->_tmp14_) ? ((GearyImapLiteralParameter*) _data_->_tmp14_) : NULL);
				_data_->literal = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->literal;
				if (_data_->_tmp16_ != NULL) {
					_data_->_state_ = 1;
					geary_imap_serializer_flush_stream (_data_->ser, _data_->cancellable, geary_imap_command_send_ready, _data_);
					return FALSE;
					_state_1:
					geary_imap_serializer_flush_stream_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->literal);
						_g_object_unref0 (_data_->arg);
						_g_object_unref0 (_data_->_arg_list);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp17_ = _data_->self->priv->literal_spinlock;
					if (_data_->_tmp17_ == NULL) {
						_data_->_tmp18_ = g_cancellable_new ();
						_g_object_unref0 (_data_->self->priv->literal_cancellable);
						_data_->self->priv->literal_cancellable = _data_->_tmp18_;
						_data_->_tmp19_ = _data_->self->priv->literal_cancellable;
						_data_->_tmp20_ = geary_nonblocking_spinlock_new (_data_->_tmp19_);
						_g_object_unref0 (_data_->self->priv->literal_spinlock);
						_data_->self->priv->literal_spinlock = _data_->_tmp20_;
					}
					_data_->_tmp21_ = _data_->self->priv->literal_spinlock;
					_data_->_state_ = 2;
					geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_imap_command_send_ready, _data_);
					return FALSE;
					_state_2:
					geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->literal);
						_g_object_unref0 (_data_->arg);
						_g_object_unref0 (_data_->_arg_list);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->buf_size = (guint) 1;
					while (TRUE) {
						_data_->_tmp22_ = geary_imap_command_get_response_timeout (_data_->self);
						_data_->_tmp23_ = _data_->_tmp22_;
						if (!(_data_->buf_size <= _data_->_tmp23_)) {
							break;
						}
						_data_->buf_size <<= (guint) 1;
					}
					_data_->buf_size >>= (guint) 1;
					_data_->_tmp24_ = g_new0 (guint8, _data_->buf_size * 1024);
					_data_->buf = _data_->_tmp24_;
					_data_->buf_length1 = _data_->buf_size * 1024;
					_data_->_buf_size_ = _data_->buf_length1;
					_data_->_tmp25_ = _data_->literal;
					_data_->_tmp26_ = geary_imap_literal_parameter_get_value (_data_->_tmp25_);
					_data_->_tmp27_ = _data_->_tmp26_;
					_data_->_tmp28_ = geary_memory_buffer_get_input_stream (_data_->_tmp27_);
					_data_->data = _data_->_tmp28_;
					{
						while (TRUE) {
							_data_->_tmp29_ = _data_->data;
							_data_->_tmp30_ = _data_->buf;
							_data_->_tmp30__length1 = _data_->buf_length1;
							_data_->_tmp31_ = 0UL;
							_data_->_state_ = 3;
							g_input_stream_read_all_async (_data_->_tmp29_, _data_->_tmp30_, (gsize) _data_->_tmp30__length1, G_PRIORITY_DEFAULT, _data_->cancellable, geary_imap_command_send_ready, _data_);
							return FALSE;
							_state_3:
							g_input_stream_read_all_finish (_data_->_tmp29_, _data_->_res_, &_data_->_tmp31_, &_data_->_inner_error0_);
							_data_->read = _data_->_tmp31_;
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								goto __finally0;
							}
							if (_data_->read <= ((gsize) 0)) {
								break;
							}
							_data_->buf_length1 = (gint) _data_->read;
							_data_->_tmp32_ = _data_->buf;
							_data_->_tmp32__length1 = _data_->buf_length1;
							_data_->_state_ = 4;
							geary_imap_serializer_push_literal_data (_data_->ser, _data_->_tmp32_, (gint) _data_->_tmp32__length1, _data_->cancellable, geary_imap_command_send_ready, _data_);
							return FALSE;
							_state_4:
							geary_imap_serializer_push_literal_data_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								goto __finally0;
							}
							_data_->_tmp33_ = _data_->self->priv->_response_timer;
							geary_timeout_manager_start (_data_->_tmp33_);
						}
					}
					__finally0:
					{
						{
							_data_->_tmp34_ = _data_->data;
							_data_->_state_ = 5;
							g_input_stream_close_async (_data_->_tmp34_, G_PRIORITY_DEFAULT, NULL, geary_imap_command_send_ready, _data_);
							return FALSE;
							_state_5:
							g_input_stream_close_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error1_);
							if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
								goto __catch1_g_error;
							}
						}
						goto __finally1;
						__catch1_g_error:
						{
							g_clear_error (&_data_->_inner_error1_);
						}
						__finally1:
						if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error1_);
							_g_object_unref0 (_data_->data);
							_data_->buf = (g_free (_data_->buf), NULL);
							_g_object_unref0 (_data_->literal);
							_g_object_unref0 (_data_->arg);
							_g_object_unref0 (_data_->_arg_list);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					}
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->data);
						_data_->buf = (g_free (_data_->buf), NULL);
						_g_object_unref0 (_data_->literal);
						_g_object_unref0 (_data_->arg);
						_g_object_unref0 (_data_->_arg_list);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_g_object_unref0 (_data_->data);
					_data_->buf = (g_free (_data_->buf), NULL);
				}
				_g_object_unref0 (_data_->literal);
				_g_object_unref0 (_data_->arg);
			}
			_g_object_unref0 (_data_->_arg_list);
		}
	}
	geary_imap_serializer_push_eol (_data_->ser, _data_->cancellable, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_command_send (GearyImapCommand* self,
                         GearyImapSerializer* ser,
                         GCancellable* cancellable,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GearyImapCommandClass* _klass_;
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->send) {
		_klass_->send (self, ser, cancellable, _callback_, _user_data_);
	}
}

void
geary_imap_command_send_finish (GearyImapCommand* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GearyImapCommandClass* _klass_;
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->send_finish) {
		_klass_->send_finish (self, _res_, error);
	}
}

static void
geary_imap_command_real_send_wait_data_free (gpointer _data)
{
	GearyImapCommandSendWaitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ser);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapCommandSendWaitData, _data_);
}

static void
geary_imap_command_real_send_wait (GearyImapCommand* self,
                                   GearyImapSerializer* ser,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyImapCommandSendWaitData* _data_;
	GearyImapCommand* _tmp0_;
	GearyImapSerializer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapCommandSendWaitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_command_real_send_wait_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ser);
	_g_object_unref0 (_data_->ser);
	_data_->ser = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_command_real_send_wait_co (_data_);
}

static void
geary_imap_command_real_send_wait_finish (GearyImapCommand* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GearyImapCommandSendWaitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Check for command-specific server responses after sending.
     *
     * This method is called after {@link send} and after {@link
     * ClientSession} has signalled the command has been sent, but
     * before the next command is processed. It allows command
     * implementations (e.g. {@link IdleCommand}) to asynchronously
     * wait for some kind of response from the server before allowing
     * additional commands to be sent.
     *
     * Most commands will not need to override this, and it by default
     * does nothing.
     */
static gboolean
geary_imap_command_real_send_wait_co (GearyImapCommandSendWaitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_imap_command_send_wait (GearyImapCommand* self,
                              GearyImapSerializer* ser,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GearyImapCommandClass* _klass_;
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->send_wait) {
		_klass_->send_wait (self, ser, cancellable, _callback_, _user_data_);
	}
}

void
geary_imap_command_send_wait_finish (GearyImapCommand* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GearyImapCommandClass* _klass_;
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->send_wait_finish) {
		_klass_->send_wait_finish (self, _res_, error);
	}
}

static void
geary_imap_command_wait_until_complete_data_free (gpointer _data)
{
	GearyImapCommandWaitUntilCompleteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapCommandWaitUntilCompleteData, _data_);
}

void
geary_imap_command_wait_until_complete (GearyImapCommand* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearyImapCommandWaitUntilCompleteData* _data_;
	GearyImapCommand* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapCommandWaitUntilCompleteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_command_wait_until_complete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_command_wait_until_complete_co (_data_);
}

void
geary_imap_command_wait_until_complete_finish (GearyImapCommand* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GearyImapCommandWaitUntilCompleteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Yields until the command has been completed or cancelled.
     *
     * Throws an error if the command or the cancellable argument is
     * cancelled, if the command timed out, or if the command's
     * response was bad.
     */
static void
geary_imap_command_wait_until_complete_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearyImapCommandWaitUntilCompleteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_command_wait_until_complete_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_imap_command_wait_until_complete_co (GearyImapCommandWaitUntilCompleteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->complete_lock;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_imap_command_wait_until_complete_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->cancelled_cause;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->cancelled_cause;
		_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->_should_send;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->self->priv->_should_send;
		_data_->_tmp4_ = g_cancellable_is_cancelled (_data_->_tmp6_);
	} else {
		_data_->_tmp4_ = FALSE;
	}
	if (_data_->_tmp4_) {
		_data_->_tmp7_ = geary_imap_command_to_brief_string (_data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Command was cancelled after sending: %s", _data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_free0 (_data_->_tmp8_);
		_data_->_inner_error0_ = _data_->_tmp10_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_imap_command_check_has_status (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->self->priv->_status;
	_data_->_tmp12_ = geary_imap_status_response_get_status (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	if (_data_->_tmp13_ == GEARY_IMAP_STATUS_BAD) {
		_data_->_tmp14_ = geary_imap_command_to_brief_string (_data_->self);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = _data_->self->priv->_status;
		_data_->_tmp17_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "%s: Command failed: %s", _data_->_tmp15_, _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_free0 (_data_->_tmp18_);
		_g_free0 (_data_->_tmp15_);
		_data_->_inner_error0_ = _data_->_tmp20_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
geary_imap_command_real_to_string (GearyImapCommand* self)
{
	gchar* args = NULL;
	GearyImapListParameter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = self->priv->_args;
	_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	args = _tmp1_;
	_tmp3_ = args;
	if (geary_string_is_empty (_tmp3_)) {
		GearyImapTag* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = self->priv->_tag;
		_tmp5_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_name;
		_tmp8_ = g_strdup_printf ("%s %s", _tmp6_, _tmp7_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp8_;
		_g_free0 (_tmp6_);
	} else {
		GearyImapTag* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = self->priv->_tag;
		_tmp10_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->_name;
		_tmp13_ = args;
		_tmp14_ = g_strdup_printf ("%s %s %s", _tmp11_, _tmp12_, _tmp13_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp14_;
		_g_free0 (_tmp11_);
	}
	result = _tmp2_;
	_g_free0 (args);
	return result;
}

gchar*
geary_imap_command_to_string (GearyImapCommand* self)
{
	GearyImapCommandClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

/**
     * Updates the commands response timer, if running.
     *
     * This will reset the command's response timer, preventing the
     * command from timing out for another {@link response_timeout}
     * seconds.
     */
static void
geary_imap_command_real_update_response_timer (GearyImapCommand* self)
{
	GearyTimeoutManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->_response_timer;
	_tmp1_ = geary_timeout_manager_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GearyTimeoutManager* _tmp3_;
		_tmp3_ = self->priv->_response_timer;
		geary_timeout_manager_start (_tmp3_);
	}
}

void
geary_imap_command_update_response_timer (GearyImapCommand* self)
{
	GearyImapCommandClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->update_response_timer) {
		_klass_->update_response_timer (self);
	}
}

/**
     * Called when a tagged status response is received for this command.
     *
     * This will update the command's {@link status} property, then
     * throw an error if it does not indicate a successful completion.
     */
static void
geary_imap_command_real_completed (GearyImapCommand* self,
                                   GearyImapStatusResponse* new_status,
                                   GError** error)
{
	GearyImapStatusResponse* _tmp0_;
	GearyTimeoutManager* _tmp8_;
	GearyNonblockingSemaphore* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (new_status));
	_tmp0_ = self->priv->_status;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GearyImapStatusResponse* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		geary_imap_command_stop_serialisation (self);
		_tmp1_ = geary_imap_command_to_brief_string (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_status;
		_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "%s: Duplicate status response received: %s", _tmp2_, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	geary_imap_command_set_status (self, new_status);
	_tmp8_ = self->priv->_response_timer;
	geary_timeout_manager_reset (_tmp8_);
	_tmp9_ = self->priv->complete_lock;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	geary_imap_command_stop_serialisation (self);
	geary_imap_command_check_has_status (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
geary_imap_command_completed (GearyImapCommand* self,
                              GearyImapStatusResponse* new_status,
                              GError** error)
{
	GearyImapCommandClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->completed) {
		_klass_->completed (self, new_status, error);
	}
}

/**
     * Marks this command as being cancelled before being sent.
     *
     * When this method is called, all locks will be released,
     * including {@link wait_until_complete}, which will then throw a
     * `GLib.IOError.CANCELLED` error.
     */
static void
geary_imap_command_real_cancelled_before_send (GearyImapCommand* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	_tmp0_ = geary_imap_command_to_brief_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Command was cancelled before sending: %s", _tmp1_);
	_tmp3_ = _tmp2_;
	geary_imap_command_cancel (self, _tmp3_);
	_g_error_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

void
geary_imap_command_cancelled_before_send (GearyImapCommand* self)
{
	GearyImapCommandClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->cancelled_before_send) {
		_klass_->cancelled_before_send (self);
	}
}

/**
     * Cancels this command due to a network or server disconnect.
     *
     * When this method is called, all locks will be released,
     * including {@link wait_until_complete}, which will then throw a
     * `ImapError.NOT_CONNECTED` error.
     */
static void
geary_imap_command_real_disconnected (GearyImapCommand* self,
                                      const gchar* reason)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	g_return_if_fail (reason != NULL);
	_tmp0_ = geary_imap_command_to_brief_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_CONNECTED, "%s: %s", _tmp1_, reason);
	_tmp3_ = _tmp2_;
	geary_imap_command_cancel (self, _tmp3_);
	_g_error_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

void
geary_imap_command_disconnected (GearyImapCommand* self,
                                 const gchar* reason)
{
	GearyImapCommandClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->disconnected) {
		_klass_->disconnected (self, reason);
	}
}

/**
     * Called when tagged server data is received for this command.
     */
static void
geary_imap_command_real_data_received (GearyImapCommand* self,
                                       GearyImapServerData* data,
                                       GError** error)
{
	GearyImapStatusResponse* _tmp0_;
	GearyTimeoutManager* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_SERVER_DATA (data));
	_tmp0_ = self->priv->_status;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		geary_imap_command_stop_serialisation (self);
		_tmp1_ = geary_imap_command_to_brief_string (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "%s: Server data received when command already complete: %s", _tmp2_, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = self->priv->_response_timer;
	geary_timeout_manager_start (_tmp7_);
}

void
geary_imap_command_data_received (GearyImapCommand* self,
                                  GearyImapServerData* data,
                                  GError** error)
{
	GearyImapCommandClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->data_received) {
		_klass_->data_received (self, data, error);
	}
}

/**
     * Called when a continuation was requested by the server.
     *
     * This will notify the command's literal spinlock so that if
     * {@link send} is waiting to send a literal, it will do so
     * now.
     */
static void
geary_imap_command_real_continuation_requested (GearyImapCommand* self,
                                                GearyImapContinuationResponse* continuation,
                                                GError** error)
{
	GearyImapStatusResponse* _tmp0_;
	GearyNonblockingSpinlock* _tmp5_;
	GearyTimeoutManager* _tmp10_;
	GearyNonblockingSpinlock* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_CONTINUATION_RESPONSE (continuation));
	_tmp0_ = self->priv->_status;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		geary_imap_command_stop_serialisation (self);
		_tmp1_ = geary_imap_command_to_brief_string (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "%s: Continuation requested when command already complete", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = self->priv->literal_spinlock;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		geary_imap_command_stop_serialisation (self);
		_tmp6_ = geary_imap_command_to_brief_string (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "%s: Continuation requested but no literals available", _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = self->priv->_response_timer;
	geary_timeout_manager_start (_tmp10_);
	_tmp11_ = self->priv->literal_spinlock;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
}

void
geary_imap_command_continuation_requested (GearyImapCommand* self,
                                           GearyImapContinuationResponse* continuation,
                                           GError** error)
{
	GearyImapCommandClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->continuation_requested) {
		_klass_->continuation_requested (self, continuation, error);
	}
}

/** Returns the command tag and name for debugging. */
gchar*
geary_imap_command_to_brief_string (GearyImapCommand* self)
{
	GearyImapTag* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_COMMAND (self), NULL);
	_tmp0_ = self->priv->_tag;
	_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_name;
	_tmp4_ = g_strdup_printf ("%s %s", _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

/**
     * Stops any existing serialisation in progress.
     *
     * When this method is called, any non I/O related process
     * blocking the blocking {@link send} must be cancelled.
     */
static void
geary_imap_command_real_stop_serialisation (GearyImapCommand* self)
{
	GCancellable* _tmp0_;
	_tmp0_ = self->priv->literal_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->literal_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

void
geary_imap_command_stop_serialisation (GearyImapCommand* self)
{
	GearyImapCommandClass* _klass_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_klass_ = GEARY_IMAP_COMMAND_GET_CLASS (self);
	if (_klass_->stop_serialisation) {
		_klass_->stop_serialisation (self);
	}
}

static void
geary_imap_command_cancel (GearyImapCommand* self,
                           GError* cause)
{
	GError* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	GearyNonblockingSemaphore* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	g_return_if_fail (cause != NULL);
	geary_imap_command_stop_serialisation (self);
	_tmp0_ = _g_error_copy0 (cause);
	_g_error_free0 (self->priv->cancelled_cause);
	self->priv->cancelled_cause = _tmp0_;
	_tmp1_ = self->priv->_response_timer;
	geary_timeout_manager_reset (_tmp1_);
	_tmp2_ = self->priv->complete_lock;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
}

static void
geary_imap_command_check_has_status (GearyImapCommand* self,
                                     GError** error)
{
	GearyImapStatusResponse* _tmp0_;
	GearyImapStatusResponse* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_tmp0_ = self->priv->_status;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_command_to_brief_string (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "%s: No command response was received", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = self->priv->_status;
	_tmp6_ = geary_imap_status_response_get_is_completion (_tmp5_);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		GearyImapStatusResponse* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GError* _tmp13_;
		GError* _tmp14_;
		_tmp8_ = geary_imap_command_to_brief_string (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_status;
		_tmp11_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_SERVER_ERROR, "%s: Command status response is not a completion: %s", _tmp9_, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
		_inner_error0_ = _tmp14_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
geary_imap_command_on_response_timeout (GearyImapCommand* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	g_return_if_fail (GEARY_IMAP_IS_COMMAND (self));
	_tmp0_ = geary_imap_command_to_brief_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TIMED_OUT, "%s: Command timed out", _tmp1_);
	_tmp3_ = _tmp2_;
	geary_imap_command_cancel (self, _tmp3_);
	_g_error_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_emit (self, geary_imap_command_signals[GEARY_IMAP_COMMAND_RESPONSE_TIMED_OUT_SIGNAL], 0);
}

static void
geary_imap_command_class_init (GearyImapCommandClass * klass,
                               gpointer klass_data)
{
	geary_imap_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapCommand_private_offset);
	((GearyImapCommandClass *) klass)->send = (void (*) (GearyImapCommand*, GearyImapSerializer*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_command_real_send;
	((GearyImapCommandClass *) klass)->send_finish = (void (*) (GearyImapCommand*, GAsyncResult*, GError**)) geary_imap_command_real_send_finish;
	((GearyImapCommandClass *) klass)->send_wait = (void (*) (GearyImapCommand*, GearyImapSerializer*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_command_real_send_wait;
	((GearyImapCommandClass *) klass)->send_wait_finish = (void (*) (GearyImapCommand*, GAsyncResult*, GError**)) geary_imap_command_real_send_wait_finish;
	((GearyImapCommandClass *) klass)->to_string = (gchar* (*) (GearyImapCommand*)) geary_imap_command_real_to_string;
	((GearyImapCommandClass *) klass)->update_response_timer = (void (*) (GearyImapCommand*)) geary_imap_command_real_update_response_timer;
	((GearyImapCommandClass *) klass)->completed = (void (*) (GearyImapCommand*, GearyImapStatusResponse*, GError**)) geary_imap_command_real_completed;
	((GearyImapCommandClass *) klass)->cancelled_before_send = (void (*) (GearyImapCommand*)) geary_imap_command_real_cancelled_before_send;
	((GearyImapCommandClass *) klass)->disconnected = (void (*) (GearyImapCommand*, const gchar*)) geary_imap_command_real_disconnected;
	((GearyImapCommandClass *) klass)->data_received = (void (*) (GearyImapCommand*, GearyImapServerData*, GError**)) geary_imap_command_real_data_received;
	((GearyImapCommandClass *) klass)->continuation_requested = (void (*) (GearyImapCommand*, GearyImapContinuationResponse*, GError**)) geary_imap_command_real_continuation_requested;
	((GearyImapCommandClass *) klass)->stop_serialisation = (void (*) (GearyImapCommand*)) geary_imap_command_real_stop_serialisation;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_command_finalize;
	/**
	     * All IMAP commands are tagged with an identifier assigned by the client.
	     *
	     * Note that this is not immutable.  The general practice is to use an unassigned Tag
	     * up until the {@link Command} is about to be transmitted, at which point a Tag is
	     * assigned.  This allows for all commands to be issued in Tag "order".  This generally makes
	     * tracing network traffic easier.
	     *
	     * @see Tag.get_unassigned
	     * @see assign_tag
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_COMMAND_TAG_PROPERTY, geary_imap_command_properties[GEARY_IMAP_COMMAND_TAG_PROPERTY] = g_param_spec_object ("tag", "tag", "tag", GEARY_IMAP_TYPE_TAG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The name (or "verb") of this command.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_COMMAND_NAME_PROPERTY, geary_imap_command_properties[GEARY_IMAP_COMMAND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Number of seconds to wait for a server response to this command.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_COMMAND_RESPONSE_TIMEOUT_PROPERTY, geary_imap_command_properties[GEARY_IMAP_COMMAND_RESPONSE_TIMEOUT_PROPERTY] = g_param_spec_uint ("response-timeout", "response-timeout", "response-timeout", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The status response for the command, once it has been received. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_COMMAND_STATUS_PROPERTY, geary_imap_command_properties[GEARY_IMAP_COMMAND_STATUS_PROPERTY] = g_param_spec_object ("status", "status", "status", GEARY_IMAP_TYPE_STATUS_RESPONSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A guard to allow cancelling a command before it is sent.
	     *
	     * Since IMAP does not allow commands that have been sent to the
	     * server to be cancelled, cancelling a command before sending it
	     * is the last opportunity to prevent it from being executed. A
	     * command queued to be sent will be sent as long as the
	     * connection it was queued is open and this cancellable is null
	     * or is not cancelled.
	     *
	     * @see Command.Command
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_COMMAND_SHOULD_SEND_PROPERTY, geary_imap_command_properties[GEARY_IMAP_COMMAND_SHOULD_SEND_PROPERTY] = g_param_spec_object ("should-send", "should-send", "should-send", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The command's arguments as parameters.
	     *
	     * Subclassess may append arguments to this before {@link send} is
	     * called, ideally from their constructors.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_COMMAND_ARGS_PROPERTY, geary_imap_command_properties[GEARY_IMAP_COMMAND_ARGS_PROPERTY] = g_param_spec_object ("args", "args", "args", GEARY_IMAP_TYPE_LIST_PARAMETER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Timer used to check for a response within {@link response_timeout}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_COMMAND_RESPONSE_TIMER_PROPERTY, geary_imap_command_properties[GEARY_IMAP_COMMAND_RESPONSE_TIMER_PROPERTY] = g_param_spec_object ("response-timer", "response-timer", "response-timer", GEARY_TYPE_TIMEOUT_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired when the response timeout for this command has been reached.
	     */
	geary_imap_command_signals[GEARY_IMAP_COMMAND_RESPONSE_TIMED_OUT_SIGNAL] = g_signal_new ("response-timed-out", GEARY_IMAP_TYPE_COMMAND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
geary_imap_command_instance_init (GearyImapCommand * self,
                                  gpointer klass)
{
	GearyImapRootParameters* _tmp0_;
	GearyNonblockingSemaphore* _tmp1_;
	self->priv = geary_imap_command_get_instance_private (self);
	self->priv->_response_timeout = GEARY_IMAP_COMMAND_DEFAULT_RESPONSE_TIMEOUT_SEC;
	self->priv->_status = NULL;
	self->priv->_should_send = NULL;
	_tmp0_ = geary_imap_root_parameters_new ();
	self->priv->_args = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter);
	_tmp1_ = geary_nonblocking_semaphore_new (NULL);
	self->priv->complete_lock = _tmp1_;
	self->priv->cancelled_cause = NULL;
	self->priv->literal_spinlock = NULL;
	self->priv->literal_cancellable = NULL;
}

static void
geary_imap_command_finalize (GObject * obj)
{
	GearyImapCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand);
	_g_object_unref0 (self->priv->_tag);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_status);
	_g_object_unref0 (self->priv->_should_send);
	_g_object_unref0 (self->priv->_args);
	_g_object_unref0 (self->priv->_response_timer);
	_g_object_unref0 (self->priv->complete_lock);
	_g_error_free0 (self->priv->cancelled_cause);
	_g_object_unref0 (self->priv->literal_spinlock);
	_g_object_unref0 (self->priv->literal_cancellable);
	G_OBJECT_CLASS (geary_imap_command_parent_class)->finalize (obj);
}

/**
 * A representation of an IMAP command (request).
 *
 * A Command is created by the caller and then submitted to a {@link ClientSession} or
 * {@link ClientConnection} for transmission to the server.  In response, one or more
 * {@link ServerResponse}s are returned, generally zero or more {@link ServerData}s followed by
 * a completion {@link StatusResponse}.  Untagged {@link StatusResponse}s may also be returned,
 * depending on the Command.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-6]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapCommand), 0, (GInstanceInitFunc) geary_imap_command_instance_init, NULL };
	GType geary_imap_command_type_id;
	geary_imap_command_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyImapCommand_private_offset = g_type_add_instance_private (geary_imap_command_type_id, sizeof (GearyImapCommandPrivate));
	return geary_imap_command_type_id;
}

GType
geary_imap_command_get_type (void)
{
	static gsize geary_imap_command_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_command_type_id__once)) {
		GType geary_imap_command_type_id;
		geary_imap_command_type_id = geary_imap_command_get_type_once ();
		g_once_init_leave (&geary_imap_command_type_id__once, geary_imap_command_type_id);
	}
	return geary_imap_command_type_id__once;
}

static void
_vala_geary_imap_command_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GearyImapCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand);
	switch (property_id) {
		case GEARY_IMAP_COMMAND_TAG_PROPERTY:
		g_value_set_object (value, geary_imap_command_get_tag (self));
		break;
		case GEARY_IMAP_COMMAND_NAME_PROPERTY:
		g_value_set_string (value, geary_imap_command_get_name (self));
		break;
		case GEARY_IMAP_COMMAND_RESPONSE_TIMEOUT_PROPERTY:
		g_value_set_uint (value, geary_imap_command_get_response_timeout (self));
		break;
		case GEARY_IMAP_COMMAND_STATUS_PROPERTY:
		g_value_set_object (value, geary_imap_command_get_status (self));
		break;
		case GEARY_IMAP_COMMAND_SHOULD_SEND_PROPERTY:
		g_value_set_object (value, geary_imap_command_get_should_send (self));
		break;
		case GEARY_IMAP_COMMAND_ARGS_PROPERTY:
		g_value_set_object (value, geary_imap_command_get_args (self));
		break;
		case GEARY_IMAP_COMMAND_RESPONSE_TIMER_PROPERTY:
		g_value_set_object (value, geary_imap_command_get_response_timer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_command_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GearyImapCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand);
	switch (property_id) {
		case GEARY_IMAP_COMMAND_TAG_PROPERTY:
		geary_imap_command_set_tag (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_COMMAND_NAME_PROPERTY:
		geary_imap_command_set_name (self, g_value_get_string (value));
		break;
		case GEARY_IMAP_COMMAND_RESPONSE_TIMEOUT_PROPERTY:
		geary_imap_command_set_response_timeout (self, g_value_get_uint (value));
		break;
		case GEARY_IMAP_COMMAND_STATUS_PROPERTY:
		geary_imap_command_set_status (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_COMMAND_SHOULD_SEND_PROPERTY:
		geary_imap_command_set_should_send (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_COMMAND_ARGS_PROPERTY:
		geary_imap_command_set_args (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_COMMAND_RESPONSE_TIMER_PROPERTY:
		geary_imap_command_set_response_timer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

