/* contacts-phones-chunk.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-phones-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contactscore.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_PHONES_CHUNK_0_PROPERTY,
	CONTACTS_PHONES_CHUNK_PROPERTY_NAME_PROPERTY,
	CONTACTS_PHONES_CHUNK_DISPLAY_NAME_PROPERTY,
	CONTACTS_PHONES_CHUNK_ICON_NAME_PROPERTY,
	CONTACTS_PHONES_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_phones_chunk_properties[CONTACTS_PHONES_CHUNK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsPhonesChunkSaveToPersonaData ContactsPhonesChunkSaveToPersonaData;
enum  {
	CONTACTS_PHONE_0_PROPERTY,
	CONTACTS_PHONE_RAW_NUMBER_PROPERTY,
	CONTACTS_PHONE_IS_EMPTY_PROPERTY,
	CONTACTS_PHONE_ICON_NAME_PROPERTY,
	CONTACTS_PHONE_NUM_PROPERTIES
};
static GParamSpec* contacts_phone_properties[CONTACTS_PHONE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsPhonesChunkSaveToPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsPhonesChunk* self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GeeSet* afds;
	GeeSet* _tmp2_;
	FolksPersona* _tmp3_;
	FolksPersona* _tmp4_;
	GError* _inner_error0_;
};

struct _ContactsPhonePrivate {
	gchar* _raw_number;
};

static gpointer contacts_phones_chunk_parent_class = NULL;
static gint ContactsPhone_private_offset;
static gpointer contacts_phone_parent_class = NULL;

static ContactsBinChunkChild* contacts_phones_chunk_real_create_empty_child (ContactsBinChunk* base);
static void contacts_phones_chunk_real_save_to_persona_data_free (gpointer _data);
static void contacts_phones_chunk_real_save_to_persona (ContactsChunk* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean contacts_phones_chunk_real_save_to_persona_co (ContactsPhonesChunkSaveToPersonaData* _data_);
static void contacts_phones_chunk_save_to_persona_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static GObject * contacts_phones_chunk_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static GType contacts_phones_chunk_get_type_once (void);
static void _vala_contacts_phones_chunk_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static gint contacts_phone_real_compare_internal (ContactsBinChunkChild* base,
                                           ContactsBinChunkChild* other);
static FolksAbstractFieldDetails* contacts_phone_real_create_afd (ContactsBinChunkChild* base);
static ContactsBinChunkChild* contacts_phone_real_copy (ContactsBinChunkChild* base);
static GVariant* contacts_phone_real_to_gvariant_internal (ContactsBinChunkChild* base);
static void contacts_phone_real_apply_gvariant (ContactsBinChunkChild* base,
                                         GVariant* variant);
static void contacts_phone_finalize (GObject * obj);
static GType contacts_phone_get_type_once (void);
static void _vala_contacts_phone_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_contacts_phone_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static ContactsBinChunkChild*
contacts_phones_chunk_real_create_empty_child (ContactsBinChunk* base)
{
	ContactsPhonesChunk * self;
	ContactsPhone* _tmp0_;
	ContactsBinChunkChild* result;
	self = (ContactsPhonesChunk*) base;
	_tmp0_ = contacts_phone_new ();
	result = (ContactsBinChunkChild*) _tmp0_;
	return result;
}

static void
contacts_phones_chunk_real_save_to_persona_data_free (gpointer _data)
{
	ContactsPhonesChunkSaveToPersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsPhonesChunkSaveToPersonaData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_phones_chunk_real_save_to_persona (ContactsChunk* base,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	ContactsPhonesChunk * self;
	ContactsPhonesChunkSaveToPersonaData* _data_;
	ContactsPhonesChunk* _tmp0_;
	self = (ContactsPhonesChunk*) base;
	_data_ = g_slice_new0 (ContactsPhonesChunkSaveToPersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_phones_chunk_real_save_to_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_phones_chunk_real_save_to_persona_co (_data_);
}

static void
contacts_phones_chunk_save_to_persona_finish (ContactsChunk* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	ContactsPhonesChunkSaveToPersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_phones_chunk_save_to_persona_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	ContactsPhonesChunkSaveToPersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_phones_chunk_real_save_to_persona_co (_data_);
}

static gboolean
contacts_phones_chunk_real_save_to_persona_co (ContactsPhonesChunkSaveToPersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, FOLKS_TYPE_PHONE_DETAILS), "this.persona is PhoneDetails", FALSE);
	_data_->_tmp2_ = contacts_bin_chunk_get_abstract_field_details ((ContactsBinChunk*) _data_->self);
	_data_->afds = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_SET, GeeSet);
	_data_->_tmp3_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	folks_phone_details_change_phone_numbers (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails), _data_->afds, contacts_phones_chunk_save_to_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_phone_details_change_phone_numbers_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->afds);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->afds);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsPhonesChunk*
contacts_phones_chunk_construct (GType object_type)
{
	ContactsPhonesChunk * self = NULL;
	self = (ContactsPhonesChunk*) contacts_bin_chunk_construct (object_type);
	return self;
}

ContactsPhonesChunk*
contacts_phones_chunk_new (void)
{
	return contacts_phones_chunk_construct (CONTACTS_TYPE_PHONES_CHUNK);
}

static const gchar*
contacts_phones_chunk_real_get_property_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsPhonesChunk* self;
	self = (ContactsPhonesChunk*) base;
	result = "phone-numbers";
	return result;
}

static const gchar*
contacts_phones_chunk_real_get_display_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsPhonesChunk* self;
	self = (ContactsPhonesChunk*) base;
	result = _ ("Phone numbers");
	return result;
}

static const gchar*
contacts_phones_chunk_real_get_icon_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsPhonesChunk* self;
	self = (ContactsPhonesChunk*) base;
	result = "phone-symbolic";
	return result;
}

static GObject *
contacts_phones_chunk_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsPhonesChunk * self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	parent_class = G_OBJECT_CLASS (contacts_phones_chunk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_PHONES_CHUNK, ContactsPhonesChunk);
	_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FolksPersona* _tmp2_;
		FolksPersona* _tmp3_;
		FolksPhoneDetails* phone_details = NULL;
		FolksPersona* _tmp4_;
		FolksPersona* _tmp5_;
		_tmp2_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp3_ = _tmp2_;
		_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, FOLKS_TYPE_PHONE_DETAILS), "persona is PhoneDetails");
		_tmp4_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp5_ = _tmp4_;
		phone_details = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails);
		{
			GeeIterator* _phone_field_it = NULL;
			FolksPhoneDetails* _tmp6_;
			GeeSet* _tmp7_;
			GeeSet* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp6_ = phone_details;
			_tmp7_ = folks_phone_details_get_phone_numbers (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_phone_field_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				FolksPhoneFieldDetails* phone_field = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				ContactsPhone* phone = NULL;
				FolksPhoneFieldDetails* _tmp13_;
				ContactsPhone* _tmp14_;
				ContactsPhone* _tmp15_;
				_tmp10_ = _phone_field_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _phone_field_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				phone_field = (FolksPhoneFieldDetails*) _tmp12_;
				_tmp13_ = phone_field;
				_tmp14_ = contacts_phone_new_from_field_details (_tmp13_);
				phone = _tmp14_;
				_tmp15_ = phone;
				contacts_bin_chunk_add_child ((ContactsBinChunk*) self, (ContactsBinChunkChild*) _tmp15_);
				_g_object_unref0 (phone);
				_g_object_unref0 (phone_field);
			}
			_g_object_unref0 (_phone_field_it);
		}
	}
	contacts_bin_chunk_finish_initialization ((ContactsBinChunk*) self);
	return obj;
}

static void
contacts_phones_chunk_class_init (ContactsPhonesChunkClass * klass,
                                  gpointer klass_data)
{
	contacts_phones_chunk_parent_class = g_type_class_peek_parent (klass);
	((ContactsBinChunkClass *) klass)->create_empty_child = (ContactsBinChunkChild* (*) (ContactsBinChunk*)) contacts_phones_chunk_real_create_empty_child;
	((ContactsChunkClass *) klass)->save_to_persona = (void (*) (ContactsChunk*, GAsyncReadyCallback, gpointer)) contacts_phones_chunk_real_save_to_persona;
	((ContactsChunkClass *) klass)->save_to_persona_finish = (void (*) (ContactsChunk*, GAsyncResult*, GError**)) contacts_phones_chunk_save_to_persona_finish;
	CONTACTS_CHUNK_CLASS (klass)->get_property_name = (const gchar* (*) (ContactsChunk*)) contacts_phones_chunk_real_get_property_name;
	CONTACTS_CHUNK_CLASS (klass)->get_display_name = (const gchar* (*) (ContactsChunk*)) contacts_phones_chunk_real_get_display_name;
	CONTACTS_CHUNK_CLASS (klass)->get_icon_name = (const gchar* (*) (ContactsChunk*)) contacts_phones_chunk_real_get_icon_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_phones_chunk_get_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_phones_chunk_constructor;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PHONES_CHUNK_PROPERTY_NAME_PROPERTY, contacts_phones_chunk_properties[CONTACTS_PHONES_CHUNK_PROPERTY_NAME_PROPERTY] = g_param_spec_string ("property-name", "property-name", "property-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PHONES_CHUNK_DISPLAY_NAME_PROPERTY, contacts_phones_chunk_properties[CONTACTS_PHONES_CHUNK_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PHONES_CHUNK_ICON_NAME_PROPERTY, contacts_phones_chunk_properties[CONTACTS_PHONES_CHUNK_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_phones_chunk_instance_init (ContactsPhonesChunk * self,
                                     gpointer klass)
{
}

/**
 * A {@link Chunk} that represents the phone numbers of a contact (similar to
 * {@link Folks.PhoneDetails}. Each element is a {@link Phone}.
 */
 G_GNUC_NO_INLINE static GType
contacts_phones_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsPhonesChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_phones_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsPhonesChunk), 0, (GInstanceInitFunc) contacts_phones_chunk_instance_init, NULL };
	GType contacts_phones_chunk_type_id;
	contacts_phones_chunk_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK, "ContactsPhonesChunk", &g_define_type_info, 0);
	return contacts_phones_chunk_type_id;
}

GType
contacts_phones_chunk_get_type (void)
{
	static volatile gsize contacts_phones_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_phones_chunk_type_id__once)) {
		GType contacts_phones_chunk_type_id;
		contacts_phones_chunk_type_id = contacts_phones_chunk_get_type_once ();
		g_once_init_leave (&contacts_phones_chunk_type_id__once, contacts_phones_chunk_type_id);
	}
	return contacts_phones_chunk_type_id__once;
}

static void
_vala_contacts_phones_chunk_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsPhonesChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_PHONES_CHUNK, ContactsPhonesChunk);
	switch (property_id) {
		case CONTACTS_PHONES_CHUNK_PROPERTY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_property_name ((ContactsChunk*) self));
		break;
		case CONTACTS_PHONES_CHUNK_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_display_name ((ContactsChunk*) self));
		break;
		case CONTACTS_PHONES_CHUNK_ICON_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_icon_name ((ContactsChunk*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_phone_get_instance_private (ContactsPhone* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsPhone_private_offset);
}

ContactsPhone*
contacts_phone_construct (GType object_type)
{
	ContactsPhone * self = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	self = (ContactsPhone*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, (GeeMultiMap*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp3_ = _tmp2_;
	gee_multi_map_set (_tmp3_, "type", "CELL");
	return self;
}

ContactsPhone*
contacts_phone_new (void)
{
	return contacts_phone_construct (CONTACTS_TYPE_PHONE);
}

ContactsPhone*
contacts_phone_construct_from_field_details (GType object_type,
                                             FolksPhoneFieldDetails* phone_field)
{
	ContactsPhone * self = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	g_return_val_if_fail (phone_field != NULL, NULL);
	self = (ContactsPhone*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) phone_field);
	_tmp1_ = _tmp0_;
	contacts_phone_set_raw_number (self, (const gchar*) _tmp1_);
	_tmp2_ = folks_abstract_field_details_get_parameters ((FolksAbstractFieldDetails*) phone_field);
	_tmp3_ = _tmp2_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, _tmp3_);
	return self;
}

ContactsPhone*
contacts_phone_new_from_field_details (FolksPhoneFieldDetails* phone_field)
{
	return contacts_phone_construct_from_field_details (CONTACTS_TYPE_PHONE, phone_field);
}

static gint
contacts_phone_real_compare_internal (ContactsBinChunkChild* base,
                                      ContactsBinChunkChild* other)
{
	ContactsPhone * self;
	ContactsPhone* other_phone = NULL;
	gint nr_cmp = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ContactsPhone* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint result;
	self = (ContactsPhone*) base;
	g_return_val_if_fail (other != NULL, 0);
	_vala_return_val_if_fail (CONTACTS_IS_PHONE (other), "other is Phone", 0);
	other_phone = G_TYPE_CHECK_INSTANCE_CAST (other, CONTACTS_TYPE_PHONE, ContactsPhone);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = contacts_phone_get_raw_number (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = other_phone;
	_tmp4_ = contacts_phone_get_raw_number (_tmp3_);
	_tmp5_ = _tmp4_;
	nr_cmp = _tmp0_ (_tmp2_, _tmp5_);
	if (nr_cmp != 0) {
		result = nr_cmp;
		return result;
	}
	result = contacts_bin_chunk_child_dummy_compare_parameters ((ContactsBinChunkChild*) self, other);
	return result;
}

/**
   * Returns the TypeDescriptor that describes the type of phone number
   * (for example mobile, work, fax, ...)
   */
ContactsTypeDescriptor*
contacts_phone_get_phone_type (ContactsPhone* self)
{
	ContactsTypeSet* _tmp0_;
	ContactsTypeSet* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	ContactsTypeDescriptor* _tmp4_;
	ContactsTypeDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_typeset_get_phone ();
	_tmp1_ = _tmp0_;
	_tmp2_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_typeset_lookup_by_parameters (_tmp1_, _tmp3_, NULL);
	result = _tmp4_;
	return result;
}

static FolksAbstractFieldDetails*
contacts_phone_real_create_afd (ContactsBinChunkChild* base)
{
	ContactsPhone * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	FolksPhoneFieldDetails* _tmp6_;
	FolksAbstractFieldDetails* result;
	self = (ContactsPhone*) base;
	_tmp0_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = contacts_phone_get_raw_number (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_phone_field_details_new (_tmp3_, _tmp5_);
	result = (FolksAbstractFieldDetails*) _tmp6_;
	return result;
}

static ContactsBinChunkChild*
contacts_phone_real_copy (ContactsBinChunkChild* base)
{
	ContactsPhone * self;
	ContactsPhone* phone = NULL;
	ContactsPhone* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ContactsBinChunkChild* result;
	self = (ContactsPhone*) base;
	_tmp0_ = contacts_phone_new ();
	phone = _tmp0_;
	_tmp1_ = contacts_phone_get_raw_number (self);
	_tmp2_ = _tmp1_;
	contacts_phone_set_raw_number (phone, _tmp2_);
	contacts_bin_chunk_child_copy_parameters ((ContactsBinChunkChild*) self, (ContactsBinChunkChild*) phone);
	result = (ContactsBinChunkChild*) phone;
	return result;
}

static GVariant*
contacts_phone_real_to_gvariant_internal (ContactsBinChunkChild* base)
{
	ContactsPhone * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* result;
	self = (ContactsPhone*) base;
	_tmp0_ = contacts_phone_get_raw_number (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = contacts_bin_chunk_child_parameters_to_gvariant ((ContactsBinChunkChild*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new ("(sv)", _tmp1_, _tmp3_, NULL);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static void
contacts_phone_real_apply_gvariant (ContactsBinChunkChild* base,
                                    GVariant* variant)
{
	ContactsPhone * self;
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	gchar* phone_nr = NULL;
	GVariant* params_variant = NULL;
	gchar* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	self = (ContactsPhone*) base;
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new ("(sv)");
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), "variant.get_type ().equal (new VariantType (\"(sv)\"))");
	g_variant_get (variant, "(sv)", &_tmp3_, &_tmp4_, NULL);
	_g_free0 (phone_nr);
	phone_nr = _tmp3_;
	_g_variant_unref0 (params_variant);
	params_variant = _tmp4_;
	_g_variant_type_free0 (_tmp2_);
	contacts_phone_set_raw_number (self, phone_nr);
	contacts_bin_chunk_child_apply_gvariant_parameters ((ContactsBinChunkChild*) self, params_variant);
	_g_variant_unref0 (params_variant);
	_g_free0 (phone_nr);
}

const gchar*
contacts_phone_get_raw_number (ContactsPhone* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_raw_number;
	result = _tmp0_;
	return result;
}

void
contacts_phone_set_raw_number (ContactsPhone* self,
                               const gchar* value)
{
	g_return_if_fail (self != NULL);
	contacts_bin_chunk_child_change_string_prop ((ContactsBinChunkChild*) self, "raw-number", &self->priv->_raw_number, value);
	g_object_notify_by_pspec ((GObject *) self, contacts_phone_properties[CONTACTS_PHONE_RAW_NUMBER_PROPERTY]);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
contacts_phone_real_get_is_empty (ContactsBinChunkChild* base)
{
	gboolean result;
	ContactsPhone* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	self = (ContactsPhone*) base;
	_tmp0_ = contacts_phone_get_raw_number (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static const gchar*
contacts_phone_real_get_icon_name (ContactsBinChunkChild* base)
{
	const gchar* result;
	ContactsPhone* self;
	self = (ContactsPhone*) base;
	result = "phone-symbolic";
	return result;
}

static void
contacts_phone_class_init (ContactsPhoneClass * klass,
                           gpointer klass_data)
{
	contacts_phone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsPhone_private_offset);
	((ContactsBinChunkChildClass *) klass)->compare_internal = (gint (*) (ContactsBinChunkChild*, ContactsBinChunkChild*)) contacts_phone_real_compare_internal;
	((ContactsBinChunkChildClass *) klass)->create_afd = (FolksAbstractFieldDetails* (*) (ContactsBinChunkChild*)) contacts_phone_real_create_afd;
	((ContactsBinChunkChildClass *) klass)->copy = (ContactsBinChunkChild* (*) (ContactsBinChunkChild*)) contacts_phone_real_copy;
	((ContactsBinChunkChildClass *) klass)->to_gvariant_internal = (GVariant* (*) (ContactsBinChunkChild*)) contacts_phone_real_to_gvariant_internal;
	((ContactsBinChunkChildClass *) klass)->apply_gvariant = (void (*) (ContactsBinChunkChild*, GVariant*)) contacts_phone_real_apply_gvariant;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_is_empty = (gboolean (*) (ContactsBinChunkChild*)) contacts_phone_real_get_is_empty;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_icon_name = (const gchar* (*) (ContactsBinChunkChild*)) contacts_phone_real_get_icon_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_phone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_phone_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_phone_finalize;
	/**
	   * The "raw" phone number as inputted by a user or from a contact. It may or
	   * may not be an actual valid phone number.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PHONE_RAW_NUMBER_PROPERTY, contacts_phone_properties[CONTACTS_PHONE_RAW_NUMBER_PROPERTY] = g_param_spec_string ("raw-number", "raw-number", "raw-number", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PHONE_IS_EMPTY_PROPERTY, contacts_phone_properties[CONTACTS_PHONE_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PHONE_ICON_NAME_PROPERTY, contacts_phone_properties[CONTACTS_PHONE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_phone_instance_init (ContactsPhone * self,
                              gpointer klass)
{
	gchar* _tmp0_;
	self->priv = contacts_phone_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_raw_number = _tmp0_;
}

static void
contacts_phone_finalize (GObject * obj)
{
	ContactsPhone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_PHONE, ContactsPhone);
	_g_free0 (self->priv->_raw_number);
	G_OBJECT_CLASS (contacts_phone_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_phone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsPhoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_phone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsPhone), 0, (GInstanceInitFunc) contacts_phone_instance_init, NULL };
	GType contacts_phone_type_id;
	contacts_phone_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK_CHILD, "ContactsPhone", &g_define_type_info, 0);
	ContactsPhone_private_offset = g_type_add_instance_private (contacts_phone_type_id, sizeof (ContactsPhonePrivate));
	return contacts_phone_type_id;
}

GType
contacts_phone_get_type (void)
{
	static volatile gsize contacts_phone_type_id__once = 0;
	if (g_once_init_enter (&contacts_phone_type_id__once)) {
		GType contacts_phone_type_id;
		contacts_phone_type_id = contacts_phone_get_type_once ();
		g_once_init_leave (&contacts_phone_type_id__once, contacts_phone_type_id);
	}
	return contacts_phone_type_id__once;
}

static void
_vala_contacts_phone_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	ContactsPhone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_PHONE, ContactsPhone);
	switch (property_id) {
		case CONTACTS_PHONE_RAW_NUMBER_PROPERTY:
		g_value_set_string (value, contacts_phone_get_raw_number (self));
		break;
		case CONTACTS_PHONE_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self));
		break;
		case CONTACTS_PHONE_ICON_NAME_PROPERTY:
		g_value_set_string (value, contacts_bin_chunk_child_get_icon_name ((ContactsBinChunkChild*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_phone_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ContactsPhone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_PHONE, ContactsPhone);
	switch (property_id) {
		case CONTACTS_PHONE_RAW_NUMBER_PROPERTY:
		contacts_phone_set_raw_number (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

