/* contacts-setup-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-setup-window.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "contacts.h"
#include <glib.h>
#include <config.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <folks/folks-eds.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_SETUP_WINDOW (contacts_setup_window_get_type ())
#define CONTACTS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindow))
#define CONTACTS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))
#define CONTACTS_IS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_IS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_SETUP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))

typedef struct _ContactsSetupWindow ContactsSetupWindow;
typedef struct _ContactsSetupWindowClass ContactsSetupWindowClass;
typedef struct _ContactsSetupWindowPrivate ContactsSetupWindowPrivate;

#define CONTACTS_TYPE_ACCOUNTS_LIST (contacts_accounts_list_get_type ())
#define CONTACTS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsList))
#define CONTACTS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))
#define CONTACTS_IS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_IS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_ACCOUNTS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))

typedef struct _ContactsAccountsList ContactsAccountsList;
typedef struct _ContactsAccountsListClass ContactsAccountsListClass;
enum  {
	CONTACTS_SETUP_WINDOW_0_PROPERTY,
	CONTACTS_SETUP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* contacts_setup_window_properties[CONTACTS_SETUP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _Block32Data Block32Data;
enum  {
	CONTACTS_SETUP_WINDOW_SETUP_DONE_SIGNAL,
	CONTACTS_SETUP_WINDOW_NUM_SIGNALS
};
static guint contacts_setup_window_signals[CONTACTS_SETUP_WINDOW_NUM_SIGNALS] = {0};

struct _ContactsSetupWindow {
	AdwApplicationWindow parent_instance;
	ContactsSetupWindowPrivate * priv;
};

struct _ContactsSetupWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ContactsSetupWindowPrivate {
	AdwClamp* clamp;
	GtkButton* setup_done_button;
	ContactsAccountsList* accounts_list;
};

struct _Block32Data {
	int _ref_count_;
	ContactsSetupWindow* self;
	ContactsStore* store;
};

static gint ContactsSetupWindow_private_offset;
static gpointer contacts_setup_window_parent_class = NULL;

VALA_EXTERN GType contacts_setup_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSetupWindow, g_object_unref)
VALA_EXTERN GType contacts_accounts_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAccountsList, g_object_unref)
VALA_EXTERN GType contacts_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsApp, g_object_unref)
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_new (ContactsApp* app,
                                                ContactsStore* store);
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_construct (GType object_type,
                                                      ContactsApp* app,
                                                      ContactsStore* store);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
VALA_EXTERN ContactsAccountsList* contacts_accounts_list_new (ContactsStore* contacts_store);
VALA_EXTERN ContactsAccountsList* contacts_accounts_list_construct (GType object_type,
                                                        ContactsStore* contacts_store);
static void __lambda56_ (ContactsSetupWindow* self,
                  GObject* obj,
                  GParamSpec* pspec);
VALA_EXTERN FolksPersonaStore* contacts_accounts_list_get_selected_store (ContactsAccountsList* self);
static void ___lambda56__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda57_ (Block32Data* _data32_);
static gboolean ___lambda57__gsource_func (gpointer self);
static void __lambda58_ (ContactsSetupWindow* self);
static void ___lambda58__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void contacts_setup_window_finalize (GObject * obj);
static GType contacts_setup_window_get_type_once (void);

static inline gpointer
contacts_setup_window_get_instance_private (ContactsSetupWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsSetupWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		ContactsSetupWindow* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->store);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
__lambda56_ (ContactsSetupWindow* self,
             GObject* obj,
             GParamSpec* pspec)
{
	GtkButton* _tmp0_;
	ContactsAccountsList* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->setup_done_button;
	_tmp1_ = self->priv->accounts_list;
	_tmp2_ = contacts_accounts_list_get_selected_store (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_ != NULL);
}

static void
___lambda56__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda56_ ((ContactsSetupWindow*) self, _sender, pspec);
}

static gboolean
__lambda57_ (Block32Data* _data32_)
{
	ContactsSetupWindow* self;
	GListModel* _tmp0_;
	GListModel* _tmp1_;
	gboolean result;
	self = _data32_->self;
	_tmp0_ = contacts_store_get_address_books (_data32_->store);
	_tmp1_ = _tmp0_;
	if (g_list_model_get_n_items (_tmp1_) == ((guint) 0)) {
		g_warning ("contacts-setup-window.vala:47: No address books were found on the syst" \
"em. Are you sure evolution-data-server is running?");
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda57__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda57_ (self);
	return result;
}

static void
__lambda58_ (ContactsSetupWindow* self)
{
	ContactsAccountsList* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	_tmp0_ = self->priv->accounts_list;
	_tmp1_ = contacts_accounts_list_get_selected_store (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, contacts_setup_window_signals[CONTACTS_SETUP_WINDOW_SETUP_DONE_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
}

static void
___lambda58__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda58_ ((ContactsSetupWindow*) self);
}

ContactsSetupWindow*
contacts_setup_window_construct (GType object_type,
                                 ContactsApp* app,
                                 ContactsStore* store)
{
	ContactsSetupWindow * self = NULL;
	Block32Data* _data32_;
	ContactsStore* _tmp0_;
	ContactsAccountsList* _tmp1_;
	AdwClamp* _tmp2_;
	ContactsAccountsList* _tmp3_;
	ContactsAccountsList* _tmp4_;
	GtkButton* _tmp5_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (store);
	_g_object_unref0 (_data32_->store);
	_data32_->store = _tmp0_;
	self = (ContactsSetupWindow*) g_object_new (object_type, "application", app, "icon-name", APP_ID, NULL);
	_data32_->self = g_object_ref (self);
	_tmp1_ = contacts_accounts_list_new (_data32_->store);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->accounts_list);
	self->priv->accounts_list = _tmp1_;
	_tmp2_ = self->priv->clamp;
	_tmp3_ = self->priv->accounts_list;
	adw_clamp_set_child (_tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->accounts_list;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::selected-store", (GCallback) ___lambda56__g_object_notify, self, 0);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda57__gsource_func, block32_data_ref (_data32_), block32_data_unref);
	_tmp5_ = self->priv->setup_done_button;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) ___lambda58__gtk_button_clicked, self, 0);
	if (g_strcmp0 (PROFILE, "development") == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	block32_data_unref (_data32_);
	_data32_ = NULL;
	return self;
}

ContactsSetupWindow*
contacts_setup_window_new (ContactsApp* app,
                           ContactsStore* store)
{
	return contacts_setup_window_construct (CONTACTS_TYPE_SETUP_WINDOW, app, store);
}

static void
contacts_setup_window_class_init (ContactsSetupWindowClass * klass,
                                  gpointer klass_data)
{
	contacts_setup_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsSetupWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contacts_setup_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-setup-window.ui");
	/**
	   * Fired after the user has successfully performed the setup proess.
	   */
	contacts_setup_window_signals[CONTACTS_SETUP_WINDOW_SETUP_DONE_SIGNAL] = g_signal_new ("setup-done", CONTACTS_TYPE_SETUP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EDSF_TYPE_PERSONA_STORE);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clamp", FALSE, ContactsSetupWindow_private_offset + G_STRUCT_OFFSET (ContactsSetupWindowPrivate, clamp));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_done_button", FALSE, ContactsSetupWindow_private_offset + G_STRUCT_OFFSET (ContactsSetupWindowPrivate, setup_done_button));
}

static void
contacts_setup_window_instance_init (ContactsSetupWindow * self,
                                     gpointer klass)
{
	self->priv = contacts_setup_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_setup_window_finalize (GObject * obj)
{
	ContactsSetupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindow);
	_g_object_unref0 (self->priv->accounts_list);
	G_OBJECT_CLASS (contacts_setup_window_parent_class)->finalize (obj);
}

/**
 * The SetupWindow is the window that is shown to the user when they run
 * Contacts for the first time. It asks the user to setup a primary address
 * book.
 */
 G_GNUC_NO_INLINE static GType
contacts_setup_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsSetupWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_setup_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsSetupWindow), 0, (GInstanceInitFunc) contacts_setup_window_instance_init, NULL };
	GType contacts_setup_window_type_id;
	contacts_setup_window_type_id = g_type_register_static (adw_application_window_get_type (), "ContactsSetupWindow", &g_define_type_info, 0);
	ContactsSetupWindow_private_offset = g_type_add_instance_private (contacts_setup_window_type_id, sizeof (ContactsSetupWindowPrivate));
	return contacts_setup_window_type_id;
}

GType
contacts_setup_window_get_type (void)
{
	static volatile gsize contacts_setup_window_type_id__once = 0;
	if (g_once_init_enter (&contacts_setup_window_type_id__once)) {
		GType contacts_setup_window_type_id;
		contacts_setup_window_type_id = contacts_setup_window_get_type_once ();
		g_once_init_leave (&contacts_setup_window_type_id__once, contacts_setup_window_type_id);
	}
	return contacts_setup_window_type_id__once;
}

