/* game-model.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-model.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;
typedef struct _GamesGameModelPrivate GamesGameModelPrivate;
typedef enum  {
	GAMES_GAME_MODEL_SORT_TYPE_BY_NAME,
	GAMES_GAME_MODEL_SORT_TYPE_BY_LAST_PLAYED
} GamesGameModelSortType;

#define GAMES_GAME_MODEL_TYPE_SORT_TYPE (games_game_model_sort_type_get_type ())
enum  {
	GAMES_GAME_MODEL_0_PROPERTY,
	GAMES_GAME_MODEL_SORT_TYPE_PROPERTY,
	GAMES_GAME_MODEL_NUM_PROPERTIES
};
static GParamSpec* games_game_model_properties[GAMES_GAME_MODEL_NUM_PROPERTIES];
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
enum  {
	GAMES_GAME_MODEL_GAME_ADDED_SIGNAL,
	GAMES_GAME_MODEL_GAME_REMOVED_SIGNAL,
	GAMES_GAME_MODEL_NUM_SIGNALS
};
static guint games_game_model_signals[GAMES_GAME_MODEL_NUM_SIGNALS] = {0};

struct _GamesGameModel {
	GObject parent_instance;
	GamesGameModelPrivate * priv;
	gboolean always_replace;
};

struct _GamesGameModelClass {
	GObjectClass parent_class;
};

struct _GamesGameModelPrivate {
	GSequence* sequence;
	gint n_games;
	GCompareDataFunc compare_func;
	gpointer compare_func_target;
	GDestroyNotify compare_func_target_destroy_notify;
	GamesGameModelSortType _sort_type;
};

static gint GamesGameModel_private_offset;
static gpointer games_game_model_parent_class = NULL;
static GListModelInterface * games_game_model_g_list_model_parent_iface = NULL;

VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_model_sort_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GCompareDataFunc games_game_model_sort_type_get_sort_function (GamesGameModelSortType self,
                                                               gpointer* result_target,
                                                               GDestroyNotify* result_target_destroy_notify);
static gint _games_game_compare_gcompare_data_func (gconstpointer a,
                                             gconstpointer b,
                                             gpointer self);
static gint _games_game_compare_by_date_time_gcompare_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self);
static GObject* games_game_model_real_get_item (GListModel* base,
                                         guint position);
static GType games_game_model_real_get_item_type (GListModel* base);
static guint games_game_model_real_get_n_items (GListModel* base);
VALA_EXTERN void games_game_model_add_game (GamesGameModel* self,
                                GamesGame* game);
VALA_EXTERN void games_game_model_replace_game (GamesGameModel* self,
                                    GamesGame* game,
                                    GamesGame* prev_game);
VALA_EXTERN void games_game_model_remove_game (GamesGameModel* self,
                                   GamesGame* game);
VALA_EXTERN GamesGameModelSortType games_game_model_get_sort_type (GamesGameModel* self);
static GSequenceIter* games_game_model_get_game_iter (GamesGameModel* self,
                                               GamesGame* game);
VALA_EXTERN GamesGameModel* games_game_model_new (void);
VALA_EXTERN GamesGameModel* games_game_model_construct (GType object_type);
VALA_EXTERN void games_game_model_set_sort_type (GamesGameModel* self,
                                     GamesGameModelSortType value);
static GObject * games_game_model_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void games_game_model_finalize (GObject * obj);
static GType games_game_model_get_type_once (void);
static void _vala_games_game_model_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_games_game_model_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
games_game_model_get_instance_private (GamesGameModel* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGameModel_private_offset);
}

static gint
_games_game_compare_gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self)
{
	gint result;
	result = games_game_compare ((GamesGame*) a, (GamesGame*) b);
	return result;
}

static gint
_games_game_compare_by_date_time_gcompare_data_func (gconstpointer a,
                                                     gconstpointer b,
                                                     gpointer self)
{
	gint result;
	result = games_game_compare_by_date_time ((GamesGame*) a, (GamesGame*) b);
	return result;
}

GCompareDataFunc
games_game_model_sort_type_get_sort_function (GamesGameModelSortType self,
                                              gpointer* result_target,
                                              GDestroyNotify* result_target_destroy_notify)
{
	GCompareDataFunc result;
	switch (self) {
		case GAMES_GAME_MODEL_SORT_TYPE_BY_NAME:
		{
			GCompareDataFunc _tmp0_;
			gpointer _tmp0__target;
			GDestroyNotify _tmp0__target_destroy_notify;
			_tmp0_ = _games_game_compare_gcompare_data_func;
			_tmp0__target = NULL;
			_tmp0__target_destroy_notify = NULL;
			*result_target = _tmp0__target;
			*result_target_destroy_notify = _tmp0__target_destroy_notify;
			result = _tmp0_;
			return result;
		}
		case GAMES_GAME_MODEL_SORT_TYPE_BY_LAST_PLAYED:
		{
			GCompareDataFunc _tmp1_;
			gpointer _tmp1__target;
			GDestroyNotify _tmp1__target_destroy_notify;
			_tmp1_ = _games_game_compare_by_date_time_gcompare_data_func;
			_tmp1__target = NULL;
			_tmp1__target_destroy_notify = NULL;
			*result_target = _tmp1__target;
			*result_target_destroy_notify = _tmp1__target_destroy_notify;
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
games_game_model_sort_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_GAME_MODEL_SORT_TYPE_BY_NAME, "GAMES_GAME_MODEL_SORT_TYPE_BY_NAME", "by-name"}, {GAMES_GAME_MODEL_SORT_TYPE_BY_LAST_PLAYED, "GAMES_GAME_MODEL_SORT_TYPE_BY_LAST_PLAYED", "by-last-played"}, {0, NULL, NULL}};
	GType games_game_model_sort_type_type_id;
	games_game_model_sort_type_type_id = g_enum_register_static ("GamesGameModelSortType", values);
	return games_game_model_sort_type_type_id;
}

GType
games_game_model_sort_type_get_type (void)
{
	static volatile gsize games_game_model_sort_type_type_id__once = 0;
	if (g_once_init_enter (&games_game_model_sort_type_type_id__once)) {
		GType games_game_model_sort_type_type_id;
		games_game_model_sort_type_type_id = games_game_model_sort_type_get_type_once ();
		g_once_init_leave (&games_game_model_sort_type_type_id__once, games_game_model_sort_type_type_id);
	}
	return games_game_model_sort_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject*
games_game_model_real_get_item (GListModel* base,
                                guint position)
{
	GamesGameModel * self;
	GSequenceIter* iter = NULL;
	GSequence* _tmp0_;
	GSequenceIter* _tmp1_;
	gconstpointer _tmp2_;
	GObject* _tmp3_;
	GObject* result;
	self = (GamesGameModel*) base;
	_tmp0_ = self->priv->sequence;
	_tmp1_ = g_sequence_get_iter_at_pos (_tmp0_, (gint) position);
	iter = _tmp1_;
	_tmp2_ = g_sequence_get (iter);
	_tmp3_ = _g_object_ref0 ((GObject*) ((GamesGame*) _tmp2_));
	result = _tmp3_;
	return result;
}

static GType
games_game_model_real_get_item_type (GListModel* base)
{
	GamesGameModel * self;
	GType result;
	self = (GamesGameModel*) base;
	result = GAMES_TYPE_GAME;
	return result;
}

static guint
games_game_model_real_get_n_items (GListModel* base)
{
	GamesGameModel * self;
	guint result;
	self = (GamesGameModel*) base;
	result = (guint) self->priv->n_games;
	return result;
}

void
games_game_model_add_game (GamesGameModel* self,
                           GamesGame* game)
{
	GSequenceIter* iter = NULL;
	GSequence* _tmp0_;
	GamesGame* _tmp1_;
	GCompareDataFunc _tmp2_;
	gpointer _tmp2__target;
	GSequenceIter* _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->sequence;
	_tmp1_ = _g_object_ref0 (game);
	_tmp2_ = self->priv->compare_func;
	_tmp2__target = self->priv->compare_func_target;
	_tmp3_ = g_sequence_insert_sorted (_tmp0_, _tmp1_, _tmp2_, _tmp2__target);
	iter = _tmp3_;
	_tmp4_ = self->priv->n_games;
	self->priv->n_games = _tmp4_ + 1;
	g_list_model_items_changed ((GListModel*) self, (guint) g_sequence_iter_get_position (iter), (guint) 0, (guint) 1);
	g_signal_emit (self, games_game_model_signals[GAMES_GAME_MODEL_GAME_ADDED_SIGNAL], 0, game);
}

void
games_game_model_replace_game (GamesGameModel* self,
                               GamesGame* game,
                               GamesGame* prev_game)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (prev_game != NULL);
	_tmp1_ = games_game_get_name (prev_game);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_game_get_name (game);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->always_replace;
	}
	if (_tmp0_) {
		games_game_model_remove_game (self, prev_game);
		games_game_model_add_game (self, game);
		return;
	}
	g_signal_emit_by_name (prev_game, "replaced", game);
}

void
games_game_model_remove_game (GamesGameModel* self,
                              GamesGame* game)
{
	GSequenceIter* iter = NULL;
	GamesGameModelSortType _tmp0_;
	GamesGameModelSortType _tmp1_;
	GSequenceIter* _tmp6_;
	GSequenceIter* _tmp7_;
	gint pos = 0;
	GSequenceIter* _tmp8_;
	GSequenceIter* _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	iter = NULL;
	_tmp0_ = games_game_model_get_sort_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GAMES_GAME_MODEL_SORT_TYPE_BY_LAST_PLAYED) {
		GSequenceIter* _tmp2_;
		_tmp2_ = games_game_model_get_game_iter (self, game);
		iter = _tmp2_;
	} else {
		GSequence* _tmp3_;
		GCompareDataFunc _tmp4_;
		gpointer _tmp4__target;
		GSequenceIter* _tmp5_;
		_tmp3_ = self->priv->sequence;
		_tmp4_ = self->priv->compare_func;
		_tmp4__target = self->priv->compare_func_target;
		_tmp5_ = g_sequence_lookup (_tmp3_, game, _tmp4_, _tmp4__target);
		iter = _tmp5_;
	}
	_tmp6_ = iter;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = iter;
	if (_tmp7_ == NULL) {
		return;
	}
	_tmp8_ = iter;
	pos = g_sequence_iter_get_position (_tmp8_);
	_tmp9_ = iter;
	g_sequence_remove (_tmp9_);
	_tmp10_ = self->priv->n_games;
	self->priv->n_games = _tmp10_ - 1;
	g_list_model_items_changed ((GListModel*) self, (guint) pos, (guint) 1, (guint) 0);
	g_signal_emit (self, games_game_model_signals[GAMES_GAME_MODEL_GAME_REMOVED_SIGNAL], 0, game);
}

static GSequenceIter*
games_game_model_get_game_iter (GamesGameModel* self,
                                GamesGame* game)
{
	GSequenceIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	{
		GSequenceIter* iter = NULL;
		GSequence* _tmp0_;
		GSequenceIter* _tmp1_;
		_tmp0_ = self->priv->sequence;
		_tmp1_ = g_sequence_get_begin_iter (_tmp0_);
		iter = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GSequenceIter* _tmp5_;
				GSequenceIter* _tmp6_;
				gconstpointer _tmp7_;
				if (!_tmp2_) {
					GSequenceIter* _tmp3_;
					GSequenceIter* _tmp4_;
					_tmp3_ = iter;
					_tmp4_ = g_sequence_iter_next (_tmp3_);
					iter = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = iter;
				if (!(!g_sequence_iter_is_end (_tmp5_))) {
					break;
				}
				_tmp6_ = iter;
				_tmp7_ = g_sequence_get (_tmp6_);
				if (games_game_equal ((GamesGame*) _tmp7_, game)) {
					result = iter;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

GamesGameModel*
games_game_model_construct (GType object_type)
{
	GamesGameModel * self = NULL;
	self = (GamesGameModel*) g_object_new (object_type, NULL);
	return self;
}

GamesGameModel*
games_game_model_new (void)
{
	return games_game_model_construct (GAMES_TYPE_GAME_MODEL);
}

GamesGameModelSortType
games_game_model_get_sort_type (GamesGameModel* self)
{
	GamesGameModelSortType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sort_type;
	return result;
}

void
games_game_model_set_sort_type (GamesGameModel* self,
                                GamesGameModelSortType value)
{
	GamesGameModelSortType _tmp0_;
	GamesGameModelSortType _tmp1_;
	GamesGameModelSortType _tmp2_;
	GamesGameModelSortType _tmp3_;
	gpointer _tmp4_ = NULL;
	GDestroyNotify _tmp5_ = NULL;
	GCompareDataFunc _tmp6_;
	GSequence* _tmp7_;
	GCompareDataFunc _tmp8_;
	gpointer _tmp8__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_game_model_get_sort_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->_sort_type = value;
	_tmp2_ = games_game_model_get_sort_type (self);
	_tmp3_ = _tmp2_;
	_tmp6_ = games_game_model_sort_type_get_sort_function (_tmp3_, &_tmp4_, &_tmp5_);
	(self->priv->compare_func_target_destroy_notify == NULL) ? NULL : (self->priv->compare_func_target_destroy_notify (self->priv->compare_func_target), NULL);
	self->priv->compare_func = NULL;
	self->priv->compare_func_target = NULL;
	self->priv->compare_func_target_destroy_notify = NULL;
	self->priv->compare_func = _tmp6_;
	self->priv->compare_func_target = _tmp4_;
	self->priv->compare_func_target_destroy_notify = _tmp5_;
	_tmp7_ = self->priv->sequence;
	_tmp8_ = self->priv->compare_func;
	_tmp8__target = self->priv->compare_func_target;
	g_sequence_sort (_tmp7_, _tmp8_, _tmp8__target);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) self->priv->n_games, (guint) self->priv->n_games);
	g_object_notify_by_pspec ((GObject *) self, games_game_model_properties[GAMES_GAME_MODEL_SORT_TYPE_PROPERTY]);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
games_game_model_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesGameModel * self;
	GamesGameModelSortType _tmp0_;
	GamesGameModelSortType _tmp1_;
	gpointer _tmp2_ = NULL;
	GDestroyNotify _tmp3_ = NULL;
	GCompareDataFunc _tmp4_;
	GSequence* _tmp5_;
	parent_class = G_OBJECT_CLASS (games_game_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME_MODEL, GamesGameModel);
	_tmp0_ = games_game_model_get_sort_type (self);
	_tmp1_ = _tmp0_;
	_tmp4_ = games_game_model_sort_type_get_sort_function (_tmp1_, &_tmp2_, &_tmp3_);
	(self->priv->compare_func_target_destroy_notify == NULL) ? NULL : (self->priv->compare_func_target_destroy_notify (self->priv->compare_func_target), NULL);
	self->priv->compare_func = NULL;
	self->priv->compare_func_target = NULL;
	self->priv->compare_func_target_destroy_notify = NULL;
	self->priv->compare_func = _tmp4_;
	self->priv->compare_func_target = _tmp2_;
	self->priv->compare_func_target_destroy_notify = _tmp3_;
	_tmp5_ = g_sequence_new (_g_object_unref0_);
	_g_sequence_free0 (self->priv->sequence);
	self->priv->sequence = _tmp5_;
	self->priv->n_games = 0;
	return obj;
}

static void
games_game_model_class_init (GamesGameModelClass * klass,
                             gpointer klass_data)
{
	games_game_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGameModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_game_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_game_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_game_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_game_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_MODEL_SORT_TYPE_PROPERTY, games_game_model_properties[GAMES_GAME_MODEL_SORT_TYPE_PROPERTY] = g_param_spec_enum ("sort-type", "sort-type", "sort-type", GAMES_GAME_MODEL_TYPE_SORT_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	games_game_model_signals[GAMES_GAME_MODEL_GAME_ADDED_SIGNAL] = g_signal_new ("game-added", GAMES_TYPE_GAME_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_GAME);
	games_game_model_signals[GAMES_GAME_MODEL_GAME_REMOVED_SIGNAL] = g_signal_new ("game-removed", GAMES_TYPE_GAME_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_GAME);
}

static void
games_game_model_g_list_model_interface_init (GListModelInterface * iface,
                                              gpointer iface_data)
{
	games_game_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) games_game_model_real_get_item;
	iface->get_item_type = (GType (*) (GListModel*)) games_game_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) games_game_model_real_get_n_items;
}

static void
games_game_model_instance_init (GamesGameModel * self,
                                gpointer klass)
{
	self->priv = games_game_model_get_instance_private (self);
	self->priv->_sort_type = GAMES_GAME_MODEL_SORT_TYPE_BY_NAME;
}

static void
games_game_model_finalize (GObject * obj)
{
	GamesGameModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME_MODEL, GamesGameModel);
	_g_sequence_free0 (self->priv->sequence);
	(self->priv->compare_func_target_destroy_notify == NULL) ? NULL : (self->priv->compare_func_target_destroy_notify (self->priv->compare_func_target), NULL);
	self->priv->compare_func = NULL;
	self->priv->compare_func_target = NULL;
	self->priv->compare_func_target_destroy_notify = NULL;
	G_OBJECT_CLASS (games_game_model_parent_class)->finalize (obj);
}

static GType
games_game_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGameModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_game_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGameModel), 0, (GInstanceInitFunc) games_game_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) games_game_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_game_model_type_id;
	games_game_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGameModel", &g_define_type_info, 0);
	g_type_add_interface_static (games_game_model_type_id, g_list_model_get_type (), &g_list_model_info);
	GamesGameModel_private_offset = g_type_add_instance_private (games_game_model_type_id, sizeof (GamesGameModelPrivate));
	return games_game_model_type_id;
}

GType
games_game_model_get_type (void)
{
	static volatile gsize games_game_model_type_id__once = 0;
	if (g_once_init_enter (&games_game_model_type_id__once)) {
		GType games_game_model_type_id;
		games_game_model_type_id = games_game_model_get_type_once ();
		g_once_init_leave (&games_game_model_type_id__once, games_game_model_type_id);
	}
	return games_game_model_type_id__once;
}

static void
_vala_games_game_model_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GamesGameModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_MODEL, GamesGameModel);
	switch (property_id) {
		case GAMES_GAME_MODEL_SORT_TYPE_PROPERTY:
		g_value_set_enum (value, games_game_model_get_sort_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_game_model_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GamesGameModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_MODEL, GamesGameModel);
	switch (property_id) {
		case GAMES_GAME_MODEL_SORT_TYPE_PROPERTY:
		games_game_model_set_sort_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

