/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_deinterleave = R"doc(deinterleave an input block of samples into N outputs.

This block deinterleaves blocks of samples. For each output connection, the input stream will be deinterleaved successively to the output connections. By default, the block deinterleaves a single input to each output unless blocksize is given in the constructor.

Constructor Specific Documentation:

Make a deinterleave block.

Args:
    itemsize : stream itemsize
    blocksize : size of block to deinterleave)doc";


static const char* __doc_gr_blocks_deinterleave_deinterleave = R"doc()doc";


static const char* __doc_gr_blocks_deinterleave_make = R"doc(deinterleave an input block of samples into N outputs.

This block deinterleaves blocks of samples. For each output connection, the input stream will be deinterleaved successively to the output connections. By default, the block deinterleaves a single input to each output unless blocksize is given in the constructor.

Constructor Specific Documentation:

Make a deinterleave block.

Args:
    itemsize : stream itemsize
    blocksize : size of block to deinterleave)doc";
