/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_ldpc_decoder = R"doc()doc";


static const char* __doc_gr_fec_ldpc_decoder_ldpc_decoder = R"doc()doc";


static const char* __doc_gr_fec_ldpc_decoder_rate = R"doc(Returns the rate of the code. For every r input bits, there is 1 output bit, so the rate is 1/r. Used for setting things like the encoder block's relative rate.


This function MUST be reimplemented by the child class.)doc";


static const char* __doc_gr_fec_ldpc_decoder_set_frame_size = R"doc(Updates the size of a decoded frame.


The child class MUST implement this function and interpret how the  information affects the block's behavior. It should also provide bounds checks.)doc";


static const char* __doc_gr_fec_ldpc_decoder_make = R"doc()doc";


static const char* __doc_gr_fec_ldpc_decoder_get_output_size = R"doc(Returns the output size in items that the decoder object produces after decoding a full frame. Often, this number is the number of bits in the outputted frame if the input format is unpacked. If the block produces packed bytes, then this value should be the number of bytes (number of bits / 8) per frame produced. This value is generally something like get_input_size()/R for a 1/R rate code.


The child class MUST implement this function.)doc";


static const char* __doc_gr_fec_ldpc_decoder_get_input_size = R"doc(Returns the input size in items that the decoder object uses to decode a full frame. Often, this number is the number of bits per frame if the input format is unpacked. If the block expects packed bytes, then this value should be the number of bytes (number of bits / 8) per input frame.


The child class MUST implement this function.)doc";


static const char* __doc_gr_fec_ldpc_decoder_get_input_item_size = R"doc(Sets the size of an input item, as in the size of a char or float item.


The child class SHOULD implement this function. If not reimplemented, it returns sizeof(float) as the decoders typically expect floating point input types.)doc";


static const char* __doc_gr_fec_ldpc_decoder_get_output_item_size = R"doc(Sets the size of an output item, as in the size of a char or float item.


The child class SHOULD implement this function. If not reimplemented, it returns sizeof(char) as the decoders typically expect to produce bits or bytes.)doc";


static const char* __doc_gr_fec_ldpc_decoder_get_iterations = R"doc(Get repetitions to decode.


The child class should implement this function and return the number of iterations required to decode.)doc";
