

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Dbusmenu.Enums
    ( 

 -- * Enumerations


-- ** Status #enum:Status#

    Status(..)                              ,


-- ** TextDirection #enum:TextDirection#

    TextDirection(..)                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum TextDirection
-- | The direction of text that the strings that this server
-- 	will be sending strings as.
data TextDirection = 
      TextDirectionNone
    -- ^ Unspecified text direction
    | TextDirectionLtr
    -- ^ Left-to-right text direction
    | TextDirectionRtl
    -- ^ Right-to-left text direction
    | AnotherTextDirection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextDirection where
    fromEnum TextDirectionNone = 0
    fromEnum TextDirectionLtr = 1
    fromEnum TextDirectionRtl = 2
    fromEnum (AnotherTextDirection k) = k

    toEnum 0 = TextDirectionNone
    toEnum 1 = TextDirectionLtr
    toEnum 2 = TextDirectionRtl
    toEnum k = AnotherTextDirection k

instance P.Ord TextDirection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum Status
-- | Tracks how the menus should be presented to the user.
data Status = 
      StatusNormal
    -- ^ Everything is normal
    | StatusNotice
    -- ^ The menus should be shown at a higher priority
    | AnotherStatus Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Status where
    fromEnum StatusNormal = 0
    fromEnum StatusNotice = 1
    fromEnum (AnotherStatus k) = k

    toEnum 0 = StatusNormal
    toEnum 1 = StatusNotice
    toEnum k = AnotherStatus k

instance P.Ord Status where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)


