{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node applying a @GskTransform@ to its single child node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.TransformNode
    ( 

-- * Exported types
    TransformNode(..)                       ,
    IsTransformNode                         ,
    toTransformNode                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.TransformNode#g:method:getChild"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getTransform]("GI.Gsk.Objects.TransformNode#g:method:getTransform").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTransformNodeMethod              ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    TransformNodeGetChildMethodInfo         ,
#endif
    transformNodeGetChild                   ,


-- ** getTransform #method:getTransform#

#if defined(ENABLE_OVERLOADING)
    TransformNodeGetTransformMethodInfo     ,
#endif
    transformNodeGetTransform               ,


-- ** new #method:new#

    transformNodeNew                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.Transform as Gsk.Transform

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.Transform as Gsk.Transform

#endif

-- | Memory-managed wrapper type.
newtype TransformNode = TransformNode (SP.ManagedPtr TransformNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype TransformNode where
    toManagedPtr (TransformNode p) = p

foreign import ccall "gsk_transform_node_get_type"
    c_gsk_transform_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject TransformNode where
    glibType = c_gsk_transform_node_get_type

-- | Type class for types which can be safely cast to t'TransformNode', for instance with `toTransformNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TransformNode o) => IsTransformNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TransformNode o) => IsTransformNode o

instance O.HasParentTypes TransformNode
type instance O.ParentTypes TransformNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'TransformNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTransformNode :: (MIO.MonadIO m, IsTransformNode o) => o -> m TransformNode
toTransformNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo TransformNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveTransformNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTransformNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveTransformNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveTransformNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveTransformNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveTransformNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveTransformNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveTransformNodeMethod "getChild" o = TransformNodeGetChildMethodInfo
    ResolveTransformNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveTransformNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveTransformNodeMethod "getTransform" o = TransformNodeGetTransformMethodInfo
    ResolveTransformNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTransformNodeMethod t TransformNode, O.OverloadedMethod info TransformNode p) => OL.IsLabel t (TransformNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTransformNodeMethod t TransformNode, O.OverloadedMethod info TransformNode p, R.HasField t TransformNode p) => R.HasField t TransformNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTransformNodeMethod t TransformNode, O.OverloadedMethodInfo info TransformNode) => OL.IsLabel t (O.MethodProxy info TransformNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr TransformNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method TransformNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The node to transform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "transform"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Transform" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The transform to apply"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "TransformNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_transform_node_new" gsk_transform_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Gsk.Transform.Transform ->          -- transform : TInterface (Name {namespace = "Gsk", name = "Transform"})
    IO (Ptr TransformNode)

-- | Creates a @GskRenderNode@ that will transform the given /@child@/
-- with the given /@transform@/.
transformNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: The node to transform
    -> Gsk.Transform.Transform
    -- ^ /@transform@/: The transform to apply
    -> m TransformNode
    -- ^ __Returns:__ A new @GskRenderNode@
transformNodeNew child transform = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    transform' <- unsafeManagedPtrGetPtr transform
    result <- gsk_transform_node_new child' transform'
    checkUnexpectedReturnNULL "transformNodeNew" result
    result' <- (wrapPtr TransformNode) result
    touchManagedPtr child
    touchManagedPtr transform
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TransformNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "TransformNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a transform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_transform_node_get_child" gsk_transform_node_get_child :: 
    Ptr TransformNode ->                    -- node : TInterface (Name {namespace = "Gsk", name = "TransformNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets the child node that is getting transformed by the given /@node@/.
transformNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsTransformNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a transform
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ The child that is getting transformed
transformNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_transform_node_get_child node'
    checkUnexpectedReturnNULL "transformNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data TransformNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsTransformNode a) => O.OverloadedMethod TransformNodeGetChildMethodInfo a signature where
    overloadedMethod = transformNodeGetChild

instance O.OverloadedMethodInfo TransformNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.TransformNode.transformNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-TransformNode.html#v:transformNodeGetChild"
        })


#endif

-- method TransformNode::get_transform
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "TransformNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a transform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "Transform" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_transform_node_get_transform" gsk_transform_node_get_transform :: 
    Ptr TransformNode ->                    -- node : TInterface (Name {namespace = "Gsk", name = "TransformNode"})
    IO (Ptr Gsk.Transform.Transform)

-- | Retrieves the @GskTransform@ used by the /@node@/.
transformNodeGetTransform ::
    (B.CallStack.HasCallStack, MonadIO m, IsTransformNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a transform
    -> m Gsk.Transform.Transform
    -- ^ __Returns:__ a @GskTransform@
transformNodeGetTransform node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_transform_node_get_transform node'
    checkUnexpectedReturnNULL "transformNodeGetTransform" result
    result' <- (newBoxed Gsk.Transform.Transform) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data TransformNodeGetTransformMethodInfo
instance (signature ~ (m Gsk.Transform.Transform), MonadIO m, IsTransformNode a) => O.OverloadedMethod TransformNodeGetTransformMethodInfo a signature where
    overloadedMethod = transformNodeGetTransform

instance O.OverloadedMethodInfo TransformNodeGetTransformMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.TransformNode.transformNodeGetTransform",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-TransformNode.html#v:transformNodeGetTransform"
        })


#endif


