{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkAppChooserWidget@ is a widget for selecting applications.
-- 
-- It is the main building block for t'GI.Gtk.Objects.AppChooserDialog.AppChooserDialog'.
-- Most applications only need to use the latter; but you can use
-- this widget as part of a larger widget if you have special needs.
-- 
-- @GtkAppChooserWidget@ offers detailed control over what applications
-- are shown, using the
-- [AppChooserWidget:showDefault]("GI.Gtk.Objects.AppChooserWidget#g:attr:showDefault"),
-- [AppChooserWidget:showRecommended]("GI.Gtk.Objects.AppChooserWidget#g:attr:showRecommended"),
-- [AppChooserWidget:showFallback]("GI.Gtk.Objects.AppChooserWidget#g:attr:showFallback"),
-- [AppChooserWidget:showOther]("GI.Gtk.Objects.AppChooserWidget#g:attr:showOther") and
-- [AppChooserWidget:showAll]("GI.Gtk.Objects.AppChooserWidget#g:attr:showAll") properties. See the
-- t'GI.Gtk.Interfaces.AppChooser.AppChooser' documentation for more information about these
-- groups of applications.
-- 
-- To keep track of the selected application, use the
-- [AppChooserWidget::applicationSelected]("GI.Gtk.Objects.AppChooserWidget#g:signal:applicationSelected") and
-- [AppChooserWidget::applicationActivated]("GI.Gtk.Objects.AppChooserWidget#g:signal:applicationActivated") signals.
-- 
-- == CSS nodes
-- 
-- @GtkAppChooserWidget@ has a single CSS node with name appchooser.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AppChooserWidget
    ( 

-- * Exported types
    AppChooserWidget(..)                    ,
    IsAppChooserWidget                      ,
    toAppChooserWidget                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refresh]("GI.Gtk.Interfaces.AppChooser#g:method:refresh"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAppInfo]("GI.Gtk.Interfaces.AppChooser#g:method:getAppInfo"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getContentType]("GI.Gtk.Interfaces.AppChooser#g:method:getContentType"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultText]("GI.Gtk.Objects.AppChooserWidget#g:method:getDefaultText"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowAll]("GI.Gtk.Objects.AppChooserWidget#g:method:getShowAll"), [getShowDefault]("GI.Gtk.Objects.AppChooserWidget#g:method:getShowDefault"), [getShowFallback]("GI.Gtk.Objects.AppChooserWidget#g:method:getShowFallback"), [getShowOther]("GI.Gtk.Objects.AppChooserWidget#g:method:getShowOther"), [getShowRecommended]("GI.Gtk.Objects.AppChooserWidget#g:method:getShowRecommended"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultText]("GI.Gtk.Objects.AppChooserWidget#g:method:setDefaultText"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowAll]("GI.Gtk.Objects.AppChooserWidget#g:method:setShowAll"), [setShowDefault]("GI.Gtk.Objects.AppChooserWidget#g:method:setShowDefault"), [setShowFallback]("GI.Gtk.Objects.AppChooserWidget#g:method:setShowFallback"), [setShowOther]("GI.Gtk.Objects.AppChooserWidget#g:method:setShowOther"), [setShowRecommended]("GI.Gtk.Objects.AppChooserWidget#g:method:setShowRecommended"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveAppChooserWidgetMethod           ,
#endif

-- ** getDefaultText #method:getDefaultText#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetGetDefaultTextMethodInfo,
#endif
    appChooserWidgetGetDefaultText          ,


-- ** getShowAll #method:getShowAll#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetGetShowAllMethodInfo    ,
#endif
    appChooserWidgetGetShowAll              ,


-- ** getShowDefault #method:getShowDefault#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetGetShowDefaultMethodInfo,
#endif
    appChooserWidgetGetShowDefault          ,


-- ** getShowFallback #method:getShowFallback#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetGetShowFallbackMethodInfo,
#endif
    appChooserWidgetGetShowFallback         ,


-- ** getShowOther #method:getShowOther#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetGetShowOtherMethodInfo  ,
#endif
    appChooserWidgetGetShowOther            ,


-- ** getShowRecommended #method:getShowRecommended#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetGetShowRecommendedMethodInfo,
#endif
    appChooserWidgetGetShowRecommended      ,


-- ** new #method:new#

    appChooserWidgetNew                     ,


-- ** setDefaultText #method:setDefaultText#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetSetDefaultTextMethodInfo,
#endif
    appChooserWidgetSetDefaultText          ,


-- ** setShowAll #method:setShowAll#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetSetShowAllMethodInfo    ,
#endif
    appChooserWidgetSetShowAll              ,


-- ** setShowDefault #method:setShowDefault#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetSetShowDefaultMethodInfo,
#endif
    appChooserWidgetSetShowDefault          ,


-- ** setShowFallback #method:setShowFallback#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetSetShowFallbackMethodInfo,
#endif
    appChooserWidgetSetShowFallback         ,


-- ** setShowOther #method:setShowOther#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetSetShowOtherMethodInfo  ,
#endif
    appChooserWidgetSetShowOther            ,


-- ** setShowRecommended #method:setShowRecommended#

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetSetShowRecommendedMethodInfo,
#endif
    appChooserWidgetSetShowRecommended      ,




 -- * Properties


-- ** defaultText #attr:defaultText#
-- | The text that appears in the widget when there are no applications
-- for the given content type.

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetDefaultTextPropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserWidgetDefaultText             ,
#endif
    constructAppChooserWidgetDefaultText    ,
    getAppChooserWidgetDefaultText          ,
    setAppChooserWidgetDefaultText          ,


-- ** showAll #attr:showAll#
-- | If 'P.True', the app chooser presents all applications
-- in a single list, without subsections for default,
-- recommended or related applications.

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetShowAllPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserWidgetShowAll                 ,
#endif
    constructAppChooserWidgetShowAll        ,
    getAppChooserWidgetShowAll              ,
    setAppChooserWidgetShowAll              ,


-- ** showDefault #attr:showDefault#
-- | Determines whether the app chooser should show the default
-- handler for the content type in a separate section.
-- 
-- If 'P.False', the default handler is listed among the recommended
-- applications.

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetShowDefaultPropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserWidgetShowDefault             ,
#endif
    constructAppChooserWidgetShowDefault    ,
    getAppChooserWidgetShowDefault          ,
    setAppChooserWidgetShowDefault          ,


-- ** showFallback #attr:showFallback#
-- | Determines whether the app chooser should show a section
-- for fallback applications.
-- 
-- If 'P.False', the fallback applications are listed among the
-- other applications.

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetShowFallbackPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserWidgetShowFallback            ,
#endif
    constructAppChooserWidgetShowFallback   ,
    getAppChooserWidgetShowFallback         ,
    setAppChooserWidgetShowFallback         ,


-- ** showOther #attr:showOther#
-- | Determines whether the app chooser should show a section
-- for other applications.

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetShowOtherPropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserWidgetShowOther               ,
#endif
    constructAppChooserWidgetShowOther      ,
    getAppChooserWidgetShowOther            ,
    setAppChooserWidgetShowOther            ,


-- ** showRecommended #attr:showRecommended#
-- | Determines whether the app chooser should show a section
-- for recommended applications.
-- 
-- If 'P.False', the recommended applications are listed
-- among the other applications.

#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetShowRecommendedPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    appChooserWidgetShowRecommended         ,
#endif
    constructAppChooserWidgetShowRecommended,
    getAppChooserWidgetShowRecommended      ,
    setAppChooserWidgetShowRecommended      ,




 -- * Signals


-- ** applicationActivated #signal:applicationActivated#

    AppChooserWidgetApplicationActivatedCallback,
#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetApplicationActivatedSignalInfo,
#endif
    afterAppChooserWidgetApplicationActivated,
    onAppChooserWidgetApplicationActivated  ,


-- ** applicationSelected #signal:applicationSelected#

    AppChooserWidgetApplicationSelectedCallback,
#if defined(ENABLE_OVERLOADING)
    AppChooserWidgetApplicationSelectedSignalInfo,
#endif
    afterAppChooserWidgetApplicationSelected,
    onAppChooserWidgetApplicationSelected   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AppChooser as Gtk.AppChooser
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AppChooser as Gtk.AppChooser
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype AppChooserWidget = AppChooserWidget (SP.ManagedPtr AppChooserWidget)
    deriving (Eq)

instance SP.ManagedPtrNewtype AppChooserWidget where
    toManagedPtr (AppChooserWidget p) = p

foreign import ccall "gtk_app_chooser_widget_get_type"
    c_gtk_app_chooser_widget_get_type :: IO B.Types.GType

instance B.Types.TypedObject AppChooserWidget where
    glibType = c_gtk_app_chooser_widget_get_type

instance B.Types.GObject AppChooserWidget

-- | Type class for types which can be safely cast to t'AppChooserWidget', for instance with `toAppChooserWidget`.
class (SP.GObject o, O.IsDescendantOf AppChooserWidget o) => IsAppChooserWidget o
instance (SP.GObject o, O.IsDescendantOf AppChooserWidget o) => IsAppChooserWidget o

instance O.HasParentTypes AppChooserWidget
type instance O.ParentTypes AppChooserWidget = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AppChooser.AppChooser, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'AppChooserWidget', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAppChooserWidget :: (MIO.MonadIO m, IsAppChooserWidget o) => o -> m AppChooserWidget
toAppChooserWidget = MIO.liftIO . B.ManagedPtr.unsafeCastTo AppChooserWidget

-- | Convert t'AppChooserWidget' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AppChooserWidget) where
    gvalueGType_ = c_gtk_app_chooser_widget_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AppChooserWidget)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AppChooserWidget)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AppChooserWidget ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAppChooserWidgetMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAppChooserWidgetMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveAppChooserWidgetMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveAppChooserWidgetMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveAppChooserWidgetMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveAppChooserWidgetMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveAppChooserWidgetMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveAppChooserWidgetMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveAppChooserWidgetMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveAppChooserWidgetMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveAppChooserWidgetMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveAppChooserWidgetMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAppChooserWidgetMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAppChooserWidgetMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveAppChooserWidgetMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveAppChooserWidgetMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveAppChooserWidgetMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveAppChooserWidgetMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveAppChooserWidgetMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveAppChooserWidgetMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveAppChooserWidgetMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveAppChooserWidgetMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveAppChooserWidgetMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveAppChooserWidgetMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveAppChooserWidgetMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAppChooserWidgetMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAppChooserWidgetMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAppChooserWidgetMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveAppChooserWidgetMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveAppChooserWidgetMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveAppChooserWidgetMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveAppChooserWidgetMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveAppChooserWidgetMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveAppChooserWidgetMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveAppChooserWidgetMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveAppChooserWidgetMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveAppChooserWidgetMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveAppChooserWidgetMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveAppChooserWidgetMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveAppChooserWidgetMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveAppChooserWidgetMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAppChooserWidgetMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveAppChooserWidgetMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveAppChooserWidgetMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveAppChooserWidgetMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveAppChooserWidgetMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveAppChooserWidgetMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveAppChooserWidgetMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveAppChooserWidgetMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveAppChooserWidgetMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAppChooserWidgetMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAppChooserWidgetMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveAppChooserWidgetMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveAppChooserWidgetMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveAppChooserWidgetMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveAppChooserWidgetMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveAppChooserWidgetMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveAppChooserWidgetMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveAppChooserWidgetMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAppChooserWidgetMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAppChooserWidgetMethod "refresh" o = Gtk.AppChooser.AppChooserRefreshMethodInfo
    ResolveAppChooserWidgetMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveAppChooserWidgetMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveAppChooserWidgetMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveAppChooserWidgetMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveAppChooserWidgetMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveAppChooserWidgetMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveAppChooserWidgetMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveAppChooserWidgetMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAppChooserWidgetMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveAppChooserWidgetMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveAppChooserWidgetMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveAppChooserWidgetMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveAppChooserWidgetMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAppChooserWidgetMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAppChooserWidgetMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAppChooserWidgetMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveAppChooserWidgetMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveAppChooserWidgetMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveAppChooserWidgetMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveAppChooserWidgetMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveAppChooserWidgetMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAppChooserWidgetMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveAppChooserWidgetMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveAppChooserWidgetMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveAppChooserWidgetMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveAppChooserWidgetMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveAppChooserWidgetMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveAppChooserWidgetMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAppChooserWidgetMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveAppChooserWidgetMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveAppChooserWidgetMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveAppChooserWidgetMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveAppChooserWidgetMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveAppChooserWidgetMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveAppChooserWidgetMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveAppChooserWidgetMethod "getAppInfo" o = Gtk.AppChooser.AppChooserGetAppInfoMethodInfo
    ResolveAppChooserWidgetMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveAppChooserWidgetMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveAppChooserWidgetMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveAppChooserWidgetMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveAppChooserWidgetMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveAppChooserWidgetMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveAppChooserWidgetMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveAppChooserWidgetMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveAppChooserWidgetMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveAppChooserWidgetMethod "getContentType" o = Gtk.AppChooser.AppChooserGetContentTypeMethodInfo
    ResolveAppChooserWidgetMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveAppChooserWidgetMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveAppChooserWidgetMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveAppChooserWidgetMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAppChooserWidgetMethod "getDefaultText" o = AppChooserWidgetGetDefaultTextMethodInfo
    ResolveAppChooserWidgetMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveAppChooserWidgetMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveAppChooserWidgetMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveAppChooserWidgetMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveAppChooserWidgetMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveAppChooserWidgetMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveAppChooserWidgetMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveAppChooserWidgetMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveAppChooserWidgetMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveAppChooserWidgetMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveAppChooserWidgetMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveAppChooserWidgetMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveAppChooserWidgetMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveAppChooserWidgetMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveAppChooserWidgetMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveAppChooserWidgetMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveAppChooserWidgetMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveAppChooserWidgetMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveAppChooserWidgetMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveAppChooserWidgetMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveAppChooserWidgetMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveAppChooserWidgetMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveAppChooserWidgetMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveAppChooserWidgetMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveAppChooserWidgetMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveAppChooserWidgetMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveAppChooserWidgetMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveAppChooserWidgetMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveAppChooserWidgetMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveAppChooserWidgetMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveAppChooserWidgetMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveAppChooserWidgetMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveAppChooserWidgetMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveAppChooserWidgetMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveAppChooserWidgetMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveAppChooserWidgetMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAppChooserWidgetMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAppChooserWidgetMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveAppChooserWidgetMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveAppChooserWidgetMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveAppChooserWidgetMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveAppChooserWidgetMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveAppChooserWidgetMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveAppChooserWidgetMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveAppChooserWidgetMethod "getShowAll" o = AppChooserWidgetGetShowAllMethodInfo
    ResolveAppChooserWidgetMethod "getShowDefault" o = AppChooserWidgetGetShowDefaultMethodInfo
    ResolveAppChooserWidgetMethod "getShowFallback" o = AppChooserWidgetGetShowFallbackMethodInfo
    ResolveAppChooserWidgetMethod "getShowOther" o = AppChooserWidgetGetShowOtherMethodInfo
    ResolveAppChooserWidgetMethod "getShowRecommended" o = AppChooserWidgetGetShowRecommendedMethodInfo
    ResolveAppChooserWidgetMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveAppChooserWidgetMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveAppChooserWidgetMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveAppChooserWidgetMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveAppChooserWidgetMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveAppChooserWidgetMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveAppChooserWidgetMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveAppChooserWidgetMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveAppChooserWidgetMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveAppChooserWidgetMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveAppChooserWidgetMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveAppChooserWidgetMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveAppChooserWidgetMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveAppChooserWidgetMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveAppChooserWidgetMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveAppChooserWidgetMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveAppChooserWidgetMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveAppChooserWidgetMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveAppChooserWidgetMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveAppChooserWidgetMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAppChooserWidgetMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAppChooserWidgetMethod "setDefaultText" o = AppChooserWidgetSetDefaultTextMethodInfo
    ResolveAppChooserWidgetMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveAppChooserWidgetMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveAppChooserWidgetMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveAppChooserWidgetMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveAppChooserWidgetMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveAppChooserWidgetMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveAppChooserWidgetMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveAppChooserWidgetMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveAppChooserWidgetMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveAppChooserWidgetMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveAppChooserWidgetMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveAppChooserWidgetMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveAppChooserWidgetMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveAppChooserWidgetMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveAppChooserWidgetMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveAppChooserWidgetMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveAppChooserWidgetMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveAppChooserWidgetMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveAppChooserWidgetMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveAppChooserWidgetMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveAppChooserWidgetMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAppChooserWidgetMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveAppChooserWidgetMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveAppChooserWidgetMethod "setShowAll" o = AppChooserWidgetSetShowAllMethodInfo
    ResolveAppChooserWidgetMethod "setShowDefault" o = AppChooserWidgetSetShowDefaultMethodInfo
    ResolveAppChooserWidgetMethod "setShowFallback" o = AppChooserWidgetSetShowFallbackMethodInfo
    ResolveAppChooserWidgetMethod "setShowOther" o = AppChooserWidgetSetShowOtherMethodInfo
    ResolveAppChooserWidgetMethod "setShowRecommended" o = AppChooserWidgetSetShowRecommendedMethodInfo
    ResolveAppChooserWidgetMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveAppChooserWidgetMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveAppChooserWidgetMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveAppChooserWidgetMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveAppChooserWidgetMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveAppChooserWidgetMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveAppChooserWidgetMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveAppChooserWidgetMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveAppChooserWidgetMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAppChooserWidgetMethod t AppChooserWidget, O.OverloadedMethod info AppChooserWidget p) => OL.IsLabel t (AppChooserWidget -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAppChooserWidgetMethod t AppChooserWidget, O.OverloadedMethod info AppChooserWidget p, R.HasField t AppChooserWidget p) => R.HasField t AppChooserWidget p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAppChooserWidgetMethod t AppChooserWidget, O.OverloadedMethodInfo info AppChooserWidget) => OL.IsLabel t (O.MethodProxy info AppChooserWidget) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal AppChooserWidget::application-activated
-- | Emitted when an application item is activated from the widget\'s list.
-- 
-- This usually happens when the user double clicks an item, or an item
-- is selected and the user presses one of the keys Space, Shift+Space,
-- Return or Enter.
type AppChooserWidgetApplicationActivatedCallback =
    Gio.AppInfo.AppInfo
    -- ^ /@application@/: the activated @GAppInfo@
    -> IO ()

type C_AppChooserWidgetApplicationActivatedCallback =
    Ptr AppChooserWidget ->                 -- object
    Ptr Gio.AppInfo.AppInfo ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AppChooserWidgetApplicationActivatedCallback`.
foreign import ccall "wrapper"
    mk_AppChooserWidgetApplicationActivatedCallback :: C_AppChooserWidgetApplicationActivatedCallback -> IO (FunPtr C_AppChooserWidgetApplicationActivatedCallback)

wrap_AppChooserWidgetApplicationActivatedCallback :: 
    GObject a => (a -> AppChooserWidgetApplicationActivatedCallback) ->
    C_AppChooserWidgetApplicationActivatedCallback
wrap_AppChooserWidgetApplicationActivatedCallback gi'cb gi'selfPtr application _ = do
    application' <- (newObject Gio.AppInfo.AppInfo) application
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  application'


-- | Connect a signal handler for the [applicationActivated](#signal:applicationActivated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' appChooserWidget #applicationActivated callback
-- @
-- 
-- 
onAppChooserWidgetApplicationActivated :: (IsAppChooserWidget a, MonadIO m) => a -> ((?self :: a) => AppChooserWidgetApplicationActivatedCallback) -> m SignalHandlerId
onAppChooserWidgetApplicationActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserWidgetApplicationActivatedCallback wrapped
    wrapped'' <- mk_AppChooserWidgetApplicationActivatedCallback wrapped'
    connectSignalFunPtr obj "application-activated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [applicationActivated](#signal:applicationActivated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' appChooserWidget #applicationActivated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAppChooserWidgetApplicationActivated :: (IsAppChooserWidget a, MonadIO m) => a -> ((?self :: a) => AppChooserWidgetApplicationActivatedCallback) -> m SignalHandlerId
afterAppChooserWidgetApplicationActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserWidgetApplicationActivatedCallback wrapped
    wrapped'' <- mk_AppChooserWidgetApplicationActivatedCallback wrapped'
    connectSignalFunPtr obj "application-activated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetApplicationActivatedSignalInfo
instance SignalInfo AppChooserWidgetApplicationActivatedSignalInfo where
    type HaskellCallbackType AppChooserWidgetApplicationActivatedSignalInfo = AppChooserWidgetApplicationActivatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AppChooserWidgetApplicationActivatedCallback cb
        cb'' <- mk_AppChooserWidgetApplicationActivatedCallback cb'
        connectSignalFunPtr obj "application-activated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget::application-activated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:signal:applicationActivated"})

#endif

-- signal AppChooserWidget::application-selected
-- | Emitted when an application item is selected from the widget\'s list.
type AppChooserWidgetApplicationSelectedCallback =
    Gio.AppInfo.AppInfo
    -- ^ /@application@/: the selected @GAppInfo@
    -> IO ()

type C_AppChooserWidgetApplicationSelectedCallback =
    Ptr AppChooserWidget ->                 -- object
    Ptr Gio.AppInfo.AppInfo ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AppChooserWidgetApplicationSelectedCallback`.
foreign import ccall "wrapper"
    mk_AppChooserWidgetApplicationSelectedCallback :: C_AppChooserWidgetApplicationSelectedCallback -> IO (FunPtr C_AppChooserWidgetApplicationSelectedCallback)

wrap_AppChooserWidgetApplicationSelectedCallback :: 
    GObject a => (a -> AppChooserWidgetApplicationSelectedCallback) ->
    C_AppChooserWidgetApplicationSelectedCallback
wrap_AppChooserWidgetApplicationSelectedCallback gi'cb gi'selfPtr application _ = do
    application' <- (newObject Gio.AppInfo.AppInfo) application
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  application'


-- | Connect a signal handler for the [applicationSelected](#signal:applicationSelected) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' appChooserWidget #applicationSelected callback
-- @
-- 
-- 
onAppChooserWidgetApplicationSelected :: (IsAppChooserWidget a, MonadIO m) => a -> ((?self :: a) => AppChooserWidgetApplicationSelectedCallback) -> m SignalHandlerId
onAppChooserWidgetApplicationSelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserWidgetApplicationSelectedCallback wrapped
    wrapped'' <- mk_AppChooserWidgetApplicationSelectedCallback wrapped'
    connectSignalFunPtr obj "application-selected" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [applicationSelected](#signal:applicationSelected) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' appChooserWidget #applicationSelected callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAppChooserWidgetApplicationSelected :: (IsAppChooserWidget a, MonadIO m) => a -> ((?self :: a) => AppChooserWidgetApplicationSelectedCallback) -> m SignalHandlerId
afterAppChooserWidgetApplicationSelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AppChooserWidgetApplicationSelectedCallback wrapped
    wrapped'' <- mk_AppChooserWidgetApplicationSelectedCallback wrapped'
    connectSignalFunPtr obj "application-selected" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetApplicationSelectedSignalInfo
instance SignalInfo AppChooserWidgetApplicationSelectedSignalInfo where
    type HaskellCallbackType AppChooserWidgetApplicationSelectedSignalInfo = AppChooserWidgetApplicationSelectedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AppChooserWidgetApplicationSelectedCallback cb
        cb'' <- mk_AppChooserWidgetApplicationSelectedCallback cb'
        connectSignalFunPtr obj "application-selected" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget::application-selected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:signal:applicationSelected"})

#endif

-- VVV Prop "default-text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@default-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserWidget #defaultText
-- @
getAppChooserWidgetDefaultText :: (MonadIO m, IsAppChooserWidget o) => o -> m (Maybe T.Text)
getAppChooserWidgetDefaultText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "default-text"

-- | Set the value of the “@default-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserWidget [ #defaultText 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserWidgetDefaultText :: (MonadIO m, IsAppChooserWidget o) => o -> T.Text -> m ()
setAppChooserWidgetDefaultText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "default-text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@default-text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserWidgetDefaultText :: (IsAppChooserWidget o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAppChooserWidgetDefaultText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "default-text" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetDefaultTextPropertyInfo
instance AttrInfo AppChooserWidgetDefaultTextPropertyInfo where
    type AttrAllowedOps AppChooserWidgetDefaultTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AppChooserWidgetDefaultTextPropertyInfo = IsAppChooserWidget
    type AttrSetTypeConstraint AppChooserWidgetDefaultTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AppChooserWidgetDefaultTextPropertyInfo = (~) T.Text
    type AttrTransferType AppChooserWidgetDefaultTextPropertyInfo = T.Text
    type AttrGetType AppChooserWidgetDefaultTextPropertyInfo = (Maybe T.Text)
    type AttrLabel AppChooserWidgetDefaultTextPropertyInfo = "default-text"
    type AttrOrigin AppChooserWidgetDefaultTextPropertyInfo = AppChooserWidget
    attrGet = getAppChooserWidgetDefaultText
    attrSet = setAppChooserWidgetDefaultText
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserWidgetDefaultText
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.defaultText"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:attr:defaultText"
        })
#endif

-- VVV Prop "show-all"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-all@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserWidget #showAll
-- @
getAppChooserWidgetShowAll :: (MonadIO m, IsAppChooserWidget o) => o -> m Bool
getAppChooserWidgetShowAll obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-all"

-- | Set the value of the “@show-all@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserWidget [ #showAll 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserWidgetShowAll :: (MonadIO m, IsAppChooserWidget o) => o -> Bool -> m ()
setAppChooserWidgetShowAll obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-all" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-all@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserWidgetShowAll :: (IsAppChooserWidget o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserWidgetShowAll val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-all" val

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetShowAllPropertyInfo
instance AttrInfo AppChooserWidgetShowAllPropertyInfo where
    type AttrAllowedOps AppChooserWidgetShowAllPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserWidgetShowAllPropertyInfo = IsAppChooserWidget
    type AttrSetTypeConstraint AppChooserWidgetShowAllPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserWidgetShowAllPropertyInfo = (~) Bool
    type AttrTransferType AppChooserWidgetShowAllPropertyInfo = Bool
    type AttrGetType AppChooserWidgetShowAllPropertyInfo = Bool
    type AttrLabel AppChooserWidgetShowAllPropertyInfo = "show-all"
    type AttrOrigin AppChooserWidgetShowAllPropertyInfo = AppChooserWidget
    attrGet = getAppChooserWidgetShowAll
    attrSet = setAppChooserWidgetShowAll
    attrPut = setAppChooserWidgetShowAll
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserWidgetShowAll
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.showAll"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:attr:showAll"
        })
#endif

-- VVV Prop "show-default"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserWidget #showDefault
-- @
getAppChooserWidgetShowDefault :: (MonadIO m, IsAppChooserWidget o) => o -> m Bool
getAppChooserWidgetShowDefault obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-default"

-- | Set the value of the “@show-default@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserWidget [ #showDefault 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserWidgetShowDefault :: (MonadIO m, IsAppChooserWidget o) => o -> Bool -> m ()
setAppChooserWidgetShowDefault obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-default" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-default@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserWidgetShowDefault :: (IsAppChooserWidget o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserWidgetShowDefault val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-default" val

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetShowDefaultPropertyInfo
instance AttrInfo AppChooserWidgetShowDefaultPropertyInfo where
    type AttrAllowedOps AppChooserWidgetShowDefaultPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserWidgetShowDefaultPropertyInfo = IsAppChooserWidget
    type AttrSetTypeConstraint AppChooserWidgetShowDefaultPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserWidgetShowDefaultPropertyInfo = (~) Bool
    type AttrTransferType AppChooserWidgetShowDefaultPropertyInfo = Bool
    type AttrGetType AppChooserWidgetShowDefaultPropertyInfo = Bool
    type AttrLabel AppChooserWidgetShowDefaultPropertyInfo = "show-default"
    type AttrOrigin AppChooserWidgetShowDefaultPropertyInfo = AppChooserWidget
    attrGet = getAppChooserWidgetShowDefault
    attrSet = setAppChooserWidgetShowDefault
    attrPut = setAppChooserWidgetShowDefault
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserWidgetShowDefault
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.showDefault"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:attr:showDefault"
        })
#endif

-- VVV Prop "show-fallback"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-fallback@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserWidget #showFallback
-- @
getAppChooserWidgetShowFallback :: (MonadIO m, IsAppChooserWidget o) => o -> m Bool
getAppChooserWidgetShowFallback obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-fallback"

-- | Set the value of the “@show-fallback@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserWidget [ #showFallback 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserWidgetShowFallback :: (MonadIO m, IsAppChooserWidget o) => o -> Bool -> m ()
setAppChooserWidgetShowFallback obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-fallback" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-fallback@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserWidgetShowFallback :: (IsAppChooserWidget o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserWidgetShowFallback val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-fallback" val

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetShowFallbackPropertyInfo
instance AttrInfo AppChooserWidgetShowFallbackPropertyInfo where
    type AttrAllowedOps AppChooserWidgetShowFallbackPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserWidgetShowFallbackPropertyInfo = IsAppChooserWidget
    type AttrSetTypeConstraint AppChooserWidgetShowFallbackPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserWidgetShowFallbackPropertyInfo = (~) Bool
    type AttrTransferType AppChooserWidgetShowFallbackPropertyInfo = Bool
    type AttrGetType AppChooserWidgetShowFallbackPropertyInfo = Bool
    type AttrLabel AppChooserWidgetShowFallbackPropertyInfo = "show-fallback"
    type AttrOrigin AppChooserWidgetShowFallbackPropertyInfo = AppChooserWidget
    attrGet = getAppChooserWidgetShowFallback
    attrSet = setAppChooserWidgetShowFallback
    attrPut = setAppChooserWidgetShowFallback
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserWidgetShowFallback
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.showFallback"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:attr:showFallback"
        })
#endif

-- VVV Prop "show-other"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-other@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserWidget #showOther
-- @
getAppChooserWidgetShowOther :: (MonadIO m, IsAppChooserWidget o) => o -> m Bool
getAppChooserWidgetShowOther obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-other"

-- | Set the value of the “@show-other@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserWidget [ #showOther 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserWidgetShowOther :: (MonadIO m, IsAppChooserWidget o) => o -> Bool -> m ()
setAppChooserWidgetShowOther obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-other" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-other@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserWidgetShowOther :: (IsAppChooserWidget o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserWidgetShowOther val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-other" val

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetShowOtherPropertyInfo
instance AttrInfo AppChooserWidgetShowOtherPropertyInfo where
    type AttrAllowedOps AppChooserWidgetShowOtherPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserWidgetShowOtherPropertyInfo = IsAppChooserWidget
    type AttrSetTypeConstraint AppChooserWidgetShowOtherPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserWidgetShowOtherPropertyInfo = (~) Bool
    type AttrTransferType AppChooserWidgetShowOtherPropertyInfo = Bool
    type AttrGetType AppChooserWidgetShowOtherPropertyInfo = Bool
    type AttrLabel AppChooserWidgetShowOtherPropertyInfo = "show-other"
    type AttrOrigin AppChooserWidgetShowOtherPropertyInfo = AppChooserWidget
    attrGet = getAppChooserWidgetShowOther
    attrSet = setAppChooserWidgetShowOther
    attrPut = setAppChooserWidgetShowOther
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserWidgetShowOther
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.showOther"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:attr:showOther"
        })
#endif

-- VVV Prop "show-recommended"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-recommended@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' appChooserWidget #showRecommended
-- @
getAppChooserWidgetShowRecommended :: (MonadIO m, IsAppChooserWidget o) => o -> m Bool
getAppChooserWidgetShowRecommended obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-recommended"

-- | Set the value of the “@show-recommended@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' appChooserWidget [ #showRecommended 'Data.GI.Base.Attributes.:=' value ]
-- @
setAppChooserWidgetShowRecommended :: (MonadIO m, IsAppChooserWidget o) => o -> Bool -> m ()
setAppChooserWidgetShowRecommended obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-recommended" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-recommended@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAppChooserWidgetShowRecommended :: (IsAppChooserWidget o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAppChooserWidgetShowRecommended val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-recommended" val

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetShowRecommendedPropertyInfo
instance AttrInfo AppChooserWidgetShowRecommendedPropertyInfo where
    type AttrAllowedOps AppChooserWidgetShowRecommendedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AppChooserWidgetShowRecommendedPropertyInfo = IsAppChooserWidget
    type AttrSetTypeConstraint AppChooserWidgetShowRecommendedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AppChooserWidgetShowRecommendedPropertyInfo = (~) Bool
    type AttrTransferType AppChooserWidgetShowRecommendedPropertyInfo = Bool
    type AttrGetType AppChooserWidgetShowRecommendedPropertyInfo = Bool
    type AttrLabel AppChooserWidgetShowRecommendedPropertyInfo = "show-recommended"
    type AttrOrigin AppChooserWidgetShowRecommendedPropertyInfo = AppChooserWidget
    attrGet = getAppChooserWidgetShowRecommended
    attrSet = setAppChooserWidgetShowRecommended
    attrPut = setAppChooserWidgetShowRecommended
    attrTransfer _ v = do
        return v
    attrConstruct = constructAppChooserWidgetShowRecommended
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.showRecommended"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#g:attr:showRecommended"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AppChooserWidget
type instance O.AttributeList AppChooserWidget = AppChooserWidgetAttributeList
type AppChooserWidgetAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("contentType", Gtk.AppChooser.AppChooserContentTypePropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("defaultText", AppChooserWidgetDefaultTextPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showAll", AppChooserWidgetShowAllPropertyInfo), '("showDefault", AppChooserWidgetShowDefaultPropertyInfo), '("showFallback", AppChooserWidgetShowFallbackPropertyInfo), '("showOther", AppChooserWidgetShowOtherPropertyInfo), '("showRecommended", AppChooserWidgetShowRecommendedPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
appChooserWidgetDefaultText :: AttrLabelProxy "defaultText"
appChooserWidgetDefaultText = AttrLabelProxy

appChooserWidgetShowAll :: AttrLabelProxy "showAll"
appChooserWidgetShowAll = AttrLabelProxy

appChooserWidgetShowDefault :: AttrLabelProxy "showDefault"
appChooserWidgetShowDefault = AttrLabelProxy

appChooserWidgetShowFallback :: AttrLabelProxy "showFallback"
appChooserWidgetShowFallback = AttrLabelProxy

appChooserWidgetShowOther :: AttrLabelProxy "showOther"
appChooserWidgetShowOther = AttrLabelProxy

appChooserWidgetShowRecommended :: AttrLabelProxy "showRecommended"
appChooserWidgetShowRecommended = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AppChooserWidget = AppChooserWidgetSignalList
type AppChooserWidgetSignalList = ('[ '("applicationActivated", AppChooserWidgetApplicationActivatedSignalInfo), '("applicationSelected", AppChooserWidgetApplicationSelectedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AppChooserWidget::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the content type to show applications for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_new" gtk_app_chooser_widget_new :: 
    CString ->                              -- content_type : TBasicType TUTF8
    IO (Ptr AppChooserWidget)

{-# DEPRECATED appChooserWidgetNew ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Creates a new @GtkAppChooserWidget@ for applications
-- that can handle content of the given type.
appChooserWidgetNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@contentType@/: the content type to show applications for
    -> m AppChooserWidget
    -- ^ __Returns:__ a newly created @GtkAppChooserWidget@
appChooserWidgetNew contentType = liftIO $ do
    contentType' <- textToCString contentType
    result <- gtk_app_chooser_widget_new contentType'
    checkUnexpectedReturnNULL "appChooserWidgetNew" result
    result' <- (newObject AppChooserWidget) result
    freeMem contentType'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppChooserWidget::get_default_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_get_default_text" gtk_app_chooser_widget_get_default_text :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    IO CString

{-# DEPRECATED appChooserWidgetGetDefaultText ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns the text that is shown if there are not applications
-- that can handle the content type.
appChooserWidgetGetDefaultText ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the value of [AppChooserWidget:defaultText]("GI.Gtk.Objects.AppChooserWidget#g:attr:defaultText")
appChooserWidgetGetDefaultText self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_widget_get_default_text self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetGetDefaultTextMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetGetDefaultTextMethodInfo a signature where
    overloadedMethod = appChooserWidgetGetDefaultText

instance O.OverloadedMethodInfo AppChooserWidgetGetDefaultTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetGetDefaultText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetGetDefaultText"
        })


#endif

-- method AppChooserWidget::get_show_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_get_show_all" gtk_app_chooser_widget_get_show_all :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    IO CInt

{-# DEPRECATED appChooserWidgetGetShowAll ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets whether the app chooser should show all applications
-- in a flat list.
appChooserWidgetGetShowAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> m Bool
    -- ^ __Returns:__ the value of [AppChooserWidget:showAll]("GI.Gtk.Objects.AppChooserWidget#g:attr:showAll")
appChooserWidgetGetShowAll self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_widget_get_show_all self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetGetShowAllMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetGetShowAllMethodInfo a signature where
    overloadedMethod = appChooserWidgetGetShowAll

instance O.OverloadedMethodInfo AppChooserWidgetGetShowAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetGetShowAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetGetShowAll"
        })


#endif

-- method AppChooserWidget::get_show_default
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_get_show_default" gtk_app_chooser_widget_get_show_default :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    IO CInt

{-# DEPRECATED appChooserWidgetGetShowDefault ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets whether the app chooser should show the default handler
-- for the content type in a separate section.
appChooserWidgetGetShowDefault ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> m Bool
    -- ^ __Returns:__ the value of [AppChooserWidget:showDefault]("GI.Gtk.Objects.AppChooserWidget#g:attr:showDefault")
appChooserWidgetGetShowDefault self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_widget_get_show_default self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetGetShowDefaultMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetGetShowDefaultMethodInfo a signature where
    overloadedMethod = appChooserWidgetGetShowDefault

instance O.OverloadedMethodInfo AppChooserWidgetGetShowDefaultMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetGetShowDefault",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetGetShowDefault"
        })


#endif

-- method AppChooserWidget::get_show_fallback
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_get_show_fallback" gtk_app_chooser_widget_get_show_fallback :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    IO CInt

{-# DEPRECATED appChooserWidgetGetShowFallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets whether the app chooser should show related applications
-- for the content type in a separate section.
appChooserWidgetGetShowFallback ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> m Bool
    -- ^ __Returns:__ the value of [AppChooserWidget:showFallback]("GI.Gtk.Objects.AppChooserWidget#g:attr:showFallback")
appChooserWidgetGetShowFallback self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_widget_get_show_fallback self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetGetShowFallbackMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetGetShowFallbackMethodInfo a signature where
    overloadedMethod = appChooserWidgetGetShowFallback

instance O.OverloadedMethodInfo AppChooserWidgetGetShowFallbackMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetGetShowFallback",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetGetShowFallback"
        })


#endif

-- method AppChooserWidget::get_show_other
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_get_show_other" gtk_app_chooser_widget_get_show_other :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    IO CInt

{-# DEPRECATED appChooserWidgetGetShowOther ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets whether the app chooser should show applications
-- which are unrelated to the content type.
appChooserWidgetGetShowOther ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> m Bool
    -- ^ __Returns:__ the value of [AppChooserWidget:showOther]("GI.Gtk.Objects.AppChooserWidget#g:attr:showOther")
appChooserWidgetGetShowOther self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_widget_get_show_other self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetGetShowOtherMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetGetShowOtherMethodInfo a signature where
    overloadedMethod = appChooserWidgetGetShowOther

instance O.OverloadedMethodInfo AppChooserWidgetGetShowOtherMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetGetShowOther",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetGetShowOther"
        })


#endif

-- method AppChooserWidget::get_show_recommended
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_get_show_recommended" gtk_app_chooser_widget_get_show_recommended :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    IO CInt

{-# DEPRECATED appChooserWidgetGetShowRecommended ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets whether the app chooser should show recommended applications
-- for the content type in a separate section.
appChooserWidgetGetShowRecommended ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> m Bool
    -- ^ __Returns:__ the value of [AppChooserWidget:showRecommended]("GI.Gtk.Objects.AppChooserWidget#g:attr:showRecommended")
appChooserWidgetGetShowRecommended self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_app_chooser_widget_get_show_recommended self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetGetShowRecommendedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetGetShowRecommendedMethodInfo a signature where
    overloadedMethod = appChooserWidgetGetShowRecommended

instance O.OverloadedMethodInfo AppChooserWidgetGetShowRecommendedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetGetShowRecommended",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetGetShowRecommended"
        })


#endif

-- method AppChooserWidget::set_default_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new value for [property@Gtk.AppChooserWidget:default-text]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_set_default_text" gtk_app_chooser_widget_set_default_text :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    CString ->                              -- text : TBasicType TUTF8
    IO ()

{-# DEPRECATED appChooserWidgetSetDefaultText ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets the text that is shown if there are not applications
-- that can handle the content type.
appChooserWidgetSetDefaultText ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> T.Text
    -- ^ /@text@/: the new value for [AppChooserWidget:defaultText]("GI.Gtk.Objects.AppChooserWidget#g:attr:defaultText")
    -> m ()
appChooserWidgetSetDefaultText self text = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    text' <- textToCString text
    gtk_app_chooser_widget_set_default_text self' text'
    touchManagedPtr self
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetSetDefaultTextMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetSetDefaultTextMethodInfo a signature where
    overloadedMethod = appChooserWidgetSetDefaultText

instance O.OverloadedMethodInfo AppChooserWidgetSetDefaultTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetSetDefaultText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetSetDefaultText"
        })


#endif

-- method AppChooserWidget::set_show_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the new value for [property@Gtk.AppChooserWidget:show-all]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_set_show_all" gtk_app_chooser_widget_set_show_all :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserWidgetSetShowAll ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the app chooser should show all applications
-- in a flat list.
appChooserWidgetSetShowAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> Bool
    -- ^ /@setting@/: the new value for [AppChooserWidget:showAll]("GI.Gtk.Objects.AppChooserWidget#g:attr:showAll")
    -> m ()
appChooserWidgetSetShowAll self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_app_chooser_widget_set_show_all self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetSetShowAllMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetSetShowAllMethodInfo a signature where
    overloadedMethod = appChooserWidgetSetShowAll

instance O.OverloadedMethodInfo AppChooserWidgetSetShowAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetSetShowAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetSetShowAll"
        })


#endif

-- method AppChooserWidget::set_show_default
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new value for [property@Gtk.AppChooserWidget:show-default]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_set_show_default" gtk_app_chooser_widget_set_show_default :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserWidgetSetShowDefault ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the app chooser should show the default handler
-- for the content type in a separate section.
appChooserWidgetSetShowDefault ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> Bool
    -- ^ /@setting@/: the new value for [AppChooserWidget:showDefault]("GI.Gtk.Objects.AppChooserWidget#g:attr:showDefault")
    -> m ()
appChooserWidgetSetShowDefault self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_app_chooser_widget_set_show_default self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetSetShowDefaultMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetSetShowDefaultMethodInfo a signature where
    overloadedMethod = appChooserWidgetSetShowDefault

instance O.OverloadedMethodInfo AppChooserWidgetSetShowDefaultMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetSetShowDefault",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetSetShowDefault"
        })


#endif

-- method AppChooserWidget::set_show_fallback
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new value for [property@Gtk.AppChooserWidget:show-fallback]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_set_show_fallback" gtk_app_chooser_widget_set_show_fallback :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserWidgetSetShowFallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the app chooser should show related applications
-- for the content type in a separate section.
appChooserWidgetSetShowFallback ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> Bool
    -- ^ /@setting@/: the new value for [AppChooserWidget:showFallback]("GI.Gtk.Objects.AppChooserWidget#g:attr:showFallback")
    -> m ()
appChooserWidgetSetShowFallback self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_app_chooser_widget_set_show_fallback self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetSetShowFallbackMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetSetShowFallbackMethodInfo a signature where
    overloadedMethod = appChooserWidgetSetShowFallback

instance O.OverloadedMethodInfo AppChooserWidgetSetShowFallbackMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetSetShowFallback",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetSetShowFallback"
        })


#endif

-- method AppChooserWidget::set_show_other
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the new value for [property@Gtk.AppChooserWidget:show-other]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_set_show_other" gtk_app_chooser_widget_set_show_other :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserWidgetSetShowOther ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the app chooser should show applications
-- which are unrelated to the content type.
appChooserWidgetSetShowOther ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> Bool
    -- ^ /@setting@/: the new value for [AppChooserWidget:showOther]("GI.Gtk.Objects.AppChooserWidget#g:attr:showOther")
    -> m ()
appChooserWidgetSetShowOther self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_app_chooser_widget_set_show_other self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetSetShowOtherMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetSetShowOtherMethodInfo a signature where
    overloadedMethod = appChooserWidgetSetShowOther

instance O.OverloadedMethodInfo AppChooserWidgetSetShowOtherMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetSetShowOther",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetSetShowOther"
        })


#endif

-- method AppChooserWidget::set_show_recommended
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AppChooserWidget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAppChooserWidget`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new value for [property@Gtk.AppChooserWidget:show-recommended]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_app_chooser_widget_set_show_recommended" gtk_app_chooser_widget_set_show_recommended :: 
    Ptr AppChooserWidget ->                 -- self : TInterface (Name {namespace = "Gtk", name = "AppChooserWidget"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED appChooserWidgetSetShowRecommended ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether the app chooser should show recommended applications
-- for the content type in a separate section.
appChooserWidgetSetShowRecommended ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppChooserWidget a) =>
    a
    -- ^ /@self@/: a @GtkAppChooserWidget@
    -> Bool
    -- ^ /@setting@/: the new value for [AppChooserWidget:showRecommended]("GI.Gtk.Objects.AppChooserWidget#g:attr:showRecommended")
    -> m ()
appChooserWidgetSetShowRecommended self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_app_chooser_widget_set_show_recommended self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AppChooserWidgetSetShowRecommendedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAppChooserWidget a) => O.OverloadedMethod AppChooserWidgetSetShowRecommendedMethodInfo a signature where
    overloadedMethod = appChooserWidgetSetShowRecommended

instance O.OverloadedMethodInfo AppChooserWidgetSetShowRecommendedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AppChooserWidget.appChooserWidgetSetShowRecommended",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AppChooserWidget.html#v:appChooserWidgetSetShowRecommended"
        })


#endif


