{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoGlyphInfo@ structure represents a single glyph with
-- positioning information and visual attributes.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.GlyphInfo
    ( 

-- * Exported types
    GlyphInfo(..)                           ,
    newZeroGlyphInfo                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphInfoMethod                  ,
#endif



 -- * Properties


-- ** attr #attr:attr#
-- | the visual attributes of the glyph.

    getGlyphInfoAttr                        ,
#if defined(ENABLE_OVERLOADING)
    glyphInfo_attr                          ,
#endif


-- ** geometry #attr:geometry#
-- | the positional information about the glyph.

    getGlyphInfoGeometry                    ,
#if defined(ENABLE_OVERLOADING)
    glyphInfo_geometry                      ,
#endif


-- ** glyph #attr:glyph#
-- | the glyph itself.

    getGlyphInfoGlyph                       ,
#if defined(ENABLE_OVERLOADING)
    glyphInfo_glyph                         ,
#endif
    setGlyphInfoGlyph                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphGeometry as Pango.GlyphGeometry
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphVisAttr as Pango.GlyphVisAttr

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphGeometry as Pango.GlyphGeometry
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphVisAttr as Pango.GlyphVisAttr

#endif

-- | Memory-managed wrapper type.
newtype GlyphInfo = GlyphInfo (SP.ManagedPtr GlyphInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype GlyphInfo where
    toManagedPtr (GlyphInfo p) = p

instance BoxedPtr GlyphInfo where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr GlyphInfo)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr GlyphInfo where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'GlyphInfo' struct initialized to zero.
newZeroGlyphInfo :: MonadIO m => m GlyphInfo
newZeroGlyphInfo = liftIO $ boxedPtrCalloc >>= wrapPtr GlyphInfo

instance tag ~ 'AttrSet => Constructible GlyphInfo tag where
    new _ attrs = do
        o <- newZeroGlyphInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphInfo #glyph
-- @
getGlyphInfoGlyph :: MonadIO m => GlyphInfo -> m Word32
getGlyphInfoGlyph s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphInfo [ #glyph 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphInfoGlyph :: MonadIO m => GlyphInfo -> Word32 -> m ()
setGlyphInfoGlyph s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data GlyphInfoGlyphFieldInfo
instance AttrInfo GlyphInfoGlyphFieldInfo where
    type AttrBaseTypeConstraint GlyphInfoGlyphFieldInfo = (~) GlyphInfo
    type AttrAllowedOps GlyphInfoGlyphFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphInfoGlyphFieldInfo = (~) Word32
    type AttrTransferTypeConstraint GlyphInfoGlyphFieldInfo = (~)Word32
    type AttrTransferType GlyphInfoGlyphFieldInfo = Word32
    type AttrGetType GlyphInfoGlyphFieldInfo = Word32
    type AttrLabel GlyphInfoGlyphFieldInfo = "glyph"
    type AttrOrigin GlyphInfoGlyphFieldInfo = GlyphInfo
    attrGet = getGlyphInfoGlyph
    attrSet = setGlyphInfoGlyph
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphInfo.glyph"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphInfo.html#g:attr:glyph"
        })

glyphInfo_glyph :: AttrLabelProxy "glyph"
glyphInfo_glyph = AttrLabelProxy

#endif


-- | Get the value of the “@geometry@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphInfo #geometry
-- @
getGlyphInfoGeometry :: MonadIO m => GlyphInfo -> m Pango.GlyphGeometry.GlyphGeometry
getGlyphInfoGeometry s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 4 :: (Ptr Pango.GlyphGeometry.GlyphGeometry)
    val' <- (newPtr Pango.GlyphGeometry.GlyphGeometry) val
    return val'

#if defined(ENABLE_OVERLOADING)
data GlyphInfoGeometryFieldInfo
instance AttrInfo GlyphInfoGeometryFieldInfo where
    type AttrBaseTypeConstraint GlyphInfoGeometryFieldInfo = (~) GlyphInfo
    type AttrAllowedOps GlyphInfoGeometryFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint GlyphInfoGeometryFieldInfo = (~) (Ptr Pango.GlyphGeometry.GlyphGeometry)
    type AttrTransferTypeConstraint GlyphInfoGeometryFieldInfo = (~)(Ptr Pango.GlyphGeometry.GlyphGeometry)
    type AttrTransferType GlyphInfoGeometryFieldInfo = (Ptr Pango.GlyphGeometry.GlyphGeometry)
    type AttrGetType GlyphInfoGeometryFieldInfo = Pango.GlyphGeometry.GlyphGeometry
    type AttrLabel GlyphInfoGeometryFieldInfo = "geometry"
    type AttrOrigin GlyphInfoGeometryFieldInfo = GlyphInfo
    attrGet = getGlyphInfoGeometry
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphInfo.geometry"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphInfo.html#g:attr:geometry"
        })

glyphInfo_geometry :: AttrLabelProxy "geometry"
glyphInfo_geometry = AttrLabelProxy

#endif


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphInfo #attr
-- @
getGlyphInfoAttr :: MonadIO m => GlyphInfo -> m Pango.GlyphVisAttr.GlyphVisAttr
getGlyphInfoAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 16 :: (Ptr Pango.GlyphVisAttr.GlyphVisAttr)
    val' <- (newPtr Pango.GlyphVisAttr.GlyphVisAttr) val
    return val'

#if defined(ENABLE_OVERLOADING)
data GlyphInfoAttrFieldInfo
instance AttrInfo GlyphInfoAttrFieldInfo where
    type AttrBaseTypeConstraint GlyphInfoAttrFieldInfo = (~) GlyphInfo
    type AttrAllowedOps GlyphInfoAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint GlyphInfoAttrFieldInfo = (~) (Ptr Pango.GlyphVisAttr.GlyphVisAttr)
    type AttrTransferTypeConstraint GlyphInfoAttrFieldInfo = (~)(Ptr Pango.GlyphVisAttr.GlyphVisAttr)
    type AttrTransferType GlyphInfoAttrFieldInfo = (Ptr Pango.GlyphVisAttr.GlyphVisAttr)
    type AttrGetType GlyphInfoAttrFieldInfo = Pango.GlyphVisAttr.GlyphVisAttr
    type AttrLabel GlyphInfoAttrFieldInfo = "attr"
    type AttrOrigin GlyphInfoAttrFieldInfo = GlyphInfo
    attrGet = getGlyphInfoAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphInfo.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphInfo.html#g:attr:attr"
        })

glyphInfo_attr :: AttrLabelProxy "attr"
glyphInfo_attr = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GlyphInfo
type instance O.AttributeList GlyphInfo = GlyphInfoAttributeList
type GlyphInfoAttributeList = ('[ '("glyph", GlyphInfoGlyphFieldInfo), '("geometry", GlyphInfoGeometryFieldInfo), '("attr", GlyphInfoAttrFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphInfoMethod t GlyphInfo, O.OverloadedMethod info GlyphInfo p) => OL.IsLabel t (GlyphInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphInfoMethod t GlyphInfo, O.OverloadedMethod info GlyphInfo p, R.HasField t GlyphInfo p) => R.HasField t GlyphInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphInfoMethod t GlyphInfo, O.OverloadedMethodInfo info GlyphInfo) => OL.IsLabel t (O.MethodProxy info GlyphInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


