#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1908
#define LARGE_STATE_COUNT 252
#define SYMBOL_COUNT 243
#define ALIAS_COUNT 4
#define TOKEN_COUNT 106
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 146

enum ts_symbol_identifiers {
  anon_sym_LBRACE = 1,
  anon_sym_RBRACE = 2,
  anon_sym_impl = 3,
  anon_sym_of = 4,
  anon_sym_SEMI = 5,
  anon_sym_trait = 6,
  anon_sym_type = 7,
  anon_sym_COLON = 8,
  anon_sym_const = 9,
  anon_sym_EQ = 10,
  anon_sym_BANG = 11,
  anon_sym_POUND = 12,
  anon_sym_LBRACK = 13,
  anon_sym_RBRACK = 14,
  anon_sym_mod = 15,
  anon_sym_struct = 16,
  anon_sym_enum = 17,
  anon_sym_COMMA = 18,
  anon_sym_fn = 19,
  anon_sym_DASH_GT = 20,
  anon_sym_implicits = 21,
  anon_sym_let = 22,
  anon_sym_use = 23,
  anon_sym_COLON_COLON = 24,
  anon_sym_as = 25,
  anon_sym_STAR = 26,
  anon_sym_LPAREN = 27,
  anon_sym__ = 28,
  anon_sym_RPAREN = 29,
  anon_sym_u8 = 30,
  anon_sym_i8 = 31,
  anon_sym_u16 = 32,
  anon_sym_i16 = 33,
  anon_sym_u32 = 34,
  anon_sym_i32 = 35,
  anon_sym_u64 = 36,
  anon_sym_i64 = 37,
  anon_sym_u128 = 38,
  anon_sym_i128 = 39,
  anon_sym_usize = 40,
  anon_sym_bool = 41,
  anon_sym_ByteArray = 42,
  anon_sym_felt252 = 43,
  anon_sym_LT = 44,
  anon_sym_GT = 45,
  anon_sym_PLUS = 46,
  anon_sym_DASH = 47,
  anon_sym_SLASH = 48,
  anon_sym_PERCENT = 49,
  anon_sym_CARET = 50,
  anon_sym_TILDE = 51,
  anon_sym_AMP = 52,
  anon_sym_PIPE = 53,
  anon_sym_AMP_AMP = 54,
  anon_sym_PIPE_PIPE = 55,
  anon_sym_LT_LT = 56,
  anon_sym_GT_GT = 57,
  anon_sym_PLUS_EQ = 58,
  anon_sym_DASH_EQ = 59,
  anon_sym_STAR_EQ = 60,
  anon_sym_SLASH_EQ = 61,
  anon_sym_PERCENT_EQ = 62,
  anon_sym_CARET_EQ = 63,
  anon_sym_AMP_EQ = 64,
  anon_sym_PIPE_EQ = 65,
  anon_sym_EQ_EQ = 66,
  anon_sym_BANG_EQ = 67,
  anon_sym_GT_EQ = 68,
  anon_sym_LT_EQ = 69,
  anon_sym_AT = 70,
  anon_sym_DOT_DOT = 71,
  anon_sym_DOT = 72,
  anon_sym_EQ_GT = 73,
  anon_sym_QMARK = 74,
  anon_sym_break = 75,
  anon_sym_continue = 76,
  anon_sym_default = 77,
  anon_sym_if = 78,
  anon_sym_extern = 79,
  anon_sym_nopanic = 80,
  anon_sym_loop = 81,
  anon_sym_match = 82,
  anon_sym_pub = 83,
  anon_sym_return = 84,
  anon_sym_static = 85,
  anon_sym_while = 86,
  anon_sym_for = 87,
  sym_numeric_literal = 88,
  aux_sym_string_literal_token1 = 89,
  aux_sym_string_literal_token2 = 90,
  anon_sym_DQUOTE = 91,
  sym_shortstring_literal = 92,
  anon_sym_true = 93,
  anon_sym_false = 94,
  anon_sym_DOLLAR = 95,
  anon_sym_LT2 = 96,
  anon_sym_else = 97,
  anon_sym_move = 98,
  anon_sym_in = 99,
  anon_sym_ref = 100,
  sym_identifier = 101,
  sym_mutable_specifier = 102,
  sym_super = 103,
  sym_crate = 104,
  sym_line_comment = 105,
  sym_source_file = 106,
  sym__statement = 107,
  sym_declaration_list = 108,
  sym_impl_item = 109,
  sym_trait_item = 110,
  sym_associated_type = 111,
  sym_associated_impl = 112,
  sym_const_item = 113,
  sym_macro_invocation = 114,
  sym_empty_statement = 115,
  sym_attribute_item = 116,
  sym_inner_attribute_item = 117,
  sym_attribute = 118,
  sym_mod_item = 119,
  sym_struct_item = 120,
  sym_enum_item = 121,
  sym_enum_variant_list = 122,
  sym_enum_variant = 123,
  sym_field_declaration_list = 124,
  sym_field_declaration = 125,
  sym_type_item = 126,
  sym_extern_type = 127,
  sym_external_function_item = 128,
  sym_function_item = 129,
  sym_function_signature_item = 130,
  sym_function = 131,
  sym_let_declaration = 132,
  sym_use_declaration = 133,
  sym__use_clause = 134,
  sym_scoped_use_list = 135,
  sym_use_list = 136,
  sym_use_as_clause = 137,
  sym_use_wildcard = 138,
  sym_parameters = 139,
  sym_parameter = 140,
  sym__type = 141,
  sym_type_parameters = 142,
  sym_const_parameter = 143,
  sym_constrained_type_parameter = 144,
  sym_generic_type = 145,
  sym_generic_type_with_turbofish = 146,
  sym_array_type = 147,
  sym_delim_token_tree = 148,
  sym__delim_tokens = 149,
  sym__pattern = 150,
  sym_tuple_pattern = 151,
  sym_range_pattern = 152,
  sym_slice_pattern = 153,
  sym_struct_pattern = 154,
  sym_field_pattern = 155,
  sym_field_initializer_list = 156,
  sym_shorthand_field_initializer = 157,
  sym_field_initializer = 158,
  sym_base_field_initializer = 159,
  sym_mut_pattern = 160,
  sym_or_pattern = 161,
  sym__literal = 162,
  sym__literal_pattern = 163,
  sym_negative_literal = 164,
  sym_string_literal = 165,
  sym_boolean_literal = 166,
  sym__non_delim_token = 167,
  sym_scoped_identifier = 168,
  sym_scoped_type_identifier_in_expression_position = 169,
  sym_scoped_type_identifier = 170,
  sym_tuple_type = 171,
  sym_unit_type = 172,
  sym_type_arguments = 173,
  sym_expression_statement = 174,
  sym_expression = 175,
  sym_expression_except_range = 176,
  sym_generic_function = 177,
  sym_tuple_expression = 178,
  sym_return_expression = 179,
  sym_struct_expression = 180,
  sym_assignment_expression = 181,
  sym_break_expression = 182,
  sym_continue_expression = 183,
  sym_index_expression = 184,
  sym_array_expression = 185,
  sym_parenthesized_expression = 186,
  sym_unit_expression = 187,
  sym_compound_assignment_expr = 188,
  sym__expression_ending_with_block = 189,
  sym_unary_expression = 190,
  sym_range_expression = 191,
  sym_try_expression = 192,
  sym_field_expression = 193,
  sym_block = 194,
  sym_if_expression = 195,
  sym__condition = 196,
  sym_let_condition = 197,
  sym_else_clause = 198,
  sym_match_expression = 199,
  sym_match_block = 200,
  sym_match_arm = 201,
  sym_last_match_arm = 202,
  sym_tuple_enum_pattern = 203,
  sym_match_pattern = 204,
  sym_while_expression = 205,
  sym_closure_expression = 206,
  sym_closure_parameters = 207,
  sym_for_expression = 208,
  sym_loop_expression = 209,
  sym_binary_expression = 210,
  sym_snapshot_type = 211,
  sym_call_expression = 212,
  sym_arguments = 213,
  sym_named_argument = 214,
  sym_reference_expression = 215,
  sym_visibility_modifier = 216,
  sym_extern = 217,
  sym_nopanic = 218,
  sym_ref_specifier = 219,
  aux_sym_source_file_repeat1 = 220,
  aux_sym_declaration_list_repeat1 = 221,
  aux_sym_enum_variant_list_repeat1 = 222,
  aux_sym_enum_variant_list_repeat2 = 223,
  aux_sym_field_declaration_list_repeat1 = 224,
  aux_sym_function_repeat1 = 225,
  aux_sym_use_list_repeat1 = 226,
  aux_sym_parameters_repeat1 = 227,
  aux_sym_type_parameters_repeat1 = 228,
  aux_sym_constrained_type_parameter_repeat1 = 229,
  aux_sym_delim_token_tree_repeat1 = 230,
  aux_sym__non_special_token_repeat1 = 231,
  aux_sym_tuple_pattern_repeat1 = 232,
  aux_sym_slice_pattern_repeat1 = 233,
  aux_sym_struct_pattern_repeat1 = 234,
  aux_sym_field_initializer_list_repeat1 = 235,
  aux_sym_type_arguments_repeat1 = 236,
  aux_sym_tuple_expression_repeat1 = 237,
  aux_sym_array_expression_repeat1 = 238,
  aux_sym_match_block_repeat1 = 239,
  aux_sym_match_arm_repeat1 = 240,
  aux_sym_closure_parameters_repeat1 = 241,
  aux_sym_arguments_repeat1 = 242,
  alias_sym_field_identifier = 243,
  alias_sym_primitive_type = 244,
  alias_sym_shorthand_field_identifier = 245,
  alias_sym_type_identifier = 246,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_impl] = "impl",
  [anon_sym_of] = "of",
  [anon_sym_SEMI] = ";",
  [anon_sym_trait] = "trait",
  [anon_sym_type] = "type",
  [anon_sym_COLON] = ":",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_mod] = "mod",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_COMMA] = ",",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_implicits] = "implicits",
  [anon_sym_let] = "let",
  [anon_sym_use] = "use",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_LPAREN] = "(",
  [anon_sym__] = "_",
  [anon_sym_RPAREN] = ")",
  [anon_sym_u8] = "identifier",
  [anon_sym_i8] = "identifier",
  [anon_sym_u16] = "identifier",
  [anon_sym_i16] = "identifier",
  [anon_sym_u32] = "identifier",
  [anon_sym_i32] = "identifier",
  [anon_sym_u64] = "identifier",
  [anon_sym_i64] = "identifier",
  [anon_sym_u128] = "identifier",
  [anon_sym_i128] = "identifier",
  [anon_sym_usize] = "identifier",
  [anon_sym_bool] = "identifier",
  [anon_sym_ByteArray] = "identifier",
  [anon_sym_felt252] = "identifier",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_CARET] = "^",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_AT] = "@",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_DOT] = ".",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK] = "\?",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_default] = "default",
  [anon_sym_if] = "if",
  [anon_sym_extern] = "extern",
  [anon_sym_nopanic] = "nopanic",
  [anon_sym_loop] = "loop",
  [anon_sym_match] = "match",
  [anon_sym_pub] = "pub",
  [anon_sym_return] = "return",
  [anon_sym_static] = "static",
  [anon_sym_while] = "while",
  [anon_sym_for] = "for",
  [sym_numeric_literal] = "numeric_literal",
  [aux_sym_string_literal_token1] = "\"",
  [aux_sym_string_literal_token2] = "string_literal_token2",
  [anon_sym_DQUOTE] = "\"",
  [sym_shortstring_literal] = "shortstring_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LT2] = "<",
  [anon_sym_else] = "else",
  [anon_sym_move] = "move",
  [anon_sym_in] = "in",
  [anon_sym_ref] = "ref",
  [sym_identifier] = "identifier",
  [sym_mutable_specifier] = "mutable_specifier",
  [sym_super] = "super",
  [sym_crate] = "crate",
  [sym_line_comment] = "line_comment",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym_declaration_list] = "declaration_list",
  [sym_impl_item] = "impl_item",
  [sym_trait_item] = "trait_item",
  [sym_associated_type] = "associated_type",
  [sym_associated_impl] = "associated_impl",
  [sym_const_item] = "const_item",
  [sym_macro_invocation] = "macro_invocation",
  [sym_empty_statement] = "empty_statement",
  [sym_attribute_item] = "attribute_item",
  [sym_inner_attribute_item] = "inner_attribute_item",
  [sym_attribute] = "attribute",
  [sym_mod_item] = "mod_item",
  [sym_struct_item] = "struct_item",
  [sym_enum_item] = "enum_item",
  [sym_enum_variant_list] = "enum_variant_list",
  [sym_enum_variant] = "enum_variant",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym_field_declaration] = "field_declaration",
  [sym_type_item] = "type_item",
  [sym_extern_type] = "extern_type",
  [sym_external_function_item] = "external_function_item",
  [sym_function_item] = "function_item",
  [sym_function_signature_item] = "function_signature_item",
  [sym_function] = "function",
  [sym_let_declaration] = "let_declaration",
  [sym_use_declaration] = "use_declaration",
  [sym__use_clause] = "_use_clause",
  [sym_scoped_use_list] = "scoped_use_list",
  [sym_use_list] = "use_list",
  [sym_use_as_clause] = "use_as_clause",
  [sym_use_wildcard] = "use_wildcard",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym__type] = "_type",
  [sym_type_parameters] = "type_parameters",
  [sym_const_parameter] = "const_parameter",
  [sym_constrained_type_parameter] = "constrained_type_parameter",
  [sym_generic_type] = "generic_type",
  [sym_generic_type_with_turbofish] = "generic_type_with_turbofish",
  [sym_array_type] = "array_type",
  [sym_delim_token_tree] = "token_tree",
  [sym__delim_tokens] = "_delim_tokens",
  [sym__pattern] = "_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_range_pattern] = "range_pattern",
  [sym_slice_pattern] = "slice_pattern",
  [sym_struct_pattern] = "struct_pattern",
  [sym_field_pattern] = "field_pattern",
  [sym_field_initializer_list] = "field_initializer_list",
  [sym_shorthand_field_initializer] = "shorthand_field_initializer",
  [sym_field_initializer] = "field_initializer",
  [sym_base_field_initializer] = "base_field_initializer",
  [sym_mut_pattern] = "mut_pattern",
  [sym_or_pattern] = "or_pattern",
  [sym__literal] = "_literal",
  [sym__literal_pattern] = "_literal_pattern",
  [sym_negative_literal] = "negative_literal",
  [sym_string_literal] = "string_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym__non_delim_token] = "_non_delim_token",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_scoped_type_identifier_in_expression_position] = "scoped_type_identifier",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_tuple_type] = "tuple_type",
  [sym_unit_type] = "unit_type",
  [sym_type_arguments] = "type_arguments",
  [sym_expression_statement] = "expression_statement",
  [sym_expression] = "expression",
  [sym_expression_except_range] = "expression_except_range",
  [sym_generic_function] = "generic_function",
  [sym_tuple_expression] = "tuple_expression",
  [sym_return_expression] = "return_expression",
  [sym_struct_expression] = "struct_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_break_expression] = "break_expression",
  [sym_continue_expression] = "continue_expression",
  [sym_index_expression] = "index_expression",
  [sym_array_expression] = "array_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_unit_expression] = "unit_expression",
  [sym_compound_assignment_expr] = "compound_assignment_expr",
  [sym__expression_ending_with_block] = "_expression_ending_with_block",
  [sym_unary_expression] = "unary_expression",
  [sym_range_expression] = "range_expression",
  [sym_try_expression] = "try_expression",
  [sym_field_expression] = "field_expression",
  [sym_block] = "block",
  [sym_if_expression] = "if_expression",
  [sym__condition] = "_condition",
  [sym_let_condition] = "let_condition",
  [sym_else_clause] = "else_clause",
  [sym_match_expression] = "match_expression",
  [sym_match_block] = "match_block",
  [sym_match_arm] = "match_arm",
  [sym_last_match_arm] = "match_arm",
  [sym_tuple_enum_pattern] = "tuple_enum_pattern",
  [sym_match_pattern] = "match_pattern",
  [sym_while_expression] = "while_expression",
  [sym_closure_expression] = "closure_expression",
  [sym_closure_parameters] = "closure_parameters",
  [sym_for_expression] = "for_expression",
  [sym_loop_expression] = "loop_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_snapshot_type] = "snapshot_type",
  [sym_call_expression] = "call_expression",
  [sym_arguments] = "arguments",
  [sym_named_argument] = "named_argument",
  [sym_reference_expression] = "reference_expression",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_extern] = "extern",
  [sym_nopanic] = "nopanic",
  [sym_ref_specifier] = "ref_specifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_declaration_list_repeat1] = "declaration_list_repeat1",
  [aux_sym_enum_variant_list_repeat1] = "enum_variant_list_repeat1",
  [aux_sym_enum_variant_list_repeat2] = "enum_variant_list_repeat2",
  [aux_sym_field_declaration_list_repeat1] = "field_declaration_list_repeat1",
  [aux_sym_function_repeat1] = "function_repeat1",
  [aux_sym_use_list_repeat1] = "use_list_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_constrained_type_parameter_repeat1] = "constrained_type_parameter_repeat1",
  [aux_sym_delim_token_tree_repeat1] = "delim_token_tree_repeat1",
  [aux_sym__non_special_token_repeat1] = "_non_special_token_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [aux_sym_slice_pattern_repeat1] = "slice_pattern_repeat1",
  [aux_sym_struct_pattern_repeat1] = "struct_pattern_repeat1",
  [aux_sym_field_initializer_list_repeat1] = "field_initializer_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_array_expression_repeat1] = "array_expression_repeat1",
  [aux_sym_match_block_repeat1] = "match_block_repeat1",
  [aux_sym_match_arm_repeat1] = "match_arm_repeat1",
  [aux_sym_closure_parameters_repeat1] = "closure_parameters_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_primitive_type] = "primitive_type",
  [alias_sym_shorthand_field_identifier] = "shorthand_field_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_impl] = anon_sym_impl,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_trait] = anon_sym_trait,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_implicits] = anon_sym_implicits,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym__] = anon_sym__,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_u8] = sym_identifier,
  [anon_sym_i8] = sym_identifier,
  [anon_sym_u16] = sym_identifier,
  [anon_sym_i16] = sym_identifier,
  [anon_sym_u32] = sym_identifier,
  [anon_sym_i32] = sym_identifier,
  [anon_sym_u64] = sym_identifier,
  [anon_sym_i64] = sym_identifier,
  [anon_sym_u128] = sym_identifier,
  [anon_sym_i128] = sym_identifier,
  [anon_sym_usize] = sym_identifier,
  [anon_sym_bool] = sym_identifier,
  [anon_sym_ByteArray] = sym_identifier,
  [anon_sym_felt252] = sym_identifier,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym_nopanic] = anon_sym_nopanic,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_pub] = anon_sym_pub,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_for] = anon_sym_for,
  [sym_numeric_literal] = sym_numeric_literal,
  [aux_sym_string_literal_token1] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token2] = aux_sym_string_literal_token2,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_shortstring_literal] = sym_shortstring_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LT2] = anon_sym_LT,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_move] = anon_sym_move,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_ref] = anon_sym_ref,
  [sym_identifier] = sym_identifier,
  [sym_mutable_specifier] = sym_mutable_specifier,
  [sym_super] = sym_super,
  [sym_crate] = sym_crate,
  [sym_line_comment] = sym_line_comment,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym_declaration_list] = sym_declaration_list,
  [sym_impl_item] = sym_impl_item,
  [sym_trait_item] = sym_trait_item,
  [sym_associated_type] = sym_associated_type,
  [sym_associated_impl] = sym_associated_impl,
  [sym_const_item] = sym_const_item,
  [sym_macro_invocation] = sym_macro_invocation,
  [sym_empty_statement] = sym_empty_statement,
  [sym_attribute_item] = sym_attribute_item,
  [sym_inner_attribute_item] = sym_inner_attribute_item,
  [sym_attribute] = sym_attribute,
  [sym_mod_item] = sym_mod_item,
  [sym_struct_item] = sym_struct_item,
  [sym_enum_item] = sym_enum_item,
  [sym_enum_variant_list] = sym_enum_variant_list,
  [sym_enum_variant] = sym_enum_variant,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym_field_declaration] = sym_field_declaration,
  [sym_type_item] = sym_type_item,
  [sym_extern_type] = sym_extern_type,
  [sym_external_function_item] = sym_external_function_item,
  [sym_function_item] = sym_function_item,
  [sym_function_signature_item] = sym_function_signature_item,
  [sym_function] = sym_function,
  [sym_let_declaration] = sym_let_declaration,
  [sym_use_declaration] = sym_use_declaration,
  [sym__use_clause] = sym__use_clause,
  [sym_scoped_use_list] = sym_scoped_use_list,
  [sym_use_list] = sym_use_list,
  [sym_use_as_clause] = sym_use_as_clause,
  [sym_use_wildcard] = sym_use_wildcard,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym__type] = sym__type,
  [sym_type_parameters] = sym_type_parameters,
  [sym_const_parameter] = sym_const_parameter,
  [sym_constrained_type_parameter] = sym_constrained_type_parameter,
  [sym_generic_type] = sym_generic_type,
  [sym_generic_type_with_turbofish] = sym_generic_type_with_turbofish,
  [sym_array_type] = sym_array_type,
  [sym_delim_token_tree] = sym_delim_token_tree,
  [sym__delim_tokens] = sym__delim_tokens,
  [sym__pattern] = sym__pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_range_pattern] = sym_range_pattern,
  [sym_slice_pattern] = sym_slice_pattern,
  [sym_struct_pattern] = sym_struct_pattern,
  [sym_field_pattern] = sym_field_pattern,
  [sym_field_initializer_list] = sym_field_initializer_list,
  [sym_shorthand_field_initializer] = sym_shorthand_field_initializer,
  [sym_field_initializer] = sym_field_initializer,
  [sym_base_field_initializer] = sym_base_field_initializer,
  [sym_mut_pattern] = sym_mut_pattern,
  [sym_or_pattern] = sym_or_pattern,
  [sym__literal] = sym__literal,
  [sym__literal_pattern] = sym__literal_pattern,
  [sym_negative_literal] = sym_negative_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym__non_delim_token] = sym__non_delim_token,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_scoped_type_identifier_in_expression_position] = sym_scoped_type_identifier,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_tuple_type] = sym_tuple_type,
  [sym_unit_type] = sym_unit_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_expression_statement] = sym_expression_statement,
  [sym_expression] = sym_expression,
  [sym_expression_except_range] = sym_expression_except_range,
  [sym_generic_function] = sym_generic_function,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_return_expression] = sym_return_expression,
  [sym_struct_expression] = sym_struct_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_break_expression] = sym_break_expression,
  [sym_continue_expression] = sym_continue_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_array_expression] = sym_array_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_unit_expression] = sym_unit_expression,
  [sym_compound_assignment_expr] = sym_compound_assignment_expr,
  [sym__expression_ending_with_block] = sym__expression_ending_with_block,
  [sym_unary_expression] = sym_unary_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_try_expression] = sym_try_expression,
  [sym_field_expression] = sym_field_expression,
  [sym_block] = sym_block,
  [sym_if_expression] = sym_if_expression,
  [sym__condition] = sym__condition,
  [sym_let_condition] = sym_let_condition,
  [sym_else_clause] = sym_else_clause,
  [sym_match_expression] = sym_match_expression,
  [sym_match_block] = sym_match_block,
  [sym_match_arm] = sym_match_arm,
  [sym_last_match_arm] = sym_match_arm,
  [sym_tuple_enum_pattern] = sym_tuple_enum_pattern,
  [sym_match_pattern] = sym_match_pattern,
  [sym_while_expression] = sym_while_expression,
  [sym_closure_expression] = sym_closure_expression,
  [sym_closure_parameters] = sym_closure_parameters,
  [sym_for_expression] = sym_for_expression,
  [sym_loop_expression] = sym_loop_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_snapshot_type] = sym_snapshot_type,
  [sym_call_expression] = sym_call_expression,
  [sym_arguments] = sym_arguments,
  [sym_named_argument] = sym_named_argument,
  [sym_reference_expression] = sym_reference_expression,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_extern] = sym_extern,
  [sym_nopanic] = sym_nopanic,
  [sym_ref_specifier] = sym_ref_specifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_declaration_list_repeat1] = aux_sym_declaration_list_repeat1,
  [aux_sym_enum_variant_list_repeat1] = aux_sym_enum_variant_list_repeat1,
  [aux_sym_enum_variant_list_repeat2] = aux_sym_enum_variant_list_repeat2,
  [aux_sym_field_declaration_list_repeat1] = aux_sym_field_declaration_list_repeat1,
  [aux_sym_function_repeat1] = aux_sym_function_repeat1,
  [aux_sym_use_list_repeat1] = aux_sym_use_list_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_constrained_type_parameter_repeat1] = aux_sym_constrained_type_parameter_repeat1,
  [aux_sym_delim_token_tree_repeat1] = aux_sym_delim_token_tree_repeat1,
  [aux_sym__non_special_token_repeat1] = aux_sym__non_special_token_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [aux_sym_slice_pattern_repeat1] = aux_sym_slice_pattern_repeat1,
  [aux_sym_struct_pattern_repeat1] = aux_sym_struct_pattern_repeat1,
  [aux_sym_field_initializer_list_repeat1] = aux_sym_field_initializer_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_array_expression_repeat1] = aux_sym_array_expression_repeat1,
  [aux_sym_match_block_repeat1] = aux_sym_match_block_repeat1,
  [aux_sym_match_arm_repeat1] = aux_sym_match_arm_repeat1,
  [aux_sym_closure_parameters_repeat1] = aux_sym_closure_parameters_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_primitive_type] = alias_sym_primitive_type,
  [alias_sym_shorthand_field_identifier] = alias_sym_shorthand_field_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_impl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implicits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_usize] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ByteArray] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_felt252] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nopanic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [sym_numeric_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_shortstring_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_mutable_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_crate] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_impl_item] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_item] = {
    .visible = true,
    .named = true,
  },
  [sym_associated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_associated_impl] = {
    .visible = true,
    .named = true,
  },
  [sym_const_item] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_item] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_attribute_item] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_mod_item] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_item] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_item] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant_list] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_item] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_let_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_use_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__use_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_scoped_use_list] = {
    .visible = true,
    .named = true,
  },
  [sym_use_list] = {
    .visible = true,
    .named = true,
  },
  [sym_use_as_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_use_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_const_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type_with_turbofish] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_delim_token_tree] = {
    .visible = true,
    .named = true,
  },
  [sym__delim_tokens] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_range_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_field_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_shorthand_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_base_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_mut_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__literal_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_negative_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__non_delim_token] = {
    .visible = false,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier_in_expression_position] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_except_range] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_generic_function] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_return_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_break_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assignment_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_ending_with_block] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__condition] = {
    .visible = false,
    .named = true,
  },
  [sym_let_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_match_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_last_match_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_enum_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_match_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_while_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_closure_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_closure_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_for_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_snapshot_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_extern] = {
    .visible = true,
    .named = true,
  },
  [sym_nopanic] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_variant_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_variant_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constrained_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_delim_token_tree_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__non_special_token_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_slice_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_arm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_closure_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_bound = 6,
  field_condition = 7,
  field_consequence = 8,
  field_element = 9,
  field_field = 10,
  field_function = 11,
  field_implicit_arguments = 12,
  field_left = 13,
  field_length = 14,
  field_list = 15,
  field_macro = 16,
  field_name = 17,
  field_operator = 18,
  field_parameters = 19,
  field_path = 20,
  field_pattern = 21,
  field_return_type = 22,
  field_right = 23,
  field_type = 24,
  field_type_arguments = 25,
  field_type_parameters = 26,
  field_value = 27,
  field_variant = 28,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_bound] = "bound",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_element] = "element",
  [field_field] = "field",
  [field_function] = "function",
  [field_implicit_arguments] = "implicit_arguments",
  [field_left] = "left",
  [field_length] = "length",
  [field_list] = "list",
  [field_macro] = "macro",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
  [field_variant] = "variant",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 3, .length = 2},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 2},
  [13] = {.index = 13, .length = 2},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 15, .length = 1},
  [16] = {.index = 13, .length = 2},
  [17] = {.index = 16, .length = 1},
  [18] = {.index = 17, .length = 1},
  [19] = {.index = 18, .length = 2},
  [20] = {.index = 18, .length = 2},
  [21] = {.index = 20, .length = 1},
  [22] = {.index = 18, .length = 2},
  [23] = {.index = 18, .length = 2},
  [24] = {.index = 21, .length = 2},
  [25] = {.index = 23, .length = 2},
  [26] = {.index = 25, .length = 2},
  [27] = {.index = 27, .length = 2},
  [28] = {.index = 29, .length = 2},
  [29] = {.index = 31, .length = 1},
  [30] = {.index = 20, .length = 1},
  [31] = {.index = 21, .length = 2},
  [32] = {.index = 32, .length = 2},
  [33] = {.index = 18, .length = 2},
  [34] = {.index = 18, .length = 2},
  [35] = {.index = 21, .length = 2},
  [36] = {.index = 34, .length = 2},
  [37] = {.index = 36, .length = 3},
  [38] = {.index = 39, .length = 2},
  [39] = {.index = 39, .length = 2},
  [42] = {.index = 41, .length = 1},
  [43] = {.index = 42, .length = 2},
  [44] = {.index = 44, .length = 3},
  [45] = {.index = 47, .length = 2},
  [46] = {.index = 49, .length = 1},
  [47] = {.index = 49, .length = 1},
  [48] = {.index = 50, .length = 1},
  [49] = {.index = 51, .length = 3},
  [50] = {.index = 54, .length = 3},
  [53] = {.index = 57, .length = 1},
  [54] = {.index = 58, .length = 1},
  [55] = {.index = 57, .length = 1},
  [56] = {.index = 59, .length = 1},
  [57] = {.index = 57, .length = 1},
  [58] = {.index = 60, .length = 2},
  [59] = {.index = 62, .length = 2},
  [60] = {.index = 60, .length = 2},
  [61] = {.index = 62, .length = 2},
  [62] = {.index = 64, .length = 2},
  [63] = {.index = 66, .length = 3},
  [64] = {.index = 69, .length = 1},
  [65] = {.index = 70, .length = 3},
  [66] = {.index = 73, .length = 1},
  [67] = {.index = 74, .length = 2},
  [68] = {.index = 73, .length = 1},
  [69] = {.index = 74, .length = 2},
  [70] = {.index = 76, .length = 1},
  [71] = {.index = 77, .length = 1},
  [72] = {.index = 78, .length = 2},
  [74] = {.index = 80, .length = 3},
  [75] = {.index = 83, .length = 3},
  [76] = {.index = 78, .length = 2},
  [77] = {.index = 31, .length = 1},
  [78] = {.index = 86, .length = 1},
  [79] = {.index = 87, .length = 1},
  [80] = {.index = 88, .length = 3},
  [81] = {.index = 91, .length = 4},
  [82] = {.index = 95, .length = 4},
  [83] = {.index = 0, .length = 1},
  [84] = {.index = 99, .length = 2},
  [85] = {.index = 101, .length = 2},
  [87] = {.index = 103, .length = 3},
  [88] = {.index = 106, .length = 3},
  [89] = {.index = 109, .length = 2},
  [90] = {.index = 109, .length = 2},
  [91] = {.index = 111, .length = 1},
  [92] = {.index = 112, .length = 2},
  [93] = {.index = 114, .length = 3},
  [94] = {.index = 117, .length = 1},
  [96] = {.index = 118, .length = 1},
  [97] = {.index = 119, .length = 2},
  [98] = {.index = 121, .length = 3},
  [99] = {.index = 124, .length = 3},
  [100] = {.index = 127, .length = 4},
  [101] = {.index = 131, .length = 4},
  [102] = {.index = 135, .length = 1},
  [103] = {.index = 136, .length = 2},
  [104] = {.index = 138, .length = 4},
  [105] = {.index = 142, .length = 5},
  [106] = {.index = 147, .length = 4},
  [107] = {.index = 151, .length = 5},
  [108] = {.index = 156, .length = 2},
  [109] = {.index = 158, .length = 2},
  [110] = {.index = 160, .length = 2},
  [111] = {.index = 162, .length = 1},
  [112] = {.index = 163, .length = 2},
  [113] = {.index = 165, .length = 2},
  [114] = {.index = 165, .length = 2},
  [115] = {.index = 167, .length = 1},
  [116] = {.index = 168, .length = 2},
  [117] = {.index = 168, .length = 2},
  [118] = {.index = 170, .length = 2},
  [119] = {.index = 172, .length = 4},
  [120] = {.index = 176, .length = 4},
  [121] = {.index = 180, .length = 5},
  [122] = {.index = 185, .length = 4},
  [123] = {.index = 189, .length = 5},
  [124] = {.index = 194, .length = 3},
  [125] = {.index = 78, .length = 2},
  [126] = {.index = 197, .length = 5},
  [127] = {.index = 202, .length = 5},
  [128] = {.index = 207, .length = 6},
  [129] = {.index = 213, .length = 2},
  [130] = {.index = 215, .length = 3},
  [131] = {.index = 218, .length = 2},
  [132] = {.index = 220, .length = 1},
  [133] = {.index = 221, .length = 2},
  [134] = {.index = 223, .length = 3},
  [135] = {.index = 226, .length = 5},
  [136] = {.index = 231, .length = 5},
  [137] = {.index = 236, .length = 6},
  [138] = {.index = 242, .length = 6},
  [139] = {.index = 248, .length = 6},
  [140] = {.index = 254, .length = 3},
  [141] = {.index = 257, .length = 3},
  [142] = {.index = 260, .length = 6},
  [143] = {.index = 266, .length = 6},
  [144] = {.index = 272, .length = 7},
  [145] = {.index = 279, .length = 7},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_body, 1},
  [2] =
    {field_value, 1},
  [3] =
    {field_body, 1},
    {field_name, 0},
  [5] =
    {field_arguments, 1},
    {field_function, 0},
  [7] =
    {field_body, 1},
    {field_parameters, 0},
  [9] =
    {field_body, 2},
    {field_name, 1},
  [11] =
    {field_name, 1},
    {field_parameters, 2},
  [13] =
    {field_type, 0},
    {field_type_arguments, 1},
  [15] =
    {field_pattern, 1},
  [16] =
    {field_list, 1},
  [17] =
    {field_argument, 1},
  [18] =
    {field_name, 2},
    {field_path, 0},
  [20] =
    {field_macro, 0},
  [21] =
    {field_type, 0},
    {field_type_arguments, 2},
  [23] =
    {field_condition, 1},
    {field_consequence, 2},
  [25] =
    {field_body, 2},
    {field_value, 1},
  [27] =
    {field_body, 2},
    {field_condition, 1},
  [29] =
    {field_body, 2},
    {field_parameters, 1},
  [31] =
    {field_value, 2},
  [32] =
    {field_function, 0},
    {field_type_arguments, 2},
  [34] =
    {field_left, 0},
    {field_right, 2},
  [36] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [39] =
    {field_field, 2},
    {field_value, 0},
  [41] =
    {field_body, 2},
  [42] =
    {field_name, 1},
    {field_type_parameters, 2},
  [44] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [47] =
    {field_name, 2},
    {field_parameters, 3},
  [49] =
    {field_arguments, 1},
  [50] =
    {field_variant, 0},
  [51] =
    {field_implicit_arguments, 3},
    {field_name, 1},
    {field_parameters, 2},
  [54] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [57] =
    {field_type, 0},
  [58] =
    {field_name, 0},
  [59] =
    {field_pattern, 2},
  [60] =
    {field_list, 2},
    {field_path, 0},
  [62] =
    {field_alias, 2},
    {field_path, 0},
  [64] =
    {field_pattern, 0},
    {field_type, 2},
  [66] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [69] =
    {field_type, 1},
  [70] =
    {field_body, 3},
    {field_parameters, 0},
    {field_return_type, 2},
  [73] =
    {field_name, 2},
  [74] =
    {field_body, 3},
    {field_name, 2},
  [76] =
    {field_argument, 2},
  [77] =
    {field_body, 4},
  [78] =
    {field_name, 1},
    {field_type, 3},
  [80] =
    {field_implicit_arguments, 4},
    {field_name, 2},
    {field_parameters, 3},
  [83] =
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [86] =
    {field_length, 3},
  [87] =
    {field_variant, 1},
  [88] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [91] =
    {field_implicit_arguments, 3},
    {field_implicit_arguments, 4},
    {field_name, 1},
    {field_parameters, 2},
  [95] =
    {field_implicit_arguments, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [99] =
    {field_pattern, 1},
    {field_type, 3},
  [101] =
    {field_pattern, 1},
    {field_value, 3},
  [103] =
    {field_body, 4},
    {field_pattern, 1},
    {field_value, 3},
  [106] =
    {field_body, 4},
    {field_parameters, 1},
    {field_return_type, 3},
  [109] =
    {field_field, 0},
    {field_value, 2},
  [111] =
    {field_element, 1},
  [112] =
    {field_name, 2},
    {field_type_parameters, 3},
  [114] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [117] =
    {field_name, 3},
  [118] =
    {field_type_parameters, 2},
  [119] =
    {field_body, 5},
    {field_type_parameters, 2},
  [121] =
    {field_name, 1},
    {field_type, 4},
    {field_type_parameters, 2},
  [124] =
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [127] =
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_name, 2},
    {field_parameters, 3},
  [131] =
    {field_implicit_arguments, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [135] =
    {field_length, 4},
  [136] =
    {field_name, 0},
    {field_type, 2},
  [138] =
    {field_implicit_arguments, 5},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [142] =
    {field_implicit_arguments, 3},
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_name, 1},
    {field_parameters, 2},
  [147] =
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [151] =
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [156] =
    {field_name, 0},
    {field_pattern, 2},
  [158] =
    {field_pattern, 2},
    {field_type, 4},
  [160] =
    {field_pattern, 2},
    {field_value, 4},
  [162] =
    {field_condition, 2},
  [163] =
    {field_pattern, 0},
    {field_value, 2},
  [165] =
    {field_field, 1},
    {field_value, 3},
  [167] =
    {field_body, 5},
  [168] =
    {field_name, 2},
    {field_type, 4},
  [170] =
    {field_name, 3},
    {field_type_parameters, 4},
  [172] =
    {field_bound, 3},
    {field_left, 0},
    {field_left, 1},
    {field_left, 2},
  [176] =
    {field_implicit_arguments, 6},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [180] =
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_name, 2},
    {field_parameters, 3},
  [185] =
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [189] =
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [194] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 5},
  [197] =
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [202] =
    {field_implicit_arguments, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [207] =
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [213] =
    {field_name, 1},
    {field_pattern, 3},
  [215] =
    {field_pattern, 1},
    {field_type, 3},
    {field_value, 5},
  [218] =
    {field_element, 1},
    {field_length, 3},
  [220] =
    {field_type_parameters, 3},
  [221] =
    {field_body, 6},
    {field_type_parameters, 3},
  [223] =
    {field_name, 2},
    {field_type, 5},
    {field_type_parameters, 3},
  [226] =
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [231] =
    {field_implicit_arguments, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [236] =
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [242] =
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [248] =
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [254] =
    {field_pattern, 2},
    {field_type, 4},
    {field_value, 6},
  [257] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 6},
  [260] =
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_implicit_arguments, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [266] =
    {field_implicit_arguments, 7},
    {field_implicit_arguments, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [272] =
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_implicit_arguments, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [279] =
    {field_implicit_arguments, 7},
    {field_implicit_arguments, 8},
    {field_implicit_arguments, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [3] = {
    [1] = alias_sym_type_identifier,
  },
  [6] = {
    [0] = alias_sym_type_identifier,
  },
  [10] = {
    [1] = alias_sym_type_identifier,
  },
  [13] = {
    [0] = sym_identifier,
  },
  [14] = {
    [0] = alias_sym_type_identifier,
  },
  [20] = {
    [2] = alias_sym_type_identifier,
  },
  [21] = {
    [0] = sym_identifier,
  },
  [22] = {
    [0] = sym_identifier,
  },
  [23] = {
    [0] = sym_identifier,
    [2] = alias_sym_type_identifier,
  },
  [24] = {
    [0] = sym_identifier,
  },
  [31] = {
    [0] = alias_sym_type_identifier,
  },
  [33] = {
    [0] = sym_generic_type,
  },
  [34] = {
    [0] = sym_generic_type,
    [2] = alias_sym_type_identifier,
  },
  [39] = {
    [2] = alias_sym_field_identifier,
  },
  [40] = {
    [0] = alias_sym_primitive_type,
  },
  [41] = {
    [0] = alias_sym_type_identifier,
  },
  [43] = {
    [1] = alias_sym_type_identifier,
  },
  [44] = {
    [1] = alias_sym_type_identifier,
  },
  [47] = {
    [0] = sym_identifier,
  },
  [51] = {
    [2] = sym_identifier,
  },
  [52] = {
    [0] = sym_identifier,
    [2] = sym_identifier,
  },
  [53] = {
    [0] = alias_sym_type_identifier,
  },
  [54] = {
    [0] = alias_sym_shorthand_field_identifier,
  },
  [57] = {
    [0] = sym_generic_type,
  },
  [60] = {
    [0] = sym_identifier,
  },
  [61] = {
    [0] = sym_identifier,
  },
  [66] = {
    [2] = alias_sym_type_identifier,
  },
  [67] = {
    [2] = alias_sym_type_identifier,
  },
  [72] = {
    [1] = alias_sym_type_identifier,
  },
  [73] = {
    [1] = alias_sym_type_identifier,
  },
  [77] = {
    [0] = sym_identifier,
  },
  [83] = {
    [1] = alias_sym_shorthand_field_identifier,
  },
  [86] = {
    [3] = sym_identifier,
  },
  [90] = {
    [0] = alias_sym_field_identifier,
  },
  [92] = {
    [2] = alias_sym_type_identifier,
  },
  [93] = {
    [2] = alias_sym_type_identifier,
  },
  [94] = {
    [3] = alias_sym_type_identifier,
  },
  [95] = {
    [2] = alias_sym_type_identifier,
  },
  [98] = {
    [1] = alias_sym_type_identifier,
  },
  [103] = {
    [0] = alias_sym_field_identifier,
  },
  [108] = {
    [0] = alias_sym_field_identifier,
  },
  [114] = {
    [1] = alias_sym_field_identifier,
  },
  [116] = {
    [2] = alias_sym_type_identifier,
  },
  [118] = {
    [3] = alias_sym_type_identifier,
  },
  [119] = {
    [1] = alias_sym_type_identifier,
  },
  [125] = {
    [1] = alias_sym_field_identifier,
  },
  [129] = {
    [1] = alias_sym_field_identifier,
  },
  [134] = {
    [2] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_generic_type_with_turbofish, 2,
    sym_generic_type_with_turbofish,
    sym_generic_type,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 3,
  [6] = 6,
  [7] = 2,
  [8] = 3,
  [9] = 6,
  [10] = 2,
  [11] = 3,
  [12] = 2,
  [13] = 3,
  [14] = 2,
  [15] = 3,
  [16] = 2,
  [17] = 3,
  [18] = 2,
  [19] = 3,
  [20] = 2,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 23,
  [25] = 25,
  [26] = 25,
  [27] = 23,
  [28] = 22,
  [29] = 21,
  [30] = 23,
  [31] = 25,
  [32] = 25,
  [33] = 25,
  [34] = 22,
  [35] = 21,
  [36] = 25,
  [37] = 23,
  [38] = 23,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 41,
  [45] = 45,
  [46] = 46,
  [47] = 40,
  [48] = 42,
  [49] = 43,
  [50] = 41,
  [51] = 46,
  [52] = 40,
  [53] = 45,
  [54] = 46,
  [55] = 40,
  [56] = 42,
  [57] = 43,
  [58] = 41,
  [59] = 45,
  [60] = 46,
  [61] = 40,
  [62] = 42,
  [63] = 43,
  [64] = 41,
  [65] = 45,
  [66] = 46,
  [67] = 40,
  [68] = 42,
  [69] = 43,
  [70] = 41,
  [71] = 45,
  [72] = 46,
  [73] = 42,
  [74] = 43,
  [75] = 45,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 86,
  [88] = 88,
  [89] = 89,
  [90] = 89,
  [91] = 91,
  [92] = 88,
  [93] = 91,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 95,
  [100] = 97,
  [101] = 101,
  [102] = 94,
  [103] = 96,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 104,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 110,
  [113] = 82,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 111,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 105,
  [124] = 124,
  [125] = 125,
  [126] = 109,
  [127] = 127,
  [128] = 128,
  [129] = 81,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 132,
  [136] = 133,
  [137] = 137,
  [138] = 132,
  [139] = 133,
  [140] = 132,
  [141] = 130,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 143,
  [147] = 147,
  [148] = 147,
  [149] = 147,
  [150] = 127,
  [151] = 144,
  [152] = 152,
  [153] = 124,
  [154] = 122,
  [155] = 155,
  [156] = 156,
  [157] = 145,
  [158] = 156,
  [159] = 143,
  [160] = 143,
  [161] = 155,
  [162] = 147,
  [163] = 163,
  [164] = 163,
  [165] = 165,
  [166] = 166,
  [167] = 163,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 172,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 166,
  [198] = 198,
  [199] = 179,
  [200] = 185,
  [201] = 188,
  [202] = 193,
  [203] = 194,
  [204] = 195,
  [205] = 196,
  [206] = 198,
  [207] = 168,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 208,
  [212] = 209,
  [213] = 173,
  [214] = 210,
  [215] = 179,
  [216] = 185,
  [217] = 188,
  [218] = 193,
  [219] = 194,
  [220] = 195,
  [221] = 196,
  [222] = 198,
  [223] = 168,
  [224] = 208,
  [225] = 209,
  [226] = 210,
  [227] = 227,
  [228] = 228,
  [229] = 172,
  [230] = 230,
  [231] = 228,
  [232] = 228,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 233,
  [238] = 187,
  [239] = 227,
  [240] = 230,
  [241] = 234,
  [242] = 170,
  [243] = 171,
  [244] = 177,
  [245] = 178,
  [246] = 183,
  [247] = 184,
  [248] = 189,
  [249] = 233,
  [250] = 234,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 115,
  [256] = 256,
  [257] = 124,
  [258] = 122,
  [259] = 81,
  [260] = 125,
  [261] = 82,
  [262] = 127,
  [263] = 124,
  [264] = 122,
  [265] = 127,
  [266] = 131,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 124,
  [351] = 122,
  [352] = 127,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 353,
  [357] = 357,
  [358] = 355,
  [359] = 359,
  [360] = 127,
  [361] = 361,
  [362] = 361,
  [363] = 363,
  [364] = 364,
  [365] = 361,
  [366] = 124,
  [367] = 120,
  [368] = 121,
  [369] = 106,
  [370] = 108,
  [371] = 117,
  [372] = 114,
  [373] = 116,
  [374] = 119,
  [375] = 122,
  [376] = 128,
  [377] = 377,
  [378] = 377,
  [379] = 379,
  [380] = 380,
  [381] = 377,
  [382] = 382,
  [383] = 382,
  [384] = 382,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 389,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 391,
  [395] = 395,
  [396] = 392,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 403,
  [406] = 402,
  [407] = 404,
  [408] = 408,
  [409] = 409,
  [410] = 326,
  [411] = 411,
  [412] = 412,
  [413] = 411,
  [414] = 414,
  [415] = 408,
  [416] = 414,
  [417] = 409,
  [418] = 418,
  [419] = 412,
  [420] = 418,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 421,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 425,
  [430] = 426,
  [431] = 425,
  [432] = 426,
  [433] = 433,
  [434] = 433,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 422,
  [439] = 439,
  [440] = 436,
  [441] = 427,
  [442] = 423,
  [443] = 433,
  [444] = 421,
  [445] = 428,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 448,
  [450] = 450,
  [451] = 450,
  [452] = 448,
  [453] = 450,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 455,
  [458] = 455,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 131,
  [473] = 473,
  [474] = 474,
  [475] = 122,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 124,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 127,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 80,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 78,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 79,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 459,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 299,
  [558] = 289,
  [559] = 290,
  [560] = 291,
  [561] = 292,
  [562] = 293,
  [563] = 473,
  [564] = 294,
  [565] = 295,
  [566] = 296,
  [567] = 297,
  [568] = 321,
  [569] = 298,
  [570] = 325,
  [571] = 283,
  [572] = 302,
  [573] = 303,
  [574] = 304,
  [575] = 305,
  [576] = 327,
  [577] = 467,
  [578] = 461,
  [579] = 469,
  [580] = 328,
  [581] = 471,
  [582] = 582,
  [583] = 329,
  [584] = 331,
  [585] = 333,
  [586] = 470,
  [587] = 306,
  [588] = 335,
  [589] = 307,
  [590] = 336,
  [591] = 308,
  [592] = 347,
  [593] = 312,
  [594] = 314,
  [595] = 317,
  [596] = 318,
  [597] = 337,
  [598] = 338,
  [599] = 339,
  [600] = 341,
  [601] = 284,
  [602] = 309,
  [603] = 272,
  [604] = 311,
  [605] = 313,
  [606] = 315,
  [607] = 316,
  [608] = 267,
  [609] = 268,
  [610] = 269,
  [611] = 270,
  [612] = 271,
  [613] = 273,
  [614] = 274,
  [615] = 275,
  [616] = 276,
  [617] = 326,
  [618] = 277,
  [619] = 278,
  [620] = 320,
  [621] = 300,
  [622] = 279,
  [623] = 285,
  [624] = 322,
  [625] = 330,
  [626] = 332,
  [627] = 334,
  [628] = 343,
  [629] = 344,
  [630] = 345,
  [631] = 346,
  [632] = 459,
  [633] = 310,
  [634] = 323,
  [635] = 286,
  [636] = 280,
  [637] = 281,
  [638] = 282,
  [639] = 324,
  [640] = 287,
  [641] = 301,
  [642] = 288,
  [643] = 342,
  [644] = 644,
  [645] = 474,
  [646] = 646,
  [647] = 461,
  [648] = 465,
  [649] = 484,
  [650] = 650,
  [651] = 466,
  [652] = 473,
  [653] = 650,
  [654] = 469,
  [655] = 471,
  [656] = 656,
  [657] = 474,
  [658] = 470,
  [659] = 659,
  [660] = 467,
  [661] = 464,
  [662] = 646,
  [663] = 663,
  [664] = 131,
  [665] = 665,
  [666] = 463,
  [667] = 462,
  [668] = 668,
  [669] = 460,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 671,
  [674] = 476,
  [675] = 468,
  [676] = 676,
  [677] = 659,
  [678] = 479,
  [679] = 676,
  [680] = 484,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 522,
  [700] = 478,
  [701] = 477,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 681,
  [706] = 476,
  [707] = 479,
  [708] = 480,
  [709] = 483,
  [710] = 695,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 695,
  [722] = 122,
  [723] = 127,
  [724] = 326,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 693,
  [729] = 695,
  [730] = 711,
  [731] = 720,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 522,
  [736] = 736,
  [737] = 713,
  [738] = 714,
  [739] = 715,
  [740] = 719,
  [741] = 736,
  [742] = 682,
  [743] = 689,
  [744] = 694,
  [745] = 703,
  [746] = 704,
  [747] = 717,
  [748] = 718,
  [749] = 725,
  [750] = 726,
  [751] = 727,
  [752] = 683,
  [753] = 684,
  [754] = 691,
  [755] = 695,
  [756] = 124,
  [757] = 556,
  [758] = 758,
  [759] = 505,
  [760] = 498,
  [761] = 504,
  [762] = 515,
  [763] = 486,
  [764] = 533,
  [765] = 529,
  [766] = 542,
  [767] = 553,
  [768] = 128,
  [769] = 555,
  [770] = 521,
  [771] = 524,
  [772] = 506,
  [773] = 773,
  [774] = 774,
  [775] = 492,
  [776] = 499,
  [777] = 500,
  [778] = 556,
  [779] = 538,
  [780] = 489,
  [781] = 120,
  [782] = 121,
  [783] = 511,
  [784] = 554,
  [785] = 513,
  [786] = 514,
  [787] = 787,
  [788] = 788,
  [789] = 541,
  [790] = 519,
  [791] = 543,
  [792] = 544,
  [793] = 545,
  [794] = 546,
  [795] = 547,
  [796] = 548,
  [797] = 549,
  [798] = 550,
  [799] = 551,
  [800] = 552,
  [801] = 523,
  [802] = 526,
  [803] = 490,
  [804] = 518,
  [805] = 106,
  [806] = 108,
  [807] = 535,
  [808] = 520,
  [809] = 530,
  [810] = 507,
  [811] = 811,
  [812] = 509,
  [813] = 512,
  [814] = 814,
  [815] = 517,
  [816] = 114,
  [817] = 116,
  [818] = 117,
  [819] = 531,
  [820] = 537,
  [821] = 496,
  [822] = 487,
  [823] = 488,
  [824] = 493,
  [825] = 119,
  [826] = 501,
  [827] = 502,
  [828] = 528,
  [829] = 495,
  [830] = 503,
  [831] = 831,
  [832] = 832,
  [833] = 554,
  [834] = 541,
  [835] = 543,
  [836] = 544,
  [837] = 545,
  [838] = 546,
  [839] = 547,
  [840] = 548,
  [841] = 549,
  [842] = 550,
  [843] = 551,
  [844] = 552,
  [845] = 299,
  [846] = 78,
  [847] = 556,
  [848] = 848,
  [849] = 554,
  [850] = 850,
  [851] = 79,
  [852] = 80,
  [853] = 853,
  [854] = 326,
  [855] = 855,
  [856] = 856,
  [857] = 831,
  [858] = 858,
  [859] = 542,
  [860] = 553,
  [861] = 788,
  [862] = 555,
  [863] = 811,
  [864] = 864,
  [865] = 865,
  [866] = 832,
  [867] = 848,
  [868] = 868,
  [869] = 869,
  [870] = 855,
  [871] = 831,
  [872] = 788,
  [873] = 811,
  [874] = 874,
  [875] = 848,
  [876] = 831,
  [877] = 811,
  [878] = 831,
  [879] = 811,
  [880] = 831,
  [881] = 811,
  [882] = 831,
  [883] = 811,
  [884] = 831,
  [885] = 811,
  [886] = 886,
  [887] = 858,
  [888] = 888,
  [889] = 869,
  [890] = 890,
  [891] = 539,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 893,
  [897] = 897,
  [898] = 895,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 892,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 906,
  [910] = 910,
  [911] = 894,
  [912] = 912,
  [913] = 908,
  [914] = 914,
  [915] = 914,
  [916] = 916,
  [917] = 910,
  [918] = 918,
  [919] = 919,
  [920] = 899,
  [921] = 905,
  [922] = 919,
  [923] = 900,
  [924] = 924,
  [925] = 918,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 930,
  [932] = 929,
  [933] = 401,
  [934] = 326,
  [935] = 935,
  [936] = 936,
  [937] = 936,
  [938] = 936,
  [939] = 936,
  [940] = 936,
  [941] = 936,
  [942] = 942,
  [943] = 942,
  [944] = 936,
  [945] = 936,
  [946] = 942,
  [947] = 947,
  [948] = 947,
  [949] = 949,
  [950] = 950,
  [951] = 464,
  [952] = 952,
  [953] = 462,
  [954] = 949,
  [955] = 955,
  [956] = 950,
  [957] = 957,
  [958] = 463,
  [959] = 460,
  [960] = 952,
  [961] = 955,
  [962] = 962,
  [963] = 82,
  [964] = 115,
  [965] = 125,
  [966] = 966,
  [967] = 81,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 950,
  [981] = 981,
  [982] = 955,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 952,
  [987] = 979,
  [988] = 949,
  [989] = 949,
  [990] = 990,
  [991] = 950,
  [992] = 952,
  [993] = 993,
  [994] = 994,
  [995] = 955,
  [996] = 79,
  [997] = 997,
  [998] = 998,
  [999] = 997,
  [1000] = 85,
  [1001] = 80,
  [1002] = 1002,
  [1003] = 998,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1013,
  [1015] = 1015,
  [1016] = 957,
  [1017] = 1017,
  [1018] = 997,
  [1019] = 1010,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1022,
  [1026] = 1026,
  [1027] = 1015,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 468,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 465,
  [1037] = 466,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 957,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 949,
  [1048] = 955,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1054,
  [1057] = 1057,
  [1058] = 1039,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1010,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1033,
  [1071] = 1071,
  [1072] = 950,
  [1073] = 952,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1040,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 971,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 971,
  [1086] = 1083,
  [1087] = 1081,
  [1088] = 1084,
  [1089] = 1028,
  [1090] = 1080,
  [1091] = 971,
  [1092] = 971,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 990,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 464,
  [1102] = 990,
  [1103] = 463,
  [1104] = 462,
  [1105] = 971,
  [1106] = 460,
  [1107] = 1099,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 990,
  [1112] = 1112,
  [1113] = 990,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1114,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 990,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1010,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1146,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1011,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1114,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1142,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1157,
  [1175] = 1175,
  [1176] = 401,
  [1177] = 1177,
  [1178] = 1148,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 401,
  [1182] = 1143,
  [1183] = 1173,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1010,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1187,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1005,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1020,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1021,
  [1216] = 1006,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1008,
  [1221] = 1009,
  [1222] = 1218,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1012,
  [1227] = 1227,
  [1228] = 1007,
  [1229] = 1030,
  [1230] = 1026,
  [1231] = 79,
  [1232] = 1232,
  [1233] = 1017,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 80,
  [1240] = 1193,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1243,
  [1246] = 1202,
  [1247] = 1193,
  [1248] = 1195,
  [1249] = 1197,
  [1250] = 1203,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1195,
  [1254] = 1218,
  [1255] = 1255,
  [1256] = 1028,
  [1257] = 1241,
  [1258] = 1244,
  [1259] = 1193,
  [1260] = 1195,
  [1261] = 1197,
  [1262] = 1262,
  [1263] = 1207,
  [1264] = 1241,
  [1265] = 1212,
  [1266] = 1208,
  [1267] = 1194,
  [1268] = 1241,
  [1269] = 1244,
  [1270] = 1193,
  [1271] = 1195,
  [1272] = 1197,
  [1273] = 1213,
  [1274] = 1209,
  [1275] = 1200,
  [1276] = 1193,
  [1277] = 1195,
  [1278] = 1197,
  [1279] = 1196,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1193,
  [1284] = 1195,
  [1285] = 1197,
  [1286] = 1193,
  [1287] = 1195,
  [1288] = 1197,
  [1289] = 1242,
  [1290] = 1198,
  [1291] = 1235,
  [1292] = 1011,
  [1293] = 1224,
  [1294] = 1294,
  [1295] = 1207,
  [1296] = 1208,
  [1297] = 1204,
  [1298] = 1232,
  [1299] = 1203,
  [1300] = 85,
  [1301] = 1206,
  [1302] = 1197,
  [1303] = 1209,
  [1304] = 1218,
  [1305] = 1241,
  [1306] = 1227,
  [1307] = 1234,
  [1308] = 1242,
  [1309] = 1193,
  [1310] = 1195,
  [1311] = 1197,
  [1312] = 1203,
  [1313] = 1313,
  [1314] = 1244,
  [1315] = 1243,
  [1316] = 1192,
  [1317] = 1202,
  [1318] = 1192,
  [1319] = 1294,
  [1320] = 1244,
  [1321] = 1236,
  [1322] = 1199,
  [1323] = 1238,
  [1324] = 1217,
  [1325] = 1203,
  [1326] = 1326,
  [1327] = 1194,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 115,
  [1334] = 125,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1337,
  [1338] = 1338,
  [1339] = 1339,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 81,
  [1343] = 82,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 326,
  [1347] = 1347,
  [1348] = 1348,
  [1349] = 1349,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1030,
  [1360] = 1061,
  [1361] = 1063,
  [1362] = 1034,
  [1363] = 1038,
  [1364] = 1050,
  [1365] = 1365,
  [1366] = 1062,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 1335,
  [1372] = 1372,
  [1373] = 1354,
  [1374] = 1374,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1377,
  [1378] = 1378,
  [1379] = 1379,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1340,
  [1385] = 972,
  [1386] = 1326,
  [1387] = 1382,
  [1388] = 1388,
  [1389] = 1389,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1358,
  [1393] = 1332,
  [1394] = 1355,
  [1395] = 1388,
  [1396] = 1396,
  [1397] = 1396,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1052,
  [1402] = 1060,
  [1403] = 1403,
  [1404] = 1068,
  [1405] = 1065,
  [1406] = 1337,
  [1407] = 1057,
  [1408] = 1345,
  [1409] = 1069,
  [1410] = 1347,
  [1411] = 1350,
  [1412] = 1357,
  [1413] = 1370,
  [1414] = 1377,
  [1415] = 1415,
  [1416] = 1059,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1031,
  [1425] = 1425,
  [1426] = 1041,
  [1427] = 1427,
  [1428] = 1428,
  [1429] = 1429,
  [1430] = 1415,
  [1431] = 1431,
  [1432] = 1381,
  [1433] = 1433,
  [1434] = 1374,
  [1435] = 1348,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 974,
  [1439] = 1390,
  [1440] = 1440,
  [1441] = 973,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 1444,
  [1445] = 1440,
  [1446] = 1328,
  [1447] = 1043,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1045,
  [1452] = 1051,
  [1453] = 1398,
  [1454] = 1077,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1457,
  [1458] = 1398,
  [1459] = 1418,
  [1460] = 1399,
  [1461] = 1425,
  [1462] = 1419,
  [1463] = 1463,
  [1464] = 1055,
  [1465] = 1420,
  [1466] = 1466,
  [1467] = 1421,
  [1468] = 1468,
  [1469] = 1422,
  [1470] = 1391,
  [1471] = 1029,
  [1472] = 1472,
  [1473] = 966,
  [1474] = 1474,
  [1475] = 1475,
  [1476] = 1400,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1049,
  [1486] = 1436,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1437,
  [1491] = 976,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1352,
  [1495] = 1425,
  [1496] = 1352,
  [1497] = 1066,
  [1498] = 1351,
  [1499] = 1499,
  [1500] = 1344,
  [1501] = 1071,
  [1502] = 1349,
  [1503] = 1427,
  [1504] = 1369,
  [1505] = 1064,
  [1506] = 1042,
  [1507] = 1507,
  [1508] = 1429,
  [1509] = 1075,
  [1510] = 970,
  [1511] = 969,
  [1512] = 1512,
  [1513] = 975,
  [1514] = 1514,
  [1515] = 1431,
  [1516] = 968,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1074,
  [1520] = 1368,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1380,
  [1524] = 962,
  [1525] = 1433,
  [1526] = 1526,
  [1527] = 1046,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 326,
  [1535] = 1141,
  [1536] = 1536,
  [1537] = 1204,
  [1538] = 1538,
  [1539] = 1336,
  [1540] = 1053,
  [1541] = 978,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1548,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1570,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 983,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 981,
  [1583] = 1583,
  [1584] = 1545,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1563,
  [1588] = 1588,
  [1589] = 1546,
  [1590] = 1559,
  [1591] = 1591,
  [1592] = 1580,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 994,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1546,
  [1600] = 1547,
  [1601] = 1563,
  [1602] = 1567,
  [1603] = 1572,
  [1604] = 1604,
  [1605] = 1002,
  [1606] = 1578,
  [1607] = 1607,
  [1608] = 1545,
  [1609] = 115,
  [1610] = 1610,
  [1611] = 1559,
  [1612] = 1612,
  [1613] = 1579,
  [1614] = 984,
  [1615] = 985,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1549,
  [1623] = 1623,
  [1624] = 125,
  [1625] = 1625,
  [1626] = 1547,
  [1627] = 1627,
  [1628] = 1563,
  [1629] = 1629,
  [1630] = 1578,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1579,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1616,
  [1637] = 78,
  [1638] = 1604,
  [1639] = 972,
  [1640] = 1621,
  [1641] = 1641,
  [1642] = 1550,
  [1643] = 1579,
  [1644] = 1544,
  [1645] = 1563,
  [1646] = 1646,
  [1647] = 1597,
  [1648] = 1579,
  [1649] = 1616,
  [1650] = 1560,
  [1651] = 1651,
  [1652] = 1616,
  [1653] = 1578,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1563,
  [1658] = 1658,
  [1659] = 1579,
  [1660] = 1660,
  [1661] = 1551,
  [1662] = 1616,
  [1663] = 1552,
  [1664] = 1664,
  [1665] = 1618,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1572,
  [1669] = 1563,
  [1670] = 1579,
  [1671] = 1610,
  [1672] = 1616,
  [1673] = 1673,
  [1674] = 1616,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 993,
  [1678] = 1620,
  [1679] = 1679,
  [1680] = 977,
  [1681] = 1681,
  [1682] = 1567,
  [1683] = 1623,
  [1684] = 1684,
  [1685] = 1553,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1568,
  [1690] = 1621,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 81,
  [1694] = 1570,
  [1695] = 1695,
  [1696] = 82,
  [1697] = 1697,
  [1698] = 1567,
  [1699] = 1542,
  [1700] = 1612,
  [1701] = 1687,
  [1702] = 1568,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1686,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1547,
  [1709] = 1709,
  [1710] = 973,
  [1711] = 1621,
  [1712] = 1712,
  [1713] = 1558,
  [1714] = 1621,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1567,
  [1719] = 1719,
  [1720] = 1720,
  [1721] = 1618,
  [1722] = 1598,
  [1723] = 1598,
  [1724] = 1724,
  [1725] = 1567,
  [1726] = 1581,
  [1727] = 1727,
  [1728] = 1593,
  [1729] = 1729,
  [1730] = 1730,
  [1731] = 1595,
  [1732] = 1635,
  [1733] = 1219,
  [1734] = 1577,
  [1735] = 1735,
  [1736] = 1557,
  [1737] = 1593,
  [1738] = 1595,
  [1739] = 1727,
  [1740] = 1740,
  [1741] = 1620,
  [1742] = 1742,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1745,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1745,
  [1761] = 1749,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1748,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1771,
  [1772] = 1772,
  [1773] = 1765,
  [1774] = 1768,
  [1775] = 1747,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1747,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1790,
  [1797] = 1797,
  [1798] = 1751,
  [1799] = 1783,
  [1800] = 1800,
  [1801] = 1794,
  [1802] = 1797,
  [1803] = 1803,
  [1804] = 1762,
  [1805] = 1800,
  [1806] = 1745,
  [1807] = 1745,
  [1808] = 1769,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1777,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1755,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1746,
  [1818] = 1769,
  [1819] = 1786,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1758,
  [1823] = 1784,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1751,
  [1827] = 1744,
  [1828] = 1747,
  [1829] = 1788,
  [1830] = 1825,
  [1831] = 1831,
  [1832] = 1781,
  [1833] = 1833,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 1757,
  [1837] = 1795,
  [1838] = 1820,
  [1839] = 1784,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1821,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1845,
  [1846] = 1846,
  [1847] = 1803,
  [1848] = 1841,
  [1849] = 1004,
  [1850] = 1813,
  [1851] = 1745,
  [1852] = 1852,
  [1853] = 1776,
  [1854] = 1777,
  [1855] = 1855,
  [1856] = 1856,
  [1857] = 1024,
  [1858] = 1858,
  [1859] = 1789,
  [1860] = 1776,
  [1861] = 1846,
  [1862] = 1862,
  [1863] = 1863,
  [1864] = 1803,
  [1865] = 1844,
  [1866] = 1866,
  [1867] = 1776,
  [1868] = 1759,
  [1869] = 1767,
  [1870] = 1831,
  [1871] = 1871,
  [1872] = 1776,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1770,
  [1876] = 1023,
  [1877] = 1803,
  [1878] = 1745,
  [1879] = 1879,
  [1880] = 1873,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1879,
  [1885] = 1745,
  [1886] = 1764,
  [1887] = 1803,
  [1888] = 1779,
  [1889] = 1824,
  [1890] = 1890,
  [1891] = 1845,
  [1892] = 1793,
  [1893] = 1873,
  [1894] = 1881,
  [1895] = 1895,
  [1896] = 1881,
  [1897] = 1881,
  [1898] = 1883,
  [1899] = 1874,
  [1900] = 1789,
  [1901] = 1833,
  [1902] = 1902,
  [1903] = 1771,
  [1904] = 1810,
  [1905] = 1871,
  [1906] = 1881,
  [1907] = 1772,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(257);
      ADVANCE_MAP(
        '!', 276,
        '"', 418,
        '#', 277,
        '$', 425,
        '%', 342,
        '&', 347,
        '\'', 30,
        '(', 299,
        ')', 302,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 339,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 269,
        ';', 263,
        '<', 426,
        '=', 274,
        '>', 334,
        '?', 371,
        '@', 367,
        'B', 214,
        '[', 278,
        ']', 279,
        '^', 344,
        '_', 300,
        'a', 187,
        'b', 25,
        'c', 24,
        'd', 129,
        'e', 155,
        'f', 100,
        'i', 69,
        'l', 130,
        'm', 105,
        'n', 171,
        'o', 137,
        'p', 208,
        'r', 116,
        's', 192,
        't', 180,
        'u', 70,
        'w', 141,
        '{', 258,
        '|', 349,
        '}', 259,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(253);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 276,
        '"', 413,
        '#', 277,
        '$', 425,
        '%', 342,
        '&', 347,
        '\'', 30,
        '(', 299,
        ')', 302,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 339,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 269,
        ';', 263,
        '<', 332,
        '=', 274,
        '>', 334,
        '?', 371,
        '@', 367,
        'B', 598,
        '[', 278,
        ']', 279,
        '^', 344,
        '_', 301,
        'b', 435,
        'c', 437,
        'd', 490,
        'e', 540,
        'f', 469,
        'i', 440,
        'l', 504,
        'm', 479,
        'n', 551,
        'p', 588,
        'r', 511,
        's', 578,
        't', 558,
        'u', 445,
        'w', 516,
        '{', 258,
        '|', 349,
        '}', 259,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 276,
        '"', 413,
        '%', 342,
        '&', 346,
        '\'', 30,
        '(', 299,
        ')', 302,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 338,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 269,
        ';', 263,
        '<', 332,
        '=', 273,
        '>', 334,
        '?', 371,
        '@', 367,
        'B', 598,
        '[', 278,
        ']', 279,
        '^', 343,
        '_', 411,
        'b', 435,
        'c', 438,
        'd', 490,
        'f', 470,
        'i', 441,
        'l', 548,
        'm', 478,
        'r', 491,
        's', 590,
        't', 567,
        'u', 446,
        'w', 516,
        '{', 258,
        '|', 350,
        '}', 259,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 276,
        '"', 413,
        '%', 342,
        '&', 346,
        '\'', 30,
        '(', 299,
        '*', 298,
        '+', 336,
        '-', 338,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 95,
        '<', 332,
        '=', 274,
        '>', 334,
        '?', 371,
        '@', 367,
        'B', 598,
        '[', 278,
        '^', 343,
        '_', 411,
        'b', 435,
        'c', 438,
        'd', 490,
        'f', 470,
        'i', 441,
        'l', 548,
        'm', 478,
        'r', 491,
        's', 590,
        't', 567,
        'u', 446,
        'w', 516,
        '{', 258,
        '|', 350,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 276,
        '%', 342,
        '&', 346,
        '(', 299,
        ')', 302,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 338,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 95,
        ';', 263,
        '<', 332,
        '=', 273,
        '>', 334,
        '?', 371,
        '[', 278,
        ']', 279,
        '^', 343,
        'a', 187,
        'e', 154,
        'i', 164,
        'n', 171,
        '{', 258,
        '|', 350,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(401);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 275,
        '"', 413,
        '#', 277,
        '\'', 30,
        '(', 299,
        ')', 302,
        '*', 297,
        ',', 286,
        '-', 337,
        '.', 66,
        '/', 67,
        '0', 399,
        ':', 269,
        ';', 263,
        '<', 331,
        '=', 272,
        '@', 367,
        'B', 598,
        '[', 278,
        ']', 279,
        '_', 411,
        'b', 435,
        'c', 438,
        'd', 490,
        'f', 470,
        'i', 441,
        'l', 548,
        'm', 478,
        'r', 491,
        's', 590,
        't', 567,
        'u', 446,
        'w', 516,
        '{', 258,
        '|', 348,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 275,
        '"', 413,
        '\'', 30,
        '(', 299,
        '*', 297,
        '-', 337,
        '.', 66,
        '/', 67,
        '0', 399,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        '_', 411,
        'b', 435,
        'c', 438,
        'd', 490,
        'f', 470,
        'i', 441,
        'l', 504,
        'm', 478,
        'r', 491,
        's', 590,
        't', 567,
        'u', 446,
        'w', 516,
        '{', 258,
        '|', 348,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 275,
        '"', 413,
        '\'', 30,
        '(', 299,
        '*', 297,
        '-', 337,
        '.', 66,
        '/', 67,
        '0', 399,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        '_', 411,
        'b', 435,
        'c', 438,
        'd', 490,
        'f', 470,
        'i', 441,
        'l', 548,
        'm', 477,
        'r', 491,
        's', 590,
        't', 567,
        'u', 446,
        'w', 516,
        '{', 258,
        '|', 348,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 275,
        '"', 413,
        '\'', 30,
        '(', 299,
        '*', 297,
        '-', 340,
        '.', 66,
        '/', 67,
        '0', 399,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        '_', 301,
        'b', 435,
        'c', 438,
        'd', 490,
        'f', 470,
        'i', 441,
        'l', 548,
        'm', 478,
        'r', 491,
        's', 590,
        't', 567,
        'u', 446,
        'w', 516,
        '{', 258,
        '|', 348,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 275,
        '"', 413,
        '\'', 30,
        '(', 299,
        '*', 297,
        '-', 340,
        '.', 66,
        '/', 67,
        '0', 399,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        '_', 301,
        'b', 435,
        'c', 438,
        'd', 490,
        'f', 470,
        'i', 441,
        'l', 548,
        'm', 477,
        'r', 491,
        's', 590,
        't', 567,
        'u', 446,
        'w', 516,
        '{', 258,
        '|', 348,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 275,
        '(', 299,
        ')', 302,
        ',', 286,
        '-', 97,
        '.', 66,
        '/', 67,
        ':', 269,
        ';', 263,
        '<', 426,
        '=', 272,
        '>', 333,
        '[', 278,
        ']', 279,
        'i', 165,
        'n', 171,
        'o', 137,
        '{', 258,
        '|', 348,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 275,
        '(', 299,
        ')', 302,
        ',', 286,
        '.', 66,
        '/', 67,
        ':', 269,
        ';', 263,
        '<', 426,
        '=', 272,
        '>', 333,
        '[', 278,
        ']', 279,
        '{', 258,
        '|', 348,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 275,
        '(', 299,
        ',', 286,
        '.', 66,
        '/', 67,
        ':', 95,
        ';', 263,
        '<', 426,
        '=', 98,
        ']', 279,
        'i', 136,
        '{', 258,
        '|', 348,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 96,
        '"', 418,
        '#', 277,
        '%', 342,
        '&', 346,
        '(', 299,
        '*', 298,
        '+', 336,
        '-', 338,
        '.', 369,
        '/', 341,
        ':', 95,
        ';', 263,
        '<', 332,
        '=', 274,
        '>', 334,
        '?', 371,
        'B', 598,
        '[', 278,
        '^', 343,
        'b', 545,
        'c', 552,
        'd', 490,
        'e', 540,
        'f', 507,
        'i', 442,
        'l', 505,
        'm', 547,
        'p', 588,
        's', 580,
        't', 565,
        'u', 445,
        '|', 350,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 96,
        '"', 413,
        '#', 277,
        '%', 342,
        '&', 346,
        '\'', 30,
        '(', 299,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 338,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 95,
        '<', 332,
        '=', 273,
        '>', 334,
        '?', 371,
        'B', 598,
        '[', 278,
        '^', 343,
        '_', 301,
        'b', 436,
        'c', 439,
        'd', 490,
        'e', 533,
        'f', 471,
        'i', 444,
        'm', 594,
        's', 590,
        't', 567,
        'u', 446,
        '|', 350,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '!', 96,
        '"', 413,
        '#', 277,
        '%', 342,
        '&', 346,
        '\'', 30,
        '(', 299,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 338,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 95,
        '<', 332,
        '=', 273,
        '>', 334,
        '?', 371,
        'B', 598,
        '[', 278,
        '^', 343,
        '_', 301,
        'b', 436,
        'c', 439,
        'd', 490,
        'f', 471,
        'i', 444,
        'm', 594,
        's', 590,
        't', 567,
        'u', 446,
        '|', 350,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '!', 96,
        '#', 277,
        '%', 342,
        '&', 346,
        '(', 299,
        '*', 298,
        '+', 336,
        '-', 338,
        '.', 369,
        '/', 341,
        ':', 95,
        ';', 263,
        '<', 332,
        '=', 274,
        '>', 334,
        '?', 371,
        'B', 598,
        '[', 278,
        '^', 343,
        'b', 545,
        'c', 552,
        'd', 490,
        'e', 540,
        'f', 507,
        'i', 442,
        'l', 505,
        'm', 547,
        'p', 588,
        's', 580,
        't', 565,
        'u', 445,
        '|', 350,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '!', 96,
        '%', 342,
        '&', 346,
        '(', 299,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 338,
        '.', 369,
        '/', 341,
        ':', 268,
        '<', 332,
        '=', 274,
        '>', 334,
        '?', 371,
        '[', 278,
        '^', 343,
        'e', 154,
        '|', 350,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '"', 413,
        '#', 277,
        '\'', 30,
        '(', 299,
        ')', 302,
        ',', 286,
        '-', 337,
        '/', 67,
        '0', 399,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        ']', 279,
        '_', 301,
        'b', 436,
        'c', 439,
        'd', 490,
        'f', 471,
        'i', 444,
        'm', 594,
        's', 590,
        't', 567,
        'u', 446,
        '|', 348,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 19:
      ADVANCE_MAP(
        '"', 413,
        '#', 277,
        '\'', 30,
        '(', 299,
        ')', 302,
        ',', 286,
        '-', 337,
        '/', 67,
        '0', 399,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        '_', 301,
        'b', 436,
        'c', 439,
        'd', 490,
        'f', 471,
        'i', 444,
        'm', 594,
        'r', 506,
        's', 590,
        't', 567,
        'u', 446,
        '|', 348,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '"', 413,
        '\'', 30,
        '(', 299,
        ')', 302,
        ',', 286,
        '-', 337,
        '/', 67,
        '0', 399,
        ':', 269,
        ';', 263,
        '=', 272,
        '>', 333,
        '@', 367,
        'B', 598,
        '[', 278,
        ']', 279,
        '_', 411,
        'b', 436,
        'c', 439,
        'd', 490,
        'f', 471,
        'i', 444,
        's', 590,
        't', 567,
        'u', 446,
        '{', 258,
        '|', 348,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 21:
      ADVANCE_MAP(
        '"', 413,
        '\'', 30,
        '(', 299,
        ')', 302,
        ',', 286,
        '-', 337,
        '/', 67,
        '0', 399,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        '_', 301,
        'b', 436,
        'c', 439,
        'd', 490,
        'f', 471,
        'i', 444,
        'm', 546,
        's', 590,
        't', 567,
        'u', 446,
        '|', 348,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        '"', 413,
        '\'', 30,
        '-', 337,
        '/', 67,
        '0', 399,
        ':', 95,
        '=', 98,
        'B', 598,
        '_', 411,
        'b', 436,
        'c', 439,
        'd', 490,
        'f', 471,
        'i', 441,
        's', 590,
        't', 567,
        'u', 446,
        '|', 348,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 23:
      ADVANCE_MAP(
        '"', 413,
        '\'', 30,
        '-', 337,
        '/', 67,
        '0', 399,
        ':', 95,
        'B', 598,
        '_', 411,
        'b', 436,
        'c', 439,
        'd', 490,
        'f', 471,
        'i', 443,
        's', 590,
        't', 567,
        'u', 446,
        '|', 348,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(413);
      if (lookahead == 'o') ADVANCE(166);
      if (lookahead == 'r') ADVANCE(108);
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(413);
      if (lookahead == 'o') ADVANCE(172);
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 26:
      ADVANCE_MAP(
        '#', 277,
        '+', 335,
        '-', 337,
        '/', 67,
        ':', 95,
        '>', 333,
        'B', 598,
        'b', 545,
        'c', 552,
        'd', 490,
        'f', 508,
        'i', 442,
        's', 590,
        'u', 446,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(26);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 27:
      if (lookahead == '#') ADVANCE(277);
      if (lookahead == ',') ADVANCE(286);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '0') ADVANCE(399);
      if (lookahead == '_') ADVANCE(411);
      if (lookahead == '}') ADVANCE(259);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(27);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 28:
      if (lookahead == '#') ADVANCE(277);
      if (lookahead == ',') ADVANCE(286);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == 'p') ADVANCE(588);
      if (lookahead == '}') ADVANCE(259);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(28);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 29:
      if (lookahead == '\'') ADVANCE(420);
      END_STATE();
    case 30:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(252);
      if (lookahead != 0) ADVANCE(60);
      END_STATE();
    case 31:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(223);
      if (lookahead != 0) ADVANCE(32);
      END_STATE();
    case 32:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(221);
      if (lookahead != 0) ADVANCE(29);
      END_STATE();
    case 33:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(224);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 34:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(225);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 35:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(226);
      if (lookahead != 0) ADVANCE(34);
      END_STATE();
    case 36:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(227);
      if (lookahead != 0) ADVANCE(35);
      END_STATE();
    case 37:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(228);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 38:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(229);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 39:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead != 0) ADVANCE(38);
      END_STATE();
    case 40:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(231);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 41:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(232);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 42:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(233);
      if (lookahead != 0) ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(234);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 44:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(235);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 45:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(236);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(237);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 47:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(238);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(239);
      if (lookahead != 0) ADVANCE(47);
      END_STATE();
    case 49:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(240);
      if (lookahead != 0) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(241);
      if (lookahead != 0) ADVANCE(49);
      END_STATE();
    case 51:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(242);
      if (lookahead != 0) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead != 0) ADVANCE(51);
      END_STATE();
    case 53:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(244);
      if (lookahead != 0) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(245);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(246);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(247);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(248);
      if (lookahead != 0) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(249);
      if (lookahead != 0) ADVANCE(57);
      END_STATE();
    case 59:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(250);
      if (lookahead != 0) ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == '\'') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(251);
      if (lookahead != 0) ADVANCE(59);
      END_STATE();
    case 61:
      ADVANCE_MAP(
        '(', 299,
        ')', 302,
        '*', 297,
        ',', 286,
        '/', 67,
        ':', 95,
        '@', 367,
        'B', 598,
        '[', 278,
        'b', 545,
        'd', 490,
        'f', 508,
        'i', 444,
        's', 590,
        'u', 446,
        '{', 258,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 62:
      ADVANCE_MAP(
        '(', 299,
        '/', 67,
        ':', 95,
        ';', 263,
        '@', 367,
        'B', 598,
        '[', 278,
        'b', 545,
        'd', 490,
        'f', 508,
        'i', 444,
        'n', 551,
        's', 590,
        'u', 446,
        '{', 258,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(62);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 63:
      ADVANCE_MAP(
        ')', 302,
        ',', 286,
        '.', 66,
        '/', 67,
        ':', 268,
        ';', 263,
        '<', 331,
        '=', 272,
        '>', 333,
        '[', 278,
        ']', 279,
        'i', 165,
        'n', 171,
        'o', 137,
        '{', 258,
        '|', 348,
        '}', 259,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      END_STATE();
    case 64:
      if (lookahead == '*') ADVANCE(297);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '<') ADVANCE(426);
      if (lookahead == 's') ADVANCE(590);
      if (lookahead == '{') ADVANCE(258);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 65:
      if (lookahead == ',') ADVANCE(286);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == 'm') ADVANCE(594);
      if (lookahead == '}') ADVANCE(259);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 66:
      if (lookahead == '.') ADVANCE(368);
      END_STATE();
    case 67:
      if (lookahead == '/') ADVANCE(608);
      END_STATE();
    case 68:
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == 'f') ADVANCE(536);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 69:
      if (lookahead == '1') ADVANCE(73);
      if (lookahead == '3') ADVANCE(74);
      if (lookahead == '6') ADVANCE(84);
      if (lookahead == '8') ADVANCE(305);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'm') ADVANCE(176);
      if (lookahead == 'n') ADVANCE(431);
      END_STATE();
    case 70:
      if (lookahead == '1') ADVANCE(79);
      if (lookahead == '3') ADVANCE(75);
      if (lookahead == '6') ADVANCE(85);
      if (lookahead == '8') ADVANCE(303);
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 71:
      if (lookahead == '1') ADVANCE(81);
      if (lookahead == '2') ADVANCE(87);
      if (lookahead == '3') ADVANCE(76);
      if (lookahead == '6') ADVANCE(86);
      if (lookahead == '8') ADVANCE(398);
      if (lookahead == 's') ADVANCE(150);
      END_STATE();
    case 72:
      if (lookahead == '1') ADVANCE(81);
      if (lookahead == '3') ADVANCE(76);
      if (lookahead == '6') ADVANCE(86);
      if (lookahead == '8') ADVANCE(398);
      END_STATE();
    case 73:
      if (lookahead == '2') ADVANCE(93);
      if (lookahead == '6') ADVANCE(309);
      END_STATE();
    case 74:
      if (lookahead == '2') ADVANCE(313);
      END_STATE();
    case 75:
      if (lookahead == '2') ADVANCE(311);
      END_STATE();
    case 76:
      if (lookahead == '2') ADVANCE(398);
      END_STATE();
    case 77:
      if (lookahead == '2') ADVANCE(329);
      END_STATE();
    case 78:
      if (lookahead == '2') ADVANCE(419);
      END_STATE();
    case 79:
      if (lookahead == '2') ADVANCE(94);
      if (lookahead == '6') ADVANCE(307);
      END_STATE();
    case 80:
      if (lookahead == '2') ADVANCE(89);
      END_STATE();
    case 81:
      if (lookahead == '2') ADVANCE(92);
      if (lookahead == '6') ADVANCE(398);
      END_STATE();
    case 82:
      if (lookahead == '2') ADVANCE(88);
      END_STATE();
    case 83:
      if (lookahead == '2') ADVANCE(90);
      END_STATE();
    case 84:
      if (lookahead == '4') ADVANCE(317);
      END_STATE();
    case 85:
      if (lookahead == '4') ADVANCE(315);
      END_STATE();
    case 86:
      if (lookahead == '4') ADVANCE(398);
      END_STATE();
    case 87:
      if (lookahead == '5') ADVANCE(91);
      END_STATE();
    case 88:
      if (lookahead == '5') ADVANCE(76);
      END_STATE();
    case 89:
      if (lookahead == '5') ADVANCE(77);
      END_STATE();
    case 90:
      if (lookahead == '5') ADVANCE(78);
      END_STATE();
    case 91:
      if (lookahead == '6') ADVANCE(398);
      END_STATE();
    case 92:
      if (lookahead == '8') ADVANCE(398);
      END_STATE();
    case 93:
      if (lookahead == '8') ADVANCE(321);
      END_STATE();
    case 94:
      if (lookahead == '8') ADVANCE(319);
      END_STATE();
    case 95:
      if (lookahead == ':') ADVANCE(295);
      END_STATE();
    case 96:
      if (lookahead == '=') ADVANCE(364);
      END_STATE();
    case 97:
      if (lookahead == '>') ADVANCE(289);
      END_STATE();
    case 98:
      if (lookahead == '>') ADVANCE(370);
      END_STATE();
    case 99:
      if (lookahead == 'A') ADVANCE(186);
      END_STATE();
    case 100:
      if (lookahead == 'a') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(156);
      if (lookahead == 'n') ADVANCE(287);
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 101:
      if (lookahead == 'a') ADVANCE(151);
      END_STATE();
    case 102:
      if (lookahead == 'a') ADVANCE(215);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(170);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(122);
      END_STATE();
    case 105:
      if (lookahead == 'a') ADVANCE(194);
      if (lookahead == 'o') ADVANCE(115);
      if (lookahead == 'u') ADVANCE(195);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(212);
      END_STATE();
    case 107:
      if (lookahead == 'a') ADVANCE(203);
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(205);
      END_STATE();
    case 109:
      if (lookahead == 'b') ADVANCE(388);
      END_STATE();
    case 110:
      if (lookahead == 'c') ADVANCE(392);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(382);
      END_STATE();
    case 112:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 113:
      if (lookahead == 'c') ADVANCE(198);
      END_STATE();
    case 114:
      if (lookahead == 'c') ADVANCE(149);
      END_STATE();
    case 115:
      if (lookahead == 'd') ADVANCE(280);
      if (lookahead == 'v') ADVANCE(121);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(293);
      if (lookahead == 'i') ADVANCE(216);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(398);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(427);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(421);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(266);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(607);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(323);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(394);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(374);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(193);
      if (lookahead == 'o') ADVANCE(173);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 136:
      if (lookahead == 'f') ADVANCE(378);
      END_STATE();
    case 137:
      if (lookahead == 'f') ADVANCE(262);
      END_STATE();
    case 138:
      if (lookahead == 'f') ADVANCE(433);
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 139:
      if (lookahead == 'f') ADVANCE(106);
      END_STATE();
    case 140:
      if (lookahead == 'f') ADVANCE(135);
      END_STATE();
    case 141:
      if (lookahead == 'h') ADVANCE(146);
      END_STATE();
    case 142:
      if (lookahead == 'h') ADVANCE(386);
      END_STATE();
    case 143:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(197);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(217);
      END_STATE();
    case 151:
      if (lookahead == 'k') ADVANCE(372);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(325);
      END_STATE();
    case 153:
      if (lookahead == 'l') ADVANCE(260);
      END_STATE();
    case 154:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 155:
      if (lookahead == 'l') ADVANCE(189);
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'x') ADVANCE(204);
      END_STATE();
    case 156:
      if (lookahead == 'l') ADVANCE(201);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(147);
      END_STATE();
    case 158:
      if (lookahead == 'l') ADVANCE(199);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(127);
      END_STATE();
    case 160:
      if (lookahead == 'l') ADVANCE(191);
      END_STATE();
    case 161:
      if (lookahead == 'l') ADVANCE(206);
      END_STATE();
    case 162:
      if (lookahead == 'l') ADVANCE(207);
      END_STATE();
    case 163:
      if (lookahead == 'm') ADVANCE(284);
      END_STATE();
    case 164:
      if (lookahead == 'm') ADVANCE(177);
      END_STATE();
    case 165:
      if (lookahead == 'm') ADVANCE(177);
      if (lookahead == 'n') ADVANCE(431);
      END_STATE();
    case 166:
      if (lookahead == 'n') ADVANCE(190);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(380);
      END_STATE();
    case 168:
      if (lookahead == 'n') ADVANCE(390);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 170:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 171:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 172:
      if (lookahead == 'o') ADVANCE(152);
      END_STATE();
    case 173:
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 174:
      if (lookahead == 'p') ADVANCE(384);
      END_STATE();
    case 175:
      if (lookahead == 'p') ADVANCE(103);
      END_STATE();
    case 176:
      if (lookahead == 'p') ADVANCE(153);
      END_STATE();
    case 177:
      if (lookahead == 'p') ADVANCE(157);
      END_STATE();
    case 178:
      if (lookahead == 'p') ADVANCE(133);
      END_STATE();
    case 179:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 180:
      if (lookahead == 'r') ADVANCE(104);
      if (lookahead == 'y') ADVANCE(179);
      END_STATE();
    case 181:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(605);
      END_STATE();
    case 183:
      if (lookahead == 'r') ADVANCE(167);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(168);
      END_STATE();
    case 185:
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 187:
      if (lookahead == 's') ADVANCE(296);
      END_STATE();
    case 188:
      if (lookahead == 's') ADVANCE(290);
      END_STATE();
    case 189:
      if (lookahead == 's') ADVANCE(120);
      END_STATE();
    case 190:
      if (lookahead == 's') ADVANCE(196);
      if (lookahead == 't') ADVANCE(143);
      END_STATE();
    case 191:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 192:
      if (lookahead == 't') ADVANCE(107);
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 194:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 195:
      if (lookahead == 't') ADVANCE(603);
      END_STATE();
    case 196:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 198:
      if (lookahead == 't') ADVANCE(282);
      END_STATE();
    case 199:
      if (lookahead == 't') ADVANCE(376);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 202:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 204:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 206:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 207:
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 208:
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 209:
      if (lookahead == 'u') ADVANCE(163);
      END_STATE();
    case 210:
      if (lookahead == 'u') ADVANCE(113);
      END_STATE();
    case 211:
      if (lookahead == 'u') ADVANCE(128);
      END_STATE();
    case 212:
      if (lookahead == 'u') ADVANCE(158);
      END_STATE();
    case 213:
      if (lookahead == 'u') ADVANCE(184);
      END_STATE();
    case 214:
      if (lookahead == 'y') ADVANCE(202);
      END_STATE();
    case 215:
      if (lookahead == 'y') ADVANCE(327);
      END_STATE();
    case 216:
      if (lookahead == 'z') ADVANCE(126);
      END_STATE();
    case 217:
      if (lookahead == 'z') ADVANCE(118);
      END_STATE();
    case 218:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(403);
      END_STATE();
    case 219:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(405);
      END_STATE();
    case 220:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(409);
      END_STATE();
    case 221:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(29);
      END_STATE();
    case 222:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(417);
      END_STATE();
    case 223:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(32);
      END_STATE();
    case 224:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 225:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(33);
      END_STATE();
    case 226:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(34);
      END_STATE();
    case 227:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(35);
      END_STATE();
    case 228:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(36);
      END_STATE();
    case 229:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(37);
      END_STATE();
    case 230:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(38);
      END_STATE();
    case 231:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(39);
      END_STATE();
    case 232:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(40);
      END_STATE();
    case 233:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(41);
      END_STATE();
    case 234:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(42);
      END_STATE();
    case 235:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(43);
      END_STATE();
    case 236:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(44);
      END_STATE();
    case 237:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(45);
      END_STATE();
    case 238:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(46);
      END_STATE();
    case 239:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(47);
      END_STATE();
    case 240:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 241:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(49);
      END_STATE();
    case 242:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(50);
      END_STATE();
    case 243:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(51);
      END_STATE();
    case 244:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(52);
      END_STATE();
    case 245:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(53);
      END_STATE();
    case 246:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(54);
      END_STATE();
    case 247:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(55);
      END_STATE();
    case 248:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(56);
      END_STATE();
    case 249:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(57);
      END_STATE();
    case 250:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(58);
      END_STATE();
    case 251:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(59);
      END_STATE();
    case 252:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(60);
      END_STATE();
    case 253:
      if (eof) ADVANCE(257);
      ADVANCE_MAP(
        '!', 276,
        '"', 413,
        '#', 277,
        '$', 425,
        '%', 342,
        '&', 347,
        '\'', 30,
        '(', 299,
        ')', 302,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 339,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 269,
        ';', 263,
        '<', 426,
        '=', 274,
        '>', 334,
        '?', 371,
        '@', 367,
        'B', 214,
        '[', 278,
        ']', 279,
        '^', 344,
        '_', 300,
        'a', 187,
        'b', 25,
        'c', 24,
        'd', 129,
        'e', 155,
        'f', 100,
        'i', 69,
        'l', 130,
        'm', 105,
        'n', 171,
        'o', 137,
        'p', 208,
        'r', 116,
        's', 192,
        't', 180,
        'u', 70,
        'w', 141,
        '{', 258,
        '|', 349,
        '}', 259,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(253);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      END_STATE();
    case 254:
      if (eof) ADVANCE(257);
      ADVANCE_MAP(
        '!', 276,
        '"', 413,
        '#', 277,
        '%', 342,
        '&', 346,
        '\'', 30,
        '(', 299,
        ')', 302,
        '*', 298,
        '+', 336,
        ',', 286,
        '-', 338,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 95,
        ';', 263,
        '<', 332,
        '=', 273,
        '>', 334,
        '?', 371,
        '@', 367,
        'B', 598,
        '[', 278,
        ']', 279,
        '^', 343,
        '_', 411,
        'b', 435,
        'c', 437,
        'd', 490,
        'e', 540,
        'f', 469,
        'i', 440,
        'l', 504,
        'm', 476,
        'p', 588,
        'r', 491,
        's', 580,
        't', 558,
        'u', 445,
        'w', 516,
        '{', 258,
        '|', 350,
        '}', 259,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(254);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 255:
      if (eof) ADVANCE(257);
      ADVANCE_MAP(
        '!', 276,
        '"', 413,
        '#', 277,
        '%', 342,
        '&', 346,
        '\'', 30,
        '(', 299,
        '*', 298,
        '+', 336,
        '-', 338,
        '.', 369,
        '/', 341,
        '0', 399,
        ':', 95,
        ';', 263,
        '<', 332,
        '=', 273,
        '>', 334,
        '?', 371,
        '@', 367,
        'B', 598,
        '[', 278,
        '^', 343,
        '_', 411,
        'b', 435,
        'c', 437,
        'd', 490,
        'e', 532,
        'f', 469,
        'i', 440,
        'l', 504,
        'm', 476,
        'p', 588,
        'r', 491,
        's', 580,
        't', 558,
        'u', 445,
        'w', 516,
        '{', 258,
        '|', 350,
        '}', 259,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(255);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 256:
      if (eof) ADVANCE(257);
      ADVANCE_MAP(
        '!', 275,
        '"', 413,
        '#', 277,
        '\'', 30,
        '(', 299,
        ')', 302,
        '*', 297,
        ',', 286,
        '-', 337,
        '.', 66,
        '/', 67,
        '0', 399,
        ':', 269,
        ';', 263,
        '<', 426,
        '=', 272,
        '>', 333,
        '@', 367,
        'B', 598,
        '[', 278,
        ']', 279,
        '_', 411,
        'b', 435,
        'c', 437,
        'd', 490,
        'e', 540,
        'f', 469,
        'i', 440,
        'l', 504,
        'm', 476,
        'p', 588,
        'r', 491,
        's', 580,
        't', 558,
        'u', 445,
        'w', 516,
        '{', 258,
        '|', 348,
        '}', 259,
        '~', 345,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(256);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_impl);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_impl);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_trait);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_trait);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(295);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(363);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(363);
      if (lookahead == '>') ADVANCE(370);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(364);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_mod);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_mod);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_struct);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_enum);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_implicits);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_use);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(357);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(411);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_u8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_i8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_u16);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_u16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_i16);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_i16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_u32);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_u32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_i32);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_i32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_u64);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_u64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_i64);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_i64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_u128);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_u128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_i128);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_i128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_usize);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_usize);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_ByteArray);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_ByteArray);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_felt252);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_felt252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(353);
      if (lookahead == '=') ADVANCE(366);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(365);
      if (lookahead == '>') ADVANCE(354);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(355);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(356);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(356);
      if (lookahead == '>') ADVANCE(289);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(289);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(608);
      if (lookahead == '=') ADVANCE(358);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(359);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(360);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(351);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(351);
      if (lookahead == '=') ADVANCE(361);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(362);
      if (lookahead == '|') ADVANCE(352);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(352);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(368);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_break);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_continue);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_default);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_extern);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_nopanic);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_nopanic);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_loop);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_match);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_pub);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_pub);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_static);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_numeric_literal);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(400);
      if (lookahead == 'b') ADVANCE(218);
      if (lookahead == 'o') ADVANCE(219);
      if (lookahead == 'x') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(400);
      if (lookahead == 'f') ADVANCE(134);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'u') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(402);
      if (lookahead == 'f') ADVANCE(134);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'u') ADVANCE(71);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(403);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(402);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(403);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(404);
      if (lookahead == 'f') ADVANCE(134);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'u') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(405);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(405);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(407);
      if (lookahead == 'e') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(409);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(407);
      if (lookahead == 'f') ADVANCE(406);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'u') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(409);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(407);
      if (lookahead == 'l') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(409);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(409);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(410);
      if (lookahead == 'f') ADVANCE(512);
      if (lookahead == 'i') ADVANCE(448);
      if (lookahead == 'u') ADVANCE(447);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(411);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(411);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '\n') ADVANCE(417);
      if (lookahead == '"') ADVANCE(608);
      if (lookahead == '\\') ADVANCE(609);
      if (lookahead != 0) ADVANCE(414);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '/') ADVANCE(416);
      if (lookahead == '\\') ADVANCE(222);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(415);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(417);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '/') ADVANCE(414);
      if (lookahead == '\\') ADVANCE(222);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(417);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '\\') ADVANCE(222);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(417);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_shortstring_literal);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_shortstring_literal);
      if (lookahead == '_') ADVANCE(140);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_LT2);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_move);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_move);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_ref);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(413);
      if (lookahead == 'o') ADVANCE(549);
      if (lookahead == 'r') ADVANCE(492);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(413);
      if (lookahead == 'o') ADVANCE(549);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(413);
      if (lookahead == 'o') ADVANCE(537);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(413);
      if (lookahead == 'o') ADVANCE(544);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(449);
      if (lookahead == '3') ADVANCE(450);
      if (lookahead == '6') ADVANCE(458);
      if (lookahead == '8') ADVANCE(306);
      if (lookahead == 'f') ADVANCE(379);
      if (lookahead == 'm') ADVANCE(554);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(449);
      if (lookahead == '3') ADVANCE(450);
      if (lookahead == '6') ADVANCE(458);
      if (lookahead == '8') ADVANCE(306);
      if (lookahead == 'f') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(449);
      if (lookahead == '3') ADVANCE(450);
      if (lookahead == '6') ADVANCE(458);
      if (lookahead == '8') ADVANCE(306);
      if (lookahead == 'm') ADVANCE(554);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(449);
      if (lookahead == '3') ADVANCE(450);
      if (lookahead == '6') ADVANCE(458);
      if (lookahead == '8') ADVANCE(306);
      if (lookahead == 'n') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(449);
      if (lookahead == '3') ADVANCE(450);
      if (lookahead == '6') ADVANCE(458);
      if (lookahead == '8') ADVANCE(306);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(454);
      if (lookahead == '3') ADVANCE(451);
      if (lookahead == '6') ADVANCE(459);
      if (lookahead == '8') ADVANCE(304);
      if (lookahead == 's') ADVANCE(493);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(454);
      if (lookahead == '3') ADVANCE(451);
      if (lookahead == '6') ADVANCE(459);
      if (lookahead == '8') ADVANCE(304);
      if (lookahead == 's') ADVANCE(518);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(456);
      if (lookahead == '2') ADVANCE(461);
      if (lookahead == '3') ADVANCE(452);
      if (lookahead == '6') ADVANCE(460);
      if (lookahead == '8') ADVANCE(412);
      if (lookahead == 's') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(456);
      if (lookahead == '3') ADVANCE(452);
      if (lookahead == '6') ADVANCE(460);
      if (lookahead == '8') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(466);
      if (lookahead == '6') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(467);
      if (lookahead == '6') ADVANCE(308);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(465);
      if (lookahead == '6') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(462);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '4') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '4') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '4') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '5') ADVANCE(464);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '5') ADVANCE(452);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '5') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '6') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '8') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '8') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '8') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(566);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(526);
      if (lookahead == 'e') ADVANCE(529);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'o') ADVANCE(559);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(526);
      if (lookahead == 'e') ADVANCE(529);
      if (lookahead == 'o') ADVANCE(559);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(526);
      if (lookahead == 'e') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(525);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(599);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(523);
      if (lookahead == 'u') ADVANCE(497);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(523);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(573);
      if (lookahead == 'o') ADVANCE(488);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(573);
      if (lookahead == 'o') ADVANCE(597);
      if (lookahead == 'u') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(573);
      if (lookahead == 'o') ADVANCE(597);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(573);
      if (lookahead == 'o') ADVANCE(489);
      if (lookahead == 'u') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(596);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(543);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(585);
      if (lookahead == 'r') ADVANCE(591);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(517);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(576);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(281);
      if (lookahead == 'v') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(515);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(513);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(472);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(294);
      if (lookahead == 'i') ADVANCE(600);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(468);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(428);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(572);
      if (lookahead == 'o') ADVANCE(550);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(572);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(514);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(529);
      if (lookahead == 'n') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(561);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(560);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(581);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(534);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(434);
      if (lookahead == 't') ADVANCE(592);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(480);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(522);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(600);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(484);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(531);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(575);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(570);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(583);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(577);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(501);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(571);
      if (lookahead == 'n') ADVANCE(589);
      if (lookahead == 'x') ADVANCE(586);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(571);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(587);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(568);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(589);
      if (lookahead == 'x') ADVANCE(586);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(569);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(595);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(521);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(584);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(549);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(597);
      if (lookahead == 'u') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(489);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(550);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(527);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(553);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(555);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(541);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(528);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(481);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(510);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(498);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 'y') ADVANCE(557);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(606);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(591);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(539);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 'y') ADVANCE(557);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(562);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(593);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(574);
      if (lookahead == 't') ADVANCE(519);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(574);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(499);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(503);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(292);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(486);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(265);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(482);
      if (lookahead == 'u') ADVANCE(556);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(604);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(563);
      if (lookahead == 'u') ADVANCE(556);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(592);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(494);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(455);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(519);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(520);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(509);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(457);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(535);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(556);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(487);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(564);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(497);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(502);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(530);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(582);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'z') ADVANCE(500);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(602);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'z') ADVANCE(495);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(602);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_mutable_specifier);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_mutable_specifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_super);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(602);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_crate);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(608);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(414);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 256},
  [2] = {.lex_state = 256},
  [3] = {.lex_state = 256},
  [4] = {.lex_state = 256},
  [5] = {.lex_state = 256},
  [6] = {.lex_state = 256},
  [7] = {.lex_state = 256},
  [8] = {.lex_state = 256},
  [9] = {.lex_state = 256},
  [10] = {.lex_state = 256},
  [11] = {.lex_state = 256},
  [12] = {.lex_state = 256},
  [13] = {.lex_state = 256},
  [14] = {.lex_state = 256},
  [15] = {.lex_state = 256},
  [16] = {.lex_state = 256},
  [17] = {.lex_state = 256},
  [18] = {.lex_state = 256},
  [19] = {.lex_state = 256},
  [20] = {.lex_state = 256},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 3},
  [28] = {.lex_state = 3},
  [29] = {.lex_state = 3},
  [30] = {.lex_state = 3},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 3},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 1},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 5},
  [87] = {.lex_state = 5},
  [88] = {.lex_state = 5},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 5},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 254},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 254},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 5},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 5},
  [113] = {.lex_state = 254},
  [114] = {.lex_state = 254},
  [115] = {.lex_state = 254},
  [116] = {.lex_state = 254},
  [117] = {.lex_state = 254},
  [118] = {.lex_state = 5},
  [119] = {.lex_state = 254},
  [120] = {.lex_state = 254},
  [121] = {.lex_state = 254},
  [122] = {.lex_state = 254},
  [123] = {.lex_state = 5},
  [124] = {.lex_state = 254},
  [125] = {.lex_state = 254},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 254},
  [128] = {.lex_state = 254},
  [129] = {.lex_state = 254},
  [130] = {.lex_state = 5},
  [131] = {.lex_state = 255},
  [132] = {.lex_state = 6},
  [133] = {.lex_state = 6},
  [134] = {.lex_state = 5},
  [135] = {.lex_state = 6},
  [136] = {.lex_state = 6},
  [137] = {.lex_state = 6},
  [138] = {.lex_state = 6},
  [139] = {.lex_state = 6},
  [140] = {.lex_state = 6},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 8},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 8},
  [147] = {.lex_state = 8},
  [148] = {.lex_state = 8},
  [149] = {.lex_state = 8},
  [150] = {.lex_state = 255},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 255},
  [154] = {.lex_state = 255},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 8},
  [160] = {.lex_state = 8},
  [161] = {.lex_state = 5},
  [162] = {.lex_state = 8},
  [163] = {.lex_state = 7},
  [164] = {.lex_state = 7},
  [165] = {.lex_state = 254},
  [166] = {.lex_state = 254},
  [167] = {.lex_state = 7},
  [168] = {.lex_state = 5},
  [169] = {.lex_state = 5},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 5},
  [174] = {.lex_state = 5},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 5},
  [177] = {.lex_state = 5},
  [178] = {.lex_state = 5},
  [179] = {.lex_state = 5},
  [180] = {.lex_state = 5},
  [181] = {.lex_state = 5},
  [182] = {.lex_state = 5},
  [183] = {.lex_state = 5},
  [184] = {.lex_state = 5},
  [185] = {.lex_state = 5},
  [186] = {.lex_state = 5},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 5},
  [189] = {.lex_state = 5},
  [190] = {.lex_state = 5},
  [191] = {.lex_state = 5},
  [192] = {.lex_state = 5},
  [193] = {.lex_state = 5},
  [194] = {.lex_state = 5},
  [195] = {.lex_state = 5},
  [196] = {.lex_state = 5},
  [197] = {.lex_state = 254},
  [198] = {.lex_state = 5},
  [199] = {.lex_state = 5},
  [200] = {.lex_state = 5},
  [201] = {.lex_state = 5},
  [202] = {.lex_state = 5},
  [203] = {.lex_state = 5},
  [204] = {.lex_state = 5},
  [205] = {.lex_state = 5},
  [206] = {.lex_state = 5},
  [207] = {.lex_state = 5},
  [208] = {.lex_state = 5},
  [209] = {.lex_state = 5},
  [210] = {.lex_state = 5},
  [211] = {.lex_state = 5},
  [212] = {.lex_state = 5},
  [213] = {.lex_state = 5},
  [214] = {.lex_state = 5},
  [215] = {.lex_state = 5},
  [216] = {.lex_state = 5},
  [217] = {.lex_state = 5},
  [218] = {.lex_state = 5},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 5},
  [221] = {.lex_state = 5},
  [222] = {.lex_state = 5},
  [223] = {.lex_state = 5},
  [224] = {.lex_state = 5},
  [225] = {.lex_state = 5},
  [226] = {.lex_state = 5},
  [227] = {.lex_state = 5},
  [228] = {.lex_state = 5},
  [229] = {.lex_state = 5},
  [230] = {.lex_state = 5},
  [231] = {.lex_state = 5},
  [232] = {.lex_state = 5},
  [233] = {.lex_state = 5},
  [234] = {.lex_state = 5},
  [235] = {.lex_state = 5},
  [236] = {.lex_state = 5},
  [237] = {.lex_state = 5},
  [238] = {.lex_state = 5},
  [239] = {.lex_state = 5},
  [240] = {.lex_state = 5},
  [241] = {.lex_state = 5},
  [242] = {.lex_state = 5},
  [243] = {.lex_state = 5},
  [244] = {.lex_state = 5},
  [245] = {.lex_state = 5},
  [246] = {.lex_state = 5},
  [247] = {.lex_state = 5},
  [248] = {.lex_state = 5},
  [249] = {.lex_state = 5},
  [250] = {.lex_state = 5},
  [251] = {.lex_state = 5},
  [252] = {.lex_state = 9},
  [253] = {.lex_state = 9},
  [254] = {.lex_state = 9},
  [255] = {.lex_state = 13},
  [256] = {.lex_state = 9},
  [257] = {.lex_state = 13},
  [258] = {.lex_state = 13},
  [259] = {.lex_state = 13},
  [260] = {.lex_state = 13},
  [261] = {.lex_state = 13},
  [262] = {.lex_state = 13},
  [263] = {.lex_state = 256},
  [264] = {.lex_state = 256},
  [265] = {.lex_state = 256},
  [266] = {.lex_state = 14},
  [267] = {.lex_state = 256},
  [268] = {.lex_state = 256},
  [269] = {.lex_state = 256},
  [270] = {.lex_state = 256},
  [271] = {.lex_state = 256},
  [272] = {.lex_state = 256},
  [273] = {.lex_state = 256},
  [274] = {.lex_state = 256},
  [275] = {.lex_state = 256},
  [276] = {.lex_state = 256},
  [277] = {.lex_state = 256},
  [278] = {.lex_state = 256},
  [279] = {.lex_state = 256},
  [280] = {.lex_state = 256},
  [281] = {.lex_state = 256},
  [282] = {.lex_state = 256},
  [283] = {.lex_state = 256},
  [284] = {.lex_state = 256},
  [285] = {.lex_state = 256},
  [286] = {.lex_state = 256},
  [287] = {.lex_state = 256},
  [288] = {.lex_state = 256},
  [289] = {.lex_state = 256},
  [290] = {.lex_state = 256},
  [291] = {.lex_state = 256},
  [292] = {.lex_state = 256},
  [293] = {.lex_state = 256},
  [294] = {.lex_state = 256},
  [295] = {.lex_state = 256},
  [296] = {.lex_state = 256},
  [297] = {.lex_state = 256},
  [298] = {.lex_state = 256},
  [299] = {.lex_state = 256},
  [300] = {.lex_state = 256},
  [301] = {.lex_state = 256},
  [302] = {.lex_state = 256},
  [303] = {.lex_state = 256},
  [304] = {.lex_state = 256},
  [305] = {.lex_state = 256},
  [306] = {.lex_state = 256},
  [307] = {.lex_state = 256},
  [308] = {.lex_state = 256},
  [309] = {.lex_state = 256},
  [310] = {.lex_state = 256},
  [311] = {.lex_state = 256},
  [312] = {.lex_state = 256},
  [313] = {.lex_state = 256},
  [314] = {.lex_state = 256},
  [315] = {.lex_state = 256},
  [316] = {.lex_state = 256},
  [317] = {.lex_state = 256},
  [318] = {.lex_state = 256},
  [319] = {.lex_state = 19},
  [320] = {.lex_state = 256},
  [321] = {.lex_state = 256},
  [322] = {.lex_state = 256},
  [323] = {.lex_state = 256},
  [324] = {.lex_state = 256},
  [325] = {.lex_state = 256},
  [326] = {.lex_state = 256},
  [327] = {.lex_state = 256},
  [328] = {.lex_state = 256},
  [329] = {.lex_state = 256},
  [330] = {.lex_state = 256},
  [331] = {.lex_state = 256},
  [332] = {.lex_state = 256},
  [333] = {.lex_state = 256},
  [334] = {.lex_state = 256},
  [335] = {.lex_state = 256},
  [336] = {.lex_state = 256},
  [337] = {.lex_state = 256},
  [338] = {.lex_state = 256},
  [339] = {.lex_state = 256},
  [340] = {.lex_state = 256},
  [341] = {.lex_state = 256},
  [342] = {.lex_state = 256},
  [343] = {.lex_state = 256},
  [344] = {.lex_state = 256},
  [345] = {.lex_state = 256},
  [346] = {.lex_state = 256},
  [347] = {.lex_state = 256},
  [348] = {.lex_state = 19},
  [349] = {.lex_state = 19},
  [350] = {.lex_state = 14},
  [351] = {.lex_state = 14},
  [352] = {.lex_state = 14},
  [353] = {.lex_state = 13},
  [354] = {.lex_state = 13},
  [355] = {.lex_state = 13},
  [356] = {.lex_state = 13},
  [357] = {.lex_state = 19},
  [358] = {.lex_state = 13},
  [359] = {.lex_state = 15},
  [360] = {.lex_state = 15},
  [361] = {.lex_state = 21},
  [362] = {.lex_state = 21},
  [363] = {.lex_state = 15},
  [364] = {.lex_state = 19},
  [365] = {.lex_state = 21},
  [366] = {.lex_state = 15},
  [367] = {.lex_state = 15},
  [368] = {.lex_state = 15},
  [369] = {.lex_state = 15},
  [370] = {.lex_state = 15},
  [371] = {.lex_state = 15},
  [372] = {.lex_state = 15},
  [373] = {.lex_state = 15},
  [374] = {.lex_state = 15},
  [375] = {.lex_state = 15},
  [376] = {.lex_state = 15},
  [377] = {.lex_state = 18},
  [378] = {.lex_state = 18},
  [379] = {.lex_state = 19},
  [380] = {.lex_state = 19},
  [381] = {.lex_state = 18},
  [382] = {.lex_state = 18},
  [383] = {.lex_state = 18},
  [384] = {.lex_state = 18},
  [385] = {.lex_state = 18},
  [386] = {.lex_state = 18},
  [387] = {.lex_state = 18},
  [388] = {.lex_state = 18},
  [389] = {.lex_state = 21},
  [390] = {.lex_state = 21},
  [391] = {.lex_state = 21},
  [392] = {.lex_state = 21},
  [393] = {.lex_state = 19},
  [394] = {.lex_state = 21},
  [395] = {.lex_state = 19},
  [396] = {.lex_state = 21},
  [397] = {.lex_state = 19},
  [398] = {.lex_state = 19},
  [399] = {.lex_state = 21},
  [400] = {.lex_state = 19},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 18},
  [403] = {.lex_state = 18},
  [404] = {.lex_state = 18},
  [405] = {.lex_state = 18},
  [406] = {.lex_state = 18},
  [407] = {.lex_state = 18},
  [408] = {.lex_state = 18},
  [409] = {.lex_state = 18},
  [410] = {.lex_state = 5},
  [411] = {.lex_state = 18},
  [412] = {.lex_state = 18},
  [413] = {.lex_state = 18},
  [414] = {.lex_state = 18},
  [415] = {.lex_state = 18},
  [416] = {.lex_state = 18},
  [417] = {.lex_state = 18},
  [418] = {.lex_state = 18},
  [419] = {.lex_state = 18},
  [420] = {.lex_state = 18},
  [421] = {.lex_state = 18},
  [422] = {.lex_state = 18},
  [423] = {.lex_state = 18},
  [424] = {.lex_state = 18},
  [425] = {.lex_state = 18},
  [426] = {.lex_state = 18},
  [427] = {.lex_state = 18},
  [428] = {.lex_state = 18},
  [429] = {.lex_state = 18},
  [430] = {.lex_state = 18},
  [431] = {.lex_state = 18},
  [432] = {.lex_state = 18},
  [433] = {.lex_state = 18},
  [434] = {.lex_state = 18},
  [435] = {.lex_state = 18},
  [436] = {.lex_state = 18},
  [437] = {.lex_state = 18},
  [438] = {.lex_state = 18},
  [439] = {.lex_state = 18},
  [440] = {.lex_state = 18},
  [441] = {.lex_state = 18},
  [442] = {.lex_state = 18},
  [443] = {.lex_state = 18},
  [444] = {.lex_state = 18},
  [445] = {.lex_state = 18},
  [446] = {.lex_state = 8},
  [447] = {.lex_state = 8},
  [448] = {.lex_state = 20},
  [449] = {.lex_state = 20},
  [450] = {.lex_state = 20},
  [451] = {.lex_state = 20},
  [452] = {.lex_state = 20},
  [453] = {.lex_state = 20},
  [454] = {.lex_state = 5},
  [455] = {.lex_state = 20},
  [456] = {.lex_state = 20},
  [457] = {.lex_state = 20},
  [458] = {.lex_state = 20},
  [459] = {.lex_state = 2},
  [460] = {.lex_state = 4},
  [461] = {.lex_state = 20},
  [462] = {.lex_state = 4},
  [463] = {.lex_state = 4},
  [464] = {.lex_state = 4},
  [465] = {.lex_state = 4},
  [466] = {.lex_state = 4},
  [467] = {.lex_state = 20},
  [468] = {.lex_state = 4},
  [469] = {.lex_state = 2},
  [470] = {.lex_state = 2},
  [471] = {.lex_state = 2},
  [472] = {.lex_state = 4},
  [473] = {.lex_state = 2},
  [474] = {.lex_state = 2},
  [475] = {.lex_state = 4},
  [476] = {.lex_state = 2},
  [477] = {.lex_state = 2},
  [478] = {.lex_state = 2},
  [479] = {.lex_state = 2},
  [480] = {.lex_state = 2},
  [481] = {.lex_state = 4},
  [482] = {.lex_state = 2},
  [483] = {.lex_state = 2},
  [484] = {.lex_state = 2},
  [485] = {.lex_state = 4},
  [486] = {.lex_state = 2},
  [487] = {.lex_state = 2},
  [488] = {.lex_state = 2},
  [489] = {.lex_state = 2},
  [490] = {.lex_state = 2},
  [491] = {.lex_state = 62},
  [492] = {.lex_state = 2},
  [493] = {.lex_state = 2},
  [494] = {.lex_state = 62},
  [495] = {.lex_state = 2},
  [496] = {.lex_state = 2},
  [497] = {.lex_state = 62},
  [498] = {.lex_state = 2},
  [499] = {.lex_state = 2},
  [500] = {.lex_state = 2},
  [501] = {.lex_state = 2},
  [502] = {.lex_state = 2},
  [503] = {.lex_state = 2},
  [504] = {.lex_state = 2},
  [505] = {.lex_state = 2},
  [506] = {.lex_state = 2},
  [507] = {.lex_state = 2},
  [508] = {.lex_state = 62},
  [509] = {.lex_state = 2},
  [510] = {.lex_state = 2},
  [511] = {.lex_state = 2},
  [512] = {.lex_state = 2},
  [513] = {.lex_state = 2},
  [514] = {.lex_state = 2},
  [515] = {.lex_state = 2},
  [516] = {.lex_state = 2},
  [517] = {.lex_state = 2},
  [518] = {.lex_state = 2},
  [519] = {.lex_state = 2},
  [520] = {.lex_state = 2},
  [521] = {.lex_state = 2},
  [522] = {.lex_state = 2},
  [523] = {.lex_state = 2},
  [524] = {.lex_state = 2},
  [525] = {.lex_state = 62},
  [526] = {.lex_state = 2},
  [527] = {.lex_state = 62},
  [528] = {.lex_state = 2},
  [529] = {.lex_state = 2},
  [530] = {.lex_state = 2},
  [531] = {.lex_state = 2},
  [532] = {.lex_state = 2},
  [533] = {.lex_state = 2},
  [534] = {.lex_state = 62},
  [535] = {.lex_state = 2},
  [536] = {.lex_state = 62},
  [537] = {.lex_state = 2},
  [538] = {.lex_state = 2},
  [539] = {.lex_state = 2},
  [540] = {.lex_state = 3},
  [541] = {.lex_state = 2},
  [542] = {.lex_state = 2},
  [543] = {.lex_state = 2},
  [544] = {.lex_state = 2},
  [545] = {.lex_state = 2},
  [546] = {.lex_state = 2},
  [547] = {.lex_state = 2},
  [548] = {.lex_state = 2},
  [549] = {.lex_state = 2},
  [550] = {.lex_state = 2},
  [551] = {.lex_state = 2},
  [552] = {.lex_state = 2},
  [553] = {.lex_state = 2},
  [554] = {.lex_state = 2},
  [555] = {.lex_state = 2},
  [556] = {.lex_state = 2},
  [557] = {.lex_state = 13},
  [558] = {.lex_state = 13},
  [559] = {.lex_state = 13},
  [560] = {.lex_state = 13},
  [561] = {.lex_state = 13},
  [562] = {.lex_state = 13},
  [563] = {.lex_state = 3},
  [564] = {.lex_state = 13},
  [565] = {.lex_state = 13},
  [566] = {.lex_state = 13},
  [567] = {.lex_state = 13},
  [568] = {.lex_state = 13},
  [569] = {.lex_state = 13},
  [570] = {.lex_state = 13},
  [571] = {.lex_state = 13},
  [572] = {.lex_state = 13},
  [573] = {.lex_state = 13},
  [574] = {.lex_state = 13},
  [575] = {.lex_state = 13},
  [576] = {.lex_state = 13},
  [577] = {.lex_state = 22},
  [578] = {.lex_state = 22},
  [579] = {.lex_state = 3},
  [580] = {.lex_state = 13},
  [581] = {.lex_state = 3},
  [582] = {.lex_state = 18},
  [583] = {.lex_state = 13},
  [584] = {.lex_state = 13},
  [585] = {.lex_state = 13},
  [586] = {.lex_state = 3},
  [587] = {.lex_state = 13},
  [588] = {.lex_state = 13},
  [589] = {.lex_state = 13},
  [590] = {.lex_state = 13},
  [591] = {.lex_state = 13},
  [592] = {.lex_state = 13},
  [593] = {.lex_state = 13},
  [594] = {.lex_state = 13},
  [595] = {.lex_state = 13},
  [596] = {.lex_state = 13},
  [597] = {.lex_state = 13},
  [598] = {.lex_state = 13},
  [599] = {.lex_state = 13},
  [600] = {.lex_state = 13},
  [601] = {.lex_state = 13},
  [602] = {.lex_state = 13},
  [603] = {.lex_state = 13},
  [604] = {.lex_state = 13},
  [605] = {.lex_state = 13},
  [606] = {.lex_state = 13},
  [607] = {.lex_state = 13},
  [608] = {.lex_state = 13},
  [609] = {.lex_state = 13},
  [610] = {.lex_state = 13},
  [611] = {.lex_state = 13},
  [612] = {.lex_state = 13},
  [613] = {.lex_state = 13},
  [614] = {.lex_state = 13},
  [615] = {.lex_state = 13},
  [616] = {.lex_state = 13},
  [617] = {.lex_state = 13},
  [618] = {.lex_state = 13},
  [619] = {.lex_state = 13},
  [620] = {.lex_state = 13},
  [621] = {.lex_state = 13},
  [622] = {.lex_state = 13},
  [623] = {.lex_state = 13},
  [624] = {.lex_state = 13},
  [625] = {.lex_state = 13},
  [626] = {.lex_state = 13},
  [627] = {.lex_state = 13},
  [628] = {.lex_state = 13},
  [629] = {.lex_state = 13},
  [630] = {.lex_state = 13},
  [631] = {.lex_state = 13},
  [632] = {.lex_state = 2},
  [633] = {.lex_state = 13},
  [634] = {.lex_state = 13},
  [635] = {.lex_state = 13},
  [636] = {.lex_state = 13},
  [637] = {.lex_state = 13},
  [638] = {.lex_state = 13},
  [639] = {.lex_state = 13},
  [640] = {.lex_state = 13},
  [641] = {.lex_state = 13},
  [642] = {.lex_state = 13},
  [643] = {.lex_state = 13},
  [644] = {.lex_state = 26},
  [645] = {.lex_state = 2},
  [646] = {.lex_state = 61},
  [647] = {.lex_state = 23},
  [648] = {.lex_state = 3},
  [649] = {.lex_state = 2},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 3},
  [652] = {.lex_state = 2},
  [653] = {.lex_state = 2},
  [654] = {.lex_state = 2},
  [655] = {.lex_state = 2},
  [656] = {.lex_state = 26},
  [657] = {.lex_state = 3},
  [658] = {.lex_state = 2},
  [659] = {.lex_state = 61},
  [660] = {.lex_state = 23},
  [661] = {.lex_state = 3},
  [662] = {.lex_state = 61},
  [663] = {.lex_state = 26},
  [664] = {.lex_state = 17},
  [665] = {.lex_state = 26},
  [666] = {.lex_state = 3},
  [667] = {.lex_state = 3},
  [668] = {.lex_state = 26},
  [669] = {.lex_state = 3},
  [670] = {.lex_state = 26},
  [671] = {.lex_state = 61},
  [672] = {.lex_state = 26},
  [673] = {.lex_state = 61},
  [674] = {.lex_state = 3},
  [675] = {.lex_state = 3},
  [676] = {.lex_state = 2},
  [677] = {.lex_state = 61},
  [678] = {.lex_state = 3},
  [679] = {.lex_state = 2},
  [680] = {.lex_state = 3},
  [681] = {.lex_state = 61},
  [682] = {.lex_state = 61},
  [683] = {.lex_state = 61},
  [684] = {.lex_state = 61},
  [685] = {.lex_state = 61},
  [686] = {.lex_state = 61},
  [687] = {.lex_state = 26},
  [688] = {.lex_state = 61},
  [689] = {.lex_state = 61},
  [690] = {.lex_state = 61},
  [691] = {.lex_state = 61},
  [692] = {.lex_state = 26},
  [693] = {.lex_state = 2},
  [694] = {.lex_state = 61},
  [695] = {.lex_state = 61},
  [696] = {.lex_state = 18},
  [697] = {.lex_state = 61},
  [698] = {.lex_state = 18},
  [699] = {.lex_state = 3},
  [700] = {.lex_state = 3},
  [701] = {.lex_state = 3},
  [702] = {.lex_state = 26},
  [703] = {.lex_state = 61},
  [704] = {.lex_state = 61},
  [705] = {.lex_state = 61},
  [706] = {.lex_state = 2},
  [707] = {.lex_state = 2},
  [708] = {.lex_state = 3},
  [709] = {.lex_state = 3},
  [710] = {.lex_state = 61},
  [711] = {.lex_state = 2},
  [712] = {.lex_state = 61},
  [713] = {.lex_state = 61},
  [714] = {.lex_state = 61},
  [715] = {.lex_state = 61},
  [716] = {.lex_state = 26},
  [717] = {.lex_state = 61},
  [718] = {.lex_state = 61},
  [719] = {.lex_state = 61},
  [720] = {.lex_state = 2},
  [721] = {.lex_state = 61},
  [722] = {.lex_state = 17},
  [723] = {.lex_state = 17},
  [724] = {.lex_state = 19},
  [725] = {.lex_state = 61},
  [726] = {.lex_state = 61},
  [727] = {.lex_state = 61},
  [728] = {.lex_state = 2},
  [729] = {.lex_state = 61},
  [730] = {.lex_state = 2},
  [731] = {.lex_state = 2},
  [732] = {.lex_state = 61},
  [733] = {.lex_state = 61},
  [734] = {.lex_state = 61},
  [735] = {.lex_state = 2},
  [736] = {.lex_state = 61},
  [737] = {.lex_state = 61},
  [738] = {.lex_state = 61},
  [739] = {.lex_state = 61},
  [740] = {.lex_state = 61},
  [741] = {.lex_state = 61},
  [742] = {.lex_state = 61},
  [743] = {.lex_state = 61},
  [744] = {.lex_state = 61},
  [745] = {.lex_state = 61},
  [746] = {.lex_state = 61},
  [747] = {.lex_state = 61},
  [748] = {.lex_state = 61},
  [749] = {.lex_state = 61},
  [750] = {.lex_state = 61},
  [751] = {.lex_state = 61},
  [752] = {.lex_state = 61},
  [753] = {.lex_state = 61},
  [754] = {.lex_state = 61},
  [755] = {.lex_state = 61},
  [756] = {.lex_state = 17},
  [757] = {.lex_state = 2},
  [758] = {.lex_state = 18},
  [759] = {.lex_state = 3},
  [760] = {.lex_state = 3},
  [761] = {.lex_state = 3},
  [762] = {.lex_state = 3},
  [763] = {.lex_state = 3},
  [764] = {.lex_state = 3},
  [765] = {.lex_state = 3},
  [766] = {.lex_state = 3},
  [767] = {.lex_state = 3},
  [768] = {.lex_state = 3},
  [769] = {.lex_state = 3},
  [770] = {.lex_state = 3},
  [771] = {.lex_state = 3},
  [772] = {.lex_state = 3},
  [773] = {.lex_state = 2},
  [774] = {.lex_state = 2},
  [775] = {.lex_state = 3},
  [776] = {.lex_state = 3},
  [777] = {.lex_state = 3},
  [778] = {.lex_state = 2},
  [779] = {.lex_state = 3},
  [780] = {.lex_state = 3},
  [781] = {.lex_state = 3},
  [782] = {.lex_state = 3},
  [783] = {.lex_state = 3},
  [784] = {.lex_state = 2},
  [785] = {.lex_state = 3},
  [786] = {.lex_state = 3},
  [787] = {.lex_state = 2},
  [788] = {.lex_state = 2},
  [789] = {.lex_state = 2},
  [790] = {.lex_state = 3},
  [791] = {.lex_state = 2},
  [792] = {.lex_state = 2},
  [793] = {.lex_state = 2},
  [794] = {.lex_state = 2},
  [795] = {.lex_state = 2},
  [796] = {.lex_state = 2},
  [797] = {.lex_state = 2},
  [798] = {.lex_state = 2},
  [799] = {.lex_state = 2},
  [800] = {.lex_state = 2},
  [801] = {.lex_state = 3},
  [802] = {.lex_state = 3},
  [803] = {.lex_state = 3},
  [804] = {.lex_state = 3},
  [805] = {.lex_state = 3},
  [806] = {.lex_state = 3},
  [807] = {.lex_state = 3},
  [808] = {.lex_state = 3},
  [809] = {.lex_state = 3},
  [810] = {.lex_state = 3},
  [811] = {.lex_state = 2},
  [812] = {.lex_state = 3},
  [813] = {.lex_state = 3},
  [814] = {.lex_state = 2},
  [815] = {.lex_state = 3},
  [816] = {.lex_state = 3},
  [817] = {.lex_state = 3},
  [818] = {.lex_state = 3},
  [819] = {.lex_state = 3},
  [820] = {.lex_state = 3},
  [821] = {.lex_state = 3},
  [822] = {.lex_state = 3},
  [823] = {.lex_state = 3},
  [824] = {.lex_state = 3},
  [825] = {.lex_state = 3},
  [826] = {.lex_state = 3},
  [827] = {.lex_state = 3},
  [828] = {.lex_state = 3},
  [829] = {.lex_state = 3},
  [830] = {.lex_state = 3},
  [831] = {.lex_state = 2},
  [832] = {.lex_state = 2},
  [833] = {.lex_state = 2},
  [834] = {.lex_state = 3},
  [835] = {.lex_state = 3},
  [836] = {.lex_state = 3},
  [837] = {.lex_state = 3},
  [838] = {.lex_state = 3},
  [839] = {.lex_state = 3},
  [840] = {.lex_state = 3},
  [841] = {.lex_state = 3},
  [842] = {.lex_state = 3},
  [843] = {.lex_state = 3},
  [844] = {.lex_state = 3},
  [845] = {.lex_state = 18},
  [846] = {.lex_state = 3},
  [847] = {.lex_state = 3},
  [848] = {.lex_state = 2},
  [849] = {.lex_state = 3},
  [850] = {.lex_state = 2},
  [851] = {.lex_state = 3},
  [852] = {.lex_state = 3},
  [853] = {.lex_state = 2},
  [854] = {.lex_state = 18},
  [855] = {.lex_state = 2},
  [856] = {.lex_state = 2},
  [857] = {.lex_state = 2},
  [858] = {.lex_state = 2},
  [859] = {.lex_state = 2},
  [860] = {.lex_state = 2},
  [861] = {.lex_state = 2},
  [862] = {.lex_state = 2},
  [863] = {.lex_state = 2},
  [864] = {.lex_state = 2},
  [865] = {.lex_state = 2},
  [866] = {.lex_state = 2},
  [867] = {.lex_state = 2},
  [868] = {.lex_state = 2},
  [869] = {.lex_state = 2},
  [870] = {.lex_state = 2},
  [871] = {.lex_state = 2},
  [872] = {.lex_state = 2},
  [873] = {.lex_state = 2},
  [874] = {.lex_state = 2},
  [875] = {.lex_state = 2},
  [876] = {.lex_state = 2},
  [877] = {.lex_state = 2},
  [878] = {.lex_state = 2},
  [879] = {.lex_state = 2},
  [880] = {.lex_state = 2},
  [881] = {.lex_state = 2},
  [882] = {.lex_state = 2},
  [883] = {.lex_state = 2},
  [884] = {.lex_state = 2},
  [885] = {.lex_state = 2},
  [886] = {.lex_state = 2},
  [887] = {.lex_state = 2},
  [888] = {.lex_state = 2},
  [889] = {.lex_state = 2},
  [890] = {.lex_state = 18},
  [891] = {.lex_state = 3},
  [892] = {.lex_state = 2},
  [893] = {.lex_state = 2},
  [894] = {.lex_state = 2},
  [895] = {.lex_state = 2},
  [896] = {.lex_state = 2},
  [897] = {.lex_state = 2},
  [898] = {.lex_state = 2},
  [899] = {.lex_state = 2},
  [900] = {.lex_state = 2},
  [901] = {.lex_state = 2},
  [902] = {.lex_state = 3},
  [903] = {.lex_state = 2},
  [904] = {.lex_state = 61},
  [905] = {.lex_state = 2},
  [906] = {.lex_state = 2},
  [907] = {.lex_state = 18},
  [908] = {.lex_state = 2},
  [909] = {.lex_state = 2},
  [910] = {.lex_state = 3},
  [911] = {.lex_state = 2},
  [912] = {.lex_state = 2},
  [913] = {.lex_state = 2},
  [914] = {.lex_state = 2},
  [915] = {.lex_state = 2},
  [916] = {.lex_state = 2},
  [917] = {.lex_state = 2},
  [918] = {.lex_state = 2},
  [919] = {.lex_state = 2},
  [920] = {.lex_state = 2},
  [921] = {.lex_state = 2},
  [922] = {.lex_state = 2},
  [923] = {.lex_state = 2},
  [924] = {.lex_state = 2},
  [925] = {.lex_state = 2},
  [926] = {.lex_state = 61},
  [927] = {.lex_state = 61},
  [928] = {.lex_state = 61},
  [929] = {.lex_state = 61},
  [930] = {.lex_state = 61},
  [931] = {.lex_state = 61},
  [932] = {.lex_state = 61},
  [933] = {.lex_state = 26},
  [934] = {.lex_state = 26},
  [935] = {.lex_state = 61},
  [936] = {.lex_state = 61},
  [937] = {.lex_state = 61},
  [938] = {.lex_state = 61},
  [939] = {.lex_state = 61},
  [940] = {.lex_state = 61},
  [941] = {.lex_state = 61},
  [942] = {.lex_state = 61},
  [943] = {.lex_state = 61},
  [944] = {.lex_state = 61},
  [945] = {.lex_state = 61},
  [946] = {.lex_state = 61},
  [947] = {.lex_state = 61},
  [948] = {.lex_state = 61},
  [949] = {.lex_state = 10},
  [950] = {.lex_state = 10},
  [951] = {.lex_state = 10},
  [952] = {.lex_state = 10},
  [953] = {.lex_state = 10},
  [954] = {.lex_state = 10},
  [955] = {.lex_state = 10},
  [956] = {.lex_state = 10},
  [957] = {.lex_state = 256},
  [958] = {.lex_state = 10},
  [959] = {.lex_state = 10},
  [960] = {.lex_state = 10},
  [961] = {.lex_state = 10},
  [962] = {.lex_state = 10},
  [963] = {.lex_state = 63},
  [964] = {.lex_state = 63},
  [965] = {.lex_state = 63},
  [966] = {.lex_state = 10},
  [967] = {.lex_state = 63},
  [968] = {.lex_state = 10},
  [969] = {.lex_state = 10},
  [970] = {.lex_state = 10},
  [971] = {.lex_state = 256},
  [972] = {.lex_state = 10},
  [973] = {.lex_state = 10},
  [974] = {.lex_state = 10},
  [975] = {.lex_state = 10},
  [976] = {.lex_state = 10},
  [977] = {.lex_state = 10},
  [978] = {.lex_state = 10},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 11},
  [981] = {.lex_state = 10},
  [982] = {.lex_state = 11},
  [983] = {.lex_state = 10},
  [984] = {.lex_state = 10},
  [985] = {.lex_state = 10},
  [986] = {.lex_state = 12},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 11},
  [989] = {.lex_state = 12},
  [990] = {.lex_state = 256},
  [991] = {.lex_state = 12},
  [992] = {.lex_state = 11},
  [993] = {.lex_state = 10},
  [994] = {.lex_state = 10},
  [995] = {.lex_state = 12},
  [996] = {.lex_state = 63},
  [997] = {.lex_state = 256},
  [998] = {.lex_state = 27},
  [999] = {.lex_state = 256},
  [1000] = {.lex_state = 63},
  [1001] = {.lex_state = 63},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 27},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 10},
  [1006] = {.lex_state = 10},
  [1007] = {.lex_state = 63},
  [1008] = {.lex_state = 10},
  [1009] = {.lex_state = 10},
  [1010] = {.lex_state = 256},
  [1011] = {.lex_state = 256},
  [1012] = {.lex_state = 10},
  [1013] = {.lex_state = 28},
  [1014] = {.lex_state = 28},
  [1015] = {.lex_state = 27},
  [1016] = {.lex_state = 12},
  [1017] = {.lex_state = 10},
  [1018] = {.lex_state = 256},
  [1019] = {.lex_state = 256},
  [1020] = {.lex_state = 10},
  [1021] = {.lex_state = 10},
  [1022] = {.lex_state = 27},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 27},
  [1026] = {.lex_state = 63},
  [1027] = {.lex_state = 27},
  [1028] = {.lex_state = 10},
  [1029] = {.lex_state = 63},
  [1030] = {.lex_state = 63},
  [1031] = {.lex_state = 63},
  [1032] = {.lex_state = 11},
  [1033] = {.lex_state = 28},
  [1034] = {.lex_state = 63},
  [1035] = {.lex_state = 27},
  [1036] = {.lex_state = 11},
  [1037] = {.lex_state = 11},
  [1038] = {.lex_state = 63},
  [1039] = {.lex_state = 28},
  [1040] = {.lex_state = 28},
  [1041] = {.lex_state = 63},
  [1042] = {.lex_state = 63},
  [1043] = {.lex_state = 63},
  [1044] = {.lex_state = 10},
  [1045] = {.lex_state = 63},
  [1046] = {.lex_state = 63},
  [1047] = {.lex_state = 256},
  [1048] = {.lex_state = 256},
  [1049] = {.lex_state = 63},
  [1050] = {.lex_state = 63},
  [1051] = {.lex_state = 63},
  [1052] = {.lex_state = 63},
  [1053] = {.lex_state = 63},
  [1054] = {.lex_state = 28},
  [1055] = {.lex_state = 63},
  [1056] = {.lex_state = 28},
  [1057] = {.lex_state = 63},
  [1058] = {.lex_state = 28},
  [1059] = {.lex_state = 63},
  [1060] = {.lex_state = 63},
  [1061] = {.lex_state = 63},
  [1062] = {.lex_state = 63},
  [1063] = {.lex_state = 63},
  [1064] = {.lex_state = 63},
  [1065] = {.lex_state = 63},
  [1066] = {.lex_state = 63},
  [1067] = {.lex_state = 10},
  [1068] = {.lex_state = 63},
  [1069] = {.lex_state = 63},
  [1070] = {.lex_state = 28},
  [1071] = {.lex_state = 63},
  [1072] = {.lex_state = 256},
  [1073] = {.lex_state = 256},
  [1074] = {.lex_state = 63},
  [1075] = {.lex_state = 63},
  [1076] = {.lex_state = 28},
  [1077] = {.lex_state = 63},
  [1078] = {.lex_state = 28},
  [1079] = {.lex_state = 256},
  [1080] = {.lex_state = 28},
  [1081] = {.lex_state = 28},
  [1082] = {.lex_state = 28},
  [1083] = {.lex_state = 28},
  [1084] = {.lex_state = 28},
  [1085] = {.lex_state = 12},
  [1086] = {.lex_state = 28},
  [1087] = {.lex_state = 28},
  [1088] = {.lex_state = 28},
  [1089] = {.lex_state = 256},
  [1090] = {.lex_state = 28},
  [1091] = {.lex_state = 256},
  [1092] = {.lex_state = 10},
  [1093] = {.lex_state = 64},
  [1094] = {.lex_state = 256},
  [1095] = {.lex_state = 256},
  [1096] = {.lex_state = 64},
  [1097] = {.lex_state = 28},
  [1098] = {.lex_state = 28},
  [1099] = {.lex_state = 28},
  [1100] = {.lex_state = 256},
  [1101] = {.lex_state = 12},
  [1102] = {.lex_state = 12},
  [1103] = {.lex_state = 12},
  [1104] = {.lex_state = 12},
  [1105] = {.lex_state = 256},
  [1106] = {.lex_state = 12},
  [1107] = {.lex_state = 28},
  [1108] = {.lex_state = 256},
  [1109] = {.lex_state = 64},
  [1110] = {.lex_state = 256},
  [1111] = {.lex_state = 256},
  [1112] = {.lex_state = 256},
  [1113] = {.lex_state = 10},
  [1114] = {.lex_state = 256},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 256},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 10},
  [1126] = {.lex_state = 10},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 256},
  [1129] = {.lex_state = 256},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 10},
  [1132] = {.lex_state = 256},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 10},
  [1137] = {.lex_state = 256},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 11},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 65},
  [1143] = {.lex_state = 65},
  [1144] = {.lex_state = 10},
  [1145] = {.lex_state = 63},
  [1146] = {.lex_state = 5},
  [1147] = {.lex_state = 5},
  [1148] = {.lex_state = 5},
  [1149] = {.lex_state = 10},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 10},
  [1152] = {.lex_state = 10},
  [1153] = {.lex_state = 12},
  [1154] = {.lex_state = 4},
  [1155] = {.lex_state = 10},
  [1156] = {.lex_state = 4},
  [1157] = {.lex_state = 5},
  [1158] = {.lex_state = 10},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 256},
  [1161] = {.lex_state = 10},
  [1162] = {.lex_state = 256},
  [1163] = {.lex_state = 256},
  [1164] = {.lex_state = 65},
  [1165] = {.lex_state = 10},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 10},
  [1168] = {.lex_state = 10},
  [1169] = {.lex_state = 4},
  [1170] = {.lex_state = 63},
  [1171] = {.lex_state = 4},
  [1172] = {.lex_state = 10},
  [1173] = {.lex_state = 5},
  [1174] = {.lex_state = 5},
  [1175] = {.lex_state = 10},
  [1176] = {.lex_state = 28},
  [1177] = {.lex_state = 64},
  [1178] = {.lex_state = 5},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 10},
  [1181] = {.lex_state = 27},
  [1182] = {.lex_state = 65},
  [1183] = {.lex_state = 5},
  [1184] = {.lex_state = 27},
  [1185] = {.lex_state = 10},
  [1186] = {.lex_state = 256},
  [1187] = {.lex_state = 63},
  [1188] = {.lex_state = 63},
  [1189] = {.lex_state = 10},
  [1190] = {.lex_state = 63},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 64},
  [1194] = {.lex_state = 256},
  [1195] = {.lex_state = 64},
  [1196] = {.lex_state = 63},
  [1197] = {.lex_state = 64},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 256},
  [1200] = {.lex_state = 5},
  [1201] = {.lex_state = 5},
  [1202] = {.lex_state = 64},
  [1203] = {.lex_state = 256},
  [1204] = {.lex_state = 256},
  [1205] = {.lex_state = 12},
  [1206] = {.lex_state = 5},
  [1207] = {.lex_state = 64},
  [1208] = {.lex_state = 64},
  [1209] = {.lex_state = 64},
  [1210] = {.lex_state = 12},
  [1211] = {.lex_state = 256},
  [1212] = {.lex_state = 256},
  [1213] = {.lex_state = 256},
  [1214] = {.lex_state = 256},
  [1215] = {.lex_state = 12},
  [1216] = {.lex_state = 12},
  [1217] = {.lex_state = 256},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 63},
  [1220] = {.lex_state = 12},
  [1221] = {.lex_state = 12},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 256},
  [1224] = {.lex_state = 65},
  [1225] = {.lex_state = 256},
  [1226] = {.lex_state = 12},
  [1227] = {.lex_state = 65},
  [1228] = {.lex_state = 12},
  [1229] = {.lex_state = 12},
  [1230] = {.lex_state = 12},
  [1231] = {.lex_state = 12},
  [1232] = {.lex_state = 63},
  [1233] = {.lex_state = 12},
  [1234] = {.lex_state = 65},
  [1235] = {.lex_state = 5},
  [1236] = {.lex_state = 65},
  [1237] = {.lex_state = 63},
  [1238] = {.lex_state = 63},
  [1239] = {.lex_state = 12},
  [1240] = {.lex_state = 64},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 64},
  [1243] = {.lex_state = 64},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 64},
  [1246] = {.lex_state = 64},
  [1247] = {.lex_state = 64},
  [1248] = {.lex_state = 64},
  [1249] = {.lex_state = 64},
  [1250] = {.lex_state = 256},
  [1251] = {.lex_state = 256},
  [1252] = {.lex_state = 63},
  [1253] = {.lex_state = 64},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 256},
  [1256] = {.lex_state = 11},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 64},
  [1260] = {.lex_state = 64},
  [1261] = {.lex_state = 64},
  [1262] = {.lex_state = 5},
  [1263] = {.lex_state = 64},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 256},
  [1266] = {.lex_state = 64},
  [1267] = {.lex_state = 63},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 64},
  [1271] = {.lex_state = 64},
  [1272] = {.lex_state = 64},
  [1273] = {.lex_state = 256},
  [1274] = {.lex_state = 64},
  [1275] = {.lex_state = 5},
  [1276] = {.lex_state = 64},
  [1277] = {.lex_state = 64},
  [1278] = {.lex_state = 64},
  [1279] = {.lex_state = 63},
  [1280] = {.lex_state = 64},
  [1281] = {.lex_state = 256},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 64},
  [1284] = {.lex_state = 64},
  [1285] = {.lex_state = 64},
  [1286] = {.lex_state = 64},
  [1287] = {.lex_state = 64},
  [1288] = {.lex_state = 64},
  [1289] = {.lex_state = 64},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 5},
  [1292] = {.lex_state = 10},
  [1293] = {.lex_state = 65},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 64},
  [1296] = {.lex_state = 64},
  [1297] = {.lex_state = 63},
  [1298] = {.lex_state = 63},
  [1299] = {.lex_state = 256},
  [1300] = {.lex_state = 12},
  [1301] = {.lex_state = 5},
  [1302] = {.lex_state = 64},
  [1303] = {.lex_state = 64},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 65},
  [1307] = {.lex_state = 65},
  [1308] = {.lex_state = 64},
  [1309] = {.lex_state = 64},
  [1310] = {.lex_state = 64},
  [1311] = {.lex_state = 64},
  [1312] = {.lex_state = 256},
  [1313] = {.lex_state = 63},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 64},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 64},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 65},
  [1322] = {.lex_state = 256},
  [1323] = {.lex_state = 63},
  [1324] = {.lex_state = 256},
  [1325] = {.lex_state = 256},
  [1326] = {.lex_state = 5},
  [1327] = {.lex_state = 256},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 12},
  [1331] = {.lex_state = 17},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 12},
  [1334] = {.lex_state = 12},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 5},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 17},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 11},
  [1342] = {.lex_state = 12},
  [1343] = {.lex_state = 12},
  [1344] = {.lex_state = 256},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 28},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 256},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 10},
  [1360] = {.lex_state = 12},
  [1361] = {.lex_state = 12},
  [1362] = {.lex_state = 12},
  [1363] = {.lex_state = 12},
  [1364] = {.lex_state = 12},
  [1365] = {.lex_state = 11},
  [1366] = {.lex_state = 12},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 11},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 256},
  [1376] = {.lex_state = 256},
  [1377] = {.lex_state = 5},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 256},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 0},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 11},
  [1386] = {.lex_state = 5},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 0},
  [1389] = {.lex_state = 11},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 0},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 0},
  [1396] = {.lex_state = 0},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 256},
  [1399] = {.lex_state = 0},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 12},
  [1402] = {.lex_state = 12},
  [1403] = {.lex_state = 256},
  [1404] = {.lex_state = 12},
  [1405] = {.lex_state = 12},
  [1406] = {.lex_state = 0},
  [1407] = {.lex_state = 12},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 12},
  [1410] = {.lex_state = 0},
  [1411] = {.lex_state = 0},
  [1412] = {.lex_state = 0},
  [1413] = {.lex_state = 0},
  [1414] = {.lex_state = 5},
  [1415] = {.lex_state = 0},
  [1416] = {.lex_state = 12},
  [1417] = {.lex_state = 256},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 0},
  [1422] = {.lex_state = 0},
  [1423] = {.lex_state = 256},
  [1424] = {.lex_state = 12},
  [1425] = {.lex_state = 256},
  [1426] = {.lex_state = 12},
  [1427] = {.lex_state = 0},
  [1428] = {.lex_state = 256},
  [1429] = {.lex_state = 0},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 0},
  [1433] = {.lex_state = 0},
  [1434] = {.lex_state = 0},
  [1435] = {.lex_state = 0},
  [1436] = {.lex_state = 0},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 11},
  [1439] = {.lex_state = 0},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 11},
  [1442] = {.lex_state = 256},
  [1443] = {.lex_state = 256},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 0},
  [1446] = {.lex_state = 0},
  [1447] = {.lex_state = 12},
  [1448] = {.lex_state = 0},
  [1449] = {.lex_state = 0},
  [1450] = {.lex_state = 256},
  [1451] = {.lex_state = 12},
  [1452] = {.lex_state = 12},
  [1453] = {.lex_state = 256},
  [1454] = {.lex_state = 12},
  [1455] = {.lex_state = 0},
  [1456] = {.lex_state = 256},
  [1457] = {.lex_state = 17},
  [1458] = {.lex_state = 256},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 256},
  [1462] = {.lex_state = 0},
  [1463] = {.lex_state = 11},
  [1464] = {.lex_state = 12},
  [1465] = {.lex_state = 0},
  [1466] = {.lex_state = 256},
  [1467] = {.lex_state = 0},
  [1468] = {.lex_state = 17},
  [1469] = {.lex_state = 0},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 12},
  [1472] = {.lex_state = 256},
  [1473] = {.lex_state = 11},
  [1474] = {.lex_state = 65},
  [1475] = {.lex_state = 0},
  [1476] = {.lex_state = 0},
  [1477] = {.lex_state = 0},
  [1478] = {.lex_state = 0},
  [1479] = {.lex_state = 0},
  [1480] = {.lex_state = 0},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 0},
  [1484] = {.lex_state = 0},
  [1485] = {.lex_state = 12},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 256},
  [1488] = {.lex_state = 0},
  [1489] = {.lex_state = 256},
  [1490] = {.lex_state = 0},
  [1491] = {.lex_state = 11},
  [1492] = {.lex_state = 256},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 256},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 12},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 17},
  [1500] = {.lex_state = 256},
  [1501] = {.lex_state = 12},
  [1502] = {.lex_state = 0},
  [1503] = {.lex_state = 0},
  [1504] = {.lex_state = 0},
  [1505] = {.lex_state = 12},
  [1506] = {.lex_state = 12},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 0},
  [1509] = {.lex_state = 12},
  [1510] = {.lex_state = 11},
  [1511] = {.lex_state = 11},
  [1512] = {.lex_state = 63},
  [1513] = {.lex_state = 11},
  [1514] = {.lex_state = 17},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 11},
  [1517] = {.lex_state = 256},
  [1518] = {.lex_state = 256},
  [1519] = {.lex_state = 12},
  [1520] = {.lex_state = 0},
  [1521] = {.lex_state = 256},
  [1522] = {.lex_state = 256},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 11},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 0},
  [1527] = {.lex_state = 12},
  [1528] = {.lex_state = 11},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 256},
  [1532] = {.lex_state = 11},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 27},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 0},
  [1537] = {.lex_state = 256},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 5},
  [1540] = {.lex_state = 12},
  [1541] = {.lex_state = 11},
  [1542] = {.lex_state = 68},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 256},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 256},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 0},
  [1551] = {.lex_state = 0},
  [1552] = {.lex_state = 0},
  [1553] = {.lex_state = 0},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 10},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 64},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 256},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 64},
  [1564] = {.lex_state = 0},
  [1565] = {.lex_state = 63},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 64},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 256},
  [1571] = {.lex_state = 0},
  [1572] = {.lex_state = 64},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 256},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 11},
  [1577] = {.lex_state = 63},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 64},
  [1580] = {.lex_state = 27},
  [1581] = {.lex_state = 256},
  [1582] = {.lex_state = 11},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 64},
  [1588] = {.lex_state = 0},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 64},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 27},
  [1593] = {.lex_state = 256},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 10},
  [1596] = {.lex_state = 11},
  [1597] = {.lex_state = 256},
  [1598] = {.lex_state = 64},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 256},
  [1601] = {.lex_state = 64},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 64},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 11},
  [1606] = {.lex_state = 0},
  [1607] = {.lex_state = 256},
  [1608] = {.lex_state = 0},
  [1609] = {.lex_state = 11},
  [1610] = {.lex_state = 256},
  [1611] = {.lex_state = 64},
  [1612] = {.lex_state = 256},
  [1613] = {.lex_state = 64},
  [1614] = {.lex_state = 11},
  [1615] = {.lex_state = 11},
  [1616] = {.lex_state = 64},
  [1617] = {.lex_state = 0},
  [1618] = {.lex_state = 64},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 64},
  [1621] = {.lex_state = 256},
  [1622] = {.lex_state = 0},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 11},
  [1625] = {.lex_state = 0},
  [1626] = {.lex_state = 256},
  [1627] = {.lex_state = 256},
  [1628] = {.lex_state = 64},
  [1629] = {.lex_state = 256},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 0},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 64},
  [1634] = {.lex_state = 0},
  [1635] = {.lex_state = 10},
  [1636] = {.lex_state = 64},
  [1637] = {.lex_state = 256},
  [1638] = {.lex_state = 0},
  [1639] = {.lex_state = 0},
  [1640] = {.lex_state = 256},
  [1641] = {.lex_state = 256},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 64},
  [1644] = {.lex_state = 256},
  [1645] = {.lex_state = 64},
  [1646] = {.lex_state = 11},
  [1647] = {.lex_state = 256},
  [1648] = {.lex_state = 64},
  [1649] = {.lex_state = 64},
  [1650] = {.lex_state = 0},
  [1651] = {.lex_state = 0},
  [1652] = {.lex_state = 64},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 0},
  [1655] = {.lex_state = 256},
  [1656] = {.lex_state = 256},
  [1657] = {.lex_state = 64},
  [1658] = {.lex_state = 256},
  [1659] = {.lex_state = 64},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 0},
  [1662] = {.lex_state = 64},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 0},
  [1665] = {.lex_state = 64},
  [1666] = {.lex_state = 0},
  [1667] = {.lex_state = 0},
  [1668] = {.lex_state = 64},
  [1669] = {.lex_state = 64},
  [1670] = {.lex_state = 64},
  [1671] = {.lex_state = 256},
  [1672] = {.lex_state = 64},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 64},
  [1675] = {.lex_state = 0},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 11},
  [1678] = {.lex_state = 64},
  [1679] = {.lex_state = 0},
  [1680] = {.lex_state = 11},
  [1681] = {.lex_state = 0},
  [1682] = {.lex_state = 0},
  [1683] = {.lex_state = 0},
  [1684] = {.lex_state = 0},
  [1685] = {.lex_state = 0},
  [1686] = {.lex_state = 0},
  [1687] = {.lex_state = 256},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 64},
  [1690] = {.lex_state = 256},
  [1691] = {.lex_state = 256},
  [1692] = {.lex_state = 0},
  [1693] = {.lex_state = 11},
  [1694] = {.lex_state = 256},
  [1695] = {.lex_state = 256},
  [1696] = {.lex_state = 11},
  [1697] = {.lex_state = 0},
  [1698] = {.lex_state = 0},
  [1699] = {.lex_state = 68},
  [1700] = {.lex_state = 256},
  [1701] = {.lex_state = 256},
  [1702] = {.lex_state = 64},
  [1703] = {.lex_state = 0},
  [1704] = {.lex_state = 0},
  [1705] = {.lex_state = 0},
  [1706] = {.lex_state = 0},
  [1707] = {.lex_state = 0},
  [1708] = {.lex_state = 256},
  [1709] = {.lex_state = 0},
  [1710] = {.lex_state = 0},
  [1711] = {.lex_state = 256},
  [1712] = {.lex_state = 0},
  [1713] = {.lex_state = 0},
  [1714] = {.lex_state = 256},
  [1715] = {.lex_state = 0},
  [1716] = {.lex_state = 0},
  [1717] = {.lex_state = 256},
  [1718] = {.lex_state = 0},
  [1719] = {.lex_state = 256},
  [1720] = {.lex_state = 0},
  [1721] = {.lex_state = 64},
  [1722] = {.lex_state = 64},
  [1723] = {.lex_state = 64},
  [1724] = {.lex_state = 256},
  [1725] = {.lex_state = 0},
  [1726] = {.lex_state = 256},
  [1727] = {.lex_state = 68},
  [1728] = {.lex_state = 256},
  [1729] = {.lex_state = 256},
  [1730] = {.lex_state = 0},
  [1731] = {.lex_state = 10},
  [1732] = {.lex_state = 10},
  [1733] = {.lex_state = 63},
  [1734] = {.lex_state = 63},
  [1735] = {.lex_state = 0},
  [1736] = {.lex_state = 10},
  [1737] = {.lex_state = 256},
  [1738] = {.lex_state = 10},
  [1739] = {.lex_state = 68},
  [1740] = {.lex_state = 0},
  [1741] = {.lex_state = 64},
  [1742] = {.lex_state = 0},
  [1743] = {.lex_state = 11},
  [1744] = {.lex_state = 0},
  [1745] = {.lex_state = 0},
  [1746] = {.lex_state = 0},
  [1747] = {.lex_state = 0},
  [1748] = {.lex_state = 11},
  [1749] = {.lex_state = 0},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 11},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 0},
  [1755] = {.lex_state = 0},
  [1756] = {.lex_state = 11},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 0},
  [1761] = {.lex_state = 0},
  [1762] = {.lex_state = 0},
  [1763] = {.lex_state = 17},
  [1764] = {.lex_state = 11},
  [1765] = {.lex_state = 11},
  [1766] = {.lex_state = 11},
  [1767] = {.lex_state = 11},
  [1768] = {.lex_state = 11},
  [1769] = {.lex_state = 0},
  [1770] = {.lex_state = 4},
  [1771] = {.lex_state = 11},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 11},
  [1774] = {.lex_state = 11},
  [1775] = {.lex_state = 0},
  [1776] = {.lex_state = 415},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 11},
  [1779] = {.lex_state = 0},
  [1780] = {.lex_state = 17},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 0},
  [1783] = {.lex_state = 0},
  [1784] = {.lex_state = 0},
  [1785] = {.lex_state = 0},
  [1786] = {.lex_state = 11},
  [1787] = {.lex_state = 0},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 11},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 17},
  [1793] = {.lex_state = 0},
  [1794] = {.lex_state = 11},
  [1795] = {.lex_state = 11},
  [1796] = {.lex_state = 11},
  [1797] = {.lex_state = 11},
  [1798] = {.lex_state = 0},
  [1799] = {.lex_state = 0},
  [1800] = {.lex_state = 11},
  [1801] = {.lex_state = 11},
  [1802] = {.lex_state = 11},
  [1803] = {.lex_state = 13},
  [1804] = {.lex_state = 0},
  [1805] = {.lex_state = 11},
  [1806] = {.lex_state = 0},
  [1807] = {.lex_state = 0},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 11},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 0},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 0},
  [1816] = {.lex_state = 0},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 0},
  [1819] = {.lex_state = 11},
  [1820] = {.lex_state = 0},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 17},
  [1825] = {.lex_state = 0},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 0},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 0},
  [1831] = {.lex_state = 11},
  [1832] = {.lex_state = 0},
  [1833] = {.lex_state = 0},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 17},
  [1836] = {.lex_state = 0},
  [1837] = {.lex_state = 11},
  [1838] = {.lex_state = 0},
  [1839] = {.lex_state = 0},
  [1840] = {.lex_state = 11},
  [1841] = {.lex_state = 0},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 0},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 256},
  [1846] = {.lex_state = 0},
  [1847] = {.lex_state = 13},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 11},
  [1850] = {.lex_state = 0},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 11},
  [1853] = {.lex_state = 415},
  [1854] = {.lex_state = 0},
  [1855] = {.lex_state = 17},
  [1856] = {.lex_state = 17},
  [1857] = {.lex_state = 11},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 0},
  [1860] = {.lex_state = 415},
  [1861] = {.lex_state = 0},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 256},
  [1864] = {.lex_state = 13},
  [1865] = {.lex_state = 0},
  [1866] = {.lex_state = 0},
  [1867] = {.lex_state = 415},
  [1868] = {.lex_state = 0},
  [1869] = {.lex_state = 11},
  [1870] = {.lex_state = 11},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 415},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 4},
  [1876] = {.lex_state = 11},
  [1877] = {.lex_state = 13},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 17},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 11},
  [1883] = {.lex_state = 11},
  [1884] = {.lex_state = 17},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 11},
  [1887] = {.lex_state = 13},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 17},
  [1890] = {.lex_state = 11},
  [1891] = {.lex_state = 256},
  [1892] = {.lex_state = 0},
  [1893] = {.lex_state = 0},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 17},
  [1896] = {.lex_state = 0},
  [1897] = {.lex_state = 0},
  [1898] = {.lex_state = 11},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 0},
  [1901] = {.lex_state = 0},
  [1902] = {.lex_state = 11},
  [1903] = {.lex_state = 11},
  [1904] = {.lex_state = 11},
  [1905] = {.lex_state = 0},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_impl] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_trait] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_u128] = ACTIONS(1),
    [anon_sym_i128] = ACTIONS(1),
    [anon_sym_usize] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_ByteArray] = ACTIONS(1),
    [anon_sym_felt252] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym_nopanic] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_pub] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [sym_numeric_literal] = ACTIONS(1),
    [aux_sym_string_literal_token1] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_shortstring_literal] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LT2] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_move] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [sym_mutable_specifier] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_crate] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(1785),
    [sym__statement] = STATE(4),
    [sym_impl_item] = STATE(4),
    [sym_trait_item] = STATE(4),
    [sym_associated_type] = STATE(4),
    [sym_associated_impl] = STATE(4),
    [sym_const_item] = STATE(4),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(4),
    [sym_attribute_item] = STATE(4),
    [sym_inner_attribute_item] = STATE(4),
    [sym_mod_item] = STATE(4),
    [sym_struct_item] = STATE(4),
    [sym_enum_item] = STATE(4),
    [sym_type_item] = STATE(4),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(4),
    [sym_function_item] = STATE(4),
    [sym_function_signature_item] = STATE(4),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(4),
    [sym_use_declaration] = STATE(4),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(4),
    [sym_expression] = STATE(916),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__statement] = STATE(5),
    [sym_impl_item] = STATE(5),
    [sym_trait_item] = STATE(5),
    [sym_associated_type] = STATE(5),
    [sym_associated_impl] = STATE(5),
    [sym_const_item] = STATE(5),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(5),
    [sym_attribute_item] = STATE(5),
    [sym_inner_attribute_item] = STATE(5),
    [sym_mod_item] = STATE(5),
    [sym_struct_item] = STATE(5),
    [sym_enum_item] = STATE(5),
    [sym_type_item] = STATE(5),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(5),
    [sym_function_item] = STATE(5),
    [sym_function_signature_item] = STATE(5),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(5),
    [sym_use_declaration] = STATE(5),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(5),
    [sym_expression] = STATE(831),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(5),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(885),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__statement] = STATE(6),
    [sym_impl_item] = STATE(6),
    [sym_trait_item] = STATE(6),
    [sym_associated_type] = STATE(6),
    [sym_associated_impl] = STATE(6),
    [sym_const_item] = STATE(6),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(6),
    [sym_attribute_item] = STATE(6),
    [sym_inner_attribute_item] = STATE(6),
    [sym_mod_item] = STATE(6),
    [sym_struct_item] = STATE(6),
    [sym_enum_item] = STATE(6),
    [sym_type_item] = STATE(6),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(6),
    [sym_function_item] = STATE(6),
    [sym_function_signature_item] = STATE(6),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(6),
    [sym_use_declaration] = STATE(6),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(6),
    [sym_expression] = STATE(916),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(811),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(93),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__statement] = STATE(6),
    [sym_impl_item] = STATE(6),
    [sym_trait_item] = STATE(6),
    [sym_associated_type] = STATE(6),
    [sym_associated_impl] = STATE(6),
    [sym_const_item] = STATE(6),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(6),
    [sym_attribute_item] = STATE(6),
    [sym_inner_attribute_item] = STATE(6),
    [sym_mod_item] = STATE(6),
    [sym_struct_item] = STATE(6),
    [sym_enum_item] = STATE(6),
    [sym_type_item] = STATE(6),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(6),
    [sym_function_item] = STATE(6),
    [sym_function_signature_item] = STATE(6),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(6),
    [sym_use_declaration] = STATE(6),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(6),
    [sym_expression] = STATE(916),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(97),
    [anon_sym_impl] = ACTIONS(100),
    [anon_sym_SEMI] = ACTIONS(103),
    [anon_sym_trait] = ACTIONS(106),
    [anon_sym_type] = ACTIONS(109),
    [anon_sym_const] = ACTIONS(112),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_POUND] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_mod] = ACTIONS(124),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_enum] = ACTIONS(130),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(136),
    [anon_sym_use] = ACTIONS(139),
    [anon_sym_COLON_COLON] = ACTIONS(142),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_u8] = ACTIONS(148),
    [anon_sym_i8] = ACTIONS(148),
    [anon_sym_u16] = ACTIONS(148),
    [anon_sym_i16] = ACTIONS(148),
    [anon_sym_u32] = ACTIONS(148),
    [anon_sym_i32] = ACTIONS(148),
    [anon_sym_u64] = ACTIONS(148),
    [anon_sym_i64] = ACTIONS(148),
    [anon_sym_u128] = ACTIONS(148),
    [anon_sym_i128] = ACTIONS(148),
    [anon_sym_usize] = ACTIONS(148),
    [anon_sym_bool] = ACTIONS(148),
    [anon_sym_ByteArray] = ACTIONS(148),
    [anon_sym_felt252] = ACTIONS(148),
    [anon_sym_DASH] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(115),
    [anon_sym_PIPE] = ACTIONS(154),
    [anon_sym_AT] = ACTIONS(115),
    [anon_sym_DOT_DOT] = ACTIONS(157),
    [anon_sym_break] = ACTIONS(160),
    [anon_sym_continue] = ACTIONS(163),
    [anon_sym_default] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_extern] = ACTIONS(172),
    [anon_sym_loop] = ACTIONS(175),
    [anon_sym_match] = ACTIONS(178),
    [anon_sym_pub] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(184),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(190),
    [sym_numeric_literal] = ACTIONS(193),
    [aux_sym_string_literal_token1] = ACTIONS(196),
    [sym_shortstring_literal] = ACTIONS(199),
    [anon_sym_true] = ACTIONS(202),
    [anon_sym_false] = ACTIONS(202),
    [anon_sym_move] = ACTIONS(205),
    [anon_sym_ref] = ACTIONS(208),
    [sym_identifier] = ACTIONS(211),
    [sym_super] = ACTIONS(214),
    [sym_line_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__statement] = STATE(8),
    [sym_impl_item] = STATE(8),
    [sym_trait_item] = STATE(8),
    [sym_associated_type] = STATE(8),
    [sym_associated_impl] = STATE(8),
    [sym_const_item] = STATE(8),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(8),
    [sym_attribute_item] = STATE(8),
    [sym_inner_attribute_item] = STATE(8),
    [sym_mod_item] = STATE(8),
    [sym_struct_item] = STATE(8),
    [sym_enum_item] = STATE(8),
    [sym_type_item] = STATE(8),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(8),
    [sym_function_item] = STATE(8),
    [sym_function_signature_item] = STATE(8),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(8),
    [sym_use_declaration] = STATE(8),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(8),
    [sym_expression] = STATE(857),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(8),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(863),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(197),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(916),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(95),
    [anon_sym_impl] = ACTIONS(100),
    [anon_sym_SEMI] = ACTIONS(103),
    [anon_sym_trait] = ACTIONS(106),
    [anon_sym_type] = ACTIONS(109),
    [anon_sym_const] = ACTIONS(112),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_POUND] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(121),
    [anon_sym_mod] = ACTIONS(124),
    [anon_sym_struct] = ACTIONS(127),
    [anon_sym_enum] = ACTIONS(130),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_let] = ACTIONS(136),
    [anon_sym_use] = ACTIONS(139),
    [anon_sym_COLON_COLON] = ACTIONS(142),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_u8] = ACTIONS(148),
    [anon_sym_i8] = ACTIONS(148),
    [anon_sym_u16] = ACTIONS(148),
    [anon_sym_i16] = ACTIONS(148),
    [anon_sym_u32] = ACTIONS(148),
    [anon_sym_i32] = ACTIONS(148),
    [anon_sym_u64] = ACTIONS(148),
    [anon_sym_i64] = ACTIONS(148),
    [anon_sym_u128] = ACTIONS(148),
    [anon_sym_i128] = ACTIONS(148),
    [anon_sym_usize] = ACTIONS(148),
    [anon_sym_bool] = ACTIONS(148),
    [anon_sym_ByteArray] = ACTIONS(148),
    [anon_sym_felt252] = ACTIONS(148),
    [anon_sym_DASH] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(115),
    [anon_sym_PIPE] = ACTIONS(154),
    [anon_sym_AT] = ACTIONS(115),
    [anon_sym_DOT_DOT] = ACTIONS(157),
    [anon_sym_break] = ACTIONS(160),
    [anon_sym_continue] = ACTIONS(163),
    [anon_sym_default] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_extern] = ACTIONS(172),
    [anon_sym_loop] = ACTIONS(175),
    [anon_sym_match] = ACTIONS(178),
    [anon_sym_pub] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(184),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(190),
    [sym_numeric_literal] = ACTIONS(193),
    [aux_sym_string_literal_token1] = ACTIONS(196),
    [sym_shortstring_literal] = ACTIONS(199),
    [anon_sym_true] = ACTIONS(202),
    [anon_sym_false] = ACTIONS(202),
    [anon_sym_move] = ACTIONS(205),
    [anon_sym_ref] = ACTIONS(208),
    [sym_identifier] = ACTIONS(211),
    [sym_super] = ACTIONS(214),
    [sym_line_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__statement] = STATE(11),
    [sym_impl_item] = STATE(11),
    [sym_trait_item] = STATE(11),
    [sym_associated_type] = STATE(11),
    [sym_associated_impl] = STATE(11),
    [sym_const_item] = STATE(11),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(11),
    [sym_attribute_item] = STATE(11),
    [sym_inner_attribute_item] = STATE(11),
    [sym_mod_item] = STATE(11),
    [sym_struct_item] = STATE(11),
    [sym_enum_item] = STATE(11),
    [sym_type_item] = STATE(11),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(11),
    [sym_function_item] = STATE(11),
    [sym_function_signature_item] = STATE(11),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(11),
    [sym_use_declaration] = STATE(11),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(11),
    [sym_expression] = STATE(871),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(11),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(873),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__statement] = STATE(13),
    [sym_impl_item] = STATE(13),
    [sym_trait_item] = STATE(13),
    [sym_associated_type] = STATE(13),
    [sym_associated_impl] = STATE(13),
    [sym_const_item] = STATE(13),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(13),
    [sym_attribute_item] = STATE(13),
    [sym_inner_attribute_item] = STATE(13),
    [sym_mod_item] = STATE(13),
    [sym_struct_item] = STATE(13),
    [sym_enum_item] = STATE(13),
    [sym_type_item] = STATE(13),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(13),
    [sym_function_item] = STATE(13),
    [sym_function_signature_item] = STATE(13),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(13),
    [sym_use_declaration] = STATE(13),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(13),
    [sym_expression] = STATE(876),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(13),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(225),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(877),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__statement] = STATE(15),
    [sym_impl_item] = STATE(15),
    [sym_trait_item] = STATE(15),
    [sym_associated_type] = STATE(15),
    [sym_associated_impl] = STATE(15),
    [sym_const_item] = STATE(15),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(15),
    [sym_attribute_item] = STATE(15),
    [sym_inner_attribute_item] = STATE(15),
    [sym_mod_item] = STATE(15),
    [sym_struct_item] = STATE(15),
    [sym_enum_item] = STATE(15),
    [sym_type_item] = STATE(15),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(15),
    [sym_function_item] = STATE(15),
    [sym_function_signature_item] = STATE(15),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(15),
    [sym_use_declaration] = STATE(15),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(15),
    [sym_expression] = STATE(878),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(15),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(879),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(231),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__statement] = STATE(17),
    [sym_impl_item] = STATE(17),
    [sym_trait_item] = STATE(17),
    [sym_associated_type] = STATE(17),
    [sym_associated_impl] = STATE(17),
    [sym_const_item] = STATE(17),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(17),
    [sym_attribute_item] = STATE(17),
    [sym_inner_attribute_item] = STATE(17),
    [sym_mod_item] = STATE(17),
    [sym_struct_item] = STATE(17),
    [sym_enum_item] = STATE(17),
    [sym_type_item] = STATE(17),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(17),
    [sym_function_item] = STATE(17),
    [sym_function_signature_item] = STATE(17),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(17),
    [sym_use_declaration] = STATE(17),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(17),
    [sym_expression] = STATE(880),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(17),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(233),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(881),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(235),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__statement] = STATE(19),
    [sym_impl_item] = STATE(19),
    [sym_trait_item] = STATE(19),
    [sym_associated_type] = STATE(19),
    [sym_associated_impl] = STATE(19),
    [sym_const_item] = STATE(19),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(19),
    [sym_attribute_item] = STATE(19),
    [sym_inner_attribute_item] = STATE(19),
    [sym_mod_item] = STATE(19),
    [sym_struct_item] = STATE(19),
    [sym_enum_item] = STATE(19),
    [sym_type_item] = STATE(19),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(19),
    [sym_function_item] = STATE(19),
    [sym_function_signature_item] = STATE(19),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(19),
    [sym_use_declaration] = STATE(19),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(19),
    [sym_expression] = STATE(882),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(19),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(237),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__statement] = STATE(9),
    [sym_impl_item] = STATE(9),
    [sym_trait_item] = STATE(9),
    [sym_associated_type] = STATE(9),
    [sym_associated_impl] = STATE(9),
    [sym_const_item] = STATE(9),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(9),
    [sym_attribute_item] = STATE(9),
    [sym_inner_attribute_item] = STATE(9),
    [sym_mod_item] = STATE(9),
    [sym_struct_item] = STATE(9),
    [sym_enum_item] = STATE(9),
    [sym_type_item] = STATE(9),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(9),
    [sym_function_item] = STATE(9),
    [sym_function_signature_item] = STATE(9),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(9),
    [sym_use_declaration] = STATE(9),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(9),
    [sym_expression] = STATE(883),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__statement] = STATE(3),
    [sym_impl_item] = STATE(3),
    [sym_trait_item] = STATE(3),
    [sym_associated_type] = STATE(3),
    [sym_associated_impl] = STATE(3),
    [sym_const_item] = STATE(3),
    [sym_macro_invocation] = STATE(166),
    [sym_empty_statement] = STATE(3),
    [sym_attribute_item] = STATE(3),
    [sym_inner_attribute_item] = STATE(3),
    [sym_mod_item] = STATE(3),
    [sym_struct_item] = STATE(3),
    [sym_enum_item] = STATE(3),
    [sym_type_item] = STATE(3),
    [sym_extern_type] = STATE(301),
    [sym_external_function_item] = STATE(3),
    [sym_function_item] = STATE(3),
    [sym_function_signature_item] = STATE(3),
    [sym_function] = STATE(1498),
    [sym_let_declaration] = STATE(3),
    [sym_use_declaration] = STATE(3),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression_statement] = STATE(3),
    [sym_expression] = STATE(884),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(165),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(165),
    [sym_if_expression] = STATE(165),
    [sym_match_expression] = STATE(165),
    [sym_while_expression] = STATE(165),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(165),
    [sym_loop_expression] = STATE(165),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [sym_visibility_modifier] = STATE(979),
    [sym_extern] = STATE(1198),
    [aux_sym_source_file_repeat1] = STATE(3),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(241),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_extern] = ACTIONS(57),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_pub] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(553),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_SEMI] = ACTIONS(243),
    [anon_sym_EQ] = ACTIONS(245),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_RBRACK] = ACTIONS(243),
    [anon_sym_COMMA] = ACTIONS(243),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_RPAREN] = ACTIONS(243),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(245),
    [anon_sym_GT] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(245),
    [anon_sym_DASH] = ACTIONS(245),
    [anon_sym_SLASH] = ACTIONS(245),
    [anon_sym_PERCENT] = ACTIONS(245),
    [anon_sym_CARET] = ACTIONS(243),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(245),
    [anon_sym_PIPE] = ACTIONS(245),
    [anon_sym_AMP_AMP] = ACTIONS(243),
    [anon_sym_PIPE_PIPE] = ACTIONS(243),
    [anon_sym_LT_LT] = ACTIONS(243),
    [anon_sym_GT_GT] = ACTIONS(243),
    [anon_sym_PLUS_EQ] = ACTIONS(243),
    [anon_sym_DASH_EQ] = ACTIONS(243),
    [anon_sym_STAR_EQ] = ACTIONS(243),
    [anon_sym_SLASH_EQ] = ACTIONS(243),
    [anon_sym_PERCENT_EQ] = ACTIONS(243),
    [anon_sym_EQ_EQ] = ACTIONS(243),
    [anon_sym_BANG_EQ] = ACTIONS(243),
    [anon_sym_GT_EQ] = ACTIONS(243),
    [anon_sym_LT_EQ] = ACTIONS(243),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(243),
    [anon_sym_DOT] = ACTIONS(245),
    [anon_sym_QMARK] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(555),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(251),
    [anon_sym_COMMA] = ACTIONS(251),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(251),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(253),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_CARET] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(253),
    [anon_sym_PIPE] = ACTIONS(257),
    [anon_sym_AMP_AMP] = ACTIONS(251),
    [anon_sym_PIPE_PIPE] = ACTIONS(251),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(251),
    [anon_sym_PLUS_EQ] = ACTIONS(251),
    [anon_sym_DASH_EQ] = ACTIONS(251),
    [anon_sym_STAR_EQ] = ACTIONS(251),
    [anon_sym_SLASH_EQ] = ACTIONS(251),
    [anon_sym_PERCENT_EQ] = ACTIONS(251),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_BANG_EQ] = ACTIONS(251),
    [anon_sym_GT_EQ] = ACTIONS(251),
    [anon_sym_LT_EQ] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_DOT] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(251),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(552),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_LBRACK] = ACTIONS(261),
    [anon_sym_RBRACK] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(261),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_RPAREN] = ACTIONS(261),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_PERCENT] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(261),
    [anon_sym_LT_LT] = ACTIONS(261),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_PLUS_EQ] = ACTIONS(261),
    [anon_sym_DASH_EQ] = ACTIONS(261),
    [anon_sym_STAR_EQ] = ACTIONS(261),
    [anon_sym_SLASH_EQ] = ACTIONS(261),
    [anon_sym_PERCENT_EQ] = ACTIONS(261),
    [anon_sym_EQ_EQ] = ACTIONS(261),
    [anon_sym_BANG_EQ] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(261),
    [anon_sym_LT_EQ] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(552),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_LBRACK] = ACTIONS(261),
    [anon_sym_RBRACK] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(261),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(261),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_PERCENT] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(261),
    [anon_sym_LT_LT] = ACTIONS(261),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_PLUS_EQ] = ACTIONS(261),
    [anon_sym_DASH_EQ] = ACTIONS(261),
    [anon_sym_STAR_EQ] = ACTIONS(261),
    [anon_sym_SLASH_EQ] = ACTIONS(261),
    [anon_sym_PERCENT_EQ] = ACTIONS(261),
    [anon_sym_EQ_EQ] = ACTIONS(261),
    [anon_sym_BANG_EQ] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(261),
    [anon_sym_LT_EQ] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(542),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(265),
    [anon_sym_DASH_EQ] = ACTIONS(265),
    [anon_sym_STAR_EQ] = ACTIONS(265),
    [anon_sym_SLASH_EQ] = ACTIONS(265),
    [anon_sym_PERCENT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(542),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(247),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(265),
    [anon_sym_DASH_EQ] = ACTIONS(265),
    [anon_sym_STAR_EQ] = ACTIONS(265),
    [anon_sym_SLASH_EQ] = ACTIONS(265),
    [anon_sym_PERCENT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(844),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_BANG] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(261),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_PERCENT] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(261),
    [anon_sym_LT_LT] = ACTIONS(261),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_PLUS_EQ] = ACTIONS(261),
    [anon_sym_DASH_EQ] = ACTIONS(261),
    [anon_sym_STAR_EQ] = ACTIONS(261),
    [anon_sym_SLASH_EQ] = ACTIONS(261),
    [anon_sym_PERCENT_EQ] = ACTIONS(261),
    [anon_sym_EQ_EQ] = ACTIONS(261),
    [anon_sym_BANG_EQ] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(261),
    [anon_sym_LT_EQ] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_EQ_GT] = ACTIONS(261),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(769),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_BANG] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(253),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_CARET] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(253),
    [anon_sym_PIPE] = ACTIONS(257),
    [anon_sym_AMP_AMP] = ACTIONS(251),
    [anon_sym_PIPE_PIPE] = ACTIONS(251),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(251),
    [anon_sym_PLUS_EQ] = ACTIONS(251),
    [anon_sym_DASH_EQ] = ACTIONS(251),
    [anon_sym_STAR_EQ] = ACTIONS(251),
    [anon_sym_SLASH_EQ] = ACTIONS(251),
    [anon_sym_PERCENT_EQ] = ACTIONS(251),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_BANG_EQ] = ACTIONS(251),
    [anon_sym_GT_EQ] = ACTIONS(251),
    [anon_sym_LT_EQ] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(319),
    [anon_sym_DOT] = ACTIONS(253),
    [anon_sym_EQ_GT] = ACTIONS(251),
    [anon_sym_QMARK] = ACTIONS(251),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(767),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(245),
    [anon_sym_BANG] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_LT] = ACTIONS(245),
    [anon_sym_GT] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(245),
    [anon_sym_DASH] = ACTIONS(245),
    [anon_sym_SLASH] = ACTIONS(245),
    [anon_sym_PERCENT] = ACTIONS(245),
    [anon_sym_CARET] = ACTIONS(243),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(245),
    [anon_sym_PIPE] = ACTIONS(245),
    [anon_sym_AMP_AMP] = ACTIONS(243),
    [anon_sym_PIPE_PIPE] = ACTIONS(243),
    [anon_sym_LT_LT] = ACTIONS(243),
    [anon_sym_GT_GT] = ACTIONS(243),
    [anon_sym_PLUS_EQ] = ACTIONS(243),
    [anon_sym_DASH_EQ] = ACTIONS(243),
    [anon_sym_STAR_EQ] = ACTIONS(243),
    [anon_sym_SLASH_EQ] = ACTIONS(243),
    [anon_sym_PERCENT_EQ] = ACTIONS(243),
    [anon_sym_EQ_EQ] = ACTIONS(243),
    [anon_sym_BANG_EQ] = ACTIONS(243),
    [anon_sym_GT_EQ] = ACTIONS(243),
    [anon_sym_LT_EQ] = ACTIONS(243),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(243),
    [anon_sym_DOT] = ACTIONS(245),
    [anon_sym_EQ_GT] = ACTIONS(243),
    [anon_sym_QMARK] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(844),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_BANG] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(261),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_PERCENT] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(261),
    [anon_sym_LT_LT] = ACTIONS(261),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_PLUS_EQ] = ACTIONS(261),
    [anon_sym_DASH_EQ] = ACTIONS(261),
    [anon_sym_STAR_EQ] = ACTIONS(261),
    [anon_sym_SLASH_EQ] = ACTIONS(261),
    [anon_sym_PERCENT_EQ] = ACTIONS(261),
    [anon_sym_EQ_EQ] = ACTIONS(261),
    [anon_sym_BANG_EQ] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(261),
    [anon_sym_LT_EQ] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_EQ_GT] = ACTIONS(261),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(766),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(265),
    [anon_sym_DASH_EQ] = ACTIONS(265),
    [anon_sym_STAR_EQ] = ACTIONS(265),
    [anon_sym_SLASH_EQ] = ACTIONS(265),
    [anon_sym_PERCENT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_EQ_GT] = ACTIONS(265),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(766),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(271),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(265),
    [anon_sym_DASH_EQ] = ACTIONS(265),
    [anon_sym_STAR_EQ] = ACTIONS(265),
    [anon_sym_SLASH_EQ] = ACTIONS(265),
    [anon_sym_PERCENT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_EQ_GT] = ACTIONS(265),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(859),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(265),
    [anon_sym_DASH_EQ] = ACTIONS(265),
    [anon_sym_STAR_EQ] = ACTIONS(265),
    [anon_sym_SLASH_EQ] = ACTIONS(265),
    [anon_sym_PERCENT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(862),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_BANG] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(253),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_CARET] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(253),
    [anon_sym_PIPE] = ACTIONS(257),
    [anon_sym_AMP_AMP] = ACTIONS(251),
    [anon_sym_PIPE_PIPE] = ACTIONS(251),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(251),
    [anon_sym_PLUS_EQ] = ACTIONS(251),
    [anon_sym_DASH_EQ] = ACTIONS(251),
    [anon_sym_STAR_EQ] = ACTIONS(251),
    [anon_sym_SLASH_EQ] = ACTIONS(251),
    [anon_sym_PERCENT_EQ] = ACTIONS(251),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_BANG_EQ] = ACTIONS(251),
    [anon_sym_GT_EQ] = ACTIONS(251),
    [anon_sym_LT_EQ] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(251),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(860),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_EQ] = ACTIONS(245),
    [anon_sym_BANG] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(245),
    [anon_sym_GT] = ACTIONS(245),
    [anon_sym_PLUS] = ACTIONS(245),
    [anon_sym_DASH] = ACTIONS(245),
    [anon_sym_SLASH] = ACTIONS(245),
    [anon_sym_PERCENT] = ACTIONS(245),
    [anon_sym_CARET] = ACTIONS(243),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(245),
    [anon_sym_PIPE] = ACTIONS(245),
    [anon_sym_AMP_AMP] = ACTIONS(243),
    [anon_sym_PIPE_PIPE] = ACTIONS(243),
    [anon_sym_LT_LT] = ACTIONS(243),
    [anon_sym_GT_GT] = ACTIONS(243),
    [anon_sym_PLUS_EQ] = ACTIONS(243),
    [anon_sym_DASH_EQ] = ACTIONS(243),
    [anon_sym_STAR_EQ] = ACTIONS(243),
    [anon_sym_SLASH_EQ] = ACTIONS(243),
    [anon_sym_PERCENT_EQ] = ACTIONS(243),
    [anon_sym_EQ_EQ] = ACTIONS(243),
    [anon_sym_BANG_EQ] = ACTIONS(243),
    [anon_sym_GT_EQ] = ACTIONS(243),
    [anon_sym_LT_EQ] = ACTIONS(243),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(243),
    [anon_sym_DOT] = ACTIONS(245),
    [anon_sym_QMARK] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(859),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(265),
    [anon_sym_EQ] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_PLUS_EQ] = ACTIONS(265),
    [anon_sym_DASH_EQ] = ACTIONS(265),
    [anon_sym_STAR_EQ] = ACTIONS(265),
    [anon_sym_SLASH_EQ] = ACTIONS(265),
    [anon_sym_PERCENT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(265),
    [anon_sym_DOT] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(800),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_BANG] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(261),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_PERCENT] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(261),
    [anon_sym_LT_LT] = ACTIONS(261),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_PLUS_EQ] = ACTIONS(261),
    [anon_sym_DASH_EQ] = ACTIONS(261),
    [anon_sym_STAR_EQ] = ACTIONS(261),
    [anon_sym_SLASH_EQ] = ACTIONS(261),
    [anon_sym_PERCENT_EQ] = ACTIONS(261),
    [anon_sym_EQ_EQ] = ACTIONS(261),
    [anon_sym_BANG_EQ] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(261),
    [anon_sym_LT_EQ] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(800),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(263),
    [anon_sym_BANG] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(261),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_PERCENT] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(261),
    [anon_sym_LT_LT] = ACTIONS(261),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_PLUS_EQ] = ACTIONS(261),
    [anon_sym_DASH_EQ] = ACTIONS(261),
    [anon_sym_STAR_EQ] = ACTIONS(261),
    [anon_sym_SLASH_EQ] = ACTIONS(261),
    [anon_sym_PERCENT_EQ] = ACTIONS(261),
    [anon_sym_EQ_EQ] = ACTIONS(261),
    [anon_sym_BANG_EQ] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(261),
    [anon_sym_LT_EQ] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(347),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_impl] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_trait] = ACTIONS(352),
    [anon_sym_type] = ACTIONS(352),
    [anon_sym_COLON] = ACTIONS(358),
    [anon_sym_const] = ACTIONS(352),
    [anon_sym_EQ] = ACTIONS(358),
    [anon_sym_BANG] = ACTIONS(358),
    [anon_sym_POUND] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(361),
    [anon_sym_RBRACK] = ACTIONS(350),
    [anon_sym_mod] = ACTIONS(352),
    [anon_sym_struct] = ACTIONS(352),
    [anon_sym_enum] = ACTIONS(352),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_fn] = ACTIONS(352),
    [anon_sym_DASH_GT] = ACTIONS(355),
    [anon_sym_let] = ACTIONS(352),
    [anon_sym_use] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(355),
    [anon_sym_STAR] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(364),
    [anon_sym__] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_u8] = ACTIONS(367),
    [anon_sym_i8] = ACTIONS(367),
    [anon_sym_u16] = ACTIONS(367),
    [anon_sym_i16] = ACTIONS(367),
    [anon_sym_u32] = ACTIONS(367),
    [anon_sym_i32] = ACTIONS(367),
    [anon_sym_u64] = ACTIONS(367),
    [anon_sym_i64] = ACTIONS(367),
    [anon_sym_u128] = ACTIONS(367),
    [anon_sym_i128] = ACTIONS(367),
    [anon_sym_usize] = ACTIONS(367),
    [anon_sym_bool] = ACTIONS(367),
    [anon_sym_ByteArray] = ACTIONS(367),
    [anon_sym_felt252] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(358),
    [anon_sym_PLUS] = ACTIONS(358),
    [anon_sym_DASH] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(358),
    [anon_sym_PERCENT] = ACTIONS(358),
    [anon_sym_CARET] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(358),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(355),
    [anon_sym_PLUS_EQ] = ACTIONS(355),
    [anon_sym_DASH_EQ] = ACTIONS(355),
    [anon_sym_STAR_EQ] = ACTIONS(355),
    [anon_sym_SLASH_EQ] = ACTIONS(355),
    [anon_sym_PERCENT_EQ] = ACTIONS(355),
    [anon_sym_CARET_EQ] = ACTIONS(355),
    [anon_sym_AMP_EQ] = ACTIONS(355),
    [anon_sym_PIPE_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_AT] = ACTIONS(355),
    [anon_sym_DOT_DOT] = ACTIONS(355),
    [anon_sym_DOT] = ACTIONS(358),
    [anon_sym_EQ_GT] = ACTIONS(355),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_break] = ACTIONS(352),
    [anon_sym_continue] = ACTIONS(352),
    [anon_sym_default] = ACTIONS(352),
    [anon_sym_if] = ACTIONS(352),
    [anon_sym_extern] = ACTIONS(352),
    [anon_sym_nopanic] = ACTIONS(352),
    [anon_sym_loop] = ACTIONS(352),
    [anon_sym_match] = ACTIONS(352),
    [anon_sym_pub] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(352),
    [anon_sym_static] = ACTIONS(352),
    [anon_sym_while] = ACTIONS(352),
    [anon_sym_for] = ACTIONS(352),
    [sym_numeric_literal] = ACTIONS(373),
    [aux_sym_string_literal_token1] = ACTIONS(376),
    [sym_shortstring_literal] = ACTIONS(379),
    [anon_sym_true] = ACTIONS(382),
    [anon_sym_false] = ACTIONS(382),
    [anon_sym_DOLLAR] = ACTIONS(385),
    [sym_identifier] = ACTIONS(352),
    [sym_mutable_specifier] = ACTIONS(352),
    [sym_super] = ACTIONS(352),
    [sym_line_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_delim_token_tree] = STATE(41),
    [sym__delim_tokens] = STATE(41),
    [sym__literal] = STATE(41),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(41),
    [aux_sym_delim_token_tree_repeat1] = STATE(41),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(390),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(390),
    [anon_sym_type] = ACTIONS(390),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(390),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(390),
    [anon_sym_struct] = ACTIONS(390),
    [anon_sym_enum] = ACTIONS(390),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(390),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(390),
    [anon_sym_use] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(400),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(390),
    [anon_sym_continue] = ACTIONS(390),
    [anon_sym_default] = ACTIONS(390),
    [anon_sym_if] = ACTIONS(390),
    [anon_sym_extern] = ACTIONS(390),
    [anon_sym_nopanic] = ACTIONS(390),
    [anon_sym_loop] = ACTIONS(390),
    [anon_sym_match] = ACTIONS(390),
    [anon_sym_pub] = ACTIONS(390),
    [anon_sym_return] = ACTIONS(390),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(390),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(414),
    [sym_identifier] = ACTIONS(390),
    [sym_mutable_specifier] = ACTIONS(390),
    [sym_super] = ACTIONS(390),
    [sym_line_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(418),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(422),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(422),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(422),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_delim_token_tree] = STATE(48),
    [sym__delim_tokens] = STATE(48),
    [sym__literal] = STATE(48),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(48),
    [aux_sym_delim_token_tree_repeat1] = STATE(48),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(424),
    [anon_sym_impl] = ACTIONS(426),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(426),
    [anon_sym_type] = ACTIONS(426),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(426),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(426),
    [anon_sym_struct] = ACTIONS(426),
    [anon_sym_enum] = ACTIONS(426),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(426),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(426),
    [anon_sym_use] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(426),
    [anon_sym_continue] = ACTIONS(426),
    [anon_sym_default] = ACTIONS(426),
    [anon_sym_if] = ACTIONS(426),
    [anon_sym_extern] = ACTIONS(426),
    [anon_sym_nopanic] = ACTIONS(426),
    [anon_sym_loop] = ACTIONS(426),
    [anon_sym_match] = ACTIONS(426),
    [anon_sym_pub] = ACTIONS(426),
    [anon_sym_return] = ACTIONS(426),
    [anon_sym_static] = ACTIONS(426),
    [anon_sym_while] = ACTIONS(426),
    [anon_sym_for] = ACTIONS(426),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(428),
    [sym_identifier] = ACTIONS(426),
    [sym_mutable_specifier] = ACTIONS(426),
    [sym_super] = ACTIONS(426),
    [sym_line_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_delim_token_tree] = STATE(49),
    [sym__delim_tokens] = STATE(49),
    [sym__literal] = STATE(49),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(49),
    [aux_sym_delim_token_tree_repeat1] = STATE(49),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(430),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(430),
    [anon_sym_type] = ACTIONS(430),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(430),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(424),
    [anon_sym_mod] = ACTIONS(430),
    [anon_sym_struct] = ACTIONS(430),
    [anon_sym_enum] = ACTIONS(430),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(430),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_use] = ACTIONS(430),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(430),
    [anon_sym_continue] = ACTIONS(430),
    [anon_sym_default] = ACTIONS(430),
    [anon_sym_if] = ACTIONS(430),
    [anon_sym_extern] = ACTIONS(430),
    [anon_sym_nopanic] = ACTIONS(430),
    [anon_sym_loop] = ACTIONS(430),
    [anon_sym_match] = ACTIONS(430),
    [anon_sym_pub] = ACTIONS(430),
    [anon_sym_return] = ACTIONS(430),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_while] = ACTIONS(430),
    [anon_sym_for] = ACTIONS(430),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(432),
    [sym_identifier] = ACTIONS(430),
    [sym_mutable_specifier] = ACTIONS(430),
    [sym_super] = ACTIONS(430),
    [sym_line_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_delim_token_tree] = STATE(50),
    [sym__delim_tokens] = STATE(50),
    [sym__literal] = STATE(50),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(50),
    [aux_sym_delim_token_tree_repeat1] = STATE(50),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(434),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(434),
    [anon_sym_type] = ACTIONS(434),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(434),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(434),
    [anon_sym_struct] = ACTIONS(434),
    [anon_sym_enum] = ACTIONS(434),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(434),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(434),
    [anon_sym_use] = ACTIONS(434),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(424),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(434),
    [anon_sym_continue] = ACTIONS(434),
    [anon_sym_default] = ACTIONS(434),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_extern] = ACTIONS(434),
    [anon_sym_nopanic] = ACTIONS(434),
    [anon_sym_loop] = ACTIONS(434),
    [anon_sym_match] = ACTIONS(434),
    [anon_sym_pub] = ACTIONS(434),
    [anon_sym_return] = ACTIONS(434),
    [anon_sym_static] = ACTIONS(434),
    [anon_sym_while] = ACTIONS(434),
    [anon_sym_for] = ACTIONS(434),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(436),
    [sym_identifier] = ACTIONS(434),
    [sym_mutable_specifier] = ACTIONS(434),
    [sym_super] = ACTIONS(434),
    [sym_line_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(438),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(438),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(438),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_delim_token_tree] = STATE(43),
    [sym__delim_tokens] = STATE(43),
    [sym__literal] = STATE(43),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(43),
    [aux_sym_delim_token_tree_repeat1] = STATE(43),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(440),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(440),
    [anon_sym_type] = ACTIONS(440),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(440),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(442),
    [anon_sym_mod] = ACTIONS(440),
    [anon_sym_struct] = ACTIONS(440),
    [anon_sym_enum] = ACTIONS(440),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(440),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(440),
    [anon_sym_use] = ACTIONS(440),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(440),
    [anon_sym_continue] = ACTIONS(440),
    [anon_sym_default] = ACTIONS(440),
    [anon_sym_if] = ACTIONS(440),
    [anon_sym_extern] = ACTIONS(440),
    [anon_sym_nopanic] = ACTIONS(440),
    [anon_sym_loop] = ACTIONS(440),
    [anon_sym_match] = ACTIONS(440),
    [anon_sym_pub] = ACTIONS(440),
    [anon_sym_return] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(440),
    [anon_sym_for] = ACTIONS(440),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(444),
    [sym_identifier] = ACTIONS(440),
    [sym_mutable_specifier] = ACTIONS(440),
    [sym_super] = ACTIONS(440),
    [sym_line_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_delim_token_tree] = STATE(44),
    [sym__delim_tokens] = STATE(44),
    [sym__literal] = STATE(44),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(44),
    [aux_sym_delim_token_tree_repeat1] = STATE(44),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(446),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(446),
    [anon_sym_type] = ACTIONS(446),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(446),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(446),
    [anon_sym_struct] = ACTIONS(446),
    [anon_sym_enum] = ACTIONS(446),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(446),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(446),
    [anon_sym_use] = ACTIONS(446),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(442),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(446),
    [anon_sym_continue] = ACTIONS(446),
    [anon_sym_default] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(446),
    [anon_sym_extern] = ACTIONS(446),
    [anon_sym_nopanic] = ACTIONS(446),
    [anon_sym_loop] = ACTIONS(446),
    [anon_sym_match] = ACTIONS(446),
    [anon_sym_pub] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(446),
    [anon_sym_static] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(446),
    [anon_sym_for] = ACTIONS(446),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(448),
    [sym_identifier] = ACTIONS(446),
    [sym_mutable_specifier] = ACTIONS(446),
    [sym_super] = ACTIONS(446),
    [sym_line_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_delim_token_tree] = STATE(56),
    [sym__delim_tokens] = STATE(56),
    [sym__literal] = STATE(56),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(56),
    [aux_sym_delim_token_tree_repeat1] = STATE(56),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(450),
    [anon_sym_impl] = ACTIONS(452),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(452),
    [anon_sym_type] = ACTIONS(452),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(452),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(452),
    [anon_sym_struct] = ACTIONS(452),
    [anon_sym_enum] = ACTIONS(452),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(452),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(452),
    [anon_sym_use] = ACTIONS(452),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(452),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_default] = ACTIONS(452),
    [anon_sym_if] = ACTIONS(452),
    [anon_sym_extern] = ACTIONS(452),
    [anon_sym_nopanic] = ACTIONS(452),
    [anon_sym_loop] = ACTIONS(452),
    [anon_sym_match] = ACTIONS(452),
    [anon_sym_pub] = ACTIONS(452),
    [anon_sym_return] = ACTIONS(452),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_for] = ACTIONS(452),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(454),
    [sym_identifier] = ACTIONS(452),
    [sym_mutable_specifier] = ACTIONS(452),
    [sym_super] = ACTIONS(452),
    [sym_line_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_delim_token_tree] = STATE(57),
    [sym__delim_tokens] = STATE(57),
    [sym__literal] = STATE(57),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(57),
    [aux_sym_delim_token_tree_repeat1] = STATE(57),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(456),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(456),
    [anon_sym_type] = ACTIONS(456),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(456),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(450),
    [anon_sym_mod] = ACTIONS(456),
    [anon_sym_struct] = ACTIONS(456),
    [anon_sym_enum] = ACTIONS(456),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(456),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_use] = ACTIONS(456),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(456),
    [anon_sym_continue] = ACTIONS(456),
    [anon_sym_default] = ACTIONS(456),
    [anon_sym_if] = ACTIONS(456),
    [anon_sym_extern] = ACTIONS(456),
    [anon_sym_nopanic] = ACTIONS(456),
    [anon_sym_loop] = ACTIONS(456),
    [anon_sym_match] = ACTIONS(456),
    [anon_sym_pub] = ACTIONS(456),
    [anon_sym_return] = ACTIONS(456),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_while] = ACTIONS(456),
    [anon_sym_for] = ACTIONS(456),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(458),
    [sym_identifier] = ACTIONS(456),
    [sym_mutable_specifier] = ACTIONS(456),
    [sym_super] = ACTIONS(456),
    [sym_line_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_delim_token_tree] = STATE(58),
    [sym__delim_tokens] = STATE(58),
    [sym__literal] = STATE(58),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(58),
    [aux_sym_delim_token_tree_repeat1] = STATE(58),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(460),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(460),
    [anon_sym_type] = ACTIONS(460),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(460),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(460),
    [anon_sym_struct] = ACTIONS(460),
    [anon_sym_enum] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(460),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(460),
    [anon_sym_use] = ACTIONS(460),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(450),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(460),
    [anon_sym_continue] = ACTIONS(460),
    [anon_sym_default] = ACTIONS(460),
    [anon_sym_if] = ACTIONS(460),
    [anon_sym_extern] = ACTIONS(460),
    [anon_sym_nopanic] = ACTIONS(460),
    [anon_sym_loop] = ACTIONS(460),
    [anon_sym_match] = ACTIONS(460),
    [anon_sym_pub] = ACTIONS(460),
    [anon_sym_return] = ACTIONS(460),
    [anon_sym_static] = ACTIONS(460),
    [anon_sym_while] = ACTIONS(460),
    [anon_sym_for] = ACTIONS(460),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(462),
    [sym_identifier] = ACTIONS(460),
    [sym_mutable_specifier] = ACTIONS(460),
    [sym_super] = ACTIONS(460),
    [sym_line_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(464),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(464),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_delim_token_tree] = STATE(62),
    [sym__delim_tokens] = STATE(62),
    [sym__literal] = STATE(62),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(62),
    [aux_sym_delim_token_tree_repeat1] = STATE(62),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(466),
    [anon_sym_impl] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(468),
    [anon_sym_type] = ACTIONS(468),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(468),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(468),
    [anon_sym_struct] = ACTIONS(468),
    [anon_sym_enum] = ACTIONS(468),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(468),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(468),
    [anon_sym_use] = ACTIONS(468),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(468),
    [anon_sym_continue] = ACTIONS(468),
    [anon_sym_default] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(468),
    [anon_sym_extern] = ACTIONS(468),
    [anon_sym_nopanic] = ACTIONS(468),
    [anon_sym_loop] = ACTIONS(468),
    [anon_sym_match] = ACTIONS(468),
    [anon_sym_pub] = ACTIONS(468),
    [anon_sym_return] = ACTIONS(468),
    [anon_sym_static] = ACTIONS(468),
    [anon_sym_while] = ACTIONS(468),
    [anon_sym_for] = ACTIONS(468),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(470),
    [sym_identifier] = ACTIONS(468),
    [sym_mutable_specifier] = ACTIONS(468),
    [sym_super] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_delim_token_tree] = STATE(63),
    [sym__delim_tokens] = STATE(63),
    [sym__literal] = STATE(63),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(63),
    [aux_sym_delim_token_tree_repeat1] = STATE(63),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(472),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(472),
    [anon_sym_type] = ACTIONS(472),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(472),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(466),
    [anon_sym_mod] = ACTIONS(472),
    [anon_sym_struct] = ACTIONS(472),
    [anon_sym_enum] = ACTIONS(472),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(472),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(472),
    [anon_sym_use] = ACTIONS(472),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(472),
    [anon_sym_continue] = ACTIONS(472),
    [anon_sym_default] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(472),
    [anon_sym_extern] = ACTIONS(472),
    [anon_sym_nopanic] = ACTIONS(472),
    [anon_sym_loop] = ACTIONS(472),
    [anon_sym_match] = ACTIONS(472),
    [anon_sym_pub] = ACTIONS(472),
    [anon_sym_return] = ACTIONS(472),
    [anon_sym_static] = ACTIONS(472),
    [anon_sym_while] = ACTIONS(472),
    [anon_sym_for] = ACTIONS(472),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(474),
    [sym_identifier] = ACTIONS(472),
    [sym_mutable_specifier] = ACTIONS(472),
    [sym_super] = ACTIONS(472),
    [sym_line_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_delim_token_tree] = STATE(64),
    [sym__delim_tokens] = STATE(64),
    [sym__literal] = STATE(64),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(64),
    [aux_sym_delim_token_tree_repeat1] = STATE(64),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(476),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(476),
    [anon_sym_type] = ACTIONS(476),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(476),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(476),
    [anon_sym_struct] = ACTIONS(476),
    [anon_sym_enum] = ACTIONS(476),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(476),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(476),
    [anon_sym_use] = ACTIONS(476),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(466),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(476),
    [anon_sym_continue] = ACTIONS(476),
    [anon_sym_default] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_extern] = ACTIONS(476),
    [anon_sym_nopanic] = ACTIONS(476),
    [anon_sym_loop] = ACTIONS(476),
    [anon_sym_match] = ACTIONS(476),
    [anon_sym_pub] = ACTIONS(476),
    [anon_sym_return] = ACTIONS(476),
    [anon_sym_static] = ACTIONS(476),
    [anon_sym_while] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(476),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(478),
    [sym_identifier] = ACTIONS(476),
    [sym_mutable_specifier] = ACTIONS(476),
    [sym_super] = ACTIONS(476),
    [sym_line_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(480),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(480),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(480),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_delim_token_tree] = STATE(68),
    [sym__delim_tokens] = STATE(68),
    [sym__literal] = STATE(68),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(68),
    [aux_sym_delim_token_tree_repeat1] = STATE(68),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(482),
    [anon_sym_impl] = ACTIONS(484),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(484),
    [anon_sym_type] = ACTIONS(484),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(484),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(484),
    [anon_sym_struct] = ACTIONS(484),
    [anon_sym_enum] = ACTIONS(484),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(484),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(484),
    [anon_sym_use] = ACTIONS(484),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(484),
    [anon_sym_continue] = ACTIONS(484),
    [anon_sym_default] = ACTIONS(484),
    [anon_sym_if] = ACTIONS(484),
    [anon_sym_extern] = ACTIONS(484),
    [anon_sym_nopanic] = ACTIONS(484),
    [anon_sym_loop] = ACTIONS(484),
    [anon_sym_match] = ACTIONS(484),
    [anon_sym_pub] = ACTIONS(484),
    [anon_sym_return] = ACTIONS(484),
    [anon_sym_static] = ACTIONS(484),
    [anon_sym_while] = ACTIONS(484),
    [anon_sym_for] = ACTIONS(484),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(486),
    [sym_identifier] = ACTIONS(484),
    [sym_mutable_specifier] = ACTIONS(484),
    [sym_super] = ACTIONS(484),
    [sym_line_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_delim_token_tree] = STATE(69),
    [sym__delim_tokens] = STATE(69),
    [sym__literal] = STATE(69),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(69),
    [aux_sym_delim_token_tree_repeat1] = STATE(69),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(488),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(488),
    [anon_sym_type] = ACTIONS(488),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(488),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(482),
    [anon_sym_mod] = ACTIONS(488),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_enum] = ACTIONS(488),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(488),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(488),
    [anon_sym_use] = ACTIONS(488),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(488),
    [anon_sym_continue] = ACTIONS(488),
    [anon_sym_default] = ACTIONS(488),
    [anon_sym_if] = ACTIONS(488),
    [anon_sym_extern] = ACTIONS(488),
    [anon_sym_nopanic] = ACTIONS(488),
    [anon_sym_loop] = ACTIONS(488),
    [anon_sym_match] = ACTIONS(488),
    [anon_sym_pub] = ACTIONS(488),
    [anon_sym_return] = ACTIONS(488),
    [anon_sym_static] = ACTIONS(488),
    [anon_sym_while] = ACTIONS(488),
    [anon_sym_for] = ACTIONS(488),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(490),
    [sym_identifier] = ACTIONS(488),
    [sym_mutable_specifier] = ACTIONS(488),
    [sym_super] = ACTIONS(488),
    [sym_line_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_delim_token_tree] = STATE(70),
    [sym__delim_tokens] = STATE(70),
    [sym__literal] = STATE(70),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(70),
    [aux_sym_delim_token_tree_repeat1] = STATE(70),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(492),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(492),
    [anon_sym_type] = ACTIONS(492),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(492),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(492),
    [anon_sym_struct] = ACTIONS(492),
    [anon_sym_enum] = ACTIONS(492),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(492),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(492),
    [anon_sym_use] = ACTIONS(492),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(482),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(492),
    [anon_sym_continue] = ACTIONS(492),
    [anon_sym_default] = ACTIONS(492),
    [anon_sym_if] = ACTIONS(492),
    [anon_sym_extern] = ACTIONS(492),
    [anon_sym_nopanic] = ACTIONS(492),
    [anon_sym_loop] = ACTIONS(492),
    [anon_sym_match] = ACTIONS(492),
    [anon_sym_pub] = ACTIONS(492),
    [anon_sym_return] = ACTIONS(492),
    [anon_sym_static] = ACTIONS(492),
    [anon_sym_while] = ACTIONS(492),
    [anon_sym_for] = ACTIONS(492),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(494),
    [sym_identifier] = ACTIONS(492),
    [sym_mutable_specifier] = ACTIONS(492),
    [sym_super] = ACTIONS(492),
    [sym_line_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(496),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(496),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(496),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_delim_token_tree] = STATE(73),
    [sym__delim_tokens] = STATE(73),
    [sym__literal] = STATE(73),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(73),
    [aux_sym_delim_token_tree_repeat1] = STATE(73),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(400),
    [anon_sym_impl] = ACTIONS(498),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(498),
    [anon_sym_type] = ACTIONS(498),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(498),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(498),
    [anon_sym_struct] = ACTIONS(498),
    [anon_sym_enum] = ACTIONS(498),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(498),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(498),
    [anon_sym_use] = ACTIONS(498),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(498),
    [anon_sym_continue] = ACTIONS(498),
    [anon_sym_default] = ACTIONS(498),
    [anon_sym_if] = ACTIONS(498),
    [anon_sym_extern] = ACTIONS(498),
    [anon_sym_nopanic] = ACTIONS(498),
    [anon_sym_loop] = ACTIONS(498),
    [anon_sym_match] = ACTIONS(498),
    [anon_sym_pub] = ACTIONS(498),
    [anon_sym_return] = ACTIONS(498),
    [anon_sym_static] = ACTIONS(498),
    [anon_sym_while] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(498),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(500),
    [sym_identifier] = ACTIONS(498),
    [sym_mutable_specifier] = ACTIONS(498),
    [sym_super] = ACTIONS(498),
    [sym_line_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_delim_token_tree] = STATE(74),
    [sym__delim_tokens] = STATE(74),
    [sym__literal] = STATE(74),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(74),
    [aux_sym_delim_token_tree_repeat1] = STATE(74),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(502),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(502),
    [anon_sym_type] = ACTIONS(502),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(502),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(400),
    [anon_sym_mod] = ACTIONS(502),
    [anon_sym_struct] = ACTIONS(502),
    [anon_sym_enum] = ACTIONS(502),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(502),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(502),
    [anon_sym_use] = ACTIONS(502),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(502),
    [anon_sym_continue] = ACTIONS(502),
    [anon_sym_default] = ACTIONS(502),
    [anon_sym_if] = ACTIONS(502),
    [anon_sym_extern] = ACTIONS(502),
    [anon_sym_nopanic] = ACTIONS(502),
    [anon_sym_loop] = ACTIONS(502),
    [anon_sym_match] = ACTIONS(502),
    [anon_sym_pub] = ACTIONS(502),
    [anon_sym_return] = ACTIONS(502),
    [anon_sym_static] = ACTIONS(502),
    [anon_sym_while] = ACTIONS(502),
    [anon_sym_for] = ACTIONS(502),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(504),
    [sym_identifier] = ACTIONS(502),
    [sym_mutable_specifier] = ACTIONS(502),
    [sym_super] = ACTIONS(502),
    [sym_line_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(418),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_delim_token_tree] = STATE(39),
    [sym__delim_tokens] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(39),
    [aux_sym_delim_token_tree_repeat1] = STATE(39),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_impl] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(416),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(416),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_RBRACK] = ACTIONS(418),
    [anon_sym_mod] = ACTIONS(416),
    [anon_sym_struct] = ACTIONS(416),
    [anon_sym_enum] = ACTIONS(416),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(416),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(416),
    [anon_sym_use] = ACTIONS(416),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_extern] = ACTIONS(416),
    [anon_sym_nopanic] = ACTIONS(416),
    [anon_sym_loop] = ACTIONS(416),
    [anon_sym_match] = ACTIONS(416),
    [anon_sym_pub] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_static] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_for] = ACTIONS(416),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(420),
    [sym_identifier] = ACTIONS(416),
    [sym_mutable_specifier] = ACTIONS(416),
    [sym_super] = ACTIONS(416),
    [sym_line_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_delim_token_tree] = STATE(42),
    [sym__delim_tokens] = STATE(42),
    [sym__literal] = STATE(42),
    [sym_negative_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_boolean_literal] = STATE(78),
    [sym__non_delim_token] = STATE(42),
    [aux_sym_delim_token_tree_repeat1] = STATE(42),
    [aux_sym__non_special_token_repeat1] = STATE(76),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(442),
    [anon_sym_impl] = ACTIONS(506),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_trait] = ACTIONS(506),
    [anon_sym_type] = ACTIONS(506),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(506),
    [anon_sym_EQ] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_POUND] = ACTIONS(392),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_mod] = ACTIONS(506),
    [anon_sym_struct] = ACTIONS(506),
    [anon_sym_enum] = ACTIONS(506),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_fn] = ACTIONS(506),
    [anon_sym_DASH_GT] = ACTIONS(392),
    [anon_sym_let] = ACTIONS(506),
    [anon_sym_use] = ACTIONS(506),
    [anon_sym_COLON_COLON] = ACTIONS(392),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym__] = ACTIONS(394),
    [anon_sym_u8] = ACTIONS(402),
    [anon_sym_i8] = ACTIONS(402),
    [anon_sym_u16] = ACTIONS(402),
    [anon_sym_i16] = ACTIONS(402),
    [anon_sym_u32] = ACTIONS(402),
    [anon_sym_i32] = ACTIONS(402),
    [anon_sym_u64] = ACTIONS(402),
    [anon_sym_i64] = ACTIONS(402),
    [anon_sym_u128] = ACTIONS(402),
    [anon_sym_i128] = ACTIONS(402),
    [anon_sym_usize] = ACTIONS(402),
    [anon_sym_bool] = ACTIONS(402),
    [anon_sym_ByteArray] = ACTIONS(402),
    [anon_sym_felt252] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(392),
    [anon_sym_PLUS_EQ] = ACTIONS(392),
    [anon_sym_DASH_EQ] = ACTIONS(392),
    [anon_sym_STAR_EQ] = ACTIONS(392),
    [anon_sym_SLASH_EQ] = ACTIONS(392),
    [anon_sym_PERCENT_EQ] = ACTIONS(392),
    [anon_sym_CARET_EQ] = ACTIONS(392),
    [anon_sym_AMP_EQ] = ACTIONS(392),
    [anon_sym_PIPE_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_DOT_DOT] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_EQ_GT] = ACTIONS(392),
    [anon_sym_QMARK] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(506),
    [anon_sym_continue] = ACTIONS(506),
    [anon_sym_default] = ACTIONS(506),
    [anon_sym_if] = ACTIONS(506),
    [anon_sym_extern] = ACTIONS(506),
    [anon_sym_nopanic] = ACTIONS(506),
    [anon_sym_loop] = ACTIONS(506),
    [anon_sym_match] = ACTIONS(506),
    [anon_sym_pub] = ACTIONS(506),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_static] = ACTIONS(506),
    [anon_sym_while] = ACTIONS(506),
    [anon_sym_for] = ACTIONS(506),
    [sym_numeric_literal] = ACTIONS(406),
    [aux_sym_string_literal_token1] = ACTIONS(408),
    [sym_shortstring_literal] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [anon_sym_DOLLAR] = ACTIONS(508),
    [sym_identifier] = ACTIONS(506),
    [sym_mutable_specifier] = ACTIONS(506),
    [sym_super] = ACTIONS(506),
    [sym_line_comment] = ACTIONS(3),
  },
  [76] = {
    [aux_sym__non_special_token_repeat1] = STATE(77),
    [anon_sym_LBRACE] = ACTIONS(510),
    [anon_sym_RBRACE] = ACTIONS(510),
    [anon_sym_impl] = ACTIONS(512),
    [anon_sym_SEMI] = ACTIONS(514),
    [anon_sym_trait] = ACTIONS(512),
    [anon_sym_type] = ACTIONS(512),
    [anon_sym_COLON] = ACTIONS(516),
    [anon_sym_const] = ACTIONS(512),
    [anon_sym_EQ] = ACTIONS(516),
    [anon_sym_BANG] = ACTIONS(516),
    [anon_sym_POUND] = ACTIONS(514),
    [anon_sym_LBRACK] = ACTIONS(510),
    [anon_sym_RBRACK] = ACTIONS(510),
    [anon_sym_mod] = ACTIONS(512),
    [anon_sym_struct] = ACTIONS(512),
    [anon_sym_enum] = ACTIONS(512),
    [anon_sym_COMMA] = ACTIONS(514),
    [anon_sym_fn] = ACTIONS(512),
    [anon_sym_DASH_GT] = ACTIONS(514),
    [anon_sym_let] = ACTIONS(512),
    [anon_sym_use] = ACTIONS(512),
    [anon_sym_COLON_COLON] = ACTIONS(514),
    [anon_sym_STAR] = ACTIONS(516),
    [anon_sym_LPAREN] = ACTIONS(510),
    [anon_sym__] = ACTIONS(516),
    [anon_sym_RPAREN] = ACTIONS(510),
    [anon_sym_u8] = ACTIONS(512),
    [anon_sym_i8] = ACTIONS(512),
    [anon_sym_u16] = ACTIONS(512),
    [anon_sym_i16] = ACTIONS(512),
    [anon_sym_u32] = ACTIONS(512),
    [anon_sym_i32] = ACTIONS(512),
    [anon_sym_u64] = ACTIONS(512),
    [anon_sym_i64] = ACTIONS(512),
    [anon_sym_u128] = ACTIONS(512),
    [anon_sym_i128] = ACTIONS(512),
    [anon_sym_usize] = ACTIONS(512),
    [anon_sym_bool] = ACTIONS(512),
    [anon_sym_ByteArray] = ACTIONS(512),
    [anon_sym_felt252] = ACTIONS(512),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_GT] = ACTIONS(516),
    [anon_sym_PLUS] = ACTIONS(516),
    [anon_sym_DASH] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(516),
    [anon_sym_PERCENT] = ACTIONS(516),
    [anon_sym_CARET] = ACTIONS(516),
    [anon_sym_TILDE] = ACTIONS(514),
    [anon_sym_AMP] = ACTIONS(516),
    [anon_sym_PIPE] = ACTIONS(516),
    [anon_sym_AMP_AMP] = ACTIONS(514),
    [anon_sym_PIPE_PIPE] = ACTIONS(514),
    [anon_sym_LT_LT] = ACTIONS(514),
    [anon_sym_GT_GT] = ACTIONS(514),
    [anon_sym_PLUS_EQ] = ACTIONS(514),
    [anon_sym_DASH_EQ] = ACTIONS(514),
    [anon_sym_STAR_EQ] = ACTIONS(514),
    [anon_sym_SLASH_EQ] = ACTIONS(514),
    [anon_sym_PERCENT_EQ] = ACTIONS(514),
    [anon_sym_CARET_EQ] = ACTIONS(514),
    [anon_sym_AMP_EQ] = ACTIONS(514),
    [anon_sym_PIPE_EQ] = ACTIONS(514),
    [anon_sym_EQ_EQ] = ACTIONS(514),
    [anon_sym_BANG_EQ] = ACTIONS(514),
    [anon_sym_GT_EQ] = ACTIONS(514),
    [anon_sym_LT_EQ] = ACTIONS(514),
    [anon_sym_AT] = ACTIONS(514),
    [anon_sym_DOT_DOT] = ACTIONS(514),
    [anon_sym_DOT] = ACTIONS(516),
    [anon_sym_EQ_GT] = ACTIONS(514),
    [anon_sym_QMARK] = ACTIONS(514),
    [anon_sym_break] = ACTIONS(512),
    [anon_sym_continue] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(512),
    [anon_sym_extern] = ACTIONS(512),
    [anon_sym_nopanic] = ACTIONS(512),
    [anon_sym_loop] = ACTIONS(512),
    [anon_sym_match] = ACTIONS(512),
    [anon_sym_pub] = ACTIONS(512),
    [anon_sym_return] = ACTIONS(512),
    [anon_sym_static] = ACTIONS(512),
    [anon_sym_while] = ACTIONS(512),
    [anon_sym_for] = ACTIONS(512),
    [sym_numeric_literal] = ACTIONS(512),
    [aux_sym_string_literal_token1] = ACTIONS(510),
    [sym_shortstring_literal] = ACTIONS(510),
    [anon_sym_true] = ACTIONS(512),
    [anon_sym_false] = ACTIONS(512),
    [anon_sym_DOLLAR] = ACTIONS(510),
    [sym_identifier] = ACTIONS(512),
    [sym_mutable_specifier] = ACTIONS(512),
    [sym_super] = ACTIONS(512),
    [sym_line_comment] = ACTIONS(3),
  },
  [77] = {
    [aux_sym__non_special_token_repeat1] = STATE(77),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(518),
    [anon_sym_impl] = ACTIONS(520),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_trait] = ACTIONS(520),
    [anon_sym_type] = ACTIONS(520),
    [anon_sym_COLON] = ACTIONS(525),
    [anon_sym_const] = ACTIONS(520),
    [anon_sym_EQ] = ACTIONS(525),
    [anon_sym_BANG] = ACTIONS(525),
    [anon_sym_POUND] = ACTIONS(522),
    [anon_sym_LBRACK] = ACTIONS(518),
    [anon_sym_RBRACK] = ACTIONS(518),
    [anon_sym_mod] = ACTIONS(520),
    [anon_sym_struct] = ACTIONS(520),
    [anon_sym_enum] = ACTIONS(520),
    [anon_sym_COMMA] = ACTIONS(522),
    [anon_sym_fn] = ACTIONS(520),
    [anon_sym_DASH_GT] = ACTIONS(522),
    [anon_sym_let] = ACTIONS(520),
    [anon_sym_use] = ACTIONS(520),
    [anon_sym_COLON_COLON] = ACTIONS(522),
    [anon_sym_STAR] = ACTIONS(525),
    [anon_sym_LPAREN] = ACTIONS(518),
    [anon_sym__] = ACTIONS(525),
    [anon_sym_RPAREN] = ACTIONS(518),
    [anon_sym_u8] = ACTIONS(520),
    [anon_sym_i8] = ACTIONS(520),
    [anon_sym_u16] = ACTIONS(520),
    [anon_sym_i16] = ACTIONS(520),
    [anon_sym_u32] = ACTIONS(520),
    [anon_sym_i32] = ACTIONS(520),
    [anon_sym_u64] = ACTIONS(520),
    [anon_sym_i64] = ACTIONS(520),
    [anon_sym_u128] = ACTIONS(520),
    [anon_sym_i128] = ACTIONS(520),
    [anon_sym_usize] = ACTIONS(520),
    [anon_sym_bool] = ACTIONS(520),
    [anon_sym_ByteArray] = ACTIONS(520),
    [anon_sym_felt252] = ACTIONS(520),
    [anon_sym_LT] = ACTIONS(525),
    [anon_sym_GT] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(525),
    [anon_sym_DASH] = ACTIONS(525),
    [anon_sym_SLASH] = ACTIONS(525),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym_TILDE] = ACTIONS(522),
    [anon_sym_AMP] = ACTIONS(525),
    [anon_sym_PIPE] = ACTIONS(525),
    [anon_sym_AMP_AMP] = ACTIONS(522),
    [anon_sym_PIPE_PIPE] = ACTIONS(522),
    [anon_sym_LT_LT] = ACTIONS(522),
    [anon_sym_GT_GT] = ACTIONS(522),
    [anon_sym_PLUS_EQ] = ACTIONS(522),
    [anon_sym_DASH_EQ] = ACTIONS(522),
    [anon_sym_STAR_EQ] = ACTIONS(522),
    [anon_sym_SLASH_EQ] = ACTIONS(522),
    [anon_sym_PERCENT_EQ] = ACTIONS(522),
    [anon_sym_CARET_EQ] = ACTIONS(522),
    [anon_sym_AMP_EQ] = ACTIONS(522),
    [anon_sym_PIPE_EQ] = ACTIONS(522),
    [anon_sym_EQ_EQ] = ACTIONS(522),
    [anon_sym_BANG_EQ] = ACTIONS(522),
    [anon_sym_GT_EQ] = ACTIONS(522),
    [anon_sym_LT_EQ] = ACTIONS(522),
    [anon_sym_AT] = ACTIONS(522),
    [anon_sym_DOT_DOT] = ACTIONS(522),
    [anon_sym_DOT] = ACTIONS(525),
    [anon_sym_EQ_GT] = ACTIONS(522),
    [anon_sym_QMARK] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(520),
    [anon_sym_continue] = ACTIONS(520),
    [anon_sym_default] = ACTIONS(520),
    [anon_sym_if] = ACTIONS(520),
    [anon_sym_extern] = ACTIONS(520),
    [anon_sym_nopanic] = ACTIONS(520),
    [anon_sym_loop] = ACTIONS(520),
    [anon_sym_match] = ACTIONS(520),
    [anon_sym_pub] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(520),
    [anon_sym_static] = ACTIONS(520),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_for] = ACTIONS(520),
    [sym_numeric_literal] = ACTIONS(520),
    [aux_sym_string_literal_token1] = ACTIONS(518),
    [sym_shortstring_literal] = ACTIONS(518),
    [anon_sym_true] = ACTIONS(520),
    [anon_sym_false] = ACTIONS(520),
    [anon_sym_DOLLAR] = ACTIONS(518),
    [sym_identifier] = ACTIONS(520),
    [sym_mutable_specifier] = ACTIONS(520),
    [sym_super] = ACTIONS(520),
    [sym_line_comment] = ACTIONS(3),
  },
  [78] = {
    [anon_sym_LBRACE] = ACTIONS(528),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_impl] = ACTIONS(530),
    [anon_sym_SEMI] = ACTIONS(528),
    [anon_sym_trait] = ACTIONS(530),
    [anon_sym_type] = ACTIONS(530),
    [anon_sym_COLON] = ACTIONS(530),
    [anon_sym_const] = ACTIONS(530),
    [anon_sym_EQ] = ACTIONS(530),
    [anon_sym_BANG] = ACTIONS(530),
    [anon_sym_POUND] = ACTIONS(528),
    [anon_sym_LBRACK] = ACTIONS(528),
    [anon_sym_RBRACK] = ACTIONS(528),
    [anon_sym_mod] = ACTIONS(530),
    [anon_sym_struct] = ACTIONS(530),
    [anon_sym_enum] = ACTIONS(530),
    [anon_sym_COMMA] = ACTIONS(528),
    [anon_sym_fn] = ACTIONS(530),
    [anon_sym_DASH_GT] = ACTIONS(528),
    [anon_sym_let] = ACTIONS(530),
    [anon_sym_use] = ACTIONS(530),
    [anon_sym_COLON_COLON] = ACTIONS(528),
    [anon_sym_STAR] = ACTIONS(530),
    [anon_sym_LPAREN] = ACTIONS(528),
    [anon_sym__] = ACTIONS(530),
    [anon_sym_RPAREN] = ACTIONS(528),
    [anon_sym_u8] = ACTIONS(530),
    [anon_sym_i8] = ACTIONS(530),
    [anon_sym_u16] = ACTIONS(530),
    [anon_sym_i16] = ACTIONS(530),
    [anon_sym_u32] = ACTIONS(530),
    [anon_sym_i32] = ACTIONS(530),
    [anon_sym_u64] = ACTIONS(530),
    [anon_sym_i64] = ACTIONS(530),
    [anon_sym_u128] = ACTIONS(530),
    [anon_sym_i128] = ACTIONS(530),
    [anon_sym_usize] = ACTIONS(530),
    [anon_sym_bool] = ACTIONS(530),
    [anon_sym_ByteArray] = ACTIONS(530),
    [anon_sym_felt252] = ACTIONS(530),
    [anon_sym_LT] = ACTIONS(530),
    [anon_sym_GT] = ACTIONS(530),
    [anon_sym_PLUS] = ACTIONS(530),
    [anon_sym_DASH] = ACTIONS(530),
    [anon_sym_SLASH] = ACTIONS(530),
    [anon_sym_PERCENT] = ACTIONS(530),
    [anon_sym_CARET] = ACTIONS(530),
    [anon_sym_TILDE] = ACTIONS(528),
    [anon_sym_AMP] = ACTIONS(530),
    [anon_sym_PIPE] = ACTIONS(530),
    [anon_sym_AMP_AMP] = ACTIONS(528),
    [anon_sym_PIPE_PIPE] = ACTIONS(528),
    [anon_sym_LT_LT] = ACTIONS(528),
    [anon_sym_GT_GT] = ACTIONS(528),
    [anon_sym_PLUS_EQ] = ACTIONS(528),
    [anon_sym_DASH_EQ] = ACTIONS(528),
    [anon_sym_STAR_EQ] = ACTIONS(528),
    [anon_sym_SLASH_EQ] = ACTIONS(528),
    [anon_sym_PERCENT_EQ] = ACTIONS(528),
    [anon_sym_CARET_EQ] = ACTIONS(528),
    [anon_sym_AMP_EQ] = ACTIONS(528),
    [anon_sym_PIPE_EQ] = ACTIONS(528),
    [anon_sym_EQ_EQ] = ACTIONS(528),
    [anon_sym_BANG_EQ] = ACTIONS(528),
    [anon_sym_GT_EQ] = ACTIONS(528),
    [anon_sym_LT_EQ] = ACTIONS(528),
    [anon_sym_AT] = ACTIONS(528),
    [anon_sym_DOT_DOT] = ACTIONS(528),
    [anon_sym_DOT] = ACTIONS(530),
    [anon_sym_EQ_GT] = ACTIONS(528),
    [anon_sym_QMARK] = ACTIONS(528),
    [anon_sym_break] = ACTIONS(530),
    [anon_sym_continue] = ACTIONS(530),
    [anon_sym_default] = ACTIONS(530),
    [anon_sym_if] = ACTIONS(530),
    [anon_sym_extern] = ACTIONS(530),
    [anon_sym_nopanic] = ACTIONS(530),
    [anon_sym_loop] = ACTIONS(530),
    [anon_sym_match] = ACTIONS(530),
    [anon_sym_pub] = ACTIONS(530),
    [anon_sym_return] = ACTIONS(530),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_while] = ACTIONS(530),
    [anon_sym_for] = ACTIONS(530),
    [sym_numeric_literal] = ACTIONS(530),
    [aux_sym_string_literal_token1] = ACTIONS(528),
    [sym_shortstring_literal] = ACTIONS(528),
    [anon_sym_true] = ACTIONS(530),
    [anon_sym_false] = ACTIONS(530),
    [anon_sym_DOLLAR] = ACTIONS(528),
    [sym_identifier] = ACTIONS(530),
    [sym_mutable_specifier] = ACTIONS(530),
    [sym_super] = ACTIONS(530),
    [sym_line_comment] = ACTIONS(3),
  },
  [79] = {
    [anon_sym_LBRACE] = ACTIONS(532),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_impl] = ACTIONS(534),
    [anon_sym_SEMI] = ACTIONS(532),
    [anon_sym_trait] = ACTIONS(534),
    [anon_sym_type] = ACTIONS(534),
    [anon_sym_COLON] = ACTIONS(534),
    [anon_sym_const] = ACTIONS(534),
    [anon_sym_EQ] = ACTIONS(534),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_POUND] = ACTIONS(532),
    [anon_sym_LBRACK] = ACTIONS(532),
    [anon_sym_RBRACK] = ACTIONS(532),
    [anon_sym_mod] = ACTIONS(534),
    [anon_sym_struct] = ACTIONS(534),
    [anon_sym_enum] = ACTIONS(534),
    [anon_sym_COMMA] = ACTIONS(532),
    [anon_sym_fn] = ACTIONS(534),
    [anon_sym_DASH_GT] = ACTIONS(532),
    [anon_sym_let] = ACTIONS(534),
    [anon_sym_use] = ACTIONS(534),
    [anon_sym_COLON_COLON] = ACTIONS(532),
    [anon_sym_STAR] = ACTIONS(534),
    [anon_sym_LPAREN] = ACTIONS(532),
    [anon_sym__] = ACTIONS(534),
    [anon_sym_RPAREN] = ACTIONS(532),
    [anon_sym_u8] = ACTIONS(534),
    [anon_sym_i8] = ACTIONS(534),
    [anon_sym_u16] = ACTIONS(534),
    [anon_sym_i16] = ACTIONS(534),
    [anon_sym_u32] = ACTIONS(534),
    [anon_sym_i32] = ACTIONS(534),
    [anon_sym_u64] = ACTIONS(534),
    [anon_sym_i64] = ACTIONS(534),
    [anon_sym_u128] = ACTIONS(534),
    [anon_sym_i128] = ACTIONS(534),
    [anon_sym_usize] = ACTIONS(534),
    [anon_sym_bool] = ACTIONS(534),
    [anon_sym_ByteArray] = ACTIONS(534),
    [anon_sym_felt252] = ACTIONS(534),
    [anon_sym_LT] = ACTIONS(534),
    [anon_sym_GT] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(534),
    [anon_sym_DASH] = ACTIONS(534),
    [anon_sym_SLASH] = ACTIONS(534),
    [anon_sym_PERCENT] = ACTIONS(534),
    [anon_sym_CARET] = ACTIONS(534),
    [anon_sym_TILDE] = ACTIONS(532),
    [anon_sym_AMP] = ACTIONS(534),
    [anon_sym_PIPE] = ACTIONS(534),
    [anon_sym_AMP_AMP] = ACTIONS(532),
    [anon_sym_PIPE_PIPE] = ACTIONS(532),
    [anon_sym_LT_LT] = ACTIONS(532),
    [anon_sym_GT_GT] = ACTIONS(532),
    [anon_sym_PLUS_EQ] = ACTIONS(532),
    [anon_sym_DASH_EQ] = ACTIONS(532),
    [anon_sym_STAR_EQ] = ACTIONS(532),
    [anon_sym_SLASH_EQ] = ACTIONS(532),
    [anon_sym_PERCENT_EQ] = ACTIONS(532),
    [anon_sym_CARET_EQ] = ACTIONS(532),
    [anon_sym_AMP_EQ] = ACTIONS(532),
    [anon_sym_PIPE_EQ] = ACTIONS(532),
    [anon_sym_EQ_EQ] = ACTIONS(532),
    [anon_sym_BANG_EQ] = ACTIONS(532),
    [anon_sym_GT_EQ] = ACTIONS(532),
    [anon_sym_LT_EQ] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(532),
    [anon_sym_DOT_DOT] = ACTIONS(532),
    [anon_sym_DOT] = ACTIONS(534),
    [anon_sym_EQ_GT] = ACTIONS(532),
    [anon_sym_QMARK] = ACTIONS(532),
    [anon_sym_break] = ACTIONS(534),
    [anon_sym_continue] = ACTIONS(534),
    [anon_sym_default] = ACTIONS(534),
    [anon_sym_if] = ACTIONS(534),
    [anon_sym_extern] = ACTIONS(534),
    [anon_sym_nopanic] = ACTIONS(534),
    [anon_sym_loop] = ACTIONS(534),
    [anon_sym_match] = ACTIONS(534),
    [anon_sym_pub] = ACTIONS(534),
    [anon_sym_return] = ACTIONS(534),
    [anon_sym_static] = ACTIONS(534),
    [anon_sym_while] = ACTIONS(534),
    [anon_sym_for] = ACTIONS(534),
    [sym_numeric_literal] = ACTIONS(534),
    [aux_sym_string_literal_token1] = ACTIONS(532),
    [sym_shortstring_literal] = ACTIONS(532),
    [anon_sym_true] = ACTIONS(534),
    [anon_sym_false] = ACTIONS(534),
    [anon_sym_DOLLAR] = ACTIONS(532),
    [sym_identifier] = ACTIONS(534),
    [sym_mutable_specifier] = ACTIONS(534),
    [sym_super] = ACTIONS(534),
    [sym_line_comment] = ACTIONS(3),
  },
  [80] = {
    [anon_sym_LBRACE] = ACTIONS(536),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_impl] = ACTIONS(538),
    [anon_sym_SEMI] = ACTIONS(536),
    [anon_sym_trait] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(538),
    [anon_sym_COLON] = ACTIONS(538),
    [anon_sym_const] = ACTIONS(538),
    [anon_sym_EQ] = ACTIONS(538),
    [anon_sym_BANG] = ACTIONS(538),
    [anon_sym_POUND] = ACTIONS(536),
    [anon_sym_LBRACK] = ACTIONS(536),
    [anon_sym_RBRACK] = ACTIONS(536),
    [anon_sym_mod] = ACTIONS(538),
    [anon_sym_struct] = ACTIONS(538),
    [anon_sym_enum] = ACTIONS(538),
    [anon_sym_COMMA] = ACTIONS(536),
    [anon_sym_fn] = ACTIONS(538),
    [anon_sym_DASH_GT] = ACTIONS(536),
    [anon_sym_let] = ACTIONS(538),
    [anon_sym_use] = ACTIONS(538),
    [anon_sym_COLON_COLON] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(538),
    [anon_sym_LPAREN] = ACTIONS(536),
    [anon_sym__] = ACTIONS(538),
    [anon_sym_RPAREN] = ACTIONS(536),
    [anon_sym_u8] = ACTIONS(538),
    [anon_sym_i8] = ACTIONS(538),
    [anon_sym_u16] = ACTIONS(538),
    [anon_sym_i16] = ACTIONS(538),
    [anon_sym_u32] = ACTIONS(538),
    [anon_sym_i32] = ACTIONS(538),
    [anon_sym_u64] = ACTIONS(538),
    [anon_sym_i64] = ACTIONS(538),
    [anon_sym_u128] = ACTIONS(538),
    [anon_sym_i128] = ACTIONS(538),
    [anon_sym_usize] = ACTIONS(538),
    [anon_sym_bool] = ACTIONS(538),
    [anon_sym_ByteArray] = ACTIONS(538),
    [anon_sym_felt252] = ACTIONS(538),
    [anon_sym_LT] = ACTIONS(538),
    [anon_sym_GT] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(538),
    [anon_sym_DASH] = ACTIONS(538),
    [anon_sym_SLASH] = ACTIONS(538),
    [anon_sym_PERCENT] = ACTIONS(538),
    [anon_sym_CARET] = ACTIONS(538),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_AMP] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(538),
    [anon_sym_AMP_AMP] = ACTIONS(536),
    [anon_sym_PIPE_PIPE] = ACTIONS(536),
    [anon_sym_LT_LT] = ACTIONS(536),
    [anon_sym_GT_GT] = ACTIONS(536),
    [anon_sym_PLUS_EQ] = ACTIONS(536),
    [anon_sym_DASH_EQ] = ACTIONS(536),
    [anon_sym_STAR_EQ] = ACTIONS(536),
    [anon_sym_SLASH_EQ] = ACTIONS(536),
    [anon_sym_PERCENT_EQ] = ACTIONS(536),
    [anon_sym_CARET_EQ] = ACTIONS(536),
    [anon_sym_AMP_EQ] = ACTIONS(536),
    [anon_sym_PIPE_EQ] = ACTIONS(536),
    [anon_sym_EQ_EQ] = ACTIONS(536),
    [anon_sym_BANG_EQ] = ACTIONS(536),
    [anon_sym_GT_EQ] = ACTIONS(536),
    [anon_sym_LT_EQ] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(536),
    [anon_sym_DOT_DOT] = ACTIONS(536),
    [anon_sym_DOT] = ACTIONS(538),
    [anon_sym_EQ_GT] = ACTIONS(536),
    [anon_sym_QMARK] = ACTIONS(536),
    [anon_sym_break] = ACTIONS(538),
    [anon_sym_continue] = ACTIONS(538),
    [anon_sym_default] = ACTIONS(538),
    [anon_sym_if] = ACTIONS(538),
    [anon_sym_extern] = ACTIONS(538),
    [anon_sym_nopanic] = ACTIONS(538),
    [anon_sym_loop] = ACTIONS(538),
    [anon_sym_match] = ACTIONS(538),
    [anon_sym_pub] = ACTIONS(538),
    [anon_sym_return] = ACTIONS(538),
    [anon_sym_static] = ACTIONS(538),
    [anon_sym_while] = ACTIONS(538),
    [anon_sym_for] = ACTIONS(538),
    [sym_numeric_literal] = ACTIONS(538),
    [aux_sym_string_literal_token1] = ACTIONS(536),
    [sym_shortstring_literal] = ACTIONS(536),
    [anon_sym_true] = ACTIONS(538),
    [anon_sym_false] = ACTIONS(538),
    [anon_sym_DOLLAR] = ACTIONS(536),
    [sym_identifier] = ACTIONS(538),
    [sym_mutable_specifier] = ACTIONS(538),
    [sym_super] = ACTIONS(538),
    [sym_line_comment] = ACTIONS(3),
  },
  [81] = {
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_impl] = ACTIONS(542),
    [anon_sym_SEMI] = ACTIONS(540),
    [anon_sym_trait] = ACTIONS(542),
    [anon_sym_type] = ACTIONS(542),
    [anon_sym_COLON] = ACTIONS(542),
    [anon_sym_const] = ACTIONS(542),
    [anon_sym_EQ] = ACTIONS(542),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_POUND] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(540),
    [anon_sym_RBRACK] = ACTIONS(540),
    [anon_sym_mod] = ACTIONS(542),
    [anon_sym_struct] = ACTIONS(542),
    [anon_sym_enum] = ACTIONS(542),
    [anon_sym_COMMA] = ACTIONS(540),
    [anon_sym_fn] = ACTIONS(542),
    [anon_sym_DASH_GT] = ACTIONS(540),
    [anon_sym_let] = ACTIONS(542),
    [anon_sym_use] = ACTIONS(542),
    [anon_sym_COLON_COLON] = ACTIONS(540),
    [anon_sym_STAR] = ACTIONS(542),
    [anon_sym_LPAREN] = ACTIONS(540),
    [anon_sym__] = ACTIONS(542),
    [anon_sym_RPAREN] = ACTIONS(540),
    [anon_sym_u8] = ACTIONS(542),
    [anon_sym_i8] = ACTIONS(542),
    [anon_sym_u16] = ACTIONS(542),
    [anon_sym_i16] = ACTIONS(542),
    [anon_sym_u32] = ACTIONS(542),
    [anon_sym_i32] = ACTIONS(542),
    [anon_sym_u64] = ACTIONS(542),
    [anon_sym_i64] = ACTIONS(542),
    [anon_sym_u128] = ACTIONS(542),
    [anon_sym_i128] = ACTIONS(542),
    [anon_sym_usize] = ACTIONS(542),
    [anon_sym_bool] = ACTIONS(542),
    [anon_sym_ByteArray] = ACTIONS(542),
    [anon_sym_felt252] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(542),
    [anon_sym_GT] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(542),
    [anon_sym_DASH] = ACTIONS(542),
    [anon_sym_SLASH] = ACTIONS(542),
    [anon_sym_PERCENT] = ACTIONS(542),
    [anon_sym_CARET] = ACTIONS(542),
    [anon_sym_TILDE] = ACTIONS(540),
    [anon_sym_AMP] = ACTIONS(542),
    [anon_sym_PIPE] = ACTIONS(542),
    [anon_sym_AMP_AMP] = ACTIONS(540),
    [anon_sym_PIPE_PIPE] = ACTIONS(540),
    [anon_sym_LT_LT] = ACTIONS(540),
    [anon_sym_GT_GT] = ACTIONS(540),
    [anon_sym_PLUS_EQ] = ACTIONS(540),
    [anon_sym_DASH_EQ] = ACTIONS(540),
    [anon_sym_STAR_EQ] = ACTIONS(540),
    [anon_sym_SLASH_EQ] = ACTIONS(540),
    [anon_sym_PERCENT_EQ] = ACTIONS(540),
    [anon_sym_CARET_EQ] = ACTIONS(540),
    [anon_sym_AMP_EQ] = ACTIONS(540),
    [anon_sym_PIPE_EQ] = ACTIONS(540),
    [anon_sym_EQ_EQ] = ACTIONS(540),
    [anon_sym_BANG_EQ] = ACTIONS(540),
    [anon_sym_GT_EQ] = ACTIONS(540),
    [anon_sym_LT_EQ] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(540),
    [anon_sym_DOT_DOT] = ACTIONS(540),
    [anon_sym_DOT] = ACTIONS(542),
    [anon_sym_EQ_GT] = ACTIONS(540),
    [anon_sym_QMARK] = ACTIONS(540),
    [anon_sym_break] = ACTIONS(542),
    [anon_sym_continue] = ACTIONS(542),
    [anon_sym_default] = ACTIONS(542),
    [anon_sym_if] = ACTIONS(542),
    [anon_sym_extern] = ACTIONS(542),
    [anon_sym_nopanic] = ACTIONS(542),
    [anon_sym_loop] = ACTIONS(542),
    [anon_sym_match] = ACTIONS(542),
    [anon_sym_pub] = ACTIONS(542),
    [anon_sym_return] = ACTIONS(542),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_while] = ACTIONS(542),
    [anon_sym_for] = ACTIONS(542),
    [sym_numeric_literal] = ACTIONS(542),
    [aux_sym_string_literal_token1] = ACTIONS(540),
    [sym_shortstring_literal] = ACTIONS(540),
    [anon_sym_true] = ACTIONS(542),
    [anon_sym_false] = ACTIONS(542),
    [anon_sym_DOLLAR] = ACTIONS(540),
    [sym_identifier] = ACTIONS(542),
    [sym_mutable_specifier] = ACTIONS(542),
    [sym_super] = ACTIONS(542),
    [sym_line_comment] = ACTIONS(3),
  },
  [82] = {
    [anon_sym_LBRACE] = ACTIONS(544),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_impl] = ACTIONS(546),
    [anon_sym_SEMI] = ACTIONS(544),
    [anon_sym_trait] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(546),
    [anon_sym_COLON] = ACTIONS(546),
    [anon_sym_const] = ACTIONS(546),
    [anon_sym_EQ] = ACTIONS(546),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_POUND] = ACTIONS(544),
    [anon_sym_LBRACK] = ACTIONS(544),
    [anon_sym_RBRACK] = ACTIONS(544),
    [anon_sym_mod] = ACTIONS(546),
    [anon_sym_struct] = ACTIONS(546),
    [anon_sym_enum] = ACTIONS(546),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_fn] = ACTIONS(546),
    [anon_sym_DASH_GT] = ACTIONS(544),
    [anon_sym_let] = ACTIONS(546),
    [anon_sym_use] = ACTIONS(546),
    [anon_sym_COLON_COLON] = ACTIONS(544),
    [anon_sym_STAR] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(544),
    [anon_sym__] = ACTIONS(546),
    [anon_sym_RPAREN] = ACTIONS(544),
    [anon_sym_u8] = ACTIONS(546),
    [anon_sym_i8] = ACTIONS(546),
    [anon_sym_u16] = ACTIONS(546),
    [anon_sym_i16] = ACTIONS(546),
    [anon_sym_u32] = ACTIONS(546),
    [anon_sym_i32] = ACTIONS(546),
    [anon_sym_u64] = ACTIONS(546),
    [anon_sym_i64] = ACTIONS(546),
    [anon_sym_u128] = ACTIONS(546),
    [anon_sym_i128] = ACTIONS(546),
    [anon_sym_usize] = ACTIONS(546),
    [anon_sym_bool] = ACTIONS(546),
    [anon_sym_ByteArray] = ACTIONS(546),
    [anon_sym_felt252] = ACTIONS(546),
    [anon_sym_LT] = ACTIONS(546),
    [anon_sym_GT] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(546),
    [anon_sym_DASH] = ACTIONS(546),
    [anon_sym_SLASH] = ACTIONS(546),
    [anon_sym_PERCENT] = ACTIONS(546),
    [anon_sym_CARET] = ACTIONS(546),
    [anon_sym_TILDE] = ACTIONS(544),
    [anon_sym_AMP] = ACTIONS(546),
    [anon_sym_PIPE] = ACTIONS(546),
    [anon_sym_AMP_AMP] = ACTIONS(544),
    [anon_sym_PIPE_PIPE] = ACTIONS(544),
    [anon_sym_LT_LT] = ACTIONS(544),
    [anon_sym_GT_GT] = ACTIONS(544),
    [anon_sym_PLUS_EQ] = ACTIONS(544),
    [anon_sym_DASH_EQ] = ACTIONS(544),
    [anon_sym_STAR_EQ] = ACTIONS(544),
    [anon_sym_SLASH_EQ] = ACTIONS(544),
    [anon_sym_PERCENT_EQ] = ACTIONS(544),
    [anon_sym_CARET_EQ] = ACTIONS(544),
    [anon_sym_AMP_EQ] = ACTIONS(544),
    [anon_sym_PIPE_EQ] = ACTIONS(544),
    [anon_sym_EQ_EQ] = ACTIONS(544),
    [anon_sym_BANG_EQ] = ACTIONS(544),
    [anon_sym_GT_EQ] = ACTIONS(544),
    [anon_sym_LT_EQ] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_DOT_DOT] = ACTIONS(544),
    [anon_sym_DOT] = ACTIONS(546),
    [anon_sym_EQ_GT] = ACTIONS(544),
    [anon_sym_QMARK] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(546),
    [anon_sym_continue] = ACTIONS(546),
    [anon_sym_default] = ACTIONS(546),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_extern] = ACTIONS(546),
    [anon_sym_nopanic] = ACTIONS(546),
    [anon_sym_loop] = ACTIONS(546),
    [anon_sym_match] = ACTIONS(546),
    [anon_sym_pub] = ACTIONS(546),
    [anon_sym_return] = ACTIONS(546),
    [anon_sym_static] = ACTIONS(546),
    [anon_sym_while] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(546),
    [sym_numeric_literal] = ACTIONS(546),
    [aux_sym_string_literal_token1] = ACTIONS(544),
    [sym_shortstring_literal] = ACTIONS(544),
    [anon_sym_true] = ACTIONS(546),
    [anon_sym_false] = ACTIONS(546),
    [anon_sym_DOLLAR] = ACTIONS(544),
    [sym_identifier] = ACTIONS(546),
    [sym_mutable_specifier] = ACTIONS(546),
    [sym_super] = ACTIONS(546),
    [sym_line_comment] = ACTIONS(3),
  },
  [83] = {
    [anon_sym_LBRACE] = ACTIONS(548),
    [anon_sym_RBRACE] = ACTIONS(548),
    [anon_sym_impl] = ACTIONS(550),
    [anon_sym_SEMI] = ACTIONS(548),
    [anon_sym_trait] = ACTIONS(550),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_COLON] = ACTIONS(550),
    [anon_sym_const] = ACTIONS(550),
    [anon_sym_EQ] = ACTIONS(550),
    [anon_sym_BANG] = ACTIONS(550),
    [anon_sym_POUND] = ACTIONS(548),
    [anon_sym_LBRACK] = ACTIONS(548),
    [anon_sym_RBRACK] = ACTIONS(548),
    [anon_sym_mod] = ACTIONS(550),
    [anon_sym_struct] = ACTIONS(550),
    [anon_sym_enum] = ACTIONS(550),
    [anon_sym_COMMA] = ACTIONS(548),
    [anon_sym_fn] = ACTIONS(550),
    [anon_sym_DASH_GT] = ACTIONS(548),
    [anon_sym_let] = ACTIONS(550),
    [anon_sym_use] = ACTIONS(550),
    [anon_sym_COLON_COLON] = ACTIONS(548),
    [anon_sym_STAR] = ACTIONS(550),
    [anon_sym_LPAREN] = ACTIONS(548),
    [anon_sym__] = ACTIONS(550),
    [anon_sym_RPAREN] = ACTIONS(548),
    [anon_sym_u8] = ACTIONS(550),
    [anon_sym_i8] = ACTIONS(550),
    [anon_sym_u16] = ACTIONS(550),
    [anon_sym_i16] = ACTIONS(550),
    [anon_sym_u32] = ACTIONS(550),
    [anon_sym_i32] = ACTIONS(550),
    [anon_sym_u64] = ACTIONS(550),
    [anon_sym_i64] = ACTIONS(550),
    [anon_sym_u128] = ACTIONS(550),
    [anon_sym_i128] = ACTIONS(550),
    [anon_sym_usize] = ACTIONS(550),
    [anon_sym_bool] = ACTIONS(550),
    [anon_sym_ByteArray] = ACTIONS(550),
    [anon_sym_felt252] = ACTIONS(550),
    [anon_sym_LT] = ACTIONS(550),
    [anon_sym_GT] = ACTIONS(550),
    [anon_sym_PLUS] = ACTIONS(550),
    [anon_sym_DASH] = ACTIONS(550),
    [anon_sym_SLASH] = ACTIONS(550),
    [anon_sym_PERCENT] = ACTIONS(550),
    [anon_sym_CARET] = ACTIONS(550),
    [anon_sym_TILDE] = ACTIONS(548),
    [anon_sym_AMP] = ACTIONS(550),
    [anon_sym_PIPE] = ACTIONS(550),
    [anon_sym_AMP_AMP] = ACTIONS(548),
    [anon_sym_PIPE_PIPE] = ACTIONS(548),
    [anon_sym_LT_LT] = ACTIONS(548),
    [anon_sym_GT_GT] = ACTIONS(548),
    [anon_sym_PLUS_EQ] = ACTIONS(548),
    [anon_sym_DASH_EQ] = ACTIONS(548),
    [anon_sym_STAR_EQ] = ACTIONS(548),
    [anon_sym_SLASH_EQ] = ACTIONS(548),
    [anon_sym_PERCENT_EQ] = ACTIONS(548),
    [anon_sym_CARET_EQ] = ACTIONS(548),
    [anon_sym_AMP_EQ] = ACTIONS(548),
    [anon_sym_PIPE_EQ] = ACTIONS(548),
    [anon_sym_EQ_EQ] = ACTIONS(548),
    [anon_sym_BANG_EQ] = ACTIONS(548),
    [anon_sym_GT_EQ] = ACTIONS(548),
    [anon_sym_LT_EQ] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(548),
    [anon_sym_DOT_DOT] = ACTIONS(548),
    [anon_sym_DOT] = ACTIONS(550),
    [anon_sym_EQ_GT] = ACTIONS(548),
    [anon_sym_QMARK] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(550),
    [anon_sym_continue] = ACTIONS(550),
    [anon_sym_default] = ACTIONS(550),
    [anon_sym_if] = ACTIONS(550),
    [anon_sym_extern] = ACTIONS(550),
    [anon_sym_nopanic] = ACTIONS(550),
    [anon_sym_loop] = ACTIONS(550),
    [anon_sym_match] = ACTIONS(550),
    [anon_sym_pub] = ACTIONS(550),
    [anon_sym_return] = ACTIONS(550),
    [anon_sym_static] = ACTIONS(550),
    [anon_sym_while] = ACTIONS(550),
    [anon_sym_for] = ACTIONS(550),
    [sym_numeric_literal] = ACTIONS(552),
    [aux_sym_string_literal_token1] = ACTIONS(548),
    [sym_shortstring_literal] = ACTIONS(548),
    [anon_sym_true] = ACTIONS(550),
    [anon_sym_false] = ACTIONS(550),
    [anon_sym_DOLLAR] = ACTIONS(548),
    [sym_identifier] = ACTIONS(550),
    [sym_mutable_specifier] = ACTIONS(550),
    [sym_super] = ACTIONS(550),
    [sym_line_comment] = ACTIONS(3),
  },
  [84] = {
    [anon_sym_LBRACE] = ACTIONS(555),
    [anon_sym_RBRACE] = ACTIONS(555),
    [anon_sym_impl] = ACTIONS(557),
    [anon_sym_SEMI] = ACTIONS(555),
    [anon_sym_trait] = ACTIONS(557),
    [anon_sym_type] = ACTIONS(557),
    [anon_sym_COLON] = ACTIONS(557),
    [anon_sym_const] = ACTIONS(557),
    [anon_sym_EQ] = ACTIONS(557),
    [anon_sym_BANG] = ACTIONS(557),
    [anon_sym_POUND] = ACTIONS(555),
    [anon_sym_LBRACK] = ACTIONS(555),
    [anon_sym_RBRACK] = ACTIONS(555),
    [anon_sym_mod] = ACTIONS(557),
    [anon_sym_struct] = ACTIONS(557),
    [anon_sym_enum] = ACTIONS(557),
    [anon_sym_COMMA] = ACTIONS(555),
    [anon_sym_fn] = ACTIONS(557),
    [anon_sym_DASH_GT] = ACTIONS(555),
    [anon_sym_let] = ACTIONS(557),
    [anon_sym_use] = ACTIONS(557),
    [anon_sym_COLON_COLON] = ACTIONS(555),
    [anon_sym_STAR] = ACTIONS(557),
    [anon_sym_LPAREN] = ACTIONS(555),
    [anon_sym__] = ACTIONS(557),
    [anon_sym_RPAREN] = ACTIONS(555),
    [anon_sym_u8] = ACTIONS(557),
    [anon_sym_i8] = ACTIONS(557),
    [anon_sym_u16] = ACTIONS(557),
    [anon_sym_i16] = ACTIONS(557),
    [anon_sym_u32] = ACTIONS(557),
    [anon_sym_i32] = ACTIONS(557),
    [anon_sym_u64] = ACTIONS(557),
    [anon_sym_i64] = ACTIONS(557),
    [anon_sym_u128] = ACTIONS(557),
    [anon_sym_i128] = ACTIONS(557),
    [anon_sym_usize] = ACTIONS(557),
    [anon_sym_bool] = ACTIONS(557),
    [anon_sym_ByteArray] = ACTIONS(557),
    [anon_sym_felt252] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(557),
    [anon_sym_GT] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(557),
    [anon_sym_DASH] = ACTIONS(557),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_PERCENT] = ACTIONS(557),
    [anon_sym_CARET] = ACTIONS(557),
    [anon_sym_TILDE] = ACTIONS(555),
    [anon_sym_AMP] = ACTIONS(557),
    [anon_sym_PIPE] = ACTIONS(557),
    [anon_sym_AMP_AMP] = ACTIONS(555),
    [anon_sym_PIPE_PIPE] = ACTIONS(555),
    [anon_sym_LT_LT] = ACTIONS(555),
    [anon_sym_GT_GT] = ACTIONS(555),
    [anon_sym_PLUS_EQ] = ACTIONS(555),
    [anon_sym_DASH_EQ] = ACTIONS(555),
    [anon_sym_STAR_EQ] = ACTIONS(555),
    [anon_sym_SLASH_EQ] = ACTIONS(555),
    [anon_sym_PERCENT_EQ] = ACTIONS(555),
    [anon_sym_CARET_EQ] = ACTIONS(555),
    [anon_sym_AMP_EQ] = ACTIONS(555),
    [anon_sym_PIPE_EQ] = ACTIONS(555),
    [anon_sym_EQ_EQ] = ACTIONS(555),
    [anon_sym_BANG_EQ] = ACTIONS(555),
    [anon_sym_GT_EQ] = ACTIONS(555),
    [anon_sym_LT_EQ] = ACTIONS(555),
    [anon_sym_AT] = ACTIONS(555),
    [anon_sym_DOT_DOT] = ACTIONS(555),
    [anon_sym_DOT] = ACTIONS(557),
    [anon_sym_EQ_GT] = ACTIONS(555),
    [anon_sym_QMARK] = ACTIONS(555),
    [anon_sym_break] = ACTIONS(557),
    [anon_sym_continue] = ACTIONS(557),
    [anon_sym_default] = ACTIONS(557),
    [anon_sym_if] = ACTIONS(557),
    [anon_sym_extern] = ACTIONS(557),
    [anon_sym_nopanic] = ACTIONS(557),
    [anon_sym_loop] = ACTIONS(557),
    [anon_sym_match] = ACTIONS(557),
    [anon_sym_pub] = ACTIONS(557),
    [anon_sym_return] = ACTIONS(557),
    [anon_sym_static] = ACTIONS(557),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_for] = ACTIONS(557),
    [sym_numeric_literal] = ACTIONS(557),
    [aux_sym_string_literal_token1] = ACTIONS(555),
    [sym_shortstring_literal] = ACTIONS(555),
    [anon_sym_true] = ACTIONS(557),
    [anon_sym_false] = ACTIONS(557),
    [anon_sym_DOLLAR] = ACTIONS(555),
    [sym_identifier] = ACTIONS(557),
    [sym_mutable_specifier] = ACTIONS(557),
    [sym_super] = ACTIONS(557),
    [sym_line_comment] = ACTIONS(3),
  },
  [85] = {
    [anon_sym_LBRACE] = ACTIONS(559),
    [anon_sym_RBRACE] = ACTIONS(559),
    [anon_sym_impl] = ACTIONS(561),
    [anon_sym_SEMI] = ACTIONS(559),
    [anon_sym_trait] = ACTIONS(561),
    [anon_sym_type] = ACTIONS(561),
    [anon_sym_COLON] = ACTIONS(561),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_EQ] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(561),
    [anon_sym_POUND] = ACTIONS(559),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_RBRACK] = ACTIONS(559),
    [anon_sym_mod] = ACTIONS(561),
    [anon_sym_struct] = ACTIONS(561),
    [anon_sym_enum] = ACTIONS(561),
    [anon_sym_COMMA] = ACTIONS(559),
    [anon_sym_fn] = ACTIONS(561),
    [anon_sym_DASH_GT] = ACTIONS(559),
    [anon_sym_let] = ACTIONS(561),
    [anon_sym_use] = ACTIONS(561),
    [anon_sym_COLON_COLON] = ACTIONS(559),
    [anon_sym_STAR] = ACTIONS(561),
    [anon_sym_LPAREN] = ACTIONS(559),
    [anon_sym__] = ACTIONS(561),
    [anon_sym_RPAREN] = ACTIONS(559),
    [anon_sym_u8] = ACTIONS(561),
    [anon_sym_i8] = ACTIONS(561),
    [anon_sym_u16] = ACTIONS(561),
    [anon_sym_i16] = ACTIONS(561),
    [anon_sym_u32] = ACTIONS(561),
    [anon_sym_i32] = ACTIONS(561),
    [anon_sym_u64] = ACTIONS(561),
    [anon_sym_i64] = ACTIONS(561),
    [anon_sym_u128] = ACTIONS(561),
    [anon_sym_i128] = ACTIONS(561),
    [anon_sym_usize] = ACTIONS(561),
    [anon_sym_bool] = ACTIONS(561),
    [anon_sym_ByteArray] = ACTIONS(561),
    [anon_sym_felt252] = ACTIONS(561),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_GT] = ACTIONS(561),
    [anon_sym_PLUS] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(561),
    [anon_sym_PERCENT] = ACTIONS(561),
    [anon_sym_CARET] = ACTIONS(561),
    [anon_sym_TILDE] = ACTIONS(559),
    [anon_sym_AMP] = ACTIONS(561),
    [anon_sym_PIPE] = ACTIONS(561),
    [anon_sym_AMP_AMP] = ACTIONS(559),
    [anon_sym_PIPE_PIPE] = ACTIONS(559),
    [anon_sym_LT_LT] = ACTIONS(559),
    [anon_sym_GT_GT] = ACTIONS(559),
    [anon_sym_PLUS_EQ] = ACTIONS(559),
    [anon_sym_DASH_EQ] = ACTIONS(559),
    [anon_sym_STAR_EQ] = ACTIONS(559),
    [anon_sym_SLASH_EQ] = ACTIONS(559),
    [anon_sym_PERCENT_EQ] = ACTIONS(559),
    [anon_sym_CARET_EQ] = ACTIONS(559),
    [anon_sym_AMP_EQ] = ACTIONS(559),
    [anon_sym_PIPE_EQ] = ACTIONS(559),
    [anon_sym_EQ_EQ] = ACTIONS(559),
    [anon_sym_BANG_EQ] = ACTIONS(559),
    [anon_sym_GT_EQ] = ACTIONS(559),
    [anon_sym_LT_EQ] = ACTIONS(559),
    [anon_sym_AT] = ACTIONS(559),
    [anon_sym_DOT_DOT] = ACTIONS(559),
    [anon_sym_DOT] = ACTIONS(561),
    [anon_sym_EQ_GT] = ACTIONS(559),
    [anon_sym_QMARK] = ACTIONS(559),
    [anon_sym_break] = ACTIONS(561),
    [anon_sym_continue] = ACTIONS(561),
    [anon_sym_default] = ACTIONS(561),
    [anon_sym_if] = ACTIONS(561),
    [anon_sym_extern] = ACTIONS(561),
    [anon_sym_nopanic] = ACTIONS(561),
    [anon_sym_loop] = ACTIONS(561),
    [anon_sym_match] = ACTIONS(561),
    [anon_sym_pub] = ACTIONS(561),
    [anon_sym_return] = ACTIONS(561),
    [anon_sym_static] = ACTIONS(561),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_for] = ACTIONS(561),
    [sym_numeric_literal] = ACTIONS(561),
    [aux_sym_string_literal_token1] = ACTIONS(559),
    [sym_shortstring_literal] = ACTIONS(559),
    [anon_sym_true] = ACTIONS(561),
    [anon_sym_false] = ACTIONS(561),
    [anon_sym_DOLLAR] = ACTIONS(559),
    [sym_identifier] = ACTIONS(561),
    [sym_mutable_specifier] = ACTIONS(561),
    [sym_super] = ACTIONS(561),
    [sym_line_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(100),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(693),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1432),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(100),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(567),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(569),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(97),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(728),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1381),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(97),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(573),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(575),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(98),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(886),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1704),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(577),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(98),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(886),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1704),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(579),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(98),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(886),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1704),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(581),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(98),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(886),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1704),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(583),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(98),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(886),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1704),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(585),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(98),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(886),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1704),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(587),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(103),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(650),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(103),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(591),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(94),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(679),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(94),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(595),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(711),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(597),
    [anon_sym_BANG] = ACTIONS(600),
    [anon_sym_POUND] = ACTIONS(603),
    [anon_sym_LBRACK] = ACTIONS(606),
    [anon_sym_RBRACK] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(609),
    [anon_sym_COLON_COLON] = ACTIONS(611),
    [anon_sym_STAR] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(614),
    [anon_sym_u8] = ACTIONS(617),
    [anon_sym_i8] = ACTIONS(617),
    [anon_sym_u16] = ACTIONS(617),
    [anon_sym_i16] = ACTIONS(617),
    [anon_sym_u32] = ACTIONS(617),
    [anon_sym_i32] = ACTIONS(617),
    [anon_sym_u64] = ACTIONS(617),
    [anon_sym_i64] = ACTIONS(617),
    [anon_sym_u128] = ACTIONS(617),
    [anon_sym_i128] = ACTIONS(617),
    [anon_sym_usize] = ACTIONS(617),
    [anon_sym_bool] = ACTIONS(617),
    [anon_sym_ByteArray] = ACTIONS(617),
    [anon_sym_felt252] = ACTIONS(617),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(600),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(600),
    [anon_sym_DOT_DOT] = ACTIONS(626),
    [anon_sym_break] = ACTIONS(629),
    [anon_sym_continue] = ACTIONS(632),
    [anon_sym_default] = ACTIONS(635),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_loop] = ACTIONS(641),
    [anon_sym_match] = ACTIONS(644),
    [anon_sym_return] = ACTIONS(647),
    [anon_sym_while] = ACTIONS(650),
    [anon_sym_for] = ACTIONS(653),
    [sym_numeric_literal] = ACTIONS(656),
    [aux_sym_string_literal_token1] = ACTIONS(659),
    [sym_shortstring_literal] = ACTIONS(662),
    [anon_sym_true] = ACTIONS(665),
    [anon_sym_false] = ACTIONS(665),
    [anon_sym_move] = ACTIONS(668),
    [anon_sym_ref] = ACTIONS(671),
    [sym_identifier] = ACTIONS(674),
    [sym_super] = ACTIONS(677),
    [sym_line_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(731),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1410),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(868),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1675),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(102),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(676),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(102),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(680),
    [anon_sym_COMMA] = ACTIONS(682),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(720),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1347),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(98),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(886),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_named_argument] = STATE(1704),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(571),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(96),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(653),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(96),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(684),
    [anon_sym_COMMA] = ACTIONS(686),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(730),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(597),
    [anon_sym_BANG] = ACTIONS(600),
    [anon_sym_POUND] = ACTIONS(603),
    [anon_sym_LBRACK] = ACTIONS(606),
    [anon_sym_RBRACK] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(609),
    [anon_sym_COLON_COLON] = ACTIONS(611),
    [anon_sym_STAR] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(614),
    [anon_sym_u8] = ACTIONS(617),
    [anon_sym_i8] = ACTIONS(617),
    [anon_sym_u16] = ACTIONS(617),
    [anon_sym_i16] = ACTIONS(617),
    [anon_sym_u32] = ACTIONS(617),
    [anon_sym_i32] = ACTIONS(617),
    [anon_sym_u64] = ACTIONS(617),
    [anon_sym_i64] = ACTIONS(617),
    [anon_sym_u128] = ACTIONS(617),
    [anon_sym_i128] = ACTIONS(617),
    [anon_sym_usize] = ACTIONS(617),
    [anon_sym_bool] = ACTIONS(617),
    [anon_sym_ByteArray] = ACTIONS(617),
    [anon_sym_felt252] = ACTIONS(617),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(600),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(600),
    [anon_sym_DOT_DOT] = ACTIONS(626),
    [anon_sym_break] = ACTIONS(629),
    [anon_sym_continue] = ACTIONS(632),
    [anon_sym_default] = ACTIONS(635),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_loop] = ACTIONS(641),
    [anon_sym_match] = ACTIONS(644),
    [anon_sym_return] = ACTIONS(647),
    [anon_sym_while] = ACTIONS(650),
    [anon_sym_for] = ACTIONS(653),
    [sym_numeric_literal] = ACTIONS(656),
    [aux_sym_string_literal_token1] = ACTIONS(659),
    [sym_shortstring_literal] = ACTIONS(662),
    [anon_sym_true] = ACTIONS(665),
    [anon_sym_false] = ACTIONS(665),
    [anon_sym_move] = ACTIONS(668),
    [anon_sym_ref] = ACTIONS(671),
    [sym_identifier] = ACTIONS(674),
    [sym_super] = ACTIONS(677),
    [sym_line_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(688),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(692),
    [anon_sym_LBRACE] = ACTIONS(692),
    [anon_sym_RBRACE] = ACTIONS(692),
    [anon_sym_impl] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(692),
    [anon_sym_trait] = ACTIONS(694),
    [anon_sym_type] = ACTIONS(694),
    [anon_sym_const] = ACTIONS(694),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(694),
    [anon_sym_POUND] = ACTIONS(692),
    [anon_sym_LBRACK] = ACTIONS(692),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_mod] = ACTIONS(694),
    [anon_sym_struct] = ACTIONS(694),
    [anon_sym_enum] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(692),
    [anon_sym_fn] = ACTIONS(694),
    [anon_sym_let] = ACTIONS(694),
    [anon_sym_use] = ACTIONS(694),
    [anon_sym_COLON_COLON] = ACTIONS(692),
    [anon_sym_STAR] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(692),
    [anon_sym_RPAREN] = ACTIONS(692),
    [anon_sym_u8] = ACTIONS(694),
    [anon_sym_i8] = ACTIONS(694),
    [anon_sym_u16] = ACTIONS(694),
    [anon_sym_i16] = ACTIONS(694),
    [anon_sym_u32] = ACTIONS(694),
    [anon_sym_i32] = ACTIONS(694),
    [anon_sym_u64] = ACTIONS(694),
    [anon_sym_i64] = ACTIONS(694),
    [anon_sym_u128] = ACTIONS(694),
    [anon_sym_i128] = ACTIONS(694),
    [anon_sym_usize] = ACTIONS(694),
    [anon_sym_bool] = ACTIONS(694),
    [anon_sym_ByteArray] = ACTIONS(694),
    [anon_sym_felt252] = ACTIONS(694),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_SLASH] = ACTIONS(694),
    [anon_sym_PERCENT] = ACTIONS(694),
    [anon_sym_CARET] = ACTIONS(692),
    [anon_sym_TILDE] = ACTIONS(692),
    [anon_sym_AMP] = ACTIONS(694),
    [anon_sym_PIPE] = ACTIONS(694),
    [anon_sym_AMP_AMP] = ACTIONS(692),
    [anon_sym_PIPE_PIPE] = ACTIONS(692),
    [anon_sym_LT_LT] = ACTIONS(692),
    [anon_sym_GT_GT] = ACTIONS(692),
    [anon_sym_PLUS_EQ] = ACTIONS(692),
    [anon_sym_DASH_EQ] = ACTIONS(692),
    [anon_sym_STAR_EQ] = ACTIONS(692),
    [anon_sym_SLASH_EQ] = ACTIONS(692),
    [anon_sym_PERCENT_EQ] = ACTIONS(692),
    [anon_sym_EQ_EQ] = ACTIONS(692),
    [anon_sym_BANG_EQ] = ACTIONS(692),
    [anon_sym_GT_EQ] = ACTIONS(692),
    [anon_sym_LT_EQ] = ACTIONS(692),
    [anon_sym_AT] = ACTIONS(692),
    [anon_sym_DOT_DOT] = ACTIONS(692),
    [anon_sym_DOT] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(692),
    [anon_sym_break] = ACTIONS(694),
    [anon_sym_continue] = ACTIONS(694),
    [anon_sym_default] = ACTIONS(694),
    [anon_sym_if] = ACTIONS(694),
    [anon_sym_extern] = ACTIONS(694),
    [anon_sym_loop] = ACTIONS(694),
    [anon_sym_match] = ACTIONS(694),
    [anon_sym_pub] = ACTIONS(694),
    [anon_sym_return] = ACTIONS(694),
    [anon_sym_while] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(694),
    [sym_numeric_literal] = ACTIONS(694),
    [aux_sym_string_literal_token1] = ACTIONS(692),
    [sym_shortstring_literal] = ACTIONS(692),
    [anon_sym_true] = ACTIONS(694),
    [anon_sym_false] = ACTIONS(694),
    [anon_sym_move] = ACTIONS(694),
    [anon_sym_ref] = ACTIONS(694),
    [sym_identifier] = ACTIONS(694),
    [sym_super] = ACTIONS(694),
    [sym_line_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(696),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(698),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(698),
    [anon_sym_impl] = ACTIONS(700),
    [anon_sym_SEMI] = ACTIONS(698),
    [anon_sym_trait] = ACTIONS(700),
    [anon_sym_type] = ACTIONS(700),
    [anon_sym_const] = ACTIONS(700),
    [anon_sym_EQ] = ACTIONS(700),
    [anon_sym_BANG] = ACTIONS(700),
    [anon_sym_POUND] = ACTIONS(698),
    [anon_sym_LBRACK] = ACTIONS(698),
    [anon_sym_RBRACK] = ACTIONS(698),
    [anon_sym_mod] = ACTIONS(700),
    [anon_sym_struct] = ACTIONS(700),
    [anon_sym_enum] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(698),
    [anon_sym_fn] = ACTIONS(700),
    [anon_sym_let] = ACTIONS(700),
    [anon_sym_use] = ACTIONS(700),
    [anon_sym_COLON_COLON] = ACTIONS(698),
    [anon_sym_STAR] = ACTIONS(700),
    [anon_sym_LPAREN] = ACTIONS(698),
    [anon_sym_RPAREN] = ACTIONS(698),
    [anon_sym_u8] = ACTIONS(700),
    [anon_sym_i8] = ACTIONS(700),
    [anon_sym_u16] = ACTIONS(700),
    [anon_sym_i16] = ACTIONS(700),
    [anon_sym_u32] = ACTIONS(700),
    [anon_sym_i32] = ACTIONS(700),
    [anon_sym_u64] = ACTIONS(700),
    [anon_sym_i64] = ACTIONS(700),
    [anon_sym_u128] = ACTIONS(700),
    [anon_sym_i128] = ACTIONS(700),
    [anon_sym_usize] = ACTIONS(700),
    [anon_sym_bool] = ACTIONS(700),
    [anon_sym_ByteArray] = ACTIONS(700),
    [anon_sym_felt252] = ACTIONS(700),
    [anon_sym_LT] = ACTIONS(700),
    [anon_sym_GT] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_SLASH] = ACTIONS(700),
    [anon_sym_PERCENT] = ACTIONS(700),
    [anon_sym_CARET] = ACTIONS(698),
    [anon_sym_TILDE] = ACTIONS(698),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(700),
    [anon_sym_AMP_AMP] = ACTIONS(698),
    [anon_sym_PIPE_PIPE] = ACTIONS(698),
    [anon_sym_LT_LT] = ACTIONS(698),
    [anon_sym_GT_GT] = ACTIONS(698),
    [anon_sym_PLUS_EQ] = ACTIONS(698),
    [anon_sym_DASH_EQ] = ACTIONS(698),
    [anon_sym_STAR_EQ] = ACTIONS(698),
    [anon_sym_SLASH_EQ] = ACTIONS(698),
    [anon_sym_PERCENT_EQ] = ACTIONS(698),
    [anon_sym_EQ_EQ] = ACTIONS(698),
    [anon_sym_BANG_EQ] = ACTIONS(698),
    [anon_sym_GT_EQ] = ACTIONS(698),
    [anon_sym_LT_EQ] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(698),
    [anon_sym_DOT_DOT] = ACTIONS(698),
    [anon_sym_DOT] = ACTIONS(700),
    [anon_sym_QMARK] = ACTIONS(698),
    [anon_sym_break] = ACTIONS(700),
    [anon_sym_continue] = ACTIONS(700),
    [anon_sym_default] = ACTIONS(700),
    [anon_sym_if] = ACTIONS(700),
    [anon_sym_extern] = ACTIONS(700),
    [anon_sym_loop] = ACTIONS(700),
    [anon_sym_match] = ACTIONS(700),
    [anon_sym_pub] = ACTIONS(700),
    [anon_sym_return] = ACTIONS(700),
    [anon_sym_while] = ACTIONS(700),
    [anon_sym_for] = ACTIONS(700),
    [sym_numeric_literal] = ACTIONS(700),
    [aux_sym_string_literal_token1] = ACTIONS(698),
    [sym_shortstring_literal] = ACTIONS(698),
    [anon_sym_true] = ACTIONS(700),
    [anon_sym_false] = ACTIONS(700),
    [anon_sym_move] = ACTIONS(700),
    [anon_sym_ref] = ACTIONS(700),
    [sym_identifier] = ACTIONS(700),
    [sym_super] = ACTIONS(700),
    [sym_line_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(130),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(887),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(130),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(702),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(704),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(706),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(708),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(544),
    [anon_sym_LBRACE] = ACTIONS(544),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_impl] = ACTIONS(546),
    [anon_sym_SEMI] = ACTIONS(544),
    [anon_sym_trait] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(546),
    [anon_sym_const] = ACTIONS(546),
    [anon_sym_EQ] = ACTIONS(546),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_POUND] = ACTIONS(544),
    [anon_sym_LBRACK] = ACTIONS(544),
    [anon_sym_RBRACK] = ACTIONS(544),
    [anon_sym_mod] = ACTIONS(546),
    [anon_sym_struct] = ACTIONS(546),
    [anon_sym_enum] = ACTIONS(546),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_fn] = ACTIONS(546),
    [anon_sym_let] = ACTIONS(546),
    [anon_sym_use] = ACTIONS(546),
    [anon_sym_COLON_COLON] = ACTIONS(544),
    [anon_sym_STAR] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(544),
    [anon_sym_RPAREN] = ACTIONS(544),
    [anon_sym_u8] = ACTIONS(546),
    [anon_sym_i8] = ACTIONS(546),
    [anon_sym_u16] = ACTIONS(546),
    [anon_sym_i16] = ACTIONS(546),
    [anon_sym_u32] = ACTIONS(546),
    [anon_sym_i32] = ACTIONS(546),
    [anon_sym_u64] = ACTIONS(546),
    [anon_sym_i64] = ACTIONS(546),
    [anon_sym_u128] = ACTIONS(546),
    [anon_sym_i128] = ACTIONS(546),
    [anon_sym_usize] = ACTIONS(546),
    [anon_sym_bool] = ACTIONS(546),
    [anon_sym_ByteArray] = ACTIONS(546),
    [anon_sym_felt252] = ACTIONS(546),
    [anon_sym_LT] = ACTIONS(546),
    [anon_sym_GT] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(546),
    [anon_sym_DASH] = ACTIONS(546),
    [anon_sym_SLASH] = ACTIONS(546),
    [anon_sym_PERCENT] = ACTIONS(546),
    [anon_sym_CARET] = ACTIONS(544),
    [anon_sym_TILDE] = ACTIONS(544),
    [anon_sym_AMP] = ACTIONS(546),
    [anon_sym_PIPE] = ACTIONS(546),
    [anon_sym_AMP_AMP] = ACTIONS(544),
    [anon_sym_PIPE_PIPE] = ACTIONS(544),
    [anon_sym_LT_LT] = ACTIONS(544),
    [anon_sym_GT_GT] = ACTIONS(544),
    [anon_sym_PLUS_EQ] = ACTIONS(544),
    [anon_sym_DASH_EQ] = ACTIONS(544),
    [anon_sym_STAR_EQ] = ACTIONS(544),
    [anon_sym_SLASH_EQ] = ACTIONS(544),
    [anon_sym_PERCENT_EQ] = ACTIONS(544),
    [anon_sym_EQ_EQ] = ACTIONS(544),
    [anon_sym_BANG_EQ] = ACTIONS(544),
    [anon_sym_GT_EQ] = ACTIONS(544),
    [anon_sym_LT_EQ] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_DOT_DOT] = ACTIONS(544),
    [anon_sym_DOT] = ACTIONS(546),
    [anon_sym_QMARK] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(546),
    [anon_sym_continue] = ACTIONS(546),
    [anon_sym_default] = ACTIONS(546),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_extern] = ACTIONS(546),
    [anon_sym_loop] = ACTIONS(546),
    [anon_sym_match] = ACTIONS(546),
    [anon_sym_pub] = ACTIONS(546),
    [anon_sym_return] = ACTIONS(546),
    [anon_sym_while] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(546),
    [sym_numeric_literal] = ACTIONS(546),
    [aux_sym_string_literal_token1] = ACTIONS(544),
    [sym_shortstring_literal] = ACTIONS(544),
    [anon_sym_true] = ACTIONS(546),
    [anon_sym_false] = ACTIONS(546),
    [anon_sym_move] = ACTIONS(546),
    [anon_sym_ref] = ACTIONS(546),
    [sym_identifier] = ACTIONS(546),
    [sym_super] = ACTIONS(546),
    [sym_line_comment] = ACTIONS(3),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_RBRACE] = ACTIONS(710),
    [anon_sym_impl] = ACTIONS(712),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_trait] = ACTIONS(712),
    [anon_sym_type] = ACTIONS(712),
    [anon_sym_const] = ACTIONS(712),
    [anon_sym_EQ] = ACTIONS(712),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_POUND] = ACTIONS(710),
    [anon_sym_LBRACK] = ACTIONS(710),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_mod] = ACTIONS(712),
    [anon_sym_struct] = ACTIONS(712),
    [anon_sym_enum] = ACTIONS(712),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_fn] = ACTIONS(712),
    [anon_sym_let] = ACTIONS(712),
    [anon_sym_use] = ACTIONS(712),
    [anon_sym_COLON_COLON] = ACTIONS(710),
    [anon_sym_STAR] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(710),
    [anon_sym_RPAREN] = ACTIONS(710),
    [anon_sym_u8] = ACTIONS(712),
    [anon_sym_i8] = ACTIONS(712),
    [anon_sym_u16] = ACTIONS(712),
    [anon_sym_i16] = ACTIONS(712),
    [anon_sym_u32] = ACTIONS(712),
    [anon_sym_i32] = ACTIONS(712),
    [anon_sym_u64] = ACTIONS(712),
    [anon_sym_i64] = ACTIONS(712),
    [anon_sym_u128] = ACTIONS(712),
    [anon_sym_i128] = ACTIONS(712),
    [anon_sym_usize] = ACTIONS(712),
    [anon_sym_bool] = ACTIONS(712),
    [anon_sym_ByteArray] = ACTIONS(712),
    [anon_sym_felt252] = ACTIONS(712),
    [anon_sym_LT] = ACTIONS(712),
    [anon_sym_GT] = ACTIONS(712),
    [anon_sym_PLUS] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(712),
    [anon_sym_SLASH] = ACTIONS(712),
    [anon_sym_PERCENT] = ACTIONS(712),
    [anon_sym_CARET] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(710),
    [anon_sym_AMP] = ACTIONS(712),
    [anon_sym_PIPE] = ACTIONS(712),
    [anon_sym_AMP_AMP] = ACTIONS(710),
    [anon_sym_PIPE_PIPE] = ACTIONS(710),
    [anon_sym_LT_LT] = ACTIONS(710),
    [anon_sym_GT_GT] = ACTIONS(710),
    [anon_sym_PLUS_EQ] = ACTIONS(710),
    [anon_sym_DASH_EQ] = ACTIONS(710),
    [anon_sym_STAR_EQ] = ACTIONS(710),
    [anon_sym_SLASH_EQ] = ACTIONS(710),
    [anon_sym_PERCENT_EQ] = ACTIONS(710),
    [anon_sym_EQ_EQ] = ACTIONS(710),
    [anon_sym_BANG_EQ] = ACTIONS(710),
    [anon_sym_GT_EQ] = ACTIONS(710),
    [anon_sym_LT_EQ] = ACTIONS(710),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_DOT_DOT] = ACTIONS(710),
    [anon_sym_DOT] = ACTIONS(712),
    [anon_sym_QMARK] = ACTIONS(710),
    [anon_sym_break] = ACTIONS(712),
    [anon_sym_continue] = ACTIONS(712),
    [anon_sym_default] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_extern] = ACTIONS(712),
    [anon_sym_loop] = ACTIONS(712),
    [anon_sym_match] = ACTIONS(712),
    [anon_sym_pub] = ACTIONS(712),
    [anon_sym_return] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [sym_numeric_literal] = ACTIONS(712),
    [aux_sym_string_literal_token1] = ACTIONS(710),
    [sym_shortstring_literal] = ACTIONS(710),
    [anon_sym_true] = ACTIONS(712),
    [anon_sym_false] = ACTIONS(712),
    [anon_sym_move] = ACTIONS(712),
    [anon_sym_ref] = ACTIONS(712),
    [sym_identifier] = ACTIONS(712),
    [sym_super] = ACTIONS(712),
    [sym_line_comment] = ACTIONS(3),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(714),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_RBRACE] = ACTIONS(714),
    [anon_sym_impl] = ACTIONS(716),
    [anon_sym_SEMI] = ACTIONS(714),
    [anon_sym_trait] = ACTIONS(716),
    [anon_sym_type] = ACTIONS(716),
    [anon_sym_const] = ACTIONS(716),
    [anon_sym_EQ] = ACTIONS(716),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_POUND] = ACTIONS(714),
    [anon_sym_LBRACK] = ACTIONS(714),
    [anon_sym_RBRACK] = ACTIONS(714),
    [anon_sym_mod] = ACTIONS(716),
    [anon_sym_struct] = ACTIONS(716),
    [anon_sym_enum] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(714),
    [anon_sym_fn] = ACTIONS(716),
    [anon_sym_let] = ACTIONS(716),
    [anon_sym_use] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(714),
    [anon_sym_STAR] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(714),
    [anon_sym_RPAREN] = ACTIONS(714),
    [anon_sym_u8] = ACTIONS(716),
    [anon_sym_i8] = ACTIONS(716),
    [anon_sym_u16] = ACTIONS(716),
    [anon_sym_i16] = ACTIONS(716),
    [anon_sym_u32] = ACTIONS(716),
    [anon_sym_i32] = ACTIONS(716),
    [anon_sym_u64] = ACTIONS(716),
    [anon_sym_i64] = ACTIONS(716),
    [anon_sym_u128] = ACTIONS(716),
    [anon_sym_i128] = ACTIONS(716),
    [anon_sym_usize] = ACTIONS(716),
    [anon_sym_bool] = ACTIONS(716),
    [anon_sym_ByteArray] = ACTIONS(716),
    [anon_sym_felt252] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(716),
    [anon_sym_GT] = ACTIONS(716),
    [anon_sym_PLUS] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(716),
    [anon_sym_SLASH] = ACTIONS(716),
    [anon_sym_PERCENT] = ACTIONS(716),
    [anon_sym_CARET] = ACTIONS(714),
    [anon_sym_TILDE] = ACTIONS(714),
    [anon_sym_AMP] = ACTIONS(716),
    [anon_sym_PIPE] = ACTIONS(716),
    [anon_sym_AMP_AMP] = ACTIONS(714),
    [anon_sym_PIPE_PIPE] = ACTIONS(714),
    [anon_sym_LT_LT] = ACTIONS(714),
    [anon_sym_GT_GT] = ACTIONS(714),
    [anon_sym_PLUS_EQ] = ACTIONS(714),
    [anon_sym_DASH_EQ] = ACTIONS(714),
    [anon_sym_STAR_EQ] = ACTIONS(714),
    [anon_sym_SLASH_EQ] = ACTIONS(714),
    [anon_sym_PERCENT_EQ] = ACTIONS(714),
    [anon_sym_EQ_EQ] = ACTIONS(714),
    [anon_sym_BANG_EQ] = ACTIONS(714),
    [anon_sym_GT_EQ] = ACTIONS(714),
    [anon_sym_LT_EQ] = ACTIONS(714),
    [anon_sym_AT] = ACTIONS(714),
    [anon_sym_DOT_DOT] = ACTIONS(714),
    [anon_sym_DOT] = ACTIONS(716),
    [anon_sym_QMARK] = ACTIONS(714),
    [anon_sym_break] = ACTIONS(716),
    [anon_sym_continue] = ACTIONS(716),
    [anon_sym_default] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_extern] = ACTIONS(716),
    [anon_sym_loop] = ACTIONS(716),
    [anon_sym_match] = ACTIONS(716),
    [anon_sym_pub] = ACTIONS(716),
    [anon_sym_return] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [sym_numeric_literal] = ACTIONS(716),
    [aux_sym_string_literal_token1] = ACTIONS(714),
    [sym_shortstring_literal] = ACTIONS(714),
    [anon_sym_true] = ACTIONS(716),
    [anon_sym_false] = ACTIONS(716),
    [anon_sym_move] = ACTIONS(716),
    [anon_sym_ref] = ACTIONS(716),
    [sym_identifier] = ACTIONS(716),
    [sym_super] = ACTIONS(716),
    [sym_line_comment] = ACTIONS(3),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(718),
    [anon_sym_LBRACE] = ACTIONS(718),
    [anon_sym_RBRACE] = ACTIONS(718),
    [anon_sym_impl] = ACTIONS(720),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_trait] = ACTIONS(720),
    [anon_sym_type] = ACTIONS(720),
    [anon_sym_const] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(720),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_POUND] = ACTIONS(718),
    [anon_sym_LBRACK] = ACTIONS(718),
    [anon_sym_RBRACK] = ACTIONS(718),
    [anon_sym_mod] = ACTIONS(720),
    [anon_sym_struct] = ACTIONS(720),
    [anon_sym_enum] = ACTIONS(720),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_fn] = ACTIONS(720),
    [anon_sym_let] = ACTIONS(720),
    [anon_sym_use] = ACTIONS(720),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [anon_sym_STAR] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(718),
    [anon_sym_RPAREN] = ACTIONS(718),
    [anon_sym_u8] = ACTIONS(720),
    [anon_sym_i8] = ACTIONS(720),
    [anon_sym_u16] = ACTIONS(720),
    [anon_sym_i16] = ACTIONS(720),
    [anon_sym_u32] = ACTIONS(720),
    [anon_sym_i32] = ACTIONS(720),
    [anon_sym_u64] = ACTIONS(720),
    [anon_sym_i64] = ACTIONS(720),
    [anon_sym_u128] = ACTIONS(720),
    [anon_sym_i128] = ACTIONS(720),
    [anon_sym_usize] = ACTIONS(720),
    [anon_sym_bool] = ACTIONS(720),
    [anon_sym_ByteArray] = ACTIONS(720),
    [anon_sym_felt252] = ACTIONS(720),
    [anon_sym_LT] = ACTIONS(720),
    [anon_sym_GT] = ACTIONS(720),
    [anon_sym_PLUS] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(720),
    [anon_sym_SLASH] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(720),
    [anon_sym_CARET] = ACTIONS(718),
    [anon_sym_TILDE] = ACTIONS(718),
    [anon_sym_AMP] = ACTIONS(720),
    [anon_sym_PIPE] = ACTIONS(720),
    [anon_sym_AMP_AMP] = ACTIONS(718),
    [anon_sym_PIPE_PIPE] = ACTIONS(718),
    [anon_sym_LT_LT] = ACTIONS(718),
    [anon_sym_GT_GT] = ACTIONS(718),
    [anon_sym_PLUS_EQ] = ACTIONS(718),
    [anon_sym_DASH_EQ] = ACTIONS(718),
    [anon_sym_STAR_EQ] = ACTIONS(718),
    [anon_sym_SLASH_EQ] = ACTIONS(718),
    [anon_sym_PERCENT_EQ] = ACTIONS(718),
    [anon_sym_EQ_EQ] = ACTIONS(718),
    [anon_sym_BANG_EQ] = ACTIONS(718),
    [anon_sym_GT_EQ] = ACTIONS(718),
    [anon_sym_LT_EQ] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(718),
    [anon_sym_DOT_DOT] = ACTIONS(718),
    [anon_sym_DOT] = ACTIONS(720),
    [anon_sym_QMARK] = ACTIONS(718),
    [anon_sym_break] = ACTIONS(720),
    [anon_sym_continue] = ACTIONS(720),
    [anon_sym_default] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_extern] = ACTIONS(720),
    [anon_sym_loop] = ACTIONS(720),
    [anon_sym_match] = ACTIONS(720),
    [anon_sym_pub] = ACTIONS(720),
    [anon_sym_return] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [sym_numeric_literal] = ACTIONS(720),
    [aux_sym_string_literal_token1] = ACTIONS(718),
    [sym_shortstring_literal] = ACTIONS(718),
    [anon_sym_true] = ACTIONS(720),
    [anon_sym_false] = ACTIONS(720),
    [anon_sym_move] = ACTIONS(720),
    [anon_sym_ref] = ACTIONS(720),
    [sym_identifier] = ACTIONS(720),
    [sym_super] = ACTIONS(720),
    [sym_line_comment] = ACTIONS(3),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_RBRACE] = ACTIONS(722),
    [anon_sym_impl] = ACTIONS(724),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_trait] = ACTIONS(724),
    [anon_sym_type] = ACTIONS(724),
    [anon_sym_const] = ACTIONS(724),
    [anon_sym_EQ] = ACTIONS(724),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_POUND] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(722),
    [anon_sym_RBRACK] = ACTIONS(722),
    [anon_sym_mod] = ACTIONS(724),
    [anon_sym_struct] = ACTIONS(724),
    [anon_sym_enum] = ACTIONS(724),
    [anon_sym_COMMA] = ACTIONS(722),
    [anon_sym_fn] = ACTIONS(724),
    [anon_sym_let] = ACTIONS(724),
    [anon_sym_use] = ACTIONS(724),
    [anon_sym_COLON_COLON] = ACTIONS(722),
    [anon_sym_STAR] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(722),
    [anon_sym_RPAREN] = ACTIONS(722),
    [anon_sym_u8] = ACTIONS(724),
    [anon_sym_i8] = ACTIONS(724),
    [anon_sym_u16] = ACTIONS(724),
    [anon_sym_i16] = ACTIONS(724),
    [anon_sym_u32] = ACTIONS(724),
    [anon_sym_i32] = ACTIONS(724),
    [anon_sym_u64] = ACTIONS(724),
    [anon_sym_i64] = ACTIONS(724),
    [anon_sym_u128] = ACTIONS(724),
    [anon_sym_i128] = ACTIONS(724),
    [anon_sym_usize] = ACTIONS(724),
    [anon_sym_bool] = ACTIONS(724),
    [anon_sym_ByteArray] = ACTIONS(724),
    [anon_sym_felt252] = ACTIONS(724),
    [anon_sym_LT] = ACTIONS(724),
    [anon_sym_GT] = ACTIONS(724),
    [anon_sym_PLUS] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_SLASH] = ACTIONS(724),
    [anon_sym_PERCENT] = ACTIONS(724),
    [anon_sym_CARET] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(722),
    [anon_sym_AMP] = ACTIONS(724),
    [anon_sym_PIPE] = ACTIONS(724),
    [anon_sym_AMP_AMP] = ACTIONS(722),
    [anon_sym_PIPE_PIPE] = ACTIONS(722),
    [anon_sym_LT_LT] = ACTIONS(722),
    [anon_sym_GT_GT] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(722),
    [anon_sym_DASH_EQ] = ACTIONS(722),
    [anon_sym_STAR_EQ] = ACTIONS(722),
    [anon_sym_SLASH_EQ] = ACTIONS(722),
    [anon_sym_PERCENT_EQ] = ACTIONS(722),
    [anon_sym_EQ_EQ] = ACTIONS(722),
    [anon_sym_BANG_EQ] = ACTIONS(722),
    [anon_sym_GT_EQ] = ACTIONS(722),
    [anon_sym_LT_EQ] = ACTIONS(722),
    [anon_sym_AT] = ACTIONS(722),
    [anon_sym_DOT_DOT] = ACTIONS(722),
    [anon_sym_DOT] = ACTIONS(724),
    [anon_sym_QMARK] = ACTIONS(722),
    [anon_sym_break] = ACTIONS(724),
    [anon_sym_continue] = ACTIONS(724),
    [anon_sym_default] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_extern] = ACTIONS(724),
    [anon_sym_loop] = ACTIONS(724),
    [anon_sym_match] = ACTIONS(724),
    [anon_sym_pub] = ACTIONS(724),
    [anon_sym_return] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [sym_numeric_literal] = ACTIONS(724),
    [aux_sym_string_literal_token1] = ACTIONS(722),
    [sym_shortstring_literal] = ACTIONS(722),
    [anon_sym_true] = ACTIONS(724),
    [anon_sym_false] = ACTIONS(724),
    [anon_sym_move] = ACTIONS(724),
    [anon_sym_ref] = ACTIONS(724),
    [sym_identifier] = ACTIONS(724),
    [sym_super] = ACTIONS(724),
    [sym_line_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(726),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_RBRACE] = ACTIONS(728),
    [anon_sym_impl] = ACTIONS(730),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_trait] = ACTIONS(730),
    [anon_sym_type] = ACTIONS(730),
    [anon_sym_const] = ACTIONS(730),
    [anon_sym_EQ] = ACTIONS(730),
    [anon_sym_BANG] = ACTIONS(730),
    [anon_sym_POUND] = ACTIONS(728),
    [anon_sym_LBRACK] = ACTIONS(728),
    [anon_sym_RBRACK] = ACTIONS(728),
    [anon_sym_mod] = ACTIONS(730),
    [anon_sym_struct] = ACTIONS(730),
    [anon_sym_enum] = ACTIONS(730),
    [anon_sym_COMMA] = ACTIONS(728),
    [anon_sym_fn] = ACTIONS(730),
    [anon_sym_let] = ACTIONS(730),
    [anon_sym_use] = ACTIONS(730),
    [anon_sym_COLON_COLON] = ACTIONS(728),
    [anon_sym_STAR] = ACTIONS(730),
    [anon_sym_LPAREN] = ACTIONS(728),
    [anon_sym_RPAREN] = ACTIONS(728),
    [anon_sym_u8] = ACTIONS(730),
    [anon_sym_i8] = ACTIONS(730),
    [anon_sym_u16] = ACTIONS(730),
    [anon_sym_i16] = ACTIONS(730),
    [anon_sym_u32] = ACTIONS(730),
    [anon_sym_i32] = ACTIONS(730),
    [anon_sym_u64] = ACTIONS(730),
    [anon_sym_i64] = ACTIONS(730),
    [anon_sym_u128] = ACTIONS(730),
    [anon_sym_i128] = ACTIONS(730),
    [anon_sym_usize] = ACTIONS(730),
    [anon_sym_bool] = ACTIONS(730),
    [anon_sym_ByteArray] = ACTIONS(730),
    [anon_sym_felt252] = ACTIONS(730),
    [anon_sym_LT] = ACTIONS(730),
    [anon_sym_GT] = ACTIONS(730),
    [anon_sym_PLUS] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(730),
    [anon_sym_SLASH] = ACTIONS(730),
    [anon_sym_PERCENT] = ACTIONS(730),
    [anon_sym_CARET] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(728),
    [anon_sym_AMP] = ACTIONS(730),
    [anon_sym_PIPE] = ACTIONS(730),
    [anon_sym_AMP_AMP] = ACTIONS(728),
    [anon_sym_PIPE_PIPE] = ACTIONS(728),
    [anon_sym_LT_LT] = ACTIONS(728),
    [anon_sym_GT_GT] = ACTIONS(728),
    [anon_sym_PLUS_EQ] = ACTIONS(728),
    [anon_sym_DASH_EQ] = ACTIONS(728),
    [anon_sym_STAR_EQ] = ACTIONS(728),
    [anon_sym_SLASH_EQ] = ACTIONS(728),
    [anon_sym_PERCENT_EQ] = ACTIONS(728),
    [anon_sym_EQ_EQ] = ACTIONS(728),
    [anon_sym_BANG_EQ] = ACTIONS(728),
    [anon_sym_GT_EQ] = ACTIONS(728),
    [anon_sym_LT_EQ] = ACTIONS(728),
    [anon_sym_AT] = ACTIONS(728),
    [anon_sym_DOT_DOT] = ACTIONS(728),
    [anon_sym_DOT] = ACTIONS(730),
    [anon_sym_QMARK] = ACTIONS(728),
    [anon_sym_break] = ACTIONS(730),
    [anon_sym_continue] = ACTIONS(730),
    [anon_sym_default] = ACTIONS(730),
    [anon_sym_if] = ACTIONS(730),
    [anon_sym_extern] = ACTIONS(730),
    [anon_sym_loop] = ACTIONS(730),
    [anon_sym_match] = ACTIONS(730),
    [anon_sym_pub] = ACTIONS(730),
    [anon_sym_return] = ACTIONS(730),
    [anon_sym_while] = ACTIONS(730),
    [anon_sym_for] = ACTIONS(730),
    [sym_numeric_literal] = ACTIONS(730),
    [aux_sym_string_literal_token1] = ACTIONS(728),
    [sym_shortstring_literal] = ACTIONS(728),
    [anon_sym_true] = ACTIONS(730),
    [anon_sym_false] = ACTIONS(730),
    [anon_sym_move] = ACTIONS(730),
    [anon_sym_ref] = ACTIONS(730),
    [sym_identifier] = ACTIONS(730),
    [sym_super] = ACTIONS(730),
    [sym_line_comment] = ACTIONS(3),
  },
  [120] = {
    [ts_builtin_sym_end] = ACTIONS(732),
    [anon_sym_LBRACE] = ACTIONS(732),
    [anon_sym_RBRACE] = ACTIONS(732),
    [anon_sym_impl] = ACTIONS(734),
    [anon_sym_SEMI] = ACTIONS(732),
    [anon_sym_trait] = ACTIONS(734),
    [anon_sym_type] = ACTIONS(734),
    [anon_sym_const] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(734),
    [anon_sym_POUND] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(732),
    [anon_sym_RBRACK] = ACTIONS(732),
    [anon_sym_mod] = ACTIONS(734),
    [anon_sym_struct] = ACTIONS(734),
    [anon_sym_enum] = ACTIONS(734),
    [anon_sym_COMMA] = ACTIONS(732),
    [anon_sym_fn] = ACTIONS(734),
    [anon_sym_let] = ACTIONS(734),
    [anon_sym_use] = ACTIONS(734),
    [anon_sym_COLON_COLON] = ACTIONS(732),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_LPAREN] = ACTIONS(732),
    [anon_sym_RPAREN] = ACTIONS(732),
    [anon_sym_u8] = ACTIONS(734),
    [anon_sym_i8] = ACTIONS(734),
    [anon_sym_u16] = ACTIONS(734),
    [anon_sym_i16] = ACTIONS(734),
    [anon_sym_u32] = ACTIONS(734),
    [anon_sym_i32] = ACTIONS(734),
    [anon_sym_u64] = ACTIONS(734),
    [anon_sym_i64] = ACTIONS(734),
    [anon_sym_u128] = ACTIONS(734),
    [anon_sym_i128] = ACTIONS(734),
    [anon_sym_usize] = ACTIONS(734),
    [anon_sym_bool] = ACTIONS(734),
    [anon_sym_ByteArray] = ACTIONS(734),
    [anon_sym_felt252] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(734),
    [anon_sym_GT] = ACTIONS(734),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_DASH] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(732),
    [anon_sym_AMP] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(734),
    [anon_sym_AMP_AMP] = ACTIONS(732),
    [anon_sym_PIPE_PIPE] = ACTIONS(732),
    [anon_sym_LT_LT] = ACTIONS(732),
    [anon_sym_GT_GT] = ACTIONS(732),
    [anon_sym_PLUS_EQ] = ACTIONS(732),
    [anon_sym_DASH_EQ] = ACTIONS(732),
    [anon_sym_STAR_EQ] = ACTIONS(732),
    [anon_sym_SLASH_EQ] = ACTIONS(732),
    [anon_sym_PERCENT_EQ] = ACTIONS(732),
    [anon_sym_EQ_EQ] = ACTIONS(732),
    [anon_sym_BANG_EQ] = ACTIONS(732),
    [anon_sym_GT_EQ] = ACTIONS(732),
    [anon_sym_LT_EQ] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(732),
    [anon_sym_DOT_DOT] = ACTIONS(732),
    [anon_sym_DOT] = ACTIONS(734),
    [anon_sym_QMARK] = ACTIONS(732),
    [anon_sym_break] = ACTIONS(734),
    [anon_sym_continue] = ACTIONS(734),
    [anon_sym_default] = ACTIONS(734),
    [anon_sym_if] = ACTIONS(734),
    [anon_sym_extern] = ACTIONS(734),
    [anon_sym_loop] = ACTIONS(734),
    [anon_sym_match] = ACTIONS(734),
    [anon_sym_pub] = ACTIONS(734),
    [anon_sym_return] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(734),
    [anon_sym_for] = ACTIONS(734),
    [sym_numeric_literal] = ACTIONS(734),
    [aux_sym_string_literal_token1] = ACTIONS(732),
    [sym_shortstring_literal] = ACTIONS(732),
    [anon_sym_true] = ACTIONS(734),
    [anon_sym_false] = ACTIONS(734),
    [anon_sym_move] = ACTIONS(734),
    [anon_sym_ref] = ACTIONS(734),
    [sym_identifier] = ACTIONS(734),
    [sym_super] = ACTIONS(734),
    [sym_line_comment] = ACTIONS(3),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_impl] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_trait] = ACTIONS(738),
    [anon_sym_type] = ACTIONS(738),
    [anon_sym_const] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_POUND] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(736),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_mod] = ACTIONS(738),
    [anon_sym_struct] = ACTIONS(738),
    [anon_sym_enum] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(736),
    [anon_sym_fn] = ACTIONS(738),
    [anon_sym_let] = ACTIONS(738),
    [anon_sym_use] = ACTIONS(738),
    [anon_sym_COLON_COLON] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(736),
    [anon_sym_RPAREN] = ACTIONS(736),
    [anon_sym_u8] = ACTIONS(738),
    [anon_sym_i8] = ACTIONS(738),
    [anon_sym_u16] = ACTIONS(738),
    [anon_sym_i16] = ACTIONS(738),
    [anon_sym_u32] = ACTIONS(738),
    [anon_sym_i32] = ACTIONS(738),
    [anon_sym_u64] = ACTIONS(738),
    [anon_sym_i64] = ACTIONS(738),
    [anon_sym_u128] = ACTIONS(738),
    [anon_sym_i128] = ACTIONS(738),
    [anon_sym_usize] = ACTIONS(738),
    [anon_sym_bool] = ACTIONS(738),
    [anon_sym_ByteArray] = ACTIONS(738),
    [anon_sym_felt252] = ACTIONS(738),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(738),
    [anon_sym_SLASH] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(738),
    [anon_sym_CARET] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(738),
    [anon_sym_PIPE] = ACTIONS(738),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_LT_LT] = ACTIONS(736),
    [anon_sym_GT_GT] = ACTIONS(736),
    [anon_sym_PLUS_EQ] = ACTIONS(736),
    [anon_sym_DASH_EQ] = ACTIONS(736),
    [anon_sym_STAR_EQ] = ACTIONS(736),
    [anon_sym_SLASH_EQ] = ACTIONS(736),
    [anon_sym_PERCENT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_AT] = ACTIONS(736),
    [anon_sym_DOT_DOT] = ACTIONS(736),
    [anon_sym_DOT] = ACTIONS(738),
    [anon_sym_QMARK] = ACTIONS(736),
    [anon_sym_break] = ACTIONS(738),
    [anon_sym_continue] = ACTIONS(738),
    [anon_sym_default] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_extern] = ACTIONS(738),
    [anon_sym_loop] = ACTIONS(738),
    [anon_sym_match] = ACTIONS(738),
    [anon_sym_pub] = ACTIONS(738),
    [anon_sym_return] = ACTIONS(738),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [sym_numeric_literal] = ACTIONS(738),
    [aux_sym_string_literal_token1] = ACTIONS(736),
    [sym_shortstring_literal] = ACTIONS(736),
    [anon_sym_true] = ACTIONS(738),
    [anon_sym_false] = ACTIONS(738),
    [anon_sym_move] = ACTIONS(738),
    [anon_sym_ref] = ACTIONS(738),
    [sym_identifier] = ACTIONS(738),
    [sym_super] = ACTIONS(738),
    [sym_line_comment] = ACTIONS(3),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_impl] = ACTIONS(742),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_trait] = ACTIONS(742),
    [anon_sym_type] = ACTIONS(742),
    [anon_sym_const] = ACTIONS(742),
    [anon_sym_EQ] = ACTIONS(742),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_LBRACK] = ACTIONS(740),
    [anon_sym_RBRACK] = ACTIONS(740),
    [anon_sym_mod] = ACTIONS(742),
    [anon_sym_struct] = ACTIONS(742),
    [anon_sym_enum] = ACTIONS(742),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_fn] = ACTIONS(742),
    [anon_sym_let] = ACTIONS(742),
    [anon_sym_use] = ACTIONS(742),
    [anon_sym_COLON_COLON] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(742),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [anon_sym_u8] = ACTIONS(742),
    [anon_sym_i8] = ACTIONS(742),
    [anon_sym_u16] = ACTIONS(742),
    [anon_sym_i16] = ACTIONS(742),
    [anon_sym_u32] = ACTIONS(742),
    [anon_sym_i32] = ACTIONS(742),
    [anon_sym_u64] = ACTIONS(742),
    [anon_sym_i64] = ACTIONS(742),
    [anon_sym_u128] = ACTIONS(742),
    [anon_sym_i128] = ACTIONS(742),
    [anon_sym_usize] = ACTIONS(742),
    [anon_sym_bool] = ACTIONS(742),
    [anon_sym_ByteArray] = ACTIONS(742),
    [anon_sym_felt252] = ACTIONS(742),
    [anon_sym_LT] = ACTIONS(742),
    [anon_sym_GT] = ACTIONS(742),
    [anon_sym_PLUS] = ACTIONS(742),
    [anon_sym_DASH] = ACTIONS(742),
    [anon_sym_SLASH] = ACTIONS(742),
    [anon_sym_PERCENT] = ACTIONS(742),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_PIPE] = ACTIONS(742),
    [anon_sym_AMP_AMP] = ACTIONS(740),
    [anon_sym_PIPE_PIPE] = ACTIONS(740),
    [anon_sym_LT_LT] = ACTIONS(740),
    [anon_sym_GT_GT] = ACTIONS(740),
    [anon_sym_PLUS_EQ] = ACTIONS(740),
    [anon_sym_DASH_EQ] = ACTIONS(740),
    [anon_sym_STAR_EQ] = ACTIONS(740),
    [anon_sym_SLASH_EQ] = ACTIONS(740),
    [anon_sym_PERCENT_EQ] = ACTIONS(740),
    [anon_sym_EQ_EQ] = ACTIONS(740),
    [anon_sym_BANG_EQ] = ACTIONS(740),
    [anon_sym_GT_EQ] = ACTIONS(740),
    [anon_sym_LT_EQ] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_DOT_DOT] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(742),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_break] = ACTIONS(742),
    [anon_sym_continue] = ACTIONS(742),
    [anon_sym_default] = ACTIONS(742),
    [anon_sym_if] = ACTIONS(742),
    [anon_sym_extern] = ACTIONS(742),
    [anon_sym_loop] = ACTIONS(742),
    [anon_sym_match] = ACTIONS(742),
    [anon_sym_pub] = ACTIONS(742),
    [anon_sym_return] = ACTIONS(742),
    [anon_sym_while] = ACTIONS(742),
    [anon_sym_for] = ACTIONS(742),
    [sym_numeric_literal] = ACTIONS(742),
    [aux_sym_string_literal_token1] = ACTIONS(740),
    [sym_shortstring_literal] = ACTIONS(740),
    [anon_sym_true] = ACTIONS(742),
    [anon_sym_false] = ACTIONS(742),
    [anon_sym_move] = ACTIONS(742),
    [anon_sym_ref] = ACTIONS(742),
    [sym_identifier] = ACTIONS(742),
    [sym_super] = ACTIONS(742),
    [sym_line_comment] = ACTIONS(3),
  },
  [123] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(744),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(746),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_RBRACE] = ACTIONS(746),
    [anon_sym_impl] = ACTIONS(748),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_trait] = ACTIONS(748),
    [anon_sym_type] = ACTIONS(748),
    [anon_sym_const] = ACTIONS(748),
    [anon_sym_EQ] = ACTIONS(748),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_POUND] = ACTIONS(746),
    [anon_sym_LBRACK] = ACTIONS(746),
    [anon_sym_RBRACK] = ACTIONS(746),
    [anon_sym_mod] = ACTIONS(748),
    [anon_sym_struct] = ACTIONS(748),
    [anon_sym_enum] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_fn] = ACTIONS(748),
    [anon_sym_let] = ACTIONS(748),
    [anon_sym_use] = ACTIONS(748),
    [anon_sym_COLON_COLON] = ACTIONS(746),
    [anon_sym_STAR] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(746),
    [anon_sym_RPAREN] = ACTIONS(746),
    [anon_sym_u8] = ACTIONS(748),
    [anon_sym_i8] = ACTIONS(748),
    [anon_sym_u16] = ACTIONS(748),
    [anon_sym_i16] = ACTIONS(748),
    [anon_sym_u32] = ACTIONS(748),
    [anon_sym_i32] = ACTIONS(748),
    [anon_sym_u64] = ACTIONS(748),
    [anon_sym_i64] = ACTIONS(748),
    [anon_sym_u128] = ACTIONS(748),
    [anon_sym_i128] = ACTIONS(748),
    [anon_sym_usize] = ACTIONS(748),
    [anon_sym_bool] = ACTIONS(748),
    [anon_sym_ByteArray] = ACTIONS(748),
    [anon_sym_felt252] = ACTIONS(748),
    [anon_sym_LT] = ACTIONS(748),
    [anon_sym_GT] = ACTIONS(748),
    [anon_sym_PLUS] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(748),
    [anon_sym_SLASH] = ACTIONS(748),
    [anon_sym_PERCENT] = ACTIONS(748),
    [anon_sym_CARET] = ACTIONS(746),
    [anon_sym_TILDE] = ACTIONS(746),
    [anon_sym_AMP] = ACTIONS(748),
    [anon_sym_PIPE] = ACTIONS(748),
    [anon_sym_AMP_AMP] = ACTIONS(746),
    [anon_sym_PIPE_PIPE] = ACTIONS(746),
    [anon_sym_LT_LT] = ACTIONS(746),
    [anon_sym_GT_GT] = ACTIONS(746),
    [anon_sym_PLUS_EQ] = ACTIONS(746),
    [anon_sym_DASH_EQ] = ACTIONS(746),
    [anon_sym_STAR_EQ] = ACTIONS(746),
    [anon_sym_SLASH_EQ] = ACTIONS(746),
    [anon_sym_PERCENT_EQ] = ACTIONS(746),
    [anon_sym_EQ_EQ] = ACTIONS(746),
    [anon_sym_BANG_EQ] = ACTIONS(746),
    [anon_sym_GT_EQ] = ACTIONS(746),
    [anon_sym_LT_EQ] = ACTIONS(746),
    [anon_sym_AT] = ACTIONS(746),
    [anon_sym_DOT_DOT] = ACTIONS(746),
    [anon_sym_DOT] = ACTIONS(748),
    [anon_sym_QMARK] = ACTIONS(746),
    [anon_sym_break] = ACTIONS(748),
    [anon_sym_continue] = ACTIONS(748),
    [anon_sym_default] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_extern] = ACTIONS(748),
    [anon_sym_loop] = ACTIONS(748),
    [anon_sym_match] = ACTIONS(748),
    [anon_sym_pub] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [sym_numeric_literal] = ACTIONS(748),
    [aux_sym_string_literal_token1] = ACTIONS(746),
    [sym_shortstring_literal] = ACTIONS(746),
    [anon_sym_true] = ACTIONS(748),
    [anon_sym_false] = ACTIONS(748),
    [anon_sym_move] = ACTIONS(748),
    [anon_sym_ref] = ACTIONS(748),
    [sym_identifier] = ACTIONS(748),
    [sym_super] = ACTIONS(748),
    [sym_line_comment] = ACTIONS(3),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(750),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_RBRACE] = ACTIONS(750),
    [anon_sym_impl] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [anon_sym_trait] = ACTIONS(752),
    [anon_sym_type] = ACTIONS(752),
    [anon_sym_const] = ACTIONS(752),
    [anon_sym_EQ] = ACTIONS(752),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_POUND] = ACTIONS(750),
    [anon_sym_LBRACK] = ACTIONS(750),
    [anon_sym_RBRACK] = ACTIONS(750),
    [anon_sym_mod] = ACTIONS(752),
    [anon_sym_struct] = ACTIONS(752),
    [anon_sym_enum] = ACTIONS(752),
    [anon_sym_COMMA] = ACTIONS(750),
    [anon_sym_fn] = ACTIONS(752),
    [anon_sym_let] = ACTIONS(752),
    [anon_sym_use] = ACTIONS(752),
    [anon_sym_COLON_COLON] = ACTIONS(750),
    [anon_sym_STAR] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(750),
    [anon_sym_RPAREN] = ACTIONS(750),
    [anon_sym_u8] = ACTIONS(752),
    [anon_sym_i8] = ACTIONS(752),
    [anon_sym_u16] = ACTIONS(752),
    [anon_sym_i16] = ACTIONS(752),
    [anon_sym_u32] = ACTIONS(752),
    [anon_sym_i32] = ACTIONS(752),
    [anon_sym_u64] = ACTIONS(752),
    [anon_sym_i64] = ACTIONS(752),
    [anon_sym_u128] = ACTIONS(752),
    [anon_sym_i128] = ACTIONS(752),
    [anon_sym_usize] = ACTIONS(752),
    [anon_sym_bool] = ACTIONS(752),
    [anon_sym_ByteArray] = ACTIONS(752),
    [anon_sym_felt252] = ACTIONS(752),
    [anon_sym_LT] = ACTIONS(752),
    [anon_sym_GT] = ACTIONS(752),
    [anon_sym_PLUS] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(752),
    [anon_sym_SLASH] = ACTIONS(752),
    [anon_sym_PERCENT] = ACTIONS(752),
    [anon_sym_CARET] = ACTIONS(750),
    [anon_sym_TILDE] = ACTIONS(750),
    [anon_sym_AMP] = ACTIONS(752),
    [anon_sym_PIPE] = ACTIONS(752),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_PLUS_EQ] = ACTIONS(750),
    [anon_sym_DASH_EQ] = ACTIONS(750),
    [anon_sym_STAR_EQ] = ACTIONS(750),
    [anon_sym_SLASH_EQ] = ACTIONS(750),
    [anon_sym_PERCENT_EQ] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(750),
    [anon_sym_BANG_EQ] = ACTIONS(750),
    [anon_sym_GT_EQ] = ACTIONS(750),
    [anon_sym_LT_EQ] = ACTIONS(750),
    [anon_sym_AT] = ACTIONS(750),
    [anon_sym_DOT_DOT] = ACTIONS(750),
    [anon_sym_DOT] = ACTIONS(752),
    [anon_sym_QMARK] = ACTIONS(750),
    [anon_sym_break] = ACTIONS(752),
    [anon_sym_continue] = ACTIONS(752),
    [anon_sym_default] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_extern] = ACTIONS(752),
    [anon_sym_loop] = ACTIONS(752),
    [anon_sym_match] = ACTIONS(752),
    [anon_sym_pub] = ACTIONS(752),
    [anon_sym_return] = ACTIONS(752),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [sym_numeric_literal] = ACTIONS(752),
    [aux_sym_string_literal_token1] = ACTIONS(750),
    [sym_shortstring_literal] = ACTIONS(750),
    [anon_sym_true] = ACTIONS(752),
    [anon_sym_false] = ACTIONS(752),
    [anon_sym_move] = ACTIONS(752),
    [anon_sym_ref] = ACTIONS(752),
    [sym_identifier] = ACTIONS(752),
    [sym_super] = ACTIONS(752),
    [sym_line_comment] = ACTIONS(3),
  },
  [126] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(141),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(858),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(141),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(754),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [127] = {
    [ts_builtin_sym_end] = ACTIONS(756),
    [anon_sym_LBRACE] = ACTIONS(756),
    [anon_sym_RBRACE] = ACTIONS(756),
    [anon_sym_impl] = ACTIONS(758),
    [anon_sym_SEMI] = ACTIONS(756),
    [anon_sym_trait] = ACTIONS(758),
    [anon_sym_type] = ACTIONS(758),
    [anon_sym_const] = ACTIONS(758),
    [anon_sym_EQ] = ACTIONS(758),
    [anon_sym_BANG] = ACTIONS(758),
    [anon_sym_POUND] = ACTIONS(756),
    [anon_sym_LBRACK] = ACTIONS(756),
    [anon_sym_RBRACK] = ACTIONS(756),
    [anon_sym_mod] = ACTIONS(758),
    [anon_sym_struct] = ACTIONS(758),
    [anon_sym_enum] = ACTIONS(758),
    [anon_sym_COMMA] = ACTIONS(756),
    [anon_sym_fn] = ACTIONS(758),
    [anon_sym_let] = ACTIONS(758),
    [anon_sym_use] = ACTIONS(758),
    [anon_sym_COLON_COLON] = ACTIONS(756),
    [anon_sym_STAR] = ACTIONS(758),
    [anon_sym_LPAREN] = ACTIONS(756),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_u8] = ACTIONS(758),
    [anon_sym_i8] = ACTIONS(758),
    [anon_sym_u16] = ACTIONS(758),
    [anon_sym_i16] = ACTIONS(758),
    [anon_sym_u32] = ACTIONS(758),
    [anon_sym_i32] = ACTIONS(758),
    [anon_sym_u64] = ACTIONS(758),
    [anon_sym_i64] = ACTIONS(758),
    [anon_sym_u128] = ACTIONS(758),
    [anon_sym_i128] = ACTIONS(758),
    [anon_sym_usize] = ACTIONS(758),
    [anon_sym_bool] = ACTIONS(758),
    [anon_sym_ByteArray] = ACTIONS(758),
    [anon_sym_felt252] = ACTIONS(758),
    [anon_sym_LT] = ACTIONS(758),
    [anon_sym_GT] = ACTIONS(758),
    [anon_sym_PLUS] = ACTIONS(758),
    [anon_sym_DASH] = ACTIONS(758),
    [anon_sym_SLASH] = ACTIONS(758),
    [anon_sym_PERCENT] = ACTIONS(758),
    [anon_sym_CARET] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(756),
    [anon_sym_AMP] = ACTIONS(758),
    [anon_sym_PIPE] = ACTIONS(758),
    [anon_sym_AMP_AMP] = ACTIONS(756),
    [anon_sym_PIPE_PIPE] = ACTIONS(756),
    [anon_sym_LT_LT] = ACTIONS(756),
    [anon_sym_GT_GT] = ACTIONS(756),
    [anon_sym_PLUS_EQ] = ACTIONS(756),
    [anon_sym_DASH_EQ] = ACTIONS(756),
    [anon_sym_STAR_EQ] = ACTIONS(756),
    [anon_sym_SLASH_EQ] = ACTIONS(756),
    [anon_sym_PERCENT_EQ] = ACTIONS(756),
    [anon_sym_EQ_EQ] = ACTIONS(756),
    [anon_sym_BANG_EQ] = ACTIONS(756),
    [anon_sym_GT_EQ] = ACTIONS(756),
    [anon_sym_LT_EQ] = ACTIONS(756),
    [anon_sym_AT] = ACTIONS(756),
    [anon_sym_DOT_DOT] = ACTIONS(756),
    [anon_sym_DOT] = ACTIONS(758),
    [anon_sym_QMARK] = ACTIONS(756),
    [anon_sym_break] = ACTIONS(758),
    [anon_sym_continue] = ACTIONS(758),
    [anon_sym_default] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(758),
    [anon_sym_extern] = ACTIONS(758),
    [anon_sym_loop] = ACTIONS(758),
    [anon_sym_match] = ACTIONS(758),
    [anon_sym_pub] = ACTIONS(758),
    [anon_sym_return] = ACTIONS(758),
    [anon_sym_while] = ACTIONS(758),
    [anon_sym_for] = ACTIONS(758),
    [sym_numeric_literal] = ACTIONS(758),
    [aux_sym_string_literal_token1] = ACTIONS(756),
    [sym_shortstring_literal] = ACTIONS(756),
    [anon_sym_true] = ACTIONS(758),
    [anon_sym_false] = ACTIONS(758),
    [anon_sym_move] = ACTIONS(758),
    [anon_sym_ref] = ACTIONS(758),
    [sym_identifier] = ACTIONS(758),
    [sym_super] = ACTIONS(758),
    [sym_line_comment] = ACTIONS(3),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(760),
    [anon_sym_LBRACE] = ACTIONS(760),
    [anon_sym_RBRACE] = ACTIONS(760),
    [anon_sym_impl] = ACTIONS(762),
    [anon_sym_SEMI] = ACTIONS(760),
    [anon_sym_trait] = ACTIONS(762),
    [anon_sym_type] = ACTIONS(762),
    [anon_sym_const] = ACTIONS(762),
    [anon_sym_EQ] = ACTIONS(762),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_POUND] = ACTIONS(760),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_RBRACK] = ACTIONS(760),
    [anon_sym_mod] = ACTIONS(762),
    [anon_sym_struct] = ACTIONS(762),
    [anon_sym_enum] = ACTIONS(762),
    [anon_sym_COMMA] = ACTIONS(760),
    [anon_sym_fn] = ACTIONS(762),
    [anon_sym_let] = ACTIONS(762),
    [anon_sym_use] = ACTIONS(762),
    [anon_sym_COLON_COLON] = ACTIONS(760),
    [anon_sym_STAR] = ACTIONS(762),
    [anon_sym_LPAREN] = ACTIONS(760),
    [anon_sym_RPAREN] = ACTIONS(760),
    [anon_sym_u8] = ACTIONS(762),
    [anon_sym_i8] = ACTIONS(762),
    [anon_sym_u16] = ACTIONS(762),
    [anon_sym_i16] = ACTIONS(762),
    [anon_sym_u32] = ACTIONS(762),
    [anon_sym_i32] = ACTIONS(762),
    [anon_sym_u64] = ACTIONS(762),
    [anon_sym_i64] = ACTIONS(762),
    [anon_sym_u128] = ACTIONS(762),
    [anon_sym_i128] = ACTIONS(762),
    [anon_sym_usize] = ACTIONS(762),
    [anon_sym_bool] = ACTIONS(762),
    [anon_sym_ByteArray] = ACTIONS(762),
    [anon_sym_felt252] = ACTIONS(762),
    [anon_sym_LT] = ACTIONS(762),
    [anon_sym_GT] = ACTIONS(762),
    [anon_sym_PLUS] = ACTIONS(762),
    [anon_sym_DASH] = ACTIONS(762),
    [anon_sym_SLASH] = ACTIONS(762),
    [anon_sym_PERCENT] = ACTIONS(762),
    [anon_sym_CARET] = ACTIONS(760),
    [anon_sym_TILDE] = ACTIONS(760),
    [anon_sym_AMP] = ACTIONS(762),
    [anon_sym_PIPE] = ACTIONS(762),
    [anon_sym_AMP_AMP] = ACTIONS(760),
    [anon_sym_PIPE_PIPE] = ACTIONS(760),
    [anon_sym_LT_LT] = ACTIONS(760),
    [anon_sym_GT_GT] = ACTIONS(760),
    [anon_sym_PLUS_EQ] = ACTIONS(760),
    [anon_sym_DASH_EQ] = ACTIONS(760),
    [anon_sym_STAR_EQ] = ACTIONS(760),
    [anon_sym_SLASH_EQ] = ACTIONS(760),
    [anon_sym_PERCENT_EQ] = ACTIONS(760),
    [anon_sym_EQ_EQ] = ACTIONS(760),
    [anon_sym_BANG_EQ] = ACTIONS(760),
    [anon_sym_GT_EQ] = ACTIONS(760),
    [anon_sym_LT_EQ] = ACTIONS(760),
    [anon_sym_AT] = ACTIONS(760),
    [anon_sym_DOT_DOT] = ACTIONS(760),
    [anon_sym_DOT] = ACTIONS(762),
    [anon_sym_QMARK] = ACTIONS(760),
    [anon_sym_break] = ACTIONS(762),
    [anon_sym_continue] = ACTIONS(762),
    [anon_sym_default] = ACTIONS(762),
    [anon_sym_if] = ACTIONS(762),
    [anon_sym_extern] = ACTIONS(762),
    [anon_sym_loop] = ACTIONS(762),
    [anon_sym_match] = ACTIONS(762),
    [anon_sym_pub] = ACTIONS(762),
    [anon_sym_return] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(762),
    [anon_sym_for] = ACTIONS(762),
    [sym_numeric_literal] = ACTIONS(762),
    [aux_sym_string_literal_token1] = ACTIONS(760),
    [sym_shortstring_literal] = ACTIONS(760),
    [anon_sym_true] = ACTIONS(762),
    [anon_sym_false] = ACTIONS(762),
    [anon_sym_move] = ACTIONS(762),
    [anon_sym_ref] = ACTIONS(762),
    [sym_identifier] = ACTIONS(762),
    [sym_super] = ACTIONS(762),
    [sym_line_comment] = ACTIONS(3),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(540),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_impl] = ACTIONS(542),
    [anon_sym_SEMI] = ACTIONS(540),
    [anon_sym_trait] = ACTIONS(542),
    [anon_sym_type] = ACTIONS(542),
    [anon_sym_const] = ACTIONS(542),
    [anon_sym_EQ] = ACTIONS(542),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_POUND] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(540),
    [anon_sym_RBRACK] = ACTIONS(540),
    [anon_sym_mod] = ACTIONS(542),
    [anon_sym_struct] = ACTIONS(542),
    [anon_sym_enum] = ACTIONS(542),
    [anon_sym_COMMA] = ACTIONS(540),
    [anon_sym_fn] = ACTIONS(542),
    [anon_sym_let] = ACTIONS(542),
    [anon_sym_use] = ACTIONS(542),
    [anon_sym_COLON_COLON] = ACTIONS(540),
    [anon_sym_STAR] = ACTIONS(542),
    [anon_sym_LPAREN] = ACTIONS(540),
    [anon_sym_RPAREN] = ACTIONS(540),
    [anon_sym_u8] = ACTIONS(542),
    [anon_sym_i8] = ACTIONS(542),
    [anon_sym_u16] = ACTIONS(542),
    [anon_sym_i16] = ACTIONS(542),
    [anon_sym_u32] = ACTIONS(542),
    [anon_sym_i32] = ACTIONS(542),
    [anon_sym_u64] = ACTIONS(542),
    [anon_sym_i64] = ACTIONS(542),
    [anon_sym_u128] = ACTIONS(542),
    [anon_sym_i128] = ACTIONS(542),
    [anon_sym_usize] = ACTIONS(542),
    [anon_sym_bool] = ACTIONS(542),
    [anon_sym_ByteArray] = ACTIONS(542),
    [anon_sym_felt252] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(542),
    [anon_sym_GT] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(542),
    [anon_sym_DASH] = ACTIONS(542),
    [anon_sym_SLASH] = ACTIONS(542),
    [anon_sym_PERCENT] = ACTIONS(542),
    [anon_sym_CARET] = ACTIONS(540),
    [anon_sym_TILDE] = ACTIONS(540),
    [anon_sym_AMP] = ACTIONS(542),
    [anon_sym_PIPE] = ACTIONS(542),
    [anon_sym_AMP_AMP] = ACTIONS(540),
    [anon_sym_PIPE_PIPE] = ACTIONS(540),
    [anon_sym_LT_LT] = ACTIONS(540),
    [anon_sym_GT_GT] = ACTIONS(540),
    [anon_sym_PLUS_EQ] = ACTIONS(540),
    [anon_sym_DASH_EQ] = ACTIONS(540),
    [anon_sym_STAR_EQ] = ACTIONS(540),
    [anon_sym_SLASH_EQ] = ACTIONS(540),
    [anon_sym_PERCENT_EQ] = ACTIONS(540),
    [anon_sym_EQ_EQ] = ACTIONS(540),
    [anon_sym_BANG_EQ] = ACTIONS(540),
    [anon_sym_GT_EQ] = ACTIONS(540),
    [anon_sym_LT_EQ] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(540),
    [anon_sym_DOT_DOT] = ACTIONS(540),
    [anon_sym_DOT] = ACTIONS(542),
    [anon_sym_QMARK] = ACTIONS(540),
    [anon_sym_break] = ACTIONS(542),
    [anon_sym_continue] = ACTIONS(542),
    [anon_sym_default] = ACTIONS(542),
    [anon_sym_if] = ACTIONS(542),
    [anon_sym_extern] = ACTIONS(542),
    [anon_sym_loop] = ACTIONS(542),
    [anon_sym_match] = ACTIONS(542),
    [anon_sym_pub] = ACTIONS(542),
    [anon_sym_return] = ACTIONS(542),
    [anon_sym_while] = ACTIONS(542),
    [anon_sym_for] = ACTIONS(542),
    [sym_numeric_literal] = ACTIONS(542),
    [aux_sym_string_literal_token1] = ACTIONS(540),
    [sym_shortstring_literal] = ACTIONS(540),
    [anon_sym_true] = ACTIONS(542),
    [anon_sym_false] = ACTIONS(542),
    [anon_sym_move] = ACTIONS(542),
    [anon_sym_ref] = ACTIONS(542),
    [sym_identifier] = ACTIONS(542),
    [sym_super] = ACTIONS(542),
    [sym_line_comment] = ACTIONS(3),
  },
  [130] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(922),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [131] = {
    [sym_else_clause] = STATE(106),
    [ts_builtin_sym_end] = ACTIONS(764),
    [anon_sym_LBRACE] = ACTIONS(764),
    [anon_sym_RBRACE] = ACTIONS(764),
    [anon_sym_impl] = ACTIONS(766),
    [anon_sym_SEMI] = ACTIONS(764),
    [anon_sym_trait] = ACTIONS(766),
    [anon_sym_type] = ACTIONS(766),
    [anon_sym_const] = ACTIONS(766),
    [anon_sym_EQ] = ACTIONS(766),
    [anon_sym_BANG] = ACTIONS(766),
    [anon_sym_POUND] = ACTIONS(764),
    [anon_sym_LBRACK] = ACTIONS(764),
    [anon_sym_mod] = ACTIONS(766),
    [anon_sym_struct] = ACTIONS(766),
    [anon_sym_enum] = ACTIONS(766),
    [anon_sym_fn] = ACTIONS(766),
    [anon_sym_let] = ACTIONS(766),
    [anon_sym_use] = ACTIONS(766),
    [anon_sym_COLON_COLON] = ACTIONS(764),
    [anon_sym_STAR] = ACTIONS(766),
    [anon_sym_LPAREN] = ACTIONS(764),
    [anon_sym_u8] = ACTIONS(766),
    [anon_sym_i8] = ACTIONS(766),
    [anon_sym_u16] = ACTIONS(766),
    [anon_sym_i16] = ACTIONS(766),
    [anon_sym_u32] = ACTIONS(766),
    [anon_sym_i32] = ACTIONS(766),
    [anon_sym_u64] = ACTIONS(766),
    [anon_sym_i64] = ACTIONS(766),
    [anon_sym_u128] = ACTIONS(766),
    [anon_sym_i128] = ACTIONS(766),
    [anon_sym_usize] = ACTIONS(766),
    [anon_sym_bool] = ACTIONS(766),
    [anon_sym_ByteArray] = ACTIONS(766),
    [anon_sym_felt252] = ACTIONS(766),
    [anon_sym_LT] = ACTIONS(766),
    [anon_sym_GT] = ACTIONS(766),
    [anon_sym_PLUS] = ACTIONS(766),
    [anon_sym_DASH] = ACTIONS(766),
    [anon_sym_SLASH] = ACTIONS(766),
    [anon_sym_PERCENT] = ACTIONS(766),
    [anon_sym_CARET] = ACTIONS(764),
    [anon_sym_TILDE] = ACTIONS(764),
    [anon_sym_AMP] = ACTIONS(766),
    [anon_sym_PIPE] = ACTIONS(766),
    [anon_sym_AMP_AMP] = ACTIONS(764),
    [anon_sym_PIPE_PIPE] = ACTIONS(764),
    [anon_sym_LT_LT] = ACTIONS(764),
    [anon_sym_GT_GT] = ACTIONS(764),
    [anon_sym_PLUS_EQ] = ACTIONS(764),
    [anon_sym_DASH_EQ] = ACTIONS(764),
    [anon_sym_STAR_EQ] = ACTIONS(764),
    [anon_sym_SLASH_EQ] = ACTIONS(764),
    [anon_sym_PERCENT_EQ] = ACTIONS(764),
    [anon_sym_EQ_EQ] = ACTIONS(764),
    [anon_sym_BANG_EQ] = ACTIONS(764),
    [anon_sym_GT_EQ] = ACTIONS(764),
    [anon_sym_LT_EQ] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(764),
    [anon_sym_DOT_DOT] = ACTIONS(764),
    [anon_sym_DOT] = ACTIONS(766),
    [anon_sym_QMARK] = ACTIONS(764),
    [anon_sym_break] = ACTIONS(766),
    [anon_sym_continue] = ACTIONS(766),
    [anon_sym_default] = ACTIONS(766),
    [anon_sym_if] = ACTIONS(766),
    [anon_sym_extern] = ACTIONS(766),
    [anon_sym_loop] = ACTIONS(766),
    [anon_sym_match] = ACTIONS(766),
    [anon_sym_pub] = ACTIONS(766),
    [anon_sym_return] = ACTIONS(766),
    [anon_sym_while] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(766),
    [sym_numeric_literal] = ACTIONS(766),
    [aux_sym_string_literal_token1] = ACTIONS(764),
    [sym_shortstring_literal] = ACTIONS(764),
    [anon_sym_true] = ACTIONS(766),
    [anon_sym_false] = ACTIONS(766),
    [anon_sym_else] = ACTIONS(768),
    [anon_sym_move] = ACTIONS(766),
    [anon_sym_ref] = ACTIONS(766),
    [sym_identifier] = ACTIONS(766),
    [sym_super] = ACTIONS(766),
    [sym_line_comment] = ACTIONS(3),
  },
  [132] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(892),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym__condition] = STATE(1653),
    [sym_let_condition] = STATE(1653),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [133] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(892),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym__condition] = STATE(1545),
    [sym_let_condition] = STATE(1545),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [134] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(874),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [135] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(892),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym__condition] = STATE(1578),
    [sym_let_condition] = STATE(1578),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [136] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(892),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym__condition] = STATE(1584),
    [sym_let_condition] = STATE(1584),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [137] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(902),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym__condition] = STATE(1812),
    [sym_let_condition] = STATE(1812),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_let] = ACTIONS(776),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(780),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [138] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(892),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym__condition] = STATE(1606),
    [sym_let_condition] = STATE(1606),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [139] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(892),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym__condition] = STATE(1608),
    [sym_let_condition] = STATE(1608),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [140] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(892),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym__condition] = STATE(1630),
    [sym_let_condition] = STATE(1630),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [141] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(401),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(919),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(401),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [142] = {
    [sym_macro_invocation] = STATE(515),
    [sym_attribute_item] = STATE(134),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(787),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_enum_variant_list_repeat1] = STATE(134),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(565),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [143] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(556),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH_GT] = ACTIONS(782),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym__] = ACTIONS(784),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [144] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(866),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(161),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(786),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [145] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(855),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(152),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(788),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [146] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(778),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH_GT] = ACTIONS(782),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym__] = ACTIONS(784),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(345),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [147] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(554),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH_GT] = ACTIONS(790),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym__] = ACTIONS(792),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [148] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(833),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH_GT] = ACTIONS(790),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym__] = ACTIONS(792),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [149] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(784),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH_GT] = ACTIONS(790),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym__] = ACTIONS(792),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(345),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(756),
    [anon_sym_LBRACE] = ACTIONS(756),
    [anon_sym_RBRACE] = ACTIONS(756),
    [anon_sym_impl] = ACTIONS(758),
    [anon_sym_SEMI] = ACTIONS(756),
    [anon_sym_trait] = ACTIONS(758),
    [anon_sym_type] = ACTIONS(758),
    [anon_sym_const] = ACTIONS(758),
    [anon_sym_EQ] = ACTIONS(758),
    [anon_sym_BANG] = ACTIONS(758),
    [anon_sym_POUND] = ACTIONS(756),
    [anon_sym_LBRACK] = ACTIONS(756),
    [anon_sym_mod] = ACTIONS(758),
    [anon_sym_struct] = ACTIONS(758),
    [anon_sym_enum] = ACTIONS(758),
    [anon_sym_fn] = ACTIONS(758),
    [anon_sym_let] = ACTIONS(758),
    [anon_sym_use] = ACTIONS(758),
    [anon_sym_COLON_COLON] = ACTIONS(756),
    [anon_sym_STAR] = ACTIONS(758),
    [anon_sym_LPAREN] = ACTIONS(756),
    [anon_sym_u8] = ACTIONS(758),
    [anon_sym_i8] = ACTIONS(758),
    [anon_sym_u16] = ACTIONS(758),
    [anon_sym_i16] = ACTIONS(758),
    [anon_sym_u32] = ACTIONS(758),
    [anon_sym_i32] = ACTIONS(758),
    [anon_sym_u64] = ACTIONS(758),
    [anon_sym_i64] = ACTIONS(758),
    [anon_sym_u128] = ACTIONS(758),
    [anon_sym_i128] = ACTIONS(758),
    [anon_sym_usize] = ACTIONS(758),
    [anon_sym_bool] = ACTIONS(758),
    [anon_sym_ByteArray] = ACTIONS(758),
    [anon_sym_felt252] = ACTIONS(758),
    [anon_sym_LT] = ACTIONS(758),
    [anon_sym_GT] = ACTIONS(758),
    [anon_sym_PLUS] = ACTIONS(758),
    [anon_sym_DASH] = ACTIONS(758),
    [anon_sym_SLASH] = ACTIONS(758),
    [anon_sym_PERCENT] = ACTIONS(758),
    [anon_sym_CARET] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(756),
    [anon_sym_AMP] = ACTIONS(758),
    [anon_sym_PIPE] = ACTIONS(758),
    [anon_sym_AMP_AMP] = ACTIONS(756),
    [anon_sym_PIPE_PIPE] = ACTIONS(756),
    [anon_sym_LT_LT] = ACTIONS(756),
    [anon_sym_GT_GT] = ACTIONS(756),
    [anon_sym_PLUS_EQ] = ACTIONS(756),
    [anon_sym_DASH_EQ] = ACTIONS(756),
    [anon_sym_STAR_EQ] = ACTIONS(756),
    [anon_sym_SLASH_EQ] = ACTIONS(756),
    [anon_sym_PERCENT_EQ] = ACTIONS(756),
    [anon_sym_EQ_EQ] = ACTIONS(756),
    [anon_sym_BANG_EQ] = ACTIONS(756),
    [anon_sym_GT_EQ] = ACTIONS(756),
    [anon_sym_LT_EQ] = ACTIONS(756),
    [anon_sym_AT] = ACTIONS(756),
    [anon_sym_DOT_DOT] = ACTIONS(756),
    [anon_sym_DOT] = ACTIONS(758),
    [anon_sym_QMARK] = ACTIONS(756),
    [anon_sym_break] = ACTIONS(758),
    [anon_sym_continue] = ACTIONS(758),
    [anon_sym_default] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(758),
    [anon_sym_extern] = ACTIONS(758),
    [anon_sym_loop] = ACTIONS(758),
    [anon_sym_match] = ACTIONS(758),
    [anon_sym_pub] = ACTIONS(758),
    [anon_sym_return] = ACTIONS(758),
    [anon_sym_while] = ACTIONS(758),
    [anon_sym_for] = ACTIONS(758),
    [sym_numeric_literal] = ACTIONS(758),
    [aux_sym_string_literal_token1] = ACTIONS(756),
    [sym_shortstring_literal] = ACTIONS(756),
    [anon_sym_true] = ACTIONS(758),
    [anon_sym_false] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(758),
    [anon_sym_move] = ACTIONS(758),
    [anon_sym_ref] = ACTIONS(758),
    [sym_identifier] = ACTIONS(758),
    [sym_super] = ACTIONS(758),
    [sym_line_comment] = ACTIONS(3),
  },
  [151] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(832),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(155),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(794),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [152] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(897),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(152),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_BANG] = ACTIONS(799),
    [anon_sym_LBRACK] = ACTIONS(802),
    [anon_sym_COLON_COLON] = ACTIONS(805),
    [anon_sym_STAR] = ACTIONS(799),
    [anon_sym_LPAREN] = ACTIONS(808),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_u8] = ACTIONS(813),
    [anon_sym_i8] = ACTIONS(813),
    [anon_sym_u16] = ACTIONS(813),
    [anon_sym_i16] = ACTIONS(813),
    [anon_sym_u32] = ACTIONS(813),
    [anon_sym_i32] = ACTIONS(813),
    [anon_sym_u64] = ACTIONS(813),
    [anon_sym_i64] = ACTIONS(813),
    [anon_sym_u128] = ACTIONS(813),
    [anon_sym_i128] = ACTIONS(813),
    [anon_sym_usize] = ACTIONS(813),
    [anon_sym_bool] = ACTIONS(813),
    [anon_sym_ByteArray] = ACTIONS(813),
    [anon_sym_felt252] = ACTIONS(813),
    [anon_sym_DASH] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(799),
    [anon_sym_PIPE] = ACTIONS(819),
    [anon_sym_AT] = ACTIONS(799),
    [anon_sym_DOT_DOT] = ACTIONS(822),
    [anon_sym_break] = ACTIONS(825),
    [anon_sym_continue] = ACTIONS(828),
    [anon_sym_default] = ACTIONS(831),
    [anon_sym_if] = ACTIONS(834),
    [anon_sym_loop] = ACTIONS(837),
    [anon_sym_match] = ACTIONS(840),
    [anon_sym_return] = ACTIONS(843),
    [anon_sym_while] = ACTIONS(846),
    [anon_sym_for] = ACTIONS(849),
    [sym_numeric_literal] = ACTIONS(852),
    [aux_sym_string_literal_token1] = ACTIONS(855),
    [sym_shortstring_literal] = ACTIONS(858),
    [anon_sym_true] = ACTIONS(861),
    [anon_sym_false] = ACTIONS(861),
    [anon_sym_move] = ACTIONS(864),
    [anon_sym_ref] = ACTIONS(867),
    [sym_identifier] = ACTIONS(870),
    [sym_super] = ACTIONS(873),
    [sym_line_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(746),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_RBRACE] = ACTIONS(746),
    [anon_sym_impl] = ACTIONS(748),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_trait] = ACTIONS(748),
    [anon_sym_type] = ACTIONS(748),
    [anon_sym_const] = ACTIONS(748),
    [anon_sym_EQ] = ACTIONS(748),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_POUND] = ACTIONS(746),
    [anon_sym_LBRACK] = ACTIONS(746),
    [anon_sym_mod] = ACTIONS(748),
    [anon_sym_struct] = ACTIONS(748),
    [anon_sym_enum] = ACTIONS(748),
    [anon_sym_fn] = ACTIONS(748),
    [anon_sym_let] = ACTIONS(748),
    [anon_sym_use] = ACTIONS(748),
    [anon_sym_COLON_COLON] = ACTIONS(746),
    [anon_sym_STAR] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(746),
    [anon_sym_u8] = ACTIONS(748),
    [anon_sym_i8] = ACTIONS(748),
    [anon_sym_u16] = ACTIONS(748),
    [anon_sym_i16] = ACTIONS(748),
    [anon_sym_u32] = ACTIONS(748),
    [anon_sym_i32] = ACTIONS(748),
    [anon_sym_u64] = ACTIONS(748),
    [anon_sym_i64] = ACTIONS(748),
    [anon_sym_u128] = ACTIONS(748),
    [anon_sym_i128] = ACTIONS(748),
    [anon_sym_usize] = ACTIONS(748),
    [anon_sym_bool] = ACTIONS(748),
    [anon_sym_ByteArray] = ACTIONS(748),
    [anon_sym_felt252] = ACTIONS(748),
    [anon_sym_LT] = ACTIONS(748),
    [anon_sym_GT] = ACTIONS(748),
    [anon_sym_PLUS] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(748),
    [anon_sym_SLASH] = ACTIONS(748),
    [anon_sym_PERCENT] = ACTIONS(748),
    [anon_sym_CARET] = ACTIONS(746),
    [anon_sym_TILDE] = ACTIONS(746),
    [anon_sym_AMP] = ACTIONS(748),
    [anon_sym_PIPE] = ACTIONS(748),
    [anon_sym_AMP_AMP] = ACTIONS(746),
    [anon_sym_PIPE_PIPE] = ACTIONS(746),
    [anon_sym_LT_LT] = ACTIONS(746),
    [anon_sym_GT_GT] = ACTIONS(746),
    [anon_sym_PLUS_EQ] = ACTIONS(746),
    [anon_sym_DASH_EQ] = ACTIONS(746),
    [anon_sym_STAR_EQ] = ACTIONS(746),
    [anon_sym_SLASH_EQ] = ACTIONS(746),
    [anon_sym_PERCENT_EQ] = ACTIONS(746),
    [anon_sym_EQ_EQ] = ACTIONS(746),
    [anon_sym_BANG_EQ] = ACTIONS(746),
    [anon_sym_GT_EQ] = ACTIONS(746),
    [anon_sym_LT_EQ] = ACTIONS(746),
    [anon_sym_AT] = ACTIONS(746),
    [anon_sym_DOT_DOT] = ACTIONS(746),
    [anon_sym_DOT] = ACTIONS(748),
    [anon_sym_QMARK] = ACTIONS(746),
    [anon_sym_break] = ACTIONS(748),
    [anon_sym_continue] = ACTIONS(748),
    [anon_sym_default] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_extern] = ACTIONS(748),
    [anon_sym_loop] = ACTIONS(748),
    [anon_sym_match] = ACTIONS(748),
    [anon_sym_pub] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [sym_numeric_literal] = ACTIONS(748),
    [aux_sym_string_literal_token1] = ACTIONS(746),
    [sym_shortstring_literal] = ACTIONS(746),
    [anon_sym_true] = ACTIONS(748),
    [anon_sym_false] = ACTIONS(748),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_move] = ACTIONS(748),
    [anon_sym_ref] = ACTIONS(748),
    [sym_identifier] = ACTIONS(748),
    [sym_super] = ACTIONS(748),
    [sym_line_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_impl] = ACTIONS(742),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_trait] = ACTIONS(742),
    [anon_sym_type] = ACTIONS(742),
    [anon_sym_const] = ACTIONS(742),
    [anon_sym_EQ] = ACTIONS(742),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_LBRACK] = ACTIONS(740),
    [anon_sym_mod] = ACTIONS(742),
    [anon_sym_struct] = ACTIONS(742),
    [anon_sym_enum] = ACTIONS(742),
    [anon_sym_fn] = ACTIONS(742),
    [anon_sym_let] = ACTIONS(742),
    [anon_sym_use] = ACTIONS(742),
    [anon_sym_COLON_COLON] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(742),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_u8] = ACTIONS(742),
    [anon_sym_i8] = ACTIONS(742),
    [anon_sym_u16] = ACTIONS(742),
    [anon_sym_i16] = ACTIONS(742),
    [anon_sym_u32] = ACTIONS(742),
    [anon_sym_i32] = ACTIONS(742),
    [anon_sym_u64] = ACTIONS(742),
    [anon_sym_i64] = ACTIONS(742),
    [anon_sym_u128] = ACTIONS(742),
    [anon_sym_i128] = ACTIONS(742),
    [anon_sym_usize] = ACTIONS(742),
    [anon_sym_bool] = ACTIONS(742),
    [anon_sym_ByteArray] = ACTIONS(742),
    [anon_sym_felt252] = ACTIONS(742),
    [anon_sym_LT] = ACTIONS(742),
    [anon_sym_GT] = ACTIONS(742),
    [anon_sym_PLUS] = ACTIONS(742),
    [anon_sym_DASH] = ACTIONS(742),
    [anon_sym_SLASH] = ACTIONS(742),
    [anon_sym_PERCENT] = ACTIONS(742),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(742),
    [anon_sym_PIPE] = ACTIONS(742),
    [anon_sym_AMP_AMP] = ACTIONS(740),
    [anon_sym_PIPE_PIPE] = ACTIONS(740),
    [anon_sym_LT_LT] = ACTIONS(740),
    [anon_sym_GT_GT] = ACTIONS(740),
    [anon_sym_PLUS_EQ] = ACTIONS(740),
    [anon_sym_DASH_EQ] = ACTIONS(740),
    [anon_sym_STAR_EQ] = ACTIONS(740),
    [anon_sym_SLASH_EQ] = ACTIONS(740),
    [anon_sym_PERCENT_EQ] = ACTIONS(740),
    [anon_sym_EQ_EQ] = ACTIONS(740),
    [anon_sym_BANG_EQ] = ACTIONS(740),
    [anon_sym_GT_EQ] = ACTIONS(740),
    [anon_sym_LT_EQ] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_DOT_DOT] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(742),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_break] = ACTIONS(742),
    [anon_sym_continue] = ACTIONS(742),
    [anon_sym_default] = ACTIONS(742),
    [anon_sym_if] = ACTIONS(742),
    [anon_sym_extern] = ACTIONS(742),
    [anon_sym_loop] = ACTIONS(742),
    [anon_sym_match] = ACTIONS(742),
    [anon_sym_pub] = ACTIONS(742),
    [anon_sym_return] = ACTIONS(742),
    [anon_sym_while] = ACTIONS(742),
    [anon_sym_for] = ACTIONS(742),
    [sym_numeric_literal] = ACTIONS(742),
    [aux_sym_string_literal_token1] = ACTIONS(740),
    [sym_shortstring_literal] = ACTIONS(740),
    [anon_sym_true] = ACTIONS(742),
    [anon_sym_false] = ACTIONS(742),
    [anon_sym_else] = ACTIONS(742),
    [anon_sym_move] = ACTIONS(742),
    [anon_sym_ref] = ACTIONS(742),
    [sym_identifier] = ACTIONS(742),
    [sym_super] = ACTIONS(742),
    [sym_line_comment] = ACTIONS(3),
  },
  [155] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(889),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(152),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(876),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [156] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(869),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(157),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(878),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [157] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(870),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(152),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(880),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [158] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(889),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(145),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(876),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [159] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(757),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH_GT] = ACTIONS(782),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym__] = ACTIONS(784),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [160] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(847),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_DASH_GT] = ACTIONS(882),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym__] = ACTIONS(884),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(319),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [161] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(869),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [aux_sym_tuple_expression_repeat1] = STATE(152),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(878),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [162] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(849),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_DASH_GT] = ACTIONS(886),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym__] = ACTIONS(888),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(319),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [163] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(521),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(345),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_mutable_specifier] = ACTIONS(890),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [164] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(770),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(319),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(297),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_mutable_specifier] = ACTIONS(892),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(894),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_RBRACE] = ACTIONS(894),
    [anon_sym_impl] = ACTIONS(896),
    [anon_sym_SEMI] = ACTIONS(894),
    [anon_sym_trait] = ACTIONS(896),
    [anon_sym_type] = ACTIONS(896),
    [anon_sym_const] = ACTIONS(896),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_BANG] = ACTIONS(896),
    [anon_sym_POUND] = ACTIONS(894),
    [anon_sym_LBRACK] = ACTIONS(894),
    [anon_sym_mod] = ACTIONS(896),
    [anon_sym_struct] = ACTIONS(896),
    [anon_sym_enum] = ACTIONS(896),
    [anon_sym_fn] = ACTIONS(896),
    [anon_sym_let] = ACTIONS(896),
    [anon_sym_use] = ACTIONS(896),
    [anon_sym_COLON_COLON] = ACTIONS(894),
    [anon_sym_STAR] = ACTIONS(896),
    [anon_sym_LPAREN] = ACTIONS(894),
    [anon_sym_u8] = ACTIONS(896),
    [anon_sym_i8] = ACTIONS(896),
    [anon_sym_u16] = ACTIONS(896),
    [anon_sym_i16] = ACTIONS(896),
    [anon_sym_u32] = ACTIONS(896),
    [anon_sym_i32] = ACTIONS(896),
    [anon_sym_u64] = ACTIONS(896),
    [anon_sym_i64] = ACTIONS(896),
    [anon_sym_u128] = ACTIONS(896),
    [anon_sym_i128] = ACTIONS(896),
    [anon_sym_usize] = ACTIONS(896),
    [anon_sym_bool] = ACTIONS(896),
    [anon_sym_ByteArray] = ACTIONS(896),
    [anon_sym_felt252] = ACTIONS(896),
    [anon_sym_LT] = ACTIONS(898),
    [anon_sym_GT] = ACTIONS(898),
    [anon_sym_PLUS] = ACTIONS(898),
    [anon_sym_DASH] = ACTIONS(896),
    [anon_sym_SLASH] = ACTIONS(898),
    [anon_sym_PERCENT] = ACTIONS(898),
    [anon_sym_CARET] = ACTIONS(900),
    [anon_sym_TILDE] = ACTIONS(894),
    [anon_sym_AMP] = ACTIONS(898),
    [anon_sym_PIPE] = ACTIONS(896),
    [anon_sym_AMP_AMP] = ACTIONS(900),
    [anon_sym_PIPE_PIPE] = ACTIONS(900),
    [anon_sym_LT_LT] = ACTIONS(900),
    [anon_sym_GT_GT] = ACTIONS(900),
    [anon_sym_PLUS_EQ] = ACTIONS(900),
    [anon_sym_DASH_EQ] = ACTIONS(900),
    [anon_sym_STAR_EQ] = ACTIONS(900),
    [anon_sym_SLASH_EQ] = ACTIONS(900),
    [anon_sym_PERCENT_EQ] = ACTIONS(900),
    [anon_sym_EQ_EQ] = ACTIONS(900),
    [anon_sym_BANG_EQ] = ACTIONS(900),
    [anon_sym_GT_EQ] = ACTIONS(900),
    [anon_sym_LT_EQ] = ACTIONS(900),
    [anon_sym_AT] = ACTIONS(894),
    [anon_sym_DOT_DOT] = ACTIONS(894),
    [anon_sym_DOT] = ACTIONS(898),
    [anon_sym_QMARK] = ACTIONS(900),
    [anon_sym_break] = ACTIONS(896),
    [anon_sym_continue] = ACTIONS(896),
    [anon_sym_default] = ACTIONS(896),
    [anon_sym_if] = ACTIONS(896),
    [anon_sym_extern] = ACTIONS(896),
    [anon_sym_loop] = ACTIONS(896),
    [anon_sym_match] = ACTIONS(896),
    [anon_sym_pub] = ACTIONS(896),
    [anon_sym_return] = ACTIONS(896),
    [anon_sym_while] = ACTIONS(896),
    [anon_sym_for] = ACTIONS(896),
    [sym_numeric_literal] = ACTIONS(896),
    [aux_sym_string_literal_token1] = ACTIONS(894),
    [sym_shortstring_literal] = ACTIONS(894),
    [anon_sym_true] = ACTIONS(896),
    [anon_sym_false] = ACTIONS(896),
    [anon_sym_move] = ACTIONS(896),
    [anon_sym_ref] = ACTIONS(896),
    [sym_identifier] = ACTIONS(896),
    [sym_super] = ACTIONS(896),
    [sym_line_comment] = ACTIONS(3),
  },
  [166] = {
    [ts_builtin_sym_end] = ACTIONS(902),
    [anon_sym_LBRACE] = ACTIONS(902),
    [anon_sym_RBRACE] = ACTIONS(900),
    [anon_sym_impl] = ACTIONS(904),
    [anon_sym_SEMI] = ACTIONS(900),
    [anon_sym_trait] = ACTIONS(904),
    [anon_sym_type] = ACTIONS(904),
    [anon_sym_const] = ACTIONS(904),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_BANG] = ACTIONS(904),
    [anon_sym_POUND] = ACTIONS(902),
    [anon_sym_LBRACK] = ACTIONS(900),
    [anon_sym_mod] = ACTIONS(904),
    [anon_sym_struct] = ACTIONS(904),
    [anon_sym_enum] = ACTIONS(904),
    [anon_sym_fn] = ACTIONS(904),
    [anon_sym_let] = ACTIONS(904),
    [anon_sym_use] = ACTIONS(904),
    [anon_sym_COLON_COLON] = ACTIONS(902),
    [anon_sym_STAR] = ACTIONS(898),
    [anon_sym_LPAREN] = ACTIONS(900),
    [anon_sym_u8] = ACTIONS(904),
    [anon_sym_i8] = ACTIONS(904),
    [anon_sym_u16] = ACTIONS(904),
    [anon_sym_i16] = ACTIONS(904),
    [anon_sym_u32] = ACTIONS(904),
    [anon_sym_i32] = ACTIONS(904),
    [anon_sym_u64] = ACTIONS(904),
    [anon_sym_i64] = ACTIONS(904),
    [anon_sym_u128] = ACTIONS(904),
    [anon_sym_i128] = ACTIONS(904),
    [anon_sym_usize] = ACTIONS(904),
    [anon_sym_bool] = ACTIONS(904),
    [anon_sym_ByteArray] = ACTIONS(904),
    [anon_sym_felt252] = ACTIONS(904),
    [anon_sym_LT] = ACTIONS(898),
    [anon_sym_GT] = ACTIONS(898),
    [anon_sym_PLUS] = ACTIONS(898),
    [anon_sym_DASH] = ACTIONS(898),
    [anon_sym_SLASH] = ACTIONS(898),
    [anon_sym_PERCENT] = ACTIONS(898),
    [anon_sym_CARET] = ACTIONS(900),
    [anon_sym_TILDE] = ACTIONS(902),
    [anon_sym_AMP] = ACTIONS(898),
    [anon_sym_PIPE] = ACTIONS(898),
    [anon_sym_AMP_AMP] = ACTIONS(900),
    [anon_sym_PIPE_PIPE] = ACTIONS(900),
    [anon_sym_LT_LT] = ACTIONS(900),
    [anon_sym_GT_GT] = ACTIONS(900),
    [anon_sym_PLUS_EQ] = ACTIONS(900),
    [anon_sym_DASH_EQ] = ACTIONS(900),
    [anon_sym_STAR_EQ] = ACTIONS(900),
    [anon_sym_SLASH_EQ] = ACTIONS(900),
    [anon_sym_PERCENT_EQ] = ACTIONS(900),
    [anon_sym_EQ_EQ] = ACTIONS(900),
    [anon_sym_BANG_EQ] = ACTIONS(900),
    [anon_sym_GT_EQ] = ACTIONS(900),
    [anon_sym_LT_EQ] = ACTIONS(900),
    [anon_sym_AT] = ACTIONS(902),
    [anon_sym_DOT_DOT] = ACTIONS(900),
    [anon_sym_DOT] = ACTIONS(898),
    [anon_sym_QMARK] = ACTIONS(900),
    [anon_sym_break] = ACTIONS(904),
    [anon_sym_continue] = ACTIONS(904),
    [anon_sym_default] = ACTIONS(904),
    [anon_sym_if] = ACTIONS(904),
    [anon_sym_extern] = ACTIONS(904),
    [anon_sym_loop] = ACTIONS(904),
    [anon_sym_match] = ACTIONS(904),
    [anon_sym_pub] = ACTIONS(904),
    [anon_sym_return] = ACTIONS(904),
    [anon_sym_while] = ACTIONS(904),
    [anon_sym_for] = ACTIONS(904),
    [sym_numeric_literal] = ACTIONS(904),
    [aux_sym_string_literal_token1] = ACTIONS(902),
    [sym_shortstring_literal] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [anon_sym_move] = ACTIONS(904),
    [anon_sym_ref] = ACTIONS(904),
    [sym_identifier] = ACTIONS(904),
    [sym_super] = ACTIONS(904),
    [sym_line_comment] = ACTIONS(3),
  },
  [167] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(521),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_mutable_specifier] = ACTIONS(906),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [168] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(548),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [169] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(903),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [170] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(906),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [171] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(918),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [172] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(486),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(908),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [173] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1496),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(649),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(917),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(146),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(325),
    [anon_sym_i8] = ACTIONS(325),
    [anon_sym_u16] = ACTIONS(325),
    [anon_sym_i16] = ACTIONS(325),
    [anon_sym_u32] = ACTIONS(325),
    [anon_sym_i32] = ACTIONS(325),
    [anon_sym_u64] = ACTIONS(325),
    [anon_sym_i64] = ACTIONS(325),
    [anon_sym_u128] = ACTIONS(325),
    [anon_sym_i128] = ACTIONS(325),
    [anon_sym_usize] = ACTIONS(325),
    [anon_sym_bool] = ACTIONS(325),
    [anon_sym_ByteArray] = ACTIONS(325),
    [anon_sym_felt252] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(327),
    [anon_sym_DOT_DOT] = ACTIONS(774),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(335),
    [anon_sym_ref] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [sym_super] = ACTIONS(341),
    [sym_line_comment] = ACTIONS(3),
  },
  [174] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(773),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [175] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(774),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [176] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(814),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [177] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(911),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [178] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(893),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [179] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(513),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [180] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(856),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(359),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(359),
    [sym_if_expression] = STATE(359),
    [sym_match_expression] = STATE(359),
    [sym_while_expression] = STATE(359),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(359),
    [sym_loop_expression] = STATE(359),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(910),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(912),
    [anon_sym_loop] = ACTIONS(914),
    [anon_sym_match] = ACTIONS(916),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(918),
    [anon_sym_for] = ACTIONS(920),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [181] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(864),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [182] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(865),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [183] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(895),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [184] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(920),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [185] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(541),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [186] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(888),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(363),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(363),
    [sym_if_expression] = STATE(363),
    [sym_match_expression] = STATE(363),
    [sym_while_expression] = STATE(363),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(363),
    [sym_loop_expression] = STATE(363),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(910),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(912),
    [anon_sym_loop] = ACTIONS(914),
    [anon_sym_match] = ACTIONS(916),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(918),
    [anon_sym_for] = ACTIONS(920),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [187] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(908),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [188] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(519),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [189] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(923),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [190] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(924),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(359),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(359),
    [sym_if_expression] = STATE(359),
    [sym_match_expression] = STATE(359),
    [sym_while_expression] = STATE(359),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(359),
    [sym_loop_expression] = STATE(359),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(910),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(912),
    [anon_sym_loop] = ACTIONS(914),
    [anon_sym_match] = ACTIONS(916),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(918),
    [anon_sym_for] = ACTIONS(920),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [191] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(912),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(363),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(363),
    [sym_if_expression] = STATE(363),
    [sym_match_expression] = STATE(363),
    [sym_while_expression] = STATE(363),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(363),
    [sym_loop_expression] = STATE(363),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(910),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(912),
    [anon_sym_loop] = ACTIONS(914),
    [anon_sym_match] = ACTIONS(916),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(918),
    [anon_sym_for] = ACTIONS(920),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [192] = {
    [sym_macro_invocation] = STATE(762),
    [sym_generic_type_with_turbofish] = STATE(1352),
    [sym__literal] = STATE(760),
    [sym_negative_literal] = STATE(846),
    [sym_string_literal] = STATE(846),
    [sym_boolean_literal] = STATE(846),
    [sym_scoped_identifier] = STATE(680),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1549),
    [sym_expression] = STATE(763),
    [sym_expression_except_range] = STATE(700),
    [sym_generic_function] = STATE(760),
    [sym_tuple_expression] = STATE(760),
    [sym_return_expression] = STATE(760),
    [sym_struct_expression] = STATE(760),
    [sym_assignment_expression] = STATE(760),
    [sym_break_expression] = STATE(760),
    [sym_continue_expression] = STATE(760),
    [sym_index_expression] = STATE(760),
    [sym_array_expression] = STATE(760),
    [sym_parenthesized_expression] = STATE(760),
    [sym_unit_expression] = STATE(760),
    [sym_compound_assignment_expr] = STATE(760),
    [sym__expression_ending_with_block] = STATE(760),
    [sym_unary_expression] = STATE(760),
    [sym_range_expression] = STATE(761),
    [sym_try_expression] = STATE(760),
    [sym_field_expression] = STATE(701),
    [sym_block] = STATE(760),
    [sym_if_expression] = STATE(760),
    [sym_match_expression] = STATE(760),
    [sym_while_expression] = STATE(760),
    [sym_closure_expression] = STATE(760),
    [sym_closure_parameters] = STATE(160),
    [sym_for_expression] = STATE(760),
    [sym_loop_expression] = STATE(760),
    [sym_binary_expression] = STATE(760),
    [sym_call_expression] = STATE(760),
    [sym_reference_expression] = STATE(760),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_LBRACK] = ACTIONS(313),
    [anon_sym_COLON_COLON] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_u8] = ACTIONS(275),
    [anon_sym_i8] = ACTIONS(275),
    [anon_sym_u16] = ACTIONS(275),
    [anon_sym_i16] = ACTIONS(275),
    [anon_sym_u32] = ACTIONS(275),
    [anon_sym_i32] = ACTIONS(275),
    [anon_sym_u64] = ACTIONS(275),
    [anon_sym_i64] = ACTIONS(275),
    [anon_sym_u128] = ACTIONS(275),
    [anon_sym_i128] = ACTIONS(275),
    [anon_sym_usize] = ACTIONS(275),
    [anon_sym_bool] = ACTIONS(275),
    [anon_sym_ByteArray] = ACTIONS(275),
    [anon_sym_felt252] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DOT_DOT] = ACTIONS(319),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(289),
    [anon_sym_return] = ACTIONS(291),
    [anon_sym_while] = ACTIONS(293),
    [anon_sym_for] = ACTIONS(295),
    [sym_numeric_literal] = ACTIONS(922),
    [aux_sym_string_literal_token1] = ACTIONS(299),
    [sym_shortstring_literal] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_ref] = ACTIONS(307),
    [sym_identifier] = ACTIONS(309),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
  },
  [193] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(543),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [194] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(544),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [195] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(545),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [196] = {
    [sym_macro_invocation] = STATE(515),
    [sym_generic_type_with_turbofish] = STATE(1494),
    [sym__literal] = STATE(498),
    [sym_negative_literal] = STATE(516),
    [sym_string_literal] = STATE(516),
    [sym_boolean_literal] = STATE(516),
    [sym_scoped_identifier] = STATE(484),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1622),
    [sym_expression] = STATE(546),
    [sym_expression_except_range] = STATE(478),
    [sym_generic_function] = STATE(498),
    [sym_tuple_expression] = STATE(498),
    [sym_return_expression] = STATE(498),
    [sym_struct_expression] = STATE(498),
    [sym_assignment_expression] = STATE(498),
    [sym_break_expression] = STATE(498),
    [sym_continue_expression] = STATE(498),
    [sym_index_expression] = STATE(498),
    [sym_array_expression] = STATE(498),
    [sym_parenthesized_expression] = STATE(498),
    [sym_unit_expression] = STATE(498),
    [sym_compound_assignment_expr] = STATE(498),
    [sym__expression_ending_with_block] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_range_expression] = STATE(504),
    [sym_try_expression] = STATE(498),
    [sym_field_expression] = STATE(477),
    [sym_block] = STATE(498),
    [sym_if_expression] = STATE(498),
    [sym_match_expression] = STATE(498),
    [sym_while_expression] = STATE(498),
    [sym_closure_expression] = STATE(498),
    [sym_closure_parameters] = STATE(143),
    [sym_for_expression] = STATE(498),
    [sym_loop_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_reference_expression] = STATE(498),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_default] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_loop] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(61),
    [anon_sym_return] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_for] = ACTIONS(69),
    [sym_numeric_literal] = ACTIONS(71),
    [aux_sym_string_literal_token1] = ACTIONS(73),
    [sym_shortstring_literal] = ACTIONS(75),
    [anon_sym_true] = ACTIONS(77),
    [anon_sym_false] = ACTIONS(77),
    [anon_sym_move] = ACTIONS(79),
    [anon_sym_ref] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
  },
  [197] = {
    [anon_sym_LBRACE] = ACTIONS(902),
    [anon_sym_RBRACE] = ACTIONS(902),
    [anon_sym_impl] = ACTIONS(904),
    [anon_sym_SEMI] = ACTIONS(900),
    [anon_sym_trait] = ACTIONS(904),
    [anon_sym_type] = ACTIONS(904),
    [anon_sym_const] = ACTIONS(904),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_BANG] = ACTIONS(904),
    [anon_sym_POUND] = ACTIONS(902),
    [anon_sym_LBRACK] = ACTIONS(900),
    [anon_sym_mod] = ACTIONS(904),
    [anon_sym_struct] = ACTIONS(904),
    [anon_sym_enum] = ACTIONS(904),
    [anon_sym_fn] = ACTIONS(904),
    [anon_sym_let] = ACTIONS(904),
    [anon_sym_use] = ACTIONS(904),
    