#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 722
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 91
#define ALIAS_COUNT 0
#define TOKEN_COUNT 41
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 1

enum {
  sym__escape_identity = 1,
  anon_sym_BSLASHt = 2,
  anon_sym_BSLASHr = 3,
  anon_sym_BSLASHn = 4,
  anon_sym_SEMI = 5,
  anon_sym_BSLASH_SEMI = 6,
  aux_sym_variable_token1 = 7,
  anon_sym_DOLLAR = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_ENV = 11,
  anon_sym_CACHE = 12,
  anon_sym_LT = 13,
  anon_sym_GT = 14,
  anon_sym_COLON = 15,
  aux_sym__gen_exp_arguments_token1 = 16,
  aux_sym__untrimmed_argument_token1 = 17,
  anon_sym_LPAREN = 18,
  anon_sym_RPAREN = 19,
  anon_sym_DQUOTE = 20,
  aux_sym__quoted_text_token1 = 21,
  aux_sym__unquoted_text_token1 = 22,
  aux_sym_if_command_token1 = 23,
  aux_sym_endwhile_command_token1 = 24,
  sym_if = 25,
  sym_elseif = 26,
  sym_else = 27,
  sym_endif = 28,
  sym_foreach = 29,
  sym_endforeach = 30,
  sym_while = 31,
  sym_endwhile = 32,
  sym_function = 33,
  sym_endfunction = 34,
  sym_macro = 35,
  sym_endmacro = 36,
  sym_identifier = 37,
  sym_bracket_argument = 38,
  sym_bracket_comment = 39,
  sym_line_comment = 40,
  sym_source_file = 41,
  sym_escape_sequence = 42,
  sym__escape_encoded = 43,
  sym__escape_semicolon = 44,
  sym_variable = 45,
  sym_variable_ref = 46,
  sym_normal_var = 47,
  sym_env_var = 48,
  sym_cache_var = 49,
  sym_gen_exp = 50,
  sym__gen_exp_content = 51,
  sym__gen_exp_arguments = 52,
  sym_argument = 53,
  sym__untrimmed_argument = 54,
  sym__paren_argument = 55,
  sym_quoted_argument = 56,
  sym_quoted_element = 57,
  sym__quoted_text = 58,
  sym_unquoted_argument = 59,
  sym__unquoted_text = 60,
  sym_if_command = 61,
  sym_elseif_command = 62,
  sym_else_command = 63,
  sym_endif_command = 64,
  sym_if_condition = 65,
  sym_foreach_command = 66,
  sym_endforeach_command = 67,
  sym_foreach_loop = 68,
  sym_while_command = 69,
  sym_endwhile_command = 70,
  sym_while_loop = 71,
  sym_function_command = 72,
  sym_endfunction_command = 73,
  sym_function_def = 74,
  sym_macro_command = 75,
  sym_endmacro_command = 76,
  sym_macro_def = 77,
  sym_normal_command = 78,
  sym__command_invocation = 79,
  sym__untrimmed_command_invocation = 80,
  aux_sym_source_file_repeat1 = 81,
  aux_sym_variable_repeat1 = 82,
  aux_sym__gen_exp_arguments_repeat1 = 83,
  aux_sym__paren_argument_repeat1 = 84,
  aux_sym_quoted_element_repeat1 = 85,
  aux_sym__quoted_text_repeat1 = 86,
  aux_sym_unquoted_argument_repeat1 = 87,
  aux_sym__unquoted_text_repeat1 = 88,
  aux_sym_if_command_repeat1 = 89,
  aux_sym_if_condition_repeat1 = 90,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__escape_identity] = "_escape_identity",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_BSLASH_SEMI] = "\\;",
  [aux_sym_variable_token1] = "variable_token1",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ENV] = "ENV",
  [anon_sym_CACHE] = "CACHE",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_COLON] = ":",
  [aux_sym__gen_exp_arguments_token1] = "_gen_exp_arguments_token1",
  [aux_sym__untrimmed_argument_token1] = "_untrimmed_argument_token1",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__quoted_text_token1] = "_quoted_text_token1",
  [aux_sym__unquoted_text_token1] = "_unquoted_text_token1",
  [aux_sym_if_command_token1] = "if_command_token1",
  [aux_sym_endwhile_command_token1] = "endwhile_command_token1",
  [sym_if] = "if",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_endif] = "endif",
  [sym_foreach] = "foreach",
  [sym_endforeach] = "endforeach",
  [sym_while] = "while",
  [sym_endwhile] = "endwhile",
  [sym_function] = "function",
  [sym_endfunction] = "endfunction",
  [sym_macro] = "macro",
  [sym_endmacro] = "endmacro",
  [sym_identifier] = "identifier",
  [sym_bracket_argument] = "bracket_argument",
  [sym_bracket_comment] = "bracket_comment",
  [sym_line_comment] = "line_comment",
  [sym_source_file] = "source_file",
  [sym_escape_sequence] = "escape_sequence",
  [sym__escape_encoded] = "_escape_encoded",
  [sym__escape_semicolon] = "_escape_semicolon",
  [sym_variable] = "variable",
  [sym_variable_ref] = "variable_ref",
  [sym_normal_var] = "normal_var",
  [sym_env_var] = "env_var",
  [sym_cache_var] = "cache_var",
  [sym_gen_exp] = "gen_exp",
  [sym__gen_exp_content] = "_gen_exp_content",
  [sym__gen_exp_arguments] = "_gen_exp_arguments",
  [sym_argument] = "argument",
  [sym__untrimmed_argument] = "_untrimmed_argument",
  [sym__paren_argument] = "_paren_argument",
  [sym_quoted_argument] = "quoted_argument",
  [sym_quoted_element] = "quoted_element",
  [sym__quoted_text] = "_quoted_text",
  [sym_unquoted_argument] = "unquoted_argument",
  [sym__unquoted_text] = "_unquoted_text",
  [sym_if_command] = "if_command",
  [sym_elseif_command] = "elseif_command",
  [sym_else_command] = "else_command",
  [sym_endif_command] = "endif_command",
  [sym_if_condition] = "if_condition",
  [sym_foreach_command] = "foreach_command",
  [sym_endforeach_command] = "endforeach_command",
  [sym_foreach_loop] = "foreach_loop",
  [sym_while_command] = "while_command",
  [sym_endwhile_command] = "endwhile_command",
  [sym_while_loop] = "while_loop",
  [sym_function_command] = "function_command",
  [sym_endfunction_command] = "endfunction_command",
  [sym_function_def] = "function_def",
  [sym_macro_command] = "macro_command",
  [sym_endmacro_command] = "endmacro_command",
  [sym_macro_def] = "macro_def",
  [sym_normal_command] = "normal_command",
  [sym__command_invocation] = "_command_invocation",
  [sym__untrimmed_command_invocation] = "_untrimmed_command_invocation",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym__gen_exp_arguments_repeat1] = "_gen_exp_arguments_repeat1",
  [aux_sym__paren_argument_repeat1] = "_paren_argument_repeat1",
  [aux_sym_quoted_element_repeat1] = "quoted_element_repeat1",
  [aux_sym__quoted_text_repeat1] = "_quoted_text_repeat1",
  [aux_sym_unquoted_argument_repeat1] = "unquoted_argument_repeat1",
  [aux_sym__unquoted_text_repeat1] = "_unquoted_text_repeat1",
  [aux_sym_if_command_repeat1] = "if_command_repeat1",
  [aux_sym_if_condition_repeat1] = "if_condition_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__escape_identity] = sym__escape_identity,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_BSLASH_SEMI] = anon_sym_BSLASH_SEMI,
  [aux_sym_variable_token1] = aux_sym_variable_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ENV] = anon_sym_ENV,
  [anon_sym_CACHE] = anon_sym_CACHE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym__gen_exp_arguments_token1] = aux_sym__gen_exp_arguments_token1,
  [aux_sym__untrimmed_argument_token1] = aux_sym__untrimmed_argument_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__quoted_text_token1] = aux_sym__quoted_text_token1,
  [aux_sym__unquoted_text_token1] = aux_sym__unquoted_text_token1,
  [aux_sym_if_command_token1] = aux_sym_if_command_token1,
  [aux_sym_endwhile_command_token1] = aux_sym_endwhile_command_token1,
  [sym_if] = sym_if,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_endif] = sym_endif,
  [sym_foreach] = sym_foreach,
  [sym_endforeach] = sym_endforeach,
  [sym_while] = sym_while,
  [sym_endwhile] = sym_endwhile,
  [sym_function] = sym_function,
  [sym_endfunction] = sym_endfunction,
  [sym_macro] = sym_macro,
  [sym_endmacro] = sym_endmacro,
  [sym_identifier] = sym_identifier,
  [sym_bracket_argument] = sym_bracket_argument,
  [sym_bracket_comment] = sym_bracket_comment,
  [sym_line_comment] = sym_line_comment,
  [sym_source_file] = sym_source_file,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__escape_encoded] = sym__escape_encoded,
  [sym__escape_semicolon] = sym__escape_semicolon,
  [sym_variable] = sym_variable,
  [sym_variable_ref] = sym_variable_ref,
  [sym_normal_var] = sym_normal_var,
  [sym_env_var] = sym_env_var,
  [sym_cache_var] = sym_cache_var,
  [sym_gen_exp] = sym_gen_exp,
  [sym__gen_exp_content] = sym__gen_exp_content,
  [sym__gen_exp_arguments] = sym__gen_exp_arguments,
  [sym_argument] = sym_argument,
  [sym__untrimmed_argument] = sym__untrimmed_argument,
  [sym__paren_argument] = sym__paren_argument,
  [sym_quoted_argument] = sym_quoted_argument,
  [sym_quoted_element] = sym_quoted_element,
  [sym__quoted_text] = sym__quoted_text,
  [sym_unquoted_argument] = sym_unquoted_argument,
  [sym__unquoted_text] = sym__unquoted_text,
  [sym_if_command] = sym_if_command,
  [sym_elseif_command] = sym_elseif_command,
  [sym_else_command] = sym_else_command,
  [sym_endif_command] = sym_endif_command,
  [sym_if_condition] = sym_if_condition,
  [sym_foreach_command] = sym_foreach_command,
  [sym_endforeach_command] = sym_endforeach_command,
  [sym_foreach_loop] = sym_foreach_loop,
  [sym_while_command] = sym_while_command,
  [sym_endwhile_command] = sym_endwhile_command,
  [sym_while_loop] = sym_while_loop,
  [sym_function_command] = sym_function_command,
  [sym_endfunction_command] = sym_endfunction_command,
  [sym_function_def] = sym_function_def,
  [sym_macro_command] = sym_macro_command,
  [sym_endmacro_command] = sym_endmacro_command,
  [sym_macro_def] = sym_macro_def,
  [sym_normal_command] = sym_normal_command,
  [sym__command_invocation] = sym__command_invocation,
  [sym__untrimmed_command_invocation] = sym__untrimmed_command_invocation,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym__gen_exp_arguments_repeat1] = aux_sym__gen_exp_arguments_repeat1,
  [aux_sym__paren_argument_repeat1] = aux_sym__paren_argument_repeat1,
  [aux_sym_quoted_element_repeat1] = aux_sym_quoted_element_repeat1,
  [aux_sym__quoted_text_repeat1] = aux_sym__quoted_text_repeat1,
  [aux_sym_unquoted_argument_repeat1] = aux_sym_unquoted_argument_repeat1,
  [aux_sym__unquoted_text_repeat1] = aux_sym__unquoted_text_repeat1,
  [aux_sym_if_command_repeat1] = aux_sym_if_command_repeat1,
  [aux_sym_if_condition_repeat1] = aux_sym_if_condition_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_identity] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENV] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CACHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__untrimmed_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_endwhile_command_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_endif] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_encoded] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_var] = {
    .visible = true,
    .named = true,
  },
  [sym_env_var] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_var] = {
    .visible = true,
    .named = true,
  },
  [sym_gen_exp] = {
    .visible = true,
    .named = true,
  },
  [sym__gen_exp_content] = {
    .visible = false,
    .named = true,
  },
  [sym__gen_exp_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__untrimmed_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__paren_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_element] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_unquoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__unquoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_if_command] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_else_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_if_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_while_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile_command] = {
    .visible = true,
    .named = true,
  },
  [sym_while_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction_command] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_def] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_command] = {
    .visible = true,
    .named = true,
  },
  [sym__command_invocation] = {
    .visible = false,
    .named = true,
  },
  [sym__untrimmed_command_invocation] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paren_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__quoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unquoted_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(24);
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == ':') ADVANCE(39);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(37);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(49);
      if (lookahead == 'E') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(48);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(37);
      if (lookahead == 'C') ADVANCE(49);
      if (lookahead == 'E') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(48);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'') ADVANCE(48);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '\'' &&
          lookahead != '(') ADVANCE(48);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(37);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(49);
      if (lookahead == 'E') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(48);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ',') ADVANCE(40);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(48);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(37);
      if (lookahead == 'C') ADVANCE(46);
      if (lookahead == 'E') ADVANCE(47);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(48);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(44);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '}') ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(52);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(31);
      END_STATE();
    case 10:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(37);
      if (lookahead == 'C') ADVANCE(49);
      if (lookahead == 'E') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\'' &&
          lookahead != '(') ADVANCE(48);
      END_STATE();
    case 11:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ':') ADVANCE(39);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(37);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(49);
      if (lookahead == 'E') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(48);
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ':') ADVANCE(39);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(27);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(25);
      END_STATE();
    case 14:
      if (lookahead == 'C') ADVANCE(16);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(36);
      END_STATE();
    case 16:
      if (lookahead == 'H') ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == 'V') ADVANCE(35);
      END_STATE();
    case 18:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(103);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(115);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(69);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 19:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(110);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(115);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(69);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 20:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(111);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(115);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(69);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 21:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(115);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(69);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 22:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(113);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(115);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(69);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 23:
      if (eof) ADVANCE(24);
      if (lookahead == '}') ADVANCE(34);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(115);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(69);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym__escape_identity);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_BSLASH_SEMI);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_ENV);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_CACHE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym__gen_exp_arguments_token1);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym__untrimmed_argument_token1);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'A') ADVANCE(14);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'N') ADVANCE(17);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'A') ADVANCE(14);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'N') ADVANCE(17);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(56);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_if_command_token1);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '<') ADVANCE(37);
      if (lookahead == 'C') ADVANCE(49);
      if (lookahead == 'E') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(51);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(48);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(51);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead)) ADVANCE(48);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(56);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_elseif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_else);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_endif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_foreach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_endforeach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_endwhile);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_endfunction);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_macro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_endmacro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(125);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(121);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 23, .external_lex_state = 2},
  [2] = {.lex_state = 2, .external_lex_state = 1},
  [3] = {.lex_state = 2, .external_lex_state = 1},
  [4] = {.lex_state = 2, .external_lex_state = 1},
  [5] = {.lex_state = 2, .external_lex_state = 1},
  [6] = {.lex_state = 2, .external_lex_state = 1},
  [7] = {.lex_state = 2, .external_lex_state = 1},
  [8] = {.lex_state = 2, .external_lex_state = 1},
  [9] = {.lex_state = 2, .external_lex_state = 1},
  [10] = {.lex_state = 2, .external_lex_state = 1},
  [11] = {.lex_state = 2, .external_lex_state = 1},
  [12] = {.lex_state = 2, .external_lex_state = 1},
  [13] = {.lex_state = 2, .external_lex_state = 1},
  [14] = {.lex_state = 2, .external_lex_state = 1},
  [15] = {.lex_state = 2, .external_lex_state = 1},
  [16] = {.lex_state = 2, .external_lex_state = 1},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 2, .external_lex_state = 1},
  [20] = {.lex_state = 2, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 2, .external_lex_state = 1},
  [24] = {.lex_state = 2, .external_lex_state = 1},
  [25] = {.lex_state = 2, .external_lex_state = 1},
  [26] = {.lex_state = 2, .external_lex_state = 1},
  [27] = {.lex_state = 2, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 2, .external_lex_state = 1},
  [31] = {.lex_state = 2, .external_lex_state = 1},
  [32] = {.lex_state = 2, .external_lex_state = 1},
  [33] = {.lex_state = 2, .external_lex_state = 1},
  [34] = {.lex_state = 2, .external_lex_state = 1},
  [35] = {.lex_state = 2, .external_lex_state = 1},
  [36] = {.lex_state = 2, .external_lex_state = 1},
  [37] = {.lex_state = 2, .external_lex_state = 1},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 2, .external_lex_state = 1},
  [40] = {.lex_state = 2, .external_lex_state = 1},
  [41] = {.lex_state = 2, .external_lex_state = 1},
  [42] = {.lex_state = 2, .external_lex_state = 1},
  [43] = {.lex_state = 2, .external_lex_state = 1},
  [44] = {.lex_state = 2, .external_lex_state = 1},
  [45] = {.lex_state = 2, .external_lex_state = 1},
  [46] = {.lex_state = 2, .external_lex_state = 1},
  [47] = {.lex_state = 2, .external_lex_state = 1},
  [48] = {.lex_state = 2, .external_lex_state = 1},
  [49] = {.lex_state = 2, .external_lex_state = 1},
  [50] = {.lex_state = 2, .external_lex_state = 1},
  [51] = {.lex_state = 2, .external_lex_state = 1},
  [52] = {.lex_state = 2, .external_lex_state = 1},
  [53] = {.lex_state = 2, .external_lex_state = 1},
  [54] = {.lex_state = 2, .external_lex_state = 1},
  [55] = {.lex_state = 2, .external_lex_state = 1},
  [56] = {.lex_state = 2, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 2, .external_lex_state = 1},
  [59] = {.lex_state = 2, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 2, .external_lex_state = 1},
  [63] = {.lex_state = 2, .external_lex_state = 1},
  [64] = {.lex_state = 2, .external_lex_state = 1},
  [65] = {.lex_state = 2, .external_lex_state = 1},
  [66] = {.lex_state = 2, .external_lex_state = 1},
  [67] = {.lex_state = 2, .external_lex_state = 1},
  [68] = {.lex_state = 2, .external_lex_state = 1},
  [69] = {.lex_state = 2, .external_lex_state = 1},
  [70] = {.lex_state = 2, .external_lex_state = 1},
  [71] = {.lex_state = 2, .external_lex_state = 1},
  [72] = {.lex_state = 2, .external_lex_state = 1},
  [73] = {.lex_state = 2, .external_lex_state = 1},
  [74] = {.lex_state = 2, .external_lex_state = 1},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 2, .external_lex_state = 1},
  [77] = {.lex_state = 2, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 2, .external_lex_state = 1},
  [80] = {.lex_state = 2, .external_lex_state = 1},
  [81] = {.lex_state = 2, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 2, .external_lex_state = 1},
  [84] = {.lex_state = 2, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 2, .external_lex_state = 1},
  [87] = {.lex_state = 2, .external_lex_state = 1},
  [88] = {.lex_state = 2, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 2, .external_lex_state = 1},
  [91] = {.lex_state = 2, .external_lex_state = 1},
  [92] = {.lex_state = 2, .external_lex_state = 1},
  [93] = {.lex_state = 2, .external_lex_state = 1},
  [94] = {.lex_state = 2, .external_lex_state = 1},
  [95] = {.lex_state = 2, .external_lex_state = 1},
  [96] = {.lex_state = 2, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 2, .external_lex_state = 1},
  [100] = {.lex_state = 2, .external_lex_state = 1},
  [101] = {.lex_state = 2, .external_lex_state = 1},
  [102] = {.lex_state = 2, .external_lex_state = 1},
  [103] = {.lex_state = 2, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 2, .external_lex_state = 1},
  [107] = {.lex_state = 2, .external_lex_state = 1},
  [108] = {.lex_state = 2, .external_lex_state = 1},
  [109] = {.lex_state = 2, .external_lex_state = 1},
  [110] = {.lex_state = 2, .external_lex_state = 1},
  [111] = {.lex_state = 2, .external_lex_state = 1},
  [112] = {.lex_state = 2, .external_lex_state = 1},
  [113] = {.lex_state = 2, .external_lex_state = 1},
  [114] = {.lex_state = 2, .external_lex_state = 1},
  [115] = {.lex_state = 2, .external_lex_state = 1},
  [116] = {.lex_state = 2, .external_lex_state = 1},
  [117] = {.lex_state = 2, .external_lex_state = 1},
  [118] = {.lex_state = 2, .external_lex_state = 1},
  [119] = {.lex_state = 2, .external_lex_state = 1},
  [120] = {.lex_state = 2, .external_lex_state = 1},
  [121] = {.lex_state = 2, .external_lex_state = 1},
  [122] = {.lex_state = 2, .external_lex_state = 1},
  [123] = {.lex_state = 2, .external_lex_state = 1},
  [124] = {.lex_state = 2, .external_lex_state = 1},
  [125] = {.lex_state = 2, .external_lex_state = 1},
  [126] = {.lex_state = 2, .external_lex_state = 1},
  [127] = {.lex_state = 2, .external_lex_state = 1},
  [128] = {.lex_state = 2, .external_lex_state = 1},
  [129] = {.lex_state = 18, .external_lex_state = 2},
  [130] = {.lex_state = 18, .external_lex_state = 2},
  [131] = {.lex_state = 18, .external_lex_state = 2},
  [132] = {.lex_state = 18, .external_lex_state = 2},
  [133] = {.lex_state = 18, .external_lex_state = 2},
  [134] = {.lex_state = 18, .external_lex_state = 2},
  [135] = {.lex_state = 18, .external_lex_state = 2},
  [136] = {.lex_state = 18, .external_lex_state = 2},
  [137] = {.lex_state = 18, .external_lex_state = 2},
  [138] = {.lex_state = 18, .external_lex_state = 2},
  [139] = {.lex_state = 18, .external_lex_state = 2},
  [140] = {.lex_state = 18, .external_lex_state = 2},
  [141] = {.lex_state = 18, .external_lex_state = 2},
  [142] = {.lex_state = 2, .external_lex_state = 1},
  [143] = {.lex_state = 7, .external_lex_state = 3},
  [144] = {.lex_state = 7, .external_lex_state = 3},
  [145] = {.lex_state = 7, .external_lex_state = 3},
  [146] = {.lex_state = 7, .external_lex_state = 3},
  [147] = {.lex_state = 7, .external_lex_state = 3},
  [148] = {.lex_state = 7, .external_lex_state = 3},
  [149] = {.lex_state = 7, .external_lex_state = 3},
  [150] = {.lex_state = 7, .external_lex_state = 3},
  [151] = {.lex_state = 7, .external_lex_state = 3},
  [152] = {.lex_state = 2, .external_lex_state = 1},
  [153] = {.lex_state = 19, .external_lex_state = 2},
  [154] = {.lex_state = 20, .external_lex_state = 2},
  [155] = {.lex_state = 21, .external_lex_state = 2},
  [156] = {.lex_state = 3, .external_lex_state = 3},
  [157] = {.lex_state = 20, .external_lex_state = 2},
  [158] = {.lex_state = 21, .external_lex_state = 2},
  [159] = {.lex_state = 22, .external_lex_state = 2},
  [160] = {.lex_state = 22, .external_lex_state = 2},
  [161] = {.lex_state = 3, .external_lex_state = 3},
  [162] = {.lex_state = 19, .external_lex_state = 2},
  [163] = {.lex_state = 21, .external_lex_state = 2},
  [164] = {.lex_state = 20, .external_lex_state = 2},
  [165] = {.lex_state = 21, .external_lex_state = 2},
  [166] = {.lex_state = 22, .external_lex_state = 2},
  [167] = {.lex_state = 19, .external_lex_state = 2},
  [168] = {.lex_state = 19, .external_lex_state = 2},
  [169] = {.lex_state = 3, .external_lex_state = 3},
  [170] = {.lex_state = 22, .external_lex_state = 2},
  [171] = {.lex_state = 3, .external_lex_state = 3},
  [172] = {.lex_state = 19, .external_lex_state = 2},
  [173] = {.lex_state = 20, .external_lex_state = 2},
  [174] = {.lex_state = 3, .external_lex_state = 3},
  [175] = {.lex_state = 19, .external_lex_state = 2},
  [176] = {.lex_state = 21, .external_lex_state = 2},
  [177] = {.lex_state = 3, .external_lex_state = 3},
  [178] = {.lex_state = 22, .external_lex_state = 2},
  [179] = {.lex_state = 3, .external_lex_state = 3},
  [180] = {.lex_state = 21, .external_lex_state = 2},
  [181] = {.lex_state = 19, .external_lex_state = 2},
  [182] = {.lex_state = 20, .external_lex_state = 2},
  [183] = {.lex_state = 20, .external_lex_state = 2},
  [184] = {.lex_state = 21, .external_lex_state = 2},
  [185] = {.lex_state = 22, .external_lex_state = 2},
  [186] = {.lex_state = 3, .external_lex_state = 3},
  [187] = {.lex_state = 19, .external_lex_state = 2},
  [188] = {.lex_state = 22, .external_lex_state = 2},
  [189] = {.lex_state = 21, .external_lex_state = 2},
  [190] = {.lex_state = 20, .external_lex_state = 2},
  [191] = {.lex_state = 21, .external_lex_state = 2},
  [192] = {.lex_state = 22, .external_lex_state = 2},
  [193] = {.lex_state = 19, .external_lex_state = 2},
  [194] = {.lex_state = 19, .external_lex_state = 2},
  [195] = {.lex_state = 3, .external_lex_state = 3},
  [196] = {.lex_state = 3, .external_lex_state = 3},
  [197] = {.lex_state = 20, .external_lex_state = 2},
  [198] = {.lex_state = 22, .external_lex_state = 2},
  [199] = {.lex_state = 20, .external_lex_state = 2},
  [200] = {.lex_state = 21, .external_lex_state = 2},
  [201] = {.lex_state = 22, .external_lex_state = 2},
  [202] = {.lex_state = 20, .external_lex_state = 2},
  [203] = {.lex_state = 21, .external_lex_state = 2},
  [204] = {.lex_state = 22, .external_lex_state = 2},
  [205] = {.lex_state = 20, .external_lex_state = 2},
  [206] = {.lex_state = 19, .external_lex_state = 2},
  [207] = {.lex_state = 19, .external_lex_state = 2},
  [208] = {.lex_state = 22, .external_lex_state = 2},
  [209] = {.lex_state = 3, .external_lex_state = 3},
  [210] = {.lex_state = 20, .external_lex_state = 2},
  [211] = {.lex_state = 21, .external_lex_state = 2},
  [212] = {.lex_state = 3, .external_lex_state = 3},
  [213] = {.lex_state = 23, .external_lex_state = 2},
  [214] = {.lex_state = 3, .external_lex_state = 3},
  [215] = {.lex_state = 19, .external_lex_state = 2},
  [216] = {.lex_state = 20, .external_lex_state = 2},
  [217] = {.lex_state = 3, .external_lex_state = 3},
  [218] = {.lex_state = 21, .external_lex_state = 2},
  [219] = {.lex_state = 3, .external_lex_state = 3},
  [220] = {.lex_state = 3, .external_lex_state = 3},
  [221] = {.lex_state = 3, .external_lex_state = 3},
  [222] = {.lex_state = 3, .external_lex_state = 3},
  [223] = {.lex_state = 3, .external_lex_state = 3},
  [224] = {.lex_state = 3, .external_lex_state = 3},
  [225] = {.lex_state = 3, .external_lex_state = 3},
  [226] = {.lex_state = 23, .external_lex_state = 2},
  [227] = {.lex_state = 3, .external_lex_state = 3},
  [228] = {.lex_state = 22, .external_lex_state = 2},
  [229] = {.lex_state = 3, .external_lex_state = 3},
  [230] = {.lex_state = 3, .external_lex_state = 3},
  [231] = {.lex_state = 5, .external_lex_state = 3},
  [232] = {.lex_state = 5, .external_lex_state = 3},
  [233] = {.lex_state = 8},
  [234] = {.lex_state = 8},
  [235] = {.lex_state = 8},
  [236] = {.lex_state = 12},
  [237] = {.lex_state = 8},
  [238] = {.lex_state = 12},
  [239] = {.lex_state = 54},
  [240] = {.lex_state = 3},
  [241] = {.lex_state = 8},
  [242] = {.lex_state = 54},
  [243] = {.lex_state = 3},
  [244] = {.lex_state = 8},
  [245] = {.lex_state = 1, .external_lex_state = 1},
  [246] = {.lex_state = 9},
  [247] = {.lex_state = 9},
  [248] = {.lex_state = 9},
  [249] = {.lex_state = 9},
  [250] = {.lex_state = 9},
  [251] = {.lex_state = 9},
  [252] = {.lex_state = 9},
  [253] = {.lex_state = 9},
  [254] = {.lex_state = 9},
  [255] = {.lex_state = 9},
  [256] = {.lex_state = 9},
  [257] = {.lex_state = 9},
  [258] = {.lex_state = 9},
  [259] = {.lex_state = 9},
  [260] = {.lex_state = 9},
  [261] = {.lex_state = 9},
  [262] = {.lex_state = 9},
  [263] = {.lex_state = 9},
  [264] = {.lex_state = 9},
  [265] = {.lex_state = 9},
  [266] = {.lex_state = 9},
  [267] = {.lex_state = 9},
  [268] = {.lex_state = 9},
  [269] = {.lex_state = 2, .external_lex_state = 1},
  [270] = {.lex_state = 4, .external_lex_state = 3},
  [271] = {.lex_state = 2, .external_lex_state = 1},
  [272] = {.lex_state = 2, .external_lex_state = 1},
  [273] = {.lex_state = 2, .external_lex_state = 1},
  [274] = {.lex_state = 2, .external_lex_state = 1},
  [275] = {.lex_state = 2, .external_lex_state = 1},
  [276] = {.lex_state = 2, .external_lex_state = 1},
  [277] = {.lex_state = 2, .external_lex_state = 1},
  [278] = {.lex_state = 2, .external_lex_state = 1},
  [279] = {.lex_state = 2, .external_lex_state = 1},
  [280] = {.lex_state = 2, .external_lex_state = 1},
  [281] = {.lex_state = 2, .external_lex_state = 1},
  [282] = {.lex_state = 2, .external_lex_state = 1},
  [283] = {.lex_state = 11},
  [284] = {.lex_state = 53},
  [285] = {.lex_state = 6},
  [286] = {.lex_state = 5, .external_lex_state = 3},
  [287] = {.lex_state = 10},
  [288] = {.lex_state = 18, .external_lex_state = 2},
  [289] = {.lex_state = 18, .external_lex_state = 2},
  [290] = {.lex_state = 5, .external_lex_state = 3},
  [291] = {.lex_state = 18, .external_lex_state = 2},
  [292] = {.lex_state = 18, .external_lex_state = 2},
  [293] = {.lex_state = 18, .external_lex_state = 2},
  [294] = {.lex_state = 18, .external_lex_state = 2},
  [295] = {.lex_state = 18, .external_lex_state = 2},
  [296] = {.lex_state = 18, .external_lex_state = 2},
  [297] = {.lex_state = 18, .external_lex_state = 2},
  [298] = {.lex_state = 18, .external_lex_state = 2},
  [299] = {.lex_state = 5, .external_lex_state = 3},
  [300] = {.lex_state = 18, .external_lex_state = 2},
  [301] = {.lex_state = 18, .external_lex_state = 2},
  [302] = {.lex_state = 18, .external_lex_state = 2},
  [303] = {.lex_state = 18, .external_lex_state = 2},
  [304] = {.lex_state = 5, .external_lex_state = 3},
  [305] = {.lex_state = 18, .external_lex_state = 2},
  [306] = {.lex_state = 5, .external_lex_state = 3},
  [307] = {.lex_state = 18, .external_lex_state = 2},
  [308] = {.lex_state = 18, .external_lex_state = 2},
  [309] = {.lex_state = 5, .external_lex_state = 3},
  [310] = {.lex_state = 18, .external_lex_state = 2},
  [311] = {.lex_state = 18, .external_lex_state = 2},
  [312] = {.lex_state = 18, .external_lex_state = 2},
  [313] = {.lex_state = 18, .external_lex_state = 2},
  [314] = {.lex_state = 18, .external_lex_state = 2},
  [315] = {.lex_state = 18, .external_lex_state = 2},
  [316] = {.lex_state = 18, .external_lex_state = 2},
  [317] = {.lex_state = 18, .external_lex_state = 2},
  [318] = {.lex_state = 18, .external_lex_state = 2},
  [319] = {.lex_state = 18, .external_lex_state = 2},
  [320] = {.lex_state = 18, .external_lex_state = 2},
  [321] = {.lex_state = 18, .external_lex_state = 2},
  [322] = {.lex_state = 18, .external_lex_state = 2},
  [323] = {.lex_state = 18, .external_lex_state = 2},
  [324] = {.lex_state = 18, .external_lex_state = 2},
  [325] = {.lex_state = 18, .external_lex_state = 2},
  [326] = {.lex_state = 18, .external_lex_state = 2},
  [327] = {.lex_state = 18, .external_lex_state = 2},
  [328] = {.lex_state = 5, .external_lex_state = 3},
  [329] = {.lex_state = 5, .external_lex_state = 3},
  [330] = {.lex_state = 5, .external_lex_state = 3},
  [331] = {.lex_state = 18, .external_lex_state = 2},
  [332] = {.lex_state = 5, .external_lex_state = 3},
  [333] = {.lex_state = 18, .external_lex_state = 2},
  [334] = {.lex_state = 5, .external_lex_state = 3},
  [335] = {.lex_state = 18, .external_lex_state = 2},
  [336] = {.lex_state = 5, .external_lex_state = 3},
  [337] = {.lex_state = 7, .external_lex_state = 3},
  [338] = {.lex_state = 12},
  [339] = {.lex_state = 23, .external_lex_state = 2},
  [340] = {.lex_state = 21, .external_lex_state = 2},
  [341] = {.lex_state = 22, .external_lex_state = 2},
  [342] = {.lex_state = 22, .external_lex_state = 2},
  [343] = {.lex_state = 22, .external_lex_state = 2},
  [344] = {.lex_state = 22, .external_lex_state = 2},
  [345] = {.lex_state = 22, .external_lex_state = 2},
  [346] = {.lex_state = 22, .external_lex_state = 2},
  [347] = {.lex_state = 22, .external_lex_state = 2},
  [348] = {.lex_state = 22, .external_lex_state = 2},
  [349] = {.lex_state = 22, .external_lex_state = 2},
  [350] = {.lex_state = 23, .external_lex_state = 2},
  [351] = {.lex_state = 22, .external_lex_state = 2},
  [352] = {.lex_state = 22, .external_lex_state = 2},
  [353] = {.lex_state = 22, .external_lex_state = 2},
  [354] = {.lex_state = 22, .external_lex_state = 2},
  [355] = {.lex_state = 22, .external_lex_state = 2},
  [356] = {.lex_state = 22, .external_lex_state = 2},
  [357] = {.lex_state = 12},
  [358] = {.lex_state = 23, .external_lex_state = 2},
  [359] = {.lex_state = 22, .external_lex_state = 2},
  [360] = {.lex_state = 22, .external_lex_state = 2},
  [361] = {.lex_state = 22, .external_lex_state = 2},
  [362] = {.lex_state = 22, .external_lex_state = 2},
  [363] = {.lex_state = 12},
  [364] = {.lex_state = 12},
  [365] = {.lex_state = 22, .external_lex_state = 2},
  [366] = {.lex_state = 22, .external_lex_state = 2},
  [367] = {.lex_state = 19, .external_lex_state = 2},
  [368] = {.lex_state = 19, .external_lex_state = 2},
  [369] = {.lex_state = 19, .external_lex_state = 2},
  [370] = {.lex_state = 19, .external_lex_state = 2},
  [371] = {.lex_state = 19, .external_lex_state = 2},
  [372] = {.lex_state = 23, .external_lex_state = 2},
  [373] = {.lex_state = 23, .external_lex_state = 2},
  [374] = {.lex_state = 19, .external_lex_state = 2},
  [375] = {.lex_state = 19, .external_lex_state = 2},
  [376] = {.lex_state = 19, .external_lex_state = 2},
  [377] = {.lex_state = 19, .external_lex_state = 2},
  [378] = {.lex_state = 19, .external_lex_state = 2},
  [379] = {.lex_state = 19, .external_lex_state = 2},
  [380] = {.lex_state = 19, .external_lex_state = 2},
  [381] = {.lex_state = 19, .external_lex_state = 2},
  [382] = {.lex_state = 19, .external_lex_state = 2},
  [383] = {.lex_state = 19, .external_lex_state = 2},
  [384] = {.lex_state = 19, .external_lex_state = 2},
  [385] = {.lex_state = 19, .external_lex_state = 2},
  [386] = {.lex_state = 20, .external_lex_state = 2},
  [387] = {.lex_state = 19, .external_lex_state = 2},
  [388] = {.lex_state = 19, .external_lex_state = 2},
  [389] = {.lex_state = 19, .external_lex_state = 2},
  [390] = {.lex_state = 19, .external_lex_state = 2},
  [391] = {.lex_state = 19, .external_lex_state = 2},
  [392] = {.lex_state = 19, .external_lex_state = 2},
  [393] = {.lex_state = 23, .external_lex_state = 2},
  [394] = {.lex_state = 22, .external_lex_state = 2},
  [395] = {.lex_state = 19, .external_lex_state = 2},
  [396] = {.lex_state = 19, .external_lex_state = 2},
  [397] = {.lex_state = 19, .external_lex_state = 2},
  [398] = {.lex_state = 19, .external_lex_state = 2},
  [399] = {.lex_state = 20, .external_lex_state = 2},
  [400] = {.lex_state = 22, .external_lex_state = 2},
  [401] = {.lex_state = 19, .external_lex_state = 2},
  [402] = {.lex_state = 19, .external_lex_state = 2},
  [403] = {.lex_state = 22, .external_lex_state = 2},
  [404] = {.lex_state = 12},
  [405] = {.lex_state = 12},
  [406] = {.lex_state = 22, .external_lex_state = 2},
  [407] = {.lex_state = 22, .external_lex_state = 2},
  [408] = {.lex_state = 22, .external_lex_state = 2},
  [409] = {.lex_state = 22, .external_lex_state = 2},
  [410] = {.lex_state = 22, .external_lex_state = 2},
  [411] = {.lex_state = 21, .external_lex_state = 2},
  [412] = {.lex_state = 21, .external_lex_state = 2},
  [413] = {.lex_state = 22, .external_lex_state = 2},
  [414] = {.lex_state = 19, .external_lex_state = 2},
  [415] = {.lex_state = 21, .external_lex_state = 2},
  [416] = {.lex_state = 21, .external_lex_state = 2},
  [417] = {.lex_state = 21, .external_lex_state = 2},
  [418] = {.lex_state = 21, .external_lex_state = 2},
  [419] = {.lex_state = 12},
  [420] = {.lex_state = 23, .external_lex_state = 2},
  [421] = {.lex_state = 21, .external_lex_state = 2},
  [422] = {.lex_state = 21, .external_lex_state = 2},
  [423] = {.lex_state = 21, .external_lex_state = 2},
  [424] = {.lex_state = 23, .external_lex_state = 2},
  [425] = {.lex_state = 21, .external_lex_state = 2},
  [426] = {.lex_state = 21, .external_lex_state = 2},
  [427] = {.lex_state = 21, .external_lex_state = 2},
  [428] = {.lex_state = 23, .external_lex_state = 2},
  [429] = {.lex_state = 12},
  [430] = {.lex_state = 21, .external_lex_state = 2},
  [431] = {.lex_state = 21, .external_lex_state = 2},
  [432] = {.lex_state = 23, .external_lex_state = 2},
  [433] = {.lex_state = 21, .external_lex_state = 2},
  [434] = {.lex_state = 23, .external_lex_state = 2},
  [435] = {.lex_state = 21, .external_lex_state = 2},
  [436] = {.lex_state = 21, .external_lex_state = 2},
  [437] = {.lex_state = 21, .external_lex_state = 2},
  [438] = {.lex_state = 54},
  [439] = {.lex_state = 20, .external_lex_state = 2},
  [440] = {.lex_state = 21, .external_lex_state = 2},
  [441] = {.lex_state = 21, .external_lex_state = 2},
  [442] = {.lex_state = 22, .external_lex_state = 2},
  [443] = {.lex_state = 21, .external_lex_state = 2},
  [444] = {.lex_state = 21, .external_lex_state = 2},
  [445] = {.lex_state = 19, .external_lex_state = 2},
  [446] = {.lex_state = 23, .external_lex_state = 2},
  [447] = {.lex_state = 23, .external_lex_state = 2},
  [448] = {.lex_state = 23, .external_lex_state = 2},
  [449] = {.lex_state = 21, .external_lex_state = 2},
  [450] = {.lex_state = 21, .external_lex_state = 2},
  [451] = {.lex_state = 21, .external_lex_state = 2},
  [452] = {.lex_state = 23, .external_lex_state = 2},
  [453] = {.lex_state = 23, .external_lex_state = 2},
  [454] = {.lex_state = 21, .external_lex_state = 2},
  [455] = {.lex_state = 21, .external_lex_state = 2},
  [456] = {.lex_state = 21, .external_lex_state = 2},
  [457] = {.lex_state = 21, .external_lex_state = 2},
  [458] = {.lex_state = 21, .external_lex_state = 2},
  [459] = {.lex_state = 20, .external_lex_state = 2},
  [460] = {.lex_state = 20, .external_lex_state = 2},
  [461] = {.lex_state = 23, .external_lex_state = 2},
  [462] = {.lex_state = 23, .external_lex_state = 2},
  [463] = {.lex_state = 20, .external_lex_state = 2},
  [464] = {.lex_state = 20, .external_lex_state = 2},
  [465] = {.lex_state = 8},
  [466] = {.lex_state = 20, .external_lex_state = 2},
  [467] = {.lex_state = 20, .external_lex_state = 2},
  [468] = {.lex_state = 20, .external_lex_state = 2},
  [469] = {.lex_state = 21, .external_lex_state = 2},
  [470] = {.lex_state = 22, .external_lex_state = 2},
  [471] = {.lex_state = 20, .external_lex_state = 2},
  [472] = {.lex_state = 20, .external_lex_state = 2},
  [473] = {.lex_state = 19, .external_lex_state = 2},
  [474] = {.lex_state = 20, .external_lex_state = 2},
  [475] = {.lex_state = 23, .external_lex_state = 2},
  [476] = {.lex_state = 20, .external_lex_state = 2},
  [477] = {.lex_state = 20, .external_lex_state = 2},
  [478] = {.lex_state = 20, .external_lex_state = 2},
  [479] = {.lex_state = 23, .external_lex_state = 2},
  [480] = {.lex_state = 23, .external_lex_state = 2},
  [481] = {.lex_state = 23, .external_lex_state = 2},
  [482] = {.lex_state = 23, .external_lex_state = 2},
  [483] = {.lex_state = 23, .external_lex_state = 2},
  [484] = {.lex_state = 20, .external_lex_state = 2},
  [485] = {.lex_state = 20, .external_lex_state = 2},
  [486] = {.lex_state = 23, .external_lex_state = 2},
  [487] = {.lex_state = 23, .external_lex_state = 2},
  [488] = {.lex_state = 23, .external_lex_state = 2},
  [489] = {.lex_state = 23, .external_lex_state = 2},
  [490] = {.lex_state = 20, .external_lex_state = 2},
  [491] = {.lex_state = 20, .external_lex_state = 2},
  [492] = {.lex_state = 20, .external_lex_state = 2},
  [493] = {.lex_state = 23, .external_lex_state = 2},
  [494] = {.lex_state = 3},
  [495] = {.lex_state = 20, .external_lex_state = 2},
  [496] = {.lex_state = 20, .external_lex_state = 2},
  [497] = {.lex_state = 20, .external_lex_state = 2},
  [498] = {.lex_state = 20, .external_lex_state = 2},
  [499] = {.lex_state = 20, .external_lex_state = 2},
  [500] = {.lex_state = 20, .external_lex_state = 2},
  [501] = {.lex_state = 20, .external_lex_state = 2},
  [502] = {.lex_state = 20, .external_lex_state = 2},
  [503] = {.lex_state = 20, .external_lex_state = 2},
  [504] = {.lex_state = 20, .external_lex_state = 2},
  [505] = {.lex_state = 20, .external_lex_state = 2},
  [506] = {.lex_state = 3},
  [507] = {.lex_state = 54},
  [508] = {.lex_state = 3},
  [509] = {.lex_state = 3},
  [510] = {.lex_state = 54},
  [511] = {.lex_state = 8},
  [512] = {.lex_state = 8},
  [513] = {.lex_state = 8},
  [514] = {.lex_state = 54},
  [515] = {.lex_state = 8},
  [516] = {.lex_state = 54},
  [517] = {.lex_state = 54},
  [518] = {.lex_state = 8},
  [519] = {.lex_state = 54},
  [520] = {.lex_state = 54},
  [521] = {.lex_state = 9},
  [522] = {.lex_state = 9},
  [523] = {.lex_state = 8},
  [524] = {.lex_state = 9},
  [525] = {.lex_state = 8},
  [526] = {.lex_state = 9},
  [527] = {.lex_state = 3},
  [528] = {.lex_state = 9},
  [529] = {.lex_state = 3},
  [530] = {.lex_state = 3},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 9},
  [533] = {.lex_state = 9},
  [534] = {.lex_state = 9},
  [535] = {.lex_state = 9},
  [536] = {.lex_state = 9},
  [537] = {.lex_state = 9},
  [538] = {.lex_state = 9},
  [539] = {.lex_state = 9},
  [540] = {.lex_state = 9},
  [541] = {.lex_state = 9},
  [542] = {.lex_state = 9},
  [543] = {.lex_state = 9},
  [544] = {.lex_state = 9},
  [545] = {.lex_state = 9},
  [546] = {.lex_state = 9},
  [547] = {.lex_state = 9},
  [548] = {.lex_state = 9},
  [549] = {.lex_state = 9},
  [550] = {.lex_state = 9},
  [551] = {.lex_state = 9},
  [552] = {.lex_state = 9},
  [553] = {.lex_state = 9},
  [554] = {.lex_state = 9},
  [555] = {.lex_state = 9},
  [556] = {.lex_state = 9},
  [557] = {.lex_state = 9},
  [558] = {.lex_state = 9},
  [559] = {.lex_state = 9},
  [560] = {.lex_state = 9},
  [561] = {.lex_state = 9},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 9},
  [564] = {.lex_state = 9},
  [565] = {.lex_state = 9},
  [566] = {.lex_state = 9},
  [567] = {.lex_state = 9},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 9},
  [570] = {.lex_state = 9},
  [571] = {.lex_state = 9},
  [572] = {.lex_state = 9},
  [573] = {.lex_state = 9},
  [574] = {.lex_state = 9},
  [575] = {.lex_state = 9},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 9},
  [578] = {.lex_state = 9},
  [579] = {.lex_state = 9},
  [580] = {.lex_state = 9},
  [581] = {.lex_state = 9},
  [582] = {.lex_state = 9},
  [583] = {.lex_state = 9},
  [584] = {.lex_state = 9},
  [585] = {.lex_state = 9},
  [586] = {.lex_state = 9},
  [587] = {.lex_state = 9},
  [588] = {.lex_state = 9},
  [589] = {.lex_state = 9},
  [590] = {.lex_state = 9},
  [591] = {.lex_state = 9},
  [592] = {.lex_state = 9},
  [593] = {.lex_state = 9},
  [594] = {.lex_state = 9},
  [595] = {.lex_state = 9},
  [596] = {.lex_state = 9},
  [597] = {.lex_state = 9},
  [598] = {.lex_state = 9},
  [599] = {.lex_state = 9},
  [600] = {.lex_state = 9},
  [601] = {.lex_state = 9},
  [602] = {.lex_state = 9},
  [603] = {.lex_state = 9},
  [604] = {.lex_state = 9},
  [605] = {.lex_state = 9},
  [606] = {.lex_state = 9},
  [607] = {.lex_state = 9},
  [608] = {.lex_state = 9},
  [609] = {.lex_state = 9},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 9},
  [613] = {.lex_state = 9},
  [614] = {.lex_state = 9},
  [615] = {.lex_state = 9},
  [616] = {.lex_state = 9},
  [617] = {.lex_state = 9},
  [618] = {.lex_state = 9},
  [619] = {.lex_state = 9},
  [620] = {.lex_state = 9},
  [621] = {.lex_state = 9},
  [622] = {.lex_state = 9},
  [623] = {.lex_state = 9},
  [624] = {.lex_state = 55},
  [625] = {.lex_state = 55},
  [626] = {.lex_state = 55},
  [627] = {.lex_state = 55},
  [628] = {.lex_state = 55},
  [629] = {.lex_state = 55},
  [630] = {.lex_state = 55},
  [631] = {.lex_state = 55},
  [632] = {.lex_state = 55},
  [633] = {.lex_state = 55},
  [634] = {.lex_state = 55},
  [635] = {.lex_state = 55},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 23},
  [641] = {.lex_state = 23},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 56},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 23},
  [647] = {.lex_state = 56},
  [648] = {.lex_state = 56},
  [649] = {.lex_state = 56},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 23},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 23},
  [660] = {.lex_state = 23},
  [661] = {.lex_state = 56},
  [662] = {.lex_state = 56},
  [663] = {.lex_state = 56},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 56},
  [669] = {.lex_state = 23},
  [670] = {.lex_state = 23},
  [671] = {.lex_state = 23},
  [672] = {.lex_state = 23},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 23},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 23},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 23},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 23},
  [685] = {.lex_state = 56},
  [686] = {.lex_state = 23},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 23},
  [689] = {.lex_state = 56},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 56},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 23},
  [694] = {.lex_state = 23},
  [695] = {.lex_state = 56},
  [696] = {.lex_state = 56},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 23},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 56},
  [703] = {.lex_state = 23},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 56},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 23},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
};

enum {
  ts_external_token_bracket_argument = 0,
  ts_external_token_bracket_comment = 1,
  ts_external_token_line_comment = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_bracket_argument] = sym_bracket_argument,
  [ts_external_token_bracket_comment] = sym_bracket_comment,
  [ts_external_token_line_comment] = sym_line_comment,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_bracket_argument] = true,
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [2] = {
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [3] = {
    [ts_external_token_bracket_argument] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__escape_identity] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_BSLASH_SEMI] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_ENV] = ACTIONS(1),
    [anon_sym_CACHE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [aux_sym__gen_exp_arguments_token1] = ACTIONS(1),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym__unquoted_text_token1] = ACTIONS(1),
    [aux_sym_if_command_token1] = ACTIONS(1),
    [sym_bracket_argument] = ACTIONS(1),
    [sym_bracket_comment] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(710),
    [sym_if_command] = STATE(133),
    [sym_if_condition] = STATE(213),
    [sym_foreach_command] = STATE(173),
    [sym_foreach_loop] = STATE(213),
    [sym_while_command] = STATE(176),
    [sym_while_loop] = STATE(213),
    [sym_function_command] = STATE(178),
    [sym_function_def] = STATE(213),
    [sym_macro_command] = STATE(181),
    [sym_macro_def] = STATE(213),
    [sym_normal_command] = STATE(213),
    [sym__command_invocation] = STATE(213),
    [sym__untrimmed_command_invocation] = STATE(213),
    [aux_sym_source_file_repeat1] = STATE(213),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(5),
    [sym_if] = ACTIONS(7),
    [sym_foreach] = ACTIONS(9),
    [sym_while] = ACTIONS(11),
    [sym_function] = ACTIONS(13),
    [sym_macro] = ACTIONS(15),
    [sym_identifier] = ACTIONS(17),
    [sym_bracket_comment] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_RPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [59] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(37), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(35), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(113), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [118] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(41), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(39), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(5), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [177] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(43), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [236] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(43), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(45), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(10), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [295] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(49), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(11), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [354] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(53), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(51), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(13), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [413] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(57), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(55), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(16), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [472] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [531] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [590] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(63), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(18), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [649] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [708] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(67), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(20), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [767] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(69), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(52), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [826] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [885] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(75), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(22), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [944] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1003] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(60), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1062] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1121] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(87), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(85), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(63), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1180] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(89), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1239] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(91), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(66), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1298] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(95), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(26), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1357] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(99), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(69), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1416] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1475] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(105), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(31), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1534] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(107), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(32), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1593] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(111), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(34), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1652] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(115), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(36), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1711] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1770] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1829] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(123), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(38), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1888] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1947] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(127), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(39), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2006] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2065] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(131), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(40), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2124] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2183] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2242] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2301] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(139), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(42), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2360] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2419] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(145), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(47), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2478] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(149), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(147), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(49), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2537] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(151), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(51), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2596] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(155), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(55), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2655] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2714] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(161), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(96), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2773] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2832] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(167), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(59), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2891] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2950] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3009] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(173), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(67), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3068] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(175), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(105), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3127] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3186] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(179), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(78), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3245] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3304] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(183), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(107), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3363] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(185), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3422] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(187), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3481] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(187), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(189), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(109), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3540] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(191), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3599] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(193), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3658] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(193), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(195), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(111), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3717] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(197), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3776] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(37), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3835] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(199), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3894] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(201), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3953] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4012] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(205), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(115), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4071] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(207), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(117), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4130] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(213), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(211), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(62), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4189] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(215), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(120), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4248] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(213), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4307] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(219), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(123), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4366] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(225), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(223), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(65), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4425] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(225), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4484] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4543] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(229), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(89), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4602] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(235), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(233), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(57), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4661] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(237), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(68), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4720] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4779] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(241), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4838] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(243), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4897] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(247), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(245), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(127), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4956] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(251), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(249), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(74), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5015] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(253), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(77), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5074] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(259), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(257), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(122), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5133] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(261), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5192] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(263), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(82), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5251] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(261), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(267), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(101), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5310] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(269), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(83), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5369] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5428] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(275), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(273), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(103), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5487] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(279), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(277), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(106), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5546] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(281), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5605] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(283), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5664] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(287), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(285), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(110), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5723] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(289), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5782] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(291), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5841] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(293), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5900] = 13,
    ACTIONS(298), 1,
      anon_sym_DOLLAR,
    ACTIONS(304), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    ACTIONS(309), 1,
      anon_sym_DQUOTE,
    ACTIONS(312), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(315), 1,
      sym_bracket_argument,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(301), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(295), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5959] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(318), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6018] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(318), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(320), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(116), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6077] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(322), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6136] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(324), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6195] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(326), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6254] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(324), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(328), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(125), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6313] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(330), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6372] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(332), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6431] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(334), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6490] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(332), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(336), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(128), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6549] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(338), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6608] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(342), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(340), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(93), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6667] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(344), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6726] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(346), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6785] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(348), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6844] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(348), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(350), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(100), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6903] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(354), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(352), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(2), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6962] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(356), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7021] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(356), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(358), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7080] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(354), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7139] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(360), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7198] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(360), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(362), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(97), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7257] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(364), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7316] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(368), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(366), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(84), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7375] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(368), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7434] = 13,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(33), 1,
      sym_bracket_argument,
    ACTIONS(370), 1,
      anon_sym_RPAREN,
    STATE(275), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(23), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(102), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(142), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [7493] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(378), 1,
      sym_endif,
    ACTIONS(380), 1,
      sym_identifier,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(450), 1,
      sym_endif_command,
    ACTIONS(372), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7557] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(375), 1,
      sym_endif_command,
    ACTIONS(372), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7621] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(386), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(308), 1,
      sym_endif_command,
    ACTIONS(384), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(132), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7685] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(386), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(316), 1,
      sym_endif_command,
    ACTIONS(372), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7749] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(390), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(350), 1,
      sym_endif_command,
    ACTIONS(388), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(134), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7813] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(390), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(424), 1,
      sym_endif_command,
    ACTIONS(372), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7877] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(501), 1,
      sym_endif_command,
    ACTIONS(392), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(136), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [7941] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(394), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(499), 1,
      sym_endif_command,
    ACTIONS(372), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8005] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(398), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(410), 1,
      sym_endif_command,
    ACTIONS(396), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(139), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8069] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(378), 1,
      sym_endif,
    ACTIONS(380), 1,
      sym_identifier,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(458), 1,
      sym_endif_command,
    ACTIONS(400), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8133] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(398), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(394), 1,
      sym_endif_command,
    ACTIONS(372), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8197] = 17,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(374), 1,
      sym_elseif,
    ACTIONS(376), 1,
      sym_else,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_endif,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    STATE(367), 1,
      sym_endif_command,
    ACTIONS(402), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8261] = 16,
    ACTIONS(407), 1,
      sym_if,
    ACTIONS(410), 1,
      sym_elseif,
    ACTIONS(413), 1,
      sym_else,
    ACTIONS(416), 1,
      sym_endif,
    ACTIONS(418), 1,
      sym_foreach,
    ACTIONS(421), 1,
      sym_while,
    ACTIONS(424), 1,
      sym_function,
    ACTIONS(427), 1,
      sym_macro,
    ACTIONS(430), 1,
      sym_identifier,
    STATE(131), 1,
      sym_if_command,
    STATE(157), 1,
      sym_foreach_command,
    STATE(158), 1,
      sym_while_command,
    STATE(160), 1,
      sym_function_command,
    STATE(162), 1,
      sym_macro_command,
    ACTIONS(404), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(141), 11,
      sym_elseif_command,
      sym_else_command,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_if_condition_repeat1,
  [8322] = 7,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(435), 1,
      aux_sym__unquoted_text_token1,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(19), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(152), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(433), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [8363] = 12,
    ACTIONS(439), 1,
      anon_sym_DOLLAR,
    ACTIONS(441), 1,
      anon_sym_GT,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(445), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(447), 1,
      sym_bracket_argument,
    STATE(562), 1,
      sym_argument,
    STATE(673), 1,
      sym__gen_exp_content,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(437), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(236), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8414] = 12,
    ACTIONS(439), 1,
      anon_sym_DOLLAR,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(445), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(449), 1,
      anon_sym_GT,
    STATE(562), 1,
      sym_argument,
    STATE(636), 1,
      sym__gen_exp_content,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(437), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(236), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8465] = 12,
    ACTIONS(453), 1,
      anon_sym_DOLLAR,
    ACTIONS(455), 1,
      anon_sym_GT,
    ACTIONS(457), 1,
      anon_sym_DQUOTE,
    ACTIONS(459), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(461), 1,
      sym_bracket_argument,
    STATE(150), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(304), 1,
      sym_argument,
    STATE(290), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(334), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(332), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(451), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(231), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8516] = 12,
    ACTIONS(439), 1,
      anon_sym_DOLLAR,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(445), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(463), 1,
      anon_sym_GT,
    STATE(562), 1,
      sym_argument,
    STATE(690), 1,
      sym__gen_exp_content,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(437), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(236), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8567] = 12,
    ACTIONS(439), 1,
      anon_sym_DOLLAR,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(445), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(465), 1,
      anon_sym_GT,
    STATE(562), 1,
      sym_argument,
    STATE(675), 1,
      sym__gen_exp_content,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(437), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(236), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8618] = 12,
    ACTIONS(439), 1,
      anon_sym_DOLLAR,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(445), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(467), 1,
      anon_sym_GT,
    STATE(562), 1,
      sym_argument,
    STATE(645), 1,
      sym__gen_exp_content,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(437), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(236), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8669] = 12,
    ACTIONS(453), 1,
      anon_sym_DOLLAR,
    ACTIONS(457), 1,
      anon_sym_DQUOTE,
    ACTIONS(459), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(461), 1,
      sym_bracket_argument,
    ACTIONS(469), 1,
      anon_sym_GT,
    STATE(145), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(304), 1,
      sym_argument,
    STATE(290), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(334), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(332), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(451), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(231), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8720] = 12,
    ACTIONS(474), 1,
      anon_sym_DOLLAR,
    ACTIONS(477), 1,
      anon_sym_GT,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(482), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(485), 1,
      sym_bracket_argument,
    STATE(150), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(304), 1,
      sym_argument,
    STATE(290), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(334), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(332), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(471), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(231), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8771] = 12,
    ACTIONS(439), 1,
      anon_sym_DOLLAR,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(445), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(488), 1,
      anon_sym_GT,
    STATE(562), 1,
      sym_argument,
    STATE(657), 1,
      sym__gen_exp_content,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(437), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(236), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [8822] = 7,
    ACTIONS(493), 1,
      anon_sym_DOLLAR,
    ACTIONS(498), 1,
      aux_sym__unquoted_text_token1,
    STATE(281), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(274), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(490), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(152), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(496), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [8863] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(503), 1,
      sym_endmacro,
    ACTIONS(505), 1,
      sym_identifier,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(504), 1,
      sym_endmacro_command,
    ACTIONS(501), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(194), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8919] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(509), 1,
      sym_endforeach,
    ACTIONS(511), 1,
      sym_identifier,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(502), 1,
      sym_endforeach_command,
    ACTIONS(507), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(190), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8975] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(515), 1,
      sym_endwhile,
    ACTIONS(517), 1,
      sym_identifier,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(377), 1,
      sym_endwhile_command,
    ACTIONS(513), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9031] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(523), 1,
      anon_sym_RPAREN,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    STATE(687), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9079] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(529), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(297), 1,
      sym_endforeach_command,
    ACTIONS(527), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(164), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9135] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(533), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(317), 1,
      sym_endwhile_command,
    ACTIONS(531), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(165), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9191] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(537), 1,
      sym_endfunction,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(378), 1,
      sym_endfunction_command,
    ACTIONS(535), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(228), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9247] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(543), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(326), 1,
      sym_endfunction_command,
    ACTIONS(541), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(166), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9303] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(545), 1,
      anon_sym_RPAREN,
    STATE(680), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9351] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(549), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(327), 1,
      sym_endmacro_command,
    ACTIONS(547), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(168), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9407] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(515), 1,
      sym_endwhile,
    ACTIONS(517), 1,
      sym_identifier,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(369), 1,
      sym_endwhile_command,
    ACTIONS(551), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9463] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(529), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(333), 1,
      sym_endforeach_command,
    ACTIONS(553), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9519] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(533), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(296), 1,
      sym_endwhile_command,
    ACTIONS(513), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9575] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(543), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(293), 1,
      sym_endfunction_command,
    ACTIONS(535), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(228), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9631] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(557), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(379), 1,
      sym_endmacro_command,
    ACTIONS(555), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9687] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(549), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(298), 1,
      sym_endmacro_command,
    ACTIONS(555), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9743] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(559), 1,
      anon_sym_RPAREN,
    STATE(652), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9791] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(537), 1,
      sym_endfunction,
    ACTIONS(539), 1,
      sym_identifier,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(370), 1,
      sym_endfunction_command,
    ACTIONS(561), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(159), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9847] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(563), 1,
      anon_sym_RPAREN,
    STATE(682), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9895] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(557), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(371), 1,
      sym_endmacro_command,
    ACTIONS(565), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(167), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9951] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(569), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(358), 1,
      sym_endforeach_command,
    ACTIONS(567), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(197), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10007] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
    STATE(650), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10055] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(573), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(343), 1,
      sym_endmacro_command,
    ACTIONS(555), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10111] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(372), 1,
      sym_endwhile_command,
    ACTIONS(575), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(211), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10167] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(579), 1,
      anon_sym_RPAREN,
    STATE(644), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10215] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(583), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(373), 1,
      sym_endfunction_command,
    ACTIONS(581), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(198), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10271] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(585), 1,
      anon_sym_RPAREN,
    STATE(658), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10319] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(341), 1,
      sym_endwhile_command,
    ACTIONS(513), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10375] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(591), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(393), 1,
      sym_endmacro_command,
    ACTIONS(589), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(207), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10431] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(593), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(400), 1,
      sym_endforeach_command,
    ACTIONS(553), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10487] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(595), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(376), 1,
      sym_endforeach_command,
    ACTIONS(553), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10543] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(599), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(503), 1,
      sym_endwhile_command,
    ACTIONS(597), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(191), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10599] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(603), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(505), 1,
      sym_endfunction_command,
    ACTIONS(601), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(192), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10655] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(605), 1,
      anon_sym_RPAREN,
    STATE(665), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10703] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(573), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(406), 1,
      sym_endmacro_command,
    ACTIONS(607), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(175), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10759] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(611), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(407), 1,
      sym_endfunction_command,
    ACTIONS(609), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(208), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10815] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(587), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(408), 1,
      sym_endwhile_command,
    ACTIONS(613), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(180), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10871] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(509), 1,
      sym_endforeach,
    ACTIONS(511), 1,
      sym_identifier,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(498), 1,
      sym_endforeach_command,
    ACTIONS(553), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10927] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(599), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(497), 1,
      sym_endwhile_command,
    ACTIONS(513), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [10983] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(603), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(496), 1,
      sym_endfunction_command,
    ACTIONS(535), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(228), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11039] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(615), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(441), 1,
      sym_endmacro_command,
    ACTIONS(555), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11095] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(503), 1,
      sym_endmacro,
    ACTIONS(505), 1,
      sym_identifier,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(495), 1,
      sym_endmacro_command,
    ACTIONS(555), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11151] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(617), 1,
      anon_sym_RPAREN,
    STATE(683), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11199] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(619), 1,
      anon_sym_RPAREN,
    STATE(714), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11247] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(569), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(453), 1,
      sym_endforeach_command,
    ACTIONS(553), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11303] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(583), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(432), 1,
      sym_endfunction_command,
    ACTIONS(535), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(228), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11359] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(623), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(457), 1,
      sym_endforeach_command,
    ACTIONS(621), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(202), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11415] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(627), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(456), 1,
      sym_endwhile_command,
    ACTIONS(625), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(203), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11471] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(631), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(455), 1,
      sym_endfunction_command,
    ACTIONS(629), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(204), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11527] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(623), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(449), 1,
      sym_endforeach_command,
    ACTIONS(553), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11583] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(627), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(444), 1,
      sym_endwhile_command,
    ACTIONS(513), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11639] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(631), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(443), 1,
      sym_endfunction_command,
    ACTIONS(535), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(228), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11695] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(593), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(409), 1,
      sym_endforeach_command,
    ACTIONS(633), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(182), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11751] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(615), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(454), 1,
      sym_endmacro_command,
    ACTIONS(635), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(193), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11807] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(505), 1,
      sym_identifier,
    ACTIONS(591), 1,
      sym_endmacro,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    STATE(434), 1,
      sym_endmacro_command,
    ACTIONS(555), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11863] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(611), 1,
      sym_endfunction,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    STATE(342), 1,
      sym_endfunction_command,
    ACTIONS(535), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(228), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [11919] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(637), 1,
      anon_sym_RPAREN,
    STATE(676), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11967] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(595), 1,
      sym_endforeach,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    STATE(368), 1,
      sym_endforeach_command,
    ACTIONS(639), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(183), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12023] = 15,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(517), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_endwhile,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    STATE(428), 1,
      sym_endwhile_command,
    ACTIONS(513), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12079] = 11,
    ACTIONS(443), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym_bracket_argument,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(641), 1,
      anon_sym_RPAREN,
    STATE(642), 1,
      sym_argument,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(611), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(240), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12127] = 14,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_identifier,
    ACTIONS(643), 1,
      ts_builtin_sym_end,
    STATE(133), 1,
      sym_if_command,
    STATE(173), 1,
      sym_foreach_command,
    STATE(176), 1,
      sym_while_command,
    STATE(178), 1,
      sym_function_command,
    STATE(181), 1,
      sym_macro_command,
    ACTIONS(645), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(226), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12180] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(696), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12225] = 14,
    ACTIONS(660), 1,
      sym_if,
    ACTIONS(663), 1,
      sym_foreach,
    ACTIONS(666), 1,
      sym_while,
    ACTIONS(669), 1,
      sym_function,
    ACTIONS(672), 1,
      sym_macro,
    ACTIONS(675), 1,
      sym_endmacro,
    ACTIONS(677), 1,
      sym_identifier,
    STATE(140), 1,
      sym_if_command,
    STATE(163), 1,
      sym_while_command,
    STATE(170), 1,
      sym_function_command,
    STATE(172), 1,
      sym_macro_command,
    STATE(210), 1,
      sym_foreach_command,
    ACTIONS(657), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12278] = 14,
    ACTIONS(660), 1,
      sym_if,
    ACTIONS(663), 1,
      sym_foreach,
    ACTIONS(666), 1,
      sym_while,
    ACTIONS(669), 1,
      sym_function,
    ACTIONS(672), 1,
      sym_macro,
    ACTIONS(675), 1,
      sym_endforeach,
    ACTIONS(683), 1,
      sym_identifier,
    STATE(135), 1,
      sym_if_command,
    STATE(153), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_foreach_command,
    STATE(184), 1,
      sym_while_command,
    STATE(185), 1,
      sym_function_command,
    ACTIONS(680), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(216), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12331] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(717), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12376] = 14,
    ACTIONS(660), 1,
      sym_if,
    ACTIONS(663), 1,
      sym_foreach,
    ACTIONS(666), 1,
      sym_while,
    ACTIONS(669), 1,
      sym_function,
    ACTIONS(672), 1,
      sym_macro,
    ACTIONS(675), 1,
      sym_endwhile,
    ACTIONS(689), 1,
      sym_identifier,
    STATE(138), 1,
      sym_if_command,
    STATE(199), 1,
      sym_foreach_command,
    STATE(200), 1,
      sym_while_command,
    STATE(201), 1,
      sym_function_command,
    STATE(206), 1,
      sym_macro_command,
    ACTIONS(686), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(218), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12429] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(648), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12474] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(663), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12519] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(662), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12564] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(661), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12609] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(649), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12654] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(702), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12699] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(695), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12744] = 14,
    ACTIONS(660), 1,
      sym_if,
    ACTIONS(663), 1,
      sym_foreach,
    ACTIONS(666), 1,
      sym_while,
    ACTIONS(669), 1,
      sym_function,
    ACTIONS(672), 1,
      sym_macro,
    ACTIONS(692), 1,
      ts_builtin_sym_end,
    ACTIONS(697), 1,
      sym_identifier,
    STATE(133), 1,
      sym_if_command,
    STATE(173), 1,
      sym_foreach_command,
    STATE(176), 1,
      sym_while_command,
    STATE(178), 1,
      sym_function_command,
    STATE(181), 1,
      sym_macro_command,
    ACTIONS(694), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(226), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12797] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(689), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12842] = 14,
    ACTIONS(660), 1,
      sym_if,
    ACTIONS(663), 1,
      sym_foreach,
    ACTIONS(666), 1,
      sym_while,
    ACTIONS(669), 1,
      sym_function,
    ACTIONS(672), 1,
      sym_macro,
    ACTIONS(675), 1,
      sym_endfunction,
    ACTIONS(703), 1,
      sym_identifier,
    STATE(137), 1,
      sym_if_command,
    STATE(187), 1,
      sym_macro_command,
    STATE(188), 1,
      sym_function_command,
    STATE(189), 1,
      sym_while_command,
    STATE(205), 1,
      sym_foreach_command,
    ACTIONS(700), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(228), 9,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [12895] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(668), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12940] = 10,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(655), 1,
      sym_bracket_argument,
    STATE(691), 1,
      sym_argument,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(643), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(239), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [12985] = 8,
    ACTIONS(453), 1,
      anon_sym_DOLLAR,
    ACTIONS(706), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(708), 1,
      aux_sym__unquoted_text_token1,
    STATE(334), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(433), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(332), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(451), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(232), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13025] = 8,
    ACTIONS(713), 1,
      anon_sym_DOLLAR,
    ACTIONS(716), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(718), 1,
      aux_sym__unquoted_text_token1,
    STATE(334), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(496), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(332), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(710), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(232), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13065] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(725), 1,
      anon_sym_DQUOTE,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    STATE(692), 1,
      sym_quoted_element,
    STATE(525), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(523), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13103] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(729), 1,
      anon_sym_DQUOTE,
    STATE(651), 1,
      sym_quoted_element,
    STATE(525), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(523), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13141] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(731), 1,
      anon_sym_DQUOTE,
    STATE(681), 1,
      sym_quoted_element,
    STATE(525), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(523), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13179] = 7,
    ACTIONS(439), 1,
      anon_sym_DOLLAR,
    ACTIONS(733), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(433), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(437), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(238), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13215] = 8,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(727), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(735), 1,
      anon_sym_DQUOTE,
    STATE(655), 1,
      sym_quoted_element,
    STATE(525), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(523), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(244), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13253] = 7,
    ACTIONS(740), 1,
      anon_sym_DOLLAR,
    ACTIONS(743), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(496), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(405), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(404), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(737), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(238), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13289] = 7,
    ACTIONS(649), 1,
      anon_sym_DOLLAR,
    ACTIONS(706), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(746), 1,
      aux_sym__unquoted_text_token1,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(647), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(242), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13324] = 7,
    ACTIONS(433), 1,
      anon_sym_RPAREN,
    ACTIONS(521), 1,
      anon_sym_DOLLAR,
    ACTIONS(748), 1,
      aux_sym__unquoted_text_token1,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(519), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(243), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13359] = 7,
    ACTIONS(753), 1,
      anon_sym_DOLLAR,
    ACTIONS(756), 1,
      anon_sym_DQUOTE,
    ACTIONS(758), 1,
      aux_sym__quoted_text_token1,
    STATE(525), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(523), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(750), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(241), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13394] = 7,
    ACTIONS(716), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(764), 1,
      anon_sym_DOLLAR,
    ACTIONS(767), 1,
      aux_sym__unquoted_text_token1,
    STATE(514), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(516), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(761), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(242), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13429] = 7,
    ACTIONS(496), 1,
      anon_sym_RPAREN,
    ACTIONS(773), 1,
      anon_sym_DOLLAR,
    ACTIONS(776), 1,
      aux_sym__unquoted_text_token1,
    STATE(508), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(509), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(770), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(243), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [13464] = 7,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(779), 1,
      anon_sym_DQUOTE,
    ACTIONS(781), 1,
      aux_sym__quoted_text_token1,
    STATE(525), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(523), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(721), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(241), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [13499] = 6,
    ACTIONS(785), 1,
      anon_sym_LBRACE,
    ACTIONS(787), 1,
      anon_sym_ENV,
    ACTIONS(789), 1,
      anon_sym_CACHE,
    ACTIONS(791), 1,
      anon_sym_LT,
    ACTIONS(793), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(783), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13531] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(686), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13563] = 7,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    ACTIONS(801), 1,
      aux_sym_variable_token1,
    ACTIONS(803), 1,
      anon_sym_RBRACE,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(258), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13595] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(674), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13627] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(660), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13659] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(641), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13691] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(703), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13723] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(646), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13755] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(659), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13787] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(684), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13819] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(656), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13851] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(693), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13883] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(698), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13915] = 7,
    ACTIONS(808), 1,
      aux_sym_variable_token1,
    ACTIONS(811), 1,
      anon_sym_DOLLAR,
    ACTIONS(814), 1,
      anon_sym_RBRACE,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(258), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(805), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13947] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(670), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [13979] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(669), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14011] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(694), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14043] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(672), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14075] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(671), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14107] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(677), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14139] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(640), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14171] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(688), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14203] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(719), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14235] = 7,
    ACTIONS(797), 1,
      aux_sym_variable_token1,
    ACTIONS(799), 1,
      anon_sym_DOLLAR,
    STATE(679), 1,
      sym_variable,
    STATE(528), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(247), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(526), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(795), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [14267] = 4,
    ACTIONS(818), 1,
      anon_sym_DOLLAR,
    ACTIONS(821), 1,
      aux_sym__unquoted_text_token1,
    STATE(269), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(816), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14292] = 6,
    ACTIONS(824), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      anon_sym_ENV,
    ACTIONS(828), 1,
      anon_sym_CACHE,
    ACTIONS(830), 1,
      anon_sym_LT,
    ACTIONS(793), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(783), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14321] = 2,
    ACTIONS(834), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(832), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14341] = 2,
    ACTIONS(838), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(836), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14361] = 2,
    ACTIONS(842), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(840), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14381] = 2,
    ACTIONS(846), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14401] = 2,
    ACTIONS(850), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(848), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14421] = 2,
    ACTIONS(854), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(852), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14441] = 2,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(856), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14461] = 2,
    ACTIONS(862), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(860), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14481] = 2,
    ACTIONS(866), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(864), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14501] = 2,
    ACTIONS(870), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14521] = 2,
    ACTIONS(874), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(872), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14541] = 2,
    ACTIONS(878), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [14561] = 6,
    ACTIONS(793), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_ENV,
    ACTIONS(884), 1,
      anon_sym_CACHE,
    ACTIONS(886), 1,
      anon_sym_LT,
    ACTIONS(783), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [14588] = 6,
    ACTIONS(888), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_ENV,
    ACTIONS(892), 1,
      anon_sym_CACHE,
    ACTIONS(894), 1,
      anon_sym_LT,
    ACTIONS(793), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(783), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [14614] = 6,
    ACTIONS(898), 1,
      anon_sym_LBRACE,
    ACTIONS(900), 1,
      anon_sym_ENV,
    ACTIONS(902), 1,
      anon_sym_CACHE,
    ACTIONS(904), 1,
      anon_sym_LT,
    ACTIONS(906), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(896), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [14640] = 5,
    ACTIONS(908), 1,
      anon_sym_DOLLAR,
    ACTIONS(911), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(913), 1,
      aux_sym__unquoted_text_token1,
    STATE(286), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(816), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14664] = 6,
    ACTIONS(793), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    ACTIONS(918), 1,
      anon_sym_ENV,
    ACTIONS(920), 1,
      anon_sym_CACHE,
    ACTIONS(922), 1,
      anon_sym_LT,
    ACTIONS(783), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [14690] = 2,
    ACTIONS(924), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(926), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14707] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14724] = 2,
    ACTIONS(850), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(848), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14741] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14758] = 2,
    ACTIONS(936), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(938), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14775] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14792] = 2,
    ACTIONS(944), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(946), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14809] = 2,
    ACTIONS(948), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(950), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14826] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14843] = 2,
    ACTIONS(956), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(958), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14860] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14877] = 2,
    ACTIONS(834), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(832), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14894] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14911] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14928] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14945] = 2,
    ACTIONS(976), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(978), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14962] = 3,
    ACTIONS(982), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(984), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(980), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14981] = 2,
    ACTIONS(986), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(988), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [14998] = 2,
    ACTIONS(858), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(856), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15015] = 2,
    ACTIONS(990), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(992), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15032] = 2,
    ACTIONS(994), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(996), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15049] = 2,
    ACTIONS(842), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(840), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15066] = 2,
    ACTIONS(998), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1000), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15083] = 2,
    ACTIONS(1002), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1004), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15100] = 2,
    ACTIONS(1006), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1008), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15117] = 2,
    ACTIONS(1010), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1012), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15134] = 2,
    ACTIONS(1014), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1016), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15151] = 2,
    ACTIONS(1018), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1020), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15168] = 2,
    ACTIONS(1022), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1024), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15185] = 2,
    ACTIONS(1026), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1028), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15202] = 2,
    ACTIONS(1030), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1032), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15219] = 2,
    ACTIONS(1034), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1036), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15236] = 2,
    ACTIONS(1038), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1040), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15253] = 2,
    ACTIONS(1042), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1044), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15270] = 2,
    ACTIONS(1046), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1048), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15287] = 2,
    ACTIONS(1050), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1052), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15304] = 2,
    ACTIONS(1054), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1056), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15321] = 2,
    ACTIONS(1058), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1060), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15338] = 2,
    ACTIONS(1062), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1064), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15355] = 2,
    ACTIONS(1066), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1068), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15372] = 2,
    ACTIONS(866), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(864), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15389] = 2,
    ACTIONS(870), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15406] = 2,
    ACTIONS(878), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15423] = 2,
    ACTIONS(1070), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1072), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15440] = 2,
    ACTIONS(846), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15457] = 2,
    ACTIONS(1074), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1076), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15474] = 2,
    ACTIONS(874), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(872), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15491] = 2,
    ACTIONS(1078), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1080), 9,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15508] = 2,
    ACTIONS(862), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(860), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15525] = 2,
    ACTIONS(1082), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(477), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [15541] = 4,
    ACTIONS(1084), 1,
      anon_sym_DOLLAR,
    ACTIONS(1087), 1,
      aux_sym__unquoted_text_token1,
    STATE(338), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(816), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_GT,
      anon_sym_COLON,
  [15561] = 2,
    ACTIONS(968), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15576] = 2,
    ACTIONS(1090), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1092), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [15591] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15606] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15621] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15636] = 2,
    ACTIONS(998), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1000), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15651] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15666] = 2,
    ACTIONS(1078), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1080), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15681] = 2,
    ACTIONS(1070), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1072), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15696] = 2,
    ACTIONS(1058), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1060), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15711] = 2,
    ACTIONS(1046), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1048), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15726] = 2,
    ACTIONS(994), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(996), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15741] = 2,
    ACTIONS(1018), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1020), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15756] = 2,
    ACTIONS(1014), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1016), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15771] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15786] = 2,
    ACTIONS(1002), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1004), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15801] = 2,
    ACTIONS(990), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(992), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15816] = 2,
    ACTIONS(986), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(988), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15831] = 2,
    ACTIONS(878), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [15846] = 2,
    ACTIONS(956), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(958), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [15861] = 2,
    ACTIONS(1006), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1008), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15876] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15891] = 2,
    ACTIONS(1050), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1052), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15906] = 2,
    ACTIONS(1034), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1036), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15921] = 2,
    ACTIONS(870), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [15936] = 2,
    ACTIONS(866), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(864), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [15951] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15966] = 2,
    ACTIONS(1010), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1012), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [15981] = 2,
    ACTIONS(994), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(996), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [15996] = 2,
    ACTIONS(956), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(958), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16011] = 2,
    ACTIONS(1026), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1028), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16026] = 2,
    ACTIONS(1062), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1064), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16041] = 2,
    ACTIONS(1066), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1068), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16056] = 2,
    ACTIONS(1026), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1028), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16071] = 2,
    ACTIONS(1062), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1064), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16086] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16101] = 2,
    ACTIONS(1022), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1024), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16116] = 2,
    ACTIONS(1074), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1076), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16131] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16146] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16161] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16176] = 2,
    ACTIONS(998), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1000), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16191] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16206] = 2,
    ACTIONS(1078), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1080), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16221] = 2,
    ACTIONS(1070), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1072), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16236] = 2,
    ACTIONS(1058), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1060), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16251] = 2,
    ACTIONS(1046), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1048), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16266] = 2,
    ACTIONS(1050), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1052), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16281] = 2,
    ACTIONS(1018), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1020), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16296] = 2,
    ACTIONS(1014), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1016), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16311] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16326] = 2,
    ACTIONS(1002), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1004), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16341] = 2,
    ACTIONS(990), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(992), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16356] = 2,
    ACTIONS(986), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(988), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16371] = 2,
    ACTIONS(1066), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1068), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16386] = 2,
    ACTIONS(1022), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1024), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16401] = 2,
    ACTIONS(1006), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1008), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16416] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16431] = 2,
    ACTIONS(1050), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1052), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16446] = 2,
    ACTIONS(1034), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1036), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16461] = 2,
    ACTIONS(1094), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1096), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16476] = 2,
    ACTIONS(1074), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1076), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16491] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16506] = 2,
    ACTIONS(1010), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1012), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16521] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16536] = 2,
    ACTIONS(846), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [16551] = 2,
    ACTIONS(874), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(872), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [16566] = 2,
    ACTIONS(1066), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1068), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16581] = 2,
    ACTIONS(1062), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1064), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16596] = 2,
    ACTIONS(1026), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1028), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16611] = 2,
    ACTIONS(956), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(958), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16626] = 2,
    ACTIONS(994), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(996), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16641] = 2,
    ACTIONS(1010), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1012), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16656] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16671] = 2,
    ACTIONS(1098), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1100), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [16686] = 2,
    ACTIONS(1102), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1104), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [16701] = 2,
    ACTIONS(1034), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1036), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16716] = 2,
    ACTIONS(1050), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1052), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16731] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16746] = 2,
    ACTIONS(1006), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1008), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16761] = 2,
    ACTIONS(862), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(860), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [16776] = 2,
    ACTIONS(972), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16791] = 2,
    ACTIONS(986), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(988), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16806] = 2,
    ACTIONS(990), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(992), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16821] = 2,
    ACTIONS(1002), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1004), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16836] = 2,
    ACTIONS(1022), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1024), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16851] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16866] = 2,
    ACTIONS(1014), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1016), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16881] = 2,
    ACTIONS(1018), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1020), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16896] = 2,
    ACTIONS(952), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16911] = 2,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(856), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [16926] = 2,
    ACTIONS(1046), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1048), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16941] = 2,
    ACTIONS(1058), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1060), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16956] = 2,
    ACTIONS(940), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [16971] = 2,
    ACTIONS(1070), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1072), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [16986] = 2,
    ACTIONS(960), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17001] = 2,
    ACTIONS(1078), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1080), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17016] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17031] = 2,
    ACTIONS(998), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1000), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17046] = 5,
    ACTIONS(911), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(1106), 1,
      anon_sym_DOLLAR,
    ACTIONS(1109), 1,
      aux_sym__unquoted_text_token1,
    STATE(438), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(816), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [17067] = 2,
    ACTIONS(1112), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1114), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17082] = 2,
    ACTIONS(1116), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1118), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17097] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17112] = 2,
    ACTIONS(1120), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1122), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [17127] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17142] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17157] = 2,
    ACTIONS(1124), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1126), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [17172] = 2,
    ACTIONS(998), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1000), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17187] = 2,
    ACTIONS(964), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17202] = 2,
    ACTIONS(1078), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1080), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17217] = 2,
    ACTIONS(1074), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1076), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17232] = 2,
    ACTIONS(1022), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1024), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17247] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17262] = 2,
    ACTIONS(1070), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1072), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17277] = 2,
    ACTIONS(1074), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1076), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17292] = 2,
    ACTIONS(1066), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1068), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17307] = 2,
    ACTIONS(1062), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1064), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17322] = 2,
    ACTIONS(1026), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1028), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17337] = 2,
    ACTIONS(956), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(958), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17352] = 2,
    ACTIONS(994), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(996), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17367] = 2,
    ACTIONS(1010), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1012), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17382] = 2,
    ACTIONS(932), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17397] = 2,
    ACTIONS(1058), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1060), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17412] = 2,
    ACTIONS(1046), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1048), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17427] = 2,
    ACTIONS(1034), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1036), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17442] = 2,
    ACTIONS(998), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1000), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17457] = 4,
    ACTIONS(1130), 1,
      anon_sym_DOLLAR,
    ACTIONS(1133), 1,
      aux_sym__quoted_text_token1,
    STATE(465), 1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(1128), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DQUOTE,
  [17476] = 2,
    ACTIONS(968), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(970), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17491] = 2,
    ACTIONS(1006), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1008), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17506] = 2,
    ACTIONS(1136), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1138), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17521] = 2,
    ACTIONS(1140), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1142), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_identifier,
  [17536] = 2,
    ACTIONS(1144), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1146), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_identifier,
  [17551] = 2,
    ACTIONS(986), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(988), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17566] = 2,
    ACTIONS(990), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(992), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17581] = 2,
    ACTIONS(1148), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1150), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_identifier,
  [17596] = 2,
    ACTIONS(1002), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1004), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17611] = 2,
    ACTIONS(1018), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1020), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17626] = 2,
    ACTIONS(928), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17641] = 2,
    ACTIONS(1014), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1016), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17656] = 2,
    ACTIONS(1018), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1020), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17671] = 2,
    ACTIONS(1014), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1016), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17686] = 2,
    ACTIONS(928), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(930), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17701] = 2,
    ACTIONS(1002), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1004), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17716] = 2,
    ACTIONS(990), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(992), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17731] = 2,
    ACTIONS(986), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(988), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17746] = 2,
    ACTIONS(1046), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1048), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17761] = 2,
    ACTIONS(1058), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1060), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17776] = 2,
    ACTIONS(1006), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1008), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17791] = 2,
    ACTIONS(1050), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1052), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17806] = 2,
    ACTIONS(1034), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1036), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17821] = 2,
    ACTIONS(932), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(934), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17836] = 2,
    ACTIONS(1070), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1072), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17851] = 2,
    ACTIONS(1078), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1080), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17866] = 2,
    ACTIONS(964), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(966), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17881] = 2,
    ACTIONS(1010), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1012), 6,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17896] = 4,
    ACTIONS(1152), 1,
      anon_sym_DOLLAR,
    ACTIONS(1155), 1,
      aux_sym__unquoted_text_token1,
    STATE(494), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(816), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_RPAREN,
  [17915] = 2,
    ACTIONS(960), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(962), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17930] = 2,
    ACTIONS(940), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(942), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17945] = 2,
    ACTIONS(952), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(954), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17960] = 2,
    ACTIONS(1074), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1076), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17975] = 2,
    ACTIONS(1022), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1024), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [17990] = 2,
    ACTIONS(972), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(974), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [18005] = 2,
    ACTIONS(994), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(996), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [18020] = 2,
    ACTIONS(956), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(958), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [18035] = 2,
    ACTIONS(1026), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1028), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [18050] = 2,
    ACTIONS(1066), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1068), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [18065] = 2,
    ACTIONS(1062), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(1064), 7,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_identifier,
  [18080] = 2,
    ACTIONS(878), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(876), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [18094] = 2,
    ACTIONS(858), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(856), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [18108] = 2,
    ACTIONS(874), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(872), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [18122] = 2,
    ACTIONS(846), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(844), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [18136] = 2,
    ACTIONS(862), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(860), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [18150] = 2,
    ACTIONS(866), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(864), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [18164] = 2,
    ACTIONS(870), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(868), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [18178] = 2,
    ACTIONS(862), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(860), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [18192] = 2,
    ACTIONS(874), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(872), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [18206] = 2,
    ACTIONS(878), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(876), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [18220] = 2,
    ACTIONS(846), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(844), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [18234] = 2,
    ACTIONS(878), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(876), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [18248] = 2,
    ACTIONS(858), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(856), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [18262] = 2,
    ACTIONS(870), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(868), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [18276] = 2,
    ACTIONS(866), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(864), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [18290] = 1,
    ACTIONS(864), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [18302] = 1,
    ACTIONS(868), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [18314] = 2,
    ACTIONS(846), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(844), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [18328] = 1,
    ACTIONS(876), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [18340] = 2,
    ACTIONS(874), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(872), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [18354] = 1,
    ACTIONS(844), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [18366] = 2,
    ACTIONS(866), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(864), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [18380] = 1,
    ACTIONS(872), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [18392] = 2,
    ACTIONS(858), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(856), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [18406] = 2,
    ACTIONS(862), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(860), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [18420] = 2,
    ACTIONS(870), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(868), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [18434] = 3,
    ACTIONS(1158), 1,
      anon_sym_LPAREN,
    ACTIONS(1160), 1,
      aux_sym_if_command_token1,
    STATE(564), 1,
      aux_sym_if_command_repeat1,
  [18444] = 3,
    ACTIONS(1162), 1,
      anon_sym_LPAREN,
    ACTIONS(1164), 1,
      aux_sym_if_command_token1,
    STATE(609), 1,
      aux_sym_if_command_repeat1,
  [18454] = 3,
    ACTIONS(1166), 1,
      anon_sym_LPAREN,
    ACTIONS(1168), 1,
      aux_sym_if_command_token1,
    STATE(540), 1,
      aux_sym_if_command_repeat1,
  [18464] = 3,
    ACTIONS(1170), 1,
      anon_sym_LPAREN,
    ACTIONS(1172), 1,
      aux_sym_if_command_token1,
    STATE(541), 1,
      aux_sym_if_command_repeat1,
  [18474] = 3,
    ACTIONS(1174), 1,
      anon_sym_LPAREN,
    ACTIONS(1176), 1,
      aux_sym_if_command_token1,
    STATE(542), 1,
      aux_sym_if_command_repeat1,
  [18484] = 3,
    ACTIONS(1178), 1,
      anon_sym_LPAREN,
    ACTIONS(1180), 1,
      aux_sym_if_command_token1,
    STATE(543), 1,
      aux_sym_if_command_repeat1,
  [18494] = 3,
    ACTIONS(1182), 1,
      anon_sym_LPAREN,
    ACTIONS(1184), 1,
      aux_sym_if_command_token1,
    STATE(544), 1,
      aux_sym_if_command_repeat1,
  [18504] = 3,
    ACTIONS(1186), 1,
      anon_sym_LPAREN,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18514] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1190), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18524] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1192), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18534] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1194), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18544] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1196), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18554] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1198), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18564] = 3,
    ACTIONS(1200), 1,
      anon_sym_LPAREN,
    ACTIONS(1202), 1,
      aux_sym_if_command_token1,
    STATE(601), 1,
      aux_sym_if_command_repeat1,
  [18574] = 3,
    ACTIONS(1204), 1,
      anon_sym_LPAREN,
    ACTIONS(1206), 1,
      aux_sym_if_command_token1,
    STATE(598), 1,
      aux_sym_if_command_repeat1,
  [18584] = 3,
    ACTIONS(1208), 1,
      anon_sym_LPAREN,
    ACTIONS(1210), 1,
      aux_sym_if_command_token1,
    STATE(597), 1,
      aux_sym_if_command_repeat1,
  [18594] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1212), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18604] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1214), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18614] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1216), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18624] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1218), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18634] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1220), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18644] = 3,
    ACTIONS(1222), 1,
      anon_sym_LPAREN,
    ACTIONS(1224), 1,
      aux_sym_if_command_token1,
    STATE(548), 1,
      aux_sym_if_command_repeat1,
  [18654] = 3,
    ACTIONS(1226), 1,
      anon_sym_LPAREN,
    ACTIONS(1228), 1,
      aux_sym_if_command_token1,
    STATE(549), 1,
      aux_sym_if_command_repeat1,
  [18664] = 3,
    ACTIONS(1230), 1,
      anon_sym_LPAREN,
    ACTIONS(1232), 1,
      aux_sym_if_command_token1,
    STATE(550), 1,
      aux_sym_if_command_repeat1,
  [18674] = 3,
    ACTIONS(1234), 1,
      anon_sym_LPAREN,
    ACTIONS(1236), 1,
      aux_sym_if_command_token1,
    STATE(551), 1,
      aux_sym_if_command_repeat1,
  [18684] = 3,
    ACTIONS(1238), 1,
      anon_sym_LPAREN,
    ACTIONS(1240), 1,
      aux_sym_if_command_token1,
    STATE(552), 1,
      aux_sym_if_command_repeat1,
  [18694] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1242), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18704] = 3,
    ACTIONS(1244), 1,
      anon_sym_LPAREN,
    ACTIONS(1246), 1,
      aux_sym_if_command_token1,
    STATE(558), 1,
      aux_sym_if_command_repeat1,
  [18714] = 3,
    ACTIONS(1248), 1,
      anon_sym_LPAREN,
    ACTIONS(1250), 1,
      aux_sym_if_command_token1,
    STATE(595), 1,
      aux_sym_if_command_repeat1,
  [18724] = 3,
    ACTIONS(1252), 1,
      anon_sym_LPAREN,
    ACTIONS(1254), 1,
      aux_sym_if_command_token1,
    STATE(590), 1,
      aux_sym_if_command_repeat1,
  [18734] = 3,
    ACTIONS(1256), 1,
      anon_sym_GT,
    ACTIONS(1258), 1,
      anon_sym_COLON,
    STATE(697), 1,
      sym__gen_exp_arguments,
  [18744] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1260), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18754] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1262), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18764] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1264), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18774] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1266), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18784] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1268), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18794] = 3,
    ACTIONS(1270), 1,
      anon_sym_LBRACE,
    ACTIONS(1272), 1,
      anon_sym_ENV,
    ACTIONS(1274), 1,
      anon_sym_CACHE,
  [18804] = 3,
    ACTIONS(1276), 1,
      anon_sym_LPAREN,
    ACTIONS(1278), 1,
      aux_sym_if_command_token1,
    STATE(563), 1,
      aux_sym_if_command_repeat1,
  [18814] = 3,
    ACTIONS(1280), 1,
      anon_sym_LPAREN,
    ACTIONS(1282), 1,
      aux_sym_if_command_token1,
    STATE(565), 1,
      aux_sym_if_command_repeat1,
  [18824] = 3,
    ACTIONS(1284), 1,
      anon_sym_LPAREN,
    ACTIONS(1286), 1,
      aux_sym_if_command_token1,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [18834] = 3,
    ACTIONS(1288), 1,
      anon_sym_LPAREN,
    ACTIONS(1290), 1,
      aux_sym_if_command_token1,
    STATE(567), 1,
      aux_sym_if_command_repeat1,
  [18844] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1292), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18854] = 3,
    ACTIONS(1294), 1,
      anon_sym_LPAREN,
    ACTIONS(1296), 1,
      aux_sym_if_command_token1,
    STATE(573), 1,
      aux_sym_if_command_repeat1,
  [18864] = 3,
    ACTIONS(1298), 1,
      anon_sym_LPAREN,
    ACTIONS(1300), 1,
      aux_sym_if_command_token1,
    STATE(588), 1,
      aux_sym_if_command_repeat1,
  [18874] = 1,
    ACTIONS(840), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [18880] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1302), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18890] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1304), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18900] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1306), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18910] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1308), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18920] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1310), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18930] = 3,
    ACTIONS(1312), 1,
      anon_sym_LPAREN,
    ACTIONS(1314), 1,
      aux_sym_if_command_token1,
    STATE(577), 1,
      aux_sym_if_command_repeat1,
  [18940] = 3,
    ACTIONS(1316), 1,
      anon_sym_LPAREN,
    ACTIONS(1318), 1,
      aux_sym_if_command_token1,
    STATE(578), 1,
      aux_sym_if_command_repeat1,
  [18950] = 3,
    ACTIONS(1320), 1,
      anon_sym_LPAREN,
    ACTIONS(1322), 1,
      aux_sym_if_command_token1,
    STATE(579), 1,
      aux_sym_if_command_repeat1,
  [18960] = 3,
    ACTIONS(1324), 1,
      anon_sym_LPAREN,
    ACTIONS(1326), 1,
      aux_sym_if_command_token1,
    STATE(580), 1,
      aux_sym_if_command_repeat1,
  [18970] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1328), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [18980] = 3,
    ACTIONS(1330), 1,
      anon_sym_LPAREN,
    ACTIONS(1332), 1,
      aux_sym_if_command_token1,
    STATE(581), 1,
      aux_sym_if_command_repeat1,
  [18990] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1334), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19000] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1336), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19010] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1338), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19020] = 3,
    ACTIONS(1340), 1,
      anon_sym_LPAREN,
    ACTIONS(1342), 1,
      aux_sym_if_command_token1,
    STATE(589), 1,
      aux_sym_if_command_repeat1,
  [19030] = 3,
    ACTIONS(1344), 1,
      anon_sym_LPAREN,
    ACTIONS(1346), 1,
      aux_sym_if_command_token1,
    STATE(586), 1,
      aux_sym_if_command_repeat1,
  [19040] = 3,
    ACTIONS(1348), 1,
      anon_sym_LPAREN,
    ACTIONS(1350), 1,
      aux_sym_if_command_token1,
    STATE(539), 1,
      aux_sym_if_command_repeat1,
  [19050] = 3,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      aux_sym_if_command_token1,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19060] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1357), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19070] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1359), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19080] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1361), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19090] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1363), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19100] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1365), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19110] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1367), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19120] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1369), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19130] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1371), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19140] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1373), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19150] = 3,
    ACTIONS(1375), 1,
      anon_sym_LPAREN,
    ACTIONS(1377), 1,
      aux_sym_if_command_token1,
    STATE(596), 1,
      aux_sym_if_command_repeat1,
  [19160] = 3,
    ACTIONS(1379), 1,
      anon_sym_LPAREN,
    ACTIONS(1381), 1,
      aux_sym_if_command_token1,
    STATE(599), 1,
      aux_sym_if_command_repeat1,
  [19170] = 3,
    ACTIONS(1383), 1,
      anon_sym_LPAREN,
    ACTIONS(1385), 1,
      aux_sym_if_command_token1,
    STATE(600), 1,
      aux_sym_if_command_repeat1,
  [19180] = 3,
    ACTIONS(1387), 1,
      anon_sym_LPAREN,
    ACTIONS(1389), 1,
      aux_sym_if_command_token1,
    STATE(602), 1,
      aux_sym_if_command_repeat1,
  [19190] = 3,
    ACTIONS(1391), 1,
      anon_sym_LPAREN,
    ACTIONS(1393), 1,
      aux_sym_if_command_token1,
    STATE(603), 1,
      aux_sym_if_command_repeat1,
  [19200] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1395), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19210] = 1,
    ACTIONS(832), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [19216] = 1,
    ACTIONS(848), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [19222] = 3,
    ACTIONS(1397), 1,
      anon_sym_LPAREN,
    ACTIONS(1399), 1,
      aux_sym_if_command_token1,
    STATE(613), 1,
      aux_sym_if_command_repeat1,
  [19232] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19242] = 3,
    ACTIONS(1403), 1,
      anon_sym_LPAREN,
    ACTIONS(1405), 1,
      aux_sym_if_command_token1,
    STATE(619), 1,
      aux_sym_if_command_repeat1,
  [19252] = 3,
    ACTIONS(1407), 1,
      anon_sym_LPAREN,
    ACTIONS(1409), 1,
      aux_sym_if_command_token1,
    STATE(620), 1,
      aux_sym_if_command_repeat1,
  [19262] = 3,
    ACTIONS(1411), 1,
      anon_sym_LPAREN,
    ACTIONS(1413), 1,
      aux_sym_if_command_token1,
    STATE(621), 1,
      aux_sym_if_command_repeat1,
  [19272] = 3,
    ACTIONS(1415), 1,
      anon_sym_LPAREN,
    ACTIONS(1417), 1,
      aux_sym_if_command_token1,
    STATE(622), 1,
      aux_sym_if_command_repeat1,
  [19282] = 3,
    ACTIONS(1419), 1,
      anon_sym_LPAREN,
    ACTIONS(1421), 1,
      aux_sym_if_command_token1,
    STATE(623), 1,
      aux_sym_if_command_repeat1,
  [19292] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1423), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19302] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1425), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19312] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1427), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19322] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1429), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19332] = 3,
    ACTIONS(1188), 1,
      aux_sym_if_command_token1,
    ACTIONS(1431), 1,
      anon_sym_LPAREN,
    STATE(594), 1,
      aux_sym_if_command_repeat1,
  [19342] = 2,
    ACTIONS(1433), 1,
      anon_sym_RPAREN,
    ACTIONS(1435), 1,
      aux_sym_endwhile_command_token1,
  [19349] = 2,
    ACTIONS(1437), 1,
      anon_sym_RPAREN,
    ACTIONS(1439), 1,
      aux_sym_endwhile_command_token1,
  [19356] = 2,
    ACTIONS(1441), 1,
      anon_sym_RPAREN,
    ACTIONS(1443), 1,
      aux_sym_endwhile_command_token1,
  [19363] = 2,
    ACTIONS(1445), 1,
      anon_sym_RPAREN,
    ACTIONS(1447), 1,
      aux_sym_endwhile_command_token1,
  [19370] = 2,
    ACTIONS(1449), 1,
      anon_sym_RPAREN,
    ACTIONS(1451), 1,
      aux_sym_endwhile_command_token1,
  [19377] = 2,
    ACTIONS(1453), 1,
      anon_sym_RPAREN,
    ACTIONS(1455), 1,
      aux_sym_endwhile_command_token1,
  [19384] = 2,
    ACTIONS(1457), 1,
      anon_sym_RPAREN,
    ACTIONS(1459), 1,
      aux_sym_endwhile_command_token1,
  [19391] = 2,
    ACTIONS(1461), 1,
      anon_sym_RPAREN,
    ACTIONS(1463), 1,
      aux_sym_endwhile_command_token1,
  [19398] = 2,
    ACTIONS(1465), 1,
      anon_sym_RPAREN,
    ACTIONS(1467), 1,
      aux_sym_endwhile_command_token1,
  [19405] = 2,
    ACTIONS(1469), 1,
      anon_sym_RPAREN,
    ACTIONS(1471), 1,
      aux_sym_endwhile_command_token1,
  [19412] = 2,
    ACTIONS(1473), 1,
      anon_sym_RPAREN,
    ACTIONS(1475), 1,
      aux_sym_endwhile_command_token1,
  [19419] = 2,
    ACTIONS(1477), 1,
      anon_sym_RPAREN,
    ACTIONS(1479), 1,
      aux_sym_endwhile_command_token1,
  [19426] = 1,
    ACTIONS(1481), 1,
      anon_sym_GT,
  [19430] = 1,
    ACTIONS(1483), 1,
      anon_sym_LBRACE,
  [19434] = 1,
    ACTIONS(1485), 1,
      anon_sym_RPAREN,
  [19438] = 1,
    ACTIONS(1487), 1,
      anon_sym_RPAREN,
  [19442] = 1,
    ACTIONS(1489), 1,
      anon_sym_RBRACE,
  [19446] = 1,
    ACTIONS(1491), 1,
      anon_sym_RBRACE,
  [19450] = 1,
    ACTIONS(1493), 1,
      anon_sym_RPAREN,
  [19454] = 1,
    ACTIONS(848), 1,
      aux_sym_endwhile_command_token1,
  [19458] = 1,
    ACTIONS(1495), 1,
      anon_sym_RPAREN,
  [19462] = 1,
    ACTIONS(1497), 1,
      anon_sym_GT,
  [19466] = 1,
    ACTIONS(1499), 1,
      anon_sym_RBRACE,
  [19470] = 1,
    ACTIONS(832), 1,
      aux_sym_endwhile_command_token1,
  [19474] = 1,
    ACTIONS(1501), 1,
      aux_sym_endwhile_command_token1,
  [19478] = 1,
    ACTIONS(1503), 1,
      aux_sym_endwhile_command_token1,
  [19482] = 1,
    ACTIONS(579), 1,
      anon_sym_RPAREN,
  [19486] = 1,
    ACTIONS(1505), 1,
      anon_sym_DQUOTE,
  [19490] = 1,
    ACTIONS(585), 1,
      anon_sym_RPAREN,
  [19494] = 1,
    ACTIONS(1507), 1,
      anon_sym_LBRACE,
  [19498] = 1,
    ACTIONS(1509), 1,
      anon_sym_LBRACE,
  [19502] = 1,
    ACTIONS(1511), 1,
      anon_sym_DQUOTE,
  [19506] = 1,
    ACTIONS(1513), 1,
      anon_sym_RBRACE,
  [19510] = 1,
    ACTIONS(1515), 1,
      anon_sym_GT,
  [19514] = 1,
    ACTIONS(1517), 1,
      anon_sym_RPAREN,
  [19518] = 1,
    ACTIONS(1519), 1,
      anon_sym_RBRACE,
  [19522] = 1,
    ACTIONS(1521), 1,
      anon_sym_RBRACE,
  [19526] = 1,
    ACTIONS(1523), 1,
      aux_sym_endwhile_command_token1,
  [19530] = 1,
    ACTIONS(1525), 1,
      aux_sym_endwhile_command_token1,
  [19534] = 1,
    ACTIONS(1527), 1,
      aux_sym_endwhile_command_token1,
  [19538] = 1,
    ACTIONS(1529), 1,
      anon_sym_RPAREN,
  [19542] = 1,
    ACTIONS(523), 1,
      anon_sym_RPAREN,
  [19546] = 1,
    ACTIONS(1531), 1,
      anon_sym_RPAREN,
  [19550] = 1,
    ACTIONS(1533), 1,
      anon_sym_RPAREN,
  [19554] = 1,
    ACTIONS(1535), 1,
      aux_sym_endwhile_command_token1,
  [19558] = 1,
    ACTIONS(1537), 1,
      anon_sym_RBRACE,
  [19562] = 1,
    ACTIONS(1539), 1,
      anon_sym_RBRACE,
  [19566] = 1,
    ACTIONS(1541), 1,
      anon_sym_RBRACE,
  [19570] = 1,
    ACTIONS(1543), 1,
      anon_sym_RBRACE,
  [19574] = 1,
    ACTIONS(1545), 1,
      anon_sym_GT,
  [19578] = 1,
    ACTIONS(1547), 1,
      anon_sym_RBRACE,
  [19582] = 1,
    ACTIONS(1549), 1,
      anon_sym_GT,
  [19586] = 1,
    ACTIONS(641), 1,
      anon_sym_RPAREN,
  [19590] = 1,
    ACTIONS(1551), 1,
      anon_sym_RBRACE,
  [19594] = 1,
    ACTIONS(1553), 1,
      anon_sym_RPAREN,
  [19598] = 1,
    ACTIONS(1555), 1,
      anon_sym_RBRACE,
  [19602] = 1,
    ACTIONS(1557), 1,
      anon_sym_RPAREN,
  [19606] = 1,
    ACTIONS(1559), 1,
      anon_sym_DQUOTE,
  [19610] = 1,
    ACTIONS(545), 1,
      anon_sym_RPAREN,
  [19614] = 1,
    ACTIONS(619), 1,
      anon_sym_RPAREN,
  [19618] = 1,
    ACTIONS(1561), 1,
      anon_sym_RBRACE,
  [19622] = 1,
    ACTIONS(840), 1,
      aux_sym_endwhile_command_token1,
  [19626] = 1,
    ACTIONS(1563), 1,
      anon_sym_RBRACE,
  [19630] = 1,
    ACTIONS(1565), 1,
      anon_sym_RPAREN,
  [19634] = 1,
    ACTIONS(1567), 1,
      anon_sym_RBRACE,
  [19638] = 1,
    ACTIONS(1569), 1,
      aux_sym_endwhile_command_token1,
  [19642] = 1,
    ACTIONS(1571), 1,
      anon_sym_GT,
  [19646] = 1,
    ACTIONS(1573), 1,
      aux_sym_endwhile_command_token1,
  [19650] = 1,
    ACTIONS(1575), 1,
      anon_sym_DQUOTE,
  [19654] = 1,
    ACTIONS(1577), 1,
      anon_sym_RBRACE,
  [19658] = 1,
    ACTIONS(1579), 1,
      anon_sym_RBRACE,
  [19662] = 1,
    ACTIONS(1581), 1,
      aux_sym_endwhile_command_token1,
  [19666] = 1,
    ACTIONS(1583), 1,
      aux_sym_endwhile_command_token1,
  [19670] = 1,
    ACTIONS(1585), 1,
      anon_sym_GT,
  [19674] = 1,
    ACTIONS(1587), 1,
      anon_sym_RBRACE,
  [19678] = 1,
    ACTIONS(1589), 1,
      anon_sym_RPAREN,
  [19682] = 1,
    ACTIONS(1591), 1,
      anon_sym_LBRACE,
  [19686] = 1,
    ACTIONS(1593), 1,
      anon_sym_LBRACE,
  [19690] = 1,
    ACTIONS(1595), 1,
      aux_sym_endwhile_command_token1,
  [19694] = 1,
    ACTIONS(1597), 1,
      anon_sym_RBRACE,
  [19698] = 1,
    ACTIONS(1599), 1,
      anon_sym_LBRACE,
  [19702] = 1,
    ACTIONS(1601), 1,
      anon_sym_LBRACE,
  [19706] = 1,
    ACTIONS(1603), 1,
      anon_sym_RPAREN,
  [19710] = 1,
    ACTIONS(1605), 1,
      anon_sym_RPAREN,
  [19714] = 1,
    ACTIONS(1607), 1,
      anon_sym_LBRACE,
  [19718] = 1,
    ACTIONS(1609), 1,
      anon_sym_LBRACE,
  [19722] = 1,
    ACTIONS(1611), 1,
      ts_builtin_sym_end,
  [19726] = 1,
    ACTIONS(1613), 1,
      anon_sym_RPAREN,
  [19730] = 1,
    ACTIONS(1615), 1,
      anon_sym_LBRACE,
  [19734] = 1,
    ACTIONS(1617), 1,
      anon_sym_LBRACE,
  [19738] = 1,
    ACTIONS(1619), 1,
      anon_sym_RPAREN,
  [19742] = 1,
    ACTIONS(1621), 1,
      anon_sym_RPAREN,
  [19746] = 1,
    ACTIONS(1623), 1,
      anon_sym_LBRACE,
  [19750] = 1,
    ACTIONS(1625), 1,
      aux_sym_endwhile_command_token1,
  [19754] = 1,
    ACTIONS(1627), 1,
      anon_sym_RPAREN,
  [19758] = 1,
    ACTIONS(1629), 1,
      anon_sym_RBRACE,
  [19762] = 1,
    ACTIONS(1631), 1,
      anon_sym_LBRACE,
  [19766] = 1,
    ACTIONS(1633), 1,
      anon_sym_LBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 59,
  [SMALL_STATE(4)] = 118,
  [SMALL_STATE(5)] = 177,
  [SMALL_STATE(6)] = 236,
  [SMALL_STATE(7)] = 295,
  [SMALL_STATE(8)] = 354,
  [SMALL_STATE(9)] = 413,
  [SMALL_STATE(10)] = 472,
  [SMALL_STATE(11)] = 531,
  [SMALL_STATE(12)] = 590,
  [SMALL_STATE(13)] = 649,
  [SMALL_STATE(14)] = 708,
  [SMALL_STATE(15)] = 767,
  [SMALL_STATE(16)] = 826,
  [SMALL_STATE(17)] = 885,
  [SMALL_STATE(18)] = 944,
  [SMALL_STATE(19)] = 1003,
  [SMALL_STATE(20)] = 1062,
  [SMALL_STATE(21)] = 1121,
  [SMALL_STATE(22)] = 1180,
  [SMALL_STATE(23)] = 1239,
  [SMALL_STATE(24)] = 1298,
  [SMALL_STATE(25)] = 1357,
  [SMALL_STATE(26)] = 1416,
  [SMALL_STATE(27)] = 1475,
  [SMALL_STATE(28)] = 1534,
  [SMALL_STATE(29)] = 1593,
  [SMALL_STATE(30)] = 1652,
  [SMALL_STATE(31)] = 1711,
  [SMALL_STATE(32)] = 1770,
  [SMALL_STATE(33)] = 1829,
  [SMALL_STATE(34)] = 1888,
  [SMALL_STATE(35)] = 1947,
  [SMALL_STATE(36)] = 2006,
  [SMALL_STATE(37)] = 2065,
  [SMALL_STATE(38)] = 2124,
  [SMALL_STATE(39)] = 2183,
  [SMALL_STATE(40)] = 2242,
  [SMALL_STATE(41)] = 2301,
  [SMALL_STATE(42)] = 2360,
  [SMALL_STATE(43)] = 2419,
  [SMALL_STATE(44)] = 2478,
  [SMALL_STATE(45)] = 2537,
  [SMALL_STATE(46)] = 2596,
  [SMALL_STATE(47)] = 2655,
  [SMALL_STATE(48)] = 2714,
  [SMALL_STATE(49)] = 2773,
  [SMALL_STATE(50)] = 2832,
  [SMALL_STATE(51)] = 2891,
  [SMALL_STATE(52)] = 2950,
  [SMALL_STATE(53)] = 3009,
  [SMALL_STATE(54)] = 3068,
  [SMALL_STATE(55)] = 3127,
  [SMALL_STATE(56)] = 3186,
  [SMALL_STATE(57)] = 3245,
  [SMALL_STATE(58)] = 3304,
  [SMALL_STATE(59)] = 3363,
  [SMALL_STATE(60)] = 3422,
  [SMALL_STATE(61)] = 3481,
  [SMALL_STATE(62)] = 3540,
  [SMALL_STATE(63)] = 3599,
  [SMALL_STATE(64)] = 3658,
  [SMALL_STATE(65)] = 3717,
  [SMALL_STATE(66)] = 3776,
  [SMALL_STATE(67)] = 3835,
  [SMALL_STATE(68)] = 3894,
  [SMALL_STATE(69)] = 3953,
  [SMALL_STATE(70)] = 4012,
  [SMALL_STATE(71)] = 4071,
  [SMALL_STATE(72)] = 4130,
  [SMALL_STATE(73)] = 4189,
  [SMALL_STATE(74)] = 4248,
  [SMALL_STATE(75)] = 4307,
  [SMALL_STATE(76)] = 4366,
  [SMALL_STATE(77)] = 4425,
  [SMALL_STATE(78)] = 4484,
  [SMALL_STATE(79)] = 4543,
  [SMALL_STATE(80)] = 4602,
  [SMALL_STATE(81)] = 4661,
  [SMALL_STATE(82)] = 4720,
  [SMALL_STATE(83)] = 4779,
  [SMALL_STATE(84)] = 4838,
  [SMALL_STATE(85)] = 4897,
  [SMALL_STATE(86)] = 4956,
  [SMALL_STATE(87)] = 5015,
  [SMALL_STATE(88)] = 5074,
  [SMALL_STATE(89)] = 5133,
  [SMALL_STATE(90)] = 5192,
  [SMALL_STATE(91)] = 5251,
  [SMALL_STATE(92)] = 5310,
  [SMALL_STATE(93)] = 5369,
  [SMALL_STATE(94)] = 5428,
  [SMALL_STATE(95)] = 5487,
  [SMALL_STATE(96)] = 5546,
  [SMALL_STATE(97)] = 5605,
  [SMALL_STATE(98)] = 5664,
  [SMALL_STATE(99)] = 5723,
  [SMALL_STATE(100)] = 5782,
  [SMALL_STATE(101)] = 5841,
  [SMALL_STATE(102)] = 5900,
  [SMALL_STATE(103)] = 5959,
  [SMALL_STATE(104)] = 6018,
  [SMALL_STATE(105)] = 6077,
  [SMALL_STATE(106)] = 6136,
  [SMALL_STATE(107)] = 6195,
  [SMALL_STATE(108)] = 6254,
  [SMALL_STATE(109)] = 6313,
  [SMALL_STATE(110)] = 6372,
  [SMALL_STATE(111)] = 6431,
  [SMALL_STATE(112)] = 6490,
  [SMALL_STATE(113)] = 6549,
  [SMALL_STATE(114)] = 6608,
  [SMALL_STATE(115)] = 6667,
  [SMALL_STATE(116)] = 6726,
  [SMALL_STATE(117)] = 6785,
  [SMALL_STATE(118)] = 6844,
  [SMALL_STATE(119)] = 6903,
  [SMALL_STATE(120)] = 6962,
  [SMALL_STATE(121)] = 7021,
  [SMALL_STATE(122)] = 7080,
  [SMALL_STATE(123)] = 7139,
  [SMALL_STATE(124)] = 7198,
  [SMALL_STATE(125)] = 7257,
  [SMALL_STATE(126)] = 7316,
  [SMALL_STATE(127)] = 7375,
  [SMALL_STATE(128)] = 7434,
  [SMALL_STATE(129)] = 7493,
  [SMALL_STATE(130)] = 7557,
  [SMALL_STATE(131)] = 7621,
  [SMALL_STATE(132)] = 7685,
  [SMALL_STATE(133)] = 7749,
  [SMALL_STATE(134)] = 7813,
  [SMALL_STATE(135)] = 7877,
  [SMALL_STATE(136)] = 7941,
  [SMALL_STATE(137)] = 8005,
  [SMALL_STATE(138)] = 8069,
  [SMALL_STATE(139)] = 8133,
  [SMALL_STATE(140)] = 8197,
  [SMALL_STATE(141)] = 8261,
  [SMALL_STATE(142)] = 8322,
  [SMALL_STATE(143)] = 8363,
  [SMALL_STATE(144)] = 8414,
  [SMALL_STATE(145)] = 8465,
  [SMALL_STATE(146)] = 8516,
  [SMALL_STATE(147)] = 8567,
  [SMALL_STATE(148)] = 8618,
  [SMALL_STATE(149)] = 8669,
  [SMALL_STATE(150)] = 8720,
  [SMALL_STATE(151)] = 8771,
  [SMALL_STATE(152)] = 8822,
  [SMALL_STATE(153)] = 8863,
  [SMALL_STATE(154)] = 8919,
  [SMALL_STATE(155)] = 8975,
  [SMALL_STATE(156)] = 9031,
  [SMALL_STATE(157)] = 9079,
  [SMALL_STATE(158)] = 9135,
  [SMALL_STATE(159)] = 9191,
  [SMALL_STATE(160)] = 9247,
  [SMALL_STATE(161)] = 9303,
  [SMALL_STATE(162)] = 9351,
  [SMALL_STATE(163)] = 9407,
  [SMALL_STATE(164)] = 9463,
  [SMALL_STATE(165)] = 9519,
  [SMALL_STATE(166)] = 9575,
  [SMALL_STATE(167)] = 9631,
  [SMALL_STATE(168)] = 9687,
  [SMALL_STATE(169)] = 9743,
  [SMALL_STATE(170)] = 9791,
  [SMALL_STATE(171)] = 9847,
  [SMALL_STATE(172)] = 9895,
  [SMALL_STATE(173)] = 9951,
  [SMALL_STATE(174)] = 10007,
  [SMALL_STATE(175)] = 10055,
  [SMALL_STATE(176)] = 10111,
  [SMALL_STATE(177)] = 10167,
  [SMALL_STATE(178)] = 10215,
  [SMALL_STATE(179)] = 10271,
  [SMALL_STATE(180)] = 10319,
  [SMALL_STATE(181)] = 10375,
  [SMALL_STATE(182)] = 10431,
  [SMALL_STATE(183)] = 10487,
  [SMALL_STATE(184)] = 10543,
  [SMALL_STATE(185)] = 10599,
  [SMALL_STATE(186)] = 10655,
  [SMALL_STATE(187)] = 10703,
  [SMALL_STATE(188)] = 10759,
  [SMALL_STATE(189)] = 10815,
  [SMALL_STATE(190)] = 10871,
  [SMALL_STATE(191)] = 10927,
  [SMALL_STATE(192)] = 10983,
  [SMALL_STATE(193)] = 11039,
  [SMALL_STATE(194)] = 11095,
  [SMALL_STATE(195)] = 11151,
  [SMALL_STATE(196)] = 11199,
  [SMALL_STATE(197)] = 11247,
  [SMALL_STATE(198)] = 11303,
  [SMALL_STATE(199)] = 11359,
  [SMALL_STATE(200)] = 11415,
  [SMALL_STATE(201)] = 11471,
  [SMALL_STATE(202)] = 11527,
  [SMALL_STATE(203)] = 11583,
  [SMALL_STATE(204)] = 11639,
  [SMALL_STATE(205)] = 11695,
  [SMALL_STATE(206)] = 11751,
  [SMALL_STATE(207)] = 11807,
  [SMALL_STATE(208)] = 11863,
  [SMALL_STATE(209)] = 11919,
  [SMALL_STATE(210)] = 11967,
  [SMALL_STATE(211)] = 12023,
  [SMALL_STATE(212)] = 12079,
  [SMALL_STATE(213)] = 12127,
  [SMALL_STATE(214)] = 12180,
  [SMALL_STATE(215)] = 12225,
  [SMALL_STATE(216)] = 12278,
  [SMALL_STATE(217)] = 12331,
  [SMALL_STATE(218)] = 12376,
  [SMALL_STATE(219)] = 12429,
  [SMALL_STATE(220)] = 12474,
  [SMALL_STATE(221)] = 12519,
  [SMALL_STATE(222)] = 12564,
  [SMALL_STATE(223)] = 12609,
  [SMALL_STATE(224)] = 12654,
  [SMALL_STATE(225)] = 12699,
  [SMALL_STATE(226)] = 12744,
  [SMALL_STATE(227)] = 12797,
  [SMALL_STATE(228)] = 12842,
  [SMALL_STATE(229)] = 12895,
  [SMALL_STATE(230)] = 12940,
  [SMALL_STATE(231)] = 12985,
  [SMALL_STATE(232)] = 13025,
  [SMALL_STATE(233)] = 13065,
  [SMALL_STATE(234)] = 13103,
  [SMALL_STATE(235)] = 13141,
  [SMALL_STATE(236)] = 13179,
  [SMALL_STATE(237)] = 13215,
  [SMALL_STATE(238)] = 13253,
  [SMALL_STATE(239)] = 13289,
  [SMALL_STATE(240)] = 13324,
  [SMALL_STATE(241)] = 13359,
  [SMALL_STATE(242)] = 13394,
  [SMALL_STATE(243)] = 13429,
  [SMALL_STATE(244)] = 13464,
  [SMALL_STATE(245)] = 13499,
  [SMALL_STATE(246)] = 13531,
  [SMALL_STATE(247)] = 13563,
  [SMALL_STATE(248)] = 13595,
  [SMALL_STATE(249)] = 13627,
  [SMALL_STATE(250)] = 13659,
  [SMALL_STATE(251)] = 13691,
  [SMALL_STATE(252)] = 13723,
  [SMALL_STATE(253)] = 13755,
  [SMALL_STATE(254)] = 13787,
  [SMALL_STATE(255)] = 13819,
  [SMALL_STATE(256)] = 13851,
  [SMALL_STATE(257)] = 13883,
  [SMALL_STATE(258)] = 13915,
  [SMALL_STATE(259)] = 13947,
  [SMALL_STATE(260)] = 13979,
  [SMALL_STATE(261)] = 14011,
  [SMALL_STATE(262)] = 14043,
  [SMALL_STATE(263)] = 14075,
  [SMALL_STATE(264)] = 14107,
  [SMALL_STATE(265)] = 14139,
  [SMALL_STATE(266)] = 14171,
  [SMALL_STATE(267)] = 14203,
  [SMALL_STATE(268)] = 14235,
  [SMALL_STATE(269)] = 14267,
  [SMALL_STATE(270)] = 14292,
  [SMALL_STATE(271)] = 14321,
  [SMALL_STATE(272)] = 14341,
  [SMALL_STATE(273)] = 14361,
  [SMALL_STATE(274)] = 14381,
  [SMALL_STATE(275)] = 14401,
  [SMALL_STATE(276)] = 14421,
  [SMALL_STATE(277)] = 14441,
  [SMALL_STATE(278)] = 14461,
  [SMALL_STATE(279)] = 14481,
  [SMALL_STATE(280)] = 14501,
  [SMALL_STATE(281)] = 14521,
  [SMALL_STATE(282)] = 14541,
  [SMALL_STATE(283)] = 14561,
  [SMALL_STATE(284)] = 14588,
  [SMALL_STATE(285)] = 14614,
  [SMALL_STATE(286)] = 14640,
  [SMALL_STATE(287)] = 14664,
  [SMALL_STATE(288)] = 14690,
  [SMALL_STATE(289)] = 14707,
  [SMALL_STATE(290)] = 14724,
  [SMALL_STATE(291)] = 14741,
  [SMALL_STATE(292)] = 14758,
  [SMALL_STATE(293)] = 14775,
  [SMALL_STATE(294)] = 14792,
  [SMALL_STATE(295)] = 14809,
  [SMALL_STATE(296)] = 14826,
  [SMALL_STATE(297)] = 14843,
  [SMALL_STATE(298)] = 14860,
  [SMALL_STATE(299)] = 14877,
  [SMALL_STATE(300)] = 14894,
  [SMALL_STATE(301)] = 14911,
  [SMALL_STATE(302)] = 14928,
  [SMALL_STATE(303)] = 14945,
  [SMALL_STATE(304)] = 14962,
  [SMALL_STATE(305)] = 14981,
  [SMALL_STATE(306)] = 14998,
  [SMALL_STATE(307)] = 15015,
  [SMALL_STATE(308)] = 15032,
  [SMALL_STATE(309)] = 15049,
  [SMALL_STATE(310)] = 15066,
  [SMALL_STATE(311)] = 15083,
  [SMALL_STATE(312)] = 15100,
  [SMALL_STATE(313)] = 15117,
  [SMALL_STATE(314)] = 15134,
  [SMALL_STATE(315)] = 15151,
  [SMALL_STATE(316)] = 15168,
  [SMALL_STATE(317)] = 15185,
  [SMALL_STATE(318)] = 15202,
  [SMALL_STATE(319)] = 15219,
  [SMALL_STATE(320)] = 15236,
  [SMALL_STATE(321)] = 15253,
  [SMALL_STATE(322)] = 15270,
  [SMALL_STATE(323)] = 15287,
  [SMALL_STATE(324)] = 15304,
  [SMALL_STATE(325)] = 15321,
  [SMALL_STATE(326)] = 15338,
  [SMALL_STATE(327)] = 15355,
  [SMALL_STATE(328)] = 15372,
  [SMALL_STATE(329)] = 15389,
  [SMALL_STATE(330)] = 15406,
  [SMALL_STATE(331)] = 15423,
  [SMALL_STATE(332)] = 15440,
  [SMALL_STATE(333)] = 15457,
  [SMALL_STATE(334)] = 15474,
  [SMALL_STATE(335)] = 15491,
  [SMALL_STATE(336)] = 15508,
  [SMALL_STATE(337)] = 15525,
  [SMALL_STATE(338)] = 15541,
  [SMALL_STATE(339)] = 15561,
  [SMALL_STATE(340)] = 15576,
  [SMALL_STATE(341)] = 15591,
  [SMALL_STATE(342)] = 15606,
  [SMALL_STATE(343)] = 15621,
  [SMALL_STATE(344)] = 15636,
  [SMALL_STATE(345)] = 15651,
  [SMALL_STATE(346)] = 15666,
  [SMALL_STATE(347)] = 15681,
  [SMALL_STATE(348)] = 15696,
  [SMALL_STATE(349)] = 15711,
  [SMALL_STATE(350)] = 15726,
  [SMALL_STATE(351)] = 15741,
  [SMALL_STATE(352)] = 15756,
  [SMALL_STATE(353)] = 15771,
  [SMALL_STATE(354)] = 15786,
  [SMALL_STATE(355)] = 15801,
  [SMALL_STATE(356)] = 15816,
  [SMALL_STATE(357)] = 15831,
  [SMALL_STATE(358)] = 15846,
  [SMALL_STATE(359)] = 15861,
  [SMALL_STATE(360)] = 15876,
  [SMALL_STATE(361)] = 15891,
  [SMALL_STATE(362)] = 15906,
  [SMALL_STATE(363)] = 15921,
  [SMALL_STATE(364)] = 15936,
  [SMALL_STATE(365)] = 15951,
  [SMALL_STATE(366)] = 15966,
  [SMALL_STATE(367)] = 15981,
  [SMALL_STATE(368)] = 15996,
  [SMALL_STATE(369)] = 16011,
  [SMALL_STATE(370)] = 16026,
  [SMALL_STATE(371)] = 16041,
  [SMALL_STATE(372)] = 16056,
  [SMALL_STATE(373)] = 16071,
  [SMALL_STATE(374)] = 16086,
  [SMALL_STATE(375)] = 16101,
  [SMALL_STATE(376)] = 16116,
  [SMALL_STATE(377)] = 16131,
  [SMALL_STATE(378)] = 16146,
  [SMALL_STATE(379)] = 16161,
  [SMALL_STATE(380)] = 16176,
  [SMALL_STATE(381)] = 16191,
  [SMALL_STATE(382)] = 16206,
  [SMALL_STATE(383)] = 16221,
  [SMALL_STATE(384)] = 16236,
  [SMALL_STATE(385)] = 16251,
  [SMALL_STATE(386)] = 16266,
  [SMALL_STATE(387)] = 16281,
  [SMALL_STATE(388)] = 16296,
  [SMALL_STATE(389)] = 16311,
  [SMALL_STATE(390)] = 16326,
  [SMALL_STATE(391)] = 16341,
  [SMALL_STATE(392)] = 16356,
  [SMALL_STATE(393)] = 16371,
  [SMALL_STATE(394)] = 16386,
  [SMALL_STATE(395)] = 16401,
  [SMALL_STATE(396)] = 16416,
  [SMALL_STATE(397)] = 16431,
  [SMALL_STATE(398)] = 16446,
  [SMALL_STATE(399)] = 16461,
  [SMALL_STATE(400)] = 16476,
  [SMALL_STATE(401)] = 16491,
  [SMALL_STATE(402)] = 16506,
  [SMALL_STATE(403)] = 16521,
  [SMALL_STATE(404)] = 16536,
  [SMALL_STATE(405)] = 16551,
  [SMALL_STATE(406)] = 16566,
  [SMALL_STATE(407)] = 16581,
  [SMALL_STATE(408)] = 16596,
  [SMALL_STATE(409)] = 16611,
  [SMALL_STATE(410)] = 16626,
  [SMALL_STATE(411)] = 16641,
  [SMALL_STATE(412)] = 16656,
  [SMALL_STATE(413)] = 16671,
  [SMALL_STATE(414)] = 16686,
  [SMALL_STATE(415)] = 16701,
  [SMALL_STATE(416)] = 16716,
  [SMALL_STATE(417)] = 16731,
  [SMALL_STATE(418)] = 16746,
  [SMALL_STATE(419)] = 16761,
  [SMALL_STATE(420)] = 16776,
  [SMALL_STATE(421)] = 16791,
  [SMALL_STATE(422)] = 16806,
  [SMALL_STATE(423)] = 16821,
  [SMALL_STATE(424)] = 16836,
  [SMALL_STATE(425)] = 16851,
  [SMALL_STATE(426)] = 16866,
  [SMALL_STATE(427)] = 16881,
  [SMALL_STATE(428)] = 16896,
  [SMALL_STATE(429)] = 16911,
  [SMALL_STATE(430)] = 16926,
  [SMALL_STATE(431)] = 16941,
  [SMALL_STATE(432)] = 16956,
  [SMALL_STATE(433)] = 16971,
  [SMALL_STATE(434)] = 16986,
  [SMALL_STATE(435)] = 17001,
  [SMALL_STATE(436)] = 17016,
  [SMALL_STATE(437)] = 17031,
  [SMALL_STATE(438)] = 17046,
  [SMALL_STATE(439)] = 17067,
  [SMALL_STATE(440)] = 17082,
  [SMALL_STATE(441)] = 17097,
  [SMALL_STATE(442)] = 17112,
  [SMALL_STATE(443)] = 17127,
  [SMALL_STATE(444)] = 17142,
  [SMALL_STATE(445)] = 17157,
  [SMALL_STATE(446)] = 17172,
  [SMALL_STATE(447)] = 17187,
  [SMALL_STATE(448)] = 17202,
  [SMALL_STATE(449)] = 17217,
  [SMALL_STATE(450)] = 17232,
  [SMALL_STATE(451)] = 17247,
  [SMALL_STATE(452)] = 17262,
  [SMALL_STATE(453)] = 17277,
  [SMALL_STATE(454)] = 17292,
  [SMALL_STATE(455)] = 17307,
  [SMALL_STATE(456)] = 17322,
  [SMALL_STATE(457)] = 17337,
  [SMALL_STATE(458)] = 17352,
  [SMALL_STATE(459)] = 17367,
  [SMALL_STATE(460)] = 17382,
  [SMALL_STATE(461)] = 17397,
  [SMALL_STATE(462)] = 17412,
  [SMALL_STATE(463)] = 17427,
  [SMALL_STATE(464)] = 17442,
  [SMALL_STATE(465)] = 17457,
  [SMALL_STATE(466)] = 17476,
  [SMALL_STATE(467)] = 17491,
  [SMALL_STATE(468)] = 17506,
  [SMALL_STATE(469)] = 17521,
  [SMALL_STATE(470)] = 17536,
  [SMALL_STATE(471)] = 17551,
  [SMALL_STATE(472)] = 17566,
  [SMALL_STATE(473)] = 17581,
  [SMALL_STATE(474)] = 17596,
  [SMALL_STATE(475)] = 17611,
  [SMALL_STATE(476)] = 17626,
  [SMALL_STATE(477)] = 17641,
  [SMALL_STATE(478)] = 17656,
  [SMALL_STATE(479)] = 17671,
  [SMALL_STATE(480)] = 17686,
  [SMALL_STATE(481)] = 17701,
  [SMALL_STATE(482)] = 17716,
  [SMALL_STATE(483)] = 17731,
  [SMALL_STATE(484)] = 17746,
  [SMALL_STATE(485)] = 17761,
  [SMALL_STATE(486)] = 17776,
  [SMALL_STATE(487)] = 17791,
  [SMALL_STATE(488)] = 17806,
  [SMALL_STATE(489)] = 17821,
  [SMALL_STATE(490)] = 17836,
  [SMALL_STATE(491)] = 17851,
  [SMALL_STATE(492)] = 17866,
  [SMALL_STATE(493)] = 17881,
  [SMALL_STATE(494)] = 17896,
  [SMALL_STATE(495)] = 17915,
  [SMALL_STATE(496)] = 17930,
  [SMALL_STATE(497)] = 17945,
  [SMALL_STATE(498)] = 17960,
  [SMALL_STATE(499)] = 17975,
  [SMALL_STATE(500)] = 17990,
  [SMALL_STATE(501)] = 18005,
  [SMALL_STATE(502)] = 18020,
  [SMALL_STATE(503)] = 18035,
  [SMALL_STATE(504)] = 18050,
  [SMALL_STATE(505)] = 18065,
  [SMALL_STATE(506)] = 18080,
  [SMALL_STATE(507)] = 18094,
  [SMALL_STATE(508)] = 18108,
  [SMALL_STATE(509)] = 18122,
  [SMALL_STATE(510)] = 18136,
  [SMALL_STATE(511)] = 18150,
  [SMALL_STATE(512)] = 18164,
  [SMALL_STATE(513)] = 18178,
  [SMALL_STATE(514)] = 18192,
  [SMALL_STATE(515)] = 18206,
  [SMALL_STATE(516)] = 18220,
  [SMALL_STATE(517)] = 18234,
  [SMALL_STATE(518)] = 18248,
  [SMALL_STATE(519)] = 18262,
  [SMALL_STATE(520)] = 18276,
  [SMALL_STATE(521)] = 18290,
  [SMALL_STATE(522)] = 18302,
  [SMALL_STATE(523)] = 18314,
  [SMALL_STATE(524)] = 18328,
  [SMALL_STATE(525)] = 18340,
  [SMALL_STATE(526)] = 18354,
  [SMALL_STATE(527)] = 18366,
  [SMALL_STATE(528)] = 18380,
  [SMALL_STATE(529)] = 18392,
  [SMALL_STATE(530)] = 18406,
  [SMALL_STATE(531)] = 18420,
  [SMALL_STATE(532)] = 18434,
  [SMALL_STATE(533)] = 18444,
  [SMALL_STATE(534)] = 18454,
  [SMALL_STATE(535)] = 18464,
  [SMALL_STATE(536)] = 18474,
  [SMALL_STATE(537)] = 18484,
  [SMALL_STATE(538)] = 18494,
  [SMALL_STATE(539)] = 18504,
  [SMALL_STATE(540)] = 18514,
  [SMALL_STATE(541)] = 18524,
  [SMALL_STATE(542)] = 18534,
  [SMALL_STATE(543)] = 18544,
  [SMALL_STATE(544)] = 18554,
  [SMALL_STATE(545)] = 18564,
  [SMALL_STATE(546)] = 18574,
  [SMALL_STATE(547)] = 18584,
  [SMALL_STATE(548)] = 18594,
  [SMALL_STATE(549)] = 18604,
  [SMALL_STATE(550)] = 18614,
  [SMALL_STATE(551)] = 18624,
  [SMALL_STATE(552)] = 18634,
  [SMALL_STATE(553)] = 18644,
  [SMALL_STATE(554)] = 18654,
  [SMALL_STATE(555)] = 18664,
  [SMALL_STATE(556)] = 18674,
  [SMALL_STATE(557)] = 18684,
  [SMALL_STATE(558)] = 18694,
  [SMALL_STATE(559)] = 18704,
  [SMALL_STATE(560)] = 18714,
  [SMALL_STATE(561)] = 18724,
  [SMALL_STATE(562)] = 18734,
  [SMALL_STATE(563)] = 18744,
  [SMALL_STATE(564)] = 18754,
  [SMALL_STATE(565)] = 18764,
  [SMALL_STATE(566)] = 18774,
  [SMALL_STATE(567)] = 18784,
  [SMALL_STATE(568)] = 18794,
  [SMALL_STATE(569)] = 18804,
  [SMALL_STATE(570)] = 18814,
  [SMALL_STATE(571)] = 18824,
  [SMALL_STATE(572)] = 18834,
  [SMALL_STATE(573)] = 18844,
  [SMALL_STATE(574)] = 18854,
  [SMALL_STATE(575)] = 18864,
  [SMALL_STATE(576)] = 18874,
  [SMALL_STATE(577)] = 18880,
  [SMALL_STATE(578)] = 18890,
  [SMALL_STATE(579)] = 18900,
  [SMALL_STATE(580)] = 18910,
  [SMALL_STATE(581)] = 18920,
  [SMALL_STATE(582)] = 18930,
  [SMALL_STATE(583)] = 18940,
  [SMALL_STATE(584)] = 18950,
  [SMALL_STATE(585)] = 18960,
  [SMALL_STATE(586)] = 18970,
  [SMALL_STATE(587)] = 18980,
  [SMALL_STATE(588)] = 18990,
  [SMALL_STATE(589)] = 19000,
  [SMALL_STATE(590)] = 19010,
  [SMALL_STATE(591)] = 19020,
  [SMALL_STATE(592)] = 19030,
  [SMALL_STATE(593)] = 19040,
  [SMALL_STATE(594)] = 19050,
  [SMALL_STATE(595)] = 19060,
  [SMALL_STATE(596)] = 19070,
  [SMALL_STATE(597)] = 19080,
  [SMALL_STATE(598)] = 19090,
  [SMALL_STATE(599)] = 19100,
  [SMALL_STATE(600)] = 19110,
  [SMALL_STATE(601)] = 19120,
  [SMALL_STATE(602)] = 19130,
  [SMALL_STATE(603)] = 19140,
  [SMALL_STATE(604)] = 19150,
  [SMALL_STATE(605)] = 19160,
  [SMALL_STATE(606)] = 19170,
  [SMALL_STATE(607)] = 19180,
  [SMALL_STATE(608)] = 19190,
  [SMALL_STATE(609)] = 19200,
  [SMALL_STATE(610)] = 19210,
  [SMALL_STATE(611)] = 19216,
  [SMALL_STATE(612)] = 19222,
  [SMALL_STATE(613)] = 19232,
  [SMALL_STATE(614)] = 19242,
  [SMALL_STATE(615)] = 19252,
  [SMALL_STATE(616)] = 19262,
  [SMALL_STATE(617)] = 19272,
  [SMALL_STATE(618)] = 19282,
  [SMALL_STATE(619)] = 19292,
  [SMALL_STATE(620)] = 19302,
  [SMALL_STATE(621)] = 19312,
  [SMALL_STATE(622)] = 19322,
  [SMALL_STATE(623)] = 19332,
  [SMALL_STATE(624)] = 19342,
  [SMALL_STATE(625)] = 19349,
  [SMALL_STATE(626)] = 19356,
  [SMALL_STATE(627)] = 19363,
  [SMALL_STATE(628)] = 19370,
  [SMALL_STATE(629)] = 19377,
  [SMALL_STATE(630)] = 19384,
  [SMALL_STATE(631)] = 19391,
  [SMALL_STATE(632)] = 19398,
  [SMALL_STATE(633)] = 19405,
  [SMALL_STATE(634)] = 19412,
  [SMALL_STATE(635)] = 19419,
  [SMALL_STATE(636)] = 19426,
  [SMALL_STATE(637)] = 19430,
  [SMALL_STATE(638)] = 19434,
  [SMALL_STATE(639)] = 19438,
  [SMALL_STATE(640)] = 19442,
  [SMALL_STATE(641)] = 19446,
  [SMALL_STATE(642)] = 19450,
  [SMALL_STATE(643)] = 19454,
  [SMALL_STATE(644)] = 19458,
  [SMALL_STATE(645)] = 19462,
  [SMALL_STATE(646)] = 19466,
  [SMALL_STATE(647)] = 19470,
  [SMALL_STATE(648)] = 19474,
  [SMALL_STATE(649)] = 19478,
  [SMALL_STATE(650)] = 19482,
  [SMALL_STATE(651)] = 19486,
  [SMALL_STATE(652)] = 19490,
  [SMALL_STATE(653)] = 19494,
  [SMALL_STATE(654)] = 19498,
  [SMALL_STATE(655)] = 19502,
  [SMALL_STATE(656)] = 19506,
  [SMALL_STATE(657)] = 19510,
  [SMALL_STATE(658)] = 19514,
  [SMALL_STATE(659)] = 19518,
  [SMALL_STATE(660)] = 19522,
  [SMALL_STATE(661)] = 19526,
  [SMALL_STATE(662)] = 19530,
  [SMALL_STATE(663)] = 19534,
  [SMALL_STATE(664)] = 19538,
  [SMALL_STATE(665)] = 19542,
  [SMALL_STATE(666)] = 19546,
  [SMALL_STATE(667)] = 19550,
  [SMALL_STATE(668)] = 19554,
  [SMALL_STATE(669)] = 19558,
  [SMALL_STATE(670)] = 19562,
  [SMALL_STATE(671)] = 19566,
  [SMALL_STATE(672)] = 19570,
  [SMALL_STATE(673)] = 19574,
  [SMALL_STATE(674)] = 19578,
  [SMALL_STATE(675)] = 19582,
  [SMALL_STATE(676)] = 19586,
  [SMALL_STATE(677)] = 19590,
  [SMALL_STATE(678)] = 19594,
  [SMALL_STATE(679)] = 19598,
  [SMALL_STATE(680)] = 19602,
  [SMALL_STATE(681)] = 19606,
  [SMALL_STATE(682)] = 19610,
  [SMALL_STATE(683)] = 19614,
  [SMALL_STATE(684)] = 19618,
  [SMALL_STATE(685)] = 19622,
  [SMALL_STATE(686)] = 19626,
  [SMALL_STATE(687)] = 19630,
  [SMALL_STATE(688)] = 19634,
  [SMALL_STATE(689)] = 19638,
  [SMALL_STATE(690)] = 19642,
  [SMALL_STATE(691)] = 19646,
  [SMALL_STATE(692)] = 19650,
  [SMALL_STATE(693)] = 19654,
  [SMALL_STATE(694)] = 19658,
  [SMALL_STATE(695)] = 19662,
  [SMALL_STATE(696)] = 19666,
  [SMALL_STATE(697)] = 19670,
  [SMALL_STATE(698)] = 19674,
  [SMALL_STATE(699)] = 19678,
  [SMALL_STATE(700)] = 19682,
  [SMALL_STATE(701)] = 19686,
  [SMALL_STATE(702)] = 19690,
  [SMALL_STATE(703)] = 19694,
  [SMALL_STATE(704)] = 19698,
  [SMALL_STATE(705)] = 19702,
  [SMALL_STATE(706)] = 19706,
  [SMALL_STATE(707)] = 19710,
  [SMALL_STATE(708)] = 19714,
  [SMALL_STATE(709)] = 19718,
  [SMALL_STATE(710)] = 19722,
  [SMALL_STATE(711)] = 19726,
  [SMALL_STATE(712)] = 19730,
  [SMALL_STATE(713)] = 19734,
  [SMALL_STATE(714)] = 19738,
  [SMALL_STATE(715)] = 19742,
  [SMALL_STATE(716)] = 19746,
  [SMALL_STATE(717)] = 19750,
  [SMALL_STATE(718)] = 19754,
  [SMALL_STATE(719)] = 19758,
  [SMALL_STATE(720)] = 19762,
  [SMALL_STATE(721)] = 19766,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(593),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(537),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(538),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [295] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(281),
  [298] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(245),
  [301] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(102),
  [304] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(48),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2),
  [309] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(237),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(142),
  [315] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(275),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(545),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(587),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(612),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(557),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(614),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(547),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(608),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(572),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [404] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(141),
  [407] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(593),
  [410] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(545),
  [413] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(546),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2),
  [418] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(534),
  [421] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(535),
  [424] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(536),
  [427] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(537),
  [430] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(612),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoted_argument, 1),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 2),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 1),
  [471] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(334),
  [474] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(270),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [479] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(233),
  [482] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(231),
  [485] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(290),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [490] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(281),
  [493] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(245),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [498] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(152),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(604),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(559),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(607),
  [511] = {.entry = {.count = 1, .reusable = false}}, SHIFT(533),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(591),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(615),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(616),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(554),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(617),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [549] = {.entry = {.count = 1, .reusable = false}}, SHIFT(618),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(553),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(560),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(569),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(561),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [583] = {.entry = {.count = 1, .reusable = false}}, SHIFT(575),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [587] = {.entry = {.count = 1, .reusable = false}}, SHIFT(570),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [591] = {.entry = {.count = 1, .reusable = false}}, SHIFT(592),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(571),
  [595] = {.entry = {.count = 1, .reusable = false}}, SHIFT(556),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(606),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(605),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(532),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(582),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [623] = {.entry = {.count = 1, .reusable = false}}, SHIFT(585),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [627] = {.entry = {.count = 1, .reusable = false}}, SHIFT(584),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [631] = {.entry = {.count = 1, .reusable = false}}, SHIFT(583),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [653] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [657] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(215),
  [660] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(593),
  [663] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(534),
  [666] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(535),
  [669] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(536),
  [672] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(537),
  [675] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [677] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(559),
  [680] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(216),
  [683] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(533),
  [686] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(218),
  [689] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(591),
  [692] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [694] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(226),
  [697] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(538),
  [700] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(228),
  [703] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(574),
  [706] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoted_argument, 1),
  [708] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [710] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(334),
  [713] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(270),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [718] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(232),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [733] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [737] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(405),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(283),
  [743] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(238),
  [746] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [748] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [750] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(525),
  [753] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(285),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2),
  [758] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(241),
  [761] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(514),
  [764] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(284),
  [767] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(242),
  [770] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(508),
  [773] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(287),
  [776] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(243),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_element, 1),
  [781] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [805] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(528),
  [808] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(258),
  [811] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(568),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [818] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(269),
  [821] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(269),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(720),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(721),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 2),
  [834] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 2),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 3),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 3),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 3),
  [842] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 3),
  [844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ref, 1),
  [846] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_ref, 1),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 1),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 2),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 2),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 3),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 3),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 4),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 4),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cache_var, 5),
  [866] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cache_var, 5),
  [868] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_env_var, 5),
  [870] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_env_var, 5),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape_sequence, 1),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_var, 4),
  [878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_var, 4),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(713),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(716),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(701),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [906] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [908] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(286),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [913] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(286),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(704),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(705),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 3),
  [926] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 3),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 4),
  [930] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 4),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 6),
  [934] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 6),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 5),
  [938] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 5),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 3),
  [942] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 3),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 5),
  [946] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 5),
  [948] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 3),
  [950] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 3),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 3),
  [954] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 3),
  [956] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 2),
  [958] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 2),
  [960] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 3),
  [962] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 3),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 3),
  [966] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 3),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 5),
  [970] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 5),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 3),
  [974] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 3),
  [976] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 3),
  [978] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 3),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [982] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [984] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 4),
  [988] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 4),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 4),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 4),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 2),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 2),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 4),
  [1000] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 4),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 4),
  [1004] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 4),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 5),
  [1008] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 5),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 7),
  [1012] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 7),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 4),
  [1016] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 4),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 5),
  [1020] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 5),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 3),
  [1024] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 3),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 2),
  [1028] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 2),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 4),
  [1032] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 4),
  [1034] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 5),
  [1036] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 5),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 4),
  [1040] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 4),
  [1042] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 4),
  [1044] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 4),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 3),
  [1048] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 3),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 5),
  [1052] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 5),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 5),
  [1056] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 5),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 3),
  [1060] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 3),
  [1062] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 2),
  [1064] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 2),
  [1066] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 2),
  [1068] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 2),
  [1070] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 3),
  [1072] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 3),
  [1074] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 3),
  [1076] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 3),
  [1078] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 3),
  [1080] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 3),
  [1082] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [1084] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(338),
  [1087] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(338),
  [1090] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 3),
  [1092] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 3),
  [1094] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 3),
  [1096] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 3),
  [1098] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 3),
  [1100] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 3),
  [1102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 3),
  [1104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 3),
  [1106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(438),
  [1109] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(438),
  [1112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 4),
  [1114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 4),
  [1116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 4),
  [1118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 4),
  [1120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 4),
  [1122] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 4),
  [1124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 4),
  [1126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 4),
  [1128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2),
  [1130] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(465),
  [1133] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(465),
  [1136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 5),
  [1138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 5),
  [1140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 5),
  [1142] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 5),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 5),
  [1146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 5),
  [1148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 5),
  [1150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 5),
  [1152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(494),
  [1155] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(494),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 1),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(708),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(709),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2),
  [1354] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2), SHIFT_REPEAT(594),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1467] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1475] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(706),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(707),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(715),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(699),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [1585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 2),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1611] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_cmake_external_scanner_create(void);
void tree_sitter_cmake_external_scanner_destroy(void *);
bool tree_sitter_cmake_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_cmake_external_scanner_serialize(void *, char *);
void tree_sitter_cmake_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_cmake(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_cmake_external_scanner_create,
      tree_sitter_cmake_external_scanner_destroy,
      tree_sitter_cmake_external_scanner_scan,
      tree_sitter_cmake_external_scanner_serialize,
      tree_sitter_cmake_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
