//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/grpc_service/channel_credentials/tls/v3/tls_credentials.proto

package tlsv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on TlsCredentials with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TlsCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TlsCredentials with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TlsCredentialsMultiError,
// or nil if none found.
func (m *TlsCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *TlsCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRootCertificateProvider()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TlsCredentialsValidationError{
					field:  "RootCertificateProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TlsCredentialsValidationError{
					field:  "RootCertificateProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRootCertificateProvider()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TlsCredentialsValidationError{
				field:  "RootCertificateProvider",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetIdentityCertificateProvider()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TlsCredentialsValidationError{
					field:  "IdentityCertificateProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TlsCredentialsValidationError{
					field:  "IdentityCertificateProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetIdentityCertificateProvider()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TlsCredentialsValidationError{
				field:  "IdentityCertificateProvider",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TlsCredentialsMultiError(errors)
	}

	return nil
}

// TlsCredentialsMultiError is an error wrapping multiple validation errors
// returned by TlsCredentials.ValidateAll() if the designated constraints
// aren't met.
type TlsCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TlsCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TlsCredentialsMultiError) AllErrors() []error { return m }

// TlsCredentialsValidationError is the validation error returned by
// TlsCredentials.Validate if the designated constraints aren't met.
type TlsCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TlsCredentialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TlsCredentialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TlsCredentialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TlsCredentialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TlsCredentialsValidationError) ErrorName() string { return "TlsCredentialsValidationError" }

// Error satisfies the builtin error interface
func (e TlsCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTlsCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TlsCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TlsCredentialsValidationError{}
