/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// LimitRangeSpecApplyConfiguration represents a declarative configuration of the LimitRangeSpec type for use
// with apply.
//
// LimitRangeSpec defines a min/max usage limit for resources that match on kind.
type LimitRangeSpecApplyConfiguration struct {
	// Limits is the list of LimitRangeItem objects that are enforced.
	Limits []LimitRangeItemApplyConfiguration `json:"limits,omitempty"`
}

// LimitRangeSpecApplyConfiguration constructs a declarative configuration of the LimitRangeSpec type for use with
// apply.
func LimitRangeSpec() *LimitRangeSpecApplyConfiguration {
	return &LimitRangeSpecApplyConfiguration{}
}

// WithLimits adds the given value to the Limits field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Limits field.
func (b *LimitRangeSpecApplyConfiguration) WithLimits(values ...*LimitRangeItemApplyConfiguration) *LimitRangeSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithLimits")
		}
		b.Limits = append(b.Limits, *values[i])
	}
	return b
}
