// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

#ifndef CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_X_CARD_HXX
#define CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_X_CARD_HXX

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (LIBXSD_VERSION != 400002000000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace vcard_4_0
{
  class DateType;
  class DateTimeType;
  class TimeStampType;
  class BaseParameterType;
  class ArrayOfParameters;
  class TextParameterType;
  class UriParameterType;
  class TypeValueType;
  class typeParamType;
  class labelParamType;
  class prefParamType;
  class xuidParamType;
  class BasePropertyType;
  class TextPropertyType;
  class TextListPropertyType;
  class NonEmptyTextListPropertyType;
  class UriPropertyType;
  class TextOrUriPropertyType;
  class DateDatetimePropertyType;
  class kindPropType;
  class revPropType;
  class prodidPropType;
  class categoriesPropType;
  class fnPropType;
  class uidPropType;
  class nPropType;
  class notePropType;
  class fburlPropType;
  class titlePropType;
  class affiliationPropType;
  class urlPropType;
  class adrPropType;
  class nicknamePropType;
  class relatedPropType;
  class bdayPropType;
  class anniversaryPropType;
  class photoPropType;
  class SexType;
  class genderPropType;
  class langPropType;
  class telPropType;
  class imppPropType;
  class emailPropType;
  class keyPropType;
  class geoPropType;
  class memberPropType;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

namespace vcard_4_0
{
  class DateType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    DateType ();

    DateType (const char*);

    DateType (const ::std::string&);

    DateType (const ::xml_schema::string&);

    DateType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    DateType (const ::xercesc::DOMAttr& a,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    DateType (const ::std::string& s,
              const ::xercesc::DOMElement* e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    DateType (const DateType& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual DateType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DateType&
    operator= (const DateType&) = default;
#endif

    virtual 
    ~DateType ();
  };

  class DateTimeType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    DateTimeType ();

    DateTimeType (const char*);

    DateTimeType (const ::std::string&);

    DateTimeType (const ::xml_schema::string&);

    DateTimeType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    DateTimeType (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    DateTimeType (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    DateTimeType (const DateTimeType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual DateTimeType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DateTimeType&
    operator= (const DateTimeType&) = default;
#endif

    virtual 
    ~DateTimeType ();
  };

  class TimeStampType: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    TimeStampType ();

    TimeStampType (const char*);

    TimeStampType (const ::std::string&);

    TimeStampType (const ::xml_schema::string&);

    TimeStampType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TimeStampType (const ::xercesc::DOMAttr& a,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TimeStampType (const ::std::string& s,
                   const ::xercesc::DOMElement* e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TimeStampType (const TimeStampType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual TimeStampType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TimeStampType&
    operator= (const TimeStampType&) = default;
#endif

    virtual 
    ~TimeStampType ();
  };

  class BaseParameterType: public ::xml_schema::type
  {
    public:
    // Constructors.
    //
    BaseParameterType ();

    BaseParameterType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BaseParameterType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BaseParameterType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BaseParameterType (const BaseParameterType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual BaseParameterType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const = 0;

#ifdef XSD_CXX11
    BaseParameterType&
    operator= (const BaseParameterType&) = default;
#endif

    virtual 
    ~BaseParameterType ();
  };

  class ArrayOfParameters: public ::xml_schema::type
  {
    public:
    // baseParameter
    //
    typedef ::vcard_4_0::BaseParameterType baseParameter_type;
    typedef ::xsd::cxx::tree::sequence< baseParameter_type > baseParameter_sequence;
    typedef baseParameter_sequence::iterator baseParameter_iterator;
    typedef baseParameter_sequence::const_iterator baseParameter_const_iterator;
    typedef ::xsd::cxx::tree::traits< baseParameter_type, char > baseParameter_traits;

    const baseParameter_sequence&
    baseParameter () const;

    baseParameter_sequence&
    baseParameter ();

    void
    baseParameter (const baseParameter_sequence& s);

    // Constructors.
    //
    ArrayOfParameters ();

    ArrayOfParameters (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ArrayOfParameters (const ArrayOfParameters& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual ArrayOfParameters*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ArrayOfParameters&
    operator= (const ArrayOfParameters& x);

    virtual 
    ~ArrayOfParameters ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    baseParameter_sequence baseParameter_;
  };

  class TextParameterType: public ::vcard_4_0::BaseParameterType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    TextParameterType (const text_type&);

    TextParameterType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    TextParameterType (const TextParameterType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual TextParameterType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextParameterType&
    operator= (const TextParameterType& x);

    virtual 
    ~TextParameterType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class UriParameterType: public ::vcard_4_0::BaseParameterType
  {
    public:
    // uri
    //
    typedef ::xml_schema::uri uri_type;
    typedef ::xsd::cxx::tree::traits< uri_type, char > uri_traits;

    const uri_type&
    uri () const;

    uri_type&
    uri ();

    void
    uri (const uri_type& x);

    void
    uri (::std::unique_ptr< uri_type > p);

    // Constructors.
    //
    UriParameterType (const uri_type&);

    UriParameterType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    UriParameterType (const UriParameterType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual UriParameterType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    UriParameterType&
    operator= (const UriParameterType& x);

    virtual 
    ~UriParameterType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uri_type > uri_;
  };

  class TypeValueType: public ::xml_schema::token
  {
    public:
    enum value
    {
      work,
      home,
      text,
      voice,
      fax,
      cell,
      video,
      pager,
      textphone,
      x_car,
      spouse,
      child,
      x_assistant,
      x_manager,
      x_blog
    };

    TypeValueType (value v);

    TypeValueType (const char* v);

    TypeValueType (const ::std::string& v);

    TypeValueType (const ::xml_schema::token& v);

    TypeValueType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TypeValueType (const ::xercesc::DOMAttr& a,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TypeValueType (const ::std::string& s,
                   const ::xercesc::DOMElement* e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TypeValueType (const TypeValueType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    TypeValueType&
    operator= (const TypeValueType&) = default;
#endif

    virtual TypeValueType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TypeValueType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_TypeValueType_convert ();
    }

    protected:
    value
    _xsd_TypeValueType_convert () const;

    public:
    static const char* const _xsd_TypeValueType_literals_[15];
    static const value _xsd_TypeValueType_indexes_[15];
  };

  class typeParamType: public ::vcard_4_0::BaseParameterType
  {
    public:
    // text
    //
    typedef ::vcard_4_0::TypeValueType text_type;
    typedef ::xsd::cxx::tree::sequence< text_type > text_sequence;
    typedef text_sequence::iterator text_iterator;
    typedef text_sequence::const_iterator text_const_iterator;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_sequence&
    text () const;

    text_sequence&
    text ();

    void
    text (const text_sequence& s);

    // Constructors.
    //
    typeParamType ();

    typeParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    typeParamType (const typeParamType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual typeParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    typeParamType&
    operator= (const typeParamType& x);

    virtual 
    ~typeParamType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    text_sequence text_;
  };

  class labelParamType: public ::vcard_4_0::TextParameterType
  {
    public:
    // Constructors.
    //
    labelParamType (const text_type&);

    labelParamType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    labelParamType (const labelParamType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual labelParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    labelParamType&
    operator= (const labelParamType&) = default;
#endif

    virtual 
    ~labelParamType ();
  };

  class prefParamType: public ::vcard_4_0::BaseParameterType
  {
    public:
    // integer
    //
    typedef ::xml_schema::string integer_type;
    typedef ::xsd::cxx::tree::traits< integer_type, char > integer_traits;

    const integer_type&
    integer () const;

    integer_type&
    integer ();

    void
    integer (const integer_type& x);

    void
    integer (::std::unique_ptr< integer_type > p);

    static const integer_type&
    integer_default_value ();

    // Constructors.
    //
    prefParamType (const integer_type&);

    prefParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    prefParamType (const prefParamType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual prefParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    prefParamType&
    operator= (const prefParamType& x);

    virtual 
    ~prefParamType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< integer_type > integer_;
    static const integer_type integer_default_value_;
  };

  class xuidParamType: public ::vcard_4_0::UriParameterType
  {
    public:
    // Constructors.
    //
    xuidParamType (const uri_type&);

    xuidParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    xuidParamType (const xuidParamType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual xuidParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    xuidParamType&
    operator= (const xuidParamType&) = default;
#endif

    virtual 
    ~xuidParamType ();
  };

  class BasePropertyType: public ::xml_schema::type
  {
    public:
    // parameters
    //
    typedef ::vcard_4_0::ArrayOfParameters parameters_type;
    typedef ::xsd::cxx::tree::optional< parameters_type > parameters_optional;
    typedef ::xsd::cxx::tree::traits< parameters_type, char > parameters_traits;

    const parameters_optional&
    parameters () const;

    parameters_optional&
    parameters ();

    void
    parameters (const parameters_type& x);

    void
    parameters (const parameters_optional& x);

    void
    parameters (::std::unique_ptr< parameters_type > p);

    // Constructors.
    //
    BasePropertyType ();

    BasePropertyType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    BasePropertyType (const BasePropertyType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual BasePropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const = 0;

    BasePropertyType&
    operator= (const BasePropertyType& x);

    virtual 
    ~BasePropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    parameters_optional parameters_;
  };

  class TextPropertyType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    TextPropertyType (const text_type&);

    TextPropertyType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    TextPropertyType (const TextPropertyType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual TextPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextPropertyType&
    operator= (const TextPropertyType& x);

    virtual 
    ~TextPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class TextListPropertyType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::sequence< text_type > text_sequence;
    typedef text_sequence::iterator text_iterator;
    typedef text_sequence::const_iterator text_const_iterator;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_sequence&
    text () const;

    text_sequence&
    text ();

    void
    text (const text_sequence& s);

    // Constructors.
    //
    TextListPropertyType ();

    TextListPropertyType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    TextListPropertyType (const TextListPropertyType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual TextListPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextListPropertyType&
    operator= (const TextListPropertyType& x);

    virtual 
    ~TextListPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    text_sequence text_;
  };

  class NonEmptyTextListPropertyType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::sequence< text_type > text_sequence;
    typedef text_sequence::iterator text_iterator;
    typedef text_sequence::const_iterator text_const_iterator;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_sequence&
    text () const;

    text_sequence&
    text ();

    void
    text (const text_sequence& s);

    // Constructors.
    //
    NonEmptyTextListPropertyType ();

    NonEmptyTextListPropertyType (const ::xercesc::DOMElement& e,
                                  ::xml_schema::flags f = 0,
                                  ::xml_schema::container* c = 0);

    NonEmptyTextListPropertyType (const NonEmptyTextListPropertyType& x,
                                  ::xml_schema::flags f = 0,
                                  ::xml_schema::container* c = 0);

    virtual NonEmptyTextListPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    NonEmptyTextListPropertyType&
    operator= (const NonEmptyTextListPropertyType& x);

    virtual 
    ~NonEmptyTextListPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    text_sequence text_;
  };

  class UriPropertyType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // uri
    //
    typedef ::xml_schema::uri uri_type;
    typedef ::xsd::cxx::tree::traits< uri_type, char > uri_traits;

    const uri_type&
    uri () const;

    uri_type&
    uri ();

    void
    uri (const uri_type& x);

    void
    uri (::std::unique_ptr< uri_type > p);

    // Constructors.
    //
    UriPropertyType (const uri_type&);

    UriPropertyType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    UriPropertyType (const UriPropertyType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual UriPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    UriPropertyType&
    operator= (const UriPropertyType& x);

    virtual 
    ~UriPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uri_type > uri_;
  };

  class TextOrUriPropertyType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::optional< text_type > text_optional;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_optional&
    text () const;

    text_optional&
    text ();

    void
    text (const text_type& x);

    void
    text (const text_optional& x);

    void
    text (::std::unique_ptr< text_type > p);

    // uri
    //
    typedef ::xml_schema::uri uri_type;
    typedef ::xsd::cxx::tree::optional< uri_type > uri_optional;
    typedef ::xsd::cxx::tree::traits< uri_type, char > uri_traits;

    const uri_optional&
    uri () const;

    uri_optional&
    uri ();

    void
    uri (const uri_type& x);

    void
    uri (const uri_optional& x);

    void
    uri (::std::unique_ptr< uri_type > p);

    // Constructors.
    //
    TextOrUriPropertyType ();

    TextOrUriPropertyType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    TextOrUriPropertyType (const TextOrUriPropertyType& x,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    virtual TextOrUriPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextOrUriPropertyType&
    operator= (const TextOrUriPropertyType& x);

    virtual 
    ~TextOrUriPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    text_optional text_;
    uri_optional uri_;
  };

  class DateDatetimePropertyType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // date-time
    //
    typedef ::vcard_4_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::optional< date_time_type > date_time_optional;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_optional&
    date_time () const;

    date_time_optional&
    date_time ();

    void
    date_time (const date_time_type& x);

    void
    date_time (const date_time_optional& x);

    void
    date_time (::std::unique_ptr< date_time_type > p);

    // date
    //
    typedef ::vcard_4_0::DateType date_type;
    typedef ::xsd::cxx::tree::optional< date_type > date_optional;
    typedef ::xsd::cxx::tree::traits< date_type, char > date_traits;

    const date_optional&
    date () const;

    date_optional&
    date ();

    void
    date (const date_type& x);

    void
    date (const date_optional& x);

    void
    date (::std::unique_ptr< date_type > p);

    // Constructors.
    //
    DateDatetimePropertyType ();

    DateDatetimePropertyType (const ::xercesc::DOMElement& e,
                              ::xml_schema::flags f = 0,
                              ::xml_schema::container* c = 0);

    DateDatetimePropertyType (const DateDatetimePropertyType& x,
                              ::xml_schema::flags f = 0,
                              ::xml_schema::container* c = 0);

    virtual DateDatetimePropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DateDatetimePropertyType&
    operator= (const DateDatetimePropertyType& x);

    virtual 
    ~DateDatetimePropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    date_time_optional date_time_;
    date_optional date_;
  };

  class kindPropType: public ::vcard_4_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    kindPropType (const text_type&);

    kindPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    kindPropType (const kindPropType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual kindPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    kindPropType&
    operator= (const kindPropType&) = default;
#endif

    virtual 
    ~kindPropType ();
  };

  class revPropType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // timestamp
    //
    typedef ::vcard_4_0::TimeStampType timestamp_type;
    typedef ::xsd::cxx::tree::traits< timestamp_type, char > timestamp_traits;

    const timestamp_type&
    timestamp () const;

    timestamp_type&
    timestamp ();

    void
    timestamp (const timestamp_type& x);

    void
    timestamp (::std::unique_ptr< timestamp_type > p);

    // Constructors.
    //
    revPropType (const timestamp_type&);

    revPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    revPropType (const revPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual revPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    revPropType&
    operator= (const revPropType& x);

    virtual 
    ~revPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< timestamp_type > timestamp_;
  };

  class prodidPropType: public ::vcard_4_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    prodidPropType (const text_type&);

    prodidPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    prodidPropType (const prodidPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual prodidPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    prodidPropType&
    operator= (const prodidPropType&) = default;
#endif

    virtual 
    ~prodidPropType ();
  };

  class categoriesPropType: public ::vcard_4_0::TextListPropertyType
  {
    public:
    // Constructors.
    //
    categoriesPropType ();

    categoriesPropType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    categoriesPropType (const categoriesPropType& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual categoriesPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    categoriesPropType&
    operator= (const categoriesPropType&) = default;
#endif

    virtual 
    ~categoriesPropType ();
  };

  class fnPropType: public ::vcard_4_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    fnPropType (const text_type&);

    fnPropType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    fnPropType (const fnPropType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual fnPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    fnPropType&
    operator= (const fnPropType&) = default;
#endif

    virtual 
    ~fnPropType ();
  };

  class uidPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    uidPropType (const uri_type&);

    uidPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    uidPropType (const uidPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual uidPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    uidPropType&
    operator= (const uidPropType&) = default;
#endif

    virtual 
    ~uidPropType ();
  };

  class nPropType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // surname
    //
    typedef ::xml_schema::string surname_type;
    typedef ::xsd::cxx::tree::sequence< surname_type > surname_sequence;
    typedef surname_sequence::iterator surname_iterator;
    typedef surname_sequence::const_iterator surname_const_iterator;
    typedef ::xsd::cxx::tree::traits< surname_type, char > surname_traits;

    const surname_sequence&
    surname () const;

    surname_sequence&
    surname ();

    void
    surname (const surname_sequence& s);

    // given
    //
    typedef ::xml_schema::string given_type;
    typedef ::xsd::cxx::tree::sequence< given_type > given_sequence;
    typedef given_sequence::iterator given_iterator;
    typedef given_sequence::const_iterator given_const_iterator;
    typedef ::xsd::cxx::tree::traits< given_type, char > given_traits;

    const given_sequence&
    given () const;

    given_sequence&
    given ();

    void
    given (const given_sequence& s);

    // additional
    //
    typedef ::xml_schema::string additional_type;
    typedef ::xsd::cxx::tree::sequence< additional_type > additional_sequence;
    typedef additional_sequence::iterator additional_iterator;
    typedef additional_sequence::const_iterator additional_const_iterator;
    typedef ::xsd::cxx::tree::traits< additional_type, char > additional_traits;

    const additional_sequence&
    additional () const;

    additional_sequence&
    additional ();

    void
    additional (const additional_sequence& s);

    // prefix
    //
    typedef ::xml_schema::string prefix_type;
    typedef ::xsd::cxx::tree::sequence< prefix_type > prefix_sequence;
    typedef prefix_sequence::iterator prefix_iterator;
    typedef prefix_sequence::const_iterator prefix_const_iterator;
    typedef ::xsd::cxx::tree::traits< prefix_type, char > prefix_traits;

    const prefix_sequence&
    prefix () const;

    prefix_sequence&
    prefix ();

    void
    prefix (const prefix_sequence& s);

    // suffix
    //
    typedef ::xml_schema::string suffix_type;
    typedef ::xsd::cxx::tree::sequence< suffix_type > suffix_sequence;
    typedef suffix_sequence::iterator suffix_iterator;
    typedef suffix_sequence::const_iterator suffix_const_iterator;
    typedef ::xsd::cxx::tree::traits< suffix_type, char > suffix_traits;

    const suffix_sequence&
    suffix () const;

    suffix_sequence&
    suffix ();

    void
    suffix (const suffix_sequence& s);

    // Constructors.
    //
    nPropType ();

    nPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    nPropType (const nPropType& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual nPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    nPropType&
    operator= (const nPropType& x);

    virtual 
    ~nPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    surname_sequence surname_;
    given_sequence given_;
    additional_sequence additional_;
    prefix_sequence prefix_;
    suffix_sequence suffix_;
  };

  class notePropType: public ::vcard_4_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    notePropType (const text_type&);

    notePropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    notePropType (const notePropType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual notePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    notePropType&
    operator= (const notePropType&) = default;
#endif

    virtual 
    ~notePropType ();
  };

  class fburlPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    fburlPropType (const uri_type&);

    fburlPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    fburlPropType (const fburlPropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual fburlPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    fburlPropType&
    operator= (const fburlPropType&) = default;
#endif

    virtual 
    ~fburlPropType ();
  };

  class titlePropType: public ::vcard_4_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    titlePropType (const text_type&);

    titlePropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    titlePropType (const titlePropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual titlePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    titlePropType&
    operator= (const titlePropType&) = default;
#endif

    virtual 
    ~titlePropType ();
  };

  class affiliationPropType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // org
    //
    typedef ::vcard_4_0::NonEmptyTextListPropertyType org_type;
    typedef ::xsd::cxx::tree::traits< org_type, char > org_traits;

    const org_type&
    org () const;

    org_type&
    org ();

    void
    org (const org_type& x);

    void
    org (::std::unique_ptr< org_type > p);

    // logo
    //
    typedef ::vcard_4_0::UriPropertyType logo_type;
    typedef ::xsd::cxx::tree::optional< logo_type > logo_optional;
    typedef ::xsd::cxx::tree::traits< logo_type, char > logo_traits;

    const logo_optional&
    logo () const;

    logo_optional&
    logo ();

    void
    logo (const logo_type& x);

    void
    logo (const logo_optional& x);

    void
    logo (::std::unique_ptr< logo_type > p);

    // role
    //
    typedef ::vcard_4_0::TextPropertyType role_type;
    typedef ::xsd::cxx::tree::sequence< role_type > role_sequence;
    typedef role_sequence::iterator role_iterator;
    typedef role_sequence::const_iterator role_const_iterator;
    typedef ::xsd::cxx::tree::traits< role_type, char > role_traits;

    const role_sequence&
    role () const;

    role_sequence&
    role ();

    void
    role (const role_sequence& s);

    // related
    //
    typedef ::vcard_4_0::relatedPropType related_type;
    typedef ::xsd::cxx::tree::sequence< related_type > related_sequence;
    typedef related_sequence::iterator related_iterator;
    typedef related_sequence::const_iterator related_const_iterator;
    typedef ::xsd::cxx::tree::traits< related_type, char > related_traits;

    const related_sequence&
    related () const;

    related_sequence&
    related ();

    void
    related (const related_sequence& s);

    // adr
    //
    typedef ::vcard_4_0::adrPropType adr_type;
    typedef ::xsd::cxx::tree::sequence< adr_type > adr_sequence;
    typedef adr_sequence::iterator adr_iterator;
    typedef adr_sequence::const_iterator adr_const_iterator;
    typedef ::xsd::cxx::tree::traits< adr_type, char > adr_traits;

    const adr_sequence&
    adr () const;

    adr_sequence&
    adr ();

    void
    adr (const adr_sequence& s);

    // name
    //
    typedef ::xml_schema::string name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    static const name_type&
    name_default_value ();

    // Constructors.
    //
    affiliationPropType (const org_type&);

    affiliationPropType (::std::unique_ptr< org_type >);

    affiliationPropType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    affiliationPropType (const affiliationPropType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual affiliationPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    affiliationPropType&
    operator= (const affiliationPropType& x);

    virtual 
    ~affiliationPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< org_type > org_;
    logo_optional logo_;
    role_sequence role_;
    related_sequence related_;
    adr_sequence adr_;
    ::xsd::cxx::tree::one< name_type > name_;
    static const name_type name_default_value_;
  };

  class urlPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    urlPropType (const uri_type&);

    urlPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    urlPropType (const urlPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual urlPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    urlPropType&
    operator= (const urlPropType&) = default;
#endif

    virtual 
    ~urlPropType ();
  };

  class adrPropType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // pobox
    //
    typedef ::xml_schema::string pobox_type;
    typedef ::xsd::cxx::tree::traits< pobox_type, char > pobox_traits;

    const pobox_type&
    pobox () const;

    pobox_type&
    pobox ();

    void
    pobox (const pobox_type& x);

    void
    pobox (::std::unique_ptr< pobox_type > p);

    // ext
    //
    typedef ::xml_schema::string ext_type;
    typedef ::xsd::cxx::tree::traits< ext_type, char > ext_traits;

    const ext_type&
    ext () const;

    ext_type&
    ext ();

    void
    ext (const ext_type& x);

    void
    ext (::std::unique_ptr< ext_type > p);

    // street
    //
    typedef ::xml_schema::string street_type;
    typedef ::xsd::cxx::tree::traits< street_type, char > street_traits;

    const street_type&
    street () const;

    street_type&
    street ();

    void
    street (const street_type& x);

    void
    street (::std::unique_ptr< street_type > p);

    // locality
    //
    typedef ::xml_schema::string locality_type;
    typedef ::xsd::cxx::tree::traits< locality_type, char > locality_traits;

    const locality_type&
    locality () const;

    locality_type&
    locality ();

    void
    locality (const locality_type& x);

    void
    locality (::std::unique_ptr< locality_type > p);

    // region
    //
    typedef ::xml_schema::string region_type;
    typedef ::xsd::cxx::tree::traits< region_type, char > region_traits;

    const region_type&
    region () const;

    region_type&
    region ();

    void
    region (const region_type& x);

    void
    region (::std::unique_ptr< region_type > p);

    // code
    //
    typedef ::xml_schema::string code_type;
    typedef ::xsd::cxx::tree::traits< code_type, char > code_traits;

    const code_type&
    code () const;

    code_type&
    code ();

    void
    code (const code_type& x);

    void
    code (::std::unique_ptr< code_type > p);

    // country
    //
    typedef ::xml_schema::string country_type;
    typedef ::xsd::cxx::tree::traits< country_type, char > country_traits;

    const country_type&
    country () const;

    country_type&
    country ();

    void
    country (const country_type& x);

    void
    country (::std::unique_ptr< country_type > p);

    // Constructors.
    //
    adrPropType (const pobox_type&,
                 const ext_type&,
                 const street_type&,
                 const locality_type&,
                 const region_type&,
                 const code_type&,
                 const country_type&);

    adrPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    adrPropType (const adrPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual adrPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    adrPropType&
    operator= (const adrPropType& x);

    virtual 
    ~adrPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< pobox_type > pobox_;
    ::xsd::cxx::tree::one< ext_type > ext_;
    ::xsd::cxx::tree::one< street_type > street_;
    ::xsd::cxx::tree::one< locality_type > locality_;
    ::xsd::cxx::tree::one< region_type > region_;
    ::xsd::cxx::tree::one< code_type > code_;
    ::xsd::cxx::tree::one< country_type > country_;
  };

  class nicknamePropType: public ::vcard_4_0::TextListPropertyType
  {
    public:
    // Constructors.
    //
    nicknamePropType ();

    nicknamePropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    nicknamePropType (const nicknamePropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual nicknamePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    nicknamePropType&
    operator= (const nicknamePropType&) = default;
#endif

    virtual 
    ~nicknamePropType ();
  };

  class relatedPropType: public ::vcard_4_0::TextOrUriPropertyType
  {
    public:
    // Constructors.
    //
    relatedPropType ();

    relatedPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    relatedPropType (const relatedPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual relatedPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    relatedPropType&
    operator= (const relatedPropType&) = default;
#endif

    virtual 
    ~relatedPropType ();
  };

  class bdayPropType: public ::vcard_4_0::DateDatetimePropertyType
  {
    public:
    // Constructors.
    //
    bdayPropType ();

    bdayPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    bdayPropType (const bdayPropType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual bdayPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    bdayPropType&
    operator= (const bdayPropType&) = default;
#endif

    virtual 
    ~bdayPropType ();
  };

  class anniversaryPropType: public ::vcard_4_0::DateDatetimePropertyType
  {
    public:
    // Constructors.
    //
    anniversaryPropType ();

    anniversaryPropType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    anniversaryPropType (const anniversaryPropType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual anniversaryPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    anniversaryPropType&
    operator= (const anniversaryPropType&) = default;
#endif

    virtual 
    ~anniversaryPropType ();
  };

  class photoPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    photoPropType (const uri_type&);

    photoPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    photoPropType (const photoPropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual photoPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    photoPropType&
    operator= (const photoPropType&) = default;
#endif

    virtual 
    ~photoPropType ();
  };

  class SexType: public ::xml_schema::token
  {
    public:
    enum value
    {
      empty,
      M,
      F
    };

    SexType (value v);

    SexType (const char* v);

    SexType (const ::std::string& v);

    SexType (const ::xml_schema::token& v);

    SexType (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    SexType (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    SexType (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    SexType (const SexType& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    SexType&
    operator= (const SexType&) = default;
#endif

    virtual SexType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    SexType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_SexType_convert ();
    }

    protected:
    value
    _xsd_SexType_convert () const;

    public:
    static const char* const _xsd_SexType_literals_[3];
    static const value _xsd_SexType_indexes_[3];
  };

  class genderPropType: public ::xml_schema::type
  {
    public:
    // sex
    //
    typedef ::vcard_4_0::SexType sex_type;
    typedef ::xsd::cxx::tree::traits< sex_type, char > sex_traits;

    const sex_type&
    sex () const;

    sex_type&
    sex ();

    void
    sex (const sex_type& x);

    void
    sex (::std::unique_ptr< sex_type > p);

    // Constructors.
    //
    genderPropType (const sex_type&);

    genderPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    genderPropType (const genderPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual genderPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    genderPropType&
    operator= (const genderPropType& x);

    virtual 
    ~genderPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< sex_type > sex_;
  };

  class langPropType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // language-tag
    //
    typedef ::xml_schema::string language_tag_type;
    typedef ::xsd::cxx::tree::traits< language_tag_type, char > language_tag_traits;

    const language_tag_type&
    language_tag () const;

    language_tag_type&
    language_tag ();

    void
    language_tag (const language_tag_type& x);

    void
    language_tag (::std::unique_ptr< language_tag_type > p);

    // Constructors.
    //
    langPropType (const language_tag_type&);

    langPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    langPropType (const langPropType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual langPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    langPropType&
    operator= (const langPropType& x);

    virtual 
    ~langPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< language_tag_type > language_tag_;
  };

  class telPropType: public ::vcard_4_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    telPropType (const text_type&);

    telPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    telPropType (const telPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual telPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    telPropType&
    operator= (const telPropType&) = default;
#endif

    virtual 
    ~telPropType ();
  };

  class imppPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    imppPropType (const uri_type&);

    imppPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    imppPropType (const imppPropType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual imppPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    imppPropType&
    operator= (const imppPropType&) = default;
#endif

    virtual 
    ~imppPropType ();
  };

  class emailPropType: public ::vcard_4_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    emailPropType (const text_type&);

    emailPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    emailPropType (const emailPropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual emailPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    emailPropType&
    operator= (const emailPropType&) = default;
#endif

    virtual 
    ~emailPropType ();
  };

  class keyPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    keyPropType (const uri_type&);

    keyPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    keyPropType (const keyPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual keyPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    keyPropType&
    operator= (const keyPropType&) = default;
#endif

    virtual 
    ~keyPropType ();
  };

  class geoPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    geoPropType (const uri_type&);

    geoPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    geoPropType (const geoPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual geoPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    geoPropType&
    operator= (const geoPropType&) = default;
#endif

    virtual 
    ~geoPropType ();
  };

  class memberPropType: public ::vcard_4_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    memberPropType (const uri_type&);

    memberPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    memberPropType (const memberPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual memberPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    memberPropType&
    operator= (const memberPropType&) = default;
#endif

    virtual 
    ~memberPropType ();
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace vcard_4_0
{
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace vcard_4_0
{
  void
  operator<< (::xercesc::DOMElement&, const DateType&);

  void
  operator<< (::xercesc::DOMAttr&, const DateType&);

  void
  operator<< (::xml_schema::list_stream&,
              const DateType&);

  void
  operator<< (::xercesc::DOMElement&, const DateTimeType&);

  void
  operator<< (::xercesc::DOMAttr&, const DateTimeType&);

  void
  operator<< (::xml_schema::list_stream&,
              const DateTimeType&);

  void
  operator<< (::xercesc::DOMElement&, const TimeStampType&);

  void
  operator<< (::xercesc::DOMAttr&, const TimeStampType&);

  void
  operator<< (::xml_schema::list_stream&,
              const TimeStampType&);

  void
  operator<< (::xercesc::DOMElement&, const BaseParameterType&);

  void
  operator<< (::xercesc::DOMAttr&, const BaseParameterType&);

  void
  operator<< (::xml_schema::list_stream&,
              const BaseParameterType&);

  void
  operator<< (::xercesc::DOMElement&, const ArrayOfParameters&);

  void
  operator<< (::xercesc::DOMElement&, const TextParameterType&);

  void
  operator<< (::xercesc::DOMElement&, const UriParameterType&);

  void
  operator<< (::xercesc::DOMElement&, const TypeValueType&);

  void
  operator<< (::xercesc::DOMAttr&, const TypeValueType&);

  void
  operator<< (::xml_schema::list_stream&,
              const TypeValueType&);

  void
  operator<< (::xercesc::DOMElement&, const typeParamType&);

  void
  operator<< (::xercesc::DOMElement&, const labelParamType&);

  void
  operator<< (::xercesc::DOMElement&, const prefParamType&);

  void
  operator<< (::xercesc::DOMElement&, const xuidParamType&);

  void
  operator<< (::xercesc::DOMElement&, const BasePropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const TextPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const TextListPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const NonEmptyTextListPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const UriPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const TextOrUriPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const DateDatetimePropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const kindPropType&);

  void
  operator<< (::xercesc::DOMElement&, const revPropType&);

  void
  operator<< (::xercesc::DOMElement&, const prodidPropType&);

  void
  operator<< (::xercesc::DOMElement&, const categoriesPropType&);

  void
  operator<< (::xercesc::DOMElement&, const fnPropType&);

  void
  operator<< (::xercesc::DOMElement&, const uidPropType&);

  void
  operator<< (::xercesc::DOMElement&, const nPropType&);

  void
  operator<< (::xercesc::DOMElement&, const notePropType&);

  void
  operator<< (::xercesc::DOMElement&, const fburlPropType&);

  void
  operator<< (::xercesc::DOMElement&, const titlePropType&);

  void
  operator<< (::xercesc::DOMElement&, const affiliationPropType&);

  void
  operator<< (::xercesc::DOMElement&, const urlPropType&);

  void
  operator<< (::xercesc::DOMElement&, const adrPropType&);

  void
  operator<< (::xercesc::DOMElement&, const nicknamePropType&);

  void
  operator<< (::xercesc::DOMElement&, const relatedPropType&);

  void
  operator<< (::xercesc::DOMElement&, const bdayPropType&);

  void
  operator<< (::xercesc::DOMElement&, const anniversaryPropType&);

  void
  operator<< (::xercesc::DOMElement&, const photoPropType&);

  void
  operator<< (::xercesc::DOMElement&, const SexType&);

  void
  operator<< (::xercesc::DOMAttr&, const SexType&);

  void
  operator<< (::xml_schema::list_stream&,
              const SexType&);

  void
  operator<< (::xercesc::DOMElement&, const genderPropType&);

  void
  operator<< (::xercesc::DOMElement&, const langPropType&);

  void
  operator<< (::xercesc::DOMElement&, const telPropType&);

  void
  operator<< (::xercesc::DOMElement&, const imppPropType&);

  void
  operator<< (::xercesc::DOMElement&, const emailPropType&);

  void
  operator<< (::xercesc::DOMElement&, const keyPropType&);

  void
  operator<< (::xercesc::DOMElement&, const geoPropType&);

  void
  operator<< (::xercesc::DOMElement&, const memberPropType&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_X_CARD_HXX
