/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the PPC target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 40;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(PPCInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(PPCInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static PPCInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static PPCInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s64,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_v256s1,
  GILLT_v512s1,
};
const static size_t NumTypeObjects = 10;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(256), 1),
  LLT::vector(ElementCount::getFixed(512), 1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_In32BitModeBit = 1,
  Feature_In64BitModeBit = 9,
  Feature_HasOnlyMSYNCBit = 23,
  Feature_HasSYNCBit = 22,
  Feature_HasSPEBit = 8,
  Feature_HasICBTBit = 21,
  Feature_HasBPERMDBit = 10,
  Feature_HasExtDivBit = 3,
  Feature_IsISA2_06Bit = 11,
  Feature_IsISA2_07Bit = 39,
  Feature_IsISA3_0Bit = 2,
  Feature_HasFPUBit = 0,
  Feature_PCRelativeMemopsBit = 36,
  Feature_IsNotISA3_1Bit = 38,
  Feature_IsAIXBit = 24,
  Feature_NotAIXBit = 25,
  Feature_IsISAFutureBit = 20,
  Feature_IsNotISAFutureBit = 18,
  Feature_HasAltivecBit = 4,
  Feature_HasP8AltivecBit = 5,
  Feature_HasP8CryptoBit = 6,
  Feature_HasP9AltivecBit = 7,
  Feature_HasVSXBit = 12,
  Feature_IsLittleEndianBit = 26,
  Feature_IsBigEndianBit = 27,
  Feature_IsPPC64Bit = 31,
  Feature_HasOnlySwappingMemOpsBit = 29,
  Feature_NoP8VectorBit = 30,
  Feature_HasP8VectorBit = 13,
  Feature_HasDirectMoveBit = 14,
  Feature_NoP9VectorBit = 28,
  Feature_HasP9VectorBit = 15,
  Feature_NoP9AltivecBit = 32,
  Feature_NoP10VectorBit = 33,
  Feature_HasHTMBit = 34,
  Feature_IsPPC32Bit = 37,
  Feature_PrefixInstrsBit = 16,
  Feature_IsISA3_1Bit = 17,
  Feature_PairedVectorMemopsBit = 35,
  Feature_MMABit = 19,
};

PredicateBitset PPCInstructionSelector::
computeAvailableModuleFeatures(const PPCSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (!Subtarget->isPPC64())
    Features.set(Feature_In32BitModeBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasOnlyMSYNCBit);
  if (!Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasSYNCBit);
  if (Subtarget->hasSPE())
    Features.set(Feature_HasSPEBit);
  if (Subtarget->hasICBT())
    Features.set(Feature_HasICBTBit);
  if (Subtarget->hasBPERMD())
    Features.set(Feature_HasBPERMDBit);
  if (Subtarget->hasExtDiv())
    Features.set(Feature_HasExtDivBit);
  if (Subtarget->isISA2_06())
    Features.set(Feature_IsISA2_06Bit);
  if (Subtarget->isISA2_07())
    Features.set(Feature_IsISA2_07Bit);
  if (Subtarget->isISA3_0())
    Features.set(Feature_IsISA3_0Bit);
  if (Subtarget->hasFPU())
    Features.set(Feature_HasFPUBit);
  if (Subtarget->hasPCRelativeMemops())
    Features.set(Feature_PCRelativeMemopsBit);
  if (!Subtarget->isISA3_1())
    Features.set(Feature_IsNotISA3_1Bit);
  if (Subtarget->isAIXABI())
    Features.set(Feature_IsAIXBit);
  if (!Subtarget->isAIXABI())
    Features.set(Feature_NotAIXBit);
  if (Subtarget->isISAFuture())
    Features.set(Feature_IsISAFutureBit);
  if (!Subtarget->isISAFuture())
    Features.set(Feature_IsNotISAFutureBit);
  if (Subtarget->hasAltivec())
    Features.set(Feature_HasAltivecBit);
  if (Subtarget->hasP8Altivec())
    Features.set(Feature_HasP8AltivecBit);
  if (Subtarget->hasP8Crypto())
    Features.set(Feature_HasP8CryptoBit);
  if (Subtarget->hasP9Altivec())
    Features.set(Feature_HasP9AltivecBit);
  if (Subtarget->hasVSX())
    Features.set(Feature_HasVSXBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBigEndianBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_IsPPC64Bit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_HasOnlySwappingMemOpsBit);
  if (!Subtarget->hasP8Vector())
    Features.set(Feature_NoP8VectorBit);
  if (Subtarget->hasP8Vector())
    Features.set(Feature_HasP8VectorBit);
  if (Subtarget->hasDirectMove())
    Features.set(Feature_HasDirectMoveBit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_NoP9VectorBit);
  if (Subtarget->hasP9Vector())
    Features.set(Feature_HasP9VectorBit);
  if (!Subtarget->hasP9Altivec())
    Features.set(Feature_NoP9AltivecBit);
  if (!Subtarget->hasP10Vector())
    Features.set(Feature_NoP10VectorBit);
  if (Subtarget->hasHTM())
    Features.set(Feature_HasHTMBit);
  if (!Subtarget->isPPC64())
    Features.set(Feature_IsPPC32Bit);
  if (Subtarget->hasPrefixInstrs())
    Features.set(Feature_PrefixInstrsBit);
  if (Subtarget->isISA3_1())
    Features.set(Feature_IsISA3_1Bit);
  if (Subtarget->pairedVectorMemops())
    Features.set(Feature_PairedVectorMemopsBit);
  if (Subtarget->hasMMA())
    Features.set(Feature_MMABit);
  return Features;
}

void PPCInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const PPCSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset PPCInstructionSelector::
computeAvailableFunctionFeatures(const PPCSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAltivec,
  GIFBS_HasBPERMD,
  GIFBS_HasExtDiv,
  GIFBS_HasFPU,
  GIFBS_HasHTM,
  GIFBS_HasOnlyMSYNC,
  GIFBS_HasP8Altivec,
  GIFBS_HasP8Crypto,
  GIFBS_HasP9Altivec,
  GIFBS_HasSPE,
  GIFBS_HasSYNC,
  GIFBS_HasVSX,
  GIFBS_In32BitMode,
  GIFBS_In64BitMode,
  GIFBS_IsAIX,
  GIFBS_IsISA3_0,
  GIFBS_IsISA3_1,
  GIFBS_IsNotISA3_1,
  GIFBS_NotAIX,
  GIFBS_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX,
  GIFBS_HasFPU_IsISA3_1,
  GIFBS_HasP8Altivec_HasVSX,
  GIFBS_HasP8Vector_HasVSX,
  GIFBS_HasP9Vector_HasVSX,
  GIFBS_HasVSX_IsISA3_1,
  GIFBS_In64BitMode_IsISA3_0,
  GIFBS_IsISAFuture_MMA,
  GIFBS_IsNotISAFuture_MMA,
  GIFBS_HasP8Altivec_HasVSX_IsBigEndian,
  GIFBS_HasP8Altivec_HasVSX_IsLittleEndian,
  GIFBS_IsISAFuture_MMA_PrefixInstrs,
  GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian,
  GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAltivecBit, },
  {Feature_HasBPERMDBit, },
  {Feature_HasExtDivBit, },
  {Feature_HasFPUBit, },
  {Feature_HasHTMBit, },
  {Feature_HasOnlyMSYNCBit, },
  {Feature_HasP8AltivecBit, },
  {Feature_HasP8CryptoBit, },
  {Feature_HasP9AltivecBit, },
  {Feature_HasSPEBit, },
  {Feature_HasSYNCBit, },
  {Feature_HasVSXBit, },
  {Feature_In32BitModeBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsAIXBit, },
  {Feature_IsISA3_0Bit, },
  {Feature_IsISA3_1Bit, },
  {Feature_IsNotISA3_1Bit, },
  {Feature_NotAIXBit, },
  {Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, },
  {Feature_HasFPUBit, Feature_IsISA3_1Bit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, },
  {Feature_HasP8VectorBit, Feature_HasVSXBit, },
  {Feature_HasP9VectorBit, Feature_HasVSXBit, },
  {Feature_HasVSXBit, Feature_IsISA3_1Bit, },
  {Feature_In64BitModeBit, Feature_IsISA3_0Bit, },
  {Feature_IsISAFutureBit, Feature_MMABit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsBigEndianBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, },
  {Feature_IsISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsISA3_0Bit, Feature_IsLittleEndianBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, Feature_NoP9VectorBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_0Bit, Feature_IsPPC64Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsPPC64Bit, Feature_NoP9VectorBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

PPCInstructionSelector::ComplexMatcherMemFn
PPCInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool PPCInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_Msk2Imm = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_Msk4Imm,
  GICXXPred_I64_Predicate_Msk8Imm,
  GICXXPred_I64_Predicate_i32immNonAllOneNonZero,
  GICXXPred_I64_Predicate_imm32SExt16,
  GICXXPred_I64_Predicate_imm64SExt16,
  GICXXPred_I64_Predicate_imm64ZExt32,
  GICXXPred_I64_Predicate_immNonAllOneAnyExt8,
  GICXXPred_I64_Predicate_immSExt5NonZero,
};
bool PPCInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_Msk2Imm: {
     return isUInt<2>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk4Imm: {
     return isUInt<4>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk8Imm: {
     return isUInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immNonAllOneNonZero: {
     return Imm && (Imm != -1); 
  }
  case GICXXPred_I64_Predicate_imm32SExt16: {
    
      // imm32SExt16 predicate - True if the i32 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int32_t)Imm == (short)Imm;
    
    llvm_unreachable("imm32SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64SExt16: {
    
      // imm64SExt16 predicate - True if the i64 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int64_t)Imm == (short)Imm;
    
    llvm_unreachable("imm64SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64ZExt32: {
    
      // imm64ZExt32 predicate - True if the i64 immediate fits in a 32-bit
      // zero extended field.
      return isUInt<32>(Imm);
    
    llvm_unreachable("imm64ZExt32 should have returned");
  }
  case GICXXPred_I64_Predicate_immNonAllOneAnyExt8: {
    
      return (isInt<8>(Imm) && (Imm != -1)) || (isUInt<8>(Imm) && (Imm != 0xFF));
    
  }
  case GICXXPred_I64_Predicate_immSExt5NonZero: {
     return Imm && isInt<5>(Imm); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("PPCInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
PPCInstructionSelector::CustomRendererFn
PPCInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool PPCInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

void PPCInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("PPCInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *PPCInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(47), GIMT_Encode2(244), /*)*//*default:*//*Label 78*/ GIMT_Encode4(107399),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(798),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(1163),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(1702),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(2033),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(2209),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(2385),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(2567), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(2749),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(3493),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(4237), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ GIMT_Encode4(6017), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 11*/ GIMT_Encode4(7081), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 12*/ GIMT_Encode4(9848),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 13*/ GIMT_Encode4(10152),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 14*/ GIMT_Encode4(10429), GIMT_Encode4(0),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 15*/ GIMT_Encode4(10572), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 16*/ GIMT_Encode4(10595), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 17*/ GIMT_Encode4(10736),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 18*/ GIMT_Encode4(42989), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 19*/ GIMT_Encode4(46335),
    /*TargetOpcode::G_TRUNC*//*Label 20*/ GIMT_Encode4(46543),
    /*TargetOpcode::G_CONSTANT*//*Label 21*/ GIMT_Encode4(46730), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 22*/ GIMT_Encode4(46915), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 23*/ GIMT_Encode4(47148),
    /*TargetOpcode::G_SHL*//*Label 24*/ GIMT_Encode4(47356),
    /*TargetOpcode::G_LSHR*//*Label 25*/ GIMT_Encode4(47747),
    /*TargetOpcode::G_ASHR*//*Label 26*/ GIMT_Encode4(48138), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTL*//*Label 27*/ GIMT_Encode4(48553),
    /*TargetOpcode::G_ICMP*//*Label 28*/ GIMT_Encode4(48923),
    /*TargetOpcode::G_FCMP*//*Label 29*/ GIMT_Encode4(53324),
    /*TargetOpcode::G_SELECT*//*Label 30*/ GIMT_Encode4(57217), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 31*/ GIMT_Encode4(57655),
    /*TargetOpcode::G_SMULH*//*Label 32*/ GIMT_Encode4(57801),
    /*TargetOpcode::G_UADDSAT*//*Label 33*/ GIMT_Encode4(57947),
    /*TargetOpcode::G_SADDSAT*//*Label 34*/ GIMT_Encode4(58061),
    /*TargetOpcode::G_USUBSAT*//*Label 35*/ GIMT_Encode4(58175),
    /*TargetOpcode::G_SSUBSAT*//*Label 36*/ GIMT_Encode4(58289), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 37*/ GIMT_Encode4(58403),
    /*TargetOpcode::G_FSUB*//*Label 38*/ GIMT_Encode4(58728),
    /*TargetOpcode::G_FMUL*//*Label 39*/ GIMT_Encode4(59053),
    /*TargetOpcode::G_FMA*//*Label 40*/ GIMT_Encode4(59442), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 41*/ GIMT_Encode4(60184), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 42*/ GIMT_Encode4(60482),
    /*TargetOpcode::G_FPEXT*//*Label 43*/ GIMT_Encode4(63192),
    /*TargetOpcode::G_FPTRUNC*//*Label 44*/ GIMT_Encode4(63369),
    /*TargetOpcode::G_FPTOSI*//*Label 45*/ GIMT_Encode4(63546),
    /*TargetOpcode::G_FPTOUI*//*Label 46*/ GIMT_Encode4(63836),
    /*TargetOpcode::G_SITOFP*//*Label 47*/ GIMT_Encode4(64126),
    /*TargetOpcode::G_UITOFP*//*Label 48*/ GIMT_Encode4(64400),
    /*TargetOpcode::G_FABS*//*Label 49*/ GIMT_Encode4(64674),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 50*/ GIMT_Encode4(64990), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 51*/ GIMT_Encode4(65397),
    /*TargetOpcode::G_FMAXNUM*//*Label 52*/ GIMT_Encode4(65485),
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 53*/ GIMT_Encode4(65573),
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 54*/ GIMT_Encode4(65724), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 55*/ GIMT_Encode4(65875),
    /*TargetOpcode::G_SMAX*//*Label 56*/ GIMT_Encode4(66070),
    /*TargetOpcode::G_UMIN*//*Label 57*/ GIMT_Encode4(66265),
    /*TargetOpcode::G_UMAX*//*Label 58*/ GIMT_Encode4(66460), GIMT_Encode4(0),
    /*TargetOpcode::G_LROUND*//*Label 59*/ GIMT_Encode4(66655),
    /*TargetOpcode::G_LLROUND*//*Label 60*/ GIMT_Encode4(66832),
    /*TargetOpcode::G_BR*//*Label 61*/ GIMT_Encode4(67009), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 62*/ GIMT_Encode4(67026), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 63*/ GIMT_Encode4(67222), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 64*/ GIMT_Encode4(67412),
    /*TargetOpcode::G_BSWAP*//*Label 65*/ GIMT_Encode4(67602),
    /*TargetOpcode::G_BITREVERSE*//*Label 66*/ GIMT_Encode4(67886),
    /*TargetOpcode::G_FCEIL*//*Label 67*/ GIMT_Encode4(103914), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 68*/ GIMT_Encode4(104218),
    /*TargetOpcode::G_FFLOOR*//*Label 69*/ GIMT_Encode4(104454),
    /*TargetOpcode::G_FRINT*//*Label 70*/ GIMT_Encode4(104758),
    /*TargetOpcode::G_FNEARBYINT*//*Label 71*/ GIMT_Encode4(104993), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 72*/ GIMT_Encode4(105255),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 73*/ GIMT_Encode4(105553),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 74*/ GIMT_Encode4(105851),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 75*/ GIMT_Encode4(106149), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 76*/ GIMT_Encode4(106447),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 77*/ GIMT_Encode4(107163),
    // Label 0: @798
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 87*/ GIMT_Encode4(1162),
    /*GILLT_s1*//*Label 79*/ GIMT_Encode4(841),
    /*GILLT_s32*//*Label 80*/ GIMT_Encode4(868),
    /*GILLT_s64*//*Label 81*/ GIMT_Encode4(940),
    /*GILLT_s128*//*Label 82*/ GIMT_Encode4(1012),
    /*GILLT_v2s64*//*Label 83*/ GIMT_Encode4(1042),
    /*GILLT_v4s32*//*Label 84*/ GIMT_Encode4(1072),
    /*GILLT_v8s16*//*Label 85*/ GIMT_Encode4(1102),
    /*GILLT_v16s8*//*Label 86*/ GIMT_Encode4(1132),
    // Label 79: @841
    GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(867), // Rule ID 3614 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (add:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3614,
      GIR_Done,
    // Label 88: @867
    GIM_Reject,
    // Label 80: @868
    GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(939),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(925), // Rule ID 104 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (ADDI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 104,
        GIR_Done,
      // Label 90: @925
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(938), // Rule ID 196 //
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (ADD4:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD4),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 196,
        GIR_Done,
      // Label 91: @938
      GIM_Reject,
    // Label 89: @939
    GIM_Reject,
    // Label 81: @940
    GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1011),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(997), // Rule ID 656 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (ADDI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADDI8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 656,
        GIR_Done,
      // Label 93: @997
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1010), // Rule ID 652 //
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (ADD8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD8),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 652,
        GIR_Done,
      // Label 94: @1010
      GIM_Reject,
    // Label 92: @1011
    GIM_Reject,
    // Label 82: @1012
    GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1041), // Rule ID 467 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUQM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 467,
      GIR_Done,
    // Label 95: @1041
    GIM_Reject,
    // Label 83: @1042
    GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1071), // Rule ID 466 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VADDUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUDM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 466,
      GIR_Done,
    // Label 96: @1071
    GIM_Reject,
    // Label 84: @1072
    GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1101), // Rule ID 300 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUWM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 300,
      GIR_Done,
    // Label 97: @1101
    GIM_Reject,
    // Label 85: @1102
    GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1131), // Rule ID 299 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUHM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 299,
      GIR_Done,
    // Label 98: @1131
    GIM_Reject,
    // Label 86: @1132
    GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1161), // Rule ID 298 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUBM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 298,
      GIR_Done,
    // Label 99: @1161
    GIM_Reject,
    // Label 87: @1162
    GIM_Reject,
    // Label 1: @1163
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 108*/ GIMT_Encode4(1701),
    /*GILLT_s1*//*Label 100*/ GIMT_Encode4(1206),
    /*GILLT_s32*//*Label 101*/ GIMT_Encode4(1233),
    /*GILLT_s64*//*Label 102*/ GIMT_Encode4(1347),
    /*GILLT_s128*//*Label 103*/ GIMT_Encode4(1461),
    /*GILLT_v2s64*//*Label 104*/ GIMT_Encode4(1491),
    /*GILLT_v4s32*//*Label 105*/ GIMT_Encode4(1566),
    /*GILLT_v8s16*//*Label 106*/ GIMT_Encode4(1641),
    /*GILLT_v16s8*//*Label 107*/ GIMT_Encode4(1671),
    // Label 100: @1206
    GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1232), // Rule ID 3615 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (sub:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3615,
      GIR_Done,
    // Label 109: @1232
    GIM_Reject,
    // Label 101: @1233
    GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1346),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1277), // Rule ID 208 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$RA)  =>  (NEG:{ *:[i32] } i32:{ *:[i32] }:$RA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NEG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 111: @1277
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1319), // Rule ID 1198 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm, i32:{ *:[i32] }:$in)  =>  (SUBFIC:{ *:[i32] }:{ *:[i32] } ?:{ *:[i32] }:$in, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SUBFIC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1198,
        GIR_Done,
      // Label 112: @1319
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1345), // Rule ID 206 //
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$RB, i32:{ *:[i32] }:$RA)  =>  (SUBF:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SUBF),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 113: @1345
      GIM_Reject,
    // Label 110: @1346
    GIM_Reject,
    // Label 102: @1347
    GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1460),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1391), // Rule ID 662 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$RA)  =>  (NEG8:{ *:[i64] } i64:{ *:[i64] }:$RA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NEG8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 662,
        GIR_Done,
      // Label 115: @1391
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1433), // Rule ID 1520 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm, i64:{ *:[i64] }:$in)  =>  (SUBFIC8:{ *:[i64] }:{ *:[i32] } ?:{ *:[i64] }:$in, (imm:{ *:[i64] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SUBFIC8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1520,
        GIR_Done,
      // Label 116: @1433
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1459), // Rule ID 661 //
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$RB, i64:{ *:[i64] }:$RA)  =>  (SUBF8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SUBF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 661,
        GIR_Done,
      // Label 117: @1459
      GIM_Reject,
    // Label 114: @1460
    GIM_Reject,
    // Label 103: @1461
    GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1490), // Rule ID 472 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUQM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 472,
      GIR_Done,
    // Label 118: @1490
    GIM_Reject,
    // Label 104: @1491
    GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1565),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1548), // Rule ID 539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VNEGD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNEGD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 539,
        GIR_Done,
      // Label 120: @1548
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1564), // Rule ID 471 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        // (sub:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VSUBUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUDM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 121: @1564
      GIM_Reject,
    // Label 119: @1565
    GIM_Reject,
    // Label 105: @1566
    GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1640),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1623), // Rule ID 538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VNEGW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNEGW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 538,
        GIR_Done,
      // Label 123: @1623
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1639), // Rule ID 370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        // (sub:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUWM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 370,
        GIR_Done,
      // Label 124: @1639
      GIM_Reject,
    // Label 122: @1640
    GIM_Reject,
    // Label 106: @1641
    GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1670), // Rule ID 369 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUHM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 369,
      GIR_Done,
    // Label 125: @1670
    GIM_Reject,
    // Label 107: @1671
    GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1700), // Rule ID 368 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUBM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 368,
      GIR_Done,
    // Label 126: @1700
    GIM_Reject,
    // Label 108: @1701
    GIM_Reject,
    // Label 2: @1702
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(7), /*)*//*default:*//*Label 133*/ GIMT_Encode4(2032),
    /*GILLT_s1*//*Label 127*/ GIMT_Encode4(1741),
    /*GILLT_s32*//*Label 128*/ GIMT_Encode4(1768),
    /*GILLT_s64*//*Label 129*/ GIMT_Encode4(1840), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 130*/ GIMT_Encode4(1912),
    /*GILLT_v4s32*//*Label 131*/ GIMT_Encode4(1942),
    /*GILLT_v8s16*//*Label 132*/ GIMT_Encode4(1972),
    // Label 127: @1741
    GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1767), // Rule ID 3616 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (mul:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRAND:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3616,
      GIR_Done,
    // Label 134: @1767
    GIM_Reject,
    // Label 128: @1768
    GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(1839),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(1825), // Rule ID 108 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (MULLI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 108,
        GIR_Done,
      // Label 136: @1825
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(1838), // Rule ID 205 //
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MULLW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 205,
        GIR_Done,
      // Label 137: @1838
      GIM_Reject,
    // Label 135: @1839
    GIM_Reject,
    // Label 129: @1840
    GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(1911),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(1897), // Rule ID 696 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (MULLI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLI8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 696,
        GIR_Done,
      // Label 139: @1897
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(1910), // Rule ID 695 //
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MULLD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 140: @1910
      GIM_Reject,
    // Label 138: @1911
    GIM_Reject,
    // Label 130: @1912
    GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(1941), // Rule ID 1111 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULLD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1111,
      GIR_Done,
    // Label 141: @1941
    GIM_Reject,
    // Label 131: @1942
    GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(1971), // Rule ID 458 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULUWM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 458,
      GIR_Done,
    // Label 142: @1971
    GIM_Reject,
    // Label 132: @1972
    GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2031), // Rule ID 1276 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, (V_SET0H:{ *:[v8i16] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::V_SET0H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1276,
      GIR_Done,
    // Label 143: @2031
    GIM_Reject,
    // Label 133: @2032
    GIM_Reject,
    // Label 3: @2033
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 149*/ GIMT_Encode4(2208),
    /*GILLT_s32*//*Label 144*/ GIMT_Encode4(2064),
    /*GILLT_s64*//*Label 145*/ GIMT_Encode4(2091),
    /*GILLT_s128*//*Label 146*/ GIMT_Encode4(2118),
    /*GILLT_v2s64*//*Label 147*/ GIMT_Encode4(2148),
    /*GILLT_v4s32*//*Label 148*/ GIMT_Encode4(2178),
    // Label 144: @2064
    GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2090), // Rule ID 199 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVW),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 199,
      GIR_Done,
    // Label 150: @2090
    GIM_Reject,
    // Label 145: @2091
    GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2117), // Rule ID 687 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 687,
      GIR_Done,
    // Label 151: @2117
    GIM_Reject,
    // Label 146: @2118
    GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2147), // Rule ID 1135 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSQ),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1135,
      GIR_Done,
    // Label 152: @2147
    GIM_Reject,
    // Label 147: @2148
    GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2177), // Rule ID 1122 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1122,
      GIR_Done,
    // Label 153: @2177
    GIM_Reject,
    // Label 148: @2178
    GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2207), // Rule ID 1120 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSW),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1120,
      GIR_Done,
    // Label 154: @2207
    GIM_Reject,
    // Label 149: @2208
    GIM_Reject,
    // Label 4: @2209
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 160*/ GIMT_Encode4(2384),
    /*GILLT_s32*//*Label 155*/ GIMT_Encode4(2240),
    /*GILLT_s64*//*Label 156*/ GIMT_Encode4(2267),
    /*GILLT_s128*//*Label 157*/ GIMT_Encode4(2294),
    /*GILLT_v2s64*//*Label 158*/ GIMT_Encode4(2324),
    /*GILLT_v4s32*//*Label 159*/ GIMT_Encode4(2354),
    // Label 155: @2240
    GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2266), // Rule ID 200 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (udiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVWU:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVWU),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 200,
      GIR_Done,
    // Label 161: @2266
    GIM_Reject,
    // Label 156: @2267
    GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2293), // Rule ID 688 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (udiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVDU:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVDU),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 688,
      GIR_Done,
    // Label 162: @2293
    GIM_Reject,
    // Label 157: @2294
    GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(2323), // Rule ID 1136 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUQ),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1136,
      GIR_Done,
    // Label 163: @2323
    GIM_Reject,
    // Label 158: @2324
    GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(2353), // Rule ID 1123 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1123,
      GIR_Done,
    // Label 164: @2353
    GIM_Reject,
    // Label 159: @2354
    GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2383), // Rule ID 1121 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUW),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1121,
      GIR_Done,
    // Label 165: @2383
    GIM_Reject,
    // Label 160: @2384
    GIM_Reject,
    // Label 5: @2385
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 171*/ GIMT_Encode4(2566),
    /*GILLT_s32*//*Label 166*/ GIMT_Encode4(2416),
    /*GILLT_s64*//*Label 167*/ GIMT_Encode4(2446),
    /*GILLT_s128*//*Label 168*/ GIMT_Encode4(2476),
    /*GILLT_v2s64*//*Label 169*/ GIMT_Encode4(2506),
    /*GILLT_v4s32*//*Label 170*/ GIMT_Encode4(2536),
    // Label 166: @2416
    GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2445), // Rule ID 194 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (srem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODSW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSW),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 194,
      GIR_Done,
    // Label 172: @2445
    GIM_Reject,
    // Label 167: @2446
    GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2475), // Rule ID 692 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (srem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODSD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 173: @2475
    GIM_Reject,
    // Label 168: @2476
    GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(2505), // Rule ID 1145 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSQ),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1145,
      GIR_Done,
    // Label 174: @2505
    GIM_Reject,
    // Label 169: @2506
    GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2535), // Rule ID 1118 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1118,
      GIR_Done,
    // Label 175: @2535
    GIM_Reject,
    // Label 170: @2536
    GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2565), // Rule ID 1116 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSW),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1116,
      GIR_Done,
    // Label 176: @2565
    GIM_Reject,
    // Label 171: @2566
    GIM_Reject,
    // Label 6: @2567
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 182*/ GIMT_Encode4(2748),
    /*GILLT_s32*//*Label 177*/ GIMT_Encode4(2598),
    /*GILLT_s64*//*Label 178*/ GIMT_Encode4(2628),
    /*GILLT_s128*//*Label 179*/ GIMT_Encode4(2658),
    /*GILLT_v2s64*//*Label 180*/ GIMT_Encode4(2688),
    /*GILLT_v4s32*//*Label 181*/ GIMT_Encode4(2718),
    // Label 177: @2598
    GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2627), // Rule ID 195 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (urem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODUW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUW),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 195,
      GIR_Done,
    // Label 183: @2627
    GIM_Reject,
    // Label 178: @2628
    GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2657), // Rule ID 693 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (urem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODUD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 184: @2657
    GIM_Reject,
    // Label 179: @2658
    GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(2687), // Rule ID 1146 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUQ),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1146,
      GIR_Done,
    // Label 185: @2687
    GIM_Reject,
    // Label 180: @2688
    GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(2717), // Rule ID 1119 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1119,
      GIR_Done,
    // Label 186: @2717
    GIM_Reject,
    // Label 181: @2718
    GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(2747), // Rule ID 1117 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUW),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1117,
      GIR_Done,
    // Label 187: @2747
    GIM_Reject,
    // Label 182: @2748
    GIM_Reject,
    // Label 7: @2749
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 192*/ GIMT_Encode4(3492),
    /*GILLT_s1*//*Label 188*/ GIMT_Encode4(2784),
    /*GILLT_s32*//*Label 189*/ GIMT_Encode4(2913),
    /*GILLT_s64*//*Label 190*/ GIMT_Encode4(3042), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 191*/ GIMT_Encode4(3171),
    // Label 188: @2784
    GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(2912),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(2850), // Rule ID 4862 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4862,
        GIR_Done,
      // Label 194: @2850
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(2898), // Rule ID 179 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 179,
        GIR_Done,
      // Label 195: @2898
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(2911), // Rule ID 172 //
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 196: @2911
      GIM_Reject,
    // Label 193: @2912
    GIM_Reject,
    // Label 189: @2913
    GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3041),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(2979), // Rule ID 4856 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4856,
        GIR_Done,
      // Label 198: @2979
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3027), // Rule ID 120 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 120,
        GIR_Done,
      // Label 199: @3027
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3040), // Rule ID 119 //
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (AND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 119,
        GIR_Done,
      // Label 200: @3040
      GIM_Reject,
    // Label 197: @3041
    GIM_Reject,
    // Label 190: @3042
    GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3170),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3108), // Rule ID 4869 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4869,
        GIR_Done,
      // Label 202: @3108
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(3156), // Rule ID 640 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 640,
        GIR_Done,
      // Label 203: @3156
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(3169), // Rule ID 639 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (AND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND8),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 639,
        GIR_Done,
      // Label 204: @3169
      GIM_Reject,
    // Label 201: @3170
    GIM_Reject,
    // Label 191: @3171
    GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(3491),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(3250), // Rule ID 4877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4877,
        GIR_Done,
      // Label 206: @3250
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(3316), // Rule ID 922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 922,
        GIR_Done,
      // Label 207: @3316
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(3337), // Rule ID 921 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLAND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 921,
        GIR_Done,
      // Label 208: @3337
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3403), // Rule ID 4865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4865,
        GIR_Done,
      // Label 209: @3403
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3469), // Rule ID 309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VANDC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 309,
        GIR_Done,
      // Label 210: @3469
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3490), // Rule ID 308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 308,
        GIR_Done,
      // Label 211: @3490
      GIM_Reject,
    // Label 205: @3491
    GIM_Reject,
    // Label 192: @3492
    GIM_Reject,
    // Label 8: @3493
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 216*/ GIMT_Encode4(4236),
    /*GILLT_s1*//*Label 212*/ GIMT_Encode4(3528),
    /*GILLT_s32*//*Label 213*/ GIMT_Encode4(3657),
    /*GILLT_s64*//*Label 214*/ GIMT_Encode4(3786), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 215*/ GIMT_Encode4(3915),
    // Label 212: @3528
    GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3656),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3594), // Rule ID 4863 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4863,
        GIR_Done,
      // Label 218: @3594
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3642), // Rule ID 180 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 219: @3642
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3655), // Rule ID 174 //
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CROR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CROR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 220: @3655
      GIM_Reject,
    // Label 217: @3656
    GIM_Reject,
    // Label 213: @3657
    GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3785),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3723), // Rule ID 4857 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4857,
        GIR_Done,
      // Label 222: @3723
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3771), // Rule ID 123 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 123,
        GIR_Done,
      // Label 223: @3771
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3784), // Rule ID 121 //
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (OR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 121,
        GIR_Done,
      // Label 224: @3784
      GIM_Reject,
    // Label 221: @3785
    GIM_Reject,
    // Label 214: @3786
    GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(3914),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(3852), // Rule ID 4870 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ORC8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4870,
        GIR_Done,
      // Label 226: @3852
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(3900), // Rule ID 643 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ORC8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 643,
        GIR_Done,
      // Label 227: @3900
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(3913), // Rule ID 641 //
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (OR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR8),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 641,
        GIR_Done,
      // Label 228: @3913
      GIM_Reject,
    // Label 225: @3914
    GIM_Reject,
    // Label 215: @3915
    GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4235),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(3994), // Rule ID 4880 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4880,
        GIR_Done,
      // Label 230: @3994
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4060), // Rule ID 935 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 935,
        GIR_Done,
      // Label 231: @4060
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4081), // Rule ID 924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLOR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 924,
        GIR_Done,
      // Label 232: @4081
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4147), // Rule ID 4868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4868,
        GIR_Done,
      // Label 233: @4147
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4213), // Rule ID 486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VORC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 486,
        GIR_Done,
      // Label 234: @4213
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(4234), // Rule ID 383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VOR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 383,
        GIR_Done,
      // Label 235: @4234
      GIM_Reject,
    // Label 229: @4235
    GIM_Reject,
    // Label 216: @4236
    GIM_Reject,
    // Label 9: @4237
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 240*/ GIMT_Encode4(6016),
    /*GILLT_s1*//*Label 236*/ GIMT_Encode4(4272),
    /*GILLT_s32*//*Label 237*/ GIMT_Encode4(4597),
    /*GILLT_s64*//*Label 238*/ GIMT_Encode4(4900), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 239*/ GIMT_Encode4(5203),
    // Label 236: @4272
    GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(4596),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(4338), // Rule ID 173 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRNAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 242: @4338
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(4386), // Rule ID 176 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRNOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 176,
        GIR_Done,
      // Label 243: @4386
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(4434), // Rule ID 4860 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRB)  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CREQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4860,
        GIR_Done,
      // Label 244: @4434
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(4482), // Rule ID 177 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CREQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 177,
        GIR_Done,
      // Label 245: @4482
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(4530), // Rule ID 4861 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }))  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CREQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4861,
        GIR_Done,
      // Label 246: @4530
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(4556), // Rule ID 178 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] })  =>  (CRNOT:{ *:[i1] } i1:{ *:[i1] }:$CRA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRNOT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 178,
        GIR_Done,
      // Label 247: @4556
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(4582), // Rule ID 2885 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$in, -1:{ *:[i1] })  =>  (CRNOT:{ *:[i1] } ?:{ *:[i1] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRNOT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2885,
        GIR_Done,
      // Label 248: @4582
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(4595), // Rule ID 175 //
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRXOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 249: @4595
      GIM_Reject,
    // Label 241: @4596
    GIM_Reject,
    // Label 237: @4597
    GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(4899),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(4663), // Rule ID 118 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (NAND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 118,
        GIR_Done,
      // Label 251: @4663
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(4711), // Rule ID 122 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 122,
        GIR_Done,
      // Label 252: @4711
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(4759), // Rule ID 4858 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, -1:{ *:[i32] }), i32:{ *:[i32] }:$RB)  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::EQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4858,
        GIR_Done,
      // Label 253: @4759
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(4807), // Rule ID 124 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::EQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 124,
        GIR_Done,
      // Label 254: @4807
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(4855), // Rule ID 4859 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, -1:{ *:[i32] }))  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::EQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4859,
        GIR_Done,
      // Label 255: @4855
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(4885), // Rule ID 1194 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } ?:{ *:[i32] }:$in, ?:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1194,
        GIR_Done,
      // Label 256: @4885
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(4898), // Rule ID 125 //
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (XOR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XOR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 125,
        GIR_Done,
      // Label 257: @4898
      GIM_Reject,
    // Label 250: @4899
    GIM_Reject,
    // Label 238: @4900
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(5202),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(4966), // Rule ID 638 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (NAND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NAND8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 638,
        GIR_Done,
      // Label 259: @4966
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(5014), // Rule ID 642 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (NOR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NOR8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 642,
        GIR_Done,
      // Label 260: @5014
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(5062), // Rule ID 4871 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, -1:{ *:[i64] }), i64:{ *:[i64] }:$RB)  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::EQV8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4871,
        GIR_Done,
      // Label 261: @5062
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(5110), // Rule ID 644 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::EQV8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 644,
        GIR_Done,
      // Label 262: @5110
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(5158), // Rule ID 4872 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, -1:{ *:[i64] }))  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::EQV8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4872,
        GIR_Done,
      // Label 263: @5158
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(5188), // Rule ID 1506 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$in, -1:{ *:[i64] })  =>  (NOR8:{ *:[i64] } ?:{ *:[i64] }:$in, ?:{ *:[i64] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::NOR8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1506,
        GIR_Done,
      // Label 264: @5188
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5201), // Rule ID 645 //
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (XOR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XOR8),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 645,
        GIR_Done,
      // Label 265: @5201
      GIM_Reject,
    // Label 258: @5202
    GIM_Reject,
    // Label 239: @5203
    GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(6015),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(5282), // Rule ID 933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLNAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 933,
        GIR_Done,
      // Label 267: @5282
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(5348), // Rule ID 923 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLNOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 923,
        GIR_Done,
      // Label 268: @5348
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(5414), // Rule ID 4878 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XB)  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4878,
        GIR_Done,
      // Label 269: @5414
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5480), // Rule ID 932 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 932,
        GIR_Done,
      // Label 270: @5480
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(5546), // Rule ID 4879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }))  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4879,
        GIR_Done,
      // Label 271: @5546
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(5594), // Rule ID 1567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, immAllOnesV:{ *:[v4i32] })  =>  (XXLNOR:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLNOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1567,
        GIR_Done,
      // Label 272: @5594
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(5615), // Rule ID 925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLXOR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 925,
        GIR_Done,
      // Label 273: @5615
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(5681), // Rule ID 485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 485,
        GIR_Done,
      // Label 274: @5681
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(5747), // Rule ID 382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 382,
        GIR_Done,
      // Label 275: @5747
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(5813), // Rule ID 4866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VB)  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4866,
        GIR_Done,
      // Label 276: @5813
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(5879), // Rule ID 484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 484,
        GIR_Done,
      // Label 277: @5879
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(5945), // Rule ID 4867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, immAllOnesV:{ *:[v4i32] }))  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4867,
        GIR_Done,
      // Label 278: @5945
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(5993), // Rule ID 1363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] })  =>  (VNOR:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1363,
        GIR_Done,
      // Label 279: @5993
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(6014), // Rule ID 384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VXOR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 384,
        GIR_Done,
      // Label 280: @6014
      GIM_Reject,
    // Label 266: @6015
    GIM_Reject,
    // Label 240: @6016
    GIM_Reject,
    // Label 10: @6017
    GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(6344),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(6170), // Rule ID 2109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$A, i64:{ *:[i64] }:$B)  =>  (XXPERMDI:{ *:[v2i64] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$A), sub_64:{ *:[i32] }), (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$B), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/3, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/3, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXPERMDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2109,
        GIR_Done,
      // Label 282: @6170
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(6298), // Rule ID 2112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$A, i64:{ *:[i64] }:$B)  =>  (XXPERMDI:{ *:[v2i64] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$B), sub_64:{ *:[i32] }), (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$A), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/3, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/3, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXPERMDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2112,
        GIR_Done,
      // Label 283: @6298
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(6314), // Rule ID 2855 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$rB, i64:{ *:[i64] }:$rA)  =>  (MTVSRDD:{ *:[v2i64] } ?:{ *:[i64] }:$rB, ?:{ *:[i64] }:$rA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRDD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2855,
        GIR_Done,
      // Label 284: @6314
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(6343), // Rule ID 2859 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MTVSRDD:{ *:[v2i64] } ?:{ *:[i64] }:$rB, ?:{ *:[i64] }:$rA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRDD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2859,
        GIR_Done,
      // Label 285: @6343
      GIM_Reject,
    // Label 281: @6344
    GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(6931),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(6418), // Rule ID 2023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt5NonZero),
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A)  =>  (VSPLTISW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSPLTISW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2023,
        GIR_Done,
      // Label 287: @6418
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(6476), // Rule ID 3356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_PrefixInstrs),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i32immNonAllOneNonZero),
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A)  =>  (XXSPLTIW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXSPLTIW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3356,
        GIR_Done,
      // Label 288: @6476
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(6628), // Rule ID 1715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        // MIs[2] A
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        // MIs[3] A
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/4, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        // MIs[4] A
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (build_vector:{ *:[v4f32] } (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A))  =>  (XXSPLTW:{ *:[v4f32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (XSCVDPSP:{ *:[f64] } f64:{ *:[f64] }:$A), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSP),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1715,
        GIR_Done,
      // Label 289: @6628
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(6693), // Rule ID 1716 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4f32] } f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A)  =>  (XXSPLTW:{ *:[v4f32] } (XSCVDPSPN:{ *:[v4f32] } ?:{ *:[f32] }:$A), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSPN),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1716,
        GIR_Done,
      // Label 290: @6693
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(6789), // Rule ID 2111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (XXSPLTW:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRWZ:{ *:[f64] } ?:{ *:[i32] }:$A), sub_64:{ *:[i32] }), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRWZ),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2111,
        GIR_Done,
      // Label 291: @6789
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(6885), // Rule ID 2114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (XXSPLTW:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRWZ:{ *:[f64] } ?:{ *:[i32] }:$A), sub_64:{ *:[i32] }), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRWZ),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2114,
        GIR_Done,
      // Label 292: @6885
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(6930), // Rule ID 2245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (MTVSRWS:{ *:[v4i32] } ?:{ *:[i32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2245,
        GIR_Done,
      // Label 293: @6930
      GIM_Reject,
    // Label 286: @6931
    GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(7080), // Rule ID 2246 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immNonAllOneAnyExt8),
      // MIs[1] Operand 1
      // No operand predicates
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXSPLTIB:{ *:[v4i32] } (imm:{ *:[i32] }):$A), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXSPLTIB),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // A
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2246,
      GIR_Done,
    // Label 294: @7080
    GIM_Reject,
    // Label 11: @7081
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(8), /*)*//*default:*//*Label 302*/ GIMT_Encode4(9847),
    /*GILLT_s32*//*Label 295*/ GIMT_Encode4(7120),
    /*GILLT_s64*//*Label 296*/ GIMT_Encode4(7201),
    /*GILLT_s128*//*Label 297*/ GIMT_Encode4(7254),
    /*GILLT_v2s64*//*Label 298*/ GIMT_Encode4(7767),
    /*GILLT_v4s32*//*Label 299*/ GIMT_Encode4(8420),
    /*GILLT_v8s16*//*Label 300*/ GIMT_Encode4(9109),
    /*GILLT_v16s8*//*Label 301*/ GIMT_Encode4(9510),
    // Label 295: @7120
    GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(7200), // Rule ID 2009 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (bitconvert:{ *:[i32] } f32:{ *:[f32] }:$A)  =>  (MFVSRWZ:{ *:[i32] } (EXTRACT_SUBREG:{ *:[f64] } (XSCVDPSPN:{ *:[v4i32] } ?:{ *:[f32] }:$A), sub_64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSPN),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_64),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSSRCRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(PPC::VSRCRegClassID),
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFVSRWZ),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2009,
      GIR_Done,
    // Label 303: @7200
    GIM_Reject,
    // Label 296: @7201
    GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(7253),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(7231), // Rule ID 2011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (bitconvert:{ *:[i64] } f64:{ *:[f64] }:$A)  =>  (MFVSRD:{ *:[i64] } ?:{ *:[f64] }:$A)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2011,
        GIR_Done,
      // Label 305: @7231
      GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(7252), // Rule ID 2012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (bitconvert:{ *:[f64] } i64:{ *:[i64] }:$S)  =>  (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$S)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2012,
        GIR_Done,
      // Label 306: @7252
      GIM_Reject,
    // Label 304: @7253
    GIM_Reject,
    // Label 297: @7254
    GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(7318), // Rule ID 1915 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v1i128] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v1i128] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1915,
      GIR_Done,
    // Label 307: @7318
    GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(7346), // Rule ID 1602 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v1i128] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1602,
      GIR_Done,
    // Label 308: @7346
    GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(7388), // Rule ID 1317 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1317,
      GIR_Done,
    // Label 309: @7388
    GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(7430), // Rule ID 1318 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1318,
      GIR_Done,
    // Label 310: @7430
    GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(7472), // Rule ID 1319 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1319,
      GIR_Done,
    // Label 311: @7472
    GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(7514), // Rule ID 1320 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1320,
      GIR_Done,
    // Label 312: @7514
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(7556), // Rule ID 1321 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1321,
      GIR_Done,
    // Label 313: @7556
    GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(7598), // Rule ID 1322 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1322,
      GIR_Done,
    // Label 314: @7598
    GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(7640), // Rule ID 1323 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1323,
      GIR_Done,
    // Label 315: @7640
    GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(7682), // Rule ID 1324 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1324,
      GIR_Done,
    // Label 316: @7682
    GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(7724), // Rule ID 1325 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1325,
      GIR_Done,
    // Label 317: @7724
    GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(7766), // Rule ID 1326 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v2f64] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1326,
      GIR_Done,
    // Label 318: @7766
    GIM_Reject,
    // Label 298: @7767
    GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(7831), // Rule ID 1916 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v2i64] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1916,
      GIR_Done,
    // Label 319: @7831
    GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(7859), // Rule ID 1583 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v4f32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1583,
      GIR_Done,
    // Label 320: @7859
    GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(7887), // Rule ID 1584 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v4i32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1584,
      GIR_Done,
    // Label 321: @7887
    GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(7915), // Rule ID 1585 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1585,
      GIR_Done,
    // Label 322: @7915
    GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(7943), // Rule ID 1586 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1586,
      GIR_Done,
    // Label 323: @7943
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(7971), // Rule ID 1591 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v4f32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1591,
      GIR_Done,
    // Label 324: @7971
    GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(7999), // Rule ID 1592 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v4i32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1592,
      GIR_Done,
    // Label 325: @7999
    GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(8027), // Rule ID 1593 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1593,
      GIR_Done,
    // Label 326: @8027
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(8055), // Rule ID 1594 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1594,
      GIR_Done,
    // Label 327: @8055
    GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(8083), // Rule ID 1599 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1599,
      GIR_Done,
    // Label 328: @8083
    GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(8111), // Rule ID 1600 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1600,
      GIR_Done,
    // Label 329: @8111
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(8139), // Rule ID 1601 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v1i128:{ *:[v1i128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v1i128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1601,
      GIR_Done,
    // Label 330: @8139
    GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(8167), // Rule ID 1603 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1603,
      GIR_Done,
    // Label 331: @8167
    GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(8209), // Rule ID 1312 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1312,
      GIR_Done,
    // Label 332: @8209
    GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(8251), // Rule ID 1313 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1313,
      GIR_Done,
    // Label 333: @8251
    GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(8293), // Rule ID 1314 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1314,
      GIR_Done,
    // Label 334: @8293
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(8335), // Rule ID 1315 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1315,
      GIR_Done,
    // Label 335: @8335
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(8377), // Rule ID 1316 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1316,
      GIR_Done,
    // Label 336: @8377
    GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(8419), // Rule ID 1331 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2f64] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1331,
      GIR_Done,
    // Label 337: @8419
    GIM_Reject,
    // Label 299: @8420
    GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(8464), // Rule ID 934 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v4i32] } immAllOnesV:{ *:[v16i8] })  =>  (XXLEQVOnes:{ *:[v4i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 934,
      GIR_Done,
    // Label 338: @8464
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(8492), // Rule ID 1587 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1587,
      GIR_Done,
    // Label 339: @8492
    GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(8520), // Rule ID 1588 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1588,
      GIR_Done,
    // Label 340: @8520
    GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(8548), // Rule ID 1595 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1595,
      GIR_Done,
    // Label 341: @8548
    GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(8576), // Rule ID 1596 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1596,
      GIR_Done,
    // Label 342: @8576
    GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(8604), // Rule ID 1604 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1604,
      GIR_Done,
    // Label 343: @8604
    GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(8646), // Rule ID 1302 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1302,
      GIR_Done,
    // Label 344: @8646
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(8688), // Rule ID 1303 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1303,
      GIR_Done,
    // Label 345: @8688
    GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(8730), // Rule ID 1304 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1304,
      GIR_Done,
    // Label 346: @8730
    GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(8772), // Rule ID 1305 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1305,
      GIR_Done,
    // Label 347: @8772
    GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(8814), // Rule ID 1306 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1306,
      GIR_Done,
    // Label 348: @8814
    GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(8856), // Rule ID 1307 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1307,
      GIR_Done,
    // Label 349: @8856
    GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(8898), // Rule ID 1308 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1308,
      GIR_Done,
    // Label 350: @8898
    GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(8940), // Rule ID 1309 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1309,
      GIR_Done,
    // Label 351: @8940
    GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(8982), // Rule ID 1310 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1310,
      GIR_Done,
    // Label 352: @8982
    GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(9024), // Rule ID 1311 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1311,
      GIR_Done,
    // Label 353: @9024
    GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(9066), // Rule ID 1329 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1329,
      GIR_Done,
    // Label 354: @9066
    GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(9108), // Rule ID 1330 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1330,
      GIR_Done,
    // Label 355: @9108
    GIM_Reject,
    // Label 300: @9109
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(9173), // Rule ID 1917 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v8i16] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1917,
      GIR_Done,
    // Label 356: @9173
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(9201), // Rule ID 1589 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1589,
      GIR_Done,
    // Label 357: @9201
    GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(9229), // Rule ID 1597 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1597,
      GIR_Done,
    // Label 358: @9229
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(9257), // Rule ID 1605 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1605,
      GIR_Done,
    // Label 359: @9257
    GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(9299), // Rule ID 1297 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1297,
      GIR_Done,
    // Label 360: @9299
    GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(9341), // Rule ID 1298 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1298,
      GIR_Done,
    // Label 361: @9341
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(9383), // Rule ID 1299 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1299,
      GIR_Done,
    // Label 362: @9383
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(9425), // Rule ID 1300 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1300,
      GIR_Done,
    // Label 363: @9425
    GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(9467), // Rule ID 1301 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1301,
      GIR_Done,
    // Label 364: @9467
    GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(9509), // Rule ID 1328 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1328,
      GIR_Done,
    // Label 365: @9509
    GIM_Reject,
    // Label 301: @9510
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(9538), // Rule ID 1590 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1590,
      GIR_Done,
    // Label 366: @9538
    GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(9566), // Rule ID 1598 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1598,
      GIR_Done,
    // Label 367: @9566
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(9594), // Rule ID 1606 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1606,
      GIR_Done,
    // Label 368: @9594
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(9636), // Rule ID 1292 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1292,
      GIR_Done,
    // Label 369: @9636
    GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(9678), // Rule ID 1293 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1293,
      GIR_Done,
    // Label 370: @9678
    GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(9720), // Rule ID 1294 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1294,
      GIR_Done,
    // Label 371: @9720
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(9762), // Rule ID 1295 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1295,
      GIR_Done,
    // Label 372: @9762
    GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(9804), // Rule ID 1296 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1296,
      GIR_Done,
    // Label 373: @9804
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(9846), // Rule ID 1327 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1327,
      GIR_Done,
    // Label 374: @9846
    GIM_Reject,
    // Label 302: @9847
    GIM_Reject,
    // Label 12: @9848
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 380*/ GIMT_Encode4(10151),
    /*GILLT_s32*//*Label 375*/ GIMT_Encode4(9879),
    /*GILLT_s64*//*Label 376*/ GIMT_Encode4(9978),
    /*GILLT_s128*//*Label 377*/ GIMT_Encode4(10031),
    /*GILLT_v2s64*//*Label 378*/ GIMT_Encode4(10072),
    /*GILLT_v4s32*//*Label 379*/ GIMT_Encode4(10098),
    // Label 375: @9879
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(9977),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(9955), // Rule ID 1693 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (ftrunc:{ *:[f32] } f32:{ *:[f32] }:$S)  =>  (COPY_TO_REGCLASS:{ *:[f32] } (XSRDPIZ:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, VSFRC:{ *:[i32] })), VSSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSRDPIZ),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSSRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1693,
        GIR_Done,
      // Label 382: @9955
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(9976), // Rule ID 147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (ftrunc:{ *:[f32] } f32:{ *:[f32] }:$RB)  =>  (FRIZS:{ *:[f32] } f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRIZS),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 383: @9976
      GIM_Reject,
    // Label 381: @9977
    GIM_Reject,
    // Label 376: @9978
    GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(10030),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(10008), // Rule ID 904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPIZ:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRDPIZ),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 904,
        GIR_Done,
      // Label 385: @10008
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(10029), // Rule ID 145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$RB)  =>  (FRIZD:{ *:[f64] } f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRIZD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 386: @10029
      GIM_Reject,
    // Label 384: @10030
    GIM_Reject,
    // Label 377: @10031
    GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(10071), // Rule ID 2142 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (ftrunc:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSRQPI:{ *:[f128] } 1:{ *:[i32] }, ?:{ *:[f128] }:$vB, 1:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRQPI),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VRT]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vB
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2142,
      GIR_Done,
    // Label 387: @10071
    GIM_Reject,
    // Label 378: @10072
    GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(10097), // Rule ID 912 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (ftrunc:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPIZ:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRDPIZ),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 912,
      GIR_Done,
    // Label 388: @10097
    GIM_Reject,
    // Label 379: @10098
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(10150),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(10128), // Rule ID 920 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (ftrunc:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRSPIZ),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 920,
        GIR_Done,
      // Label 390: @10128
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(10149), // Rule ID 1402 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (ftrunc:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA)  =>  (VRFIZ:{ *:[v4f32] } ?:{ *:[v4f32] }:$vA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRFIZ),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1402,
        GIR_Done,
      // Label 391: @10149
      GIM_Reject,
    // Label 389: @10150
    GIM_Reject,
    // Label 380: @10151
    GIM_Reject,
    // Label 13: @10152
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 397*/ GIMT_Encode4(10428),
    /*GILLT_s32*//*Label 392*/ GIMT_Encode4(10183),
    /*GILLT_s64*//*Label 393*/ GIMT_Encode4(10282),
    /*GILLT_s128*//*Label 394*/ GIMT_Encode4(10335),
    /*GILLT_v2s64*//*Label 395*/ GIMT_Encode4(10376),
    /*GILLT_v4s32*//*Label 396*/ GIMT_Encode4(10402),
    // Label 392: @10183
    GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(10281),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(10259), // Rule ID 1687 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (fround:{ *:[f32] } f32:{ *:[f32] }:$S)  =>  (COPY_TO_REGCLASS:{ *:[f32] } (XSRDPI:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, VSFRC:{ *:[i32] })), VSSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSRDPI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSSRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1687,
        GIR_Done,
      // Label 399: @10259
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(10280), // Rule ID 139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (fround:{ *:[f32] } f32:{ *:[f32] }:$RB)  =>  (FRINS:{ *:[f32] } f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRINS),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 139,
        GIR_Done,
      // Label 400: @10280
      GIM_Reject,
    // Label 398: @10281
    GIM_Reject,
    // Label 393: @10282
    GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(10334),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(10312), // Rule ID 898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPI:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRDPI),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 898,
        GIR_Done,
      // Label 402: @10312
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(10333), // Rule ID 137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$RB)  =>  (FRIND:{ *:[f64] } f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRIND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 403: @10333
      GIM_Reject,
    // Label 401: @10334
    GIM_Reject,
    // Label 394: @10335
    GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(10375), // Rule ID 2140 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (fround:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSRQPI:{ *:[f128] } 0:{ *:[i32] }, ?:{ *:[f128] }:$vB, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRQPI),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VRT]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vB
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2140,
      GIR_Done,
    // Label 404: @10375
    GIM_Reject,
    // Label 395: @10376
    GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(10401), // Rule ID 906 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (fround:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPI:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRDPI),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 906,
      GIR_Done,
    // Label 405: @10401
    GIM_Reject,
    // Label 396: @10402
    GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(10427), // Rule ID 914 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (fround:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPI:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRSPI),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 914,
      GIR_Done,
    // Label 406: @10427
    GIM_Reject,
    // Label 397: @10428
    GIM_Reject,
    // Label 14: @10429
    GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(10571),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_SwitchType, /*MI*/0, /*Op*/1, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 410*/ GIMT_Encode4(10570),
      /*GILLT_s32*//*Label 408*/ GIMT_Encode4(10457),
      /*GILLT_s64*//*Label 409*/ GIMT_Encode4(10522),
      // Label 408: @10457
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(10521), // Rule ID 2014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (lrint:{ *:[i64] } f32:{ *:[f32] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, F8RC:{ *:[i32] })))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2014,
        GIR_Done,
      // Label 411: @10521
      GIM_Reject,
      // Label 409: @10522
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(10569), // Rule ID 2013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (lrint:{ *:[i64] } f64:{ *:[f64] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } ?:{ *:[f64] }:$S))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2013,
        GIR_Done,
      // Label 412: @10569
      GIM_Reject,
      // Label 410: @10570
      GIM_Reject,
    // Label 407: @10571
    GIM_Reject,
    // Label 15: @10572
    GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(10594), // Rule ID 632 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (readcyclecounter:{ *:[i64] })  =>  (MFTB8:{ *:[i64] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFTB8),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 632,
      GIR_Done,
    // Label 413: @10594
    GIM_Reject,
    // Label 16: @10595
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 416*/ GIMT_Encode4(10678),
    /*GILLT_s32*//*Label 414*/ GIMT_Encode4(10614),
    /*GILLT_s64*//*Label 415*/ GIMT_Encode4(10646),
    // Label 414: @10614
    GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(10645), // Rule ID 1252 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
      GIM_CheckConstantInt8, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SYNC),
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1252,
      GIR_Done,
    // Label 417: @10645
    GIM_Reject,
    // Label 415: @10646
    GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(10677), // Rule ID 1251 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
      GIM_CheckConstantInt8, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SYNC),
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1251,
      GIR_Done,
    // Label 418: @10677
    GIM_Reject,
    // Label 416: @10678
    GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(10735),
      GIM_CheckIsImm, /*MI*/0, /*Op*/0,
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(10713), // Rule ID 1253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SYNC),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1253,
        GIR_Done,
      // Label 420: @10713
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(10734), // Rule ID 1254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasOnlyMSYNC),
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MSYNC),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1254,
        GIR_Done,
      // Label 421: @10734
      GIM_Reject,
    // Label 419: @10735
    GIM_Reject,
    // Label 17: @10736
    GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(10889),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(10779), // Rule ID 1154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxsetaccz),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9678:{ *:[iPTR] })  =>  (XXSETACCZ:{ *:[v512i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXSETACCZ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1154,
        GIR_Done,
      // Label 423: @10779
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(10814), // Rule ID 1155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxsetaccz),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9678:{ *:[iPTR] })  =>  (XXSETACCZW:{ *:[v512i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXSETACCZW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1155,
        GIR_Done,
      // Label 424: @10814
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(10846), // Rule ID 4845 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mfmsr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9610:{ *:[iPTR] })  =>  (MFMSR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFMSR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4845,
        GIR_Done,
      // Label 425: @10846
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(10888), // Rule ID 4846 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mftbu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9612:{ *:[iPTR] })  =>  (MFTB:{ *:[i32] } 269:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(269),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4846,
        GIR_Done,
      // Label 426: @10888
      GIM_Reject,
    // Label 422: @10889
    GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(15505),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(10945), // Rule ID 1735 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9585:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XB)  =>  (XSRSQRTEDP:{ *:[f64] } ?:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRSQRTEDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1735,
        GIR_Done,
      // Label 428: @10945
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(10993), // Rule ID 1926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrtes),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9586:{ *:[iPTR] }, vssrc:{ *:[f32] }:$XB)  =>  (XSRSQRTESP:{ *:[f32] } ?:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRSQRTESP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1926,
        GIR_Done,
      // Label 429: @10993
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(11036), // Rule ID 865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvdpsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9768:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSP:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVDPSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 865,
        GIR_Done,
      // Label 430: @11036
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(11079), // Rule ID 868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvdpsxws),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9769:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVDPSXWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 868,
        GIR_Done,
      // Label 431: @11079
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(11122), // Rule ID 871 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvdpuxws),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9770:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPUXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVDPUXWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 871,
        GIR_Done,
      // Label 432: @11122
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(11165), // Rule ID 872 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9773:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPDP:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVSPDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 872,
        GIR_Done,
      // Label 433: @11165
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(11208), // Rule ID 873 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspsxds),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9775:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPSXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVSPSXDS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 873,
        GIR_Done,
      // Label 434: @11208
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(11251), // Rule ID 876 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspuxds),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9776:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPUXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVSPUXDS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 876,
        GIR_Done,
      // Label 435: @11251
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(11294), // Rule ID 881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvsxdsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9777:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVSXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVSXDSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 881,
        GIR_Done,
      // Label 436: @11294
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(11337), // Rule ID 886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvuxdsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9779:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVUXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVUXDSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 886,
        GIR_Done,
      // Label 437: @11337
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(11380), // Rule ID 889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvsxwdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9778:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVSXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVSXWDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 889,
        GIR_Done,
      // Label 438: @11380
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(11423), // Rule ID 890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvuxwdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9780:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVUXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVUXWDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 890,
        GIR_Done,
      // Label 439: @11423
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(11466), // Rule ID 998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_sqrtf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9704:{ *:[iPTR] }, f128:{ *:[f128] }:$RB)  =>  (XSSQRTQPO:{ *:[f128] } f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSSQRTQPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 440: @11466
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(11509), // Rule ID 1005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_truncf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9731:{ *:[iPTR] }, f128:{ *:[f128] }:$RB)  =>  (XSCVQPDPO:{ *:[f64] } f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSCVQPDPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1005,
        GIR_Done,
      // Label 441: @11509
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(11552), // Rule ID 1014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvsphp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9774:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPHP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVSPHP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1014,
        GIR_Done,
      // Label 442: @11552
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(11595), // Rule ID 1018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxexpdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9802:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXEXPDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVXEXPDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1018,
        GIR_Done,
      // Label 443: @11595
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(11638), // Rule ID 1019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxexpsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9803:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXEXPSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVXEXPSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1019,
        GIR_Done,
      // Label 444: @11638
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(11681), // Rule ID 1020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxsigdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9804:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXSIGDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVXSIGDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1020,
        GIR_Done,
      // Label 445: @11681
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(11724), // Rule ID 1021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxsigsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9805:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXSIGSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVXSIGSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1021,
        GIR_Done,
      // Label 446: @11724
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(11787), // Rule ID 1643 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtsqrtdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9798:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTSQRTDP:{ *:[i32] } ?:{ *:[v2f64] }:$A), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTSQRTDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1643,
        GIR_Done,
      // Label 447: @11787
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(11850), // Rule ID 1644 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtsqrtsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9799:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTSQRTSP:{ *:[i32] } ?:{ *:[v4f32] }:$A), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTSQRTSP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1644,
        GIR_Done,
      // Label 448: @11850
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(11893), // Rule ID 1645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvresp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9791:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (XVRESP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRESP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1645,
        GIR_Done,
      // Label 449: @11893
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(11936), // Rule ID 1646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvredp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9790:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (XVREDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVREDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1646,
        GIR_Done,
      // Label 450: @11936
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(11979), // Rule ID 1647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvrsqrtesp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9794:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (XVRSQRTESP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRSQRTESP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1647,
        GIR_Done,
      // Label 451: @11979
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(12022), // Rule ID 1648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvrsqrtedp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9793:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (XVRSQRTEDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRSQRTEDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1648,
        GIR_Done,
      // Label 452: @12022
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(12065), // Rule ID 1734 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fre),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9583:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSREDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSREDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1734,
        GIR_Done,
      // Label 453: @12065
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(12108), // Rule ID 1736 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9578:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSNABSDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSNABSDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1736,
        GIR_Done,
      // Label 454: @12108
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(12151), // Rule ID 1737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabss),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9579:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (XSNABSDPs:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSNABSDPs),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1737,
        GIR_Done,
      // Label 455: @12151
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(12194), // Rule ID 1921 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fres),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9584:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (XSRESP:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRESP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1921,
        GIR_Done,
      // Label 456: @12194
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(12283), // Rule ID 1922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_extract_exp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9564:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (EXTRACT_SUBREG:{ *:[i32] } (XSXEXPDP:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f64] }:$A, VSFRC:{ *:[i32] })), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSXEXPDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(PPC::G8RCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1922,
        GIR_Done,
      // Label 457: @12283
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(12343), // Rule ID 1923 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_extract_sig),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9565:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSXSIGDP:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f64] }:$A, VSFRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSXSIGDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1923,
        GIR_Done,
      // Label 458: @12343
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(12403), // Rule ID 2136 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvhpsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9771:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$A)  =>  (XVCVHPSP:{ *:[v4f32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCVHPSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2136,
        GIR_Done,
      // Label 459: @12403
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(12492), // Rule ID 2150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_scalar_extract_expq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9695:{ *:[iPTR] }, f128:{ *:[f128] }:$vA)  =>  (MFVSRD:{ *:[i64] } (EXTRACT_SUBREG:{ *:[f64] } (XSXEXPQP:{ *:[v2i64] } ?:{ *:[f128] }:$vA), sub_64:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::XSXEXPQP),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_64),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VFRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2150,
        GIR_Done,
      // Label 460: @12492
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(12544), // Rule ID 1084 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrbm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9233:{ *:[iPTR] }, (imm:{ *:[i64] }):$D)  =>  (MTVSRBMI:{ *:[v16i8] } (imm:{ *:[i64] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRBMI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1084,
        GIR_Done,
      // Label 461: @12544
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(12589), // Rule ID 4803 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9585:{ *:[iPTR] }, f8rc:{ *:[f64] }:$frB)  =>  (FRSQRTE:{ *:[f64] } ?:{ *:[f64] }:$frB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRSQRTE),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // frB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4803,
        GIR_Done,
      // Label 462: @12589
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(12634), // Rule ID 4804 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrtes),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9586:{ *:[iPTR] }, f4rc:{ *:[f32] }:$frB)  =>  (FRSQRTES:{ *:[f32] } ?:{ *:[f32] }:$frB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRSQRTES),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // frB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4804,
        GIR_Done,
      // Label 463: @12634
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(12674), // Rule ID 73 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_popcntb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9693:{ *:[iPTR] }, i32:{ *:[i32] }:$RST)  =>  (POPCNTB:{ *:[i32] } i32:{ *:[i32] }:$RST)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::POPCNTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 464: @12674
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(12717), // Rule ID 318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexptefp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9340:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VEXPTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXPTEFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 318,
        GIR_Done,
      // Label 465: @12717
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(12760), // Rule ID 319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vlogefp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9378:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VLOGEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VLOGEFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 319,
        GIR_Done,
      // Label 466: @12760
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(12803), // Rule ID 360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrefp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9446:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VREFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VREFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 360,
        GIR_Done,
      // Label 467: @12803
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(12846), // Rule ID 361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfim),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9447:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIM:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRFIM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 361,
        GIR_Done,
      // Label 468: @12846
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(12889), // Rule ID 362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfin),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9448:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIN:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRFIN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 362,
        GIR_Done,
      // Label 469: @12889
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(12932), // Rule ID 363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfip),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9449:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRFIP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 363,
        GIR_Done,
      // Label 470: @12932
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(12975), // Rule ID 364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfiz),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9450:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRFIZ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 364,
        GIR_Done,
      // Label 471: @12975
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(13018), // Rule ID 365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrsqrtefp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9461:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRSQRTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRSQRTEFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 365,
        GIR_Done,
      // Label 472: @13018
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(13061), // Rule ID 416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhpx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9503:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKHPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKHPX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 473: @13061
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(13104), // Rule ID 417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhsb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9504:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VUPKHSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKHSB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 474: @13104
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(13147), // Rule ID 418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhsh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9505:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKHSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKHSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 475: @13147
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(13190), // Rule ID 419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklpx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9507:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKLPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKLPX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 476: @13190
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(13233), // Rule ID 420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklsb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9508:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VUPKLSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKLSB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 477: @13233
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(13276), // Rule ID 421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklsh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9509:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKLSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKLSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 421,
        GIR_Done,
      // Label 478: @13276
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(13319), // Rule ID 501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhsw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9506:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VUPKHSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKHSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 479: @13319
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(13362), // Rule ID 502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklsw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9510:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VUPKLSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VUPKLSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 502,
        GIR_Done,
      // Label 480: @13362
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(13405), // Rule ID 503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vgbbd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9360:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VGBBD:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VGBBD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 503,
        GIR_Done,
      // Label 481: @13405
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(13448), // Rule ID 511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vsbox),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9215:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA)  =>  (VSBOX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSBOX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 511,
        GIR_Done,
      // Label 482: @13448
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(13491), // Rule ID 527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclzlsbb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9270:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VCLZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCLZLSBB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 527,
        GIR_Done,
      // Label 483: @13491
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(13534), // Rule ID 528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctzlsbb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9328:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VCTZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCTZLSBB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 528,
        GIR_Done,
      // Label 484: @13534
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(13577), // Rule ID 533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsb2w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9355:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTSB2W:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTSB2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 533,
        GIR_Done,
      // Label 485: @13577
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(13620), // Rule ID 534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsh2w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9358:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTSH2W:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTSH2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 534,
        GIR_Done,
      // Label 486: @13620
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(13663), // Rule ID 535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsb2d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9354:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTSB2D:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTSB2D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 535,
        GIR_Done,
      // Label 487: @13663
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(13706), // Rule ID 536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsh2d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9357:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTSH2D:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTSH2D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 536,
        GIR_Done,
      // Label 488: @13706
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(13749), // Rule ID 537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsw2d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9359:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXTSW2D:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTSW2D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 537,
        GIR_Done,
      // Label 489: @13749
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(13792), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vprtybw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9445:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VPRTYBW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPRTYBW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 540,
        GIR_Done,
      // Label 490: @13792
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(13835), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vprtybd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9443:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VPRTYBD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPRTYBD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 541,
        GIR_Done,
      // Label 491: @13835
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(13878), // Rule ID 542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vprtybq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9444:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VPRTYBQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPRTYBQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 542,
        GIR_Done,
      // Label 492: @13878
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(13918), // Rule ID 686 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_popcntb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9693:{ *:[iPTR] }, i64:{ *:[i64] }:$RST)  =>  (POPCNTB8:{ *:[i64] } i64:{ *:[i64] }:$RST)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::POPCNTB8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 686,
        GIR_Done,
      // Label 493: @13918
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(13961), // Rule ID 1049 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstribr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9482:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VSTRIBR:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSTRIBR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1049,
        GIR_Done,
      // Label 494: @13961
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(14004), // Rule ID 1050 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstribl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9480:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VSTRIBL:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSTRIBL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1050,
        GIR_Done,
      // Label 495: @14004
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(14047), // Rule ID 1051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstrihr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9486:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VSTRIHR:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSTRIHR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1051,
        GIR_Done,
      // Label 496: @14047
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(14090), // Rule ID 1052 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstrihl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9484:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VSTRIHL:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSTRIHL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1052,
        GIR_Done,
      // Label 497: @14090
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(14133), // Rule ID 1069 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractbm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9349:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTRACTBM:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTBM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1069,
        GIR_Done,
      // Label 498: @14133
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(14176), // Rule ID 1070 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextracthm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9351:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTRACTHM:{ *:[i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTHM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1070,
        GIR_Done,
      // Label 499: @14176
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(14219), // Rule ID 1071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractwm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9353:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXTRACTWM:{ *:[i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTWM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1071,
        GIR_Done,
      // Label 500: @14219
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(14262), // Rule ID 1072 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractdm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9350:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXTRACTDM:{ *:[i32] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1072,
        GIR_Done,
      // Label 501: @14262
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(14305), // Rule ID 1073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractqm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9352:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VEXTRACTQM:{ *:[i32] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTQM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 502: @14305
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(14348), // Rule ID 1074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandbm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9335:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXPANDBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXPANDBM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 503: @14348
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(14391), // Rule ID 1075 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandhm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9337:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXPANDHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXPANDHM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1075,
        GIR_Done,
      // Label 504: @14391
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(14434), // Rule ID 1076 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandwm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9339:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXPANDWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXPANDWM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1076,
        GIR_Done,
      // Label 505: @14434
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(14477), // Rule ID 1077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpanddm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9336:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXPANDDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXPANDDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 506: @14477
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(14520), // Rule ID 1078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandqm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9338:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VEXPANDQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXPANDQM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 507: @14520
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(14563), // Rule ID 1079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrbm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9233:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRBM:{ *:[v16i8] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRBM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 508: @14563
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(14606), // Rule ID 1080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrhm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9235:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRHM:{ *:[v8i16] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRHM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1080,
        GIR_Done,
      // Label 509: @14606
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(14649), // Rule ID 1081 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrwm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9237:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRWM:{ *:[v4i32] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRWM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1081,
        GIR_Done,
      // Label 510: @14649
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(14692), // Rule ID 1082 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrdm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9234:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRDM:{ *:[v2i64] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1082,
        GIR_Done,
      // Label 511: @14692
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(14735), // Rule ID 1083 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrqm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9236:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRQM:{ *:[v1i128] } i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRQM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1083,
        GIR_Done,
      // Label 512: @14735
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(14778), // Rule ID 1147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsd2q),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9356:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXTSD2Q:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTSD2Q),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1147,
        GIR_Done,
      // Label 513: @14778
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(14821), // Rule ID 1152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxmfacc),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9676:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$AT)  =>  (XXMFACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$AT)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXMFACC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[ATo]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // AT
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1152,
        GIR_Done,
      // Label 514: @14821
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(14864), // Rule ID 1153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxmtacc),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9677:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi)  =>  (XXMTACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$ATi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXMTACC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1153,
        GIR_Done,
      // Label 515: @14864
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(14904), // Rule ID 1267 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fre),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9583:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FRE:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRE),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1267,
        GIR_Done,
      // Label 516: @14904
      GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(14944), // Rule ID 1268 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fres),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9584:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (FRES:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRES),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 517: @14944
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(14984), // Rule ID 1269 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9578:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FNABSD:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FNABSD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 518: @14984
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(15024), // Rule ID 1270 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabss),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9579:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (FNABSS:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FNABSS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 519: @15024
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(15104), // Rule ID 3338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspbf16),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9772:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XVCVSPBF16:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] })), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVCVSPBF16),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3338,
        GIR_Done,
      // Label 520: @15104
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(15184), // Rule ID 3339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvbf16spn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9767:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XVCVBF16SPN:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] })), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVCVBF16SPN),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3339,
        GIR_Done,
      // Label 521: @15184
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(15224), // Rule ID 4837 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fcfid),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9566:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVSXDDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSCVSXDDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4837,
        GIR_Done,
      // Label 522: @15224
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(15264), // Rule ID 4838 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fcfud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9567:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVUXDDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSCVUXDDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4838,
        GIR_Done,
      // Label 523: @15264
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(15304), // Rule ID 4839 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctid),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9568:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FCTID:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4839,
        GIR_Done,
      // Label 524: @15304
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(15344), // Rule ID 4840 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctidz),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9569:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPSXDS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSXDS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4840,
        GIR_Done,
      // Label 525: @15344
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(15384), // Rule ID 4841 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctiw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9570:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FCTIW:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FCTIW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4841,
        GIR_Done,
      // Label 526: @15384
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(15424), // Rule ID 4842 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctiwz),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9571:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPSXWS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSXWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4842,
        GIR_Done,
      // Label 527: @15424
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(15464), // Rule ID 4843 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctudz),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9572:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPUXDS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSCVDPUXDS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4843,
        GIR_Done,
      // Label 528: @15464
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(15504), // Rule ID 4844 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctuwz),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9573:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPUXWS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSCVDPUXWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4844,
        GIR_Done,
      // Label 529: @15504
      GIM_Reject,
    // Label 427: @15505
    GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(26258),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(15593), // Rule ID 2152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxextractuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9811:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$A, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXEXTRACTUW:{ *:[f64] } ?:{ *:[v2i64] }:$A, (imm:{ *:[i32] }):$IMM), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXEXTRACTUW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2152,
        GIR_Done,
      // Label 531: @15593
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(15643), // Rule ID 1022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtstdcsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9801:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCSP:{ *:[v4i32] } (timm:{ *:[i32] }):$DCMX, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVTSTDCSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // DCMX
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1022,
        GIR_Done,
      // Label 532: @15643
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(15693), // Rule ID 1023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtstdcdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9800:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCDP:{ *:[v2i64] } (timm:{ *:[i32] }):$DCMX, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVTSTDCDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // DCMX
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1023,
        GIR_Done,
      // Label 533: @15693
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(15754), // Rule ID 891 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xsmaxdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9753:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMAXDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSMAXDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 891,
        GIR_Done,
      // Label 534: @15754
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(15815), // Rule ID 892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xsmindp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9754:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMINDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSMINDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 892,
        GIR_Done,
      // Label 535: @15815
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(15876), // Rule ID 893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvmaxdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9785:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMAXDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVMAXDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 893,
        GIR_Done,
      // Label 536: @15876
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(15937), // Rule ID 894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvmindp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9787:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMINDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVMINDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 894,
        GIR_Done,
      // Label 537: @15937
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(15998), // Rule ID 895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvmaxsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9786:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMAXSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVMAXSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 895,
        GIR_Done,
      // Label 538: @15998
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(16059), // Rule ID 896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvminsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9788:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMINSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVMINSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 896,
        GIR_Done,
      // Label 539: @16059
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(16110), // Rule ID 820 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpeqdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9755:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPEQDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCMPEQDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 820,
        GIR_Done,
      // Label 540: @16110
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(16161), // Rule ID 822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpeqsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9757:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPEQSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCMPEQSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 822,
        GIR_Done,
      // Label 541: @16161
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(16212), // Rule ID 824 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgedp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9759:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGEDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCMPGEDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 824,
        GIR_Done,
      // Label 542: @16212
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(16263), // Rule ID 826 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgesp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9761:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGESP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCMPGESP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 826,
        GIR_Done,
      // Label 543: @16263
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(16314), // Rule ID 828 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgtdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9763:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGTDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCMPGTDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 828,
        GIR_Done,
      // Label 544: @16314
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(16365), // Rule ID 830 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgtsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9765:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGTSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVCMPGTSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 830,
        GIR_Done,
      // Label 545: @16365
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(16416), // Rule ID 994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_addf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9204:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSADDQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSADDQPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 546: @16416
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(16467), // Rule ID 995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9685:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSMULQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSMULQPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 547: @16467
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(16518), // Rule ID 996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_subf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9713:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSSUBQPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 548: @16518
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(16569), // Rule ID 997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9560:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSDIVQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSDIVQPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 549: @16569
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(16620), // Rule ID 1016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xviexpdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9783:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)  =>  (XVIEXPDP:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVIEXPDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1016,
        GIR_Done,
      // Label 550: @16620
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(16671), // Rule ID 1017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xviexpsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9784:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XVIEXPSP:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVIEXPSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1017,
        GIR_Done,
      // Label 551: @16671
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(16722), // Rule ID 1639 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvdivsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9782:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B)  =>  (XVDIVSP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVDIVSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1639,
        GIR_Done,
      // Label 552: @16722
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(16773), // Rule ID 1640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvdivdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 9781:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A, v2f64:{ *:[v2f64] }:$B)  =>  (XVDIVDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A, ?:{ *:[v2f64] }:$B)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVDIVDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1640,
        GIR_Done,
      // Label 553: @16773
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(16844), // Rule ID 1641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtdivdp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9795:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A, v2f64:{ *:[v2f64] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTDIVDP:{ *:[i32] } ?:{ *:[v2f64] }:$A, ?:{ *:[v2f64] }:$B), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTDIVDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1641,
        GIR_Done,
      // Label 554: @16844
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(16915), // Rule ID 1642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtdivsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9796:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTDIVSP:{ *:[i32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTDIVSP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1642,
        GIR_Done,
      // Label 555: @16915
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(16966), // Rule ID 1886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxleqv),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9817:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v4i32:{ *:[v4i32] }:$B)  =>  (XXLEQV:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1886,
        GIR_Done,
      // Label 556: @16966
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(17054), // Rule ID 1924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_insert_exp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9594:{ *:[iPTR] }, f64:{ *:[f64] }:$A, i64:{ *:[i64] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[f64] } (XSIEXPDP:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[i64] } ?:{ *:[f64] }:$A, G8RC:{ *:[i32] }), ?:{ *:[i64] }:$B), F8RC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSIEXPDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::F8RCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1924,
        GIR_Done,
      // Label 557: @17054
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(17122), // Rule ID 2149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_scalar_insert_exp_qp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9696:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, i64:{ *:[i64] }:$vB)  =>  (XSIEXPQP:{ *:[f128] } ?:{ *:[f128] }:$vA, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$vB))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSIEXPQP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[FRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2149,
        GIR_Done,
      // Label 558: @17122
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(17219), // Rule ID 3328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtlsbb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRRCRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 1,
        // (intrinsic_wo_chain:{ *:[i32] } 9797:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XB, 1:{ *:[i32] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (XVTLSBB:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] })), sub_lt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTLSBB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_lt),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::CRBITRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(PPC::CRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3328,
        GIR_Done,
      // Label 559: @17219
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(17316), // Rule ID 3329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtlsbb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRRCRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[i32] } 9797:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XB, 0:{ *:[i32] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (XVTLSBB:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] })), sub_eq:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTLSBB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_eq),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::CRBITRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(PPC::CRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3329,
        GIR_Done,
      // Label 560: @17316
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(17370), // Rule ID 314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfsx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9264:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, 0:{ *:[i32] })  =>  (VCFSX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCFSX_0),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 314,
        GIR_Done,
      // Label 561: @17370
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(17424), // Rule ID 315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctuxs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9326:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, 0:{ *:[i32] })  =>  (VCTUXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCTUXS_0),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 315,
        GIR_Done,
      // Label 562: @17424
      GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(17478), // Rule ID 316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfux),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9266:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, 0:{ *:[i32] })  =>  (VCFUX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCFUX_0),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 316,
        GIR_Done,
      // Label 563: @17478
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(17532), // Rule ID 317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctsxs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9325:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, 0:{ *:[i32] })  =>  (VCTSXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCTSXS_0),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 317,
        GIR_Done,
      // Label 564: @17532
      GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(17612), // Rule ID 3324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvbm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9812:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXGENPCVBM:{ *:[v4i32] } ?:{ *:[v16i8] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVBM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3324,
        GIR_Done,
      // Label 565: @17612
      GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(17692), // Rule ID 3325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvhm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 9814:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXGENPCVHM:{ *:[v4i32] } ?:{ *:[v8i16] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVHM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3325,
        GIR_Done,
      // Label 566: @17692
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(17772), // Rule ID 3326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvwm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9815:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (XXGENPCVWM:{ *:[v4i32] } ?:{ *:[v4i32] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVWM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3326,
        GIR_Done,
      // Label 567: @17772
      GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(17852), // Rule ID 3327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvdm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9813:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXGENPCVDM:{ *:[v4i32] } ?:{ *:[v2i64] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVDM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3327,
        GIR_Done,
      // Label 568: @17852
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(17902), // Rule ID 310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfsx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 9264:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCFSX:{ *:[v4f32] } (timm:{ *:[i32] }):$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCFSX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 310,
        GIR_Done,
      // Label 569: @17902
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(17952), // Rule ID 311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfux),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 9266:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCFUX:{ *:[v4f32] } (timm:{ *:[i32] }):$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCFUX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 311,
        GIR_Done,
      // Label 570: @17952
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(18002), // Rule ID 312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctsxs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9325:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCTSXS:{ *:[v4i32] } (timm:{ *:[i32] }):$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCTSXS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 312,
        GIR_Done,
      // Label 571: @18002
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(18052), // Rule ID 313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctuxs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9326:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCTUXS:{ *:[v4i32] } (timm:{ *:[i32] }):$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCTUXS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 313,
        GIR_Done,
      // Label 572: @18052
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(18102), // Rule ID 1085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9321:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBB:{ *:[i64] } v16i8:{ *:[v16i8] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCNTMBB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1085,
        GIR_Done,
      // Label 573: @18102
      GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(18152), // Rule ID 1086 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9323:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBH:{ *:[i64] } v8i16:{ *:[v8i16] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCNTMBH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1086,
        GIR_Done,
      // Label 574: @18152
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(18202), // Rule ID 1087 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9324:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBW:{ *:[i64] } v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCNTMBW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1087,
        GIR_Done,
      // Label 575: @18202
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(18252), // Rule ID 1088 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9322:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBD:{ *:[i64] } v2i64:{ *:[v2i64] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCNTMBD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1088,
        GIR_Done,
      // Label 576: @18252
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(18302), // Rule ID 1102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vgnb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] N
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9361:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB, (timm:{ *:[i32] }):$N)  =>  (VGNB:{ *:[i64] } v1i128:{ *:[v1i128] }:$VB, (timm:{ *:[i32] }):$N)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VGNB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // N
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1102,
        GIR_Done,
      // Label 577: @18302
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(18363), // Rule ID 201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divwe),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9561:{ *:[iPTR] }, gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)  =>  (DIVWE:{ *:[i32] } gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVWE),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 201,
        GIR_Done,
      // Label 578: @18363
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(18424), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divweu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9562:{ *:[iPTR] }, gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)  =>  (DIVWEU:{ *:[i32] } gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVWEU),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 579: @18424
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(18485), // Rule ID 683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBPERMD),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_bpermd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9524:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RST, g8rc:{ *:[i64] }:$RB)  =>  (BPERMD:{ *:[i64] } g8rc:{ *:[i64] }:$RST, g8rc:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::BPERMD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 683,
        GIR_Done,
      // Label 580: @18485
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(18546), // Rule ID 689 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divde),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9558:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)  =>  (DIVDE:{ *:[i64] } g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVDE),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 689,
        GIR_Done,
      // Label 581: @18546
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(18607), // Rule ID 694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divdeu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9559:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)  =>  (DIVDEU:{ *:[i64] } g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVDEU),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 582: @18607
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(18685), // Rule ID 1545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cmpeqb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9528:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (SETB8:{ *:[i64] } (CMPEQB:{ *:[i32] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::CMPEQB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SETB8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1545,
        GIR_Done,
      // Label 583: @18685
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(18763), // Rule ID 1546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_setb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9701:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (SETB8:{ *:[i64] } (CMPD:{ *:[i32] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::CMPD),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::SETB8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1546,
        GIR_Done,
      // Label 584: @18763
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(18824), // Rule ID 1550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9686:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (MULHD:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULHD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1550,
        GIR_Done,
      // Label 585: @18824
      GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(18885), // Rule ID 1551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhdu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9687:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (MULHDU:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULHDU),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1551,
        GIR_Done,
      // Label 586: @18885
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(18943), // Rule ID 1554 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cmpb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9527:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (CMPB8:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CMPB8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1554,
        GIR_Done,
      // Label 587: @18943
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(19001), // Rule ID 4823 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9688:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (MULHW:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULHW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4823,
        GIR_Done,
      // Label 588: @19001
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(19059), // Rule ID 4824 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhwu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9689:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (MULHWU:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULHWU),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4824,
        GIR_Done,
      // Label 589: @19059
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(19117), // Rule ID 4825 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cmpb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9527:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (CMPB:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CMPB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4825,
        GIR_Done,
      // Label 590: @19117
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(19168), // Rule ID 301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddcuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9247:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDCUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 301,
        GIR_Done,
      // Label 591: @19168
      GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(19219), // Rule ID 302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddsbs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9250:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDSBS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 302,
        GIR_Done,
      // Label 592: @19219
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(19270), // Rule ID 303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddshs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9251:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDSHS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 303,
        GIR_Done,
      // Label 593: @19270
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(19321), // Rule ID 304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddsws),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9252:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDSWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 304,
        GIR_Done,
      // Label 594: @19321
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(19372), // Rule ID 305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddubs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9253:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUBS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 305,
        GIR_Done,
      // Label 595: @19372
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(19423), // Rule ID 306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vadduhs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9254:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUHS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 306,
        GIR_Done,
      // Label 596: @19423
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(19474), // Rule ID 307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vadduws),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9255:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 307,
        GIR_Done,
      // Label 597: @19474
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(19525), // Rule ID 320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgsb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9256:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VAVGSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAVGSB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 320,
        GIR_Done,
      // Label 598: @19525
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(19576), // Rule ID 321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgsh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9257:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VAVGSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAVGSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 321,
        GIR_Done,
      // Label 599: @19576
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(19627), // Rule ID 322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgsw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9258:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAVGSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAVGSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 322,
        GIR_Done,
      // Label 600: @19627
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(19678), // Rule ID 323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9259:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VAVGUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAVGUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 323,
        GIR_Done,
      // Label 601: @19678
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(19729), // Rule ID 324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavguh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9260:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VAVGUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAVGUH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 324,
        GIR_Done,
      // Label 602: @19729
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(19780), // Rule ID 325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavguw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9261:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAVGUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAVGUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 325,
        GIR_Done,
      // Label 603: @19780
      GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(19831), // Rule ID 326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxfp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9380:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)  =>  (VMAXFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 326,
        GIR_Done,
      // Label 604: @19831
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(19882), // Rule ID 327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9381:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMAXSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXSB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 327,
        GIR_Done,
      // Label 605: @19882
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(19933), // Rule ID 328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9383:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMAXSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 328,
        GIR_Done,
      // Label 606: @19933
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(19984), // Rule ID 329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9384:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMAXSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 329,
        GIR_Done,
      // Label 607: @19984
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(20035), // Rule ID 330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9385:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMAXUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 330,
        GIR_Done,
      // Label 608: @20035
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(20086), // Rule ID 331 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxuh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9387:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMAXUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXUH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 331,
        GIR_Done,
      // Label 609: @20086
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(20137), // Rule ID 332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9388:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMAXUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 332,
        GIR_Done,
      // Label 610: @20137
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(20188), // Rule ID 333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminfp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9391:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)  =>  (VMINFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 333,
        GIR_Done,
      // Label 611: @20188
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(20239), // Rule ID 334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9392:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMINSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINSB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 334,
        GIR_Done,
      // Label 612: @20239
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(20290), // Rule ID 335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9394:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMINSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 335,
        GIR_Done,
      // Label 613: @20290
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(20341), // Rule ID 336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9395:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 336,
        GIR_Done,
      // Label 614: @20341
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(20392), // Rule ID 337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9396:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMINUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 337,
        GIR_Done,
      // Label 615: @20392
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(20443), // Rule ID 338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminuh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9398:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMINUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINUH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 338,
        GIR_Done,
      // Label 616: @20443
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(20494), // Rule ID 339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9399:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMINUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 339,
        GIR_Done,
      // Label 617: @20494
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(20545), // Rule ID 352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9409:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULESB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULESB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 618: @20545
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(20596), // Rule ID 353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9411:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULESH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULESH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 619: @20596
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(20647), // Rule ID 354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9413:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULEUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULEUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 354,
        GIR_Done,
      // Label 620: @20647
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(20698), // Rule ID 355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleuh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9415:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULEUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULEUH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 355,
        GIR_Done,
      // Label 621: @20698
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(20749), // Rule ID 356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9421:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULOSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOSB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 356,
        GIR_Done,
      // Label 622: @20749
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(20800), // Rule ID 357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9423:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULOSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 357,
        GIR_Done,
      // Label 623: @20800
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(20851), // Rule ID 358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuloub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9425:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULOUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 358,
        GIR_Done,
      // Label 624: @20851
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(20902), // Rule ID 359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulouh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9427:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULOUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOUH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 359,
        GIR_Done,
      // Label 625: @20902
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(20953), // Rule ID 366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubcuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9489:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBCUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 366,
        GIR_Done,
      // Label 626: @20953
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(21004), // Rule ID 371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubsbs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9492:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBSBS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 371,
        GIR_Done,
      // Label 627: @21004
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(21055), // Rule ID 372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubshs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9493:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBSHS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 372,
        GIR_Done,
      // Label 628: @21055
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(21106), // Rule ID 373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubsws),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9494:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBSWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 373,
        GIR_Done,
      // Label 629: @21106
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(21157), // Rule ID 374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsububs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9495:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUBS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 374,
        GIR_Done,
      // Label 630: @21157
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(21208), // Rule ID 375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubuhs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9496:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUHS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 375,
        GIR_Done,
      // Label 631: @21208
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(21259), // Rule ID 376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubuws),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9497:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUWS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 376,
        GIR_Done,
      // Label 632: @21259
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(21310), // Rule ID 385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9451:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 385,
        GIR_Done,
      // Label 633: @21310
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(21361), // Rule ID 386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9455:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VRLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 386,
        GIR_Done,
      // Label 634: @21361
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(21412), // Rule ID 387 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9458:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VRLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 387,
        GIR_Done,
      // Label 635: @21412
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(21463), // Rule ID 388 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9463:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 388,
        GIR_Done,
      // Label 636: @21463
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(21514), // Rule ID 389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslo),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9467:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSLO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSLO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 389,
        GIR_Done,
      // Label 637: @21514
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(21565), // Rule ID 390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9464:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSLB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 390,
        GIR_Done,
      // Label 638: @21565
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(21616), // Rule ID 391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9466:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSLH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 391,
        GIR_Done,
      // Label 639: @21616
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(21667), // Rule ID 392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9469:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSLW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 392,
        GIR_Done,
      // Label 640: @21667
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(21718), // Rule ID 396 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9470:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 396,
        GIR_Done,
      // Label 641: @21718
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(21769), // Rule ID 397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsro),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9477:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 397,
        GIR_Done,
      // Label 642: @21769
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(21820), // Rule ID 398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrab),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9471:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRAB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRAB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 398,
        GIR_Done,
      // Label 643: @21820
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(21871), // Rule ID 399 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrah),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9472:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSRAH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRAH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 399,
        GIR_Done,
      // Label 644: @21871
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(21922), // Rule ID 400 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsraw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9473:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRAW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 400,
        GIR_Done,
      // Label 645: @21922
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(21973), // Rule ID 401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9474:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 401,
        GIR_Done,
      // Label 646: @21973
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(22024), // Rule ID 402 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9476:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSRH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 402,
        GIR_Done,
      // Label 647: @22024
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(22075), // Rule ID 403 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9479:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 403,
        GIR_Done,
      // Label 648: @22075
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(22126), // Rule ID 407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkpx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9433:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKPX:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPKPX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 407,
        GIR_Done,
      // Label 649: @22126
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(22177), // Rule ID 454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9412:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULESW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULESW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 454,
        GIR_Done,
      // Label 650: @22177
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(22228), // Rule ID 455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9416:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULEUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULEUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 455,
        GIR_Done,
      // Label 651: @22228
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(22279), // Rule ID 456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9424:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULOSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 456,
        GIR_Done,
      // Label 652: @22279
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(22330), // Rule ID 457 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulouw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9428:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULOUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 457,
        GIR_Done,
      // Label 653: @22330
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(22381), // Rule ID 459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9382:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMAXSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXSD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 459,
        GIR_Done,
      // Label 654: @22381
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(22432), // Rule ID 460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9386:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMAXUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMAXUD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 460,
        GIR_Done,
      // Label 655: @22432
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(22483), // Rule ID 461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9393:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINSD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 461,
        GIR_Done,
      // Label 656: @22483
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(22534), // Rule ID 462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9397:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMINUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMINUD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 462,
        GIR_Done,
      // Label 657: @22534
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(22585), // Rule ID 465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrld),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9452:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VRLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 465,
        GIR_Done,
      // Label 658: @22585
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(22636), // Rule ID 469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddcuq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9246:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDCUQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 469,
        GIR_Done,
      // Label 659: @22636
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(22687), // Rule ID 474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubcuq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9488:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBCUQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 474,
        GIR_Done,
      // Label 660: @22687
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(22738), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9211:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VPMSUMB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPMSUMB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 661: @22738
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(22789), // Rule ID 494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9213:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPMSUMH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPMSUMH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 662: @22789
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(22840), // Rule ID 495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9214:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPMSUMW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPMSUMW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 663: @22840
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(22891), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9212:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPMSUMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPMSUMD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 496,
        GIR_Done,
      // Label 664: @22891
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(22942), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vbpermq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9263:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VBPERMQ:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VBPERMQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 665: @22942
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(22993), // Rule ID 507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vcipher),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9205:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCIPHER),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 666: @22993
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(23044), // Rule ID 508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vcipherlast),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9206:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCIPHERLAST),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 667: @23044
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(23095), // Rule ID 509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vncipher),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9207:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VNCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNCIPHER),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 668: @23095
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(23146), // Rule ID 510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vncipherlast),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9208:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VNCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNCIPHERLAST),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 669: @23146
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(23197), // Rule ID 543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vbpermd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9262:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VBPERMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VBPERMD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 543,
        GIR_Done,
      // Label 670: @23197
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(23248), // Rule ID 544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlwnm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9460:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VRLWNM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLWNM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 544,
        GIR_Done,
      // Label 671: @23248
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(23299), // Rule ID 546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrldnm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9454:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VRLDNM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLDNM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 546,
        GIR_Done,
      // Label 672: @23299
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(23350), // Rule ID 548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslv),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9468:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSLV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSLV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 548,
        GIR_Done,
      // Label 673: @23350
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(23401), // Rule ID 549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrv),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9478:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 549,
        GIR_Done,
      // Label 674: @23401
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(23452), // Rule ID 550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vabsdub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9243:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VABSDUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VABSDUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 550,
        GIR_Done,
      // Label 675: @23452
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(23503), // Rule ID 551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vabsduh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9244:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VABSDUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VABSDUH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 551,
        GIR_Done,
      // Label 676: @23503
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(23554), // Rule ID 552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vabsduw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9245:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VABSDUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VABSDUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 552,
        GIR_Done,
      // Label 677: @23554
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(23605), // Rule ID 1097 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpdepd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9430:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPDEPD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPDEPD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1097,
        GIR_Done,
      // Label 678: @23605
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(23656), // Rule ID 1098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpextd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9432:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPEXTD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPEXTD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1098,
        GIR_Done,
      // Label 679: @23656
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(23707), // Rule ID 1099 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_pdepd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9691:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (PDEPD:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PDEPD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1099,
        GIR_Done,
      // Label 680: @23707
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(23758), // Rule ID 1100 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_pextd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9692:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (PEXTD:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PEXTD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1100,
        GIR_Done,
      // Label 681: @23758
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(23809), // Rule ID 1101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfuged),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9265:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCFUGED:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCFUGED),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1101,
        GIR_Done,
      // Label 682: @23809
      GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(23860), // Rule ID 1103 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cfuged),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9526:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CFUGED:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CFUGED),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1103,
        GIR_Done,
      // Label 683: @23860
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(23911), // Rule ID 1105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclzdm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9269:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCLZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCLZDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1105,
        GIR_Done,
      // Label 684: @23911
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(23962), // Rule ID 1106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctzdm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9327:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCTZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCTZDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1106,
        GIR_Done,
      // Label 685: @23962
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(24013), // Rule ID 1107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cntlzdm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9531:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CNTLZDM:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CNTLZDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1107,
        GIR_Done,
      // Label 686: @24013
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(24064), // Rule ID 1108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cnttzdm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9532:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CNTTZDM:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CNTTZDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1108,
        GIR_Done,
      // Label 687: @24064
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(24115), // Rule ID 1109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclrlb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9267:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VCLRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCLRLB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1109,
        GIR_Done,
      // Label 688: @24115
      GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(24166), // Rule ID 1110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclrrb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9268:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VCLRRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VCLRRB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1110,
        GIR_Done,
      // Label 689: @24166
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(24217), // Rule ID 1124 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdivesw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9331:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVESW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVESW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1124,
        GIR_Done,
      // Label 690: @24217
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(24268), // Rule ID 1125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdiveuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9334:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVEUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVEUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1125,
        GIR_Done,
      // Label 691: @24268
      GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(24319), // Rule ID 1126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdivesd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9329:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVESD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVESD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1126,
        GIR_Done,
      // Label 692: @24319
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(24370), // Rule ID 1127 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdiveud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9332:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVEUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVEUD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1127,
        GIR_Done,
      // Label 693: @24370
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(24421), // Rule ID 1130 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9410:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULESD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULESD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1130,
        GIR_Done,
      // Label 694: @24421
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(24472), // Rule ID 1131 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9414:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULEUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULEUD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1131,
        GIR_Done,
      // Label 695: @24472
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(24523), // Rule ID 1132 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9422:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULOSD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOSD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1132,
        GIR_Done,
      // Label 696: @24523
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(24574), // Rule ID 1133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuloud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9426:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULOUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULOUD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1133,
        GIR_Done,
      // Label 697: @24574
      GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(24625), // Rule ID 1137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdivesq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9330:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVESQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVESQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1137,
        GIR_Done,
      // Label 698: @24625
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(24676), // Rule ID 1138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdiveuq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9333:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVEUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVEUQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1138,
        GIR_Done,
      // Label 699: @24676
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(24727), // Rule ID 1148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlqnm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9457:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VRLQNM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLQNM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1148,
        GIR_Done,
      // Label 700: @24727
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(24778), // Rule ID 3320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhsw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9418:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHSW:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULHSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3320,
        GIR_Done,
      // Label 701: @24778
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(24829), // Rule ID 3321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhuw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9420:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHUW:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULHUW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3321,
        GIR_Done,
      // Label 702: @24829
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(24880), // Rule ID 3322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhsd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9417:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHSD:{ *:[v2i64] } ?:{ *:[v2i64] }:$vA, ?:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULHSD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3322,
        GIR_Done,
      // Label 703: @24880
      GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(24931), // Rule ID 3323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9419:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHUD:{ *:[v2i64] } ?:{ *:[v2i64] }:$vA, ?:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULHUD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3323,
        GIR_Done,
      // Label 704: @24931
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(25016), // Rule ID 3488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9671:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3488,
        GIR_Done,
      // Label 705: @25016
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(25101), // Rule ID 3490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9673:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3490,
        GIR_Done,
      // Label 706: @25101
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(25186), // Rule ID 3492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2s),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9669:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2S:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2S),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3492,
        GIR_Done,
      // Label 707: @25186
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(25271), // Rule ID 3494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9671:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3494,
        GIR_Done,
      // Label 708: @25271
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(25356), // Rule ID 3496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9673:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3496,
        GIR_Done,
      // Label 709: @25356
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(25441), // Rule ID 3498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2s),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9669:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2SW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3498,
        GIR_Done,
      // Label 710: @25441
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(25526), // Rule ID 3500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9652:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3500,
        GIR_Done,
      // Label 711: @25526
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(25611), // Rule ID 3505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9652:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3505,
        GIR_Done,
      // Label 712: @25611
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(25696), // Rule ID 3510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9657:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GER:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GER),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3510,
        GIR_Done,
      // Label 713: @25696
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(25764), // Rule ID 3515 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9662:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GER:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GER),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3515,
        GIR_Done,
      // Label 714: @25764
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(25849), // Rule ID 3520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9647:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3520,
        GIR_Done,
      // Label 715: @25849
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(25934), // Rule ID 3525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9667:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3525,
        GIR_Done,
      // Label 716: @25934
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(26019), // Rule ID 3528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9657:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3528,
        GIR_Done,
      // Label 717: @26019
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(26087), // Rule ID 3533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9662:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERW:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3533,
        GIR_Done,
      // Label 718: @26087
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(26172), // Rule ID 3538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9647:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3538,
        GIR_Done,
      // Label 719: @26172
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(26257), // Rule ID 3543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9667:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3543,
        GIR_Done,
      // Label 720: @26257
      GIM_Reject,
    // Label 530: @26258
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(34428),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(26339), // Rule ID 1000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmaf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[f128] } 9575:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$RSTi))  =>  (XSMSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$RSTi, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSMSUBQPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RSTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1000,
        GIR_Done,
      // Label 722: @26339
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(26407), // Rule ID 2151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxinsertw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9816:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v2i64:{ *:[v2i64] }:$B, (imm:{ *:[i32] }):$IMM)  =>  (XXINSERTW:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v2i64] }:$B, (imm:{ *:[i32] }):$IMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXINSERTW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2151,
        GIR_Done,
      // Label 723: @26407
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(26466), // Rule ID 999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmaf128_round_to_odd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9575:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB, f128:{ *:[f128] }:$RSTi)  =>  (XSMADDQPO:{ *:[f128] } f128:{ *:[f128] }:$RSTi, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSMADDQPO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RSTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 724: @26466
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(26525), // Rule ID 1732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9576:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (XSMSUBMDP:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSMSUBMDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1732,
        GIR_Done,
      // Label 725: @26525
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(26584), // Rule ID 1733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9580:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (XSNMADDMDP:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSNMADDMDP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1733,
        GIR_Done,
      // Label 726: @26584
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(26643), // Rule ID 1919 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsubs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9577:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (XSMSUBMSP:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSMSUBMSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1919,
        GIR_Done,
      // Label 727: @26643
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(26702), // Rule ID 1920 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadds),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9581:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (XSNMADDMSP:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSNMADDMSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1920,
        GIR_Done,
      // Label 728: @26702
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(26759), // Rule ID 505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vshasigmaw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9217:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSHASIGMAW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SIX
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 729: @26759
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(26816), // Rule ID 506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vshasigmad),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9216:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSHASIGMAD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SIX
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 730: @26816
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(26874), // Rule ID 1047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsldbi),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] SD
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9465:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)  =>  (VSLDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSLDBI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VRB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SD
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1047,
        GIR_Done,
      // Label 731: @26874
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(26932), // Rule ID 1048 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrdbi),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] SD
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9475:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)  =>  (VSRDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSRDBI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VRB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SD
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1048,
        GIR_Done,
      // Label 732: @26932
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(26990), // Rule ID 1053 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9373:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, (timm:{ *:[i32] }):$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1053,
        GIR_Done,
      // Label 733: @26990
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(27048), // Rule ID 1054 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9366:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, (timm:{ *:[i32] }):$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1054,
        GIR_Done,
      // Label 734: @27048
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(27109), // Rule ID 1431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_bcdadd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] PS
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9520:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$PS)  =>  (BCDADD_rec:{ *:[v16i8] }:{ *:[i32] } ?:{ *:[v16i8] }:$vA, ?:{ *:[v16i8] }:$vB, ?:{ *:[i32] }:$PS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::BCDADD_rec),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // PS
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CR6*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1431,
        GIR_Done,
      // Label 735: @27109
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(27170), // Rule ID 1432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_bcdsub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] PS
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9522:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$PS)  =>  (BCDSUB_rec:{ *:[v16i8] }:{ *:[i32] } ?:{ *:[v16i8] }:$vA, ?:{ *:[v16i8] }:$vB, ?:{ *:[i32] }:$PS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::BCDSUB_rec),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // PS
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CR6*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1432,
        GIR_Done,
      // Label 736: @27170
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(27244), // Rule ID 1547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_maddhd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9603:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDHD:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MADDHD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1547,
        GIR_Done,
      // Label 737: @27244
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(27318), // Rule ID 1548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_maddhdu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9604:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDHDU:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MADDHDU),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1548,
        GIR_Done,
      // Label 738: @27318
      GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(27392), // Rule ID 1549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_maddld),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9605:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDLD8:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MADDLD8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1549,
        GIR_Done,
      // Label 739: @27392
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(27463), // Rule ID 4802 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fsel),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9587:{ *:[iPTR] }, f8rc:{ *:[f64] }:$FRA, f8rc:{ *:[f64] }:$FRC, f8rc:{ *:[f64] }:$FRB)  =>  (FSELD:{ *:[f64] } ?:{ *:[f64] }:$FRA, ?:{ *:[f64] }:$FRC, ?:{ *:[f64] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FSELD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[FRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // FRB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 4802,
        GIR_Done,
      // Label 740: @27463
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(27522), // Rule ID 293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmladduhm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9400:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v8i16:{ *:[v8i16] }:$RC)  =>  (VMLADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v8i16:{ *:[v8i16] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 293,
        GIR_Done,
      // Label 741: @27522
      GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(27581), // Rule ID 294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vperm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9431:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v16i8:{ *:[v16i8] }:$RC)  =>  (VPERM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v16i8:{ *:[v16i8] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPERM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 294,
        GIR_Done,
      // Label 742: @27581
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(27640), // Rule ID 295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsel),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9462:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VSEL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSEL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 295,
        GIR_Done,
      // Label 743: @27640
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(27699), // Rule ID 346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsummbm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9402:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMMBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMSUMMBM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 346,
        GIR_Done,
      // Label 744: @27699
      GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(27758), // Rule ID 347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumshm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9403:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMSHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMSUMSHM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 745: @27758
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(27817), // Rule ID 348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumubm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9405:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMUBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMSUMUBM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 348,
        GIR_Done,
      // Label 746: @27817
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(27876), // Rule ID 349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumuhm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9407:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMUHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMSUMUHM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 349,
        GIR_Done,
      // Label 747: @27876
      GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(27935), // Rule ID 468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddeuqm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9249:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VADDEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDEUQM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 468,
        GIR_Done,
      // Label 748: @27935
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(27994), // Rule ID 470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddecuq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9248:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VADDECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDECUQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 470,
        GIR_Done,
      // Label 749: @27994
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(28053), // Rule ID 473 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubeuqm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9491:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VSUBEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBEUQM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 473,
        GIR_Done,
      // Label 750: @28053
      GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(28112), // Rule ID 475 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubecuq),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9490:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VSUBECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBECUQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 475,
        GIR_Done,
      // Label 751: @28112
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(28171), // Rule ID 512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumudm),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9406:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VMSUMUDM:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMSUMUDM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 512,
        GIR_Done,
      // Label 752: @28171
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(28230), // Rule ID 545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlwmi),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9459:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB, v4i32:{ *:[v4i32] }:$VDi)  =>  (VRLWMI:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB, v4i32:{ *:[v4i32] }:$VDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLWMI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VDi
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 545,
        GIR_Done,
      // Label 753: @28230
      GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(28289), // Rule ID 547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrldmi),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9453:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB, v2i64:{ *:[v2i64] }:$VDi)  =>  (VRLDMI:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB, v2i64:{ *:[v2i64] }:$VDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLDMI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VDi
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 754: @28289
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(28348), // Rule ID 1055 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsbvlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9364:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VINSBVLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSBVLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1055,
        GIR_Done,
      // Label 755: @28348
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(28407), // Rule ID 1056 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsbvrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9365:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VINSBVRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSBVRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1056,
        GIR_Done,
      // Label 756: @28407
      GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(28466), // Rule ID 1057 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshvlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9371:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VINSHVLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSHVLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1057,
        GIR_Done,
      // Label 757: @28466
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(28525), // Rule ID 1058 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshvrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9372:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VINSHVRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSHVRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1058,
        GIR_Done,
      // Label 758: @28525
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(28584), // Rule ID 1059 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswvlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9376:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VINSWVLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSWVLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1059,
        GIR_Done,
      // Label 759: @28584
      GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(28643), // Rule ID 1060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswvrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9377:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VINSWVRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSWVRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1060,
        GIR_Done,
      // Label 760: @28643
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(28702), // Rule ID 1061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsblx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9362:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSBLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSBLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1061,
        GIR_Done,
      // Label 761: @28702
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(28761), // Rule ID 1062 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsbrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9363:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSBRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSBRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1062,
        GIR_Done,
      // Label 762: @28761
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(28820), // Rule ID 1063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9369:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSHLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSHLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1063,
        GIR_Done,
      // Label 763: @28820
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(28879), // Rule ID 1064 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9370:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSHRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSHRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1064,
        GIR_Done,
      // Label 764: @28879
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(28938), // Rule ID 1065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9374:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSWLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSWLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1065,
        GIR_Done,
      // Label 765: @28938
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(28997), // Rule ID 1066 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9375:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSWRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSWRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1066,
        GIR_Done,
      // Label 766: @28997
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(29056), // Rule ID 1067 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsdlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9367:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)  =>  (VINSDLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSDLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1067,
        GIR_Done,
      // Label 767: @29056
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(29115), // Rule ID 1068 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsdrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9368:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)  =>  (VINSDRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VINSDRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1068,
        GIR_Done,
      // Label 768: @29115
      GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(29174), // Rule ID 1089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextdubvlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9343:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUBVLX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDUBVLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1089,
        GIR_Done,
      // Label 769: @29174
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(29233), // Rule ID 1090 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextdubvrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9344:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUBVRX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDUBVRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1090,
        GIR_Done,
      // Label 770: @29233
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(29292), // Rule ID 1091 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduhvlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9345:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUHVLX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDUHVLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1091,
        GIR_Done,
      // Label 771: @29292
      GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(29351), // Rule ID 1092 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduhvrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9346:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUHVRX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDUHVRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1092,
        GIR_Done,
      // Label 772: @29351
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(29410), // Rule ID 1093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduwvlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9347:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUWVLX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDUWVLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1093,
        GIR_Done,
      // Label 773: @29410
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(29469), // Rule ID 1094 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduwvrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9348:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUWVRX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDUWVRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1094,
        GIR_Done,
      // Label 774: @29469
      GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(29528), // Rule ID 1095 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextddvlx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9341:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDDVLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDDVLX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1095,
        GIR_Done,
      // Label 775: @29528
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(29587), // Rule ID 1096 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextddvrx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9342:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDDVRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VEXTDDVRX),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1096,
        GIR_Done,
      // Label 776: @29587
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(29646), // Rule ID 1134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumcud),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9401:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VMSUMCUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMSUMCUD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // RB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // RC
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1134,
        GIR_Done,
      // Label 777: @29646
      GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(29705), // Rule ID 1149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlqmi),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9456:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB, v1i128:{ *:[v1i128] }:$VDi)  =>  (VRLQMI:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB, v1i128:{ *:[v1i128] }:$VDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRLQMI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // VDi
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1149,
        GIR_Done,
      // Label 778: @29705
      GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(29761), // Rule ID 1263 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9576:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (FMSUB:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FMSUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[FRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1263,
        GIR_Done,
      // Label 779: @29761
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(29817), // Rule ID 1264 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsubs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9577:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (FMSUBS:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FMSUBS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[FRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1264,
        GIR_Done,
      // Label 780: @29817
      GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(29873), // Rule ID 1265 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9580:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (FNMADD:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FNMADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[FRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1265,
        GIR_Done,
      // Label 781: @29873
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(29929), // Rule ID 1266 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadds),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9581:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (FNMADDS:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FNMADDS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[FRT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1266,
        GIR_Done,
      // Label 782: @29929
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(29988), // Rule ID 1368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaddfp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9379:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B, v4f32:{ *:[v4f32] }:$C)  =>  (VMADDFP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B, ?:{ *:[v4f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMADDFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1368,
        GIR_Done,
      // Label 783: @29988
      GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(30047), // Rule ID 1369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vnmsubfp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9429:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B, v4f32:{ *:[v4f32] }:$C)  =>  (VNMSUBFP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B, ?:{ *:[v4f32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VNMSUBFP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1369,
        GIR_Done,
      // Label 784: @30047
      GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(30161), // Rule ID 1564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec_HasVSX_IsLittleEndian),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpermxor),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9209:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, (XXLNOR:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$c, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$c, VSRC:{ *:[i32] })))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLNOR),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPERMXOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1564,
        GIR_Done,
      // Label 785: @30161
      GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(30220), // Rule ID 1565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec_HasVSX_IsBigEndian),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpermxor),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9209:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, ?:{ *:[v16i8] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPERMXOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1565,
        GIR_Done,
      // Label 786: @30220
      GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(30279), // Rule ID 1566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpermxor_be),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9210:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, ?:{ *:[v16i8] }:$c)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VPERMXOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1566,
        GIR_Done,
      // Label 787: @30279
      GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(30409), // Rule ID 3406 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9806:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$A, v16i8:{ *:[v16i8] }:$B, v16i8:{ *:[v16i8] }:$C)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXBLENDVB:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$C, VSRC:{ *:[i32] })), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3406,
        GIR_Done,
      // Label 788: @30409
      GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(30539), // Rule ID 3407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvh),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9808:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$A, v8i16:{ *:[v8i16] }:$B, v8i16:{ *:[v8i16] }:$C)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXBLENDVH:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$C, VSRC:{ *:[i32] })), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3407,
        GIR_Done,
      // Label 789: @30539
      GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(30598), // Rule ID 3408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvw),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9809:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v4i32:{ *:[v4i32] }:$B, v4i32:{ *:[v4i32] }:$C)  =>  (XXBLENDVW:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3408,
        GIR_Done,
      // Label 790: @30598
      GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(30657), // Rule ID 3409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvd),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9807:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$A, v2i64:{ *:[v2i64] }:$B, v2i64:{ *:[v2i64] }:$C)  =>  (XXBLENDVD:{ *:[v2i64] } ?:{ *:[v2i64] }:$A, ?:{ *:[v2i64] }:$B, ?:{ *:[v2i64] }:$C)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3409,
        GIR_Done,
      // Label 791: @30657
      GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(30750), // Rule ID 3489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9672:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3489,
        GIR_Done,
      // Label 792: @30750
      GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(30843), // Rule ID 3491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9674:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3491,
        GIR_Done,
      // Label 793: @30843
      GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(30936), // Rule ID 3493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9670:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2SPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3493,
        GIR_Done,
      // Label 794: @30936
      GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(31029), // Rule ID 3495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9672:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3495,
        GIR_Done,
      // Label 795: @31029
      GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(31122), // Rule ID 3497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9674:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3497,
        GIR_Done,
      // Label 796: @31122
      GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(31215), // Rule ID 3499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9670:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2SWPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3499,
        GIR_Done,
      // Label 797: @31215
      GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(31308), // Rule ID 3501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9656:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3501,
        GIR_Done,
      // Label 798: @31308
      GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(31401), // Rule ID 3502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9655:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2PN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3502,
        GIR_Done,
      // Label 799: @31401
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(31494), // Rule ID 3503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9654:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2NP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3503,
        GIR_Done,
      // Label 800: @31494
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(31587), // Rule ID 3504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9653:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2NN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3504,
        GIR_Done,
      // Label 801: @31587
      GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(31680), // Rule ID 3506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9656:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3506,
        GIR_Done,
      // Label 802: @31680
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(31773), // Rule ID 3507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9655:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3507,
        GIR_Done,
      // Label 803: @31773
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(31866), // Rule ID 3508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9654:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3508,
        GIR_Done,
      // Label 804: @31866
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(31959), // Rule ID 3509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9653:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3509,
        GIR_Done,
      // Label 805: @31959
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(32052), // Rule ID 3511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9661:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3511,
        GIR_Done,
      // Label 806: @32052
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(32145), // Rule ID 3512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9660:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3512,
        GIR_Done,
      // Label 807: @32145
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(32238), // Rule ID 3513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9659:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3513,
        GIR_Done,
      // Label 808: @32238
      GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(32331), // Rule ID 3514 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9658:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3514,
        GIR_Done,
      // Label 809: @32331
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(32407), // Rule ID 3516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9666:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3516,
        GIR_Done,
      // Label 810: @32407
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(32483), // Rule ID 3517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9665:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3517,
        GIR_Done,
      // Label 811: @32483
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(32559), // Rule ID 3518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9664:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3518,
        GIR_Done,
      // Label 812: @32559
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(32635), // Rule ID 3519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9663:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3519,
        GIR_Done,
      // Label 813: @32635
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(32728), // Rule ID 3521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9651:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3521,
        GIR_Done,
      // Label 814: @32728
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(32821), // Rule ID 3522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9650:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2PN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3522,
        GIR_Done,
      // Label 815: @32821
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(32914), // Rule ID 3523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9649:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2NP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3523,
        GIR_Done,
      // Label 816: @32914
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(33007), // Rule ID 3524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9648:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2NN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3524,
        GIR_Done,
      // Label 817: @33007
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(33100), // Rule ID 3526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9668:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3526,
        GIR_Done,
      // Label 818: @33100
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(33193), // Rule ID 3527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9675:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4SPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3527,
        GIR_Done,
      // Label 819: @33193
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(33286), // Rule ID 3529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9661:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3529,
        GIR_Done,
      // Label 820: @33286
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(33379), // Rule ID 3530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9660:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3530,
        GIR_Done,
      // Label 821: @33379
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(33472), // Rule ID 3531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9659:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3531,
        GIR_Done,
      // Label 822: @33472
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(33565), // Rule ID 3532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9658:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3532,
        GIR_Done,
      // Label 823: @33565
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(33641), // Rule ID 3534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9666:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERWPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3534,
        GIR_Done,
      // Label 824: @33641
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(33717), // Rule ID 3535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9665:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERWPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3535,
        GIR_Done,
      // Label 825: @33717
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(33793), // Rule ID 3536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9664:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3536,
        GIR_Done,
      // Label 826: @33793
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(33869), // Rule ID 3537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9663:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVF64GERWNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3537,
        GIR_Done,
      // Label 827: @33869
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(33962), // Rule ID 3539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9651:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3539,
        GIR_Done,
      // Label 828: @33962
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(34055), // Rule ID 3540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9650:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3540,
        GIR_Done,
      // Label 829: @34055
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(34148), // Rule ID 3541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9649:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3541,
        GIR_Done,
      // Label 830: @34148
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(34241), // Rule ID 3542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9648:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3542,
        GIR_Done,
      // Label 831: @34241
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(34334), // Rule ID 3544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9668:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3544,
        GIR_Done,
      // Label 832: @34334
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(34427), // Rule ID 3545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9675:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4WSPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4WSPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3545,
        GIR_Done,
      // Label 833: @34427
      GIM_Reject,
    // Label 721: @34428
    GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(35114),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(34563), // Rule ID 3557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9628:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GER:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GER),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3557,
        GIR_Done,
      // Label 835: @34563
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(34673), // Rule ID 3562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9633:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GER:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GER),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3562,
        GIR_Done,
      // Label 836: @34673
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(34800), // Rule ID 3586 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9628:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3586,
        GIR_Done,
      // Label 837: @34800
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(34910), // Rule ID 3591 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64ger),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9633:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERW:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3591,
        GIR_Done,
      // Label 838: @34910
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(34976), // Rule ID 1104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxeval),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] IMM
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9810:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)  =>  (XXEVAL:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // XC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1104,
        GIR_Done,
      // Label 839: @34976
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(35113), // Rule ID 3405 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxpermx),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] D
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9818:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$A, v16i8:{ *:[v16i8] }:$B, v16i8:{ *:[v16i8] }:$C, (timm:{ *:[i32] }):$D)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXPERMX:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$C, VSRC:{ *:[i32] }), ?:{ *:[i32] }:$D), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXPERMX),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/5, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3405,
        GIR_Done,
      // Label 840: @35113
      GIM_Reject,
    // Label 834: @35114
    GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(38923),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/7,
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(35270), // Rule ID 3546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9642:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3546,
        GIR_Done,
      // Label 842: @35270
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(35418), // Rule ID 3548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9644:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3548,
        GIR_Done,
      // Label 843: @35418
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(35566), // Rule ID 3550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2s),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9640:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2S:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2S),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3550,
        GIR_Done,
      // Label 844: @35566
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(35714), // Rule ID 3552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9623:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3552,
        GIR_Done,
      // Label 845: @35714
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(35862), // Rule ID 3567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9618:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3567,
        GIR_Done,
      // Label 846: @35862
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(36010), // Rule ID 3572 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9638:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3572,
        GIR_Done,
      // Label 847: @36010
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(36158), // Rule ID 3575 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9642:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3575,
        GIR_Done,
      // Label 848: @36158
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(36306), // Rule ID 3577 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9644:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3577,
        GIR_Done,
      // Label 849: @36306
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(36454), // Rule ID 3579 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2s),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9640:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2SW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3579,
        GIR_Done,
      // Label 850: @36454
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(36602), // Rule ID 3581 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9623:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3581,
        GIR_Done,
      // Label 851: @36602
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(36750), // Rule ID 3596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9618:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3596,
        GIR_Done,
      // Label 852: @36750
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(36898), // Rule ID 3601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9638:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3601,
        GIR_Done,
      // Label 853: @36898
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(37033), // Rule ID 3558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9632:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3558,
        GIR_Done,
      // Label 854: @37033
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(37168), // Rule ID 3559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9631:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3559,
        GIR_Done,
      // Label 855: @37168
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(37303), // Rule ID 3560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9630:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3560,
        GIR_Done,
      // Label 856: @37303
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(37438), // Rule ID 3561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9629:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3561,
        GIR_Done,
      // Label 857: @37438
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(37556), // Rule ID 3563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9637:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3563,
        GIR_Done,
      // Label 858: @37556
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(37674), // Rule ID 3564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9636:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3564,
        GIR_Done,
      // Label 859: @37674
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(37792), // Rule ID 3565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9635:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3565,
        GIR_Done,
      // Label 860: @37792
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(37910), // Rule ID 3566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9634:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3566,
        GIR_Done,
      // Label 861: @37910
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(38045), // Rule ID 3587 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9632:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3587,
        GIR_Done,
      // Label 862: @38045
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(38180), // Rule ID 3588 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9631:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3588,
        GIR_Done,
      // Label 863: @38180
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(38315), // Rule ID 3589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9630:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3589,
        GIR_Done,
      // Label 864: @38315
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(38450), // Rule ID 3590 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9629:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3590,
        GIR_Done,
      // Label 865: @38450
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(38568), // Rule ID 3592 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9637:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3592,
        GIR_Done,
      // Label 866: @38568
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(38686), // Rule ID 3593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9636:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3593,
        GIR_Done,
      // Label 867: @38686
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(38804), // Rule ID 3594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9635:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3594,
        GIR_Done,
      // Label 868: @38804
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(38922), // Rule ID 3595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9634:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3595,
        GIR_Done,
      // Label 869: @38922
      GIM_Reject,
    // Label 841: @38923
    GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(42988),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/8,
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(39087), // Rule ID 3547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9643:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3547,
        GIR_Done,
      // Label 871: @39087
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(39243), // Rule ID 3549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9645:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3549,
        GIR_Done,
      // Label 872: @39243
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(39399), // Rule ID 3551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9641:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2SPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3551,
        GIR_Done,
      // Label 873: @39399
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(39555), // Rule ID 3553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9627:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3553,
        GIR_Done,
      // Label 874: @39555
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(39711), // Rule ID 3554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9626:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2PN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3554,
        GIR_Done,
      // Label 875: @39711
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(39867), // Rule ID 3555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9625:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2NP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3555,
        GIR_Done,
      // Label 876: @39867
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(40023), // Rule ID 3556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9624:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2NN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3556,
        GIR_Done,
      // Label 877: @40023
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(40179), // Rule ID 3568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9622:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3568,
        GIR_Done,
      // Label 878: @40179
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(40335), // Rule ID 3569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9621:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2PN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3569,
        GIR_Done,
      // Label 879: @40335
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(40491), // Rule ID 3570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9620:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2NP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3570,
        GIR_Done,
      // Label 880: @40491
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(40647), // Rule ID 3571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9619:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2NN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3571,
        GIR_Done,
      // Label 881: @40647
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(40803), // Rule ID 3573 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9646:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI8GER4SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4SPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3573,
        GIR_Done,
      // Label 882: @40803
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(40959), // Rule ID 3574 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9639:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2PP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3574,
        GIR_Done,
      // Label 883: @40959
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(41115), // Rule ID 3576 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9643:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3576,
        GIR_Done,
      // Label 884: @41115
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(41271), // Rule ID 3578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9645:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3578,
        GIR_Done,
      // Label 885: @41271
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(41427), // Rule ID 3580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9641:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2SWPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3580,
        GIR_Done,
      // Label 886: @41427
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(41583), // Rule ID 3582 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9627:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3582,
        GIR_Done,
      // Label 887: @41583
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(41739), // Rule ID 3583 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9626:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3583,
        GIR_Done,
      // Label 888: @41739
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(41895), // Rule ID 3584 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9625:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3584,
        GIR_Done,
      // Label 889: @41895
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(42051), // Rule ID 3585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9624:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3585,
        GIR_Done,
      // Label 890: @42051
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(42207), // Rule ID 3597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9622:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WPP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3597,
        GIR_Done,
      // Label 891: @42207
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(42363), // Rule ID 3598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9621:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WPN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3598,
        GIR_Done,
      // Label 892: @42363
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(42519), // Rule ID 3599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2np),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9620:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WNP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3599,
        GIR_Done,
      // Label 893: @42519
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(42675), // Rule ID 3600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2nn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9619:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WNN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[AT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3600,
        GIR_Done,
      // Label 894: @42675
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(42831), // Rule ID 3602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4spp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9646:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI8GER4WSPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
 