/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: RISCV.td                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands,
                       const SmallBitVector &OptionalOperandsMask);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_InvalidBareSymbol,
  Match_InvalidCLUIImm,
  Match_InvalidCSRSystemRegister,
  Match_InvalidCallSymbol,
  Match_InvalidImmXLenLI,
  Match_InvalidImmXLenLI_Restricted,
  Match_InvalidImmZero,
  Match_InvalidLoadFPImm,
  Match_InvalidPseudoJumpSymbol,
  Match_InvalidRTZArg,
  Match_InvalidRegReg,
  Match_InvalidRlist,
  Match_InvalidRnumArg,
  Match_InvalidSImm10Lsb0000NonZero,
  Match_InvalidSImm12,
  Match_InvalidSImm12Lsb0,
  Match_InvalidSImm12Lsb00000,
  Match_InvalidSImm13Lsb0,
  Match_InvalidSImm21Lsb0JAL,
  Match_InvalidSImm5,
  Match_InvalidSImm5Plus1,
  Match_InvalidSImm6,
  Match_InvalidSImm6NonZero,
  Match_InvalidSImm9Lsb0,
  Match_InvalidSpimm,
  Match_InvalidTLSDESCCallSymbol,
  Match_InvalidTPRelAddSymbol,
  Match_InvalidUImm1,
  Match_InvalidUImm10Lsb00NonZero,
  Match_InvalidUImm2,
  Match_InvalidUImm20,
  Match_InvalidUImm20AUIPC,
  Match_InvalidUImm20LUI,
  Match_InvalidUImm2Lsb0,
  Match_InvalidUImm3,
  Match_InvalidUImm4,
  Match_InvalidUImm5,
  Match_InvalidUImm6,
  Match_InvalidUImm7,
  Match_InvalidUImm7Lsb00,
  Match_InvalidUImm8,
  Match_InvalidUImm8GE32,
  Match_InvalidUImm8Lsb00,
  Match_InvalidUImm8Lsb000,
  Match_InvalidUImm9Lsb000,
  Match_InvalidUImmLog2XLen,
  Match_InvalidUImmLog2XLenHalf,
  Match_InvalidUImmLog2XLenNonZero,
  Match_InvalidVMaskRegister,
  Match_InvalidVTypeI,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtIBit = 10,
  Feature_HasStdExtZicbomBit = 38,
  Feature_HasStdExtZicbopBit = 39,
  Feature_HasStdExtZicbozBit = 40,
  Feature_HasStdExtZicsrBit = 44,
  Feature_HasStdExtZicondBit = 43,
  Feature_HasStdExtZifenceiBit = 45,
  Feature_HasStdExtZihintpauseBit = 47,
  Feature_HasStdExtZihintntlBit = 46,
  Feature_HasStdExtZimopBit = 48,
  Feature_HasStdExtZicfilpBit = 41,
  Feature_HasStdExtZicfissBit = 42,
  Feature_HasStdExtMBit = 11,
  Feature_HasStdExtMOrZmmulBit = 12,
  Feature_HasStdExtABit = 2,
  Feature_HasStdExtZtsoBit = 56,
  Feature_HasStdExtZacasBit = 14,
  Feature_HasStdExtZawrsBit = 15,
  Feature_HasStdExtFBit = 8,
  Feature_HasStdExtDBit = 7,
  Feature_HasStdExtZfhminBit = 34,
  Feature_HasStdExtZfhBit = 32,
  Feature_HasStdExtZfbfminBit = 31,
  Feature_HasHalfFPLoadStoreMoveBit = 0,
  Feature_HasStdExtZfaBit = 30,
  Feature_HasStdExtZfinxBit = 35,
  Feature_HasStdExtZdinxBit = 29,
  Feature_HasStdExtZhinxminBit = 37,
  Feature_HasStdExtZhinxBit = 36,
  Feature_HasStdExtCBit = 3,
  Feature_HasRVCHintsBit = 1,
  Feature_HasStdExtCOrZcaBit = 4,
  Feature_HasStdExtZcbBit = 25,
  Feature_HasStdExtCOrZcdBit = 5,
  Feature_HasStdExtZcmpBit = 27,
  Feature_HasStdExtZcmtBit = 28,
  Feature_HasStdExtCOrZcfOrZceBit = 6,
  Feature_HasStdExtZcmopBit = 26,
  Feature_HasStdExtZbaBit = 16,
  Feature_HasStdExtZbbBit = 17,
  Feature_HasStdExtZbcBit = 19,
  Feature_HasStdExtZbsBit = 24,
  Feature_HasStdExtZbkbBit = 21,
  Feature_HasStdExtZbkxBit = 23,
  Feature_HasStdExtZbbOrZbkbBit = 18,
  Feature_HasStdExtZbkcBit = 22,
  Feature_HasStdExtZbcOrZbkcBit = 20,
  Feature_HasStdExtZkndBit = 49,
  Feature_HasStdExtZkneBit = 51,
  Feature_HasStdExtZkndOrZkneBit = 50,
  Feature_HasStdExtZknhBit = 52,
  Feature_HasStdExtZksedBit = 54,
  Feature_HasStdExtZkshBit = 55,
  Feature_HasStdExtZkrBit = 53,
  Feature_HasStdExtZvfbfminBit = 59,
  Feature_HasStdExtZvfbfwmaBit = 60,
  Feature_HasStdExtZfhOrZvfhBit = 33,
  Feature_HasStdExtZvkbBit = 61,
  Feature_HasStdExtZvbbBit = 57,
  Feature_HasStdExtZvbcBit = 58,
  Feature_HasStdExtZvkgBit = 62,
  Feature_HasStdExtZvknedBit = 63,
  Feature_HasStdExtZvknhaBit = 64,
  Feature_HasStdExtZvknhbBit = 66,
  Feature_HasStdExtZvknhaOrZvknhbBit = 65,
  Feature_HasStdExtZvksedBit = 67,
  Feature_HasStdExtZvkshBit = 68,
  Feature_HasVInstructionsBit = 69,
  Feature_HasVInstructionsI64Bit = 72,
  Feature_HasVInstructionsAnyFBit = 70,
  Feature_HasVInstructionsF16MinimalBit = 71,
  Feature_HasStdExtHBit = 9,
  Feature_HasStdExtSvinvalBit = 13,
  Feature_HasVendorXVentanaCondOpsBit = 96,
  Feature_HasVendorXTHeadBaBit = 85,
  Feature_HasVendorXTHeadBbBit = 86,
  Feature_HasVendorXTHeadBsBit = 87,
  Feature_HasVendorXTHeadCondMovBit = 89,
  Feature_HasVendorXTHeadCmoBit = 88,
  Feature_HasVendorXTHeadFMemIdxBit = 90,
  Feature_HasVendorXTHeadMacBit = 91,
  Feature_HasVendorXTHeadMemIdxBit = 92,
  Feature_HasVendorXTHeadMemPairBit = 93,
  Feature_HasVendorXTHeadSyncBit = 94,
  Feature_HasVendorXTHeadVdotBit = 95,
  Feature_HasVendorXSfvcpBit = 80,
  Feature_HasVendorXSfvqmaccdodBit = 83,
  Feature_HasVendorXSfvqmaccqoqBit = 84,
  Feature_HasVendorXSfvfwmaccqqqBit = 82,
  Feature_HasVendorXSfvfnrclipxfqfBit = 81,
  Feature_HasVendorXCVelwBit = 76,
  Feature_HasVendorXCVbitmanipBit = 75,
  Feature_HasVendorXCVmacBit = 77,
  Feature_HasVendorXCVmemBit = 78,
  Feature_HasVendorXCValuBit = 73,
  Feature_HasVendorXCVsimdBit = 79,
  Feature_HasVendorXCVbiBit = 74,
  Feature_IsRV64Bit = 98,
  Feature_IsRV32Bit = 97,
  Feature_IsRVEBit = 99,
};

static unsigned MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 1 string to match.
    if (Name[0] != '0')
      break;
    return 9;	 // "0"
  case 2:	 // 66 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 30 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 3 strings to match.
        return 74;	 // "f0"
      case '1':	 // 3 strings to match.
        return 75;	 // "f1"
      case '2':	 // 3 strings to match.
        return 76;	 // "f2"
      case '3':	 // 3 strings to match.
        return 77;	 // "f3"
      case '4':	 // 3 strings to match.
        return 78;	 // "f4"
      case '5':	 // 3 strings to match.
        return 79;	 // "f5"
      case '6':	 // 3 strings to match.
        return 80;	 // "f6"
      case '7':	 // 3 strings to match.
        return 81;	 // "f7"
      case '8':	 // 3 strings to match.
        return 82;	 // "f8"
      case '9':	 // 3 strings to match.
        return 83;	 // "f9"
      }
      break;
    case 'v':	 // 21 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return 10;	 // "v0"
      case '1':	 // 1 string to match.
        return 11;	 // "v1"
      case '2':	 // 2 strings to match.
        return 12;	 // "v2"
      case '3':	 // 1 string to match.
        return 13;	 // "v3"
      case '4':	 // 3 strings to match.
        return 14;	 // "v4"
      case '5':	 // 1 string to match.
        return 15;	 // "v5"
      case '6':	 // 2 strings to match.
        return 16;	 // "v6"
      case '7':	 // 1 string to match.
        return 17;	 // "v7"
      case '8':	 // 4 strings to match.
        return 18;	 // "v8"
      case '9':	 // 1 string to match.
        return 19;	 // "v9"
      case 'l':	 // 1 string to match.
        return 4;	 // "vl"
      }
      break;
    case 'x':	 // 15 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 42;	 // "x0"
      case '1':	 // 1 string to match.
        return 43;	 // "x1"
      case '2':	 // 2 strings to match.
        return 44;	 // "x2"
      case '3':	 // 1 string to match.
        return 45;	 // "x3"
      case '4':	 // 2 strings to match.
        return 46;	 // "x4"
      case '5':	 // 1 string to match.
        return 47;	 // "x5"
      case '6':	 // 2 strings to match.
        return 48;	 // "x6"
      case '7':	 // 1 string to match.
        return 49;	 // "x7"
      case '8':	 // 2 strings to match.
        return 50;	 // "x8"
      case '9':	 // 1 string to match.
        return 51;	 // "x9"
      }
      break;
    }
    break;
  case 3:	 // 141 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 67 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 84;	 // "f10"
        case '1':	 // 3 strings to match.
          return 85;	 // "f11"
        case '2':	 // 3 strings to match.
          return 86;	 // "f12"
        case '3':	 // 3 strings to match.
          return 87;	 // "f13"
        case '4':	 // 3 strings to match.
          return 88;	 // "f14"
        case '5':	 // 3 strings to match.
          return 89;	 // "f15"
        case '6':	 // 3 strings to match.
          return 90;	 // "f16"
        case '7':	 // 3 strings to match.
          return 91;	 // "f17"
        case '8':	 // 3 strings to match.
          return 92;	 // "f18"
        case '9':	 // 3 strings to match.
          return 93;	 // "f19"
        }
        break;
      case '2':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 94;	 // "f20"
        case '1':	 // 3 strings to match.
          return 95;	 // "f21"
        case '2':	 // 3 strings to match.
          return 96;	 // "f22"
        case '3':	 // 3 strings to match.
          return 97;	 // "f23"
        case '4':	 // 3 strings to match.
          return 98;	 // "f24"
        case '5':	 // 3 strings to match.
          return 99;	 // "f25"
        case '6':	 // 3 strings to match.
          return 100;	 // "f26"
        case '7':	 // 3 strings to match.
          return 101;	 // "f27"
        case '8':	 // 3 strings to match.
          return 102;	 // "f28"
        case '9':	 // 3 strings to match.
          return 103;	 // "f29"
        }
        break;
      case '3':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 104;	 // "f30"
        case '1':	 // 3 strings to match.
          return 105;	 // "f31"
        }
        break;
      case 'r':	 // 1 string to match.
        if (Name[2] != 'm')
          break;
        return 2;	 // "frm"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "sp", 2) != 0)
        break;
      return 3;	 // "ssp"
    case 'v':	 // 40 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 18 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 20;	 // "v10"
        case '1':	 // 1 string to match.
          return 21;	 // "v11"
        case '2':	 // 3 strings to match.
          return 22;	 // "v12"
        case '3':	 // 1 string to match.
          return 23;	 // "v13"
        case '4':	 // 2 strings to match.
          return 24;	 // "v14"
        case '5':	 // 1 string to match.
          return 25;	 // "v15"
        case '6':	 // 4 strings to match.
          return 26;	 // "v16"
        case '7':	 // 1 string to match.
          return 27;	 // "v17"
        case '8':	 // 2 strings to match.
          return 28;	 // "v18"
        case '9':	 // 1 string to match.
          return 29;	 // "v19"
        }
        break;
      case '2':	 // 19 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 30;	 // "v20"
        case '1':	 // 1 string to match.
          return 31;	 // "v21"
        case '2':	 // 2 strings to match.
          return 32;	 // "v22"
        case '3':	 // 1 string to match.
          return 33;	 // "v23"
        case '4':	 // 4 strings to match.
          return 34;	 // "v24"
        case '5':	 // 1 string to match.
          return 35;	 // "v25"
        case '6':	 // 2 strings to match.
          return 36;	 // "v26"
        case '7':	 // 1 string to match.
          return 37;	 // "v27"
        case '8':	 // 3 strings to match.
          return 38;	 // "v28"
        case '9':	 // 1 string to match.
          return 39;	 // "v29"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 40;	 // "v30"
        case '1':	 // 1 string to match.
          return 41;	 // "v31"
        }
        break;
      }
      break;
    case 'x':	 // 33 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 52;	 // "x10"
        case '1':	 // 1 string to match.
          return 53;	 // "x11"
        case '2':	 // 2 strings to match.
          return 54;	 // "x12"
        case '3':	 // 1 string to match.
          return 55;	 // "x13"
        case '4':	 // 2 strings to match.
          return 56;	 // "x14"
        case '5':	 // 1 string to match.
          return 57;	 // "x15"
        case '6':	 // 2 strings to match.
          return 58;	 // "x16"
        case '7':	 // 1 string to match.
          return 59;	 // "x17"
        case '8':	 // 2 strings to match.
          return 60;	 // "x18"
        case '9':	 // 1 string to match.
          return 61;	 // "x19"
        }
        break;
      case '2':	 // 15 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 62;	 // "x20"
        case '1':	 // 1 string to match.
          return 63;	 // "x21"
        case '2':	 // 2 strings to match.
          return 64;	 // "x22"
        case '3':	 // 1 string to match.
          return 65;	 // "x23"
        case '4':	 // 2 strings to match.
          return 66;	 // "x24"
        case '5':	 // 1 string to match.
          return 67;	 // "x25"
        case '6':	 // 2 strings to match.
          return 68;	 // "x26"
        case '7':	 // 1 string to match.
          return 69;	 // "x27"
        case '8':	 // 2 strings to match.
          return 70;	 // "x28"
        case '9':	 // 1 string to match.
          return 71;	 // "x29"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 2 strings to match.
          return 72;	 // "x30"
        case '1':	 // 1 string to match.
          return 73;	 // "x31"
        }
        break;
      }
      break;
    }
    break;
  case 4:	 // 1 string to match.
    if (memcmp(Name.data()+0, "vxrm", 4) != 0)
      break;
    return 7;	 // "vxrm"
  case 5:	 // 3 strings to match.
    if (Name[0] != 'v')
      break;
    switch (Name[1]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(Name.data()+2, "enb", 3) != 0)
        break;
      return 5;	 // "vlenb"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+2, "ype", 3) != 0)
        break;
      return 6;	 // "vtype"
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+2, "sat", 3) != 0)
        break;
      return 8;	 // "vxsat"
    }
    break;
  case 6:	 // 1 string to match.
    if (memcmp(Name.data()+0, "fflags", 6) != 0)
      break;
    return 1;	 // "fflags"
  }
  return 0;
}

static unsigned MatchRegisterAltName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 45 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 52;	 // "a0"
      case '1':	 // 1 string to match.
        return 53;	 // "a1"
      case '2':	 // 2 strings to match.
        return 54;	 // "a2"
      case '3':	 // 1 string to match.
        return 55;	 // "a3"
      case '4':	 // 2 strings to match.
        return 56;	 // "a4"
      case '5':	 // 1 string to match.
        return 57;	 // "a5"
      case '6':	 // 2 strings to match.
        return 58;	 // "a6"
      case '7':	 // 1 string to match.
        return 59;	 // "a7"
      }
      break;
    case 'f':	 // 2 strings to match.
      if (Name[1] != 'p')
        break;
      return 50;	 // "fp"
    case 'g':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return 45;	 // "gp"
    case 'r':	 // 1 string to match.
      if (Name[1] != 'a')
        break;
      return 43;	 // "ra"
    case 's':	 // 17 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 50;	 // "s0"
      case '1':	 // 1 string to match.
        return 51;	 // "s1"
      case '2':	 // 2 strings to match.
        return 60;	 // "s2"
      case '3':	 // 1 string to match.
        return 61;	 // "s3"
      case '4':	 // 2 strings to match.
        return 62;	 // "s4"
      case '5':	 // 1 string to match.
        return 63;	 // "s5"
      case '6':	 // 2 strings to match.
        return 64;	 // "s6"
      case '7':	 // 1 string to match.
        return 65;	 // "s7"
      case '8':	 // 2 strings to match.
        return 66;	 // "s8"
      case '9':	 // 1 string to match.
        return 67;	 // "s9"
      case 'p':	 // 2 strings to match.
        return 44;	 // "sp"
      }
      break;
    case 't':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 47;	 // "t0"
      case '1':	 // 2 strings to match.
        return 48;	 // "t1"
      case '2':	 // 1 string to match.
        return 49;	 // "t2"
      case '3':	 // 2 strings to match.
        return 70;	 // "t3"
      case '4':	 // 1 string to match.
        return 71;	 // "t4"
      case '5':	 // 2 strings to match.
        return 72;	 // "t5"
      case '6':	 // 1 string to match.
        return 73;	 // "t6"
      case 'p':	 // 2 strings to match.
        return 46;	 // "tp"
      }
      break;
    }
    break;
  case 3:	 // 87 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 84 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 24 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 84;	 // "fa0"
        case '1':	 // 3 strings to match.
          return 85;	 // "fa1"
        case '2':	 // 3 strings to match.
          return 86;	 // "fa2"
        case '3':	 // 3 strings to match.
          return 87;	 // "fa3"
        case '4':	 // 3 strings to match.
          return 88;	 // "fa4"
        case '5':	 // 3 strings to match.
          return 89;	 // "fa5"
        case '6':	 // 3 strings to match.
          return 90;	 // "fa6"
        case '7':	 // 3 strings to match.
          return 91;	 // "fa7"
        }
        break;
      case 's':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 82;	 // "fs0"
        case '1':	 // 3 strings to match.
          return 83;	 // "fs1"
        case '2':	 // 3 strings to match.
          return 92;	 // "fs2"
        case '3':	 // 3 strings to match.
          return 93;	 // "fs3"
        case '4':	 // 3 strings to match.
          return 94;	 // "fs4"
        case '5':	 // 3 strings to match.
          return 95;	 // "fs5"
        case '6':	 // 3 strings to match.
          return 96;	 // "fs6"
        case '7':	 // 3 strings to match.
          return 97;	 // "fs7"
        case '8':	 // 3 strings to match.
          return 98;	 // "fs8"
        case '9':	 // 3 strings to match.
          return 99;	 // "fs9"
        }
        break;
      case 't':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 74;	 // "ft0"
        case '1':	 // 3 strings to match.
          return 75;	 // "ft1"
        case '2':	 // 3 strings to match.
          return 76;	 // "ft2"
        case '3':	 // 3 strings to match.
          return 77;	 // "ft3"
        case '4':	 // 3 strings to match.
          return 78;	 // "ft4"
        case '5':	 // 3 strings to match.
          return 79;	 // "ft5"
        case '6':	 // 3 strings to match.
          return 80;	 // "ft6"
        case '7':	 // 3 strings to match.
          return 81;	 // "ft7"
        case '8':	 // 3 strings to match.
          return 102;	 // "ft8"
        case '9':	 // 3 strings to match.
          return 103;	 // "ft9"
        }
        break;
      }
      break;
    case 's':	 // 3 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 2 strings to match.
        return 68;	 // "s10"
      case '1':	 // 1 string to match.
        return 69;	 // "s11"
      }
      break;
    }
    break;
  case 4:	 // 14 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case 's':	 // 6 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 100;	 // "fs10"
        case '1':	 // 3 strings to match.
          return 101;	 // "fs11"
        }
        break;
      case 't':	 // 6 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 3 strings to match.
          return 104;	 // "ft10"
        case '1':	 // 3 strings to match.
          return 105;	 // "ft11"
        }
        break;
      }
      break;
    case 'z':	 // 2 strings to match.
      if (memcmp(Name.data()+1, "ero", 3) != 0)
        break;
      return 42;	 // "zero"
    }
    break;
  }
  return 0;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_HasStdExtIBit: return "'I' (Base Integer Instruction Set)";
  case Feature_HasStdExtZicbomBit: return "'Zicbom' (Cache-Block Management Instructions)";
  case Feature_HasStdExtZicbopBit: return "'Zicbop' (Cache-Block Prefetch Instructions)";
  case Feature_HasStdExtZicbozBit: return "'Zicboz' (Cache-Block Zero Instructions)";
  case Feature_HasStdExtZicsrBit: return "'Zicsr' (CSRs)";
  case Feature_HasStdExtZicondBit: return "'Zicond' (Integer Conditional Operations)";
  case Feature_HasStdExtZifenceiBit: return "'Zifencei' (fence.i)";
  case Feature_HasStdExtZihintpauseBit: return "'Zihintpause' (Pause Hint)";
  case Feature_HasStdExtZihintntlBit: return "'Zihintntl' (Non-Temporal Locality Hints)";
  case Feature_HasStdExtZimopBit: return "'Zimop' (May-Be-Operations)";
  case Feature_HasStdExtZicfilpBit: return "'Zicfilp' (Landing pad)";
  case Feature_HasStdExtZicfissBit: return "'Zicfiss' (Shadow stack)";
  case Feature_HasStdExtMBit: return "'M' (Integer Multiplication and Division)";
  case Feature_HasStdExtMOrZmmulBit: return "'M' (Integer Multiplication and Division) or 'Zmmul' (Integer Multiplication)";
  case Feature_HasStdExtABit: return "'A' (Atomic Instructions)";
  case Feature_HasStdExtZtsoBit: return "'Ztso' (Memory Model - Total Store Order)";
  case Feature_HasStdExtZacasBit: return "'Zacas' (Atomic Compare-And-Swap Instructions)";
  case Feature_HasStdExtZawrsBit: return "'Zawrs' (Wait on Reservation Set)";
  case Feature_HasStdExtFBit: return "'F' (Single-Precision Floating-Point)";
  case Feature_HasStdExtDBit: return "'D' (Double-Precision Floating-Point)";
  case Feature_HasStdExtZfhminBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal)";
  case Feature_HasStdExtZfhBit: return "'Zfh' (Half-Precision Floating-Point)";
  case Feature_HasStdExtZfbfminBit: return "'Zfbfmin' (Scalar BF16 Converts)";
  case Feature_HasHalfFPLoadStoreMoveBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal) or 'Zfbfmin' (Scalar BF16 Converts)";
  case Feature_HasStdExtZfaBit: return "'Zfa' (Additional Floating-Point)";
  case Feature_HasStdExtZfinxBit: return "'Zfinx' (Float in Integer)";
  case Feature_HasStdExtZdinxBit: return "'Zdinx' (Double in Integer)";
  case Feature_HasStdExtZhinxminBit: return "'Zhinx' (Half Float in Integer) or 'Zhinxmin' (Half Float in Integer Minimal)";
  case Feature_HasStdExtZhinxBit: return "'Zhinx' (Half Float in Integer)";
  case Feature_HasStdExtCBit: return "'C' (Compressed Instructions)";
  case Feature_HasRVCHintsBit: return "RVC Hint Instructions";
  case Feature_HasStdExtCOrZcaBit: return "'C' (Compressed Instructions) or 'Zca' (part of the C extension, excluding compressed floating point loads/stores)";
  case Feature_HasStdExtZcbBit: return "'Zcb' (Compressed basic bit manipulation instructions)";
  case Feature_HasStdExtCOrZcdBit: return "'C' (Compressed Instructions) or 'Zcd' (Compressed Double-Precision Floating-Point Instructions)";
  case Feature_HasStdExtZcmpBit: return "'Zcmp' (sequenced instuctions for code-size reduction)";
  case Feature_HasStdExtZcmtBit: return "'Zcmt' (table jump instuctions for code-size reduction)";
  case Feature_HasStdExtCOrZcfOrZceBit: return "'C' (Compressed Instructions) or 'Zcf' (Compressed Single-Precision Floating-Point Instructions)";
  case Feature_HasStdExtZcmopBit: return "'Zcmop' (Compressed May-Be-Operations)";
  case Feature_HasStdExtZbaBit: return "'Zba' (Address Generation Instructions)";
  case Feature_HasStdExtZbbBit: return "'Zbb' (Basic Bit-Manipulation)";
  case Feature_HasStdExtZbcBit: return "'Zbc' (Carry-Less Multiplication)";
  case Feature_HasStdExtZbsBit: return "'Zbs' (Single-Bit Instructions)";
  case Feature_HasStdExtZbkbBit: return "'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_HasStdExtZbkxBit: return "'Zbkx' (Crossbar permutation instructions)";
  case Feature_HasStdExtZbbOrZbkbBit: return "'Zbb' (Basic Bit-Manipulation) or 'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_HasStdExtZbkcBit: return "'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZbcOrZbkcBit: return "'Zbc' (Carry-Less Multiplication) or 'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZkndBit: return "'Zknd' (NIST Suite: AES Decryption)";
  case Feature_HasStdExtZkneBit: return "'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZkndOrZkneBit: return "'Zknd' (NIST Suite: AES Decryption) or 'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZknhBit: return "'Zknh' (NIST Suite: Hash Function Instructions)";
  case Feature_HasStdExtZksedBit: return "'Zksed' (ShangMi Suite: SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZkshBit: return "'Zksh' (ShangMi Suite: SM3 Hash Function Instructions)";
  case Feature_HasStdExtZkrBit: return "'Zkr' (Entropy Source Extension)";
  case Feature_HasStdExtZvfbfminBit: return "'Zvfbfmin' (Vector BF16 Converts)";
  case Feature_HasStdExtZvfbfwmaBit: return "'Zvfbfwma' (Vector BF16 widening mul-add)";
  case Feature_HasStdExtZfhOrZvfhBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zvfh' (Vector Half-Precision Floating-Point)";
  case Feature_HasStdExtZvkbBit: return "'Zvkb' (Vector Bit-manipulation used in Cryptography)";
  case Feature_HasStdExtZvbbBit: return "'Zvbb' (Vector basic bit-manipulation instructions)";
  case Feature_HasStdExtZvbcBit: return "'Zvbc' (Vector Carryless Multiplication)";
  case Feature_HasStdExtZvkgBit: return "'Zvkg' (Vector GCM instructions for Cryptography)";
  case Feature_HasStdExtZvknedBit: return "'Zvkned' (Vector AES Encryption & Decryption (Single Round))";
  case Feature_HasStdExtZvknhaBit: return "'Zvknha' (Vector SHA-2 (SHA-256 only))";
  case Feature_HasStdExtZvknhbBit: return "'Zvknhb' (Vector SHA-2 (SHA-256 and SHA-512))";
  case Feature_HasStdExtZvknhaOrZvknhbBit: return "'Zvknha' or 'Zvknhb' (Vector SHA-2)";
  case Feature_HasStdExtZvksedBit: return "'Zvksed' (SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZvkshBit: return "'Zvksh' (SM3 Hash Function Instructions)";
  case Feature_HasVInstructionsBit: return "'V' (Vector Extension for Application Processors), 'Zve32x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsI64Bit: return "'V' (Vector Extension for Application Processors) or 'Zve64x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsAnyFBit: return "'V' (Vector Extension for Application Processors), 'Zve32f' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsF16MinimalBit: return "'Zvfhmin' (Vector Half-Precision Floating-Point Minimal) or 'Zvfh' (Vector Half-Precision Floating-Point)";
  case Feature_HasStdExtHBit: return "'H' (Hypervisor)";
  case Feature_HasStdExtSvinvalBit: return "'Svinval' (Fine-Grained Address-Translation Cache Invalidation)";
  case Feature_HasVendorXVentanaCondOpsBit: return "'XVentanaCondOps' (Ventana Conditional Ops)";
  case Feature_HasVendorXTHeadBaBit: return "'xtheadba' (T-Head address calculation instructions)";
  case Feature_HasVendorXTHeadBbBit: return "'xtheadbb' (T-Head basic bit-manipulation instructions)";
  case Feature_HasVendorXTHeadBsBit: return "'xtheadbs' (T-Head single-bit instructions)";
  case Feature_HasVendorXTHeadCondMovBit: return "'xtheadcondmov' (T-Head conditional move instructions)";
  case Feature_HasVendorXTHeadCmoBit: return "'xtheadcmo' (T-Head cache management instructions)";
  case Feature_HasVendorXTHeadFMemIdxBit: return "'xtheadfmemidx' (T-Head FP Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMacBit: return "'xtheadmac' (T-Head Multiply-Accumulate Instructions)";
  case Feature_HasVendorXTHeadMemIdxBit: return "'xtheadmemidx' (T-Head Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMemPairBit: return "'xtheadmempair' (T-Head two-GPR Memory Operations)";
  case Feature_HasVendorXTHeadSyncBit: return "'xtheadsync' (T-Head multicore synchronization instructions)";
  case Feature_HasVendorXTHeadVdotBit: return "'xtheadvdot' (T-Head Vector Extensions for Dot)";
  case Feature_HasVendorXSfvcpBit: return "'XSfvcp' (SiFive Custom Vector Coprocessor Interface Instructions)";
  case Feature_HasVendorXSfvqmaccdodBit: return "'XSfvqmaccdod' (SiFive Int8 Matrix Multiplication Instructions (2-by-8 and 8-by-2))";
  case Feature_HasVendorXSfvqmaccqoqBit: return "'XSfvqmaccqoq' (SiFive Int8 Matrix Multiplication Instructions (4-by-8 and 8-by-4))";
  case Feature_HasVendorXSfvfwmaccqqqBit: return "'XSfvfwmaccqqq' (SiFive Matrix Multiply Accumulate Instruction and 4-by-4))";
  case Feature_HasVendorXSfvfnrclipxfqfBit: return "'XSfvfnrclipxfqf' (SiFive FP32-to-int8 Ranged Clip Instructions)";
  case Feature_HasVendorXCVelwBit: return "'XCVelw' (CORE-V Event Load Word)";
  case Feature_HasVendorXCVbitmanipBit: return "'XCVbitmanip' (CORE-V Bit Manipulation)";
  case Feature_HasVendorXCVmacBit: return "'XCVmac' (CORE-V Multiply-Accumulate)";
  case Feature_HasVendorXCVmemBit: return "'XCVmem' (CORE-V Post-incrementing Load & Store)";
  case Feature_HasVendorXCValuBit: return "'XCValu' (CORE-V ALU Operations)";
  case Feature_HasVendorXCVsimdBit: return "'XCVsimd' (CORE-V SIMD ALU)";
  case Feature_HasVendorXCVbiBit: return "'XCVbi' (CORE-V Immediate Branching)";
  case Feature_IsRV64Bit: return "RV64I Base Instruction Set";
  case Feature_IsRV32Bit: return "RV32I Base Instruction Set";
  case Feature_IsRVEBit: return "";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "move", 4) != 0)
          break;
        Mnemonic = "mv";	 // "move"
        return;
      case 5:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "scall", 5) != 0)
          break;
        Mnemonic = "ecall";	 // "scall"
        return;
      case 6:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "sbreak", 6) != 0)
          break;
        Mnemonic = "ebreak";	 // "sbreak"
        return;
      case 7:	 // 2 strings to match.
        if (memcmp(Mnemonic.data()+0, "fmv.", 4) != 0)
          break;
        switch (Mnemonic[4]) {
        default: break;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, ".x", 2) != 0)
            break;
          if (Features.test(Feature_HasStdExtFBit))	 // "fmv.s.x"
            Mnemonic = "fmv.w.x";
          return;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+5, ".s", 2) != 0)
            break;
          if (Features.test(Feature_HasStdExtFBit))	 // "fmv.x.s"
            Mnemonic = "fmv.x.w";
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 4:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "move", 4) != 0)
      break;
    Mnemonic = "mv";	 // "move"
    return;
  case 5:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "scall", 5) != 0)
      break;
    Mnemonic = "ecall";	 // "scall"
    return;
  case 6:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "sbreak", 6) != 0)
      break;
    Mnemonic = "ebreak";	 // "sbreak"
    return;
  case 7:	 // 2 strings to match.
    if (memcmp(Mnemonic.data()+0, "fmv.", 4) != 0)
      break;
    switch (Mnemonic[4]) {
    default: break;
    case 's':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, ".x", 2) != 0)
        break;
      if (Features.test(Feature_HasStdExtFBit))	 // "fmv.s.x"
        Mnemonic = "fmv.w.x";
      return;
    case 'x':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, ".s", 2) != 0)
        break;
      if (Features.test(Feature_HasStdExtFBit))	 // "fmv.x.s"
        Mnemonic = "fmv.x.w";
      return;
    }
    break;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie1_3_3,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie1_3_3 */ { 1, 3, 3 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_addImmOperands,
  CVT_95_addRegOperands,
  CVT_95_Reg,
  CVT_regX0,
  CVT_imm_95_0,
  CVT_regX5,
  CVT_regX2,
  CVT_regX3,
  CVT_regX4,
  CVT_95_addRlistOperands,
  CVT_95_addSpimmOperands,
  CVT_95_addCSRSystemRegisterOperands,
  CVT_95_addRegRegOperands,
  CVT_95_addFRMArgOperands_95_defaultFRMArgOp,
  CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp,
  CVT_95_addFRMArgOperands,
  CVT_imm_95_15,
  CVT_95_addFenceArgOperands,
  CVT_95_addFPImmOperands,
  CVT_imm_95_3,
  CVT_imm_95_1,
  CVT_imm_95_2,
  CVT_regX1,
  CVT_imm_95__MINUS_1,
  CVT_imm_95_3072,
  CVT_imm_95_3200,
  CVT_imm_95_3074,
  CVT_imm_95_3202,
  CVT_imm_95_3073,
  CVT_imm_95_3201,
  CVT_95_addRegOperands_95_defaultMaskRegOp,
  CVT_reg0,
  CVT_95_addVTypeIOperands,
  CVT_imm_95_255,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4,
  Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3,
  Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__SImm121_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Reg1_1__RnumArg1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1,
  Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1,
  Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1,
  Convert__Reg1_0__UImm20AUIPC1_1,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2,
  Convert__Reg1_0__Reg1_1__SImm13Lsb01_2,
  Convert__Reg1_0__regX0__SImm13Lsb01_1,
  Convert__Reg1_1__Reg1_0__SImm13Lsb01_2,
  Convert__regX0__Reg1_0__SImm13Lsb01_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ImmZero1_1,
  Convert__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1,
  Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2,
  Convert__Reg1_0__Tie0_1_1__SImm61_1,
  Convert__Reg1_0__SImm9Lsb01_1,
  Convert_NoOperands,
  Convert__Reg1_0__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm7Lsb001_1,
  Convert__Reg1_0__Reg1_3__UImm8Lsb001_1,
  Convert__SImm12Lsb01_0,
  Convert__Reg1_0,
  Convert__Reg1_0__Reg1_3__UImm21_1,
  Convert__Reg1_0__Reg1_3__UImm2Lsb01_1,
  Convert__Reg1_0__SImm61_1,
  Convert__Reg1_0__CLUIImm1_1,
  Convert__SImm6NonZero1_0,
  Convert__Reg1_0__Tie0_1_1,
  Convert__regX0__Tie0_1_1__regX5,
  Convert__regX0__Tie0_1_1__regX2,
  Convert__regX0__Tie0_1_1__regX3,
  Convert__regX0__Tie0_1_1__regX4,
  Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1,
  Convert__CallSymbol1_0,
  Convert__Reg1_0__CallSymbol1_1,
  Convert__ZeroOffsetMemOpOperand1_0,
  Convert__UImm8GE321_0,
  Convert__UImm51_0,
  Convert__Rlist1_0__Spimm1_1,
  Convert__regX0__CSRSystemRegister1_0__Reg1_1,
  Convert__regX0__CSRSystemRegister1_0__UImm51_1,
  Convert__Reg1_0__CSRSystemRegister1_1__regX0,
  Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2,
  Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2,
  Convert__Reg1_0__Reg1_1__SImm61_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__UImm61_2,
  Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__SImm51_1__SImm13Lsb01_2,
  Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__UImm51_2,
  Convert__Reg1_0__Reg1_3__SImm121_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2,
  Convert__Reg1_0__RegReg1_1,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2,
  Convert__Reg1_0__Reg1_1__UImm31_2,
  Convert__Reg1_0__Reg1_1__UImm41_2,
  Convert__imm_95_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3,
  Convert__Reg1_0__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPairAsFPR1_1,
  Convert__Reg1_0__GPRAsFPR1_1,
  Convert__Reg1_0__Reg1_1__FRMArg1_2,
  Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2,
  Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2,
  Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__Reg1_1__RTZArg1_2,
  Convert__imm_95_15__imm_95_15,
  Convert__FenceArg1_0__FenceArg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2,
  Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2,
  Convert__Reg1_0__Reg1_2__Reg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1,
  Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1,
  Convert__Reg1_2__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__LoadFPImm1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2,
  Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2,
  Convert__Reg1_0__imm_95_3__regX0,
  Convert__Reg1_0__imm_95_1__regX0,
  Convert__Reg1_0__imm_95_2__regX0,
  Convert__regX0__imm_95_3__Reg1_0,
  Convert__Reg1_0__imm_95_3__Reg1_1,
  Convert__regX0__imm_95_1__Reg1_0,
  Convert__Reg1_0__imm_95_1__Reg1_1,
  Convert__regX0__imm_95_1__UImm51_0,
  Convert__Reg1_0__imm_95_1__UImm51_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__regX0__imm_95_2__Reg1_0,
  Convert__Reg1_0__imm_95_2__Reg1_1,
  Convert__regX0__imm_95_2__UImm51_0,
  Convert__Reg1_0__imm_95_2__UImm51_1,
  Convert__regX0__regX0,
  Convert__Reg1_0__regX0,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1,
  Convert__regX0__SImm21Lsb0JAL1_0,
  Convert__regX1__SImm21Lsb0JAL1_0,
  Convert__Reg1_0__SImm21Lsb0JAL1_1,
  Convert__regX1__Reg1_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95_0,
  Convert__regX1__Reg1_0__SImm121_1,
  Convert__regX1__Reg1_2__SImm121_0,
  Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5,
  Convert__regX0__Reg1_0__imm_95_0,
  Convert__regX0__Reg1_0__SImm121_1,
  Convert__regX0__Reg1_2__SImm121_0,
  Convert__Reg1_1__PseudoJumpSymbol1_0,
  Convert__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__ImmXLenLI_Restricted1_1,
  Convert__Reg1_0__regX0__SImm121_1,
  Convert__Reg1_0__ImmXLenLI1_1,
  Convert__regX0__UImm201_0,
  Convert__Reg1_0__UImm20LUI1_1,
  Convert__Reg1_0__regX0__Reg1_1,
  Convert__regX0__regX0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1,
  Convert__regX0__regX0__regX5,
  Convert__regX0__regX0__regX2,
  Convert__regX0__regX0__regX3,
  Convert__regX0__regX0__regX4,
  Convert__imm_95_1__imm_95_0,
  Convert__Reg1_2__SImm12Lsb000001_0,
  Convert__Reg1_0__imm_95_3072__regX0,
  Convert__Reg1_0__imm_95_3200__regX0,
  Convert__Reg1_0__imm_95_3074__regX0,
  Convert__Reg1_0__imm_95_3202__regX0,
  Convert__Reg1_0__imm_95_3073__regX0,
  Convert__Reg1_0__imm_95_3201__regX0,
  Convert__regX0__regX1__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95_1,
  Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__regX0,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__Reg1_1__reg0,
  Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__RVVMaskRegOpOperand1_1,
  Convert__Reg1_0__Reg1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2,
  Convert__Reg1_0__Reg1_0__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__SImm51_1,
  Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__regX0__reg0,
  Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__UImm51_1__VTypeI101_2,
  Convert__Reg1_0__Reg1_1__VTypeI111_2,
  Convert__Reg1_0__Reg1_1__imm_95_255,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][15] = {
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_95_addRegOperands, 7, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm121_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RnumArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__UImm20AUIPC1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__regX0__SImm13Lsb01_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_0__SImm13Lsb01_2
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__regX0__Reg1_0__SImm13Lsb01_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm61_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm9Lsb01_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm7Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm12Lsb01_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm21_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm2Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm61_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CLUIImm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX5
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX2
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX3
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX4
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__CallSymbol1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__CallSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ZeroOffsetMemOpOperand1_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__UImm8GE321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__UImm51_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Rlist1_0__Spimm1_1
  { CVT_95_addRlistOperands, 1, CVT_95_addSpimmOperands, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__Reg1_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__UImm51_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__regX0
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm61_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm61_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__SImm51_1__SImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm121_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__RegReg1_1
  { CVT_95_Reg, 1, CVT_95_addRegRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm31_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm41_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__imm_95_0__imm_95_0
  { CVT_imm_95_0, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RTZArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands, 3, CVT_Done },
  // Convert__imm_95_15__imm_95_15
  { CVT_imm_95_15, 0, CVT_imm_95_15, 0, CVT_Done },
  // Convert__FenceArg1_0__FenceArg1_1
  { CVT_95_addFenceArgOperands, 1, CVT_95_addFenceArgOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__LoadFPImm1_1
  { CVT_95_Reg, 1, CVT_95_addFPImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__imm_95_3__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_1__regX0
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_2__regX0
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__imm_95_3__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_3__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__regX0__imm_95_2__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_2__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__regX0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__regX0
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__regX0__SImm21Lsb0JAL1_0
  { CVT_regX0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regX1__SImm21Lsb0JAL1_0
  { CVT_regX1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__SImm21Lsb0JAL1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_0__imm_95_0
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX1__Reg1_0__SImm121_1
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_2__SImm121_0
  { CVT_regX1, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__regX0__Reg1_0__imm_95_0
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX0__Reg1_0__SImm121_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__Reg1_2__SImm121_0
  { CVT_regX0, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__PseudoJumpSymbol1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI_Restricted1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__regX0__SImm121_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__UImm201_0
  { CVT_regX0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__UImm20LUI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__regX0__Reg1_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__regX0__imm_95_0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_Done },
  // Convert__regX0__regX0__regX5
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__regX0__regX2
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__regX0__regX3
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__regX0__regX4
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX4, 0, CVT_Done },
  // Convert__imm_95_1__imm_95_0
  { CVT_imm_95_1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__SImm12Lsb000001_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_3072__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3072, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3200__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3200, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3074__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3074, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3202__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3202, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3073__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3073, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3201__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3201, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__regX1__imm_95_0
  { CVT_regX0, 0, CVT_regX1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__RVVMaskRegOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands_95_defaultMaskRegOp, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Reg1_0
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__SImm51_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__UImm51_1__VTypeI101_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__VTypeI111_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_255
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_255, 0, CVT_Done },
};

void RISCVAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands,
                const SmallBitVector &OptionalOperandsMask) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  unsigned DefaultsOffset[8] = { 0 };
  assert(OptionalOperandsMask.size() == 7);
  for (unsigned i = 0, NumDefaults = 0; i < 7; ++i) {
    DefaultsOffset[i + 1] = NumDefaults;
    NumDefaults += (OptionalOperandsMask[i] ? 1 : 0);
  }
  unsigned OpIdx;
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    OpIdx = *(p + 1) - DefaultsOffset[*(p + 1)];
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[OpIdx][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_addImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addRegOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_regX0:
      Inst.addOperand(MCOperand::createReg(RISCV::X0));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_regX5:
      Inst.addOperand(MCOperand::createReg(RISCV::X5));
      break;
    case CVT_regX2:
      Inst.addOperand(MCOperand::createReg(RISCV::X2));
      break;
    case CVT_regX3:
      Inst.addOperand(MCOperand::createReg(RISCV::X3));
      break;
    case CVT_regX4:
      Inst.addOperand(MCOperand::createReg(RISCV::X4));
      break;
    case CVT_95_addRlistOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRlistOperands(Inst, 1);
      break;
    case CVT_95_addSpimmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addSpimmOperands(Inst, 1);
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addCSRSystemRegisterOperands(Inst, 1);
      break;
    case CVT_95_addRegRegOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegRegOperands(Inst, 1);
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultFRMArgOp()->addFRMArgOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      }
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultFRMArgLegacyOp()->addFRMArgOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      }
      break;
    case CVT_95_addFRMArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addFenceArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFenceArgOperands(Inst, 1);
      break;
    case CVT_95_addFPImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFPImmOperands(Inst, 1);
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_regX1:
      Inst.addOperand(MCOperand::createReg(RISCV::X1));
      break;
    case CVT_imm_95__MINUS_1:
      Inst.addOperand(MCOperand::createImm(-1));
      break;
    case CVT_imm_95_3072:
      Inst.addOperand(MCOperand::createImm(3072));
      break;
    case CVT_imm_95_3200:
      Inst.addOperand(MCOperand::createImm(3200));
      break;
    case CVT_imm_95_3074:
      Inst.addOperand(MCOperand::createImm(3074));
      break;
    case CVT_imm_95_3202:
      Inst.addOperand(MCOperand::createImm(3202));
      break;
    case CVT_imm_95_3073:
      Inst.addOperand(MCOperand::createImm(3073));
      break;
    case CVT_imm_95_3201:
      Inst.addOperand(MCOperand::createImm(3201));
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultMaskRegOp()->addRegOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      }
      break;
    case CVT_reg0:
      Inst.addOperand(MCOperand::createReg(0));
      break;
    case CVT_95_addVTypeIOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addVTypeIOperands(Inst, 1);
      break;
    case CVT_imm_95_255:
      Inst.addOperand(MCOperand::createImm(255));
      break;
    }
  }
}

void RISCVAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_regX0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regX5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addRlistOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSpimmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addFenceArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFPImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regX1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95__MINUS_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3072:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3200:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3074:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3202:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3073:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3201:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_reg0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addVTypeIOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_255:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__40_, // '('
  MCK__41_, // ')'
  MCK_LAST_TOKEN = MCK__41_,
  MCK_Reg77, // derived register class
  MCK_Reg74, // derived register class
  MCK_Reg71, // derived register class
  MCK_Reg68, // derived register class
  MCK_Reg65, // derived register class
  MCK_Reg62, // derived register class
  MCK_Reg59, // derived register class
  MCK_Reg56, // derived register class
  MCK_Reg53, // derived register class
  MCK_Reg50, // derived register class
  MCK_Reg47, // derived register class
  MCK_Reg41, // derived register class
  MCK_Reg37, // derived register class
  MCK_Reg35, // derived register class
  MCK_Reg33, // derived register class
  MCK_Reg29, // derived register class
  MCK_Reg26, // derived register class
  MCK_Reg23, // derived register class
  MCK_GPRX0, // register class 'GPRX0,X0'
  MCK_GPRX1, // register class 'GPRX1'
  MCK_GPRX5, // register class 'GPRX5'
  MCK_SP, // register class 'SP'
  MCK_VMV0, // register class 'VMV0,V0'
  MCK_Reg11, // derived register class
  MCK_GPRX1X5, // register class 'GPRX1X5'
  MCK_Reg44, // derived register class
  MCK_VCSR, // register class 'VCSR'
  MCK_VRM8NoV0, // register class 'VRM8NoV0'
  MCK_Reg43, // derived register class
  MCK_Reg42, // derived register class
  MCK_VRM8, // register class 'VRM8'
  MCK_Reg14, // derived register class
  MCK_VRN2M4NoV0, // register class 'VRN2M4NoV0'
  MCK_Reg40, // derived register class
  MCK_VRM4NoV0, // register class 'VRM4NoV0'
  MCK_VRN2M4, // register class 'VRN2M4'
  MCK_FPR32C, // register class 'FPR32C'
  MCK_FPR64C, // register class 'FPR64C'
  MCK_GPRC, // register class 'GPRC'
  MCK_SR07, // register class 'SR07'
  MCK_VRM4, // register class 'VRM4'
  MCK_VRN4M2NoV0, // register class 'VRN4M2NoV0'
  MCK_Reg39, // derived register class
  MCK_VRN3M2NoV0, // register class 'VRN3M2NoV0'
  MCK_VRN4M2, // register class 'VRN4M2'
  MCK_Reg38, // derived register class
  MCK_GPRTC, // register class 'GPRTC'
  MCK_VRN2M2NoV0, // register class 'VRN2M2NoV0'
  MCK_VRN3M2, // register class 'VRN3M2'
  MCK_Reg36, // derived register class
  MCK_VRM2NoV0, // register class 'VRM2NoV0'
  MCK_VRN2M2, // register class 'VRN2M2'
  MCK_GPRPair, // register class 'GPRPair'
  MCK_VRM2, // register class 'VRM2'
  MCK_VRN8M1NoV0, // register class 'VRN8M1NoV0'
  MCK_VRN7M1NoV0, // register class 'VRN7M1NoV0'
  MCK_VRN8M1, // register class 'VRN8M1'
  MCK_GPRJALR, // register class 'GPRJALR'
  MCK_VRN6M1NoV0, // register class 'VRN6M1NoV0'
  MCK_VRN7M1, // register class 'VRN7M1'
  MCK_VRN5M1NoV0, // register class 'VRN5M1NoV0'
  MCK_VRN6M1, // register class 'VRN6M1'
  MCK_VRN4M1NoV0, // register class 'VRN4M1NoV0'
  MCK_VRN5M1, // register class 'VRN5M1'
  MCK_VRN3M1NoV0, // register class 'VRN3M1NoV0'
  MCK_VRN4M1, // register class 'VRN4M1'
  MCK_GPRNoX0X2, // register class 'GPRNoX0X2'
  MCK_VRN2M1NoV0, // register class 'VRN2M1NoV0'
  MCK_VRN3M1, // register class 'VRN3M1'
  MCK_GPRNoX0, // register class 'GPRNoX0'
  MCK_VRN2M1, // register class 'VRN2M1'
  MCK_VRNoV0, // register class 'VRNoV0'
  MCK_FPR16, // register class 'FPR16'
  MCK_FPR32, // register class 'FPR32'
  MCK_FPR64, // register class 'FPR64'
  MCK_GPR, // register class 'GPR,GPRF16,GPRF32'
  MCK_VM, // register class 'VM,VR'
  MCK_GPRAll, // register class 'GPRAll'
  MCK_LAST_REGISTER = MCK_GPRAll,
  MCK_AnyRegCOperand, // user defined class 'AnyRegCOperand'
  MCK_AnyRegOperand, // user defined class 'AnyRegOperand'
  MCK_BareSymbol, // user defined class 'BareSymbol'
  MCK_CLUIImm, // user defined class 'CLUIImmAsmOperand'
  MCK_CSRSystemRegister, // user defined class 'CSRSystemRegister'
  MCK_RegReg, // user defined class 'CVrrAsmOperand'
  MCK_CallSymbol, // user defined class 'CallSymbol'
  MCK_FRMArg, // user defined class 'FRMArg'
  MCK_FRMArgLegacy, // user defined class 'FRMArgLegacy'
  MCK_FenceArg, // user defined class 'FenceArg'
  MCK_GPRAsFPR, // user defined class 'GPRAsFPR'
  MCK_GPRF64AsFPR, // user defined class 'GPRF64AsFPR'
  MCK_GPRPairAsFPR, // user defined class 'GPRPairAsFPR'
  MCK_GPRPairRV32, // user defined class 'GPRPairRV32Operand'
  MCK_GPRPairRV64, // user defined class 'GPRPairRV64Operand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmZero, // user defined class 'ImmZeroAsmOperand'
  MCK_InsnCDirectiveOpcode, // user defined class 'InsnCDirectiveOpcode'
  MCK_InsnDirectiveOpcode, // user defined class 'InsnDirectiveOpcode'
  MCK_LoadFPImm, // user defined class 'LoadFPImmOperand'
  MCK_PseudoJumpSymbol, // user defined class 'PseudoJumpSymbol'
  MCK_RTZArg, // user defined class 'RTZArg'
  MCK_Rlist, // user defined class 'RlistAsmOperand'
  MCK_RnumArg, // user defined class 'RnumArg'
  MCK_SImm5Plus1, // user defined class 'SImm5Plus1AsmOperand'
  MCK_SImm21Lsb0JAL, // user defined class 'Simm21Lsb0JALAsmOperand'
  MCK_Spimm, // user defined class 'SpimmAsmOperand'
  MCK_TLSDESCCallSymbol, // user defined class 'TLSDESCCallSymbol'
  MCK_TPRelAddSymbol, // user defined class 'TPRelAddSymbol'
  MCK_UImmLog2XLen, // user defined class 'UImmLog2XLenAsmOperand'
  MCK_UImmLog2XLenHalf, // user defined class 'UImmLog2XLenHalfAsmOperand'
  MCK_UImmLog2XLenNonZero, // user defined class 'UImmLog2XLenNonZeroAsmOperand'
  MCK_RVVMaskRegOpOperand, // user defined class 'VMaskAsmOperand'
  MCK_ZeroOffsetMemOpOperand, // user defined class 'ZeroOffsetMemOpOperand'
  MCK_SImm6, // user defined class 'anonymous_46832'
  MCK_SImm6NonZero, // user defined class 'anonymous_46833'
  MCK_UImm7Lsb00, // user defined class 'anonymous_46834'
  MCK_UImm8Lsb00, // user defined class 'anonymous_46835'
  MCK_UImm8Lsb000, // user defined class 'anonymous_46836'
  MCK_SImm9Lsb0, // user defined class 'anonymous_46837'
  MCK_UImm9Lsb000, // user defined class 'anonymous_46838'
  MCK_UImm10Lsb00NonZero, // user defined class 'anonymous_46839'
  MCK_SImm10Lsb0000NonZero, // user defined class 'anonymous_46840'
  MCK_SImm12Lsb0, // user defined class 'anonymous_46841'
  MCK_UImm2Lsb0, // user defined class 'anonymous_46925'
  MCK_UImm8GE32, // user defined class 'anonymous_46926'
  MCK_SImm12Lsb00000, // user defined class 'anonymous_46946'
  MCK_UImm1, // user defined class 'anonymous_8024'
  MCK_UImm2, // user defined class 'anonymous_8025'
  MCK_UImm3, // user defined class 'anonymous_8026'
  MCK_UImm4, // user defined class 'anonymous_8027'
  MCK_UImm5, // user defined class 'anonymous_8028'
  MCK_UImm6, // user defined class 'anonymous_8029'
  MCK_UImm7, // user defined class 'anonymous_8030'
  MCK_UImm8, // user defined class 'anonymous_8031'
  MCK_SImm12, // user defined class 'anonymous_8032'
  MCK_SImm13Lsb0, // user defined class 'anonymous_8033'
  MCK_UImm20LUI, // user defined class 'anonymous_8034'
  MCK_UImm20AUIPC, // user defined class 'anonymous_8035'
  MCK_UImm20, // user defined class 'anonymous_8036'
  MCK_ImmXLenLI, // user defined class 'anonymous_8037'
  MCK_ImmXLenLI_Restricted, // user defined class 'anonymous_8038'
  MCK_VTypeI10, // user defined class 'anonymous_9431'
  MCK_VTypeI11, // user defined class 'anonymous_9432'
  MCK_SImm5, // user defined class 'anonymous_9433'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case '(':	 // 1 string to match.
      return MCK__40_;	 // "("
    case ')':	 // 1 string to match.
      return MCK__41_;	 // ")"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK_Reg77:
    return B == MCK_VRN8M1;

  case MCK_Reg74:
    return B == MCK_VRN7M1;

  case MCK_Reg71:
    return B == MCK_VRN6M1;

  case MCK_Reg68:
    return B == MCK_VRN5M1;

  case MCK_Reg65:
    return B == MCK_VRN4M2;

  case MCK_Reg62:
    return B == MCK_VRN4M1;

  case MCK_Reg59:
    return B == MCK_VRN3M2;

  case MCK_Reg56:
    return B == MCK_VRN3M1;

  case MCK_Reg53:
    return B == MCK_VRN2M4;

  case MCK_Reg50:
    return B == MCK_VRN2M2;

  case MCK_Reg47:
    return B == MCK_VRN2M1;

  case MCK_Reg41:
    switch (B) {
    default: return false;
    case MCK_Reg43: return true;
    case MCK_Reg42: return true;
    case MCK_Reg39: return true;
    case MCK_Reg38: return true;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg37:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg35:
    switch (B) {
    default: return false;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg33:
    return B == MCK_GPRPair;

  case MCK_Reg29:
    return B == MCK_VRM8;

  case MCK_Reg26:
    return B == MCK_VRM4;

  case MCK_Reg23:
    return B == MCK_VRM2;

  case MCK_GPRX0:
    switch (B) {
    default: return false;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_GPRX1:
    switch (B) {
    default: return false;
    case MCK_GPRX1X5: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_GPRX5:
    switch (B) {
    default: return false;
    case MCK_GPRX1X5: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_SP:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VMV0:
    return B == MCK_VM;

  case MCK_Reg11:
    switch (B) {
    default: return false;
    case MCK_GPRC: return true;
    case MCK_SR07: return true;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_GPRX1X5:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_Reg44:
    switch (B) {
    default: return false;
    case MCK_Reg42: return true;
    case MCK_Reg40: return true;
    case MCK_Reg39: return true;
    case MCK_Reg38: return true;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_VRM8NoV0:
    return B == MCK_VRM8;

  case MCK_Reg43:
    switch (B) {
    default: return false;
    case MCK_Reg39: return true;
    case MCK_Reg38: return true;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg42:
    switch (B) {
    default: return false;
    case MCK_Reg39: return true;
    case MCK_Reg38: return true;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_Reg14:
    switch (B) {
    default: return false;
    case MCK_GPRC: return true;
    case MCK_GPRTC: return true;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN2M4NoV0:
    return B == MCK_VRN2M4;

  case MCK_Reg40:
    switch (B) {
    default: return false;
    case MCK_Reg39: return true;
    case MCK_Reg38: return true;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_VRM4NoV0:
    return B == MCK_VRM4;

  case MCK_FPR32C:
    return B == MCK_FPR32;

  case MCK_FPR64C:
    return B == MCK_FPR64;

  case MCK_GPRC:
    switch (B) {
    default: return false;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_SR07:
    switch (B) {
    default: return false;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN4M2NoV0:
    return B == MCK_VRN4M2;

  case MCK_Reg39:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_VRN3M2NoV0:
    return B == MCK_VRN3M2;

  case MCK_Reg38:
    switch (B) {
    default: return false;
    case MCK_Reg36: return true;
    case MCK_GPRPair: return true;
    }

  case MCK_GPRTC:
    switch (B) {
    default: return false;
    case MCK_GPRJALR: return true;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN2M2NoV0:
    return B == MCK_VRN2M2;

  case MCK_Reg36:
    return B == MCK_GPRPair;

  case MCK_VRM2NoV0:
    return B == MCK_VRM2;

  case MCK_VRN8M1NoV0:
    return B == MCK_VRN8M1;

  case MCK_VRN7M1NoV0:
    return B == MCK_VRN7M1;

  case MCK_GPRJALR:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0X2: return true;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN6M1NoV0:
    return B == MCK_VRN6M1;

  case MCK_VRN5M1NoV0:
    return B == MCK_VRN5M1;

  case MCK_VRN4M1NoV0:
    return B == MCK_VRN4M1;

  case MCK_VRN3M1NoV0:
    return B == MCK_VRN3M1;

  case MCK_GPRNoX0X2:
    switch (B) {
    default: return false;
    case MCK_GPRNoX0: return true;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRN2M1NoV0:
    return B == MCK_VRN2M1;

  case MCK_GPRNoX0:
    switch (B) {
    default: return false;
    case MCK_GPR: return true;
    case MCK_GPRAll: return true;
    }

  case MCK_VRNoV0:
    return B == MCK_VM;

  case MCK_GPR:
    return B == MCK_GPRAll;

  case MCK_FRMArg:
    return B == OptionalMatchClass;

  case MCK_FRMArgLegacy:
    return B == OptionalMatchClass;

  case MCK_RVVMaskRegOpOperand:
    return B == OptionalMatchClass;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  RISCVOperand &Operand = (RISCVOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  // 'AnyRegCOperand' class
  case MCK_AnyRegCOperand: {
    DiagnosticPredicate DP(Operand.isAnyRegC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'AnyRegOperand' class
  case MCK_AnyRegOperand: {
    DiagnosticPredicate DP(Operand.isAnyReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'BareSymbol' class
  case MCK_BareSymbol: {
    DiagnosticPredicate DP(Operand.isBareSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSymbol;
    break;
    }
  // 'CLUIImm' class
  case MCK_CLUIImm: {
    DiagnosticPredicate DP(Operand.isCLUIImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCLUIImm;
    break;
    }
  // 'CSRSystemRegister' class
  case MCK_CSRSystemRegister: {
    DiagnosticPredicate DP(Operand.isCSRSystemRegister());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCSRSystemRegister;
    break;
    }
  // 'RegReg' class
  case MCK_RegReg: {
    DiagnosticPredicate DP(Operand.isRegReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRegReg;
    break;
    }
  // 'CallSymbol' class
  case MCK_CallSymbol: {
    DiagnosticPredicate DP(Operand.isCallSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCallSymbol;
    break;
    }
  // 'FRMArg' class
  case MCK_FRMArg: {
    DiagnosticPredicate DP(Operand.isFRMArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FRMArgLegacy' class
  case MCK_FRMArgLegacy: {
    DiagnosticPredicate DP(Operand.isFRMArgLegacy());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'FenceArg' class
  case MCK_FenceArg: {
    DiagnosticPredicate DP(Operand.isFenceArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRAsFPR' class
  case MCK_GPRAsFPR: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRF64AsFPR' class
  case MCK_GPRF64AsFPR: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRPairAsFPR' class
  case MCK_GPRPairAsFPR: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRPairRV32' class
  case MCK_GPRPairRV32: {
    DiagnosticPredicate DP(Operand.isGPRPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'GPRPairRV64' class
  case MCK_GPRPairRV64: {
    DiagnosticPredicate DP(Operand.isGPRPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'Imm' class
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'ImmZero' class
  case MCK_ImmZero: {
    DiagnosticPredicate DP(Operand.isImmZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmZero;
    break;
    }
  // 'InsnCDirectiveOpcode' class
  case MCK_InsnCDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'InsnDirectiveOpcode' class
  case MCK_InsnDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'LoadFPImm' class
  case MCK_LoadFPImm: {
    DiagnosticPredicate DP(Operand.isLoadFPImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidLoadFPImm;
    break;
    }
  // 'PseudoJumpSymbol' class
  case MCK_PseudoJumpSymbol: {
    DiagnosticPredicate DP(Operand.isPseudoJumpSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidPseudoJumpSymbol;
    break;
    }
  // 'RTZArg' class
  case MCK_RTZArg: {
    DiagnosticPredicate DP(Operand.isRTZArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRTZArg;
    break;
    }
  // 'Rlist' class
  case MCK_Rlist: {
    DiagnosticPredicate DP(Operand.isRlist());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRlist;
    break;
    }
  // 'RnumArg' class
  case MCK_RnumArg: {
    DiagnosticPredicate DP(Operand.isRnumArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRnumArg;
    break;
    }
  // 'SImm5Plus1' class
  case MCK_SImm5Plus1: {
    DiagnosticPredicate DP(Operand.isSImm5Plus1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5Plus1;
    break;
    }
  // 'SImm21Lsb0JAL' class
  case MCK_SImm21Lsb0JAL: {
    DiagnosticPredicate DP(Operand.isSImm21Lsb0JAL());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm21Lsb0JAL;
    break;
    }
  // 'Spimm' class
  case MCK_Spimm: {
    DiagnosticPredicate DP(Operand.isSpimm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSpimm;
    break;
    }
  // 'TLSDESCCallSymbol' class
  case MCK_TLSDESCCallSymbol: {
    DiagnosticPredicate DP(Operand.isTLSDESCCallSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidTLSDESCCallSymbol;
    break;
    }
  // 'TPRelAddSymbol' class
  case MCK_TPRelAddSymbol: {
    DiagnosticPredicate DP(Operand.isTPRelAddSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidTPRelAddSymbol;
    break;
    }
  // 'UImmLog2XLen' class
  case MCK_UImmLog2XLen: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLen());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLen;
    break;
    }
  // 'UImmLog2XLenHalf' class
  case MCK_UImmLog2XLenHalf: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLenHalf());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLenHalf;
    break;
    }
  // 'UImmLog2XLenNonZero' class
  case MCK_UImmLog2XLenNonZero: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLenNonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLenNonZero;
    break;
    }
  // 'RVVMaskRegOpOperand' class
  case MCK_RVVMaskRegOpOperand: {
    DiagnosticPredicate DP(Operand.isV0Reg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVMaskRegister;
    break;
    }
  // 'ZeroOffsetMemOpOperand' class
  case MCK_ZeroOffsetMemOpOperand: {
    DiagnosticPredicate DP(Operand.isGPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
    }
  // 'SImm6' class
  case MCK_SImm6: {
    DiagnosticPredicate DP(Operand.isSImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6;
    break;
    }
  // 'SImm6NonZero' class
  case MCK_SImm6NonZero: {
    DiagnosticPredicate DP(Operand.isSImm6NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6NonZero;
    break;
    }
  // 'UImm7Lsb00' class
  case MCK_UImm7Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm7Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7Lsb00;
    break;
    }
  // 'UImm8Lsb00' class
  case MCK_UImm8Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb00;
    break;
    }
  // 'UImm8Lsb000' class
  case MCK_UImm8Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb000;
    break;
    }
  // 'SImm9Lsb0' class
  case MCK_SImm9Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm9Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm9Lsb0;
    break;
    }
  // 'UImm9Lsb000' class
  case MCK_UImm9Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm9Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm9Lsb000;
    break;
    }
  // 'UImm10Lsb00NonZero' class
  case MCK_UImm10Lsb00NonZero: {
    DiagnosticPredicate DP(Operand.isUImm10Lsb00NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm10Lsb00NonZero;
    break;
    }
  // 'SImm10Lsb0000NonZero' class
  case MCK_SImm10Lsb0000NonZero: {
    DiagnosticPredicate DP(Operand.isSImm10Lsb0000NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm10Lsb0000NonZero;
    break;
    }
  // 'SImm12Lsb0' class
  case MCK_SImm12Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm12Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12Lsb0;
    break;
    }
  // 'UImm2Lsb0' class
  case MCK_UImm2Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm2Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2Lsb0;
    break;
    }
  // 'UImm8GE32' class
  case MCK_UImm8GE32: {
    DiagnosticPredicate DP(Operand.isUImm8GE32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8GE32;
    break;
    }
  // 'SImm12Lsb00000' class
  case MCK_SImm12Lsb00000: {
    DiagnosticPredicate DP(Operand.isSImm12Lsb00000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12Lsb00000;
    break;
    }
  // 'UImm1' class
  case MCK_UImm1: {
    DiagnosticPredicate DP(Operand.isUImm1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm1;
    break;
    }
  // 'UImm2' class
  case MCK_UImm2: {
    DiagnosticPredicate DP(Operand.isUImm2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2;
    break;
    }
  // 'UImm3' class
  case MCK_UImm3: {
    DiagnosticPredicate DP(Operand.isUImm3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm3;
    break;
    }
  // 'UImm4' class
  case MCK_UImm4: {
    DiagnosticPredicate DP(Operand.isUImm4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm4;
    break;
    }
  // 'UImm5' class
  case MCK_UImm5: {
    DiagnosticPredicate DP(Operand.isUImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5;
    break;
    }
  // 'UImm6' class
  case MCK_UImm6: {
    DiagnosticPredicate DP(Operand.isUImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm6;
    break;
    }
  // 'UImm7' class
  case MCK_UImm7: {
    DiagnosticPredicate DP(Operand.isUImm7());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7;
    break;
    }
  // 'UImm8' class
  case MCK_UImm8: {
    DiagnosticPredicate DP(Operand.isUImm8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8;
    break;
    }
  // 'SImm12' class
  case MCK_SImm12: {
    DiagnosticPredicate DP(Operand.isSImm12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12;
    break;
    }
  // 'SImm13Lsb0' class
  case MCK_SImm13Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm13Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm13Lsb0;
    break;
    }
  // 'UImm20LUI' class
  case MCK_UImm20LUI: {
    DiagnosticPredicate DP(Operand.isUImm20LUI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20LUI;
    break;
    }
  // 'UImm20AUIPC' class
  case MCK_UImm20AUIPC: {
    DiagnosticPredicate DP(Operand.isUImm20AUIPC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20AUIPC;
    break;
    }
  // 'UImm20' class
  case MCK_UImm20: {
    DiagnosticPredicate DP(Operand.isUImm20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20;
    break;
    }
  // 'ImmXLenLI' class
  case MCK_ImmXLenLI: {
    DiagnosticPredicate DP(Operand.isImmXLenLI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI;
    break;
    }
  // 'ImmXLenLI_Restricted' class
  case MCK_ImmXLenLI_Restricted: {
    DiagnosticPredicate DP(Operand.isImmXLenLI_Restricted());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI_Restricted;
    break;
    }
  // 'VTypeI10' class
  case MCK_VTypeI10: {
    DiagnosticPredicate DP(Operand.isVTypeI10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
    }
  // 'VTypeI11' class
  case MCK_VTypeI11: {
    DiagnosticPredicate DP(Operand.isVTypeI11());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
    }
  // 'SImm5' class
  case MCK_SImm5: {
    DiagnosticPredicate DP(Operand.isSImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5;
    break;
    }
  } // end switch (Kind)

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg()) {
    default: OpKind = InvalidMatchClass; break;
    case RISCV::X0: OpKind = MCK_GPRX0; break;
    case RISCV::X1: OpKind = MCK_GPRX1; break;
    case RISCV::X2: OpKind = MCK_SP; break;
    case RISCV::X3: OpKind = MCK_GPRNoX0X2; break;
    case RISCV::X4: OpKind = MCK_GPRNoX0X2; break;
    case RISCV::X5: OpKind = MCK_GPRX5; break;
    case RISCV::X6: OpKind = MCK_GPRTC; break;
    case RISCV::X7: OpKind = MCK_GPRTC; break;
    case RISCV::X8: OpKind = MCK_Reg11; break;
    case RISCV::X9: OpKind = MCK_Reg11; break;
    case RISCV::X10: OpKind = MCK_Reg14; break;
    case RISCV::X11: OpKind = MCK_Reg14; break;
    case RISCV::X12: OpKind = MCK_Reg14; break;
    case RISCV::X13: OpKind = MCK_Reg14; break;
    case RISCV::X14: OpKind = MCK_Reg14; break;
    case RISCV::X15: OpKind = MCK_Reg14; break;
    case RISCV::X16: OpKind = MCK_GPRTC; break;
    case RISCV::X17: OpKind = MCK_GPRTC; break;
    case RISCV::X18: OpKind = MCK_SR07; break;
    case RISCV::X19: OpKind = MCK_SR07; break;
    case RISCV::X20: OpKind = MCK_SR07; break;
    case RISCV::X21: OpKind = MCK_SR07; break;
    case RISCV::X22: OpKind = MCK_SR07; break;
    case RISCV::X23: OpKind = MCK_SR07; break;
    case RISCV::X24: OpKind = MCK_GPRJALR; break;
    case RISCV::X25: OpKind = MCK_GPRJALR; break;
    case RISCV::X26: OpKind = MCK_GPRJALR; break;
    case RISCV::X27: OpKind = MCK_GPRJALR; break;
    case RISCV::X28: OpKind = MCK_GPRTC; break;
    case RISCV::X29: OpKind = MCK_GPRTC; break;
    case RISCV::X30: OpKind = MCK_GPRTC; break;
    case RISCV::X31: OpKind = MCK_GPRTC; break;
    case RISCV::F0_H: OpKind = MCK_FPR16; break;
    case RISCV::F1_H: OpKind = MCK_FPR16; break;
    case RISCV::F2_H: OpKind = MCK_FPR16; break;
    case RISCV::F3_H: OpKind = MCK_FPR16; break;
    case RISCV::F4_H: OpKind = MCK_FPR16; break;
    case RISCV::F5_H: OpKind = MCK_FPR16; break;
    case RISCV::F6_H: OpKind = MCK_FPR16; break;
    case RISCV::F7_H: OpKind = MCK_FPR16; break;
    case RISCV::F8_H: OpKind = MCK_FPR16; break;
    case RISCV::F9_H: OpKind = MCK_FPR16; break;
    case RISCV::F10_H: OpKind = MCK_FPR16; break;
    case RISCV::F11_H: OpKind = MCK_FPR16; break;
    case RISCV::F12_H: OpKind = MCK_FPR16; break;
    case RISCV::F13_H: OpKind = MCK_FPR16; break;
    case RISCV::F14_H: OpKind = MCK_FPR16; break;
    case RISCV::F15_H: OpKind = MCK_FPR16; break;
    case RISCV::F16_H: OpKind = MCK_FPR16; break;
    case RISCV::F17_H: OpKind = MCK_FPR16; break;
    case RISCV::F18_H: OpKind = MCK_FPR16; break;
    case RISCV::F19_H: OpKind = MCK_FPR16; break;
    case RISCV::F20_H: OpKind = MCK_FPR16; break;
    case RISCV::F21_H: OpKind = MCK_FPR16; break;
    case RISCV::F22_H: OpKind = MCK_FPR16; break;
    case RISCV::F23_H: OpKind = MCK_FPR16; break;
    case RISCV::F24_H: OpKind = MCK_FPR16; break;
    case RISCV::F25_H: OpKind = MCK_FPR16; break;
    case RISCV::F26_H: OpKind = MCK_FPR16; break;
    case RISCV::F27_H: OpKind = MCK_FPR16; break;
    case RISCV::F28_H: OpKind = MCK_FPR16; break;
    case RISCV::F29_H: OpKind = MCK_FPR16; break;
    case RISCV::F30_H: OpKind = MCK_FPR16; break;
    case RISCV::F31_H: OpKind = MCK_FPR16; break;
    case RISCV::F0_F: OpKind = MCK_FPR32; break;
    case RISCV::F1_F: OpKind = MCK_FPR32; break;
    case RISCV::F2_F: OpKind = MCK_FPR32; break;
    case RISCV::F3_F: OpKind = MCK_FPR32; break;
    case RISCV::F4_F: OpKind = MCK_FPR32; break;
    case RISCV::F5_F: OpKind = MCK_FPR32; break;
    case RISCV::F6_F: OpKind = MCK_FPR32; break;
    case RISCV::F7_F: OpKind = MCK_FPR32; break;
    case RISCV::F8_F: OpKind = MCK_FPR32C; break;
    case RISCV::F9_F: OpKind = MCK_FPR32C; break;
    case RISCV::F10_F: OpKind = MCK_FPR32C; break;
    case RISCV::F11_F: OpKind = MCK_FPR32C; break;
    case RISCV::F12_F: OpKind = MCK_FPR32C; break;
    case RISCV::F13_F: OpKind = MCK_FPR32C; break;
    case RISCV::F14_F: OpKind = MCK_FPR32C; break;
    case RISCV::F15_F: OpKind = MCK_FPR32C; break;
    case RISCV::F16_F: OpKind = MCK_FPR32; break;
    case RISCV::F17_F: OpKind = MCK_FPR32; break;
    case RISCV::F18_F: OpKind = MCK_FPR32; break;
    case RISCV::F19_F: OpKind = MCK_FPR32; break;
    case RISCV::F20_F: OpKind = MCK_FPR32; break;
    case RISCV::F21_F: OpKind = MCK_FPR32; break;
    case RISCV::F22_F: OpKind = MCK_FPR32; break;
    case RISCV::F23_F: OpKind = MCK_FPR32; break;
    case RISCV::F24_F: OpKind = MCK_FPR32; break;
    case RISCV::F25_F: OpKind = MCK_FPR32; break;
    case RISCV::F26_F: OpKind = MCK_FPR32; break;
    case RISCV::F27_F: OpKind = MCK_FPR32; break;
    case RISCV::F28_F: OpKind = MCK_FPR32; break;
    case RISCV::F29_F: OpKind = MCK_FPR32; break;
    case RISCV::F30_F: OpKind = MCK_FPR32; break;
    case RISCV::F31_F: OpKind = MCK_FPR32; break;
    case RISCV::F0_D: OpKind = MCK_FPR64; break;
    case RISCV::F1_D: OpKind = MCK_FPR64; break;
    case RISCV::F2_D: OpKind = MCK_FPR64; break;
    case RISCV::F3_D: OpKind = MCK_FPR64; break;
    case RISCV::F4_D: OpKind = MCK_FPR64; break;
    case RISCV::F5_D: OpKind = MCK_FPR64; break;
    case RISCV::F6_D: OpKind = MCK_FPR64; break;
    case RISCV::F7_D: OpKind = MCK_FPR64; break;
    case RISCV::F8_D: OpKind = MCK_FPR64C; break;
    case RISCV::F9_D: OpKind = MCK_FPR64C; break;
    case RISCV::F10_D: OpKind = MCK_FPR64C; break;
    case RISCV::F11_D: OpKind = MCK_FPR64C; break;
    case RISCV::F12_D: OpKind = MCK_FPR64C; break;
    case RISCV::F13_D: OpKind = MCK_FPR64C; break;
    case RISCV::F14_D: OpKind = MCK_FPR64C; break;
    case RISCV::F15_D: OpKind = MCK_FPR64C; break;
    case RISCV::F16_D: OpKind = MCK_FPR64; break;
    case RISCV::F17_D: OpKind = MCK_FPR64; break;
    case RISCV::F18_D: OpKind = MCK_FPR64; break;
    case RISCV::F19_D: OpKind = MCK_FPR64; break;
    case RISCV::F20_D: OpKind = MCK_FPR64; break;
    case RISCV::F21_D: OpKind = MCK_FPR64; break;
    case RISCV::F22_D: OpKind = MCK_FPR64; break;
    case RISCV::F23_D: OpKind = MCK_FPR64; break;
    case RISCV::F24_D: OpKind = MCK_FPR64; break;
    case RISCV::F25_D: OpKind = MCK_FPR64; break;
    case RISCV::F26_D: OpKind = MCK_FPR64; break;
    case RISCV::F27_D: OpKind = MCK_FPR64; break;
    case RISCV::F28_D: OpKind = MCK_FPR64; break;
    case RISCV::F29_D: OpKind = MCK_FPR64; break;
    case RISCV::F30_D: OpKind = MCK_FPR64; break;
    case RISCV::F31_D: OpKind = MCK_FPR64; break;
    case RISCV::V0: OpKind = MCK_VMV0; break;
    case RISCV::V1: OpKind = MCK_VRNoV0; break;
    case RISCV::V2: OpKind = MCK_VRNoV0; break;
    case RISCV::V3: OpKind = MCK_VRNoV0; break;
    case RISCV::V4: OpKind = MCK_VRNoV0; break;
    case RISCV::V5: OpKind = MCK_VRNoV0; break;
    case RISCV::V6: OpKind = MCK_VRNoV0; break;
    case RISCV::V7: OpKind = MCK_VRNoV0; break;
    case RISCV::V8: OpKind = MCK_VRNoV0; break;
    case RISCV::V9: OpKind = MCK_VRNoV0; break;
    case RISCV::V10: OpKind = MCK_VRNoV0; break;
    case RISCV::V11: OpKind = MCK_VRNoV0; break;
    case RISCV::V12: OpKind = MCK_VRNoV0; break;
    case RISCV::V13: OpKind = MCK_VRNoV0; break;
    case RISCV::V14: OpKind = MCK_VRNoV0; break;
    case RISCV::V15: OpKind = MCK_VRNoV0; break;
    case RISCV::V16: OpKind = MCK_VRNoV0; break;
    case RISCV::V17: OpKind = MCK_VRNoV0; break;
    case RISCV::V18: OpKind = MCK_VRNoV0; break;
    case RISCV::V19: OpKind = MCK_VRNoV0; break;
    case RISCV::V20: OpKind = MCK_VRNoV0; break;
    case RISCV::V21: OpKind = MCK_VRNoV0; break;
    case RISCV::V22: OpKind = MCK_VRNoV0; break;
    case RISCV::V23: OpKind = MCK_VRNoV0; break;
    case RISCV::V24: OpKind = MCK_VRNoV0; break;
    case RISCV::V25: OpKind = MCK_VRNoV0; break;
    case RISCV::V26: OpKind = MCK_VRNoV0; break;
    case RISCV::V27: OpKind = MCK_VRNoV0; break;
    case RISCV::V28: OpKind = MCK_VRNoV0; break;
    case RISCV::V29: OpKind = MCK_VRNoV0; break;
    case RISCV::V30: OpKind = MCK_VRNoV0; break;
    case RISCV::V31: OpKind = MCK_VRNoV0; break;
    case RISCV::V0M2: OpKind = MCK_Reg23; break;
    case RISCV::V2M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V4M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V6M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V8M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V10M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V12M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V14M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V16M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V18M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V20M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V22M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V24M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V26M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V28M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V30M2: OpKind = MCK_VRM2NoV0; break;
    case RISCV::V0M4: OpKind = MCK_Reg26; break;
    case RISCV::V4M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V8M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V12M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V16M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V20M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V24M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V28M4: OpKind = MCK_VRM4NoV0; break;
    case RISCV::V0M8: OpKind = MCK_Reg29; break;
    case RISCV::V8M8: OpKind = MCK_VRM8NoV0; break;
    case RISCV::V16M8: OpKind = MCK_VRM8NoV0; break;
    case RISCV::V24M8: OpKind = MCK_VRM8NoV0; break;
    case RISCV::VTYPE: OpKind = MCK_VCSR; break;
    case RISCV::VL: OpKind = MCK_VCSR; break;
    case RISCV::VLENB: OpKind = MCK_VCSR; break;
    case RISCV::DUMMY_REG_PAIR_WITH_X0: OpKind = MCK_GPRAll; break;
    case RISCV::X0_Pair: OpKind = MCK_Reg33; break;
    case RISCV::X2_X3: OpKind = MCK_Reg35; break;
    case RISCV::X4_X5: OpKind = MCK_Reg37; break;
    case RISCV::X6_X7: OpKind = MCK_Reg40; break;
    case RISCV::X8_X9: OpKind = MCK_Reg41; break;
    case RISCV::X10_X11: OpKind = MCK_Reg44; break;
    case RISCV::X12_X13: OpKind = MCK_Reg44; break;
    case RISCV::X14_X15: OpKind = MCK_Reg44; break;
    case RISCV::X16_X17: OpKind = MCK_Reg40; break;
    case RISCV::X18_X19: OpKind = MCK_Reg43; break;
    case RISCV::X20_X21: OpKind = MCK_Reg43; break;
    case RISCV::X22_X23: OpKind = MCK_Reg43; break;
    case RISCV::X24_X25: OpKind = MCK_Reg39; break;
    case RISCV::X26_X27: OpKind = MCK_Reg39; break;
    case RISCV::X28_X29: OpKind = MCK_Reg40; break;
    case RISCV::X30_X31: OpKind = MCK_Reg40; break;
    case RISCV::V8_V9: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V9_V10: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V10_V11: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V11_V12: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V12_V13: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V13_V14: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V14_V15: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V15_V16: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V16_V17: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V17_V18: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V18_V19: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V19_V20: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V20_V21: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V21_V22: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V22_V23: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V23_V24: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V24_V25: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V25_V26: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V26_V27: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V27_V28: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V28_V29: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V29_V30: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V30_V31: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V1_V2: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V2_V3: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V3_V4: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V4_V5: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V5_V6: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V6_V7: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V7_V8: OpKind = MCK_VRN2M1NoV0; break;
    case RISCV::V0_V1: OpKind = MCK_Reg47; break;
    case RISCV::V8M2_V10M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V10M2_V12M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V12M2_V14M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V14M2_V16M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V16M2_V18M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V18M2_V20M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V20M2_V22M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V22M2_V24M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V24M2_V26M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V26M2_V28M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V28M2_V30M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V2M2_V4M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V4M2_V6M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V6M2_V8M2: OpKind = MCK_VRN2M2NoV0; break;
    case RISCV::V0M2_V2M2: OpKind = MCK_Reg50; break;
    case RISCV::V8M4_V12M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V12M4_V16M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V16M4_V20M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V20M4_V24M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V24M4_V28M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V4M4_V8M4: OpKind = MCK_VRN2M4NoV0; break;
    case RISCV::V0M4_V4M4: OpKind = MCK_Reg53; break;
    case RISCV::V8_V9_V10: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V9_V10_V11: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V10_V11_V12: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V11_V12_V13: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V12_V13_V14: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V13_V14_V15: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V14_V15_V16: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V15_V16_V17: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V16_V17_V18: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V17_V18_V19: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V18_V19_V20: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V19_V20_V21: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V20_V21_V22: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V21_V22_V23: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V22_V23_V24: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V23_V24_V25: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V24_V25_V26: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V25_V26_V27: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V26_V27_V28: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V27_V28_V29: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V28_V29_V30: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V29_V30_V31: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V1_V2_V3: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V2_V3_V4: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V3_V4_V5: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V4_V5_V6: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V5_V6_V7: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V6_V7_V8: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V7_V8_V9: OpKind = MCK_VRN3M1NoV0; break;
    case RISCV::V0_V1_V2: OpKind = MCK_Reg56; break;
    case RISCV::V8M2_V10M2_V12M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V10M2_V12M2_V14M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V12M2_V14M2_V16M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V14M2_V16M2_V18M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V16M2_V18M2_V20M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V18M2_V20M2_V22M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V20M2_V22M2_V24M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V22M2_V24M2_V26M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V24M2_V26M2_V28M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V26M2_V28M2_V30M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V2M2_V4M2_V6M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V4M2_V6M2_V8M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V6M2_V8M2_V10M2: OpKind = MCK_VRN3M2NoV0; break;
    case RISCV::V0M2_V2M2_V4M2: OpKind = MCK_Reg59; break;
    case RISCV::V8_V9_V10_V11: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V9_V10_V11_V12: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V10_V11_V12_V13: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V11_V12_V13_V14: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V12_V13_V14_V15: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V13_V14_V15_V16: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V14_V15_V16_V17: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V15_V16_V17_V18: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V16_V17_V18_V19: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V17_V18_V19_V20: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V18_V19_V20_V21: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V19_V20_V21_V22: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V20_V21_V22_V23: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V21_V22_V23_V24: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V22_V23_V24_V25: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V23_V24_V25_V26: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V24_V25_V26_V27: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V25_V26_V27_V28: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V26_V27_V28_V29: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V27_V28_V29_V30: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V28_V29_V30_V31: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V1_V2_V3_V4: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V2_V3_V4_V5: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V3_V4_V5_V6: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V4_V5_V6_V7: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V5_V6_V7_V8: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V6_V7_V8_V9: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V7_V8_V9_V10: OpKind = MCK_VRN4M1NoV0; break;
    case RISCV::V0_V1_V2_V3: OpKind = MCK_Reg62; break;
    case RISCV::V8M2_V10M2_V12M2_V14M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V10M2_V12M2_V14M2_V16M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V12M2_V14M2_V16M2_V18M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V14M2_V16M2_V18M2_V20M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V16M2_V18M2_V20M2_V22M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V18M2_V20M2_V22M2_V24M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V20M2_V22M2_V24M2_V26M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V22M2_V24M2_V26M2_V28M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V24M2_V26M2_V28M2_V30M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V2M2_V4M2_V6M2_V8M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V4M2_V6M2_V8M2_V10M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V6M2_V8M2_V10M2_V12M2: OpKind = MCK_VRN4M2NoV0; break;
    case RISCV::V0M2_V2M2_V4M2_V6M2: OpKind = MCK_Reg65; break;
    case RISCV::V8_V9_V10_V11_V12: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V25_V26_V27_V28_V29: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V26_V27_V28_V29_V30: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V27_V28_V29_V30_V31: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11: OpKind = MCK_VRN5M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4: OpKind = MCK_Reg68; break;
    case RISCV::V8_V9_V10_V11_V12_V13: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13_V14: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14_V15: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15_V16: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16_V17: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17_V18: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18_V19: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19_V20: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20_V21: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21_V22: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22_V23: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23_V24: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24_V25: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25_V26: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26_V27: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27_V28: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28_V29: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V25_V26_V27_V28_V29_V30: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V26_V27_V28_V29_V30_V31: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5_V6: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6_V7: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7_V8: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8_V9: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9_V10: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10_V11: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11_V12: OpKind = MCK_VRN6M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4_V5: OpKind = MCK_Reg71; break;
    case RISCV::V8_V9_V10_V11_V12_V13_V14: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13_V14_V15: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14_V15_V16: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15_V16_V17: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16_V17_V18: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17_V18_V19: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18_V19_V20: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19_V20_V21: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20_V21_V22: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21_V22_V23: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22_V23_V24: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23_V24_V25: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24_V25_V26: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25_V26_V27: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26_V27_V28: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27_V28_V29: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28_V29_V30: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V25_V26_V27_V28_V29_V30_V31: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5_V6_V7: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6_V7_V8: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7_V8_V9: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8_V9_V10: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9_V10_V11: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10_V11_V12: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11_V12_V13: OpKind = MCK_VRN7M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4_V5_V6: OpKind = MCK_Reg74; break;
    case RISCV::V8_V9_V10_V11_V12_V13_V14_V15: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V9_V10_V11_V12_V13_V14_V15_V16: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V10_V11_V12_V13_V14_V15_V16_V17: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V11_V12_V13_V14_V15_V16_V17_V18: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V12_V13_V14_V15_V16_V17_V18_V19: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V13_V14_V15_V16_V17_V18_V19_V20: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V14_V15_V16_V17_V18_V19_V20_V21: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V15_V16_V17_V18_V19_V20_V21_V22: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V16_V17_V18_V19_V20_V21_V22_V23: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V17_V18_V19_V20_V21_V22_V23_V24: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V18_V19_V20_V21_V22_V23_V24_V25: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V19_V20_V21_V22_V23_V24_V25_V26: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V20_V21_V22_V23_V24_V25_V26_V27: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V21_V22_V23_V24_V25_V26_V27_V28: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V22_V23_V24_V25_V26_V27_V28_V29: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V23_V24_V25_V26_V27_V28_V29_V30: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V24_V25_V26_V27_V28_V29_V30_V31: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V1_V2_V3_V4_V5_V6_V7_V8: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V2_V3_V4_V5_V6_V7_V8_V9: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V3_V4_V5_V6_V7_V8_V9_V10: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V4_V5_V6_V7_V8_V9_V10_V11: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V5_V6_V7_V8_V9_V10_V11_V12: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V6_V7_V8_V9_V10_V11_V12_V13: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V7_V8_V9_V10_V11_V12_V13_V14: OpKind = MCK_VRN8M1NoV0; break;
    case RISCV::V0_V1_V2_V3_V4_V5_V6_V7: OpKind = MCK_Reg77; break;
    }
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__40_: return "MCK__40_";
  case MCK__41_: return "MCK__41_";
  case MCK_Reg77: return "MCK_Reg77";
  case MCK_Reg74: return "MCK_Reg74";
  case MCK_Reg71: return "MCK_Reg71";
  case MCK_Reg68: return "MCK_Reg68";
  case MCK_Reg65: return "MCK_Reg65";
  case MCK_Reg62: return "MCK_Reg62";
  case MCK_Reg59: return "MCK_Reg59";
  case MCK_Reg56: return "MCK_Reg56";
  case MCK_Reg53: return "MCK_Reg53";
  case MCK_Reg50: return "MCK_Reg50";
  case MCK_Reg47: return "MCK_Reg47";
  case MCK_Reg41: return "MCK_Reg41";
  case MCK_Reg37: return "MCK_Reg37";
  case MCK_Reg35: return "MCK_Reg35";
  case MCK_Reg33: return "MCK_Reg33";
  case MCK_Reg29: return "MCK_Reg29";
  case MCK_Reg26: return "MCK_Reg26";
  case MCK_Reg23: return "MCK_Reg23";
  case MCK_GPRX0: return "MCK_GPRX0";
  case MCK_GPRX1: return "MCK_GPRX1";
  case MCK_GPRX5: return "MCK_GPRX5";
  case MCK_SP: return "MCK_SP";
  case MCK_VMV0: return "MCK_VMV0";
  case MCK_Reg11: return "MCK_Reg11";
  case MCK_GPRX1X5: return "MCK_GPRX1X5";
  case MCK_Reg44: return "MCK_Reg44";
  case MCK_VCSR: return "MCK_VCSR";
  case MCK_VRM8NoV0: return "MCK_VRM8NoV0";
  case MCK_Reg43: return "MCK_Reg43";
  case MCK_Reg42: return "MCK_Reg42";
  case MCK_VRM8: return "MCK_VRM8";
  case MCK_Reg14: return "MCK_Reg14";
  case MCK_VRN2M4NoV0: return "MCK_VRN2M4NoV0";
  case MCK_Reg40: return "MCK_Reg40";
  case MCK_VRM4NoV0: return "MCK_VRM4NoV0";
  case MCK_VRN2M4: return "MCK_VRN2M4";
  case MCK_FPR32C: return "MCK_FPR32C";
  case MCK_FPR64C: return "MCK_FPR64C";
  case MCK_GPRC: return "MCK_GPRC";
  case MCK_SR07: return "MCK_SR07";
  case MCK_VRM4: return "MCK_VRM4";
  case MCK_VRN4M2NoV0: return "MCK_VRN4M2NoV0";
  case MCK_Reg39: return "MCK_Reg39";
  case MCK_VRN3M2NoV0: return "MCK_VRN3M2NoV0";
  case MCK_VRN4M2: return "MCK_VRN4M2";
  case MCK_Reg38: return "MCK_Reg38";
  case MCK_GPRTC: return "MCK_GPRTC";
  case MCK_VRN2M2NoV0: return "MCK_VRN2M2NoV0";
  case MCK_VRN3M2: return "MCK_VRN3M2";
  case MCK_Reg36: return "MCK_Reg36";
  case MCK_VRM2NoV0: return "MCK_VRM2NoV0";
  case MCK_VRN2M2: return "MCK_VRN2M2";
  case MCK_GPRPair: return "MCK_GPRPair";
  case MCK_VRM2: return "MCK_VRM2";
  case MCK_VRN8M1NoV0: return "MCK_VRN8M1NoV0";
  case MCK_VRN7M1NoV0: return "MCK_VRN7M1NoV0";
  case MCK_VRN8M1: return "MCK_VRN8M1";
  case MCK_GPRJALR: return "MCK_GPRJALR";
  case MCK_VRN6M1NoV0: return "MCK_VRN6M1NoV0";
  case MCK_VRN7M1: return "MCK_VRN7M1";
  case MCK_VRN5M1NoV0: return "MCK_VRN5M1NoV0";
  case MCK_VRN6M1: return "MCK_VRN6M1";
  case MCK_VRN4M1NoV0: return "MCK_VRN4M1NoV0";
  case MCK_VRN5M1: return "MCK_VRN5M1";
  case MCK_VRN3M1NoV0: return "MCK_VRN3M1NoV0";
  case MCK_VRN4M1: return "MCK_VRN4M1";
  case MCK_GPRNoX0X2: return "MCK_GPRNoX0X2";
  case MCK_VRN2M1NoV0: return "MCK_VRN2M1NoV0";
  case MCK_VRN3M1: return "MCK_VRN3M1";
  case MCK_GPRNoX0: return "MCK_GPRNoX0";
  case MCK_VRN2M1: return "MCK_VRN2M1";
  case MCK_VRNoV0: return "MCK_VRNoV0";
  case MCK_FPR16: return "MCK_FPR16";
  case MCK_FPR32: return "MCK_FPR32";
  case MCK_FPR64: return "MCK_FPR64";
  case MCK_GPR: return "MCK_GPR";
  case MCK_VM: return "MCK_VM";
  case MCK_GPRAll: return "MCK_GPRAll";
  case MCK_AnyRegCOperand: return "MCK_AnyRegCOperand";
  case MCK_AnyRegOperand: return "MCK_AnyRegOperand";
  case MCK_BareSymbol: return "MCK_BareSymbol";
  case MCK_CLUIImm: return "MCK_CLUIImm";
  case MCK_CSRSystemRegister: return "MCK_CSRSystemRegister";
  case MCK_RegReg: return "MCK_RegReg";
  case MCK_CallSymbol: return "MCK_CallSymbol";
  case MCK_FRMArg: return "MCK_FRMArg";
  case MCK_FRMArgLegacy: return "MCK_FRMArgLegacy";
  case MCK_FenceArg: return "MCK_FenceArg";
  case MCK_GPRAsFPR: return "MCK_GPRAsFPR";
  case MCK_GPRF64AsFPR: return "MCK_GPRF64AsFPR";
  case MCK_GPRPairAsFPR: return "MCK_GPRPairAsFPR";
  case MCK_GPRPairRV32: return "MCK_GPRPairRV32";
  case MCK_GPRPairRV64: return "MCK_GPRPairRV64";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ImmZero: return "MCK_ImmZero";
  case MCK_InsnCDirectiveOpcode: return "MCK_InsnCDirectiveOpcode";
  case MCK_InsnDirectiveOpcode: return "MCK_InsnDirectiveOpcode";
  case MCK_LoadFPImm: return "MCK_LoadFPImm";
  case MCK_PseudoJumpSymbol: return "MCK_PseudoJumpSymbol";
  case MCK_RTZArg: return "MCK_RTZArg";
  case MCK_Rlist: return "MCK_Rlist";
  case MCK_RnumArg: return "MCK_RnumArg";
  case MCK_SImm5Plus1: return "MCK_SImm5Plus1";
  case MCK_SImm21Lsb0JAL: return "MCK_SImm21Lsb0JAL";
  case MCK_Spimm: return "MCK_Spimm";
  case MCK_TLSDESCCallSymbol: return "MCK_TLSDESCCallSymbol";
  case MCK_TPRelAddSymbol: return "MCK_TPRelAddSymbol";
  case MCK_UImmLog2XLen: return "MCK_UImmLog2XLen";
  case MCK_UImmLog2XLenHalf: return "MCK_UImmLog2XLenHalf";
  case MCK_UImmLog2XLenNonZero: return "MCK_UImmLog2XLenNonZero";
  case MCK_RVVMaskRegOpOperand: return "MCK_RVVMaskRegOpOperand";
  case MCK_ZeroOffsetMemOpOperand: return "MCK_ZeroOffsetMemOpOperand";
  case MCK_SImm6: return "MCK_SImm6";
  case MCK_SImm6NonZero: return "MCK_SImm6NonZero";
  case MCK_UImm7Lsb00: return "MCK_UImm7Lsb00";
  case MCK_UImm8Lsb00: return "MCK_UImm8Lsb00";
  case MCK_UImm8Lsb000: return "MCK_UImm8Lsb000";
  case MCK_SImm9Lsb0: return "MCK_SImm9Lsb0";
  case MCK_UImm9Lsb000: return "MCK_UImm9Lsb000";
  case MCK_UImm10Lsb00NonZero: return "MCK_UImm10Lsb00NonZero";
  case MCK_SImm10Lsb0000NonZero: return "MCK_SImm10Lsb0000NonZero";
  case MCK_SImm12Lsb0: return "MCK_SImm12Lsb0";
  case MCK_UImm2Lsb0: return "MCK_UImm2Lsb0";
  case MCK_UImm8GE32: return "MCK_UImm8GE32";
  case MCK_SImm12Lsb00000: return "MCK_SImm12Lsb00000";
  case MCK_UImm1: return "MCK_UImm1";
  case MCK_UImm2: return "MCK_UImm2";
  case MCK_UImm3: return "MCK_UImm3";
  case MCK_UImm4: return "MCK_UImm4";
  case MCK_UImm5: return "MCK_UImm5";
  case MCK_UImm6: return "MCK_UImm6";
  case MCK_UImm7: return "MCK_UImm7";
  case MCK_UImm8: return "MCK_UImm8";
  case MCK_SImm12: return "MCK_SImm12";
  case MCK_SImm13Lsb0: return "MCK_SImm13Lsb0";
  case MCK_UImm20LUI: return "MCK_UImm20LUI";
  case MCK_UImm20AUIPC: return "MCK_UImm20AUIPC";
  case MCK_UImm20: return "MCK_UImm20";
  case MCK_ImmXLenLI: return "MCK_ImmXLenLI";
  case MCK_ImmXLenLI_Restricted: return "MCK_ImmXLenLI_Restricted";
  case MCK_VTypeI10: return "MCK_VTypeI10";
  case MCK_VTypeI11: return "MCK_VTypeI11";
  case MCK_SImm5: return "MCK_SImm5";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset RISCVAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[RISCV::FeatureStdExtI])
    Features.set(Feature_HasStdExtIBit);
  if (FB[RISCV::FeatureStdExtZicbom])
    Features.set(Feature_HasStdExtZicbomBit);
  if (FB[RISCV::FeatureStdExtZicbop])
    Features.set(Feature_HasStdExtZicbopBit);
  if (FB[RISCV::FeatureStdExtZicboz])
    Features.set(Feature_HasStdExtZicbozBit);
  if (FB[RISCV::FeatureStdExtZicsr])
    Features.set(Feature_HasStdExtZicsrBit);
  if (FB[RISCV::FeatureStdExtZicond])
    Features.set(Feature_HasStdExtZicondBit);
  if (FB[RISCV::FeatureStdExtZifencei])
    Features.set(Feature_HasStdExtZifenceiBit);
  if (FB[RISCV::FeatureStdExtZihintpause])
    Features.set(Feature_HasStdExtZihintpauseBit);
  if (FB[RISCV::FeatureStdExtZihintntl])
    Features.set(Feature_HasStdExtZihintntlBit);
  if (FB[RISCV::FeatureStdExtZimop])
    Features.set(Feature_HasStdExtZimopBit);
  if (FB[RISCV::FeatureStdExtZicfilp])
    Features.set(Feature_HasStdExtZicfilpBit);
  if (FB[RISCV::FeatureStdExtZicfiss])
    Features.set(Feature_HasStdExtZicfissBit);
  if (FB[RISCV::FeatureStdExtM])
    Features.set(Feature_HasStdExtMBit);
  if (FB[RISCV::FeatureStdExtM] || FB[RISCV::FeatureStdExtZmmul])
    Features.set(Feature_HasStdExtMOrZmmulBit);
  if (FB[RISCV::FeatureStdExtA])
    Features.set(Feature_HasStdExtABit);
  if (FB[RISCV::FeatureStdExtZtso])
    Features.set(Feature_HasStdExtZtsoBit);
  if (FB[RISCV::FeatureStdExtZacas])
    Features.set(Feature_HasStdExtZacasBit);
  if (FB[RISCV::FeatureStdExtZawrs])
    Features.set(Feature_HasStdExtZawrsBit);
  if (FB[RISCV::FeatureStdExtF])
    Features.set(Feature_HasStdExtFBit);
  if (FB[RISCV::FeatureStdExtD])
    Features.set(Feature_HasStdExtDBit);
  if (FB[RISCV::FeatureStdExtZfhmin])
    Features.set(Feature_HasStdExtZfhminBit);
  if (FB[RISCV::FeatureStdExtZfh])
    Features.set(Feature_HasStdExtZfhBit);
  if (FB[RISCV::FeatureStdExtZfbfmin])
    Features.set(Feature_HasStdExtZfbfminBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZfhmin] || FB[RISCV::FeatureStdExtZfbfmin])
    Features.set(Feature_HasHalfFPLoadStoreMoveBit);
  if (FB[RISCV::FeatureStdExtZfa])
    Features.set(Feature_HasStdExtZfaBit);
  if (FB[RISCV::FeatureStdExtZfinx])
    Features.set(Feature_HasStdExtZfinxBit);
  if (FB[RISCV::FeatureStdExtZdinx])
    Features.set(Feature_HasStdExtZdinxBit);
  if (FB[RISCV::FeatureStdExtZhinxmin])
    Features.set(Feature_HasStdExtZhinxminBit);
  if (FB[RISCV::FeatureStdExtZhinx])
    Features.set(Feature_HasStdExtZhinxBit);
  if (FB[RISCV::FeatureStdExtC])
    Features.set(Feature_HasStdExtCBit);
  if (!FB[RISCV::FeatureNoRVCHints])
    Features.set(Feature_HasRVCHintsBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZca])
    Features.set(Feature_HasStdExtCOrZcaBit);
  if (FB[RISCV::FeatureStdExtZcb])
    Features.set(Feature_HasStdExtZcbBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcd])
    Features.set(Feature_HasStdExtCOrZcdBit);
  if (FB[RISCV::FeatureStdExtZcmp])
    Features.set(Feature_HasStdExtZcmpBit);
  if (FB[RISCV::FeatureStdExtZcmt])
    Features.set(Feature_HasStdExtZcmtBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcf] || FB[RISCV::FeatureStdExtZce])
    Features.set(Feature_HasStdExtCOrZcfOrZceBit);
  if (FB[RISCV::FeatureStdExtZcmop])
    Features.set(Feature_HasStdExtZcmopBit);
  if (FB[RISCV::FeatureStdExtZba])
    Features.set(Feature_HasStdExtZbaBit);
  if (FB[RISCV::FeatureStdExtZbb])
    Features.set(Feature_HasStdExtZbbBit);
  if (FB[RISCV::FeatureStdExtZbc])
    Features.set(Feature_HasStdExtZbcBit);
  if (FB[RISCV::FeatureStdExtZbs])
    Features.set(Feature_HasStdExtZbsBit);
  if (FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkx])
    Features.set(Feature_HasStdExtZbkxBit);
  if (FB[RISCV::FeatureStdExtZbb] || FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbkcBit);
  if (FB[RISCV::FeatureStdExtZbc] || FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (FB[RISCV::FeatureStdExtZknd])
    Features.set(Feature_HasStdExtZkndBit);
  if (FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkneBit);
  if (FB[RISCV::FeatureStdExtZknd] || FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (FB[RISCV::FeatureStdExtZknh])
    Features.set(Feature_HasStdExtZknhBit);
  if (FB[RISCV::FeatureStdExtZksed])
    Features.set(Feature_HasStdExtZksedBit);
  if (FB[RISCV::FeatureStdExtZksh])
    Features.set(Feature_HasStdExtZkshBit);
  if (FB[RISCV::FeatureStdExtZkr])
    Features.set(Feature_HasStdExtZkrBit);
  if (FB[RISCV::FeatureStdExtZvfbfmin])
    Features.set(Feature_HasStdExtZvfbfminBit);
  if (FB[RISCV::FeatureStdExtZvfbfwma])
    Features.set(Feature_HasStdExtZvfbfwmaBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZvfh])
    Features.set(Feature_HasStdExtZfhOrZvfhBit);
  if (FB[RISCV::FeatureStdExtZvkb])
    Features.set(Feature_HasStdExtZvkbBit);
  if (FB[RISCV::FeatureStdExtZvbb])
    Features.set(Feature_HasStdExtZvbbBit);
  if (FB[RISCV::FeatureStdExtZvbc])
    Features.set(Feature_HasStdExtZvbcBit);
  if (FB[RISCV::FeatureStdExtZvkg])
    Features.set(Feature_HasStdExtZvkgBit);
  if (FB[RISCV::FeatureStdExtZvkned])
    Features.set(Feature_HasStdExtZvknedBit);
  if (FB[RISCV::FeatureStdExtZvknha])
    Features.set(Feature_HasStdExtZvknhaBit);
  if (FB[RISCV::FeatureStdExtZvknhb])
    Features.set(Feature_HasStdExtZvknhbBit);
  if (FB[RISCV::FeatureStdExtZvknha] || FB[RISCV::FeatureStdExtZvknhb])
    Features.set(Feature_HasStdExtZvknhaOrZvknhbBit);
  if (FB[RISCV::FeatureStdExtZvksed])
    Features.set(Feature_HasStdExtZvksedBit);
  if (FB[RISCV::FeatureStdExtZvksh])
    Features.set(Feature_HasStdExtZvkshBit);
  if (FB[RISCV::FeatureStdExtZve32x])
    Features.set(Feature_HasVInstructionsBit);
  if (FB[RISCV::FeatureStdExtZve64x])
    Features.set(Feature_HasVInstructionsI64Bit);
  if (FB[RISCV::FeatureStdExtZve32f])
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (FB[RISCV::FeatureStdExtZvfhmin] || FB[RISCV::FeatureStdExtZvfh])
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (FB[RISCV::FeatureStdExtH])
    Features.set(Feature_HasStdExtHBit);
  if (FB[RISCV::FeatureStdExtSvinval])
    Features.set(Feature_HasStdExtSvinvalBit);
  if (FB[RISCV::FeatureVendorXVentanaCondOps])
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (FB[RISCV::FeatureVendorXTHeadBa])
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (FB[RISCV::FeatureVendorXTHeadBb])
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (FB[RISCV::FeatureVendorXTHeadBs])
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (FB[RISCV::FeatureVendorXTHeadCondMov])
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (FB[RISCV::FeatureVendorXTHeadCmo])
    Features.set(Feature_HasVendorXTHeadCmoBit);
  if (FB[RISCV::FeatureVendorXTHeadFMemIdx])
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMac])
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (FB[RISCV::FeatureVendorXTHeadMemIdx])
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMemPair])
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (FB[RISCV::FeatureVendorXTHeadSync])
    Features.set(Feature_HasVendorXTHeadSyncBit);
  if (FB[RISCV::FeatureVendorXTHeadVdot])
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (FB[RISCV::FeatureVendorXSfvcp])
    Features.set(Feature_HasVendorXSfvcpBit);
  if (FB[RISCV::FeatureVendorXSfvqmaccdod])
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (FB[RISCV::FeatureVendorXSfvqmaccqoq])
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (FB[RISCV::FeatureVendorXSfvfwmaccqqq])
    Features.set(Feature_HasVendorXSfvfwmaccqqqBit);
  if (FB[RISCV::FeatureVendorXSfvfnrclipxfqf])
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (FB[RISCV::FeatureVendorXCVelw])
    Features.set(Feature_HasVendorXCVelwBit);
  if (FB[RISCV::FeatureVendorXCVbitmanip])
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (FB[RISCV::FeatureVendorXCVmac])
    Features.set(Feature_HasVendorXCVmacBit);
  if (FB[RISCV::FeatureVendorXCVmem])
    Features.set(Feature_HasVendorXCVmemBit);
  if (FB[RISCV::FeatureVendorXCValu])
    Features.set(Feature_HasVendorXCValuBit);
  if (FB[RISCV::FeatureVendorXCVsimd])
    Features.set(Feature_HasVendorXCVsimdBit);
  if (FB[RISCV::FeatureVendorXCVbi])
    Features.set(Feature_HasVendorXCVbiBit);
  if (FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV64Bit);
  if (!FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV32Bit);
  if (FB[RISCV::FeatureRVE])
    Features.set(Feature_IsRVEBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const RISCVAsmParser&AsmParser,
                               unsigned Kind,
                               const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\007.insn_b\010.insn_ca\010.insn_cb\010.insn_ci\t.insn_ciw\010.insn_cj\010"
    ".insn_cl\010.insn_cr\010.insn_cs\t.insn_css\007.insn_i\007.insn_j\007.i"
    "nsn_r\010.insn_r4\007.insn_s\010.insn_sb\007.insn_u\010.insn_uj\003add\006"
    "add.uw\004addi\005addiw\004addw\010aes32dsi\taes32dsmi\010aes32esi\taes"
    "32esmi\007aes64ds\010aes64dsm\007aes64es\010aes64esm\007aes64im\taes64k"
    "s1i\010aes64ks2\010amoadd.d\013amoadd.d.aq\015amoadd.d.aqrl\013amoadd.d"
    ".rl\010amoadd.w\013amoadd.w.aq\015amoadd.w.aqrl\013amoadd.w.rl\010amoan"
    "d.d\013amoand.d.aq\015amoand.d.aqrl\013amoand.d.rl\010amoand.w\013amoan"
    "d.w.aq\015amoand.w.aqrl\013amoand.w.rl\010amocas.d\013amocas.d.aq\015am"
    "ocas.d.aqrl\013amocas.d.rl\010amocas.q\013amocas.q.aq\015amocas.q.aqrl\013"
    "amocas.q.rl\010amocas.w\013amocas.w.aq\015amocas.w.aqrl\013amocas.w.rl\010"
    "amomax.d\013amomax.d.aq\015amomax.d.aqrl\013amomax.d.rl\010amomax.w\013"
    "amomax.w.aq\015amomax.w.aqrl\013amomax.w.rl\tamomaxu.d\014amomaxu.d.aq\016"
    "amomaxu.d.aqrl\014amomaxu.d.rl\tamomaxu.w\014amomaxu.w.aq\016amomaxu.w."
    "aqrl\014amomaxu.w.rl\010amomin.d\013amomin.d.aq\015amomin.d.aqrl\013amo"
    "min.d.rl\010amomin.w\013amomin.w.aq\015amomin.w.aqrl\013amomin.w.rl\tam"
    "ominu.d\014amominu.d.aq\016amominu.d.aqrl\014amominu.d.rl\tamominu.w\014"
    "amominu.w.aq\016amominu.w.aqrl\014amominu.w.rl\007amoor.d\namoor.d.aq\014"
    "amoor.d.aqrl\namoor.d.rl\007amoor.w\namoor.w.aq\014amoor.w.aqrl\namoor."
    "w.rl\tamoswap.d\014amoswap.d.aq\016amoswap.d.aqrl\014amoswap.d.rl\tamos"
    "wap.w\014amoswap.w.aq\016amoswap.w.aqrl\014amoswap.w.rl\010amoxor.d\013"
    "amoxor.d.aq\015amoxor.d.aqrl\013amoxor.d.rl\010amoxor.w\013amoxor.w.aq\015"
    "amoxor.w.aqrl\013amoxor.w.rl\003and\004andi\004andn\005auipc\004bclr\005"
    "bclri\003beq\004beqz\004bext\005bexti\003bge\004bgeu\004bgez\003bgt\004"
    "bgtu\004bgtz\004binv\005binvi\003ble\004bleu\004blez\003blt\004bltu\004"
    "bltz\003bne\004bnez\005brev8\004bset\005bseti\005c.add\006c.addi\nc.add"
    "i16sp\nc.addi4spn\007c.addiw\006c.addw\005c.and\006c.andi\006c.beqz\006"
    "c.bnez\010c.ebreak\005c.fld\007c.fldsp\005c.flw\007c.flwsp\005c.fsd\007"
    "c.fsdsp\005c.fsw\007c.fswsp\003c.j\005c.jal\006c.jalr\004c.jr\005c.lbu\004"
    "c.ld\006c.ldsp\004c.lh\005c.lhu\004c.li\005c.lui\004c.lw\006c.lwsp\005c"
    ".mul\004c.mv\005c.nop\005c.not\tc.ntl.all\010c.ntl.p1\nc.ntl.pall\010c."
    "ntl.s1\004c.or\004c.sb\004c.sd\006c.sdsp\010c.sext.b\010c.sext.h\004c.s"
    "h\006c.slli\010c.slli64\006c.srai\010c.srai64\006c.srli\010c.srli64\nc."
    "sspopchk\010c.sspush\005c.sub\006c.subw\004c.sw\006c.swsp\007c.unimp\005"
    "c.xor\010c.zext.b\010c.zext.h\010c.zext.w\004call\tcbo.clean\tcbo.flush"
    "\tcbo.inval\010cbo.zero\005clmul\006clmulh\006clmulr\003clz\004clzw\007"
    "cm.jalt\005cm.jt\tcm.mva01s\tcm.mvsa01\006cm.pop\tcm.popret\ncm.popretz"
    "\007cm.push\006cmop.1\007cmop.11\007cmop.13\007cmop.15\006cmop.3\006cmo"
    "p.5\006cmop.7\006cmop.9\004cpop\005cpopw\004csrc\005csrci\004csrr\005cs"
    "rrc\006csrrci\005csrrs\006csrrsi\005csrrw\006csrrwi\004csrs\005csrsi\004"
    "csrw\005csrwi\003ctz\004ctzw\006cv.abs\010cv.abs.b\010cv.abs.h\010cv.ad"
    "d.b\013cv.add.div2\013cv.add.div4\013cv.add.div8\010cv.add.h\013cv.add."
    "sc.b\013cv.add.sc.h\014cv.add.sci.b\014cv.add.sci.h\007cv.addn\010cv.ad"
    "dnr\010cv.addrn\tcv.addrnr\010cv.addun\tcv.addunr\tcv.addurn\ncv.addurn"
    "r\010cv.and.b\010cv.and.h\013cv.and.sc.b\013cv.and.sc.h\014cv.and.sci.b"
    "\014cv.and.sci.h\010cv.avg.b\010cv.avg.h\013cv.avg.sc.b\013cv.avg.sc.h\014"
    "cv.avg.sci.b\014cv.avg.sci.h\tcv.avgu.b\tcv.avgu.h\014cv.avgu.sc.b\014c"
    "v.avgu.sc.h\015cv.avgu.sci.b\015cv.avgu.sci.h\007cv.bclr\010cv.bclrr\tc"
    "v.beqimm\tcv.bitrev\tcv.bneimm\007cv.bset\010cv.bsetr\006cv.clb\007cv.c"
    "lip\010cv.clipr\010cv.clipu\tcv.clipur\ncv.cmpeq.b\ncv.cmpeq.h\015cv.cm"
    "peq.sc.b\015cv.cmpeq.sc.h\016cv.cmpeq.sci.b\016cv.cmpeq.sci.h\ncv.cmpge"
    ".b\ncv.cmpge.h\015cv.cmpge.sc.b\015cv.cmpge.sc.h\016cv.cmpge.sci.b\016c"
    "v.cmpge.sci.h\013cv.cmpgeu.b\013cv.cmpgeu.h\016cv.cmpgeu.sc.b\016cv.cmp"
    "geu.sc.h\017cv.cmpgeu.sci.b\017cv.cmpgeu.sci.h\ncv.cmpgt.b\ncv.cmpgt.h\015"
    "cv.cmpgt.sc.b\015cv.cmpgt.sc.h\016cv.cmpgt.sci.b\016cv.cmpgt.sci.h\013c"
    "v.cmpgtu.b\013cv.cmpgtu.h\016cv.cmpgtu.sc.b\016cv.cmpgtu.sc.h\017cv.cmp"
    "gtu.sci.b\017cv.cmpgtu.sci.h\ncv.cmple.b\ncv.cmple.h\015cv.cmple.sc.b\015"
    "cv.cmple.sc.h\016cv.cmple.sci.b\016cv.cmple.sci.h\013cv.cmpleu.b\013cv."
    "cmpleu.h\016cv.cmpleu.sc.b\016cv.cmpleu.sc.h\017cv.cmpleu.sci.b\017cv.c"
    "mpleu.sci.h\ncv.cmplt.b\ncv.cmplt.h\015cv.cmplt.sc.b\015cv.cmplt.sc.h\016"
    "cv.cmplt.sci.b\016cv.cmplt.sci.h\013cv.cmpltu.b\013cv.cmpltu.h\016cv.cm"
    "pltu.sc.b\016cv.cmpltu.sc.h\017cv.cmpltu.sci.b\017cv.cmpltu.sci.h\ncv.c"
    "mpne.b\ncv.cmpne.h\015cv.cmpne.sc.b\015cv.cmpne.sc.h\016cv.cmpne.sci.b\016"
    "cv.cmpne.sci.h\006cv.cnt\013cv.cplxconj\014cv.cplxmul.i\021cv.cplxmul.i"
    ".div2\021cv.cplxmul.i.div4\021cv.cplxmul.i.div8\014cv.cplxmul.r\021cv.c"
    "plxmul.r.div2\021cv.cplxmul.r.div4\021cv.cplxmul.r.div8\ncv.dotsp.b\ncv"
    ".dotsp.h\015cv.dotsp.sc.b\015cv.dotsp.sc.h\016cv.dotsp.sci.b\016cv.dots"
    "p.sci.h\ncv.dotup.b\ncv.dotup.h\015cv.dotup.sc.b\015cv.dotup.sc.h\016cv"
    ".dotup.sci.b\016cv.dotup.sci.h\013cv.dotusp.b\013cv.dotusp.h\016cv.dotu"
    "sp.sc.b\016cv.dotusp.sc.h\017cv.dotusp.sci.b\017cv.dotusp.sci.h\006cv.e"
    "lw\010cv.extbs\010cv.extbz\010cv.exths\010cv.exthz\ncv.extract\014cv.ex"
    "tract.b\014cv.extract.h\013cv.extractr\013cv.extractu\015cv.extractu.b\015"
    "cv.extractu.h\014cv.extractur\006cv.ff1\006cv.fl1\tcv.insert\013cv.inse"
    "rt.b\013cv.insert.h\ncv.insertr\005cv.lb\006cv.lbu\005cv.lh\006cv.lhu\005"
    "cv.lw\006cv.mac\ncv.machhsn\013cv.machhsrn\ncv.machhun\013cv.machhurn\010"
    "cv.macsn\tcv.macsrn\010cv.macun\tcv.macurn\006cv.max\010cv.max.b\010cv."
    "max.h\013cv.max.sc.b\013cv.max.sc.h\014cv.max.sci.b\014cv.max.sci.h\007"
    "cv.maxu\tcv.maxu.b\tcv.maxu.h\014cv.maxu.sc.b\014cv.maxu.sc.h\015cv.max"
    "u.sci.b\015cv.maxu.sci.h\006cv.min\010cv.min.b\010cv.min.h\013cv.min.sc"
    ".b\013cv.min.sc.h\014cv.min.sci.b\014cv.min.sci.h\007cv.minu\tcv.minu.b"
    "\tcv.minu.h\014cv.minu.sc.b\014cv.minu.sc.h\015cv.minu.sci.b\015cv.minu"
    ".sci.h\006cv.msu\tcv.mulhhs\ncv.mulhhsn\013cv.mulhhsrn\tcv.mulhhu\ncv.m"
    "ulhhun\013cv.mulhhurn\007cv.muls\010cv.mulsn\tcv.mulsrn\007cv.mulu\010c"
    "v.mulun\tcv.mulurn\007cv.or.b\007cv.or.h\ncv.or.sc.b\ncv.or.sc.h\013cv."
    "or.sci.b\013cv.or.sci.h\007cv.pack\tcv.pack.h\013cv.packhi.b\013cv.pack"
    "lo.b\006cv.ror\005cv.sb\013cv.sdotsp.b\013cv.sdotsp.h\016cv.sdotsp.sc.b"
    "\016cv.sdotsp.sc.h\017cv.sdotsp.sci.b\017cv.sdotsp.sci.h\013cv.sdotup.b"
    "\013cv.sdotup.h\016cv.sdotup.sc.b\016cv.sdotup.sc.h\017cv.sdotup.sci.b\017"
    "cv.sdotup.sci.h\014cv.sdotusp.b\014cv.sdotusp.h\017cv.sdotusp.sc.b\017c"
    "v.sdotusp.sc.h\020cv.sdotusp.sci.b\020cv.sdotusp.sci.h\005cv.sh\014cv.s"
    "huffle.b\014cv.shuffle.h\020cv.shuffle.sci.h\015cv.shuffle2.b\015cv.shu"
    "ffle2.h\022cv.shufflei0.sci.b\022cv.shufflei1.sci.b\022cv.shufflei2.sci"
    ".b\022cv.shufflei3.sci.b\007cv.slet\010cv.sletu\010cv.sll.b\010cv.sll.h"
    "\013cv.sll.sc.b\013cv.sll.sc.h\014cv.sll.sci.b\014cv.sll.sci.h\010cv.sr"
    "a.b\010cv.sra.h\013cv.sra.sc.b\013cv.sra.sc.h\014cv.sra.sci.b\014cv.sra"
    ".sci.h\010cv.srl.b\010cv.srl.h\013cv.srl.sc.b\013cv.srl.sc.h\014cv.srl."
    "sci.b\014cv.srl.sci.h\010cv.sub.b\013cv.sub.div2\013cv.sub.div4\013cv.s"
    "ub.div8\010cv.sub.h\013cv.sub.sc.b\013cv.sub.sc.h\014cv.sub.sci.b\014cv"
    ".sub.sci.h\007cv.subn\010cv.subnr\010cv.subrn\tcv.subrnr\013cv.subrotmj"
    "\020cv.subrotmj.div2\020cv.subrotmj.div4\020cv.subrotmj.div8\010cv.subu"
    "n\tcv.subunr\tcv.suburn\ncv.suburnr\005cv.sw\010cv.xor.b\010cv.xor.h\013"
    "cv.xor.sc.b\013cv.xor.sc.h\014cv.xor.sci.b\014cv.xor.sci.h\tczero.eqz\t"
    "czero.nez\003div\004divu\005divuw\004divw\004dret\006ebreak\005ecall\006"
    "fabs.d\006fabs.h\006fabs.s\006fadd.d\006fadd.h\006fadd.s\010fclass.d\010"
    "fclass.h\010fclass.s\013fcvt.bf16.s\010fcvt.d.h\010fcvt.d.l\tfcvt.d.lu\010"
    "fcvt.d.s\010fcvt.d.w\tfcvt.d.wu\010fcvt.h.d\010fcvt.h.l\tfcvt.h.lu\010f"
    "cvt.h.s\010fcvt.h.w\tfcvt.h.wu\010fcvt.l.d\010fcvt.l.h\010fcvt.l.s\tfcv"
    "t.lu.d\tfcvt.lu.h\tfcvt.lu.s\013fcvt.s.bf16\010fcvt.s.d\010fcvt.s.h\010"
    "fcvt.s.l\tfcvt.s.lu\010fcvt.s.w\tfcvt.s.wu\010fcvt.w.d\010fcvt.w.h\010f"
    "cvt.w.s\tfcvt.wu.d\tfcvt.wu.h\tfcvt.wu.s\013fcvtmod.w.d\006fdiv.d\006fd"
    "iv.h\006fdiv.s\005fence\007fence.i\tfence.tso\005feq.d\005feq.h\005feq."
    "s\005fge.d\005fge.h\005fge.s\006fgeq.d\006fgeq.h\006fgeq.s\005fgt.d\005"
    "fgt.h\005fgt.s\006fgtq.d\006fgtq.h\006fgtq.s\003fld\005fle.d\005fle.h\005"
    "fle.s\006fleq.d\006fleq.h\006fleq.s\003flh\005fli.d\005fli.h\005fli.s\005"
    "flt.d\005flt.h\005flt.s\006fltq.d\006fltq.h\006fltq.s\003flw\007fmadd.d"
    "\007fmadd.h\007fmadd.s\006fmax.d\006fmax.h\006fmax.s\007fmaxm.d\007fmax"
    "m.h\007fmaxm.s\006fmin.d\006fmin.h\006fmin.s\007fminm.d\007fminm.h\007f"
    "minm.s\007fmsub.d\007fmsub.h\007fmsub.s\006fmul.d\006fmul.h\006fmul.s\005"
    "fmv.d\007fmv.d.x\005fmv.h\007fmv.h.x\005fmv.s\007fmv.w.x\007fmv.x.d\007"
    "fmv.x.h\007fmv.x.w\010fmvh.x.d\010fmvp.d.x\006fneg.d\006fneg.h\006fneg."
    "s\010fnmadd.d\010fnmadd.h\010fnmadd.s\010fnmsub.d\010fnmsub.h\010fnmsub"
    ".s\005frcsr\007frflags\010fround.d\010fround.h\010fround.s\nfroundnx.d\n"
    "froundnx.h\nfroundnx.s\004frrm\004frsr\005fscsr\003fsd\007fsflags\010fs"
    "flagsi\007fsgnj.d\007fsgnj.h\007fsgnj.s\010fsgnjn.d\010fsgnjn.h\010fsgn"
    "jn.s\010fsgnjx.d\010fsgnjx.h\010fsgnjx.s\003fsh\007fsqrt.d\007fsqrt.h\007"
    "fsqrt.s\004fsrm\005fsrmi\004fssr\006fsub.d\006fsub.h\006fsub.s\003fsw\013"
    "hfence.gvma\013hfence.vvma\013hinval.gvma\013hinval.vvma\005hlv.b\006hl"
    "v.bu\005hlv.d\005hlv.h\006hlv.hu\005hlv.w\006hlv.wu\007hlvx.hu\007hlvx."
    "wu\005hsv.b\005hsv.d\005hsv.h\005hsv.w\001j\003jal\004jalr\002jr\004jum"
    "p\002la\tla.tls.gd\tla.tls.ie\nla.tlsdesc\002lb\003lbu\002ld\003lga\002"
    "lh\003lhu\002li\003lla\004lpad\004lr.d\007lr.d.aq\tlr.d.aqrl\007lr.d.rl"
    "\004lr.w\007lr.w.aq\tlr.w.aqrl\007lr.w.rl\003lui\002lw\003lwu\003max\004"
    "maxu\003min\004minu\007mop.r.0\007mop.r.1\010mop.r.10\010mop.r.11\010mo"
    "p.r.12\010mop.r.13\010mop.r.14\010mop.r.15\010mop.r.16\010mop.r.17\010m"
    "op.r.18\010mop.r.19\007mop.r.2\010mop.r.20\010mop.r.21\010mop.r.22\010m"
    "op.r.23\010mop.r.24\010mop.r.25\010mop.r.26\010mop.r.27\010mop.r.28\010"
    "mop.r.29\007mop.r.3\010mop.r.30\010mop.r.31\007mop.r.4\007mop.r.5\007mo"
    "p.r.6\007mop.r.7\007mop.r.8\007mop.r.9\010mop.rr.0\010mop.rr.1\010mop.r"
    "r.2\010mop.rr.3\010mop.rr.4\010mop.rr.5\010mop.rr.6\010mop.rr.7\004mret"
    "\003mul\004mulh\006mulhsu\005mulhu\004mulw\002mv\003neg\004negw\003nop\003"
    "not\007ntl.all\006ntl.p1\010ntl.pall\006ntl.s1\002or\005orc.b\003ori\003"
    "orn\004pack\005packh\005packw\005pause\nprefetch.i\nprefetch.r\nprefetc"
    "h.w\007rdcycle\010rdcycleh\trdinstret\nrdinstreth\006rdtime\007rdtimeh\003"
    "rem\004remu\005remuw\004remw\003ret\004rev8\003rol\004rolw\003ror\004ro"
    "ri\005roriw\004rorw\002sb\004sc.d\007sc.d.aq\tsc.d.aqrl\007sc.d.rl\004s"
    "c.w\007sc.w.aq\tsc.w.aqrl\007sc.w.rl\002sd\004seqz\006sext.b\006sext.h\006"
    "sext.w\010sf.vc.fv\tsf.vc.fvv\tsf.vc.fvw\007sf.vc.i\010sf.vc.iv\tsf.vc."
    "ivv\tsf.vc.ivw\nsf.vc.v.fv\013sf.vc.v.fvv\013sf.vc.v.fvw\tsf.vc.v.i\nsf"
    ".vc.v.iv\013sf.vc.v.ivv\013sf.vc.v.ivw\nsf.vc.v.vv\013sf.vc.v.vvv\013sf"
    ".vc.v.vvw\tsf.vc.v.x\nsf.vc.v.xv\013sf.vc.v.xvv\013sf.vc.v.xvw\010sf.vc"
    ".vv\tsf.vc.vvv\tsf.vc.vvw\007sf.vc.x\010sf.vc.xv\tsf.vc.xvv\tsf.vc.xvw\022"
    "sf.vfnrclip.x.f.qf\023sf.vfnrclip.xu.f.qf\020sf.vfwmacc.4x4x4\017sf.vqm"
    "acc.2x8x2\017sf.vqmacc.4x8x4\021sf.vqmaccsu.2x8x2\021sf.vqmaccsu.4x8x4\020"
    "sf.vqmaccu.2x8x2\020sf.vqmaccu.4x8x4\021sf.vqmaccus.2x8x2\021sf.vqmaccu"
    "s.4x8x4\017sfence.inval.ir\nsfence.vma\016sfence.w.inval\003sgt\004sgtu"
    "\004sgtz\002sh\006sh1add\tsh1add.uw\006sh2add\tsh2add.uw\006sh3add\tsh3"
    "add.uw\nsha256sig0\nsha256sig1\nsha256sum0\nsha256sum1\nsha512sig0\013s"
    "ha512sig0h\013sha512sig0l\nsha512sig1\013sha512sig1h\013sha512sig1l\nsh"
    "a512sum0\013sha512sum0r\nsha512sum1\013sha512sum1r\nsinval.vma\003sll\004"
    "slli\007slli.uw\005slliw\004sllw\003slt\004slti\005sltiu\004sltu\004slt"
    "z\005sm3p0\005sm3p1\005sm4ed\005sm4ks\004snez\003sra\004srai\005sraiw\004"
    "sraw\004sret\003srl\004srli\005srliw\004srlw\013ssamoswap.d\016ssamoswa"
    "p.d.aq\020ssamoswap.d.aqrl\016ssamoswap.d.rl\013ssamoswap.w\016ssamoswa"
    "p.w.aq\020ssamoswap.w.aqrl\016ssamoswap.w.rl\010sspopchk\006sspush\005s"
    "srdp\003sub\004subw\002sw\004tail\010th.addsl\016th.dcache.call\017th.d"
    "cache.ciall\016th.dcache.cipa\016th.dcache.cisw\016th.dcache.civa\015th"
    ".dcache.cpa\017th.dcache.cpal1\015th.dcache.csw\015th.dcache.cva\017th."
    "dcache.cval1\016th.dcache.iall\015th.dcache.ipa\015th.dcache.isw\015th."
    "dcache.iva\006th.ext\007th.extu\006th.ff0\006th.ff1\007th.flrd\007th.fl"
    "rw\010th.flurd\010th.flurw\007th.fsrd\007th.fsrw\010th.fsurd\010th.fsur"
    "w\016th.icache.iall\017th.icache.ialls\015th.icache.ipa\015th.icache.iv"
    "a\017th.l2cache.call\020th.l2cache.ciall\017th.l2cache.iall\007th.lbia\007"
    "th.lbib\010th.lbuia\010th.lbuib\006th.ldd\007th.ldia\007th.ldib\007th.l"
    "hia\007th.lhib\010th.lhuia\010th.lhuib\006th.lrb\007th.lrbu\006th.lrd\006"
    "th.lrh\007th.lrhu\006th.lrw\007th.lrwu\007th.lurb\010th.lurbu\007th.lur"
    "d\007th.lurh\010th.lurhu\007th.lurw\010th.lurwu\006th.lwd\007th.lwia\007"
    "th.lwib\007th.lwud\010th.lwuia\010th.lwuib\007th.mula\010th.mulah\010th"
    ".mulaw\007th.muls\010th.mulsh\010th.mulsw\010th.mveqz\010th.mvnez\006th"
    ".rev\007th.revw\007th.sbia\007th.sbib\006th.sdd\007th.sdia\007th.sdib\016"
    "th.sfence.vmas\007th.shia\007th.shib\006th.srb\006th.srd\006th.srh\007t"
    "h.srri\010th.srriw\006th.srw\007th.surb\007th.surd\007th.surh\007th.sur"
    "w\006th.swd\007th.swia\007th.swib\007th.sync\tth.sync.i\nth.sync.is\tth"
    ".sync.s\006th.tst\tth.tstnbz\013th.vmaqa.vv\013th.vmaqa.vx\015th.vmaqas"
    "u.vv\015th.vmaqasu.vx\014th.vmaqau.vv\014th.vmaqau.vx\015th.vmaqaus.vx\005"
    "unimp\005unzip\010vaadd.vv\010vaadd.vx\tvaaddu.vv\tvaaddu.vx\010vadc.vi"
    "m\010vadc.vvm\010vadc.vxm\007vadd.vi\007vadd.vv\007vadd.vx\tvaesdf.vs\t"
    "vaesdf.vv\tvaesdm.vs\tvaesdm.vv\tvaesef.vs\tvaesef.vv\tvaesem.vs\tvaese"
    "m.vv\nvaeskf1.vi\nvaeskf2.vi\010vaesz.vs\007vand.vi\007vand.vv\007vand."
    "vx\010vandn.vv\010vandn.vx\010vasub.vv\010vasub.vx\tvasubu.vv\tvasubu.v"
    "x\007vbrev.v\010vbrev8.v\tvclmul.vv\tvclmul.vx\nvclmulh.vv\nvclmulh.vx\006"
    "vclz.v\014vcompress.vm\007vcpop.m\007vcpop.v\006vctz.v\007vdiv.vv\007vd"
    "iv.vx\010vdivu.vv\010vdivu.vx\007vfabs.v\010vfadd.vf\010vfadd.vv\tvfcla"
    "ss.v\013vfcvt.f.x.v\014vfcvt.f.xu.v\017vfcvt.rtz.x.f.v\020vfcvt.rtz.xu."
    "f.v\013vfcvt.x.f.v\014vfcvt.xu.f.v\010vfdiv.vf\010vfdiv.vv\010vfirst.m\t"
    "vfmacc.vf\tvfmacc.vv\tvfmadd.vf\tvfmadd.vv\010vfmax.vf\010vfmax.vv\013v"
    "fmerge.vfm\010vfmin.vf\010vfmin.vv\tvfmsac.vf\tvfmsac.vv\tvfmsub.vf\tvf"
    "msub.vv\010vfmul.vf\010vfmul.vv\010vfmv.f.s\010vfmv.s.f\010vfmv.v.f\014"
    "vfncvt.f.f.w\014vfncvt.f.x.w\015vfncvt.f.xu.w\020vfncvt.rod.f.f.w\020vf"
    "ncvt.rtz.x.f.w\021vfncvt.rtz.xu.f.w\014vfncvt.x.f.w\015vfncvt.xu.f.w\020"
    "vfncvtbf16.f.f.w\007vfneg.v\nvfnmacc.vf\nvfnmacc.vv\nvfnmadd.vf\nvfnmad"
    "d.vv\nvfnmsac.vf\nvfnmsac.vv\nvfnmsub.vf\nvfnmsub.vv\tvfrdiv.vf\010vfre"
    "c7.v\013vfredmax.vs\013vfredmin.vs\014vfredosum.vs\013vfredsum.vs\014vf"
    "redusum.vs\nvfrsqrt7.v\tvfrsub.vf\tvfsgnj.vf\tvfsgnj.vv\nvfsgnjn.vf\nvf"
    "sgnjn.vv\nvfsgnjx.vf\nvfsgnjx.vv\017vfslide1down.vf\015vfslide1up.vf\010"
    "vfsqrt.v\010vfsub.vf\010vfsub.vv\tvfwadd.vf\tvfwadd.vv\tvfwadd.wf\tvfwa"
    "dd.wv\014vfwcvt.f.f.v\014vfwcvt.f.x.v\015vfwcvt.f.xu.v\020vfwcvt.rtz.x."
    "f.v\021vfwcvt.rtz.xu.f.v\014vfwcvt.x.f.v\015vfwcvt.xu.f.v\020vfwcvtbf16"
    ".f.f.v\nvfwmacc.vf\nvfwmacc.vv\016vfwmaccbf16.vf\016vfwmaccbf16.vv\nvfw"
    "msac.vf\nvfwmsac.vv\tvfwmul.vf\tvfwmul.vv\013vfwnmacc.vf\013vfwnmacc.vv"
    "\013vfwnmsac.vf\013vfwnmsac.vv\015vfwredosum.vs\014vfwredsum.vs\015vfwr"
    "edusum.vs\tvfwsub.vf\tvfwsub.vv\tvfwsub.wf\tvfwsub.wv\010vghsh.vv\010vg"
    "mul.vv\005vid.v\007viota.m\006vl1r.v\tvl1re16.v\tvl1re32.v\tvl1re64.v\010"
    "vl1re8.v\006vl2r.v\tvl2re16.v\tvl2re32.v\tvl2re64.v\010vl2re8.v\006vl4r"
    ".v\tvl4re16.v\tvl4re32.v\tvl4re64.v\010vl4re8.v\006vl8r.v\tvl8re16.v\tv"
    "l8re32.v\tvl8re64.v\010vl8re8.v\006vle1.v\007vle16.v\tvle16ff.v\007vle3"
    "2.v\tvle32ff.v\007vle64.v\tvle64ff.v\006vle8.v\010vle8ff.v\005vlm.v\nvl"
    "oxei16.v\nvloxei32.v\nvloxei64.v\tvloxei8.v\016vloxseg2ei16.v\016vloxse"
    "g2ei32.v\016vloxseg2ei64.v\015vloxseg2ei8.v\016vloxseg3ei16.v\016vloxse"
    "g3ei32.v\016vloxseg3ei64.v\015vloxseg3ei8.v\016vloxseg4ei16.v\016vloxse"
    "g4ei32.v\016vloxseg4ei64.v\015vloxseg4ei8.v\016vloxseg5ei16.v\016vloxse"
    "g5ei32.v\016vloxseg5ei64.v\015vloxseg5ei8.v\016vloxseg6ei16.v\016vloxse"
    "g6ei32.v\016vloxseg6ei64.v\015vloxseg6ei8.v\016vloxseg7ei16.v\016vloxse"
    "g7ei32.v\016vloxseg7ei64.v\015vloxseg7ei8.v\016vloxseg8ei16.v\016vloxse"
    "g8ei32.v\016vloxseg8ei64.v\015vloxseg8ei8.v\010vlse16.v\010vlse32.v\010"
    "vlse64.v\007vlse8.v\013vlseg2e16.v\015vlseg2e16ff.v\013vlseg2e32.v\015v"
    "lseg2e32ff.v\013vlseg2e64.v\015vlseg2e64ff.v\nvlseg2e8.v\014vlseg2e8ff."
    "v\013vlseg3e16.v\015vlseg3e16ff.v\013vlseg3e32.v\015vlseg3e32ff.v\013vl"
    "seg3e64.v\015vlseg3e64ff.v\nvlseg3e8.v\014vlseg3e8ff.v\013vlseg4e16.v\015"
    "vlseg4e16ff.v\013vlseg4e32.v\015vlseg4e32ff.v\013vlseg4e64.v\015vlseg4e"
    "64ff.v\nvlseg4e8.v\014vlseg4e8ff.v\013vlseg5e16.v\015vlseg5e16ff.v\013v"
    "lseg5e32.v\015vlseg5e32ff.v\013vlseg5e64.v\015vlseg5e64ff.v\nvlseg5e8.v"
    "\014vlseg5e8ff.v\013vlseg6e16.v\015vlseg6e16ff.v\013vlseg6e32.v\015vlse"
    "g6e32ff.v\013vlseg6e64.v\015vlseg6e64ff.v\nvlseg6e8.v\014vlseg6e8ff.v\013"
    "vlseg7e16.v\015vlseg7e16ff.v\013vlseg7e32.v\015vlseg7e32ff.v\013vlseg7e"
    "64.v\015vlseg7e64ff.v\nvlseg7e8.v\014vlseg7e8ff.v\013vlseg8e16.v\015vls"
    "eg8e16ff.v\013vlseg8e32.v\015vlseg8e32ff.v\013vlseg8e64.v\015vlseg8e64f"
    "f.v\nvlseg8e8.v\014vlseg8e8ff.v\014vlsseg2e16.v\014vlsseg2e32.v\014vlss"
    "eg2e64.v\013vlsseg2e8.v\014vlsseg3e16.v\014vlsseg3e32.v\014vlsseg3e64.v"
    "\013vlsseg3e8.v\014vlsseg4e16.v\014vlsseg4e32.v\014vlsseg4e64.v\013vlss"
    "eg4e8.v\014vlsseg5e16.v\014vlsseg5e32.v\014vlsseg5e64.v\013vlsseg5e8.v\014"
    "vlsseg6e16.v\014vlsseg6e32.v\014vlsseg6e64.v\013vlsseg6e8.v\014vlsseg7e"
    "16.v\014vlsseg7e32.v\014vlsseg7e64.v\013vlsseg7e8.v\014vlsseg8e16.v\014"
    "vlsseg8e32.v\014vlsseg8e64.v\013vlsseg8e8.v\nvluxei16.v\nvluxei32.v\nvl"
    "uxei64.v\tvluxei8.v\016vluxseg2ei16.v\016vluxseg2ei32.v\016vluxseg2ei64"
    ".v\015vluxseg2ei8.v\016vluxseg3ei16.v\016vluxseg3ei32.v\016vluxseg3ei64"
    ".v\015vluxseg3ei8.v\016vluxseg4ei16.v\016vluxseg4ei32.v\016vluxseg4ei64"
    ".v\015vluxseg4ei8.v\016vluxseg5ei16.v\016vluxseg5ei32.v\016vluxseg5ei64"
    ".v\015vluxseg5ei8.v\016vluxseg6ei16.v\016vluxseg6ei32.v\016vluxseg6ei64"
    ".v\015vluxseg6ei8.v\016vluxseg7ei16.v\016vluxseg7ei32.v\016vluxseg7ei64"
    ".v\015vluxseg7ei8.v\016vluxseg8ei16.v\016vluxseg8ei32.v\016vluxseg8ei64"
    ".v\015vluxseg8ei8.v\010vmacc.vv\010vmacc.vx\010vmadc.vi\tvmadc.vim\010v"
    "madc.vv\tvmadc.vvm\010vmadc.vx\tvmadc.vxm\010vmadd.vv\010vmadd.vx\010vm"
    "and.mm\tvmandn.mm\013vmandnot.mm\007vmax.vv\007vmax.vx\010vmaxu.vv\010v"
    "maxu.vx\007vmclr.m\nvmerge.vim\nvmerge.vvm\nvmerge.vxm\010vmfeq.vf\010v"
    "mfeq.vv\010vmfge.vf\010vmfge.vv\010vmfgt.vf\010vmfgt.vv\010vmfle.vf\010"
    "vmfle.vv\010vmflt.vf\010vmflt.vv\010vmfne.vf\010vmfne.vv\007vmin.vv\007"
    "vmin.vx\010vminu.vv\010vminu.vx\006vmmv.m\tvmnand.mm\010vmnor.mm\007vmn"
    "ot.m\007vmor.mm\010vmorn.mm\nvmornot.mm\010vmsbc.vv\tvmsbc.vvm\010vmsbc"
    ".vx\tvmsbc.vxm\007vmsbf.m\010vmseq.vi\010vmseq.vv\010vmseq.vx\007vmset."
    "m\010vmsge.vi\010vmsge.vv\010vmsge.vx\tvmsgeu.vi\tvmsgeu.vv\tvmsgeu.vx\010"
    "vmsgt.vi\010vmsgt.vv\010vmsgt.vx\tvmsgtu.vi\tvmsgtu.vv\tvmsgtu.vx\007vm"
    "sif.m\010vmsle.vi\010vmsle.vv\010vmsle.vx\tvmsleu.vi\tvmsleu.vv\tvmsleu"
    ".vx\010vmslt.vi\010vmslt.vv\010vmslt.vx\tvmsltu.vi\tvmsltu.vv\tvmsltu.v"
    "x\010vmsne.vi\010vmsne.vv\010vmsne.vx\007vmsof.m\007vmul.vv\007vmul.vx\010"
    "vmulh.vv\010vmulh.vx\nvmulhsu.vv\nvmulhsu.vx\tvmulhu.vv\tvmulhu.vx\007v"
    "mv.s.x\007vmv.v.i\007vmv.v.v\007vmv.v.x\007vmv.x.s\007vmv1r.v\007vmv2r."
    "v\007vmv4r.v\007vmv8r.v\tvmxnor.mm\010vmxor.mm\tvnclip.wi\tvnclip.wv\tv"
    "nclip.wx\nvnclipu.wi\nvnclipu.wv\nvnclipu.wx\013vncvt.x.x.w\006vneg.v\t"
    "vnmsac.vv\tvnmsac.vx\tvnmsub.vv\tvnmsub.vx\006vnot.v\010vnsra.wi\010vns"
    "ra.wv\010vnsra.wx\010vnsrl.wi\010vnsrl.wv\010vnsrl.wx\006vor.vi\006vor."
    "vv\006vor.vx\007vpopc.m\nvredand.vs\nvredmax.vs\013vredmaxu.vs\nvredmin"
    ".vs\013vredminu.vs\tvredor.vs\nvredsum.vs\nvredxor.vs\007vrem.vv\007vre"
    "m.vx\010vremu.vv\010vremu.vx\007vrev8.v\013vrgather.vi\013vrgather.vv\013"
    "vrgather.vx\017vrgatherei16.vv\007vrol.vv\007vrol.vx\007vror.vi\007vror"
    ".vv\007vror.vx\010vrsub.vi\010vrsub.vx\006vs1r.v\006vs2r.v\006vs4r.v\006"
    "vs8r.v\010vsadd.vi\010vsadd.vv\010vsadd.vx\tvsaddu.vi\tvsaddu.vv\tvsadd"
    "u.vx\010vsbc.vvm\010vsbc.vxm\006vse1.v\007vse16.v\007vse32.v\007vse64.v"
    "\006vse8.v\010vsetivli\006vsetvl\007vsetvli\tvsext.vf2\tvsext.vf4\tvsex"
    "t.vf8\nvsha2ch.vv\nvsha2cl.vv\nvsha2ms.vv\016vslide1down.vx\014vslide1u"
    "p.vx\015vslidedown.vi\015vslidedown.vx\013vslideup.vi\013vslideup.vx\007"
    "vsll.vi\007vsll.vv\007vsll.vx\005vsm.v\010vsm3c.vi\tvsm3me.vv\010vsm4k."
    "vi\010vsm4r.vs\010vsm4r.vv\010vsmul.vv\010vsmul.vx\nvsoxei16.v\nvsoxei3"
    "2.v\nvsoxei64.v\tvsoxei8.v\016vsoxseg2ei16.v\016vsoxseg2ei32.v\016vsoxs"
    "eg2ei64.v\015vsoxseg2ei8.v\016vsoxseg3ei16.v\016vsoxseg3ei32.v\016vsoxs"
    "eg3ei64.v\015vsoxseg3ei8.v\016vsoxseg4ei16.v\016vsoxseg4ei32.v\016vsoxs"
    "eg4ei64.v\015vsoxseg4ei8.v\016vsoxseg5ei16.v\016vsoxseg5ei32.v\016vsoxs"
    "eg5ei64.v\015vsoxseg5ei8.v\016vsoxseg6ei16.v\016vsoxseg6ei32.v\016vsoxs"
    "eg6ei64.v\015vsoxseg6ei8.v\016vsoxseg7ei16.v\016vsoxseg7ei32.v\016vsoxs"
    "eg7ei64.v\015vsoxseg7ei8.v\016vsoxseg8ei16.v\016vsoxseg8ei32.v\016vsoxs"
    "eg8ei64.v\015vsoxseg8ei8.v\007vsra.vi\007vsra.vv\007vsra.vx\007vsrl.vi\007"
    "vsrl.vv\007vsrl.vx\010vsse16.v\010vsse32.v\010vsse64.v\007vsse8.v\013vs"
    "seg2e16.v\013vsseg2e32.v\013vsseg2e64.v\nvsseg2e8.v\013vsseg3e16.v\013v"
    "sseg3e32.v\013vsseg3e64.v\nvsseg3e8.v\013vsseg4e16.v\013vsseg4e32.v\013"
    "vsseg4e64.v\nvsseg4e8.v\013vsseg5e16.v\013vsseg5e32.v\013vsseg5e64.v\nv"
    "sseg5e8.v\013vsseg6e16.v\013vsseg6e32.v\013vsseg6e64.v\nvsseg6e8.v\013v"
    "sseg7e16.v\013vsseg7e32.v\013vsseg7e64.v\nvsseg7e8.v\013vsseg8e16.v\013"
    "vsseg8e32.v\013vsseg8e64.v\nvsseg8e8.v\010vssra.vi\010vssra.vv\010vssra"
    ".vx\010vssrl.vi\010vssrl.vv\010vssrl.vx\014vssseg2e16.v\014vssseg2e32.v"
    "\014vssseg2e64.v\013vssseg2e8.v\014vssseg3e16.v\014vssseg3e32.v\014vsss"
    "eg3e64.v\013vssseg3e8.v\014vssseg4e16.v\014vssseg4e32.v\014vssseg4e64.v"
    "\013vssseg4e8.v\014vssseg5e16.v\014vssseg5e32.v\014vssseg5e64.v\013vsss"
    "eg5e8.v\014vssseg6e16.v\014vssseg6e32.v\014vssseg6e64.v\013vssseg6e8.v\014"
    "vssseg7e16.v\014vssseg7e32.v\014vssseg7e64.v\013vssseg7e8.v\014vssseg8e"
    "16.v\014vssseg8e32.v\014vssseg8e64.v\013vssseg8e8.v\010vssub.vv\010vssu"
    "b.vx\tvssubu.vv\tvssubu.vx\007vsub.vv\007vsub.vx\nvsuxei16.v\nvsuxei32."
    "v\nvsuxei64.v\tvsuxei8.v\016vsuxseg2ei16.v\016vsuxseg2ei32.v\016vsuxseg"
    "2ei64.v\015vsuxseg2ei8.v\016vsuxseg3ei16.v\016vsuxseg3ei32.v\016vsuxseg"
    "3ei64.v\015vsuxseg3ei8.v\016vsuxseg4ei16.v\016vsuxseg4ei32.v\016vsuxseg"
    "4ei64.v\015vsuxseg4ei8.v\016vsuxseg5ei16.v\016vsuxseg5ei32.v\016vsuxseg"
    "5ei64.v\015vsuxseg5ei8.v\016vsuxseg6ei16.v\016vsuxseg6ei32.v\016vsuxseg"
    "6ei64.v\015vsuxseg6ei8.v\016vsuxseg7ei16.v\016vsuxseg7ei32.v\016vsuxseg"
    "7ei64.v\015vsuxseg7ei8.v\016vsuxseg8ei16.v\016vsuxseg8ei32.v\016vsuxseg"
    "8ei64.v\015vsuxseg8ei8.v\010vt.maskc\tvt.maskcn\010vwadd.vv\010vwadd.vx"
    "\010vwadd.wv\010vwadd.wx\tvwaddu.vv\tvwaddu.vx\tvwaddu.wv\tvwaddu.wx\013"
    "vwcvt.x.x.v\014vwcvtu.x.x.v\tvwmacc.vv\tvwmacc.vx\013vwmaccsu.vv\013vwm"
    "accsu.vx\nvwmaccu.vv\nvwmaccu.vx\013vwmaccus.vx\010vwmul.vv\010vwmul.vx"
    "\nvwmulsu.vv\nvwmulsu.vx\tvwmulu.vv\tvwmulu.vx\013vwredsum.vs\014vwreds"
    "umu.vs\010vwsll.vi\010vwsll.vv\010vwsll.vx\010vwsub.vv\010vwsub.vx\010v"
    "wsub.wv\010vwsub.wx\tvwsubu.vv\tvwsubu.vx\tvwsubu.wv\tvwsubu.wx\007vxor"
    ".vi\007vxor.vv\007vxor.vx\tvzext.vf2\tvzext.vf4\tvzext.vf8\003wfi\007wr"
    "s.nto\007wrs.sto\004xnor\003xor\004xori\006xperm4\006xperm8\006zext.b\006"
    "zext.h\006zext.w\003zip";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_HasHalfFPLoadStoreMove,
  AMFBS_HasStdExtA,
  AMFBS_HasStdExtCOrZca,
  AMFBS_HasStdExtD,
  AMFBS_HasStdExtF,
  AMFBS_HasStdExtH,
  AMFBS_HasStdExtM,
  AMFBS_HasStdExtMOrZmmul,
  AMFBS_HasStdExtSvinval,
  AMFBS_HasStdExtZacas,
  AMFBS_HasStdExtZawrs,
  AMFBS_HasStdExtZba,
  AMFBS_HasStdExtZbb,
  AMFBS_HasStdExtZbbOrZbkb,
  AMFBS_HasStdExtZbc,
  AMFBS_HasStdExtZbcOrZbkc,
  AMFBS_HasStdExtZbkb,
  AMFBS_HasStdExtZbkx,
  AMFBS_HasStdExtZbs,
  AMFBS_HasStdExtZcb,
  AMFBS_HasStdExtZcmop,
  AMFBS_HasStdExtZcmp,
  AMFBS_HasStdExtZcmt,
  AMFBS_HasStdExtZfa,
  AMFBS_HasStdExtZfbfmin,
  AMFBS_HasStdExtZfh,
  AMFBS_HasStdExtZfhmin,
  AMFBS_HasStdExtZfinx,
  AMFBS_HasStdExtZhinx,
  AMFBS_HasStdExtZhinxmin,
  AMFBS_HasStdExtZicbom,
  AMFBS_HasStdExtZicbop,
  AMFBS_HasStdExtZicboz,
  AMFBS_HasStdExtZicfilp,
  AMFBS_HasStdExtZicfiss,
  AMFBS_HasStdExtZicond,
  AMFBS_HasStdExtZihintntl,
  AMFBS_HasStdExtZihintpause,
  AMFBS_HasStdExtZimop,
  AMFBS_HasStdExtZknh,
  AMFBS_HasStdExtZksed,
  AMFBS_HasStdExtZksh,
  AMFBS_HasStdExtZvbb,
  AMFBS_HasStdExtZvbc,
  AMFBS_HasStdExtZvfbfmin,
  AMFBS_HasStdExtZvfbfwma,
  AMFBS_HasStdExtZvkb,
  AMFBS_HasStdExtZvkg,
  AMFBS_HasStdExtZvkned,
  AMFBS_HasStdExtZvknhaOrZvknhb,
  AMFBS_HasStdExtZvksed,
  AMFBS_HasStdExtZvksh,
  AMFBS_HasVInstructions,
  AMFBS_HasVInstructionsAnyF,
  AMFBS_HasVInstructionsI64,
  AMFBS_HasVendorXCValu,
  AMFBS_HasVendorXSfvcp,
  AMFBS_HasVendorXSfvfnrclipxfqf,
  AMFBS_HasVendorXSfvfwmaccqqq,
  AMFBS_HasVendorXSfvqmaccdod,
  AMFBS_HasVendorXSfvqmaccqoq,
  AMFBS_HasVendorXTHeadBa,
  AMFBS_HasVendorXTHeadBb,
  AMFBS_HasVendorXTHeadBs,
  AMFBS_HasVendorXTHeadCmo,
  AMFBS_HasVendorXTHeadCondMov,
  AMFBS_HasVendorXTHeadMac,
  AMFBS_HasVendorXTHeadMemIdx,
  AMFBS_HasVendorXTHeadMemPair,
  AMFBS_HasVendorXTHeadSync,
  AMFBS_HasVendorXTHeadVdot,
  AMFBS_IsRV32,
  AMFBS_IsRV64,
  AMFBS_HasStdExtA_IsRV64,
  AMFBS_HasStdExtCOrZca_HasRVCHints,
  AMFBS_HasStdExtCOrZca_IsRV32,
  AMFBS_HasStdExtCOrZca_IsRV64,
  AMFBS_HasStdExtCOrZcd_HasStdExtD,
  AMFBS_HasStdExtD_IsRV64,
  AMFBS_HasStdExtF_IsRV64,
  AMFBS_HasStdExtM_IsRV64,
  AMFBS_HasStdExtMOrZmmul_IsRV64,
  AMFBS_HasStdExtZacas_IsRV32,
  AMFBS_HasStdExtZacas_IsRV64,
  AMFBS_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZbb_IsRV32,
  AMFBS_HasStdExtZbb_IsRV64,
  AMFBS_HasStdExtZbbOrZbkb_IsRV32,
  AMFBS_HasStdExtZbbOrZbkb_IsRV64,
  AMFBS_HasStdExtZbkb_IsRV32,
  AMFBS_HasStdExtZbkb_IsRV64,
  AMFBS_HasStdExtZcb_HasStdExtMOrZmmul,
  AMFBS_HasStdExtZcb_HasStdExtZbb,
  AMFBS_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZdinx_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD,
  AMFBS_HasStdExtZfa_HasStdExtZfh,
  AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh,
  AMFBS_HasStdExtZfh_IsRV64,
  AMFBS_HasStdExtZfhmin_HasStdExtD,
  AMFBS_HasStdExtZfinx_IsRV64,
  AMFBS_HasStdExtZhinx_IsRV64,
  AMFBS_HasStdExtZicfiss_HasStdExtZcmop,
  AMFBS_HasStdExtZicfiss_IsRV64,
  AMFBS_HasStdExtZknd_IsRV32,
  AMFBS_HasStdExtZknd_IsRV64,
  AMFBS_HasStdExtZkndOrZkne_IsRV64,
  AMFBS_HasStdExtZkne_IsRV32,
  AMFBS_HasStdExtZkne_IsRV64,
  AMFBS_HasStdExtZknh_IsRV32,
  AMFBS_HasStdExtZknh_IsRV64,
  AMFBS_HasVInstructionsI64_IsRV64,
  AMFBS_HasVendorXCVbi_IsRV32,
  AMFBS_HasVendorXCVbitmanip_IsRV32,
  AMFBS_HasVendorXCVelw_IsRV32,
  AMFBS_HasVendorXCVmac_IsRV32,
  AMFBS_HasVendorXCVmem_IsRV32,
  AMFBS_HasVendorXCVsimd_IsRV32,
  AMFBS_HasVendorXTHeadBb_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF,
  AMFBS_HasVendorXTHeadMac_IsRV64,
  AMFBS_HasVendorXTHeadMemIdx_IsRV64,
  AMFBS_HasVendorXTHeadMemPair_IsRV64,
  AMFBS_IsRV64_HasStdExtH,
  AMFBS_IsRV64_HasVInstructionsI64,
  AMFBS_IsRV64_HasVendorXVentanaCondOps,
  AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl,
  AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32,
  AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZdinx_IsRV64_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD_IsRV32,
  AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_HasHalfFPLoadStoreMoveBit, },
  {Feature_HasStdExtABit, },
  {Feature_HasStdExtCOrZcaBit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtHBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtMOrZmmulBit, },
  {Feature_HasStdExtSvinvalBit, },
  {Feature_HasStdExtZacasBit, },
  {Feature_HasStdExtZawrsBit, },
  {Feature_HasStdExtZbaBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrZbkbBit, },
  {Feature_HasStdExtZbcBit, },
  {Feature_HasStdExtZbcOrZbkcBit, },
  {Feature_HasStdExtZbkbBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZcbBit, },
  {Feature_HasStdExtZcmopBit, },
  {Feature_HasStdExtZcmpBit, },
  {Feature_HasStdExtZcmtBit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfbfminBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhminBit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxminBit, },
  {Feature_HasStdExtZicbomBit, },
  {Feature_HasStdExtZicbopBit, },
  {Feature_HasStdExtZicbozBit, },
  {Feature_HasStdExtZicfilpBit, },
  {Feature_HasStdExtZicfissBit, },
  {Feature_HasStdExtZicondBit, },
  {Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtZihintpauseBit, },
  {Feature_HasStdExtZimopBit, },
  {Feature_HasStdExtZknhBit, },
  {Feature_HasStdExtZksedBit, },
  {Feature_HasStdExtZkshBit, },
  {Feature_HasStdExtZvbbBit, },
  {Feature_HasStdExtZvbcBit, },
  {Feature_HasStdExtZvfbfminBit, },
  {Feature_HasStdExtZvfbfwmaBit, },
  {Feature_HasStdExtZvkbBit, },
  {Feature_HasStdExtZvkgBit, },
  {Feature_HasStdExtZvknedBit, },
  {Feature_HasStdExtZvknhaOrZvknhbBit, },
  {Feature_HasStdExtZvksedBit, },
  {Feature_HasStdExtZvkshBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_HasVInstructionsI64Bit, },
  {Feature_HasVendorXCValuBit, },
  {Feature_HasVendorXSfvcpBit, },
  {Feature_HasVendorXSfvfnrclipxfqfBit, },
  {Feature_HasVendorXSfvfwmaccqqqBit, },
  {Feature_HasVendorXSfvqmaccdodBit, },
  {Feature_HasVendorXSfvqmaccqoqBit, },
  {Feature_HasVendorXTHeadBaBit, },
  {Feature_HasVendorXTHeadBbBit, },
  {Feature_HasVendorXTHeadBsBit, },
  {Feature_HasVendorXTHeadCmoBit, },
  {Feature_HasVendorXTHeadCondMovBit, },
  {Feature_HasVendorXTHeadMacBit, },
  {Feature_HasVendorXTHeadMemIdxBit, },
  {Feature_HasVendorXTHeadMemPairBit, },
  {Feature_HasVendorXTHeadSyncBit, },
  {Feature_HasVendorXTHeadVdotBit, },
  {Feature_IsRV32Bit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, },
  {Feature_HasStdExtCOrZcaBit, Feature_HasRVCHintsBit, },
  {Feature_HasStdExtCOrZcaBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtCOrZcaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtCOrZcdBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtMOrZmmulBit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhOrZvfhBit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZicfissBit, Feature_HasStdExtZcmopBit, },
  {Feature_HasStdExtZicfissBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_IsRV64Bit, },
  {Feature_HasVendorXCVbiBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVelwBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVmacBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVmemBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVsimdBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemIdxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemPairBit, Feature_IsRV64Bit, },
  {Feature_IsRV64Bit, Feature_HasStdExtHBit, },
  {Feature_IsRV64Bit, Feature_HasVInstructionsI64Bit, },
  {Feature_IsRV64Bit, Feature_HasVendorXVentanaCondOpsBit, },
  {Feature_HasStdExtCBit, Feature_HasRVCHintsBit, Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtCOrZcfOrZceBit, Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, Feature_IsRV64Bit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint8_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[7];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* .insn_b */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm13Lsb0 }, },
  { 8 /* .insn_ca */, RISCV::InsnCA, Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm6, MCK_UImm2, MCK_AnyRegCOperand, MCK_AnyRegCOperand }, },
  { 17 /* .insn_cb */, RISCV::InsnCB, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_SImm9Lsb0 }, },
  { 26 /* .insn_ci */, RISCV::InsnCI, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_SImm6 }, },
  { 35 /* .insn_ciw */, RISCV::InsnCIW, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm8 }, },
  { 45 /* .insn_cj */, RISCV::InsnCJ, Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_SImm12Lsb0 }, },
  { 54 /* .insn_cl */, RISCV::InsnCL, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 63 /* .insn_cr */, RISCV::InsnCR, Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm4, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 72 /* .insn_cs */, RISCV::InsnCS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 81 /* .insn_css */, RISCV::InsnCSS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_UImm6 }, },
  { 91 /* .insn_i */, RISCV::InsnI, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm12 }, },
  { 91 /* .insn_i */, RISCV::InsnI_Mem, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 99 /* .insn_j */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_SImm21Lsb0JAL }, },
  { 107 /* .insn_r */, RISCV::InsnR, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm7, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 107 /* .insn_r */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 115 /* .insn_r4 */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 124 /* .insn_s */, RISCV::InsnS, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 132 /* .insn_sb */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm13Lsb0 }, },
  { 141 /* .insn_u */, RISCV::InsnU, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_UImm20LUI }, },
  { 149 /* .insn_uj */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_SImm21Lsb0JAL }, },
  { 158 /* add */, RISCV::ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 158 /* add */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 158 /* add */, RISCV::PseudoAddTPRel, Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_TPRelAddSymbol }, },
  { 162 /* add.uw */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 169 /* addi */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 174 /* addiw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 180 /* addw */, RISCV::ADDW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 180 /* addw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 185 /* aes32dsi */, RISCV::AES32DSI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 194 /* aes32dsmi */, RISCV::AES32DSMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 204 /* aes32esi */, RISCV::AES32ESI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 213 /* aes32esmi */, RISCV::AES32ESMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 223 /* aes64ds */, RISCV::AES64DS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 231 /* aes64dsm */, RISCV::AES64DSM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 240 /* aes64es */, RISCV::AES64ES, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 248 /* aes64esm */, RISCV::AES64ESM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 257 /* aes64im */, RISCV::AES64IM, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 265 /* aes64ks1i */, RISCV::AES64KS1I, Convert__Reg1_0__Reg1_1__RnumArg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_RnumArg }, },
  { 275 /* aes64ks2 */, RISCV::AES64KS2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 284 /* amoadd.d */, RISCV::AMOADD_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 293 /* amoadd.d.aq */, RISCV::AMOADD_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 305 /* amoadd.d.aqrl */, RISCV::AMOADD_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 319 /* amoadd.d.rl */, RISCV::AMOADD_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 331 /* amoadd.w */, RISCV::AMOADD_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 340 /* amoadd.w.aq */, RISCV::AMOADD_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 352 /* amoadd.w.aqrl */, RISCV::AMOADD_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 366 /* amoadd.w.rl */, RISCV::AMOADD_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 378 /* amoand.d */, RISCV::AMOAND_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 387 /* amoand.d.aq */, RISCV::AMOAND_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 399 /* amoand.d.aqrl */, RISCV::AMOAND_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 413 /* amoand.d.rl */, RISCV::AMOAND_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 425 /* amoand.w */, RISCV::AMOAND_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 434 /* amoand.w.aq */, RISCV::AMOAND_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 446 /* amoand.w.aqrl */, RISCV::AMOAND_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 460 /* amoand.w.rl */, RISCV::AMOAND_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 472 /* amocas.d */, RISCV::AMOCAS_D_RV64, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 472 /* amocas.d */, RISCV::AMOCAS_D_RV32, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 481 /* amocas.d.aq */, RISCV::AMOCAS_D_RV64_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 481 /* amocas.d.aq */, RISCV::AMOCAS_D_RV32_AQ, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 493 /* amocas.d.aqrl */, RISCV::AMOCAS_D_RV64_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 493 /* amocas.d.aqrl */, RISCV::AMOCAS_D_RV32_AQ_RL, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 507 /* amocas.d.rl */, RISCV::AMOCAS_D_RV64_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 507 /* amocas.d.rl */, RISCV::AMOCAS_D_RV32_RL, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 519 /* amocas.q */, RISCV::AMOCAS_Q, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 528 /* amocas.q.aq */, RISCV::AMOCAS_Q_AQ, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 540 /* amocas.q.aqrl */, RISCV::AMOCAS_Q_AQ_RL, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 554 /* amocas.q.rl */, RISCV::AMOCAS_Q_RL, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 566 /* amocas.w */, RISCV::AMOCAS_W, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 575 /* amocas.w.aq */, RISCV::AMOCAS_W_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 587 /* amocas.w.aqrl */, RISCV::AMOCAS_W_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 601 /* amocas.w.rl */, RISCV::AMOCAS_W_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 613 /* amomax.d */, RISCV::AMOMAX_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 622 /* amomax.d.aq */, RISCV::AMOMAX_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 634 /* amomax.d.aqrl */, RISCV::AMOMAX_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 648 /* amomax.d.rl */, RISCV::AMOMAX_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 660 /* amomax.w */, RISCV::AMOMAX_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 669 /* amomax.w.aq */, RISCV::AMOMAX_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 681 /* amomax.w.aqrl */, RISCV::AMOMAX_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 695 /* amomax.w.rl */, RISCV::AMOMAX_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 707 /* amomaxu.d */, RISCV::AMOMAXU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 717 /* amomaxu.d.aq */, RISCV::AMOMAXU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 730 /* amomaxu.d.aqrl */, RISCV::AMOMAXU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 745 /* amomaxu.d.rl */, RISCV::AMOMAXU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 758 /* amomaxu.w */, RISCV::AMOMAXU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 768 /* amomaxu.w.aq */, RISCV::AMOMAXU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 781 /* amomaxu.w.aqrl */, RISCV::AMOMAXU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 796 /* amomaxu.w.rl */, RISCV::AMOMAXU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 809 /* amomin.d */, RISCV::AMOMIN_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 818 /* amomin.d.aq */, RISCV::AMOMIN_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 830 /* amomin.d.aqrl */, RISCV::AMOMIN_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 844 /* amomin.d.rl */, RISCV::AMOMIN_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 856 /* amomin.w */, RISCV::AMOMIN_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 865 /* amomin.w.aq */, RISCV::AMOMIN_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 877 /* amomin.w.aqrl */, RISCV::AMOMIN_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 891 /* amomin.w.rl */, RISCV::AMOMIN_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 903 /* amominu.d */, RISCV::AMOMINU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 913 /* amominu.d.aq */, RISCV::AMOMINU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 926 /* amominu.d.aqrl */, RISCV::AMOMINU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 941 /* amominu.d.rl */, RISCV::AMOMINU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 954 /* amominu.w */, RISCV::AMOMINU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 964 /* amominu.w.aq */, RISCV::AMOMINU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 977 /* amominu.w.aqrl */, RISCV::AMOMINU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 992 /* amominu.w.rl */, RISCV::AMOMINU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1005 /* amoor.d */, RISCV::AMOOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1013 /* amoor.d.aq */, RISCV::AMOOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1024 /* amoor.d.aqrl */, RISCV::AMOOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1037 /* amoor.d.rl */, RISCV::AMOOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1048 /* amoor.w */, RISCV::AMOOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1056 /* amoor.w.aq */, RISCV::AMOOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1067 /* amoor.w.aqrl */, RISCV::AMOOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1080 /* amoor.w.rl */, RISCV::AMOOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1091 /* amoswap.d */, RISCV::AMOSWAP_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1101 /* amoswap.d.aq */, RISCV::AMOSWAP_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1114 /* amoswap.d.aqrl */, RISCV::AMOSWAP_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1129 /* amoswap.d.rl */, RISCV::AMOSWAP_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1142 /* amoswap.w */, RISCV::AMOSWAP_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1152 /* amoswap.w.aq */, RISCV::AMOSWAP_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1165 /* amoswap.w.aqrl */, RISCV::AMOSWAP_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1180 /* amoswap.w.rl */, RISCV::AMOSWAP_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1193 /* amoxor.d */, RISCV::AMOXOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1202 /* amoxor.d.aq */, RISCV::AMOXOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1214 /* amoxor.d.aqrl */, RISCV::AMOXOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1228 /* amoxor.d.rl */, RISCV::AMOXOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1240 /* amoxor.w */, RISCV::AMOXOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1249 /* amoxor.w.aq */, RISCV::AMOXOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1261 /* amoxor.w.aqrl */, RISCV::AMOXOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1275 /* amoxor.w.rl */, RISCV::AMOXOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1287 /* and */, RISCV::AND, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1287 /* and */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 1291 /* andi */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 1296 /* andn */, RISCV::ANDN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1301 /* auipc */, RISCV::AUIPC, Convert__Reg1_0__UImm20AUIPC1_1, AMFBS_None, { MCK_GPR, MCK_UImm20AUIPC }, },
  { 1307 /* bclr */, RISCV::BCLR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1307 /* bclr */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1312 /* bclri */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1318 /* beq */, RISCV::BEQ, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1322 /* beqz */, RISCV::BEQ, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1327 /* bext */, RISCV::BEXT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1327 /* bext */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1332 /* bexti */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1338 /* bge */, RISCV::BGE, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1342 /* bgeu */, RISCV::BGEU, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1347 /* bgez */, RISCV::BGE, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1352 /* bgt */, RISCV::BLT, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1356 /* bgtu */, RISCV::BLTU, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1361 /* bgtz */, RISCV::BLT, Convert__regX0__Reg1_0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1366 /* binv */, RISCV::BINV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1366 /* binv */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1371 /* binvi */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1377 /* ble */, RISCV::BGE, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1381 /* bleu */, RISCV::BGEU, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1386 /* blez */, RISCV::BGE, Convert__regX0__Reg1_0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1391 /* blt */, RISCV::BLT, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1395 /* bltu */, RISCV::BLTU, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1400 /* bltz */, RISCV::BLT, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1405 /* bne */, RISCV::BNE, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1409 /* bnez */, RISCV::BNE, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 1414 /* brev8 */, RISCV::BREV8, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR }, },
  { 1420 /* bset */, RISCV::BSET, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1420 /* bset */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1425 /* bseti */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 1431 /* c.add */, RISCV::C_ADD_HINT, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 1431 /* c.add */, RISCV::C_ADD, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 1437 /* c.addi */, RISCV::C_ADDI_NOP, Convert__Reg1_0__Tie0_1_1__ImmZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRX0, MCK_ImmZero }, },
  { 1437 /* c.addi */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_SImm6NonZero }, },
  { 1437 /* c.addi */, RISCV::C_ADDI_HINT_IMM_ZERO, Convert__Reg1_0__Tie0_1_1__ImmZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRNoX0, MCK_ImmZero }, },
  { 1437 /* c.addi */, RISCV::C_ADDI, Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_SImm6NonZero }, },
  { 1444 /* c.addi16sp */, RISCV::C_ADDI16SP, Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_SP, MCK_SImm10Lsb0000NonZero }, },
  { 1455 /* c.addi4spn */, RISCV::C_ADDI4SPN, Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SP, MCK_UImm10Lsb00NonZero }, },
  { 1466 /* c.addiw */, RISCV::C_ADDIW, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 1474 /* c.addw */, RISCV::C_ADDW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 1481 /* c.and */, RISCV::C_AND, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1487 /* c.andi */, RISCV::C_ANDI, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm6 }, },
  { 1494 /* c.beqz */, RISCV::C_BEQZ, Convert__Reg1_0__SImm9Lsb01_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm9Lsb0 }, },
  { 1501 /* c.bnez */, RISCV::C_BNEZ, Convert__Reg1_0__SImm9Lsb01_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm9Lsb0 }, },
  { 1508 /* c.ebreak */, RISCV::C_EBREAK, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 1517 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1517 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1523 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1523 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1531 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1531 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1537 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1537 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1545 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1545 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1551 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1551 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1559 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1559 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1565 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1565 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1573 /* c.j */, RISCV::C_J, Convert__SImm12Lsb01_0, AMFBS_HasStdExtCOrZca, { MCK_SImm12Lsb0 }, },
  { 1577 /* c.jal */, RISCV::C_JAL, Convert__SImm12Lsb01_0, AMFBS_HasStdExtCOrZca_IsRV32, { MCK_SImm12Lsb0 }, },
  { 1583 /* c.jalr */, RISCV::C_JALR, Convert__Reg1_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0 }, },
  { 1590 /* c.jr */, RISCV::C_JR, Convert__Reg1_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0 }, },
  { 1595 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1595 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1601 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1601 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1606 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1606 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1613 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1613 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1618 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1618 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1624 /* c.li */, RISCV::C_LI_HINT, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_SImm6 }, },
  { 1624 /* c.li */, RISCV::C_LI, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 1629 /* c.lui */, RISCV::C_LUI_HINT, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_CLUIImm }, },
  { 1629 /* c.lui */, RISCV::C_LUI, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0X2, MCK_CLUIImm }, },
  { 1635 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1635 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1640 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1640 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1647 /* c.mul */, RISCV::C_MUL, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZcb_HasStdExtMOrZmmul, { MCK_GPRC, MCK_GPRC }, },
  { 1653 /* c.mv */, RISCV::C_MV_HINT, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 1653 /* c.mv */, RISCV::C_MV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 1658 /* c.nop */, RISCV::C_NOP, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 1658 /* c.nop */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_0, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_SImm6NonZero }, },
  { 1664 /* c.not */, RISCV::C_NOT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 1670 /* c.ntl.all */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX5, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1680 /* c.ntl.p1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX2, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1689 /* c.ntl.pall */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX3, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1700 /* c.ntl.s1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX4, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 1709 /* c.or */, RISCV::C_OR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1714 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1714 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1719 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1719 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1724 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1724 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPR, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1731 /* c.sext.b */, RISCV::C_SEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 1740 /* c.sext.h */, RISCV::C_SEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 1749 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1749 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1754 /* c.slli */, RISCV::C_SLLI_HINT, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_UImmLog2XLenNonZero }, },
  { 1754 /* c.slli */, RISCV::C_SLLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_UImmLog2XLenNonZero }, },
  { 1761 /* c.slli64 */, RISCV::C_SLLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPR }, },
  { 1770 /* c.srai */, RISCV::C_SRAI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 1777 /* c.srai64 */, RISCV::C_SRAI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRC }, },
  { 1786 /* c.srli */, RISCV::C_SRLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 1793 /* c.srli64 */, RISCV::C_SRLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRC }, },
  { 1802 /* c.sspopchk */, RISCV::C_SSPOPCHK, Convert__Reg1_0, AMFBS_HasStdExtZicfiss_HasStdExtZcmop, { MCK_GPRX5 }, },
  { 1813 /* c.sspush */, RISCV::C_SSPUSH, Convert__Reg1_0, AMFBS_HasStdExtZicfiss_HasStdExtZcmop, { MCK_GPRX1 }, },
  { 1822 /* c.sub */, RISCV::C_SUB, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1828 /* c.subw */, RISCV::C_SUBW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 1835 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1835 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 1840 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1840 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPR, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 1847 /* c.unimp */, RISCV::C_UNIMP, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 1855 /* c.xor */, RISCV::C_XOR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 1861 /* c.zext.b */, RISCV::C_ZEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 1870 /* c.zext.h */, RISCV::C_ZEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 1879 /* c.zext.w */, RISCV::C_ZEXT_W, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64, { MCK_GPRC }, },
  { 1888 /* call */, RISCV::PseudoCALL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 1888 /* call */, RISCV::PseudoCALLReg, Convert__Reg1_0__CallSymbol1_1, AMFBS_None, { MCK_GPR, MCK_CallSymbol }, },
  { 1893 /* cbo.clean */, RISCV::CBO_CLEAN, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 1903 /* cbo.flush */, RISCV::CBO_FLUSH, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 1913 /* cbo.inval */, RISCV::CBO_INVAL, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 1923 /* cbo.zero */, RISCV::CBO_ZERO, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicboz, { MCK_ZeroOffsetMemOpOperand }, },
  { 1932 /* clmul */, RISCV::CLMUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1938 /* clmulh */, RISCV::CLMULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1945 /* clmulr */, RISCV::CLMULR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 1952 /* clz */, RISCV::CLZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 1956 /* clzw */, RISCV::CLZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 1961 /* cm.jalt */, RISCV::CM_JALT, Convert__UImm8GE321_0, AMFBS_HasStdExtZcmt, { MCK_UImm8GE32 }, },
  { 1969 /* cm.jt */, RISCV::CM_JT, Convert__UImm51_0, AMFBS_HasStdExtZcmt, { MCK_UImm5 }, },
  { 1975 /* cm.mva01s */, RISCV::CM_MVA01S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 1985 /* cm.mvsa01 */, RISCV::CM_MVSA01, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 1995 /* cm.pop */, RISCV::CM_POP, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2002 /* cm.popret */, RISCV::CM_POPRET, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2012 /* cm.popretz */, RISCV::CM_POPRETZ, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2023 /* cm.push */, RISCV::CM_PUSH, Convert__Rlist1_0__Spimm1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_Spimm }, },
  { 2031 /* cmop.1 */, RISCV::CMOP1, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2038 /* cmop.11 */, RISCV::CMOP11, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2046 /* cmop.13 */, RISCV::CMOP13, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2054 /* cmop.15 */, RISCV::CMOP15, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2062 /* cmop.3 */, RISCV::CMOP3, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2069 /* cmop.5 */, RISCV::CMOP5, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2076 /* cmop.7 */, RISCV::CMOP7, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2083 /* cmop.9 */, RISCV::CMOP9, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2090 /* cpop */, RISCV::CPOP, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 2095 /* cpopw */, RISCV::CPOPW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 2101 /* csrc */, RISCV::CSRRC, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 2101 /* csrc */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2106 /* csrci */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2112 /* csrr */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__regX0, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister }, },
  { 2117 /* csrrc */, RISCV::CSRRC, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 2117 /* csrrc */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2123 /* csrrci */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2130 /* csrrs */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 2130 /* csrrs */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2136 /* csrrsi */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2143 /* csrrw */, RISCV::CSRRW, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 2143 /* csrrw */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2149 /* csrrwi */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2156 /* csrs */, RISCV::CSRRS, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 2156 /* csrs */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2161 /* csrsi */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2167 /* csrw */, RISCV::CSRRW, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 2167 /* csrw */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2172 /* csrwi */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 2178 /* ctz */, RISCV::CTZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 2182 /* ctzw */, RISCV::CTZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 2187 /* cv.abs */, RISCV::CV_ABS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR }, },
  { 2194 /* cv.abs.b */, RISCV::CV_ABS_B, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 2203 /* cv.abs.h */, RISCV::CV_ABS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 2212 /* cv.add.b */, RISCV::CV_ADD_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2221 /* cv.add.div2 */, RISCV::CV_ADD_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2233 /* cv.add.div4 */, RISCV::CV_ADD_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2245 /* cv.add.div8 */, RISCV::CV_ADD_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2257 /* cv.add.h */, RISCV::CV_ADD_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2266 /* cv.add.sc.b */, RISCV::CV_ADD_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2278 /* cv.add.sc.h */, RISCV::CV_ADD_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2290 /* cv.add.sci.b */, RISCV::CV_ADD_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2303 /* cv.add.sci.h */, RISCV::CV_ADD_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2316 /* cv.addn */, RISCV::CV_ADDN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2324 /* cv.addnr */, RISCV::CV_ADDNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2333 /* cv.addrn */, RISCV::CV_ADDRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2342 /* cv.addrnr */, RISCV::CV_ADDRNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2352 /* cv.addun */, RISCV::CV_ADDUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2361 /* cv.addunr */, RISCV::CV_ADDUNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2371 /* cv.addurn */, RISCV::CV_ADDURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2381 /* cv.addurnr */, RISCV::CV_ADDURNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2392 /* cv.and.b */, RISCV::CV_AND_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2401 /* cv.and.h */, RISCV::CV_AND_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2410 /* cv.and.sc.b */, RISCV::CV_AND_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2422 /* cv.and.sc.h */, RISCV::CV_AND_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2434 /* cv.and.sci.b */, RISCV::CV_AND_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2447 /* cv.and.sci.h */, RISCV::CV_AND_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2460 /* cv.avg.b */, RISCV::CV_AVG_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2469 /* cv.avg.h */, RISCV::CV_AVG_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2478 /* cv.avg.sc.b */, RISCV::CV_AVG_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2490 /* cv.avg.sc.h */, RISCV::CV_AVG_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2502 /* cv.avg.sci.b */, RISCV::CV_AVG_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2515 /* cv.avg.sci.h */, RISCV::CV_AVG_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2528 /* cv.avgu.b */, RISCV::CV_AVGU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2538 /* cv.avgu.h */, RISCV::CV_AVGU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2548 /* cv.avgu.sc.b */, RISCV::CV_AVGU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2561 /* cv.avgu.sc.h */, RISCV::CV_AVGU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2574 /* cv.avgu.sci.b */, RISCV::CV_AVGU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 2588 /* cv.avgu.sci.h */, RISCV::CV_AVGU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 2602 /* cv.bclr */, RISCV::CV_BCLR, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 2610 /* cv.bclrr */, RISCV::CV_BCLRR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2619 /* cv.beqimm */, RISCV::CV_BEQIMM, Convert__Reg1_0__SImm51_1__SImm13Lsb01_2, AMFBS_HasVendorXCVbi_IsRV32, { MCK_GPR, MCK_SImm5, MCK_SImm13Lsb0 }, },
  { 2629 /* cv.bitrev */, RISCV::CV_BITREV, Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm2, MCK_UImm5 }, },
  { 2639 /* cv.bneimm */, RISCV::CV_BNEIMM, Convert__Reg1_0__SImm51_1__SImm13Lsb01_2, AMFBS_HasVendorXCVbi_IsRV32, { MCK_GPR, MCK_SImm5, MCK_SImm13Lsb0 }, },
  { 2649 /* cv.bset */, RISCV::CV_BSET, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 2657 /* cv.bsetr */, RISCV::CV_BSETR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2666 /* cv.clb */, RISCV::CV_CLB, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 2673 /* cv.clip */, RISCV::CV_CLIP, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2681 /* cv.clipr */, RISCV::CV_CLIPR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2690 /* cv.clipu */, RISCV::CV_CLIPU, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 2699 /* cv.clipur */, RISCV::CV_CLIPUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2709 /* cv.cmpeq.b */, RISCV::CV_CMPEQ_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2720 /* cv.cmpeq.h */, RISCV::CV_CMPEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2731 /* cv.cmpeq.sc.b */, RISCV::CV_CMPEQ_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2745 /* cv.cmpeq.sc.h */, RISCV::CV_CMPEQ_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2759 /* cv.cmpeq.sci.b */, RISCV::CV_CMPEQ_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2774 /* cv.cmpeq.sci.h */, RISCV::CV_CMPEQ_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2789 /* cv.cmpge.b */, RISCV::CV_CMPGE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2800 /* cv.cmpge.h */, RISCV::CV_CMPGE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2811 /* cv.cmpge.sc.b */, RISCV::CV_CMPGE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2825 /* cv.cmpge.sc.h */, RISCV::CV_CMPGE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2839 /* cv.cmpge.sci.b */, RISCV::CV_CMPGE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2854 /* cv.cmpge.sci.h */, RISCV::CV_CMPGE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 2869 /* cv.cmpgeu.b */, RISCV::CV_CMPGEU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2881 /* cv.cmpgeu.h */, RISCV::CV_CMPGEU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2893 /* cv.cmpgeu.sc.b */, RISCV::CV_CMPGEU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2908 /* cv.cmpgeu.sc.h */, RISCV::CV_CMPGEU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2923 /* cv.cmpgeu.sci.b */, RISCV::CV_CMPGEU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 2939 /* cv.cmpgeu.sci.h */, RISCV::CV_CMPGEU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 2955 /* cv.cmpgt.b */, RISCV::CV_CMPGT_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2966 /* cv.cmpgt.h */, RISCV::CV_CMPGT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2977 /* cv.cmpgt.sc.b */, RISCV::CV_CMPGT_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2991 /* cv.cmpgt.sc.h */, RISCV::CV_CMPGT_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3005 /* cv.cmpgt.sci.b */, RISCV::CV_CMPGT_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3020 /* cv.cmpgt.sci.h */, RISCV::CV_CMPGT_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3035 /* cv.cmpgtu.b */, RISCV::CV_CMPGTU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3047 /* cv.cmpgtu.h */, RISCV::CV_CMPGTU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3059 /* cv.cmpgtu.sc.b */, RISCV::CV_CMPGTU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3074 /* cv.cmpgtu.sc.h */, RISCV::CV_CMPGTU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3089 /* cv.cmpgtu.sci.b */, RISCV::CV_CMPGTU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3105 /* cv.cmpgtu.sci.h */, RISCV::CV_CMPGTU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3121 /* cv.cmple.b */, RISCV::CV_CMPLE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3132 /* cv.cmple.h */, RISCV::CV_CMPLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3143 /* cv.cmple.sc.b */, RISCV::CV_CMPLE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3157 /* cv.cmple.sc.h */, RISCV::CV_CMPLE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3171 /* cv.cmple.sci.b */, RISCV::CV_CMPLE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3186 /* cv.cmple.sci.h */, RISCV::CV_CMPLE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3201 /* cv.cmpleu.b */, RISCV::CV_CMPLEU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3213 /* cv.cmpleu.h */, RISCV::CV_CMPLEU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3225 /* cv.cmpleu.sc.b */, RISCV::CV_CMPLEU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3240 /* cv.cmpleu.sc.h */, RISCV::CV_CMPLEU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3255 /* cv.cmpleu.sci.b */, RISCV::CV_CMPLEU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3271 /* cv.cmpleu.sci.h */, RISCV::CV_CMPLEU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3287 /* cv.cmplt.b */, RISCV::CV_CMPLT_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3298 /* cv.cmplt.h */, RISCV::CV_CMPLT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3309 /* cv.cmplt.sc.b */, RISCV::CV_CMPLT_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3323 /* cv.cmplt.sc.h */, RISCV::CV_CMPLT_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3337 /* cv.cmplt.sci.b */, RISCV::CV_CMPLT_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3352 /* cv.cmplt.sci.h */, RISCV::CV_CMPLT_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3367 /* cv.cmpltu.b */, RISCV::CV_CMPLTU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3379 /* cv.cmpltu.h */, RISCV::CV_CMPLTU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3391 /* cv.cmpltu.sc.b */, RISCV::CV_CMPLTU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3406 /* cv.cmpltu.sc.h */, RISCV::CV_CMPLTU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3421 /* cv.cmpltu.sci.b */, RISCV::CV_CMPLTU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3437 /* cv.cmpltu.sci.h */, RISCV::CV_CMPLTU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3453 /* cv.cmpne.b */, RISCV::CV_CMPNE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3464 /* cv.cmpne.h */, RISCV::CV_CMPNE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3475 /* cv.cmpne.sc.b */, RISCV::CV_CMPNE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3489 /* cv.cmpne.sc.h */, RISCV::CV_CMPNE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3503 /* cv.cmpne.sci.b */, RISCV::CV_CMPNE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3518 /* cv.cmpne.sci.h */, RISCV::CV_CMPNE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3533 /* cv.cnt */, RISCV::CV_CNT, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3540 /* cv.cplxconj */, RISCV::CV_CPLXCONJ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3552 /* cv.cplxmul.i */, RISCV::CV_CPLXMUL_I, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3565 /* cv.cplxmul.i.div2 */, RISCV::CV_CPLXMUL_I_DIV2, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3583 /* cv.cplxmul.i.div4 */, RISCV::CV_CPLXMUL_I_DIV4, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3601 /* cv.cplxmul.i.div8 */, RISCV::CV_CPLXMUL_I_DIV8, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3619 /* cv.cplxmul.r */, RISCV::CV_CPLXMUL_R, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3632 /* cv.cplxmul.r.div2 */, RISCV::CV_CPLXMUL_R_DIV2, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3650 /* cv.cplxmul.r.div4 */, RISCV::CV_CPLXMUL_R_DIV4, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3668 /* cv.cplxmul.r.div8 */, RISCV::CV_CPLXMUL_R_DIV8, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3686 /* cv.dotsp.b */, RISCV::CV_DOTSP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3697 /* cv.dotsp.h */, RISCV::CV_DOTSP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3708 /* cv.dotsp.sc.b */, RISCV::CV_DOTSP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3722 /* cv.dotsp.sc.h */, RISCV::CV_DOTSP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3736 /* cv.dotsp.sci.b */, RISCV::CV_DOTSP_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3751 /* cv.dotsp.sci.h */, RISCV::CV_DOTSP_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3766 /* cv.dotup.b */, RISCV::CV_DOTUP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3777 /* cv.dotup.h */, RISCV::CV_DOTUP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3788 /* cv.dotup.sc.b */, RISCV::CV_DOTUP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3802 /* cv.dotup.sc.h */, RISCV::CV_DOTUP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3816 /* cv.dotup.sci.b */, RISCV::CV_DOTUP_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3831 /* cv.dotup.sci.h */, RISCV::CV_DOTUP_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3846 /* cv.dotusp.b */, RISCV::CV_DOTUSP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3858 /* cv.dotusp.h */, RISCV::CV_DOTUSP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3870 /* cv.dotusp.sc.b */, RISCV::CV_DOTUSP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3885 /* cv.dotusp.sc.h */, RISCV::CV_DOTUSP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3900 /* cv.dotusp.sci.b */, RISCV::CV_DOTUSP_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3916 /* cv.dotusp.sci.h */, RISCV::CV_DOTUSP_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3932 /* cv.elw */, RISCV::CV_ELW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasVendorXCVelw_IsRV32, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 3939 /* cv.extbs */, RISCV::CV_EXTBS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR }, },
  { 3948 /* cv.extbz */, RISCV::CV_EXTBZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR }, },
  { 3957 /* cv.exths */, RISCV::CV_EXTHS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR }, },
  { 3966 /* cv.exthz */, RISCV::CV_EXTHZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR }, },
  { 3975 /* cv.extract */, RISCV::CV_EXTRACT, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 3986 /* cv.extract.b */, RISCV::CV_EXTRACT_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3999 /* cv.extract.h */, RISCV::CV_EXTRACT_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4012 /* cv.extractr */, RISCV::CV_EXTRACTR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4024 /* cv.extractu */, RISCV::CV_EXTRACTU, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 4036 /* cv.extractu.b */, RISCV::CV_EXTRACTU_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4050 /* cv.extractu.h */, RISCV::CV_EXTRACTU_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4064 /* cv.extractur */, RISCV::CV_EXTRACTUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4077 /* cv.ff1 */, RISCV::CV_FF1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4084 /* cv.fl1 */, RISCV::CV_FL1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4091 /* cv.insert */, RISCV::CV_INSERT, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 4101 /* cv.insert.b */, RISCV::CV_INSERT_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4113 /* cv.insert.h */, RISCV::CV_INSERT_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4125 /* cv.insertr */, RISCV::CV_INSERTR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4136 /* cv.lb */, RISCV::CV_LB_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 4136 /* cv.lb */, RISCV::CV_LB_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 4136 /* cv.lb */, RISCV::CV_LB_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 4142 /* cv.lbu */, RISCV::CV_LBU_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 4142 /* cv.lbu */, RISCV::CV_LBU_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 4142 /* cv.lbu */, RISCV::CV_LBU_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 4149 /* cv.lh */, RISCV::CV_LH_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 4149 /* cv.lh */, RISCV::CV_LH_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 4149 /* cv.lh */, RISCV::CV_LH_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 4155 /* cv.lhu */, RISCV::CV_LHU_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 4155 /* cv.lhu */, RISCV::CV_LHU_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 4155 /* cv.lhu */, RISCV::CV_LHU_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 4162 /* cv.lw */, RISCV::CV_LW_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 4162 /* cv.lw */, RISCV::CV_LW_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 4162 /* cv.lw */, RISCV::CV_LW_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 4168 /* cv.mac */, RISCV::CV_MAC, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4175 /* cv.machhsn */, RISCV::CV_MACHHSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4186 /* cv.machhsrn */, RISCV::CV_MACHHSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4198 /* cv.machhun */, RISCV::CV_MACHHUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4209 /* cv.machhurn */, RISCV::CV_MACHHURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4221 /* cv.macsn */, RISCV::CV_MACSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4230 /* cv.macsrn */, RISCV::CV_MACSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4240 /* cv.macun */, RISCV::CV_MACUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4249 /* cv.macurn */, RISCV::CV_MACURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4259 /* cv.max */, RISCV::CV_MAX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4266 /* cv.max.b */, RISCV::CV_MAX_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4275 /* cv.max.h */, RISCV::CV_MAX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4284 /* cv.max.sc.b */, RISCV::CV_MAX_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4296 /* cv.max.sc.h */, RISCV::CV_MAX_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4308 /* cv.max.sci.b */, RISCV::CV_MAX_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4321 /* cv.max.sci.h */, RISCV::CV_MAX_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4334 /* cv.maxu */, RISCV::CV_MAXU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4342 /* cv.maxu.b */, RISCV::CV_MAXU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4352 /* cv.maxu.h */, RISCV::CV_MAXU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4362 /* cv.maxu.sc.b */, RISCV::CV_MAXU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4375 /* cv.maxu.sc.h */, RISCV::CV_MAXU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4388 /* cv.maxu.sci.b */, RISCV::CV_MAXU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4402 /* cv.maxu.sci.h */, RISCV::CV_MAXU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4416 /* cv.min */, RISCV::CV_MIN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4423 /* cv.min.b */, RISCV::CV_MIN_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4432 /* cv.min.h */, RISCV::CV_MIN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4441 /* cv.min.sc.b */, RISCV::CV_MIN_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4453 /* cv.min.sc.h */, RISCV::CV_MIN_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4465 /* cv.min.sci.b */, RISCV::CV_MIN_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4478 /* cv.min.sci.h */, RISCV::CV_MIN_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4491 /* cv.minu */, RISCV::CV_MINU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4499 /* cv.minu.b */, RISCV::CV_MINU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4509 /* cv.minu.h */, RISCV::CV_MINU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4519 /* cv.minu.sc.b */, RISCV::CV_MINU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4532 /* cv.minu.sc.h */, RISCV::CV_MINU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4545 /* cv.minu.sci.b */, RISCV::CV_MINU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4559 /* cv.minu.sci.h */, RISCV::CV_MINU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4573 /* cv.msu */, RISCV::CV_MSU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4580 /* cv.mulhhs */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4590 /* cv.mulhhsn */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4601 /* cv.mulhhsrn */, RISCV::CV_MULHHSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4613 /* cv.mulhhu */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4623 /* cv.mulhhun */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4634 /* cv.mulhhurn */, RISCV::CV_MULHHURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4646 /* cv.muls */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4654 /* cv.mulsn */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4663 /* cv.mulsrn */, RISCV::CV_MULSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4673 /* cv.mulu */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4681 /* cv.mulun */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4690 /* cv.mulurn */, RISCV::CV_MULURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 4700 /* cv.or.b */, RISCV::CV_OR_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4708 /* cv.or.h */, RISCV::CV_OR_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4716 /* cv.or.sc.b */, RISCV::CV_OR_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4727 /* cv.or.sc.h */, RISCV::CV_OR_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4738 /* cv.or.sci.b */, RISCV::CV_OR_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4750 /* cv.or.sci.h */, RISCV::CV_OR_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4762 /* cv.pack */, RISCV::CV_PACK, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4770 /* cv.pack.h */, RISCV::CV_PACK_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4780 /* cv.packhi.b */, RISCV::CV_PACKHI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4792 /* cv.packlo.b */, RISCV::CV_PACKLO_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4804 /* cv.ror */, RISCV::CV_ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4811 /* cv.sb */, RISCV::CV_SB_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 4811 /* cv.sb */, RISCV::CV_SB_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 4811 /* cv.sb */, RISCV::CV_SB_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 4817 /* cv.sdotsp.b */, RISCV::CV_SDOTSP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4829 /* cv.sdotsp.h */, RISCV::CV_SDOTSP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4841 /* cv.sdotsp.sc.b */, RISCV::CV_SDOTSP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4856 /* cv.sdotsp.sc.h */, RISCV::CV_SDOTSP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4871 /* cv.sdotsp.sci.b */, RISCV::CV_SDOTSP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4887 /* cv.sdotsp.sci.h */, RISCV::CV_SDOTSP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4903 /* cv.sdotup.b */, RISCV::CV_SDOTUP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4915 /* cv.sdotup.h */, RISCV::CV_SDOTUP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4927 /* cv.sdotup.sc.b */, RISCV::CV_SDOTUP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4942 /* cv.sdotup.sc.h */, RISCV::CV_SDOTUP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4957 /* cv.sdotup.sci.b */, RISCV::CV_SDOTUP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4973 /* cv.sdotup.sci.h */, RISCV::CV_SDOTUP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4989 /* cv.sdotusp.b */, RISCV::CV_SDOTUSP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5002 /* cv.sdotusp.h */, RISCV::CV_SDOTUSP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5015 /* cv.sdotusp.sc.b */, RISCV::CV_SDOTUSP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5031 /* cv.sdotusp.sc.h */, RISCV::CV_SDOTUSP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5047 /* cv.sdotusp.sci.b */, RISCV::CV_SDOTUSP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5064 /* cv.sdotusp.sci.h */, RISCV::CV_SDOTUSP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5081 /* cv.sh */, RISCV::CV_SH_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5081 /* cv.sh */, RISCV::CV_SH_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5081 /* cv.sh */, RISCV::CV_SH_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5087 /* cv.shuffle.b */, RISCV::CV_SHUFFLE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5100 /* cv.shuffle.h */, RISCV::CV_SHUFFLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5113 /* cv.shuffle.sci.h */, RISCV::CV_SHUFFLE_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5130 /* cv.shuffle2.b */, RISCV::CV_SHUFFLE2_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5144 /* cv.shuffle2.h */, RISCV::CV_SHUFFLE2_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5158 /* cv.shufflei0.sci.b */, RISCV::CV_SHUFFLEI0_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5177 /* cv.shufflei1.sci.b */, RISCV::CV_SHUFFLEI1_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5196 /* cv.shufflei2.sci.b */, RISCV::CV_SHUFFLEI2_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5215 /* cv.shufflei3.sci.b */, RISCV::CV_SHUFFLEI3_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5234 /* cv.slet */, RISCV::CV_SLET, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5242 /* cv.sletu */, RISCV::CV_SLETU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5251 /* cv.sll.b */, RISCV::CV_SLL_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5260 /* cv.sll.h */, RISCV::CV_SLL_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5269 /* cv.sll.sc.b */, RISCV::CV_SLL_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5281 /* cv.sll.sc.h */, RISCV::CV_SLL_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5293 /* cv.sll.sci.b */, RISCV::CV_SLL_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 5306 /* cv.sll.sci.h */, RISCV::CV_SLL_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 5319 /* cv.sra.b */, RISCV::CV_SRA_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5328 /* cv.sra.h */, RISCV::CV_SRA_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5337 /* cv.sra.sc.b */, RISCV::CV_SRA_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5349 /* cv.sra.sc.h */, RISCV::CV_SRA_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5361 /* cv.sra.sci.b */, RISCV::CV_SRA_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 5374 /* cv.sra.sci.h */, RISCV::CV_SRA_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 5387 /* cv.srl.b */, RISCV::CV_SRL_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5396 /* cv.srl.h */, RISCV::CV_SRL_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5405 /* cv.srl.sc.b */, RISCV::CV_SRL_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5417 /* cv.srl.sc.h */, RISCV::CV_SRL_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5429 /* cv.srl.sci.b */, RISCV::CV_SRL_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 5442 /* cv.srl.sci.h */, RISCV::CV_SRL_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 5455 /* cv.sub.b */, RISCV::CV_SUB_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5464 /* cv.sub.div2 */, RISCV::CV_SUB_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5476 /* cv.sub.div4 */, RISCV::CV_SUB_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5488 /* cv.sub.div8 */, RISCV::CV_SUB_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5500 /* cv.sub.h */, RISCV::CV_SUB_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5509 /* cv.sub.sc.b */, RISCV::CV_SUB_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5521 /* cv.sub.sc.h */, RISCV::CV_SUB_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5533 /* cv.sub.sci.b */, RISCV::CV_SUB_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5546 /* cv.sub.sci.h */, RISCV::CV_SUB_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5559 /* cv.subn */, RISCV::CV_SUBN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5567 /* cv.subnr */, RISCV::CV_SUBNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5576 /* cv.subrn */, RISCV::CV_SUBRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5585 /* cv.subrnr */, RISCV::CV_SUBRNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5595 /* cv.subrotmj */, RISCV::CV_SUBROTMJ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5607 /* cv.subrotmj.div2 */, RISCV::CV_SUBROTMJ_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5624 /* cv.subrotmj.div4 */, RISCV::CV_SUBROTMJ_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5641 /* cv.subrotmj.div8 */, RISCV::CV_SUBROTMJ_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5658 /* cv.subun */, RISCV::CV_SUBUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5667 /* cv.subunr */, RISCV::CV_SUBUNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5677 /* cv.suburn */, RISCV::CV_SUBURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5687 /* cv.suburnr */, RISCV::CV_SUBURNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5698 /* cv.sw */, RISCV::CV_SW_rr, Convert__Reg1_0__RegReg1_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5698 /* cv.sw */, RISCV::CV_SW_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5698 /* cv.sw */, RISCV::CV_SW_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5704 /* cv.xor.b */, RISCV::CV_XOR_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5713 /* cv.xor.h */, RISCV::CV_XOR_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5722 /* cv.xor.sc.b */, RISCV::CV_XOR_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5734 /* cv.xor.sc.h */, RISCV::CV_XOR_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5746 /* cv.xor.sci.b */, RISCV::CV_XOR_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5759 /* cv.xor.sci.h */, RISCV::CV_XOR_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5772 /* czero.eqz */, RISCV::CZERO_EQZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5782 /* czero.nez */, RISCV::CZERO_NEZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5792 /* div */, RISCV::DIV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5796 /* divu */, RISCV::DIVU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5801 /* divuw */, RISCV::DIVUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5807 /* divw */, RISCV::DIVW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5812 /* dret */, RISCV::DRET, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 5817 /* ebreak */, RISCV::EBREAK, Convert_NoOperands, AMFBS_None, {  }, },
  { 5824 /* ecall */, RISCV::ECALL, Convert_NoOperands, AMFBS_None, {  }, },
  { 5830 /* fabs.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 5830 /* fabs.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 5830 /* fabs.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 5837 /* fabs.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 5837 /* fabs.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 5844 /* fabs.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 5844 /* fabs.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 5851 /* fadd.d */, RISCV::FADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 5851 /* fadd.d */, RISCV::FADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 5851 /* fadd.d */, RISCV::FADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 5858 /* fadd.h */, RISCV::FADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 5858 /* fadd.h */, RISCV::FADD_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 5865 /* fadd.s */, RISCV::FADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 5865 /* fadd.s */, RISCV::FADD_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 5872 /* fclass.d */, RISCV::FCLASS_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64 }, },
  { 5872 /* fclass.d */, RISCV::FCLASS_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR }, },
  { 5872 /* fclass.d */, RISCV::FCLASS_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR }, },
  { 5881 /* fclass.h */, RISCV::FCLASS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16 }, },
  { 5881 /* fclass.h */, RISCV::FCLASS_H_INX, Convert__Reg1_0__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR }, },
  { 5890 /* fclass.s */, RISCV::FCLASS_S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 5890 /* fclass.s */, RISCV::FCLASS_S_INX, Convert__Reg1_0__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR }, },
  { 5899 /* fcvt.bf16.s */, RISCV::FCVT_BF16_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 5911 /* fcvt.d.h */, RISCV::FCVT_D_H, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfhmin_HasStdExtD, { MCK_FPR64, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 5911 /* fcvt.d.h */, RISCV::FCVT_D_H_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR, MCK_FRMArgLegacy }, },
  { 5911 /* fcvt.d.h */, RISCV::FCVT_D_H_IN32X, Convert__GPRPairAsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRAsFPR, MCK_FRMArgLegacy }, },
  { 5920 /* fcvt.d.l */, RISCV::FCVT_D_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 5920 /* fcvt.d.l */, RISCV::FCVT_D_L_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 5929 /* fcvt.d.lu */, RISCV::FCVT_D_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 5929 /* fcvt.d.lu */, RISCV::FCVT_D_LU_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 5939 /* fcvt.d.s */, RISCV::FCVT_D_S, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR32, MCK_FRMArgLegacy }, },
  { 5939 /* fcvt.d.s */, RISCV::FCVT_D_S_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR, MCK_FRMArgLegacy }, },
  { 5939 /* fcvt.d.s */, RISCV::FCVT_D_S_IN32X, Convert__GPRPairAsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRAsFPR, MCK_FRMArgLegacy }, },
  { 5948 /* fcvt.d.w */, RISCV::FCVT_D_W, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_FRMArgLegacy }, },
  { 5948 /* fcvt.d.w */, RISCV::FCVT_D_W_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 5948 /* fcvt.d.w */, RISCV::FCVT_D_W_IN32X, Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 5957 /* fcvt.d.wu */, RISCV::FCVT_D_WU, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_FRMArgLegacy }, },
  { 5957 /* fcvt.d.wu */, RISCV::FCVT_D_WU_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 5957 /* fcvt.d.wu */, RISCV::FCVT_D_WU_IN32X, Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 5967 /* fcvt.h.d */, RISCV::FCVT_H_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhmin_HasStdExtD, { MCK_FPR16, MCK_FPR64, MCK_FRMArg }, },
  { 5967 /* fcvt.h.d */, RISCV::FCVT_H_D_INX, Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 5967 /* fcvt.h.d */, RISCV::FCVT_H_D_IN32X, Convert__GPRAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 5976 /* fcvt.h.l */, RISCV::FCVT_H_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 5976 /* fcvt.h.l */, RISCV::FCVT_H_L_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 5985 /* fcvt.h.lu */, RISCV::FCVT_H_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 5985 /* fcvt.h.lu */, RISCV::FCVT_H_LU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 5995 /* fcvt.h.s */, RISCV::FCVT_H_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 5995 /* fcvt.h.s */, RISCV::FCVT_H_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6004 /* fcvt.h.w */, RISCV::FCVT_H_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 6004 /* fcvt.h.w */, RISCV::FCVT_H_W_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6013 /* fcvt.h.wu */, RISCV::FCVT_H_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 6013 /* fcvt.h.wu */, RISCV::FCVT_H_WU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6023 /* fcvt.l.d */, RISCV::FCVT_L_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 6023 /* fcvt.l.d */, RISCV::FCVT_L_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6032 /* fcvt.l.h */, RISCV::FCVT_L_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 6032 /* fcvt.l.h */, RISCV::FCVT_L_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6041 /* fcvt.l.s */, RISCV::FCVT_L_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 6041 /* fcvt.l.s */, RISCV::FCVT_L_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6050 /* fcvt.lu.d */, RISCV::FCVT_LU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 6050 /* fcvt.lu.d */, RISCV::FCVT_LU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6060 /* fcvt.lu.h */, RISCV::FCVT_LU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 6060 /* fcvt.lu.h */, RISCV::FCVT_LU_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6070 /* fcvt.lu.s */, RISCV::FCVT_LU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 6070 /* fcvt.lu.s */, RISCV::FCVT_LU_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6080 /* fcvt.s.bf16 */, RISCV::FCVT_S_BF16, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR32, MCK_FPR16, MCK_FRMArg }, },
  { 6092 /* fcvt.s.d */, RISCV::FCVT_S_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR32, MCK_FPR64, MCK_FRMArg }, },
  { 6092 /* fcvt.s.d */, RISCV::FCVT_S_D_INX, Convert__GPRAsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6092 /* fcvt.s.d */, RISCV::FCVT_S_D_IN32X, Convert__GPRAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6101 /* fcvt.s.h */, RISCV::FCVT_S_H, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfhmin, { MCK_FPR32, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 6101 /* fcvt.s.h */, RISCV::FCVT_S_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArgLegacy }, },
  { 6110 /* fcvt.s.l */, RISCV::FCVT_S_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 6110 /* fcvt.s.l */, RISCV::FCVT_S_L_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6119 /* fcvt.s.lu */, RISCV::FCVT_S_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 6119 /* fcvt.s.lu */, RISCV::FCVT_S_LU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6129 /* fcvt.s.w */, RISCV::FCVT_S_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 6129 /* fcvt.s.w */, RISCV::FCVT_S_W_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6138 /* fcvt.s.wu */, RISCV::FCVT_S_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 6138 /* fcvt.s.wu */, RISCV::FCVT_S_WU_INX, Convert__GPRAsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6148 /* fcvt.w.d */, RISCV::FCVT_W_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 6148 /* fcvt.w.d */, RISCV::FCVT_W_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6148 /* fcvt.w.d */, RISCV::FCVT_W_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6157 /* fcvt.w.h */, RISCV::FCVT_W_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 6157 /* fcvt.w.h */, RISCV::FCVT_W_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6166 /* fcvt.w.s */, RISCV::FCVT_W_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 6166 /* fcvt.w.s */, RISCV::FCVT_W_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6175 /* fcvt.wu.d */, RISCV::FCVT_WU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 6175 /* fcvt.wu.d */, RISCV::FCVT_WU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6175 /* fcvt.wu.d */, RISCV::FCVT_WU_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6185 /* fcvt.wu.h */, RISCV::FCVT_WU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 6185 /* fcvt.wu.h */, RISCV::FCVT_WU_H_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6195 /* fcvt.wu.s */, RISCV::FCVT_WU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 6195 /* fcvt.wu.s */, RISCV::FCVT_WU_S_INX, Convert__Reg1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6205 /* fcvtmod.w.d */, RISCV::FCVTMOD_W_D, Convert__Reg1_0__Reg1_1__RTZArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_RTZArg }, },
  { 6217 /* fdiv.d */, RISCV::FDIV_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6217 /* fdiv.d */, RISCV::FDIV_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6217 /* fdiv.d */, RISCV::FDIV_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6224 /* fdiv.h */, RISCV::FDIV_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6224 /* fdiv.h */, RISCV::FDIV_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6231 /* fdiv.s */, RISCV::FDIV_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6231 /* fdiv.s */, RISCV::FDIV_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6238 /* fence */, RISCV::FENCE, Convert__imm_95_15__imm_95_15, AMFBS_None, {  }, },
  { 6238 /* fence */, RISCV::FENCE, Convert__FenceArg1_0__FenceArg1_1, AMFBS_None, { MCK_FenceArg, MCK_FenceArg }, },
  { 6244 /* fence.i */, RISCV::FENCE_I, Convert_NoOperands, AMFBS_None, {  }, },
  { 6252 /* fence.tso */, RISCV::FENCE_TSO, Convert_NoOperands, AMFBS_None, {  }, },
  { 6262 /* feq.d */, RISCV::FEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6262 /* feq.d */, RISCV::FEQ_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6262 /* feq.d */, RISCV::FEQ_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6268 /* feq.h */, RISCV::FEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6268 /* feq.h */, RISCV::FEQ_H_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6274 /* feq.s */, RISCV::FEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6274 /* feq.s */, RISCV::FEQ_S_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6280 /* fge.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6280 /* fge.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6280 /* fge.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6286 /* fge.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6286 /* fge.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6292 /* fge.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6292 /* fge.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6298 /* fgeq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6305 /* fgeq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6312 /* fgeq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6319 /* fgt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6319 /* fgt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6319 /* fgt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6325 /* fgt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6325 /* fgt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6331 /* fgt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6331 /* fgt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR1_2__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6337 /* fgtq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6344 /* fgtq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6351 /* fgtq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6358 /* fld */, RISCV::PseudoFLD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 6358 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6358 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6362 /* fle.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6362 /* fle.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6362 /* fle.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6368 /* fle.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6368 /* fle.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6374 /* fle.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6374 /* fle.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6380 /* fleq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6387 /* fleq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6394 /* fleq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6401 /* flh */, RISCV::PseudoFLH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 6401 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6401 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6405 /* fli.d */, RISCV::FLI_D, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_LoadFPImm }, },
  { 6411 /* fli.h */, RISCV::FLI_H, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh, { MCK_FPR16, MCK_LoadFPImm }, },
  { 6417 /* fli.s */, RISCV::FLI_S, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_LoadFPImm }, },
  { 6423 /* flt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6423 /* flt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6423 /* flt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6429 /* flt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6429 /* flt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6435 /* flt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6435 /* flt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6441 /* fltq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 6448 /* fltq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 6455 /* fltq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 6462 /* flw */, RISCV::PseudoFLW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 6462 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6462 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6466 /* fmadd.d */, RISCV::FMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6466 /* fmadd.d */, RISCV::FMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6466 /* fmadd.d */, RISCV::FMADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6474 /* fmadd.h */, RISCV::FMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6474 /* fmadd.h */, RISCV::FMADD_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6482 /* fmadd.s */, RISCV::FMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6482 /* fmadd.s */, RISCV::FMADD_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6490 /* fmax.d */, RISCV::FMAX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 6490 /* fmax.d */, RISCV::FMAX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6490 /* fmax.d */, RISCV::FMAX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6497 /* fmax.h */, RISCV::FMAX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 6497 /* fmax.h */, RISCV::FMAX_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6504 /* fmax.s */, RISCV::FMAX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 6504 /* fmax.s */, RISCV::FMAX_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6511 /* fmaxm.d */, RISCV::FMAXM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 6519 /* fmaxm.h */, RISCV::FMAXM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 6527 /* fmaxm.s */, RISCV::FMAXM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 6535 /* fmin.d */, RISCV::FMIN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 6535 /* fmin.d */, RISCV::FMIN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6535 /* fmin.d */, RISCV::FMIN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6542 /* fmin.h */, RISCV::FMIN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 6542 /* fmin.h */, RISCV::FMIN_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6549 /* fmin.s */, RISCV::FMIN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 6549 /* fmin.s */, RISCV::FMIN_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6556 /* fminm.d */, RISCV::FMINM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 6564 /* fminm.h */, RISCV::FMINM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 6572 /* fminm.s */, RISCV::FMINM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 6580 /* fmsub.d */, RISCV::FMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6580 /* fmsub.d */, RISCV::FMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6580 /* fmsub.d */, RISCV::FMSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6588 /* fmsub.h */, RISCV::FMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6588 /* fmsub.h */, RISCV::FMSUB_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6596 /* fmsub.s */, RISCV::FMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6596 /* fmsub.s */, RISCV::FMSUB_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6604 /* fmul.d */, RISCV::FMUL_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6604 /* fmul.d */, RISCV::FMUL_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6604 /* fmul.d */, RISCV::FMUL_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6611 /* fmul.h */, RISCV::FMUL_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6611 /* fmul.h */, RISCV::FMUL_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6618 /* fmul.s */, RISCV::FMUL_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6618 /* fmul.s */, RISCV::FMUL_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6625 /* fmv.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 6631 /* fmv.d.x */, RISCV::FMV_D_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR }, },
  { 6639 /* fmv.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 6639 /* fmv.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6645 /* fmv.h.x */, RISCV::FMV_H_X, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_GPR }, },
  { 6653 /* fmv.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 6659 /* fmv.w.x */, RISCV::FMV_W_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR }, },
  { 6667 /* fmv.x.d */, RISCV::FMV_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64 }, },
  { 6675 /* fmv.x.h */, RISCV::FMV_X_H, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_GPR, MCK_FPR16 }, },
  { 6683 /* fmv.x.w */, RISCV::FMV_X_W, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 6691 /* fmvh.x.d */, RISCV::FMVH_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_GPR, MCK_FPR64 }, },
  { 6700 /* fmvp.d.x */, RISCV::FMVP_D_X, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_FPR64, MCK_GPR, MCK_GPR }, },
  { 6709 /* fneg.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 6709 /* fneg.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6709 /* fneg.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6716 /* fneg.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 6716 /* fneg.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6723 /* fneg.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 6723 /* fneg.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6730 /* fnmadd.d */, RISCV::FNMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6730 /* fnmadd.d */, RISCV::FNMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6730 /* fnmadd.d */, RISCV::FNMADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6739 /* fnmadd.h */, RISCV::FNMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6739 /* fnmadd.h */, RISCV::FNMADD_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6748 /* fnmadd.s */, RISCV::FNMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6748 /* fnmadd.s */, RISCV::FNMADD_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6757 /* fnmsub.d */, RISCV::FNMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6757 /* fnmsub.d */, RISCV::FNMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6757 /* fnmsub.d */, RISCV::FNMSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6766 /* fnmsub.h */, RISCV::FNMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6766 /* fnmsub.h */, RISCV::FNMSUB_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6775 /* fnmsub.s */, RISCV::FNMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6775 /* fnmsub.s */, RISCV::FNMSUB_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__GPRAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6784 /* frcsr */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 6790 /* frflags */, RISCV::CSRRS, Convert__Reg1_0__imm_95_1__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 6798 /* fround.d */, RISCV::FROUND_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6807 /* fround.h */, RISCV::FROUND_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6816 /* fround.s */, RISCV::FROUND_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6825 /* froundnx.d */, RISCV::FROUNDNX_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6836 /* froundnx.h */, RISCV::FROUNDNX_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6847 /* froundnx.s */, RISCV::FROUNDNX_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6858 /* frrm */, RISCV::CSRRS, Convert__Reg1_0__imm_95_2__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 6863 /* frsr */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3__regX0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 6868 /* fscsr */, RISCV::CSRRW, Convert__regX0__imm_95_3__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 6868 /* fscsr */, RISCV::CSRRW, Convert__Reg1_0__imm_95_3__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 6874 /* fsd */, RISCV::PseudoFSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 6874 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6874 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6878 /* fsflags */, RISCV::CSRRW, Convert__regX0__imm_95_1__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 6878 /* fsflags */, RISCV::CSRRW, Convert__Reg1_0__imm_95_1__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 6886 /* fsflagsi */, RISCV::CSRRWI, Convert__regX0__imm_95_1__UImm51_0, AMFBS_HasStdExtF, { MCK_UImm5 }, },
  { 6886 /* fsflagsi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_1__UImm51_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_UImm5 }, },
  { 6895 /* fsgnj.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 6895 /* fsgnj.d */, RISCV::FSGNJ_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6895 /* fsgnj.d */, RISCV::FSGNJ_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6903 /* fsgnj.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 6903 /* fsgnj.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6911 /* fsgnj.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 6911 /* fsgnj.s */, RISCV::FSGNJ_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6919 /* fsgnjn.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 6919 /* fsgnjn.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6919 /* fsgnjn.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6928 /* fsgnjn.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 6928 /* fsgnjn.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6937 /* fsgnjn.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 6937 /* fsgnjn.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6946 /* fsgnjx.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 6946 /* fsgnjx.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6946 /* fsgnjx.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6955 /* fsgnjx.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 6955 /* fsgnjx.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6964 /* fsgnjx.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 6964 /* fsgnjx.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR }, },
  { 6973 /* fsh */, RISCV::PseudoFSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 6973 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6973 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 6977 /* fsqrt.d */, RISCV::FSQRT_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6977 /* fsqrt.d */, RISCV::FSQRT_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6977 /* fsqrt.d */, RISCV::FSQRT_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6985 /* fsqrt.h */, RISCV::FSQRT_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6985 /* fsqrt.h */, RISCV::FSQRT_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 6993 /* fsqrt.s */, RISCV::FSQRT_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6993 /* fsqrt.s */, RISCV::FSQRT_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 7001 /* fsrm */, RISCV::CSRRW, Convert__regX0__imm_95_2__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 7001 /* fsrm */, RISCV::CSRRW, Convert__Reg1_0__imm_95_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 7006 /* fsrmi */, RISCV::CSRRWI, Convert__regX0__imm_95_2__UImm51_0, AMFBS_HasStdExtF, { MCK_UImm5 }, },
  { 7006 /* fsrmi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_2__UImm51_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_UImm5 }, },
  { 7012 /* fssr */, RISCV::CSRRW, Convert__regX0__imm_95_3__Reg1_0, AMFBS_HasStdExtF, { MCK_GPR }, },
  { 7012 /* fssr */, RISCV::CSRRW, Convert__Reg1_0__imm_95_3__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_GPR }, },
  { 7017 /* fsub.d */, RISCV::FSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7017 /* fsub.d */, RISCV::FSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7017 /* fsub.d */, RISCV::FSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7024 /* fsub.h */, RISCV::FSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7024 /* fsub.h */, RISCV::FSUB_H_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 7031 /* fsub.s */, RISCV::FSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7031 /* fsub.s */, RISCV::FSUB_S_INX, Convert__GPRAsFPR1_0__GPRAsFPR1_1__GPRAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_GPRAsFPR, MCK_FRMArg }, },
  { 7038 /* fsw */, RISCV::PseudoFSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 7038 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7038 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7042 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 7042 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 7042 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 7054 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 7054 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 7054 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 7066 /* hinval.gvma */, RISCV::HINVAL_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 7078 /* hinval.vvma */, RISCV::HINVAL_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 7090 /* hlv.b */, RISCV::HLV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7096 /* hlv.bu */, RISCV::HLV_BU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7103 /* hlv.d */, RISCV::HLV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7109 /* hlv.h */, RISCV::HLV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7115 /* hlv.hu */, RISCV::HLV_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7122 /* hlv.w */, RISCV::HLV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7128 /* hlv.wu */, RISCV::HLV_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7135 /* hlvx.hu */, RISCV::HLVX_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7143 /* hlvx.wu */, RISCV::HLVX_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7151 /* hsv.b */, RISCV::HSV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7157 /* hsv.d */, RISCV::HSV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7163 /* hsv.h */, RISCV::HSV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7169 /* hsv.w */, RISCV::HSV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7175 /* j */, RISCV::JAL, Convert__regX0__SImm21Lsb0JAL1_0, AMFBS_None, { MCK_SImm21Lsb0JAL }, },
  { 7177 /* jal */, RISCV::JAL, Convert__regX1__SImm21Lsb0JAL1_0, AMFBS_None, { MCK_SImm21Lsb0JAL }, },
  { 7177 /* jal */, RISCV::JAL, Convert__Reg1_0__SImm21Lsb0JAL1_1, AMFBS_None, { MCK_GPR, MCK_SImm21Lsb0JAL }, },
  { 7181 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 7181 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 7181 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 7181 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 7181 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7181 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7181 /* jalr */, RISCV::PseudoTLSDESCCall, Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_, MCK_TLSDESCCallSymbol }, },
  { 7186 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 7186 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 7186 /* jr */, RISCV::JALR, Convert__regX0__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7189 /* jump */, RISCV::PseudoJump, Convert__Reg1_1__PseudoJumpSymbol1_0, AMFBS_None, { MCK_PseudoJumpSymbol, MCK_GPR }, },
  { 7194 /* la */, RISCV::PseudoLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7194 /* la */, RISCV::PseudoLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 7197 /* la.tls.gd */, RISCV::PseudoLA_TLS_GD, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7207 /* la.tls.ie */, RISCV::PseudoLA_TLS_IE, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7217 /* la.tlsdesc */, RISCV::PseudoLA_TLSDESC, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7228 /* lb */, RISCV::PseudoLB, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7228 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7228 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7231 /* lbu */, RISCV::PseudoLBU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7231 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7231 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7235 /* ld */, RISCV::PseudoLD, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 7235 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7235 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7238 /* lga */, RISCV::PseudoLGA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7242 /* lh */, RISCV::PseudoLH, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7242 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7242 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7245 /* lhu */, RISCV::PseudoLHU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7245 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7245 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7249 /* li */, RISCV::ADDI, Convert__Reg1_0__regX0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 7249 /* li */, RISCV::PseudoLI, Convert__Reg1_0__ImmXLenLI1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI }, },
  { 7252 /* lla */, RISCV::PseudoLLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7252 /* lla */, RISCV::PseudoLLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 7256 /* lpad */, RISCV::AUIPC, Convert__regX0__UImm201_0, AMFBS_HasStdExtZicfilp, { MCK_UImm20 }, },
  { 7261 /* lr.d */, RISCV::LR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7266 /* lr.d.aq */, RISCV::LR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7274 /* lr.d.aqrl */, RISCV::LR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7284 /* lr.d.rl */, RISCV::LR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7292 /* lr.w */, RISCV::LR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7297 /* lr.w.aq */, RISCV::LR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7305 /* lr.w.aqrl */, RISCV::LR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7315 /* lr.w.rl */, RISCV::LR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7323 /* lui */, RISCV::LUI, Convert__Reg1_0__UImm20LUI1_1, AMFBS_None, { MCK_GPR, MCK_UImm20LUI }, },
  { 7327 /* lw */, RISCV::PseudoLW, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 7327 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7327 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7330 /* lwu */, RISCV::PseudoLWU, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 7330 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7330 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7334 /* max */, RISCV::MAX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7338 /* maxu */, RISCV::MAXU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7343 /* min */, RISCV::MIN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7347 /* minu */, RISCV::MINU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7352 /* mop.r.0 */, RISCV::MOPR0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7360 /* mop.r.1 */, RISCV::MOPR1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7368 /* mop.r.10 */, RISCV::MOPR10, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7377 /* mop.r.11 */, RISCV::MOPR11, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7386 /* mop.r.12 */, RISCV::MOPR12, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7395 /* mop.r.13 */, RISCV::MOPR13, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7404 /* mop.r.14 */, RISCV::MOPR14, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7413 /* mop.r.15 */, RISCV::MOPR15, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7422 /* mop.r.16 */, RISCV::MOPR16, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7431 /* mop.r.17 */, RISCV::MOPR17, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7440 /* mop.r.18 */, RISCV::MOPR18, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7449 /* mop.r.19 */, RISCV::MOPR19, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7458 /* mop.r.2 */, RISCV::MOPR2, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7466 /* mop.r.20 */, RISCV::MOPR20, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7475 /* mop.r.21 */, RISCV::MOPR21, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7484 /* mop.r.22 */, RISCV::MOPR22, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7493 /* mop.r.23 */, RISCV::MOPR23, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7502 /* mop.r.24 */, RISCV::MOPR24, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7511 /* mop.r.25 */, RISCV::MOPR25, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7520 /* mop.r.26 */, RISCV::MOPR26, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7529 /* mop.r.27 */, RISCV::MOPR27, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7538 /* mop.r.28 */, RISCV::MOPR28, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7547 /* mop.r.29 */, RISCV::MOPR29, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7556 /* mop.r.3 */, RISCV::MOPR3, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7564 /* mop.r.30 */, RISCV::MOPR30, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7573 /* mop.r.31 */, RISCV::MOPR31, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7582 /* mop.r.4 */, RISCV::MOPR4, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7590 /* mop.r.5 */, RISCV::MOPR5, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7598 /* mop.r.6 */, RISCV::MOPR6, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7606 /* mop.r.7 */, RISCV::MOPR7, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7614 /* mop.r.8 */, RISCV::MOPR8, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7622 /* mop.r.9 */, RISCV::MOPR9, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 7630 /* mop.rr.0 */, RISCV::MOPRR0, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7639 /* mop.rr.1 */, RISCV::MOPRR1, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7648 /* mop.rr.2 */, RISCV::MOPRR2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7657 /* mop.rr.3 */, RISCV::MOPRR3, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7666 /* mop.rr.4 */, RISCV::MOPRR4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7675 /* mop.rr.5 */, RISCV::MOPRR5, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7684 /* mop.rr.6 */, RISCV::MOPRR6, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7693 /* mop.rr.7 */, RISCV::MOPRR7, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7702 /* mret */, RISCV::MRET, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 7707 /* mul */, RISCV::MUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7711 /* mulh */, RISCV::MULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7716 /* mulhsu */, RISCV::MULHSU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7723 /* mulhu */, RISCV::MULHU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7729 /* mulw */, RISCV::MULW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtMOrZmmul_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7734 /* mv */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 7737 /* neg */, RISCV::SUB, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 7741 /* negw */, RISCV::SUBW, Convert__Reg1_0__regX0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 7746 /* nop */, RISCV::ADDI, Convert__regX0__regX0__imm_95_0, AMFBS_None, {  }, },
  { 7750 /* not */, RISCV::XORI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 7754 /* ntl.all */, RISCV::ADD, Convert__regX0__regX0__regX5, AMFBS_HasStdExtZihintntl, {  }, },
  { 7762 /* ntl.p1 */, RISCV::ADD, Convert__regX0__regX0__regX2, AMFBS_HasStdExtZihintntl, {  }, },
  { 7769 /* ntl.pall */, RISCV::ADD, Convert__regX0__regX0__regX3, AMFBS_HasStdExtZihintntl, {  }, },
  { 7778 /* ntl.s1 */, RISCV::ADD, Convert__regX0__regX0__regX4, AMFBS_HasStdExtZihintntl, {  }, },
  { 7785 /* or */, RISCV::OR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7785 /* or */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 7788 /* orc.b */, RISCV::ORC_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 7794 /* ori */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 7798 /* orn */, RISCV::ORN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7802 /* pack */, RISCV::PACK, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7807 /* packh */, RISCV::PACKH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7813 /* packw */, RISCV::PACKW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7819 /* pause */, RISCV::FENCE, Convert__imm_95_1__imm_95_0, AMFBS_HasStdExtZihintpause, {  }, },
  { 7825 /* prefetch.i */, RISCV::PREFETCH_I, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7836 /* prefetch.r */, RISCV::PREFETCH_R, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7847 /* prefetch.w */, RISCV::PREFETCH_W, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7858 /* rdcycle */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3072__regX0, AMFBS_None, { MCK_GPR }, },
  { 7866 /* rdcycleh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3200__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 7875 /* rdinstret */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3074__regX0, AMFBS_None, { MCK_GPR }, },
  { 7885 /* rdinstreth */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3202__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 7896 /* rdtime */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3073__regX0, AMFBS_None, { MCK_GPR }, },
  { 7903 /* rdtimeh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3201__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 7911 /* rem */, RISCV::REM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7915 /* remu */, RISCV::REMU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7920 /* remuw */, RISCV::REMUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7926 /* remw */, RISCV::REMW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7931 /* ret */, RISCV::JALR, Convert__regX0__regX1__imm_95_0, AMFBS_None, {  }, },
  { 7935 /* rev8 */, RISCV::REV8_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 7935 /* rev8 */, RISCV::REV8_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 7940 /* rol */, RISCV::ROL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7944 /* rolw */, RISCV::ROLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7949 /* ror */, RISCV::ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7949 /* ror */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 7953 /* rori */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 7958 /* roriw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 7964 /* rorw */, RISCV::RORW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 7964 /* rorw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 7969 /* sb */, RISCV::PseudoSB, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 7969 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7969 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7972 /* sc.d */, RISCV::SC_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7977 /* sc.d.aq */, RISCV::SC_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7985 /* sc.d.aqrl */, RISCV::SC_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 7995 /* sc.d.rl */, RISCV::SC_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8003 /* sc.w */, RISCV::SC_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8008 /* sc.w.aq */, RISCV::SC_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8016 /* sc.w.aqrl */, RISCV::SC_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8026 /* sc.w.rl */, RISCV::SC_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtA, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8034 /* sd */, RISCV::PseudoSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 8034 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8034 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8037 /* seqz */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__imm_95_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8042 /* sext.b */, RISCV::SEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 8042 /* sext.b */, RISCV::PseudoSEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8049 /* sext.h */, RISCV::SEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 8049 /* sext.h */, RISCV::PseudoSEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8056 /* sext.w */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 8063 /* sf.vc.fv */, RISCV::VC_FV, Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_UImm5, MCK_VM, MCK_FPR32 }, },
  { 8072 /* sf.vc.fvv */, RISCV::VC_FVV, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 8082 /* sf.vc.fvw */, RISCV::VC_FVW, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 8092 /* sf.vc.i */, RISCV::VC_I, Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_SImm5 }, },
  { 8100 /* sf.vc.iv */, RISCV::VC_IV, Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 8109 /* sf.vc.ivv */, RISCV::VC_IVV, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 8119 /* sf.vc.ivw */, RISCV::VC_IVW, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 8129 /* sf.vc.v.fv */, RISCV::VC_V_FV, Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 8140 /* sf.vc.v.fvv */, RISCV::VC_V_FVV, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 8152 /* sf.vc.v.fvw */, RISCV::VC_V_FVW, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 8164 /* sf.vc.v.i */, RISCV::VC_V_I, Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 8174 /* sf.vc.v.iv */, RISCV::VC_V_IV, Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 8185 /* sf.vc.v.ivv */, RISCV::VC_V_IVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 8197 /* sf.vc.v.ivw */, RISCV::VC_V_IVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 8209 /* sf.vc.v.vv */, RISCV::VC_V_VV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 8220 /* sf.vc.v.vvv */, RISCV::VC_V_VVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 8232 /* sf.vc.v.vvw */, RISCV::VC_V_VVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 8244 /* sf.vc.v.x */, RISCV::VC_V_X, Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 8254 /* sf.vc.v.xv */, RISCV::VC_V_XV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 8265 /* sf.vc.v.xvv */, RISCV::VC_V_XVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 8277 /* sf.vc.v.xvw */, RISCV::VC_V_XVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 8289 /* sf.vc.vv */, RISCV::VC_VV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_VM }, },
  { 8298 /* sf.vc.vvv */, RISCV::VC_VVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 8308 /* sf.vc.vvw */, RISCV::VC_VVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 8318 /* sf.vc.x */, RISCV::VC_X, Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_GPR }, },
  { 8326 /* sf.vc.xv */, RISCV::VC_XV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 8335 /* sf.vc.xvv */, RISCV::VC_XVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 8345 /* sf.vc.xvw */, RISCV::VC_XVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 8355 /* sf.vfnrclip.x.f.qf */, RISCV::VFNRCLIP_X_F_QF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXSfvfnrclipxfqf, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 8374 /* sf.vfnrclip.xu.f.qf */, RISCV::VFNRCLIP_XU_F_QF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXSfvfnrclipxfqf, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 8394 /* sf.vfwmacc.4x4x4 */, RISCV::VFWMACC_4x4x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvfwmaccqqq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8411 /* sf.vqmacc.2x8x2 */, RISCV::VQMACC_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8427 /* sf.vqmacc.4x8x4 */, RISCV::VQMACC_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8443 /* sf.vqmaccsu.2x8x2 */, RISCV::VQMACCSU_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8461 /* sf.vqmaccsu.4x8x4 */, RISCV::VQMACCSU_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8479 /* sf.vqmaccu.2x8x2 */, RISCV::VQMACCU_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8496 /* sf.vqmaccu.4x8x4 */, RISCV::VQMACCU_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8513 /* sf.vqmaccus.2x8x2 */, RISCV::VQMACCUS_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8531 /* sf.vqmaccus.4x8x4 */, RISCV::VQMACCUS_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 8549 /* sfence.inval.ir */, RISCV::SFENCE_INVAL_IR, Convert__imm_95_0__imm_95_0, AMFBS_HasStdExtSvinval, {  }, },
  { 8565 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 8565 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 8565 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8576 /* sfence.w.inval */, RISCV::SFENCE_W_INVAL, Convert__imm_95_0__imm_95_0, AMFBS_HasStdExtSvinval, {  }, },
  { 8591 /* sgt */, RISCV::SLT, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8595 /* sgtu */, RISCV::SLTU, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8600 /* sgtz */, RISCV::SLT, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8605 /* sh */, RISCV::PseudoSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 8605 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8605 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8608 /* sh1add */, RISCV::SH1ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8615 /* sh1add.uw */, RISCV::SH1ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8625 /* sh2add */, RISCV::SH2ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8632 /* sh2add.uw */, RISCV::SH2ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8642 /* sh3add */, RISCV::SH3ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8649 /* sh3add.uw */, RISCV::SH3ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8659 /* sha256sig0 */, RISCV::SHA256SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 8670 /* sha256sig1 */, RISCV::SHA256SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 8681 /* sha256sum0 */, RISCV::SHA256SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 8692 /* sha256sum1 */, RISCV::SHA256SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 8703 /* sha512sig0 */, RISCV::SHA512SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 8714 /* sha512sig0h */, RISCV::SHA512SIG0H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8726 /* sha512sig0l */, RISCV::SHA512SIG0L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8738 /* sha512sig1 */, RISCV::SHA512SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 8749 /* sha512sig1h */, RISCV::SHA512SIG1H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8761 /* sha512sig1l */, RISCV::SHA512SIG1L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8773 /* sha512sum0 */, RISCV::SHA512SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 8784 /* sha512sum0r */, RISCV::SHA512SUM0R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8796 /* sha512sum1 */, RISCV::SHA512SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 8807 /* sha512sum1r */, RISCV::SHA512SUM1R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8819 /* sinval.vma */, RISCV::SINVAL_VMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 8830 /* sll */, RISCV::SLL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8830 /* sll */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 8834 /* slli */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 8839 /* slli.uw */, RISCV::SLLI_UW, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 8847 /* slliw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 8853 /* sllw */, RISCV::SLLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8853 /* sllw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 8858 /* slt */, RISCV::SLT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8858 /* slt */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8862 /* slti */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8867 /* sltiu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8873 /* sltu */, RISCV::SLTU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8873 /* sltu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8878 /* sltz */, RISCV::SLT, Convert__Reg1_0__Reg1_1__regX0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8883 /* sm3p0 */, RISCV::SM3P0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 8889 /* sm3p1 */, RISCV::SM3P1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 8895 /* sm4ed */, RISCV::SM4ED, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 8901 /* sm4ks */, RISCV::SM4KS, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 8907 /* snez */, RISCV::SLTU, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8912 /* sra */, RISCV::SRA, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8912 /* sra */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 8916 /* srai */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 8921 /* sraiw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 8927 /* sraw */, RISCV::SRAW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8927 /* sraw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 8932 /* sret */, RISCV::SRET, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 8937 /* srl */, RISCV::SRL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8937 /* srl */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 8941 /* srli */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 8946 /* srliw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 8952 /* srlw */, RISCV::SRLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8952 /* srlw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 8957 /* ssamoswap.d */, RISCV::SSAMOSWAP_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8969 /* ssamoswap.d.aq */, RISCV::SSAMOSWAP_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8984 /* ssamoswap.d.aqrl */, RISCV::SSAMOSWAP_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9001 /* ssamoswap.d.rl */, RISCV::SSAMOSWAP_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9016 /* ssamoswap.w */, RISCV::SSAMOSWAP_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9028 /* ssamoswap.w.aq */, RISCV::SSAMOSWAP_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9043 /* ssamoswap.w.aqrl */, RISCV::SSAMOSWAP_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9060 /* ssamoswap.w.rl */, RISCV::SSAMOSWAP_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9075 /* sspopchk */, RISCV::SSPOPCHK, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRX1X5 }, },
  { 9084 /* sspush */, RISCV::SSPUSH, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRX1X5 }, },
  { 9091 /* ssrdp */, RISCV::SSRDP, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRNoX0 }, },
  { 9097 /* sub */, RISCV::SUB, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9101 /* subw */, RISCV::SUBW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9106 /* sw */, RISCV::PseudoSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 9106 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9106 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9109 /* tail */, RISCV::PseudoTAIL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 9114 /* th.addsl */, RISCV::TH_ADDSL, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadBa, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9123 /* th.dcache.call */, RISCV::TH_DCACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9138 /* th.dcache.ciall */, RISCV::TH_DCACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9154 /* th.dcache.cipa */, RISCV::TH_DCACHE_CIPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9169 /* th.dcache.cisw */, RISCV::TH_DCACHE_CISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9184 /* th.dcache.civa */, RISCV::TH_DCACHE_CIVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9199 /* th.dcache.cpa */, RISCV::TH_DCACHE_CPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9213 /* th.dcache.cpal1 */, RISCV::TH_DCACHE_CPAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9229 /* th.dcache.csw */, RISCV::TH_DCACHE_CSW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9243 /* th.dcache.cva */, RISCV::TH_DCACHE_CVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9257 /* th.dcache.cval1 */, RISCV::TH_DCACHE_CVAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9273 /* th.dcache.iall */, RISCV::TH_DCACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9288 /* th.dcache.ipa */, RISCV::TH_DCACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9302 /* th.dcache.isw */, RISCV::TH_DCACHE_ISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9316 /* th.dcache.iva */, RISCV::TH_DCACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9330 /* th.ext */, RISCV::TH_EXT, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 9337 /* th.extu */, RISCV::TH_EXTU, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 9345 /* th.ff0 */, RISCV::TH_FF0, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 9352 /* th.ff1 */, RISCV::TH_FF1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 9359 /* th.flrd */, RISCV::TH_FLRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9367 /* th.flrw */, RISCV::TH_FLRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9375 /* th.flurd */, RISCV::TH_FLURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9384 /* th.flurw */, RISCV::TH_FLURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9393 /* th.fsrd */, RISCV::TH_FSRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9401 /* th.fsrw */, RISCV::TH_FSRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9409 /* th.fsurd */, RISCV::TH_FSURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9418 /* th.fsurw */, RISCV::TH_FSURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9427 /* th.icache.iall */, RISCV::TH_ICACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9442 /* th.icache.ialls */, RISCV::TH_ICACHE_IALLS, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9458 /* th.icache.ipa */, RISCV::TH_ICACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9472 /* th.icache.iva */, RISCV::TH_ICACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 9486 /* th.l2cache.call */, RISCV::TH_L2CACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9502 /* th.l2cache.ciall */, RISCV::TH_L2CACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9519 /* th.l2cache.iall */, RISCV::TH_L2CACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 9535 /* th.lbia */, RISCV::TH_LBIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9543 /* th.lbib */, RISCV::TH_LBIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9551 /* th.lbuia */, RISCV::TH_LBUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9560 /* th.lbuib */, RISCV::TH_LBUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9569 /* th.ldd */, RISCV::TH_LDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 9576 /* th.ldia */, RISCV::TH_LDIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9584 /* th.ldib */, RISCV::TH_LDIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9592 /* th.lhia */, RISCV::TH_LHIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9600 /* th.lhib */, RISCV::TH_LHIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9608 /* th.lhuia */, RISCV::TH_LHUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9617 /* th.lhuib */, RISCV::TH_LHUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9626 /* th.lrb */, RISCV::TH_LRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9633 /* th.lrbu */, RISCV::TH_LRBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9641 /* th.lrd */, RISCV::TH_LRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9648 /* th.lrh */, RISCV::TH_LRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9655 /* th.lrhu */, RISCV::TH_LRHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9663 /* th.lrw */, RISCV::TH_LRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9670 /* th.lrwu */, RISCV::TH_LRWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9678 /* th.lurb */, RISCV::TH_LURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9686 /* th.lurbu */, RISCV::TH_LURBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9695 /* th.lurd */, RISCV::TH_LURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9703 /* th.lurh */, RISCV::TH_LURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9711 /* th.lurhu */, RISCV::TH_LURHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9720 /* th.lurw */, RISCV::TH_LURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9728 /* th.lurwu */, RISCV::TH_LURWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9737 /* th.lwd */, RISCV::TH_LWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 9744 /* th.lwia */, RISCV::TH_LWIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9752 /* th.lwib */, RISCV::TH_LWIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9760 /* th.lwud */, RISCV::TH_LWUD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 9768 /* th.lwuia */, RISCV::TH_LWUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9777 /* th.lwuib */, RISCV::TH_LWUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9786 /* th.mula */, RISCV::TH_MULA, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9794 /* th.mulah */, RISCV::TH_MULAH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9803 /* th.mulaw */, RISCV::TH_MULAW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9812 /* th.muls */, RISCV::TH_MULS, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9820 /* th.mulsh */, RISCV::TH_MULSH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9829 /* th.mulsw */, RISCV::TH_MULSW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9838 /* th.mveqz */, RISCV::TH_MVEQZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9847 /* th.mvnez */, RISCV::TH_MVNEZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9856 /* th.rev */, RISCV::TH_REV, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 9863 /* th.revw */, RISCV::TH_REVW, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 9871 /* th.sbia */, RISCV::TH_SBIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9879 /* th.sbib */, RISCV::TH_SBIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9887 /* th.sdd */, RISCV::TH_SDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 9894 /* th.sdia */, RISCV::TH_SDIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9902 /* th.sdib */, RISCV::TH_SDIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9910 /* th.sfence.vmas */, RISCV::TH_SFENCE_VMAS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadSync, { MCK_GPR, MCK_GPR }, },
  { 9925 /* th.shia */, RISCV::TH_SHIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9933 /* th.shib */, RISCV::TH_SHIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 9941 /* th.srb */, RISCV::TH_SRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9948 /* th.srd */, RISCV::TH_SRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9955 /* th.srh */, RISCV::TH_SRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9962 /* th.srri */, RISCV::TH_SRRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 9970 /* th.srriw */, RISCV::TH_SRRIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 9979 /* th.srw */, RISCV::TH_SRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9986 /* th.surb */, RISCV::TH_SURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 9994 /* th.surd */, RISCV::TH_SURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 10002 /* th.surh */, RISCV::TH_SURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 10010 /* th.surw */, RISCV::TH_SURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 10018 /* th.swd */, RISCV::TH_SWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 10025 /* th.swia */, RISCV::TH_SWIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 10033 /* th.swib */, RISCV::TH_SWIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 10041 /* th.sync */, RISCV::TH_SYNC, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 10049 /* th.sync.i */, RISCV::TH_SYNC_I, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 10059 /* th.sync.is */, RISCV::TH_SYNC_IS, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 10070 /* th.sync.s */, RISCV::TH_SYNC_S, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 10080 /* th.tst */, RISCV::TH_TST, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10087 /* th.tstnbz */, RISCV::TH_TSTNBZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 10097 /* th.vmaqa.vv */, RISCV::THVdotVMAQA_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10109 /* th.vmaqa.vx */, RISCV::THVdotVMAQA_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10121 /* th.vmaqasu.vv */, RISCV::THVdotVMAQASU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10135 /* th.vmaqasu.vx */, RISCV::THVdotVMAQASU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10149 /* th.vmaqau.vv */, RISCV::THVdotVMAQAU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10162 /* th.vmaqau.vx */, RISCV::THVdotVMAQAU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10175 /* th.vmaqaus.vx */, RISCV::THVdotVMAQAUS_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10189 /* unimp */, RISCV::UNIMP, Convert_NoOperands, AMFBS_None, {  }, },
  { 10195 /* unzip */, RISCV::UNZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 10201 /* vaadd.vv */, RISCV::VAADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10210 /* vaadd.vx */, RISCV::VAADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10219 /* vaaddu.vv */, RISCV::VAADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10229 /* vaaddu.vx */, RISCV::VAADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10239 /* vadc.vim */, RISCV::VADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_VMV0 }, },
  { 10248 /* vadc.vvm */, RISCV::VADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 10257 /* vadc.vxm */, RISCV::VADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 10266 /* vadd.vi */, RISCV::VADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10274 /* vadd.vv */, RISCV::VADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10282 /* vadd.vx */, RISCV::VADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10290 /* vaesdf.vs */, RISCV::VAESDF_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10300 /* vaesdf.vv */, RISCV::VAESDF_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10310 /* vaesdm.vs */, RISCV::VAESDM_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10320 /* vaesdm.vv */, RISCV::VAESDM_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10330 /* vaesef.vs */, RISCV::VAESEF_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10340 /* vaesef.vv */, RISCV::VAESEF_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10350 /* vaesem.vs */, RISCV::VAESEM_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10360 /* vaesem.vv */, RISCV::VAESEM_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10370 /* vaeskf1.vi */, RISCV::VAESKF1_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 10381 /* vaeskf2.vi */, RISCV::VAESKF2_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 10392 /* vaesz.vs */, RISCV::VAESZ_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 10401 /* vand.vi */, RISCV::VAND_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 10409 /* vand.vv */, RISCV::VAND_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10417 /* vand.vx */, RISCV::VAND_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10425 /* vandn.vv */, RISCV::VANDN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10434 /* vandn.vx */, RISCV::VANDN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10443 /* vasub.vv */, RISCV::VASUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10452 /* vasub.vx */, RISCV::VASUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10461 /* vasubu.vv */, RISCV::VASUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10471 /* vasubu.vx */, RISCV::VASUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10481 /* vbrev.v */, RISCV::VBREV_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10489 /* vbrev8.v */, RISCV::VBREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10498 /* vclmul.vv */, RISCV::VCLMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10508 /* vclmul.vx */, RISCV::VCLMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10518 /* vclmulh.vv */, RISCV::VCLMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10529 /* vclmulh.vx */, RISCV::VCLMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbc, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10540 /* vclz.v */, RISCV::VCLZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10547 /* vcompress.vm */, RISCV::VCOMPRESS_VM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10560 /* vcpop.m */, RISCV::VCPOP_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10568 /* vcpop.v */, RISCV::VCPOP_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10576 /* vctz.v */, RISCV::VCTZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10583 /* vdiv.vv */, RISCV::VDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10591 /* vdiv.vx */, RISCV::VDIV_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10599 /* vdivu.vv */, RISCV::VDIVU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10608 /* vdivu.vx */, RISCV::VDIVU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 10617 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 10617 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10625 /* vfadd.vf */, RISCV::VFADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10634 /* vfadd.vv */, RISCV::VFADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10643 /* vfclass.v */, RISCV::VFCLASS_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10653 /* vfcvt.f.x.v */, RISCV::VFCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10665 /* vfcvt.f.xu.v */, RISCV::VFCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10678 /* vfcvt.rtz.x.f.v */, RISCV::VFCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10694 /* vfcvt.rtz.xu.f.v */, RISCV::VFCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10711 /* vfcvt.x.f.v */, RISCV::VFCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10723 /* vfcvt.xu.f.v */, RISCV::VFCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10736 /* vfdiv.vf */, RISCV::VFDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10745 /* vfdiv.vv */, RISCV::VFDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10754 /* vfirst.m */, RISCV::VFIRST_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10763 /* vfmacc.vf */, RISCV::VFMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10773 /* vfmacc.vv */, RISCV::VFMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10783 /* vfmadd.vf */, RISCV::VFMADD_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10793 /* vfmadd.vv */, RISCV::VFMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10803 /* vfmax.vf */, RISCV::VFMAX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10812 /* vfmax.vv */, RISCV::VFMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10821 /* vfmerge.vfm */, RISCV::VFMERGE_VFM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_VMV0 }, },
  { 10833 /* vfmin.vf */, RISCV::VFMIN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10842 /* vfmin.vv */, RISCV::VFMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10851 /* vfmsac.vf */, RISCV::VFMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10861 /* vfmsac.vv */, RISCV::VFMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10871 /* vfmsub.vf */, RISCV::VFMSUB_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10881 /* vfmsub.vv */, RISCV::VFMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10891 /* vfmul.vf */, RISCV::VFMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10900 /* vfmul.vv */, RISCV::VFMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10909 /* vfmv.f.s */, RISCV::VFMV_F_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_FPR32, MCK_VM }, },
  { 10918 /* vfmv.s.f */, RISCV::VFMV_S_F, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 10927 /* vfmv.v.f */, RISCV::VFMV_V_F, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 10936 /* vfncvt.f.f.w */, RISCV::VFNCVT_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10949 /* vfncvt.f.x.w */, RISCV::VFNCVT_F_X_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10962 /* vfncvt.f.xu.w */, RISCV::VFNCVT_F_XU_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10976 /* vfncvt.rod.f.f.w */, RISCV::VFNCVT_ROD_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 10993 /* vfncvt.rtz.x.f.w */, RISCV::VFNCVT_RTZ_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11010 /* vfncvt.rtz.xu.f.w */, RISCV::VFNCVT_RTZ_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11028 /* vfncvt.x.f.w */, RISCV::VFNCVT_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11041 /* vfncvt.xu.f.w */, RISCV::VFNCVT_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11055 /* vfncvtbf16.f.f.w */, RISCV::VFNCVTBF16_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11072 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 11072 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11080 /* vfnmacc.vf */, RISCV::VFNMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11091 /* vfnmacc.vv */, RISCV::VFNMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11102 /* vfnmadd.vf */, RISCV::VFNMADD_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11113 /* vfnmadd.vv */, RISCV::VFNMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11124 /* vfnmsac.vf */, RISCV::VFNMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11135 /* vfnmsac.vv */, RISCV::VFNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11146 /* vfnmsub.vf */, RISCV::VFNMSUB_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11157 /* vfnmsub.vv */, RISCV::VFNMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11168 /* vfrdiv.vf */, RISCV::VFRDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11178 /* vfrec7.v */, RISCV::VFREC7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11187 /* vfredmax.vs */, RISCV::VFREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11199 /* vfredmin.vs */, RISCV::VFREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11211 /* vfredosum.vs */, RISCV::VFREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11224 /* vfredsum.vs */, RISCV::VFREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11236 /* vfredusum.vs */, RISCV::VFREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11249 /* vfrsqrt7.v */, RISCV::VFRSQRT7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11260 /* vfrsub.vf */, RISCV::VFRSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11270 /* vfsgnj.vf */, RISCV::VFSGNJ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11280 /* vfsgnj.vv */, RISCV::VFSGNJ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11290 /* vfsgnjn.vf */, RISCV::VFSGNJN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11301 /* vfsgnjn.vv */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11312 /* vfsgnjx.vf */, RISCV::VFSGNJX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11323 /* vfsgnjx.vv */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11334 /* vfslide1down.vf */, RISCV::VFSLIDE1DOWN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11350 /* vfslide1up.vf */, RISCV::VFSLIDE1UP_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11364 /* vfsqrt.v */, RISCV::VFSQRT_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11373 /* vfsub.vf */, RISCV::VFSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11382 /* vfsub.vv */, RISCV::VFSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11391 /* vfwadd.vf */, RISCV::VFWADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11401 /* vfwadd.vv */, RISCV::VFWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11411 /* vfwadd.wf */, RISCV::VFWADD_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11421 /* vfwadd.wv */, RISCV::VFWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11431 /* vfwcvt.f.f.v */, RISCV::VFWCVT_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11444 /* vfwcvt.f.x.v */, RISCV::VFWCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11457 /* vfwcvt.f.xu.v */, RISCV::VFWCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11471 /* vfwcvt.rtz.x.f.v */, RISCV::VFWCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11488 /* vfwcvt.rtz.xu.f.v */, RISCV::VFWCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11506 /* vfwcvt.x.f.v */, RISCV::VFWCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11519 /* vfwcvt.xu.f.v */, RISCV::VFWCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11533 /* vfwcvtbf16.f.f.v */, RISCV::VFWCVTBF16_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11550 /* vfwmacc.vf */, RISCV::VFWMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11561 /* vfwmacc.vv */, RISCV::VFWMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11572 /* vfwmaccbf16.vf */, RISCV::VFWMACCBF16_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11587 /* vfwmaccbf16.vv */, RISCV::VFWMACCBF16_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11602 /* vfwmsac.vf */, RISCV::VFWMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11613 /* vfwmsac.vv */, RISCV::VFWMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11624 /* vfwmul.vf */, RISCV::VFWMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11634 /* vfwmul.vv */, RISCV::VFWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11644 /* vfwnmacc.vf */, RISCV::VFWNMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11656 /* vfwnmacc.vv */, RISCV::VFWNMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11668 /* vfwnmsac.vf */, RISCV::VFWNMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11680 /* vfwnmsac.vv */, RISCV::VFWNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11692 /* vfwredosum.vs */, RISCV::VFWREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11706 /* vfwredsum.vs */, RISCV::VFWREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11719 /* vfwredusum.vs */, RISCV::VFWREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11733 /* vfwsub.vf */, RISCV::VFWSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11743 /* vfwsub.vv */, RISCV::VFWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11753 /* vfwsub.wf */, RISCV::VFWSUB_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 11763 /* vfwsub.wv */, RISCV::VFWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11773 /* vghsh.vv */, RISCV::VGHSH_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM, MCK_VM }, },
  { 11782 /* vgmul.vv */, RISCV::VGMUL_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM }, },
  { 11791 /* vid.v */, RISCV::VID_V, Convert__Reg1_0__RVVMaskRegOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11797 /* viota.m */, RISCV::VIOTA_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 11805 /* vl1r.v */, RISCV::VL1RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11812 /* vl1re16.v */, RISCV::VL1RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 11822 /* vl1re32.v */, RISCV::VL1RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 11832 /* vl1re64.v */, RISCV::VL1RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 11842 /* vl1re8.v */, RISCV::VL1RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 11851 /* vl2r.v */, RISCV::VL2RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM2, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11858 /* vl2re16.v */, RISCV::VL2RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 11868 /* vl2re32.v */, RISCV::VL2RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 11878 /* vl2re64.v */, RISCV::VL2RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 11888 /* vl2re8.v */, RISCV::VL2RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 11897 /* vl4r.v */, RISCV::VL4RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM4, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11904 /* vl4re16.v */, RISCV::VL4RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 11914 /* vl4re32.v */, RISCV::VL4RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 11924 /* vl4re64.v */, RISCV::VL4RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 11934 /* vl4re8.v */, RISCV::VL4RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 11943 /* vl8r.v */, RISCV::VL8RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM8, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11950 /* vl8re16.v */, RISCV::VL8RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 11960 /* vl8re32.v */, RISCV::VL8RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 11970 /* vl8re64.v */, RISCV::VL8RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 11980 /* vl8re8.v */, RISCV::VL8RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 11989 /* vle1.v */, RISCV::VLM_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11996 /* vle16.v */, RISCV::VLE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12004 /* vle16ff.v */, RISCV::VLE16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12014 /* vle32.v */, RISCV::VLE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12022 /* vle32ff.v */, RISCV::VLE32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12032 /* vle64.v */, RISCV::VLE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12040 /* vle64ff.v */, RISCV::VLE64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12050 /* vle8.v */, RISCV::VLE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12057 /* vle8ff.v */, RISCV::VLE8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12066 /* vlm.v */, RISCV::VLM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 12072 /* vloxei16.v */, RISCV::VLOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12083 /* vloxei32.v */, RISCV::VLOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12094 /* vloxei64.v */, RISCV::VLOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12105 /* vloxei8.v */, RISCV::VLOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12115 /* vloxseg2ei16.v */, RISCV::VLOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12130 /* vloxseg2ei32.v */, RISCV::VLOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12145 /* vloxseg2ei64.v */, RISCV::VLOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12160 /* vloxseg2ei8.v */, RISCV::VLOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12174 /* vloxseg3ei16.v */, RISCV::VLOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12189 /* vloxseg3ei32.v */, RISCV::VLOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12204 /* vloxseg3ei64.v */, RISCV::VLOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12219 /* vloxseg3ei8.v */, RISCV::VLOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12233 /* vloxseg4ei16.v */, RISCV::VLOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12248 /* vloxseg4ei32.v */, RISCV::VLOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12263 /* vloxseg4ei64.v */, RISCV::VLOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12278 /* vloxseg4ei8.v */, RISCV::VLOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12292 /* vloxseg5ei16.v */, RISCV::VLOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12307 /* vloxseg5ei32.v */, RISCV::VLOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12322 /* vloxseg5ei64.v */, RISCV::VLOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12337 /* vloxseg5ei8.v */, RISCV::VLOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12351 /* vloxseg6ei16.v */, RISCV::VLOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12366 /* vloxseg6ei32.v */, RISCV::VLOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12381 /* vloxseg6ei64.v */, RISCV::VLOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12396 /* vloxseg6ei8.v */, RISCV::VLOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12410 /* vloxseg7ei16.v */, RISCV::VLOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12425 /* vloxseg7ei32.v */, RISCV::VLOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12440 /* vloxseg7ei64.v */, RISCV::VLOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12455 /* vloxseg7ei8.v */, RISCV::VLOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12469 /* vloxseg8ei16.v */, RISCV::VLOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12484 /* vloxseg8ei32.v */, RISCV::VLOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12499 /* vloxseg8ei64.v */, RISCV::VLOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12514 /* vloxseg8ei8.v */, RISCV::VLOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12528 /* vlse16.v */, RISCV::VLSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12537 /* vlse32.v */, RISCV::VLSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12546 /* vlse64.v */, RISCV::VLSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12555 /* vlse8.v */, RISCV::VLSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12563 /* vlseg2e16.v */, RISCV::VLSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12575 /* vlseg2e16ff.v */, RISCV::VLSEG2E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12589 /* vlseg2e32.v */, RISCV::VLSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12601 /* vlseg2e32ff.v */, RISCV::VLSEG2E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12615 /* vlseg2e64.v */, RISCV::VLSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12627 /* vlseg2e64ff.v */, RISCV::VLSEG2E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12641 /* vlseg2e8.v */, RISCV::VLSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12652 /* vlseg2e8ff.v */, RISCV::VLSEG2E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12665 /* vlseg3e16.v */, RISCV::VLSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12677 /* vlseg3e16ff.v */, RISCV::VLSEG3E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12691 /* vlseg3e32.v */, RISCV::VLSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12703 /* vlseg3e32ff.v */, RISCV::VLSEG3E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12717 /* vlseg3e64.v */, RISCV::VLSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12729 /* vlseg3e64ff.v */, RISCV::VLSEG3E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12743 /* vlseg3e8.v */, RISCV::VLSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12754 /* vlseg3e8ff.v */, RISCV::VLSEG3E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12767 /* vlseg4e16.v */, RISCV::VLSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12779 /* vlseg4e16ff.v */, RISCV::VLSEG4E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12793 /* vlseg4e32.v */, RISCV::VLSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12805 /* vlseg4e32ff.v */, RISCV::VLSEG4E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12819 /* vlseg4e64.v */, RISCV::VLSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12831 /* vlseg4e64ff.v */, RISCV::VLSEG4E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12845 /* vlseg4e8.v */, RISCV::VLSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12856 /* vlseg4e8ff.v */, RISCV::VLSEG4E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12869 /* vlseg5e16.v */, RISCV::VLSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12881 /* vlseg5e16ff.v */, RISCV::VLSEG5E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12895 /* vlseg5e32.v */, RISCV::VLSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12907 /* vlseg5e32ff.v */, RISCV::VLSEG5E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12921 /* vlseg5e64.v */, RISCV::VLSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12933 /* vlseg5e64ff.v */, RISCV::VLSEG5E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12947 /* vlseg5e8.v */, RISCV::VLSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12958 /* vlseg5e8ff.v */, RISCV::VLSEG5E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12971 /* vlseg6e16.v */, RISCV::VLSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12983 /* vlseg6e16ff.v */, RISCV::VLSEG6E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 12997 /* vlseg6e32.v */, RISCV::VLSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13009 /* vlseg6e32ff.v */, RISCV::VLSEG6E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13023 /* vlseg6e64.v */, RISCV::VLSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13035 /* vlseg6e64ff.v */, RISCV::VLSEG6E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13049 /* vlseg6e8.v */, RISCV::VLSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13060 /* vlseg6e8ff.v */, RISCV::VLSEG6E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13073 /* vlseg7e16.v */, RISCV::VLSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13085 /* vlseg7e16ff.v */, RISCV::VLSEG7E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13099 /* vlseg7e32.v */, RISCV::VLSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13111 /* vlseg7e32ff.v */, RISCV::VLSEG7E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13125 /* vlseg7e64.v */, RISCV::VLSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13137 /* vlseg7e64ff.v */, RISCV::VLSEG7E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13151 /* vlseg7e8.v */, RISCV::VLSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13162 /* vlseg7e8ff.v */, RISCV::VLSEG7E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13175 /* vlseg8e16.v */, RISCV::VLSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13187 /* vlseg8e16ff.v */, RISCV::VLSEG8E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13201 /* vlseg8e32.v */, RISCV::VLSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13213 /* vlseg8e32ff.v */, RISCV::VLSEG8E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13227 /* vlseg8e64.v */, RISCV::VLSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13239 /* vlseg8e64ff.v */, RISCV::VLSEG8E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13253 /* vlseg8e8.v */, RISCV::VLSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13264 /* vlseg8e8ff.v */, RISCV::VLSEG8E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 13277 /* vlsseg2e16.v */, RISCV::VLSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13290 /* vlsseg2e32.v */, RISCV::VLSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13303 /* vlsseg2e64.v */, RISCV::VLSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13316 /* vlsseg2e8.v */, RISCV::VLSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13328 /* vlsseg3e16.v */, RISCV::VLSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13341 /* vlsseg3e32.v */, RISCV::VLSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13354 /* vlsseg3e64.v */, RISCV::VLSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13367 /* vlsseg3e8.v */, RISCV::VLSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13379 /* vlsseg4e16.v */, RISCV::VLSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13392 /* vlsseg4e32.v */, RISCV::VLSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13405 /* vlsseg4e64.v */, RISCV::VLSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13418 /* vlsseg4e8.v */, RISCV::VLSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13430 /* vlsseg5e16.v */, RISCV::VLSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13443 /* vlsseg5e32.v */, RISCV::VLSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13456 /* vlsseg5e64.v */, RISCV::VLSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13469 /* vlsseg5e8.v */, RISCV::VLSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13481 /* vlsseg6e16.v */, RISCV::VLSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13494 /* vlsseg6e32.v */, RISCV::VLSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13507 /* vlsseg6e64.v */, RISCV::VLSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13520 /* vlsseg6e8.v */, RISCV::VLSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13532 /* vlsseg7e16.v */, RISCV::VLSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13545 /* vlsseg7e32.v */, RISCV::VLSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13558 /* vlsseg7e64.v */, RISCV::VLSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13571 /* vlsseg7e8.v */, RISCV::VLSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13583 /* vlsseg8e16.v */, RISCV::VLSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13596 /* vlsseg8e32.v */, RISCV::VLSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13609 /* vlsseg8e64.v */, RISCV::VLSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13622 /* vlsseg8e8.v */, RISCV::VLSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 13634 /* vluxei16.v */, RISCV::VLUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13645 /* vluxei32.v */, RISCV::VLUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13656 /* vluxei64.v */, RISCV::VLUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13667 /* vluxei8.v */, RISCV::VLUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13677 /* vluxseg2ei16.v */, RISCV::VLUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13692 /* vluxseg2ei32.v */, RISCV::VLUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13707 /* vluxseg2ei64.v */, RISCV::VLUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13722 /* vluxseg2ei8.v */, RISCV::VLUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13736 /* vluxseg3ei16.v */, RISCV::VLUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13751 /* vluxseg3ei32.v */, RISCV::VLUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13766 /* vluxseg3ei64.v */, RISCV::VLUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13781 /* vluxseg3ei8.v */, RISCV::VLUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13795 /* vluxseg4ei16.v */, RISCV::VLUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13810 /* vluxseg4ei32.v */, RISCV::VLUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13825 /* vluxseg4ei64.v */, RISCV::VLUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13840 /* vluxseg4ei8.v */, RISCV::VLUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13854 /* vluxseg5ei16.v */, RISCV::VLUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13869 /* vluxseg5ei32.v */, RISCV::VLUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13884 /* vluxseg5ei64.v */, RISCV::VLUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13899 /* vluxseg5ei8.v */, RISCV::VLUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13913 /* vluxseg6ei16.v */, RISCV::VLUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13928 /* vluxseg6ei32.v */, RISCV::VLUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13943 /* vluxseg6ei64.v */, RISCV::VLUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13958 /* vluxseg6ei8.v */, RISCV::VLUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13972 /* vluxseg7ei16.v */, RISCV::VLUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13987 /* vluxseg7ei32.v */, RISCV::VLUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14002 /* vluxseg7ei64.v */, RISCV::VLUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14017 /* vluxseg7ei8.v */, RISCV::VLUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14031 /* vluxseg8ei16.v */, RISCV::VLUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14046 /* vluxseg8ei32.v */, RISCV::VLUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14061 /* vluxseg8ei64.v */, RISCV::VLUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14076 /* vluxseg8ei8.v */, RISCV::VLUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14090 /* vmacc.vv */, RISCV::VMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14099 /* vmacc.vx */, RISCV::VMACC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14108 /* vmadc.vi */, RISCV::VMADC_VI, Convert__Reg1_0__Reg1_1__SImm51_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 14117 /* vmadc.vim */, RISCV::VMADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_VMV0 }, },
  { 14127 /* vmadc.vv */, RISCV::VMADC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14136 /* vmadc.vvm */, RISCV::VMADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 14146 /* vmadc.vx */, RISCV::VMADC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 14155 /* vmadc.vxm */, RISCV::VMADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 14165 /* vmadd.vv */, RISCV::VMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14174 /* vmadd.vx */, RISCV::VMADD_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14183 /* vmand.mm */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14192 /* vmandn.mm */, RISCV::VMANDN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14202 /* vmandnot.mm */, RISCV::VMANDN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14214 /* vmax.vv */, RISCV::VMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14222 /* vmax.vx */, RISCV::VMAX_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14230 /* vmaxu.vv */, RISCV::VMAXU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14239 /* vmaxu.vx */, RISCV::VMAXU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14248 /* vmclr.m */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 14256 /* vmerge.vim */, RISCV::VMERGE_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_VMV0 }, },
  { 14267 /* vmerge.vvm */, RISCV::VMERGE_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 14278 /* vmerge.vxm */, RISCV::VMERGE_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 14289 /* vmfeq.vf */, RISCV::VMFEQ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 14298 /* vmfeq.vv */, RISCV::VMFEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14307 /* vmfge.vf */, RISCV::VMFGE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 14316 /* vmfge.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14325 /* vmfgt.vf */, RISCV::VMFGT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 14334 /* vmfgt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14343 /* vmfle.vf */, RISCV::VMFLE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 14352 /* vmfle.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14361 /* vmflt.vf */, RISCV::VMFLT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 14370 /* vmflt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14379 /* vmfne.vf */, RISCV::VMFNE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 14388 /* vmfne.vv */, RISCV::VMFNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14397 /* vmin.vv */, RISCV::VMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14405 /* vmin.vx */, RISCV::VMIN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14413 /* vminu.vv */, RISCV::VMINU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14422 /* vminu.vx */, RISCV::VMINU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14431 /* vmmv.m */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 14438 /* vmnand.mm */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14448 /* vmnor.mm */, RISCV::VMNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14457 /* vmnot.m */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 14465 /* vmor.mm */, RISCV::VMOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14473 /* vmorn.mm */, RISCV::VMORN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14482 /* vmornot.mm */, RISCV::VMORN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14493 /* vmsbc.vv */, RISCV::VMSBC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 14502 /* vmsbc.vvm */, RISCV::VMSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 14512 /* vmsbc.vx */, RISCV::VMSBC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 14521 /* vmsbc.vxm */, RISCV::VMSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 14531 /* vmsbf.m */, RISCV::VMSBF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14539 /* vmseq.vi */, RISCV::VMSEQ_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14548 /* vmseq.vv */, RISCV::VMSEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14557 /* vmseq.vx */, RISCV::VMSEQ_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14566 /* vmset.m */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 14574 /* vmsge.vi */, RISCV::PseudoVMSGE_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 14583 /* vmsge.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14592 /* vmsge.vx */, RISCV::PseudoVMSGE_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 14592 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14592 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 14601 /* vmsgeu.vi */, RISCV::PseudoVMSGEU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 14611 /* vmsgeu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14621 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 14621 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14621 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 14631 /* vmsgt.vi */, RISCV::VMSGT_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14640 /* vmsgt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14649 /* vmsgt.vx */, RISCV::VMSGT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14658 /* vmsgtu.vi */, RISCV::VMSGTU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14668 /* vmsgtu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14678 /* vmsgtu.vx */, RISCV::VMSGTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14688 /* vmsif.m */, RISCV::VMSIF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14696 /* vmsle.vi */, RISCV::VMSLE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14705 /* vmsle.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14714 /* vmsle.vx */, RISCV::VMSLE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14723 /* vmsleu.vi */, RISCV::VMSLEU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14733 /* vmsleu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14743 /* vmsleu.vx */, RISCV::VMSLEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14753 /* vmslt.vi */, RISCV::PseudoVMSLT_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 14762 /* vmslt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14771 /* vmslt.vx */, RISCV::VMSLT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14780 /* vmsltu.vi */, RISCV::PseudoVMSLTU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 14790 /* vmsltu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14800 /* vmsltu.vx */, RISCV::VMSLTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14810 /* vmsne.vi */, RISCV::VMSNE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 14819 /* vmsne.vv */, RISCV::VMSNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14828 /* vmsne.vx */, RISCV::VMSNE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14837 /* vmsof.m */, RISCV::VMSOF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14845 /* vmul.vv */, RISCV::VMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14853 /* vmul.vx */, RISCV::VMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14861 /* vmulh.vv */, RISCV::VMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14870 /* vmulh.vx */, RISCV::VMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14879 /* vmulhsu.vv */, RISCV::VMULHSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14890 /* vmulhsu.vx */, RISCV::VMULHSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14901 /* vmulhu.vv */, RISCV::VMULHU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14911 /* vmulhu.vx */, RISCV::VMULHU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14921 /* vmv.s.x */, RISCV::VMV_S_X, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 14929 /* vmv.v.i */, RISCV::VMV_V_I, Convert__Reg1_0__SImm51_1, AMFBS_HasVInstructions, { MCK_VM, MCK_SImm5 }, },
  { 14937 /* vmv.v.v */, RISCV::VMV_V_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 14945 /* vmv.v.x */, RISCV::VMV_V_X, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 14953 /* vmv.x.s */, RISCV::VMV_X_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM }, },
  { 14961 /* vmv1r.v */, RISCV::VMV1R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 14969 /* vmv2r.v */, RISCV::VMV2R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_VRM2 }, },
  { 14977 /* vmv4r.v */, RISCV::VMV4R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_VRM4 }, },
  { 14985 /* vmv8r.v */, RISCV::VMV8R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_VRM8 }, },
  { 14993 /* vmxnor.mm */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 15003 /* vmxor.mm */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 15012 /* vnclip.wi */, RISCV::VNCLIP_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15022 /* vnclip.wv */, RISCV::VNCLIP_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15032 /* vnclip.wx */, RISCV::VNCLIP_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15042 /* vnclipu.wi */, RISCV::VNCLIPU_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15053 /* vnclipu.wv */, RISCV::VNCLIPU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15064 /* vnclipu.wx */, RISCV::VNCLIPU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15075 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 15075 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15087 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 15087 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15094 /* vnmsac.vv */, RISCV::VNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15104 /* vnmsac.vx */, RISCV::VNMSAC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15114 /* vnmsub.vv */, RISCV::VNMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15124 /* vnmsub.vx */, RISCV::VNMSUB_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15134 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 15134 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15141 /* vnsra.wi */, RISCV::VNSRA_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15150 /* vnsra.wv */, RISCV::VNSRA_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15159 /* vnsra.wx */, RISCV::VNSRA_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15168 /* vnsrl.wi */, RISCV::VNSRL_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15177 /* vnsrl.wv */, RISCV::VNSRL_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15186 /* vnsrl.wx */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15195 /* vor.vi */, RISCV::VOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 15202 /* vor.vv */, RISCV::VOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15209 /* vor.vx */, RISCV::VOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15216 /* vpopc.m */, RISCV::VCPOP_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15224 /* vredand.vs */, RISCV::VREDAND_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15235 /* vredmax.vs */, RISCV::VREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15246 /* vredmaxu.vs */, RISCV::VREDMAXU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15258 /* vredmin.vs */, RISCV::VREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15269 /* vredminu.vs */, RISCV::VREDMINU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15281 /* vredor.vs */, RISCV::VREDOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15291 /* vredsum.vs */, RISCV::VREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15302 /* vredxor.vs */, RISCV::VREDXOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15313 /* vrem.vv */, RISCV::VREM_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15321 /* vrem.vx */, RISCV::VREM_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15329 /* vremu.vv */, RISCV::VREMU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15338 /* vremu.vx */, RISCV::VREMU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15347 /* vrev8.v */, RISCV::VREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15355 /* vrgather.vi */, RISCV::VRGATHER_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15367 /* vrgather.vv */, RISCV::VRGATHER_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15379 /* vrgather.vx */, RISCV::VRGATHER_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15391 /* vrgatherei16.vv */, RISCV::VRGATHEREI16_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15407 /* vrol.vv */, RISCV::VROL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15415 /* vrol.vx */, RISCV::VROL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15423 /* vror.vi */, RISCV::VROR_VI, Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_UImm6, MCK_RVVMaskRegOpOperand }, },
  { 15431 /* vror.vv */, RISCV::VROR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15439 /* vror.vx */, RISCV::VROR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15447 /* vrsub.vi */, RISCV::VRSUB_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 15456 /* vrsub.vx */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15465 /* vs1r.v */, RISCV::VS1R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 15472 /* vs2r.v */, RISCV::VS2R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 15479 /* vs4r.v */, RISCV::VS4R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 15486 /* vs8r.v */, RISCV::VS8R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 15493 /* vsadd.vi */, RISCV::VSADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 15502 /* vsadd.vv */, RISCV::VSADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15511 /* vsadd.vx */, RISCV::VSADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15520 /* vsaddu.vi */, RISCV::VSADDU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 15530 /* vsaddu.vv */, RISCV::VSADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15540 /* vsaddu.vx */, RISCV::VSADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15550 /* vsbc.vvm */, RISCV::VSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_VMV0 }, },
  { 15559 /* vsbc.vxm */, RISCV::VSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_VMV0 }, },
  { 15568 /* vse1.v */, RISCV::VSM_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 15575 /* vse16.v */, RISCV::VSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15583 /* vse32.v */, RISCV::VSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15591 /* vse64.v */, RISCV::VSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15599 /* vse8.v */, RISCV::VSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15606 /* vsetivli */, RISCV::VSETIVLI, Convert__Reg1_0__UImm51_1__VTypeI101_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_UImm5, MCK_VTypeI10 }, },
  { 15615 /* vsetvl */, RISCV::VSETVL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 15622 /* vsetvli */, RISCV::VSETVLI, Convert__Reg1_0__Reg1_1__VTypeI111_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_VTypeI11 }, },
  { 15630 /* vsext.vf2 */, RISCV::VSEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15640 /* vsext.vf4 */, RISCV::VSEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15650 /* vsext.vf8 */, RISCV::VSEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15660 /* vsha2ch.vv */, RISCV::VSHA2CH_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 15671 /* vsha2cl.vv */, RISCV::VSHA2CL_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 15682 /* vsha2ms.vv */, RISCV::VSHA2MS_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 15693 /* vslide1down.vx */, RISCV::VSLIDE1DOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15708 /* vslide1up.vx */, RISCV::VSLIDE1UP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15721 /* vslidedown.vi */, RISCV::VSLIDEDOWN_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15735 /* vslidedown.vx */, RISCV::VSLIDEDOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15749 /* vslideup.vi */, RISCV::VSLIDEUP_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15761 /* vslideup.vx */, RISCV::VSLIDEUP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15773 /* vsll.vi */, RISCV::VSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 15781 /* vsll.vv */, RISCV::VSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15789 /* vsll.vx */, RISCV::VSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15797 /* vsm.v */, RISCV::VSM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 15803 /* vsm3c.vi */, RISCV::VSM3C_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 15812 /* vsm3me.vv */, RISCV::VSM3ME_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_VM }, },
  { 15822 /* vsm4k.vi */, RISCV::VSM4K_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 15831 /* vsm4r.vs */, RISCV::VSM4R_VS, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 15840 /* vsm4r.vv */, RISCV::VSM4R_VV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 15849 /* vsmul.vv */, RISCV::VSMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15858 /* vsmul.vx */, RISCV::VSMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15867 /* vsoxei16.v */, RISCV::VSOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15878 /* vsoxei32.v */, RISCV::VSOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15889 /* vsoxei64.v */, RISCV::VSOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15900 /* vsoxei8.v */, RISCV::VSOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15910 /* vsoxseg2ei16.v */, RISCV::VSOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15925 /* vsoxseg2ei32.v */, RISCV::VSOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15940 /* vsoxseg2ei64.v */, RISCV::VSOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15955 /* vsoxseg2ei8.v */, RISCV::VSOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15969 /* vsoxseg3ei16.v */, RISCV::VSOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15984 /* vsoxseg3ei32.v */, RISCV::VSOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15999 /* vsoxseg3ei64.v */, RISCV::VSOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16014 /* vsoxseg3ei8.v */, RISCV::VSOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16028 /* vsoxseg4ei16.v */, RISCV::VSOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16043 /* vsoxseg4ei32.v */, RISCV::VSOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16058 /* vsoxseg4ei64.v */, RISCV::VSOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16073 /* vsoxseg4ei8.v */, RISCV::VSOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16087 /* vsoxseg5ei16.v */, RISCV::VSOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16102 /* vsoxseg5ei32.v */, RISCV::VSOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16117 /* vsoxseg5ei64.v */, RISCV::VSOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16132 /* vsoxseg5ei8.v */, RISCV::VSOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16146 /* vsoxseg6ei16.v */, RISCV::VSOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16161 /* vsoxseg6ei32.v */, RISCV::VSOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16176 /* vsoxseg6ei64.v */, RISCV::VSOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16191 /* vsoxseg6ei8.v */, RISCV::VSOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16205 /* vsoxseg7ei16.v */, RISCV::VSOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16220 /* vsoxseg7ei32.v */, RISCV::VSOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16235 /* vsoxseg7ei64.v */, RISCV::VSOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16250 /* vsoxseg7ei8.v */, RISCV::VSOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16264 /* vsoxseg8ei16.v */, RISCV::VSOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16279 /* vsoxseg8ei32.v */, RISCV::VSOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16294 /* vsoxseg8ei64.v */, RISCV::VSOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16309 /* vsoxseg8ei8.v */, RISCV::VSOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16323 /* vsra.vi */, RISCV::VSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 16331 /* vsra.vv */, RISCV::VSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16339 /* vsra.vx */, RISCV::VSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16347 /* vsrl.vi */, RISCV::VSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 16355 /* vsrl.vv */, RISCV::VSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16363 /* vsrl.vx */, RISCV::VSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16371 /* vsse16.v */, RISCV::VSSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16380 /* vsse32.v */, RISCV::VSSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16389 /* vsse64.v */, RISCV::VSSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16398 /* vsse8.v */, RISCV::VSSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16406 /* vsseg2e16.v */, RISCV::VSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16418 /* vsseg2e32.v */, RISCV::VSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16430 /* vsseg2e64.v */, RISCV::VSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16442 /* vsseg2e8.v */, RISCV::VSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16453 /* vsseg3e16.v */, RISCV::VSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16465 /* vsseg3e32.v */, RISCV::VSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16477 /* vsseg3e64.v */, RISCV::VSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16489 /* vsseg3e8.v */, RISCV::VSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16500 /* vsseg4e16.v */, RISCV::VSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16512 /* vsseg4e32.v */, RISCV::VSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16524 /* vsseg4e64.v */, RISCV::VSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16536 /* vsseg4e8.v */, RISCV::VSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16547 /* vsseg5e16.v */, RISCV::VSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16559 /* vsseg5e32.v */, RISCV::VSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16571 /* vsseg5e64.v */, RISCV::VSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16583 /* vsseg5e8.v */, RISCV::VSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16594 /* vsseg6e16.v */, RISCV::VSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16606 /* vsseg6e32.v */, RISCV::VSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16618 /* vsseg6e64.v */, RISCV::VSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16630 /* vsseg6e8.v */, RISCV::VSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16641 /* vsseg7e16.v */, RISCV::VSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16653 /* vsseg7e32.v */, RISCV::VSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16665 /* vsseg7e64.v */, RISCV::VSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16677 /* vsseg7e8.v */, RISCV::VSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16688 /* vsseg8e16.v */, RISCV::VSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16700 /* vsseg8e32.v */, RISCV::VSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16712 /* vsseg8e64.v */, RISCV::VSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16724 /* vsseg8e8.v */, RISCV::VSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 16735 /* vssra.vi */, RISCV::VSSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 16744 /* vssra.vv */, RISCV::VSSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16753 /* vssra.vx */, RISCV::VSSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16762 /* vssrl.vi */, RISCV::VSSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 16771 /* vssrl.vv */, RISCV::VSSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16780 /* vssrl.vx */, RISCV::VSSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16789 /* vssseg2e16.v */, RISCV::VSSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16802 /* vssseg2e32.v */, RISCV::VSSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16815 /* vssseg2e64.v */, RISCV::VSSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16828 /* vssseg2e8.v */, RISCV::VSSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16840 /* vssseg3e16.v */, RISCV::VSSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16853 /* vssseg3e32.v */, RISCV::VSSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16866 /* vssseg3e64.v */, RISCV::VSSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16879 /* vssseg3e8.v */, RISCV::VSSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16891 /* vssseg4e16.v */, RISCV::VSSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16904 /* vssseg4e32.v */, RISCV::VSSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16917 /* vssseg4e64.v */, RISCV::VSSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16930 /* vssseg4e8.v */, RISCV::VSSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16942 /* vssseg5e16.v */, RISCV::VSSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16955 /* vssseg5e32.v */, RISCV::VSSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16968 /* vssseg5e64.v */, RISCV::VSSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16981 /* vssseg5e8.v */, RISCV::VSSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16993 /* vssseg6e16.v */, RISCV::VSSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17006 /* vssseg6e32.v */, RISCV::VSSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17019 /* vssseg6e64.v */, RISCV::VSSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17032 /* vssseg6e8.v */, RISCV::VSSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17044 /* vssseg7e16.v */, RISCV::VSSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17057 /* vssseg7e32.v */, RISCV::VSSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17070 /* vssseg7e64.v */, RISCV::VSSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17083 /* vssseg7e8.v */, RISCV::VSSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17095 /* vssseg8e16.v */, RISCV::VSSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17108 /* vssseg8e32.v */, RISCV::VSSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17121 /* vssseg8e64.v */, RISCV::VSSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17134 /* vssseg8e8.v */, RISCV::VSSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17146 /* vssub.vv */, RISCV::VSSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17155 /* vssub.vx */, RISCV::VSSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17164 /* vssubu.vv */, RISCV::VSSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17174 /* vssubu.vx */, RISCV::VSSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17184 /* vsub.vv */, RISCV::VSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17192 /* vsub.vx */, RISCV::VSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17200 /* vsuxei16.v */, RISCV::VSUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17211 /* vsuxei32.v */, RISCV::VSUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17222 /* vsuxei64.v */, RISCV::VSUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17233 /* vsuxei8.v */, RISCV::VSUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17243 /* vsuxseg2ei16.v */, RISCV::VSUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17258 /* vsuxseg2ei32.v */, RISCV::VSUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17273 /* vsuxseg2ei64.v */, RISCV::VSUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17288 /* vsuxseg2ei8.v */, RISCV::VSUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17302 /* vsuxseg3ei16.v */, RISCV::VSUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17317 /* vsuxseg3ei32.v */, RISCV::VSUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17332 /* vsuxseg3ei64.v */, RISCV::VSUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17347 /* vsuxseg3ei8.v */, RISCV::VSUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17361 /* vsuxseg4ei16.v */, RISCV::VSUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17376 /* vsuxseg4ei32.v */, RISCV::VSUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17391 /* vsuxseg4ei64.v */, RISCV::VSUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17406 /* vsuxseg4ei8.v */, RISCV::VSUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17420 /* vsuxseg5ei16.v */, RISCV::VSUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17435 /* vsuxseg5ei32.v */, RISCV::VSUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17450 /* vsuxseg5ei64.v */, RISCV::VSUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17465 /* vsuxseg5ei8.v */, RISCV::VSUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17479 /* vsuxseg6ei16.v */, RISCV::VSUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17494 /* vsuxseg6ei32.v */, RISCV::VSUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17509 /* vsuxseg6ei64.v */, RISCV::VSUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17524 /* vsuxseg6ei8.v */, RISCV::VSUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17538 /* vsuxseg7ei16.v */, RISCV::VSUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17553 /* vsuxseg7ei32.v */, RISCV::VSUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17568 /* vsuxseg7ei64.v */, RISCV::VSUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17583 /* vsuxseg7ei8.v */, RISCV::VSUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17597 /* vsuxseg8ei16.v */, RISCV::VSUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17612 /* vsuxseg8ei32.v */, RISCV::VSUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17627 /* vsuxseg8ei64.v */, RISCV::VSUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17642 /* vsuxseg8ei8.v */, RISCV::VSUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17656 /* vt.maskc */, RISCV::VT_MASKC, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 17665 /* vt.maskcn */, RISCV::VT_MASKCN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 17675 /* vwadd.vv */, RISCV::VWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17684 /* vwadd.vx */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17693 /* vwadd.wv */, RISCV::VWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17702 /* vwadd.wx */, RISCV::VWADD_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17711 /* vwaddu.vv */, RISCV::VWADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17721 /* vwaddu.vx */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17731 /* vwaddu.wv */, RISCV::VWADDU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17741 /* vwaddu.wx */, RISCV::VWADDU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17751 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 17751 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17763 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 17763 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17776 /* vwmacc.vv */, RISCV::VWMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17786 /* vwmacc.vx */, RISCV::VWMACC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17796 /* vwmaccsu.vv */, RISCV::VWMACCSU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17808 /* vwmaccsu.vx */, RISCV::VWMACCSU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17820 /* vwmaccu.vv */, RISCV::VWMACCU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17831 /* vwmaccu.vx */, RISCV::VWMACCU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17842 /* vwmaccus.vx */, RISCV::VWMACCUS_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17854 /* vwmul.vv */, RISCV::VWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17863 /* vwmul.vx */, RISCV::VWMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17872 /* vwmulsu.vv */, RISCV::VWMULSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17883 /* vwmulsu.vx */, RISCV::VWMULSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17894 /* vwmulu.vv */, RISCV::VWMULU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17904 /* vwmulu.vx */, RISCV::VWMULU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17914 /* vwredsum.vs */, RISCV::VWREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17926 /* vwredsumu.vs */, RISCV::VWREDSUMU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17939 /* vwsll.vi */, RISCV::VWSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17948 /* vwsll.vv */, RISCV::VWSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17957 /* vwsll.vx */, RISCV::VWSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17966 /* vwsub.vv */, RISCV::VWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17975 /* vwsub.vx */, RISCV::VWSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17984 /* vwsub.wv */, RISCV::VWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17993 /* vwsub.wx */, RISCV::VWSUB_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18002 /* vwsubu.vv */, RISCV::VWSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18012 /* vwsubu.vx */, RISCV::VWSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18022 /* vwsubu.wv */, RISCV::VWSUBU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18032 /* vwsubu.wx */, RISCV::VWSUBU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18042 /* vxor.vi */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 18050 /* vxor.vv */, RISCV::VXOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18058 /* vxor.vx */, RISCV::VXOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18066 /* vzext.vf2 */, RISCV::VZEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18076 /* vzext.vf4 */, RISCV::VZEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18086 /* vzext.vf8 */, RISCV::VZEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18096 /* wfi */, RISCV::WFI, Convert__imm_95_0__imm_95_0, AMFBS_None, {  }, },
  { 18100 /* wrs.nto */, RISCV::WRS_NTO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 18108 /* wrs.sto */, RISCV::WRS_STO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 18116 /* xnor */, RISCV::XNOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 18121 /* xor */, RISCV::XOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 18121 /* xor */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 18125 /* xori */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 18130 /* xperm4 */, RISCV::XPERM4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 18137 /* xperm8 */, RISCV::XPERM8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 18144 /* zext.b */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__imm_95_255, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 18151 /* zext.h */, RISCV::ZEXT_H_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 18151 /* zext.h */, RISCV::ZEXT_H_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 18151 /* zext.h */, RISCV::PseudoZEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 18158 /* zext.w */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 18158 /* zext.w */, RISCV::PseudoZEXT_W, Convert__Reg1_0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 18165 /* zip */, RISCV::ZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned RISCVAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 8) {
    ErrorInfo = 8;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((RISCVOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  SmallBitVector OptionalOperandsMask(7);
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    OptionalOperandsMask.reset(0, 7);
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 7; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          OptionalOperandsMask.set(FormalIdx, 7);
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          OptionalOperandsMask.set(FormalIdx);
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        OptionalOperandsMask.set(FormalIdx);
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands, ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands,
                    OptionalOperandsMask);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands, ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[1436] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 0 /* .insn_b */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 8 /* .insn_ca */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 17 /* .insn_cb */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 26 /* .insn_ci */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 35 /* .insn_ciw */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 45 /* .insn_cj */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 54 /* .insn_cl */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 63 /* .insn_cr */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 72 /* .insn_cs */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 81 /* .insn_css */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 91 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 91 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 99 /* .insn_j */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 99 /* .insn_j */, 4 /* 2 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 107 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 107 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 115 /* .insn_r4 */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 124 /* .insn_s */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 132 /* .insn_sb */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 141 /* .insn_u */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 149 /* .insn_uj */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 149 /* .insn_uj */, 4 /* 2 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 158 /* add */, 8 /* 3 */, MCK_TPRelAddSymbol, AMFBS_None },
  { 284 /* amoadd.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 293 /* amoadd.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 305 /* amoadd.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 319 /* amoadd.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 331 /* amoadd.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 340 /* amoadd.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 352 /* amoadd.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 366 /* amoadd.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 378 /* amoand.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 387 /* amoand.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 399 /* amoand.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 413 /* amoand.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 425 /* amoand.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 434 /* amoand.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 446 /* amoand.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 460 /* amoand.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 472 /* amocas.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 472 /* amocas.d */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 472 /* amocas.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 481 /* amocas.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 481 /* amocas.d.aq */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 481 /* amocas.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 493 /* amocas.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 493 /* amocas.d.aqrl */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 493 /* amocas.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 507 /* amocas.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 507 /* amocas.d.rl */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 507 /* amocas.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 519 /* amocas.q */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 519 /* amocas.q */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 528 /* amocas.q.aq */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 528 /* amocas.q.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 540 /* amocas.q.aqrl */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 540 /* amocas.q.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 554 /* amocas.q.rl */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 554 /* amocas.q.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 566 /* amocas.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 575 /* amocas.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 587 /* amocas.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 601 /* amocas.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 613 /* amomax.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 622 /* amomax.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 634 /* amomax.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 648 /* amomax.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 660 /* amomax.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 669 /* amomax.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 681 /* amomax.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 695 /* amomax.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 707 /* amomaxu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 717 /* amomaxu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 730 /* amomaxu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 745 /* amomaxu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 758 /* amomaxu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 768 /* amomaxu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 781 /* amomaxu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 796 /* amomaxu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 809 /* amomin.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 818 /* amomin.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 830 /* amomin.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 844 /* amomin.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 856 /* amomin.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 865 /* amomin.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 877 /* amomin.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 891 /* amomin.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 903 /* amominu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 913 /* amominu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 926 /* amominu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 941 /* amominu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 954 /* amominu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 964 /* amominu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 977 /* amominu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 992 /* amominu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1005 /* amoor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1013 /* amoor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1024 /* amoor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1037 /* amoor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1048 /* amoor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1056 /* amoor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1067 /* amoor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1080 /* amoor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1091 /* amoswap.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1101 /* amoswap.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1114 /* amoswap.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1129 /* amoswap.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1142 /* amoswap.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1152 /* amoswap.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1165 /* amoswap.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1180 /* amoswap.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1193 /* amoxor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1202 /* amoxor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1214 /* amoxor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1228 /* amoxor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 1240 /* amoxor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1249 /* amoxor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1261 /* amoxor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1275 /* amoxor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 1888 /* call */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 1888 /* call */, 2 /* 1 */, MCK_CallSymbol, AMFBS_None },
  { 1893 /* cbo.clean */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 1903 /* cbo.flush */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 1913 /* cbo.inval */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 1923 /* cbo.zero */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicboz },
  { 1995 /* cm.pop */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 1995 /* cm.pop */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2002 /* cm.popret */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 2002 /* cm.popret */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2012 /* cm.popretz */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 2012 /* cm.popretz */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2023 /* cm.push */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 2023 /* cm.push */, 2 /* 1 */, MCK_Spimm, AMFBS_HasStdExtZcmp },
  { 2101 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2101 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2106 /* csrci */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2112 /* csrr */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2117 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2117 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2123 /* csrrci */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2130 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2130 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2136 /* csrrsi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2143 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2143 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2149 /* csrrwi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2156 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2156 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2161 /* csrsi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2167 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2167 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 2172 /* csrwi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 4136 /* cv.lb */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 4142 /* cv.lbu */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 4149 /* cv.lh */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 4155 /* cv.lhu */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 4162 /* cv.lw */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 4811 /* cv.sb */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5081 /* cv.sh */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5698 /* cv.sw */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5830 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5830 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5837 /* fabs.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 5844 /* fabs.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 5851 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 5851 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5851 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5851 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5851 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5858 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 5858 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 5858 /* fadd.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 5865 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 5865 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 5865 /* fadd.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 5872 /* fclass.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5872 /* fclass.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5881 /* fclass.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 5890 /* fclass.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 5899 /* fcvt.bf16.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfbfmin },
  { 5911 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfhmin_HasStdExtD },
  { 5911 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 5911 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 5911 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 5911 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 5911 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 5911 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 5920 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 5920 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 5920 /* fcvt.d.l */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 5929 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 5929 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 5929 /* fcvt.d.lu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 5939 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 5939 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5939 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5939 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5939 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5939 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5939 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5948 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 5948 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5948 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5948 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5948 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5957 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 5957 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5957 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 5957 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5957 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 5967 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhmin_HasStdExtD },
  { 5967 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 5967 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 5967 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 5967 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 5967 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 5967 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 5976 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 5976 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 5976 /* fcvt.h.l */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 5985 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 5985 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 5985 /* fcvt.h.lu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 5995 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhmin },
  { 5995 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin },
  { 5995 /* fcvt.h.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxmin },
  { 6004 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6004 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6004 /* fcvt.h.w */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6013 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6013 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6013 /* fcvt.h.wu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6023 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 6023 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6023 /* fcvt.l.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6032 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 6032 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6032 /* fcvt.l.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6041 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 6041 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6041 /* fcvt.l.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6050 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 6050 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6050 /* fcvt.lu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6060 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 6060 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6060 /* fcvt.lu.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6070 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 6070 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6070 /* fcvt.lu.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6080 /* fcvt.s.bf16 */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfbfmin },
  { 6092 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6092 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6092 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6092 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6092 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6092 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6092 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6101 /* fcvt.s.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfhmin },
  { 6101 /* fcvt.s.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin },
  { 6101 /* fcvt.s.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinxmin },
  { 6110 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 6110 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6110 /* fcvt.s.l */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6119 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 6119 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6119 /* fcvt.s.lu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx_IsRV64 },
  { 6129 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6129 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6129 /* fcvt.s.w */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6138 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6138 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6138 /* fcvt.s.wu */, 1 /* 0 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6148 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6148 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6148 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6148 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6148 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6157 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6157 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6157 /* fcvt.w.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6166 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6166 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6166 /* fcvt.w.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6175 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6175 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6175 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6175 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6175 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6185 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6185 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6185 /* fcvt.wu.h */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6195 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6195 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6195 /* fcvt.wu.s */, 2 /* 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6205 /* fcvtmod.w.d */, 4 /* 2 */, MCK_RTZArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 6217 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6217 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6217 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6217 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6217 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6224 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6224 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6224 /* fdiv.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6231 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6231 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6231 /* fdiv.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6238 /* fence */, 3 /* 0, 1 */, MCK_FenceArg, AMFBS_None },
  { 6262 /* feq.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6262 /* feq.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6268 /* feq.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6274 /* feq.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6280 /* fge.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6280 /* fge.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6286 /* fge.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6292 /* fge.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6319 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6319 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6325 /* fgt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6331 /* fgt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6358 /* fld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 6362 /* fle.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6362 /* fle.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6368 /* fle.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6374 /* fle.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6401 /* flh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZfhmin },
  { 6405 /* fli.d */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtD },
  { 6411 /* fli.h */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh },
  { 6417 /* fli.s */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa },
  { 6423 /* flt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6423 /* flt.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6429 /* flt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6435 /* flt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6462 /* flw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 6466 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6466 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6466 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6466 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6466 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6474 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6474 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6474 /* fmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6482 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6482 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6482 /* fmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6490 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6490 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6497 /* fmax.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6504 /* fmax.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6535 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6535 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6542 /* fmin.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6549 /* fmin.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6580 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6580 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6580 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6580 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6580 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6588 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6588 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6588 /* fmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6596 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6596 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6596 /* fmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6604 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6604 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6604 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6604 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6604 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6611 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6611 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6611 /* fmul.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6618 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6618 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6618 /* fmul.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6639 /* fmv.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6709 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6709 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6716 /* fneg.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6723 /* fneg.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6730 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6730 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6730 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6730 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6730 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6739 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6739 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6739 /* fnmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6748 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6748 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6748 /* fnmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6757 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6757 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6757 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6757 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6757 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6766 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6766 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6766 /* fnmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6775 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6775 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6775 /* fnmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6798 /* fround.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 6807 /* fround.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 6816 /* fround.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 6825 /* froundnx.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 6836 /* froundnx.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 6847 /* froundnx.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 6874 /* fsd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 6895 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6895 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6903 /* fsgnj.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6911 /* fsgnj.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6919 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6919 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6928 /* fsgnjn.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6937 /* fsgnjn.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6946 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6946 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6955 /* fsgnjx.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6964 /* fsgnjx.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 6973 /* fsh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZfhmin },
  { 6977 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6977 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6977 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6977 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6977 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6985 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6985 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6985 /* fsqrt.h */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 6993 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6993 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6993 /* fsqrt.s */, 3 /* 0, 1 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 7017 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7017 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7017 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7017 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7017 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7024 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7024 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7024 /* fsub.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZhinx },
  { 7031 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7031 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7031 /* fsub.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR, AMFBS_HasStdExtZfinx },
  { 7038 /* fsw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 7090 /* hlv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7096 /* hlv.bu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7103 /* hlv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 7109 /* hlv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7115 /* hlv.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7122 /* hlv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7128 /* hlv.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 7135 /* hlvx.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7143 /* hlvx.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7151 /* hsv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7157 /* hsv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 7163 /* hsv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7169 /* hsv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 7175 /* j */, 1 /* 0 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 7177 /* jal */, 1 /* 0 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 7177 /* jal */, 2 /* 1 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 7181 /* jalr */, 32 /* 5 */, MCK_TLSDESCCallSymbol, AMFBS_None },
  { 7189 /* jump */, 1 /* 0 */, MCK_PseudoJumpSymbol, AMFBS_None },
  { 7194 /* la */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7197 /* la.tls.gd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7207 /* la.tls.ie */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7217 /* la.tlsdesc */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7228 /* lb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7231 /* lbu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7235 /* ld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 7238 /* lga */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7242 /* lh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7245 /* lhu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7252 /* lla */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7261 /* lr.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 7266 /* lr.d.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 7274 /* lr.d.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 7284 /* lr.d.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 7292 /* lr.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 7297 /* lr.w.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 7305 /* lr.w.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 7315 /* lr.w.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 7327 /* lw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7330 /* lwu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 7969 /* sb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 7972 /* sc.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 7977 /* sc.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 7985 /* sc.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 7995 /* sc.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA_IsRV64 },
  { 8003 /* sc.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 8008 /* sc.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 8016 /* sc.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 8026 /* sc.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtA },
  { 8034 /* sd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 8355 /* sf.vfnrclip.x.f.qf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXSfvfnrclipxfqf },
  { 8374 /* sf.vfnrclip.xu.f.qf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXSfvfnrclipxfqf },
  { 8605 /* sh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8957 /* ssamoswap.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 8969 /* ssamoswap.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 8984 /* ssamoswap.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 9001 /* ssamoswap.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 9016 /* ssamoswap.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 9028 /* ssamoswap.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 9043 /* ssamoswap.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 9060 /* ssamoswap.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 9106 /* sw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 9109 /* tail */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 10097 /* th.vmaqa.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 10109 /* th.vmaqa.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 10121 /* th.vmaqasu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 10135 /* th.vmaqasu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 10149 /* th.vmaqau.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 10162 /* th.vmaqau.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 10175 /* th.vmaqaus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 10201 /* vaadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10210 /* vaadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10219 /* vaaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10229 /* vaaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10266 /* vadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10274 /* vadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10282 /* vadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10401 /* vand.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10409 /* vand.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10417 /* vand.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10425 /* vandn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 10434 /* vandn.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 10443 /* vasub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10452 /* vasub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10461 /* vasubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10471 /* vasubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10481 /* vbrev.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 10489 /* vbrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 10498 /* vclmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 10508 /* vclmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 10518 /* vclmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 10529 /* vclmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbc },
  { 10540 /* vclz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 10560 /* vcpop.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10568 /* vcpop.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 10576 /* vctz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 10583 /* vdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10591 /* vdiv.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10599 /* vdivu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10608 /* vdivu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10617 /* vfabs.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10625 /* vfadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10634 /* vfadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10643 /* vfclass.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10653 /* vfcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10665 /* vfcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10678 /* vfcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10694 /* vfcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10711 /* vfcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10723 /* vfcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10736 /* vfdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10745 /* vfdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10754 /* vfirst.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 10763 /* vfmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10773 /* vfmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10783 /* vfmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10793 /* vfmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10803 /* vfmax.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10812 /* vfmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10833 /* vfmin.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10842 /* vfmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10851 /* vfmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10861 /* vfmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10871 /* vfmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10881 /* vfmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10891 /* vfmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10900 /* vfmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10936 /* vfncvt.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10949 /* vfncvt.f.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10962 /* vfncvt.f.xu.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10976 /* vfncvt.rod.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 10993 /* vfncvt.rtz.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11010 /* vfncvt.rtz.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11028 /* vfncvt.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11041 /* vfncvt.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11055 /* vfncvtbf16.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 11072 /* vfneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11080 /* vfnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11091 /* vfnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11102 /* vfnmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11113 /* vfnmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11124 /* vfnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11135 /* vfnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11146 /* vfnmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11157 /* vfnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11168 /* vfrdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11178 /* vfrec7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11187 /* vfredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11199 /* vfredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11211 /* vfredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11224 /* vfredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11236 /* vfredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11249 /* vfrsqrt7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11260 /* vfrsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11270 /* vfsgnj.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11280 /* vfsgnj.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11290 /* vfsgnjn.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11301 /* vfsgnjn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11312 /* vfsgnjx.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11323 /* vfsgnjx.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11334 /* vfslide1down.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11350 /* vfslide1up.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11364 /* vfsqrt.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11373 /* vfsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11382 /* vfsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11391 /* vfwadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11401 /* vfwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11411 /* vfwadd.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11421 /* vfwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11431 /* vfwcvt.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11444 /* vfwcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11457 /* vfwcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11471 /* vfwcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11488 /* vfwcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11506 /* vfwcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11519 /* vfwcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11533 /* vfwcvtbf16.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 11550 /* vfwmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11561 /* vfwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11572 /* vfwmaccbf16.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 11587 /* vfwmaccbf16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 11602 /* vfwmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11613 /* vfwmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11624 /* vfwmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11634 /* vfwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11644 /* vfwnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11656 /* vfwnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11668 /* vfwnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11680 /* vfwnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11692 /* vfwredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11706 /* vfwredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11719 /* vfwredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11733 /* vfwsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11743 /* vfwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11753 /* vfwsub.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11763 /* vfwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 11791 /* vid.v */, 2 /* 1 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11797 /* viota.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11812 /* vl1re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11822 /* vl1re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11832 /* vl1re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 11842 /* vl1re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11858 /* vl2re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11868 /* vl2re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11878 /* vl2re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 11888 /* vl2re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11904 /* vl4re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11914 /* vl4re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11924 /* vl4re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 11934 /* vl4re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11950 /* vl8re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11960 /* vl8re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11970 /* vl8re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 11980 /* vl8re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 11996 /* vle16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 11996 /* vle16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12004 /* vle16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12004 /* vle16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12014 /* vle32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12014 /* vle32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12022 /* vle32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12022 /* vle32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12032 /* vle64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12032 /* vle64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12040 /* vle64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12040 /* vle64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12050 /* vle8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12050 /* vle8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12057 /* vle8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12057 /* vle8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12066 /* vlm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12072 /* vloxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12072 /* vloxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12083 /* vloxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12083 /* vloxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12094 /* vloxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 12094 /* vloxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 12105 /* vloxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12105 /* vloxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12115 /* vloxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12115 /* vloxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12130 /* vloxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12130 /* vloxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12145 /* vloxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12145 /* vloxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12160 /* vloxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12160 /* vloxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12174 /* vloxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12174 /* vloxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12189 /* vloxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12189 /* vloxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12204 /* vloxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12204 /* vloxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12219 /* vloxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12219 /* vloxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12233 /* vloxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12233 /* vloxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12248 /* vloxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12248 /* vloxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12263 /* vloxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12263 /* vloxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12278 /* vloxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12278 /* vloxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12292 /* vloxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12292 /* vloxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12307 /* vloxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12307 /* vloxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12322 /* vloxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12322 /* vloxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12337 /* vloxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12337 /* vloxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12351 /* vloxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12351 /* vloxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12366 /* vloxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12366 /* vloxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12381 /* vloxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12381 /* vloxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12396 /* vloxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12396 /* vloxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12410 /* vloxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12410 /* vloxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12425 /* vloxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12425 /* vloxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12440 /* vloxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12440 /* vloxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12455 /* vloxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12455 /* vloxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12469 /* vloxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12469 /* vloxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12484 /* vloxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12484 /* vloxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12499 /* vloxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12499 /* vloxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 12514 /* vloxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12514 /* vloxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12528 /* vlse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12528 /* vlse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12537 /* vlse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12537 /* vlse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12546 /* vlse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12546 /* vlse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12555 /* vlse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12555 /* vlse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12563 /* vlseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12563 /* vlseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12575 /* vlseg2e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12575 /* vlseg2e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12589 /* vlseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12589 /* vlseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12601 /* vlseg2e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12601 /* vlseg2e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12615 /* vlseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12615 /* vlseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12627 /* vlseg2e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12627 /* vlseg2e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12641 /* vlseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12641 /* vlseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12652 /* vlseg2e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12652 /* vlseg2e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12665 /* vlseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12665 /* vlseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12677 /* vlseg3e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12677 /* vlseg3e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12691 /* vlseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12691 /* vlseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12703 /* vlseg3e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12703 /* vlseg3e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12717 /* vlseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12717 /* vlseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12729 /* vlseg3e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12729 /* vlseg3e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12743 /* vlseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12743 /* vlseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12754 /* vlseg3e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12754 /* vlseg3e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12767 /* vlseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12767 /* vlseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12779 /* vlseg4e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12779 /* vlseg4e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12793 /* vlseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12793 /* vlseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12805 /* vlseg4e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12805 /* vlseg4e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12819 /* vlseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12819 /* vlseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12831 /* vlseg4e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12831 /* vlseg4e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12845 /* vlseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12845 /* vlseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12856 /* vlseg4e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12856 /* vlseg4e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12869 /* vlseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12869 /* vlseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12881 /* vlseg5e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12881 /* vlseg5e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12895 /* vlseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12895 /* vlseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12907 /* vlseg5e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12907 /* vlseg5e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12921 /* vlseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12921 /* vlseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12933 /* vlseg5e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 12933 /* vlseg5e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 12947 /* vlseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12947 /* vlseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12958 /* vlseg5e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12958 /* vlseg5e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12971 /* vlseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12971 /* vlseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12983 /* vlseg6e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12983 /* vlseg6e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 12997 /* vlseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12997 /* vlseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13009 /* vlseg6e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13009 /* vlseg6e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13023 /* vlseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13023 /* vlseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13035 /* vlseg6e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13035 /* vlseg6e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13049 /* vlseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13049 /* vlseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13060 /* vlseg6e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13060 /* vlseg6e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13073 /* vlseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13073 /* vlseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13085 /* vlseg7e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13085 /* vlseg7e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13099 /* vlseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13099 /* vlseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13111 /* vlseg7e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13111 /* vlseg7e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13125 /* vlseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13125 /* vlseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13137 /* vlseg7e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13137 /* vlseg7e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13151 /* vlseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13151 /* vlseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13162 /* vlseg7e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13162 /* vlseg7e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13175 /* vlseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13175 /* vlseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13187 /* vlseg8e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13187 /* vlseg8e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13201 /* vlseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13201 /* vlseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13213 /* vlseg8e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13213 /* vlseg8e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13227 /* vlseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13227 /* vlseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13239 /* vlseg8e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13239 /* vlseg8e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13253 /* vlseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13253 /* vlseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13264 /* vlseg8e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13264 /* vlseg8e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13277 /* vlsseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13277 /* vlsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13290 /* vlsseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13290 /* vlsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13303 /* vlsseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13303 /* vlsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13316 /* vlsseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13316 /* vlsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13328 /* vlsseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13328 /* vlsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13341 /* vlsseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13341 /* vlsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13354 /* vlsseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13354 /* vlsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13367 /* vlsseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13367 /* vlsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13379 /* vlsseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13379 /* vlsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13392 /* vlsseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13392 /* vlsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13405 /* vlsseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13405 /* vlsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13418 /* vlsseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13418 /* vlsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13430 /* vlsseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13430 /* vlsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13443 /* vlsseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13443 /* vlsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13456 /* vlsseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13456 /* vlsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13469 /* vlsseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13469 /* vlsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13481 /* vlsseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13481 /* vlsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13494 /* vlsseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13494 /* vlsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13507 /* vlsseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13507 /* vlsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13520 /* vlsseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13520 /* vlsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13532 /* vlsseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13532 /* vlsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13545 /* vlsseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13545 /* vlsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13558 /* vlsseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13558 /* vlsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13571 /* vlsseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13571 /* vlsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13583 /* vlsseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13583 /* vlsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13596 /* vlsseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13596 /* vlsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13609 /* vlsseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 13609 /* vlsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13622 /* vlsseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13622 /* vlsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13634 /* vluxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13634 /* vluxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13645 /* vluxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13645 /* vluxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13656 /* vluxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 13656 /* vluxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 13667 /* vluxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13667 /* vluxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13677 /* vluxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13677 /* vluxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13692 /* vluxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13692 /* vluxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13707 /* vluxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13707 /* vluxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13722 /* vluxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13722 /* vluxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13736 /* vluxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13736 /* vluxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13751 /* vluxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13751 /* vluxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13766 /* vluxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13766 /* vluxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13781 /* vluxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13781 /* vluxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13795 /* vluxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13795 /* vluxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13810 /* vluxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13810 /* vluxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13825 /* vluxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13825 /* vluxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13840 /* vluxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13840 /* vluxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13854 /* vluxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13854 /* vluxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13869 /* vluxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13869 /* vluxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13884 /* vluxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13884 /* vluxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13899 /* vluxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13899 /* vluxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13913 /* vluxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13913 /* vluxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13928 /* vluxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13928 /* vluxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13943 /* vluxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13943 /* vluxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 13958 /* vluxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13958 /* vluxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13972 /* vluxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13972 /* vluxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13987 /* vluxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13987 /* vluxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14002 /* vluxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14002 /* vluxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14017 /* vluxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14017 /* vluxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14031 /* vluxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14031 /* vluxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14046 /* vluxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14046 /* vluxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14061 /* vluxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14061 /* vluxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14076 /* vluxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14076 /* vluxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14090 /* vmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14099 /* vmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14165 /* vmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14174 /* vmadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14214 /* vmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14222 /* vmax.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14230 /* vmaxu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14239 /* vmaxu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14289 /* vmfeq.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14298 /* vmfeq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14307 /* vmfge.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14316 /* vmfge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14325 /* vmfgt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14334 /* vmfgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14343 /* vmfle.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14352 /* vmfle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14361 /* vmflt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14370 /* vmflt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14379 /* vmfne.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14388 /* vmfne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 14397 /* vmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14405 /* vmin.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14413 /* vminu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14422 /* vminu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14531 /* vmsbf.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14539 /* vmseq.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14548 /* vmseq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14557 /* vmseq.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14574 /* vmsge.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14583 /* vmsge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14592 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14592 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14601 /* vmsgeu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14611 /* vmsgeu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14621 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14621 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14631 /* vmsgt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14640 /* vmsgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14649 /* vmsgt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14658 /* vmsgtu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14668 /* vmsgtu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14678 /* vmsgtu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14688 /* vmsif.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14696 /* vmsle.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14705 /* vmsle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14714 /* vmsle.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14723 /* vmsleu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14733 /* vmsleu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14743 /* vmsleu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14753 /* vmslt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14762 /* vmslt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14771 /* vmslt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14780 /* vmsltu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14790 /* vmsltu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14800 /* vmsltu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14810 /* vmsne.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14819 /* vmsne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14828 /* vmsne.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14837 /* vmsof.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14845 /* vmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14853 /* vmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14861 /* vmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14870 /* vmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14879 /* vmulhsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14890 /* vmulhsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14901 /* vmulhu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14911 /* vmulhu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15012 /* vnclip.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15022 /* vnclip.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15032 /* vnclip.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15042 /* vnclipu.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15053 /* vnclipu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15064 /* vnclipu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15075 /* vncvt.x.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15087 /* vneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15094 /* vnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15104 /* vnmsac.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15114 /* vnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15124 /* vnmsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15134 /* vnot.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15141 /* vnsra.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15150 /* vnsra.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15159 /* vnsra.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15168 /* vnsrl.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15177 /* vnsrl.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15186 /* vnsrl.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15195 /* vor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15202 /* vor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15209 /* vor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15216 /* vpopc.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15224 /* vredand.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15235 /* vredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15246 /* vredmaxu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15258 /* vredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15269 /* vredminu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15281 /* vredor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15291 /* vredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15302 /* vredxor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15313 /* vrem.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15321 /* vrem.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15329 /* vremu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15338 /* vremu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15347 /* vrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 15355 /* vrgather.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15367 /* vrgather.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15379 /* vrgather.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15391 /* vrgatherei16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15407 /* vrol.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 15415 /* vrol.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 15423 /* vror.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 15431 /* vror.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 15439 /* vror.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 15447 /* vrsub.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15456 /* vrsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15465 /* vs1r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15472 /* vs2r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15479 /* vs4r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15486 /* vs8r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15493 /* vsadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15502 /* vsadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15511 /* vsadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15520 /* vsaddu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15530 /* vsaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15540 /* vsaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15575 /* vse16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15575 /* vse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15583 /* vse32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15583 /* vse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15591 /* vse64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15591 /* vse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15599 /* vse8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15599 /* vse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15606 /* vsetivli */, 4 /* 2 */, MCK_VTypeI10, AMFBS_HasVInstructions },
  { 15622 /* vsetvli */, 4 /* 2 */, MCK_VTypeI11, AMFBS_HasVInstructions },
  { 15630 /* vsext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15640 /* vsext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15650 /* vsext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15693 /* vslide1down.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15708 /* vslide1up.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15721 /* vslidedown.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15735 /* vslidedown.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15749 /* vslideup.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15761 /* vslideup.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15773 /* vsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15781 /* vsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15789 /* vsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15797 /* vsm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15849 /* vsmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15858 /* vsmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15867 /* vsoxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15867 /* vsoxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15878 /* vsoxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15878 /* vsoxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15889 /* vsoxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 15889 /* vsoxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 15900 /* vsoxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15900 /* vsoxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15910 /* vsoxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15910 /* vsoxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15925 /* vsoxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15925 /* vsoxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15940 /* vsoxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15940 /* vsoxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15955 /* vsoxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15955 /* vsoxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15969 /* vsoxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15969 /* vsoxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15984 /* vsoxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15984 /* vsoxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15999 /* vsoxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15999 /* vsoxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16014 /* vsoxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16014 /* vsoxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16028 /* vsoxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16028 /* vsoxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16043 /* vsoxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16043 /* vsoxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16058 /* vsoxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16058 /* vsoxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16073 /* vsoxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16073 /* vsoxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16087 /* vsoxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16087 /* vsoxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16102 /* vsoxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16102 /* vsoxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16117 /* vsoxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16117 /* vsoxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16132 /* vsoxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16132 /* vsoxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16146 /* vsoxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16146 /* vsoxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16161 /* vsoxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16161 /* vsoxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16176 /* vsoxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16176 /* vsoxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16191 /* vsoxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16191 /* vsoxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16205 /* vsoxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16205 /* vsoxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16220 /* vsoxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16220 /* vsoxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16235 /* vsoxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16235 /* vsoxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16250 /* vsoxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16250 /* vsoxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16264 /* vsoxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16264 /* vsoxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16279 /* vsoxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16279 /* vsoxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16294 /* vsoxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16294 /* vsoxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16309 /* vsoxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16309 /* vsoxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16323 /* vsra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16331 /* vsra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16339 /* vsra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16347 /* vsrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16355 /* vsrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16363 /* vsrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16371 /* vsse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16371 /* vsse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16380 /* vsse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16380 /* vsse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16389 /* vsse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16389 /* vsse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16398 /* vsse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16398 /* vsse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16406 /* vsseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16406 /* vsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16418 /* vsseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16418 /* vsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16430 /* vsseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16430 /* vsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16442 /* vsseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16442 /* vsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16453 /* vsseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16453 /* vsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16465 /* vsseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16465 /* vsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16477 /* vsseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16477 /* vsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16489 /* vsseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16489 /* vsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16500 /* vsseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16500 /* vsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16512 /* vsseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16512 /* vsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16524 /* vsseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16524 /* vsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16536 /* vsseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16536 /* vsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16547 /* vsseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16547 /* vsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16559 /* vsseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16559 /* vsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16571 /* vsseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16571 /* vsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16583 /* vsseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16583 /* vsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16594 /* vsseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16594 /* vsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16606 /* vsseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16606 /* vsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16618 /* vsseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16618 /* vsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16630 /* vsseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16630 /* vsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16641 /* vsseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16641 /* vsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16653 /* vsseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16653 /* vsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16665 /* vsseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16665 /* vsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16677 /* vsseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16677 /* vsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16688 /* vsseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16688 /* vsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16700 /* vsseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16700 /* vsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16712 /* vsseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16712 /* vsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16724 /* vsseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16724 /* vsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16735 /* vssra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16744 /* vssra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16753 /* vssra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16762 /* vssrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16771 /* vssrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16780 /* vssrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16789 /* vssseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16789 /* vssseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16802 /* vssseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16802 /* vssseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16815 /* vssseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16815 /* vssseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16828 /* vssseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16828 /* vssseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16840 /* vssseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16840 /* vssseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16853 /* vssseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16853 /* vssseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16866 /* vssseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16866 /* vssseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16879 /* vssseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16879 /* vssseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16891 /* vssseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16891 /* vssseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16904 /* vssseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16904 /* vssseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16917 /* vssseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16917 /* vssseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16930 /* vssseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16930 /* vssseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16942 /* vssseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16942 /* vssseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16955 /* vssseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16955 /* vssseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16968 /* vssseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 16968 /* vssseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 16981 /* vssseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16981 /* vssseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16993 /* vssseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16993 /* vssseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17006 /* vssseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17006 /* vssseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17019 /* vssseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17019 /* vssseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17032 /* vssseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17032 /* vssseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17044 /* vssseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17044 /* vssseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17057 /* vssseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17057 /* vssseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17070 /* vssseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17070 /* vssseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17083 /* vssseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17083 /* vssseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17095 /* vssseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17095 /* vssseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17108 /* vssseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17108 /* vssseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17121 /* vssseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17121 /* vssseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17134 /* vssseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17134 /* vssseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17146 /* vssub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17155 /* vssub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17164 /* vssubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17174 /* vssubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17184 /* vsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17192 /* vsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17200 /* vsuxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17200 /* vsuxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17211 /* vsuxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17211 /* vsuxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17222 /* vsuxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 17222 /* vsuxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 17233 /* vsuxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17233 /* vsuxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17243 /* vsuxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17243 /* vsuxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17258 /* vsuxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17258 /* vsuxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17273 /* vsuxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17273 /* vsuxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17288 /* vsuxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17288 /* vsuxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17302 /* vsuxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17302 /* vsuxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17317 /* vsuxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17317 /* vsuxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17332 /* vsuxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17332 /* vsuxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17347 /* vsuxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17347 /* vsuxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17361 /* vsuxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17361 /* vsuxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17376 /* vsuxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17376 /* vsuxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17391 /* vsuxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17391 /* vsuxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17406 /* vsuxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17406 /* vsuxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17420 /* vsuxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17420 /* vsuxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17435 /* vsuxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17435 /* vsuxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17450 /* vsuxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17450 /* vsuxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17465 /* vsuxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17465 /* vsuxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17479 /* vsuxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17479 /* vsuxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17494 /* vsuxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17494 /* vsuxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17509 /* vsuxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17509 /* vsuxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17524 /* vsuxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17524 /* vsuxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17538 /* vsuxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17538 /* vsuxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17553 /* vsuxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17553 /* vsuxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17568 /* vsuxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17568 /* vsuxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17583 /* vsuxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17583 /* vsuxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17597 /* vsuxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17597 /* vsuxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17612 /* vsuxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17612 /* vsuxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17627 /* vsuxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17627 /* vsuxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 17642 /* vsuxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17642 /* vsuxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17675 /* vwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17684 /* vwadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17693 /* vwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17702 /* vwadd.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17711 /* vwaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17721 /* vwaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17731 /* vwaddu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17741 /* vwaddu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17751 /* vwcvt.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17763 /* vwcvtu.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17776 /* vwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17786 /* vwmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17796 /* vwmaccsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17808 /* vwmaccsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17820 /* vwmaccu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17831 /* vwmaccu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17842 /* vwmaccus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17854 /* vwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17863 /* vwmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17872 /* vwmulsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17883 /* vwmulsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17894 /* vwmulu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17904 /* vwmulu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17914 /* vwredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17926 /* vwredsumu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17939 /* vwsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 17948 /* vwsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 17957 /* vwsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 17966 /* vwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17975 /* vwsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17984 /* vwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17993 /* vwsub.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18002 /* vwsubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18012 /* vwsubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18022 /* vwsubu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18032 /* vwsubu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18042 /* vxor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18050 /* vxor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18058 /* vxor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18066 /* vzext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18076 /* vzext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18086 /* vzext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
};

ParseStatus RISCVAsmParser::
tryCustomParseOperand(OperandVector &Operands,
                      unsigned MCK) {

  switch(MCK) {
  case MCK_BareSymbol:
    return parseBareSymbol(Operands);
  case MCK_CSRSystemRegister:
    return parseCSRSystemRegister(Operands);
  case MCK_RegReg:
    return parseRegReg(Operands);
  case MCK_CallSymbol:
    return parseCallSymbol(Operands);
  case MCK_FRMArg:
    return parseFRMArg(Operands);
  case MCK_FRMArgLegacy:
    return parseFRMArg(Operands);
  case MCK_FenceArg:
    return parseFenceArg(Operands);
  case MCK_GPRAsFPR:
    return parseGPRAsFPR(Operands);
  case MCK_GPRF64AsFPR:
    return parseGPRAsFPR(Operands);
  case MCK_GPRPairAsFPR:
    return parseGPRAsFPR(Operands);
  case MCK_GPRPairRV32:
    return parseGPRPair<false>(Operands);
  case MCK_GPRPairRV64:
    return parseGPRPair<true>(Operands);
  case MCK_InsnCDirectiveOpcode:
    return parseInsnCDirectiveOpcode(Operands);
  case MCK_InsnDirectiveOpcode:
    return parseInsnDirectiveOpcode(Operands);
  case MCK_LoadFPImm:
    return parseFPImm(Operands);
  case MCK_PseudoJumpSymbol:
    return parsePseudoJumpSymbol(Operands);
  case MCK_RTZArg:
    return parseFRMArg(Operands);
  case MCK_Rlist:
    return parseReglist(Operands);
  case MCK_SImm21Lsb0JAL:
    return parseJALOffset(Operands);
  case MCK_Spimm:
    return parseZcmpSpimm(Operands);
  case MCK_TLSDESCCallSymbol:
    return parseOperandWithModifier(Operands);
  case MCK_TPRelAddSymbol:
    return parseOperandWithModifier(Operands);
  case MCK_RVVMaskRegOpOperand:
    return parseMaskReg(Operands);
  case MCK_ZeroOffsetMemOpOperand:
    return parseZeroOffsetMemOp(Operands);
  case MCK_VTypeI10:
    return parseVTypeI(Operands);
  case MCK_VTypeI11:
    return parseVTypeI(Operands);
  default:
    return ParseStatus::NoMatch;
  }
  return ParseStatus::NoMatch;
}

ParseStatus RISCVAsmParser::
MatchOperandParserImpl(OperandVector &Operands,
                       StringRef Mnemonic,
                       bool ParseForAllFeatures) {
  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the next operand index.
  unsigned NextOpNum = Operands.size() - 1;
  // Search the table.
  auto MnemonicRange =
    std::equal_range(std::begin(OperandMatchTable), std::end(OperandMatchTable),
                     Mnemonic, LessOpcodeOperand());

  if (MnemonicRange.first == MnemonicRange.second)
    return ParseStatus::NoMatch;

  for (const OperandMatchEntry *it = MnemonicRange.first,
       *ie = MnemonicRange.second; it != ie; ++it) {
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());

    // check if the available features match
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    if (!ParseForAllFeatures && (AvailableFeatures & RequiredFeatures) != RequiredFeatures)
      continue;

    // check if the operand in question has a custom parser.
    if (!(it->OperandMask & (1 << NextOpNum)))
      continue;

    // call custom parse method to handle the operand
    ParseStatus Result = tryCustomParseOperand(Operands, it->Class);
    if (!Result.isNoMatch())
      return Result;
  }

  // Okay, we had no match.
  return ParseStatus::NoMatch;
}

#endif // GET_MATCHER_IMPLEMENTATION


#ifdef GET_MNEMONIC_SPELL_CHECKER
#undef GET_MNEMONIC_SPELL_CHECKER

static std::string RISCVMnemonicSpellCheck(StringRef S, const FeatureBitset &FBS, unsigned VariantID) {
  const unsigned MaxEditDist = 2;
  std::vector<StringRef> Candidates;
  StringRef Prev = "";

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  for (auto I = Start; I < End; I++) {
    // Ignore unsupported instructions.
    const FeatureBitset &RequiredFeatures = FeatureBitsets[I->RequiredFeaturesIdx];
    if ((FBS & RequiredFeatures) != RequiredFeatures)
      continue;

    StringRef T = I->getMnemonic();
    // Avoid recomputing the edit distance for the same string.
    if (T.equals(Prev))
      continue;

    Prev = T;
    unsigned Dist = S.edit_distance(T, false, MaxEditDist);
    if (Dist <= MaxEditDist)
      Candidates.push_back(T);
  }

  if (Candidates.empty())
    return "";

  std::string Res = ", did you mean: ";
  unsigned i = 0;
  for (; i < Candidates.size() - 1; i++)
    Res += Candidates[i].str() + ", ";
  return Res + Candidates[i].str() + "?";
}

#endif // GET_MNEMONIC_SPELL_CHECKER


#ifdef GET_MNEMONIC_CHECKER
#undef GET_MNEMONIC_CHECKER

static bool RISCVCheckMnemonic(StringRef Mnemonic,
                                const FeatureBitset &AvailableFeatures,
                                unsigned VariantID) {
  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  if (MnemonicRange.first == MnemonicRange.second)
    return false;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures =
      FeatureBitsets[it->RequiredFeaturesIdx];
    if ((AvailableFeatures & RequiredFeatures) == RequiredFeatures)
      return true;
  }
  return false;
}

#endif // GET_MNEMONIC_CHECKER

