/* Application.c generated by valac 0.56.18, the Vala compiler
 * generated from Application.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <granite.h>
#include <glib-object.h>
#include <handy.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <gee.h>
#include <glib/gstdio.h>

#define MINDER_INTERFACE_SCHEMA "org.gnome.desktop.interface"
#define GETTEXT_PACKAGE "com.github.phase1geo.minder"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MINDER (minder_get_type ())
#define MINDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINDER, Minder))
#define MINDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINDER, MinderClass))
#define IS_MINDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINDER))
#define IS_MINDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINDER))
#define MINDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINDER, MinderClass))

typedef struct _Minder Minder;
typedef struct _MinderClass MinderClass;
typedef struct _MinderPrivate MinderPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	MINDER_0_PROPERTY,
	MINDER_NUM_PROPERTIES
};
static GParamSpec* minder_properties[MINDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EXPORTS (exports_get_type ())
#define EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTS, Exports))
#define EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTS, ExportsClass))
#define IS_EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTS))
#define IS_EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTS))
#define EXPORTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTS, ExportsClass))

typedef struct _Exports Exports;
typedef struct _ExportsClass ExportsClass;

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
#define _export_unref0(var) ((var == NULL) ? NULL : (var = (export_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _exports_unref0(var) ((var == NULL) ? NULL : (var = (exports_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

struct _Minder {
	GraniteApplication parent_instance;
	MinderPrivate * priv;
};

struct _MinderClass {
	GraniteApplicationClass parent_class;
};

struct _MinderPrivate {
	MainWindow* appwin;
	GSettings* iface_settings;
	GSettings* touch_settings;
};

struct _Block1Data {
	int _ref_count_;
	Minder* self;
	Export* export;
};

static gint Minder_private_offset;
static gpointer minder_parent_class = NULL;
VALA_EXTERN GSettings* minder_settings;
GSettings* minder_settings = NULL;
VALA_EXTERN gchar* minder_version;
gchar* minder_version = NULL;

VALA_EXTERN GType minder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Minder, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN Minder* minder_new (void);
VALA_EXTERN Minder* minder_construct (GType object_type);
static void minder_start_application (Minder* self);
static void _minder_start_application_g_application_startup (GApplication* _sender,
                                                      gpointer self);
static gint minder_handle_command_line (Minder* self,
                                 GApplicationCommandLine* cl);
static gint _minder_handle_command_line_g_application_command_line (GApplication* _sender,
                                                             GApplicationCommandLine* command_line,
                                                             gpointer self);
VALA_EXTERN MainWindow* main_window_new (GtkApplication* app,
                             GSettings* settings);
VALA_EXTERN MainWindow* main_window_construct (GType object_type,
                                   GtkApplication* app,
                                   GSettings* settings);
VALA_EXTERN void main_window_load_tab_state (MainWindow* self);
static gboolean __lambda155_ (Minder* self);
static gboolean ___lambda155__gtk_widget_configure_event (GtkWidget* _sender,
                                                   GdkEventConfigure* event,
                                                   gpointer self);
static void __lambda156_ (Minder* self);
static void ___lambda156__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void ____lambda157_ (Minder* self);
static gboolean __lambda158_ (Minder* self);
VALA_EXTERN void main_window_update_node_sizes (MainWindow* self);
static gboolean ___lambda158__gsource_func (gpointer self);
static void _____lambda157__g_settings_changed (GSettings* _sender,
                                         const gchar* key,
                                         gpointer self);
static gint minder_end_cl (Minder* self,
                    GApplicationCommandLine* cl,
                    gint status);
VALA_EXTERN gpointer exports_ref (gpointer instance);
VALA_EXTERN void exports_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_exports (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_exports (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_exports (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_exports (const GValue* value);
VALA_EXTERN GType exports_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exports, exports_unref)
VALA_EXTERN Exports* exports_new (gboolean save_settings);
VALA_EXTERN Exports* exports_construct (GType object_type,
                            gboolean save_settings);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN gint exports_length (Exports* self);
VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN Export* exports_index (Exports* self,
                       gint idx);
VALA_EXTERN gboolean export_get_importable (Export* self);
VALA_EXTERN const gchar* export_get_name (Export* self);
VALA_EXTERN gboolean export_get_exportable (Export* self);
VALA_EXTERN gboolean main_window_import_file (MainWindow* self,
                                  const gchar* fname,
                                  const gchar* export_name,
                                  gchar** new_fname);
static gboolean minder_export_as (Minder* self,
                           const gchar* format,
                           GeeHashMap* options,
                           const gchar* infile,
                           const gchar* outfile);
VALA_EXTERN void main_window_close_current_tab (MainWindow* self);
VALA_EXTERN void main_window_do_new_file (MainWindow* self);
VALA_EXTERN gboolean main_window_open_file (MainWindow* self,
                                const gchar* fname,
                                gboolean dir);
VALA_EXTERN Exports* main_window_get_exports (MainWindow* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ______lambda159_ (Block1Data* _data1_,
                           const gchar* key,
                           gint value);
VALA_EXTERN gboolean export_is_bool_setting (Export* self,
                                 const gchar* name);
VALA_EXTERN void export_set_bool (Export* self,
                      const gchar* name,
                      gboolean value);
VALA_EXTERN gboolean export_is_scale_setting (Export* self,
                                  const gchar* name);
VALA_EXTERN void export_set_scale (Export* self,
                       const gchar* name,
                       gint value);
static gboolean _______lambda159__gee_forall_map_func (gconstpointer k,
                                                gconstpointer v,
                                                gpointer self);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN DrawArea* main_window_create_da (MainWindow* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN Document* draw_area_get_doc (DrawArea* self);
VALA_EXTERN void document_load_filename (Document* self,
                             const gchar* fname,
                             gboolean saved);
VALA_EXTERN gboolean document_load (Document* self);
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
static gint minder_main (gchar** args,
                  gint args_length1);
static void minder_finalize (GObject * obj);
static GType minder_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
minder_get_instance_private (Minder* self)
{
	return G_STRUCT_MEMBER_P (self, Minder_private_offset);
}

static void
_minder_start_application_g_application_startup (GApplication* _sender,
                                                 gpointer self)
{
	minder_start_application ((Minder*) self);
}

static gint
_minder_handle_command_line_g_application_command_line (GApplication* _sender,
                                                        GApplicationCommandLine* command_line,
                                                        gpointer self)
{
	gint result;
	result = minder_handle_command_line ((Minder*) self, command_line);
	return result;
}

Minder*
minder_construct (GType object_type)
{
	Minder * self = NULL;
	self = (Minder*) g_object_new (object_type, "application-id", "com.github.phase1geo.minder", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _minder_start_application_g_application_startup, self, 0);
	g_signal_connect_object ((GApplication*) self, "command-line", (GCallback) _minder_handle_command_line_g_application_command_line, self, 0);
	return self;
}

Minder*
minder_new (void)
{
	return minder_construct (TYPE_MINDER);
}

static gboolean
__lambda155_ (Minder* self)
{
	gint root_x = 0;
	gint root_y = 0;
	gint size_w = 0;
	gint size_h = 0;
	MainWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	MainWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	gboolean result;
	_tmp0_ = self->priv->appwin;
	gtk_window_get_position ((GtkWindow*) _tmp0_, &_tmp1_, &_tmp2_);
	root_x = _tmp1_;
	root_y = _tmp2_;
	_tmp3_ = self->priv->appwin;
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
	size_w = _tmp4_;
	size_h = _tmp5_;
	_tmp6_ = minder_settings;
	g_settings_set_int (_tmp6_, "window-x", root_x);
	_tmp7_ = minder_settings;
	g_settings_set_int (_tmp7_, "window-y", root_y);
	_tmp8_ = minder_settings;
	g_settings_set_int (_tmp8_, "window-w", size_w);
	_tmp9_ = minder_settings;
	g_settings_set_int (_tmp9_, "window-h", size_h);
	result = FALSE;
	return result;
}

static gboolean
___lambda155__gtk_widget_configure_event (GtkWidget* _sender,
                                          GdkEventConfigure* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda155_ ((Minder*) self);
	return result;
}

static void
__lambda156_ (Minder* self)
{
	g_application_quit ((GApplication*) self);
}

static void
___lambda156__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda156_ ((Minder*) self);
}

static gboolean
__lambda158_ (Minder* self)
{
	MainWindow* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->appwin;
	main_window_update_node_sizes (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda158__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda158_ ((Minder*) self);
	return result;
}

static void
____lambda157_ (Minder* self)
{
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda158__gsource_func, g_object_ref (self), g_object_unref);
}

static void
_____lambda157__g_settings_changed (GSettings* _sender,
                                    const gchar* key,
                                    gpointer self)
{
	____lambda157_ ((Minder*) self);
}

static void
minder_start_application (Minder* self)
{
	GSettings* _tmp0_;
	GtkIconTheme* default_theme = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* _tmp2_;
	GSettings* _tmp3_;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
	MainWindow* _tmp7_;
	gchar** names = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint names_length1;
	gint _names_size_;
	GSettings* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("com.github.phase1geo.minder");
	_g_object_unref0 (minder_settings);
	minder_settings = _tmp0_;
	_tmp1_ = gtk_icon_theme_get_default ();
	default_theme = _tmp1_;
	_tmp2_ = default_theme;
	gtk_icon_theme_add_resource_path (_tmp2_, "/com/github/phase1geo/minder");
	_tmp3_ = minder_settings;
	_tmp4_ = main_window_new ((GtkApplication*) self, _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->appwin);
	self->priv->appwin = _tmp4_;
	_tmp5_ = self->priv->appwin;
	main_window_load_tab_state (_tmp5_);
	_tmp6_ = self->priv->appwin;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "configure-event", (GCallback) ___lambda155__gtk_widget_configure_event, self, 0);
	_tmp7_ = self->priv->appwin;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "destroy", (GCallback) ___lambda156__gtk_widget_destroy, self, 0);
	_tmp8_ = g_strdup ("font-name");
	_tmp9_ = g_strdup ("text-scaling-factor");
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	names = _tmp10_;
	names_length1 = 2;
	_names_size_ = names_length1;
	_tmp11_ = g_settings_new (MINDER_INTERFACE_SCHEMA);
	_g_object_unref0 (self->priv->iface_settings);
	self->priv->iface_settings = _tmp11_;
	_tmp12_ = names;
	_tmp12__length1 = names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp12_;
		name_collection_length1 = _tmp12__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp13_;
			gchar* name = NULL;
			_tmp13_ = g_strdup (name_collection[name_it]);
			name = _tmp13_;
			{
				GSettings* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = self->priv->iface_settings;
				_tmp15_ = name;
				_tmp16_ = g_strconcat ("changed::", _tmp15_, NULL);
				g_signal_connect_object (_tmp14_, _tmp16_, (GCallback) _____lambda157__g_settings_changed, self, 0);
				_g_free0 (_tmp16_);
				_g_free0 (name);
			}
		}
	}
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
}

static gint
minder_end_cl (Minder* self,
               GApplicationCommandLine* cl,
               gint status)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (cl != NULL, 0);
	if (!g_application_command_line_get_is_remote (cl)) {
		exit (status);
	} else {
		g_application_command_line_set_exit_status (cl, status);
		g_application_command_line_done (cl);
	}
	result = status;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gint
minder_handle_command_line (Minder* self,
                            GApplicationCommandLine* cl)
{
	gchar* open_file = NULL;
	gchar* cl_import = NULL;
	gchar* cl_export = NULL;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp1_;
	gint options_length1;
	gint _options_size_;
	gboolean transparent = FALSE;
	gint compression = 0;
	gint quality = 0;
	gboolean image_links = FALSE;
	Exports* exports = NULL;
	Exports* _tmp2_;
	GArray* import_list = NULL;
	GArray* _tmp3_;
	GArray* export_list = NULL;
	GArray* _tmp4_;
	gboolean show_version = FALSE;
	gboolean show_help = FALSE;
	gboolean new_file = FALSE;
	gchar* import_str = NULL;
	GArray* _tmp26_;
	gpointer* _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* export_str = NULL;
	GArray* _tmp32_;
	gpointer* _tmp33_;
	gint _tmp33__length1;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** args = NULL;
	gint _tmp38_ = 0;
	gchar** _tmp39_;
	gint args_length1;
	gint _args_size_;
	GOptionEntry* _tmp40_;
	gint _tmp40__length1;
	GOptionEntry _tmp41_ = {0};
	GOptionEntry* _tmp42_;
	gint _tmp42__length1;
	GOptionEntry _tmp43_ = {0};
	GOptionEntry* _tmp44_;
	gint _tmp44__length1;
	GOptionEntry _tmp45_ = {0};
	GOptionEntry* _tmp46_;
	gint _tmp46__length1;
	const gchar* _tmp47_;
	GOptionEntry _tmp48_ = {0};
	GOptionEntry* _tmp49_;
	gint _tmp49__length1;
	const gchar* _tmp50_;
	GOptionEntry _tmp51_ = {0};
	GOptionEntry* _tmp52_;
	gint _tmp52__length1;
	GOptionEntry _tmp53_ = {0};
	GOptionEntry* _tmp54_;
	gint _tmp54__length1;
	GOptionEntry _tmp55_ = {0};
	GOptionEntry* _tmp56_;
	gint _tmp56__length1;
	GOptionEntry _tmp57_ = {0};
	GOptionEntry* _tmp58_;
	gint _tmp58__length1;
	GOptionEntry _tmp59_ = {0};
	GOptionEntry* _tmp60_;
	gint _tmp60__length1;
	GOptionEntry _tmp61_ = {0};
	gchar** _tmp82_;
	gint _tmp82__length1;
	const gchar* _tmp86_;
	const gchar* _tmp98_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (cl != NULL, 0);
	open_file = NULL;
	cl_import = NULL;
	cl_export = NULL;
	_tmp0_ = g_option_context_new ("- Minder Options");
	context = _tmp0_;
	_tmp1_ = g_new0 (GOptionEntry, 10);
	options = _tmp1_;
	options_length1 = 10;
	_options_size_ = options_length1;
	transparent = FALSE;
	compression = 0;
	quality = 90;
	image_links = FALSE;
	_tmp2_ = exports_new (TRUE);
	exports = _tmp2_;
	_tmp3_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp3_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	import_list = _tmp3_;
	_tmp4_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp4_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	export_list = _tmp4_;
	show_version = FALSE;
	show_help = FALSE;
	new_file = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				Exports* _tmp7_;
				Export* export = NULL;
				Exports* _tmp8_;
				Export* _tmp9_;
				Export* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				Export* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = exports;
				if (!(i < exports_length (_tmp7_))) {
					break;
				}
				_tmp8_ = exports;
				_tmp9_ = exports_index (_tmp8_, i);
				export = _tmp9_;
				_tmp10_ = export;
				_tmp11_ = export_get_importable (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					GArray* _tmp13_;
					Export* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp13_ = import_list;
					_tmp14_ = export;
					_tmp15_ = export_get_name (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup (_tmp16_);
					g_array_append_val (_tmp13_, _tmp17_);
				}
				_tmp18_ = export;
				_tmp19_ = export_get_exportable (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_) {
					GArray* _tmp21_;
					Export* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp21_ = export_list;
					_tmp22_ = export;
					_tmp23_ = export_get_name (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strdup (_tmp24_);
					g_array_append_val (_tmp21_, _tmp25_);
				}
				_export_unref0 (export);
			}
		}
	}
	_tmp26_ = import_list;
	_tmp27_ = _tmp26_->data;
	_tmp27__length1 = _tmp26_->len;
	_tmp28_ = _vala_g_strjoinv (",", _tmp27_, (gint) _tmp27__length1);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup_printf (_ ("Import file from format (%s)"), _tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	import_str = _tmp31_;
	_tmp32_ = export_list;
	_tmp33_ = _tmp32_->data;
	_tmp33__length1 = _tmp32_->len;
	_tmp34_ = _vala_g_strjoinv (",", _tmp33_, (gint) _tmp33__length1);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strdup_printf (_ ("Export mindmap as format (%s)"), _tmp35_);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	export_str = _tmp37_;
	_tmp39_ = g_application_command_line_get_arguments (cl, &_tmp38_);
	args = _tmp39_;
	args_length1 = _tmp38_;
	_args_size_ = args_length1;
	_tmp40_ = options;
	_tmp40__length1 = options_length1;
	_tmp41_.long_name = "version";
	_tmp41_.short_name = (gchar) 0;
	_tmp41_.flags = (gint) 0;
	_tmp41_.arg = G_OPTION_ARG_NONE;
	_tmp41_.arg_data = &show_version;
	_tmp41_.description = _ ("Display version number");
	_tmp41_.arg_description = NULL;
	_tmp40_[0] = _tmp41_;
	_tmp42_ = options;
	_tmp42__length1 = options_length1;
	_tmp43_.long_name = "help";
	_tmp43_.short_name = (gchar) 0;
	_tmp43_.flags = (gint) 0;
	_tmp43_.arg = G_OPTION_ARG_NONE;
	_tmp43_.arg_data = &show_help;
	_tmp43_.description = _ ("Display help");
	_tmp43_.arg_description = NULL;
	_tmp42_[1] = _tmp43_;
	_tmp44_ = options;
	_tmp44__length1 = options_length1;
	_tmp45_.long_name = "new";
	_tmp45_.short_name = 'n';
	_tmp45_.flags = (gint) 0;
	_tmp45_.arg = G_OPTION_ARG_NONE;
	_tmp45_.arg_data = &new_file;
	_tmp45_.description = _ ("Starts Minder with a new file");
	_tmp45_.arg_description = NULL;
	_tmp44_[2] = _tmp45_;
	_tmp46_ = options;
	_tmp46__length1 = options_length1;
	_tmp47_ = import_str;
	_tmp48_.long_name = "import";
	_tmp48_.short_name = (gchar) 0;
	_tmp48_.flags = (gint) 0;
	_tmp48_.arg = G_OPTION_ARG_STRING;
	_tmp48_.arg_data = &cl_import;
	_tmp48_.description = _tmp47_;
	_tmp48_.arg_description = "FORMAT";
	_tmp46_[3] = _tmp48_;
	_tmp49_ = options;
	_tmp49__length1 = options_length1;
	_tmp50_ = export_str;
	_tmp51_.long_name = "export";
	_tmp51_.short_name = (gchar) 0;
	_tmp51_.flags = (gint) 0;
	_tmp51_.arg = G_OPTION_ARG_STRING;
	_tmp51_.arg_data = &cl_export;
	_tmp51_.description = _tmp50_;
	_tmp51_.arg_description = "FORMAT";
	_tmp49_[4] = _tmp51_;
	_tmp52_ = options;
	_tmp52__length1 = options_length1;
	_tmp53_.long_name = "png-transparent";
	_tmp53_.short_name = (gchar) 0;
	_tmp53_.flags = (gint) 0;
	_tmp53_.arg = G_OPTION_ARG_NONE;
	_tmp53_.arg_data = &transparent;
	_tmp53_.description = _ ("Enables a transparent background for PNG images.  Default is no transp" \
"arency.");
	_tmp53_.arg_description = NULL;
	_tmp52_[5] = _tmp53_;
	_tmp54_ = options;
	_tmp54__length1 = options_length1;
	_tmp55_.long_name = "png-compression";
	_tmp55_.short_name = (gchar) 0;
	_tmp55_.flags = (gint) 0;
	_tmp55_.arg = G_OPTION_ARG_INT;
	_tmp55_.arg_data = &compression;
	_tmp55_.description = _ ("PNG compression value (0-9). Default is 0.");
	_tmp55_.arg_description = "INT";
	_tmp54_[6] = _tmp55_;
	_tmp56_ = options;
	_tmp56__length1 = options_length1;
	_tmp57_.long_name = "jpeg-quality";
	_tmp57_.short_name = (gchar) 0;
	_tmp57_.flags = (gint) 0;
	_tmp57_.arg = G_OPTION_ARG_INT;
	_tmp57_.arg_data = &quality;
	_tmp57_.description = _ ("JPEG quality (0-100). Default is 90.");
	_tmp57_.arg_description = "INT";
	_tmp56_[7] = _tmp57_;
	_tmp58_ = options;
	_tmp58__length1 = options_length1;
	_tmp59_.long_name = "markdown-include-image-links";
	_tmp59_.short_name = (gchar) 0;
	_tmp59_.flags = (gint) 0;
	_tmp59_.arg = G_OPTION_ARG_NONE;
	_tmp59_.arg_data = &image_links;
	_tmp59_.description = _ ("Enables image links in exported Markdown");
	_tmp59_.arg_description = NULL;
	_tmp58_[8] = _tmp59_;
	_tmp60_ = options;
	_tmp60__length1 = options_length1;
	_tmp61_.long_name = NULL;
	_tmp60_[9] = _tmp61_;
	{
		GOptionContext* _tmp62_;
		GOptionContext* _tmp63_;
		GOptionEntry* _tmp64_;
		gint _tmp64__length1;
		GOptionContext* _tmp65_;
		_tmp62_ = context;
		g_option_context_set_help_enabled (_tmp62_, FALSE);
		_tmp63_ = context;
		_tmp64_ = options;
		_tmp64__length1 = options_length1;
		g_option_context_add_main_entries (_tmp63_, _tmp64_, NULL);
		_tmp65_ = context;
		g_option_context_parse_strv (_tmp65_, &args, &_inner_error0_);
		args_length1 = _vala_array_length (args);
		_args_size_ = args_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp66_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (export_str);
			_g_free0 (import_str);
			_g_array_unref0 (export_list);
			_g_array_unref0 (import_list);
			_exports_unref0 (exports);
			options = (g_free (options), NULL);
			_g_option_context_free0 (context);
			_g_free0 (cl_export);
			_g_free0 (cl_import);
			_g_free0 (open_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp66_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp67_;
		GError* _tmp68_;
		const gchar* _tmp69_;
		FILE* _tmp70_;
		gchar** _tmp71_;
		gint _tmp71__length1;
		const gchar* _tmp72_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp67_ = stdout;
		_tmp68_ = e;
		_tmp69_ = _tmp68_->message;
		fprintf (_tmp67_, _ ("ERROR: %s\n"), _tmp69_);
		_tmp70_ = stdout;
		_tmp71_ = args;
		_tmp71__length1 = args_length1;
		_tmp72_ = _tmp71_[0];
		fprintf (_tmp70_, _ ("Run '%s --help' to see valid options\n"), _tmp72_);
		result = minder_end_cl (self, cl, 1);
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (export_str);
		_g_free0 (import_str);
		_g_array_unref0 (export_list);
		_g_array_unref0 (import_list);
		_exports_unref0 (exports);
		options = (g_free (options), NULL);
		_g_option_context_free0 (context);
		_g_free0 (cl_export);
		_g_free0 (cl_import);
		_g_free0 (open_file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp73_ = -1;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (export_str);
		_g_free0 (import_str);
		_g_array_unref0 (export_list);
		_g_array_unref0 (import_list);
		_exports_unref0 (exports);
		options = (g_free (options), NULL);
		_g_option_context_free0 (context);
		_g_free0 (cl_export);
		_g_free0 (cl_import);
		_g_free0 (open_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp73_;
	}
	if (show_help) {
		FILE* _tmp74_;
		GOptionContext* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		_tmp74_ = stdout;
		_tmp75_ = context;
		_tmp76_ = g_option_context_get_help (_tmp75_, TRUE, NULL);
		_tmp77_ = _tmp76_;
		fprintf (_tmp74_, "%s", _tmp77_);
		_g_free0 (_tmp77_);
		result = minder_end_cl (self, cl, 0);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (export_str);
		_g_free0 (import_str);
		_g_array_unref0 (export_list);
		_g_array_unref0 (import_list);
		_exports_unref0 (exports);
		options = (g_free (options), NULL);
		_g_option_context_free0 (context);
		_g_free0 (cl_export);
		_g_free0 (cl_import);
		_g_free0 (open_file);
		return result;
	}
	if (show_version) {
		FILE* _tmp78_;
		const gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		_tmp78_ = stdout;
		_tmp79_ = minder_version;
		_tmp80_ = g_strconcat (_tmp79_, "\n", NULL);
		_tmp81_ = _tmp80_;
		fprintf (_tmp78_, "%s", _tmp81_);
		_g_free0 (_tmp81_);
		result = minder_end_cl (self, cl, 0);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (export_str);
		_g_free0 (import_str);
		_g_array_unref0 (export_list);
		_g_array_unref0 (import_list);
		_exports_unref0 (exports);
		options = (g_free (options), NULL);
		_g_option_context_free0 (context);
		_g_free0 (cl_export);
		_g_free0 (cl_import);
		_g_free0 (open_file);
		return result;
	}
	_tmp82_ = args;
	_tmp82__length1 = args_length1;
	if (_tmp82__length1 >= 2) {
		gchar** _tmp83_;
		gint _tmp83__length1;
		const gchar* _tmp84_;
		gchar* _tmp85_;
		_tmp83_ = args;
		_tmp83__length1 = args_length1;
		_tmp84_ = _tmp83_[1];
		_tmp85_ = g_strdup (_tmp84_);
		_g_free0 (open_file);
		open_file = _tmp85_;
	}
	_tmp86_ = cl_import;
	if (_tmp86_ != NULL) {
		gchar** _tmp87_;
		gint _tmp87__length1;
		_tmp87_ = args;
		_tmp87__length1 = args_length1;
		if (_tmp87__length1 >= 2) {
			MainWindow* _tmp88_;
			const gchar* _tmp89_;
			const gchar* _tmp90_;
			gboolean _tmp91_;
			_tmp88_ = self->priv->appwin;
			_tmp89_ = open_file;
			_tmp90_ = cl_import;
			_tmp91_ = main_window_import_file (_tmp88_, _tmp89_, _tmp90_, &open_file);
			if (!_tmp91_) {
				FILE* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				_tmp92_ = stderr;
				_tmp93_ = g_strconcat (_ ("ERROR: Unable to import file"), "\n", NULL);
				_tmp94_ = _tmp93_;
				fprintf (_tmp92_, "%s", _tmp94_);
				_g_free0 (_tmp94_);
				result = minder_end_cl (self, cl, 1);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (export_str);
				_g_free0 (import_str);
				_g_array_unref0 (export_list);
				_g_array_unref0 (import_list);
				_exports_unref0 (exports);
				options = (g_free (options), NULL);
				_g_option_context_free0 (context);
				_g_free0 (cl_export);
				_g_free0 (cl_import);
				_g_free0 (open_file);
				return result;
			}
		} else {
			FILE* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			_tmp95_ = stderr;
			_tmp96_ = g_strconcat (_ ("ERROR: Import is missing filename to import"), "\n", NULL);
			_tmp97_ = _tmp96_;
			fprintf (_tmp95_, "%s", _tmp97_);
			_g_free0 (_tmp97_);
			result = minder_end_cl (self, cl, 1);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (export_str);
			_g_free0 (import_str);
			_g_array_unref0 (export_list);
			_g_array_unref0 (import_list);
			_exports_unref0 (exports);
			options = (g_free (options), NULL);
			_g_option_context_free0 (context);
			_g_free0 (cl_export);
			_g_free0 (cl_import);
			_g_free0 (open_file);
			return result;
		}
	}
	_tmp98_ = cl_export;
	if (_tmp98_ != NULL) {
		gint retval = 0;
		GeeHashMap* cl_options = NULL;
		GeeHashMap* _tmp99_;
		GeeHashMap* _tmp100_;
		GeeHashMap* _tmp101_;
		GeeHashMap* _tmp102_;
		GeeHashMap* _tmp103_;
		gchar** _tmp104_;
		gint _tmp104__length1;
		retval = 0;
		_tmp99_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		cl_options = _tmp99_;
		_tmp100_ = cl_options;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp100_, "transparent", (gpointer) ((gintptr) transparent));
		_tmp101_ = cl_options;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp101_, "compression", (gpointer) ((gintptr) compression));
		_tmp102_ = cl_options;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp102_, "quality", (gpointer) ((gintptr) quality));
		_tmp103_ = cl_options;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp103_, "include-image-links", (gpointer) ((gintptr) image_links));
		_tmp104_ = args;
		_tmp104__length1 = args_length1;
		if (_tmp104__length1 == 3) {
			const gchar* _tmp105_;
			GeeHashMap* _tmp106_;
			const gchar* _tmp107_;
			gchar** _tmp108_;
			gint _tmp108__length1;
			const gchar* _tmp109_;
			const gchar* _tmp113_;
			_tmp105_ = cl_export;
			_tmp106_ = cl_options;
			_tmp107_ = open_file;
			_tmp108_ = args;
			_tmp108__length1 = args_length1;
			_tmp109_ = _tmp108_[2];
			if (minder_export_as (self, _tmp105_, _tmp106_, _tmp107_, _tmp109_)) {
				FILE* _tmp110_;
				gchar** _tmp111_;
				gint _tmp111__length1;
				const gchar* _tmp112_;
				_tmp110_ = stdout;
				_tmp111_ = args;
				_tmp111__length1 = args_length1;
				_tmp112_ = _tmp111_[2];
				fprintf (_tmp110_, "Successfully exported %s!\n", _tmp112_);
			} else {
				retval = 1;
			}
			_tmp113_ = cl_import;
			if (_tmp113_ != NULL) {
				MainWindow* _tmp114_;
				const gchar* _tmp115_;
				_tmp114_ = self->priv->appwin;
				main_window_close_current_tab (_tmp114_);
				_tmp115_ = open_file;
				g_unlink (_tmp115_);
			}
		} else {
			FILE* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			_tmp116_ = stderr;
			_tmp117_ = g_strconcat (_ ("ERROR: Export is missing input file and/or export output file"), "\n", NULL);
			_tmp118_ = _tmp117_;
			fprintf (_tmp116_, "%s", _tmp118_);
			_g_free0 (_tmp118_);
		}
		result = minder_end_cl (self, cl, retval);
		_g_object_unref0 (cl_options);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (export_str);
		_g_free0 (import_str);
		_g_array_unref0 (export_list);
		_g_array_unref0 (import_list);
		_exports_unref0 (exports);
		options = (g_free (options), NULL);
		_g_option_context_free0 (context);
		_g_free0 (cl_export);
		_g_free0 (cl_import);
		_g_free0 (open_file);
		return result;
	} else {
		const gchar* _tmp119_;
		_tmp119_ = cl_import;
		if (_tmp119_ == NULL) {
			MainWindow* _tmp131_;
			if (new_file) {
				MainWindow* _tmp120_;
				_tmp120_ = self->priv->appwin;
				main_window_do_new_file (_tmp120_);
			} else {
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp121_ = FALSE;
						_tmp121_ = TRUE;
						while (TRUE) {
							gchar** _tmp123_;
							gint _tmp123__length1;
							gchar* file = NULL;
							gchar** _tmp124_;
							gint _tmp124__length1;
							const gchar* _tmp125_;
							gchar* _tmp126_;
							MainWindow* _tmp127_;
							const gchar* _tmp128_;
							if (!_tmp121_) {
								gint _tmp122_;
								_tmp122_ = i;
								i = _tmp122_ + 1;
							}
							_tmp121_ = FALSE;
							_tmp123_ = args;
							_tmp123__length1 = args_length1;
							if (!(i < _tmp123__length1)) {
								break;
							}
							_tmp124_ = args;
							_tmp124__length1 = args_length1;
							_tmp125_ = _tmp124_[i];
							_tmp126_ = g_strdup (_tmp125_);
							file = _tmp126_;
							_tmp127_ = self->priv->appwin;
							_tmp128_ = file;
							if (!main_window_open_file (_tmp127_, _tmp128_, FALSE)) {
								FILE* _tmp129_;
								const gchar* _tmp130_;
								_tmp129_ = stdout;
								_tmp130_ = file;
								fprintf (_tmp129_, _ ("ERROR:  Unable to open file '%s'\n"), _tmp130_);
							}
							_g_free0 (file);
						}
					}
				}
			}
			_tmp131_ = self->priv->appwin;
			gtk_window_present ((GtkWindow*) _tmp131_);
		}
	}
	result = 0;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (export_str);
	_g_free0 (import_str);
	_g_array_unref0 (export_list);
	_g_array_unref0 (import_list);
	_exports_unref0 (exports);
	options = (g_free (options), NULL);
	_g_option_context_free0 (context);
	_g_free0 (cl_export);
	_g_free0 (cl_import);
	_g_free0 (open_file);
	return result;
}

static gpointer
_exports_ref0 (gpointer self)
{
	return self ? exports_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Minder* self;
		self = _data1_->self;
		_export_unref0 (_data1_->export);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
______lambda159_ (Block1Data* _data1_,
                  const gchar* key,
                  gint value)
{
	Minder* self;
	Export* _tmp0_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = _data1_->export;
	if (export_is_bool_setting (_tmp0_, key)) {
		Export* _tmp1_;
		_tmp1_ = _data1_->export;
		export_set_bool (_tmp1_, key, value > 0);
	} else {
		Export* _tmp2_;
		_tmp2_ = _data1_->export;
		if (export_is_scale_setting (_tmp2_, key)) {
			Export* _tmp3_;
			_tmp3_ = _data1_->export;
			export_set_scale (_tmp3_, key, value);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
_______lambda159__gee_forall_map_func (gconstpointer k,
                                       gconstpointer v,
                                       gpointer self)
{
	gboolean result;
	result = ______lambda159_ (self, (const gchar*) k, (gint) ((gintptr) v));
	return result;
}

static gboolean
minder_export_as (Minder* self,
                  const gchar* format,
                  GeeHashMap* options,
                  const gchar* infile,
                  const gchar* outfile)
{
	Exports* exports = NULL;
	MainWindow* _tmp0_;
	Exports* _tmp1_;
	Exports* _tmp2_;
	Exports* _tmp3_;
	FILE* _tmp30_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (format != NULL, FALSE);
	g_return_val_if_fail (options != NULL, FALSE);
	g_return_val_if_fail (infile != NULL, FALSE);
	g_return_val_if_fail (outfile != NULL, FALSE);
	_tmp0_ = self->priv->appwin;
	_tmp1_ = main_window_get_exports (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _exports_ref0 (_tmp2_);
	exports = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				Block1Data* _data1_;
				Exports* _tmp6_;
				Exports* _tmp7_;
				Export* _tmp8_;
				Export* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = exports;
				if (!(i < exports_length (_tmp6_))) {
					block1_data_unref (_data1_);
					_data1_ = NULL;
					break;
				}
				_tmp7_ = exports;
				_tmp8_ = exports_index (_tmp7_, i);
				_data1_->export = _tmp8_;
				_tmp9_ = _data1_->export;
				_tmp10_ = export_get_name (_tmp9_);
				_tmp11_ = _tmp10_;
				if (g_strcmp0 (_tmp11_, format) == 0) {
					GeeMapIterator* _tmp12_;
					GeeMapIterator* _tmp13_;
					DrawArea* da = NULL;
					MainWindow* _tmp14_;
					DrawArea* _tmp15_;
					DrawArea* _tmp16_;
					Document* _tmp17_;
					Document* _tmp18_;
					DrawArea* _tmp19_;
					Document* _tmp20_;
					Document* _tmp21_;
					gboolean _tmp22_;
					_tmp12_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) options);
					_tmp13_ = _tmp12_;
					gee_map_iterator_foreach (_tmp13_, _______lambda159__gee_forall_map_func, _data1_);
					_g_object_unref0 (_tmp13_);
					_tmp14_ = self->priv->appwin;
					_tmp15_ = main_window_create_da (_tmp14_);
					da = _tmp15_;
					_tmp16_ = da;
					_tmp17_ = draw_area_get_doc (_tmp16_);
					_tmp18_ = _tmp17_;
					document_load_filename (_tmp18_, infile, FALSE);
					_g_object_unref0 (_tmp18_);
					_tmp19_ = da;
					_tmp20_ = draw_area_get_doc (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = document_load (_tmp21_);
					_g_object_unref0 (_tmp21_);
					if (_tmp22_) {
						Export* _tmp23_;
						DrawArea* _tmp24_;
						_tmp23_ = _data1_->export;
						_tmp24_ = da;
						result = export_export (_tmp23_, outfile, _tmp24_);
						_g_object_unref0 (da);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						_exports_unref0 (exports);
						return result;
					} else {
						FILE* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp25_ = stderr;
						_tmp26_ = g_strdup_printf (_ ("ERROR:  Unable to load Minder input file %s"), infile);
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strconcat (_tmp27_, "\n", NULL);
						_tmp29_ = _tmp28_;
						fprintf (_tmp25_, "%s", _tmp29_);
						_g_free0 (_tmp29_);
						_g_free0 (_tmp27_);
						result = FALSE;
						_g_object_unref0 (da);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						_exports_unref0 (exports);
						return result;
					}
					_g_object_unref0 (da);
				}
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
	}
	_tmp30_ = stderr;
	fprintf (_tmp30_, "ERROR: Unknown export format: %s\n", format);
	result = FALSE;
	_exports_unref0 (exports);
	return result;
}

static gint
minder_main (gchar** args,
             gint args_length1)
{
	Minder* app = NULL;
	Minder* _tmp0_;
	gint result;
	_tmp0_ = minder_new ();
	app = _tmp0_;
	result = granite_application_run ((GraniteApplication*) app, args, (gint) args_length1);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return minder_main (argv, argc);
}

static void
minder_class_init (MinderClass * klass,
                   gpointer klass_data)
{
	gchar* _tmp0_;
	minder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Minder_private_offset);
	G_OBJECT_CLASS (klass)->finalize = minder_finalize;
	_tmp0_ = g_strdup ("1.17");
	minder_version = _tmp0_;
}

static void
minder_instance_init (Minder * self,
                      gpointer klass)
{
	self->priv = minder_get_instance_private (self);
}

static void
minder_finalize (GObject * obj)
{
	Minder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINDER, Minder);
	_g_object_unref0 (self->priv->appwin);
	_g_object_unref0 (self->priv->iface_settings);
	_g_object_unref0 (self->priv->touch_settings);
	G_OBJECT_CLASS (minder_parent_class)->finalize (obj);
}

static GType
minder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MinderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Minder), 0, (GInstanceInitFunc) minder_instance_init, NULL };
	GType minder_type_id;
	minder_type_id = g_type_register_static (GRANITE_TYPE_APPLICATION, "Minder", &g_define_type_info, 0);
	Minder_private_offset = g_type_add_instance_private (minder_type_id, sizeof (MinderPrivate));
	return minder_type_id;
}

GType
minder_get_type (void)
{
	static volatile gsize minder_type_id__once = 0;
	if (g_once_init_enter (&minder_type_id__once)) {
		GType minder_type_id;
		minder_type_id = minder_get_type_once ();
		g_once_init_leave (&minder_type_id__once, minder_type_id);
	}
	return minder_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

