/* TextMenu.c generated by valac 0.56.18, the Vala compiler
 * generated from TextMenu.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TEXT_MENU (text_menu_get_type ())
#define TEXT_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_MENU, TextMenu))
#define TEXT_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_MENU, TextMenuClass))
#define IS_TEXT_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_MENU))
#define IS_TEXT_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_MENU))
#define TEXT_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_MENU, TextMenuClass))

typedef struct _TextMenu TextMenu;
typedef struct _TextMenuClass TextMenuClass;
typedef struct _TextMenuPrivate TextMenuPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
enum  {
	TEXT_MENU_0_PROPERTY,
	TEXT_MENU_NUM_PROPERTIES
};
static GParamSpec* text_menu_properties[TEXT_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;

#define TYPE_UNDO_TAG_INFO (undo_tag_info_get_type ())
#define UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfo))
#define UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))
#define IS_UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TAG_INFO))
#define IS_UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TAG_INFO))
#define UNDO_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))

typedef struct _UndoTagInfo UndoTagInfo;
typedef struct _UndoTagInfoClass UndoTagInfoClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_URL_EDITOR (url_editor_get_type ())
#define URL_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_URL_EDITOR, UrlEditor))
#define URL_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_URL_EDITOR, UrlEditorClass))
#define IS_URL_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_URL_EDITOR))
#define IS_URL_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_URL_EDITOR))
#define URL_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_URL_EDITOR, UrlEditorClass))

typedef struct _UrlEditor UrlEditor;
typedef struct _UrlEditorClass UrlEditorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _undo_tag_info_unref0(var) ((var == NULL) ? NULL : (var = (undo_tag_info_unref (var), NULL)))

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

struct _TextMenu {
	GtkMenu parent_instance;
	TextMenuPrivate * priv;
};

struct _TextMenuClass {
	GtkMenuClass parent_class;
};

struct _TextMenuPrivate {
	DrawArea* _da;
	GtkMenuItem* _copy;
	GtkMenuItem* _cut;
	GtkMenuItem* _paste;
	GtkMenuItem* _emoji;
	GtkMenuItem* _open_link;
	GtkMenuItem* _add_link;
	GtkMenuItem* _del_link;
	GtkMenuItem* _edit_link;
	GtkMenuItem* _rest_link;
	GtkSeparatorMenuItem* _link_div1;
	GtkSeparatorMenuItem* _link_div2;
};

static gint TextMenu_private_offset;
static gpointer text_menu_parent_class = NULL;

VALA_EXTERN GType text_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextMenu, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN TextMenu* text_menu_new (DrawArea* da,
                         GtkAccelGroup* accel_group);
VALA_EXTERN TextMenu* text_menu_construct (GType object_type,
                               DrawArea* da,
                               GtkAccelGroup* accel_group);
static void text_menu_copy (TextMenu* self);
static void _text_menu_copy_gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self);
static void text_menu_cut (TextMenu* self);
static void _text_menu_cut_gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void text_menu_paste (TextMenu* self);
static void _text_menu_paste_gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static void text_menu_insert_emoji (TextMenu* self);
static void _text_menu_insert_emoji_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self);
static void text_menu_open_link (TextMenu* self);
static void _text_menu_open_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                  gpointer self);
static void text_menu_add_link (TextMenu* self);
static void _text_menu_add_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                 gpointer self);
static void text_menu_edit_link (TextMenu* self);
static void _text_menu_edit_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                  gpointer self);
static void text_menu_remove_link (TextMenu* self);
static void _text_menu_remove_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                    gpointer self);
static void text_menu_restore_link (TextMenu* self);
static void _text_menu_restore_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self);
static void text_menu_on_popup (TextMenu* self);
static void _text_menu_on_popup_gtk_widget_show (GtkWidget* _sender,
                                          gpointer self);
static void text_menu_on_popdown (TextMenu* self);
static void _text_menu_on_popdown_gtk_widget_hide (GtkWidget* _sender,
                                            gpointer self);
VALA_EXTERN void draw_area_copy_selected_text (DrawArea* self);
VALA_EXTERN void draw_area_cut_selected_text (DrawArea* self);
VALA_EXTERN void minder_clipboard_paste (DrawArea* da,
                             gboolean shift);
VALA_EXTERN void draw_area_handle_control_period (DrawArea* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN gboolean draw_area_is_node_editable (DrawArea* self);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gboolean draw_area_is_callout_editable (DrawArea* self);
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN Callout* draw_area_get_current_callout (DrawArea* self);
VALA_EXTERN CanvasText* callout_get_text (Callout* self);
VALA_EXTERN void canvas_text_get_cursor_info (CanvasText* self,
                                  gint* cursor,
                                  gint* start,
                                  gint* end);
VALA_EXTERN gpointer undo_tag_info_ref (gpointer instance);
VALA_EXTERN void undo_tag_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo_tag_info (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_undo_tag_info (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_undo_tag_info (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_undo_tag_info (const GValue* value);
VALA_EXTERN GType undo_tag_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTagInfo, undo_tag_info_unref)
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GArray* formatted_text_get_full_tags_in_range (FormattedText* self,
                                               FormatTag tag,
                                               gint start,
                                               gint end);
VALA_EXTERN void utils_open_url (const gchar* url);
VALA_EXTERN const gchar* undo_tag_info_get_extra (UndoTagInfo* self);
VALA_EXTERN GType url_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UrlEditor, g_object_unref)
VALA_EXTERN UrlEditor* draw_area_get_url_editor (DrawArea* self);
VALA_EXTERN void url_editor_add_url (UrlEditor* self);
VALA_EXTERN void url_editor_remove_url (UrlEditor* self);
VALA_EXTERN void url_editor_edit_url (UrlEditor* self);
VALA_EXTERN void canvas_text_clear_selection (CanvasText* self,
                                  const gchar* msg);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
static gboolean text_menu_copy_or_cut_possible (TextMenu* self);
static gboolean text_menu_paste_possible (TextMenu* self);
VALA_EXTERN void canvas_text_change_selection (CanvasText* self,
                                   gint* selstart,
                                   gint* selend,
                                   const gchar* msg);
VALA_EXTERN gint undo_tag_info_get_start (UndoTagInfo* self);
VALA_EXTERN gint undo_tag_info_get_end (UndoTagInfo* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN gboolean draw_area_add_link_possible (DrawArea* self,
                                      CanvasText* ct);
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
VALA_EXTERN Connection* draw_area_get_current_connection (DrawArea* self);
VALA_EXTERN CanvasText* connection_get_title (Connection* self);
static void text_menu_finalize (GObject * obj);
static GType text_menu_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
text_menu_get_instance_private (TextMenu* self)
{
	return G_STRUCT_MEMBER_P (self, TextMenu_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_text_menu_copy_gtk_menu_item_activate (GtkMenuItem* _sender,
                                        gpointer self)
{
	text_menu_copy ((TextMenu*) self);
}

static void
_text_menu_cut_gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	text_menu_cut ((TextMenu*) self);
}

static void
_text_menu_paste_gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	text_menu_paste ((TextMenu*) self);
}

static void
_text_menu_insert_emoji_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                gpointer self)
{
	text_menu_insert_emoji ((TextMenu*) self);
}

static void
_text_menu_open_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self)
{
	text_menu_open_link ((TextMenu*) self);
}

static void
_text_menu_add_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self)
{
	text_menu_add_link ((TextMenu*) self);
}

static void
_text_menu_edit_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self)
{
	text_menu_edit_link ((TextMenu*) self);
}

static void
_text_menu_remove_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                               gpointer self)
{
	text_menu_remove_link ((TextMenu*) self);
}

static void
_text_menu_restore_link_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                gpointer self)
{
	text_menu_restore_link ((TextMenu*) self);
}

static void
_text_menu_on_popup_gtk_widget_show (GtkWidget* _sender,
                                     gpointer self)
{
	text_menu_on_popup ((TextMenu*) self);
}

static void
_text_menu_on_popdown_gtk_widget_hide (GtkWidget* _sender,
                                       gpointer self)
{
	text_menu_on_popdown ((TextMenu*) self);
}

TextMenu*
text_menu_construct (GType object_type,
                     DrawArea* da,
                     GtkAccelGroup* accel_group)
{
	TextMenu * self = NULL;
	DrawArea* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GraniteAccelLabel* _tmp3_;
	GraniteAccelLabel* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GraniteAccelLabel* _tmp8_;
	GraniteAccelLabel* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GraniteAccelLabel* _tmp13_;
	GraniteAccelLabel* _tmp14_;
	GtkMenuItem* _tmp15_;
	GtkMenuItem* _tmp16_;
	GtkMenuItem* _tmp17_;
	GraniteAccelLabel* _tmp18_;
	GraniteAccelLabel* _tmp19_;
	GtkMenuItem* _tmp20_;
	GtkMenuItem* _tmp21_;
	GtkMenuItem* _tmp22_;
	GtkMenuItem* _tmp23_;
	GtkMenuItem* _tmp24_;
	GraniteAccelLabel* _tmp25_;
	GraniteAccelLabel* _tmp26_;
	GtkMenuItem* _tmp27_;
	GtkMenuItem* _tmp28_;
	GtkMenuItem* _tmp29_;
	GtkMenuItem* _tmp30_;
	GtkMenuItem* _tmp31_;
	GraniteAccelLabel* _tmp32_;
	GraniteAccelLabel* _tmp33_;
	GtkMenuItem* _tmp34_;
	GtkMenuItem* _tmp35_;
	GtkMenuItem* _tmp36_;
	GtkSeparatorMenuItem* _tmp37_;
	GtkSeparatorMenuItem* _tmp38_;
	GtkMenuItem* _tmp39_;
	GtkMenuItem* _tmp40_;
	GtkMenuItem* _tmp41_;
	GtkSeparatorMenuItem* _tmp42_;
	GtkSeparatorMenuItem* _tmp43_;
	GtkMenuItem* _tmp44_;
	GtkSeparatorMenuItem* _tmp45_;
	GtkMenuItem* _tmp46_;
	GtkSeparatorMenuItem* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkMenuItem* _tmp49_;
	GtkMenuItem* _tmp50_;
	GtkMenuItem* _tmp51_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (accel_group != NULL, NULL);
	self = (TextMenu*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_copy);
	self->priv->_copy = _tmp1_;
	_tmp2_ = self->priv->_copy;
	_tmp3_ = granite_accel_label_new (_ ("Copy"), "<Control>c");
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_copy;
	g_signal_connect_object (_tmp5_, "activate", (GCallback) _text_menu_copy_gtk_menu_item_activate, self, 0);
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->_cut);
	self->priv->_cut = _tmp6_;
	_tmp7_ = self->priv->_cut;
	_tmp8_ = granite_accel_label_new (_ ("Cut"), "<Control>x");
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->_cut;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _text_menu_cut_gtk_menu_item_activate, self, 0);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->_paste);
	self->priv->_paste = _tmp11_;
	_tmp12_ = self->priv->_paste;
	_tmp13_ = granite_accel_label_new (_ ("Paste"), "<Control>v");
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_paste;
	g_signal_connect_object (_tmp15_, "activate", (GCallback) _text_menu_paste_gtk_menu_item_activate, self, 0);
	_tmp16_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_emoji);
	self->priv->_emoji = _tmp16_;
	_tmp17_ = self->priv->_emoji;
	_tmp18_ = granite_accel_label_new (_ ("Insert Emoji"), "<Control>period");
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->_emoji;
	g_signal_connect_object (_tmp20_, "activate", (GCallback) _text_menu_insert_emoji_gtk_menu_item_activate, self, 0);
	_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open Link"));
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->_open_link);
	self->priv->_open_link = _tmp21_;
	_tmp22_ = self->priv->_open_link;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) _text_menu_open_link_gtk_menu_item_activate, self, 0);
	_tmp23_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->_add_link);
	self->priv->_add_link = _tmp23_;
	_tmp24_ = self->priv->_add_link;
	_tmp25_ = granite_accel_label_new (_ ("Add Link"), "<Control>k");
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = self->priv->_add_link;
	g_signal_connect_object (_tmp27_, "activate", (GCallback) _text_menu_add_link_gtk_menu_item_activate, self, 0);
	_tmp28_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Edit Link"));
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->_edit_link);
	self->priv->_edit_link = _tmp28_;
	_tmp29_ = self->priv->_edit_link;
	g_signal_connect_object (_tmp29_, "activate", (GCallback) _text_menu_edit_link_gtk_menu_item_activate, self, 0);
	_tmp30_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->_del_link);
	self->priv->_del_link = _tmp30_;
	_tmp31_ = self->priv->_del_link;
	_tmp32_ = granite_accel_label_new (_ ("Remove Link"), "<Shift><Control>k");
	g_object_ref_sink (_tmp32_);
	_tmp33_ = _tmp32_;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = self->priv->_del_link;
	g_signal_connect_object (_tmp34_, "activate", (GCallback) _text_menu_remove_link_gtk_menu_item_activate, self, 0);
	_tmp35_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Restore Link"));
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->_rest_link);
	self->priv->_rest_link = _tmp35_;
	_tmp36_ = self->priv->_rest_link;
	g_signal_connect_object (_tmp36_, "activate", (GCallback) _text_menu_restore_link_gtk_menu_item_activate, self, 0);
	_tmp37_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->_link_div1);
	self->priv->_link_div1 = _tmp37_;
	_tmp38_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->_link_div2);
	self->priv->_link_div2 = _tmp38_;
	_tmp39_ = self->priv->_copy;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->_cut;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->_paste;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp41_);
	_tmp42_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp42_);
	_tmp43_ = _tmp42_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = self->priv->_emoji;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->_link_div1;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->_open_link;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->_link_div2;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->_add_link;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->_edit_link;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp49_);
	_tmp50_ = self->priv->_del_link;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->_rest_link;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp51_);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _text_menu_on_popup_gtk_widget_show, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) _text_menu_on_popdown_gtk_widget_hide, self, 0);
	return self;
}

TextMenu*
text_menu_new (DrawArea* da,
               GtkAccelGroup* accel_group)
{
	return text_menu_construct (TYPE_TEXT_MENU, da, accel_group);
}

static void
text_menu_copy (TextMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_copy_selected_text (_tmp0_);
}

static void
text_menu_cut (TextMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_cut_selected_text (_tmp0_);
}

static void
text_menu_paste (TextMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	minder_clipboard_paste (_tmp0_, FALSE);
}

static void
text_menu_insert_emoji (TextMenu* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_handle_control_period (_tmp0_);
}

static void
text_menu_open_link (TextMenu* self)
{
	CanvasText* ct = NULL;
	DrawArea* _tmp0_;
	CanvasText* _tmp14_;
	g_return_if_fail (self != NULL);
	ct = NULL;
	_tmp0_ = self->priv->_da;
	if (draw_area_is_node_editable (_tmp0_)) {
		DrawArea* _tmp1_;
		Node* _tmp2_;
		Node* _tmp3_;
		CanvasText* _tmp4_;
		CanvasText* _tmp5_;
		CanvasText* _tmp6_;
		_tmp1_ = self->priv->_da;
		_tmp2_ = draw_area_get_current_node (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = node_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (ct);
		ct = _tmp6_;
		_g_object_unref0 (_tmp3_);
	} else {
		DrawArea* _tmp7_;
		_tmp7_ = self->priv->_da;
		if (draw_area_is_callout_editable (_tmp7_)) {
			DrawArea* _tmp8_;
			Callout* _tmp9_;
			Callout* _tmp10_;
			CanvasText* _tmp11_;
			CanvasText* _tmp12_;
			CanvasText* _tmp13_;
			_tmp8_ = self->priv->_da;
			_tmp9_ = draw_area_get_current_callout (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = callout_get_text (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (ct);
			ct = _tmp13_;
			_g_object_unref0 (_tmp10_);
		}
	}
	_tmp14_ = ct;
	if (_tmp14_ != NULL) {
		gint cursor = 0;
		gint selstart = 0;
		gint selend = 0;
		CanvasText* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		GArray* links = NULL;
		CanvasText* _tmp19_;
		FormattedText* _tmp20_;
		FormattedText* _tmp21_;
		GArray* _tmp22_;
		GArray* _tmp23_;
		UndoTagInfo* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp15_ = ct;
		canvas_text_get_cursor_info (_tmp15_, &_tmp16_, &_tmp17_, &_tmp18_);
		cursor = _tmp16_;
		selstart = _tmp17_;
		selend = _tmp18_;
		_tmp19_ = ct;
		_tmp20_ = canvas_text_get_text (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = formatted_text_get_full_tags_in_range (_tmp21_, FORMAT_TAG_URL, cursor, cursor);
		links = _tmp22_;
		_tmp23_ = links;
		_tmp24_ = g_array_index (_tmp23_, UndoTagInfo*, (guint) 0);
		_tmp25_ = undo_tag_info_get_extra (_tmp24_);
		_tmp26_ = _tmp25_;
		utils_open_url (_tmp26_);
		_g_array_unref0 (links);
	}
	_g_object_unref0 (ct);
}

static void
text_menu_add_link (TextMenu* self)
{
	DrawArea* _tmp0_;
	UrlEditor* _tmp1_;
	UrlEditor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_url_editor (_tmp0_);
	_tmp2_ = _tmp1_;
	url_editor_add_url (_tmp2_);
}

static void
text_menu_remove_link (TextMenu* self)
{
	DrawArea* _tmp0_;
	UrlEditor* _tmp1_;
	UrlEditor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_url_editor (_tmp0_);
	_tmp2_ = _tmp1_;
	url_editor_remove_url (_tmp2_);
}

static void
text_menu_edit_link (TextMenu* self)
{
	DrawArea* _tmp0_;
	UrlEditor* _tmp1_;
	UrlEditor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_url_editor (_tmp0_);
	_tmp2_ = _tmp1_;
	url_editor_edit_url (_tmp2_);
}

static void
text_menu_restore_link (TextMenu* self)
{
	CanvasText* ct = NULL;
	DrawArea* _tmp0_;
	CanvasText* _tmp14_;
	g_return_if_fail (self != NULL);
	ct = NULL;
	_tmp0_ = self->priv->_da;
	if (draw_area_is_node_editable (_tmp0_)) {
		DrawArea* _tmp1_;
		Node* _tmp2_;
		Node* _tmp3_;
		CanvasText* _tmp4_;
		CanvasText* _tmp5_;
		CanvasText* _tmp6_;
		_tmp1_ = self->priv->_da;
		_tmp2_ = draw_area_get_current_node (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = node_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (ct);
		ct = _tmp6_;
		_g_object_unref0 (_tmp3_);
	} else {
		DrawArea* _tmp7_;
		_tmp7_ = self->priv->_da;
		if (draw_area_is_callout_editable (_tmp7_)) {
			DrawArea* _tmp8_;
			Callout* _tmp9_;
			Callout* _tmp10_;
			CanvasText* _tmp11_;
			CanvasText* _tmp12_;
			CanvasText* _tmp13_;
			_tmp8_ = self->priv->_da;
			_tmp9_ = draw_area_get_current_callout (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = callout_get_text (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (ct);
			ct = _tmp13_;
			_g_object_unref0 (_tmp10_);
		}
	}
	_tmp14_ = ct;
	if (_tmp14_ != NULL) {
		gint cursor = 0;
		gint selstart = 0;
		gint selend = 0;
		CanvasText* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		CanvasText* _tmp19_;
		DrawArea* _tmp20_;
		_tmp15_ = ct;
		canvas_text_get_cursor_info (_tmp15_, &_tmp16_, &_tmp17_, &_tmp18_);
		cursor = _tmp16_;
		selstart = _tmp17_;
		selend = _tmp18_;
		_tmp19_ = ct;
		canvas_text_clear_selection (_tmp19_, NULL);
		_tmp20_ = self->priv->_da;
		draw_area_auto_save (_tmp20_);
	}
	_g_object_unref0 (ct);
}

static gpointer
_undo_tag_info_ref0 (gpointer self)
{
	return self ? undo_tag_info_ref (self) : NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
text_menu_on_popup (TextMenu* self)
{
	Node* node = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Callout* callout = NULL;
	DrawArea* _tmp2_;
	Callout* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	CanvasText* ct = NULL;
	DrawArea* _tmp12_;
	CanvasText* _tmp26_;
	GtkSeparatorMenuItem* _tmp84_;
	GtkMenuItem* _tmp85_;
	gboolean _tmp86_;
	gboolean _tmp87_;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp90_ = FALSE;
	GtkMenuItem* _tmp91_;
	gboolean _tmp92_;
	gboolean _tmp93_;
	GtkSeparatorMenuItem* _tmp103_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	node = _tmp1_;
	_tmp2_ = self->priv->_da;
	_tmp3_ = draw_area_get_current_callout (_tmp2_);
	callout = _tmp3_;
	_tmp4_ = self->priv->_copy;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, text_menu_copy_or_cut_possible (self));
	_tmp5_ = self->priv->_cut;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, text_menu_copy_or_cut_possible (self));
	_tmp6_ = self->priv->_paste;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, text_menu_paste_possible (self));
	_tmp7_ = self->priv->_open_link;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
	_tmp8_ = self->priv->_add_link;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
	_tmp9_ = self->priv->_edit_link;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
	_tmp10_ = self->priv->_del_link;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
	_tmp11_ = self->priv->_rest_link;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
	ct = NULL;
	_tmp12_ = self->priv->_da;
	if (draw_area_is_node_editable (_tmp12_)) {
		DrawArea* _tmp13_;
		Node* _tmp14_;
		Node* _tmp15_;
		CanvasText* _tmp16_;
		CanvasText* _tmp17_;
		CanvasText* _tmp18_;
		_tmp13_ = self->priv->_da;
		_tmp14_ = draw_area_get_current_node (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = node_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (ct);
		ct = _tmp18_;
		_g_object_unref0 (_tmp15_);
	} else {
		DrawArea* _tmp19_;
		_tmp19_ = self->priv->_da;
		if (draw_area_is_callout_editable (_tmp19_)) {
			DrawArea* _tmp20_;
			Callout* _tmp21_;
			Callout* _tmp22_;
			CanvasText* _tmp23_;
			CanvasText* _tmp24_;
			CanvasText* _tmp25_;
			_tmp20_ = self->priv->_da;
			_tmp21_ = draw_area_get_current_callout (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = callout_get_text (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			_g_object_unref0 (ct);
			ct = _tmp25_;
			_g_object_unref0 (_tmp22_);
		}
	}
	_tmp26_ = ct;
	if (_tmp26_ != NULL) {
		gint cursor = 0;
		gint selstart = 0;
		gint selend = 0;
		CanvasText* _tmp27_;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		GArray* links = NULL;
		CanvasText* _tmp31_;
		FormattedText* _tmp32_;
		FormattedText* _tmp33_;
		GArray* _tmp34_;
		UndoTagInfo* _tmp35_ = NULL;
		GArray* _tmp36_;
		UndoTagInfo* link = NULL;
		UndoTagInfo* _tmp39_;
		gboolean selected = FALSE;
		gboolean valid = FALSE;
		UndoTagInfo* _tmp40_;
		gboolean _tmp48_ = FALSE;
		GArray* _tmp49_;
		gboolean embedded = FALSE;
		gboolean ignore = FALSE;
		gboolean _tmp66_ = FALSE;
		GtkMenuItem* _tmp67_;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		GtkMenuItem* _tmp72_;
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_ = FALSE;
		GtkMenuItem* _tmp75_;
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		GtkMenuItem* _tmp79_;
		gboolean _tmp80_ = FALSE;
		gboolean _tmp81_ = FALSE;
		gboolean _tmp82_ = FALSE;
		GtkMenuItem* _tmp83_;
		_tmp27_ = ct;
		canvas_text_get_cursor_info (_tmp27_, &_tmp28_, &_tmp29_, &_tmp30_);
		cursor = _tmp28_;
		selstart = _tmp29_;
		selend = _tmp30_;
		_tmp31_ = ct;
		_tmp32_ = canvas_text_get_text (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = formatted_text_get_full_tags_in_range (_tmp33_, FORMAT_TAG_URL, cursor, cursor);
		links = _tmp34_;
		_tmp36_ = links;
		if (_tmp36_->len > ((guint) 0)) {
			GArray* _tmp37_;
			UndoTagInfo* _tmp38_;
			_tmp37_ = links;
			_tmp38_ = g_array_index (_tmp37_, UndoTagInfo*, (guint) 0);
			_tmp35_ = _tmp38_;
		} else {
			_tmp35_ = NULL;
		}
		_tmp39_ = _undo_tag_info_ref0 (_tmp35_);
		link = _tmp39_;
		selected = selstart != selend;
		_tmp40_ = link;
		valid = _tmp40_ != NULL;
		if (!selected) {
			CanvasText* _tmp41_;
			UndoTagInfo* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			UndoTagInfo* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			_tmp41_ = ct;
			_tmp42_ = link;
			_tmp43_ = undo_tag_info_get_start (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = link;
			_tmp46_ = undo_tag_info_get_end (_tmp45_);
			_tmp47_ = _tmp46_;
			canvas_text_change_selection (_tmp41_, &_tmp44_, &_tmp47_, NULL);
		}
		_tmp49_ = links;
		if (_tmp49_->len > ((guint) 0)) {
			UndoTagInfo* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			CanvasText* _tmp53_;
			FormattedText* _tmp54_;
			FormattedText* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			UndoTagInfo* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			UndoTagInfo* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp50_ = link;
			_tmp51_ = undo_tag_info_get_extra (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = ct;
			_tmp54_ = canvas_text_get_text (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = formatted_text_get_text (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = link;
			_tmp59_ = undo_tag_info_get_start (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = link;
			_tmp62_ = undo_tag_info_get_end (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = string_slice (_tmp57_, (glong) _tmp60_, (glong) _tmp63_);
			_tmp65_ = _tmp64_;
			_tmp48_ = g_strcmp0 (_tmp52_, _tmp65_) == 0;
			_g_free0 (_tmp65_);
		} else {
			_tmp48_ = FALSE;
		}
		embedded = _tmp48_;
		ignore = FALSE;
		if (valid) {
			_tmp66_ = !ignore;
		} else {
			_tmp66_ = FALSE;
		}
		_tmp67_ = self->priv->_open_link;
		gtk_widget_set_visible ((GtkWidget*) _tmp67_, _tmp66_);
		if (!embedded) {
			_tmp69_ = !ignore;
		} else {
			_tmp69_ = FALSE;
		}
		if (_tmp69_) {
			DrawArea* _tmp70_;
			CanvasText* _tmp71_;
			_tmp70_ = self->priv->_da;
			_tmp71_ = ct;
			_tmp68_ = draw_area_add_link_possible (_tmp70_, _tmp71_);
		} else {
			_tmp68_ = FALSE;
		}
		_tmp72_ = self->priv->_add_link;
		gtk_widget_set_visible ((GtkWidget*) _tmp72_, _tmp68_);
		if (valid) {
			_tmp74_ = !selected;
		} else {
			_tmp74_ = FALSE;
		}
		if (_tmp74_) {
			_tmp73_ = !embedded;
		} else {
			_tmp73_ = FALSE;
		}
		_tmp75_ = self->priv->_edit_link;
		gtk_widget_set_visible ((GtkWidget*) _tmp75_, _tmp73_);
		if (valid) {
			_tmp77_ = !selected;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			gboolean _tmp78_ = FALSE;
			if (!embedded) {
				_tmp78_ = TRUE;
			} else {
				_tmp78_ = !ignore;
			}
			_tmp76_ = _tmp78_;
		} else {
			_tmp76_ = FALSE;
		}
		_tmp79_ = self->priv->_del_link;
		gtk_widget_set_visible ((GtkWidget*) _tmp79_, _tmp76_);
		if (valid) {
			_tmp82_ = !selected;
		} else {
			_tmp82_ = FALSE;
		}
		if (_tmp82_) {
			_tmp81_ = embedded;
		} else {
			_tmp81_ = FALSE;
		}
		if (_tmp81_) {
			_tmp80_ = ignore;
		} else {
			_tmp80_ = FALSE;
		}
		_tmp83_ = self->priv->_rest_link;
		gtk_widget_set_visible ((GtkWidget*) _tmp83_, _tmp80_);
		_undo_tag_info_unref0 (link);
		_g_array_unref0 (links);
	}
	_tmp84_ = self->priv->_link_div1;
	_tmp85_ = self->priv->_open_link;
	_tmp86_ = gtk_widget_get_visible ((GtkWidget*) _tmp85_);
	_tmp87_ = _tmp86_;
	gtk_widget_set_visible ((GtkWidget*) _tmp84_, _tmp87_);
	_tmp91_ = self->priv->_add_link;
	_tmp92_ = gtk_widget_get_visible ((GtkWidget*) _tmp91_);
	_tmp93_ = _tmp92_;
	if (_tmp93_) {
		_tmp90_ = TRUE;
	} else {
		GtkMenuItem* _tmp94_;
		gboolean _tmp95_;
		gboolean _tmp96_;
		_tmp94_ = self->priv->_edit_link;
		_tmp95_ = gtk_widget_get_visible ((GtkWidget*) _tmp94_);
		_tmp96_ = _tmp95_;
		_tmp90_ = _tmp96_;
	}
	if (_tmp90_) {
		_tmp89_ = TRUE;
	} else {
		GtkMenuItem* _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp99_;
		_tmp97_ = self->priv->_del_link;
		_tmp98_ = gtk_widget_get_visible ((GtkWidget*) _tmp97_);
		_tmp99_ = _tmp98_;
		_tmp89_ = _tmp99_;
	}
	if (_tmp89_) {
		_tmp88_ = TRUE;
	} else {
		GtkMenuItem* _tmp100_;
		gboolean _tmp101_;
		gboolean _tmp102_;
		_tmp100_ = self->priv->_rest_link;
		_tmp101_ = gtk_widget_get_visible ((GtkWidget*) _tmp100_);
		_tmp102_ = _tmp101_;
		_tmp88_ = _tmp102_;
	}
	_tmp103_ = self->priv->_link_div2;
	gtk_widget_set_visible ((GtkWidget*) _tmp103_, _tmp88_);
	_g_object_unref0 (ct);
	_g_object_unref0 (callout);
	_g_object_unref0 (node);
}

static void
text_menu_on_popdown (TextMenu* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkMenuItem* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_edit_link;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		GtkMenuItem* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->_del_link;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GtkMenuItem* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->_rest_link;
		_tmp9_ = gtk_widget_get_visible ((GtkWidget*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	}
	if (_tmp0_) {
		Node* node = NULL;
		DrawArea* _tmp11_;
		Node* _tmp12_;
		Callout* callout = NULL;
		DrawArea* _tmp13_;
		Callout* _tmp14_;
		Node* _tmp15_;
		_tmp11_ = self->priv->_da;
		_tmp12_ = draw_area_get_current_node (_tmp11_);
		node = _tmp12_;
		_tmp13_ = self->priv->_da;
		_tmp14_ = draw_area_get_current_callout (_tmp13_);
		callout = _tmp14_;
		_tmp15_ = node;
		if (_tmp15_ != NULL) {
			Node* _tmp16_;
			CanvasText* _tmp17_;
			CanvasText* _tmp18_;
			_tmp16_ = node;
			_tmp17_ = node_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			canvas_text_clear_selection (_tmp18_, NULL);
		} else {
			Callout* _tmp19_;
			_tmp19_ = callout;
			if (_tmp19_ != NULL) {
				Callout* _tmp20_;
				CanvasText* _tmp21_;
				CanvasText* _tmp22_;
				_tmp20_ = callout;
				_tmp21_ = callout_get_text (_tmp20_);
				_tmp22_ = _tmp21_;
				canvas_text_clear_selection (_tmp22_, NULL);
			}
		}
		_g_object_unref0 (callout);
		_g_object_unref0 (node);
	}
}

static gboolean
text_menu_copy_or_cut_possible (TextMenu* self)
{
	Node* node = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Connection* conn = NULL;
	DrawArea* _tmp2_;
	Connection* _tmp3_;
	Callout* callout = NULL;
	DrawArea* _tmp4_;
	Callout* _tmp5_;
	gint cursor = 0;
	gint selstart = 0;
	gint selend = 0;
	Node* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	node = _tmp1_;
	_tmp2_ = self->priv->_da;
	_tmp3_ = draw_area_get_current_connection (_tmp2_);
	conn = _tmp3_;
	_tmp4_ = self->priv->_da;
	_tmp5_ = draw_area_get_current_callout (_tmp4_);
	callout = _tmp5_;
	cursor = 0;
	selstart = 0;
	selend = 0;
	_tmp6_ = node;
	if (_tmp6_ != NULL) {
		Node* _tmp7_;
		CanvasText* _tmp8_;
		CanvasText* _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp7_ = node;
		_tmp8_ = node_get_name (_tmp7_);
		_tmp9_ = _tmp8_;
		canvas_text_get_cursor_info (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
		cursor = _tmp10_;
		selstart = _tmp11_;
		selend = _tmp12_;
	} else {
		Connection* _tmp13_;
		_tmp13_ = conn;
		if (_tmp13_ != NULL) {
			Connection* _tmp14_;
			CanvasText* _tmp15_;
			CanvasText* _tmp16_;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp14_ = conn;
			_tmp15_ = connection_get_title (_tmp14_);
			_tmp16_ = _tmp15_;
			canvas_text_get_cursor_info (_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
			cursor = _tmp17_;
			selstart = _tmp18_;
			selend = _tmp19_;
		} else {
			Callout* _tmp20_;
			_tmp20_ = callout;
			if (_tmp20_ != NULL) {
				Callout* _tmp21_;
				CanvasText* _tmp22_;
				CanvasText* _tmp23_;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				_tmp21_ = callout;
				_tmp22_ = callout_get_text (_tmp21_);
				_tmp23_ = _tmp22_;
				canvas_text_get_cursor_info (_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_);
				cursor = _tmp24_;
				selstart = _tmp25_;
				selend = _tmp26_;
			}
		}
	}
	result = selstart != selend;
	_g_object_unref0 (callout);
	_g_object_unref0 (conn);
	_g_object_unref0 (node);
	return result;
}

static gboolean
text_menu_paste_possible (TextMenu* self)
{
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	gchar* value = NULL;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gtk_clipboard_get_default (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = gtk_clipboard_wait_for_text (clipboard);
	value = _tmp3_;
	result = value != NULL;
	_g_free0 (value);
	_g_object_unref0 (clipboard);
	return result;
}

static void
text_menu_class_init (TextMenuClass * klass,
                      gpointer klass_data)
{
	text_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TextMenu_private_offset);
	G_OBJECT_CLASS (klass)->finalize = text_menu_finalize;
}

static void
text_menu_instance_init (TextMenu * self,
                         gpointer klass)
{
	self->priv = text_menu_get_instance_private (self);
}

static void
text_menu_finalize (GObject * obj)
{
	TextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_MENU, TextMenu);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_copy);
	_g_object_unref0 (self->priv->_cut);
	_g_object_unref0 (self->priv->_paste);
	_g_object_unref0 (self->priv->_emoji);
	_g_object_unref0 (self->priv->_open_link);
	_g_object_unref0 (self->priv->_add_link);
	_g_object_unref0 (self->priv->_del_link);
	_g_object_unref0 (self->priv->_edit_link);
	_g_object_unref0 (self->priv->_rest_link);
	_g_object_unref0 (self->priv->_link_div1);
	_g_object_unref0 (self->priv->_link_div2);
	G_OBJECT_CLASS (text_menu_parent_class)->finalize (obj);
}

static GType
text_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TextMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextMenu), 0, (GInstanceInitFunc) text_menu_instance_init, NULL };
	GType text_menu_type_id;
	text_menu_type_id = g_type_register_static (gtk_menu_get_type (), "TextMenu", &g_define_type_info, 0);
	TextMenu_private_offset = g_type_add_instance_private (text_menu_type_id, sizeof (TextMenuPrivate));
	return text_menu_type_id;
}

GType
text_menu_get_type (void)
{
	static volatile gsize text_menu_type_id__once = 0;
	if (g_once_init_enter (&text_menu_type_id__once)) {
		GType text_menu_type_id;
		text_menu_type_id = text_menu_get_type_once ();
		g_once_init_leave (&text_menu_type_id__once, text_menu_type_id);
	}
	return text_menu_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

