use glib::{Enum, prelude::*, translate::*};
use news_flash::models::Marked;

#[derive(Debug, Default, Eq, PartialEq, Clone, Copy, Enum)]
#[repr(u32)]
#[enum_type(name = "NewsFlashGMarked")]
pub enum GMarked {
    Marked,
    #[default]
    Unmarked,
}

impl From<Marked> for GMarked {
    fn from(marked: Marked) -> Self {
        match marked {
            Marked::Marked => Self::Marked,
            Marked::Unmarked => Self::Unmarked,
        }
    }
}

impl GMarked {
    pub fn invert(&self) -> Self {
        match self {
            Self::Marked => Self::Unmarked,
            Self::Unmarked => Self::Marked,
        }
    }
}

impl ToVariant for GMarked {
    fn to_variant(&self) -> glib::Variant {
        self.into_glib().to_variant()
    }
}

impl FromVariant for GMarked {
    fn from_variant(variant: &glib::Variant) -> Option<Self> {
        variant.get::<i32>().map(|int| unsafe { GMarked::from_glib(int) })
    }
}

impl StaticVariantType for GMarked {
    fn static_variant_type() -> std::borrow::Cow<'static, glib::VariantTy> {
        std::borrow::Cow::Borrowed(glib::VariantTy::INT32)
    }
}

impl From<GMarked> for Marked {
    fn from(marked: GMarked) -> Self {
        match marked {
            GMarked::Marked => Marked::Marked,
            GMarked::Unmarked => Marked::Unmarked,
        }
    }
}
