/* Terminal.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Terminal.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022 elementary, Inc. (https://elementary.io)
 *                         2011-2013 Mario Guerriero <mario@elementaryos.org>
 */

#include <glib.h>
#include "codecore.h"
#include <vte/vte.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <glib/gstdio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#define CODE_TERMINAL_MAX_SCALE 5.0
#define CODE_TERMINAL_MIN_SCALE 0.2
#define CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA "org.pantheon.terminal.settings"
#define CODE_TERMINAL_SETTINGS_SCHEMA "io.elementary.terminal.settings"
#define CODE_TERMINAL_GNOME_DESKTOP_INTERFACE_SCHEMA "org.gnome.desktop.interface"
#define CODE_TERMINAL_GNOME_DESKTOP_WM_PREFERENCES_SCHEMA "org.gnome.desktop.wm.preferences"
#define CODE_TERMINAL_TERMINAL_FONT_KEY "font"
#define CODE_TERMINAL_TERMINAL_BELL_KEY "audible-bell"
#define CODE_TERMINAL_TERMINAL_CURSOR_KEY "cursor-shape"
#define CODE_TERMINAL_TERMINAL_FOREGROUND_KEY "foreground"
#define CODE_TERMINAL_TERMINAL_BACKGROUND_KEY "background"
#define CODE_TERMINAL_TERMINAL_PALETTE_KEY "palette"
#define CODE_TERMINAL_GNOME_FONT_KEY "monospace-font-name"
#define CODE_TERMINAL_GNOME_BELL_KEY "audible-bell"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef gboolean (*_LocalFunc0_) (guint keyval, guint code, gpointer user_data);
enum  {
	CODE_TERMINAL_0_PROPERTY,
	CODE_TERMINAL_TERMINAL_PROPERTY,
	CODE_TERMINAL_ACTIONS_PROPERTY,
	CODE_TERMINAL_NUM_PROPERTIES
};
static GParamSpec* code_terminal_properties[CODE_TERMINAL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _Block52Data Block52Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

struct _CodeTerminalPrivate {
	VteTerminal* _terminal;
	GtkEventControllerKey* key_controller;
	GSettings* terminal_settings;
	GSettings* gnome_interface_settings;
	GSettings* gnome_wm_settings;
	GSimpleActionGroup* _actions;
	GPid child_pid;
	GtkClipboard* current_clipboard;
};

struct _Block52Data {
	int _ref_count_;
	CodeTerminal* self;
	GSimpleAction* copy_action;
	GSimpleAction* paste_action;
	GtkMenu* menu;
};

static gint CodeTerminal_private_offset;
static gpointer code_terminal_parent_class = NULL;

static void code_terminal_spawn_shell (CodeTerminal* self,
                                const gchar* dir);
static gchar* code_terminal_get_shell_location (CodeTerminal* self);
static void code_terminal_update_font (CodeTerminal* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void code_terminal_update_audible_bell (CodeTerminal* self);
static void code_terminal_update_cursor (CodeTerminal* self);
static void code_terminal_update_colors (CodeTerminal* self);
static gboolean code_terminal_key_pressed (CodeTerminal* self,
                                    guint keyval,
                                    guint keycode,
                                    GdkModifierType modifiers);
static gboolean __lambda127_ (CodeTerminal* self,
                       guint keyval,
                       guint code);
static gboolean ___lambda127___localfunc0_ (guint keyval,
                                     guint code,
                                     gpointer self);
static GObject * code_terminal_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void _code_terminal____lambda128_ (CodeTerminal* self,
                                   const gchar* key);
static void __code_terminal____lambda128__g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self);
static void _code_terminal_____lambda129_ (CodeTerminal* self,
                                    const gchar* key);
static void __code_terminal_____lambda129__g_settings_changed (GSettings* _sender,
                                                        const gchar* key,
                                                        gpointer self);
static void _code_terminal____lambda130_ (CodeTerminal* self,
                                   const gchar* key);
static void __code_terminal____lambda130__g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self);
static void _code_terminal___lambda131_ (CodeTerminal* self);
static void __code_terminal___lambda131__vte_terminal_child_exited (VteTerminal* _sender,
                                                             gint status,
                                                             gpointer self);
static void _code_terminal___lambda132_ (CodeTerminal* self);
static void __code_terminal___lambda132__g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static void _code_terminal___lambda133_ (CodeTerminal* self);
static void __code_terminal___lambda133__g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static gboolean _code_terminal_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                          guint keyval,
                                                                          guint keycode,
                                                                          GdkModifierType state,
                                                                          gpointer self);
static gboolean _code_terminal___lambda134_ (Block52Data* _data52_,
                                      GdkEventButton* event);
static gboolean __code_terminal___lambda134__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self);
static void _code_terminal___lambda135_ (Block52Data* _data52_);
static void __code_terminal___lambda135__gtk_widget_realize (GtkWidget* _sender,
                                                      gpointer self);
static void _code_terminal___lambda136_ (Block52Data* _data52_);
static void __code_terminal___lambda136__vte_terminal_selection_changed (VteTerminal* _sender,
                                                                  gpointer self);
static void _code_terminal___lambda137_ (CodeTerminal* self);
static void __code_terminal___lambda137__gtk_widget_destroy (GtkWidget* _sender,
                                                      gpointer self);
static void code_terminal_finalize (GObject * obj);
static GType code_terminal_get_type_once (void);
static void _vala_code_terminal_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_code_terminal_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
code_terminal_get_instance_private (CodeTerminal* self)
{
	return G_STRUCT_MEMBER_P (self, CodeTerminal_private_offset);
}

static void
code_terminal_spawn_shell (CodeTerminal* self,
                           const gchar* dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	{
		VteTerminal* _tmp0_;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		GPid _tmp4_ = 0;
		_tmp0_ = self->priv->_terminal;
		_tmp1_ = vte_get_user_shell ();
		_tmp2_ = g_new0 (gchar*, 1 + 1);
		_tmp2_[0] = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 1;
		vte_terminal_spawn_sync (_tmp0_, VTE_PTY_DEFAULT, dir, _tmp3_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, NULL, &_inner_error0_);
		self->priv->child_pid = _tmp4_;
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("Terminal.vala:197: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
code_terminal_change_location (CodeTerminal* self,
                               const gchar* dir)
{
	VteTerminal* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	kill ((pid_t) self->priv->child_pid, (gint) SIGTERM);
	_tmp0_ = self->priv->_terminal;
	vte_terminal_reset (_tmp0_, TRUE, TRUE);
	code_terminal_spawn_shell (self, dir);
	_tmp1_ = scratch_saved_state;
	g_settings_set_string (_tmp1_, "last-opened-path", dir);
}

static gchar*
code_terminal_get_shell_location (CodeTerminal* self)
{
	gint pid = 0;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	pid = (gint) ((GPid) self->priv->child_pid);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_strdup_printf ("/proc/%d/cwd", pid);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_read_link (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("Terminal.vala:213: An error occurred while fetching the current dir of" \
" shell: %s", _tmp7_);
		_tmp8_ = g_strdup ("");
		result = _tmp8_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
code_terminal_update_font (CodeTerminal* self)
{
	gchar* font_name = NULL;
	gchar* _tmp0_;
	GSettings* _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	PangoFontDescription* fd = NULL;
	const gchar* _tmp9_;
	PangoFontDescription* _tmp10_;
	VteTerminal* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	font_name = _tmp0_;
	_tmp1_ = self->priv->terminal_settings;
	if (_tmp1_ != NULL) {
		GSettings* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->terminal_settings;
		_tmp3_ = g_settings_get_string (_tmp2_, CODE_TERMINAL_TERMINAL_FONT_KEY);
		_g_free0 (font_name);
		font_name = _tmp3_;
	}
	_tmp5_ = font_name;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		GSettings* _tmp6_;
		_tmp6_ = self->priv->gnome_interface_settings;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GSettings* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->gnome_interface_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, CODE_TERMINAL_GNOME_FONT_KEY);
		_g_free0 (font_name);
		font_name = _tmp8_;
	}
	_tmp9_ = font_name;
	_tmp10_ = pango_font_description_from_string (_tmp9_);
	fd = _tmp10_;
	_tmp11_ = self->priv->_terminal;
	vte_terminal_set_font (_tmp11_, fd);
	__vala_PangoFontDescription_free0 (fd);
	_g_free0 (font_name);
}

static void
code_terminal_update_audible_bell (CodeTerminal* self)
{
	gboolean audible_bell = FALSE;
	GSettings* _tmp0_;
	VteTerminal* _tmp4_;
	g_return_if_fail (self != NULL);
	audible_bell = FALSE;
	_tmp0_ = self->priv->terminal_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->terminal_settings;
		audible_bell = g_settings_get_boolean (_tmp1_, CODE_TERMINAL_TERMINAL_BELL_KEY);
	} else {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->gnome_wm_settings;
		if (_tmp2_ != NULL) {
			GSettings* _tmp3_;
			_tmp3_ = self->priv->gnome_wm_settings;
			audible_bell = g_settings_get_boolean (_tmp3_, CODE_TERMINAL_GNOME_BELL_KEY);
		}
	}
	_tmp4_ = self->priv->_terminal;
	vte_terminal_set_audible_bell (_tmp4_, audible_bell);
}

static void
code_terminal_update_cursor (CodeTerminal* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->terminal_settings;
	if (_tmp0_ != NULL) {
		gchar* cursor_shape_setting = NULL;
		GSettings* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GQuark _tmp6_ = 0U;
		static GQuark _tmp5_label0 = 0;
		static GQuark _tmp5_label1 = 0;
		static GQuark _tmp5_label2 = 0;
		_tmp1_ = self->priv->terminal_settings;
		_tmp2_ = g_settings_get_string (_tmp1_, CODE_TERMINAL_TERMINAL_CURSOR_KEY);
		cursor_shape_setting = _tmp2_;
		_tmp3_ = cursor_shape_setting;
		_tmp4_ = _tmp3_;
		_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
		if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("Block")))) {
			switch (0) {
				default:
				{
					VteTerminal* _tmp7_;
					_tmp7_ = self->priv->_terminal;
					vte_terminal_set_cursor_shape (_tmp7_, VTE_CURSOR_SHAPE_BLOCK);
					break;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("I-Beam")))) {
			switch (0) {
				default:
				{
					VteTerminal* _tmp8_;
					_tmp8_ = self->priv->_terminal;
					vte_terminal_set_cursor_shape (_tmp8_, VTE_CURSOR_SHAPE_IBEAM);
					break;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("Underline")))) {
			switch (0) {
				default:
				{
					VteTerminal* _tmp9_;
					_tmp9_ = self->priv->_terminal;
					vte_terminal_set_cursor_shape (_tmp9_, VTE_CURSOR_SHAPE_UNDERLINE);
					break;
				}
			}
		}
		_g_free0 (cursor_shape_setting);
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
code_terminal_update_colors (CodeTerminal* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->terminal_settings;
	if (_tmp0_ != NULL) {
		gchar* background_setting = NULL;
		GSettings* _tmp1_;
		gchar* _tmp2_;
		GdkRGBA background_color = {0};
		const gchar* _tmp3_;
		gchar* foreground_setting = NULL;
		GSettings* _tmp4_;
		gchar* _tmp5_;
		GdkRGBA foreground_color = {0};
		const gchar* _tmp6_;
		gchar* palette_setting = NULL;
		GSettings* _tmp7_;
		gchar* _tmp8_;
		gchar** hex_palette = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar** _tmp25_;
		gint hex_palette_length1;
		gint _hex_palette_size_;
		gchar* current_string = NULL;
		gchar* _tmp26_;
		gint current_color = 0;
		GdkRGBA* palette = NULL;
		GdkRGBA* _tmp43_;
		gint palette_length1;
		gint _palette_size_;
		VteTerminal* _tmp51_;
		GdkRGBA _tmp52_;
		GdkRGBA _tmp53_;
		GdkRGBA* _tmp54_;
		gint _tmp54__length1;
		_tmp1_ = self->priv->terminal_settings;
		_tmp2_ = g_settings_get_string (_tmp1_, CODE_TERMINAL_TERMINAL_BACKGROUND_KEY);
		background_setting = _tmp2_;
		memset (&background_color, 0, sizeof (GdkRGBA));
		_tmp3_ = background_setting;
		gdk_rgba_parse (&background_color, _tmp3_);
		_tmp4_ = self->priv->terminal_settings;
		_tmp5_ = g_settings_get_string (_tmp4_, CODE_TERMINAL_TERMINAL_FOREGROUND_KEY);
		foreground_setting = _tmp5_;
		memset (&foreground_color, 0, sizeof (GdkRGBA));
		_tmp6_ = foreground_setting;
		gdk_rgba_parse (&foreground_color, _tmp6_);
		_tmp7_ = self->priv->terminal_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, CODE_TERMINAL_TERMINAL_PALETTE_KEY);
		palette_setting = _tmp8_;
		_tmp9_ = g_strdup ("#000000");
		_tmp10_ = g_strdup ("#FF6C60");
		_tmp11_ = g_strdup ("#A8FF60");
		_tmp12_ = g_strdup ("#FFFFCC");
		_tmp13_ = g_strdup ("#96CBFE");
		_tmp14_ = g_strdup ("#FF73FE");
		_tmp15_ = g_strdup ("#C6C5FE");
		_tmp16_ = g_strdup ("#EEEEEE");
		_tmp17_ = g_strdup ("#000000");
		_tmp18_ = g_strdup ("#FF6C60");
		_tmp19_ = g_strdup ("#A8FF60");
		_tmp20_ = g_strdup ("#FFFFB6");
		_tmp21_ = g_strdup ("#96CBFE");
		_tmp22_ = g_strdup ("#FF73FE");
		_tmp23_ = g_strdup ("#C6C5FE");
		_tmp24_ = g_strdup ("#EEEEEE");
		_tmp25_ = g_new0 (gchar*, 16 + 1);
		_tmp25_[0] = _tmp9_;
		_tmp25_[1] = _tmp10_;
		_tmp25_[2] = _tmp11_;
		_tmp25_[3] = _tmp12_;
		_tmp25_[4] = _tmp13_;
		_tmp25_[5] = _tmp14_;
		_tmp25_[6] = _tmp15_;
		_tmp25_[7] = _tmp16_;
		_tmp25_[8] = _tmp17_;
		_tmp25_[9] = _tmp18_;
		_tmp25_[10] = _tmp19_;
		_tmp25_[11] = _tmp20_;
		_tmp25_[12] = _tmp21_;
		_tmp25_[13] = _tmp22_;
		_tmp25_[14] = _tmp23_;
		_tmp25_[15] = _tmp24_;
		hex_palette = _tmp25_;
		hex_palette_length1 = 16;
		_hex_palette_size_ = hex_palette_length1;
		_tmp26_ = g_strdup ("");
		current_string = _tmp26_;
		current_color = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp27_ = FALSE;
				_tmp27_ = TRUE;
				while (TRUE) {
					const gchar* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					const gchar* _tmp32_;
					if (!_tmp27_) {
						gint _tmp28_;
						_tmp28_ = i;
						i = _tmp28_ + 1;
					}
					_tmp27_ = FALSE;
					_tmp29_ = palette_setting;
					_tmp30_ = strlen (_tmp29_);
					_tmp31_ = _tmp30_;
					if (!(i < _tmp31_)) {
						break;
					}
					_tmp32_ = palette_setting;
					if (string_get (_tmp32_, (glong) i) == ':') {
						gchar** _tmp33_;
						gint _tmp33__length1;
						const gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gint _tmp37_;
						_tmp33_ = hex_palette;
						_tmp33__length1 = hex_palette_length1;
						_tmp34_ = current_string;
						_tmp35_ = g_strdup (_tmp34_);
						_g_free0 (_tmp33_[current_color]);
						_tmp33_[current_color] = _tmp35_;
						_tmp36_ = g_strdup ("");
						_g_free0 (current_string);
						current_string = _tmp36_;
						_tmp37_ = current_color;
						current_color = _tmp37_ + 1;
					} else {
						const gchar* _tmp38_;
						const gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp38_ = current_string;
						_tmp39_ = palette_setting;
						_tmp40_ = g_strdup_printf ("%c", string_get (_tmp39_, (glong) i));
						_tmp41_ = _tmp40_;
						_tmp42_ = g_strconcat (_tmp38_, _tmp41_, NULL);
						_g_free0 (current_string);
						current_string = _tmp42_;
						_g_free0 (_tmp41_);
					}
				}
			}
		}
		_tmp43_ = g_new0 (GdkRGBA, 16);
		palette = _tmp43_;
		palette_length1 = 16;
		_palette_size_ = palette_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp44_ = FALSE;
				_tmp44_ = TRUE;
				while (TRUE) {
					gchar** _tmp46_;
					gint _tmp46__length1;
					GdkRGBA new_color = {0};
					gchar** _tmp47_;
					gint _tmp47__length1;
					const gchar* _tmp48_;
					GdkRGBA* _tmp49_;
					gint _tmp49__length1;
					GdkRGBA _tmp50_;
					if (!_tmp44_) {
						gint _tmp45_;
						_tmp45_ = i;
						i = _tmp45_ + 1;
					}
					_tmp44_ = FALSE;
					_tmp46_ = hex_palette;
					_tmp46__length1 = hex_palette_length1;
					if (!(i < _tmp46__length1)) {
						break;
					}
					memset (&new_color, 0, sizeof (GdkRGBA));
					_tmp47_ = hex_palette;
					_tmp47__length1 = hex_palette_length1;
					_tmp48_ = _tmp47_[i];
					gdk_rgba_parse (&new_color, _tmp48_);
					_tmp49_ = palette;
					_tmp49__length1 = palette_length1;
					_tmp50_ = new_color;
					_tmp49_[i] = _tmp50_;
				}
			}
		}
		_tmp51_ = self->priv->_terminal;
		_tmp52_ = foreground_color;
		_tmp53_ = background_color;
		_tmp54_ = palette;
		_tmp54__length1 = palette_length1;
		vte_terminal_set_colors (_tmp51_, &_tmp52_, &_tmp53_, _tmp54_, (gsize) _tmp54__length1);
		palette = (g_free (palette), NULL);
		_g_free0 (current_string);
		hex_palette = (_vala_array_free (hex_palette, hex_palette_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (palette_setting);
		_g_free0 (foreground_setting);
		_g_free0 (background_setting);
	}
}

void
code_terminal_increment_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	VteTerminal* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = self->priv->_terminal;
	_tmp2_ = vte_terminal_get_font_scale (_tmp1_);
	_tmp3_ = _tmp2_;
	vte_terminal_set_font_scale (_tmp0_, CLAMP (_tmp3_ + 0.1, CODE_TERMINAL_MIN_SCALE, CODE_TERMINAL_MAX_SCALE));
}

void
code_terminal_decrement_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	VteTerminal* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = self->priv->_terminal;
	_tmp2_ = vte_terminal_get_font_scale (_tmp1_);
	_tmp3_ = _tmp2_;
	vte_terminal_set_font_scale (_tmp0_, CLAMP (_tmp3_ - 0.1, CODE_TERMINAL_MIN_SCALE, CODE_TERMINAL_MAX_SCALE));
}

void
code_terminal_set_default_font_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	vte_terminal_set_font_scale (_tmp0_, 1.0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda127_ (CodeTerminal* self,
              guint keyval,
              guint code)
{
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkKeymap* keymap = NULL;
	GdkDisplay* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	GdkKeymap* _tmp3_;
	GdkKeymapKey* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean result;
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gdk_keymap_get_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keymap = _tmp2_;
	_tmp3_ = keymap;
	_tmp6_ = gdk_keymap_get_entries_for_keyval (_tmp3_, keyval, &_tmp4_, &_tmp5_);
	keys = (g_free (keys), NULL);
	keys = _tmp4_;
	keys_length1 = _tmp5_;
	_keys_size_ = keys_length1;
	if (_tmp6_) {
		GdkKeymapKey* _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = keys;
		_tmp7__length1 = keys_length1;
		{
			GdkKeymapKey* key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp7_;
			key_collection_length1 = _tmp7__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				GdkKeymapKey key = {0};
				key = key_collection[key_it];
				{
					GdkKeymapKey _tmp8_;
					_tmp8_ = key;
					if (code == _tmp8_.keycode) {
						result = GDK_EVENT_STOP;
						_g_object_unref0 (keymap);
						keys = (g_free (keys), NULL);
						return result;
					}
				}
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (keymap);
	keys = (g_free (keys), NULL);
	return result;
}

static gboolean
___lambda127___localfunc0_ (guint keyval,
                            guint code,
                            gpointer self)
{
	gboolean result;
	result = __lambda127_ ((CodeTerminal*) self, keyval, code);
	return result;
}

static gboolean
code_terminal_key_pressed (CodeTerminal* self,
                           guint keyval,
                           guint keycode,
                           GdkModifierType modifiers)
{
	_LocalFunc0_ match_keycode = NULL;
	gpointer match_keycode_target;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	match_keycode = ___lambda127___localfunc0_;
	match_keycode_target = self;
	if ((modifiers & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		gboolean _tmp1_ = FALSE;
		if ((modifiers & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			GSettings* _tmp3_;
			_tmp3_ = self->priv->terminal_settings;
			if (_tmp3_ != NULL) {
				GSettings* _tmp4_;
				_tmp4_ = self->priv->terminal_settings;
				_tmp2_ = g_settings_get_boolean (_tmp4_, "natural-copy-paste");
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp5_ = FALSE;
		_LocalFunc0_ _tmp6_;
		gpointer _tmp6__target;
		_tmp6_ = match_keycode;
		_tmp6__target = match_keycode_target;
		if (_tmp6_ (GDK_KEY_c, keycode, _tmp6__target)) {
			VteTerminal* _tmp7_;
			_tmp7_ = self->priv->_terminal;
			_tmp5_ = vte_terminal_get_has_selection (_tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GSimpleActionGroup* _tmp8_;
			_tmp8_ = self->priv->_actions;
			g_action_group_activate_action ((GActionGroup*) _tmp8_, CODE_TERMINAL_ACTION_COPY, NULL);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			gboolean _tmp9_ = FALSE;
			_LocalFunc0_ _tmp10_;
			gpointer _tmp10__target;
			_tmp10_ = match_keycode;
			_tmp10__target = match_keycode_target;
			if (_tmp10_ (GDK_KEY_v, keycode, _tmp10__target)) {
				GtkClipboard* _tmp11_;
				_tmp11_ = self->priv->current_clipboard;
				_tmp9_ = gtk_clipboard_wait_is_text_available (_tmp11_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GSimpleActionGroup* _tmp12_;
				_tmp12_ = self->priv->_actions;
				g_action_group_activate_action ((GActionGroup*) _tmp12_, CODE_TERMINAL_ACTION_PASTE, NULL);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

CodeTerminal*
code_terminal_construct (GType object_type)
{
	CodeTerminal * self = NULL;
	self = (CodeTerminal*) g_object_new (object_type, NULL);
	return self;
}

CodeTerminal*
code_terminal_new (void)
{
	return code_terminal_construct (CODE_TYPE_TERMINAL);
}

VteTerminal*
code_terminal_get_terminal (CodeTerminal* self)
{
	VteTerminal* result;
	VteTerminal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_terminal;
	result = _tmp0_;
	return result;
}

static void
code_terminal_set_terminal (CodeTerminal* self,
                            VteTerminal* value)
{
	VteTerminal* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_terminal_get_terminal (self);
	if (old_value != value) {
		VteTerminal* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_terminal);
		self->priv->_terminal = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_terminal_properties[CODE_TERMINAL_TERMINAL_PROPERTY]);
	}
}

GSimpleActionGroup*
code_terminal_get_actions (CodeTerminal* self)
{
	GSimpleActionGroup* result;
	GSimpleActionGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	result = _tmp0_;
	return result;
}

static void
code_terminal_set_actions (CodeTerminal* self,
                           GSimpleActionGroup* value)
{
	GSimpleActionGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_terminal_get_actions (self);
	if (old_value != value) {
		GSimpleActionGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actions);
		self->priv->_actions = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_terminal_properties[CODE_TERMINAL_ACTIONS_PROPERTY]);
	}
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		CodeTerminal* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->menu);
		_g_object_unref0 (_data52_->paste_action);
		_g_object_unref0 (_data52_->copy_action);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_code_terminal____lambda128_ (CodeTerminal* self,
                              const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (CODE_TERMINAL_TERMINAL_FONT_KEY)))) {
		switch (0) {
			default:
			{
				code_terminal_update_font (self);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (CODE_TERMINAL_TERMINAL_BELL_KEY)))) {
		switch (0) {
			default:
			{
				code_terminal_update_audible_bell (self);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (CODE_TERMINAL_TERMINAL_CURSOR_KEY)))) {
		switch (0) {
			default:
			{
				code_terminal_update_cursor (self);
				break;
			}
		}
	} else if (((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (CODE_TERMINAL_TERMINAL_FOREGROUND_KEY)))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string (CODE_TERMINAL_TERMINAL_BACKGROUND_KEY))))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string (CODE_TERMINAL_TERMINAL_PALETTE_KEY))))) {
		switch (0) {
			default:
			{
				code_terminal_update_colors (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
__code_terminal____lambda128__g_settings_changed (GSettings* _sender,
                                                  const gchar* key,
                                                  gpointer self)
{
	_code_terminal____lambda128_ ((CodeTerminal*) self, key);
}

static void
_code_terminal_____lambda129_ (CodeTerminal* self,
                               const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (CODE_TERMINAL_GNOME_BELL_KEY)))) {
		switch (0) {
			default:
			{
				code_terminal_update_audible_bell (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
__code_terminal_____lambda129__g_settings_changed (GSettings* _sender,
                                                   const gchar* key,
                                                   gpointer self)
{
	_code_terminal_____lambda129_ ((CodeTerminal*) self, key);
}

static void
_code_terminal____lambda130_ (CodeTerminal* self,
                              const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (CODE_TERMINAL_GNOME_FONT_KEY)))) {
		switch (0) {
			default:
			{
				code_terminal_update_font (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
__code_terminal____lambda130__g_settings_changed (GSettings* _sender,
                                                  const gchar* key,
                                                  gpointer self)
{
	_code_terminal____lambda130_ ((CodeTerminal*) self, key);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_code_terminal___lambda131_ (CodeTerminal* self)
{
	GActionGroup* win_group = NULL;
	GActionGroup* _tmp0_;
	GActionGroup* _tmp1_;
	GActionGroup* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	VteTerminal* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_ = 0;
	guint8* _tmp9_;
	gint _tmp9__length1;
	_tmp0_ = gtk_widget_get_action_group ((GtkWidget*) self, SCRATCH_MAIN_WINDOW_ACTION_GROUP);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	win_group = _tmp1_;
	_tmp2_ = win_group;
	g_action_group_activate_action (_tmp2_, SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_TERMINAL, NULL);
	_tmp3_ = scratch_saved_state;
	_tmp4_ = g_settings_get_string (_tmp3_, "last-opened-path");
	_tmp5_ = _tmp4_;
	code_terminal_spawn_shell (self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_terminal;
	_tmp7_ = string_get_data ("clear -x\n", &_tmp8_);
	_tmp7__length1 = _tmp8_;
	_tmp9_ = _tmp7_;
	_tmp9__length1 = _tmp7__length1;
	vte_terminal_feed_child (_tmp6_, _tmp9_, (gssize) _tmp9__length1);
	_g_object_unref0 (win_group);
}

static void
__code_terminal___lambda131__vte_terminal_child_exited (VteTerminal* _sender,
                                                        gint status,
                                                        gpointer self)
{
	_code_terminal___lambda131_ ((CodeTerminal*) self);
}

static void
_code_terminal___lambda132_ (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	_tmp0_ = self->priv->_terminal;
	vte_terminal_copy_clipboard (_tmp0_);
}

static void
__code_terminal___lambda132__g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	_code_terminal___lambda132_ ((CodeTerminal*) self);
}

static void
_code_terminal___lambda133_ (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	_tmp0_ = self->priv->_terminal;
	vte_terminal_paste_clipboard (_tmp0_);
}

static void
__code_terminal___lambda133__g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	_code_terminal___lambda133_ ((CodeTerminal*) self);
}

static gboolean
_code_terminal_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                 guint keyval,
                                                                 guint keycode,
                                                                 GdkModifierType state,
                                                                 gpointer self)
{
	gboolean result;
	result = code_terminal_key_pressed ((CodeTerminal*) self, keyval, keycode, state);
	return result;
}

static gboolean
_code_terminal___lambda134_ (Block52Data* _data52_,
                             GdkEventButton* event)
{
	CodeTerminal* self;
	gboolean result;
	self = _data52_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 3)) {
		GSimpleAction* _tmp0_;
		GtkClipboard* _tmp1_;
		GtkMenu* _tmp2_;
		GtkMenu* _tmp3_;
		_tmp0_ = _data52_->paste_action;
		_tmp1_ = self->priv->current_clipboard;
		g_simple_action_set_enabled (_tmp0_, gtk_clipboard_wait_is_text_available (_tmp1_));
		_tmp2_ = _data52_->menu;
		gtk_menu_shell_select_first ((GtkMenuShell*) _tmp2_, FALSE);
		_tmp3_ = _data52_->menu;
		gtk_menu_popup_at_pointer (_tmp3_, (GdkEvent*) event);
	}
	result = FALSE;
	return result;
}

static gboolean
__code_terminal___lambda134__gtk_widget_button_press_event (GtkWidget* _sender,
                                                            GdkEventButton* event,
                                                            gpointer self)
{
	gboolean result;
	result = _code_terminal___lambda134_ (self, event);
	return result;
}

static void
_code_terminal___lambda135_ (Block52Data* _data52_)
{
	CodeTerminal* self;
	VteTerminal* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	GSimpleAction* _tmp3_;
	VteTerminal* _tmp4_;
	self = _data52_->self;
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = gtk_widget_get_clipboard ((GtkWidget*) _tmp0_, GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->current_clipboard);
	self->priv->current_clipboard = _tmp2_;
	_tmp3_ = _data52_->copy_action;
	_tmp4_ = self->priv->_terminal;
	g_simple_action_set_enabled (_tmp3_, vte_terminal_get_has_selection (_tmp4_));
}

static void
__code_terminal___lambda135__gtk_widget_realize (GtkWidget* _sender,
                                                 gpointer self)
{
	_code_terminal___lambda135_ (self);
}

static void
_code_terminal___lambda136_ (Block52Data* _data52_)
{
	CodeTerminal* self;
	GSimpleAction* _tmp0_;
	VteTerminal* _tmp1_;
	self = _data52_->self;
	_tmp0_ = _data52_->copy_action;
	_tmp1_ = self->priv->_terminal;
	g_simple_action_set_enabled (_tmp0_, vte_terminal_get_has_selection (_tmp1_));
}

static void
__code_terminal___lambda136__vte_terminal_selection_changed (VteTerminal* _sender,
                                                             gpointer self)
{
	_code_terminal___lambda136_ (self);
}

static void
_code_terminal___lambda137_ (CodeTerminal* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = scratch_saved_state;
	_tmp1_ = code_terminal_get_shell_location (self);
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "last-opened-path", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__code_terminal___lambda137__gtk_widget_destroy (GtkWidget* _sender,
                                                 gpointer self)
{
	_code_terminal___lambda137_ ((CodeTerminal*) self);
}

static GObject *
code_terminal_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CodeTerminal * self;
	Block52Data* _data52_;
	VteTerminal* _tmp0_ = NULL;
	VteTerminal* _tmp1_;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSettingsSchema* terminal_schema = NULL;
	GSettingsSchemaSource* _tmp4_;
	GSettingsSchema* _tmp5_;
	GSettingsSchema* _tmp6_;
	GSettingsSchema* _tmp9_;
	GSettingsSchema* gnome_interface_settings_schema = NULL;
	GSettingsSchemaSource* _tmp19_;
	GSettingsSchema* _tmp20_;
	GSettingsSchema* _tmp21_;
	VteTerminal* _tmp25_;
	GSimpleAction* _tmp26_;
	GSimpleAction* _tmp27_;
	GSimpleAction* _tmp28_;
	GSimpleAction* _tmp29_;
	GSimpleAction* _tmp30_;
	GSimpleActionGroup* _tmp31_;
	GSimpleActionGroup* _tmp32_;
	GSimpleActionGroup* _tmp33_;
	GSimpleAction* _tmp34_;
	GSimpleActionGroup* _tmp35_;
	GSimpleAction* _tmp36_;
	GMenu* menu_model = NULL;
	GMenu* _tmp37_;
	GMenu* _tmp38_;
	GMenu* _tmp39_;
	GMenu* _tmp40_;
	GtkMenu* _tmp41_;
	GtkMenu* _tmp42_;
	GSimpleActionGroup* _tmp43_;
	GtkMenu* _tmp44_;
	VteTerminal* _tmp45_;
	GtkEventControllerKey* _tmp46_ = NULL;
	GtkEventControllerKey* _tmp47_;
	VteTerminal* _tmp48_;
	VteTerminal* _tmp49_;
	GSettings* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GtkScrolledWindow* scrolled_window = NULL;
	VteTerminal* _tmp53_;
	GtkAdjustment* _tmp54_;
	GtkScrolledWindow* _tmp55_;
	GtkScrolledWindow* _tmp56_;
	VteTerminal* _tmp57_;
	GtkScrolledWindow* _tmp58_;
	parent_class = G_OBJECT_CLASS (code_terminal_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_TERMINAL, CodeTerminal);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_tmp0_ = (VteTerminal*) vte_terminal_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, TRUE);
	vte_terminal_set_scrollback_lines (_tmp0_, (guint) -1);
	vte_terminal_set_cursor_blink_mode (_tmp0_, VTE_CURSOR_BLINK_SYSTEM);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	code_terminal_set_terminal (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	schema_source = _tmp3_;
	_tmp4_ = schema_source;
	_tmp5_ = g_settings_schema_source_lookup (_tmp4_, CODE_TERMINAL_SETTINGS_SCHEMA, TRUE);
	terminal_schema = _tmp5_;
	_tmp6_ = terminal_schema;
	if (_tmp6_ == NULL) {
		GSettingsSchemaSource* _tmp7_;
		GSettingsSchema* _tmp8_;
		_tmp7_ = schema_source;
		_tmp8_ = g_settings_schema_source_lookup (_tmp7_, CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA, TRUE);
		_g_settings_schema_unref0 (terminal_schema);
		terminal_schema = _tmp8_;
	}
	_tmp9_ = terminal_schema;
	if (_tmp9_ != NULL) {
		GSettingsSchema* _tmp10_;
		GSettings* _tmp11_;
		GSettings* _tmp12_;
		_tmp10_ = terminal_schema;
		_tmp11_ = g_settings_new_full (_tmp10_, NULL, NULL);
		_g_object_unref0 (self->priv->terminal_settings);
		self->priv->terminal_settings = _tmp11_;
		_tmp12_ = self->priv->terminal_settings;
		g_signal_connect_object (_tmp12_, "changed", (GCallback) __code_terminal____lambda128__g_settings_changed, self, 0);
	} else {
		GSettingsSchema* gnome_wm_settings_schema = NULL;
		GSettingsSchemaSource* _tmp13_;
		GSettingsSchema* _tmp14_;
		GSettingsSchema* _tmp15_;
		_tmp13_ = schema_source;
		_tmp14_ = g_settings_schema_source_lookup (_tmp13_, CODE_TERMINAL_GNOME_DESKTOP_WM_PREFERENCES_SCHEMA, TRUE);
		gnome_wm_settings_schema = _tmp14_;
		_tmp15_ = gnome_wm_settings_schema;
		if (_tmp15_ != NULL) {
			GSettingsSchema* _tmp16_;
			GSettings* _tmp17_;
			GSettings* _tmp18_;
			_tmp16_ = gnome_wm_settings_schema;
			_tmp17_ = g_settings_new_full (_tmp16_, NULL, NULL);
			_g_object_unref0 (self->priv->gnome_wm_settings);
			self->priv->gnome_wm_settings = _tmp17_;
			_tmp18_ = self->priv->gnome_wm_settings;
			g_signal_connect_object (_tmp18_, "changed", (GCallback) __code_terminal_____lambda129__g_settings_changed, self, 0);
		}
		_g_settings_schema_unref0 (gnome_wm_settings_schema);
	}
	_tmp19_ = schema_source;
	_tmp20_ = g_settings_schema_source_lookup (_tmp19_, CODE_TERMINAL_GNOME_DESKTOP_INTERFACE_SCHEMA, TRUE);
	gnome_interface_settings_schema = _tmp20_;
	_tmp21_ = gnome_interface_settings_schema;
	if (_tmp21_ != NULL) {
		GSettingsSchema* _tmp22_;
		GSettings* _tmp23_;
		GSettings* _tmp24_;
		_tmp22_ = gnome_interface_settings_schema;
		_tmp23_ = g_settings_new_full (_tmp22_, NULL, NULL);
		_g_object_unref0 (self->priv->gnome_interface_settings);
		self->priv->gnome_interface_settings = _tmp23_;
		_tmp24_ = self->priv->gnome_interface_settings;
		g_signal_connect_object (_tmp24_, "changed", (GCallback) __code_terminal____lambda130__g_settings_changed, self, 0);
	}
	code_terminal_update_font (self);
	code_terminal_update_audible_bell (self);
	code_terminal_update_cursor (self);
	code_terminal_update_colors (self);
	_tmp25_ = self->priv->_terminal;
	g_signal_connect_object (_tmp25_, "child-exited", (GCallback) __code_terminal___lambda131__vte_terminal_child_exited, self, 0);
	_tmp26_ = g_simple_action_new (CODE_TERMINAL_ACTION_COPY, NULL);
	_data52_->copy_action = _tmp26_;
	_tmp27_ = _data52_->copy_action;
	g_simple_action_set_enabled (_tmp27_, FALSE);
	_tmp28_ = _data52_->copy_action;
	g_signal_connect_object (_tmp28_, "activate", (GCallback) __code_terminal___lambda132__g_simple_action_activate, self, 0);
	_tmp29_ = g_simple_action_new (CODE_TERMINAL_ACTION_PASTE, NULL);
	_data52_->paste_action = _tmp29_;
	_tmp30_ = _data52_->paste_action;
	g_signal_connect_object (_tmp30_, "activate", (GCallback) __code_terminal___lambda133__g_simple_action_activate, self, 0);
	_tmp31_ = g_simple_action_group_new ();
	_tmp32_ = _tmp31_;
	code_terminal_set_actions (self, _tmp32_);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = self->priv->_actions;
	_tmp34_ = _data52_->copy_action;
	g_action_map_add_action ((GActionMap*) _tmp33_, (GAction*) _tmp34_);
	_tmp35_ = self->priv->_actions;
	_tmp36_ = _data52_->paste_action;
	g_action_map_add_action ((GActionMap*) _tmp35_, (GAction*) _tmp36_);
	_tmp37_ = g_menu_new ();
	menu_model = _tmp37_;
	_tmp38_ = menu_model;
	g_menu_append (_tmp38_, _ ("Copy"), CODE_TERMINAL_ACTION_PREFIX CODE_TERMINAL_ACTION_COPY);
	_tmp39_ = menu_model;
	g_menu_append (_tmp39_, _ ("Paste"), CODE_TERMINAL_ACTION_PREFIX CODE_TERMINAL_ACTION_PASTE);
	_tmp40_ = menu_model;
	_tmp41_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp40_);
	g_object_ref_sink (_tmp41_);
	_data52_->menu = _tmp41_;
	_tmp42_ = _data52_->menu;
	_tmp43_ = self->priv->_actions;
	gtk_widget_insert_action_group ((GtkWidget*) _tmp42_, CODE_TERMINAL_ACTION_GROUP, (GActionGroup*) _tmp43_);
	_tmp44_ = _data52_->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->_terminal;
	_tmp46_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp45_);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp46_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp46_;
	_tmp47_ = self->priv->key_controller;
	g_signal_connect_object (_tmp47_, "key-pressed", (GCallback) _code_terminal_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp48_ = self->priv->_terminal;
	g_signal_connect_data ((GtkWidget*) _tmp48_, "button-press-event", (GCallback) __code_terminal___lambda134__gtk_widget_button_press_event, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) __code_terminal___lambda135__gtk_widget_realize, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	_tmp49_ = self->priv->_terminal;
	g_signal_connect_data (_tmp49_, "selection-changed", (GCallback) __code_terminal___lambda136__vte_terminal_selection_changed, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	_tmp50_ = scratch_saved_state;
	_tmp51_ = g_settings_get_string (_tmp50_, "last-opened-path");
	_tmp52_ = _tmp51_;
	code_terminal_spawn_shell (self, _tmp52_);
	_g_free0 (_tmp52_);
	_tmp53_ = self->priv->_terminal;
	_tmp54_ = gtk_scrollable_get_vadjustment ((GtkScrollable*) _tmp53_);
	_tmp55_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, _tmp54_);
	g_object_ref_sink (_tmp55_);
	scrolled_window = _tmp55_;
	_tmp56_ = scrolled_window;
	_tmp57_ = self->priv->_terminal;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp58_);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) __code_terminal___lambda137__gtk_widget_destroy, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (menu_model);
	_g_settings_schema_unref0 (gnome_interface_settings_schema);
	_g_settings_schema_unref0 (terminal_schema);
	_g_settings_schema_source_unref0 (schema_source);
	block52_data_unref (_data52_);
	_data52_ = NULL;
	return obj;
}

static void
code_terminal_class_init (CodeTerminalClass * klass,
                          gpointer klass_data)
{
	code_terminal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodeTerminal_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_code_terminal_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_terminal_set_property;
	G_OBJECT_CLASS (klass)->constructor = code_terminal_constructor;
	G_OBJECT_CLASS (klass)->finalize = code_terminal_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_TERMINAL_TERMINAL_PROPERTY, code_terminal_properties[CODE_TERMINAL_TERMINAL_PROPERTY] = g_param_spec_object ("terminal", "terminal", "terminal", vte_terminal_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_TERMINAL_ACTIONS_PROPERTY, code_terminal_properties[CODE_TERMINAL_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", g_simple_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
code_terminal_instance_init (CodeTerminal * self,
                             gpointer klass)
{
	self->priv = code_terminal_get_instance_private (self);
	self->priv->terminal_settings = NULL;
	self->priv->gnome_interface_settings = NULL;
	self->priv->gnome_wm_settings = NULL;
}

static void
code_terminal_finalize (GObject * obj)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_TERMINAL, CodeTerminal);
	_g_object_unref0 (self->priv->_terminal);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->terminal_settings);
	_g_object_unref0 (self->priv->gnome_interface_settings);
	_g_object_unref0 (self->priv->gnome_wm_settings);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->current_clipboard);
	G_OBJECT_CLASS (code_terminal_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
code_terminal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodeTerminalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_terminal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodeTerminal), 0, (GInstanceInitFunc) code_terminal_instance_init, NULL };
	GType code_terminal_type_id;
	code_terminal_type_id = g_type_register_static (gtk_box_get_type (), "CodeTerminal", &g_define_type_info, 0);
	CodeTerminal_private_offset = g_type_add_instance_private (code_terminal_type_id, sizeof (CodeTerminalPrivate));
	return code_terminal_type_id;
}

GType
code_terminal_get_type (void)
{
	static gsize code_terminal_type_id__once = 0;
	if (g_once_init_enter (&code_terminal_type_id__once)) {
		GType code_terminal_type_id;
		code_terminal_type_id = code_terminal_get_type_once ();
		g_once_init_leave (&code_terminal_type_id__once, code_terminal_type_id);
	}
	return code_terminal_type_id__once;
}

static void
_vala_code_terminal_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_TERMINAL, CodeTerminal);
	switch (property_id) {
		case CODE_TERMINAL_TERMINAL_PROPERTY:
		g_value_set_object (value, code_terminal_get_terminal (self));
		break;
		case CODE_TERMINAL_ACTIONS_PROPERTY:
		g_value_set_object (value, code_terminal_get_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_terminal_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_TERMINAL, CodeTerminal);
	switch (property_id) {
		case CODE_TERMINAL_TERMINAL_PROPERTY:
		code_terminal_set_terminal (self, g_value_get_object (value));
		break;
		case CODE_TERMINAL_ACTIONS_PROPERTY:
		code_terminal_set_actions (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

