// python wrapper for vtkPVLogger
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkLogger.h"
#include "vtkPVLogger.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVLogger(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVLogger_ClassNew(); }


static PyObject *
PyvtkPVLogger_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVLogger::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVLogger *op = static_cast<vtkPVLogger *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVLogger::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVLogger *tempr = vtkPVLogger::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVLogger *op = static_cast<vtkPVLogger *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVLogger *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVLogger::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVLogger::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVLogger *op = static_cast<vtkPVLogger *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVLogger::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetPipelineVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPipelineVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetPipelineVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetPipelineVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetPipelineVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetPipelineVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetExecutionVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetExecutionVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetExecutionVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetExecutionVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetExecutionVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetExecutionVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetPluginVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPluginVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetPluginVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetPluginVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetPluginVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetPluginVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetDataMovementVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDataMovementVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetDataMovementVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetDataMovementVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDataMovementVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetDataMovementVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetRenderingVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRenderingVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetRenderingVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetRenderingVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRenderingVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetRenderingVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetApplicationVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetApplicationVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetApplicationVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetApplicationVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetApplicationVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetApplicationVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetCatalystVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetCatalystVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetCatalystVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetCatalystVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetCatalystVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetCatalystVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_GetDefaultVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDefaultVerbosity");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkLogger::Verbosity tempr = vtkPVLogger::GetDefaultVerbosity();

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkLogger.Verbosity");
    }
  }

  return result;
}


static PyObject *
PyvtkPVLogger_SetDefaultVerbosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDefaultVerbosity");

  vtkLogger::Verbosity temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkLogger.Verbosity"))
  {
    vtkPVLogger::SetDefaultVerbosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVLogger_Methods[] = {
  {"IsTypeOf", PyvtkPVLogger_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVLogger_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVLogger_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVLogger\nC++: static vtkPVLogger *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVLogger_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVLogger\nC++: vtkPVLogger *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVLogger_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVLogger_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetPipelineVerbosity", PyvtkPVLogger_GetPipelineVerbosity, METH_VARARGS,
   "GetPipelineVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetPipelineVerbosity()\n\nUse this verbosity level when logging messages that provide\ninformation about pipeline update requests, etc.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE` unless overridden\nby calling `SetPipelineVerbosity` or by setting the environment\nvariable `PARAVIEW_LOG_PIPELINE_VERBOSITY` to the expected\nverbosity level.\n"},
  {"SetPipelineVerbosity", PyvtkPVLogger_SetPipelineVerbosity, METH_VARARGS,
   "SetPipelineVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetPipelineVerbosity(vtkLogger::Verbosity value)\n\n"},
  {"GetExecutionVerbosity", PyvtkPVLogger_GetExecutionVerbosity, METH_VARARGS,
   "GetExecutionVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetExecutionVerbosity()\n\nUse this verbosity level when logging messages that provide\ninformation about algorithm execution.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE` unless overridden\nby calling `SetExecutionVerbosity` or by setting the environment\nvariable `PARAVIEW_LOG_EXECUTION_VERBOSITY` to the expected\nverbosity level.\n"},
  {"SetExecutionVerbosity", PyvtkPVLogger_SetExecutionVerbosity, METH_VARARGS,
   "SetExecutionVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetExecutionVerbosity(vtkLogger::Verbosity value)\n\n"},
  {"GetPluginVerbosity", PyvtkPVLogger_GetPluginVerbosity, METH_VARARGS,
   "GetPluginVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetPluginVerbosity()\n\nUse this verbosity level to for log message relating to\nParaView's plugin system.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE` unless overridden\nby calling `SetPluginVerbosity` or by setting the environment\nvariable `PARAVIEW_LOG_PLUGIN_VERBOSITY` to the expected\nverbosity level.\n"},
  {"SetPluginVerbosity", PyvtkPVLogger_SetPluginVerbosity, METH_VARARGS,
   "SetPluginVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetPluginVerbosity(vtkLogger::Verbosity value)\n\n"},
  {"GetDataMovementVerbosity", PyvtkPVLogger_GetDataMovementVerbosity, METH_VARARGS,
   "GetDataMovementVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetDataMovementVerbosity()\n\nVerbosity level for log messages related to data-movement e.g.\nmoving data between processes for rendering.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE` unless overridden\nby calling `SetDataMovementVerbosity` or by setting the\nenvironment variable `PARAVIEW_LOG_DATA_MOVEMENT_VERBOSITY` to\nthe expected verbosity level.\n"},
  {"SetDataMovementVerbosity", PyvtkPVLogger_SetDataMovementVerbosity, METH_VARARGS,
   "SetDataMovementVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetDataMovementVerbosity(\n    vtkLogger::Verbosity value)\n\n"},
  {"GetRenderingVerbosity", PyvtkPVLogger_GetRenderingVerbosity, METH_VARARGS,
   "GetRenderingVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetRenderingVerbosity()\n\nVerbosity level for log messages related to rendering.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE` unless overridden\nby calling `SetRenderingVerbosity` or by setting the environment\nvariable `PARAVIEW_LOG_RENDERING_VERBOSITY` to the expected\nverbosity level.\n"},
  {"SetRenderingVerbosity", PyvtkPVLogger_SetRenderingVerbosity, METH_VARARGS,
   "SetRenderingVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetRenderingVerbosity(vtkLogger::Verbosity value)\n\n"},
  {"GetApplicationVerbosity", PyvtkPVLogger_GetApplicationVerbosity, METH_VARARGS,
   "GetApplicationVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetApplicationVerbosity()\n\nVerbosity level for log messages related to the application, gui,\nand similar components.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE` unless overridden\nby calling `SetApplicationVerbosity` or by setting the\nenvironment variable `PARAVIEW_LOG_APPLICATION_VERBOSITY` to the\nexpected verbosity level.\n"},
  {"SetApplicationVerbosity", PyvtkPVLogger_SetApplicationVerbosity, METH_VARARGS,
   "SetApplicationVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetApplicationVerbosity(\n    vtkLogger::Verbosity value)\n\n"},
  {"GetCatalystVerbosity", PyvtkPVLogger_GetCatalystVerbosity, METH_VARARGS,
   "GetCatalystVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetCatalystVerbosity()\n\nVerbosity level for log messages related to Catalyst and other in\nsitu tasks.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE` unless overridden\nby calling `SetCatalystVerbosity` or by setting the environment\nvariable `PARAVIEW_LOG_CATALYST_VERBOSITY` to the expected\nverbosity level.\n"},
  {"SetCatalystVerbosity", PyvtkPVLogger_SetCatalystVerbosity, METH_VARARGS,
   "SetCatalystVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetCatalystVerbosity(vtkLogger::Verbosity value)\n\n"},
  {"GetDefaultVerbosity", PyvtkPVLogger_GetDefaultVerbosity, METH_VARARGS,
   "GetDefaultVerbosity() -> vtkLogger.Verbosity\nC++: static vtkLogger::Verbosity GetDefaultVerbosity()\n\nChange default verbosity to use for all ParaView categories\ndefined here if no overrides are specified. This is intended to\nbe used by ParaView-based applications to change the level at\nwhich ParaView messages are logged in bulk.\n\nDefault level is `vtkLogger::VERBOSITY_TRACE`.\n"},
  {"SetDefaultVerbosity", PyvtkPVLogger_SetDefaultVerbosity, METH_VARARGS,
   "SetDefaultVerbosity(value:vtkLogger.Verbosity) -> None\nC++: static void SetDefaultVerbosity(vtkLogger::Verbosity value)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVLogger_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("pipeline_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetPipelineVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetPipelineVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetPipelineVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPipelineVerbosity/SetPipelineVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("execution_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetExecutionVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetExecutionVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetExecutionVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExecutionVerbosity/SetExecutionVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugin_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetPluginVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetPluginVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetPluginVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPluginVerbosity/SetPluginVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_movement_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetDataMovementVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetDataMovementVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetDataMovementVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataMovementVerbosity/SetDataMovementVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rendering_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetRenderingVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetRenderingVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetRenderingVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderingVerbosity/SetRenderingVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("application_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetApplicationVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetApplicationVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetApplicationVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetApplicationVerbosity/SetApplicationVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("catalyst_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetCatalystVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetCatalystVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetCatalystVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCatalystVerbosity/SetCatalystVerbosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("default_verbosity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVLogger_GetDefaultVerbosity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVLogger_SetDefaultVerbosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVLogger_SetDefaultVerbosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDefaultVerbosity/SetDefaultVerbosity\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVLogger_Doc =
  "vtkPVLogger - defines various logging categories for ParaView\n\n"
  "Superclass: vtkLogger\n\n"
  "ParaView code generates informative log entires under several\n"
  "categories. This class provides ability to convert a category to a\n"
  "verbosity level to use to log a message.\n\n"
  "All code in ParaView that generates informative log messages should\n"
  "use one of the categories defined here when logging. For example, to\n"
  "log a message about rendering, one uses `GetRenderingVerbosity` or\n"
  "the convenience macro `PARAVIEW_LOG_RENDERING_VERBOSITY()` as\n"
  "follows:\n\n"
  "{cpp}\n"
  "vtkVLogF(PARAVIEW_LOG_RENDERING_VERBOSITY(), \"message about\n"
  "rendering\");\n\n"
  "Developers can elevate verbosity level for any category using the\n"
  "APIs provided on vtkPVLogger e.g. SetRenderingVerbosity.\n\n"
  "At runtime, users can elevate verbosity level for any category by\n"
  "setting the corresponding environment variable to level requested\n"
  "e.g. to make all rendering log message show up as INFO, and thus show\n"
  "up on the terminal by default, set the environment variable\n"
  "`PARAVIEW_LOG_RENDERING_VERBOSITY` to `INFO` or `0`.\n\n"
  "When not changed using the APIs or environment variables, all\n"
  "categories default to vtkLogger::VERBOSITY_TRACE. To change the\n"
  "default used, use `vtkPVLogger::SetDefaultVerbosity`.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVLogger_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsCore.vtkPVLogger", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVLogger_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkPVLogger_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVLogger_Type, PyvtkPVLogger_Methods,
    "vtkPVLogger",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkLogger");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVLogger_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVLogger(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVLogger_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVLogger", o) != 0)
  {
    Py_DECREF(o);
  }

}

