/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtLocation.h"

#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplace.sip"
#include <qplace.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"

#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qlocation.sip"
#include <qlocation.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplacecontactdetail.sip"
#include <qplacecontactdetail.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplaceattribute.sip"
#include <qplaceattribute.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 109 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qurl.sip"
#include <qurl.h>
#line 51 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplacecontent.sip"
#include <qplacecontent.h>
#line 54 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 146 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qmap.sip"
#include <qmap.h>
#line 57 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplaceicon.sip"
#include <qplaceicon.h>
#line 60 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplacesupplier.sip"
#include <qplacesupplier.h>
#line 63 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplaceratings.sip"
#include <qplaceratings.h>
#line 66 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtPositioning/qgeolocation.sip"
#include <qgeolocation.h>
#line 69 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 72 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtLocation/qplacecategory.sip"
#include <qplacecategory.h>
#line 75 "/build/pyqt5/src/PyQt5-5.15.11/build/QtLocation/sipQtLocationQPlace.cpp"


PyDoc_STRVAR(doc_QPlace_categories, "categories(self) -> list[QPlaceCategory]");

extern "C" {static PyObject *meth_QPlace_categories(PyObject *, PyObject *);}
static PyObject *meth_QPlace_categories(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            QList< ::QPlaceCategory>*sipRes;

            sipRes = new QList< ::QPlaceCategory>(sipCpp->categories());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QPlaceCategory, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_categories, doc_QPlace_categories);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setCategory, "setCategory(self, category: QPlaceCategory)");

extern "C" {static PyObject *meth_QPlace_setCategory(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setCategory(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaceCategory* a0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceCategory, &a0))
        {
            sipCpp->setCategory(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setCategory, doc_QPlace_setCategory);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setCategories, "setCategories(self, categories: Iterable[QPlaceCategory])");

extern "C" {static PyObject *meth_QPlace_setCategories(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setCategories(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QList< ::QPlaceCategory>* a0;
        int a0State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QList_0100QPlaceCategory, &a0, &a0State))
        {
            sipCpp->setCategories(*a0);
            sipReleaseType(const_cast<QList< ::QPlaceCategory> *>(a0), sipType_QList_0100QPlaceCategory, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setCategories, doc_QPlace_setCategories);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_location, "location(self) -> QGeoLocation");

extern "C" {static PyObject *meth_QPlace_location(PyObject *, PyObject *);}
static PyObject *meth_QPlace_location(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QGeoLocation*sipRes;

            sipRes = new ::QGeoLocation(sipCpp->location());

            return sipConvertFromNewType(sipRes, sipType_QGeoLocation, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_location, doc_QPlace_location);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setLocation, "setLocation(self, location: QGeoLocation)");

extern "C" {static PyObject *meth_QPlace_setLocation(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setLocation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGeoLocation* a0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPlace, &sipCpp, sipType_QGeoLocation, &a0))
        {
            sipCpp->setLocation(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setLocation, doc_QPlace_setLocation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_ratings, "ratings(self) -> QPlaceRatings");

extern "C" {static PyObject *meth_QPlace_ratings(PyObject *, PyObject *);}
static PyObject *meth_QPlace_ratings(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QPlaceRatings*sipRes;

            sipRes = new ::QPlaceRatings(sipCpp->ratings());

            return sipConvertFromNewType(sipRes, sipType_QPlaceRatings, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_ratings, doc_QPlace_ratings);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setRatings, "setRatings(self, ratings: QPlaceRatings)");

extern "C" {static PyObject *meth_QPlace_setRatings(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setRatings(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaceRatings* a0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceRatings, &a0))
        {
            sipCpp->setRatings(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setRatings, doc_QPlace_setRatings);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_supplier, "supplier(self) -> QPlaceSupplier");

extern "C" {static PyObject *meth_QPlace_supplier(PyObject *, PyObject *);}
static PyObject *meth_QPlace_supplier(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QPlaceSupplier*sipRes;

            sipRes = new ::QPlaceSupplier(sipCpp->supplier());

            return sipConvertFromNewType(sipRes, sipType_QPlaceSupplier, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_supplier, doc_QPlace_supplier);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setSupplier, "setSupplier(self, supplier: QPlaceSupplier)");

extern "C" {static PyObject *meth_QPlace_setSupplier(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setSupplier(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaceSupplier* a0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceSupplier, &a0))
        {
            sipCpp->setSupplier(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setSupplier, doc_QPlace_setSupplier);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_attribution, "attribution(self) -> str");

extern "C" {static PyObject *meth_QPlace_attribution(PyObject *, PyObject *);}
static PyObject *meth_QPlace_attribution(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->attribution());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_attribution, doc_QPlace_attribution);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setAttribution, "setAttribution(self, attribution: Optional[str])");

extern "C" {static PyObject *meth_QPlace_setAttribution(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setAttribution(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setAttribution(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setAttribution, doc_QPlace_setAttribution);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_icon, "icon(self) -> QPlaceIcon");

extern "C" {static PyObject *meth_QPlace_icon(PyObject *, PyObject *);}
static PyObject *meth_QPlace_icon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QPlaceIcon*sipRes;

            sipRes = new ::QPlaceIcon(sipCpp->icon());

            return sipConvertFromNewType(sipRes, sipType_QPlaceIcon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_icon, doc_QPlace_icon);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setIcon, "setIcon(self, icon: QPlaceIcon)");

extern "C" {static PyObject *meth_QPlace_setIcon(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setIcon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlaceIcon* a0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceIcon, &a0))
        {
            sipCpp->setIcon(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setIcon, doc_QPlace_setIcon);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_content, "content(self, type: QPlaceContent.Type) -> dict[int, QPlaceContent]");

extern "C" {static PyObject *meth_QPlace_content(PyObject *, PyObject *);}
static PyObject *meth_QPlace_content(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaceContent::Type a0;
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceContent_Type, &a0))
        {
            ::QPlaceContent::Collection*sipRes;

            sipRes = new ::QPlaceContent::Collection(sipCpp->content(a0));

            return sipConvertFromNewType(sipRes, sipType_QMap_1800_0100QPlaceContent, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_content, doc_QPlace_content);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setContent, "setContent(self, type: QPlaceContent.Type, content: dict[int, QPlaceContent])");

extern "C" {static PyObject *meth_QPlace_setContent(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setContent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaceContent::Type a0;
        const ::QPlaceContent::Collection* a1;
        int a1State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceContent_Type, &a0, sipType_QMap_1800_0100QPlaceContent, &a1, &a1State))
        {
            sipCpp->setContent(a0, *a1);
            sipReleaseType(const_cast< ::QPlaceContent::Collection *>(a1), sipType_QMap_1800_0100QPlaceContent, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setContent, doc_QPlace_setContent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_insertContent, "insertContent(self, type: QPlaceContent.Type, content: dict[int, QPlaceContent])");

extern "C" {static PyObject *meth_QPlace_insertContent(PyObject *, PyObject *);}
static PyObject *meth_QPlace_insertContent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaceContent::Type a0;
        const ::QPlaceContent::Collection* a1;
        int a1State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceContent_Type, &a0, sipType_QMap_1800_0100QPlaceContent, &a1, &a1State))
        {
            sipCpp->insertContent(a0, *a1);
            sipReleaseType(const_cast< ::QPlaceContent::Collection *>(a1), sipType_QMap_1800_0100QPlaceContent, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_insertContent, doc_QPlace_insertContent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_totalContentCount, "totalContentCount(self, type: QPlaceContent.Type) -> int");

extern "C" {static PyObject *meth_QPlace_totalContentCount(PyObject *, PyObject *);}
static PyObject *meth_QPlace_totalContentCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaceContent::Type a0;
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceContent_Type, &a0))
        {
            int sipRes;

            sipRes = sipCpp->totalContentCount(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_totalContentCount, doc_QPlace_totalContentCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setTotalContentCount, "setTotalContentCount(self, type: QPlaceContent.Type, total: int)");

extern "C" {static PyObject *meth_QPlace_setTotalContentCount(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setTotalContentCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPlaceContent::Type a0;
        int a1;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEi", &sipSelf, sipType_QPlace, &sipCpp, sipType_QPlaceContent_Type, &a0, &a1))
        {
            sipCpp->setTotalContentCount(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setTotalContentCount, doc_QPlace_setTotalContentCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_name, "name(self) -> str");

extern "C" {static PyObject *meth_QPlace_name(PyObject *, PyObject *);}
static PyObject *meth_QPlace_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->name());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_name, doc_QPlace_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setName, "setName(self, name: Optional[str])");

extern "C" {static PyObject *meth_QPlace_setName(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setName, doc_QPlace_setName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_placeId, "placeId(self) -> str");

extern "C" {static PyObject *meth_QPlace_placeId(PyObject *, PyObject *);}
static PyObject *meth_QPlace_placeId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->placeId());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_placeId, doc_QPlace_placeId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setPlaceId, "setPlaceId(self, identifier: Optional[str])");

extern "C" {static PyObject *meth_QPlace_setPlaceId(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setPlaceId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setPlaceId(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setPlaceId, doc_QPlace_setPlaceId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_primaryPhone, "primaryPhone(self) -> str");

extern "C" {static PyObject *meth_QPlace_primaryPhone(PyObject *, PyObject *);}
static PyObject *meth_QPlace_primaryPhone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->primaryPhone());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_primaryPhone, doc_QPlace_primaryPhone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_primaryFax, "primaryFax(self) -> str");

extern "C" {static PyObject *meth_QPlace_primaryFax(PyObject *, PyObject *);}
static PyObject *meth_QPlace_primaryFax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->primaryFax());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_primaryFax, doc_QPlace_primaryFax);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_primaryEmail, "primaryEmail(self) -> str");

extern "C" {static PyObject *meth_QPlace_primaryEmail(PyObject *, PyObject *);}
static PyObject *meth_QPlace_primaryEmail(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->primaryEmail());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_primaryEmail, doc_QPlace_primaryEmail);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_primaryWebsite, "primaryWebsite(self) -> QUrl");

extern "C" {static PyObject *meth_QPlace_primaryWebsite(PyObject *, PyObject *);}
static PyObject *meth_QPlace_primaryWebsite(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QUrl*sipRes;

            sipRes = new ::QUrl(sipCpp->primaryWebsite());

            return sipConvertFromNewType(sipRes, sipType_QUrl, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_primaryWebsite, doc_QPlace_primaryWebsite);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_detailsFetched, "detailsFetched(self) -> bool");

extern "C" {static PyObject *meth_QPlace_detailsFetched(PyObject *, PyObject *);}
static PyObject *meth_QPlace_detailsFetched(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->detailsFetched();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_detailsFetched, doc_QPlace_detailsFetched);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setDetailsFetched, "setDetailsFetched(self, fetched: bool)");

extern "C" {static PyObject *meth_QPlace_setDetailsFetched(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setDetailsFetched(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QPlace, &sipCpp, &a0))
        {
            sipCpp->setDetailsFetched(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setDetailsFetched, doc_QPlace_setDetailsFetched);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_extendedAttributeTypes, "extendedAttributeTypes(self) -> list[str]");

extern "C" {static PyObject *meth_QPlace_extendedAttributeTypes(PyObject *, PyObject *);}
static PyObject *meth_QPlace_extendedAttributeTypes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->extendedAttributeTypes());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_extendedAttributeTypes, doc_QPlace_extendedAttributeTypes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_extendedAttribute, "extendedAttribute(self, attributeType: Optional[str]) -> QPlaceAttribute");

extern "C" {static PyObject *meth_QPlace_extendedAttribute(PyObject *, PyObject *);}
static PyObject *meth_QPlace_extendedAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QPlaceAttribute*sipRes;

            sipRes = new ::QPlaceAttribute(sipCpp->extendedAttribute(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QPlaceAttribute, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_extendedAttribute, doc_QPlace_extendedAttribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setExtendedAttribute, "setExtendedAttribute(self, attributeType: Optional[str], attribute: QPlaceAttribute)");

extern "C" {static PyObject *meth_QPlace_setExtendedAttribute(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setExtendedAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QPlaceAttribute* a1;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J9", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State, sipType_QPlaceAttribute, &a1))
        {
            sipCpp->setExtendedAttribute(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setExtendedAttribute, doc_QPlace_setExtendedAttribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_removeExtendedAttribute, "removeExtendedAttribute(self, attributeType: Optional[str])");

extern "C" {static PyObject *meth_QPlace_removeExtendedAttribute(PyObject *, PyObject *);}
static PyObject *meth_QPlace_removeExtendedAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->removeExtendedAttribute(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_removeExtendedAttribute, doc_QPlace_removeExtendedAttribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_contactTypes, "contactTypes(self) -> list[str]");

extern "C" {static PyObject *meth_QPlace_contactTypes(PyObject *, PyObject *);}
static PyObject *meth_QPlace_contactTypes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->contactTypes());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_contactTypes, doc_QPlace_contactTypes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_contactDetails, "contactDetails(self, contactType: Optional[str]) -> list[QPlaceContactDetail]");

extern "C" {static PyObject *meth_QPlace_contactDetails(PyObject *, PyObject *);}
static PyObject *meth_QPlace_contactDetails(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            QList< ::QPlaceContactDetail>*sipRes;

            sipRes = new QList< ::QPlaceContactDetail>(sipCpp->contactDetails(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QList_0100QPlaceContactDetail, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_contactDetails, doc_QPlace_contactDetails);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setContactDetails, "setContactDetails(self, contactType: Optional[str], details: Iterable[QPlaceContactDetail])");

extern "C" {static PyObject *meth_QPlace_setContactDetails(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setContactDetails(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        QList< ::QPlaceContactDetail>* a1;
        int a1State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State, sipType_QList_0100QPlaceContactDetail, &a1, &a1State))
        {
            sipCpp->setContactDetails(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(a1, sipType_QList_0100QPlaceContactDetail, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setContactDetails, doc_QPlace_setContactDetails);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_appendContactDetail, "appendContactDetail(self, contactType: Optional[str], detail: QPlaceContactDetail)");

extern "C" {static PyObject *meth_QPlace_appendContactDetail(PyObject *, PyObject *);}
static PyObject *meth_QPlace_appendContactDetail(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QPlaceContactDetail* a1;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J9", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State, sipType_QPlaceContactDetail, &a1))
        {
            sipCpp->appendContactDetail(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_appendContactDetail, doc_QPlace_appendContactDetail);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_removeContactDetails, "removeContactDetails(self, contactType: Optional[str])");

extern "C" {static PyObject *meth_QPlace_removeContactDetails(PyObject *, PyObject *);}
static PyObject *meth_QPlace_removeContactDetails(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPlace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->removeContactDetails(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_removeContactDetails, doc_QPlace_removeContactDetails);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_visibility, "visibility(self) -> QLocation.Visibility");

extern "C" {static PyObject *meth_QPlace_visibility(PyObject *, PyObject *);}
static PyObject *meth_QPlace_visibility(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            ::QLocation::Visibility sipRes;

            sipRes = sipCpp->visibility();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QLocation_Visibility);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_visibility, doc_QPlace_visibility);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_setVisibility, "setVisibility(self, visibility: QLocation.Visibility)");

extern "C" {static PyObject *meth_QPlace_setVisibility(PyObject *, PyObject *);}
static PyObject *meth_QPlace_setVisibility(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLocation::Visibility a0;
        ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QPlace, &sipCpp, sipType_QLocation_Visibility, &a0))
        {
            sipCpp->setVisibility(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_setVisibility, doc_QPlace_setVisibility);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPlace_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QPlace_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QPlace_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPlace, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPlace, sipName_isEmpty, doc_QPlace_isEmpty);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPlace___ne__(PyObject *, PyObject *);}
static PyObject *slot_QPlace___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlace *sipCpp = reinterpret_cast< ::QPlace *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlace));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlace, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QPlace::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtLocation, ne_slot, sipType_QPlace, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPlace___eq__(PyObject *, PyObject *);}
static PyObject *slot_QPlace___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPlace *sipCpp = reinterpret_cast< ::QPlace *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPlace));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPlace* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPlace, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QPlace::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtLocation, eq_slot, sipType_QPlace, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QPlace(void *, int);}
static void release_QPlace(void *sipCppV, int)
{
    delete reinterpret_cast< ::QPlace *>(sipCppV);
}


extern "C" {static void *array_QPlace(Py_ssize_t);}
static void *array_QPlace(Py_ssize_t sipNrElem)
{
    return new ::QPlace[sipNrElem];
}


extern "C" {static void array_delete_QPlace(void *);}
static void array_delete_QPlace(void *sipCpp)
{
    delete[] reinterpret_cast< ::QPlace *>(sipCpp);
}


extern "C" {static void assign_QPlace(void *, Py_ssize_t, void *);}
static void assign_QPlace(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QPlace *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QPlace *>(sipSrc);
}


extern "C" {static void *copy_QPlace(const void *, Py_ssize_t);}
static void *copy_QPlace(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QPlace(reinterpret_cast<const ::QPlace *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QPlace(sipSimpleWrapper *);}
static void dealloc_QPlace(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QPlace(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QPlace(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QPlace(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QPlace *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QPlace();

            return sipCpp;
        }
    }

    {
        const ::QPlace* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPlace, &a0))
        {
            sipCpp = new ::QPlace(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QPlace[] = {
    {(void *)slot_QPlace___ne__, ne_slot},
    {(void *)slot_QPlace___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QPlace[] = {
    {sipName_appendContactDetail, meth_QPlace_appendContactDetail, METH_VARARGS, doc_QPlace_appendContactDetail},
    {sipName_attribution, meth_QPlace_attribution, METH_VARARGS, doc_QPlace_attribution},
    {sipName_categories, meth_QPlace_categories, METH_VARARGS, doc_QPlace_categories},
    {sipName_contactDetails, meth_QPlace_contactDetails, METH_VARARGS, doc_QPlace_contactDetails},
    {sipName_contactTypes, meth_QPlace_contactTypes, METH_VARARGS, doc_QPlace_contactTypes},
    {sipName_content, meth_QPlace_content, METH_VARARGS, doc_QPlace_content},
    {sipName_detailsFetched, meth_QPlace_detailsFetched, METH_VARARGS, doc_QPlace_detailsFetched},
    {sipName_extendedAttribute, meth_QPlace_extendedAttribute, METH_VARARGS, doc_QPlace_extendedAttribute},
    {sipName_extendedAttributeTypes, meth_QPlace_extendedAttributeTypes, METH_VARARGS, doc_QPlace_extendedAttributeTypes},
    {sipName_icon, meth_QPlace_icon, METH_VARARGS, doc_QPlace_icon},
    {sipName_insertContent, meth_QPlace_insertContent, METH_VARARGS, doc_QPlace_insertContent},
    {sipName_isEmpty, meth_QPlace_isEmpty, METH_VARARGS, doc_QPlace_isEmpty},
    {sipName_location, meth_QPlace_location, METH_VARARGS, doc_QPlace_location},
    {sipName_name, meth_QPlace_name, METH_VARARGS, doc_QPlace_name},
    {sipName_placeId, meth_QPlace_placeId, METH_VARARGS, doc_QPlace_placeId},
    {sipName_primaryEmail, meth_QPlace_primaryEmail, METH_VARARGS, doc_QPlace_primaryEmail},
    {sipName_primaryFax, meth_QPlace_primaryFax, METH_VARARGS, doc_QPlace_primaryFax},
    {sipName_primaryPhone, meth_QPlace_primaryPhone, METH_VARARGS, doc_QPlace_primaryPhone},
    {sipName_primaryWebsite, meth_QPlace_primaryWebsite, METH_VARARGS, doc_QPlace_primaryWebsite},
    {sipName_ratings, meth_QPlace_ratings, METH_VARARGS, doc_QPlace_ratings},
    {sipName_removeContactDetails, meth_QPlace_removeContactDetails, METH_VARARGS, doc_QPlace_removeContactDetails},
    {sipName_removeExtendedAttribute, meth_QPlace_removeExtendedAttribute, METH_VARARGS, doc_QPlace_removeExtendedAttribute},
    {sipName_setAttribution, meth_QPlace_setAttribution, METH_VARARGS, doc_QPlace_setAttribution},
    {sipName_setCategories, meth_QPlace_setCategories, METH_VARARGS, doc_QPlace_setCategories},
    {sipName_setCategory, meth_QPlace_setCategory, METH_VARARGS, doc_QPlace_setCategory},
    {sipName_setContactDetails, meth_QPlace_setContactDetails, METH_VARARGS, doc_QPlace_setContactDetails},
    {sipName_setContent, meth_QPlace_setContent, METH_VARARGS, doc_QPlace_setContent},
    {sipName_setDetailsFetched, meth_QPlace_setDetailsFetched, METH_VARARGS, doc_QPlace_setDetailsFetched},
    {sipName_setExtendedAttribute, meth_QPlace_setExtendedAttribute, METH_VARARGS, doc_QPlace_setExtendedAttribute},
    {sipName_setIcon, meth_QPlace_setIcon, METH_VARARGS, doc_QPlace_setIcon},
    {sipName_setLocation, meth_QPlace_setLocation, METH_VARARGS, doc_QPlace_setLocation},
    {sipName_setName, meth_QPlace_setName, METH_VARARGS, doc_QPlace_setName},
    {sipName_setPlaceId, meth_QPlace_setPlaceId, METH_VARARGS, doc_QPlace_setPlaceId},
    {sipName_setRatings, meth_QPlace_setRatings, METH_VARARGS, doc_QPlace_setRatings},
    {sipName_setSupplier, meth_QPlace_setSupplier, METH_VARARGS, doc_QPlace_setSupplier},
    {sipName_setTotalContentCount, meth_QPlace_setTotalContentCount, METH_VARARGS, doc_QPlace_setTotalContentCount},
    {sipName_setVisibility, meth_QPlace_setVisibility, METH_VARARGS, doc_QPlace_setVisibility},
    {sipName_supplier, meth_QPlace_supplier, METH_VARARGS, doc_QPlace_supplier},
    {sipName_totalContentCount, meth_QPlace_totalContentCount, METH_VARARGS, doc_QPlace_totalContentCount},
    {sipName_visibility, meth_QPlace_visibility, METH_VARARGS, doc_QPlace_visibility}
};

PyDoc_STRVAR(doc_QPlace, "\1QPlace()\n"
"QPlace(other: QPlace)");


static pyqt5ClassPluginDef plugin_QPlace = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtLocation_QPlace = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QPlace,
        SIP_NULLPTR,
        &plugin_QPlace,
    },
    {
        sipNameNr_QPlace,
        {0, 0, 1},
        40, methods_QPlace,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QPlace,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QPlace,
    init_type_QPlace,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QPlace,
    assign_QPlace,
    array_QPlace,
    copy_QPlace,
    release_QPlace,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QPlace,
    sizeof (::QPlace),
};
