// ----------------------------------------------------------------------------
//
//  Copyright (C) 2021 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __FADER2_H
#define __FADER2_H


#include <stdint.h>


class Fader2chan
{
private:

    friend class Fader2;

    Fader2chan (void);

    enum { MININF, FADING, STATIC };

    void prepare (int fragm, float gain, bool mute);
    void process (int n, float *inp, float *out);
    
    bool              _mute;
    int               _state;
    float             _g0;    // User requested gain.
    float             _g1;    // Target gain in current fragment.
    float             _g, _d; // Current gain and per sample delta.
};


class Fader2
{
public:

    Fader2 (int nchan, int fsamp);
    ~Fader2 (void);
    
    void setgain (int chan, float gdb);
    void setmute (int chan, bool mute);
    void process (int nframes, float *inp[], float *out[]);

private:

    int               _nchan;
    int               _fragm;  // Number of frames per 10 ms fragment.
    int               _count;  // Remaining frames in current fragment.
    bool              _mute;   // Master mute.
    float             _gain;   // Master gain.
    Fader2chan       *_procs;
};


#endif
