// ----------------------------------------------------------------------------
//
//  Copyright (C) 2010-2018 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JAMBPAN_H
#define __JAMBPAN_H


#include <zita-jclient.h>
#include "ambpan8.h"


class Jambpan : public Jclient
{
public:

    enum
    {
        MAXDEGR = Ambpan8::MAXDEGR, 
        MAXHARM = Ambpan8::MAXHARM,
        MAXINP = 100,
    };

    Jambpan (const char *client_name, const char *server_name,
             int degree, int ninput);
    virtual ~Jambpan (void);

    void set_direction (int inp, float az, float el, float dt);
    
private:
    
    int jack_process (int nframes);

    Ambpan8  *_ambpan [MAXINP];
};


#endif
