// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-blink.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-blink.h"
#include "services/viz/public/mojom/compositing/layer_context.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-blink.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-blink.h"
#include "services/viz/public/mojom/compositing/thread.mojom-blink-forward.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {

class CompositorFrameSinkProxy;

template <typename ImplRefTraits>
class CompositorFrameSinkStub;

class CompositorFrameSinkRequestValidator;
class CompositorFrameSinkResponseValidator;


class BLINK_PLATFORM_EXPORT CompositorFrameSink
    : public CompositorFrameSinkInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    2057629369
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CompositorFrameSinkInterfaceBase;
  using Proxy_ = CompositorFrameSinkProxy;

  template <typename ImplRefTraits>
  using Stub_ = CompositorFrameSinkStub<ImplRefTraits>;

  using RequestValidator_ = CompositorFrameSinkRequestValidator;
  using ResponseValidator_ = CompositorFrameSinkResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetNeedsBeginFrameMinVersion = 0,
    kSetWantsAnimateOnlyBeginFramesMinVersion = 0,
    kSetWantsBeginFrameAcksMinVersion = 0,
    kSetAutoNeedsBeginFrameMinVersion = 0,
    kSubmitCompositorFrameMinVersion = 0,
    kSubmitCompositorFrameSyncMinVersion = 0,
    kDidNotProduceFrameMinVersion = 0,
    kInitializeCompositorFrameSinkTypeMinVersion = 0,
    kBindLayerContextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetNeedsBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWantsAnimateOnlyBeginFrames_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWantsBeginFrameAcks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAutoNeedsBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitCompositorFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitCompositorFrameSync_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidNotProduceFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitializeCompositorFrameSinkType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindLayerContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CompositorFrameSink() = default;

  
  virtual void SetNeedsBeginFrame(bool needs_begin_frame) = 0;

  
  virtual void SetWantsAnimateOnlyBeginFrames() = 0;

  
  virtual void SetWantsBeginFrameAcks() = 0;

  
  virtual void SetAutoNeedsBeginFrame() = 0;

  
  virtual void SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, WTF::Vector<::viz::ReturnedResource>* out_resources);

  using SubmitCompositorFrameSyncCallback = base::OnceCallback<void(WTF::Vector<::viz::ReturnedResource>)>;
  
  virtual void SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, SubmitCompositorFrameSyncCallback callback) = 0;

  
  virtual void DidNotProduceFrame(const ::viz::BeginFrameAck& ack) = 0;

  
  virtual void InitializeCompositorFrameSinkType(CompositorFrameSinkType type) = 0;

  
  virtual void BindLayerContext(::viz::mojom::blink::PendingLayerContextPtr context) = 0;
};

class CompositorFrameSinkClientProxy;

template <typename ImplRefTraits>
class CompositorFrameSinkClientStub;

class CompositorFrameSinkClientRequestValidator;


class BLINK_PLATFORM_EXPORT CompositorFrameSinkClient
    : public CompositorFrameSinkClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CompositorFrameSinkClientInterfaceBase;
  using Proxy_ = CompositorFrameSinkClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CompositorFrameSinkClientStub<ImplRefTraits>;

  using RequestValidator_ = CompositorFrameSinkClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReceiveCompositorFrameAckMinVersion = 0,
    kOnBeginFrameMinVersion = 0,
    kOnBeginFramePausedChangedMinVersion = 0,
    kReclaimResourcesMinVersion = 0,
    kOnCompositorFrameTransitionDirectiveProcessedMinVersion = 0,
    kOnSurfaceEvictedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidReceiveCompositorFrameAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBeginFramePausedChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReclaimResources_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCompositorFrameTransitionDirectiveProcessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSurfaceEvicted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CompositorFrameSinkClient() = default;

  
  virtual void DidReceiveCompositorFrameAck(WTF::Vector<::viz::ReturnedResource> resources) = 0;

  
  virtual void OnBeginFrame(const ::viz::BeginFrameArgs& args, const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>& details, bool frame_ack, WTF::Vector<::viz::ReturnedResource> resources) = 0;

  
  virtual void OnBeginFramePausedChanged(bool paused) = 0;

  
  virtual void ReclaimResources(WTF::Vector<::viz::ReturnedResource> resources) = 0;

  
  virtual void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) = 0;

  
  virtual void OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) = 0;
};



class BLINK_PLATFORM_EXPORT CompositorFrameSinkProxy
    : public CompositorFrameSink {
 public:
  using InterfaceType = CompositorFrameSink;

  explicit CompositorFrameSinkProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetNeedsBeginFrame(bool needs_begin_frame) final;
  
  void SetWantsAnimateOnlyBeginFrames() final;
  
  void SetWantsBeginFrameAcks() final;
  
  void SetAutoNeedsBeginFrame() final;
  
  void SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) final;
  
  bool SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, WTF::Vector<::viz::ReturnedResource>* out_resources) final;
  
  void SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, std::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, SubmitCompositorFrameSyncCallback callback) final;
  
  void DidNotProduceFrame(const ::viz::BeginFrameAck& ack) final;
  
  void InitializeCompositorFrameSinkType(CompositorFrameSinkType type) final;
  
  void BindLayerContext(::viz::mojom::blink::PendingLayerContextPtr context) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
  mojo::internal::MessageSizeEstimator size_estimator_;
};



class BLINK_PLATFORM_EXPORT CompositorFrameSinkClientProxy
    : public CompositorFrameSinkClient {
 public:
  using InterfaceType = CompositorFrameSinkClient;

  explicit CompositorFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReceiveCompositorFrameAck(WTF::Vector<::viz::ReturnedResource> resources) final;
  
  void OnBeginFrame(const ::viz::BeginFrameArgs& args, const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>& details, bool frame_ack, WTF::Vector<::viz::ReturnedResource> resources) final;
  
  void OnBeginFramePausedChanged(bool paused) final;
  
  void ReclaimResources(WTF::Vector<::viz::ReturnedResource> resources) final;
  
  void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) final;
  
  void OnSurfaceEvicted(const ::viz::LocalSurfaceId& local_surface_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CompositorFrameSinkStubDispatch {
 public:
  static bool Accept(CompositorFrameSink* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CompositorFrameSink* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CompositorFrameSink>>
class CompositorFrameSinkStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CompositorFrameSinkStub() = default;
  ~CompositorFrameSinkStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CompositorFrameSinkClientStubDispatch {
 public:
  static bool Accept(CompositorFrameSinkClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CompositorFrameSinkClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CompositorFrameSinkClient>>
class CompositorFrameSinkClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CompositorFrameSinkClientStub() = default;
  ~CompositorFrameSinkClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CompositorFrameSinkClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CompositorFrameSinkRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CompositorFrameSinkClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CompositorFrameSinkResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_BLINK_H_