// ui/accessibility/mojom/ax_tree_update.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"
#include "ui/accessibility/mojom/ax_node_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_checks.mojom-shared.h"







namespace ax::mojom {
class AXTreeUpdateDataView;



}  // ax::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXTreeUpdateDataView> {
  using Data = ::ax::mojom::internal::AXTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXTreeUpdateDataView {
 public:
  AXTreeUpdateDataView() = default;

  AXTreeUpdateDataView(
      internal::AXTreeUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool has_tree_data() const {
    return data_->has_tree_data;
  }
  inline void GetTreeDataDataView(
      ::ax::mojom::AXTreeDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTreeData(UserType* output) {
    
    auto* pointer = data_->tree_data.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXTreeDataDataView>(
        pointer, output, message_);
  }
  int32_t node_id_to_clear() const {
    return data_->node_id_to_clear;
  }
  int32_t root_id() const {
    return data_->root_id;
  }
  inline void GetNodesDataView(
      mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodes(UserType* output) {
    
    auto* pointer = data_->nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventFrom(UserType* output) const {
    auto data_value = data_->event_from;
    return mojo::internal::Deserialize<::ax::mojom::EventFrom>(
        data_value, output);
  }
  ::ax::mojom::EventFrom event_from() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::EventFrom>(data_->event_from));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventFromAction(UserType* output) const {
    auto data_value = data_->event_from_action;
    return mojo::internal::Deserialize<::ax::mojom::Action>(
        data_value, output);
  }
  ::ax::mojom::Action event_from_action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Action>(data_->event_from_action));
  }
  inline void GetEventIntentsDataView(
      mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventIntents(UserType* output) {
    
    auto* pointer = data_->event_intents.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        pointer, output, message_);
  }
  inline void GetTreeChecksDataView(
      ::ax::mojom::AXTreeChecksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTreeChecks(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ax::mojom::AXTreeChecksDataView, UserType>(),
    "Attempting to read the optional `tree_checks` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTreeChecks` instead "
    "of `ReadTreeChecks if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->tree_checks.Get() : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeChecksDataView>(
        pointer, output, message_);
  }
 private:
  internal::AXTreeUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXTreeUpdateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXTreeUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->has_tree_data = Traits::has_tree_data(input);
    decltype(Traits::tree_data(input)) in_tree_data = Traits::tree_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tree_data)::BaseType> tree_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::ax::mojom::AXTreeDataDataView>(
        in_tree_data, tree_data_fragment);
    fragment->tree_data.Set(
        tree_data_fragment.is_null() ? nullptr : tree_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tree_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tree_data in AXTreeUpdate struct");
    fragment->node_id_to_clear = Traits::node_id_to_clear(input);
    fragment->root_id = Traits::root_id(input);
    decltype(Traits::nodes(input)) in_nodes = Traits::nodes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nodes)::BaseType>
        nodes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& nodes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>>(
        in_nodes, nodes_fragment, &nodes_validate_params);
    fragment->nodes.Set(
        nodes_fragment.is_null() ? nullptr : nodes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->nodes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nodes in AXTreeUpdate struct");
    mojo::internal::Serialize<::ax::mojom::EventFrom>(
        Traits::event_from(input), &fragment->event_from);
    mojo::internal::Serialize<::ax::mojom::Action>(
        Traits::event_from_action(input), &fragment->event_from_action);
    decltype(Traits::event_intents(input)) in_event_intents = Traits::event_intents(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_intents)::BaseType>
        event_intents_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& event_intents_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        in_event_intents, event_intents_fragment, &event_intents_validate_params);
    fragment->event_intents.Set(
        event_intents_fragment.is_null() ? nullptr : event_intents_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->event_intents.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_intents in AXTreeUpdate struct");
    decltype(Traits::tree_checks(input)) in_tree_checks = Traits::tree_checks(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tree_checks)::BaseType> tree_checks_fragment(
            fragment.message());
    mojo::internal::Serialize<::ax::mojom::AXTreeChecksDataView>(
        in_tree_checks, tree_checks_fragment);
    fragment->tree_checks.Set(
        tree_checks_fragment.is_null() ? nullptr : tree_checks_fragment.data());
  }

  static bool Deserialize(::ax::mojom::internal::AXTreeUpdate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXTreeUpdateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {

inline void AXTreeUpdateDataView::GetTreeDataDataView(
    ::ax::mojom::AXTreeDataDataView* output) {
  auto pointer = data_->tree_data.Get();
  *output = ::ax::mojom::AXTreeDataDataView(pointer, message_);
}
inline void AXTreeUpdateDataView::GetNodesDataView(
    mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>* output) {
  auto pointer = data_->nodes.Get();
  *output = mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>(pointer, message_);
}
inline void AXTreeUpdateDataView::GetEventIntentsDataView(
    mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output) {
  auto pointer = data_->event_intents.Get();
  *output = mojo::ArrayDataView<::ax::mojom::EventIntentDataView>(pointer, message_);
}
inline void AXTreeUpdateDataView::GetTreeChecksDataView(
    ::ax::mojom::AXTreeChecksDataView* output) {
  auto pointer = data_->header_.version >= 2
                 ? data_->tree_checks.Get() : nullptr;
  *output = ::ax::mojom::AXTreeChecksDataView(pointer, message_);
}



}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SHARED_H_