/* rygel-audio-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-audio-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_AUDIO_ITEM_0_PROPERTY,
	RYGEL_AUDIO_ITEM_DURATION_PROPERTY,
	RYGEL_AUDIO_ITEM_BITRATE_PROPERTY,
	RYGEL_AUDIO_ITEM_SAMPLE_FREQ_PROPERTY,
	RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE_PROPERTY,
	RYGEL_AUDIO_ITEM_CHANNELS_PROPERTY,
	RYGEL_AUDIO_ITEM_ALBUM_PROPERTY,
	RYGEL_AUDIO_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_audio_item_properties[RYGEL_AUDIO_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelAudioItemPrivate {
	glong _duration;
	gint _bitrate;
	gint _sample_freq;
	gint _bits_per_sample;
	gint _channels;
	gchar* _album;
};

static gint RygelAudioItem_private_offset;
static gpointer rygel_audio_item_parent_class = NULL;

VALA_EXTERN void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
VALA_EXTERN gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
static void rygel_audio_item_real_apply_didl_lite (RygelMediaObject* base,
                                            GUPnPDIDLLiteObject* didl_object);
static gint rygel_audio_item_real_compare_by_property (RygelMediaObject* base,
                                                RygelMediaObject* media_object,
                                                const gchar* property);
static GUPnPDIDLLiteObject* rygel_audio_item_real_serialize (RygelMediaObject* base,
                                                      RygelSerializer* serializer,
                                                      RygelHTTPServer* http_server,
                                                      GError** error);
static RygelMediaResource* rygel_audio_item_real_get_primary_resource (RygelMediaFileItem* base);
static void rygel_audio_item_finalize (GObject * obj);
static GType rygel_audio_item_get_type_once (void);
static void _vala_rygel_audio_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_rygel_audio_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
rygel_audio_item_get_instance_private (RygelAudioItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelAudioItem_private_offset);
}

RygelAudioItem*
rygel_audio_item_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            const gchar* upnp_class)
{
	RygelAudioItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelAudioItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelAudioItem*
rygel_audio_item_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      const gchar* upnp_class)
{
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM, id, parent, title, upnp_class);
}

static void
rygel_audio_item_real_apply_didl_lite (RygelMediaObject* base,
                                       GUPnPDIDLLiteObject* didl_object)
{
	RygelAudioItem * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (RygelAudioItem*) base;
	g_return_if_fail (didl_object != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), didl_object);
	_tmp0_ = gupnp_didl_lite_object_get_album (didl_object);
	_tmp1_ = _tmp0_;
	rygel_audio_item_set_album (self, _tmp1_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
rygel_audio_item_real_compare_by_property (RygelMediaObject* base,
                                           RygelMediaObject* media_object,
                                           const gchar* property)
{
	RygelAudioItem * self;
	RygelAudioItem* item = NULL;
	RygelAudioItem* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	gint result;
	self = (RygelAudioItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	if (!RYGEL_IS_AUDIO_ITEM (media_object)) {
		result = 1;
		return result;
	}
	_tmp0_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (media_object) ? ((RygelAudioItem*) media_object) : NULL);
	item = _tmp0_;
	_tmp1_ = property;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelAudioItem* _tmp5_;
				const gchar* _tmp6_;
				_tmp4_ = self->priv->_album;
				_tmp5_ = item;
				_tmp6_ = _tmp5_->priv->_album;
				result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp4_, _tmp6_);
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelAudioItem* _tmp7_;
				_tmp7_ = item;
				result = RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), (RygelMediaObject*) _tmp7_, property);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
}

static GUPnPDIDLLiteObject*
rygel_audio_item_real_serialize (RygelMediaObject* base,
                                 RygelSerializer* serializer,
                                 RygelHTTPServer* http_server,
                                 GError** error)
{
	RygelAudioItem * self;
	GUPnPDIDLLiteObject* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	GUPnPDIDLLiteObject* result;
	self = (RygelAudioItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), serializer, http_server, &_inner_error0_);
	didl_item = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = self->priv->_album;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_album;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_album;
		gupnp_didl_lite_object_set_album (didl_item, _tmp4_);
	}
	result = didl_item;
	return result;
}

static RygelMediaResource*
rygel_audio_item_real_get_primary_resource (RygelMediaFileItem* base)
{
	RygelAudioItem * self;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_;
	glong _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GUPnPDLNAFlags _tmp6_;
	GUPnPDLNAFlags _tmp7_;
	RygelMediaResource* result;
	self = (RygelAudioItem*) base;
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_audio_item_parent_class)->get_primary_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
	res = _tmp0_;
	_tmp1_ = self->priv->_duration;
	rygel_media_resource_set_duration (res, _tmp1_);
	_tmp2_ = self->priv->_bitrate;
	rygel_media_resource_set_bitrate (res, _tmp2_);
	_tmp3_ = self->priv->_sample_freq;
	rygel_media_resource_set_sample_freq (res, _tmp3_);
	_tmp4_ = self->priv->_bits_per_sample;
	rygel_media_resource_set_bits_per_sample (res, _tmp4_);
	_tmp5_ = self->priv->_channels;
	rygel_media_resource_set_audio_channels (res, _tmp5_);
	_tmp6_ = rygel_media_resource_get_dlna_flags (res);
	_tmp7_ = _tmp6_;
	rygel_media_resource_set_dlna_flags (res, _tmp7_ | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	result = res;
	return result;
}

glong
rygel_audio_item_get_duration (RygelAudioItem* self)
{
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = self->priv->_duration;
	return result;
}

void
rygel_audio_item_set_duration (RygelAudioItem* self,
                               glong value)
{
	glong old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_audio_item_get_duration (self);
	if (old_value != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_DURATION_PROPERTY]);
	}
}

gint
rygel_audio_item_get_bitrate (RygelAudioItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_bitrate;
	return result;
}

void
rygel_audio_item_set_bitrate (RygelAudioItem* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_audio_item_get_bitrate (self);
	if (old_value != value) {
		self->priv->_bitrate = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_BITRATE_PROPERTY]);
	}
}

gint
rygel_audio_item_get_sample_freq (RygelAudioItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sample_freq;
	return result;
}

void
rygel_audio_item_set_sample_freq (RygelAudioItem* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_audio_item_get_sample_freq (self);
	if (old_value != value) {
		self->priv->_sample_freq = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_SAMPLE_FREQ_PROPERTY]);
	}
}

gint
rygel_audio_item_get_bits_per_sample (RygelAudioItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_bits_per_sample;
	return result;
}

void
rygel_audio_item_set_bits_per_sample (RygelAudioItem* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_audio_item_get_bits_per_sample (self);
	if (old_value != value) {
		self->priv->_bits_per_sample = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE_PROPERTY]);
	}
}

gint
rygel_audio_item_get_channels (RygelAudioItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_channels;
	return result;
}

void
rygel_audio_item_set_channels (RygelAudioItem* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_audio_item_get_channels (self);
	if (old_value != value) {
		self->priv->_channels = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_CHANNELS_PROPERTY]);
	}
}

const gchar*
rygel_audio_item_get_album (RygelAudioItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_album;
	result = _tmp0_;
	return result;
}

void
rygel_audio_item_set_album (RygelAudioItem* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_audio_item_get_album (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_album);
		self->priv->_album = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_ALBUM_PROPERTY]);
	}
}

static void
rygel_audio_item_class_init (RygelAudioItemClass * klass,
                             gpointer klass_data)
{
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelAudioItem_private_offset);
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject*, GUPnPDIDLLiteObject*)) rygel_audio_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->compare_by_property = (gint (*) (RygelMediaObject*, RygelMediaObject*, const gchar*)) rygel_audio_item_real_compare_by_property;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_audio_item_real_serialize;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = (RygelMediaResource* (*) (RygelMediaFileItem*)) rygel_audio_item_real_get_primary_resource;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_audio_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_audio_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
	/**
	     * The duration of the source content (this.uri) in seconds.
	     * A value of -1 means the duration is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_DURATION_PROPERTY, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_DURATION_PROPERTY] = g_param_spec_long ("duration", "duration", "duration", G_MINLONG, G_MAXLONG, (glong) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The bitrate of the source content (this.uri) in bytes/second.
	     * A value of -1 means the bitrate is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_BITRATE_PROPERTY, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_BITRATE_PROPERTY] = g_param_spec_int ("bitrate", "bitrate", "bitrate", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The sample frequency of the source content (this.uri) in Hz.
	     * A value of -1 means the sample frequency is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_SAMPLE_FREQ_PROPERTY, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_SAMPLE_FREQ_PROPERTY] = g_param_spec_int ("sample-freq", "sample-freq", "sample-freq", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The bits per sample of the source content (this.uri).
	     * A value of -1 means the bits per sample is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE_PROPERTY, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE_PROPERTY] = g_param_spec_int ("bits-per-sample", "bits-per-sample", "bits-per-sample", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of audio channels in the source content (this.uri).
	     * A value of -1 means the number of channels is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_CHANNELS_PROPERTY, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_CHANNELS_PROPERTY] = g_param_spec_int ("channels", "channels", "channels", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_ALBUM_PROPERTY, rygel_audio_item_properties[RYGEL_AUDIO_ITEM_ALBUM_PROPERTY] = g_param_spec_string ("album", "album", "album", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_audio_item_instance_init (RygelAudioItem * self,
                                gpointer klass)
{
	self->priv = rygel_audio_item_get_instance_private (self);
	self->priv->_duration = (glong) -1;
	self->priv->_bitrate = -1;
	self->priv->_sample_freq = -1;
	self->priv->_bits_per_sample = -1;
	self->priv->_channels = -1;
}

static void
rygel_audio_item_finalize (GObject * obj)
{
	RygelAudioItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
	_g_free0 (self->priv->_album);
	G_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
}

/**
 * Represents an audio item contained in a file.
 */
 G_GNUC_NO_INLINE static GType
rygel_audio_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
	GType rygel_audio_item_type_id;
	rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_FILE_ITEM, "RygelAudioItem", &g_define_type_info, 0);
	RygelAudioItem_private_offset = g_type_add_instance_private (rygel_audio_item_type_id, sizeof (RygelAudioItemPrivate));
	return rygel_audio_item_type_id;
}

GType
rygel_audio_item_get_type (void)
{
	static volatile gsize rygel_audio_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__once)) {
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = rygel_audio_item_get_type_once ();
		g_once_init_leave (&rygel_audio_item_type_id__once, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__once;
}

static void
_vala_rygel_audio_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	RygelAudioItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
	switch (property_id) {
		case RYGEL_AUDIO_ITEM_DURATION_PROPERTY:
		g_value_set_long (value, rygel_audio_item_get_duration (self));
		break;
		case RYGEL_AUDIO_ITEM_BITRATE_PROPERTY:
		g_value_set_int (value, rygel_audio_item_get_bitrate (self));
		break;
		case RYGEL_AUDIO_ITEM_SAMPLE_FREQ_PROPERTY:
		g_value_set_int (value, rygel_audio_item_get_sample_freq (self));
		break;
		case RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE_PROPERTY:
		g_value_set_int (value, rygel_audio_item_get_bits_per_sample (self));
		break;
		case RYGEL_AUDIO_ITEM_CHANNELS_PROPERTY:
		g_value_set_int (value, rygel_audio_item_get_channels (self));
		break;
		case RYGEL_AUDIO_ITEM_ALBUM_PROPERTY:
		g_value_set_string (value, rygel_audio_item_get_album (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_audio_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	RygelAudioItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
	switch (property_id) {
		case RYGEL_AUDIO_ITEM_DURATION_PROPERTY:
		rygel_audio_item_set_duration (self, g_value_get_long (value));
		break;
		case RYGEL_AUDIO_ITEM_BITRATE_PROPERTY:
		rygel_audio_item_set_bitrate (self, g_value_get_int (value));
		break;
		case RYGEL_AUDIO_ITEM_SAMPLE_FREQ_PROPERTY:
		rygel_audio_item_set_sample_freq (self, g_value_get_int (value));
		break;
		case RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE_PROPERTY:
		rygel_audio_item_set_bits_per_sample (self, g_value_get_int (value));
		break;
		case RYGEL_AUDIO_ITEM_CHANNELS_PROPERTY:
		rygel_audio_item_set_channels (self, g_value_get_int (value));
		break;
		case RYGEL_AUDIO_ITEM_ALBUM_PROPERTY:
		rygel_audio_item_set_album (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

