/* rygel-av-transport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Neha Shanbhag <N.Shanbhag@cablelabs.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <libgupnp/gupnp.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-renderer.h"
#include "config.h"
#include <errno.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:AVTransport:1"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;
enum  {
	RYGEL_AV_TRANSPORT_0_PROPERTY,
	RYGEL_AV_TRANSPORT_STATUS_PROPERTY,
	RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM_PROPERTY,
	RYGEL_AV_TRANSPORT_POSSIBLE_PLAYBACK_MEDIA_PROPERTY,
	RYGEL_AV_TRANSPORT_SPEED_PROPERTY,
	RYGEL_AV_TRANSPORT_NUM_PROPERTIES
};
static GParamSpec* rygel_av_transport_properties[RYGEL_AV_TRANSPORT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelAvTransportHandlePlaylistData RygelAvTransportHandlePlaylistData;
typedef struct _RygelAvTransportHandleNewTransportUriData RygelAvTransportHandleNewTransportUriData;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelAVTransportPrivate {
	SoupSession* session;
	gchar* protocol_info;
	gchar* _status;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
	RygelPlayerController* controller;
};

struct _RygelAvTransportHandlePlaylistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	gchar* uri;
	gchar* metadata;
	gchar* mime;
	gchar* features;
	SoupMessage* message;
	SoupMessage* _tmp0_;
	GBytes* body;
	GBytes* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	GBytes* _tmp4_;
	GBytes* _tmp5_;
	SoupMessage* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	gchar* content_type;
	SoupMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GUPnPMediaCollection* collection;
	const gchar* _tmp14_;
	GUPnPMediaCollection* _tmp15_;
	GBytes* _tmp16_;
	GUPnPMediaCollection* _tmp17_;
	GUPnPMediaCollection* _tmp18_;
	GError* _error_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	const gchar* xml_string;
	GBytes* _tmp21_;
	gsize _tmp22_;
	guint8* _tmp23_;
	const gchar* _tmp24_;
	GUPnPMediaCollection* _tmp25_;
	GUPnPMediaCollection* _tmp26_;
	GList* _tmp27_;
	GList* _tmp28_;
	gboolean _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GQuark _tmp33_;
	RygelPlayerController* _tmp34_;
	GUPnPMediaCollection* _tmp35_;
	RygelPlayerController* _tmp36_;
	GUPnPMediaCollection* _tmp37_;
	GError* _inner_error0_;
};

struct _RygelAvTransportHandleNewTransportUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	gchar* uri;
	gchar* metadata;
	gboolean _tmp0_;
	gchar* new_uri;
	GUPnPContext* _tmp1_;
	GUPnPContext* _tmp2_;
	gchar* _tmp3_;
	SoupMessage* message;
	const gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessageHeaders* _tmp7_;
	SoupMessageHeaders* _tmp8_;
	SoupMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	SoupSession* _tmp12_;
	SoupMessage* _tmp13_;
	GInputStream* _tmp14_;
	GInputStream* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	SoupMessage* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	SoupMessage* _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	SoupMessage* _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	SoupMessage* _tmp27_;
	SoupSession* _tmp28_;
	SoupMessage* _tmp29_;
	GInputStream* _tmp30_;
	GInputStream* _tmp31_;
	SoupMessage* _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	SoupMessage* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* mime;
	SoupMessage* _tmp38_;
	SoupMessageHeaders* _tmp39_;
	SoupMessageHeaders* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* features;
	SoupMessage* _tmp43_;
	SoupMessageHeaders* _tmp44_;
	SoupMessageHeaders* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gboolean _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	SoupMessage* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	GError* _inner_error0_;
};

static gint RygelAVTransport_private_offset;
static gpointer rygel_av_transport_parent_class = NULL;

VALA_EXTERN GType rygel_av_transport_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_change_log_get_type (void) G_GNUC_CONST ;
static void rygel_av_transport_real_constructed (GObject* base);
VALA_EXTERN RygelChangeLog* rygel_change_log_new (GUPnPService* service,
                                      const gchar* service_ns);
VALA_EXTERN RygelChangeLog* rygel_change_log_construct (GType object_type,
                                            GUPnPService* service,
                                            const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
VALA_EXTERN RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self,
                                              GUPnPService* service,
                                              const gchar* variable,
                                              GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                            const gchar* variable,
                                                                            GValue* value,
                                                                            gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self,
                                                 GUPnPService* service,
                                                 GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                               GUPnPServiceAction* action,
                                                                               gpointer self);
static void rygel_av_transport_set_next_av_transport_uri_cb (RygelAVTransport* self,
                                                      GUPnPService* service,
                                                      GUPnPServiceAction* action);
static void _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                    GUPnPServiceAction* action,
                                                                                    gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self,
                                           GUPnPService* service,
                                           GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                         GUPnPServiceAction* action,
                                                                         gpointer self);
static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self,
                                              GUPnPService* service,
                                              GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                            GUPnPServiceAction* action,
                                                                            gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self,
                                               GUPnPService* service,
                                               GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                             GUPnPServiceAction* action,
                                                                             gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self,
                                              GUPnPService* service,
                                              GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                            GUPnPServiceAction* action,
                                                                            gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self,
                                                    GUPnPService* service,
                                                    GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                  GUPnPServiceAction* action,
                                                                                  gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self,
                                                   GUPnPService* service,
                                                   GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                 GUPnPServiceAction* action,
                                                                                 gpointer self);
static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self,
                                                  GUPnPService* service,
                                                  GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                GUPnPServiceAction* action,
                                                                                gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self,
                                 GUPnPService* service,
                                 GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                               GUPnPServiceAction* action,
                                                               gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self,
                                 GUPnPService* service,
                                 GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                               GUPnPServiceAction* action,
                                                               gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self,
                                  GUPnPService* service,
                                  GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                GUPnPServiceAction* action,
                                                                gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self,
                                 GUPnPService* service,
                                 GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                               GUPnPServiceAction* action,
                                                               gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self,
                                 GUPnPService* service,
                                 GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                               GUPnPServiceAction* action,
                                                               gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self,
                                     GUPnPService* service,
                                     GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                   GUPnPServiceAction* action,
                                                                   gpointer self);
static void rygel_av_transport_x_dlna_get_byte_position_info_cb (RygelAVTransport* self,
                                                          GUPnPService* service,
                                                          GUPnPServiceAction* action);
static void _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                        GUPnPServiceAction* action,
                                                                                        gpointer self);
static void rygel_av_transport_set_play_mode_cb (RygelAVTransport* self,
                                          GUPnPService* service,
                                          GUPnPServiceAction* action);
static void _rygel_av_transport_set_play_mode_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                        GUPnPServiceAction* action,
                                                                        gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self,
                                         GObject* controller,
                                         GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self,
                                            GObject* controller,
                                            GParamSpec* p);
static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void rygel_av_transport_notify_track_cb (RygelAVTransport* self,
                                         GObject* controller,
                                         GParamSpec* p);
static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self,
                                       GObject* controller,
                                       GParamSpec* p);
static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self,
                                             GObject* player,
                                             GParamSpec* p);
static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self,
                                             GObject* player,
                                             GParamSpec* p);
static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self,
                                                   GObject* player,
                                                   GParamSpec* p);
static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void rygel_av_transport_notify_next_uri_cb (RygelAVTransport* self,
                                            GObject* controller,
                                            GParamSpec* p);
static void _rygel_av_transport_notify_next_uri_cb_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void rygel_av_transport_notify_next_meta_data_cb (RygelAVTransport* self,
                                                  GObject* player,
                                                  GParamSpec* p);
static void _rygel_av_transport_notify_next_meta_data_cb_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void rygel_av_transport_notify_play_mode_cb (RygelAVTransport* self,
                                             GObject* player,
                                             GParamSpec* p);
static void _rygel_av_transport_notify_play_mode_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self,
                                            GObject* player,
                                            GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
VALA_EXTERN void rygel_change_log_log (RygelChangeLog* self,
                           const gchar* variable,
                           const gchar* value);
VALA_EXTERN const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
VALA_EXTERN const gchar* rygel_av_transport_get_playback_medium (RygelAVTransport* self);
VALA_EXTERN const gchar* rygel_av_transport_get_possible_playback_media (RygelAVTransport* self);
VALA_EXTERN gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self,
                                               GUPnPServiceAction* action);
static void rygel_av_transport_handle_new_transport_uri (RygelAVTransport* self,
                                                  GUPnPServiceAction* action,
                                                  const gchar* uri,
                                                  const gchar* metadata,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void rygel_av_transport_handle_new_transport_uri_finish (RygelAVTransport* self,
                                                         GAsyncResult* _res_);
static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self,
                                                const gchar* mime);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN gint64 rygel_time_utils_time_from_string (const gchar* str);
static GUPnPMediaCollection* rygel_av_transport_parse_m3u_playlist (RygelAVTransport* self,
                                                             GBytes* data,
                                                             GError** error);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static void rygel_av_transport_handle_playlist_data_free (gpointer _data);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
static void rygel_av_transport_handle_playlist (RygelAVTransport* self,
                                         GUPnPServiceAction* action,
                                         const gchar* uri,
                                         const gchar* metadata,
                                         const gchar* mime,
                                         const gchar* features,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self,
                                                GAsyncResult* _res_);
static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_);
static void rygel_av_transport_handle_playlist_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self,
                                         const gchar* mime,
                                         const gchar* features);
static void rygel_av_transport_handle_new_transport_uri_data_free (gpointer _data);
static gboolean rygel_av_transport_handle_new_transport_uri_co (RygelAvTransportHandleNewTransportUriData* _data_);
static void rygel_av_transport_set_single_play_uri (RygelAVTransport* self,
                                             GUPnPServiceAction* action,
                                             const gchar* uri,
                                             const gchar* metadata,
                                             const gchar* mime,
                                             const gchar* features);
static void rygel_av_transport_handle_new_transport_uri_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
VALA_EXTERN RygelAVTransport* rygel_av_transport_new (void);
VALA_EXTERN RygelAVTransport* rygel_av_transport_construct (GType object_type);
VALA_EXTERN void rygel_av_transport_set_status (RygelAVTransport* self,
                                    const gchar* value);
VALA_EXTERN gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
VALA_EXTERN void rygel_av_transport_set_speed (RygelAVTransport* self,
                                   const gchar* value);
static void rygel_av_transport_finalize (GObject * obj);
static GType rygel_av_transport_get_type_once (void);
static void _vala_rygel_av_transport_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_av_transport_get_instance_private (RygelAVTransport* self)
{
	return G_STRUCT_MEMBER_P (self, RygelAVTransport_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender,
                                                                       const gchar* variable,
                                                                       GValue* value,
                                                                       gpointer self)
{
	rygel_av_transport_query_last_change_cb ((RygelAVTransport*) self, _sender, variable, value);
}

static void
_rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                          GUPnPServiceAction* action,
                                                                          gpointer self)
{
	rygel_av_transport_set_av_transport_uri_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                               GUPnPServiceAction* action,
                                                                               gpointer self)
{
	rygel_av_transport_set_next_av_transport_uri_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                    GUPnPServiceAction* action,
                                                                    gpointer self)
{
	rygel_av_transport_get_media_info_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                       GUPnPServiceAction* action,
                                                                       gpointer self)
{
	rygel_av_transport_get_media_info_ex_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                        GUPnPServiceAction* action,
                                                                        gpointer self)
{
	rygel_av_transport_get_transport_info_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                       GUPnPServiceAction* action,
                                                                       gpointer self)
{
	rygel_av_transport_get_position_info_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                             GUPnPServiceAction* action,
                                                                             gpointer self)
{
	rygel_av_transport_get_device_capabilities_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                            GUPnPServiceAction* action,
                                                                            gpointer self)
{
	rygel_av_transport_get_transport_settings_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                           GUPnPServiceAction* action,
                                                                           gpointer self)
{
	rygel_av_transport_get_transport_actions_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                          GUPnPServiceAction* action,
                                                          gpointer self)
{
	rygel_av_transport_stop_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                          GUPnPServiceAction* action,
                                                          gpointer self)
{
	rygel_av_transport_play_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                           GUPnPServiceAction* action,
                                                           gpointer self)
{
	rygel_av_transport_pause_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                          GUPnPServiceAction* action,
                                                          gpointer self)
{
	rygel_av_transport_seek_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                          GUPnPServiceAction* action,
                                                          gpointer self)
{
	rygel_av_transport_next_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                              GUPnPServiceAction* action,
                                                              gpointer self)
{
	rygel_av_transport_previous_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                                   GUPnPServiceAction* action,
                                                                                   gpointer self)
{
	rygel_av_transport_x_dlna_get_byte_position_info_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_set_play_mode_cb_gupnp_service_action_invoked (GUPnPService* _sender,
                                                                   GUPnPServiceAction* action,
                                                                   gpointer self)
{
	rygel_av_transport_set_play_mode_cb ((RygelAVTransport*) self, _sender, action);
}

static void
_rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	rygel_av_transport_notify_state_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	rygel_av_transport_notify_n_tracks_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	rygel_av_transport_notify_track_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	rygel_av_transport_notify_uri_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	rygel_av_transport_notify_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	rygel_av_transport_notify_track_uri_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	rygel_av_transport_notify_track_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_next_uri_cb_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	rygel_av_transport_notify_next_uri_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_next_meta_data_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	rygel_av_transport_notify_next_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_play_mode_cb_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	rygel_av_transport_notify_play_mode_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
_rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	rygel_av_transport_notify_duration_cb ((RygelAVTransport*) self, _sender, pspec);
}

static void
rygel_av_transport_real_constructed (GObject* base)
{
	RygelAVTransport * self;
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelChangeLog* _tmp7_;
	RygelMediaPlayer* _tmp8_;
	RygelMediaRendererPlugin* _tmp9_;
	RygelPlayerController* _tmp10_;
	RygelPlayerController* _tmp11_;
	RygelPlayerController* _tmp12_;
	RygelPlayerController* _tmp13_;
	RygelPlayerController* _tmp14_;
	RygelPlayerController* _tmp15_;
	RygelPlayerController* _tmp16_;
	RygelPlayerController* _tmp17_;
	RygelPlayerController* _tmp18_;
	RygelPlayerController* _tmp19_;
	RygelPlayerController* _tmp20_;
	RygelMediaPlayer* _tmp21_;
	RygelMediaPlayer* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	SoupSession* _tmp30_;
	SoupSession* _tmp31_;
	RygelMediaPlayer* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	RygelMediaRendererPlugin* _tmp36_;
	gchar* _tmp37_;
	self = (RygelAVTransport*) base;
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp4_) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	_g_object_unref0 (self->priv->changelog);
	self->priv->changelog = _tmp7_;
	_tmp8_ = rygel_av_transport_get_player (self);
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp8_;
	_tmp9_ = plugin;
	_tmp10_ = rygel_media_renderer_plugin_get_controller (_tmp9_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp10_;
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetNextAVTransportURI", (GCallback) _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo_Ext", (GCallback) _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetCurrentTransportActions", (GCallback) _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::X_DLNA_GetBytePositionInfo", (GCallback) _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetPlayMode", (GCallback) _rygel_av_transport_set_play_mode_cb_gupnp_service_action_invoked, self, 0);
	_tmp11_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
	_tmp12_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::n-tracks", (GCallback) _rygel_av_transport_notify_n_tracks_cb_g_object_notify, self, 0);
	_tmp13_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::track", (GCallback) _rygel_av_transport_notify_track_cb_g_object_notify, self, 0);
	_tmp14_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::uri", (GCallback) _rygel_av_transport_notify_uri_cb_g_object_notify, self, 0);
	_tmp15_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::metadata", (GCallback) _rygel_av_transport_notify_meta_data_cb_g_object_notify, self, 0);
	_tmp16_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::track-uri", (GCallback) _rygel_av_transport_notify_track_uri_cb_g_object_notify, self, 0);
	_tmp17_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::track-metadata", (GCallback) _rygel_av_transport_notify_track_meta_data_cb_g_object_notify, self, 0);
	_tmp18_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::next-uri", (GCallback) _rygel_av_transport_notify_next_uri_cb_g_object_notify, self, 0);
	_tmp19_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp19_, "notify::next-metadata", (GCallback) _rygel_av_transport_notify_next_meta_data_cb_g_object_notify, self, 0);
	_tmp20_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::play-mode", (GCallback) _rygel_av_transport_notify_play_mode_cb_g_object_notify, self, 0);
	_tmp21_ = self->priv->player;
	g_signal_connect_object ((GObject*) _tmp21_, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
	_tmp22_ = self->priv->player;
	_tmp23_ = rygel_media_player_get_user_agent (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_ == NULL;
	_g_free0 (_tmp25_);
	if (_tmp26_) {
		RygelMediaPlayer* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp27_ = self->priv->player;
		_tmp28_ = g_strdup_printf ("Rygel/%s DLNADOC/1.50 UPnP/1.0", PACKAGE_VERSION);
		_tmp29_ = _tmp28_;
		rygel_media_player_set_user_agent (_tmp27_, _tmp29_);
		_g_free0 (_tmp29_);
	}
	_tmp30_ = soup_session_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp30_;
	_tmp31_ = self->priv->session;
	_tmp32_ = self->priv->player;
	_tmp33_ = rygel_media_player_get_user_agent (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_;
	soup_session_set_user_agent (_tmp31_, _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = plugin;
	_tmp37_ = rygel_media_renderer_plugin_get_protocol_info (_tmp36_);
	_g_free0 (self->priv->protocol_info);
	self->priv->protocol_info = _tmp37_;
	_g_object_unref0 (plugin);
}

static RygelMediaPlayer*
rygel_av_transport_get_player (RygelAVTransport* self)
{
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaPlayer* _tmp7_;
	RygelMediaPlayer* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp4_) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
	result = _tmp7_;
	_g_object_unref0 (plugin);
	return result;
}

static void
rygel_av_transport_query_last_change_cb (RygelAVTransport* self,
                                         GUPnPService* service,
                                         const gchar* variable,
                                         GValue* value)
{
	RygelChangeLog* log = NULL;
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelPlayerController* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	RygelPlayerController* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelMediaPlayer* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	RygelPlayerController* _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	RygelPlayerController* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	RygelMediaPlayer* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	RygelMediaPlayer* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	RygelPlayerController* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	RygelPlayerController* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	RygelPlayerController* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	RygelPlayerController* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	RygelPlayerController* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	RygelPlayerController* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	log = _tmp0_;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_playback_state (_tmp1_);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (log, "TransportState", _tmp3_);
	_tmp4_ = self->priv->controller;
	_tmp5_ = rygel_player_controller_get_current_transport_actions (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	rygel_change_log_log (log, "CurrentTransportActions", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = rygel_av_transport_get_status (self);
	_tmp9_ = _tmp8_;
	rygel_change_log_log (log, "TransportStatus", _tmp9_);
	_tmp10_ = rygel_av_transport_get_playback_medium (self);
	_tmp11_ = _tmp10_;
	rygel_change_log_log (log, "PlaybackStorageMedium", _tmp11_);
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
	_tmp12_ = rygel_av_transport_get_possible_playback_media (self);
	_tmp13_ = _tmp12_;
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", _tmp13_);
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
	_tmp14_ = self->priv->controller;
	_tmp15_ = rygel_player_controller_get_play_mode (_tmp14_);
	_tmp16_ = _tmp15_;
	rygel_change_log_log (log, "CurrentPlayMode", _tmp16_);
	_tmp17_ = self->priv->player;
	_tmp18_ = rygel_media_player_get_playback_speed (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp20_);
	_g_free0 (_tmp20_);
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossibleRecordQualityModes", "NOT_IMPLEMENTED");
	_tmp21_ = self->priv->controller;
	_tmp22_ = rygel_player_controller_get_n_tracks (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup_printf ("%u", _tmp23_);
	_tmp25_ = _tmp24_;
	rygel_change_log_log (log, "NumberOfTracks", _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->controller;
	_tmp27_ = rygel_player_controller_get_track (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strdup_printf ("%u", _tmp28_);
	_tmp30_ = _tmp29_;
	rygel_change_log_log (log, "CurrentTrack", _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = self->priv->player;
	_tmp32_ = rygel_media_player_get_duration_as_str (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_;
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = self->priv->player;
	_tmp36_ = rygel_media_player_get_duration_as_str (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp37_;
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp38_);
	_g_free0 (_tmp38_);
	_tmp39_ = self->priv->controller;
	_tmp40_ = rygel_player_controller_get_uri (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_;
	rygel_change_log_log (log, "AVTransportURI", _tmp42_);
	_g_free0 (_tmp42_);
	_tmp43_ = self->priv->controller;
	_tmp44_ = rygel_player_controller_get_metadata (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_;
	rygel_change_log_log (log, "AVTransportURIMetaData", _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = self->priv->controller;
	_tmp48_ = rygel_player_controller_get_track_uri (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = _tmp49_;
	rygel_change_log_log (log, "CurrentTrackURI", _tmp50_);
	_g_free0 (_tmp50_);
	_tmp51_ = self->priv->controller;
	_tmp52_ = rygel_player_controller_get_track_metadata (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = _tmp53_;
	rygel_change_log_log (log, "CurrentTrackMetaData", _tmp54_);
	_g_free0 (_tmp54_);
	_tmp55_ = self->priv->controller;
	_tmp56_ = rygel_player_controller_get_next_uri (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = _tmp57_;
	rygel_change_log_log (log, "NextAVTransportURI", _tmp58_);
	_g_free0 (_tmp58_);
	_tmp59_ = self->priv->controller;
	_tmp60_ = rygel_player_controller_get_next_metadata (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_;
	rygel_change_log_log (log, "NextAVTransportURIMetaData", _tmp62_);
	_g_free0 (_tmp62_);
	g_value_init (value, G_TYPE_STRING);
	_tmp63_ = rygel_change_log_finish (log);
	_tmp64_ = _tmp63_;
	g_value_set_string (value, _tmp64_);
	_g_free0 (_tmp64_);
	_g_object_unref0 (log);
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar** unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
rygel_av_transport_check_instance_id (RygelAVTransport* self,
                                      GUPnPServiceAction* action)
{
	gchar* instance_id_string = NULL;
	gint64 instance_id = 0LL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	instance_id = (gint64) -1;
	gupnp_service_action_get (action, "InstanceID", G_TYPE_STRING, &_tmp0_, NULL);
	_g_free0 (instance_id_string);
	instance_id_string = _tmp0_;
	_tmp2_ = instance_id_string;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_;
		_tmp3_ = instance_id_string;
		_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_, NULL, (guint) 0);
		instance_id = _tmp4_;
		_tmp1_ = !_tmp5_;
	}
	if (_tmp1_) {
		gupnp_service_action_return_error (action, (guint) 402, _ ("Invalid argument"));
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	if (instance_id != ((gint64) 0)) {
		gupnp_service_action_return_error (action, (guint) 718, _ ("Invalid InstanceID"));
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	result = TRUE;
	_g_free0 (instance_id_string);
	return result;
}

static void
rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self,
                                            GUPnPService* service,
                                            GUPnPServiceAction* action)
{
	gchar* _uri = NULL;
	gchar* _metadata = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "CurrentURI", G_TYPE_STRING, &_tmp0_, "CurrentURIMetaData", G_TYPE_STRING, &_tmp1_, NULL);
	_g_free0 (_uri);
	_uri = _tmp0_;
	_g_free0 (_metadata);
	_metadata = _tmp1_;
	_tmp2_ = _uri;
	_tmp3_ = _metadata;
	rygel_av_transport_handle_new_transport_uri (self, action, _tmp2_, _tmp3_, NULL, NULL);
	_g_free0 (_metadata);
	_g_free0 (_uri);
}

static void
rygel_av_transport_set_next_av_transport_uri_cb (RygelAVTransport* self,
                                                 GUPnPService* service,
                                                 GUPnPServiceAction* action)
{
	gchar* _uri = NULL;
	gchar* _metadata = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "NextURI", G_TYPE_STRING, &_tmp0_, "NextURIMetaData", G_TYPE_STRING, &_tmp1_, NULL);
	_g_free0 (_uri);
	_uri = _tmp0_;
	_g_free0 (_metadata);
	_metadata = _tmp1_;
	_tmp2_ = _uri;
	_tmp3_ = _metadata;
	rygel_av_transport_handle_new_transport_uri (self, action, _tmp2_, _tmp3_, NULL, NULL);
	_g_free0 (_metadata);
	_g_free0 (_uri);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
rygel_av_transport_is_valid_mime_type (RygelAVTransport* self,
                                       const gchar* mime)
{
	gchar* normalized = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelMediaPlayer* _tmp5_;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (mime == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_utf8_strdown (mime, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, " ", "");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	normalized = _tmp3_;
	_tmp4_ = normalized;
	_tmp5_ = self->priv->player;
	_tmp7_ = rygel_media_player_get_mime_types (_tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = _vala_string_array_contains (_tmp8_, _tmp6_, _tmp4_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp9_;
	_g_free0 (normalized);
	return result;
}

static void
rygel_av_transport_get_media_info_cb (RygelAVTransport* self,
                                      GUPnPService* service,
                                      GUPnPServiceAction* action)
{
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	RygelPlayerController* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	const gchar* _tmp10_;
	RygelPlayerController* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelPlayerController* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	RygelPlayerController* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	RygelPlayerController* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_n_tracks (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > ((guint) 1)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("0:00:00");
		_g_free0 (media_duration);
		media_duration = _tmp3_;
	} else {
		RygelMediaPlayer* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->player;
		_tmp5_ = rygel_media_player_get_duration_as_str (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (media_duration);
		media_duration = _tmp6_;
	}
	_tmp7_ = self->priv->controller;
	_tmp8_ = rygel_player_controller_get_n_tracks (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = media_duration;
	_tmp11_ = self->priv->controller;
	_tmp12_ = rygel_player_controller_get_uri (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->controller;
	_tmp16_ = rygel_player_controller_get_metadata (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->controller;
	_tmp20_ = rygel_player_controller_get_next_uri (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->controller;
	_tmp24_ = rygel_player_controller_get_next_metadata (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp27_ = rygel_av_transport_get_playback_medium (self);
	_tmp28_ = _tmp27_;
	gupnp_service_action_set (action, "NrTracks", G_TYPE_UINT, _tmp9_, "MediaDuration", G_TYPE_STRING, _tmp10_, "CurrentURI", G_TYPE_STRING, _tmp14_, "CurrentURIMetaData", G_TYPE_STRING, _tmp18_, "NextURI", G_TYPE_STRING, _tmp22_, "NextURIMetaData", G_TYPE_STRING, _tmp26_, "PlayMedium", G_TYPE_STRING, _tmp28_, "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp14_);
	gupnp_service_action_return_success (action);
	_g_free0 (media_duration);
}

static void
rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self,
                                         GUPnPService* service,
                                         GUPnPServiceAction* action)
{
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	RygelPlayerController* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	const gchar* _tmp10_;
	RygelPlayerController* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelPlayerController* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	RygelPlayerController* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	RygelPlayerController* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_n_tracks (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > ((guint) 1)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("0:00:00");
		_g_free0 (media_duration);
		media_duration = _tmp3_;
	} else {
		RygelMediaPlayer* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->player;
		_tmp5_ = rygel_media_player_get_duration_as_str (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (media_duration);
		media_duration = _tmp6_;
	}
	_tmp7_ = self->priv->controller;
	_tmp8_ = rygel_player_controller_get_n_tracks (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = media_duration;
	_tmp11_ = self->priv->controller;
	_tmp12_ = rygel_player_controller_get_uri (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->controller;
	_tmp16_ = rygel_player_controller_get_metadata (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->controller;
	_tmp20_ = rygel_player_controller_get_next_uri (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->controller;
	_tmp24_ = rygel_player_controller_get_next_metadata (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp27_ = rygel_av_transport_get_playback_medium (self);
	_tmp28_ = _tmp27_;
	gupnp_service_action_set (action, "CurrentType", G_TYPE_STRING, "NO_MEDIA", "NrTracks", G_TYPE_UINT, _tmp9_, "MediaDuration", G_TYPE_STRING, _tmp10_, "CurrentURI", G_TYPE_STRING, _tmp14_, "CurrentURIMetaData", G_TYPE_STRING, _tmp18_, "NextURI", G_TYPE_STRING, _tmp22_, "NextURIMetaData", G_TYPE_STRING, _tmp26_, "PlayMedium", G_TYPE_STRING, _tmp28_, "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp14_);
	gupnp_service_action_return_success (action);
	_g_free0 (media_duration);
}

static void
rygel_av_transport_get_transport_info_cb (RygelAVTransport* self,
                                          GUPnPService* service,
                                          GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelMediaPlayer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_playback_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = rygel_av_transport_get_status (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player;
	_tmp6_ = rygel_media_player_get_playback_speed (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gupnp_service_action_set (action, "CurrentTransportState", G_TYPE_STRING, _tmp2_, "CurrentTransportStatus", G_TYPE_STRING, _tmp4_, "CurrentSpeed", G_TYPE_STRING, _tmp8_, NULL);
	_g_free0 (_tmp8_);
	gupnp_service_action_return_success (action);
}

static void
rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self,
                                             GUPnPService* service,
                                             GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_current_transport_actions (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	gupnp_service_action_set (action, "Actions", G_TYPE_STRING, _tmp3_, NULL);
	_g_free0 (_tmp3_);
	gupnp_service_action_return_success (action);
}

static void
rygel_av_transport_get_position_info_cb (RygelAVTransport* self,
                                         GUPnPService* service,
                                         GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	RygelPlayerController* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RygelPlayerController* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelMediaPlayer* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	RygelMediaPlayer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	RygelMediaPlayer* _tmp23_;
	gint64 _tmp24_;
	gint64 _tmp25_;
	RygelMediaPlayer* _tmp26_;
	gint64 _tmp27_;
	gint64 _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_track (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->player;
	_tmp4_ = rygel_media_player_get_duration_as_str (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->controller;
	_tmp8_ = rygel_player_controller_get_track_metadata (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->controller;
	_tmp12_ = rygel_player_controller_get_track_uri (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->player;
	_tmp16_ = rygel_media_player_get_position_as_str (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->player;
	_tmp20_ = rygel_media_player_get_position_as_str (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->player;
	_tmp24_ = rygel_media_player_get_byte_position (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->player;
	_tmp27_ = rygel_media_player_get_byte_position (_tmp26_);
	_tmp28_ = _tmp27_;
	gupnp_service_action_set (action, "Track", G_TYPE_UINT, _tmp2_, "TrackDuration", G_TYPE_STRING, _tmp6_, "TrackMetaData", G_TYPE_STRING, _tmp10_, "TrackURI", G_TYPE_STRING, _tmp14_, "RelTime", G_TYPE_STRING, _tmp18_, "AbsTime", G_TYPE_STRING, _tmp22_, "RelCount", G_TYPE_INT64, _tmp25_, "AbsCount", G_TYPE_INT64, _tmp28_, NULL);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp6_);
	gupnp_service_action_return_success (action);
}

static void
rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self,
                                               GUPnPService* service,
                                               GUPnPServiceAction* action)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = rygel_av_transport_get_possible_playback_media (self);
	_tmp1_ = _tmp0_;
	gupnp_service_action_set (action, "PlayMedia", G_TYPE_STRING, _tmp1_, "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	gupnp_service_action_return_success (action);
}

static void
rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self,
                                              GUPnPService* service,
                                              GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_play_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	gupnp_service_action_set (action, "PlayMode", G_TYPE_STRING, _tmp2_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	gupnp_service_action_return_success (action);
}

static void
rygel_av_transport_stop_cb (RygelAVTransport* self,
                            GUPnPService* service,
                            GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	rygel_player_controller_set_playback_state (_tmp0_, "STOPPED");
	gupnp_service_action_return_success (action);
}

static void
rygel_av_transport_play_cb (RygelAVTransport* self,
                            GUPnPService* service,
                            GUPnPServiceAction* action)
{
	gchar* speed = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	RygelMediaPlayer* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	RygelPlayerController* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	RygelMediaPlayer* _tmp15_;
	const gchar* _tmp16_;
	RygelPlayerController* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "Speed", G_TYPE_STRING, &_tmp0_, NULL);
	_g_free0 (speed);
	speed = _tmp0_;
	_tmp1_ = speed;
	_tmp2_ = self->priv->player;
	_tmp3_ = rygel_media_player_get_allowed_playback_speeds (_tmp2_, &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = !_vala_string_array_contains (_tmp6_, _tmp5__length1, _tmp1_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp7_) {
		gupnp_service_action_return_error (action, (guint) 717, _ ("Play speed not supported"));
		_g_free0 (speed);
		return;
	}
	_tmp9_ = self->priv->controller;
	_tmp10_ = rygel_player_controller_get_playback_state (_tmp9_);
	_tmp11_ = _tmp10_;
	if (g_strcmp0 (_tmp11_, "STOPPED") != 0) {
		RygelPlayerController* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = self->priv->controller;
		_tmp13_ = rygel_player_controller_get_playback_state (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp8_ = g_strcmp0 (_tmp14_, "PAUSED_PLAYBACK") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gupnp_service_action_return_error (action, (guint) 701, _ ("Transition not available"));
		_g_free0 (speed);
		return;
	}
	_tmp15_ = self->priv->player;
	_tmp16_ = speed;
	rygel_media_player_set_playback_speed (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->controller;
	rygel_player_controller_set_playback_state (_tmp17_, "PLAYING");
	gupnp_service_action_return_success (action);
	_g_free0 (speed);
}

static void
rygel_av_transport_pause_cb (RygelAVTransport* self,
                             GUPnPService* service,
                             GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	RygelPlayerController* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_can_pause (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gupnp_service_action_return_error (action, (guint) 701, _ ("Transition not available"));
		return;
	}
	_tmp3_ = self->priv->controller;
	rygel_player_controller_set_playback_state (_tmp3_, "PAUSED_PLAYBACK");
	gupnp_service_action_return_success (action);
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static void
rygel_av_transport_seek_cb (RygelAVTransport* self,
                            GUPnPService* service,
                            GUPnPServiceAction* action)
{
	gchar* unit = NULL;
	gchar* target = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	static GQuark _tmp4_label4 = 0;
	static GQuark _tmp4_label5 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "Unit", G_TYPE_STRING, &_tmp0_, "Target", G_TYPE_STRING, &_tmp1_, NULL);
	_g_free0 (unit);
	unit = _tmp0_;
	_g_free0 (target);
	target = _tmp1_;
	_tmp2_ = unit;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if ((_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("REL_TIME"))))) {
		switch (0) {
			default:
			{
				gint64 seek_target = 0LL;
				const gchar* _tmp6_;
				RygelMediaPlayer* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				RygelMediaPlayer* _tmp10_;
				_tmp6_ = target;
				seek_target = rygel_time_utils_time_from_string (_tmp6_);
				g_debug ("rygel-av-transport.vala:526: Seeking to %lld sec", seek_target / G_TIME_SPAN_SECOND);
				_tmp7_ = self->priv->player;
				_tmp8_ = rygel_media_player_get_can_seek (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gupnp_service_action_return_error (action, (guint) 710, _ ("Seek mode not supported"));
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp10_ = self->priv->player;
				if (!rygel_media_player_seek (_tmp10_, seek_target)) {
					gupnp_service_action_return_error (action, (guint) 711, _ ("Illegal seek target"));
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				gupnp_service_action_return_success (action);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	} else if (((_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("REL_COUNT")))) || (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("X_DLNA_REL_BYTE"))))) || (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("ABS_COUNT"))))) {
		switch (0) {
			default:
			{
				gint64 seek_target = 0LL;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				RygelMediaPlayer* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				RygelMediaPlayer* _tmp19_;
				_tmp11_ = target;
				seek_target = int64_parse (_tmp11_, (guint) 0);
				_tmp12_ = unit;
				if (g_strcmp0 (_tmp12_, "ABS_COUNT") != 0) {
					RygelMediaPlayer* _tmp13_;
					gint64 _tmp14_;
					gint64 _tmp15_;
					_tmp13_ = self->priv->player;
					_tmp14_ = rygel_media_player_get_byte_position (_tmp13_);
					_tmp15_ = _tmp14_;
					seek_target += _tmp15_;
				}
				g_debug ("rygel-av-transport.vala:551: Seeking to %lld bytes.", seek_target);
				_tmp16_ = self->priv->player;
				_tmp17_ = rygel_media_player_get_can_seek_bytes (_tmp16_);
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gupnp_service_action_return_error (action, (guint) 710, _ ("Seek mode not supported"));
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp19_ = self->priv->player;
				if (!rygel_media_player_seek_bytes (_tmp19_, seek_target)) {
					gupnp_service_action_return_error (action, (guint) 711, _ ("Illegal seek target"));
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				gupnp_service_action_return_success (action);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("TRACK_NR")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp20_;
				gint track = 0;
				const gchar* _tmp21_;
				gboolean _tmp22_ = FALSE;
				RygelPlayerController* _tmp26_;
				_tmp20_ = target;
				g_debug ("rygel-av-transport.vala:569: Setting track to %s.", _tmp20_);
				_tmp21_ = target;
				track = atoi (_tmp21_);
				if (track < 1) {
					_tmp22_ = TRUE;
				} else {
					RygelPlayerController* _tmp23_;
					guint _tmp24_;
					guint _tmp25_;
					_tmp23_ = self->priv->controller;
					_tmp24_ = rygel_player_controller_get_n_tracks (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp22_ = ((guint) track) > _tmp25_;
				}
				if (_tmp22_) {
					gupnp_service_action_return_error (action, (guint) 711, _ ("Illegal seek target"));
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp26_ = self->priv->controller;
				rygel_player_controller_set_track (_tmp26_, (guint) track);
				gupnp_service_action_return_success (action);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gupnp_service_action_return_error (action, (guint) 710, _ ("Seek mode not supported"));
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	}
	_g_free0 (target);
	_g_free0 (unit);
}

static void
rygel_av_transport_next_cb (RygelAVTransport* self,
                            GUPnPService* service,
                            GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	if (rygel_player_controller_next (_tmp0_)) {
		gupnp_service_action_return_success (action);
	} else {
		gupnp_service_action_return_error (action, (guint) 711, _ ("Illegal seek target"));
	}
}

static void
rygel_av_transport_previous_cb (RygelAVTransport* self,
                                GUPnPService* service,
                                GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	if (rygel_player_controller_previous (_tmp0_)) {
		gupnp_service_action_return_success (action);
	} else {
		gupnp_service_action_return_error (action, (guint) 711, _ ("Illegal seek target"));
	}
}

static void
rygel_av_transport_x_dlna_get_byte_position_info_cb (RygelAVTransport* self,
                                                     GUPnPService* service,
                                                     GUPnPServiceAction* action)
{
	RygelPlayerController* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		gupnp_service_action_set (action, "TrackSize", G_TYPE_STRING, "", "RelByte", G_TYPE_STRING, "", "AbsByte", G_TYPE_STRING, "", NULL);
	} else {
		gchar* position = NULL;
		RygelMediaPlayer* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		gchar* _tmp8_;
		RygelMediaPlayer* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp5_ = self->priv->player;
		_tmp6_ = rygel_media_player_get_byte_position (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
		position = _tmp8_;
		_tmp9_ = self->priv->player;
		_tmp10_ = rygel_media_player_get_size (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = position;
		_tmp15_ = position;
		gupnp_service_action_set (action, "TrackSize", G_TYPE_STRING, _tmp13_, "RelByte", G_TYPE_STRING, _tmp14_, "AbsByte", G_TYPE_STRING, _tmp15_, NULL);
		_g_free0 (_tmp13_);
		_g_free0 (position);
	}
	gupnp_service_action_return_success (action);
}

static void
rygel_av_transport_set_play_mode_cb (RygelAVTransport* self,
                                     GUPnPService* service,
                                     GUPnPServiceAction* action)
{
	gchar* play_mode = NULL;
	gchar* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_;
	const gchar* _tmp2_;
	RygelPlayerController* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_get (action, "NewPlayMode", G_TYPE_STRING, &_tmp0_, NULL);
	_g_free0 (play_mode);
	play_mode = _tmp0_;
	_tmp1_ = self->priv->controller;
	_tmp2_ = play_mode;
	if (!rygel_player_controller_is_play_mode_valid (_tmp1_, _tmp2_)) {
		gupnp_service_action_return_error (action, (guint) 712, _ ("Play mode not supported"));
		_g_free0 (play_mode);
		return;
	}
	_tmp3_ = self->priv->controller;
	_tmp4_ = play_mode;
	rygel_player_controller_set_play_mode (_tmp3_, _tmp4_);
	gupnp_service_action_return_success (action);
	_g_free0 (play_mode);
}

static void
rygel_av_transport_notify_state_cb (RygelAVTransport* self,
                                    GObject* controller,
                                    GParamSpec* p)
{
	gchar* state = NULL;
	RygelPlayerController* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	RygelChangeLog* _tmp4_;
	RygelChangeLog* _tmp5_;
	RygelPlayerController* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_playback_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	state = _tmp3_;
	_tmp4_ = self->priv->changelog;
	rygel_change_log_log (_tmp4_, "TransportState", state);
	_tmp5_ = self->priv->changelog;
	_tmp6_ = self->priv->controller;
	_tmp7_ = rygel_player_controller_get_current_transport_actions (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	rygel_change_log_log (_tmp5_, "CurrentTransportActions", _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (state);
}

static void
rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self,
                                       GObject* controller,
                                       GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_n_tracks (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "NumberOfTracks", _tmp5_);
	_g_free0 (_tmp5_);
}

static void
rygel_av_transport_notify_track_cb (RygelAVTransport* self,
                                    GObject* controller,
                                    GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_track (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "CurrentTrack", _tmp5_);
	_g_free0 (_tmp5_);
}

static void
rygel_av_transport_notify_duration_cb (RygelAVTransport* self,
                                       GObject* player,
                                       GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelChangeLog* _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->player;
	_tmp2_ = rygel_media_player_get_duration_as_str (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "CurrentTrackDuration", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->changelog;
	_tmp6_ = self->priv->player;
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	rygel_change_log_log (_tmp5_, "CurrentMediaDuration", _tmp9_);
	_g_free0 (_tmp9_);
}

static void
rygel_av_transport_notify_uri_cb (RygelAVTransport* self,
                                  GObject* controller,
                                  GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "AVTransportURI", _tmp4_);
	_g_free0 (_tmp4_);
}

static void
rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self,
                                        GObject* player,
                                        GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "AVTransportURIMetaData", _tmp4_);
	_g_free0 (_tmp4_);
}

static void
rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self,
                                        GObject* player,
                                        GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_track_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "CurrentTrackURI", _tmp4_);
	_g_free0 (_tmp4_);
}

static void
rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self,
                                              GObject* player,
                                              GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_track_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "CurrentTrackMetaData", _tmp4_);
	_g_free0 (_tmp4_);
}

static void
rygel_av_transport_notify_next_uri_cb (RygelAVTransport* self,
                                       GObject* controller,
                                       GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_next_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "NextAVTransportURI", _tmp4_);
	_g_free0 (_tmp4_);
}

static void
rygel_av_transport_notify_next_meta_data_cb (RygelAVTransport* self,
                                             GObject* player,
                                             GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_next_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "NextAVTransportURIMetaData", _tmp4_);
	_g_free0 (_tmp4_);
}

static void
rygel_av_transport_notify_play_mode_cb (RygelAVTransport* self,
                                        GObject* player,
                                        GParamSpec* p)
{
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_play_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (_tmp0_, "CurrentPlayMode", _tmp3_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static GUPnPMediaCollection*
rygel_av_transport_parse_m3u_playlist (RygelAVTransport* self,
                                       GBytes* data,
                                       GError** error)
{
	GUPnPMediaCollection* collection = NULL;
	GUPnPMediaCollection* _tmp0_;
	GMemoryInputStream* m_stream = NULL;
	GMemoryInputStream* _tmp1_;
	GDataInputStream* stream = NULL;
	GMemoryInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	gsize length = 0UL;
	gchar* line = NULL;
	GDataInputStream* _tmp4_;
	gsize _tmp5_ = 0UL;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	GUPnPMediaCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (data == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = gupnp_media_collection_new ();
	collection = _tmp0_;
	_tmp1_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (data);
	m_stream = _tmp1_;
	_tmp2_ = m_stream;
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
	stream = _tmp3_;
	g_debug ("rygel-av-transport.vala:732: Trying to parse m3u playlist");
	_tmp4_ = stream;
	_tmp6_ = g_data_input_stream_read_line (_tmp4_, &_tmp5_, NULL, &_inner_error0_);
	length = _tmp5_;
	line = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		_g_object_unref0 (m_stream);
		_g_object_unref0 (collection);
		return NULL;
	}
	while (TRUE) {
		const gchar* _tmp7_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GUPnPDIDLLiteItem* item = NULL;
		GUPnPMediaCollection* _tmp18_;
		GUPnPDIDLLiteItem* _tmp19_;
		GUPnPDIDLLiteItem* _tmp20_;
		GUPnPDIDLLiteResource* resource = NULL;
		GUPnPDIDLLiteItem* _tmp21_;
		GUPnPDIDLLiteResource* _tmp22_;
		GUPnPProtocolInfo* pi = NULL;
		GUPnPProtocolInfo* _tmp23_;
		GUPnPDIDLLiteResource* _tmp24_;
		GUPnPProtocolInfo* _tmp25_;
		GUPnPDIDLLiteResource* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		GDataInputStream* _tmp31_;
		gsize _tmp32_ = 0UL;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp7_ = line;
		if (!(_tmp7_ != NULL)) {
			break;
		}
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
			gchar* _tmp11_ = NULL;
			GDataInputStream* _tmp12_;
			gsize _tmp13_ = 0UL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = line;
			if (_tmp9_ != NULL) {
				const gchar* _tmp10_;
				_tmp10_ = line;
				_tmp8_ = g_str_has_prefix (_tmp10_, "#");
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp12_ = stream;
			_tmp14_ = g_data_input_stream_read_line (_tmp12_, &_tmp13_, NULL, &_inner_error0_);
			length = _tmp13_;
			_tmp11_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (line);
				_g_object_unref0 (stream);
				_g_object_unref0 (m_stream);
				_g_object_unref0 (collection);
				return NULL;
			}
			_tmp15_ = _tmp11_;
			_tmp11_ = NULL;
			_g_free0 (line);
			line = _tmp15_;
			_g_free0 (_tmp11_);
		}
		_tmp16_ = line;
		if (_tmp16_ == NULL) {
			break;
		}
		_tmp17_ = line;
		g_debug ("rygel-av-transport.vala:747: Adding uri with %s", _tmp17_);
		_tmp18_ = collection;
		_tmp19_ = gupnp_media_collection_add_item (_tmp18_);
		item = _tmp19_;
		_tmp20_ = item;
		gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp20_, "object.item.audioItem");
		_tmp21_ = item;
		_tmp22_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) _tmp21_);
		resource = _tmp22_;
		_tmp23_ = gupnp_protocol_info_new_from_string ("*:*:*:*", &_inner_error0_);
		pi = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (resource);
			_g_object_unref0 (item);
			_g_free0 (line);
			_g_object_unref0 (stream);
			_g_object_unref0 (m_stream);
			_g_object_unref0 (collection);
			return NULL;
		}
		_tmp24_ = resource;
		_tmp25_ = pi;
		gupnp_didl_lite_resource_set_protocol_info (_tmp24_, _tmp25_);
		_tmp26_ = resource;
		_tmp27_ = line;
		_tmp28_ = string_strip (_tmp27_);
		_tmp29_ = _tmp28_;
		gupnp_didl_lite_resource_set_uri (_tmp26_, _tmp29_);
		_g_free0 (_tmp29_);
		_tmp31_ = stream;
		_tmp33_ = g_data_input_stream_read_line (_tmp31_, &_tmp32_, NULL, &_inner_error0_);
		length = _tmp32_;
		_tmp30_ = _tmp33_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pi);
			_g_object_unref0 (resource);
			_g_object_unref0 (item);
			_g_free0 (line);
			_g_object_unref0 (stream);
			_g_object_unref0 (m_stream);
			_g_object_unref0 (collection);
			return NULL;
		}
		_tmp34_ = _tmp30_;
		_tmp30_ = NULL;
		_g_free0 (line);
		line = _tmp34_;
		_g_free0 (_tmp30_);
		_g_object_unref0 (pi);
		_g_object_unref0 (resource);
		_g_object_unref0 (item);
	}
	result = collection;
	_g_free0 (line);
	_g_object_unref0 (stream);
	_g_object_unref0 (m_stream);
	return result;
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

static void
rygel_av_transport_handle_playlist_data_free (gpointer _data)
{
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = _data;
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->metadata);
	_g_free0 (_data_->mime);
	_g_free0 (_data_->features);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelAvTransportHandlePlaylistData, _data_);
}

static GUPnPServiceAction*
_vala_GUPnPServiceAction_copy (GUPnPServiceAction* self)
{
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}

static gpointer
__vala_GUPnPServiceAction_copy0 (gpointer self)
{
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}

static void
rygel_av_transport_handle_playlist (RygelAVTransport* self,
                                    GUPnPServiceAction* action,
                                    const gchar* uri,
                                    const gchar* metadata,
                                    const gchar* mime,
                                    const gchar* features,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RygelAvTransportHandlePlaylistData* _data_;
	RygelAVTransport* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (mime != NULL);
	g_return_if_fail (features != NULL);
	_data_ = g_slice_new0 (RygelAvTransportHandlePlaylistData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_av_transport_handle_playlist_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (action);
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_data_->action = _tmp1_;
	_tmp2_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	_tmp3_ = g_strdup (metadata);
	_g_free0 (_data_->metadata);
	_data_->metadata = _tmp3_;
	_tmp4_ = g_strdup (mime);
	_g_free0 (_data_->mime);
	_data_->mime = _tmp4_;
	_tmp5_ = g_strdup (features);
	_g_free0 (_data_->features);
	_data_->features = _tmp5_;
	rygel_av_transport_handle_playlist_co (_data_);
}

static void
rygel_av_transport_handle_playlist_finish (RygelAVTransport* self,
                                           GAsyncResult* _res_)
{
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_av_transport_handle_playlist_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_av_transport_handle_playlist_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_)
{
	static GQuark _tmp32_label0 = 0;
	static GQuark _tmp32_label1 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = soup_message_new ("GET", _data_->uri);
	_data_->message = _data_->_tmp0_;
	_data_->body = NULL;
	{
		_data_->_tmp2_ = _data_->self->priv->session;
		_data_->_tmp3_ = _data_->message;
		_data_->_state_ = 1;
		soup_session_send_and_read_async (_data_->_tmp2_, _data_->_tmp3_, G_PRIORITY_DEFAULT, NULL, rygel_av_transport_handle_playlist_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = soup_session_send_and_read_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_bytes_unref0 (_data_->body);
		_data_->body = _data_->_tmp5_;
		_g_bytes_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		gupnp_service_action_return_error (_data_->action, (guint) 716, _ ("Resource not found"));
		_g_bytes_unref0 (_data_->body);
		_g_object_unref0 (_data_->message);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_bytes_unref0 (_data_->body);
		_g_object_unref0 (_data_->message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->message;
	g_object_get (_data_->_tmp6_, "status-code", &_data_->_tmp7_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	if (_data_->_tmp8_ != ((guint) 200)) {
		gupnp_service_action_return_error (_data_->action, (guint) 716, _ ("Resource not found"));
		_g_bytes_unref0 (_data_->body);
		_g_object_unref0 (_data_->message);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->message;
	_data_->_tmp10_ = soup_message_get_response_headers (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = soup_message_headers_get_content_type (_data_->_tmp11_, NULL);
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->content_type = _data_->_tmp13_;
	_data_->collection = NULL;
	_data_->_tmp14_ = _data_->content_type;
	if (g_str_has_suffix (_data_->_tmp14_, "mpegurl")) {
		g_debug ("rygel-av-transport.vala:788: Trying to parse m3u playlist");
		{
			_data_->_tmp16_ = _data_->body;
			_data_->_tmp17_ = rygel_av_transport_parse_m3u_playlist (_data_->self, _data_->_tmp16_, &_data_->_inner_error0_);
			_data_->_tmp15_ = _data_->_tmp17_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp18_ = _data_->_tmp15_;
			_data_->_tmp15_ = NULL;
			_g_object_unref0 (_data_->collection);
			_data_->collection = _data_->_tmp18_;
			_g_object_unref0 (_data_->_tmp15_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp19_ = _data_->_error_;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			g_warning (_ ("Problem parsing playlist: %s"), _data_->_tmp20_);
			gupnp_service_action_return_error (_data_->action, (guint) 716, _ ("Resource not found"));
			_g_error_free0 (_data_->_error_);
			_g_object_unref0 (_data_->collection);
			_g_free0 (_data_->content_type);
			_g_bytes_unref0 (_data_->body);
			_g_object_unref0 (_data_->message);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->collection);
			_g_free0 (_data_->content_type);
			_g_bytes_unref0 (_data_->body);
			_g_object_unref0 (_data_->message);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp21_ = _data_->body;
		_data_->_tmp22_ = 0;
		_data_->_tmp23_ = g_bytes_get_data (_data_->_tmp21_, &_data_->_tmp22_);
		_data_->xml_string = (const gchar*) _data_->_tmp23_;
		_data_->_tmp24_ = _data_->xml_string;
		_data_->_tmp25_ = gupnp_media_collection_new_from_string (_data_->_tmp24_);
		_g_object_unref0 (_data_->collection);
		_data_->collection = _data_->_tmp25_;
		_data_->_tmp26_ = _data_->collection;
		_data_->_tmp27_ = gupnp_media_collection_get_items (_data_->_tmp26_);
		_data_->_tmp28_ = _data_->_tmp27_;
		_data_->_tmp29_ = g_list_length (_data_->_tmp28_) == ((guint) 0);
		(_data_->_tmp28_ == NULL) ? NULL : (_data_->_tmp28_ = (_g_list_free__g_object_unref0_ (_data_->_tmp28_), NULL));
		if (_data_->_tmp29_) {
			gupnp_service_action_return_error (_data_->action, (guint) 716, _ ("Resource not found"));
			_g_object_unref0 (_data_->collection);
			_g_free0 (_data_->content_type);
			_g_bytes_unref0 (_data_->body);
			_g_object_unref0 (_data_->message);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp30_ = gupnp_service_action_get_name (_data_->action);
	_data_->_tmp33_ = 0U;
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_tmp33_ = (NULL == _data_->_tmp31_) ? 0 : g_quark_from_string (_data_->_tmp31_);
	if (_data_->_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("SetAVTransportURI")))) {
		switch (0) {
			default:
			{
				_data_->_tmp34_ = _data_->self->priv->controller;
				_data_->_tmp35_ = _data_->collection;
				rygel_player_controller_set_playlist_uri (_data_->_tmp34_, _data_->uri, _data_->metadata, _data_->_tmp35_);
				break;
			}
		}
	} else if (_data_->_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("SetNextAVTransportURI")))) {
		switch (0) {
			default:
			{
				_data_->_tmp36_ = _data_->self->priv->controller;
				_data_->_tmp37_ = _data_->collection;
				rygel_player_controller_set_next_playlist_uri (_data_->_tmp36_, _data_->uri, _data_->metadata, _data_->_tmp37_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	gupnp_service_action_return_success (_data_->action);
	_g_object_unref0 (_data_->collection);
	_g_free0 (_data_->content_type);
	_g_bytes_unref0 (_data_->body);
	_g_object_unref0 (_data_->message);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
rygel_av_transport_is_playlist (RygelAVTransport* self,
                                const gchar* mime,
                                const gchar* features)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (mime != NULL) {
		_tmp3_ = g_strcmp0 (mime, "text/xml") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = features != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_str_has_prefix (features, "DLNA.ORG_PN=DIDL_S");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_str_has_suffix (mime, "mpegurl");
	}
	result = _tmp0_;
	return result;
}

static void
rygel_av_transport_handle_new_transport_uri_data_free (gpointer _data)
{
	RygelAvTransportHandleNewTransportUriData* _data_;
	_data_ = _data;
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->metadata);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelAvTransportHandleNewTransportUriData, _data_);
}

static void
rygel_av_transport_handle_new_transport_uri (RygelAVTransport* self,
                                             GUPnPServiceAction* action,
                                             const gchar* uri,
                                             const gchar* metadata,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	RygelAvTransportHandleNewTransportUriData* _data_;
	RygelAVTransport* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_data_ = g_slice_new0 (RygelAvTransportHandleNewTransportUriData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_av_transport_handle_new_transport_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (action);
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_data_->action = _tmp1_;
	_tmp2_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	_tmp3_ = g_strdup (metadata);
	_g_free0 (_data_->metadata);
	_data_->metadata = _tmp3_;
	rygel_av_transport_handle_new_transport_uri_co (_data_);
}

static void
rygel_av_transport_handle_new_transport_uri_finish (RygelAVTransport* self,
                                                    GAsyncResult* _res_)
{
	RygelAvTransportHandleNewTransportUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_av_transport_handle_new_transport_uri_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	RygelAvTransportHandleNewTransportUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_av_transport_handle_new_transport_uri_co (_data_);
}

static gboolean
rygel_av_transport_handle_new_transport_uri_co (RygelAvTransportHandleNewTransportUriData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!g_str_has_prefix (_data_->uri, "http://")) {
		_data_->_tmp0_ = !g_str_has_prefix (_data_->uri, "https://");
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		rygel_av_transport_set_single_play_uri (_data_->self, _data_->action, _data_->uri, _data_->metadata, NULL, NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = gupnp_service_info_get_context ((GUPnPServiceInfo*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gupnp_context_rewrite_uri (_data_->_tmp2_, _data_->uri);
	_data_->new_uri = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->new_uri;
	_data_->_tmp5_ = soup_message_new ("HEAD", _data_->_tmp4_);
	_data_->message = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->message;
	_data_->_tmp7_ = soup_message_get_request_headers (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	soup_message_headers_append (_data_->_tmp8_, "getContentFeatures.dlna.org", "1");
	_data_->_tmp9_ = _data_->message;
	_data_->_tmp10_ = soup_message_get_request_headers (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	soup_message_headers_append (_data_->_tmp11_, "Connection", "close");
	{
		_data_->_tmp12_ = _data_->self->priv->session;
		_data_->_tmp13_ = _data_->message;
		_data_->_state_ = 1;
		soup_session_send_async (_data_->_tmp12_, _data_->_tmp13_, G_PRIORITY_DEFAULT, NULL, rygel_av_transport_handle_new_transport_uri_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp14_ = soup_session_send_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_g_object_unref0 (_data_->_tmp15_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp18_ = _data_->message;
		g_object_get (_data_->_tmp18_, "status-code", &_data_->_tmp19_, NULL);
		_data_->_tmp20_ = _data_->_tmp19_;
		if (_data_->_tmp20_ == ((guint) SOUP_STATUS_BAD_REQUEST)) {
			_data_->_tmp17_ = TRUE;
		} else {
			_data_->_tmp21_ = _data_->message;
			g_object_get (_data_->_tmp21_, "status-code", &_data_->_tmp22_, NULL);
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp17_ = _data_->_tmp23_ == ((guint) SOUP_STATUS_METHOD_NOT_ALLOWED);
		}
		if (_data_->_tmp17_) {
			_data_->_tmp16_ = TRUE;
		} else {
			_data_->_tmp24_ = _data_->message;
			g_object_get (_data_->_tmp24_, "status-code", &_data_->_tmp25_, NULL);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp16_ = _data_->_tmp26_ == ((guint) SOUP_STATUS_NOT_IMPLEMENTED);
		}
		if (_data_->_tmp16_) {
			g_debug ("rygel-av-transport.vala:851: Peer does not support HEAD, trying GET");
			_data_->_tmp27_ = _data_->message;
			soup_message_set_method (_data_->_tmp27_, "GET");
			_data_->_tmp28_ = _data_->self->priv->session;
			_data_->_tmp29_ = _data_->message;
			_data_->_state_ = 2;
			soup_session_send_async (_data_->_tmp28_, _data_->_tmp29_, G_PRIORITY_DEFAULT, NULL, rygel_av_transport_handle_new_transport_uri_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp30_ = soup_session_send_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_g_object_unref0 (_data_->_tmp31_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_data_->_tmp32_ = _data_->message;
		g_object_get (_data_->_tmp32_, "status-code", &_data_->_tmp33_, NULL);
		_data_->_tmp34_ = _data_->_tmp33_;
		if (_data_->_tmp34_ != ((guint) SOUP_STATUS_OK)) {
			_data_->_tmp35_ = _data_->message;
			_data_->_tmp36_ = soup_message_get_reason_phrase (_data_->_tmp35_);
			_data_->_tmp37_ = _data_->_tmp36_;
			g_warning (_ ("Failed to access resource at %s: %s"), _data_->uri, _data_->_tmp37_);
			gupnp_service_action_return_error (_data_->action, (guint) 716, _ ("Resource not found"));
			_g_object_unref0 (_data_->message);
			_g_free0 (_data_->new_uri);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp38_ = _data_->message;
		_data_->_tmp39_ = soup_message_get_response_headers (_data_->_tmp38_);
		_data_->_tmp40_ = _data_->_tmp39_;
		_data_->_tmp41_ = soup_message_headers_get_one (_data_->_tmp40_, "Content-Type");
		_data_->_tmp42_ = g_strdup (_data_->_tmp41_);
		_data_->mime = _data_->_tmp42_;
		_data_->_tmp43_ = _data_->message;
		_data_->_tmp44_ = soup_message_get_response_headers (_data_->_tmp43_);
		_data_->_tmp45_ = _data_->_tmp44_;
		_data_->_tmp46_ = soup_message_headers_get_one (_data_->_tmp45_, "contentFeatures.dlna.org");
		_data_->_tmp47_ = g_strdup (_data_->_tmp46_);
		_data_->features = _data_->_tmp47_;
		_data_->_tmp49_ = _data_->mime;
		if (!rygel_av_transport_is_valid_mime_type (_data_->self, _data_->_tmp49_)) {
			_data_->_tmp50_ = _data_->mime;
			_data_->_tmp51_ = _data_->features;
			_data_->_tmp48_ = !rygel_av_transport_is_playlist (_data_->self, _data_->_tmp50_, _data_->_tmp51_);
		} else {
			_data_->_tmp48_ = FALSE;
		}
		if (_data_->_tmp48_) {
			_data_->_tmp52_ = _data_->mime;
			g_debug ("rygel-av-transport.vala:874: Unsupported mime type %s", _data_->_tmp52_);
			gupnp_service_action_return_error (_data_->action, (guint) 714, _ ("Illegal MIME-type"));
			_g_free0 (_data_->features);
			_g_free0 (_data_->mime);
			_g_object_unref0 (_data_->message);
			_g_free0 (_data_->new_uri);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp53_ = _data_->mime;
		_data_->_tmp54_ = _data_->features;
		if (rygel_av_transport_is_playlist (_data_->self, _data_->_tmp53_, _data_->_tmp54_)) {
			_data_->_tmp55_ = _data_->mime;
			_data_->_tmp56_ = _data_->features;
			_data_->_state_ = 3;
			rygel_av_transport_handle_playlist (_data_->self, _data_->action, _data_->uri, _data_->metadata, _data_->_tmp55_, _data_->_tmp56_, rygel_av_transport_handle_new_transport_uri_ready, _data_);
			return FALSE;
			_state_3:
			rygel_av_transport_handle_playlist_finish (_data_->self, _data_->_res_);
		} else {
			_data_->_tmp57_ = _data_->mime;
			_data_->_tmp58_ = _data_->features;
			rygel_av_transport_set_single_play_uri (_data_->self, _data_->action, _data_->uri, _data_->metadata, _data_->_tmp57_, _data_->_tmp58_);
		}
		_g_free0 (_data_->features);
		_g_free0 (_data_->mime);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp59_ = _data_->message;
		_data_->_tmp60_ = soup_message_get_reason_phrase (_data_->_tmp59_);
		_data_->_tmp61_ = _data_->_tmp60_;
		g_warning (_ ("Failed to access resource at %s: %s"), _data_->uri, _data_->_tmp61_);
		gupnp_service_action_return_error (_data_->action, (guint) 716, _ ("Resource not found"));
		_g_object_unref0 (_data_->message);
		_g_free0 (_data_->new_uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->message);
		_g_free0 (_data_->new_uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->message);
	_g_free0 (_data_->new_uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_av_transport_set_single_play_uri (RygelAVTransport* self,
                                        GUPnPServiceAction* action,
                                        const gchar* uri,
                                        const gchar* metadata,
                                        const gchar* mime,
                                        const gchar* features)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = gupnp_service_action_get_name (action);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("SetAVTransportURI")))) {
		switch (0) {
			default:
			{
				RygelPlayerController* _tmp4_;
				_tmp4_ = self->priv->controller;
				rygel_player_controller_set_single_play_uri (_tmp4_, uri, metadata, mime, features);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("SetNextAVTransportURI")))) {
		switch (0) {
			default:
			{
				RygelPlayerController* _tmp5_;
				_tmp5_ = self->priv->controller;
				rygel_player_controller_set_next_single_play_uri (_tmp5_, uri, metadata, mime, features);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	gupnp_service_action_return_success (action);
}

RygelAVTransport*
rygel_av_transport_construct (GType object_type)
{
	RygelAVTransport * self = NULL;
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
	return self;
}

RygelAVTransport*
rygel_av_transport_new (void)
{
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
}

const gchar*
rygel_av_transport_get_status (RygelAVTransport* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}

void
rygel_av_transport_set_status (RygelAVTransport* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	RygelChangeLog* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_status);
	self->priv->_status = _tmp0_;
	_tmp1_ = self->priv->changelog;
	_tmp2_ = self->priv->_status;
	rygel_change_log_log (_tmp1_, "TransportStatus", _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, rygel_av_transport_properties[RYGEL_AV_TRANSPORT_STATUS_PROPERTY]);
}

const gchar*
rygel_av_transport_get_playback_medium (RygelAVTransport* self)
{
	const gchar* result;
	RygelPlayerController* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		result = "NONE";
		return result;
	} else {
		result = "NETWORK";
		return result;
	}
}

const gchar*
rygel_av_transport_get_possible_playback_media (RygelAVTransport* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = "NONE,NETWORK";
	return result;
}

gchar*
rygel_av_transport_get_speed (RygelAVTransport* self)
{
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = rygel_media_player_get_playback_speed (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
rygel_av_transport_set_speed (RygelAVTransport* self,
                              const gchar* value)
{
	RygelMediaPlayer* _tmp0_;
	RygelChangeLog* _tmp1_;
	RygelMediaPlayer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->player;
	rygel_media_player_set_playback_speed (_tmp0_, value);
	_tmp1_ = self->priv->changelog;
	_tmp2_ = self->priv->player;
	_tmp3_ = rygel_media_player_get_playback_speed (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp1_, "TransportPlaySpeed", _tmp5_);
	_g_free0 (_tmp5_);
	g_object_notify_by_pspec ((GObject *) self, rygel_av_transport_properties[RYGEL_AV_TRANSPORT_SPEED_PROPERTY]);
}

static void
rygel_av_transport_class_init (RygelAVTransportClass * klass,
                               gpointer klass_data)
{
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelAVTransport_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_av_transport_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS_PROPERTY, rygel_av_transport_properties[RYGEL_AV_TRANSPORT_STATUS_PROPERTY] = g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM_PROPERTY, rygel_av_transport_properties[RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM_PROPERTY] = g_param_spec_string ("playback-medium", "playback-medium", "playback-medium", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_POSSIBLE_PLAYBACK_MEDIA_PROPERTY, rygel_av_transport_properties[RYGEL_AV_TRANSPORT_POSSIBLE_PLAYBACK_MEDIA_PROPERTY] = g_param_spec_string ("possible-playback-media", "possible-playback-media", "possible-playback-media", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED_PROPERTY, rygel_av_transport_properties[RYGEL_AV_TRANSPORT_SPEED_PROPERTY] = g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_av_transport_instance_init (RygelAVTransport * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	self->priv = rygel_av_transport_get_instance_private (self);
	_tmp0_ = g_strdup ("OK");
	self->priv->_status = _tmp0_;
}

static void
rygel_av_transport_finalize (GObject * obj)
{
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	_g_object_unref0 (self->priv->session);
	_g_free0 (self->priv->protocol_info);
	_g_free0 (self->priv->_status);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	_g_object_unref0 (self->priv->controller);
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_av_transport_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
	GType rygel_av_transport_type_id;
	rygel_av_transport_type_id = g_type_register_static (gupnp_service_get_type (), "RygelAVTransport", &g_define_type_info, 0);
	RygelAVTransport_private_offset = g_type_add_instance_private (rygel_av_transport_type_id, sizeof (RygelAVTransportPrivate));
	return rygel_av_transport_type_id;
}

GType
rygel_av_transport_get_type (void)
{
	static volatile gsize rygel_av_transport_type_id__once = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__once)) {
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = rygel_av_transport_get_type_once ();
		g_once_init_leave (&rygel_av_transport_type_id__once, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__once;
}

static void
_vala_rygel_av_transport_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_STATUS_PROPERTY:
		g_value_set_string (value, rygel_av_transport_get_status (self));
		break;
		case RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM_PROPERTY:
		g_value_set_string (value, rygel_av_transport_get_playback_medium (self));
		break;
		case RYGEL_AV_TRANSPORT_POSSIBLE_PLAYBACK_MEDIA_PROPERTY:
		g_value_set_string (value, rygel_av_transport_get_possible_playback_media (self));
		break;
		case RYGEL_AV_TRANSPORT_SPEED_PROPERTY:
		g_value_take_string (value, rygel_av_transport_get_speed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_av_transport_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_STATUS_PROPERTY:
		rygel_av_transport_set_status (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_SPEED_PROPERTY:
		rygel_av_transport_set_speed (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

