/* localsearch-interfaces.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-interfaces.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy RygelLocalSearchStatsIfaceProxy;
typedef GDBusProxyClass RygelLocalSearchStatsIfaceProxyClass;
typedef GDBusProxy RygelLocalSearchResourcesIfaceProxy;
typedef GDBusProxyClass RygelLocalSearchResourcesIfaceProxyClass;
typedef struct _RygelLocalSearchResourcesIfaceSparqlQueryReadyData RygelLocalSearchResourcesIfaceSparqlQueryReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelLocalSearchResourcesIfaceSparqlUpdateReadyData RygelLocalSearchResourcesIfaceSparqlUpdateReadyData;
typedef struct _RygelLocalSearchResourcesIfaceSparqlUpdateBlankReadyData RygelLocalSearchResourcesIfaceSparqlUpdateBlankReadyData;
typedef GDBusProxy RygelLocalSearchMinerFilesIndexIfaceProxy;
typedef GDBusProxyClass RygelLocalSearchMinerFilesIndexIfaceProxyClass;
typedef struct _RygelLocalSearchMinerFilesIndexIfaceIndexFileReadyData RygelLocalSearchMinerFilesIndexIfaceIndexFileReadyData;

struct _RygelLocalSearchResourcesIfaceSparqlQueryReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* query;
};

struct _RygelLocalSearchResourcesIfaceSparqlUpdateReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* query;
};

struct _RygelLocalSearchResourcesIfaceSparqlUpdateBlankReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* query;
};

struct _RygelLocalSearchMinerFilesIndexIfaceIndexFileReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* uri;
};

static GType rygel_local_search_stats_iface_get_type_once (void);
static void rygel_local_search_stats_iface_proxy_g_signal (GDBusProxy* proxy,
                                                    const gchar* sender_name,
                                                    const gchar* signal_name,
                                                    GVariant* parameters);
static gchar** rygel_local_search_stats_iface_proxy_get (RygelLocalSearchStatsIface* self,
                                                  gint* result_length1,
                                                  gint* result_length2,
                                                  GError** error);
static void rygel_local_search_stats_iface_proxy_rygel_local_search_stats_iface_interface_init (RygelLocalSearchStatsIfaceIface* iface);
static void _dbus_rygel_local_search_stats_iface_get (RygelLocalSearchStatsIface* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void rygel_local_search_stats_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* method_name,
                                                                GVariant* parameters,
                                                                GDBusMethodInvocation* invocation,
                                                                gpointer user_data);
static GVariant* rygel_local_search_stats_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GError** error,
                                                                      gpointer user_data);
static gboolean rygel_local_search_stats_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* property_name,
                                                                     GVariant* value,
                                                                     GError** error,
                                                                     gpointer user_data);
static void _rygel_local_search_stats_iface_unregister_object (gpointer user_data);
static GType rygel_local_search_resources_iface_get_type_once (void);
static void rygel_local_search_resources_iface_proxy_g_signal (GDBusProxy* proxy,
                                                        const gchar* sender_name,
                                                        const gchar* signal_name,
                                                        GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void rygel_local_search_resources_iface_proxy_sparql_query_async (RygelLocalSearchResourcesIface* self,
                                                                  const gchar* query,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static gchar** rygel_local_search_resources_iface_proxy_sparql_query_finish (RygelLocalSearchResourcesIface* self,
                                                                      GAsyncResult* _res_,
                                                                      gint* result_length1,
                                                                      gint* result_length2,
                                                                      GError** error);
static void rygel_local_search_resources_iface_proxy_sparql_update_async (RygelLocalSearchResourcesIface* self,
                                                                   const gchar* query,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static void rygel_local_search_resources_iface_proxy_sparql_update_finish (RygelLocalSearchResourcesIface* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
static void rygel_local_search_resources_iface_proxy_sparql_update_blank_async (RygelLocalSearchResourcesIface* self,
                                                                         const gchar* query,
                                                                         GAsyncReadyCallback _callback_,
                                                                         gpointer _user_data_);
static GHashTable** rygel_local_search_resources_iface_proxy_sparql_update_blank_finish (RygelLocalSearchResourcesIface* self,
                                                                                  GAsyncResult* _res_,
                                                                                  gint* result_length1,
                                                                                  gint* result_length2,
                                                                                  GError** error);
static void rygel_local_search_resources_iface_proxy_rygel_local_search_resources_iface_interface_init (RygelLocalSearchResourcesIfaceIface* iface);
static void _dbus_rygel_local_search_resources_iface_sparql_query (RygelLocalSearchResourcesIface* self,
                                                            GVariant* _parameters_,
                                                            GDBusMethodInvocation* invocation);
static void _dbus_rygel_local_search_resources_iface_sparql_query_ready (GObject * source_object,
                                                                  GAsyncResult * _res_,
                                                                  gpointer _user_data_);
static void _dbus_rygel_local_search_resources_iface_sparql_update (RygelLocalSearchResourcesIface* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation);
static void _dbus_rygel_local_search_resources_iface_sparql_update_ready (GObject * source_object,
                                                                   GAsyncResult * _res_,
                                                                   gpointer _user_data_);
static void _dbus_rygel_local_search_resources_iface_sparql_update_blank (RygelLocalSearchResourcesIface* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation);
static void _dbus_rygel_local_search_resources_iface_sparql_update_blank_ready (GObject * source_object,
                                                                         GAsyncResult * _res_,
                                                                         gpointer _user_data_);
static void rygel_local_search_resources_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                                    const gchar* sender,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    const gchar* method_name,
                                                                    GVariant* parameters,
                                                                    GDBusMethodInvocation* invocation,
                                                                    gpointer user_data);
static GVariant* rygel_local_search_resources_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GError** error,
                                                                          gpointer user_data);
static gboolean rygel_local_search_resources_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                                         const gchar* sender,
                                                                         const gchar* object_path,
                                                                         const gchar* interface_name,
                                                                         const gchar* property_name,
                                                                         GVariant* value,
                                                                         GError** error,
                                                                         gpointer user_data);
static void _rygel_local_search_resources_iface_unregister_object (gpointer user_data);
static GType rygel_local_search_miner_files_index_iface_get_type_once (void);
static void rygel_local_search_miner_files_index_iface_proxy_g_signal (GDBusProxy* proxy,
                                                                const gchar* sender_name,
                                                                const gchar* signal_name,
                                                                GVariant* parameters);
static void rygel_local_search_miner_files_index_iface_proxy_index_file_async (RygelLocalSearchMinerFilesIndexIface* self,
                                                                        const gchar* uri,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static void rygel_local_search_miner_files_index_iface_proxy_index_file_finish (RygelLocalSearchMinerFilesIndexIface* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error);
static void rygel_local_search_miner_files_index_iface_proxy_rygel_local_search_miner_files_index_iface_interface_init (RygelLocalSearchMinerFilesIndexIfaceIface* iface);
static void _dbus_rygel_local_search_miner_files_index_iface_index_file (RygelLocalSearchMinerFilesIndexIface* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void _dbus_rygel_local_search_miner_files_index_iface_index_file_ready (GObject * source_object,
                                                                        GAsyncResult * _res_,
                                                                        gpointer _user_data_);
static void rygel_local_search_miner_files_index_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                                            const gchar* sender,
                                                                            const gchar* object_path,
                                                                            const gchar* interface_name,
                                                                            const gchar* method_name,
                                                                            GVariant* parameters,
                                                                            GDBusMethodInvocation* invocation,
                                                                            gpointer user_data);
static GVariant* rygel_local_search_miner_files_index_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                                                  const gchar* sender,
                                                                                  const gchar* object_path,
                                                                                  const gchar* interface_name,
                                                                                  const gchar* property_name,
                                                                                  GError** error,
                                                                                  gpointer user_data);
static gboolean rygel_local_search_miner_files_index_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                                                 const gchar* sender,
                                                                                 const gchar* object_path,
                                                                                 const gchar* interface_name,
                                                                                 const gchar* property_name,
                                                                                 GVariant* value,
                                                                                 GError** error,
                                                                                 gpointer user_data);
static void _rygel_local_search_miner_files_index_iface_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _rygel_local_search_stats_iface_dbus_arg_info_get_result = {-1, "result", "aas", NULL};
static const GDBusArgInfo * const _rygel_local_search_stats_iface_dbus_arg_info_get_in[] = {NULL};
static const GDBusArgInfo * const _rygel_local_search_stats_iface_dbus_arg_info_get_out[] = {&_rygel_local_search_stats_iface_dbus_arg_info_get_result, NULL};
static const GDBusMethodInfo _rygel_local_search_stats_iface_dbus_method_info_get = {-1, "Get", (GDBusArgInfo **) (&_rygel_local_search_stats_iface_dbus_arg_info_get_in), (GDBusArgInfo **) (&_rygel_local_search_stats_iface_dbus_arg_info_get_out), NULL};
static const GDBusMethodInfo * const _rygel_local_search_stats_iface_dbus_method_info[] = {&_rygel_local_search_stats_iface_dbus_method_info_get, NULL};
static const GDBusSignalInfo * const _rygel_local_search_stats_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _rygel_local_search_stats_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _rygel_local_search_stats_iface_dbus_interface_info = {-1, "org.freedesktop.LocalSearch1.Statistics", (GDBusMethodInfo **) (&_rygel_local_search_stats_iface_dbus_method_info), (GDBusSignalInfo **) (&_rygel_local_search_stats_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_rygel_local_search_stats_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _rygel_local_search_stats_iface_dbus_interface_vtable = {rygel_local_search_stats_iface_dbus_interface_method_call, rygel_local_search_stats_iface_dbus_interface_get_property, rygel_local_search_stats_iface_dbus_interface_set_property};
static const GDBusArgInfo _rygel_local_search_resources_iface_dbus_arg_info_sparql_query_query = {-1, "query", "s", NULL};
static const GDBusArgInfo _rygel_local_search_resources_iface_dbus_arg_info_sparql_query_result = {-1, "result", "aas", NULL};
static const GDBusArgInfo * const _rygel_local_search_resources_iface_dbus_arg_info_sparql_query_in[] = {&_rygel_local_search_resources_iface_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _rygel_local_search_resources_iface_dbus_arg_info_sparql_query_out[] = {&_rygel_local_search_resources_iface_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _rygel_local_search_resources_iface_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_rygel_local_search_resources_iface_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_rygel_local_search_resources_iface_dbus_arg_info_sparql_query_out), NULL};
static const GDBusArgInfo _rygel_local_search_resources_iface_dbus_arg_info_sparql_update_query = {-1, "query", "s", NULL};
static const GDBusArgInfo * const _rygel_local_search_resources_iface_dbus_arg_info_sparql_update_in[] = {&_rygel_local_search_resources_iface_dbus_arg_info_sparql_update_query, NULL};
static const GDBusArgInfo * const _rygel_local_search_resources_iface_dbus_arg_info_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _rygel_local_search_resources_iface_dbus_method_info_sparql_update = {-1, "SparqlUpdate", (GDBusArgInfo **) (&_rygel_local_search_resources_iface_dbus_arg_info_sparql_update_in), (GDBusArgInfo **) (&_rygel_local_search_resources_iface_dbus_arg_info_sparql_update_out), NULL};
static const GDBusArgInfo _rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_query = {-1, "query", "s", NULL};
static const GDBusArgInfo _rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_result = {-1, "result", "aaa{ss}", NULL};
static const GDBusArgInfo * const _rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_in[] = {&_rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_query, NULL};
static const GDBusArgInfo * const _rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_out[] = {&_rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_result, NULL};
static const GDBusMethodInfo _rygel_local_search_resources_iface_dbus_method_info_sparql_update_blank = {-1, "SparqlUpdateBlank", (GDBusArgInfo **) (&_rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_in), (GDBusArgInfo **) (&_rygel_local_search_resources_iface_dbus_arg_info_sparql_update_blank_out), NULL};
static const GDBusMethodInfo * const _rygel_local_search_resources_iface_dbus_method_info[] = {&_rygel_local_search_resources_iface_dbus_method_info_sparql_query, &_rygel_local_search_resources_iface_dbus_method_info_sparql_update, &_rygel_local_search_resources_iface_dbus_method_info_sparql_update_blank, NULL};
static const GDBusSignalInfo * const _rygel_local_search_resources_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _rygel_local_search_resources_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _rygel_local_search_resources_iface_dbus_interface_info = {-1, "org.freedesktop.LocalSearch1.Resources", (GDBusMethodInfo **) (&_rygel_local_search_resources_iface_dbus_method_info), (GDBusSignalInfo **) (&_rygel_local_search_resources_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_rygel_local_search_resources_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _rygel_local_search_resources_iface_dbus_interface_vtable = {rygel_local_search_resources_iface_dbus_interface_method_call, rygel_local_search_resources_iface_dbus_interface_get_property, rygel_local_search_resources_iface_dbus_interface_set_property};
static const GDBusArgInfo _rygel_local_search_miner_files_index_iface_dbus_arg_info_index_file_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo * const _rygel_local_search_miner_files_index_iface_dbus_arg_info_index_file_in[] = {&_rygel_local_search_miner_files_index_iface_dbus_arg_info_index_file_uri, NULL};
static const GDBusArgInfo * const _rygel_local_search_miner_files_index_iface_dbus_arg_info_index_file_out[] = {NULL};
static const GDBusMethodInfo _rygel_local_search_miner_files_index_iface_dbus_method_info_index_file = {-1, "IndexFile", (GDBusArgInfo **) (&_rygel_local_search_miner_files_index_iface_dbus_arg_info_index_file_in), (GDBusArgInfo **) (&_rygel_local_search_miner_files_index_iface_dbus_arg_info_index_file_out), NULL};
static const GDBusMethodInfo * const _rygel_local_search_miner_files_index_iface_dbus_method_info[] = {&_rygel_local_search_miner_files_index_iface_dbus_method_info_index_file, NULL};
static const GDBusSignalInfo * const _rygel_local_search_miner_files_index_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _rygel_local_search_miner_files_index_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _rygel_local_search_miner_files_index_iface_dbus_interface_info = {-1, "org.freedesktop.LocalSearch1.Miner.Files.Index", (GDBusMethodInfo **) (&_rygel_local_search_miner_files_index_iface_dbus_method_info), (GDBusSignalInfo **) (&_rygel_local_search_miner_files_index_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_rygel_local_search_miner_files_index_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _rygel_local_search_miner_files_index_iface_dbus_interface_vtable = {rygel_local_search_miner_files_index_iface_dbus_interface_method_call, rygel_local_search_miner_files_index_iface_dbus_interface_get_property, rygel_local_search_miner_files_index_iface_dbus_interface_set_property};

Event*
event_dup (const Event* self)
{
	Event* dup;
	dup = g_new0 (Event, 1);
	memcpy (dup, self, sizeof (Event));
	return dup;
}

void
event_free (Event* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
event_get_type_once (void)
{
	GType event_type_id;
	event_type_id = g_boxed_type_register_static ("Event", (GBoxedCopyFunc) event_dup, (GBoxedFreeFunc) event_free);
	return event_type_id;
}

GType
event_get_type (void)
{
	static volatile gsize event_type_id__once = 0;
	if (g_once_init_enter (&event_type_id__once)) {
		GType event_type_id;
		event_type_id = event_get_type_once ();
		g_once_init_leave (&event_type_id__once, event_type_id);
	}
	return event_type_id__once;
}

gchar**
rygel_local_search_stats_iface_get (RygelLocalSearchStatsIface* self,
                                    gint* result_length1,
                                    gint* result_length2,
                                    GError** error)
{
	RygelLocalSearchStatsIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_LOCAL_SEARCH_STATS_IFACE_GET_INTERFACE (self);
	if (_iface_->get) {
		return _iface_->get (self, result_length1, result_length2, error);
	}
	return NULL;
}

static void
rygel_local_search_stats_iface_default_init (RygelLocalSearchStatsIfaceIface * iface,
                                             gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
rygel_local_search_stats_iface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchStatsIfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_stats_iface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_local_search_stats_iface_type_id;
	rygel_local_search_stats_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelLocalSearchStatsIface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_local_search_stats_iface_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (rygel_local_search_stats_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) rygel_local_search_stats_iface_proxy_get_type);
	g_type_set_qdata (rygel_local_search_stats_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.LocalSearch1.Statistics");
	g_type_set_qdata (rygel_local_search_stats_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_rygel_local_search_stats_iface_dbus_interface_info));
	g_type_set_qdata (rygel_local_search_stats_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) rygel_local_search_stats_iface_register_object);
	return rygel_local_search_stats_iface_type_id;
}

GType
rygel_local_search_stats_iface_get_type (void)
{
	static volatile gsize rygel_local_search_stats_iface_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_stats_iface_type_id__once)) {
		GType rygel_local_search_stats_iface_type_id;
		rygel_local_search_stats_iface_type_id = rygel_local_search_stats_iface_get_type_once ();
		g_once_init_leave (&rygel_local_search_stats_iface_type_id__once, rygel_local_search_stats_iface_type_id);
	}
	return rygel_local_search_stats_iface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (RygelLocalSearchStatsIfaceProxy, rygel_local_search_stats_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_LOCAL_SEARCH_TYPE_STATS_IFACE, rygel_local_search_stats_iface_proxy_rygel_local_search_stats_iface_interface_init) )
static void
rygel_local_search_stats_iface_proxy_class_init (RygelLocalSearchStatsIfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = rygel_local_search_stats_iface_proxy_g_signal;
}

static void
rygel_local_search_stats_iface_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters)
{
}

static void
rygel_local_search_stats_iface_proxy_init (RygelLocalSearchStatsIfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_rygel_local_search_stats_iface_dbus_interface_info));
}

static gchar**
rygel_local_search_stats_iface_proxy_get (RygelLocalSearchStatsIface* self,
                                          gint* result_length1,
                                          gint* result_length2,
                                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	gint _result_length2;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.LocalSearch1.Statistics", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		gint _tmp1__length2;
		GVariantIter _tmp4_;
		GVariant* _tmp5_;
		_tmp1__length2 = 0;
		g_variant_iter_init (&_tmp4_, _tmp3_);
		for (; (_tmp5_ = g_variant_iter_next_value (&_tmp4_)) != NULL; _tmp1__length2++) {
			if (_tmp1__size == _tmp1__length) {
				_tmp1__size = 2 * _tmp1__size;
				_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
			}
			_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp5_, NULL);
			g_variant_unref (_tmp5_);
		}
		_result_length2 = _tmp1__length2;
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}

static void
rygel_local_search_stats_iface_proxy_rygel_local_search_stats_iface_interface_init (RygelLocalSearchStatsIfaceIface* iface)
{
	iface->get = rygel_local_search_stats_iface_proxy_get;
}

static void
_dbus_rygel_local_search_stats_iface_get (RygelLocalSearchStatsIface* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gint result_length2 = 0;
	gchar** _tmp6_;
	GVariantBuilder _tmp7_;
	gint _tmp8_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = rygel_local_search_stats_iface_get (self, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp6_ = result;
	g_variant_builder_init (&_tmp7_, G_VARIANT_TYPE ("aas"));
	for (_tmp8_ = 0; _tmp8_ < result_length1; _tmp8_++) {
		GVariantBuilder _tmp9_;
		gint _tmp10_;
		g_variant_builder_init (&_tmp9_, G_VARIANT_TYPE ("as"));
		for (_tmp10_ = 0; _tmp10_ < result_length2; _tmp10_++) {
			g_variant_builder_add_value (&_tmp9_, g_variant_new_string (*_tmp6_));
			_tmp6_++;
		}
		g_variant_builder_add_value (&_tmp7_, g_variant_builder_end (&_tmp9_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp7_));
	result = (_vala_array_free (result, result_length1 * result_length2, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
rygel_local_search_stats_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Get") == 0) {
		_dbus_rygel_local_search_stats_iface_get (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
rygel_local_search_stats_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
rygel_local_search_stats_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
rygel_local_search_stats_iface_register_object (gpointer object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_rygel_local_search_stats_iface_dbus_interface_info), &_rygel_local_search_stats_iface_dbus_interface_vtable, data, _rygel_local_search_stats_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_rygel_local_search_stats_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
rygel_local_search_resources_iface_sparql_query (RygelLocalSearchResourcesIface* self,
                                                 const gchar* query,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	RygelLocalSearchResourcesIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_RESOURCES_IFACE_GET_INTERFACE (self);
	if (_iface_->sparql_query) {
		_iface_->sparql_query (self, query, _callback_, _user_data_);
	}
}

gchar**
rygel_local_search_resources_iface_sparql_query_finish (RygelLocalSearchResourcesIface* self,
                                                        GAsyncResult* _res_,
                                                        gint* result_length1,
                                                        gint* result_length2,
                                                        GError** error)
{
	RygelLocalSearchResourcesIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_RESOURCES_IFACE_GET_INTERFACE (self);
	if (_iface_->sparql_query_finish) {
		return _iface_->sparql_query_finish (self, _res_, result_length1, result_length2, error);
	}
	return NULL;
}

void
rygel_local_search_resources_iface_sparql_update (RygelLocalSearchResourcesIface* self,
                                                  const gchar* query,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	RygelLocalSearchResourcesIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_RESOURCES_IFACE_GET_INTERFACE (self);
	if (_iface_->sparql_update) {
		_iface_->sparql_update (self, query, _callback_, _user_data_);
	}
}

void
rygel_local_search_resources_iface_sparql_update_finish (RygelLocalSearchResourcesIface* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	RygelLocalSearchResourcesIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_RESOURCES_IFACE_GET_INTERFACE (self);
	if (_iface_->sparql_update_finish) {
		_iface_->sparql_update_finish (self, _res_, error);
	}
}

void
rygel_local_search_resources_iface_sparql_update_blank (RygelLocalSearchResourcesIface* self,
                                                        const gchar* query,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	RygelLocalSearchResourcesIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_RESOURCES_IFACE_GET_INTERFACE (self);
	if (_iface_->sparql_update_blank) {
		_iface_->sparql_update_blank (self, query, _callback_, _user_data_);
	}
}

GHashTable**
rygel_local_search_resources_iface_sparql_update_blank_finish (RygelLocalSearchResourcesIface* self,
                                                               GAsyncResult* _res_,
                                                               gint* result_length1,
                                                               gint* result_length2,
                                                               GError** error)
{
	RygelLocalSearchResourcesIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_RESOURCES_IFACE_GET_INTERFACE (self);
	if (_iface_->sparql_update_blank_finish) {
		return _iface_->sparql_update_blank_finish (self, _res_, result_length1, result_length2, error);
	}
	return NULL;
}

static void
rygel_local_search_resources_iface_default_init (RygelLocalSearchResourcesIfaceIface * iface,
                                                 gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
rygel_local_search_resources_iface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchResourcesIfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_resources_iface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_local_search_resources_iface_type_id;
	rygel_local_search_resources_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelLocalSearchResourcesIface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_local_search_resources_iface_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (rygel_local_search_resources_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) rygel_local_search_resources_iface_proxy_get_type);
	g_type_set_qdata (rygel_local_search_resources_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.LocalSearch1.Resources");
	g_type_set_qdata (rygel_local_search_resources_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_rygel_local_search_resources_iface_dbus_interface_info));
	g_type_set_qdata (rygel_local_search_resources_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) rygel_local_search_resources_iface_register_object);
	return rygel_local_search_resources_iface_type_id;
}

GType
rygel_local_search_resources_iface_get_type (void)
{
	static volatile gsize rygel_local_search_resources_iface_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_resources_iface_type_id__once)) {
		GType rygel_local_search_resources_iface_type_id;
		rygel_local_search_resources_iface_type_id = rygel_local_search_resources_iface_get_type_once ();
		g_once_init_leave (&rygel_local_search_resources_iface_type_id__once, rygel_local_search_resources_iface_type_id);
	}
	return rygel_local_search_resources_iface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (RygelLocalSearchResourcesIfaceProxy, rygel_local_search_resources_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_LOCAL_SEARCH_TYPE_RESOURCES_IFACE, rygel_local_search_resources_iface_proxy_rygel_local_search_resources_iface_interface_init) )
static void
rygel_local_search_resources_iface_proxy_class_init (RygelLocalSearchResourcesIfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = rygel_local_search_resources_iface_proxy_g_signal;
}

static void
rygel_local_search_resources_iface_proxy_g_signal (GDBusProxy* proxy,
                                                   const gchar* sender_name,
                                                   const gchar* signal_name,
                                                   GVariant* parameters)
{
}

static void
rygel_local_search_resources_iface_proxy_init (RygelLocalSearchResourcesIfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_rygel_local_search_resources_iface_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
rygel_local_search_resources_iface_proxy_sparql_query_async (RygelLocalSearchResourcesIface* self,
                                                             const gchar* query,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.LocalSearch1.Resources", "SparqlQuery");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static gchar**
rygel_local_search_resources_iface_proxy_sparql_query_finish (RygelLocalSearchResourcesIface* self,
                                                              GAsyncResult* _res_,
                                                              gint* result_length1,
                                                              gint* result_length2,
                                                              GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	gint _result_length2;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp11_ = g_variant_iter_next_value (&_reply_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		gint _tmp12__length2;
		GVariantIter _tmp15_;
		GVariant* _tmp16_;
		_tmp12__length2 = 0;
		g_variant_iter_init (&_tmp15_, _tmp14_);
		for (; (_tmp16_ = g_variant_iter_next_value (&_tmp15_)) != NULL; _tmp12__length2++) {
			if (_tmp12__size == _tmp12__length) {
				_tmp12__size = 2 * _tmp12__size;
				_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
			}
			_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp16_, NULL);
			g_variant_unref (_tmp16_);
		}
		_result_length2 = _tmp12__length2;
		g_variant_unref (_tmp14_);
	}
	_result_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	_result = _tmp12_;
	g_variant_unref (_tmp11_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}

static void
rygel_local_search_resources_iface_proxy_sparql_update_async (RygelLocalSearchResourcesIface* self,
                                                              const gchar* query,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.LocalSearch1.Resources", "SparqlUpdate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
rygel_local_search_resources_iface_proxy_sparql_update_finish (RygelLocalSearchResourcesIface* self,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
rygel_local_search_resources_iface_proxy_sparql_update_blank_async (RygelLocalSearchResourcesIface* self,
                                                                    const gchar* query,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.LocalSearch1.Resources", "SparqlUpdateBlank");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static GHashTable**
rygel_local_search_resources_iface_proxy_sparql_update_blank_finish (RygelLocalSearchResourcesIface* self,
                                                                     GAsyncResult* _res_,
                                                                     gint* result_length1,
                                                                     gint* result_length2,
                                                                     GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable** _result = NULL;
	gint _result_length1;
	gint _result_length2;
	GVariant* _tmp17_;
	GHashTable** _tmp18_;
	gint _tmp18__length;
	gint _tmp18__size;
	gint _tmp18__length1;
	GVariantIter _tmp19_;
	GVariant* _tmp20_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp17_ = g_variant_iter_next_value (&_reply_iter);
	_tmp18_ = g_new (GHashTable*, 5);
	_tmp18__length = 0;
	_tmp18__size = 4;
	_tmp18__length1 = 0;
	g_variant_iter_init (&_tmp19_, _tmp17_);
	for (; (_tmp20_ = g_variant_iter_next_value (&_tmp19_)) != NULL; _tmp18__length1++) {
		gint _tmp18__length2;
		GVariantIter _tmp21_;
		GVariant* _tmp22_;
		_tmp18__length2 = 0;
		g_variant_iter_init (&_tmp21_, _tmp20_);
		for (; (_tmp22_ = g_variant_iter_next_value (&_tmp21_)) != NULL; _tmp18__length2++) {
			GHashTable* _tmp23_;
			GVariantIter _tmp24_;
			GVariant* _tmp25_;
			GVariant* _tmp26_;
			if (_tmp18__size == _tmp18__length) {
				_tmp18__size = 2 * _tmp18__size;
				_tmp18_ = g_renew (GHashTable*, _tmp18_, _tmp18__size + 1);
			}
			_tmp23_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
			g_variant_iter_init (&_tmp24_, _tmp22_);
			while (g_variant_iter_loop (&_tmp24_, "{?*}", &_tmp25_, &_tmp26_)) {
				g_hash_table_insert (_tmp23_, g_variant_dup_string (_tmp25_, NULL), g_variant_dup_string (_tmp26_, NULL));
			}
			_tmp18_[_tmp18__length++] = _tmp23_;
			g_variant_unref (_tmp22_);
		}
		_result_length2 = _tmp18__length2;
		g_variant_unref (_tmp20_);
	}
	_result_length1 = _tmp18__length1;
	_tmp18_[_tmp18__length] = NULL;
	_result = _tmp18_;
	g_variant_unref (_tmp17_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}

static void
rygel_local_search_resources_iface_proxy_rygel_local_search_resources_iface_interface_init (RygelLocalSearchResourcesIfaceIface* iface)
{
	iface->sparql_query = rygel_local_search_resources_iface_proxy_sparql_query_async;
	iface->sparql_query_finish = rygel_local_search_resources_iface_proxy_sparql_query_finish;
	iface->sparql_update = rygel_local_search_resources_iface_proxy_sparql_update_async;
	iface->sparql_update_finish = rygel_local_search_resources_iface_proxy_sparql_update_finish;
	iface->sparql_update_blank = rygel_local_search_resources_iface_proxy_sparql_update_blank_async;
	iface->sparql_update_blank_finish = rygel_local_search_resources_iface_proxy_sparql_update_blank_finish;
}

static void
_dbus_rygel_local_search_resources_iface_sparql_query (RygelLocalSearchResourcesIface* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	RygelLocalSearchResourcesIfaceSparqlQueryReadyData* _ready_data;
	GVariant* _tmp27_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (RygelLocalSearchResourcesIfaceSparqlQueryReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->query = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	rygel_local_search_resources_iface_sparql_query (self, _ready_data->query, (GAsyncReadyCallback) _dbus_rygel_local_search_resources_iface_sparql_query_ready, _ready_data);
	_error:
	;
}

static void
_dbus_rygel_local_search_resources_iface_sparql_query_ready (GObject * source_object,
                                                             GAsyncResult * _res_,
                                                             gpointer _user_data_)
{
	RygelLocalSearchResourcesIfaceSparqlQueryReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gint result_length2 = 0;
	gchar** _tmp28_;
	GVariantBuilder _tmp29_;
	gint _tmp30_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = rygel_local_search_resources_iface_sparql_query_finish ((RygelLocalSearchResourcesIface*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp28_ = result;
	g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE ("aas"));
	for (_tmp30_ = 0; _tmp30_ < result_length1; _tmp30_++) {
		GVariantBuilder _tmp31_;
		gint _tmp32_;
		g_variant_builder_init (&_tmp31_, G_VARIANT_TYPE ("as"));
		for (_tmp32_ = 0; _tmp32_ < result_length2; _tmp32_++) {
			g_variant_builder_add_value (&_tmp31_, g_variant_new_string (*_tmp28_));
			_tmp28_++;
		}
		g_variant_builder_add_value (&_tmp29_, g_variant_builder_end (&_tmp31_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp29_));
	result = (_vala_array_free (result, result_length1 * result_length2, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->query);
	g_slice_free (RygelLocalSearchResourcesIfaceSparqlQueryReadyData, _ready_data);
}

static void
_dbus_rygel_local_search_resources_iface_sparql_update (RygelLocalSearchResourcesIface* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	RygelLocalSearchResourcesIfaceSparqlUpdateReadyData* _ready_data;
	GVariant* _tmp33_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (RygelLocalSearchResourcesIfaceSparqlUpdateReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->query = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	rygel_local_search_resources_iface_sparql_update (self, _ready_data->query, (GAsyncReadyCallback) _dbus_rygel_local_search_resources_iface_sparql_update_ready, _ready_data);
	_error:
	;
}

static void
_dbus_rygel_local_search_resources_iface_sparql_update_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_)
{
	RygelLocalSearchResourcesIfaceSparqlUpdateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	rygel_local_search_resources_iface_sparql_update_finish ((RygelLocalSearchResourcesIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->query);
	g_slice_free (RygelLocalSearchResourcesIfaceSparqlUpdateReadyData, _ready_data);
}

static void
_dbus_rygel_local_search_resources_iface_sparql_update_blank (RygelLocalSearchResourcesIface* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	RygelLocalSearchResourcesIfaceSparqlUpdateBlankReadyData* _ready_data;
	GVariant* _tmp34_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (RygelLocalSearchResourcesIfaceSparqlUpdateBlankReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->query = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	rygel_local_search_resources_iface_sparql_update_blank (self, _ready_data->query, (GAsyncReadyCallback) _dbus_rygel_local_search_resources_iface_sparql_update_blank_ready, _ready_data);
	_error:
	;
}

static void
_dbus_rygel_local_search_resources_iface_sparql_update_blank_ready (GObject * source_object,
                                                                    GAsyncResult * _res_,
                                                                    gpointer _user_data_)
{
	RygelLocalSearchResourcesIfaceSparqlUpdateBlankReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	gint result_length2 = 0;
	GHashTable** _tmp35_;
	GVariantBuilder _tmp36_;
	gint _tmp37_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = rygel_local_search_resources_iface_sparql_update_blank_finish ((RygelLocalSearchResourcesIface*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp35_ = result;
	g_variant_builder_init (&_tmp36_, G_VARIANT_TYPE ("aaa{ss}"));
	for (_tmp37_ = 0; _tmp37_ < result_length1; _tmp37_++) {
		GVariantBuilder _tmp38_;
		gint _tmp39_;
		g_variant_builder_init (&_tmp38_, G_VARIANT_TYPE ("aa{ss}"));
		for (_tmp39_ = 0; _tmp39_ < result_length2; _tmp39_++) {
			GVariantBuilder _tmp40_;
			GHashTableIter _tmp41_;
			gpointer _tmp42_;
			gpointer _tmp43_;
			g_hash_table_iter_init (&_tmp41_, *_tmp35_);
			g_variant_builder_init (&_tmp40_, G_VARIANT_TYPE ("a{ss}"));
			while (g_hash_table_iter_next (&_tmp41_, &_tmp42_, &_tmp43_)) {
				gchar* _key;
				gchar* _value;
				_key = (gchar*) _tmp42_;
				_value = (gchar*) _tmp43_;
				g_variant_builder_add (&_tmp40_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
			}
			g_variant_builder_add_value (&_tmp38_, g_variant_builder_end (&_tmp40_));
			_tmp35_++;
		}
		g_variant_builder_add_value (&_tmp36_, g_variant_builder_end (&_tmp38_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp36_));
	result = (_vala_array_free (result, result_length1 * result_length2, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->query);
	g_slice_free (RygelLocalSearchResourcesIfaceSparqlUpdateBlankReadyData, _ready_data);
}

static void
rygel_local_search_resources_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* method_name,
                                                               GVariant* parameters,
                                                               GDBusMethodInvocation* invocation,
                                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_rygel_local_search_resources_iface_sparql_query (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdate") == 0) {
		_dbus_rygel_local_search_resources_iface_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdateBlank") == 0) {
		_dbus_rygel_local_search_resources_iface_sparql_update_blank (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
rygel_local_search_resources_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
rygel_local_search_resources_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
rygel_local_search_resources_iface_register_object (gpointer object,
                                                    GDBusConnection* connection,
                                                    const gchar* path,
                                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_rygel_local_search_resources_iface_dbus_interface_info), &_rygel_local_search_resources_iface_dbus_interface_vtable, data, _rygel_local_search_resources_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_rygel_local_search_resources_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
rygel_local_search_miner_files_index_iface_index_file (RygelLocalSearchMinerFilesIndexIface* self,
                                                       const gchar* uri,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	RygelLocalSearchMinerFilesIndexIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_MINER_FILES_INDEX_IFACE_GET_INTERFACE (self);
	if (_iface_->index_file) {
		_iface_->index_file (self, uri, _callback_, _user_data_);
	}
}

void
rygel_local_search_miner_files_index_iface_index_file_finish (RygelLocalSearchMinerFilesIndexIface* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	RygelLocalSearchMinerFilesIndexIfaceIface* _iface_;
	_iface_ = RYGEL_LOCAL_SEARCH_MINER_FILES_INDEX_IFACE_GET_INTERFACE (self);
	if (_iface_->index_file_finish) {
		_iface_->index_file_finish (self, _res_, error);
	}
}

static void
rygel_local_search_miner_files_index_iface_default_init (RygelLocalSearchMinerFilesIndexIfaceIface * iface,
                                                         gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
rygel_local_search_miner_files_index_iface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchMinerFilesIndexIfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_miner_files_index_iface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_local_search_miner_files_index_iface_type_id;
	rygel_local_search_miner_files_index_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelLocalSearchMinerFilesIndexIface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_local_search_miner_files_index_iface_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (rygel_local_search_miner_files_index_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) rygel_local_search_miner_files_index_iface_proxy_get_type);
	g_type_set_qdata (rygel_local_search_miner_files_index_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.LocalSearch1.Miner.Files.Index");
	g_type_set_qdata (rygel_local_search_miner_files_index_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_rygel_local_search_miner_files_index_iface_dbus_interface_info));
	g_type_set_qdata (rygel_local_search_miner_files_index_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) rygel_local_search_miner_files_index_iface_register_object);
	return rygel_local_search_miner_files_index_iface_type_id;
}

GType
rygel_local_search_miner_files_index_iface_get_type (void)
{
	static volatile gsize rygel_local_search_miner_files_index_iface_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_miner_files_index_iface_type_id__once)) {
		GType rygel_local_search_miner_files_index_iface_type_id;
		rygel_local_search_miner_files_index_iface_type_id = rygel_local_search_miner_files_index_iface_get_type_once ();
		g_once_init_leave (&rygel_local_search_miner_files_index_iface_type_id__once, rygel_local_search_miner_files_index_iface_type_id);
	}
	return rygel_local_search_miner_files_index_iface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (RygelLocalSearchMinerFilesIndexIfaceProxy, rygel_local_search_miner_files_index_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_LOCAL_SEARCH_TYPE_MINER_FILES_INDEX_IFACE, rygel_local_search_miner_files_index_iface_proxy_rygel_local_search_miner_files_index_iface_interface_init) )
static void
rygel_local_search_miner_files_index_iface_proxy_class_init (RygelLocalSearchMinerFilesIndexIfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = rygel_local_search_miner_files_index_iface_proxy_g_signal;
}

static void
rygel_local_search_miner_files_index_iface_proxy_g_signal (GDBusProxy* proxy,
                                                           const gchar* sender_name,
                                                           const gchar* signal_name,
                                                           GVariant* parameters)
{
}

static void
rygel_local_search_miner_files_index_iface_proxy_init (RygelLocalSearchMinerFilesIndexIfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_rygel_local_search_miner_files_index_iface_dbus_interface_info));
}

static void
rygel_local_search_miner_files_index_iface_proxy_index_file_async (RygelLocalSearchMinerFilesIndexIface* self,
                                                                   const gchar* uri,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.LocalSearch1.Miner.Files.Index", "IndexFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
rygel_local_search_miner_files_index_iface_proxy_index_file_finish (RygelLocalSearchMinerFilesIndexIface* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
rygel_local_search_miner_files_index_iface_proxy_rygel_local_search_miner_files_index_iface_interface_init (RygelLocalSearchMinerFilesIndexIfaceIface* iface)
{
	iface->index_file = rygel_local_search_miner_files_index_iface_proxy_index_file_async;
	iface->index_file_finish = rygel_local_search_miner_files_index_iface_proxy_index_file_finish;
}

static void
_dbus_rygel_local_search_miner_files_index_iface_index_file (RygelLocalSearchMinerFilesIndexIface* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	RygelLocalSearchMinerFilesIndexIfaceIndexFileReadyData* _ready_data;
	GVariant* _tmp44_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (RygelLocalSearchMinerFilesIndexIfaceIndexFileReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp44_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->uri = g_variant_dup_string (_tmp44_, NULL);
	g_variant_unref (_tmp44_);
	rygel_local_search_miner_files_index_iface_index_file (self, _ready_data->uri, (GAsyncReadyCallback) _dbus_rygel_local_search_miner_files_index_iface_index_file_ready, _ready_data);
	_error:
	;
}

static void
_dbus_rygel_local_search_miner_files_index_iface_index_file_ready (GObject * source_object,
                                                                   GAsyncResult * _res_,
                                                                   gpointer _user_data_)
{
	RygelLocalSearchMinerFilesIndexIfaceIndexFileReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	rygel_local_search_miner_files_index_iface_index_file_finish ((RygelLocalSearchMinerFilesIndexIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->uri);
	g_slice_free (RygelLocalSearchMinerFilesIndexIfaceIndexFileReadyData, _ready_data);
}

static void
rygel_local_search_miner_files_index_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* method_name,
                                                                       GVariant* parameters,
                                                                       GDBusMethodInvocation* invocation,
                                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "IndexFile") == 0) {
		_dbus_rygel_local_search_miner_files_index_iface_index_file (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
rygel_local_search_miner_files_index_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* property_name,
                                                                        GError** error,
                                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
rygel_local_search_miner_files_index_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* property_name,
                                                                        GVariant* value,
                                                                        GError** error,
                                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
rygel_local_search_miner_files_index_iface_register_object (gpointer object,
                                                            GDBusConnection* connection,
                                                            const gchar* path,
                                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_rygel_local_search_miner_files_index_iface_dbus_interface_info), &_rygel_local_search_miner_files_index_iface_dbus_interface_vtable, data, _rygel_local_search_miner_files_index_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_rygel_local_search_miner_files_index_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

