/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef AGS_ACHIEVEMENTS_H
#define AGS_ACHIEVEMENTS_H

#include "engines/achievements.h"

namespace AGS {

static const Common::AchievementDescriptionList achievementDescriptionList[] = {
	{"44thejail", Common::STEAM_ACHIEVEMENTS, "2702680"},
	{"adateinthepark", Common::STEAM_ACHIEVEMENTS, "468530"},
	{"absent", Common::STEAM_ACHIEVEMENTS, "398450"},
	{"alemmo", Common::STEAM_ACHIEVEMENTS, "296850"},
	{"alum", Common::STEAM_ACHIEVEMENTS, "338420"},
	{"apotheosis", Common::STEAM_ACHIEVEMENTS, "364350"},
	{"ashinaredwitch", Common::STEAM_ACHIEVEMENTS, "1259140"},
	{"astroloco", Common::STEAM_ACHIEVEMENTS, "357490"},
	{"atotkdeluxe", Common::STEAM_ACHIEVEMENTS, "603870"},
	{"azazelxmas", Common::STEAM_ACHIEVEMENTS, "2163620"},
	{"beer", Common::STEAM_ACHIEVEMENTS, "782280"},
	{"beyondowlsgard", Common::STEAM_ACHIEVEMENTS, "1709730"},
	{"beyondowlsgard", Common::GALAXY_ACHIEVEMENTS, "1086301307"},
	{"bizarreearthquake", Common::STEAM_ACHIEVEMENTS, "1709730"},
	{"blackwell1", Common::GALAXY_ACHIEVEMENTS, "1207662883"},
	{"blackwell1", Common::STEAM_ACHIEVEMENTS, "80330"},
	{"blackwell2", Common::GALAXY_ACHIEVEMENTS, "1207662893"},
	{"blackwell2", Common::STEAM_ACHIEVEMENTS, "80340"},
	{"blackwell3", Common::GALAXY_ACHIEVEMENTS, "1207662903"},
	{"blackwell3", Common::STEAM_ACHIEVEMENTS, "80350"},
	{"blackwell4", Common::GALAXY_ACHIEVEMENTS, "1207662913"},
	{"blackwell4", Common::STEAM_ACHIEVEMENTS, "80360"},
	{"blackwell5", Common::GALAXY_ACHIEVEMENTS, "1207664393"},
	{"blackwell5", Common::STEAM_ACHIEVEMENTS, "236930"},
	{"brownieadv1", Common::STEAM_ACHIEVEMENTS, "2581560"},
	{"brownieadv1", Common::GALAXY_ACHIEVEMENTS, "1855964876"},
	{"captaindisastermoon", Common::STEAM_ACHIEVEMENTS, "1305500"},
	{"castleagony", Common::STEAM_ACHIEVEMENTS, "827830"},
	{"charnelhousetrilogy", Common::STEAM_ACHIEVEMENTS, "288930"},
	{"chronicleofinnsmouth", Common::STEAM_ACHIEVEMENTS, "420180"},
	{"crimsondiamond", Common::STEAM_ACHIEVEMENTS, "1098770"},
	{"crimsondiamond", Common::GALAXY_ACHIEVEMENTS, "1602588462"},
	{"crystalshardadventurebundle", Common::STEAM_ACHIEVEMENTS, "551840"},
	{"detectivebhdino", Common::STEAM_ACHIEVEMENTS, "1343390"},
	{"detectivegallo", Common::GALAXY_ACHIEVEMENTS, "1745746005"},
	{"detectivegallo", Common::STEAM_ACHIEVEMENTS, "556060"},
	{"docapocalypse", Common::STEAM_ACHIEVEMENTS, "509920"},
	{"downfall2016", Common::STEAM_ACHIEVEMENTS, "364390"},
	{"dreamswitchhouse", Common::STEAM_ACHIEVEMENTS, "1902850"},
	{"dreamswitchhouse", Common::GALAXY_ACHIEVEMENTS, "1123332294"},
	{"dustbowl", Common::STEAM_ACHIEVEMENTS, "367110"},
	{"englishhaunting", Common::STEAM_ACHIEVEMENTS, "2474030"},
	{"excavationhb", Common::STEAM_ACHIEVEMENTS, "1182310"},
	{"excavationhb", Common::GALAXY_ACHIEVEMENTS, "1790032718"},
	{"falconcity", Common::STEAM_ACHIEVEMENTS, "1270590"},
	{"feriadarles", Common::STEAM_ACHIEVEMENTS, "1181570"},
	{"footballgame", Common::STEAM_ACHIEVEMENTS, "654550"},
	{"geminirue", Common::GALAXY_ACHIEVEMENTS, "1207659073"},
	{"geminirue", Common::STEAM_ACHIEVEMENTS, "80310"},
	{"gnrblex", Common::STEAM_ACHIEVEMENTS, "1060560"},
	{"goldenwake", Common::STEAM_ACHIEVEMENTS, "307570"},
	{"graceward", Common::STEAM_ACHIEVEMENTS, "2217060"},
	{"grandmabadass", Common::STEAM_ACHIEVEMENTS, "1606640"},
	{"guardduty", Common::GALAXY_ACHIEVEMENTS, "1455980545"},
	{"guardduty", Common::STEAM_ACHIEVEMENTS, "872750"},
	{"herdiscoming", Common::STEAM_ACHIEVEMENTS, "1028740"},
	{"heroinesquest", Common::STEAM_ACHIEVEMENTS, "283880"},
	{"insectophobiaep1", Common::STEAM_ACHIEVEMENTS, "655250"},
	{"ioawn4t", Common::STEAM_ACHIEVEMENTS, "1603980"},
	{"justignorethem", Common::STEAM_ACHIEVEMENTS, "561770"},
	{"justignorethembrea1", Common::STEAM_ACHIEVEMENTS, "1900280"},
	{"kathyrain", Common::GALAXY_ACHIEVEMENTS, "1460710709"},
	{"kathyrain", Common::STEAM_ACHIEVEMENTS, "370910"},
	{"killyourself", Common::STEAM_ACHIEVEMENTS, "1251910"},
	{"lamplightcity", Common::STEAM_ACHIEVEMENTS, "761460"},
	{"lancelothangover", Common::STEAM_ACHIEVEMENTS, "917380"},
	{"legendofhand", Common::STEAM_ACHIEVEMENTS, "595560"},
	{"legendofskye", Common::STEAM_ACHIEVEMENTS, "2314850"},
	{"legendofskye", Common::GALAXY_ACHIEVEMENTS, "1562711791"},
	{"mage", Common::GALAXY_ACHIEVEMENTS, "1469845437"},
	{"mage", Common::STEAM_ACHIEVEMENTS, "270610"},
	{"magretfdb", Common::STEAM_ACHIEVEMENTS, "2661780"},
	{"metaldead", Common::STEAM_ACHIEVEMENTS, "302690"},
	{"metaphobia", Common::STEAM_ACHIEVEMENTS, "1220930"},
	{"mountainsofmadness", Common::STEAM_ACHIEVEMENTS, "962700"},
	{"mybigsister", Common::STEAM_ACHIEVEMENTS, "733300"},
	{"mybigsisterrm", Common::STEAM_ACHIEVEMENTS, "2118540"},
	{"nellycootalot-hd", Common::STEAM_ACHIEVEMENTS, "763030"},
	{"neofeud", Common::STEAM_ACHIEVEMENTS, "673850"},
	{"nightmareframes", Common::STEAM_ACHIEVEMENTS, "1650590"},
	{"oldskies", Common::STEAM_ACHIEVEMENTS, "1346360"},
	{"oldskies", Common::GALAXY_ACHIEVEMENTS, "1391436028"},
	{"oott", Common::GALAXY_ACHIEVEMENTS, "1444830704"},
	{"oott", Common::STEAM_ACHIEVEMENTS, "425600"},
	{"perfecttides", Common::STEAM_ACHIEVEMENTS, "1172800"},
	{"perfecttides", Common::GALAXY_ACHIEVEMENTS, "1321012195"},
	{"personalrocket", Common::STEAM_ACHIEVEMENTS, "1497290"},
	{"phantomfellows", Common::STEAM_ACHIEVEMENTS, "1581490"},
	{"phantomfellows", Common::GALAXY_ACHIEVEMENTS, "2134608058"},
	{"primordia", Common::GALAXY_ACHIEVEMENTS, "1207659144"},
	{"primordia", Common::STEAM_ACHIEVEMENTS, "227000"},
	{"projectorface", Common::STEAM_ACHIEVEMENTS, "431850"},
	{"qfi", Common::STEAM_ACHIEVEMENTS, "264560"},
	{"redbow", Common::STEAM_ACHIEVEMENTS, "710600"},
	{"resonance", Common::GALAXY_ACHIEVEMENTS, "1207659043"},
	{"resonance", Common::STEAM_ACHIEVEMENTS, "212050"},
	{"richardandalice", Common::STEAM_ACHIEVEMENTS, "279260"},
	{"rnrneverdies", Common::STEAM_ACHIEVEMENTS, "1644080"},
	{"roguestate", Common::STEAM_ACHIEVEMENTS, "396090"},
	{"rosewater", Common::STEAM_ACHIEVEMENTS, "1226670"},
	{"rosewater", Common::GALAXY_ACHIEVEMENTS, "1657623040"},
	{"samaritan", Common::STEAM_ACHIEVEMENTS, "283180"},
	{"shardlight", Common::GALAXY_ACHIEVEMENTS, "1454499527"},
	{"shardlight", Common::STEAM_ACHIEVEMENTS, "336130"},
	{"shivahkosher", Common::GALAXY_ACHIEVEMENTS, "1207660263"},
	{"shivahkosher", Common::STEAM_ACHIEVEMENTS, "252370"},
	{"sisyphus", Common::STEAM_ACHIEVEMENTS, "517910"},
	{"smallsister", Common::STEAM_ACHIEVEMENTS, "904600"},
	{"snowproblem", Common::STEAM_ACHIEVEMENTS, "2097090"},
	{"songanimals", Common::STEAM_ACHIEVEMENTS, "1036200"},
	{"stayingalive", Common::STEAM_ACHIEVEMENTS, "1285960"},
	{"stellarmessep1", Common::STEAM_ACHIEVEMENTS, "1507530"},
	{"strangeland", Common::GALAXY_ACHIEVEMENTS, "1392294208"},
	{"strangeland", Common::STEAM_ACHIEVEMENTS, "1369520"},
	{"sumatra", Common::GALAXY_ACHIEVEMENTS, "1489938431"},
	{"sumatra", Common::STEAM_ACHIEVEMENTS, "610900"},
	{"tales", Common::STEAM_ACHIEVEMENTS, "416250"},
	{"technobabylon", Common::GALAXY_ACHIEVEMENTS, "1430234218"},
	{"technobabylon", Common::STEAM_ACHIEVEMENTS, "307580"},
	{"theantidote", Common::STEAM_ACHIEVEMENTS, "1026080"},
	{"thecastle", Common::STEAM_ACHIEVEMENTS, "1133950"},
	{"thecatlady", Common::STEAM_ACHIEVEMENTS, "253110"},
	{"thesecretofhuttongrammarschoolvga", Common::STEAM_ACHIEVEMENTS, "1196520"},
	{"thesecretsofjesus", Common::STEAM_ACHIEVEMENTS, "1142230"},
	{"theterribleoldman", Common::STEAM_ACHIEVEMENTS, "1147030"},
	{"unavowed", Common::GALAXY_ACHIEVEMENTS, "1637485057"},
	{"unavowed", Common::STEAM_ACHIEVEMENTS, "336140"},
	{"unlikelyprometheus", Common::STEAM_ACHIEVEMENTS, "1834750"},
	{"untilihaveyou", Common::STEAM_ACHIEVEMENTS, "439310"},
	{"whispersofamachine", Common::GALAXY_ACHIEVEMENTS, "1845001352"},
	{"whispersofamachine", Common::STEAM_ACHIEVEMENTS, "631570"},
	{"wolfterritory", Common::STEAM_ACHIEVEMENTS, "1355910"},
	{"zniwadventure", Common::GALAXY_ACHIEVEMENTS, "1664228813"},
	{"zniwadventure", Common::STEAM_ACHIEVEMENTS, "904750"},

	ACHIEVEMENT_DESC_TABLE_END_MARKER
};

} // End of namespace AGS

#endif /* AGS_ACHIEVEMENTS_H */
