/* raw-gamepad-monitor-interface.c generated by valac 0.56.18, the Vala compiler
 * generated from raw-gamepad-monitor-interface.vala, do not modify */

/*
 * Copyright 2016 Megh Parikh
 *
 * This file is part of LibGamepad.
 *
 * LibGamepad is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LibGamepad is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR (lib_gamepad_raw_gamepad_monitor_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, LibGamepadRawGamepadMonitor))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, LibGamepadRawGamepadMonitorIface))

typedef struct _LibGamepadRawGamepadMonitor LibGamepadRawGamepadMonitor;
typedef struct _LibGamepadRawGamepadMonitorIface LibGamepadRawGamepadMonitorIface;

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD (lib_gamepad_raw_gamepad_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepad))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD))
#define LIB_GAMEPAD_RAW_GAMEPAD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepadIface))

typedef struct _LibGamepadRawGamepad LibGamepadRawGamepad;
typedef struct _LibGamepadRawGamepadIface LibGamepadRawGamepadIface;
typedef void (*LibGamepadRawGamepadMonitorRawGamepadCallback) (LibGamepadRawGamepad* raw_gamepad, gpointer user_data);
enum  {
	LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GAMEPAD_PLUGGED_SIGNAL,
	LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GAMEPAD_UNPLUGGED_SIGNAL,
	LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_NUM_SIGNALS
};
static guint lib_gamepad_raw_gamepad_monitor_signals[LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_NUM_SIGNALS] = {0};

struct _LibGamepadRawGamepadIface {
	GTypeInterface parent_iface;
	const gchar* (*get_identifier) (LibGamepadRawGamepad* self);
	const gchar* (*get_name) (LibGamepadRawGamepad* self);
	const gchar* (*get_guid) (LibGamepadRawGamepad* self);
	guint8 (*get_axes_number) (LibGamepadRawGamepad* self);
	guint8 (*get_buttons_number) (LibGamepadRawGamepad* self);
	guint8 (*get_dpads_number) (LibGamepadRawGamepad* self);
};

struct _LibGamepadRawGamepadMonitorIface {
	GTypeInterface parent_iface;
	void (*foreach_gamepad) (LibGamepadRawGamepadMonitor* self, LibGamepadRawGamepadMonitorRawGamepadCallback callback, gpointer callback_target);
};

VALA_EXTERN GType lib_gamepad_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepad, g_object_unref)
VALA_EXTERN GType lib_gamepad_raw_gamepad_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepadMonitor, g_object_unref)
VALA_EXTERN void lib_gamepad_raw_gamepad_monitor_foreach_gamepad (LibGamepadRawGamepadMonitor* self,
                                                      LibGamepadRawGamepadMonitorRawGamepadCallback callback,
                                                      gpointer callback_target);
static GType lib_gamepad_raw_gamepad_monitor_get_type_once (void);

/**
 * This function allows to iterate over all gamepads
 * @param   callback            The callback
 */
void
lib_gamepad_raw_gamepad_monitor_foreach_gamepad (LibGamepadRawGamepadMonitor* self,
                                                 LibGamepadRawGamepadMonitorRawGamepadCallback callback,
                                                 gpointer callback_target)
{
	LibGamepadRawGamepadMonitorIface* _iface_;
#line 51 "../Spice-up-1.9.1/src/Services/libgamepad/raw-gamepad-monitor-interface.vala"
	g_return_if_fail (self != NULL);
#line 51 "../Spice-up-1.9.1/src/Services/libgamepad/raw-gamepad-monitor-interface.vala"
	_iface_ = LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GET_INTERFACE (self);
#line 51 "../Spice-up-1.9.1/src/Services/libgamepad/raw-gamepad-monitor-interface.vala"
	if (_iface_->foreach_gamepad) {
#line 51 "../Spice-up-1.9.1/src/Services/libgamepad/raw-gamepad-monitor-interface.vala"
		_iface_->foreach_gamepad (self, callback, callback_target);
#line 112 "raw-gamepad-monitor-interface.c"
	}
}

static void
lib_gamepad_raw_gamepad_monitor_default_init (LibGamepadRawGamepadMonitorIface * iface,
                                              gpointer iface_data)
{
	/**
	 * This signal should be emmited when a gamepad is plugged in.
	 * @param   raw_gamepad   The raw gamepad
	 */
#line 28 "../Spice-up-1.9.1/src/Services/libgamepad/raw-gamepad-monitor-interface.vala"
	lib_gamepad_raw_gamepad_monitor_signals[LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GAMEPAD_PLUGGED_SIGNAL] = g_signal_new ("gamepad-plugged", LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, LIB_GAMEPAD_TYPE_RAW_GAMEPAD);
#line 126 "raw-gamepad-monitor-interface.c"
	/**
	 * This signal should be emitted when a gamepad is unplugged
	 *
	 * If an identifier which is not passed with gamepad_plugged even once is passed,
	 * then it is ignored. Drivers may use this to their benefit
	 *
	 * @param  identifier    The identifier of the unplugged gamepad
	 */
#line 28 "../Spice-up-1.9.1/src/Services/libgamepad/raw-gamepad-monitor-interface.vala"
	lib_gamepad_raw_gamepad_monitor_signals[LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GAMEPAD_UNPLUGGED_SIGNAL] = g_signal_new ("gamepad-unplugged", LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 137 "raw-gamepad-monitor-interface.c"
}

/**
 * This is one of the interfaces that needs to be implemented by the driver.
 *
 * This interface deals with handling events related to plugging and unplugging
 * of gamepads and also provides a method to iterate through all the plugged in
 * gamepads. An identifier is a string that is easily understood by the driver
 * and may depend on other factors, i.e. it may not be unique for the gamepad.
 */
static GType
lib_gamepad_raw_gamepad_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibGamepadRawGamepadMonitorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lib_gamepad_raw_gamepad_monitor_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType lib_gamepad_raw_gamepad_monitor_type_id;
	lib_gamepad_raw_gamepad_monitor_type_id = g_type_register_static (G_TYPE_INTERFACE, "LibGamepadRawGamepadMonitor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (lib_gamepad_raw_gamepad_monitor_type_id, G_TYPE_OBJECT);
	return lib_gamepad_raw_gamepad_monitor_type_id;
}

GType
lib_gamepad_raw_gamepad_monitor_get_type (void)
{
	static volatile gsize lib_gamepad_raw_gamepad_monitor_type_id__once = 0;
	if (g_once_init_enter (&lib_gamepad_raw_gamepad_monitor_type_id__once)) {
		GType lib_gamepad_raw_gamepad_monitor_type_id;
		lib_gamepad_raw_gamepad_monitor_type_id = lib_gamepad_raw_gamepad_monitor_get_type_once ();
		g_once_init_leave (&lib_gamepad_raw_gamepad_monitor_type_id__once, lib_gamepad_raw_gamepad_monitor_type_id);
	}
	return lib_gamepad_raw_gamepad_monitor_type_id__once;
}

