/* DisplayWidget.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DisplayWidget.vala, do not modify */

/*-
 * Copyright 2014–2024 elementary, Inc.
 *           2014–2018 Corentin Noël <corentin@elementary.io>
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "display.h"
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <glib-object.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_DISPLAY_WIDGET_0_PROPERTY,
	DISPLAY_DISPLAY_WIDGET_VIRTUAL_MONITOR_PROPERTY,
	DISPLAY_DISPLAY_WIDGET_BG_COLOR_PROPERTY,
	DISPLAY_DISPLAY_WIDGET_TEXT_COLOR_PROPERTY,
	DISPLAY_DISPLAY_WIDGET_DISPLAY_NAME_PROPERTY,
	DISPLAY_DISPLAY_WIDGET_WINDOW_RATIO_PROPERTY,
	DISPLAY_DISPLAY_WIDGET_CONNECTED_PROPERTY,
	DISPLAY_DISPLAY_WIDGET_NUM_PROPERTIES
};
static GParamSpec* display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_NUM_PROPERTIES];
typedef enum  {
	DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME,
	DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH,
	DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT,
	DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_TOTAL
} DisplayDisplayWidgetResolutionColumns;

#define DISPLAY_DISPLAY_WIDGET_TYPE_RESOLUTION_COLUMNS (display_display_widget_resolution_columns_get_type ())
typedef enum  {
	DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_NAME,
	DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_VALUE,
	DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_TOTAL
} DisplayDisplayWidgetRotationColumns;

#define DISPLAY_DISPLAY_WIDGET_TYPE_ROTATION_COLUMNS (display_display_widget_rotation_columns_get_type ())
typedef enum  {
	DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_NAME,
	DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_VALUE,
	DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_TOTAL
} DisplayDisplayWidgetRefreshColumns;

#define DISPLAY_DISPLAY_WIDGET_TYPE_REFRESH_COLUMNS (display_display_widget_refresh_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
enum  {
	DISPLAY_DISPLAY_WIDGET_SET_AS_PRIMARY_SIGNAL,
	DISPLAY_DISPLAY_WIDGET_CHECK_POSITION_SIGNAL,
	DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL,
	DISPLAY_DISPLAY_WIDGET_ACTIVE_CHANGED_SIGNAL,
	DISPLAY_DISPLAY_WIDGET_NUM_SIGNALS
};
static guint display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_NUM_SIGNALS] = {0};

struct _DisplayDisplayWidgetPrivate {
	DisplayVirtualMonitor* _virtual_monitor;
	gchar* _bg_color;
	gchar* _text_color;
	gdouble _window_ratio;
	gboolean _connected;
	GtkButton* primary_image;
	GraniteSwitchModelButton* use_switch;
	GtkComboBox* resolution_combobox;
	GtkTreeStore* resolution_tree_store;
	GtkComboBox* rotation_combobox;
	GtkListStore* rotation_list_store;
	GtkComboBox* refresh_combobox;
	GtkListStore* refresh_list_store;
	GtkDropDown* scale_drop_down;
	gint real_width;
	gint real_height;
};

struct _Block4Data {
	int _ref_count_;
	DisplayDisplayWidget* self;
	gboolean _result_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	DisplayMonitorMode* mode;
};

struct _Block6Data {
	int _ref_count_;
	DisplayDisplayWidget* self;
	DisplayTransform transform;
};

struct _Block7Data {
	int _ref_count_;
	DisplayDisplayWidget* self;
	gchar* virtual_monitor_name;
	GtkLabel* label;
	GtkPopover* popover;
};

static gint DisplayDisplayWidget_private_offset;
static gpointer display_display_widget_parent_class = NULL;

static GType display_display_widget_resolution_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType display_display_widget_rotation_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType display_display_widget_refresh_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void display_display_widget_populate_refresh_rates (DisplayDisplayWidget* self);
static gboolean _vala_double_array_contains (gdouble * stack,
                                      gssize stack_length,
                                      const gdouble needle);
static void _vala_array_add4 (gdouble* * array,
                       gint* length,
                       gint* size,
                       gdouble value);
static void display_display_widget_on_monitor_modes_changed (DisplayDisplayWidget* self);
static gboolean display_display_widget_set_active_resolution_from_current_mode (DisplayDisplayWidget* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean ____lambda5_ (Block5Data* _data5_,
                       GtkTreeModel* model,
                       GtkTreePath* path,
                       GtkTreeIter* iter);
static gboolean _____lambda5__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                    GtkTreePath* path,
                                                    GtkTreeIter* iter,
                                                    gpointer self);
static void display_display_widget_on_vm_transform_changed (DisplayDisplayWidget* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block6Data* _data6_,
                     GtkTreeModel* model,
                     GtkTreePath* path,
                     GtkTreeIter* iter);
static gboolean ___lambda6__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                  GtkTreePath* path,
                                                  GtkTreeIter* iter,
                                                  gpointer self);
static void display_display_widget_set_window_ratio (DisplayDisplayWidget* self,
                                              gdouble value);
static GObject * display_display_widget_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _display_display_widget___lambda7_ (DisplayDisplayWidget* self);
static void __display_display_widget___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static gint _display_monitor_mode_resolution_compare_func_gcompare_data_func (gconstpointer a,
                                                                       gconstpointer b,
                                                                       gpointer self);
static void _vala_array_add5 (DisplayResolution* * array,
                       gint* length,
                       gint* size,
                       const DisplayResolution* value);
static void _vala_array_add6 (DisplayResolution* * array,
                       gint* length,
                       gint* size,
                       const DisplayResolution* value);
static void _vala_array_add7 (DisplayResolution* * array,
                       gint* length,
                       gint* size,
                       const DisplayResolution* value);
static void _display_display_widget___lambda8_ (DisplayDisplayWidget* self,
                                         GObject* obj);
static void __display_display_widget___lambda8__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                             GObject* object,
                                                                             gpointer self);
static void _display_display_widget___lambda9_ (DisplayDisplayWidget* self,
                                         GObject* obj);
static void __display_display_widget___lambda9__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self);
static void _display_display_widget___lambda10_ (DisplayDisplayWidget* self);
static void __display_display_widget___lambda10__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _display_display_widget___lambda11_ (Block7Data* _data7_);
static void __display_display_widget___lambda11__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void _display_display_widget___lambda12_ (Block7Data* _data7_);
static void __display_display_widget___lambda12__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void _display_display_widget___lambda13_ (Block7Data* _data7_);
static void __display_display_widget___lambda13__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void _display_display_widget___lambda14_ (Block7Data* _data7_);
static void __display_display_widget___lambda14__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _display_display_widget_on_monitor_modes_changed_display_virtual_monitor_modes_changed (DisplayVirtualMonitor* _sender,
                                                                                             gpointer self);
static void _display_display_widget_on_vm_transform_changed_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void display_display_widget_finalize (GObject * obj);
static GType display_display_widget_get_type_once (void);
static void _vala_display_display_widget_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_display_display_widget_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

DisplayResolution*
display_resolution_dup (const DisplayResolution* self)
{
	DisplayResolution* dup;
	dup = g_new0 (DisplayResolution, 1);
	memcpy (dup, self, sizeof (DisplayResolution));
	return dup;
}

void
display_resolution_free (DisplayResolution* self)
{
	g_free (self);
}

static GType
display_resolution_get_type_once (void)
{
	GType display_resolution_type_id;
	display_resolution_type_id = g_boxed_type_register_static ("DisplayResolution", (GBoxedCopyFunc) display_resolution_dup, (GBoxedFreeFunc) display_resolution_free);
	return display_resolution_type_id;
}

GType
display_resolution_get_type (void)
{
	static volatile gsize display_resolution_type_id__once = 0;
	if (g_once_init_enter (&display_resolution_type_id__once)) {
		GType display_resolution_type_id;
		display_resolution_type_id = display_resolution_get_type_once ();
		g_once_init_leave (&display_resolution_type_id__once, display_resolution_type_id);
	}
	return display_resolution_type_id__once;
}

static inline gpointer
display_display_widget_get_instance_private (DisplayDisplayWidget* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayDisplayWidget_private_offset);
}

static GType
display_display_widget_resolution_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME, "DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME", "name"}, {DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH, "DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH", "width"}, {DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT, "DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT", "height"}, {DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_TOTAL, "DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_TOTAL", "total"}, {0, NULL, NULL}};
	GType display_display_widget_resolution_columns_type_id;
	display_display_widget_resolution_columns_type_id = g_enum_register_static ("DisplayDisplayWidgetResolutionColumns", values);
	return display_display_widget_resolution_columns_type_id;
}

static GType
display_display_widget_resolution_columns_get_type (void)
{
	static volatile gsize display_display_widget_resolution_columns_type_id__once = 0;
	if (g_once_init_enter (&display_display_widget_resolution_columns_type_id__once)) {
		GType display_display_widget_resolution_columns_type_id;
		display_display_widget_resolution_columns_type_id = display_display_widget_resolution_columns_get_type_once ();
		g_once_init_leave (&display_display_widget_resolution_columns_type_id__once, display_display_widget_resolution_columns_type_id);
	}
	return display_display_widget_resolution_columns_type_id__once;
}

static GType
display_display_widget_rotation_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_NAME, "DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_NAME", "name"}, {DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_VALUE, "DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_VALUE", "value"}, {DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_TOTAL, "DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_TOTAL", "total"}, {0, NULL, NULL}};
	GType display_display_widget_rotation_columns_type_id;
	display_display_widget_rotation_columns_type_id = g_enum_register_static ("DisplayDisplayWidgetRotationColumns", values);
	return display_display_widget_rotation_columns_type_id;
}

static GType
display_display_widget_rotation_columns_get_type (void)
{
	static volatile gsize display_display_widget_rotation_columns_type_id__once = 0;
	if (g_once_init_enter (&display_display_widget_rotation_columns_type_id__once)) {
		GType display_display_widget_rotation_columns_type_id;
		display_display_widget_rotation_columns_type_id = display_display_widget_rotation_columns_get_type_once ();
		g_once_init_leave (&display_display_widget_rotation_columns_type_id__once, display_display_widget_rotation_columns_type_id);
	}
	return display_display_widget_rotation_columns_type_id__once;
}

static GType
display_display_widget_refresh_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_NAME, "DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_NAME", "name"}, {DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_VALUE, "DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_VALUE", "value"}, {DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_TOTAL, "DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_TOTAL", "total"}, {0, NULL, NULL}};
	GType display_display_widget_refresh_columns_type_id;
	display_display_widget_refresh_columns_type_id = g_enum_register_static ("DisplayDisplayWidgetRefreshColumns", values);
	return display_display_widget_refresh_columns_type_id;
}

static GType
display_display_widget_refresh_columns_get_type (void)
{
	static volatile gsize display_display_widget_refresh_columns_type_id__once = 0;
	if (g_once_init_enter (&display_display_widget_refresh_columns_type_id__once)) {
		GType display_display_widget_refresh_columns_type_id;
		display_display_widget_refresh_columns_type_id = display_display_widget_refresh_columns_get_type_once ();
		g_once_init_leave (&display_display_widget_refresh_columns_type_id__once, display_display_widget_refresh_columns_type_id);
	}
	return display_display_widget_refresh_columns_type_id__once;
}

DisplayDisplayWidget*
display_display_widget_construct (GType object_type,
                                  DisplayVirtualMonitor* virtual_monitor,
                                  const gchar* bg_color,
                                  const gchar* text_color)
{
	DisplayDisplayWidget * self = NULL;
	g_return_val_if_fail (virtual_monitor != NULL, NULL);
	g_return_val_if_fail (bg_color != NULL, NULL);
	g_return_val_if_fail (text_color != NULL, NULL);
	self = (DisplayDisplayWidget*) g_object_new (object_type, "virtual-monitor", virtual_monitor, "bg-color", bg_color, "text-color", text_color, NULL);
	return self;
}

DisplayDisplayWidget*
display_display_widget_new (DisplayVirtualMonitor* virtual_monitor,
                            const gchar* bg_color,
                            const gchar* text_color)
{
	return display_display_widget_construct (DISPLAY_TYPE_DISPLAY_WIDGET, virtual_monitor, bg_color, text_color);
}

static gboolean
_vala_double_array_contains (gdouble * stack,
                             gssize stack_length,
                             const gdouble needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add4 (gdouble* * array,
                  gint* length,
                  gint* size,
                  gdouble value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gdouble, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
display_display_widget_populate_refresh_rates (DisplayDisplayWidget* self)
{
	GtkListStore* _tmp0_;
	GtkTreeIter iter = {0};
	gint added = 0;
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkComboBox* _tmp56_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->refresh_list_store;
	gtk_list_store_clear (_tmp0_);
	added = 0;
	_tmp1_ = self->priv->resolution_combobox;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		gint active_width = 0;
		gint active_height = 0;
		GtkComboBox* _tmp4_;
		GtkTreeIter _tmp5_ = {0};
		gboolean _tmp6_;
		gdouble* frequencies = NULL;
		gdouble* _tmp11_;
		gint frequencies_length1;
		gint _frequencies_size_;
		gboolean refresh_set = FALSE;
		_tmp4_ = self->priv->resolution_combobox;
		_tmp6_ = gtk_combo_box_get_active_iter (_tmp4_, &_tmp5_);
		iter = _tmp5_;
		if (_tmp6_) {
			GtkTreeStore* _tmp7_;
			GtkTreeIter _tmp8_;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			_tmp7_ = self->priv->resolution_tree_store;
			_tmp8_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH, &_tmp9_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT, &_tmp10_, -1);
			active_width = _tmp9_;
			active_height = _tmp10_;
		} else {
			return;
		}
		_tmp11_ = g_new0 (gdouble, 0);
		frequencies = _tmp11_;
		frequencies_length1 = 0;
		_frequencies_size_ = frequencies_length1;
		refresh_set = FALSE;
		{
			GeeLinkedList* _mode_list = NULL;
			DisplayVirtualMonitor* _tmp12_;
			GeeLinkedList* _tmp13_;
			gint _mode_size = 0;
			GeeLinkedList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _mode_index = 0;
			_tmp12_ = self->priv->_virtual_monitor;
			_tmp13_ = display_virtual_monitor_get_available_modes (_tmp12_);
			_mode_list = _tmp13_;
			_tmp14_ = _mode_list;
			_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_mode_size = _tmp16_;
			_mode_index = -1;
			while (TRUE) {
				gint _tmp17_;
				gint _tmp18_;
				DisplayMonitorMode* mode = NULL;
				GeeLinkedList* _tmp19_;
				gpointer _tmp20_;
				gboolean _tmp21_ = FALSE;
				DisplayMonitorMode* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				DisplayMonitorMode* _tmp28_;
				gdouble _tmp29_;
				gdouble _tmp30_;
				gdouble* _tmp31_;
				gint _tmp31__length1;
				gboolean freq_already_added = FALSE;
				gdouble* _tmp32_;
				gint _tmp32__length1;
				DisplayMonitorMode* _tmp36_;
				gdouble _tmp37_;
				gdouble _tmp38_;
				gchar* freq_name = NULL;
				DisplayMonitorMode* _tmp39_;
				gdouble _tmp40_;
				gdouble _tmp41_;
				gchar* _tmp42_;
				GtkListStore* _tmp43_;
				GtkTreeIter _tmp44_ = {0};
				GtkListStore* _tmp45_;
				GtkTreeIter _tmp46_;
				const gchar* _tmp47_;
				DisplayMonitorMode* _tmp48_;
				gint _tmp49_;
				DisplayMonitorMode* _tmp50_;
				gboolean _tmp51_;
				gboolean _tmp52_;
				_mode_index = _mode_index + 1;
				_tmp17_ = _mode_index;
				_tmp18_ = _mode_size;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = _mode_list;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _mode_index);
				mode = (DisplayMonitorMode*) _tmp20_;
				_tmp22_ = mode;
				_tmp23_ = display_monitor_mode_get_width (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ != active_width) {
					_tmp21_ = TRUE;
				} else {
					DisplayMonitorMode* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					_tmp25_ = mode;
					_tmp26_ = display_monitor_mode_get_height (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp21_ = _tmp27_ != active_height;
				}
				if (_tmp21_) {
					_g_object_unref0 (mode);
					continue;
				}
				_tmp28_ = mode;
				_tmp29_ = display_monitor_mode_get_frequency (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = frequencies;
				_tmp31__length1 = frequencies_length1;
				if (_vala_double_array_contains (_tmp31_, _tmp31__length1, _tmp30_)) {
					_g_object_unref0 (mode);
					continue;
				}
				freq_already_added = FALSE;
				_tmp32_ = frequencies;
				_tmp32__length1 = frequencies_length1;
				{
					gdouble* freq_collection = NULL;
					gint freq_collection_length1 = 0;
					gint _freq_collection_size_ = 0;
					gint freq_it = 0;
					freq_collection = _tmp32_;
					freq_collection_length1 = _tmp32__length1;
					for (freq_it = 0; freq_it < freq_collection_length1; freq_it = freq_it + 1) {
						gdouble freq = 0.0;
						freq = freq_collection[freq_it];
						{
							DisplayMonitorMode* _tmp33_;
							gdouble _tmp34_;
							gdouble _tmp35_;
							_tmp33_ = mode;
							_tmp34_ = display_monitor_mode_get_frequency (_tmp33_);
							_tmp35_ = _tmp34_;
							if (fabs (_tmp35_ - freq) < ((gdouble) 1)) {
								freq_already_added = TRUE;
								break;
							}
						}
					}
				}
				if (freq_already_added) {
					_g_object_unref0 (mode);
					continue;
				}
				_tmp36_ = mode;
				_tmp37_ = display_monitor_mode_get_frequency (_tmp36_);
				_tmp38_ = _tmp37_;
				_vala_array_add4 (&frequencies, &frequencies_length1, &_frequencies_size_, _tmp38_);
				_tmp39_ = mode;
				_tmp40_ = display_monitor_mode_get_frequency (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup_printf (_ ("%g Hz"), (gdouble) roundf ((gfloat) _tmp41_));
				freq_name = _tmp42_;
				_tmp43_ = self->priv->refresh_list_store;
				gtk_list_store_append (_tmp43_, &_tmp44_);
				iter = _tmp44_;
				_tmp45_ = self->priv->refresh_list_store;
				_tmp46_ = iter;
				_tmp47_ = freq_name;
				_tmp48_ = mode;
				gtk_list_store_set (_tmp45_, &_tmp46_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME, _tmp47_, DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_VALUE, _tmp48_, -1);
				_tmp49_ = added;
				added = _tmp49_ + 1;
				_tmp50_ = mode;
				_tmp51_ = display_monitor_mode_get_is_current (_tmp50_);
				_tmp52_ = _tmp51_;
				if (_tmp52_) {
					GtkComboBox* _tmp53_;
					GtkTreeIter _tmp54_;
					_tmp53_ = self->priv->refresh_combobox;
					_tmp54_ = iter;
					gtk_combo_box_set_active_iter (_tmp53_, &_tmp54_);
					refresh_set = TRUE;
				}
				_g_free0 (freq_name);
				_g_object_unref0 (mode);
			}
			_g_object_unref0 (_mode_list);
		}
		if (!refresh_set) {
			GtkComboBox* _tmp55_;
			_tmp55_ = self->priv->refresh_combobox;
			gtk_combo_box_set_active (_tmp55_, 0);
		}
		frequencies = (g_free (frequencies), NULL);
	}
	_tmp56_ = self->priv->refresh_combobox;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, added > 1);
}

static void
display_display_widget_on_monitor_modes_changed (DisplayDisplayWidget* self)
{
	g_return_if_fail (self != NULL);
	display_display_widget_set_active_resolution_from_current_mode (self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		DisplayDisplayWidget* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		DisplayDisplayWidget* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->mode);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
____lambda5_ (Block5Data* _data5_,
              GtkTreeModel* model,
              GtkTreePath* path,
              GtkTreeIter* iter)
{
	Block4Data* _data4_;
	DisplayDisplayWidget* self;
	gint width = 0;
	gint height = 0;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	DisplayMonitorMode* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->resolution_tree_store;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH, &_tmp2_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT, &_tmp3_, -1);
	width = _tmp2_;
	height = _tmp3_;
	_tmp5_ = _data5_->mode;
	_tmp6_ = display_monitor_mode_get_width (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == width) {
		DisplayMonitorMode* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = _data5_->mode;
		_tmp9_ = display_monitor_mode_get_height (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_ == height;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkComboBox* _tmp11_;
		GtkTreeIter _tmp12_;
		_tmp11_ = self->priv->resolution_combobox;
		_tmp12_ = *iter;
		gtk_combo_box_set_active_iter (_tmp11_, &_tmp12_);
		_data4_->_result_ = TRUE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_____lambda5__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                           GtkTreePath* path,
                                           GtkTreeIter* iter,
                                           gpointer self)
{
	gboolean result;
	result = ____lambda5_ (self, model, path, iter);
	return result;
}

static gboolean
display_display_widget_set_active_resolution_from_current_mode (DisplayDisplayWidget* self)
{
	Block4Data* _data4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->_result_ = FALSE;
	{
		GeeLinkedList* _mode_list = NULL;
		DisplayVirtualMonitor* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _mode_index = 0;
		_tmp0_ = self->priv->_virtual_monitor;
		_tmp1_ = display_virtual_monitor_get_available_modes (_tmp0_);
		_mode_list = _tmp1_;
		_tmp2_ = _mode_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_mode_size = _tmp4_;
		_mode_index = -1;
		while (TRUE) {
			Block5Data* _data5_;
			gint _tmp5_;
			gint _tmp6_;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			DisplayMonitorMode* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			GtkTreeStore* _tmp12_;
			_data5_ = g_slice_new0 (Block5Data);
			_data5_->_ref_count_ = 1;
			_data5_->_data4_ = block4_data_ref (_data4_);
			_mode_index = _mode_index + 1;
			_tmp5_ = _mode_index;
			_tmp6_ = _mode_size;
			if (!(_tmp5_ < _tmp6_)) {
				block5_data_unref (_data5_);
				_data5_ = NULL;
				break;
			}
			_tmp7_ = _mode_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _mode_index);
			_data5_->mode = (DisplayMonitorMode*) _tmp8_;
			_tmp9_ = _data5_->mode;
			_tmp10_ = display_monitor_mode_get_is_current (_tmp9_);
			_tmp11_ = _tmp10_;
			if (!_tmp11_) {
				block5_data_unref (_data5_);
				_data5_ = NULL;
				continue;
			}
			_tmp12_ = self->priv->resolution_tree_store;
			gtk_tree_model_foreach ((GtkTreeModel*) _tmp12_, _____lambda5__gtk_tree_model_foreach_func, _data5_);
			block5_data_unref (_data5_);
			_data5_ = NULL;
		}
		_g_object_unref0 (_mode_list);
	}
	result = _data4_->_result_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		DisplayDisplayWidget* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
__lambda6_ (Block6Data* _data6_,
            GtkTreeModel* model,
            GtkTreePath* path,
            GtkTreeIter* iter)
{
	DisplayDisplayWidget* self;
	GValue val = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	DisplayTransform iter_transform = 0;
	GValue _tmp3_;
	gboolean result;
	self = _data6_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->rotation_list_store;
	_tmp1_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, (gint) DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_VALUE, &_tmp2_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp2_;
	_tmp3_ = val;
	iter_transform = (DisplayTransform) g_value_get_int (&_tmp3_);
	if (iter_transform == _data6_->transform) {
		GtkComboBox* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->rotation_combobox;
		_tmp5_ = *iter;
		gtk_combo_box_set_active_iter (_tmp4_, &_tmp5_);
		result = TRUE;
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return result;
	}
	result = FALSE;
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}

static gboolean
___lambda6__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                         GtkTreePath* path,
                                         GtkTreeIter* iter,
                                         gpointer self)
{
	gboolean result;
	result = __lambda6_ (self, model, path, iter);
	return result;
}

static void
display_display_widget_on_vm_transform_changed (DisplayDisplayWidget* self)
{
	Block6Data* _data6_;
	DisplayVirtualMonitor* _tmp0_;
	DisplayTransform _tmp1_;
	DisplayTransform _tmp2_;
	GtkListStore* _tmp3_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->priv->_virtual_monitor;
	_tmp1_ = display_virtual_monitor_get_transform (_tmp0_);
	_tmp2_ = _tmp1_;
	_data6_->transform = _tmp2_;
	_tmp3_ = self->priv->rotation_list_store;
	gtk_tree_model_foreach ((GtkTreeModel*) _tmp3_, ___lambda6__gtk_tree_model_foreach_func, _data6_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

void
display_display_widget_set_primary (DisplayDisplayWidget* self,
                                    gboolean is_primary)
{
	GraniteSwitchModelButton* _tmp4_;
	g_return_if_fail (self != NULL);
	if (is_primary) {
		GtkButton* _tmp0_;
		GtkButton* _tmp1_;
		_tmp0_ = self->priv->primary_image;
		gtk_button_set_icon_name (_tmp0_, "starred-symbolic");
		_tmp1_ = self->priv->primary_image;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _ ("Is the primary display"));
	} else {
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		_tmp2_ = self->priv->primary_image;
		gtk_button_set_icon_name (_tmp2_, "non-starred-symbolic");
		_tmp3_ = self->priv->primary_image;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Set as primary display"));
	}
	_tmp4_ = self->priv->use_switch;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, !is_primary);
}

void
display_display_widget_get_preferred_size (DisplayDisplayWidget* self,
                                           GtkRequisition* minimum_size,
                                           GtkRequisition* natural_size)
{
	GtkRequisition _vala_minimum_size = {0};
	GtkRequisition _vala_natural_size = {0};
	gdouble _tmp0_;
	gdouble _tmp1_;
	GtkRequisition _tmp2_ = {0};
	GtkRequisition _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window_ratio;
	_tmp1_ = self->priv->_window_ratio;
	memset (&_tmp2_, 0, sizeof (GtkRequisition));
	_tmp2_.height = (gint) (self->priv->real_height * _tmp0_);
	_tmp2_.width = (gint) (self->priv->real_width * _tmp1_);
	_vala_minimum_size = _tmp2_;
	_tmp3_ = _vala_minimum_size;
	_vala_natural_size = _tmp3_;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

void
display_display_widget_get_virtual_monitor_geometry (DisplayDisplayWidget* self,
                                                     gint* x,
                                                     gint* y,
                                                     gint* width,
                                                     gint* height)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	DisplayVirtualMonitor* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	DisplayVirtualMonitor* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_virtual_monitor;
	_tmp1_ = display_virtual_monitor_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_x = _tmp2_;
	_tmp3_ = self->priv->_virtual_monitor;
	_tmp4_ = display_virtual_monitor_get_y (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_y = _tmp5_;
	_vala_width = self->priv->real_width;
	_vala_height = self->priv->real_height;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

void
display_display_widget_set_virtual_monitor_geometry (DisplayDisplayWidget* self,
                                                     gint x,
                                                     gint y,
                                                     gint width,
                                                     gint height)
{
	DisplayVirtualMonitor* _tmp0_;
	DisplayVirtualMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_virtual_monitor;
	display_virtual_monitor_set_x (_tmp0_, x);
	_tmp1_ = self->priv->_virtual_monitor;
	display_virtual_monitor_set_y (_tmp1_, y);
	self->priv->real_width = width;
	self->priv->real_height = height;
	gtk_widget_queue_resize ((GtkWidget*) self);
}

void
display_display_widget_move_x (DisplayDisplayWidget* self,
                               gint dx)
{
	DisplayVirtualMonitor* _tmp0_;
	DisplayVirtualMonitor* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_virtual_monitor;
	_tmp1_ = self->priv->_virtual_monitor;
	_tmp2_ = display_virtual_monitor_get_x (_tmp1_);
	_tmp3_ = _tmp2_;
	display_virtual_monitor_set_x (_tmp1_, _tmp3_ + dx);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

void
display_display_widget_move_y (DisplayDisplayWidget* self,
                               gint dy)
{
	DisplayVirtualMonitor* _tmp0_;
	DisplayVirtualMonitor* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_virtual_monitor;
	_tmp1_ = self->priv->_virtual_monitor;
	_tmp2_ = display_virtual_monitor_get_y (_tmp1_);
	_tmp3_ = _tmp2_;
	display_virtual_monitor_set_y (_tmp1_, _tmp3_ + dy);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

gboolean
display_display_widget_equals (DisplayDisplayWidget* self,
                               DisplayDisplayWidget* sibling)
{
	DisplayVirtualMonitor* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	DisplayVirtualMonitor* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sibling != NULL, FALSE);
	_tmp0_ = self->priv->_virtual_monitor;
	_tmp1_ = display_virtual_monitor_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = sibling->priv->_virtual_monitor;
	_tmp5_ = display_virtual_monitor_get_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp3_, _tmp7_) == 0;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp8_;
	return result;
}

DisplayVirtualMonitor*
display_display_widget_get_virtual_monitor (DisplayDisplayWidget* self)
{
	DisplayVirtualMonitor* result;
	DisplayVirtualMonitor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_virtual_monitor;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
display_display_widget_set_virtual_monitor (DisplayDisplayWidget* self,
                                            DisplayVirtualMonitor* value)
{
	DisplayVirtualMonitor* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_display_widget_get_virtual_monitor (self);
	if (old_value != value) {
		DisplayVirtualMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_virtual_monitor);
		self->priv->_virtual_monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_VIRTUAL_MONITOR_PROPERTY]);
	}
}

const gchar*
display_display_widget_get_bg_color (DisplayDisplayWidget* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_bg_color;
	result = _tmp0_;
	return result;
}

static void
display_display_widget_set_bg_color (DisplayDisplayWidget* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_display_widget_get_bg_color (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_bg_color);
		self->priv->_bg_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_BG_COLOR_PROPERTY]);
	}
}

const gchar*
display_display_widget_get_text_color (DisplayDisplayWidget* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text_color;
	result = _tmp0_;
	return result;
}

static void
display_display_widget_set_text_color (DisplayDisplayWidget* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_display_widget_get_text_color (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text_color);
		self->priv->_text_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_TEXT_COLOR_PROPERTY]);
	}
}

const gchar*
display_display_widget_get_display_name (DisplayDisplayWidget* self)
{
	const gchar* result;
	DisplayVirtualMonitor* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_virtual_monitor;
	_tmp1_ = display_virtual_monitor_get_display_name (_tmp0_);
	result = _tmp1_;
	return result;
}

gdouble
display_display_widget_get_window_ratio (DisplayDisplayWidget* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_window_ratio;
	return result;
}

static void
display_display_widget_set_window_ratio (DisplayDisplayWidget* self,
                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = display_display_widget_get_window_ratio (self);
	if (old_value != value) {
		self->priv->_window_ratio = value;
		g_object_notify_by_pspec ((GObject *) self, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_WINDOW_RATIO_PROPERTY]);
	}
}

gboolean
display_display_widget_get_connected (DisplayDisplayWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_connected;
	return result;
}

void
display_display_widget_set_connected (DisplayDisplayWidget* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_display_widget_get_connected (self);
	if (old_value != value) {
		self->priv->_connected = value;
		g_object_notify_by_pspec ((GObject *) self, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_CONNECTED_PROPERTY]);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		DisplayDisplayWidget* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->popover);
		_g_object_unref0 (_data7_->label);
		_g_free0 (_data7_->virtual_monitor_name);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_display_display_widget___lambda7_ (DisplayDisplayWidget* self)
{
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_SET_AS_PRIMARY_SIGNAL], 0);
}

static void
__display_display_widget___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_display_display_widget___lambda7_ ((DisplayDisplayWidget*) self);
}

static gint
_display_monitor_mode_resolution_compare_func_gcompare_data_func (gconstpointer a,
                                                                  gconstpointer b,
                                                                  gpointer self)
{
	gint result;
	result = display_monitor_mode_resolution_compare_func ((DisplayMonitorMode*) a, (DisplayMonitorMode*) b);
	return result;
}

static void
_vala_array_add5 (DisplayResolution* * array,
                  gint* length,
                  gint* size,
                  const DisplayResolution* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DisplayResolution, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add6 (DisplayResolution* * array,
                  gint* length,
                  gint* size,
                  const DisplayResolution* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DisplayResolution, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add7 (DisplayResolution* * array,
                  gint* length,
                  gint* size,
                  const DisplayResolution* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DisplayResolution, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_display_display_widget___lambda8_ (DisplayDisplayWidget* self,
                                    GObject* obj)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkListItem* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = list_item;
	_tmp2_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	gtk_list_item_set_child (_tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (list_item);
}

static void
__display_display_widget___lambda8__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                        GObject* object,
                                                                        gpointer self)
{
	_display_display_widget___lambda8_ ((DisplayDisplayWidget*) self, object);
}

static void
_display_display_widget___lambda9_ (DisplayDisplayWidget* self,
                                    GObject* obj)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	DisplayVirtualMonitorScale* item = NULL;
	GtkListItem* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	DisplayVirtualMonitorScale* _tmp4_;
	GtkLabel* scale_label = NULL;
	GtkListItem* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	DisplayVirtualMonitorScale* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = list_item;
	_tmp2_ = gtk_list_item_get_item (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE, DisplayVirtualMonitorScale));
	item = _tmp4_;
	_tmp5_ = list_item;
	_tmp6_ = gtk_list_item_get_child (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_label_get_type (), GtkLabel));
	scale_label = _tmp8_;
	_tmp9_ = scale_label;
	_tmp10_ = item;
	_tmp11_ = display_virtual_monitor_scale_get_string_representation (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_label_set_label (_tmp9_, _tmp12_);
	_g_object_unref0 (scale_label);
	_g_object_unref0 (item);
	_g_object_unref0 (list_item);
}

static void
__display_display_widget___lambda9__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                       GObject* object,
                                                                       gpointer self)
{
	_display_display_widget___lambda9_ ((DisplayDisplayWidget*) self, object);
}

static void
_display_display_widget___lambda10_ (DisplayDisplayWidget* self)
{
	GtkComboBox* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkComboBox* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkComboBox* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GraniteSwitchModelButton* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	_tmp0_ = self->priv->rotation_combobox;
	_tmp1_ = gtk_combo_box_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == -1) {
		GtkComboBox* _tmp3_;
		_tmp3_ = self->priv->rotation_combobox;
		gtk_combo_box_set_active (_tmp3_, 0);
	}
	_tmp4_ = self->priv->resolution_combobox;
	_tmp5_ = gtk_combo_box_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == -1) {
		GtkComboBox* _tmp7_;
		_tmp7_ = self->priv->resolution_combobox;
		gtk_combo_box_set_active (_tmp7_, 0);
	}
	_tmp8_ = self->priv->refresh_combobox;
	_tmp9_ = gtk_combo_box_get_active (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == -1) {
		GtkComboBox* _tmp11_;
		_tmp11_ = self->priv->refresh_combobox;
		gtk_combo_box_set_active (_tmp11_, 0);
	}
	_tmp12_ = self->priv->use_switch;
	_tmp13_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		gtk_widget_remove_css_class ((GtkWidget*) self, "disabled");
	} else {
		gtk_widget_add_css_class ((GtkWidget*) self, "disabled");
	}
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL], 0);
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_ACTIVE_CHANGED_SIGNAL], 0);
}

static void
__display_display_widget___lambda10__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_display_display_widget___lambda10_ ((DisplayDisplayWidget*) self);
}

static void
_display_display_widget___lambda11_ (Block7Data* _data7_)
{
	DisplayDisplayWidget* self;
	GtkPopover* _tmp0_;
	gint active_width = 0;
	gint active_height = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	DisplayVirtualMonitor* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	DisplayVirtualMonitor* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	DisplayMonitorMode* new_mode = NULL;
	DisplayVirtualMonitor* _tmp14_;
	DisplayMonitorMode* _tmp15_;
	DisplayMonitorMode* _tmp16_;
	DisplayVirtualMonitor* _tmp17_;
	DisplayMonitorMode* _tmp18_;
	GtkComboBox* _tmp19_;
	self = _data7_->self;
	_tmp0_ = _data7_->popover;
	gtk_popover_popdown (_tmp0_);
	_tmp1_ = self->priv->resolution_combobox;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreeStore* _tmp4_;
		GtkTreeIter _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp4_ = self->priv->resolution_tree_store;
		_tmp5_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH, &_tmp6_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT, &_tmp7_, -1);
		active_width = _tmp6_;
		active_height = _tmp7_;
	} else {
		return;
	}
	_tmp8_ = self->priv->_virtual_monitor;
	_tmp9_ = display_virtual_monitor_get_x (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_virtual_monitor;
	_tmp12_ = display_virtual_monitor_get_y (_tmp11_);
	_tmp13_ = _tmp12_;
	display_display_widget_set_virtual_monitor_geometry (self, _tmp10_, _tmp13_, active_width, active_height);
	_tmp14_ = self->priv->_virtual_monitor;
	_tmp15_ = display_virtual_monitor_get_mode_for_resolution (_tmp14_, active_width, active_height);
	new_mode = _tmp15_;
	_tmp16_ = new_mode;
	if (_tmp16_ == NULL) {
		_g_object_unref0 (new_mode);
		return;
	}
	_tmp17_ = self->priv->_virtual_monitor;
	_tmp18_ = new_mode;
	display_virtual_monitor_set_current_mode (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->rotation_combobox;
	gtk_combo_box_set_active (_tmp19_, 0);
	display_display_widget_populate_refresh_rates (self);
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL], 0);
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CHECK_POSITION_SIGNAL], 0);
	_g_object_unref0 (new_mode);
}

static void
__display_display_widget___lambda11__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_display_display_widget___lambda11_ (self);
}

static void
_display_display_widget___lambda12_ (Block7Data* _data7_)
{
	DisplayDisplayWidget* self;
	GtkPopover* _tmp0_;
	GValue val = {0};
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GValue _tmp5_ = {0};
	DisplayTransform transform = 0;
	GValue _tmp6_;
	DisplayVirtualMonitor* _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	self = _data7_->self;
	_tmp0_ = _data7_->popover;
	gtk_popover_popdown (_tmp0_);
	_tmp1_ = self->priv->rotation_combobox;
	gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	_tmp3_ = self->priv->rotation_list_store;
	_tmp4_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp3_, &_tmp4_, (gint) DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_VALUE, &_tmp5_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp5_;
	_tmp6_ = val;
	transform = (DisplayTransform) g_value_get_int (&_tmp6_);
	_tmp7_ = self->priv->_virtual_monitor;
	display_virtual_monitor_set_transform (_tmp7_, transform);
	_tmp8_ = _data7_->label;
	_tmp9_ = g_strdup ("");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_widget_set_css_classes ((GtkWidget*) _tmp8_, _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	switch (transform) {
		case DISPLAY_TRANSFORM_NORMAL:
		{
			DisplayVirtualMonitor* _tmp12_;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			GtkLabel* _tmp15_;
			const gchar* _tmp16_;
			_tmp12_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp12_, &_tmp13_, &_tmp14_);
			self->priv->real_width = _tmp13_;
			self->priv->real_height = _tmp14_;
			_tmp15_ = _data7_->label;
			_tmp16_ = _data7_->virtual_monitor_name;
			gtk_label_set_label (_tmp15_, _tmp16_);
			break;
		}
		case DISPLAY_TRANSFORM_ROTATION_90:
		{
			DisplayVirtualMonitor* _tmp17_;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			GtkLabel* _tmp20_;
			GtkLabel* _tmp21_;
			const gchar* _tmp22_;
			_tmp17_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp17_, &_tmp18_, &_tmp19_);
			self->priv->real_height = _tmp18_;
			self->priv->real_width = _tmp19_;
			_tmp20_ = _data7_->label;
			gtk_widget_add_css_class ((GtkWidget*) _tmp20_, "rotate-270");
			_tmp21_ = _data7_->label;
			_tmp22_ = _data7_->virtual_monitor_name;
			gtk_label_set_label (_tmp21_, _tmp22_);
			break;
		}
		case DISPLAY_TRANSFORM_ROTATION_180:
		{
			DisplayVirtualMonitor* _tmp23_;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			GtkLabel* _tmp26_;
			GtkLabel* _tmp27_;
			const gchar* _tmp28_;
			_tmp23_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp23_, &_tmp24_, &_tmp25_);
			self->priv->real_width = _tmp24_;
			self->priv->real_height = _tmp25_;
			_tmp26_ = _data7_->label;
			gtk_widget_add_css_class ((GtkWidget*) _tmp26_, "rotate-180");
			_tmp27_ = _data7_->label;
			_tmp28_ = _data7_->virtual_monitor_name;
			gtk_label_set_label (_tmp27_, _tmp28_);
			break;
		}
		case DISPLAY_TRANSFORM_ROTATION_270:
		{
			DisplayVirtualMonitor* _tmp29_;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			GtkLabel* _tmp32_;
			GtkLabel* _tmp33_;
			const gchar* _tmp34_;
			_tmp29_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp29_, &_tmp30_, &_tmp31_);
			self->priv->real_height = _tmp30_;
			self->priv->real_width = _tmp31_;
			_tmp32_ = _data7_->label;
			gtk_widget_add_css_class ((GtkWidget*) _tmp32_, "rotate-90");
			_tmp33_ = _data7_->label;
			_tmp34_ = _data7_->virtual_monitor_name;
			gtk_label_set_label (_tmp33_, _tmp34_);
			break;
		}
		case DISPLAY_TRANSFORM_FLIPPED:
		{
			DisplayVirtualMonitor* _tmp35_;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			GtkLabel* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp35_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp35_, &_tmp36_, &_tmp37_);
			self->priv->real_width = _tmp36_;
			self->priv->real_height = _tmp37_;
			_tmp38_ = _data7_->label;
			_tmp39_ = _data7_->virtual_monitor_name;
			_tmp40_ = g_utf8_strreverse (_tmp39_, (gssize) -1);
			_tmp41_ = _tmp40_;
			gtk_label_set_label (_tmp38_, _tmp41_);
			_g_free0 (_tmp41_);
			break;
		}
		case DISPLAY_TRANSFORM_FLIPPED_ROTATION_90:
		{
			DisplayVirtualMonitor* _tmp42_;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			GtkLabel* _tmp45_;
			GtkLabel* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp42_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp42_, &_tmp43_, &_tmp44_);
			self->priv->real_height = _tmp43_;
			self->priv->real_width = _tmp44_;
			_tmp45_ = _data7_->label;
			gtk_widget_add_css_class ((GtkWidget*) _tmp45_, "rotate-270");
			_tmp46_ = _data7_->label;
			_tmp47_ = _data7_->virtual_monitor_name;
			_tmp48_ = g_utf8_strreverse (_tmp47_, (gssize) -1);
			_tmp49_ = _tmp48_;
			gtk_label_set_label (_tmp46_, _tmp49_);
			_g_free0 (_tmp49_);
			break;
		}
		case DISPLAY_TRANSFORM_FLIPPED_ROTATION_180:
		{
			DisplayVirtualMonitor* _tmp50_;
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			GtkLabel* _tmp53_;
			GtkLabel* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			_tmp50_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp50_, &_tmp51_, &_tmp52_);
			self->priv->real_width = _tmp51_;
			self->priv->real_height = _tmp52_;
			_tmp53_ = _data7_->label;
			gtk_widget_add_css_class ((GtkWidget*) _tmp53_, "rotate-180");
			_tmp54_ = _data7_->label;
			_tmp55_ = _data7_->virtual_monitor_name;
			_tmp56_ = g_utf8_strreverse (_tmp55_, (gssize) -1);
			_tmp57_ = _tmp56_;
			gtk_label_set_label (_tmp54_, _tmp57_);
			_g_free0 (_tmp57_);
			break;
		}
		case DISPLAY_TRANSFORM_FLIPPED_ROTATION_270:
		{
			DisplayVirtualMonitor* _tmp58_;
			gint _tmp59_ = 0;
			gint _tmp60_ = 0;
			GtkLabel* _tmp61_;
			GtkLabel* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp58_ = self->priv->_virtual_monitor;
			display_virtual_monitor_get_current_mode_size (_tmp58_, &_tmp59_, &_tmp60_);
			self->priv->real_height = _tmp59_;
			self->priv->real_width = _tmp60_;
			_tmp61_ = _data7_->label;
			gtk_widget_add_css_class ((GtkWidget*) _tmp61_, "rotate-90");
			_tmp62_ = _data7_->label;
			_tmp63_ = _data7_->virtual_monitor_name;
			_tmp64_ = g_utf8_strreverse (_tmp63_, (gssize) -1);
			_tmp65_ = _tmp64_;
			gtk_label_set_label (_tmp62_, _tmp65_);
			_g_free0 (_tmp65_);
			break;
		}
		default:
		break;
	}
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL], 0);
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CHECK_POSITION_SIGNAL], 0);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}

static void
__display_display_widget___lambda12__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_display_display_widget___lambda12_ (self);
}

static void
_display_display_widget___lambda13_ (Block7Data* _data7_)
{
	DisplayDisplayWidget* self;
	GtkPopover* _tmp0_;
	GValue val = {0};
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	self = _data7_->self;
	_tmp0_ = _data7_->popover;
	gtk_popover_popdown (_tmp0_);
	_tmp1_ = self->priv->refresh_combobox;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		GValue _tmp6_ = {0};
		DisplayMonitorMode* new_mode = NULL;
		GValue _tmp7_;
		DisplayMonitorMode* _tmp8_;
		DisplayVirtualMonitor* _tmp9_;
		DisplayMonitorMode* _tmp10_;
		GtkComboBox* _tmp11_;
		_tmp4_ = self->priv->refresh_list_store;
		_tmp5_ = iter;
		gtk_tree_model_get_value ((GtkTreeModel*) _tmp4_, &_tmp5_, (gint) DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_VALUE, &_tmp6_);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		val = _tmp6_;
		_tmp7_ = val;
		_tmp8_ = _g_object_ref0 (g_value_get_object (&_tmp7_));
		new_mode = _tmp8_;
		_tmp9_ = self->priv->_virtual_monitor;
		_tmp10_ = new_mode;
		display_virtual_monitor_set_current_mode (_tmp9_, _tmp10_);
		_tmp11_ = self->priv->rotation_combobox;
		gtk_combo_box_set_active (_tmp11_, 0);
		g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL], 0);
		g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CHECK_POSITION_SIGNAL], 0);
		_g_object_unref0 (new_mode);
	}
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}

static void
__display_display_widget___lambda13__gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	_display_display_widget___lambda13_ (self);
}

static void
_display_display_widget___lambda14_ (Block7Data* _data7_)
{
	DisplayDisplayWidget* self;
	GtkPopover* _tmp0_;
	self = _data7_->self;
	_tmp0_ = _data7_->popover;
	gtk_popover_popdown (_tmp0_);
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL], 0);
}

static void
__display_display_widget___lambda14__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_display_display_widget___lambda14_ (self);
}

static void
_display_display_widget_on_monitor_modes_changed_display_virtual_monitor_modes_changed (DisplayVirtualMonitor* _sender,
                                                                                        gpointer self)
{
	display_display_widget_on_monitor_modes_changed ((DisplayDisplayWidget*) self);
}

static void
_display_display_widget_on_vm_transform_changed_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	display_display_widget_on_vm_transform_changed ((DisplayDisplayWidget*) self);
}

static GObject *
display_display_widget_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DisplayDisplayWidget * self;
	Block7Data* _data7_;
	DisplayVirtualMonitor* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_;
	DisplayVirtualMonitor* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GraniteSwitchModelButton* _tmp10_;
	DisplayVirtualMonitor* _tmp11_;
	GraniteSwitchModelButton* _tmp12_;
	GtkTreeStore* _tmp13_;
	GtkTreeStore* _tmp14_;
	GtkComboBox* _tmp15_ = NULL;
	GraniteHeaderLabel* resolution_label = NULL;
	GtkComboBox* _tmp16_;
	GtkWidget* _tmp17_;
	GraniteHeaderLabel* _tmp18_ = NULL;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkCellRendererText* _tmp23_;
	GtkListStore* _tmp24_;
	GtkListStore* _tmp25_;
	GtkComboBox* _tmp26_ = NULL;
	GraniteHeaderLabel* rotation_label = NULL;
	GtkComboBox* _tmp27_;
	GtkWidget* _tmp28_;
	GraniteHeaderLabel* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_;
	GtkComboBox* _tmp31_;
	GtkCellRendererText* _tmp32_;
	GtkComboBox* _tmp33_;
	GtkCellRendererText* _tmp34_;
	GtkListStore* _tmp35_;
	GtkListStore* _tmp36_;
	GtkComboBox* _tmp37_ = NULL;
	GraniteHeaderLabel* refresh_label = NULL;
	GtkComboBox* _tmp38_;
	GtkWidget* _tmp39_;
	GraniteHeaderLabel* _tmp40_ = NULL;
	GtkCellRendererText* _tmp41_;
	GtkComboBox* _tmp42_;
	GtkCellRendererText* _tmp43_;
	GtkComboBox* _tmp44_;
	GtkCellRendererText* _tmp45_;
	DisplayResolution* resolutions = NULL;
	DisplayResolution* _tmp54_;
	gint resolutions_length1;
	gint _resolutions_size_;
	DisplayResolution* recommended_resolutions = NULL;
	DisplayResolution* _tmp55_;
	gint recommended_resolutions_length1;
	gint _recommended_resolutions_size_;
	DisplayResolution* other_resolutions = NULL;
	DisplayResolution* _tmp56_;
	gint other_resolutions_length1;
	gint _other_resolutions_size_;
	gint max_width = 0;
	gint max_height = 0;
	guint usable_resolutions = 0U;
	gint current_width = 0;
	gint current_height = 0;
	DisplayVirtualMonitor* _tmp57_;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	GeeTreeSet* resolution_set = NULL;
	GeeTreeSet* _tmp60_;
	gint native_ratio = 0;
	DisplayResolution* _tmp94_;
	gint _tmp94__length1;
	DisplayResolution* _tmp106_;
	gint _tmp106__length1;
	DisplayResolution* _tmp117_;
	gint _tmp117__length1;
	GtkComboBox* _tmp135_;
	GtkSignalListItemFactory* scale_drop_down_factory = NULL;
	GtkSignalListItemFactory* _tmp136_;
	GtkSignalListItemFactory* _tmp137_;
	GtkSignalListItemFactory* _tmp138_;
	DisplayVirtualMonitor* _tmp139_;
	GtkSingleSelection* _tmp140_;
	GtkSingleSelection* _tmp141_;
	GListModel* _tmp142_;
	GtkSignalListItemFactory* _tmp143_;
	GtkListItemFactory* _tmp144_;
	GtkDropDown* _tmp145_ = NULL;
	DisplayVirtualMonitor* _tmp146_;
	GtkSingleSelection* _tmp147_;
	GtkSingleSelection* _tmp148_;
	GtkDropDown* _tmp149_;
	GraniteHeaderLabel* scale_label = NULL;
	GtkDropDown* _tmp150_;
	GtkWidget* _tmp151_;
	GraniteHeaderLabel* _tmp152_ = NULL;
	GtkBox* popover_box = NULL;
	GtkBox* _tmp153_ = NULL;
	GtkBox* _tmp154_;
	GraniteSwitchModelButton* _tmp155_;
	GtkBox* _tmp156_;
	GraniteHeaderLabel* _tmp157_;
	GtkBox* _tmp158_;
	GtkComboBox* _tmp159_;
	GtkBox* _tmp160_;
	GraniteHeaderLabel* _tmp161_;
	GtkBox* _tmp162_;
	GtkComboBox* _tmp163_;
	GtkBox* _tmp164_;
	GraniteHeaderLabel* _tmp165_;
	GtkBox* _tmp166_;
	GtkComboBox* _tmp167_;
	DisplayMonitorManager* _tmp168_;
	gboolean _tmp169_;
	gboolean _tmp170_;
	GtkBox* _tmp175_;
	GtkWidget* _tmp176_;
	GtkPopover* _tmp177_ = NULL;
	GtkMenuButton* toggle_settings = NULL;
	gchar* _tmp178_;
	GtkPopover* _tmp179_;
	GtkPopover* _tmp180_;
	gchar* _tmp181_;
	GtkMenuButton* _tmp182_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp183_;
	GtkGrid* _tmp184_;
	GtkButton* _tmp185_;
	GtkGrid* _tmp186_;
	GtkMenuButton* _tmp187_;
	GtkGrid* _tmp188_;
	GtkLabel* _tmp189_;
	GtkGrid* _tmp190_;
	DisplayVirtualMonitor* _tmp191_;
	gboolean _tmp192_;
	gboolean _tmp193_;
	GraniteSwitchModelButton* _tmp194_;
	GtkComboBox* _tmp195_;
	GraniteSwitchModelButton* _tmp196_;
	GtkComboBox* _tmp197_;
	GraniteSwitchModelButton* _tmp198_;
	GtkComboBox* _tmp199_;
	GraniteSwitchModelButton* _tmp200_;
	GtkDropDown* _tmp201_;
	GraniteSwitchModelButton* _tmp202_;
	DisplayVirtualMonitor* _tmp203_;
	gboolean _tmp204_;
	gboolean _tmp205_;
	GtkComboBox* _tmp206_;
	GtkComboBox* _tmp207_;
	GtkComboBox* _tmp208_;
	GtkDropDown* _tmp209_;
	GtkComboBox* _tmp210_;
	DisplayVirtualMonitor* _tmp211_;
	DisplayTransform _tmp212_;
	DisplayTransform _tmp213_;
	DisplayVirtualMonitor* _tmp214_;
	DisplayVirtualMonitor* _tmp215_;
	parent_class = G_OBJECT_CLASS (display_display_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_DISPLAY_WIDGET, DisplayDisplayWidget);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = self->priv->_virtual_monitor;
	display_virtual_monitor_get_current_mode_size (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->real_width = _tmp1_;
	self->priv->real_height = _tmp2_;
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("non-starred-symbolic");
	gtk_button_set_has_frame (_tmp3_, FALSE);
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->primary_image);
	self->priv->primary_image = _tmp3_;
	_tmp4_ = self->priv->primary_image;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) __display_display_widget___lambda7__gtk_button_clicked, self, 0);
	_tmp5_ = self->priv->_virtual_monitor;
	_tmp6_ = display_virtual_monitor_get_display_name (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	_data7_->virtual_monitor_name = _tmp7_;
	_tmp8_ = _data7_->virtual_monitor_name;
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	g_object_ref_sink (_tmp9_);
	_data7_->label = _tmp9_;
	_tmp10_ = granite_switch_model_button_new (_ ("Use This Display"));
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->use_switch);
	self->priv->use_switch = _tmp10_;
	_tmp11_ = self->priv->_virtual_monitor;
	_tmp12_ = self->priv->use_switch;
	g_object_bind_property_with_closures ((GObject*) _tmp11_, "is-active", (GObject*) _tmp12_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = gtk_tree_store_new ((gint) DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_TOTAL, G_TYPE_STRING, G_TYPE_INT, G_TYPE_INT);
	_g_object_unref0 (self->priv->resolution_tree_store);
	self->priv->resolution_tree_store = _tmp13_;
	_tmp14_ = self->priv->resolution_tree_store;
	_tmp15_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp14_);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp15_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp15_, 12);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->resolution_combobox);
	self->priv->resolution_combobox = _tmp15_;
	_tmp16_ = self->priv->resolution_combobox;
	_tmp17_ = _g_object_ref0 ((GtkWidget*) _tmp16_);
	_tmp18_ = granite_header_label_new (_ ("Resolution"));
	granite_header_label_set_mnemonic_widget (_tmp18_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	resolution_label = _tmp18_;
	_tmp19_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp19_);
	text_renderer = _tmp19_;
	_tmp20_ = self->priv->resolution_combobox;
	_tmp21_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp20_, (GtkCellRenderer*) _tmp21_, TRUE);
	_tmp22_ = self->priv->resolution_combobox;
	_tmp23_ = text_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) _tmp23_, "text", (gint) DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME);
	_tmp24_ = gtk_list_store_new ((gint) DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_TOTAL, G_TYPE_STRING, G_TYPE_INT, -1);
	_g_object_unref0 (self->priv->rotation_list_store);
	self->priv->rotation_list_store = _tmp24_;
	_tmp25_ = self->priv->rotation_list_store;
	_tmp26_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp25_);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp26_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp26_, 12);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->rotation_combobox);
	self->priv->rotation_combobox = _tmp26_;
	_tmp27_ = self->priv->rotation_combobox;
	_tmp28_ = _g_object_ref0 ((GtkWidget*) _tmp27_);
	_tmp29_ = granite_header_label_new (_ ("Screen Rotation"));
	granite_header_label_set_mnemonic_widget (_tmp29_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	g_object_ref_sink (_tmp29_);
	rotation_label = _tmp29_;
	_tmp30_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp30_;
	_tmp31_ = self->priv->rotation_combobox;
	_tmp32_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp31_, (GtkCellRenderer*) _tmp32_, TRUE);
	_tmp33_ = self->priv->rotation_combobox;
	_tmp34_ = text_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, "text", (gint) DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_NAME);
	_tmp35_ = gtk_list_store_new ((gint) DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_TOTAL, G_TYPE_STRING, DISPLAY_TYPE_MONITOR_MODE, -1);
	_g_object_unref0 (self->priv->refresh_list_store);
	self->priv->refresh_list_store = _tmp35_;
	_tmp36_ = self->priv->refresh_list_store;
	_tmp37_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp36_);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp37_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp37_, 12);
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->refresh_combobox);
	self->priv->refresh_combobox = _tmp37_;
	_tmp38_ = self->priv->refresh_combobox;
	_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
	_tmp40_ = granite_header_label_new (_ ("Refresh Rate"));
	granite_header_label_set_mnemonic_widget (_tmp40_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	g_object_ref_sink (_tmp40_);
	refresh_label = _tmp40_;
	_tmp41_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp41_;
	_tmp42_ = self->priv->refresh_combobox;
	_tmp43_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp42_, (GtkCellRenderer*) _tmp43_, TRUE);
	_tmp44_ = self->priv->refresh_combobox;
	_tmp45_ = text_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp44_, (GtkCellRenderer*) _tmp45_, "text", (gint) DISPLAY_DISPLAY_WIDGET_REFRESH_COLUMNS_NAME);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				GtkTreeIter iter = {0};
				GtkListStore* _tmp48_;
				GtkTreeIter _tmp49_ = {0};
				GtkListStore* _tmp50_;
				GtkTreeIter _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				if (!(i <= ((gint) DISPLAY_TRANSFORM_FLIPPED_ROTATION_270))) {
					break;
				}
				_tmp48_ = self->priv->rotation_list_store;
				gtk_list_store_append (_tmp48_, &_tmp49_);
				iter = _tmp49_;
				_tmp50_ = self->priv->rotation_list_store;
				_tmp51_ = iter;
				_tmp52_ = display_transform_to_string ((DisplayTransform) i);
				_tmp53_ = _tmp52_;
				gtk_list_store_set (_tmp50_, &_tmp51_, DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_NAME, _tmp53_, DISPLAY_DISPLAY_WIDGET_ROTATION_COLUMNS_VALUE, i, -1);
				_g_free0 (_tmp53_);
			}
		}
	}
	_tmp54_ = g_new0 (DisplayResolution, 0);
	resolutions = _tmp54_;
	resolutions_length1 = 0;
	_resolutions_size_ = resolutions_length1;
	_tmp55_ = g_new0 (DisplayResolution, 0);
	recommended_resolutions = _tmp55_;
	recommended_resolutions_length1 = 0;
	_recommended_resolutions_size_ = recommended_resolutions_length1;
	_tmp56_ = g_new0 (DisplayResolution, 0);
	other_resolutions = _tmp56_;
	other_resolutions_length1 = 0;
	_other_resolutions_size_ = other_resolutions_length1;
	max_width = -1;
	max_height = -1;
	usable_resolutions = (guint) 0;
	_tmp57_ = self->priv->_virtual_monitor;
	display_virtual_monitor_get_current_mode_size (_tmp57_, &_tmp58_, &_tmp59_);
	current_width = _tmp58_;
	current_height = _tmp59_;
	_tmp60_ = gee_tree_set_new (DISPLAY_TYPE_MONITOR_MODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _display_monitor_mode_resolution_compare_func_gcompare_data_func, NULL, NULL);
	resolution_set = _tmp60_;
	{
		GeeLinkedList* _mode_list = NULL;
		DisplayVirtualMonitor* _tmp61_;
		GeeLinkedList* _tmp62_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _mode_index = 0;
		_tmp61_ = self->priv->_virtual_monitor;
		_tmp62_ = display_virtual_monitor_get_available_modes (_tmp61_);
		_mode_list = _tmp62_;
		_tmp63_ = _mode_list;
		_tmp64_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_mode_size = _tmp65_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp68_;
			gpointer _tmp69_;
			GeeTreeSet* _tmp70_;
			DisplayMonitorMode* _tmp71_;
			_mode_index = _mode_index + 1;
			_tmp66_ = _mode_index;
			_tmp67_ = _mode_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _mode_list;
			_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp69_;
			_tmp70_ = resolution_set;
			_tmp71_ = mode;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, _tmp71_);
			_g_object_unref0 (mode);
		}
		_g_object_unref0 (_mode_list);
	}
	{
		GeeIterator* _mode_it = NULL;
		GeeTreeSet* _tmp72_;
		GeeIterator* _tmp73_;
		_tmp72_ = resolution_set;
		_tmp73_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp72_);
		_mode_it = _tmp73_;
		while (TRUE) {
			GeeIterator* _tmp74_;
			DisplayMonitorMode* mode = NULL;
			GeeIterator* _tmp75_;
			gpointer _tmp76_;
			gint mode_width = 0;
			DisplayMonitorMode* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gint mode_height = 0;
			DisplayMonitorMode* _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
			DisplayMonitorMode* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
			DisplayResolution res = {0};
			DisplayMonitorMode* _tmp86_;
			gboolean _tmp87_;
			gboolean _tmp88_;
			DisplayMonitorMode* _tmp89_;
			gboolean _tmp90_;
			gboolean _tmp91_;
			DisplayResolution _tmp92_ = {0};
			DisplayResolution _tmp93_;
			_tmp74_ = _mode_it;
			if (!gee_iterator_next (_tmp74_)) {
				break;
			}
			_tmp75_ = _mode_it;
			_tmp76_ = gee_iterator_get (_tmp75_);
			mode = (DisplayMonitorMode*) _tmp76_;
			_tmp77_ = mode;
			_tmp78_ = display_monitor_mode_get_width (_tmp77_);
			_tmp79_ = _tmp78_;
			mode_width = _tmp79_;
			_tmp80_ = mode;
			_tmp81_ = display_monitor_mode_get_height (_tmp80_);
			_tmp82_ = _tmp81_;
			mode_height = _tmp82_;
			_tmp83_ = mode;
			_tmp84_ = display_monitor_mode_get_is_preferred (_tmp83_);
			_tmp85_ = _tmp84_;
			if (_tmp85_) {
				max_width = MAX (max_width, mode_width);
				max_height = MAX (max_height, mode_height);
			}
			_tmp86_ = mode;
			_tmp87_ = display_monitor_mode_get_is_preferred (_tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = mode;
			_tmp90_ = display_monitor_mode_get_is_current (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_.width = mode_width;
			_tmp92_.height = mode_height;
			_tmp92_.aspect = (mode_width * 10) / mode_height;
			_tmp92_.is_preferred = _tmp88_;
			_tmp92_.is_current = _tmp91_;
			res = _tmp92_;
			_tmp93_ = res;
			_vala_array_add5 (&resolutions, &resolutions_length1, &_resolutions_size_, &_tmp93_);
			_g_object_unref0 (mode);
		}
		_g_object_unref0 (_mode_it);
	}
	native_ratio = (max_width * 10) / max_height;
	_tmp94_ = resolutions;
	_tmp94__length1 = resolutions_length1;
	{
		DisplayResolution* resolution_collection = NULL;
		gint resolution_collection_length1 = 0;
		gint _resolution_collection_size_ = 0;
		gint resolution_it = 0;
		resolution_collection = _tmp94_;
		resolution_collection_length1 = _tmp94__length1;
		for (resolution_it = 0; resolution_it < resolution_collection_length1; resolution_it = resolution_it + 1) {
			DisplayResolution resolution = {0};
			resolution = resolution_collection[resolution_it];
			{
				gboolean _tmp95_ = FALSE;
				DisplayResolution _tmp96_;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp99_ = FALSE;
				DisplayResolution _tmp100_;
				guint _tmp105_;
				_tmp96_ = resolution;
				if (_tmp96_.width < 1024) {
					_tmp95_ = TRUE;
				} else {
					DisplayResolution _tmp97_;
					_tmp97_ = resolution;
					_tmp95_ = _tmp97_.height < 768;
				}
				if (_tmp95_) {
					continue;
				}
				_tmp100_ = resolution;
				if (_tmp100_.is_preferred) {
					_tmp99_ = TRUE;
				} else {
					DisplayResolution _tmp101_;
					_tmp101_ = resolution;
					_tmp99_ = _tmp101_.is_current;
				}
				if (_tmp99_) {
					_tmp98_ = TRUE;
				} else {
					DisplayResolution _tmp102_;
					_tmp102_ = resolution;
					_tmp98_ = _tmp102_.aspect == native_ratio;
				}
				if (_tmp98_) {
					DisplayResolution _tmp103_;
					_tmp103_ = resolution;
					_vala_array_add6 (&recommended_resolutions, &recommended_resolutions_length1, &_recommended_resolutions_size_, &_tmp103_);
				} else {
					DisplayResolution _tmp104_;
					_tmp104_ = resolution;
					_vala_array_add7 (&other_resolutions, &other_resolutions_length1, &_other_resolutions_size_, &_tmp104_);
				}
				_tmp105_ = usable_resolutions;
				usable_resolutions = _tmp105_ + 1;
			}
		}
	}
	_tmp106_ = recommended_resolutions;
	_tmp106__length1 = recommended_resolutions_length1;
	{
		DisplayResolution* resolution_collection = NULL;
		gint resolution_collection_length1 = 0;
		gint _resolution_collection_size_ = 0;
		gint resolution_it = 0;
		resolution_collection = _tmp106_;
		resolution_collection_length1 = _tmp106__length1;
		for (resolution_it = 0; resolution_it < resolution_collection_length1; resolution_it = resolution_it + 1) {
			DisplayResolution resolution = {0};
			resolution = resolution_collection[resolution_it];
			{
				GtkTreeIter iter = {0};
				GtkTreeStore* _tmp107_;
				GtkTreeIter _tmp108_ = {0};
				GtkTreeStore* _tmp109_;
				GtkTreeIter _tmp110_;
				DisplayResolution _tmp111_;
				DisplayResolution _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				DisplayResolution _tmp115_;
				DisplayResolution _tmp116_;
				_tmp107_ = self->priv->resolution_tree_store;
				gtk_tree_store_append (_tmp107_, &_tmp108_, NULL);
				iter = _tmp108_;
				_tmp109_ = self->priv->resolution_tree_store;
				_tmp110_ = iter;
				_tmp111_ = resolution;
				_tmp112_ = resolution;
				_tmp113_ = display_monitor_mode_get_resolution_string (_tmp111_.width, _tmp112_.height, FALSE);
				_tmp114_ = _tmp113_;
				_tmp115_ = resolution;
				_tmp116_ = resolution;
				gtk_tree_store_set (_tmp109_, &_tmp110_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME, _tmp114_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH, _tmp115_.width, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT, _tmp116_.height, -1);
				_g_free0 (_tmp114_);
			}
		}
	}
	_tmp117_ = other_resolutions;
	_tmp117__length1 = other_resolutions_length1;
	if (_tmp117__length1 > 0) {
		GtkTreeIter iter = {0};
		GtkTreeIter parent_iter = {0};
		GtkTreeStore* _tmp118_;
		GtkTreeIter _tmp119_ = {0};
		GtkTreeStore* _tmp120_;
		GtkTreeIter _tmp121_;
		DisplayResolution* _tmp122_;
		gint _tmp122__length1;
		_tmp118_ = self->priv->resolution_tree_store;
		gtk_tree_store_append (_tmp118_, &_tmp119_, NULL);
		parent_iter = _tmp119_;
		_tmp120_ = self->priv->resolution_tree_store;
		_tmp121_ = parent_iter;
		gtk_tree_store_set (_tmp120_, &_tmp121_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME, _ ("Other…"), DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH, -1, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT, -1, -1);
		_tmp122_ = other_resolutions;
		_tmp122__length1 = other_resolutions_length1;
		{
			DisplayResolution* resolution_collection = NULL;
			gint resolution_collection_length1 = 0;
			gint _resolution_collection_size_ = 0;
			gint resolution_it = 0;
			resolution_collection = _tmp122_;
			resolution_collection_length1 = _tmp122__length1;
			for (resolution_it = 0; resolution_it < resolution_collection_length1; resolution_it = resolution_it + 1) {
				DisplayResolution resolution = {0};
				resolution = resolution_collection[resolution_it];
				{
					GtkTreeStore* _tmp123_;
					GtkTreeIter _tmp124_;
					GtkTreeIter _tmp125_ = {0};
					GtkTreeStore* _tmp126_;
					GtkTreeIter _tmp127_;
					DisplayResolution _tmp128_;
					DisplayResolution _tmp129_;
					gchar* _tmp130_;
					gchar* _tmp131_;
					DisplayResolution _tmp132_;
					DisplayResolution _tmp133_;
					_tmp123_ = self->priv->resolution_tree_store;
					_tmp124_ = parent_iter;
					gtk_tree_store_append (_tmp123_, &_tmp125_, &_tmp124_);
					iter = _tmp125_;
					_tmp126_ = self->priv->resolution_tree_store;
					_tmp127_ = iter;
					_tmp128_ = resolution;
					_tmp129_ = resolution;
					_tmp130_ = display_monitor_mode_get_resolution_string (_tmp128_.width, _tmp129_.height, TRUE);
					_tmp131_ = _tmp130_;
					_tmp132_ = resolution;
					_tmp133_ = resolution;
					gtk_tree_store_set (_tmp126_, &_tmp127_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_NAME, _tmp131_, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_WIDTH, _tmp132_.width, DISPLAY_DISPLAY_WIDGET_RESOLUTION_COLUMNS_HEIGHT, _tmp133_.height, -1);
					_g_free0 (_tmp131_);
				}
			}
		}
	}
	if (!display_display_widget_set_active_resolution_from_current_mode (self)) {
		GtkComboBox* _tmp134_;
		_tmp134_ = self->priv->resolution_combobox;
		gtk_combo_box_set_active (_tmp134_, 0);
	}
	_tmp135_ = self->priv->resolution_combobox;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp135_, usable_resolutions > ((guint) 1));
	display_display_widget_populate_refresh_rates (self);
	_tmp136_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	scale_drop_down_factory = _tmp136_;
	_tmp137_ = scale_drop_down_factory;
	g_signal_connect_object (_tmp137_, "setup", (GCallback) __display_display_widget___lambda8__gtk_signal_list_item_factory_setup, self, 0);
	_tmp138_ = scale_drop_down_factory;
	g_signal_connect_object (_tmp138_, "bind", (GCallback) __display_display_widget___lambda9__gtk_signal_list_item_factory_bind, self, 0);
	_tmp139_ = self->priv->_virtual_monitor;
	_tmp140_ = display_virtual_monitor_get_available_scales (_tmp139_);
	_tmp141_ = _tmp140_;
	_tmp142_ = _g_object_ref0 ((GListModel*) _tmp141_);
	_tmp143_ = scale_drop_down_factory;
	_tmp144_ = _g_object_ref0 ((GtkListItemFactory*) _tmp143_);
	_tmp145_ = (GtkDropDown*) gtk_drop_down_new (_tmp142_, NULL);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp145_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp145_, 12);
	gtk_drop_down_set_factory (_tmp145_, _tmp144_);
	_g_object_unref0 (_tmp144_);
	g_object_ref_sink (_tmp145_);
	_g_object_unref0 (self->priv->scale_drop_down);
	self->priv->scale_drop_down = _tmp145_;
	_tmp146_ = self->priv->_virtual_monitor;
	_tmp147_ = display_virtual_monitor_get_available_scales (_tmp146_);
	_tmp148_ = _tmp147_;
	_tmp149_ = self->priv->scale_drop_down;
	g_object_bind_property_with_closures ((GObject*) _tmp148_, "selected", (GObject*) _tmp149_, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp150_ = self->priv->scale_drop_down;
	_tmp151_ = _g_object_ref0 ((GtkWidget*) _tmp150_);
	_tmp152_ = granite_header_label_new (_ ("Scaling factor"));
	granite_header_label_set_mnemonic_widget (_tmp152_, _tmp151_);
	_g_object_unref0 (_tmp151_);
	g_object_ref_sink (_tmp152_);
	scale_label = _tmp152_;
	_tmp153_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp153_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp153_, 12);
	g_object_ref_sink (_tmp153_);
	popover_box = _tmp153_;
	_tmp154_ = popover_box;
	_tmp155_ = self->priv->use_switch;
	gtk_box_append (_tmp154_, (GtkWidget*) _tmp155_);
	_tmp156_ = popover_box;
	_tmp157_ = resolution_label;
	gtk_box_append (_tmp156_, (GtkWidget*) _tmp157_);
	_tmp158_ = popover_box;
	_tmp159_ = self->priv->resolution_combobox;
	gtk_box_append (_tmp158_, (GtkWidget*) _tmp159_);
	_tmp160_ = popover_box;
	_tmp161_ = rotation_label;
	gtk_box_append (_tmp160_, (GtkWidget*) _tmp161_);
	_tmp162_ = popover_box;
	_tmp163_ = self->priv->rotation_combobox;
	gtk_box_append (_tmp162_, (GtkWidget*) _tmp163_);
	_tmp164_ = popover_box;
	_tmp165_ = refresh_label;
	gtk_box_append (_tmp164_, (GtkWidget*) _tmp165_);
	_tmp166_ = popover_box;
	_tmp167_ = self->priv->refresh_combobox;
	gtk_box_append (_tmp166_, (GtkWidget*) _tmp167_);
	_tmp168_ = display_monitor_manager_get_default ();
	_tmp169_ = display_monitor_manager_get_global_scale_required (_tmp168_);
	_tmp170_ = _tmp169_;
	if (!_tmp170_) {
		GtkBox* _tmp171_;
		GraniteHeaderLabel* _tmp172_;
		GtkBox* _tmp173_;
		GtkDropDown* _tmp174_;
		_tmp171_ = popover_box;
		_tmp172_ = scale_label;
		gtk_box_append (_tmp171_, (GtkWidget*) _tmp172_);
		_tmp173_ = popover_box;
		_tmp174_ = self->priv->scale_drop_down;
		gtk_box_append (_tmp173_, (GtkWidget*) _tmp174_);
	}
	_tmp175_ = popover_box;
	_tmp176_ = _g_object_ref0 ((GtkWidget*) _tmp175_);
	_tmp177_ = (GtkPopover*) gtk_popover_new ();
	gtk_popover_set_child (_tmp177_, _tmp176_);
	_g_object_unref0 (_tmp176_);
	gtk_popover_set_position (_tmp177_, GTK_POS_BOTTOM);
	g_object_ref_sink (_tmp177_);
	_data7_->popover = _tmp177_;
	_tmp178_ = g_strdup ("open-menu-symbolic");
	_tmp179_ = _data7_->popover;
	_tmp180_ = _g_object_ref0 (_tmp179_);
	_tmp181_ = g_strdup (_ ("Configure display"));
	_tmp182_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_has_frame (_tmp182_, FALSE);
	gtk_widget_set_halign ((GtkWidget*) _tmp182_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp182_, GTK_ALIGN_START);
	gtk_menu_button_set_icon_name (_tmp182_, _tmp178_);
	_g_free0 (_tmp178_);
	gtk_menu_button_set_popover (_tmp182_, _tmp180_);
	_g_object_unref0 (_tmp180_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp182_, _tmp181_);
	_g_free0 (_tmp181_);
	g_object_ref_sink (_tmp182_);
	toggle_settings = _tmp182_;
	_tmp183_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp183_);
	grid = _tmp183_;
	_tmp184_ = grid;
	_tmp185_ = self->priv->primary_image;
	gtk_grid_attach (_tmp184_, (GtkWidget*) _tmp185_, 0, 0, 1, 1);
	_tmp186_ = grid;
	_tmp187_ = toggle_settings;
	gtk_grid_attach (_tmp186_, (GtkWidget*) _tmp187_, 2, 0, 1, 1);
	_tmp188_ = grid;
	_tmp189_ = _data7_->label;
	gtk_grid_attach (_tmp188_, (GtkWidget*) _tmp189_, 0, 0, 3, 2);
	_tmp190_ = grid;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp190_);
	_tmp191_ = self->priv->_virtual_monitor;
	_tmp192_ = display_virtual_monitor_get_primary (_tmp191_);
	_tmp193_ = _tmp192_;
	display_display_widget_set_primary (self, _tmp193_);
	_tmp194_ = self->priv->use_switch;
	_tmp195_ = self->priv->resolution_combobox;
	g_object_bind_property_with_closures ((GObject*) _tmp194_, "active", (GObject*) _tmp195_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp196_ = self->priv->use_switch;
	_tmp197_ = self->priv->rotation_combobox;
	g_object_bind_property_with_closures ((GObject*) _tmp196_, "active", (GObject*) _tmp197_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp198_ = self->priv->use_switch;
	_tmp199_ = self->priv->refresh_combobox;
	g_object_bind_property_with_closures ((GObject*) _tmp198_, "active", (GObject*) _tmp199_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp200_ = self->priv->use_switch;
	_tmp201_ = self->priv->scale_drop_down;
	g_object_bind_property_with_closures ((GObject*) _tmp200_, "active", (GObject*) _tmp201_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp202_ = self->priv->use_switch;
	g_signal_connect_object ((GObject*) _tmp202_, "notify::active", (GCallback) __display_display_widget___lambda10__g_object_notify, self, 0);
	_tmp203_ = self->priv->_virtual_monitor;
	_tmp204_ = display_virtual_monitor_get_is_active (_tmp203_);
	_tmp205_ = _tmp204_;
	if (!_tmp205_) {
		gtk_widget_add_css_class ((GtkWidget*) self, "disabled");
	}
	_tmp206_ = self->priv->resolution_combobox;
	g_signal_connect_data (_tmp206_, "changed", (GCallback) __display_display_widget___lambda11__gtk_combo_box_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp207_ = self->priv->rotation_combobox;
	g_signal_connect_data (_tmp207_, "changed", (GCallback) __display_display_widget___lambda12__gtk_combo_box_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp208_ = self->priv->refresh_combobox;
	g_signal_connect_data (_tmp208_, "changed", (GCallback) __display_display_widget___lambda13__gtk_combo_box_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp209_ = self->priv->scale_drop_down;
	g_signal_connect_data ((GObject*) _tmp209_, "notify::selected-item", (GCallback) __display_display_widget___lambda14__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp210_ = self->priv->rotation_combobox;
	_tmp211_ = self->priv->_virtual_monitor;
	_tmp212_ = display_virtual_monitor_get_transform (_tmp211_);
	_tmp213_ = _tmp212_;
	gtk_combo_box_set_active (_tmp210_, (gint) _tmp213_);
	display_display_widget_on_vm_transform_changed (self);
	_tmp214_ = self->priv->_virtual_monitor;
	g_signal_connect_object (_tmp214_, "modes-changed", (GCallback) _display_display_widget_on_monitor_modes_changed_display_virtual_monitor_modes_changed, self, 0);
	_tmp215_ = self->priv->_virtual_monitor;
	g_signal_connect_object ((GObject*) _tmp215_, "notify::transform", (GCallback) _display_display_widget_on_vm_transform_changed_g_object_notify, self, 0);
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL], 0);
	g_signal_emit (self, display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CHECK_POSITION_SIGNAL], 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (toggle_settings);
	_g_object_unref0 (popover_box);
	_g_object_unref0 (scale_label);
	_g_object_unref0 (scale_drop_down_factory);
	_g_object_unref0 (resolution_set);
	other_resolutions = (g_free (other_resolutions), NULL);
	recommended_resolutions = (g_free (recommended_resolutions), NULL);
	resolutions = (g_free (resolutions), NULL);
	_g_object_unref0 (refresh_label);
	_g_object_unref0 (rotation_label);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (resolution_label);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return obj;
}

static void
display_display_widget_base_init (DisplayDisplayWidgetClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "display-widget");
}

static void
display_display_widget_class_init (DisplayDisplayWidgetClass * klass,
                                   gpointer klass_data)
{
	display_display_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayDisplayWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_display_display_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_display_display_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = display_display_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = display_display_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAY_WIDGET_VIRTUAL_MONITOR_PROPERTY, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_VIRTUAL_MONITOR_PROPERTY] = g_param_spec_object ("virtual-monitor", "virtual-monitor", "virtual-monitor", DISPLAY_TYPE_VIRTUAL_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAY_WIDGET_BG_COLOR_PROPERTY, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_BG_COLOR_PROPERTY] = g_param_spec_string ("bg-color", "bg-color", "bg-color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAY_WIDGET_TEXT_COLOR_PROPERTY, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_TEXT_COLOR_PROPERTY] = g_param_spec_string ("text-color", "text-color", "text-color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAY_WIDGET_DISPLAY_NAME_PROPERTY, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAY_WIDGET_WINDOW_RATIO_PROPERTY, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_WINDOW_RATIO_PROPERTY] = g_param_spec_double ("window-ratio", "window-ratio", "window-ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_DISPLAY_WIDGET_CONNECTED_PROPERTY, display_display_widget_properties[DISPLAY_DISPLAY_WIDGET_CONNECTED_PROPERTY] = g_param_spec_boolean ("connected", "connected", "connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_SET_AS_PRIMARY_SIGNAL] = g_signal_new ("set-as-primary", DISPLAY_TYPE_DISPLAY_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CHECK_POSITION_SIGNAL] = g_signal_new ("check-position", DISPLAY_TYPE_DISPLAY_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_CONFIGURATION_CHANGED_SIGNAL] = g_signal_new ("configuration-changed", DISPLAY_TYPE_DISPLAY_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	display_display_widget_signals[DISPLAY_DISPLAY_WIDGET_ACTIVE_CHANGED_SIGNAL] = g_signal_new ("active-changed", DISPLAY_TYPE_DISPLAY_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
display_display_widget_instance_init (DisplayDisplayWidget * self,
                                      gpointer klass)
{
	self->priv = display_display_widget_get_instance_private (self);
	self->priv->_window_ratio = 1.0;
	self->priv->real_width = 0;
	self->priv->real_height = 0;
}

static void
display_display_widget_finalize (GObject * obj)
{
	DisplayDisplayWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_DISPLAY_WIDGET, DisplayDisplayWidget);
	_g_object_unref0 (self->priv->_virtual_monitor);
	_g_free0 (self->priv->_bg_color);
	_g_free0 (self->priv->_text_color);
	_g_object_unref0 (self->priv->primary_image);
	_g_object_unref0 (self->priv->use_switch);
	_g_object_unref0 (self->priv->resolution_combobox);
	_g_object_unref0 (self->priv->resolution_tree_store);
	_g_object_unref0 (self->priv->rotation_combobox);
	_g_object_unref0 (self->priv->rotation_list_store);
	_g_object_unref0 (self->priv->refresh_combobox);
	_g_object_unref0 (self->priv->refresh_list_store);
	_g_object_unref0 (self->priv->scale_drop_down);
	G_OBJECT_CLASS (display_display_widget_parent_class)->finalize (obj);
}

static GType
display_display_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayDisplayWidgetClass), (GBaseInitFunc) display_display_widget_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_display_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayDisplayWidget), 0, (GInstanceInitFunc) display_display_widget_instance_init, NULL };
	GType display_display_widget_type_id;
	display_display_widget_type_id = g_type_register_static (gtk_box_get_type (), "DisplayDisplayWidget", &g_define_type_info, 0);
	DisplayDisplayWidget_private_offset = g_type_add_instance_private (display_display_widget_type_id, sizeof (DisplayDisplayWidgetPrivate));
	return display_display_widget_type_id;
}

GType
display_display_widget_get_type (void)
{
	static volatile gsize display_display_widget_type_id__once = 0;
	if (g_once_init_enter (&display_display_widget_type_id__once)) {
		GType display_display_widget_type_id;
		display_display_widget_type_id = display_display_widget_get_type_once ();
		g_once_init_leave (&display_display_widget_type_id__once, display_display_widget_type_id);
	}
	return display_display_widget_type_id__once;
}

static void
_vala_display_display_widget_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	DisplayDisplayWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_DISPLAY_WIDGET, DisplayDisplayWidget);
	switch (property_id) {
		case DISPLAY_DISPLAY_WIDGET_VIRTUAL_MONITOR_PROPERTY:
		g_value_set_object (value, display_display_widget_get_virtual_monitor (self));
		break;
		case DISPLAY_DISPLAY_WIDGET_BG_COLOR_PROPERTY:
		g_value_set_string (value, display_display_widget_get_bg_color (self));
		break;
		case DISPLAY_DISPLAY_WIDGET_TEXT_COLOR_PROPERTY:
		g_value_set_string (value, display_display_widget_get_text_color (self));
		break;
		case DISPLAY_DISPLAY_WIDGET_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, display_display_widget_get_display_name (self));
		break;
		case DISPLAY_DISPLAY_WIDGET_WINDOW_RATIO_PROPERTY:
		g_value_set_double (value, display_display_widget_get_window_ratio (self));
		break;
		case DISPLAY_DISPLAY_WIDGET_CONNECTED_PROPERTY:
		g_value_set_boolean (value, display_display_widget_get_connected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_display_display_widget_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	DisplayDisplayWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_DISPLAY_WIDGET, DisplayDisplayWidget);
	switch (property_id) {
		case DISPLAY_DISPLAY_WIDGET_VIRTUAL_MONITOR_PROPERTY:
		display_display_widget_set_virtual_monitor (self, g_value_get_object (value));
		break;
		case DISPLAY_DISPLAY_WIDGET_BG_COLOR_PROPERTY:
		display_display_widget_set_bg_color (self, g_value_get_string (value));
		break;
		case DISPLAY_DISPLAY_WIDGET_TEXT_COLOR_PROPERTY:
		display_display_widget_set_text_color (self, g_value_get_string (value));
		break;
		case DISPLAY_DISPLAY_WIDGET_WINDOW_RATIO_PROPERTY:
		display_display_widget_set_window_ratio (self, g_value_get_double (value));
		break;
		case DISPLAY_DISPLAY_WIDGET_CONNECTED_PROPERTY:
		display_display_widget_set_connected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

