/* AppRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppRow.vala, do not modify */

/*
* SPDX-License-Identifier: LGPL-3.0-or-later
* SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
*
* Authored by: Leonhard Kargl <leo.kargl@proton.me>
*/

#include "io.elementary.settings.sound.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_APP_ROW_0_PROPERTY,
	SOUND_APP_ROW_NUM_PROPERTIES
};
static GParamSpec* sound_app_row_properties[SOUND_APP_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _SoundAppRowPrivate {
	SoundApp* app;
	GtkLabel* app_name_label;
	GtkLabel* media_name_label;
	GtkImage* image;
	GtkButton* icon_button;
	GtkScale* volume_scale;
	GtkSwitch* mute_switch;
};

struct _Block2Data {
	int _ref_count_;
	SoundAppRow* self;
	SoundApp* app;
};

static gint SoundAppRow_private_offset;
static gpointer sound_app_row_parent_class = NULL;

static void sound_app_row_toggle_mute_application (SoundAppRow* self,
                                            gboolean* custom);
static void sound_app_row_update (SoundAppRow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _sound_app_row_update_sound_app_changed (SoundApp* _sender,
                                              gpointer self);
static void __lambda17_ (Block2Data* _data2_);
static void ___lambda17__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static GObject * sound_app_row_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static gboolean _sound_app_row___lambda18_ (SoundAppRow* self,
                                     GtkScrollType type,
                                     gdouble new_value);
static gboolean __sound_app_row___lambda18__gtk_range_change_value (GtkRange* _sender,
                                                             GtkScrollType scroll,
                                                             gdouble new_value,
                                                             gpointer self);
static void _sound_app_row___lambda19_ (SoundAppRow* self);
static void __sound_app_row___lambda19__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static gboolean _sound_app_row___lambda20_ (SoundAppRow* self,
                                     gboolean state);
static gboolean __sound_app_row___lambda20__gtk_switch_state_set (GtkSwitch* _sender,
                                                           gboolean state,
                                                           gpointer self);
static void sound_app_row_finalize (GObject * obj);
static GType sound_app_row_get_type_once (void);

static inline gpointer
sound_app_row_get_instance_private (SoundAppRow* self)
{
	return G_STRUCT_MEMBER_P (self, SoundAppRow_private_offset);
}

static void
sound_app_row_toggle_mute_application (SoundAppRow* self,
                                       gboolean* custom)
{
	SoundApp* _tmp0_;
	gboolean* _tmp1_ = NULL;
	SoundPulseAudioManager* _tmp6_;
	SoundApp* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app;
	if (_tmp0_ == NULL) {
		return;
	}
	if (custom != NULL) {
		_tmp1_ = custom;
	} else {
		SoundApp* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->app;
		_tmp3_ = sound_app_get_muted (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = !_tmp4_;
		_tmp1_ = &_tmp5_;
	}
	_tmp6_ = sound_pulse_audio_manager_get_default ();
	_tmp7_ = self->priv->app;
	sound_pulse_audio_manager_mute_application (_tmp6_, _tmp7_, *_tmp1_);
}

static void
sound_app_row_update (SoundAppRow* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	SoundApp* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkScale* _tmp5_;
	SoundApp* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GtkSwitch* _tmp9_;
	SoundApp* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GtkScale* _tmp13_;
	SoundApp* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	SoundApp* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	SoundApp* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->media_name_label;
	_tmp1_ = self->priv->media_name_label;
	_tmp2_ = self->priv->app;
	_tmp3_ = sound_app_get_media_name (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp4_);
	gtk_label_set_label (_tmp0_, _tmp4_);
	_tmp5_ = self->priv->volume_scale;
	_tmp6_ = self->priv->app;
	_tmp7_ = sound_app_get_volume (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_range_set_value ((GtkRange*) _tmp5_, _tmp8_);
	_tmp9_ = self->priv->mute_switch;
	_tmp10_ = self->priv->app;
	_tmp11_ = sound_app_get_muted (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_switch_set_state (_tmp9_, !_tmp12_);
	_tmp13_ = self->priv->volume_scale;
	_tmp14_ = self->priv->app;
	_tmp15_ = sound_app_get_muted (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp16_);
	_tmp17_ = self->priv->app;
	_tmp18_ = sound_app_get_muted (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		GtkButton* _tmp20_;
		_tmp20_ = self->priv->icon_button;
		gtk_button_set_icon_name (_tmp20_, "audio-volume-muted");
	} else {
		GtkScale* _tmp21_;
		_tmp21_ = self->priv->volume_scale;
		if (gtk_range_get_value ((GtkRange*) _tmp21_) < 0.33) {
			GtkButton* _tmp22_;
			_tmp22_ = self->priv->icon_button;
			gtk_button_set_icon_name (_tmp22_, "audio-volume-low");
		} else {
			GtkScale* _tmp23_;
			_tmp23_ = self->priv->volume_scale;
			if (gtk_range_get_value ((GtkRange*) _tmp23_) > 0.66) {
				GtkButton* _tmp24_;
				_tmp24_ = self->priv->icon_button;
				gtk_button_set_icon_name (_tmp24_, "audio-volume-high");
			} else {
				GtkButton* _tmp25_;
				_tmp25_ = self->priv->icon_button;
				gtk_button_set_icon_name (_tmp25_, "audio-volume-medium");
			}
		}
	}
	_tmp26_ = self->priv->app;
	_tmp27_ = sound_app_get_muted (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		GtkButton* _tmp29_;
		_tmp29_ = self->priv->icon_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp29_, _ ("Unmute"));
	} else {
		GtkButton* _tmp30_;
		_tmp30_ = self->priv->icon_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _ ("Mute"));
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SoundAppRow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->app);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_sound_app_row_update_sound_app_changed (SoundApp* _sender,
                                         gpointer self)
{
	sound_app_row_update ((SoundAppRow*) self);
}

static void
__lambda17_ (Block2Data* _data2_)
{
	SoundAppRow* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data2_->self;
	_tmp0_ = sound_app_get_hidden (_data2_->app);
	_tmp1_ = _tmp0_;
	gtk_widget_set_visible ((GtkWidget*) self, _tmp1_);
}

static void
___lambda17__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda17_ (self);
}

void
sound_app_row_bind_app (SoundAppRow* self,
                        SoundApp* app)
{
	Block2Data* _data2_;
	SoundApp* _tmp0_;
	SoundApp* _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkImage* _tmp5_;
	GIcon* _tmp6_;
	GIcon* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkScale* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (_data2_->app);
	_data2_->app = _tmp0_;
	_tmp1_ = _g_object_ref0 (_data2_->app);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp1_;
	_tmp2_ = self->priv->app_name_label;
	_tmp3_ = sound_app_get_display_name (_data2_->app);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp2_, _tmp4_);
	_tmp5_ = self->priv->image;
	_tmp6_ = sound_app_get_icon (_data2_->app);
	_tmp7_ = _tmp6_;
	gtk_image_set_from_gicon (_tmp5_, _tmp7_);
	g_signal_connect_object (_data2_->app, "changed", (GCallback) _sound_app_row_update_sound_app_changed, self, 0);
	g_signal_connect_data ((GObject*) _data2_->app, "notify::hidden", (GCallback) ___lambda17__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp8_ = sound_app_get_hidden (_data2_->app);
	_tmp9_ = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) self, _tmp9_);
	_tmp10_ = self->priv->volume_scale;
	_tmp11_ = sound_app_get_volume (_data2_->app);
	_tmp12_ = _tmp11_;
	gtk_range_set_value ((GtkRange*) _tmp10_, _tmp12_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

void
sound_app_row_unbind_app (SoundAppRow* self)
{
	SoundApp* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app;
	g_signal_parse_name ("changed", SOUND_TYPE_APP, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _sound_app_row_update_sound_app_changed, self);
}

SoundAppRow*
sound_app_row_construct (GType object_type)
{
	SoundAppRow * self = NULL;
	self = (SoundAppRow*) g_object_new (object_type, NULL);
	return self;
}

SoundAppRow*
sound_app_row_new (void)
{
	return sound_app_row_construct (SOUND_TYPE_APP_ROW);
}

static gboolean
_sound_app_row___lambda18_ (SoundAppRow* self,
                            GtkScrollType type,
                            gdouble new_value)
{
	SoundApp* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->app;
	if (_tmp0_ != NULL) {
		SoundPulseAudioManager* _tmp1_;
		SoundApp* _tmp2_;
		_tmp1_ = sound_pulse_audio_manager_get_default ();
		_tmp2_ = self->priv->app;
		sound_pulse_audio_manager_change_application_volume (_tmp1_, _tmp2_, CLAMP (new_value, (gdouble) 0, (gdouble) 1));
	}
	result = TRUE;
	return result;
}

static gboolean
__sound_app_row___lambda18__gtk_range_change_value (GtkRange* _sender,
                                                    GtkScrollType scroll,
                                                    gdouble new_value,
                                                    gpointer self)
{
	gboolean result;
	result = _sound_app_row___lambda18_ ((SoundAppRow*) self, scroll, new_value);
	return result;
}

static void
_sound_app_row___lambda19_ (SoundAppRow* self)
{
	sound_app_row_toggle_mute_application (self, NULL);
}

static void
__sound_app_row___lambda19__gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	_sound_app_row___lambda19_ ((SoundAppRow*) self);
}

static gboolean
_sound_app_row___lambda20_ (SoundAppRow* self,
                            gboolean state)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = !state;
	sound_app_row_toggle_mute_application (self, &_tmp0_);
	result = TRUE;
	return result;
}

static gboolean
__sound_app_row___lambda20__gtk_switch_state_set (GtkSwitch* _sender,
                                                  gboolean state,
                                                  gpointer self)
{
	gboolean result;
	result = _sound_app_row___lambda20_ ((SoundAppRow*) self, state);
	return result;
}

static GObject *
sound_app_row_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundAppRow * self;
	GtkImage* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkBox* label_box = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkButton* _tmp11_;
	GtkScale* _tmp12_ = NULL;
	GtkSwitch* _tmp13_ = NULL;
	GtkImage* _tmp14_;
	GtkBox* _tmp15_;
	GtkButton* _tmp16_;
	GtkScale* _tmp17_;
	GtkSwitch* _tmp18_;
	GtkScale* _tmp19_;
	GtkButton* _tmp20_;
	GtkSwitch* _tmp21_;
	parent_class = G_OBJECT_CLASS (sound_app_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_APP_ROW, SoundAppRow);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_icon_size (_tmp0_, GTK_ICON_SIZE_LARGE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_ellipsize (_tmp1_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->app_name_label);
	self->priv->app_name_label = _tmp1_;
	_tmp2_ = self->priv->app_name_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp3_, (gfloat) 0);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->media_name_label);
	self->priv->media_name_label = _tmp3_;
	_tmp4_ = self->priv->media_name_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp5_ = self->priv->media_name_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp6_);
	label_box = _tmp6_;
	_tmp7_ = label_box;
	_tmp8_ = self->priv->app_name_label;
	gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = label_box;
	_tmp10_ = self->priv->media_name_label;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkButton*) gtk_button_new_from_icon_name ("audio-volume-muted");
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->icon_button);
	self->priv->icon_button = _tmp11_;
	_tmp12_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 1, 0.01);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->volume_scale);
	self->priv->volume_scale = _tmp12_;
	_tmp13_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->mute_switch);
	self->priv->mute_switch = _tmp13_;
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
	_tmp14_ = self->priv->image;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp14_, 0, 0, 1, 2);
	_tmp15_ = label_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp15_, 1, 0, 2, 1);
	_tmp16_ = self->priv->icon_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp16_, 1, 1, 1, 1);
	_tmp17_ = self->priv->volume_scale;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp17_, 2, 1, 1, 1);
	_tmp18_ = self->priv->mute_switch;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp18_, 3, 0, 1, 2);
	_tmp19_ = self->priv->volume_scale;
	g_signal_connect_object ((GtkRange*) _tmp19_, "change-value", (GCallback) __sound_app_row___lambda18__gtk_range_change_value, self, 0);
	_tmp20_ = self->priv->icon_button;
	g_signal_connect_object (_tmp20_, "clicked", (GCallback) __sound_app_row___lambda19__gtk_button_clicked, self, 0);
	_tmp21_ = self->priv->mute_switch;
	g_signal_connect_object (_tmp21_, "state-set", (GCallback) __sound_app_row___lambda20__gtk_switch_state_set, self, 0);
	_g_object_unref0 (label_box);
	return obj;
}

static void
sound_app_row_class_init (SoundAppRowClass * klass,
                          gpointer klass_data)
{
	sound_app_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundAppRow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = sound_app_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_app_row_finalize;
}

static void
sound_app_row_instance_init (SoundAppRow * self,
                             gpointer klass)
{
	self->priv = sound_app_row_get_instance_private (self);
}

static void
sound_app_row_finalize (GObject * obj)
{
	SoundAppRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_APP_ROW, SoundAppRow);
	_g_object_unref0 (self->priv->app);
	_g_object_unref0 (self->priv->app_name_label);
	_g_object_unref0 (self->priv->media_name_label);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->icon_button);
	_g_object_unref0 (self->priv->volume_scale);
	_g_object_unref0 (self->priv->mute_switch);
	G_OBJECT_CLASS (sound_app_row_parent_class)->finalize (obj);
}

static GType
sound_app_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundAppRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_app_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundAppRow), 0, (GInstanceInitFunc) sound_app_row_instance_init, NULL };
	GType sound_app_row_type_id;
	sound_app_row_type_id = g_type_register_static (gtk_grid_get_type (), "SoundAppRow", &g_define_type_info, 0);
	SoundAppRow_private_offset = g_type_add_instance_private (sound_app_row_type_id, sizeof (SoundAppRowPrivate));
	return sound_app_row_type_id;
}

GType
sound_app_row_get_type (void)
{
	static volatile gsize sound_app_row_type_id__once = 0;
	if (g_once_init_enter (&sound_app_row_type_id__once)) {
		GType sound_app_row_type_id;
		sound_app_row_type_id = sound_app_row_get_type_once ();
		g_once_init_leave (&sound_app_row_type_id__once, sound_app_row_type_id);
	}
	return sound_app_row_type_id__once;
}

