/* UserUtils.c generated by valac 0.56.17, the Vala compiler
 * generated from UserUtils.vala, do not modify */

/*
* Copyright (c) 2014-2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "useraccounts.h"
#include <act/act.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SwitchboardPlugUserAccountsParamSpecUserUtils SwitchboardPlugUserAccountsParamSpecUserUtils;

struct _SwitchboardPlugUserAccountsUserUtilsPrivate {
	ActUser* user;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* widget;
};

struct _SwitchboardPlugUserAccountsParamSpecUserUtils {
	GParamSpec parent_instance;
};

static gint SwitchboardPlugUserAccountsUserUtils_private_offset;
static gpointer switchboard_plug_user_accounts_user_utils_parent_class = NULL;

static void switchboard_plug_user_accounts_user_utils_finalize (SwitchboardPlugUserAccountsUserUtils * obj);
static GType switchboard_plug_user_accounts_user_utils_get_type_once (void);

static inline gpointer
switchboard_plug_user_accounts_user_utils_get_instance_private (SwitchboardPlugUserAccountsUserUtils* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugUserAccountsUserUtils_private_offset);
}

SwitchboardPlugUserAccountsUserUtils*
switchboard_plug_user_accounts_user_utils_construct (GType object_type,
                                                     ActUser* user,
                                                     SwitchboardPlugUserAccountsWidgetsUserSettingsView* widget)
{
	SwitchboardPlugUserAccountsUserUtils* self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	self = (SwitchboardPlugUserAccountsUserUtils*) g_type_create_instance (object_type);
	self->priv->user = user;
	self->priv->widget = widget;
	return self;
}

SwitchboardPlugUserAccountsUserUtils*
switchboard_plug_user_accounts_user_utils_new (ActUser* user,
                                               SwitchboardPlugUserAccountsWidgetsUserSettingsView* widget)
{
	return switchboard_plug_user_accounts_user_utils_construct (SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS, user, widget);
}

void
switchboard_plug_user_accounts_user_utils_change_full_name (SwitchboardPlugUserAccountsUserUtils* self,
                                                            const gchar* new_full_name)
{
	gboolean _tmp0_ = FALSE;
	ActUser* _tmp1_;
	ActUser* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_full_name != NULL);
	_tmp1_ = switchboard_plug_user_accounts_get_current_user ();
	_tmp2_ = self->priv->user;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		PolkitPermission* _tmp3_;
		PolkitPermission* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = switchboard_plug_user_accounts_get_permission ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_permission_get_allowed ((GPermission*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp4_);
	}
	if (_tmp0_) {
		ActUser* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->user;
		_tmp8_ = act_user_get_real_name (_tmp7_);
		if (g_strcmp0 (new_full_name, _tmp8_) != 0) {
			ActUser* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			ActUser* _tmp13_;
			_tmp9_ = self->priv->user;
			_tmp10_ = act_user_get_user_name (_tmp9_);
			_tmp11_ = g_strdup_printf ("Setting real name for %s to %s", _tmp10_, new_full_name);
			_tmp12_ = _tmp11_;
			g_debug ("UserUtils.vala:33: %s", _tmp12_);
			_g_free0 (_tmp12_);
			_tmp13_ = self->priv->user;
			act_user_set_real_name (_tmp13_, new_full_name);
		} else {
			SwitchboardPlugUserAccountsWidgetsUserSettingsView* _tmp14_;
			_tmp14_ = self->priv->widget;
			switchboard_plug_user_accounts_widgets_user_settings_view_update_real_name (_tmp14_);
		}
	}
}

void
switchboard_plug_user_accounts_user_utils_change_user_type (SwitchboardPlugUserAccountsUserUtils* self,
                                                            gint new_user_type)
{
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ActUser* _tmp6_;
		_tmp6_ = self->priv->user;
		if (act_user_get_account_type (_tmp6_) == ACT_USER_ACCOUNT_TYPE_STANDARD) {
			_tmp5_ = new_user_type == 1;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ActUser* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			ActUser* _tmp11_;
			_tmp7_ = self->priv->user;
			_tmp8_ = act_user_get_user_name (_tmp7_);
			_tmp9_ = g_strdup_printf ("Setting account type for %s to Administrator", _tmp8_);
			_tmp10_ = _tmp9_;
			g_debug ("UserUtils.vala:43: %s", _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = self->priv->user;
			act_user_set_account_type (_tmp11_, ACT_USER_ACCOUNT_TYPE_ADMINISTRATOR);
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			ActUser* _tmp14_;
			_tmp14_ = self->priv->user;
			if (act_user_get_account_type (_tmp14_) == ACT_USER_ACCOUNT_TYPE_ADMINISTRATOR) {
				_tmp13_ = new_user_type == 0;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				ActUser* _tmp15_;
				_tmp15_ = self->priv->user;
				_tmp12_ = !switchboard_plug_user_accounts_is_last_admin (_tmp15_);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ActUser* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				ActUser* _tmp20_;
				_tmp16_ = self->priv->user;
				_tmp17_ = act_user_get_user_name (_tmp16_);
				_tmp18_ = g_strdup_printf ("Setting account type for %s to Standard", _tmp17_);
				_tmp19_ = _tmp18_;
				g_debug ("UserUtils.vala:47: %s", _tmp19_);
				_g_free0 (_tmp19_);
				_tmp20_ = self->priv->user;
				act_user_set_account_type (_tmp20_, ACT_USER_ACCOUNT_TYPE_STANDARD);
			} else {
				SwitchboardPlugUserAccountsWidgetsUserSettingsView* _tmp21_;
				_tmp21_ = self->priv->widget;
				switchboard_plug_user_accounts_widgets_user_settings_view_update_account_type (_tmp21_);
			}
		}
	}
}

void
switchboard_plug_user_accounts_user_utils_change_language (SwitchboardPlugUserAccountsUserUtils* self,
                                                           const gchar* new_lang)
{
	gboolean _tmp0_ = FALSE;
	ActUser* _tmp1_;
	ActUser* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_lang != NULL);
	_tmp1_ = switchboard_plug_user_accounts_get_current_user ();
	_tmp2_ = self->priv->user;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		PolkitPermission* _tmp3_;
		PolkitPermission* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = switchboard_plug_user_accounts_get_permission ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_permission_get_allowed ((GPermission*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp4_);
	}
	if (_tmp0_) {
		gboolean _tmp7_ = FALSE;
		if (g_strcmp0 (new_lang, "") != 0) {
			ActUser* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = self->priv->user;
			_tmp9_ = act_user_get_language (_tmp8_);
			_tmp7_ = g_strcmp0 (new_lang, _tmp9_) != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ActUser* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			ActUser* _tmp14_;
			_tmp10_ = self->priv->user;
			_tmp11_ = act_user_get_user_name (_tmp10_);
			_tmp12_ = g_strdup_printf ("Setting language for %s to %s", _tmp11_, new_lang);
			_tmp13_ = _tmp12_;
			g_debug ("UserUtils.vala:57: %s", _tmp13_);
			_g_free0 (_tmp13_);
			_tmp14_ = self->priv->user;
			act_user_set_language (_tmp14_, new_lang);
		} else {
			SwitchboardPlugUserAccountsWidgetsUserSettingsView* _tmp15_;
			SwitchboardPlugUserAccountsWidgetsUserSettingsView* _tmp16_;
			_tmp15_ = self->priv->widget;
			switchboard_plug_user_accounts_widgets_user_settings_view_update_language (_tmp15_);
			_tmp16_ = self->priv->widget;
			switchboard_plug_user_accounts_widgets_user_settings_view_update_region (_tmp16_, NULL);
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_plug_user_accounts_user_utils_change_autologin (SwitchboardPlugUserAccountsUserUtils* self,
                                                            gboolean new_autologin)
{
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ActUser* _tmp6_;
		_tmp6_ = self->priv->user;
		if (act_user_get_automatic_login (_tmp6_)) {
			_tmp5_ = !new_autologin;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ActUser* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			ActUser* _tmp11_;
			_tmp7_ = self->priv->user;
			_tmp8_ = act_user_get_user_name (_tmp7_);
			_tmp9_ = g_strdup_printf ("Removing automatic login for %s", _tmp8_);
			_tmp10_ = _tmp9_;
			g_debug ("UserUtils.vala:69: %s", _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = self->priv->user;
			act_user_set_automatic_login (_tmp11_, FALSE);
		} else {
			gboolean _tmp12_ = FALSE;
			ActUser* _tmp13_;
			_tmp13_ = self->priv->user;
			if (!act_user_get_automatic_login (_tmp13_)) {
				_tmp12_ = new_autologin;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ActUser* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				ActUserManager* _tmp18_;
				GSList* _tmp19_;
				ActUser* _tmp26_;
				_tmp14_ = self->priv->user;
				_tmp15_ = act_user_get_user_name (_tmp14_);
				_tmp16_ = g_strdup_printf ("Setting automatic login for %s", _tmp15_);
				_tmp17_ = _tmp16_;
				g_debug ("UserUtils.vala:72: %s", _tmp17_);
				_g_free0 (_tmp17_);
				_tmp18_ = switchboard_plug_user_accounts_get_usermanager ();
				_tmp19_ = act_user_manager_list_users (_tmp18_);
				{
					GSList* temp_user_collection = NULL;
					GSList* temp_user_it = NULL;
					temp_user_collection = _tmp19_;
					for (temp_user_it = temp_user_collection; temp_user_it != NULL; temp_user_it = temp_user_it->next) {
						ActUser* _tmp20_;
						ActUser* temp_user = NULL;
						_tmp20_ = _g_object_ref0 ((ActUser*) temp_user_it->data);
						temp_user = _tmp20_;
						{
							gboolean _tmp21_ = FALSE;
							ActUser* _tmp22_;
							_tmp22_ = temp_user;
							if (act_user_get_automatic_login (_tmp22_)) {
								ActUser* _tmp23_;
								ActUser* _tmp24_;
								_tmp23_ = temp_user;
								_tmp24_ = self->priv->user;
								_tmp21_ = _tmp23_ != _tmp24_;
							} else {
								_tmp21_ = FALSE;
							}
							if (_tmp21_) {
								ActUser* _tmp25_;
								_tmp25_ = temp_user;
								act_user_set_automatic_login (_tmp25_, FALSE);
							}
							_g_object_unref0 (temp_user);
						}
					}
					(temp_user_collection == NULL) ? NULL : (temp_user_collection = (g_slist_free (temp_user_collection), NULL));
				}
				_tmp26_ = self->priv->user;
				act_user_set_automatic_login (_tmp26_, TRUE);
			}
		}
	}
}

static void
switchboard_plug_user_accounts_value_user_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
switchboard_plug_user_accounts_value_user_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		switchboard_plug_user_accounts_user_utils_unref (value->data[0].v_pointer);
	}
}

static void
switchboard_plug_user_accounts_value_user_utils_copy_value (const GValue* src_value,
                                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = switchboard_plug_user_accounts_user_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
switchboard_plug_user_accounts_value_user_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
switchboard_plug_user_accounts_value_user_utils_collect_value (GValue* value,
                                                               guint n_collect_values,
                                                               GTypeCValue* collect_values,
                                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SwitchboardPlugUserAccountsUserUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = switchboard_plug_user_accounts_user_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
switchboard_plug_user_accounts_value_user_utils_lcopy_value (const GValue* value,
                                                             guint n_collect_values,
                                                             GTypeCValue* collect_values,
                                                             guint collect_flags)
{
	SwitchboardPlugUserAccountsUserUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = switchboard_plug_user_accounts_user_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
switchboard_plug_user_accounts_param_spec_user_utils (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags)
{
	SwitchboardPlugUserAccountsParamSpecUserUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
switchboard_plug_user_accounts_value_get_user_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
switchboard_plug_user_accounts_value_set_user_utils (GValue* value,
                                                     gpointer v_object)
{
	SwitchboardPlugUserAccountsUserUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		switchboard_plug_user_accounts_user_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		switchboard_plug_user_accounts_user_utils_unref (old);
	}
}

void
switchboard_plug_user_accounts_value_take_user_utils (GValue* value,
                                                      gpointer v_object)
{
	SwitchboardPlugUserAccountsUserUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		switchboard_plug_user_accounts_user_utils_unref (old);
	}
}

static void
switchboard_plug_user_accounts_user_utils_class_init (SwitchboardPlugUserAccountsUserUtilsClass * klass,
                                                      gpointer klass_data)
{
	switchboard_plug_user_accounts_user_utils_parent_class = g_type_class_peek_parent (klass);
	((SwitchboardPlugUserAccountsUserUtilsClass *) klass)->finalize = switchboard_plug_user_accounts_user_utils_finalize;
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugUserAccountsUserUtils_private_offset);
}

static void
switchboard_plug_user_accounts_user_utils_instance_init (SwitchboardPlugUserAccountsUserUtils * self,
                                                         gpointer klass)
{
	self->priv = switchboard_plug_user_accounts_user_utils_get_instance_private (self);
	self->ref_count = 1;
}

static void
switchboard_plug_user_accounts_user_utils_finalize (SwitchboardPlugUserAccountsUserUtils * obj)
{
	SwitchboardPlugUserAccountsUserUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_TYPE_USER_UTILS, SwitchboardPlugUserAccountsUserUtils);
	g_signal_handlers_destroy (self);
}

static GType
switchboard_plug_user_accounts_user_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { switchboard_plug_user_accounts_value_user_utils_init, switchboard_plug_user_accounts_value_user_utils_free_value, switchboard_plug_user_accounts_value_user_utils_copy_value, switchboard_plug_user_accounts_value_user_utils_peek_pointer, "p", switchboard_plug_user_accounts_value_user_utils_collect_value, "p", switchboard_plug_user_accounts_value_user_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugUserAccountsUserUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_user_accounts_user_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugUserAccountsUserUtils), 0, (GInstanceInitFunc) switchboard_plug_user_accounts_user_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType switchboard_plug_user_accounts_user_utils_type_id;
	switchboard_plug_user_accounts_user_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SwitchboardPlugUserAccountsUserUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SwitchboardPlugUserAccountsUserUtils_private_offset = g_type_add_instance_private (switchboard_plug_user_accounts_user_utils_type_id, sizeof (SwitchboardPlugUserAccountsUserUtilsPrivate));
	return switchboard_plug_user_accounts_user_utils_type_id;
}

GType
switchboard_plug_user_accounts_user_utils_get_type (void)
{
	static volatile gsize switchboard_plug_user_accounts_user_utils_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_user_accounts_user_utils_type_id__once)) {
		GType switchboard_plug_user_accounts_user_utils_type_id;
		switchboard_plug_user_accounts_user_utils_type_id = switchboard_plug_user_accounts_user_utils_get_type_once ();
		g_once_init_leave (&switchboard_plug_user_accounts_user_utils_type_id__once, switchboard_plug_user_accounts_user_utils_type_id);
	}
	return switchboard_plug_user_accounts_user_utils_type_id__once;
}

gpointer
switchboard_plug_user_accounts_user_utils_ref (gpointer instance)
{
	SwitchboardPlugUserAccountsUserUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
switchboard_plug_user_accounts_user_utils_unref (gpointer instance)
{
	SwitchboardPlugUserAccountsUserUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SWITCHBOARD_PLUG_USER_ACCOUNTS_USER_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

