package providers

import (
	"fmt"
	"os"

	"github.com/aandrew-me/tgpt/v2/src/providers/deepseek"
	"github.com/aandrew-me/tgpt/v2/src/providers/gemini"
	"github.com/aandrew-me/tgpt/v2/src/providers/groq"
	"github.com/aandrew-me/tgpt/v2/src/providers/isou"
	"github.com/aandrew-me/tgpt/v2/src/providers/kimi"
	"github.com/aandrew-me/tgpt/v2/src/providers/koboldai"
	"github.com/aandrew-me/tgpt/v2/src/providers/ollama"
	"github.com/aandrew-me/tgpt/v2/src/providers/openai"
	"github.com/aandrew-me/tgpt/v2/src/providers/pollinations"
	"github.com/aandrew-me/tgpt/v2/src/providers/sky"
	"github.com/aandrew-me/tgpt/v2/src/structs"
	http "github.com/bogdanfinn/fhttp"
)

var availableProviders = []string{
	"", "deepseek", "isou", "gemini", "groq", "kimi", "koboldai", "ollama", "openai", "pollinations", "sky",
}

func GetMainText(line string, provider string, input string) string {
	switch provider {
	case "deepseek":
		return deepseek.GetMainText(line)
	case "isou":
		return isou.GetMainText((line))
	case "gemini":
		return gemini.GetMainText(line)
	case "groq":
		return groq.GetMainText(line)
	case "kimi":
		return kimi.GetMainText(line)
	case "koboldai":
		return koboldai.GetMainText(line)
	case "ollama":
		return ollama.GetMainText(line)
	case "openai":
		return openai.GetMainText(line)
	case "pollinations":
		return pollinations.GetMainText(line)
	case "sky":
		return sky.GetMainText(line)
	default:
		return pollinations.GetMainText(line)
	}
}

func NewRequest(input string, params structs.Params, extraOptions structs.ExtraOptions) (*http.Response, error) {
	validProvider := false
	for _, str := range availableProviders {
		if str == params.Provider {
			validProvider = true
			break
		}
	}
	if !validProvider {
		fmt.Fprintln(os.Stderr, "Invalid provider")
		os.Exit(1)
	}

	switch params.Provider {
	case "deepseek":
		return deepseek.NewRequest(input, params)
	case "gemini":
		return gemini.NewRequest(input, params)
	case "groq":
		return groq.NewRequest(input, params)
	case "isou":
		return isou.NewRequest(input, params)
	case "kimi":
		return kimi.NewRequest(input, params)
	case "koboldai":
		return koboldai.NewRequest(input, params)
	case "ollama":
		return ollama.NewRequest(input, params)
	case "openai":
		return openai.NewRequest(input, params)
	case "pollinations":
		return pollinations.NewRequest(input, params)
	case "sky":
		return sky.NewRequest(input, params)
	default:
		return pollinations.NewRequest(input, params)
	}

}
