// python wrapper for ttkMergeTreePrincipalGeodesicsDecoding
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTreePrincipalGeodesicsDecoding.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTreePrincipalGeodesicsDecoding(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTreePrincipalGeodesicsDecoding_ClassNew(); }


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetNumberOfGeodesicsIntervals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfGeodesicsIntervals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfGeodesicsIntervals(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetNumberOfGeodesicsIntervals(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetNumberOfGeodesicsIntervals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGeodesicsIntervals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfGeodesicsIntervals() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetNumberOfGeodesicsIntervals());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputInputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputInputTrees(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetOutputInputTrees(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputInputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputInputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputInputTrees() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetOutputInputTrees());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTreesSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputInputTreesSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputInputTreesSegmentation(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetOutputInputTreesSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputInputTreesSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputInputTreesSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputInputTreesSegmentation() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetOutputInputTreesSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputBarycenter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputBarycenter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputBarycenter(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetOutputBarycenter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputBarycenter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputBarycenter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputBarycenter() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetOutputBarycenter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetReconstructInputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReconstructInputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReconstructInputTrees(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetReconstructInputTrees(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetReconstructInputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReconstructInputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReconstructInputTrees() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetReconstructInputTrees());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetcomputeReconstructionError_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetcomputeReconstructionError_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetcomputeReconstructionError_(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetcomputeReconstructionError_(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetcomputeReconstructionError_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetcomputeReconstructionError_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetcomputeReconstructionError_() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetcomputeReconstructionError_());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SettransferInputTreesInformation_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SettransferInputTreesInformation_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SettransferInputTreesInformation_(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SettransferInputTreesInformation_(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GettransferInputTreesInformation_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GettransferInputTreesInformation_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GettransferInputTreesInformation_() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GettransferInputTreesInformation_());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SettransferBarycenterInformation_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SettransferBarycenterInformation_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SettransferBarycenterInformation_(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SettransferBarycenterInformation_(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GettransferBarycenterInformation_(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GettransferBarycenterInformation_");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GettransferBarycenterInformation_() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GettransferBarycenterInformation_());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructGeodesicsTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConstructGeodesicsTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConstructGeodesicsTrees(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetConstructGeodesicsTrees(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructGeodesicsTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConstructGeodesicsTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConstructGeodesicsTrees() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetConstructGeodesicsTrees());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructEllipses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConstructEllipses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConstructEllipses(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetConstructEllipses(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructEllipses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConstructEllipses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConstructEllipses() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetConstructEllipses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructRectangle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConstructRectangle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConstructRectangle(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetConstructRectangle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructRectangle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConstructRectangle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConstructRectangle() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetConstructRectangle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetRectangleMultiplier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRectangleMultiplier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRectangleMultiplier(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetRectangleMultiplier(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetRectangleMultiplier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRectangleMultiplier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetRectangleMultiplier() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetRectangleMultiplier());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructSurface(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConstructSurface");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConstructSurface(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetConstructSurface(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructSurface(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConstructSurface");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConstructSurface() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetConstructSurface());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SetProcessSecondInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProcessSecondInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProcessSecondInput(temp0);
    }
    else
    {
      op->ttkMergeTreePrincipalGeodesicsDecoding::SetProcessSecondInput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetProcessSecondInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProcessSecondInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetProcessSecondInput() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetProcessSecondInput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTreePrincipalGeodesicsDecoding::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTreePrincipalGeodesicsDecoding::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTreePrincipalGeodesicsDecoding *tempr = ttkMergeTreePrincipalGeodesicsDecoding::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTreePrincipalGeodesicsDecoding *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTreePrincipalGeodesicsDecoding::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTreePrincipalGeodesicsDecoding::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreePrincipalGeodesicsDecoding_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreePrincipalGeodesicsDecoding *op = static_cast<ttkMergeTreePrincipalGeodesicsDecoding *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTreePrincipalGeodesicsDecoding::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreePrincipalGeodesicsDecoding_Methods[] = {
  {"SetNumberOfGeodesicsIntervals", PyttkMergeTreePrincipalGeodesicsDecoding_SetNumberOfGeodesicsIntervals, METH_VARARGS,
   "SetNumberOfGeodesicsIntervals(self, k:int) -> None\nC++: void SetNumberOfGeodesicsIntervals(int k)\n\nAutomatically generate getters and setters of filter parameters\nvia vtkMacros.\n"},
  {"GetNumberOfGeodesicsIntervals", PyttkMergeTreePrincipalGeodesicsDecoding_GetNumberOfGeodesicsIntervals, METH_VARARGS,
   "GetNumberOfGeodesicsIntervals(self) -> int\nC++: int GetNumberOfGeodesicsIntervals()\n\n"},
  {"SetOutputInputTrees", PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTrees, METH_VARARGS,
   "SetOutputInputTrees(self, _arg:bool) -> None\nC++: virtual void SetOutputInputTrees(bool _arg)\n\n"},
  {"GetOutputInputTrees", PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputInputTrees, METH_VARARGS,
   "GetOutputInputTrees(self) -> bool\nC++: virtual bool GetOutputInputTrees()\n\n"},
  {"SetOutputInputTreesSegmentation", PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTreesSegmentation, METH_VARARGS,
   "SetOutputInputTreesSegmentation(self, _arg:bool) -> None\nC++: virtual void SetOutputInputTreesSegmentation(bool _arg)\n\n"},
  {"GetOutputInputTreesSegmentation", PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputInputTreesSegmentation, METH_VARARGS,
   "GetOutputInputTreesSegmentation(self) -> bool\nC++: virtual bool GetOutputInputTreesSegmentation()\n\n"},
  {"SetOutputBarycenter", PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputBarycenter, METH_VARARGS,
   "SetOutputBarycenter(self, _arg:bool) -> None\nC++: virtual void SetOutputBarycenter(bool _arg)\n\n"},
  {"GetOutputBarycenter", PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputBarycenter, METH_VARARGS,
   "GetOutputBarycenter(self) -> bool\nC++: virtual bool GetOutputBarycenter()\n\n"},
  {"SetReconstructInputTrees", PyttkMergeTreePrincipalGeodesicsDecoding_SetReconstructInputTrees, METH_VARARGS,
   "SetReconstructInputTrees(self, _arg:bool) -> None\nC++: virtual void SetReconstructInputTrees(bool _arg)\n\n"},
  {"GetReconstructInputTrees", PyttkMergeTreePrincipalGeodesicsDecoding_GetReconstructInputTrees, METH_VARARGS,
   "GetReconstructInputTrees(self) -> bool\nC++: virtual bool GetReconstructInputTrees()\n\n"},
  {"SetcomputeReconstructionError_", PyttkMergeTreePrincipalGeodesicsDecoding_SetcomputeReconstructionError_, METH_VARARGS,
   "SetcomputeReconstructionError_(self, b:bool) -> None\nC++: void SetcomputeReconstructionError_(bool b)\n\n"},
  {"GetcomputeReconstructionError_", PyttkMergeTreePrincipalGeodesicsDecoding_GetcomputeReconstructionError_, METH_VARARGS,
   "GetcomputeReconstructionError_(self) -> bool\nC++: virtual bool GetcomputeReconstructionError_()\n\n"},
  {"SettransferInputTreesInformation_", PyttkMergeTreePrincipalGeodesicsDecoding_SettransferInputTreesInformation_, METH_VARARGS,
   "SettransferInputTreesInformation_(self, b:bool) -> None\nC++: void SettransferInputTreesInformation_(bool b)\n\n"},
  {"GettransferInputTreesInformation_", PyttkMergeTreePrincipalGeodesicsDecoding_GettransferInputTreesInformation_, METH_VARARGS,
   "GettransferInputTreesInformation_(self) -> bool\nC++: virtual bool GettransferInputTreesInformation_()\n\n"},
  {"SettransferBarycenterInformation_", PyttkMergeTreePrincipalGeodesicsDecoding_SettransferBarycenterInformation_, METH_VARARGS,
   "SettransferBarycenterInformation_(self, b:bool) -> None\nC++: void SettransferBarycenterInformation_(bool b)\n\n"},
  {"GettransferBarycenterInformation_", PyttkMergeTreePrincipalGeodesicsDecoding_GettransferBarycenterInformation_, METH_VARARGS,
   "GettransferBarycenterInformation_(self) -> bool\nC++: virtual bool GettransferBarycenterInformation_()\n\n"},
  {"SetConstructGeodesicsTrees", PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructGeodesicsTrees, METH_VARARGS,
   "SetConstructGeodesicsTrees(self, _arg:bool) -> None\nC++: virtual void SetConstructGeodesicsTrees(bool _arg)\n\n"},
  {"GetConstructGeodesicsTrees", PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructGeodesicsTrees, METH_VARARGS,
   "GetConstructGeodesicsTrees(self) -> bool\nC++: virtual bool GetConstructGeodesicsTrees()\n\n"},
  {"SetConstructEllipses", PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructEllipses, METH_VARARGS,
   "SetConstructEllipses(self, _arg:bool) -> None\nC++: virtual void SetConstructEllipses(bool _arg)\n\n"},
  {"GetConstructEllipses", PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructEllipses, METH_VARARGS,
   "GetConstructEllipses(self) -> bool\nC++: virtual bool GetConstructEllipses()\n\n"},
  {"SetConstructRectangle", PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructRectangle, METH_VARARGS,
   "SetConstructRectangle(self, _arg:bool) -> None\nC++: virtual void SetConstructRectangle(bool _arg)\n\n"},
  {"GetConstructRectangle", PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructRectangle, METH_VARARGS,
   "GetConstructRectangle(self) -> bool\nC++: virtual bool GetConstructRectangle()\n\n"},
  {"SetRectangleMultiplier", PyttkMergeTreePrincipalGeodesicsDecoding_SetRectangleMultiplier, METH_VARARGS,
   "SetRectangleMultiplier(self, mult:int) -> None\nC++: void SetRectangleMultiplier(unsigned int mult)\n\n"},
  {"GetRectangleMultiplier", PyttkMergeTreePrincipalGeodesicsDecoding_GetRectangleMultiplier, METH_VARARGS,
   "GetRectangleMultiplier(self) -> int\nC++: virtual unsigned int GetRectangleMultiplier()\n\n"},
  {"SetConstructSurface", PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructSurface, METH_VARARGS,
   "SetConstructSurface(self, _arg:bool) -> None\nC++: virtual void SetConstructSurface(bool _arg)\n\n"},
  {"GetConstructSurface", PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructSurface, METH_VARARGS,
   "GetConstructSurface(self) -> bool\nC++: virtual bool GetConstructSurface()\n\n"},
  {"SetProcessSecondInput", PyttkMergeTreePrincipalGeodesicsDecoding_SetProcessSecondInput, METH_VARARGS,
   "SetProcessSecondInput(self, b:bool) -> None\nC++: void SetProcessSecondInput(bool b)\n\n"},
  {"GetProcessSecondInput", PyttkMergeTreePrincipalGeodesicsDecoding_GetProcessSecondInput, METH_VARARGS,
   "GetProcessSecondInput(self) -> bool\nC++: virtual bool GetProcessSecondInput()\n\n"},
  {"IsTypeOf", PyttkMergeTreePrincipalGeodesicsDecoding_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTreePrincipalGeodesicsDecoding_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTreePrincipalGeodesicsDecoding_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> ttkMergeTreePrincipalGeodesicsDecoding\nC++: static ttkMergeTreePrincipalGeodesicsDecoding *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTreePrincipalGeodesicsDecoding_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTreePrincipalGeodesicsDecoding\nC++: ttkMergeTreePrincipalGeodesicsDecoding *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTreePrincipalGeodesicsDecoding_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTreePrincipalGeodesicsDecoding_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTreePrincipalGeodesicsDecoding_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("output_input_trees"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputInputTrees(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTrees(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTrees(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputInputTrees/SetOutputInputTrees\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_input_trees_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputInputTreesSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTreesSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputInputTreesSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputInputTreesSegmentation/SetOutputInputTreesSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_barycenter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetOutputBarycenter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputBarycenter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetOutputBarycenter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputBarycenter/SetOutputBarycenter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reconstruct_input_trees"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetReconstructInputTrees(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetReconstructInputTrees(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetReconstructInputTrees(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReconstructInputTrees/SetReconstructInputTrees\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("construct_geodesics_trees"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructGeodesicsTrees(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructGeodesicsTrees(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructGeodesicsTrees(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConstructGeodesicsTrees/SetConstructGeodesicsTrees\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("construct_ellipses"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructEllipses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructEllipses(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructEllipses(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConstructEllipses/SetConstructEllipses\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("construct_rectangle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructRectangle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructRectangle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructRectangle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConstructRectangle/SetConstructRectangle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rectangle_multiplier"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetRectangleMultiplier(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetRectangleMultiplier(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetRectangleMultiplier(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRectangleMultiplier/SetRectangleMultiplier\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("construct_surface"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetConstructSurface(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructSurface(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetConstructSurface(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConstructSurface/SetConstructSurface\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("process_second_input"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetProcessSecondInput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetProcessSecondInput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetProcessSecondInput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProcessSecondInput/SetProcessSecondInput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_geodesics_intervals"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreePrincipalGeodesicsDecoding_GetNumberOfGeodesicsIntervals(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetNumberOfGeodesicsIntervals(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreePrincipalGeodesicsDecoding_SetNumberOfGeodesicsIntervals(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfGeodesicsIntervals/SetNumberOfGeodesicsIntervals\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTreePrincipalGeodesicsDecoding_Doc =
  "ttkMergeTreePrincipalGeodesicsDecoding - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Mathieu Pont <mathieu.pont@lip6.fr>\\date 2022.\n\n"
  "TTK VTK-filter that wraps the\n"
  "ttk::MergeTreePrincipalGeodesicsDecoding module.\n\n"
  "This VTK filter uses the ttk::MergeTreePrincipalGeodesicsDecoding\n"
  "module to compute the reconstruction of merge trees or persistence\n"
  "diagrams given a Principal Geodesic Analysis basis and projection\n"
  "coefficients.\n\n"
  "\\param Input vtkMultiBlockDataSet Barycenter\n"
  "\\param Input vtkTable Coefficients\n"
  "\\param Input vtkTable Geodesics\n"
  "\\param Input vtkTable Branches Correlation\n"
  "\\param Output vtkMultiBlockDataSet Trees\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(),\n"
  "GetOutputDataObject()).\n\n"
  "See the corresponding standalone program for a usage example:\n"
  "- standalone/MergeTreePrincipalGeodesicsDecoding/main.cpp\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::MergeTreePrincipalGeodesicsDecoding\n"
  "\\sa ttkAlgorithm\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramPGA/\"\n"
  "  >Persistence Diagram Principal Geodesic Analysis example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTreePrincipalGeodesicsDecoding_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTreePrincipalGeodesicsDecoding.ttkMergeTreePrincipalGeodesicsDecoding", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTreePrincipalGeodesicsDecoding_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTreePrincipalGeodesicsDecoding_StaticNew()
{
  return ttkMergeTreePrincipalGeodesicsDecoding::New();
}

PyObject *PyttkMergeTreePrincipalGeodesicsDecoding_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTreePrincipalGeodesicsDecoding_Type, PyttkMergeTreePrincipalGeodesicsDecoding_Methods,
    "ttkMergeTreePrincipalGeodesicsDecoding",
 &PyttkMergeTreePrincipalGeodesicsDecoding_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTreePrincipalGeodesicsDecoding_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTreePrincipalGeodesicsDecoding(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTreePrincipalGeodesicsDecoding_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTreePrincipalGeodesicsDecoding", o) != 0)
  {
    Py_DECREF(o);
  }

}

