/** @file
 * VirtualBox API class wrapper code for IHostDrivePartition.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOSTDRIVEPARTITION

#include "HostDrivePartitionWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostDrivePartitionWrap)

//
// IHostDrivePartition properties
//

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(Number)(ULONG *aNumber)
{
    LogRelFlow(("{%p} %s: enter aNumber=%p\n", this, "HostDrivePartition::getNumber", aNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNumber);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NUMBER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNumber(aNumber);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NUMBER_RETURN(this, hrc, 0 /*normal*/,*aNumber);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NUMBER_RETURN(this, hrc, 1 /*hrc exception*/,*aNumber);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,*aNumber);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNumber=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getNumber", *aNumber, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(Size)(LONG64 *aSize)
{
    LogRelFlow(("{%p} %s: enter aSize=%p\n", this, "HostDrivePartition::getSize", aSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_SIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSize(aSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_SIZE_RETURN(this, hrc, 0 /*normal*/,*aSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_SIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_SIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSize=%RI64 hrc=%Rhrc\n", this, "HostDrivePartition::getSize", *aSize, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(Start)(LONG64 *aStart)
{
    LogRelFlow(("{%p} %s: enter aStart=%p\n", this, "HostDrivePartition::getStart", aStart));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStart);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_START_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStart(aStart);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_START_RETURN(this, hrc, 0 /*normal*/,*aStart);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_START_RETURN(this, hrc, 1 /*hrc exception*/,*aStart);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_START_RETURN(this, hrc, 9 /*unhandled exception*/,*aStart);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStart=%RI64 hrc=%Rhrc\n", this, "HostDrivePartition::getStart", *aStart, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(Type)(PartitionType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "HostDrivePartition::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(Active)(BOOL *aActive)
{
    LogRelFlow(("{%p} %s: enter aActive=%p\n", this, "HostDrivePartition::getActive", aActive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aActive);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ACTIVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getActive(aActive);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ACTIVE_RETURN(this, hrc, 0 /*normal*/,*aActive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ACTIVE_RETURN(this, hrc, 1 /*hrc exception*/,*aActive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ACTIVE_RETURN(this, hrc, 9 /*unhandled exception*/,*aActive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aActive=%RTbool hrc=%Rhrc\n", this, "HostDrivePartition::getActive", *aActive, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(TypeMBR)(ULONG *aTypeMBR)
{
    LogRelFlow(("{%p} %s: enter aTypeMBR=%p\n", this, "HostDrivePartition::getTypeMBR", aTypeMBR));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTypeMBR);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEMBR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTypeMBR(aTypeMBR);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEMBR_RETURN(this, hrc, 0 /*normal*/,*aTypeMBR);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEMBR_RETURN(this, hrc, 1 /*hrc exception*/,*aTypeMBR);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEMBR_RETURN(this, hrc, 9 /*unhandled exception*/,*aTypeMBR);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTypeMBR=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getTypeMBR", *aTypeMBR, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(StartCylinder)(ULONG *aStartCylinder)
{
    LogRelFlow(("{%p} %s: enter aStartCylinder=%p\n", this, "HostDrivePartition::getStartCylinder", aStartCylinder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStartCylinder);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTCYLINDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStartCylinder(aStartCylinder);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTCYLINDER_RETURN(this, hrc, 0 /*normal*/,*aStartCylinder);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTCYLINDER_RETURN(this, hrc, 1 /*hrc exception*/,*aStartCylinder);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTCYLINDER_RETURN(this, hrc, 9 /*unhandled exception*/,*aStartCylinder);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStartCylinder=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getStartCylinder", *aStartCylinder, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(StartHead)(ULONG *aStartHead)
{
    LogRelFlow(("{%p} %s: enter aStartHead=%p\n", this, "HostDrivePartition::getStartHead", aStartHead));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStartHead);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTHEAD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStartHead(aStartHead);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTHEAD_RETURN(this, hrc, 0 /*normal*/,*aStartHead);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTHEAD_RETURN(this, hrc, 1 /*hrc exception*/,*aStartHead);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTHEAD_RETURN(this, hrc, 9 /*unhandled exception*/,*aStartHead);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStartHead=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getStartHead", *aStartHead, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(StartSector)(ULONG *aStartSector)
{
    LogRelFlow(("{%p} %s: enter aStartSector=%p\n", this, "HostDrivePartition::getStartSector", aStartSector));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStartSector);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTSECTOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStartSector(aStartSector);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTSECTOR_RETURN(this, hrc, 0 /*normal*/,*aStartSector);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTSECTOR_RETURN(this, hrc, 1 /*hrc exception*/,*aStartSector);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_STARTSECTOR_RETURN(this, hrc, 9 /*unhandled exception*/,*aStartSector);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStartSector=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getStartSector", *aStartSector, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(EndCylinder)(ULONG *aEndCylinder)
{
    LogRelFlow(("{%p} %s: enter aEndCylinder=%p\n", this, "HostDrivePartition::getEndCylinder", aEndCylinder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEndCylinder);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDCYLINDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEndCylinder(aEndCylinder);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDCYLINDER_RETURN(this, hrc, 0 /*normal*/,*aEndCylinder);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDCYLINDER_RETURN(this, hrc, 1 /*hrc exception*/,*aEndCylinder);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDCYLINDER_RETURN(this, hrc, 9 /*unhandled exception*/,*aEndCylinder);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEndCylinder=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getEndCylinder", *aEndCylinder, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(EndHead)(ULONG *aEndHead)
{
    LogRelFlow(("{%p} %s: enter aEndHead=%p\n", this, "HostDrivePartition::getEndHead", aEndHead));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEndHead);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDHEAD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEndHead(aEndHead);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDHEAD_RETURN(this, hrc, 0 /*normal*/,*aEndHead);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDHEAD_RETURN(this, hrc, 1 /*hrc exception*/,*aEndHead);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDHEAD_RETURN(this, hrc, 9 /*unhandled exception*/,*aEndHead);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEndHead=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getEndHead", *aEndHead, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(EndSector)(ULONG *aEndSector)
{
    LogRelFlow(("{%p} %s: enter aEndSector=%p\n", this, "HostDrivePartition::getEndSector", aEndSector));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEndSector);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDSECTOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEndSector(aEndSector);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDSECTOR_RETURN(this, hrc, 0 /*normal*/,*aEndSector);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDSECTOR_RETURN(this, hrc, 1 /*hrc exception*/,*aEndSector);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_ENDSECTOR_RETURN(this, hrc, 9 /*unhandled exception*/,*aEndSector);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEndSector=%RU32 hrc=%Rhrc\n", this, "HostDrivePartition::getEndSector", *aEndSector, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(TypeUuid)(BSTR *aTypeUuid)
{
    LogRelFlow(("{%p} %s: enter aTypeUuid=%p\n", this, "HostDrivePartition::getTypeUuid", aTypeUuid));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTypeUuid);
        UuidOutConverter TmpTypeUuid(aTypeUuid);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEUUID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTypeUuid(TmpTypeUuid.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEUUID_RETURN(this, hrc, 0 /*normal*/,TmpTypeUuid.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEUUID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_TYPEUUID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTypeUuid=%ls hrc=%Rhrc\n", this, "HostDrivePartition::getTypeUuid", *aTypeUuid, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(Uuid)(BSTR *aUuid)
{
    LogRelFlow(("{%p} %s: enter aUuid=%p\n", this, "HostDrivePartition::getUuid", aUuid));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUuid);
        UuidOutConverter TmpUuid(aUuid);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_UUID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUuid(TmpUuid.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_UUID_RETURN(this, hrc, 0 /*normal*/,TmpUuid.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_UUID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_UUID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUuid=%ls hrc=%Rhrc\n", this, "HostDrivePartition::getUuid", *aUuid, hrc));
    return hrc;
}

STDMETHODIMP HostDrivePartitionWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "HostDrivePartition::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTDRIVEPARTITION_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "HostDrivePartition::getName", *aName, hrc));
    return hrc;
}


//
// IHostDrivePartition methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostDrivePartitionWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(HostDrivePartitionWrap, IHostDrivePartition)
#endif // VBOX_WITH_XPCOM
