/** @file
 * VirtualBox API class wrapper code for IPerformanceCollector.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PERFORMANCECOLLECTOR

#include "PerformanceCollectorWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PerformanceCollectorWrap)

//
// IPerformanceCollector properties
//

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(MetricNames)(ComSafeArrayOut(BSTR, aMetricNames))
{
    LogRelFlow(("{%p} %s: enter aMetricNames=%p\n", this, "PerformanceCollector::getMetricNames", aMetricNames));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMetricNames);
        ArrayBSTROutConverter TmpMetricNames(ComSafeArrayOutArg(aMetricNames));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GET_METRICNAMES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMetricNames(TmpMetricNames.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GET_METRICNAMES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMetricNames.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GET_METRICNAMES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GET_METRICNAMES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMetricNames=%zu hrc=%Rhrc\n", this, "PerformanceCollector::getMetricNames", ComSafeArraySize(*aMetricNames), hrc));
    return hrc;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute1IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute2IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute3IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute4IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute5IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute6IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute7IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::COMGETTER(InternalAndReservedAttribute8IPerformanceCollector)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IPerformanceCollector methods
//

STDMETHODIMP PerformanceCollectorWrap::GetMetrics(ComSafeArrayIn(IN_BSTR, aMetricNames),
                                                  ComSafeArrayIn(IUnknown *, aObjects),
                                                  ComSafeArrayOut(IPerformanceMetric *, aMetrics))
{
    LogRelFlow(("{%p} %s: enter aMetricNames=%zu aObjects=%zu aMetrics=%p\n", this, "PerformanceCollector::getMetrics", aMetricNames, aObjects, aMetrics));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMetrics);


        ArrayBSTRInConverter TmpMetricNames(ComSafeArrayInArg(aMetricNames));
        ArrayComTypeInConverter<IUnknown> TmpObjects(ComSafeArrayInArg(aObjects));
        ArrayComTypeOutConverter<IPerformanceMetric> TmpMetrics(ComSafeArrayOutArg(aMetrics));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GETMETRICS_ENTER(this, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMetrics(TmpMetricNames.array(),
                             TmpObjects.array(),
                             TmpMetrics.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GETMETRICS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/, (uint32_t)TmpMetrics.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GETMETRICS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_GETMETRICS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMetrics=%zu hrc=%Rhrc\n", this, "PerformanceCollector::getMetrics", ComSafeArraySize(*aMetrics), hrc));
    return hrc;
}

STDMETHODIMP PerformanceCollectorWrap::SetupMetrics(ComSafeArrayIn(IN_BSTR, aMetricNames),
                                                    ComSafeArrayIn(IUnknown *, aObjects),
                                                    ULONG aPeriod,
                                                    ULONG aCount,
                                                    ComSafeArrayOut(IPerformanceMetric *, aAffectedMetrics))
{
    LogRelFlow(("{%p} %s: enter aMetricNames=%zu aObjects=%zu aPeriod=%RU32 aCount=%RU32 aAffectedMetrics=%p\n", this, "PerformanceCollector::setupMetrics", aMetricNames, aObjects, aPeriod, aCount, aAffectedMetrics));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAffectedMetrics);


        ArrayBSTRInConverter TmpMetricNames(ComSafeArrayInArg(aMetricNames));
        ArrayComTypeInConverter<IUnknown> TmpObjects(ComSafeArrayInArg(aObjects));
        
        
        ArrayComTypeOutConverter<IPerformanceMetric> TmpAffectedMetrics(ComSafeArrayOutArg(aAffectedMetrics));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_SETUPMETRICS_ENTER(this, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/, aPeriod, aCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setupMetrics(TmpMetricNames.array(),
                               TmpObjects.array(),
                               aPeriod,
                               aCount,
                               TmpAffectedMetrics.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_SETUPMETRICS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/, aPeriod, aCount, (uint32_t)TmpAffectedMetrics.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_SETUPMETRICS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, aPeriod, aCount, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_SETUPMETRICS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, aPeriod, aCount, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAffectedMetrics=%zu hrc=%Rhrc\n", this, "PerformanceCollector::setupMetrics", ComSafeArraySize(*aAffectedMetrics), hrc));
    return hrc;
}

STDMETHODIMP PerformanceCollectorWrap::EnableMetrics(ComSafeArrayIn(IN_BSTR, aMetricNames),
                                                     ComSafeArrayIn(IUnknown *, aObjects),
                                                     ComSafeArrayOut(IPerformanceMetric *, aAffectedMetrics))
{
    LogRelFlow(("{%p} %s: enter aMetricNames=%zu aObjects=%zu aAffectedMetrics=%p\n", this, "PerformanceCollector::enableMetrics", aMetricNames, aObjects, aAffectedMetrics));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAffectedMetrics);


        ArrayBSTRInConverter TmpMetricNames(ComSafeArrayInArg(aMetricNames));
        ArrayComTypeInConverter<IUnknown> TmpObjects(ComSafeArrayInArg(aObjects));
        ArrayComTypeOutConverter<IPerformanceMetric> TmpAffectedMetrics(ComSafeArrayOutArg(aAffectedMetrics));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_ENABLEMETRICS_ENTER(this, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enableMetrics(TmpMetricNames.array(),
                                TmpObjects.array(),
                                TmpAffectedMetrics.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_ENABLEMETRICS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/, (uint32_t)TmpAffectedMetrics.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_ENABLEMETRICS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_ENABLEMETRICS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAffectedMetrics=%zu hrc=%Rhrc\n", this, "PerformanceCollector::enableMetrics", ComSafeArraySize(*aAffectedMetrics), hrc));
    return hrc;
}

STDMETHODIMP PerformanceCollectorWrap::DisableMetrics(ComSafeArrayIn(IN_BSTR, aMetricNames),
                                                      ComSafeArrayIn(IUnknown *, aObjects),
                                                      ComSafeArrayOut(IPerformanceMetric *, aAffectedMetrics))
{
    LogRelFlow(("{%p} %s: enter aMetricNames=%zu aObjects=%zu aAffectedMetrics=%p\n", this, "PerformanceCollector::disableMetrics", aMetricNames, aObjects, aAffectedMetrics));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAffectedMetrics);


        ArrayBSTRInConverter TmpMetricNames(ComSafeArrayInArg(aMetricNames));
        ArrayComTypeInConverter<IUnknown> TmpObjects(ComSafeArrayInArg(aObjects));
        ArrayComTypeOutConverter<IPerformanceMetric> TmpAffectedMetrics(ComSafeArrayOutArg(aAffectedMetrics));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_DISABLEMETRICS_ENTER(this, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = disableMetrics(TmpMetricNames.array(),
                                 TmpObjects.array(),
                                 TmpAffectedMetrics.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_DISABLEMETRICS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/, (uint32_t)TmpAffectedMetrics.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_DISABLEMETRICS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_DISABLEMETRICS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAffectedMetrics=%zu hrc=%Rhrc\n", this, "PerformanceCollector::disableMetrics", ComSafeArraySize(*aAffectedMetrics), hrc));
    return hrc;
}

STDMETHODIMP PerformanceCollectorWrap::QueryMetricsData(ComSafeArrayIn(IN_BSTR, aMetricNames),
                                                        ComSafeArrayIn(IUnknown *, aObjects),
                                                        ComSafeArrayOut(BSTR, aReturnMetricNames),
                                                        ComSafeArrayOut(IUnknown *, aReturnObjects),
                                                        ComSafeArrayOut(BSTR, aReturnUnits),
                                                        ComSafeArrayOut(ULONG, aReturnScales),
                                                        ComSafeArrayOut(ULONG, aReturnSequenceNumbers),
                                                        ComSafeArrayOut(ULONG, aReturnDataIndices),
                                                        ComSafeArrayOut(ULONG, aReturnDataLengths),
                                                        ComSafeArrayOut(LONG, aReturnData))
{
    LogRelFlow(("{%p} %s: enter aMetricNames=%zu aObjects=%zu aReturnMetricNames=%p aReturnObjects=%p aReturnUnits=%p aReturnScales=%p aReturnSequenceNumbers=%p aReturnDataIndices=%p aReturnDataLengths=%p aReturnData=%p\n", this, "PerformanceCollector::queryMetricsData", aMetricNames, aObjects, aReturnMetricNames, aReturnObjects, aReturnUnits, aReturnScales, aReturnSequenceNumbers, aReturnDataIndices, aReturnDataLengths, aReturnData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnMetricNames);
        CheckComArgOutPointerValidThrow(aReturnObjects);
        CheckComArgOutPointerValidThrow(aReturnUnits);
        CheckComArgOutPointerValidThrow(aReturnScales);
        CheckComArgOutPointerValidThrow(aReturnSequenceNumbers);
        CheckComArgOutPointerValidThrow(aReturnDataIndices);
        CheckComArgOutPointerValidThrow(aReturnDataLengths);
        CheckComArgOutPointerValidThrow(aReturnData);


        ArrayBSTRInConverter TmpMetricNames(ComSafeArrayInArg(aMetricNames));
        ArrayComTypeInConverter<IUnknown> TmpObjects(ComSafeArrayInArg(aObjects));
        ArrayBSTROutConverter TmpReturnMetricNames(ComSafeArrayOutArg(aReturnMetricNames));
        ArrayComTypeOutConverter<IUnknown> TmpReturnObjects(ComSafeArrayOutArg(aReturnObjects));
        ArrayBSTROutConverter TmpReturnUnits(ComSafeArrayOutArg(aReturnUnits));
        ArrayOutConverter<ULONG> TmpReturnScales(ComSafeArrayOutArg(aReturnScales));
        ArrayOutConverter<ULONG> TmpReturnSequenceNumbers(ComSafeArrayOutArg(aReturnSequenceNumbers));
        ArrayOutConverter<ULONG> TmpReturnDataIndices(ComSafeArrayOutArg(aReturnDataIndices));
        ArrayOutConverter<ULONG> TmpReturnDataLengths(ComSafeArrayOutArg(aReturnDataLengths));
        ArrayOutConverter<LONG> TmpReturnData(ComSafeArrayOutArg(aReturnData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_QUERYMETRICSDATA_ENTER(this, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryMetricsData(TmpMetricNames.array(),
                                   TmpObjects.array(),
                                   TmpReturnMetricNames.array(),
                                   TmpReturnObjects.array(),
                                   TmpReturnUnits.array(),
                                   TmpReturnScales.array(),
                                   TmpReturnSequenceNumbers.array(),
                                   TmpReturnDataIndices.array(),
                                   TmpReturnDataLengths.array(),
                                   TmpReturnData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_QUERYMETRICSDATA_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpObjects.array().size(), NULL /*for now*/, (uint32_t)TmpReturnMetricNames.array().size(), NULL /*for now*/, (uint32_t)TmpReturnObjects.array().size(), NULL /*for now*/, (uint32_t)TmpReturnUnits.array().size(), NULL /*for now*/, (uint32_t)TmpReturnScales.array().size(), NULL /*for now*/, (uint32_t)TmpReturnSequenceNumbers.array().size(), NULL /*for now*/, (uint32_t)TmpReturnDataIndices.array().size(), NULL /*for now*/, (uint32_t)TmpReturnDataLengths.array().size(), NULL /*for now*/, (uint32_t)TmpReturnData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_QUERYMETRICSDATA_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PERFORMANCECOLLECTOR_QUERYMETRICSDATA_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReturnMetricNames=%zu *aReturnObjects=%zu *aReturnUnits=%zu *aReturnScales=%zu *aReturnSequenceNumbers=%zu *aReturnDataIndices=%zu *aReturnDataLengths=%zu aReturnData=%zu hrc=%Rhrc\n", this, "PerformanceCollector::queryMetricsData", ComSafeArraySize(*aReturnMetricNames), ComSafeArraySize(*aReturnObjects), ComSafeArraySize(*aReturnUnits), ComSafeArraySize(*aReturnScales), ComSafeArraySize(*aReturnSequenceNumbers), ComSafeArraySize(*aReturnDataIndices), ComSafeArraySize(*aReturnDataLengths), ComSafeArraySize(*aReturnData), hrc));
    return hrc;
}

STDMETHODIMP PerformanceCollectorWrap::InternalAndReservedMethod1IPerformanceCollector()
{
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::InternalAndReservedMethod2IPerformanceCollector()
{
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::InternalAndReservedMethod3IPerformanceCollector()
{
    return E_NOTIMPL;
}

STDMETHODIMP PerformanceCollectorWrap::InternalAndReservedMethod4IPerformanceCollector()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PerformanceCollectorWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PerformanceCollectorWrap, IPerformanceCollector)
#endif // VBOX_WITH_XPCOM
