/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitSerializedNode.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebKitSerializedNodeConstructor);

class JSWebKitSerializedNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebKitSerializedNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitSerializedNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitSerializedNodePrototype>(vm)) JSWebKitSerializedNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitSerializedNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitSerializedNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebKitSerializedNodePrototype, JSWebKitSerializedNodePrototype::Base);

using JSWebKitSerializedNodeDOMConstructor = JSDOMConstructorNotConstructable<JSWebKitSerializedNode>;

template<> const ClassInfo JSWebKitSerializedNodeDOMConstructor::s_info = { "WebKitSerializedNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitSerializedNodeDOMConstructor) };

template<> JSValue JSWebKitSerializedNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebKitSerializedNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebKitSerializedNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebKitSerializedNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSWebKitSerializedNodePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebKitSerializedNodeConstructor, 0 } },
};

const ClassInfo JSWebKitSerializedNodePrototype::s_info = { "WebKitSerializedNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitSerializedNodePrototype) };

void JSWebKitSerializedNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitSerializedNode::info(), JSWebKitSerializedNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebKitSerializedNode::s_info = { "WebKitSerializedNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebKitSerializedNode) };

JSWebKitSerializedNode::JSWebKitSerializedNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitSerializedNode>&& impl)
    : JSDOMWrapper<WebKitSerializedNode>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebKitSerializedNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebKitSerializedNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebKitSerializedNodePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebKitSerializedNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebKitSerializedNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebKitSerializedNode>(vm, globalObject);
}

JSValue JSWebKitSerializedNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitSerializedNodeDOMConstructor, DOMConstructorID::WebKitSerializedNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebKitSerializedNode::destroy(JSC::JSCell* cell)
{
    JSWebKitSerializedNode* thisObject = static_cast<JSWebKitSerializedNode*>(cell);
    thisObject->JSWebKitSerializedNode::~JSWebKitSerializedNode();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebKitSerializedNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebKitSerializedNodePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebKitSerializedNode::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSWebKitSerializedNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebKitSerializedNode, UseCustomHeapCellType::No>(vm, "JSWebKitSerializedNode"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebKitSerializedNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebKitSerializedNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebKitSerializedNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebKitSerializedNode = std::forward<decltype(space)>(space); }
    );
}

void JSWebKitSerializedNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebKitSerializedNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebKitSerializedNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebKitSerializedNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitSerializedNode = static_cast<JSWebKitSerializedNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebKitSerializedNode->protectedWrapped().ptr(), jsWebKitSerializedNode);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebKitSerializedNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20WebKitSerializedNodeE[]; }
#endif
template<std::same_as<WebKitSerializedNode> T>
static inline void verifyVTable(WebKitSerializedNode* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebKitSerializedNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20WebKitSerializedNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebKitSerializedNode has subclasses. If WebKitSerializedNode has subclasses that get passed
        // to toJS() we currently require WebKitSerializedNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebKitSerializedNode>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebKitSerializedNode>(impl.ptr());
#endif
    return createWrapper<WebKitSerializedNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebKitSerializedNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebKitSerializedNode* JSWebKitSerializedNode::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitSerializedNode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
