/* monitor.c generated by valac 0.56.17, the Vala compiler
 * generated from monitor.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a C implementation (© 2010 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist.h"
#include "zeitgeist-datamodel.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_MONITOR_0_PROPERTY,
	ZEITGEIST_MONITOR_TIME_RANGE_PROPERTY,
	ZEITGEIST_MONITOR_EVENT_TEMPLATES_PROPERTY,
	ZEITGEIST_MONITOR_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_monitor_properties[ZEITGEIST_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistMonitorNotifyInsertData ZeitgeistMonitorNotifyInsertData;
typedef struct _ZeitgeistMonitorNotifyDeleteData ZeitgeistMonitorNotifyDeleteData;
enum  {
	ZEITGEIST_MONITOR_EVENTS_INSERTED_SIGNAL,
	ZEITGEIST_MONITOR_EVENTS_DELETED_SIGNAL,
	ZEITGEIST_MONITOR_NUM_SIGNALS
};
static guint zeitgeist_monitor_signals[ZEITGEIST_MONITOR_NUM_SIGNALS] = {0};

struct _ZeitgeistMonitorPrivate {
	ZeitgeistTimeRange* _time_range;
	GPtrArray* _event_templates;
	char* monitor_path;
};

struct _ZeitgeistMonitorNotifyInsertData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistMonitor* self;
	GVariant* time_range;
	GVariant* events;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	ZeitgeistSimpleResultSet* result_set;
	ZeitgeistSimpleResultSet* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	ZeitgeistSimpleResultSet* _tmp5_;
	GError* err;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _ZeitgeistMonitorNotifyDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistMonitor* self;
	GVariant* time_range;
	guint32* event_ids;
	gint event_ids_length1;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GError* err;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

static gint ZeitgeistMonitor_private_offset;
static gpointer zeitgeist_monitor_parent_class = NULL;
static gint zeitgeist_monitor_monitor_counter;
static gint zeitgeist_monitor_monitor_counter = 0;
static ZeitgeistRemoteMonitorIface * zeitgeist_monitor_zeitgeist_remote_monitor_parent_iface = NULL;

static void zeitgeist_monitor_real_notify_insert_data_free (gpointer _data);
static void zeitgeist_monitor_real_notify_insert (ZeitgeistRemoteMonitor* base,
                                           GVariant* time_range,
                                           GVariant* events,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean zeitgeist_monitor_real_notify_insert_co (ZeitgeistMonitorNotifyInsertData* _data_);
static void zeitgeist_monitor_real_notify_delete_data_free (gpointer _data);
static void zeitgeist_monitor_real_notify_delete (ZeitgeistRemoteMonitor* base,
                                           GVariant* time_range,
                                           guint32* event_ids,
                                           gint event_ids_length1,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean zeitgeist_monitor_real_notify_delete_co (ZeitgeistMonitorNotifyDeleteData* _data_);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static void zeitgeist_monitor_finalize (GObject * obj);
static GType zeitgeist_monitor_get_type_once (void);
static void _vala_zeitgeist_monitor_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_zeitgeist_monitor_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
zeitgeist_monitor_get_instance_private (ZeitgeistMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistMonitor_private_offset);
}

/**
     * zeitgeist_monitor_new
     *
     * Create a new monitor. Before you can receive signals from the monitor you
     * need to install it in the running Zeitgeist daemon by calling
     * zeitgeist_log_install_monitor().
     *
     * @param time_range The monitor will only listen for events with
     *     timestamps within this time range. Note that it is legal for
     *     applications to insert events that are "in the past".
     * @param event_templates A #GPtrArray of #ZeitgeistEvent<!-- -->s.
     *     Only listen for events that match any of these templates.
     *
     * @return A reference to a newly allocated monitor
     */
ZeitgeistMonitor*
zeitgeist_monitor_construct (GType object_type,
                             ZeitgeistTimeRange* time_range,
                             GPtrArray* event_templates)
{
	ZeitgeistMonitor * self = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	self = (ZeitgeistMonitor*) g_object_new (object_type, NULL);
	zeitgeist_monitor_set_time_range (self, time_range);
	zeitgeist_monitor_set_event_templates (self, event_templates);
	_tmp0_ = zeitgeist_monitor_monitor_counter;
	zeitgeist_monitor_monitor_counter = _tmp0_ + 1;
	_tmp1_ = g_strdup_printf ("/org/gnome/zeitgeist/monitor/%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->monitor_path);
	self->priv->monitor_path = _tmp3_;
	_g_free0 (_tmp2_);
	_g_ptr_array_unref0 (event_templates);
	return self;
}

ZeitgeistMonitor*
zeitgeist_monitor_new (ZeitgeistTimeRange* time_range,
                       GPtrArray* event_templates)
{
	return zeitgeist_monitor_construct (ZEITGEIST_TYPE_MONITOR, time_range, event_templates);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

GPtrArray*
zeitgeist_monitor_get_templates (ZeitgeistMonitor* self)
{
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event_templates;
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

char*
zeitgeist_monitor_get_path (ZeitgeistMonitor* self)
{
	const char* _tmp0_;
	char* _tmp1_;
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->monitor_path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
zeitgeist_monitor_real_notify_insert_data_free (gpointer _data)
{
	ZeitgeistMonitorNotifyInsertData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->events);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistMonitorNotifyInsertData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
zeitgeist_monitor_real_notify_insert (ZeitgeistRemoteMonitor* base,
                                      GVariant* time_range,
                                      GVariant* events,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ZeitgeistMonitor * self;
	ZeitgeistMonitorNotifyInsertData* _data_;
	ZeitgeistMonitor* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	self = (ZeitgeistMonitor*) base;
	_data_ = g_slice_new0 (ZeitgeistMonitorNotifyInsertData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_monitor_real_notify_insert_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_variant_ref0 (events);
	_g_variant_unref0 (_data_->events);
	_data_->events = _tmp2_;
	zeitgeist_monitor_real_notify_insert_co (_data_);
}

static void
zeitgeist_monitor_notify_insert_finish (ZeitgeistRemoteMonitor* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	ZeitgeistMonitorNotifyInsertData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
zeitgeist_monitor_real_notify_insert_co (ZeitgeistMonitorNotifyInsertData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = zeitgeist_events_from_variant (_data_->events, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				goto __catch0_zeitgeist_data_model_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = zeitgeist_simple_result_set_new (_data_->_tmp0_);
		_data_->result_set = _data_->_tmp2_;
		_data_->_tmp4_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->result_set);
			_g_ptr_array_unref0 (_data_->_tmp0_);
			if (_data_->_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				goto __catch0_zeitgeist_data_model_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = _data_->result_set;
		g_signal_emit (_data_->self, zeitgeist_monitor_signals[ZEITGEIST_MONITOR_EVENTS_INSERTED_SIGNAL], 0, _data_->_tmp3_, (ZeitgeistResultSet*) _data_->_tmp5_);
		_g_object_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->result_set);
		_g_ptr_array_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_zeitgeist_data_model_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->err;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("monitor.vala:123: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_monitor_real_notify_delete_data_free (gpointer _data)
{
	ZeitgeistMonitorNotifyDeleteData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistMonitorNotifyDeleteData, _data_);
}

static void
zeitgeist_monitor_real_notify_delete (ZeitgeistRemoteMonitor* base,
                                      GVariant* time_range,
                                      guint32* event_ids,
                                      gint event_ids_length1,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ZeitgeistMonitor * self;
	ZeitgeistMonitorNotifyDeleteData* _data_;
	ZeitgeistMonitor* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (time_range != NULL);
	self = (ZeitgeistMonitor*) base;
	_data_ = g_slice_new0 (ZeitgeistMonitorNotifyDeleteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_monitor_real_notify_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_data_->event_ids = event_ids;
	_data_->event_ids_length1 = event_ids_length1;
	zeitgeist_monitor_real_notify_delete_co (_data_);
}

static void
zeitgeist_monitor_notify_delete_finish (ZeitgeistRemoteMonitor* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	ZeitgeistMonitorNotifyDeleteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
zeitgeist_monitor_real_notify_delete_co (ZeitgeistMonitorNotifyDeleteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				goto __catch0_zeitgeist_data_model_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		g_signal_emit (_data_->self, zeitgeist_monitor_signals[ZEITGEIST_MONITOR_EVENTS_DELETED_SIGNAL], 0, _data_->_tmp0_, _data_->event_ids, (gint) _data_->event_ids_length1);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_zeitgeist_data_model_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->err;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("monitor.vala:138: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ZeitgeistTimeRange*
zeitgeist_monitor_get_time_range (ZeitgeistMonitor* self)
{
	ZeitgeistTimeRange* result;
	ZeitgeistTimeRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_time_range;
	result = _tmp0_;
	return result;
}

void
zeitgeist_monitor_set_time_range (ZeitgeistMonitor* self,
                                  ZeitgeistTimeRange* value)
{
	ZeitgeistTimeRange* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_monitor_get_time_range (self);
	if (old_value != value) {
		ZeitgeistTimeRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_time_range);
		self->priv->_time_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_monitor_properties[ZEITGEIST_MONITOR_TIME_RANGE_PROPERTY]);
	}
}

GPtrArray*
zeitgeist_monitor_get_event_templates (ZeitgeistMonitor* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event_templates;
	result = _tmp0_;
	return result;
}

void
zeitgeist_monitor_set_event_templates (ZeitgeistMonitor* self,
                                       GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_monitor_get_event_templates (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_event_templates);
		self->priv->_event_templates = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_monitor_properties[ZEITGEIST_MONITOR_EVENT_TEMPLATES_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
zeitgeist_monitor_class_init (ZeitgeistMonitorClass * klass,
                              gpointer klass_data)
{
	zeitgeist_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_monitor_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_MONITOR_TIME_RANGE_PROPERTY, zeitgeist_monitor_properties[ZEITGEIST_MONITOR_TIME_RANGE_PROPERTY] = g_param_spec_object ("time-range", "time-range", "time-range", ZEITGEIST_TYPE_TIME_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_MONITOR_EVENT_TEMPLATES_PROPERTY, zeitgeist_monitor_properties[ZEITGEIST_MONITOR_EVENT_TEMPLATES_PROPERTY] = g_param_spec_boxed ("event-templates", "event-templates", "event-templates", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * ZeitgeistMonitor::events-inserted:
	     *
	     * Emitted when events matching the event templates and with timestamps
	     * within the time range of the monitor has been inserted into the log.
	     *
	     * @param time_range A #ZeitgeistTimeRange that specifies the minimum and
	     *     maximum of the timestamps in @events
	     * @param events A #ZeitgeistResultSet holding the "ZeitgeistEvent"s that
	     *     have been inserted into the log
	     */
	zeitgeist_monitor_signals[ZEITGEIST_MONITOR_EVENTS_INSERTED_SIGNAL] = g_signal_new ("events-inserted", ZEITGEIST_TYPE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, ZEITGEIST_TYPE_TIME_RANGE, ZEITGEIST_TYPE_RESULT_SET);
	/**
	     * ZeitgeistMonitor::events-deleted:
	     *
	     * Emitted when events with timestamps within the time range of this
	     * monitor have been deleted from the log. Note that the deleted events
	     * may not match the event templates for the monitor.
	     *
	     * @param time_range A #ZeitgeistTimeRange that specifies the minimum and
	     *     maximum timestamps of the deleted events
	     * @param event_ids A #GArray of #guint32<!-- -->s holding the IDs of the
	     *     deleted events
	     */
	zeitgeist_monitor_signals[ZEITGEIST_MONITOR_EVENTS_DELETED_SIGNAL] = g_signal_new ("events-deleted", ZEITGEIST_TYPE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT, G_TYPE_NONE, 3, ZEITGEIST_TYPE_TIME_RANGE, G_TYPE_POINTER, G_TYPE_INT);
}

static void
zeitgeist_monitor_zeitgeist_remote_monitor_interface_init (ZeitgeistRemoteMonitorIface * iface,
                                                           gpointer iface_data)
{
	zeitgeist_monitor_zeitgeist_remote_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->notify_insert = (void (*) (ZeitgeistRemoteMonitor*, GVariant*, GVariant*, GAsyncReadyCallback, gpointer)) zeitgeist_monitor_real_notify_insert;
	iface->notify_insert_finish = (void (*) (ZeitgeistRemoteMonitor*, GAsyncResult*, GError**)) zeitgeist_monitor_notify_insert_finish;
	iface->notify_delete = (void (*) (ZeitgeistRemoteMonitor*, GVariant*, guint32*, gint, GAsyncReadyCallback, gpointer)) zeitgeist_monitor_real_notify_delete;
	iface->notify_delete_finish = (void (*) (ZeitgeistRemoteMonitor*, GAsyncResult*, GError**)) zeitgeist_monitor_notify_delete_finish;
}

static void
zeitgeist_monitor_instance_init (ZeitgeistMonitor * self,
                                 gpointer klass)
{
	self->priv = zeitgeist_monitor_get_instance_private (self);
}

static void
zeitgeist_monitor_finalize (GObject * obj)
{
	ZeitgeistMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor);
	_g_object_unref0 (self->priv->_time_range);
	_g_ptr_array_unref0 (self->priv->_event_templates);
	_g_free0 (self->priv->monitor_path);
	G_OBJECT_CLASS (zeitgeist_monitor_parent_class)->finalize (obj);
}

/**
 * Listens for updates to the Zeitgeist event log
 *
 * A #Monitor listens for updates to the Zeitgeist event log
 * matching a given set of templates and with timestamps in some predefined
 * time range.
 *
 * A monitor must be installed into the running Zeitgeist daemon by calling
 * zeitgeist_log_install_monitor(). The monitor will not emit any of the
 * ::events-added or ::events-deleted signals before this.
 */
static GType
zeitgeist_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitor), 0, (GInstanceInitFunc) zeitgeist_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_monitor_info = { (GInterfaceInitFunc) zeitgeist_monitor_zeitgeist_remote_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType zeitgeist_monitor_type_id;
	zeitgeist_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistMonitor", &g_define_type_info, 0);
	g_type_add_interface_static (zeitgeist_monitor_type_id, ZEITGEIST_TYPE_REMOTE_MONITOR, &zeitgeist_remote_monitor_info);
	ZeitgeistMonitor_private_offset = g_type_add_instance_private (zeitgeist_monitor_type_id, sizeof (ZeitgeistMonitorPrivate));
	return zeitgeist_monitor_type_id;
}

GType
zeitgeist_monitor_get_type (void)
{
	static volatile gsize zeitgeist_monitor_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_monitor_type_id__once)) {
		GType zeitgeist_monitor_type_id;
		zeitgeist_monitor_type_id = zeitgeist_monitor_get_type_once ();
		g_once_init_leave (&zeitgeist_monitor_type_id__once, zeitgeist_monitor_type_id);
	}
	return zeitgeist_monitor_type_id__once;
}

static void
_vala_zeitgeist_monitor_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ZeitgeistMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor);
	switch (property_id) {
		case ZEITGEIST_MONITOR_TIME_RANGE_PROPERTY:
		g_value_set_object (value, zeitgeist_monitor_get_time_range (self));
		break;
		case ZEITGEIST_MONITOR_EVENT_TEMPLATES_PROPERTY:
		g_value_set_boxed (value, zeitgeist_monitor_get_event_templates (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_monitor_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ZeitgeistMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor);
	switch (property_id) {
		case ZEITGEIST_MONITOR_TIME_RANGE_PROPERTY:
		zeitgeist_monitor_set_time_range (self, g_value_get_object (value));
		break;
		case ZEITGEIST_MONITOR_EVENT_TEMPLATES_PROPERTY:
		zeitgeist_monitor_set_event_templates (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

