local result, l, i;
i:= Sqrt(-1);
result:= rec();
result.comment:=
"4b\"M20 as 4 x 4 matrices over Z[i].\n\
Absolutely irreducible representation.\n\
Schur Index 1.\n\
\n\
SEED:\n\
Nonzero v negated by x and x^(yxy) where <x,x^(yxy)> = S4.\n\
v has 4 x 40 = 160 images under G; <v> has 40 images under G.\n\
BASIS:\n\
All in v^G.\n\
\n\
Possible matrix entries for any element of the group:\n\
The 9 elements of {0,1,-1,i,-i,1+i,1-i,-1+i,-1-i} only.\n\
The possible norms are in {0,1,2} only.\n\
\n\
Average number of nonzero entries for any element of the group:\n\
11 + 1/5  (11.2; 70% exactly).\n\
\n\
Entry    Av/Mat  %Av/Mat\n\
   0      4.8     30\n\
   1      1.6     10\n\
  -1      1.6     10\n\
   i      1.6     10\n\
  -i      1.6     10\n\
 1+i      1.2      7.5\n\
 1-i      1.2      7.5\n\
-1+i      1.2      7.5\n\
-1-i      1.2      7.5\n\
Norm 0    4.8     30\n\
Norm 1    6.4     40\n\
Norm 2    4.8     30\n\
nonzero  11.2     70\n\
";
result.symmetricforms:= [];
result.antisymmetricforms:= [];
result.hermitianforms:= [];
result.centralizeralgebra:= [];
result.generators:= List( [ [
-1,0,0,0,
-1,i,-i+1,0,
-1,0,-i-1,1,
-1,0,-i,0]
,[
0,1,0,0,
0,0,1,0,
1,0,0,0,
0,0,0,1]
], l -> List( [ 0 .. 3 ],
i -> l{ [ i*4+1 .. (i+1)*4 ] } ) );


l:= [
2,i,-i,1,
-i,2,i,1,
i,-i,2,1,
1,1,1,2];
Add( result.hermitianforms, List( [ 0 .. 3 ],
i -> l{ [ i*4+1 .. (i+1)*4 ] } ) );

Add( result.centralizeralgebra, IdentityMat(4) );
return result;
